# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError, map_error
from azure.core.async_paging import AsyncItemPaged, AsyncList
from ... import models
import uuid


class AzureAppConfigurationOperationsMixin:

    def get_keys(
            self, name=None, after=None, accept_datetime=None, *, cls=None, **kwargs):
        """Gets a list of keys.

        :param name: A filter for the name of the returned keys.
        :type name: str
        :param after: Instructs the server to return elements that appear
         after the element referred to by the specified token.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state
         of the resource at the specified time.
        :type accept_datetime: str
        :return: An iterator like instance of Key
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~appconfiguration.models.Key]
        :raises:
         :class:`ErrorException<appconfiguration.models.ErrorException>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.get_keys.metadata['url']
                if name is not None:
                    query_parameters['name'] = self._serialize.query("name", name, 'str')
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if after is not None:
                    query_parameters['After'] = self._serialize.query("after", after, 'str')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/vnd.microsoft.appconfig.keyset+json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if self._config.sync_token is not None:
                header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
            if accept_datetime is not None:
                header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('KeyListResult', response)
            list_of_elem = deserialized.items
            if cls:
               list_of_elem = cls(list_of_elem)
            return deserialized.next_link, AsyncList(list_of_elem)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise models.ErrorException(response, self._deserialize)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    get_keys.metadata = {'url': '/keys'}

    async def check_keys(self, name=None, after=None, accept_datetime=None, *, cls=None, **kwargs):
        """Requests the headers and status of the given resource.

        :param name: A filter for the name of the returned keys.
        :type name: str
        :param after: Instructs the server to return elements that appear
         after the element referred to by the specified token.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state
         of the resource at the specified time.
        :type accept_datetime: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises: :class:`HttpResponseError<azure.core.HttpResponseError>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.check_keys.metadata['url']

        # Construct parameters
        query_parameters = {}
        if name is not None:
            query_parameters['name'] = self._serialize.query("name", name, 'str')
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if after is not None:
            query_parameters['After'] = self._serialize.query("after", after, 'str')

        # Construct headers
        header_parameters = {}
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if accept_datetime is not None:
            header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')

        # Construct and send request
        request = self._client.head(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            response_headers = {
                'Sync-Token': self._deserialize('str', response.headers.get('Sync-Token')),
            }
            return cls(response, None, response_headers)
    check_keys.metadata = {'url': '/keys'}

    def get_key_values(
            self, key=None, label=None, after=None, accept_datetime=None, select=None, *, cls=None, **kwargs):
        """Gets a list of key-values.

        :param key: A filter used to match keys.
        :type key: str
        :param label: A filter used to match labels
        :type label: str
        :param after: Instructs the server to return elements that appear
         after the element referred to by the specified token.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state
         of the resource at the specified time.
        :type accept_datetime: str
        :param select: Used to select what fields are present in the returned
         resource(s).
        :type select: list[str]
        :return: An iterator like instance of KeyValue
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~appconfiguration.models.KeyValue]
        :raises:
         :class:`ErrorException<appconfiguration.models.ErrorException>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.get_key_values.metadata['url']
                if key is not None:
                    query_parameters['key'] = self._serialize.query("key", key, 'str')
                if label is not None:
                    query_parameters['label'] = self._serialize.query("label", label, 'str')
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if after is not None:
                    query_parameters['After'] = self._serialize.query("after", after, 'str')
                if select is not None:
                    query_parameters['$Select'] = self._serialize.query("select", select, '[str]', div=',')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/vnd.microsoft.appconfig.kvset+json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if self._config.sync_token is not None:
                header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
            if accept_datetime is not None:
                header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('KeyValueListResult', response)
            list_of_elem = deserialized.items
            if cls:
               list_of_elem = cls(list_of_elem)
            return deserialized.next_link, AsyncList(list_of_elem)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise models.ErrorException(response, self._deserialize)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    get_key_values.metadata = {'url': '/kv'}

    async def check_key_values(self, key=None, label=None, after=None, accept_datetime=None, select=None, *, cls=None, **kwargs):
        """Requests the headers and status of the given resource.

        :param key: A filter used to match keys.
        :type key: str
        :param label: A filter used to match labels
        :type label: str
        :param after: Instructs the server to return elements that appear
         after the element referred to by the specified token.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state
         of the resource at the specified time.
        :type accept_datetime: str
        :param select: Used to select what fields are present in the returned
         resource(s).
        :type select: list[str]
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises: :class:`HttpResponseError<azure.core.HttpResponseError>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.check_key_values.metadata['url']

        # Construct parameters
        query_parameters = {}
        if key is not None:
            query_parameters['key'] = self._serialize.query("key", key, 'str')
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if after is not None:
            query_parameters['After'] = self._serialize.query("after", after, 'str')
        if select is not None:
            query_parameters['$Select'] = self._serialize.query("select", select, '[str]', div=',')

        # Construct headers
        header_parameters = {}
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if accept_datetime is not None:
            header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')

        # Construct and send request
        request = self._client.head(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            response_headers = {
                'Sync-Token': self._deserialize('str', response.headers.get('Sync-Token')),
            }
            return cls(response, None, response_headers)
    check_key_values.metadata = {'url': '/kv'}

    async def get_key_value(self, key, label=None, accept_datetime=None, if_match=None, if_none_match=None, select=None, *, cls=None, **kwargs):
        """Gets a single key-value.

        :param key: The key of the key-value to retrieve.
        :type key: str
        :param label: The label of the key-value to retrieve.
        :type label: str
        :param accept_datetime: Requests the server to respond with the state
         of the resource at the specified time.
        :type accept_datetime: str
        :param if_match: Used to perform an operation only if the targeted
         resource's etag matches the value provided.
        :type if_match: str
        :param if_none_match: Used to perform an operation only if the
         targeted resource's etag does not match the value provided.
        :type if_none_match: str
        :param select: Used to select what fields are present in the returned
         resource(s).
        :type select: list[str]
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: KeyValue or the result of cls(response)
        :rtype: ~appconfiguration.models.KeyValue
        :raises:
         :class:`ErrorException<appconfiguration.models.ErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.get_key_value.metadata['url']
        path_format_arguments = {
            'key': self._serialize.url("key", key, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if select is not None:
            query_parameters['$Select'] = self._serialize.query("select", select, '[str]', div=',')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/vnd.microsoft.appconfig.kv+json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if accept_datetime is not None:
            header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.ErrorException(response, self._deserialize)

        header_dict = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('KeyValue', response)
            header_dict = {
                'Sync-Token': self._deserialize('str', response.headers.get('Sync-Token')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('str', response.headers.get('Last-Modified')),
            }

        if cls:
            return cls(response, deserialized, header_dict)

        return deserialized
    get_key_value.metadata = {'url': '/kv/{key}'}

    async def put_key_value(self, key, label=None, entity=None, if_match=None, if_none_match=None, *, cls=None, **kwargs):
        """Creates a key-value.

        :param key: The key of the key-value to create.
        :type key: str
        :param label: The label of the key-value to create.
        :type label: str
        :param entity: The key-value to create.
        :type entity: ~appconfiguration.models.KeyValue
        :param if_match: Used to perform an operation only if the targeted
         resource's etag matches the value provided.
        :type if_match: str
        :param if_none_match: Used to perform an operation only if the
         targeted resource's etag does not match the value provided.
        :type if_none_match: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: KeyValue or the result of cls(response)
        :rtype: ~appconfiguration.models.KeyValue
        :raises:
         :class:`ErrorException<appconfiguration.models.ErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.put_key_value.metadata['url']
        path_format_arguments = {
            'key': self._serialize.url("key", key, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/vnd.microsoft.appconfig.kv+json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')

        # Construct body
        if entity is not None:
            body_content = self._serialize.body(entity, 'KeyValue')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.ErrorException(response, self._deserialize)

        header_dict = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('KeyValue', response)
            header_dict = {
                'Sync-Token': self._deserialize('str', response.headers.get('Sync-Token')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
            }

        if cls:
            return cls(response, deserialized, header_dict)

        return deserialized
    put_key_value.metadata = {'url': '/kv/{key}'}

    async def delete_key_value(self, key, label=None, if_match=None, *, cls=None, **kwargs):
        """Deletes a key-value.

        :param key: The key of the key-value to delete.
        :type key: str
        :param label: The label of the key-value to delete.
        :type label: str
        :param if_match: Used to perform an operation only if the targeted
         resource's etag matches the value provided.
        :type if_match: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: KeyValue or the result of cls(response)
        :rtype: ~appconfiguration.models.KeyValue
        :raises:
         :class:`ErrorException<appconfiguration.models.ErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.delete_key_value.metadata['url']
        path_format_arguments = {
            'key': self._serialize.url("key", key, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/vnd.microsoft.appconfig.kv+json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.ErrorException(response, self._deserialize)

        header_dict = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('KeyValue', response)
            header_dict = {
                'Sync-Token': self._deserialize('str', response.headers.get('Sync-Token')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
            }

        if cls:
            return cls(response, deserialized, header_dict)

        return deserialized
    delete_key_value.metadata = {'url': '/kv/{key}'}

    async def check_key_value(self, key, label=None, accept_datetime=None, if_match=None, if_none_match=None, select=None, *, cls=None, **kwargs):
        """Requests the headers and status of the given resource.

        :param key: The key of the key-value to retrieve.
        :type key: str
        :param label: The label of the key-value to retrieve.
        :type label: str
        :param accept_datetime: Requests the server to respond with the state
         of the resource at the specified time.
        :type accept_datetime: str
        :param if_match: Used to perform an operation only if the targeted
         resource's etag matches the value provided.
        :type if_match: str
        :param if_none_match: Used to perform an operation only if the
         targeted resource's etag does not match the value provided.
        :type if_none_match: str
        :param select: Used to select what fields are present in the returned
         resource(s).
        :type select: list[str]
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises: :class:`HttpResponseError<azure.core.HttpResponseError>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.check_key_value.metadata['url']
        path_format_arguments = {
            'key': self._serialize.url("key", key, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if select is not None:
            query_parameters['$Select'] = self._serialize.query("select", select, '[str]', div=',')

        # Construct headers
        header_parameters = {}
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if accept_datetime is not None:
            header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')

        # Construct and send request
        request = self._client.head(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            response_headers = {
                'Sync-Token': self._deserialize('str', response.headers.get('Sync-Token')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('str', response.headers.get('Last-Modified')),
            }
            return cls(response, None, response_headers)
    check_key_value.metadata = {'url': '/kv/{key}'}

    def get_labels(
            self, name=None, after=None, accept_datetime=None, select=None, *, cls=None, **kwargs):
        """Gets a list of labels.

        :param name: A filter for the name of the returned labels.
        :type name: str
        :param after: Instructs the server to return elements that appear
         after the element referred to by the specified token.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state
         of the resource at the specified time.
        :type accept_datetime: str
        :param select: Used to select what fields are present in the returned
         resource(s).
        :type select: list[str]
        :return: An iterator like instance of Label
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~appconfiguration.models.Label]
        :raises:
         :class:`ErrorException<appconfiguration.models.ErrorException>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.get_labels.metadata['url']
                if name is not None:
                    query_parameters['name'] = self._serialize.query("name", name, 'str')
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if after is not None:
                    query_parameters['After'] = self._serialize.query("after", after, 'str')
                if select is not None:
                    query_parameters['$Select'] = self._serialize.query("select", select, '[str]', div=',')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/vnd.microsoft.appconfig.labelset+json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if self._config.sync_token is not None:
                header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
            if accept_datetime is not None:
                header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('LabelListResult', response)
            list_of_elem = deserialized.items
            if cls:
               list_of_elem = cls(list_of_elem)
            return deserialized.next_link, AsyncList(list_of_elem)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise models.ErrorException(response, self._deserialize)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    get_labels.metadata = {'url': '/labels'}

    async def check_labels(self, name=None, after=None, accept_datetime=None, select=None, *, cls=None, **kwargs):
        """Requests the headers and status of the given resource.

        :param name: A filter for the name of the returned labels.
        :type name: str
        :param after: Instructs the server to return elements that appear
         after the element referred to by the specified token.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state
         of the resource at the specified time.
        :type accept_datetime: str
        :param select: Used to select what fields are present in the returned
         resource(s).
        :type select: list[str]
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises: :class:`HttpResponseError<azure.core.HttpResponseError>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.check_labels.metadata['url']

        # Construct parameters
        query_parameters = {}
        if name is not None:
            query_parameters['name'] = self._serialize.query("name", name, 'str')
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if after is not None:
            query_parameters['After'] = self._serialize.query("after", after, 'str')
        if select is not None:
            query_parameters['$Select'] = self._serialize.query("select", select, '[str]', div=',')

        # Construct headers
        header_parameters = {}
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if accept_datetime is not None:
            header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')

        # Construct and send request
        request = self._client.head(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            response_headers = {
                'Sync-Token': self._deserialize('str', response.headers.get('Sync-Token')),
            }
            return cls(response, None, response_headers)
    check_labels.metadata = {'url': '/labels'}

    async def put_lock(self, key, label=None, if_match=None, if_none_match=None, *, cls=None, **kwargs):
        """Locks a key-value.

        :param key: The key of the key-value to lock.
        :type key: str
        :param label: The label, if any, of the key-value to lock.
        :type label: str
        :param if_match: Used to perform an operation only if the targeted
         resource's etag matches the value provided.
        :type if_match: str
        :param if_none_match: Used to perform an operation only if the
         targeted resource's etag does not match the value provided.
        :type if_none_match: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: KeyValue or the result of cls(response)
        :rtype: ~appconfiguration.models.KeyValue
        :raises:
         :class:`ErrorException<appconfiguration.models.ErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.put_lock.metadata['url']
        path_format_arguments = {
            'key': self._serialize.url("key", key, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/vnd.microsoft.appconfig.kv+json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.ErrorException(response, self._deserialize)

        header_dict = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('KeyValue', response)
            header_dict = {
                'Sync-Token': self._deserialize('str', response.headers.get('Sync-Token')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
            }

        if cls:
            return cls(response, deserialized, header_dict)

        return deserialized
    put_lock.metadata = {'url': '/locks/{key}'}

    async def delete_lock(self, key, label=None, if_match=None, if_none_match=None, *, cls=None, **kwargs):
        """Unlocks a key-value.

        :param key: The key of the key-value to unlock.
        :type key: str
        :param label: The label, if any, of the key-value to unlock.
        :type label: str
        :param if_match: Used to perform an operation only if the targeted
         resource's etag matches the value provided.
        :type if_match: str
        :param if_none_match: Used to perform an operation only if the
         targeted resource's etag does not match the value provided.
        :type if_none_match: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: KeyValue or the result of cls(response)
        :rtype: ~appconfiguration.models.KeyValue
        :raises:
         :class:`ErrorException<appconfiguration.models.ErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.delete_lock.metadata['url']
        path_format_arguments = {
            'key': self._serialize.url("key", key, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/vnd.microsoft.appconfig.kv+json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.ErrorException(response, self._deserialize)

        header_dict = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('KeyValue', response)
            header_dict = {
                'Sync-Token': self._deserialize('str', response.headers.get('Sync-Token')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
            }

        if cls:
            return cls(response, deserialized, header_dict)

        return deserialized
    delete_lock.metadata = {'url': '/locks/{key}'}

    def get_revisions(
            self, key=None, label=None, after=None, accept_datetime=None, select=None, *, cls=None, **kwargs):
        """Gets a list of key-value revisions.

        :param key: A filter used to match keys.
        :type key: str
        :param label: A filter used to match labels
        :type label: str
        :param after: Instructs the server to return elements that appear
         after the element referred to by the specified token.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state
         of the resource at the specified time.
        :type accept_datetime: str
        :param select: Used to select what fields are present in the returned
         resource(s).
        :type select: list[str]
        :return: An iterator like instance of KeyValue
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~appconfiguration.models.KeyValue]
        :raises:
         :class:`ErrorException<appconfiguration.models.ErrorException>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.get_revisions.metadata['url']
                if key is not None:
                    query_parameters['key'] = self._serialize.query("key", key, 'str')
                if label is not None:
                    query_parameters['label'] = self._serialize.query("label", label, 'str')
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if after is not None:
                    query_parameters['After'] = self._serialize.query("after", after, 'str')
                if select is not None:
                    query_parameters['$Select'] = self._serialize.query("select", select, '[str]', div=',')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/vnd.microsoft.appconfig.kvset+json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if self._config.sync_token is not None:
                header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
            if accept_datetime is not None:
                header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('KeyValueListResult', response)
            list_of_elem = deserialized.items
            if cls:
               list_of_elem = cls(list_of_elem)
            return deserialized.next_link, AsyncList(list_of_elem)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise models.ErrorException(response, self._deserialize)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    get_revisions.metadata = {'url': '/revisions'}

    async def check_revisions(self, key=None, label=None, after=None, accept_datetime=None, select=None, *, cls=None, **kwargs):
        """Requests the headers and status of the given resource.

        :param key: A filter used to match keys.
        :type key: str
        :param label: A filter used to match labels
        :type label: str
        :param after: Instructs the server to return elements that appear
         after the element referred to by the specified token.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state
         of the resource at the specified time.
        :type accept_datetime: str
        :param select: Used to select what fields are present in the returned
         resource(s).
        :type select: list[str]
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises: :class:`HttpResponseError<azure.core.HttpResponseError>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.check_revisions.metadata['url']

        # Construct parameters
        query_parameters = {}
        if key is not None:
            query_parameters['key'] = self._serialize.query("key", key, 'str')
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if after is not None:
            query_parameters['After'] = self._serialize.query("after", after, 'str')
        if select is not None:
            query_parameters['$Select'] = self._serialize.query("select", select, '[str]', div=',')

        # Construct headers
        header_parameters = {}
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if accept_datetime is not None:
            header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')

        # Construct and send request
        request = self._client.head(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            response_headers = {
                'Sync-Token': self._deserialize('str', response.headers.get('Sync-Token')),
            }
            return cls(response, None, response_headers)
    check_revisions.metadata = {'url': '/revisions'}
