# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._network_management_client_enums import *


class AddressSpace(msrest.serialization.Model):
    """AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.

    :param address_prefixes: A list of address blocks reserved for this virtual network in CIDR
     notation.
    :type address_prefixes: list[str]
    """

    _attribute_map = {
        'address_prefixes': {'key': 'addressPrefixes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        address_prefixes: Optional[List[str]] = None,
        **kwargs
    ):
        super(AddressSpace, self).__init__(**kwargs)
        self.address_prefixes = address_prefixes


class Resource(msrest.serialization.Model):
    """Common resource representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ApplicationGateway(Resource):
    """Application gateway resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param sku: SKU of the application gateway resource.
    :type sku: ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewaySku
    :param ssl_policy: SSL policy of the application gateway resource.
    :type ssl_policy: ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewaySslPolicy
    :ivar operational_state: Operational state of the application gateway resource. Possible values
     include: "Stopped", "Starting", "Running", "Stopping".
    :vartype operational_state: str or
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayOperationalState
    :param gateway_ip_configurations: Subnets of application the gateway resource.
    :type gateway_ip_configurations:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayIPConfiguration]
    :param authentication_certificates: Authentication certificates of the application gateway
     resource.
    :type authentication_certificates:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayAuthenticationCertificate]
    :param ssl_certificates: SSL certificates of the application gateway resource.
    :type ssl_certificates:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewaySslCertificate]
    :param frontend_ip_configurations: Frontend IP addresses of the application gateway resource.
    :type frontend_ip_configurations:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayFrontendIPConfiguration]
    :param frontend_ports: Frontend ports of the application gateway resource.
    :type frontend_ports:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayFrontendPort]
    :param probes: Probes of the application gateway resource.
    :type probes: list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayProbe]
    :param backend_address_pools: Backend address pool of the application gateway resource.
    :type backend_address_pools:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayBackendAddressPool]
    :param backend_http_settings_collection: Backend http settings of the application gateway
     resource.
    :type backend_http_settings_collection:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayBackendHttpSettings]
    :param http_listeners: Http listeners of the application gateway resource.
    :type http_listeners:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayHttpListener]
    :param url_path_maps: URL path map of the application gateway resource.
    :type url_path_maps: list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayUrlPathMap]
    :param request_routing_rules: Request routing rules of the application gateway resource.
    :type request_routing_rules:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayRequestRoutingRule]
    :param redirect_configurations: Redirect configurations of the application gateway resource.
    :type redirect_configurations:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayRedirectConfiguration]
    :param web_application_firewall_configuration: Web application firewall configuration.
    :type web_application_firewall_configuration:
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayWebApplicationFirewallConfiguration
    :param enable_http2: Whether HTTP2 is enabled on the application gateway resource.
    :type enable_http2: bool
    :param resource_guid: Resource GUID property of the application gateway resource.
    :type resource_guid: str
    :param provisioning_state: Provisioning state of the application gateway resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'operational_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'ApplicationGatewaySku'},
        'ssl_policy': {'key': 'properties.sslPolicy', 'type': 'ApplicationGatewaySslPolicy'},
        'operational_state': {'key': 'properties.operationalState', 'type': 'str'},
        'gateway_ip_configurations': {'key': 'properties.gatewayIPConfigurations', 'type': '[ApplicationGatewayIPConfiguration]'},
        'authentication_certificates': {'key': 'properties.authenticationCertificates', 'type': '[ApplicationGatewayAuthenticationCertificate]'},
        'ssl_certificates': {'key': 'properties.sslCertificates', 'type': '[ApplicationGatewaySslCertificate]'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[ApplicationGatewayFrontendIPConfiguration]'},
        'frontend_ports': {'key': 'properties.frontendPorts', 'type': '[ApplicationGatewayFrontendPort]'},
        'probes': {'key': 'properties.probes', 'type': '[ApplicationGatewayProbe]'},
        'backend_address_pools': {'key': 'properties.backendAddressPools', 'type': '[ApplicationGatewayBackendAddressPool]'},
        'backend_http_settings_collection': {'key': 'properties.backendHttpSettingsCollection', 'type': '[ApplicationGatewayBackendHttpSettings]'},
        'http_listeners': {'key': 'properties.httpListeners', 'type': '[ApplicationGatewayHttpListener]'},
        'url_path_maps': {'key': 'properties.urlPathMaps', 'type': '[ApplicationGatewayUrlPathMap]'},
        'request_routing_rules': {'key': 'properties.requestRoutingRules', 'type': '[ApplicationGatewayRequestRoutingRule]'},
        'redirect_configurations': {'key': 'properties.redirectConfigurations', 'type': '[ApplicationGatewayRedirectConfiguration]'},
        'web_application_firewall_configuration': {'key': 'properties.webApplicationFirewallConfiguration', 'type': 'ApplicationGatewayWebApplicationFirewallConfiguration'},
        'enable_http2': {'key': 'properties.enableHttp2', 'type': 'bool'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        sku: Optional["ApplicationGatewaySku"] = None,
        ssl_policy: Optional["ApplicationGatewaySslPolicy"] = None,
        gateway_ip_configurations: Optional[List["ApplicationGatewayIPConfiguration"]] = None,
        authentication_certificates: Optional[List["ApplicationGatewayAuthenticationCertificate"]] = None,
        ssl_certificates: Optional[List["ApplicationGatewaySslCertificate"]] = None,
        frontend_ip_configurations: Optional[List["ApplicationGatewayFrontendIPConfiguration"]] = None,
        frontend_ports: Optional[List["ApplicationGatewayFrontendPort"]] = None,
        probes: Optional[List["ApplicationGatewayProbe"]] = None,
        backend_address_pools: Optional[List["ApplicationGatewayBackendAddressPool"]] = None,
        backend_http_settings_collection: Optional[List["ApplicationGatewayBackendHttpSettings"]] = None,
        http_listeners: Optional[List["ApplicationGatewayHttpListener"]] = None,
        url_path_maps: Optional[List["ApplicationGatewayUrlPathMap"]] = None,
        request_routing_rules: Optional[List["ApplicationGatewayRequestRoutingRule"]] = None,
        redirect_configurations: Optional[List["ApplicationGatewayRedirectConfiguration"]] = None,
        web_application_firewall_configuration: Optional["ApplicationGatewayWebApplicationFirewallConfiguration"] = None,
        enable_http2: Optional[bool] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGateway, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.sku = sku
        self.ssl_policy = ssl_policy
        self.operational_state = None
        self.gateway_ip_configurations = gateway_ip_configurations
        self.authentication_certificates = authentication_certificates
        self.ssl_certificates = ssl_certificates
        self.frontend_ip_configurations = frontend_ip_configurations
        self.frontend_ports = frontend_ports
        self.probes = probes
        self.backend_address_pools = backend_address_pools
        self.backend_http_settings_collection = backend_http_settings_collection
        self.http_listeners = http_listeners
        self.url_path_maps = url_path_maps
        self.request_routing_rules = request_routing_rules
        self.redirect_configurations = redirect_configurations
        self.web_application_firewall_configuration = web_application_firewall_configuration
        self.enable_http2 = enable_http2
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class SubResource(msrest.serialization.Model):
    """Reference to another subresource.

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = id


class ApplicationGatewayAuthenticationCertificate(SubResource):
    """Authentication certificates of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    :param data: Certificate public data.
    :type data: str
    :param provisioning_state: Provisioning state of the authentication certificate resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data': {'key': 'properties.data', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        data: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayAuthenticationCertificate, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.data = data
        self.provisioning_state = provisioning_state


class ApplicationGatewayAvailableSslOptions(Resource):
    """Response for ApplicationGatewayAvailableSslOptions API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param predefined_policies: List of available Ssl predefined policy.
    :type predefined_policies: list[~azure.mgmt.network.v2018_01_01.models.SubResource]
    :param default_policy: Name of the Ssl predefined policy applied by default to application
     gateway. Possible values include: "AppGwSslPolicy20150501", "AppGwSslPolicy20170401",
     "AppGwSslPolicy20170401S".
    :type default_policy: str or
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewaySslPolicyName
    :param available_cipher_suites: List of available Ssl cipher suites.
    :type available_cipher_suites: list[str or
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewaySslCipherSuite]
    :param available_protocols: List of available Ssl protocols.
    :type available_protocols: list[str or
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewaySslProtocol]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'predefined_policies': {'key': 'properties.predefinedPolicies', 'type': '[SubResource]'},
        'default_policy': {'key': 'properties.defaultPolicy', 'type': 'str'},
        'available_cipher_suites': {'key': 'properties.availableCipherSuites', 'type': '[str]'},
        'available_protocols': {'key': 'properties.availableProtocols', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        predefined_policies: Optional[List["SubResource"]] = None,
        default_policy: Optional[Union[str, "ApplicationGatewaySslPolicyName"]] = None,
        available_cipher_suites: Optional[List[Union[str, "ApplicationGatewaySslCipherSuite"]]] = None,
        available_protocols: Optional[List[Union[str, "ApplicationGatewaySslProtocol"]]] = None,
        **kwargs
    ):
        super(ApplicationGatewayAvailableSslOptions, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.predefined_policies = predefined_policies
        self.default_policy = default_policy
        self.available_cipher_suites = available_cipher_suites
        self.available_protocols = available_protocols


class ApplicationGatewayAvailableSslPredefinedPolicies(msrest.serialization.Model):
    """Response for ApplicationGatewayAvailableSslOptions API service call.

    :param value: List of available Ssl predefined policy.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewaySslPredefinedPolicy]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationGatewaySslPredefinedPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ApplicationGatewaySslPredefinedPolicy"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayAvailableSslPredefinedPolicies, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationGatewayAvailableWafRuleSetsResult(msrest.serialization.Model):
    """Response for ApplicationGatewayAvailableWafRuleSets API service call.

    :param value: The list of application gateway rule sets.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayFirewallRuleSet]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationGatewayFirewallRuleSet]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ApplicationGatewayFirewallRuleSet"]] = None,
        **kwargs
    ):
        super(ApplicationGatewayAvailableWafRuleSetsResult, self).__init__(**kwargs)
        self.value = value


class ApplicationGatewayBackendAddress(msrest.serialization.Model):
    """Backend address of an application gateway.

    :param fqdn: Fully qualified domain name (FQDN).
    :type fqdn: str
    :param ip_address: IP address.
    :type ip_address: str
    """

    _attribute_map = {
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        fqdn: Optional[str] = None,
        ip_address: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayBackendAddress, self).__init__(**kwargs)
        self.fqdn = fqdn
        self.ip_address = ip_address


class ApplicationGatewayBackendAddressPool(SubResource):
    """Backend Address Pool of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param name: Resource that is unique within a resource group. This name can be used to access
     the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    :param backend_ip_configurations: Collection of references to IPs defined in network
     interfaces.
    :type backend_ip_configurations:
     list[~azure.mgmt.network.v2018_01_01.models.NetworkInterfaceIPConfiguration]
    :param backend_addresses: Backend addresses.
    :type backend_addresses:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayBackendAddress]
    :param provisioning_state: Provisioning state of the backend address pool resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'backend_ip_configurations': {'key': 'properties.backendIPConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'backend_addresses': {'key': 'properties.backendAddresses', 'type': '[ApplicationGatewayBackendAddress]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        backend_ip_configurations: Optional[List["NetworkInterfaceIPConfiguration"]] = None,
        backend_addresses: Optional[List["ApplicationGatewayBackendAddress"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayBackendAddressPool, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.backend_ip_configurations = backend_ip_configurations
        self.backend_addresses = backend_addresses
        self.provisioning_state = provisioning_state


class ApplicationGatewayBackendHealth(msrest.serialization.Model):
    """List of ApplicationGatewayBackendHealthPool resources.

    :param backend_address_pools:
    :type backend_address_pools:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayBackendHealthPool]
    """

    _attribute_map = {
        'backend_address_pools': {'key': 'backendAddressPools', 'type': '[ApplicationGatewayBackendHealthPool]'},
    }

    def __init__(
        self,
        *,
        backend_address_pools: Optional[List["ApplicationGatewayBackendHealthPool"]] = None,
        **kwargs
    ):
        super(ApplicationGatewayBackendHealth, self).__init__(**kwargs)
        self.backend_address_pools = backend_address_pools


class ApplicationGatewayBackendHealthHttpSettings(msrest.serialization.Model):
    """Application gateway BackendHealthHttp settings.

    :param backend_http_settings: Reference of an ApplicationGatewayBackendHttpSettings resource.
    :type backend_http_settings:
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayBackendHttpSettings
    :param servers: List of ApplicationGatewayBackendHealthServer resources.
    :type servers:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayBackendHealthServer]
    """

    _attribute_map = {
        'backend_http_settings': {'key': 'backendHttpSettings', 'type': 'ApplicationGatewayBackendHttpSettings'},
        'servers': {'key': 'servers', 'type': '[ApplicationGatewayBackendHealthServer]'},
    }

    def __init__(
        self,
        *,
        backend_http_settings: Optional["ApplicationGatewayBackendHttpSettings"] = None,
        servers: Optional[List["ApplicationGatewayBackendHealthServer"]] = None,
        **kwargs
    ):
        super(ApplicationGatewayBackendHealthHttpSettings, self).__init__(**kwargs)
        self.backend_http_settings = backend_http_settings
        self.servers = servers


class ApplicationGatewayBackendHealthPool(msrest.serialization.Model):
    """Application gateway BackendHealth pool.

    :param backend_address_pool: Reference of an ApplicationGatewayBackendAddressPool resource.
    :type backend_address_pool:
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayBackendAddressPool
    :param backend_http_settings_collection: List of ApplicationGatewayBackendHealthHttpSettings
     resources.
    :type backend_http_settings_collection:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayBackendHealthHttpSettings]
    """

    _attribute_map = {
        'backend_address_pool': {'key': 'backendAddressPool', 'type': 'ApplicationGatewayBackendAddressPool'},
        'backend_http_settings_collection': {'key': 'backendHttpSettingsCollection', 'type': '[ApplicationGatewayBackendHealthHttpSettings]'},
    }

    def __init__(
        self,
        *,
        backend_address_pool: Optional["ApplicationGatewayBackendAddressPool"] = None,
        backend_http_settings_collection: Optional[List["ApplicationGatewayBackendHealthHttpSettings"]] = None,
        **kwargs
    ):
        super(ApplicationGatewayBackendHealthPool, self).__init__(**kwargs)
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings_collection = backend_http_settings_collection


class ApplicationGatewayBackendHealthServer(msrest.serialization.Model):
    """Application gateway backendhealth http settings.

    :param address: IP address or FQDN of backend server.
    :type address: str
    :param ip_configuration: Reference of IP configuration of backend server.
    :type ip_configuration: ~azure.mgmt.network.v2018_01_01.models.NetworkInterfaceIPConfiguration
    :param health: Health of backend server. Possible values include: "Unknown", "Up", "Down",
     "Partial", "Draining".
    :type health: str or
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayBackendHealthServerHealth
    """

    _attribute_map = {
        'address': {'key': 'address', 'type': 'str'},
        'ip_configuration': {'key': 'ipConfiguration', 'type': 'NetworkInterfaceIPConfiguration'},
        'health': {'key': 'health', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        address: Optional[str] = None,
        ip_configuration: Optional["NetworkInterfaceIPConfiguration"] = None,
        health: Optional[Union[str, "ApplicationGatewayBackendHealthServerHealth"]] = None,
        **kwargs
    ):
        super(ApplicationGatewayBackendHealthServer, self).__init__(**kwargs)
        self.address = address
        self.ip_configuration = ip_configuration
        self.health = health


class ApplicationGatewayBackendHttpSettings(SubResource):
    """Backend address pool settings of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    :param port: Port.
    :type port: int
    :param protocol: Protocol. Possible values include: "Http", "Https".
    :type protocol: str or ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayProtocol
    :param cookie_based_affinity: Cookie based affinity. Possible values include: "Enabled",
     "Disabled".
    :type cookie_based_affinity: str or
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayCookieBasedAffinity
    :param request_timeout: Request timeout in seconds. Application Gateway will fail the request
     if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400
     seconds.
    :type request_timeout: int
    :param probe: Probe resource of an application gateway.
    :type probe: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param authentication_certificates: Array of references to application gateway authentication
     certificates.
    :type authentication_certificates: list[~azure.mgmt.network.v2018_01_01.models.SubResource]
    :param connection_draining: Connection draining of the backend http settings resource.
    :type connection_draining:
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayConnectionDraining
    :param host_name: Host header to be sent to the backend servers.
    :type host_name: str
    :param pick_host_name_from_backend_address: Whether to pick host header should be picked from
     the host name of the backend server. Default value is false.
    :type pick_host_name_from_backend_address: bool
    :param affinity_cookie_name: Cookie name to use for the affinity cookie.
    :type affinity_cookie_name: str
    :param probe_enabled: Whether the probe is enabled. Default value is false.
    :type probe_enabled: bool
    :param path: Path which should be used as a prefix for all HTTP requests. Null means no path
     will be prefixed. Default value is null.
    :type path: str
    :param provisioning_state: Provisioning state of the backend http settings resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'cookie_based_affinity': {'key': 'properties.cookieBasedAffinity', 'type': 'str'},
        'request_timeout': {'key': 'properties.requestTimeout', 'type': 'int'},
        'probe': {'key': 'properties.probe', 'type': 'SubResource'},
        'authentication_certificates': {'key': 'properties.authenticationCertificates', 'type': '[SubResource]'},
        'connection_draining': {'key': 'properties.connectionDraining', 'type': 'ApplicationGatewayConnectionDraining'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'pick_host_name_from_backend_address': {'key': 'properties.pickHostNameFromBackendAddress', 'type': 'bool'},
        'affinity_cookie_name': {'key': 'properties.affinityCookieName', 'type': 'str'},
        'probe_enabled': {'key': 'properties.probeEnabled', 'type': 'bool'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        port: Optional[int] = None,
        protocol: Optional[Union[str, "ApplicationGatewayProtocol"]] = None,
        cookie_based_affinity: Optional[Union[str, "ApplicationGatewayCookieBasedAffinity"]] = None,
        request_timeout: Optional[int] = None,
        probe: Optional["SubResource"] = None,
        authentication_certificates: Optional[List["SubResource"]] = None,
        connection_draining: Optional["ApplicationGatewayConnectionDraining"] = None,
        host_name: Optional[str] = None,
        pick_host_name_from_backend_address: Optional[bool] = None,
        affinity_cookie_name: Optional[str] = None,
        probe_enabled: Optional[bool] = None,
        path: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayBackendHttpSettings, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.port = port
        self.protocol = protocol
        self.cookie_based_affinity = cookie_based_affinity
        self.request_timeout = request_timeout
        self.probe = probe
        self.authentication_certificates = authentication_certificates
        self.connection_draining = connection_draining
        self.host_name = host_name
        self.pick_host_name_from_backend_address = pick_host_name_from_backend_address
        self.affinity_cookie_name = affinity_cookie_name
        self.probe_enabled = probe_enabled
        self.path = path
        self.provisioning_state = provisioning_state


class ApplicationGatewayConnectionDraining(msrest.serialization.Model):
    """Connection draining allows open connections to a backend server to be active for a specified time after the backend server got removed from the configuration.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether connection draining is enabled or not.
    :type enabled: bool
    :param drain_timeout_in_sec: Required. The number of seconds connection draining is active.
     Acceptable values are from 1 second to 3600 seconds.
    :type drain_timeout_in_sec: int
    """

    _validation = {
        'enabled': {'required': True},
        'drain_timeout_in_sec': {'required': True, 'maximum': 3600, 'minimum': 1},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'drain_timeout_in_sec': {'key': 'drainTimeoutInSec', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        drain_timeout_in_sec: int,
        **kwargs
    ):
        super(ApplicationGatewayConnectionDraining, self).__init__(**kwargs)
        self.enabled = enabled
        self.drain_timeout_in_sec = drain_timeout_in_sec


class ApplicationGatewayFirewallDisabledRuleGroup(msrest.serialization.Model):
    """Allows to disable rules within a rule group or an entire rule group.

    All required parameters must be populated in order to send to Azure.

    :param rule_group_name: Required. The name of the rule group that will be disabled.
    :type rule_group_name: str
    :param rules: The list of rules that will be disabled. If null, all rules of the rule group
     will be disabled.
    :type rules: list[int]
    """

    _validation = {
        'rule_group_name': {'required': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[int]'},
    }

    def __init__(
        self,
        *,
        rule_group_name: str,
        rules: Optional[List[int]] = None,
        **kwargs
    ):
        super(ApplicationGatewayFirewallDisabledRuleGroup, self).__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.rules = rules


class ApplicationGatewayFirewallRule(msrest.serialization.Model):
    """A web application firewall rule.

    All required parameters must be populated in order to send to Azure.

    :param rule_id: Required. The identifier of the web application firewall rule.
    :type rule_id: int
    :param description: The description of the web application firewall rule.
    :type description: str
    """

    _validation = {
        'rule_id': {'required': True},
    }

    _attribute_map = {
        'rule_id': {'key': 'ruleId', 'type': 'int'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        rule_id: int,
        description: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayFirewallRule, self).__init__(**kwargs)
        self.rule_id = rule_id
        self.description = description


class ApplicationGatewayFirewallRuleGroup(msrest.serialization.Model):
    """A web application firewall rule group.

    All required parameters must be populated in order to send to Azure.

    :param rule_group_name: Required. The name of the web application firewall rule group.
    :type rule_group_name: str
    :param description: The description of the web application firewall rule group.
    :type description: str
    :param rules: Required. The rules of the web application firewall rule group.
    :type rules: list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayFirewallRule]
    """

    _validation = {
        'rule_group_name': {'required': True},
        'rules': {'required': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[ApplicationGatewayFirewallRule]'},
    }

    def __init__(
        self,
        *,
        rule_group_name: str,
        rules: List["ApplicationGatewayFirewallRule"],
        description: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayFirewallRuleGroup, self).__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.description = description
        self.rules = rules


class ApplicationGatewayFirewallRuleSet(Resource):
    """A web application firewall rule set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param provisioning_state: The provisioning state of the web application firewall rule set.
    :type provisioning_state: str
    :param rule_set_type: The type of the web application firewall rule set.
    :type rule_set_type: str
    :param rule_set_version: The version of the web application firewall rule set type.
    :type rule_set_version: str
    :param rule_groups: The rule groups of the web application firewall rule set.
    :type rule_groups:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayFirewallRuleGroup]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'rule_set_type': {'key': 'properties.ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'properties.ruleSetVersion', 'type': 'str'},
        'rule_groups': {'key': 'properties.ruleGroups', 'type': '[ApplicationGatewayFirewallRuleGroup]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        provisioning_state: Optional[str] = None,
        rule_set_type: Optional[str] = None,
        rule_set_version: Optional[str] = None,
        rule_groups: Optional[List["ApplicationGatewayFirewallRuleGroup"]] = None,
        **kwargs
    ):
        super(ApplicationGatewayFirewallRuleSet, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.provisioning_state = provisioning_state
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.rule_groups = rule_groups


class ApplicationGatewayFrontendIPConfiguration(SubResource):
    """Frontend IP configuration of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    :param private_ip_address: PrivateIPAddress of the network interface IP Configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: PrivateIP allocation method. Possible values include:
     "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2018_01_01.models.IPAllocationMethod
    :param subnet: Reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param public_ip_address: Reference of the PublicIP resource.
    :type public_ip_address: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param provisioning_state: Provisioning state of the public IP resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "IPAllocationMethod"]] = None,
        subnet: Optional["SubResource"] = None,
        public_ip_address: Optional["SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayFrontendIPConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state


class ApplicationGatewayFrontendPort(SubResource):
    """Frontend port of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    :param port: Frontend port.
    :type port: int
    :param provisioning_state: Provisioning state of the frontend port resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        port: Optional[int] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayFrontendPort, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.port = port
        self.provisioning_state = provisioning_state


class ApplicationGatewayHttpListener(SubResource):
    """Http listener of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    :param frontend_ip_configuration: Frontend IP configuration resource of an application gateway.
    :type frontend_ip_configuration: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param frontend_port: Frontend port resource of an application gateway.
    :type frontend_port: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param protocol: Protocol. Possible values include: "Http", "Https".
    :type protocol: str or ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayProtocol
    :param host_name: Host name of HTTP listener.
    :type host_name: str
    :param ssl_certificate: SSL certificate resource of an application gateway.
    :type ssl_certificate: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param require_server_name_indication: Applicable only if protocol is https. Enables SNI for
     multi-hosting.
    :type require_server_name_indication: bool
    :param provisioning_state: Provisioning state of the HTTP listener resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'SubResource'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'ssl_certificate': {'key': 'properties.sslCertificate', 'type': 'SubResource'},
        'require_server_name_indication': {'key': 'properties.requireServerNameIndication', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        frontend_ip_configuration: Optional["SubResource"] = None,
        frontend_port: Optional["SubResource"] = None,
        protocol: Optional[Union[str, "ApplicationGatewayProtocol"]] = None,
        host_name: Optional[str] = None,
        ssl_certificate: Optional["SubResource"] = None,
        require_server_name_indication: Optional[bool] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayHttpListener, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.frontend_ip_configuration = frontend_ip_configuration
        self.frontend_port = frontend_port
        self.protocol = protocol
        self.host_name = host_name
        self.ssl_certificate = ssl_certificate
        self.require_server_name_indication = require_server_name_indication
        self.provisioning_state = provisioning_state


class ApplicationGatewayIPConfiguration(SubResource):
    """IP configuration of an application gateway. Currently 1 public and 1 private IP configuration is allowed.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    :param subnet: Reference of the subnet resource. A subnet from where application gateway gets
     its private address.
    :type subnet: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param provisioning_state: Provisioning state of the application gateway subnet resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        subnet: Optional["SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayIPConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.subnet = subnet
        self.provisioning_state = provisioning_state


class ApplicationGatewayListResult(msrest.serialization.Model):
    """Response for ListApplicationGateways API service call.

    :param value: List of an application gateways in a resource group.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.ApplicationGateway]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationGateway]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ApplicationGateway"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationGatewayPathRule(SubResource):
    """Path rule of URL path map of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    :param paths: Path rules of URL path map.
    :type paths: list[str]
    :param backend_address_pool: Backend address pool resource of URL path map path rule.
    :type backend_address_pool: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param backend_http_settings: Backend http settings resource of URL path map path rule.
    :type backend_http_settings: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param redirect_configuration: Redirect configuration resource of URL path map path rule.
    :type redirect_configuration: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param provisioning_state: Path rule of URL path map resource. Possible values are: 'Updating',
     'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'paths': {'key': 'properties.paths', 'type': '[str]'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'backend_http_settings': {'key': 'properties.backendHttpSettings', 'type': 'SubResource'},
        'redirect_configuration': {'key': 'properties.redirectConfiguration', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        paths: Optional[List[str]] = None,
        backend_address_pool: Optional["SubResource"] = None,
        backend_http_settings: Optional["SubResource"] = None,
        redirect_configuration: Optional["SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayPathRule, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.paths = paths
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings
        self.redirect_configuration = redirect_configuration
        self.provisioning_state = provisioning_state


class ApplicationGatewayProbe(SubResource):
    """Probe of the application gateway.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    :param protocol: Protocol. Possible values include: "Http", "Https".
    :type protocol: str or ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayProtocol
    :param host: Host name to send the probe to.
    :type host: str
    :param path: Relative path of probe. Valid path starts from '/'. Probe is sent to
     :code:`<Protocol>`://:code:`<host>`::code:`<port>`:code:`<path>`.
    :type path: str
    :param interval: The probing interval in seconds. This is the time interval between two
     consecutive probes. Acceptable values are from 1 second to 86400 seconds.
    :type interval: int
    :param timeout: the probe timeout in seconds. Probe marked as failed if valid response is not
     received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
    :type timeout: int
    :param unhealthy_threshold: The probe retry count. Backend server is marked down after
     consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second
     to 20.
    :type unhealthy_threshold: int
    :param pick_host_name_from_backend_http_settings: Whether the host header should be picked from
     the backend http settings. Default value is false.
    :type pick_host_name_from_backend_http_settings: bool
    :param min_servers: Minimum number of servers that are always marked healthy. Default value is
     0.
    :type min_servers: int
    :param match: Criterion for classifying a healthy probe response.
    :type match: ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayProbeHealthResponseMatch
    :param provisioning_state: Provisioning state of the backend http settings resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'host': {'key': 'properties.host', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'interval': {'key': 'properties.interval', 'type': 'int'},
        'timeout': {'key': 'properties.timeout', 'type': 'int'},
        'unhealthy_threshold': {'key': 'properties.unhealthyThreshold', 'type': 'int'},
        'pick_host_name_from_backend_http_settings': {'key': 'properties.pickHostNameFromBackendHttpSettings', 'type': 'bool'},
        'min_servers': {'key': 'properties.minServers', 'type': 'int'},
        'match': {'key': 'properties.match', 'type': 'ApplicationGatewayProbeHealthResponseMatch'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        protocol: Optional[Union[str, "ApplicationGatewayProtocol"]] = None,
        host: Optional[str] = None,
        path: Optional[str] = None,
        interval: Optional[int] = None,
        timeout: Optional[int] = None,
        unhealthy_threshold: Optional[int] = None,
        pick_host_name_from_backend_http_settings: Optional[bool] = None,
        min_servers: Optional[int] = None,
        match: Optional["ApplicationGatewayProbeHealthResponseMatch"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayProbe, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.protocol = protocol
        self.host = host
        self.path = path
        self.interval = interval
        self.timeout = timeout
        self.unhealthy_threshold = unhealthy_threshold
        self.pick_host_name_from_backend_http_settings = pick_host_name_from_backend_http_settings
        self.min_servers = min_servers
        self.match = match
        self.provisioning_state = provisioning_state


class ApplicationGatewayProbeHealthResponseMatch(msrest.serialization.Model):
    """Application gateway probe health response match.

    :param body: Body that must be contained in the health response. Default value is empty.
    :type body: str
    :param status_codes: Allowed ranges of healthy status codes. Default range of healthy status
     codes is 200-399.
    :type status_codes: list[str]
    """

    _attribute_map = {
        'body': {'key': 'body', 'type': 'str'},
        'status_codes': {'key': 'statusCodes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        body: Optional[str] = None,
        status_codes: Optional[List[str]] = None,
        **kwargs
    ):
        super(ApplicationGatewayProbeHealthResponseMatch, self).__init__(**kwargs)
        self.body = body
        self.status_codes = status_codes


class ApplicationGatewayRedirectConfiguration(SubResource):
    """Redirect configuration of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    :param redirect_type: Supported http redirection types - Permanent, Temporary, Found, SeeOther.
     Possible values include: "Permanent", "Found", "SeeOther", "Temporary".
    :type redirect_type: str or
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayRedirectType
    :param target_listener: Reference to a listener to redirect the request to.
    :type target_listener: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param target_url: Url to redirect the request to.
    :type target_url: str
    :param include_path: Include path in the redirected url.
    :type include_path: bool
    :param include_query_string: Include query string in the redirected url.
    :type include_query_string: bool
    :param request_routing_rules: Request routing specifying redirect configuration.
    :type request_routing_rules: list[~azure.mgmt.network.v2018_01_01.models.SubResource]
    :param url_path_maps: Url path maps specifying default redirect configuration.
    :type url_path_maps: list[~azure.mgmt.network.v2018_01_01.models.SubResource]
    :param path_rules: Path rules specifying redirect configuration.
    :type path_rules: list[~azure.mgmt.network.v2018_01_01.models.SubResource]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'redirect_type': {'key': 'properties.redirectType', 'type': 'str'},
        'target_listener': {'key': 'properties.targetListener', 'type': 'SubResource'},
        'target_url': {'key': 'properties.targetUrl', 'type': 'str'},
        'include_path': {'key': 'properties.includePath', 'type': 'bool'},
        'include_query_string': {'key': 'properties.includeQueryString', 'type': 'bool'},
        'request_routing_rules': {'key': 'properties.requestRoutingRules', 'type': '[SubResource]'},
        'url_path_maps': {'key': 'properties.urlPathMaps', 'type': '[SubResource]'},
        'path_rules': {'key': 'properties.pathRules', 'type': '[SubResource]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        redirect_type: Optional[Union[str, "ApplicationGatewayRedirectType"]] = None,
        target_listener: Optional["SubResource"] = None,
        target_url: Optional[str] = None,
        include_path: Optional[bool] = None,
        include_query_string: Optional[bool] = None,
        request_routing_rules: Optional[List["SubResource"]] = None,
        url_path_maps: Optional[List["SubResource"]] = None,
        path_rules: Optional[List["SubResource"]] = None,
        **kwargs
    ):
        super(ApplicationGatewayRedirectConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.redirect_type = redirect_type
        self.target_listener = target_listener
        self.target_url = target_url
        self.include_path = include_path
        self.include_query_string = include_query_string
        self.request_routing_rules = request_routing_rules
        self.url_path_maps = url_path_maps
        self.path_rules = path_rules


class ApplicationGatewayRequestRoutingRule(SubResource):
    """Request routing rule of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    :param rule_type: Rule type. Possible values include: "Basic", "PathBasedRouting".
    :type rule_type: str or
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayRequestRoutingRuleType
    :param backend_address_pool: Backend address pool resource of the application gateway.
    :type backend_address_pool: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param backend_http_settings: Frontend port resource of the application gateway.
    :type backend_http_settings: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param http_listener: Http listener resource of the application gateway.
    :type http_listener: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param url_path_map: URL path map resource of the application gateway.
    :type url_path_map: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param redirect_configuration: Redirect configuration resource of the application gateway.
    :type redirect_configuration: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param provisioning_state: Provisioning state of the request routing rule resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'rule_type': {'key': 'properties.ruleType', 'type': 'str'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'backend_http_settings': {'key': 'properties.backendHttpSettings', 'type': 'SubResource'},
        'http_listener': {'key': 'properties.httpListener', 'type': 'SubResource'},
        'url_path_map': {'key': 'properties.urlPathMap', 'type': 'SubResource'},
        'redirect_configuration': {'key': 'properties.redirectConfiguration', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        rule_type: Optional[Union[str, "ApplicationGatewayRequestRoutingRuleType"]] = None,
        backend_address_pool: Optional["SubResource"] = None,
        backend_http_settings: Optional["SubResource"] = None,
        http_listener: Optional["SubResource"] = None,
        url_path_map: Optional["SubResource"] = None,
        redirect_configuration: Optional["SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayRequestRoutingRule, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.rule_type = rule_type
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings
        self.http_listener = http_listener
        self.url_path_map = url_path_map
        self.redirect_configuration = redirect_configuration
        self.provisioning_state = provisioning_state


class ApplicationGatewaySku(msrest.serialization.Model):
    """SKU of an application gateway.

    :param name: Name of an application gateway SKU. Possible values include: "Standard_Small",
     "Standard_Medium", "Standard_Large", "WAF_Medium", "WAF_Large".
    :type name: str or ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewaySkuName
    :param tier: Tier of an application gateway. Possible values include: "Standard", "WAF".
    :type tier: str or ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayTier
    :param capacity: Capacity (instance count) of an application gateway.
    :type capacity: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "ApplicationGatewaySkuName"]] = None,
        tier: Optional[Union[str, "ApplicationGatewayTier"]] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(ApplicationGatewaySku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class ApplicationGatewaySslCertificate(SubResource):
    """SSL certificates of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    :param data: Base-64 encoded pfx certificate. Only applicable in PUT Request.
    :type data: str
    :param password: Password for the pfx file specified in data. Only applicable in PUT request.
    :type password: str
    :param public_cert_data: Base-64 encoded Public cert data corresponding to pfx specified in
     data. Only applicable in GET request.
    :type public_cert_data: str
    :param provisioning_state: Provisioning state of the SSL certificate resource Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data': {'key': 'properties.data', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'public_cert_data': {'key': 'properties.publicCertData', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        data: Optional[str] = None,
        password: Optional[str] = None,
        public_cert_data: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewaySslCertificate, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.data = data
        self.password = password
        self.public_cert_data = public_cert_data
        self.provisioning_state = provisioning_state


class ApplicationGatewaySslPolicy(msrest.serialization.Model):
    """Application Gateway Ssl policy.

    :param disabled_ssl_protocols: Ssl protocols to be disabled on application gateway.
    :type disabled_ssl_protocols: list[str or
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewaySslProtocol]
    :param policy_type: Type of Ssl Policy. Possible values include: "Predefined", "Custom".
    :type policy_type: str or
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewaySslPolicyType
    :param policy_name: Name of Ssl predefined policy. Possible values include:
     "AppGwSslPolicy20150501", "AppGwSslPolicy20170401", "AppGwSslPolicy20170401S".
    :type policy_name: str or
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewaySslPolicyName
    :param cipher_suites: Ssl cipher suites to be enabled in the specified order to application
     gateway.
    :type cipher_suites: list[str or
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewaySslCipherSuite]
    :param min_protocol_version: Minimum version of Ssl protocol to be supported on application
     gateway. Possible values include: "TLSv1_0", "TLSv1_1", "TLSv1_2".
    :type min_protocol_version: str or
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewaySslProtocol
    """

    _attribute_map = {
        'disabled_ssl_protocols': {'key': 'disabledSslProtocols', 'type': '[str]'},
        'policy_type': {'key': 'policyType', 'type': 'str'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'cipher_suites': {'key': 'cipherSuites', 'type': '[str]'},
        'min_protocol_version': {'key': 'minProtocolVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disabled_ssl_protocols: Optional[List[Union[str, "ApplicationGatewaySslProtocol"]]] = None,
        policy_type: Optional[Union[str, "ApplicationGatewaySslPolicyType"]] = None,
        policy_name: Optional[Union[str, "ApplicationGatewaySslPolicyName"]] = None,
        cipher_suites: Optional[List[Union[str, "ApplicationGatewaySslCipherSuite"]]] = None,
        min_protocol_version: Optional[Union[str, "ApplicationGatewaySslProtocol"]] = None,
        **kwargs
    ):
        super(ApplicationGatewaySslPolicy, self).__init__(**kwargs)
        self.disabled_ssl_protocols = disabled_ssl_protocols
        self.policy_type = policy_type
        self.policy_name = policy_name
        self.cipher_suites = cipher_suites
        self.min_protocol_version = min_protocol_version


class ApplicationGatewaySslPredefinedPolicy(SubResource):
    """An Ssl predefined policy.

    :param id: Resource ID.
    :type id: str
    :param name: Name of Ssl predefined policy.
    :type name: str
    :param cipher_suites: Ssl cipher suites to be enabled in the specified order for application
     gateway.
    :type cipher_suites: list[str or
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewaySslCipherSuite]
    :param min_protocol_version: Minimum version of Ssl protocol to be supported on application
     gateway. Possible values include: "TLSv1_0", "TLSv1_1", "TLSv1_2".
    :type min_protocol_version: str or
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewaySslProtocol
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'cipher_suites': {'key': 'properties.cipherSuites', 'type': '[str]'},
        'min_protocol_version': {'key': 'properties.minProtocolVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        cipher_suites: Optional[List[Union[str, "ApplicationGatewaySslCipherSuite"]]] = None,
        min_protocol_version: Optional[Union[str, "ApplicationGatewaySslProtocol"]] = None,
        **kwargs
    ):
        super(ApplicationGatewaySslPredefinedPolicy, self).__init__(id=id, **kwargs)
        self.name = name
        self.cipher_suites = cipher_suites
        self.min_protocol_version = min_protocol_version


class ApplicationGatewayUrlPathMap(SubResource):
    """UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    :param default_backend_address_pool: Default backend address pool resource of URL path map.
    :type default_backend_address_pool: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param default_backend_http_settings: Default backend http settings resource of URL path map.
    :type default_backend_http_settings: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param default_redirect_configuration: Default redirect configuration resource of URL path map.
    :type default_redirect_configuration: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param path_rules: Path rule of URL path map resource.
    :type path_rules: list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayPathRule]
    :param provisioning_state: Provisioning state of the backend http settings resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'default_backend_address_pool': {'key': 'properties.defaultBackendAddressPool', 'type': 'SubResource'},
        'default_backend_http_settings': {'key': 'properties.defaultBackendHttpSettings', 'type': 'SubResource'},
        'default_redirect_configuration': {'key': 'properties.defaultRedirectConfiguration', 'type': 'SubResource'},
        'path_rules': {'key': 'properties.pathRules', 'type': '[ApplicationGatewayPathRule]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        default_backend_address_pool: Optional["SubResource"] = None,
        default_backend_http_settings: Optional["SubResource"] = None,
        default_redirect_configuration: Optional["SubResource"] = None,
        path_rules: Optional[List["ApplicationGatewayPathRule"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayUrlPathMap, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.default_backend_address_pool = default_backend_address_pool
        self.default_backend_http_settings = default_backend_http_settings
        self.default_redirect_configuration = default_redirect_configuration
        self.path_rules = path_rules
        self.provisioning_state = provisioning_state


class ApplicationGatewayWebApplicationFirewallConfiguration(msrest.serialization.Model):
    """Application gateway web application firewall configuration.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether the web application firewall is enabled or not.
    :type enabled: bool
    :param firewall_mode: Required. Web application firewall mode. Possible values include:
     "Detection", "Prevention".
    :type firewall_mode: str or
     ~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayFirewallMode
    :param rule_set_type: Required. The type of the web application firewall rule set. Possible
     values are: 'OWASP'.
    :type rule_set_type: str
    :param rule_set_version: Required. The version of the rule set type.
    :type rule_set_version: str
    :param disabled_rule_groups: The disabled rule groups.
    :type disabled_rule_groups:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayFirewallDisabledRuleGroup]
    :param request_body_check: Whether allow WAF to check request Body.
    :type request_body_check: bool
    :param max_request_body_size: Maximum request body size for WAF.
    :type max_request_body_size: int
    """

    _validation = {
        'enabled': {'required': True},
        'firewall_mode': {'required': True},
        'rule_set_type': {'required': True},
        'rule_set_version': {'required': True},
        'max_request_body_size': {'maximum': 128, 'minimum': 8},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'firewall_mode': {'key': 'firewallMode', 'type': 'str'},
        'rule_set_type': {'key': 'ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'ruleSetVersion', 'type': 'str'},
        'disabled_rule_groups': {'key': 'disabledRuleGroups', 'type': '[ApplicationGatewayFirewallDisabledRuleGroup]'},
        'request_body_check': {'key': 'requestBodyCheck', 'type': 'bool'},
        'max_request_body_size': {'key': 'maxRequestBodySize', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        firewall_mode: Union[str, "ApplicationGatewayFirewallMode"],
        rule_set_type: str,
        rule_set_version: str,
        disabled_rule_groups: Optional[List["ApplicationGatewayFirewallDisabledRuleGroup"]] = None,
        request_body_check: Optional[bool] = None,
        max_request_body_size: Optional[int] = None,
        **kwargs
    ):
        super(ApplicationGatewayWebApplicationFirewallConfiguration, self).__init__(**kwargs)
        self.enabled = enabled
        self.firewall_mode = firewall_mode
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.disabled_rule_groups = disabled_rule_groups
        self.request_body_check = request_body_check
        self.max_request_body_size = max_request_body_size


class ApplicationSecurityGroup(Resource):
    """An application security group in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar resource_guid: The resource GUID property of the application security group resource. It
     uniquely identifies a resource, even if the user changes its name or migrate the resource
     across subscriptions or resource groups.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the application security group resource.
     Possible values are: 'Succeeded', 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ApplicationSecurityGroup, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.resource_guid = None
        self.provisioning_state = None


class ApplicationSecurityGroupListResult(msrest.serialization.Model):
    """A list of application security groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of application security groups.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.ApplicationSecurityGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationSecurityGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ApplicationSecurityGroup"]] = None,
        **kwargs
    ):
        super(ApplicationSecurityGroupListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class AuthorizationListResult(msrest.serialization.Model):
    """Response for ListAuthorizations API service call retrieves all authorizations that belongs to an ExpressRouteCircuit.

    :param value: The authorizations in an ExpressRoute Circuit.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitAuthorization]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitAuthorization]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ExpressRouteCircuitAuthorization"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AuthorizationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Availability(msrest.serialization.Model):
    """Availability of the metric.

    :param time_grain: The time grain of the availability.
    :type time_grain: str
    :param retention: The retention of the availability.
    :type retention: str
    :param blob_duration: Duration of the availability blob.
    :type blob_duration: str
    """

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'retention': {'key': 'retention', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        time_grain: Optional[str] = None,
        retention: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs
    ):
        super(Availability, self).__init__(**kwargs)
        self.time_grain = time_grain
        self.retention = retention
        self.blob_duration = blob_duration


class AvailableProvidersList(msrest.serialization.Model):
    """List of available countries with details.

    All required parameters must be populated in order to send to Azure.

    :param countries: Required. List of available countries.
    :type countries: list[~azure.mgmt.network.v2018_01_01.models.AvailableProvidersListCountry]
    """

    _validation = {
        'countries': {'required': True},
    }

    _attribute_map = {
        'countries': {'key': 'countries', 'type': '[AvailableProvidersListCountry]'},
    }

    def __init__(
        self,
        *,
        countries: List["AvailableProvidersListCountry"],
        **kwargs
    ):
        super(AvailableProvidersList, self).__init__(**kwargs)
        self.countries = countries


class AvailableProvidersListCity(msrest.serialization.Model):
    """City or town details.

    :param city_name: The city or town name.
    :type city_name: str
    :param providers: A list of Internet service providers.
    :type providers: list[str]
    """

    _attribute_map = {
        'city_name': {'key': 'cityName', 'type': 'str'},
        'providers': {'key': 'providers', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        city_name: Optional[str] = None,
        providers: Optional[List[str]] = None,
        **kwargs
    ):
        super(AvailableProvidersListCity, self).__init__(**kwargs)
        self.city_name = city_name
        self.providers = providers


class AvailableProvidersListCountry(msrest.serialization.Model):
    """Country details.

    :param country_name: The country name.
    :type country_name: str
    :param providers: A list of Internet service providers.
    :type providers: list[str]
    :param states: List of available states in the country.
    :type states: list[~azure.mgmt.network.v2018_01_01.models.AvailableProvidersListState]
    """

    _attribute_map = {
        'country_name': {'key': 'countryName', 'type': 'str'},
        'providers': {'key': 'providers', 'type': '[str]'},
        'states': {'key': 'states', 'type': '[AvailableProvidersListState]'},
    }

    def __init__(
        self,
        *,
        country_name: Optional[str] = None,
        providers: Optional[List[str]] = None,
        states: Optional[List["AvailableProvidersListState"]] = None,
        **kwargs
    ):
        super(AvailableProvidersListCountry, self).__init__(**kwargs)
        self.country_name = country_name
        self.providers = providers
        self.states = states


class AvailableProvidersListParameters(msrest.serialization.Model):
    """Constraints that determine the list of available Internet service providers.

    :param azure_locations: A list of Azure regions.
    :type azure_locations: list[str]
    :param country: The country for available providers list.
    :type country: str
    :param state: The state for available providers list.
    :type state: str
    :param city: The city or town for available providers list.
    :type city: str
    """

    _attribute_map = {
        'azure_locations': {'key': 'azureLocations', 'type': '[str]'},
        'country': {'key': 'country', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        azure_locations: Optional[List[str]] = None,
        country: Optional[str] = None,
        state: Optional[str] = None,
        city: Optional[str] = None,
        **kwargs
    ):
        super(AvailableProvidersListParameters, self).__init__(**kwargs)
        self.azure_locations = azure_locations
        self.country = country
        self.state = state
        self.city = city


class AvailableProvidersListState(msrest.serialization.Model):
    """State details.

    :param state_name: The state name.
    :type state_name: str
    :param providers: A list of Internet service providers.
    :type providers: list[str]
    :param cities: List of available cities or towns in the state.
    :type cities: list[~azure.mgmt.network.v2018_01_01.models.AvailableProvidersListCity]
    """

    _attribute_map = {
        'state_name': {'key': 'stateName', 'type': 'str'},
        'providers': {'key': 'providers', 'type': '[str]'},
        'cities': {'key': 'cities', 'type': '[AvailableProvidersListCity]'},
    }

    def __init__(
        self,
        *,
        state_name: Optional[str] = None,
        providers: Optional[List[str]] = None,
        cities: Optional[List["AvailableProvidersListCity"]] = None,
        **kwargs
    ):
        super(AvailableProvidersListState, self).__init__(**kwargs)
        self.state_name = state_name
        self.providers = providers
        self.cities = cities


class AzureAsyncOperationResult(msrest.serialization.Model):
    """The response body contains the status of the specified asynchronous operation, indicating whether it has succeeded, is in progress, or has failed. Note that this status is distinct from the HTTP status code returned for the Get Operation Status operation itself. If the asynchronous operation succeeded, the response body includes the HTTP status code for the successful request. If the asynchronous operation failed, the response body includes the HTTP status code for the failed request and error information regarding the failure.

    :param status: Status of the Azure async operation. Possible values are: 'InProgress',
     'Succeeded', and 'Failed'. Possible values include: "InProgress", "Succeeded", "Failed".
    :type status: str or ~azure.mgmt.network.v2018_01_01.models.NetworkOperationStatus
    :param error:
    :type error: ~azure.mgmt.network.v2018_01_01.models.Error
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "NetworkOperationStatus"]] = None,
        error: Optional["Error"] = None,
        **kwargs
    ):
        super(AzureAsyncOperationResult, self).__init__(**kwargs)
        self.status = status
        self.error = error


class AzureReachabilityReport(msrest.serialization.Model):
    """Azure reachability report details.

    All required parameters must be populated in order to send to Azure.

    :param aggregation_level: Required. The aggregation level of Azure reachability report. Can be
     Country, State or City.
    :type aggregation_level: str
    :param provider_location: Required. Parameters that define a geographic location.
    :type provider_location: ~azure.mgmt.network.v2018_01_01.models.AzureReachabilityReportLocation
    :param reachability_report: Required. List of Azure reachability report items.
    :type reachability_report:
     list[~azure.mgmt.network.v2018_01_01.models.AzureReachabilityReportItem]
    """

    _validation = {
        'aggregation_level': {'required': True},
        'provider_location': {'required': True},
        'reachability_report': {'required': True},
    }

    _attribute_map = {
        'aggregation_level': {'key': 'aggregationLevel', 'type': 'str'},
        'provider_location': {'key': 'providerLocation', 'type': 'AzureReachabilityReportLocation'},
        'reachability_report': {'key': 'reachabilityReport', 'type': '[AzureReachabilityReportItem]'},
    }

    def __init__(
        self,
        *,
        aggregation_level: str,
        provider_location: "AzureReachabilityReportLocation",
        reachability_report: List["AzureReachabilityReportItem"],
        **kwargs
    ):
        super(AzureReachabilityReport, self).__init__(**kwargs)
        self.aggregation_level = aggregation_level
        self.provider_location = provider_location
        self.reachability_report = reachability_report


class AzureReachabilityReportItem(msrest.serialization.Model):
    """Azure reachability report details for a given provider location.

    :param provider: The Internet service provider.
    :type provider: str
    :param azure_location: The Azure region.
    :type azure_location: str
    :param latencies: List of latency details for each of the time series.
    :type latencies:
     list[~azure.mgmt.network.v2018_01_01.models.AzureReachabilityReportLatencyInfo]
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'azure_location': {'key': 'azureLocation', 'type': 'str'},
        'latencies': {'key': 'latencies', 'type': '[AzureReachabilityReportLatencyInfo]'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        azure_location: Optional[str] = None,
        latencies: Optional[List["AzureReachabilityReportLatencyInfo"]] = None,
        **kwargs
    ):
        super(AzureReachabilityReportItem, self).__init__(**kwargs)
        self.provider = provider
        self.azure_location = azure_location
        self.latencies = latencies


class AzureReachabilityReportLatencyInfo(msrest.serialization.Model):
    """Details on latency for a time series.

    :param time_stamp: The time stamp.
    :type time_stamp: ~datetime.datetime
    :param score: The relative latency score between 1 and 100, higher values indicating a faster
     connection.
    :type score: int
    """

    _validation = {
        'score': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'time_stamp': {'key': 'timeStamp', 'type': 'iso-8601'},
        'score': {'key': 'score', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        time_stamp: Optional[datetime.datetime] = None,
        score: Optional[int] = None,
        **kwargs
    ):
        super(AzureReachabilityReportLatencyInfo, self).__init__(**kwargs)
        self.time_stamp = time_stamp
        self.score = score


class AzureReachabilityReportLocation(msrest.serialization.Model):
    """Parameters that define a geographic location.

    All required parameters must be populated in order to send to Azure.

    :param country: Required. The name of the country.
    :type country: str
    :param state: The name of the state.
    :type state: str
    :param city: The name of the city or town.
    :type city: str
    """

    _validation = {
        'country': {'required': True},
    }

    _attribute_map = {
        'country': {'key': 'country', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        country: str,
        state: Optional[str] = None,
        city: Optional[str] = None,
        **kwargs
    ):
        super(AzureReachabilityReportLocation, self).__init__(**kwargs)
        self.country = country
        self.state = state
        self.city = city


class AzureReachabilityReportParameters(msrest.serialization.Model):
    """Geographic and time constraints for Azure reachability report.

    All required parameters must be populated in order to send to Azure.

    :param provider_location: Required. Parameters that define a geographic location.
    :type provider_location: ~azure.mgmt.network.v2018_01_01.models.AzureReachabilityReportLocation
    :param providers: List of Internet service providers.
    :type providers: list[str]
    :param azure_locations: Optional Azure regions to scope the query to.
    :type azure_locations: list[str]
    :param start_time: Required. The start time for the Azure reachability report.
    :type start_time: ~datetime.datetime
    :param end_time: Required. The end time for the Azure reachability report.
    :type end_time: ~datetime.datetime
    """

    _validation = {
        'provider_location': {'required': True},
        'start_time': {'required': True},
        'end_time': {'required': True},
    }

    _attribute_map = {
        'provider_location': {'key': 'providerLocation', 'type': 'AzureReachabilityReportLocation'},
        'providers': {'key': 'providers', 'type': '[str]'},
        'azure_locations': {'key': 'azureLocations', 'type': '[str]'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        provider_location: "AzureReachabilityReportLocation",
        start_time: datetime.datetime,
        end_time: datetime.datetime,
        providers: Optional[List[str]] = None,
        azure_locations: Optional[List[str]] = None,
        **kwargs
    ):
        super(AzureReachabilityReportParameters, self).__init__(**kwargs)
        self.provider_location = provider_location
        self.providers = providers
        self.azure_locations = azure_locations
        self.start_time = start_time
        self.end_time = end_time


class BackendAddressPool(SubResource):
    """Pool of backend IP addresses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :ivar backend_ip_configurations: Gets collection of references to IP addresses defined in
     network interfaces.
    :vartype backend_ip_configurations:
     list[~azure.mgmt.network.v2018_01_01.models.NetworkInterfaceIPConfiguration]
    :ivar load_balancing_rules: Gets load balancing rules that use this backend address pool.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2018_01_01.models.SubResource]
    :ivar outbound_nat_rule: Gets outbound rules that use this backend address pool.
    :vartype outbound_nat_rule: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param provisioning_state: Get provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'backend_ip_configurations': {'readonly': True},
        'load_balancing_rules': {'readonly': True},
        'outbound_nat_rule': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'backend_ip_configurations': {'key': 'properties.backendIPConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'outbound_nat_rule': {'key': 'properties.outboundNatRule', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(BackendAddressPool, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.backend_ip_configurations = None
        self.load_balancing_rules = None
        self.outbound_nat_rule = None
        self.provisioning_state = provisioning_state


class BGPCommunity(msrest.serialization.Model):
    """Contains bgp community information offered in Service Community resources.

    :param service_supported_region: The region which the service support. e.g. For O365, region is
     Global.
    :type service_supported_region: str
    :param community_name: The name of the bgp community. e.g. Skype.
    :type community_name: str
    :param community_value: The value of the bgp community. For more information:
     https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
    :type community_value: str
    :param community_prefixes: The prefixes that the bgp community contains.
    :type community_prefixes: list[str]
    :param is_authorized_to_use: Customer is authorized to use bgp community or not.
    :type is_authorized_to_use: bool
    :param service_group: The service group of the bgp community contains.
    :type service_group: str
    """

    _attribute_map = {
        'service_supported_region': {'key': 'serviceSupportedRegion', 'type': 'str'},
        'community_name': {'key': 'communityName', 'type': 'str'},
        'community_value': {'key': 'communityValue', 'type': 'str'},
        'community_prefixes': {'key': 'communityPrefixes', 'type': '[str]'},
        'is_authorized_to_use': {'key': 'isAuthorizedToUse', 'type': 'bool'},
        'service_group': {'key': 'serviceGroup', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        service_supported_region: Optional[str] = None,
        community_name: Optional[str] = None,
        community_value: Optional[str] = None,
        community_prefixes: Optional[List[str]] = None,
        is_authorized_to_use: Optional[bool] = None,
        service_group: Optional[str] = None,
        **kwargs
    ):
        super(BGPCommunity, self).__init__(**kwargs)
        self.service_supported_region = service_supported_region
        self.community_name = community_name
        self.community_value = community_value
        self.community_prefixes = community_prefixes
        self.is_authorized_to_use = is_authorized_to_use
        self.service_group = service_group


class BgpPeerStatus(msrest.serialization.Model):
    """BGP peer status details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar local_address: The virtual network gateway's local address.
    :vartype local_address: str
    :ivar neighbor: The remote BGP peer.
    :vartype neighbor: str
    :ivar asn: The autonomous system number of the remote BGP peer.
    :vartype asn: int
    :ivar state: The BGP peer state. Possible values include: "Unknown", "Stopped", "Idle",
     "Connecting", "Connected".
    :vartype state: str or ~azure.mgmt.network.v2018_01_01.models.BgpPeerState
    :ivar connected_duration: For how long the peering has been up.
    :vartype connected_duration: str
    :ivar routes_received: The number of routes learned from this peer.
    :vartype routes_received: long
    :ivar messages_sent: The number of BGP messages sent.
    :vartype messages_sent: long
    :ivar messages_received: The number of BGP messages received.
    :vartype messages_received: long
    """

    _validation = {
        'local_address': {'readonly': True},
        'neighbor': {'readonly': True},
        'asn': {'readonly': True},
        'state': {'readonly': True},
        'connected_duration': {'readonly': True},
        'routes_received': {'readonly': True},
        'messages_sent': {'readonly': True},
        'messages_received': {'readonly': True},
    }

    _attribute_map = {
        'local_address': {'key': 'localAddress', 'type': 'str'},
        'neighbor': {'key': 'neighbor', 'type': 'str'},
        'asn': {'key': 'asn', 'type': 'int'},
        'state': {'key': 'state', 'type': 'str'},
        'connected_duration': {'key': 'connectedDuration', 'type': 'str'},
        'routes_received': {'key': 'routesReceived', 'type': 'long'},
        'messages_sent': {'key': 'messagesSent', 'type': 'long'},
        'messages_received': {'key': 'messagesReceived', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BgpPeerStatus, self).__init__(**kwargs)
        self.local_address = None
        self.neighbor = None
        self.asn = None
        self.state = None
        self.connected_duration = None
        self.routes_received = None
        self.messages_sent = None
        self.messages_received = None


class BgpPeerStatusListResult(msrest.serialization.Model):
    """Response for list BGP peer status API service call.

    :param value: List of BGP peers.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.BgpPeerStatus]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BgpPeerStatus]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["BgpPeerStatus"]] = None,
        **kwargs
    ):
        super(BgpPeerStatusListResult, self).__init__(**kwargs)
        self.value = value


class BgpServiceCommunity(Resource):
    """Service Community Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param service_name: The name of the bgp community. e.g. Skype.
    :type service_name: str
    :param bgp_communities: Get a list of bgp communities.
    :type bgp_communities: list[~azure.mgmt.network.v2018_01_01.models.BGPCommunity]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'service_name': {'key': 'properties.serviceName', 'type': 'str'},
        'bgp_communities': {'key': 'properties.bgpCommunities', 'type': '[BGPCommunity]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        service_name: Optional[str] = None,
        bgp_communities: Optional[List["BGPCommunity"]] = None,
        **kwargs
    ):
        super(BgpServiceCommunity, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.service_name = service_name
        self.bgp_communities = bgp_communities


class BgpServiceCommunityListResult(msrest.serialization.Model):
    """Response for the ListServiceCommunity API service call.

    :param value: A list of service community resources.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.BgpServiceCommunity]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BgpServiceCommunity]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["BgpServiceCommunity"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(BgpServiceCommunityListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BgpSettings(msrest.serialization.Model):
    """BGP settings details.

    :param asn: The BGP speaker's ASN.
    :type asn: long
    :param bgp_peering_address: The BGP peering address and BGP identifier of this BGP speaker.
    :type bgp_peering_address: str
    :param peer_weight: The weight added to routes learned from this BGP speaker.
    :type peer_weight: int
    """

    _attribute_map = {
        'asn': {'key': 'asn', 'type': 'long'},
        'bgp_peering_address': {'key': 'bgpPeeringAddress', 'type': 'str'},
        'peer_weight': {'key': 'peerWeight', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        asn: Optional[int] = None,
        bgp_peering_address: Optional[str] = None,
        peer_weight: Optional[int] = None,
        **kwargs
    ):
        super(BgpSettings, self).__init__(**kwargs)
        self.asn = asn
        self.bgp_peering_address = bgp_peering_address
        self.peer_weight = peer_weight


class ConnectionMonitor(msrest.serialization.Model):
    """Parameters that define the operation to create a connection monitor.

    All required parameters must be populated in order to send to Azure.

    :param location: Connection monitor location.
    :type location: str
    :param tags: A set of tags. Connection monitor tags.
    :type tags: dict[str, str]
    :param source: Required. Describes the source of connection monitor.
    :type source: ~azure.mgmt.network.v2018_01_01.models.ConnectionMonitorSource
    :param destination: Required. Describes the destination of connection monitor.
    :type destination: ~azure.mgmt.network.v2018_01_01.models.ConnectionMonitorDestination
    :param auto_start: Determines if the connection monitor will start automatically once created.
    :type auto_start: bool
    :param monitoring_interval_in_seconds: Monitoring interval in seconds.
    :type monitoring_interval_in_seconds: int
    """

    _validation = {
        'source': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'source': {'key': 'properties.source', 'type': 'ConnectionMonitorSource'},
        'destination': {'key': 'properties.destination', 'type': 'ConnectionMonitorDestination'},
        'auto_start': {'key': 'properties.autoStart', 'type': 'bool'},
        'monitoring_interval_in_seconds': {'key': 'properties.monitoringIntervalInSeconds', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        source: "ConnectionMonitorSource",
        destination: "ConnectionMonitorDestination",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        auto_start: Optional[bool] = True,
        monitoring_interval_in_seconds: Optional[int] = 60,
        **kwargs
    ):
        super(ConnectionMonitor, self).__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.source = source
        self.destination = destination
        self.auto_start = auto_start
        self.monitoring_interval_in_seconds = monitoring_interval_in_seconds


class ConnectionMonitorDestination(msrest.serialization.Model):
    """Describes the destination of connection monitor.

    :param resource_id: The ID of the resource used as the destination by connection monitor.
    :type resource_id: str
    :param address: Address of the connection monitor destination (IP or domain name).
    :type address: str
    :param port: The destination port used by connection monitor.
    :type port: int
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        address: Optional[str] = None,
        port: Optional[int] = None,
        **kwargs
    ):
        super(ConnectionMonitorDestination, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.address = address
        self.port = port


class ConnectionMonitorListResult(msrest.serialization.Model):
    """List of connection monitors.

    :param value: Information about connection monitors.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.ConnectionMonitorResult]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ConnectionMonitorResult]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ConnectionMonitorResult"]] = None,
        **kwargs
    ):
        super(ConnectionMonitorListResult, self).__init__(**kwargs)
        self.value = value


class ConnectionMonitorParameters(msrest.serialization.Model):
    """Parameters that define the operation to create a connection monitor.

    All required parameters must be populated in order to send to Azure.

    :param source: Required. Describes the source of connection monitor.
    :type source: ~azure.mgmt.network.v2018_01_01.models.ConnectionMonitorSource
    :param destination: Required. Describes the destination of connection monitor.
    :type destination: ~azure.mgmt.network.v2018_01_01.models.ConnectionMonitorDestination
    :param auto_start: Determines if the connection monitor will start automatically once created.
    :type auto_start: bool
    :param monitoring_interval_in_seconds: Monitoring interval in seconds.
    :type monitoring_interval_in_seconds: int
    """

    _validation = {
        'source': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'ConnectionMonitorSource'},
        'destination': {'key': 'destination', 'type': 'ConnectionMonitorDestination'},
        'auto_start': {'key': 'autoStart', 'type': 'bool'},
        'monitoring_interval_in_seconds': {'key': 'monitoringIntervalInSeconds', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        source: "ConnectionMonitorSource",
        destination: "ConnectionMonitorDestination",
        auto_start: Optional[bool] = True,
        monitoring_interval_in_seconds: Optional[int] = 60,
        **kwargs
    ):
        super(ConnectionMonitorParameters, self).__init__(**kwargs)
        self.source = source
        self.destination = destination
        self.auto_start = auto_start
        self.monitoring_interval_in_seconds = monitoring_interval_in_seconds


class ConnectionMonitorQueryResult(msrest.serialization.Model):
    """List of connection states snapshots.

    :param states: Information about connection states.
    :type states: list[~azure.mgmt.network.v2018_01_01.models.ConnectionStateSnapshot]
    """

    _attribute_map = {
        'states': {'key': 'states', 'type': '[ConnectionStateSnapshot]'},
    }

    def __init__(
        self,
        *,
        states: Optional[List["ConnectionStateSnapshot"]] = None,
        **kwargs
    ):
        super(ConnectionMonitorQueryResult, self).__init__(**kwargs)
        self.states = states


class ConnectionMonitorResult(msrest.serialization.Model):
    """Information about the connection monitor.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the connection monitor.
    :vartype name: str
    :ivar id: ID of the connection monitor.
    :vartype id: str
    :param etag:
    :type etag: str
    :ivar type: Connection monitor type.
    :vartype type: str
    :param location: Connection monitor location.
    :type location: str
    :param tags: A set of tags. Connection monitor tags.
    :type tags: dict[str, str]
    :param source: Describes the source of connection monitor.
    :type source: ~azure.mgmt.network.v2018_01_01.models.ConnectionMonitorSource
    :param destination: Describes the destination of connection monitor.
    :type destination: ~azure.mgmt.network.v2018_01_01.models.ConnectionMonitorDestination
    :param auto_start: Determines if the connection monitor will start automatically once created.
    :type auto_start: bool
    :param monitoring_interval_in_seconds: Monitoring interval in seconds.
    :type monitoring_interval_in_seconds: int
    :param provisioning_state: The provisioning state of the connection monitor. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :type provisioning_state: str or ~azure.mgmt.network.v2018_01_01.models.ProvisioningState
    :param start_time: The date and time when the connection monitor was started.
    :type start_time: ~datetime.datetime
    :param monitoring_status: The monitoring status of the connection monitor.
    :type monitoring_status: str
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'source': {'key': 'properties.source', 'type': 'ConnectionMonitorSource'},
        'destination': {'key': 'properties.destination', 'type': 'ConnectionMonitorDestination'},
        'auto_start': {'key': 'properties.autoStart', 'type': 'bool'},
        'monitoring_interval_in_seconds': {'key': 'properties.monitoringIntervalInSeconds', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'monitoring_status': {'key': 'properties.monitoringStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = "A unique read-only string that changes whenever the resource is updated.",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        source: Optional["ConnectionMonitorSource"] = None,
        destination: Optional["ConnectionMonitorDestination"] = None,
        auto_start: Optional[bool] = True,
        monitoring_interval_in_seconds: Optional[int] = 60,
        provisioning_state: Optional[Union[str, "ProvisioningState"]] = None,
        start_time: Optional[datetime.datetime] = None,
        monitoring_status: Optional[str] = None,
        **kwargs
    ):
        super(ConnectionMonitorResult, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.etag = etag
        self.type = None
        self.location = location
        self.tags = tags
        self.source = source
        self.destination = destination
        self.auto_start = auto_start
        self.monitoring_interval_in_seconds = monitoring_interval_in_seconds
        self.provisioning_state = provisioning_state
        self.start_time = start_time
        self.monitoring_status = monitoring_status


class ConnectionMonitorResultProperties(ConnectionMonitorParameters):
    """Describes the properties of a connection monitor.

    All required parameters must be populated in order to send to Azure.

    :param source: Required. Describes the source of connection monitor.
    :type source: ~azure.mgmt.network.v2018_01_01.models.ConnectionMonitorSource
    :param destination: Required. Describes the destination of connection monitor.
    :type destination: ~azure.mgmt.network.v2018_01_01.models.ConnectionMonitorDestination
    :param auto_start: Determines if the connection monitor will start automatically once created.
    :type auto_start: bool
    :param monitoring_interval_in_seconds: Monitoring interval in seconds.
    :type monitoring_interval_in_seconds: int
    :param provisioning_state: The provisioning state of the connection monitor. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :type provisioning_state: str or ~azure.mgmt.network.v2018_01_01.models.ProvisioningState
    :param start_time: The date and time when the connection monitor was started.
    :type start_time: ~datetime.datetime
    :param monitoring_status: The monitoring status of the connection monitor.
    :type monitoring_status: str
    """

    _validation = {
        'source': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'ConnectionMonitorSource'},
        'destination': {'key': 'destination', 'type': 'ConnectionMonitorDestination'},
        'auto_start': {'key': 'autoStart', 'type': 'bool'},
        'monitoring_interval_in_seconds': {'key': 'monitoringIntervalInSeconds', 'type': 'int'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'monitoring_status': {'key': 'monitoringStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source: "ConnectionMonitorSource",
        destination: "ConnectionMonitorDestination",
        auto_start: Optional[bool] = True,
        monitoring_interval_in_seconds: Optional[int] = 60,
        provisioning_state: Optional[Union[str, "ProvisioningState"]] = None,
        start_time: Optional[datetime.datetime] = None,
        monitoring_status: Optional[str] = None,
        **kwargs
    ):
        super(ConnectionMonitorResultProperties, self).__init__(source=source, destination=destination, auto_start=auto_start, monitoring_interval_in_seconds=monitoring_interval_in_seconds, **kwargs)
        self.provisioning_state = provisioning_state
        self.start_time = start_time
        self.monitoring_status = monitoring_status


class ConnectionMonitorSource(msrest.serialization.Model):
    """Describes the source of connection monitor.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: Required. The ID of the resource used as the source by connection monitor.
    :type resource_id: str
    :param port: The source port used by connection monitor.
    :type port: int
    """

    _validation = {
        'resource_id': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        resource_id: str,
        port: Optional[int] = None,
        **kwargs
    ):
        super(ConnectionMonitorSource, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.port = port


class ConnectionResetSharedKey(msrest.serialization.Model):
    """The virtual network connection reset shared key.

    All required parameters must be populated in order to send to Azure.

    :param key_length: Required. The virtual network connection reset shared key length, should
     between 1 and 128.
    :type key_length: int
    """

    _validation = {
        'key_length': {'required': True, 'maximum': 128, 'minimum': 1},
    }

    _attribute_map = {
        'key_length': {'key': 'keyLength', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        key_length: int,
        **kwargs
    ):
        super(ConnectionResetSharedKey, self).__init__(**kwargs)
        self.key_length = key_length


class ConnectionSharedKey(msrest.serialization.Model):
    """Response for GetConnectionSharedKey API service call.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The virtual network connection shared key value.
    :type value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        **kwargs
    ):
        super(ConnectionSharedKey, self).__init__(**kwargs)
        self.value = value


class ConnectionStateSnapshot(msrest.serialization.Model):
    """Connection state snapshot.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param connection_state: The connection state. Possible values include: "Reachable",
     "Unreachable", "Unknown".
    :type connection_state: str or ~azure.mgmt.network.v2018_01_01.models.ConnectionState
    :param start_time: The start time of the connection snapshot.
    :type start_time: ~datetime.datetime
    :param end_time: The end time of the connection snapshot.
    :type end_time: ~datetime.datetime
    :param evaluation_state: Connectivity analysis evaluation state. Possible values include:
     "NotStarted", "InProgress", "Completed".
    :type evaluation_state: str or ~azure.mgmt.network.v2018_01_01.models.EvaluationState
    :ivar hops: List of hops between the source and the destination.
    :vartype hops: list[~azure.mgmt.network.v2018_01_01.models.ConnectivityHop]
    """

    _validation = {
        'hops': {'readonly': True},
    }

    _attribute_map = {
        'connection_state': {'key': 'connectionState', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'evaluation_state': {'key': 'evaluationState', 'type': 'str'},
        'hops': {'key': 'hops', 'type': '[ConnectivityHop]'},
    }

    def __init__(
        self,
        *,
        connection_state: Optional[Union[str, "ConnectionState"]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        evaluation_state: Optional[Union[str, "EvaluationState"]] = None,
        **kwargs
    ):
        super(ConnectionStateSnapshot, self).__init__(**kwargs)
        self.connection_state = connection_state
        self.start_time = start_time
        self.end_time = end_time
        self.evaluation_state = evaluation_state
        self.hops = None


class ConnectivityDestination(msrest.serialization.Model):
    """Parameters that define destination of connection.

    :param resource_id: The ID of the resource to which a connection attempt will be made.
    :type resource_id: str
    :param address: The IP address or URI the resource to which a connection attempt will be made.
    :type address: str
    :param port: Port on which check connectivity will be performed.
    :type port: int
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        address: Optional[str] = None,
        port: Optional[int] = None,
        **kwargs
    ):
        super(ConnectivityDestination, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.address = address
        self.port = port


class ConnectivityHop(msrest.serialization.Model):
    """Information about a hop between the source and the destination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the hop.
    :vartype type: str
    :ivar id: The ID of the hop.
    :vartype id: str
    :ivar address: The IP address of the hop.
    :vartype address: str
    :ivar resource_id: The ID of the resource corresponding to this hop.
    :vartype resource_id: str
    :ivar next_hop_ids: List of next hop identifiers.
    :vartype next_hop_ids: list[str]
    :ivar issues: List of issues.
    :vartype issues: list[~azure.mgmt.network.v2018_01_01.models.ConnectivityIssue]
    """

    _validation = {
        'type': {'readonly': True},
        'id': {'readonly': True},
        'address': {'readonly': True},
        'resource_id': {'readonly': True},
        'next_hop_ids': {'readonly': True},
        'issues': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'next_hop_ids': {'key': 'nextHopIds', 'type': '[str]'},
        'issues': {'key': 'issues', 'type': '[ConnectivityIssue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectivityHop, self).__init__(**kwargs)
        self.type = None
        self.id = None
        self.address = None
        self.resource_id = None
        self.next_hop_ids = None
        self.issues = None


class ConnectivityInformation(msrest.serialization.Model):
    """Information on the connectivity status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hops: List of hops between the source and the destination.
    :vartype hops: list[~azure.mgmt.network.v2018_01_01.models.ConnectivityHop]
    :ivar connection_status: The connection status. Possible values include: "Unknown",
     "Connected", "Disconnected", "Degraded".
    :vartype connection_status: str or ~azure.mgmt.network.v2018_01_01.models.ConnectionStatus
    :ivar avg_latency_in_ms: Average latency in milliseconds.
    :vartype avg_latency_in_ms: int
    :ivar min_latency_in_ms: Minimum latency in milliseconds.
    :vartype min_latency_in_ms: int
    :ivar max_latency_in_ms: Maximum latency in milliseconds.
    :vartype max_latency_in_ms: int
    :ivar probes_sent: Total number of probes sent.
    :vartype probes_sent: int
    :ivar probes_failed: Number of failed probes.
    :vartype probes_failed: int
    """

    _validation = {
        'hops': {'readonly': True},
        'connection_status': {'readonly': True},
        'avg_latency_in_ms': {'readonly': True},
        'min_latency_in_ms': {'readonly': True},
        'max_latency_in_ms': {'readonly': True},
        'probes_sent': {'readonly': True},
        'probes_failed': {'readonly': True},
    }

    _attribute_map = {
        'hops': {'key': 'hops', 'type': '[ConnectivityHop]'},
        'connection_status': {'key': 'connectionStatus', 'type': 'str'},
        'avg_latency_in_ms': {'key': 'avgLatencyInMs', 'type': 'int'},
        'min_latency_in_ms': {'key': 'minLatencyInMs', 'type': 'int'},
        'max_latency_in_ms': {'key': 'maxLatencyInMs', 'type': 'int'},
        'probes_sent': {'key': 'probesSent', 'type': 'int'},
        'probes_failed': {'key': 'probesFailed', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectivityInformation, self).__init__(**kwargs)
        self.hops = None
        self.connection_status = None
        self.avg_latency_in_ms = None
        self.min_latency_in_ms = None
        self.max_latency_in_ms = None
        self.probes_sent = None
        self.probes_failed = None


class ConnectivityIssue(msrest.serialization.Model):
    """Information about an issue encountered in the process of checking for connectivity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the issue. Possible values include: "Local", "Inbound", "Outbound".
    :vartype origin: str or ~azure.mgmt.network.v2018_01_01.models.Origin
    :ivar severity: The severity of the issue. Possible values include: "Error", "Warning".
    :vartype severity: str or ~azure.mgmt.network.v2018_01_01.models.Severity
    :ivar type: The type of issue. Possible values include: "Unknown", "AgentStopped",
     "GuestFirewall", "DnsResolution", "SocketBind", "NetworkSecurityRule", "UserDefinedRoute",
     "PortThrottled", "Platform".
    :vartype type: str or ~azure.mgmt.network.v2018_01_01.models.IssueType
    :ivar context: Provides additional context on the issue.
    :vartype context: list[dict[str, str]]
    """

    _validation = {
        'origin': {'readonly': True},
        'severity': {'readonly': True},
        'type': {'readonly': True},
        'context': {'readonly': True},
    }

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'context': {'key': 'context', 'type': '[{str}]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectivityIssue, self).__init__(**kwargs)
        self.origin = None
        self.severity = None
        self.type = None
        self.context = None


class ConnectivityParameters(msrest.serialization.Model):
    """Parameters that determine how the connectivity check will be performed.

    All required parameters must be populated in order to send to Azure.

    :param source: Required. Parameters that define the source of the connection.
    :type source: ~azure.mgmt.network.v2018_01_01.models.ConnectivitySource
    :param destination: Required. Parameters that define destination of connection.
    :type destination: ~azure.mgmt.network.v2018_01_01.models.ConnectivityDestination
    """

    _validation = {
        'source': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'ConnectivitySource'},
        'destination': {'key': 'destination', 'type': 'ConnectivityDestination'},
    }

    def __init__(
        self,
        *,
        source: "ConnectivitySource",
        destination: "ConnectivityDestination",
        **kwargs
    ):
        super(ConnectivityParameters, self).__init__(**kwargs)
        self.source = source
        self.destination = destination


class ConnectivitySource(msrest.serialization.Model):
    """Parameters that define the source of the connection.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: Required. The ID of the resource from which a connectivity check will be
     initiated.
    :type resource_id: str
    :param port: The source port from which a connectivity check will be performed.
    :type port: int
    """

    _validation = {
        'resource_id': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        resource_id: str,
        port: Optional[int] = None,
        **kwargs
    ):
        super(ConnectivitySource, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.port = port


class DhcpOptions(msrest.serialization.Model):
    """DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.

    :param dns_servers: The list of DNS servers IP addresses.
    :type dns_servers: list[str]
    """

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        dns_servers: Optional[List[str]] = None,
        **kwargs
    ):
        super(DhcpOptions, self).__init__(**kwargs)
        self.dns_servers = dns_servers


class Dimension(msrest.serialization.Model):
    """Dimension of the metric.

    :param name: The name of the dimension.
    :type name: str
    :param display_name: The display name of the dimension.
    :type display_name: str
    :param internal_name: The internal name of the dimension.
    :type internal_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'internal_name': {'key': 'internalName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        **kwargs
    ):
        super(Dimension, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name


class DnsNameAvailabilityResult(msrest.serialization.Model):
    """Response for the CheckDnsNameAvailability API service call.

    :param available: Domain availability (True/False).
    :type available: bool
    """

    _attribute_map = {
        'available': {'key': 'available', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        available: Optional[bool] = None,
        **kwargs
    ):
        super(DnsNameAvailabilityResult, self).__init__(**kwargs)
        self.available = available


class EffectiveNetworkSecurityGroup(msrest.serialization.Model):
    """Effective network security group.

    :param network_security_group: The ID of network security group that is applied.
    :type network_security_group: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param association: Associated resources.
    :type association:
     ~azure.mgmt.network.v2018_01_01.models.EffectiveNetworkSecurityGroupAssociation
    :param effective_security_rules: A collection of effective security rules.
    :type effective_security_rules:
     list[~azure.mgmt.network.v2018_01_01.models.EffectiveNetworkSecurityRule]
    :param tag_map: Mapping of tags to list of IP Addresses included within the tag.
    :type tag_map: str
    """

    _attribute_map = {
        'network_security_group': {'key': 'networkSecurityGroup', 'type': 'SubResource'},
        'association': {'key': 'association', 'type': 'EffectiveNetworkSecurityGroupAssociation'},
        'effective_security_rules': {'key': 'effectiveSecurityRules', 'type': '[EffectiveNetworkSecurityRule]'},
        'tag_map': {'key': 'tagMap', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        network_security_group: Optional["SubResource"] = None,
        association: Optional["EffectiveNetworkSecurityGroupAssociation"] = None,
        effective_security_rules: Optional[List["EffectiveNetworkSecurityRule"]] = None,
        tag_map: Optional[str] = None,
        **kwargs
    ):
        super(EffectiveNetworkSecurityGroup, self).__init__(**kwargs)
        self.network_security_group = network_security_group
        self.association = association
        self.effective_security_rules = effective_security_rules
        self.tag_map = tag_map


class EffectiveNetworkSecurityGroupAssociation(msrest.serialization.Model):
    """The effective network security group association.

    :param subnet: The ID of the subnet if assigned.
    :type subnet: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param network_interface: The ID of the network interface if assigned.
    :type network_interface: ~azure.mgmt.network.v2018_01_01.models.SubResource
    """

    _attribute_map = {
        'subnet': {'key': 'subnet', 'type': 'SubResource'},
        'network_interface': {'key': 'networkInterface', 'type': 'SubResource'},
    }

    def __init__(
        self,
        *,
        subnet: Optional["SubResource"] = None,
        network_interface: Optional["SubResource"] = None,
        **kwargs
    ):
        super(EffectiveNetworkSecurityGroupAssociation, self).__init__(**kwargs)
        self.subnet = subnet
        self.network_interface = network_interface


class EffectiveNetworkSecurityGroupListResult(msrest.serialization.Model):
    """Response for list effective network security groups API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of effective network security groups.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.EffectiveNetworkSecurityGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EffectiveNetworkSecurityGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EffectiveNetworkSecurityGroup"]] = None,
        **kwargs
    ):
        super(EffectiveNetworkSecurityGroupListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class EffectiveNetworkSecurityRule(msrest.serialization.Model):
    """Effective network security rules.

    :param name: The name of the security rule specified by the user (if created by the user).
    :type name: str
    :param protocol: The network protocol this rule applies to. Possible values are: 'Tcp', 'Udp',
     and 'All'. Possible values include: "Tcp", "Udp", "All".
    :type protocol: str or ~azure.mgmt.network.v2018_01_01.models.EffectiveSecurityRuleProtocol
    :param source_port_range: The source port or range.
    :type source_port_range: str
    :param destination_port_range: The destination port or range.
    :type destination_port_range: str
    :param source_port_ranges: The source port ranges. Expected values include a single integer
     between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
    :type source_port_ranges: list[str]
    :param destination_port_ranges: The destination port ranges. Expected values include a single
     integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
    :type destination_port_ranges: list[str]
    :param source_address_prefix: The source address prefix.
    :type source_address_prefix: str
    :param destination_address_prefix: The destination address prefix.
    :type destination_address_prefix: str
    :param source_address_prefixes: The source address prefixes. Expected values include CIDR IP
     ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the
     asterisk (*).
    :type source_address_prefixes: list[str]
    :param destination_address_prefixes: The destination address prefixes. Expected values include
     CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and
     the asterisk (*).
    :type destination_address_prefixes: list[str]
    :param expanded_source_address_prefix: The expanded source address prefix.
    :type expanded_source_address_prefix: list[str]
    :param expanded_destination_address_prefix: Expanded destination address prefix.
    :type expanded_destination_address_prefix: list[str]
    :param access: Whether network traffic is allowed or denied. Possible values are: 'Allow' and
     'Deny'. Possible values include: "Allow", "Deny".
    :type access: str or ~azure.mgmt.network.v2018_01_01.models.SecurityRuleAccess
    :param priority: The priority of the rule.
    :type priority: int
    :param direction: The direction of the rule. Possible values are: 'Inbound and Outbound'.
     Possible values include: "Inbound", "Outbound".
    :type direction: str or ~azure.mgmt.network.v2018_01_01.models.SecurityRuleDirection
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'source_port_range': {'key': 'sourcePortRange', 'type': 'str'},
        'destination_port_range': {'key': 'destinationPortRange', 'type': 'str'},
        'source_port_ranges': {'key': 'sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'destinationPortRanges', 'type': '[str]'},
        'source_address_prefix': {'key': 'sourceAddressPrefix', 'type': 'str'},
        'destination_address_prefix': {'key': 'destinationAddressPrefix', 'type': 'str'},
        'source_address_prefixes': {'key': 'sourceAddressPrefixes', 'type': '[str]'},
        'destination_address_prefixes': {'key': 'destinationAddressPrefixes', 'type': '[str]'},
        'expanded_source_address_prefix': {'key': 'expandedSourceAddressPrefix', 'type': '[str]'},
        'expanded_destination_address_prefix': {'key': 'expandedDestinationAddressPrefix', 'type': '[str]'},
        'access': {'key': 'access', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'direction': {'key': 'direction', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        protocol: Optional[Union[str, "EffectiveSecurityRuleProtocol"]] = None,
        source_port_range: Optional[str] = None,
        destination_port_range: Optional[str] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        source_address_prefix: Optional[str] = None,
        destination_address_prefix: Optional[str] = None,
        source_address_prefixes: Optional[List[str]] = None,
        destination_address_prefixes: Optional[List[str]] = None,
        expanded_source_address_prefix: Optional[List[str]] = None,
        expanded_destination_address_prefix: Optional[List[str]] = None,
        access: Optional[Union[str, "SecurityRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "SecurityRuleDirection"]] = None,
        **kwargs
    ):
        super(EffectiveNetworkSecurityRule, self).__init__(**kwargs)
        self.name = name
        self.protocol = protocol
        self.source_port_range = source_port_range
        self.destination_port_range = destination_port_range
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.source_address_prefix = source_address_prefix
        self.destination_address_prefix = destination_address_prefix
        self.source_address_prefixes = source_address_prefixes
        self.destination_address_prefixes = destination_address_prefixes
        self.expanded_source_address_prefix = expanded_source_address_prefix
        self.expanded_destination_address_prefix = expanded_destination_address_prefix
        self.access = access
        self.priority = priority
        self.direction = direction


class EffectiveRoute(msrest.serialization.Model):
    """Effective Route.

    :param name: The name of the user defined route. This is optional.
    :type name: str
    :param source: Who created the route. Possible values are: 'Unknown', 'User',
     'VirtualNetworkGateway', and 'Default'. Possible values include: "Unknown", "User",
     "VirtualNetworkGateway", "Default".
    :type source: str or ~azure.mgmt.network.v2018_01_01.models.EffectiveRouteSource
    :param state: The value of effective route. Possible values are: 'Active' and 'Invalid'.
     Possible values include: "Active", "Invalid".
    :type state: str or ~azure.mgmt.network.v2018_01_01.models.EffectiveRouteState
    :param address_prefix: The address prefixes of the effective routes in CIDR notation.
    :type address_prefix: list[str]
    :param next_hop_ip_address: The IP address of the next hop of the effective route.
    :type next_hop_ip_address: list[str]
    :param next_hop_type: The type of Azure hop the packet should be sent to. Possible values are:
     'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'. Possible
     values include: "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", "None".
    :type next_hop_type: str or ~azure.mgmt.network.v2018_01_01.models.RouteNextHopType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'address_prefix': {'key': 'addressPrefix', 'type': '[str]'},
        'next_hop_ip_address': {'key': 'nextHopIpAddress', 'type': '[str]'},
        'next_hop_type': {'key': 'nextHopType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        source: Optional[Union[str, "EffectiveRouteSource"]] = None,
        state: Optional[Union[str, "EffectiveRouteState"]] = None,
        address_prefix: Optional[List[str]] = None,
        next_hop_ip_address: Optional[List[str]] = None,
        next_hop_type: Optional[Union[str, "RouteNextHopType"]] = None,
        **kwargs
    ):
        super(EffectiveRoute, self).__init__(**kwargs)
        self.name = name
        self.source = source
        self.state = state
        self.address_prefix = address_prefix
        self.next_hop_ip_address = next_hop_ip_address
        self.next_hop_type = next_hop_type


class EffectiveRouteListResult(msrest.serialization.Model):
    """Response for list effective route API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of effective routes.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.EffectiveRoute]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EffectiveRoute]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EffectiveRoute"]] = None,
        **kwargs
    ):
        super(EffectiveRouteListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class EndpointServiceResult(SubResource):
    """Endpoint service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Name of the endpoint service.
    :vartype name: str
    :ivar type: Type of the endpoint service.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(EndpointServiceResult, self).__init__(id=id, **kwargs)
        self.name = None
        self.type = None


class EndpointServicesListResult(msrest.serialization.Model):
    """Response for the ListAvailableEndpointServices API service call.

    :param value: List of available endpoint services in a region.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.EndpointServiceResult]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EndpointServiceResult]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EndpointServiceResult"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(EndpointServicesListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Error(msrest.serialization.Model):
    """Error.

    :param code:
    :type code: str
    :param message:
    :type message: str
    :param target:
    :type target: str
    :param details:
    :type details: list[~azure.mgmt.network.v2018_01_01.models.ErrorDetails]
    :param inner_error:
    :type inner_error: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetails]'},
        'inner_error': {'key': 'innerError', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["ErrorDetails"]] = None,
        inner_error: Optional[str] = None,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.inner_error = inner_error


class ErrorDetails(msrest.serialization.Model):
    """ErrorDetails.

    :param code:
    :type code: str
    :param target:
    :type target: str
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class ExpressRouteCircuit(Resource):
    """ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The SKU.
    :type sku: ~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitSku
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param allow_classic_operations: Allow classic operations.
    :type allow_classic_operations: bool
    :param circuit_provisioning_state: The CircuitProvisioningState state of the resource.
    :type circuit_provisioning_state: str
    :param service_provider_provisioning_state: The ServiceProviderProvisioningState state of the
     resource. Possible values are 'NotProvisioned', 'Provisioning', 'Provisioned', and
     'Deprovisioning'. Possible values include: "NotProvisioned", "Provisioning", "Provisioned",
     "Deprovisioning".
    :type service_provider_provisioning_state: str or
     ~azure.mgmt.network.v2018_01_01.models.ServiceProviderProvisioningState
    :param authorizations: The list of authorizations.
    :type authorizations:
     list[~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitAuthorization]
    :param peerings: The list of peerings.
    :type peerings: list[~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitPeering]
    :param service_key: The ServiceKey.
    :type service_key: str
    :param service_provider_notes: The ServiceProviderNotes.
    :type service_provider_notes: str
    :param service_provider_properties: The ServiceProviderProperties.
    :type service_provider_properties:
     ~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitServiceProviderProperties
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param gateway_manager_etag: The GatewayManager Etag.
    :type gateway_manager_etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'ExpressRouteCircuitSku'},
        'etag': {'key': 'etag', 'type': 'str'},
        'allow_classic_operations': {'key': 'properties.allowClassicOperations', 'type': 'bool'},
        'circuit_provisioning_state': {'key': 'properties.circuitProvisioningState', 'type': 'str'},
        'service_provider_provisioning_state': {'key': 'properties.serviceProviderProvisioningState', 'type': 'str'},
        'authorizations': {'key': 'properties.authorizations', 'type': '[ExpressRouteCircuitAuthorization]'},
        'peerings': {'key': 'properties.peerings', 'type': '[ExpressRouteCircuitPeering]'},
        'service_key': {'key': 'properties.serviceKey', 'type': 'str'},
        'service_provider_notes': {'key': 'properties.serviceProviderNotes', 'type': 'str'},
        'service_provider_properties': {'key': 'properties.serviceProviderProperties', 'type': 'ExpressRouteCircuitServiceProviderProperties'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'gateway_manager_etag': {'key': 'properties.gatewayManagerEtag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["ExpressRouteCircuitSku"] = None,
        allow_classic_operations: Optional[bool] = None,
        circuit_provisioning_state: Optional[str] = None,
        service_provider_provisioning_state: Optional[Union[str, "ServiceProviderProvisioningState"]] = None,
        authorizations: Optional[List["ExpressRouteCircuitAuthorization"]] = None,
        peerings: Optional[List["ExpressRouteCircuitPeering"]] = None,
        service_key: Optional[str] = None,
        service_provider_notes: Optional[str] = None,
        service_provider_properties: Optional["ExpressRouteCircuitServiceProviderProperties"] = None,
        provisioning_state: Optional[str] = None,
        gateway_manager_etag: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuit, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.etag = None
        self.allow_classic_operations = allow_classic_operations
        self.circuit_provisioning_state = circuit_provisioning_state
        self.service_provider_provisioning_state = service_provider_provisioning_state
        self.authorizations = authorizations
        self.peerings = peerings
        self.service_key = service_key
        self.service_provider_notes = service_provider_notes
        self.service_provider_properties = service_provider_properties
        self.provisioning_state = provisioning_state
        self.gateway_manager_etag = gateway_manager_etag


class ExpressRouteCircuitArpTable(msrest.serialization.Model):
    """The ARP table associated with the ExpressRouteCircuit.

    :param age: Age.
    :type age: int
    :param interface: Interface.
    :type interface: str
    :param ip_address: The IP address.
    :type ip_address: str
    :param mac_address: The MAC address.
    :type mac_address: str
    """

    _attribute_map = {
        'age': {'key': 'age', 'type': 'int'},
        'interface': {'key': 'interface', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'mac_address': {'key': 'macAddress', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        age: Optional[int] = None,
        interface: Optional[str] = None,
        ip_address: Optional[str] = None,
        mac_address: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitArpTable, self).__init__(**kwargs)
        self.age = age
        self.interface = interface
        self.ip_address = ip_address
        self.mac_address = mac_address


class ExpressRouteCircuitAuthorization(SubResource):
    """Authorization in an ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param authorization_key: The authorization key.
    :type authorization_key: str
    :param authorization_use_status: AuthorizationUseStatus. Possible values are: 'Available' and
     'InUse'. Possible values include: "Available", "InUse".
    :type authorization_use_status: str or
     ~azure.mgmt.network.v2018_01_01.models.AuthorizationUseStatus
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'authorization_use_status': {'key': 'properties.authorizationUseStatus', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        authorization_key: Optional[str] = None,
        authorization_use_status: Optional[Union[str, "AuthorizationUseStatus"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitAuthorization, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.authorization_key = authorization_key
        self.authorization_use_status = authorization_use_status
        self.provisioning_state = provisioning_state


class ExpressRouteCircuitListResult(msrest.serialization.Model):
    """Response for ListExpressRouteCircuit API service call.

    :param value: A list of ExpressRouteCircuits in a resource group.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuit]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuit]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ExpressRouteCircuit"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitPeering(SubResource):
    """Peering in an ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param peering_type: The PeeringType. Possible values are: 'AzurePublicPeering',
     'AzurePrivatePeering', and 'MicrosoftPeering'. Possible values include: "AzurePublicPeering",
     "AzurePrivatePeering", "MicrosoftPeering".
    :type peering_type: str or
     ~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitPeeringType
    :param state: The state of peering. Possible values are: 'Disabled' and 'Enabled'. Possible
     values include: "Disabled", "Enabled".
    :type state: str or ~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitPeeringState
    :param azure_asn: The Azure ASN.
    :type azure_asn: int
    :param peer_asn: The peer ASN.
    :type peer_asn: long
    :param primary_peer_address_prefix: The primary address prefix.
    :type primary_peer_address_prefix: str
    :param secondary_peer_address_prefix: The secondary address prefix.
    :type secondary_peer_address_prefix: str
    :param primary_azure_port: The primary port.
    :type primary_azure_port: str
    :param secondary_azure_port: The secondary port.
    :type secondary_azure_port: str
    :param shared_key: The shared key.
    :type shared_key: str
    :param vlan_id: The VLAN ID.
    :type vlan_id: int
    :param microsoft_peering_config: The Microsoft peering configuration.
    :type microsoft_peering_config:
     ~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitPeeringConfig
    :param stats: Gets peering stats.
    :type stats: ~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitStats
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param gateway_manager_etag: The GatewayManager Etag.
    :type gateway_manager_etag: str
    :param last_modified_by: Gets whether the provider or the customer last modified the peering.
    :type last_modified_by: str
    :param route_filter: The reference of the RouteFilter resource.
    :type route_filter: ~azure.mgmt.network.v2018_01_01.models.RouteFilter
    :param ipv6_peering_config: The IPv6 peering configuration.
    :type ipv6_peering_config:
     ~azure.mgmt.network.v2018_01_01.models.Ipv6ExpressRouteCircuitPeeringConfig
    """

    _validation = {
        'etag': {'readonly': True},
        'peer_asn': {'maximum': 4294967295, 'minimum': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'peering_type': {'key': 'properties.peeringType', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'azure_asn': {'key': 'properties.azureASN', 'type': 'int'},
        'peer_asn': {'key': 'properties.peerASN', 'type': 'long'},
        'primary_peer_address_prefix': {'key': 'properties.primaryPeerAddressPrefix', 'type': 'str'},
        'secondary_peer_address_prefix': {'key': 'properties.secondaryPeerAddressPrefix', 'type': 'str'},
        'primary_azure_port': {'key': 'properties.primaryAzurePort', 'type': 'str'},
        'secondary_azure_port': {'key': 'properties.secondaryAzurePort', 'type': 'str'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'vlan_id': {'key': 'properties.vlanId', 'type': 'int'},
        'microsoft_peering_config': {'key': 'properties.microsoftPeeringConfig', 'type': 'ExpressRouteCircuitPeeringConfig'},
        'stats': {'key': 'properties.stats', 'type': 'ExpressRouteCircuitStats'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'gateway_manager_etag': {'key': 'properties.gatewayManagerEtag', 'type': 'str'},
        'last_modified_by': {'key': 'properties.lastModifiedBy', 'type': 'str'},
        'route_filter': {'key': 'properties.routeFilter', 'type': 'RouteFilter'},
        'ipv6_peering_config': {'key': 'properties.ipv6PeeringConfig', 'type': 'Ipv6ExpressRouteCircuitPeeringConfig'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        peering_type: Optional[Union[str, "ExpressRouteCircuitPeeringType"]] = None,
        state: Optional[Union[str, "ExpressRouteCircuitPeeringState"]] = None,
        azure_asn: Optional[int] = None,
        peer_asn: Optional[int] = None,
        primary_peer_address_prefix: Optional[str] = None,
        secondary_peer_address_prefix: Optional[str] = None,
        primary_azure_port: Optional[str] = None,
        secondary_azure_port: Optional[str] = None,
        shared_key: Optional[str] = None,
        vlan_id: Optional[int] = None,
        microsoft_peering_config: Optional["ExpressRouteCircuitPeeringConfig"] = None,
        stats: Optional["ExpressRouteCircuitStats"] = None,
        provisioning_state: Optional[str] = None,
        gateway_manager_etag: Optional[str] = None,
        last_modified_by: Optional[str] = None,
        route_filter: Optional["RouteFilter"] = None,
        ipv6_peering_config: Optional["Ipv6ExpressRouteCircuitPeeringConfig"] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitPeering, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.peering_type = peering_type
        self.state = state
        self.azure_asn = azure_asn
        self.peer_asn = peer_asn
        self.primary_peer_address_prefix = primary_peer_address_prefix
        self.secondary_peer_address_prefix = secondary_peer_address_prefix
        self.primary_azure_port = primary_azure_port
        self.secondary_azure_port = secondary_azure_port
        self.shared_key = shared_key
        self.vlan_id = vlan_id
        self.microsoft_peering_config = microsoft_peering_config
        self.stats = stats
        self.provisioning_state = provisioning_state
        self.gateway_manager_etag = gateway_manager_etag
        self.last_modified_by = last_modified_by
        self.route_filter = route_filter
        self.ipv6_peering_config = ipv6_peering_config


class ExpressRouteCircuitPeeringConfig(msrest.serialization.Model):
    """Specifies the peering configuration.

    :param advertised_public_prefixes: The reference of AdvertisedPublicPrefixes.
    :type advertised_public_prefixes: list[str]
    :param advertised_communities: The communities of bgp peering. Specified for microsoft peering.
    :type advertised_communities: list[str]
    :param advertised_public_prefixes_state: AdvertisedPublicPrefixState of the Peering resource.
     Possible values are 'NotConfigured', 'Configuring', 'Configured', and 'ValidationNeeded'.
     Possible values include: "NotConfigured", "Configuring", "Configured", "ValidationNeeded".
    :type advertised_public_prefixes_state: str or
     ~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState
    :param legacy_mode: The legacy mode of the peering.
    :type legacy_mode: int
    :param customer_asn: The CustomerASN of the peering.
    :type customer_asn: int
    :param routing_registry_name: The RoutingRegistryName of the configuration.
    :type routing_registry_name: str
    """

    _attribute_map = {
        'advertised_public_prefixes': {'key': 'advertisedPublicPrefixes', 'type': '[str]'},
        'advertised_communities': {'key': 'advertisedCommunities', 'type': '[str]'},
        'advertised_public_prefixes_state': {'key': 'advertisedPublicPrefixesState', 'type': 'str'},
        'legacy_mode': {'key': 'legacyMode', 'type': 'int'},
        'customer_asn': {'key': 'customerASN', 'type': 'int'},
        'routing_registry_name': {'key': 'routingRegistryName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        advertised_public_prefixes: Optional[List[str]] = None,
        advertised_communities: Optional[List[str]] = None,
        advertised_public_prefixes_state: Optional[Union[str, "ExpressRouteCircuitPeeringAdvertisedPublicPrefixState"]] = None,
        legacy_mode: Optional[int] = None,
        customer_asn: Optional[int] = None,
        routing_registry_name: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitPeeringConfig, self).__init__(**kwargs)
        self.advertised_public_prefixes = advertised_public_prefixes
        self.advertised_communities = advertised_communities
        self.advertised_public_prefixes_state = advertised_public_prefixes_state
        self.legacy_mode = legacy_mode
        self.customer_asn = customer_asn
        self.routing_registry_name = routing_registry_name


class ExpressRouteCircuitPeeringListResult(msrest.serialization.Model):
    """Response for ListPeering API service call retrieves all peerings that belong to an ExpressRouteCircuit.

    :param value: The peerings in an express route circuit.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitPeering]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitPeering]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ExpressRouteCircuitPeering"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitPeeringListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitRoutesTable(msrest.serialization.Model):
    """The routes table associated with the ExpressRouteCircuit.

    :param network: network.
    :type network: str
    :param next_hop: nextHop.
    :type next_hop: str
    :param loc_prf: locPrf.
    :type loc_prf: str
    :param weight: weight.
    :type weight: int
    :param path: path.
    :type path: str
    """

    _attribute_map = {
        'network': {'key': 'network', 'type': 'str'},
        'next_hop': {'key': 'nextHop', 'type': 'str'},
        'loc_prf': {'key': 'locPrf', 'type': 'str'},
        'weight': {'key': 'weight', 'type': 'int'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        network: Optional[str] = None,
        next_hop: Optional[str] = None,
        loc_prf: Optional[str] = None,
        weight: Optional[int] = None,
        path: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitRoutesTable, self).__init__(**kwargs)
        self.network = network
        self.next_hop = next_hop
        self.loc_prf = loc_prf
        self.weight = weight
        self.path = path


class ExpressRouteCircuitRoutesTableSummary(msrest.serialization.Model):
    """The routes table associated with the ExpressRouteCircuit.

    :param neighbor: Neighbor.
    :type neighbor: str
    :param v: BGP version number spoken to the neighbor.
    :type v: int
    :param as_property: Autonomous system number.
    :type as_property: int
    :param up_down: The length of time that the BGP session has been in the Established state, or
     the current status if not in the Established state.
    :type up_down: str
    :param state_pfx_rcd: Current state of the BGP session, and the number of prefixes that have
     been received from a neighbor or peer group.
    :type state_pfx_rcd: str
    """

    _attribute_map = {
        'neighbor': {'key': 'neighbor', 'type': 'str'},
        'v': {'key': 'v', 'type': 'int'},
        'as_property': {'key': 'as', 'type': 'int'},
        'up_down': {'key': 'upDown', 'type': 'str'},
        'state_pfx_rcd': {'key': 'statePfxRcd', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        neighbor: Optional[str] = None,
        v: Optional[int] = None,
        as_property: Optional[int] = None,
        up_down: Optional[str] = None,
        state_pfx_rcd: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitRoutesTableSummary, self).__init__(**kwargs)
        self.neighbor = neighbor
        self.v = v
        self.as_property = as_property
        self.up_down = up_down
        self.state_pfx_rcd = state_pfx_rcd


class ExpressRouteCircuitsArpTableListResult(msrest.serialization.Model):
    """Response for ListArpTable associated with the Express Route Circuits API.

    :param value: Gets list of the ARP table.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitArpTable]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitArpTable]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ExpressRouteCircuitArpTable"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitsArpTableListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitServiceProviderProperties(msrest.serialization.Model):
    """Contains ServiceProviderProperties in an ExpressRouteCircuit.

    :param service_provider_name: The serviceProviderName.
    :type service_provider_name: str
    :param peering_location: The peering location.
    :type peering_location: str
    :param bandwidth_in_mbps: The BandwidthInMbps.
    :type bandwidth_in_mbps: int
    """

    _attribute_map = {
        'service_provider_name': {'key': 'serviceProviderName', 'type': 'str'},
        'peering_location': {'key': 'peeringLocation', 'type': 'str'},
        'bandwidth_in_mbps': {'key': 'bandwidthInMbps', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        service_provider_name: Optional[str] = None,
        peering_location: Optional[str] = None,
        bandwidth_in_mbps: Optional[int] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitServiceProviderProperties, self).__init__(**kwargs)
        self.service_provider_name = service_provider_name
        self.peering_location = peering_location
        self.bandwidth_in_mbps = bandwidth_in_mbps


class ExpressRouteCircuitSku(msrest.serialization.Model):
    """Contains SKU in an ExpressRouteCircuit.

    :param name: The name of the SKU.
    :type name: str
    :param tier: The tier of the SKU. Possible values are 'Standard' and 'Premium'. Possible values
     include: "Standard", "Premium".
    :type tier: str or ~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitSkuTier
    :param family: The family of the SKU. Possible values are: 'UnlimitedData' and 'MeteredData'.
     Possible values include: "UnlimitedData", "MeteredData".
    :type family: str or ~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitSkuFamily
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[Union[str, "ExpressRouteCircuitSkuTier"]] = None,
        family: Optional[Union[str, "ExpressRouteCircuitSkuFamily"]] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitSku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.family = family


class ExpressRouteCircuitsRoutesTableListResult(msrest.serialization.Model):
    """Response for ListRoutesTable associated with the Express Route Circuits API.

    :param value: The list of routes table.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitRoutesTable]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitRoutesTable]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ExpressRouteCircuitRoutesTable"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitsRoutesTableListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitsRoutesTableSummaryListResult(msrest.serialization.Model):
    """Response for ListRoutesTable associated with the Express Route Circuits API.

    :param value: A list of the routes table.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitRoutesTableSummary]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitRoutesTableSummary]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ExpressRouteCircuitRoutesTableSummary"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitsRoutesTableSummaryListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitStats(msrest.serialization.Model):
    """Contains stats associated with the peering.

    :param primarybytes_in: Gets BytesIn of the peering.
    :type primarybytes_in: long
    :param primarybytes_out: Gets BytesOut of the peering.
    :type primarybytes_out: long
    :param secondarybytes_in: Gets BytesIn of the peering.
    :type secondarybytes_in: long
    :param secondarybytes_out: Gets BytesOut of the peering.
    :type secondarybytes_out: long
    """

    _attribute_map = {
        'primarybytes_in': {'key': 'primarybytesIn', 'type': 'long'},
        'primarybytes_out': {'key': 'primarybytesOut', 'type': 'long'},
        'secondarybytes_in': {'key': 'secondarybytesIn', 'type': 'long'},
        'secondarybytes_out': {'key': 'secondarybytesOut', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        primarybytes_in: Optional[int] = None,
        primarybytes_out: Optional[int] = None,
        secondarybytes_in: Optional[int] = None,
        secondarybytes_out: Optional[int] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitStats, self).__init__(**kwargs)
        self.primarybytes_in = primarybytes_in
        self.primarybytes_out = primarybytes_out
        self.secondarybytes_in = secondarybytes_in
        self.secondarybytes_out = secondarybytes_out


class ExpressRouteServiceProvider(Resource):
    """A ExpressRouteResourceProvider object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param peering_locations: Get a list of peering locations.
    :type peering_locations: list[str]
    :param bandwidths_offered: Gets bandwidths offered.
    :type bandwidths_offered:
     list[~azure.mgmt.network.v2018_01_01.models.ExpressRouteServiceProviderBandwidthsOffered]
    :param provisioning_state: Gets the provisioning state of the resource.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'peering_locations': {'key': 'properties.peeringLocations', 'type': '[str]'},
        'bandwidths_offered': {'key': 'properties.bandwidthsOffered', 'type': '[ExpressRouteServiceProviderBandwidthsOffered]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        peering_locations: Optional[List[str]] = None,
        bandwidths_offered: Optional[List["ExpressRouteServiceProviderBandwidthsOffered"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteServiceProvider, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.peering_locations = peering_locations
        self.bandwidths_offered = bandwidths_offered
        self.provisioning_state = provisioning_state


class ExpressRouteServiceProviderBandwidthsOffered(msrest.serialization.Model):
    """Contains bandwidths offered in ExpressRouteServiceProvider resources.

    :param offer_name: The OfferName.
    :type offer_name: str
    :param value_in_mbps: The ValueInMbps.
    :type value_in_mbps: int
    """

    _attribute_map = {
        'offer_name': {'key': 'offerName', 'type': 'str'},
        'value_in_mbps': {'key': 'valueInMbps', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        offer_name: Optional[str] = None,
        value_in_mbps: Optional[int] = None,
        **kwargs
    ):
        super(ExpressRouteServiceProviderBandwidthsOffered, self).__init__(**kwargs)
        self.offer_name = offer_name
        self.value_in_mbps = value_in_mbps


class ExpressRouteServiceProviderListResult(msrest.serialization.Model):
    """Response for the ListExpressRouteServiceProvider API service call.

    :param value: A list of ExpressRouteResourceProvider resources.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.ExpressRouteServiceProvider]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteServiceProvider]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ExpressRouteServiceProvider"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteServiceProviderListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FlowLogInformation(msrest.serialization.Model):
    """Information on the configuration of flow log and traffic analytics (optional).

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The ID of the resource to configure for flow logging.
    :type target_resource_id: str
    :param network_watcher_flow_analytics_configuration: Parameters that define the configuration
     of traffic analytics.
    :type network_watcher_flow_analytics_configuration:
     ~azure.mgmt.network.v2018_01_01.models.TrafficAnalyticsConfigurationProperties
    :param storage_id: Required. ID of the storage account which is used to store the flow log.
    :type storage_id: str
    :param enabled: Required. Flag to enable/disable flow logging.
    :type enabled: bool
    :param retention_policy: Parameters that define the retention policy for flow log.
    :type retention_policy: ~azure.mgmt.network.v2018_01_01.models.RetentionPolicyParameters
    """

    _validation = {
        'target_resource_id': {'required': True},
        'storage_id': {'required': True},
        'enabled': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'network_watcher_flow_analytics_configuration': {'key': 'flowAnalyticsConfiguration.networkWatcherFlowAnalyticsConfiguration', 'type': 'TrafficAnalyticsConfigurationProperties'},
        'storage_id': {'key': 'properties.storageId', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'retention_policy': {'key': 'properties.retentionPolicy', 'type': 'RetentionPolicyParameters'},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        storage_id: str,
        enabled: bool,
        network_watcher_flow_analytics_configuration: Optional["TrafficAnalyticsConfigurationProperties"] = None,
        retention_policy: Optional["RetentionPolicyParameters"] = None,
        **kwargs
    ):
        super(FlowLogInformation, self).__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.network_watcher_flow_analytics_configuration = network_watcher_flow_analytics_configuration
        self.storage_id = storage_id
        self.enabled = enabled
        self.retention_policy = retention_policy


class FlowLogStatusParameters(msrest.serialization.Model):
    """Parameters that define a resource to query flow log and traffic analytics (optional) status.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The target resource where getting the flow logging and
     traffic analytics (optional) status.
    :type target_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        **kwargs
    ):
        super(FlowLogStatusParameters, self).__init__(**kwargs)
        self.target_resource_id = target_resource_id


class FrontendIPConfiguration(SubResource):
    """Frontend IP address of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param zones: A list of availability zones denoting the IP allocated for the resource needs to
     come from.
    :type zones: list[str]
    :ivar inbound_nat_rules: Read only. Inbound rules URIs that use this frontend IP.
    :vartype inbound_nat_rules: list[~azure.mgmt.network.v2018_01_01.models.SubResource]
    :ivar inbound_nat_pools: Read only. Inbound pools URIs that use this frontend IP.
    :vartype inbound_nat_pools: list[~azure.mgmt.network.v2018_01_01.models.SubResource]
    :ivar outbound_nat_rules: Read only. Outbound rules URIs that use this frontend IP.
    :vartype outbound_nat_rules: list[~azure.mgmt.network.v2018_01_01.models.SubResource]
    :ivar load_balancing_rules: Gets load balancing rules URIs that use this frontend IP.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2018_01_01.models.SubResource]
    :param private_ip_address: The private IP address of the IP configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The Private IP allocation method. Possible values are:
     'Static' and 'Dynamic'. Possible values include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2018_01_01.models.IPAllocationMethod
    :param subnet: The reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2018_01_01.models.Subnet
    :param public_ip_address: The reference of the Public IP resource.
    :type public_ip_address: ~azure.mgmt.network.v2018_01_01.models.PublicIPAddress
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'inbound_nat_rules': {'readonly': True},
        'inbound_nat_pools': {'readonly': True},
        'outbound_nat_rules': {'readonly': True},
        'load_balancing_rules': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'inbound_nat_rules': {'key': 'properties.inboundNatRules', 'type': '[SubResource]'},
        'inbound_nat_pools': {'key': 'properties.inboundNatPools', 'type': '[SubResource]'},
        'outbound_nat_rules': {'key': 'properties.outboundNatRules', 'type': '[SubResource]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        zones: Optional[List[str]] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "IPAllocationMethod"]] = None,
        subnet: Optional["Subnet"] = None,
        public_ip_address: Optional["PublicIPAddress"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(FrontendIPConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.zones = zones
        self.inbound_nat_rules = None
        self.inbound_nat_pools = None
        self.outbound_nat_rules = None
        self.load_balancing_rules = None
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state


class GatewayRoute(msrest.serialization.Model):
    """Gateway routing details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar local_address: The gateway's local address.
    :vartype local_address: str
    :ivar network: The route's network prefix.
    :vartype network: str
    :ivar next_hop: The route's next hop.
    :vartype next_hop: str
    :ivar source_peer: The peer this route was learned from.
    :vartype source_peer: str
    :ivar origin: The source this route was learned from.
    :vartype origin: str
    :ivar as_path: The route's AS path sequence.
    :vartype as_path: str
    :ivar weight: The route's weight.
    :vartype weight: int
    """

    _validation = {
        'local_address': {'readonly': True},
        'network': {'readonly': True},
        'next_hop': {'readonly': True},
        'source_peer': {'readonly': True},
        'origin': {'readonly': True},
        'as_path': {'readonly': True},
        'weight': {'readonly': True},
    }

    _attribute_map = {
        'local_address': {'key': 'localAddress', 'type': 'str'},
        'network': {'key': 'network', 'type': 'str'},
        'next_hop': {'key': 'nextHop', 'type': 'str'},
        'source_peer': {'key': 'sourcePeer', 'type': 'str'},
        'origin': {'key': 'origin', 'type': 'str'},
        'as_path': {'key': 'asPath', 'type': 'str'},
        'weight': {'key': 'weight', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GatewayRoute, self).__init__(**kwargs)
        self.local_address = None
        self.network = None
        self.next_hop = None
        self.source_peer = None
        self.origin = None
        self.as_path = None
        self.weight = None


class GatewayRouteListResult(msrest.serialization.Model):
    """List of virtual network gateway routes.

    :param value: List of gateway routes.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.GatewayRoute]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GatewayRoute]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["GatewayRoute"]] = None,
        **kwargs
    ):
        super(GatewayRouteListResult, self).__init__(**kwargs)
        self.value = value


class InboundNatPool(SubResource):
    """Inbound NAT pool of the load balancer.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param frontend_ip_configuration: A reference to frontend IP addresses.
    :type frontend_ip_configuration: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param protocol: The transport protocol for the endpoint. Possible values are 'Udp' or 'Tcp' or
     'All.'. Possible values include: "Udp", "Tcp", "All".
    :type protocol: str or ~azure.mgmt.network.v2018_01_01.models.TransportProtocol
    :param frontend_port_range_start: The first port number in the range of external ports that
     will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values
     range between 1 and 65534.
    :type frontend_port_range_start: int
    :param frontend_port_range_end: The last port number in the range of external ports that will
     be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
     between 1 and 65535.
    :type frontend_port_range_end: int
    :param backend_port: The port used for internal connections on the endpoint. Acceptable values
     are between 1 and 65535.
    :type backend_port: int
    :param idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :type idle_timeout_in_minutes: int
    :param enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :type enable_floating_ip: bool
    :param provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'frontend_port_range_start': {'key': 'properties.frontendPortRangeStart', 'type': 'int'},
        'frontend_port_range_end': {'key': 'properties.frontendPortRangeEnd', 'type': 'int'},
        'backend_port': {'key': 'properties.backendPort', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'enable_floating_ip': {'key': 'properties.enableFloatingIP', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        frontend_ip_configuration: Optional["SubResource"] = None,
        protocol: Optional[Union[str, "TransportProtocol"]] = None,
        frontend_port_range_start: Optional[int] = None,
        frontend_port_range_end: Optional[int] = None,
        backend_port: Optional[int] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        enable_floating_ip: Optional[bool] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(InboundNatPool, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.frontend_ip_configuration = frontend_ip_configuration
        self.protocol = protocol
        self.frontend_port_range_start = frontend_port_range_start
        self.frontend_port_range_end = frontend_port_range_end
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.provisioning_state = provisioning_state


class InboundNatRule(SubResource):
    """Inbound NAT rule of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param frontend_ip_configuration: A reference to frontend IP addresses.
    :type frontend_ip_configuration: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :ivar backend_ip_configuration: A reference to a private IP address defined on a network
     interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations
     is forwarded to the backend IP.
    :vartype backend_ip_configuration:
     ~azure.mgmt.network.v2018_01_01.models.NetworkInterfaceIPConfiguration
    :param protocol: The transport protocol for the endpoint. Possible values are 'Udp' or 'Tcp' or
     'All.'. Possible values include: "Udp", "Tcp", "All".
    :type protocol: str or ~azure.mgmt.network.v2018_01_01.models.TransportProtocol
    :param frontend_port: The port for the external endpoint. Port numbers for each rule must be
     unique within the Load Balancer. Acceptable values range from 1 to 65534.
    :type frontend_port: int
    :param backend_port: The port used for the internal endpoint. Acceptable values range from 1 to
     65535.
    :type backend_port: int
    :param idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :type idle_timeout_in_minutes: int
    :param enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :type enable_floating_ip: bool
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'backend_ip_configuration': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'backend_ip_configuration': {'key': 'properties.backendIPConfiguration', 'type': 'NetworkInterfaceIPConfiguration'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'int'},
        'backend_port': {'key': 'properties.backendPort', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'enable_floating_ip': {'key': 'properties.enableFloatingIP', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        frontend_ip_configuration: Optional["SubResource"] = None,
        protocol: Optional[Union[str, "TransportProtocol"]] = None,
        frontend_port: Optional[int] = None,
        backend_port: Optional[int] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        enable_floating_ip: Optional[bool] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(InboundNatRule, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.frontend_ip_configuration = frontend_ip_configuration
        self.backend_ip_configuration = None
        self.protocol = protocol
        self.frontend_port = frontend_port
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.provisioning_state = provisioning_state


class InboundNatRuleListResult(msrest.serialization.Model):
    """Response for ListInboundNatRule API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of inbound nat rules in a load balancer.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.InboundNatRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[InboundNatRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["InboundNatRule"]] = None,
        **kwargs
    ):
        super(InboundNatRuleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class IPAddressAvailabilityResult(msrest.serialization.Model):
    """Response for CheckIPAddressAvailability API service call.

    :param available: Private IP address availability.
    :type available: bool
    :param available_ip_addresses: Contains other available private IP addresses if the asked for
     address is taken.
    :type available_ip_addresses: list[str]
    """

    _attribute_map = {
        'available': {'key': 'available', 'type': 'bool'},
        'available_ip_addresses': {'key': 'availableIPAddresses', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        available: Optional[bool] = None,
        available_ip_addresses: Optional[List[str]] = None,
        **kwargs
    ):
        super(IPAddressAvailabilityResult, self).__init__(**kwargs)
        self.available = available
        self.available_ip_addresses = available_ip_addresses


class IPConfiguration(SubResource):
    """IP configuration.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param private_ip_address: The private IP address of the IP configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The private IP allocation method. Possible values are
     'Static' and 'Dynamic'. Possible values include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2018_01_01.models.IPAllocationMethod
    :param subnet: The reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2018_01_01.models.Subnet
    :param public_ip_address: The reference of the public IP resource.
    :type public_ip_address: ~azure.mgmt.network.v2018_01_01.models.PublicIPAddress
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "IPAllocationMethod"]] = None,
        subnet: Optional["Subnet"] = None,
        public_ip_address: Optional["PublicIPAddress"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(IPConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state


class IpsecPolicy(msrest.serialization.Model):
    """An IPSec Policy configuration for a virtual network gateway connection.

    All required parameters must be populated in order to send to Azure.

    :param sa_life_time_seconds: Required. The IPSec Security Association (also called Quick Mode
     or Phase 2 SA) lifetime in seconds for a site to site VPN tunnel.
    :type sa_life_time_seconds: int
    :param sa_data_size_kilobytes: Required. The IPSec Security Association (also called Quick Mode
     or Phase 2 SA) payload size in KB for a site to site VPN tunnel.
    :type sa_data_size_kilobytes: int
    :param ipsec_encryption: Required. The IPSec encryption algorithm (IKE phase 1). Possible
     values include: "None", "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES128", "GCMAES192",
     "GCMAES256".
    :type ipsec_encryption: str or ~azure.mgmt.network.v2018_01_01.models.IpsecEncryption
    :param ipsec_integrity: Required. The IPSec integrity algorithm (IKE phase 1). Possible values
     include: "MD5", "SHA1", "SHA256", "GCMAES128", "GCMAES192", "GCMAES256".
    :type ipsec_integrity: str or ~azure.mgmt.network.v2018_01_01.models.IpsecIntegrity
    :param ike_encryption: Required. The IKE encryption algorithm (IKE phase 2). Possible values
     include: "DES", "DES3", "AES128", "AES192", "AES256".
    :type ike_encryption: str or ~azure.mgmt.network.v2018_01_01.models.IkeEncryption
    :param ike_integrity: Required. The IKE integrity algorithm (IKE phase 2). Possible values
     include: "MD5", "SHA1", "SHA256", "SHA384".
    :type ike_integrity: str or ~azure.mgmt.network.v2018_01_01.models.IkeIntegrity
    :param dh_group: Required. The DH Groups used in IKE Phase 1 for initial SA. Possible values
     include: "None", "DHGroup1", "DHGroup2", "DHGroup14", "DHGroup2048", "ECP256", "ECP384",
     "DHGroup24".
    :type dh_group: str or ~azure.mgmt.network.v2018_01_01.models.DhGroup
    :param pfs_group: Required. The DH Groups used in IKE Phase 2 for new child SA. Possible values
     include: "None", "PFS1", "PFS2", "PFS2048", "ECP256", "ECP384", "PFS24".
    :type pfs_group: str or ~azure.mgmt.network.v2018_01_01.models.PfsGroup
    """

    _validation = {
        'sa_life_time_seconds': {'required': True},
        'sa_data_size_kilobytes': {'required': True},
        'ipsec_encryption': {'required': True},
        'ipsec_integrity': {'required': True},
        'ike_encryption': {'required': True},
        'ike_integrity': {'required': True},
        'dh_group': {'required': True},
        'pfs_group': {'required': True},
    }

    _attribute_map = {
        'sa_life_time_seconds': {'key': 'saLifeTimeSeconds', 'type': 'int'},
        'sa_data_size_kilobytes': {'key': 'saDataSizeKilobytes', 'type': 'int'},
        'ipsec_encryption': {'key': 'ipsecEncryption', 'type': 'str'},
        'ipsec_integrity': {'key': 'ipsecIntegrity', 'type': 'str'},
        'ike_encryption': {'key': 'ikeEncryption', 'type': 'str'},
        'ike_integrity': {'key': 'ikeIntegrity', 'type': 'str'},
        'dh_group': {'key': 'dhGroup', 'type': 'str'},
        'pfs_group': {'key': 'pfsGroup', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sa_life_time_seconds: int,
        sa_data_size_kilobytes: int,
        ipsec_encryption: Union[str, "IpsecEncryption"],
        ipsec_integrity: Union[str, "IpsecIntegrity"],
        ike_encryption: Union[str, "IkeEncryption"],
        ike_integrity: Union[str, "IkeIntegrity"],
        dh_group: Union[str, "DhGroup"],
        pfs_group: Union[str, "PfsGroup"],
        **kwargs
    ):
        super(IpsecPolicy, self).__init__(**kwargs)
        self.sa_life_time_seconds = sa_life_time_seconds
        self.sa_data_size_kilobytes = sa_data_size_kilobytes
        self.ipsec_encryption = ipsec_encryption
        self.ipsec_integrity = ipsec_integrity
        self.ike_encryption = ike_encryption
        self.ike_integrity = ike_integrity
        self.dh_group = dh_group
        self.pfs_group = pfs_group


class IpTag(msrest.serialization.Model):
    """Contains the IpTag associated with the public IP address.

    :param ip_tag_type: Gets or sets the ipTag type: Example FirstPartyUsage.
    :type ip_tag_type: str
    :param tag: Gets or sets value of the IpTag associated with the public IP. Example SQL, Storage
     etc.
    :type tag: str
    """

    _attribute_map = {
        'ip_tag_type': {'key': 'ipTagType', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ip_tag_type: Optional[str] = None,
        tag: Optional[str] = None,
        **kwargs
    ):
        super(IpTag, self).__init__(**kwargs)
        self.ip_tag_type = ip_tag_type
        self.tag = tag


class Ipv6ExpressRouteCircuitPeeringConfig(msrest.serialization.Model):
    """Contains IPv6 peering config.

    :param primary_peer_address_prefix: The primary address prefix.
    :type primary_peer_address_prefix: str
    :param secondary_peer_address_prefix: The secondary address prefix.
    :type secondary_peer_address_prefix: str
    :param microsoft_peering_config: The Microsoft peering configuration.
    :type microsoft_peering_config:
     ~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitPeeringConfig
    :param route_filter: The reference of the RouteFilter resource.
    :type route_filter: ~azure.mgmt.network.v2018_01_01.models.RouteFilter
    :param state: The state of peering. Possible values are: 'Disabled' and 'Enabled'. Possible
     values include: "Disabled", "Enabled".
    :type state: str or ~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitPeeringState
    """

    _attribute_map = {
        'primary_peer_address_prefix': {'key': 'primaryPeerAddressPrefix', 'type': 'str'},
        'secondary_peer_address_prefix': {'key': 'secondaryPeerAddressPrefix', 'type': 'str'},
        'microsoft_peering_config': {'key': 'microsoftPeeringConfig', 'type': 'ExpressRouteCircuitPeeringConfig'},
        'route_filter': {'key': 'routeFilter', 'type': 'RouteFilter'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary_peer_address_prefix: Optional[str] = None,
        secondary_peer_address_prefix: Optional[str] = None,
        microsoft_peering_config: Optional["ExpressRouteCircuitPeeringConfig"] = None,
        route_filter: Optional["RouteFilter"] = None,
        state: Optional[Union[str, "ExpressRouteCircuitPeeringState"]] = None,
        **kwargs
    ):
        super(Ipv6ExpressRouteCircuitPeeringConfig, self).__init__(**kwargs)
        self.primary_peer_address_prefix = primary_peer_address_prefix
        self.secondary_peer_address_prefix = secondary_peer_address_prefix
        self.microsoft_peering_config = microsoft_peering_config
        self.route_filter = route_filter
        self.state = state


class LoadBalancer(Resource):
    """LoadBalancer resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The load balancer SKU.
    :type sku: ~azure.mgmt.network.v2018_01_01.models.LoadBalancerSku
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param frontend_ip_configurations: Object representing the frontend IPs to be used for the load
     balancer.
    :type frontend_ip_configurations:
     list[~azure.mgmt.network.v2018_01_01.models.FrontendIPConfiguration]
    :param backend_address_pools: Collection of backend address pools used by a load balancer.
    :type backend_address_pools: list[~azure.mgmt.network.v2018_01_01.models.BackendAddressPool]
    :param load_balancing_rules: Object collection representing the load balancing rules Gets the
     provisioning.
    :type load_balancing_rules: list[~azure.mgmt.network.v2018_01_01.models.LoadBalancingRule]
    :param probes: Collection of probe objects used in the load balancer.
    :type probes: list[~azure.mgmt.network.v2018_01_01.models.Probe]
    :param inbound_nat_rules: Collection of inbound NAT Rules used by a load balancer. Defining
     inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT
     pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are
     associated with individual virtual machines cannot reference an Inbound NAT pool. They have to
     reference individual inbound NAT rules.
    :type inbound_nat_rules: list[~azure.mgmt.network.v2018_01_01.models.InboundNatRule]
    :param inbound_nat_pools: Defines an external port range for inbound NAT to a single backend
     port on NICs associated with a load balancer. Inbound NAT rules are created automatically for
     each NIC associated with the Load Balancer using an external port from this range. Defining an
     Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound Nat rules.
     Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with
     individual virtual machines cannot reference an inbound NAT pool. They have to reference
     individual inbound NAT rules.
    :type inbound_nat_pools: list[~azure.mgmt.network.v2018_01_01.models.InboundNatPool]
    :param outbound_nat_rules: The outbound NAT rules.
    :type outbound_nat_rules: list[~azure.mgmt.network.v2018_01_01.models.OutboundNatRule]
    :param resource_guid: The resource GUID property of the load balancer resource.
    :type resource_guid: str
    :param provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'LoadBalancerSku'},
        'etag': {'key': 'etag', 'type': 'str'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[FrontendIPConfiguration]'},
        'backend_address_pools': {'key': 'properties.backendAddressPools', 'type': '[BackendAddressPool]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[LoadBalancingRule]'},
        'probes': {'key': 'properties.probes', 'type': '[Probe]'},
        'inbound_nat_rules': {'key': 'properties.inboundNatRules', 'type': '[InboundNatRule]'},
        'inbound_nat_pools': {'key': 'properties.inboundNatPools', 'type': '[InboundNatPool]'},
        'outbound_nat_rules': {'key': 'properties.outboundNatRules', 'type': '[OutboundNatRule]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["LoadBalancerSku"] = None,
        etag: Optional[str] = None,
        frontend_ip_configurations: Optional[List["FrontendIPConfiguration"]] = None,
        backend_address_pools: Optional[List["BackendAddressPool"]] = None,
        load_balancing_rules: Optional[List["LoadBalancingRule"]] = None,
        probes: Optional[List["Probe"]] = None,
        inbound_nat_rules: Optional[List["InboundNatRule"]] = None,
        inbound_nat_pools: Optional[List["InboundNatPool"]] = None,
        outbound_nat_rules: Optional[List["OutboundNatRule"]] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(LoadBalancer, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.etag = etag
        self.frontend_ip_configurations = frontend_ip_configurations
        self.backend_address_pools = backend_address_pools
        self.load_balancing_rules = load_balancing_rules
        self.probes = probes
        self.inbound_nat_rules = inbound_nat_rules
        self.inbound_nat_pools = inbound_nat_pools
        self.outbound_nat_rules = outbound_nat_rules
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class LoadBalancerBackendAddressPoolListResult(msrest.serialization.Model):
    """Response for ListBackendAddressPool API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of backend address pools in a load balancer.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.BackendAddressPool]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BackendAddressPool]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["BackendAddressPool"]] = None,
        **kwargs
    ):
        super(LoadBalancerBackendAddressPoolListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class LoadBalancerFrontendIPConfigurationListResult(msrest.serialization.Model):
    """Response for ListFrontendIPConfiguration API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of frontend IP configurations in a load balancer.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.FrontendIPConfiguration]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FrontendIPConfiguration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["FrontendIPConfiguration"]] = None,
        **kwargs
    ):
        super(LoadBalancerFrontendIPConfigurationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class LoadBalancerListResult(msrest.serialization.Model):
    """Response for ListLoadBalancers API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of load balancers in a resource group.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.LoadBalancer]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LoadBalancer]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["LoadBalancer"]] = None,
        **kwargs
    ):
        super(LoadBalancerListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class LoadBalancerLoadBalancingRuleListResult(msrest.serialization.Model):
    """Response for ListLoadBalancingRule API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of load balancing rules in a load balancer.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.LoadBalancingRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LoadBalancingRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["LoadBalancingRule"]] = None,
        **kwargs
    ):
        super(LoadBalancerLoadBalancingRuleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class LoadBalancerProbeListResult(msrest.serialization.Model):
    """Response for ListProbe API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of probes in a load balancer.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.Probe]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Probe]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Probe"]] = None,
        **kwargs
    ):
        super(LoadBalancerProbeListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class LoadBalancerSku(msrest.serialization.Model):
    """SKU of a load balancer.

    :param name: Name of a load balancer SKU. Possible values include: "Basic", "Standard".
    :type name: str or ~azure.mgmt.network.v2018_01_01.models.LoadBalancerSkuName
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "LoadBalancerSkuName"]] = None,
        **kwargs
    ):
        super(LoadBalancerSku, self).__init__(**kwargs)
        self.name = name


class LoadBalancingRule(SubResource):
    """A load balancing rule for a load balancer.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param frontend_ip_configuration: A reference to frontend IP addresses.
    :type frontend_ip_configuration: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param backend_address_pool: A reference to a pool of DIPs. Inbound traffic is randomly load
     balanced across IPs in the backend IPs.
    :type backend_address_pool: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param probe: The reference of the load balancer probe used by the load balancing rule.
    :type probe: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param protocol: The transport protocol for the endpoint. Possible values are 'Udp' or 'Tcp' or
     'All.'. Possible values include: "Udp", "Tcp", "All".
    :type protocol: str or ~azure.mgmt.network.v2018_01_01.models.TransportProtocol
    :param load_distribution: The load distribution policy for this rule. Possible values are
     'Default', 'SourceIP', and 'SourceIPProtocol'. Possible values include: "Default", "SourceIP",
     "SourceIPProtocol".
    :type load_distribution: str or ~azure.mgmt.network.v2018_01_01.models.LoadDistribution
    :param frontend_port: The port for the external endpoint. Port numbers for each rule must be
     unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0
     enables "Any Port".
    :type frontend_port: int
    :param backend_port: The port used for internal connections on the endpoint. Acceptable values
     are between 0 and 65535. Note that value 0 enables "Any Port".
    :type backend_port: int
    :param idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :type idle_timeout_in_minutes: int
    :param enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :type enable_floating_ip: bool
    :param disable_outbound_snat: Configures SNAT for the VMs in the backend pool to use the
     publicIP address specified in the frontend of the load balancing rule.
    :type disable_outbound_snat: bool
    :param provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'probe': {'key': 'properties.probe', 'type': 'SubResource'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'load_distribution': {'key': 'properties.loadDistribution', 'type': 'str'},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'int'},
        'backend_port': {'key': 'properties.backendPort', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'enable_floating_ip': {'key': 'properties.enableFloatingIP', 'type': 'bool'},
        'disable_outbound_snat': {'key': 'properties.disableOutboundSnat', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        frontend_ip_configuration: Optional["SubResource"] = None,
        backend_address_pool: Optional["SubResource"] = None,
        probe: Optional["SubResource"] = None,
        protocol: Optional[Union[str, "TransportProtocol"]] = None,
        load_distribution: Optional[Union[str, "LoadDistribution"]] = None,
        frontend_port: Optional[int] = None,
        backend_port: Optional[int] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        enable_floating_ip: Optional[bool] = None,
        disable_outbound_snat: Optional[bool] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(LoadBalancingRule, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.frontend_ip_configuration = frontend_ip_configuration
        self.backend_address_pool = backend_address_pool
        self.probe = probe
        self.protocol = protocol
        self.load_distribution = load_distribution
        self.frontend_port = frontend_port
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.disable_outbound_snat = disable_outbound_snat
        self.provisioning_state = provisioning_state


class LocalNetworkGateway(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param local_network_address_space: Local network site address space.
    :type local_network_address_space: ~azure.mgmt.network.v2018_01_01.models.AddressSpace
    :param gateway_ip_address: IP address of local network gateway.
    :type gateway_ip_address: str
    :param bgp_settings: Local network gateway's BGP speaker settings.
    :type bgp_settings: ~azure.mgmt.network.v2018_01_01.models.BgpSettings
    :param resource_guid: The resource GUID property of the LocalNetworkGateway resource.
    :type resource_guid: str
    :ivar provisioning_state: The provisioning state of the LocalNetworkGateway resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'local_network_address_space': {'key': 'properties.localNetworkAddressSpace', 'type': 'AddressSpace'},
        'gateway_ip_address': {'key': 'properties.gatewayIpAddress', 'type': 'str'},
        'bgp_settings': {'key': 'properties.bgpSettings', 'type': 'BgpSettings'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        local_network_address_space: Optional["AddressSpace"] = None,
        gateway_ip_address: Optional[str] = None,
        bgp_settings: Optional["BgpSettings"] = None,
        resource_guid: Optional[str] = None,
        **kwargs
    ):
        super(LocalNetworkGateway, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.local_network_address_space = local_network_address_space
        self.gateway_ip_address = gateway_ip_address
        self.bgp_settings = bgp_settings
        self.resource_guid = resource_guid
        self.provisioning_state = None


class LocalNetworkGatewayListResult(msrest.serialization.Model):
    """Response for ListLocalNetworkGateways API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of local network gateways that exists in a resource group.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.LocalNetworkGateway]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LocalNetworkGateway]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["LocalNetworkGateway"]] = None,
        **kwargs
    ):
        super(LocalNetworkGatewayListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class LogSpecification(msrest.serialization.Model):
    """Description of logging specification.

    :param name: The name of the specification.
    :type name: str
    :param display_name: The display name of the specification.
    :type display_name: str
    :param blob_duration: Duration of the blob.
    :type blob_duration: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs
    ):
        super(LogSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class MetricSpecification(msrest.serialization.Model):
    """Description of metrics specification.

    :param name: The name of the metric.
    :type name: str
    :param display_name: The display name of the metric.
    :type display_name: str
    :param display_description: The description of the metric.
    :type display_description: str
    :param unit: Units the metric to be displayed in.
    :type unit: str
    :param aggregation_type: The aggregation type.
    :type aggregation_type: str
    :param availabilities: List of availability.
    :type availabilities: list[~azure.mgmt.network.v2018_01_01.models.Availability]
    :param enable_regional_mdm_account: Whether regional MDM account enabled.
    :type enable_regional_mdm_account: bool
    :param fill_gap_with_zero: Whether gaps would be filled with zeros.
    :type fill_gap_with_zero: bool
    :param metric_filter_pattern: Pattern for the filter of the metric.
    :type metric_filter_pattern: str
    :param dimensions: List of dimensions.
    :type dimensions: list[~azure.mgmt.network.v2018_01_01.models.Dimension]
    :param is_internal: Whether the metric is internal.
    :type is_internal: bool
    :param source_mdm_account: The source MDM account.
    :type source_mdm_account: str
    :param source_mdm_namespace: The source MDM namespace.
    :type source_mdm_namespace: str
    :param resource_id_dimension_name_override: The resource Id dimension name override.
    :type resource_id_dimension_name_override: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'availabilities': {'key': 'availabilities', 'type': '[Availability]'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'bool'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'metric_filter_pattern': {'key': 'metricFilterPattern', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
        'is_internal': {'key': 'isInternal', 'type': 'bool'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
        'resource_id_dimension_name_override': {'key': 'resourceIdDimensionNameOverride', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        availabilities: Optional[List["Availability"]] = None,
        enable_regional_mdm_account: Optional[bool] = None,
        fill_gap_with_zero: Optional[bool] = None,
        metric_filter_pattern: Optional[str] = None,
        dimensions: Optional[List["Dimension"]] = None,
        is_internal: Optional[bool] = None,
        source_mdm_account: Optional[str] = None,
        source_mdm_namespace: Optional[str] = None,
        resource_id_dimension_name_override: Optional[str] = None,
        **kwargs
    ):
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.availabilities = availabilities
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.fill_gap_with_zero = fill_gap_with_zero
        self.metric_filter_pattern = metric_filter_pattern
        self.dimensions = dimensions
        self.is_internal = is_internal
        self.source_mdm_account = source_mdm_account
        self.source_mdm_namespace = source_mdm_namespace
        self.resource_id_dimension_name_override = resource_id_dimension_name_override


class NetworkInterface(Resource):
    """A network interface in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param virtual_machine: The reference of a virtual machine.
    :type virtual_machine: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param network_security_group: The reference of the NetworkSecurityGroup resource.
    :type network_security_group: ~azure.mgmt.network.v2018_01_01.models.NetworkSecurityGroup
    :param ip_configurations: A list of IPConfigurations of the network interface.
    :type ip_configurations:
     list[~azure.mgmt.network.v2018_01_01.models.NetworkInterfaceIPConfiguration]
    :param dns_settings: The DNS settings in network interface.
    :type dns_settings: ~azure.mgmt.network.v2018_01_01.models.NetworkInterfaceDnsSettings
    :param mac_address: The MAC address of the network interface.
    :type mac_address: str
    :param primary: Gets whether this is a primary network interface on a virtual machine.
    :type primary: bool
    :param enable_accelerated_networking: If the network interface is accelerated networking
     enabled.
    :type enable_accelerated_networking: bool
    :param enable_ip_forwarding: Indicates whether IP forwarding is enabled on this network
     interface.
    :type enable_ip_forwarding: bool
    :param resource_guid: The resource GUID property of the network interface resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'virtual_machine': {'key': 'properties.virtualMachine', 'type': 'SubResource'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'NetworkSecurityGroup'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'NetworkInterfaceDnsSettings'},
        'mac_address': {'key': 'properties.macAddress', 'type': 'str'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'enable_accelerated_networking': {'key': 'properties.enableAcceleratedNetworking', 'type': 'bool'},
        'enable_ip_forwarding': {'key': 'properties.enableIPForwarding', 'type': 'bool'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        virtual_machine: Optional["SubResource"] = None,
        network_security_group: Optional["NetworkSecurityGroup"] = None,
        ip_configurations: Optional[List["NetworkInterfaceIPConfiguration"]] = None,
        dns_settings: Optional["NetworkInterfaceDnsSettings"] = None,
        mac_address: Optional[str] = None,
        primary: Optional[bool] = None,
        enable_accelerated_networking: Optional[bool] = None,
        enable_ip_forwarding: Optional[bool] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(NetworkInterface, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.virtual_machine = virtual_machine
        self.network_security_group = network_security_group
        self.ip_configurations = ip_configurations
        self.dns_settings = dns_settings
        self.mac_address = mac_address
        self.primary = primary
        self.enable_accelerated_networking = enable_accelerated_networking
        self.enable_ip_forwarding = enable_ip_forwarding
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class NetworkInterfaceAssociation(msrest.serialization.Model):
    """Network interface and its custom security rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Network interface ID.
    :vartype id: str
    :param security_rules: Collection of custom security rules.
    :type security_rules: list[~azure.mgmt.network.v2018_01_01.models.SecurityRule]
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'security_rules': {'key': 'securityRules', 'type': '[SecurityRule]'},
    }

    def __init__(
        self,
        *,
        security_rules: Optional[List["SecurityRule"]] = None,
        **kwargs
    ):
        super(NetworkInterfaceAssociation, self).__init__(**kwargs)
        self.id = None
        self.security_rules = security_rules


class NetworkInterfaceDnsSettings(msrest.serialization.Model):
    """DNS settings of a network interface.

    :param dns_servers: List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure
     provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be
     the only value in dnsServers collection.
    :type dns_servers: list[str]
    :param applied_dns_servers: If the VM that uses this NIC is part of an Availability Set, then
     this list will have the union of all DNS servers from all NICs that are part of the
     Availability Set. This property is what is configured on each of those VMs.
    :type applied_dns_servers: list[str]
    :param internal_dns_name_label: Relative DNS name for this NIC used for internal communications
     between VMs in the same virtual network.
    :type internal_dns_name_label: str
    :param internal_fqdn: Fully qualified DNS name supporting internal communications between VMs
     in the same virtual network.
    :type internal_fqdn: str
    :param internal_domain_name_suffix: Even if internalDnsNameLabel is not specified, a DNS entry
     is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the
     VM name with the value of internalDomainNameSuffix.
    :type internal_domain_name_suffix: str
    """

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
        'applied_dns_servers': {'key': 'appliedDnsServers', 'type': '[str]'},
        'internal_dns_name_label': {'key': 'internalDnsNameLabel', 'type': 'str'},
        'internal_fqdn': {'key': 'internalFqdn', 'type': 'str'},
        'internal_domain_name_suffix': {'key': 'internalDomainNameSuffix', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        dns_servers: Optional[List[str]] = None,
        applied_dns_servers: Optional[List[str]] = None,
        internal_dns_name_label: Optional[str] = None,
        internal_fqdn: Optional[str] = None,
        internal_domain_name_suffix: Optional[str] = None,
        **kwargs
    ):
        super(NetworkInterfaceDnsSettings, self).__init__(**kwargs)
        self.dns_servers = dns_servers
        self.applied_dns_servers = applied_dns_servers
        self.internal_dns_name_label = internal_dns_name_label
        self.internal_fqdn = internal_fqdn
        self.internal_domain_name_suffix = internal_domain_name_suffix


class NetworkInterfaceIPConfiguration(SubResource):
    """IPConfiguration in a network interface.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param application_gateway_backend_address_pools: The reference of
     ApplicationGatewayBackendAddressPool resource.
    :type application_gateway_backend_address_pools:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationGatewayBackendAddressPool]
    :param load_balancer_backend_address_pools: The reference of LoadBalancerBackendAddressPool
     resource.
    :type load_balancer_backend_address_pools:
     list[~azure.mgmt.network.v2018_01_01.models.BackendAddressPool]
    :param load_balancer_inbound_nat_rules: A list of references of LoadBalancerInboundNatRules.
    :type load_balancer_inbound_nat_rules:
     list[~azure.mgmt.network.v2018_01_01.models.InboundNatRule]
    :param private_ip_address: Private IP address of the IP configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: Defines how a private IP address is assigned. Possible
     values are: 'Static' and 'Dynamic'. Possible values include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2018_01_01.models.IPAllocationMethod
    :param private_ip_address_version: Available from Api-Version 2016-03-30 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Possible values include: "IPv4", "IPv6".
    :type private_ip_address_version: str or ~azure.mgmt.network.v2018_01_01.models.IPVersion
    :param subnet: Subnet bound to the IP configuration.
    :type subnet: ~azure.mgmt.network.v2018_01_01.models.Subnet
    :param primary: Gets whether this is a primary customer address on the network interface.
    :type primary: bool
    :param public_ip_address: Public IP address bound to the IP configuration.
    :type public_ip_address: ~azure.mgmt.network.v2018_01_01.models.PublicIPAddress
    :param application_security_groups: Application security groups in which the IP configuration
     is included.
    :type application_security_groups:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationSecurityGroup]
    :param provisioning_state: The provisioning state of the network interface IP configuration.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'application_gateway_backend_address_pools': {'key': 'properties.applicationGatewayBackendAddressPools', 'type': '[ApplicationGatewayBackendAddressPool]'},
        'load_balancer_backend_address_pools': {'key': 'properties.loadBalancerBackendAddressPools', 'type': '[BackendAddressPool]'},
        'load_balancer_inbound_nat_rules': {'key': 'properties.loadBalancerInboundNatRules', 'type': '[InboundNatRule]'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'private_ip_address_version': {'key': 'properties.privateIPAddressVersion', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'application_security_groups': {'key': 'properties.applicationSecurityGroups', 'type': '[ApplicationSecurityGroup]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        application_gateway_backend_address_pools: Optional[List["ApplicationGatewayBackendAddressPool"]] = None,
        load_balancer_backend_address_pools: Optional[List["BackendAddressPool"]] = None,
        load_balancer_inbound_nat_rules: Optional[List["InboundNatRule"]] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "IPAllocationMethod"]] = None,
        private_ip_address_version: Optional[Union[str, "IPVersion"]] = None,
        subnet: Optional["Subnet"] = None,
        primary: Optional[bool] = None,
        public_ip_address: Optional["PublicIPAddress"] = None,
        application_security_groups: Optional[List["ApplicationSecurityGroup"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(NetworkInterfaceIPConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_rules = load_balancer_inbound_nat_rules
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.private_ip_address_version = private_ip_address_version
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address = public_ip_address
        self.application_security_groups = application_security_groups
        self.provisioning_state = provisioning_state


class NetworkInterfaceIPConfigurationListResult(msrest.serialization.Model):
    """Response for list ip configurations API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of ip configurations.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.NetworkInterfaceIPConfiguration]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkInterfaceIPConfiguration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NetworkInterfaceIPConfiguration"]] = None,
        **kwargs
    ):
        super(NetworkInterfaceIPConfigurationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class NetworkInterfaceListResult(msrest.serialization.Model):
    """Response for the ListNetworkInterface API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of network interfaces in a resource group.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.NetworkInterface]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkInterface]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NetworkInterface"]] = None,
        **kwargs
    ):
        super(NetworkInterfaceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class NetworkInterfaceLoadBalancerListResult(msrest.serialization.Model):
    """Response for list ip configurations API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of load balancers.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.LoadBalancer]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LoadBalancer]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["LoadBalancer"]] = None,
        **kwargs
    ):
        super(NetworkInterfaceLoadBalancerListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class NetworkSecurityGroup(Resource):
    """NetworkSecurityGroup resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param security_rules: A collection of security rules of the network security group.
    :type security_rules: list[~azure.mgmt.network.v2018_01_01.models.SecurityRule]
    :param default_security_rules: The default security rules of network security group.
    :type default_security_rules: list[~azure.mgmt.network.v2018_01_01.models.SecurityRule]
    :ivar network_interfaces: A collection of references to network interfaces.
    :vartype network_interfaces: list[~azure.mgmt.network.v2018_01_01.models.NetworkInterface]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.v2018_01_01.models.Subnet]
    :param resource_guid: The resource GUID property of the network security group resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'network_interfaces': {'readonly': True},
        'subnets': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'security_rules': {'key': 'properties.securityRules', 'type': '[SecurityRule]'},
        'default_security_rules': {'key': 'properties.defaultSecurityRules', 'type': '[SecurityRule]'},
        'network_interfaces': {'key': 'properties.networkInterfaces', 'type': '[NetworkInterface]'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        security_rules: Optional[List["SecurityRule"]] = None,
        default_security_rules: Optional[List["SecurityRule"]] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(NetworkSecurityGroup, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.security_rules = security_rules
        self.default_security_rules = default_security_rules
        self.network_interfaces = None
        self.subnets = None
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class NetworkSecurityGroupListResult(msrest.serialization.Model):
    """Response for ListNetworkSecurityGroups API service call.

    :param value: A list of NetworkSecurityGroup resources.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.NetworkSecurityGroup]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkSecurityGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NetworkSecurityGroup"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(NetworkSecurityGroupListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkWatcher(Resource):
    """Network watcher in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag:
    :type etag: str
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2018_01_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = "A unique read-only string that changes whenever the resource is updated.",
        **kwargs
    ):
        super(NetworkWatcher, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.provisioning_state = None


class NetworkWatcherListResult(msrest.serialization.Model):
    """List of network watcher resources.

    :param value:
    :type value: list[~azure.mgmt.network.v2018_01_01.models.NetworkWatcher]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkWatcher]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NetworkWatcher"]] = None,
        **kwargs
    ):
        super(NetworkWatcherListResult, self).__init__(**kwargs)
        self.value = value


class NextHopParameters(msrest.serialization.Model):
    """Parameters that define the source and destination endpoint.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The resource identifier of the target resource against
     which the action is to be performed.
    :type target_resource_id: str
    :param source_ip_address: Required. The source IP address.
    :type source_ip_address: str
    :param destination_ip_address: Required. The destination IP address.
    :type destination_ip_address: str
    :param target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP forwarding is
     enabled on any of the nics, then this parameter must be specified. Otherwise optional).
    :type target_nic_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
        'source_ip_address': {'required': True},
        'destination_ip_address': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'source_ip_address': {'key': 'sourceIPAddress', 'type': 'str'},
        'destination_ip_address': {'key': 'destinationIPAddress', 'type': 'str'},
        'target_nic_resource_id': {'key': 'targetNicResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        source_ip_address: str,
        destination_ip_address: str,
        target_nic_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(NextHopParameters, self).__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.source_ip_address = source_ip_address
        self.destination_ip_address = destination_ip_address
        self.target_nic_resource_id = target_nic_resource_id


class NextHopResult(msrest.serialization.Model):
    """The information about next hop from the specified VM.

    :param next_hop_type: Next hop type. Possible values include: "Internet", "VirtualAppliance",
     "VirtualNetworkGateway", "VnetLocal", "HyperNetGateway", "None".
    :type next_hop_type: str or ~azure.mgmt.network.v2018_01_01.models.NextHopType
    :param next_hop_ip_address: Next hop IP Address.
    :type next_hop_ip_address: str
    :param route_table_id: The resource identifier for the route table associated with the route
     being returned. If the route being returned does not correspond to any user created routes then
     this field will be the string 'System Route'.
    :type route_table_id: str
    """

    _attribute_map = {
        'next_hop_type': {'key': 'nextHopType', 'type': 'str'},
        'next_hop_ip_address': {'key': 'nextHopIpAddress', 'type': 'str'},
        'route_table_id': {'key': 'routeTableId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_hop_type: Optional[Union[str, "NextHopType"]] = None,
        next_hop_ip_address: Optional[str] = None,
        route_table_id: Optional[str] = None,
        **kwargs
    ):
        super(NextHopResult, self).__init__(**kwargs)
        self.next_hop_type = next_hop_type
        self.next_hop_ip_address = next_hop_ip_address
        self.route_table_id = route_table_id


class Operation(msrest.serialization.Model):
    """Network REST API operation definition.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display: ~azure.mgmt.network.v2018_01_01.models.OperationDisplay
    :param origin: Origin of the operation.
    :type origin: str
    :param service_specification: Specification of the service.
    :type service_specification:
     ~azure.mgmt.network.v2018_01_01.models.OperationPropertiesFormatServiceSpecification
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'OperationPropertiesFormatServiceSpecification'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationDisplay"] = None,
        origin: Optional[str] = None,
        service_specification: Optional["OperationPropertiesFormatServiceSpecification"] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.service_specification = service_specification


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :param provider: Service provider: Microsoft Network.
    :type provider: str
    :param resource: Resource on which the operation is performed.
    :type resource: str
    :param operation: Type of the operation: get, read, delete, etc.
    :type operation: str
    :param description: Description of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Network operations. It contains a list of operations and a URL link to get the next set of results.

    :param value: List of Network operations supported by the Network resource provider.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.Operation]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationPropertiesFormatServiceSpecification(msrest.serialization.Model):
    """Specification of the service.

    :param metric_specifications: Operation service specification.
    :type metric_specifications: list[~azure.mgmt.network.v2018_01_01.models.MetricSpecification]
    :param log_specifications: Operation log specification.
    :type log_specifications: list[~azure.mgmt.network.v2018_01_01.models.LogSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["MetricSpecification"]] = None,
        log_specifications: Optional[List["LogSpecification"]] = None,
        **kwargs
    ):
        super(OperationPropertiesFormatServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications
        self.log_specifications = log_specifications


class OutboundNatRule(SubResource):
    """Outbound NAT pool of the load balancer.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param allocated_outbound_ports: The number of outbound ports to be used for NAT.
    :type allocated_outbound_ports: int
    :param frontend_ip_configurations: The Frontend IP addresses of the load balancer.
    :type frontend_ip_configurations: list[~azure.mgmt.network.v2018_01_01.models.SubResource]
    :param backend_address_pool: A reference to a pool of DIPs. Outbound traffic is randomly load
     balanced across IPs in the backend IPs.
    :type backend_address_pool: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'allocated_outbound_ports': {'key': 'properties.allocatedOutboundPorts', 'type': 'int'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[SubResource]'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        allocated_outbound_ports: Optional[int] = None,
        frontend_ip_configurations: Optional[List["SubResource"]] = None,
        backend_address_pool: Optional["SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(OutboundNatRule, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.allocated_outbound_ports = allocated_outbound_ports
        self.frontend_ip_configurations = frontend_ip_configurations
        self.backend_address_pool = backend_address_pool
        self.provisioning_state = provisioning_state


class PacketCapture(msrest.serialization.Model):
    """Parameters that define the create packet capture operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the packet capture.
    :vartype name: str
    :ivar id: ID of the packet capture.
    :vartype id: str
    :ivar type: Packet capture type.
    :vartype type: str
    :param target: Required. The ID of the targeted resource, only VM is currently supported.
    :type target: str
    :param bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
     are truncated.
    :type bytes_to_capture_per_packet: int
    :param total_bytes_per_session: Maximum size of the capture output.
    :type total_bytes_per_session: int
    :param time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :type time_limit_in_seconds: int
    :param storage_location: Required. Describes the storage location for a packet capture session.
    :type storage_location: ~azure.mgmt.network.v2018_01_01.models.PacketCaptureStorageLocation
    :param filters:
    :type filters: list[~azure.mgmt.network.v2018_01_01.models.PacketCaptureFilter]
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'target': {'required': True},
        'storage_location': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'target': {'key': 'properties.target', 'type': 'str'},
        'bytes_to_capture_per_packet': {'key': 'properties.bytesToCapturePerPacket', 'type': 'int'},
        'total_bytes_per_session': {'key': 'properties.totalBytesPerSession', 'type': 'int'},
        'time_limit_in_seconds': {'key': 'properties.timeLimitInSeconds', 'type': 'int'},
        'storage_location': {'key': 'properties.storageLocation', 'type': 'PacketCaptureStorageLocation'},
        'filters': {'key': 'properties.filters', 'type': '[PacketCaptureFilter]'},
    }

    def __init__(
        self,
        *,
        target: str,
        storage_location: "PacketCaptureStorageLocation",
        bytes_to_capture_per_packet: Optional[int] = 0,
        total_bytes_per_session: Optional[int] = 1073741824,
        time_limit_in_seconds: Optional[int] = 18000,
        filters: Optional[List["PacketCaptureFilter"]] = None,
        **kwargs
    ):
        super(PacketCapture, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.target = target
        self.bytes_to_capture_per_packet = bytes_to_capture_per_packet
        self.total_bytes_per_session = total_bytes_per_session
        self.time_limit_in_seconds = time_limit_in_seconds
        self.storage_location = storage_location
        self.filters = filters


class PacketCaptureFilter(msrest.serialization.Model):
    """Filter that is applied to packet capture request. Multiple filters can be applied.

    :param protocol: Protocol to be filtered on. Possible values include: "TCP", "UDP", "Any".
     Default value: "Any".
    :type protocol: str or ~azure.mgmt.network.v2018_01_01.models.PcProtocol
    :param local_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single
     address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries.
     Multiple ranges not currently supported. Mixing ranges with multiple entries not currently
     supported. Default = null.
    :type local_ip_address: str
    :param remote_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single
     address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries.
     Multiple ranges not currently supported. Mixing ranges with multiple entries not currently
     supported. Default = null.
    :type remote_ip_address: str
    :param local_port: Local port to be filtered on. Notation: "80" for single port entry."80-85"
     for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing
     ranges with multiple entries not currently supported. Default = null.
    :type local_port: str
    :param remote_port: Remote port to be filtered on. Notation: "80" for single port entry."80-85"
     for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing
     ranges with multiple entries not currently supported. Default = null.
    :type remote_port: str
    """

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'str'},
        'local_ip_address': {'key': 'localIPAddress', 'type': 'str'},
        'remote_ip_address': {'key': 'remoteIPAddress', 'type': 'str'},
        'local_port': {'key': 'localPort', 'type': 'str'},
        'remote_port': {'key': 'remotePort', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        protocol: Optional[Union[str, "PcProtocol"]] = "Any",
        local_ip_address: Optional[str] = None,
        remote_ip_address: Optional[str] = None,
        local_port: Optional[str] = None,
        remote_port: Optional[str] = None,
        **kwargs
    ):
        super(PacketCaptureFilter, self).__init__(**kwargs)
        self.protocol = protocol
        self.local_ip_address = local_ip_address
        self.remote_ip_address = remote_ip_address
        self.local_port = local_port
        self.remote_port = remote_port


class PacketCaptureListResult(msrest.serialization.Model):
    """List of packet capture sessions.

    :param value: Information about packet capture sessions.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.PacketCaptureResult]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PacketCaptureResult]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PacketCaptureResult"]] = None,
        **kwargs
    ):
        super(PacketCaptureListResult, self).__init__(**kwargs)
        self.value = value


class PacketCaptureParameters(msrest.serialization.Model):
    """Parameters that define the create packet capture operation.

    All required parameters must be populated in order to send to Azure.

    :param target: Required. The ID of the targeted resource, only VM is currently supported.
    :type target: str
    :param bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
     are truncated.
    :type bytes_to_capture_per_packet: int
    :param total_bytes_per_session: Maximum size of the capture output.
    :type total_bytes_per_session: int
    :param time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :type time_limit_in_seconds: int
    :param storage_location: Required. Describes the storage location for a packet capture session.
    :type storage_location: ~azure.mgmt.network.v2018_01_01.models.PacketCaptureStorageLocation
    :param filters:
    :type filters: list[~azure.mgmt.network.v2018_01_01.models.PacketCaptureFilter]
    """

    _validation = {
        'target': {'required': True},
        'storage_location': {'required': True},
    }

    _attribute_map = {
        'target': {'key': 'target', 'type': 'str'},
        'bytes_to_capture_per_packet': {'key': 'bytesToCapturePerPacket', 'type': 'int'},
        'total_bytes_per_session': {'key': 'totalBytesPerSession', 'type': 'int'},
        'time_limit_in_seconds': {'key': 'timeLimitInSeconds', 'type': 'int'},
        'storage_location': {'key': 'storageLocation', 'type': 'PacketCaptureStorageLocation'},
        'filters': {'key': 'filters', 'type': '[PacketCaptureFilter]'},
    }

    def __init__(
        self,
        *,
        target: str,
        storage_location: "PacketCaptureStorageLocation",
        bytes_to_capture_per_packet: Optional[int] = 0,
        total_bytes_per_session: Optional[int] = 1073741824,
        time_limit_in_seconds: Optional[int] = 18000,
        filters: Optional[List["PacketCaptureFilter"]] = None,
        **kwargs
    ):
        super(PacketCaptureParameters, self).__init__(**kwargs)
        self.target = target
        self.bytes_to_capture_per_packet = bytes_to_capture_per_packet
        self.total_bytes_per_session = total_bytes_per_session
        self.time_limit_in_seconds = time_limit_in_seconds
        self.storage_location = storage_location
        self.filters = filters


class PacketCaptureQueryStatusResult(msrest.serialization.Model):
    """Status of packet capture session.

    :param name: The name of the packet capture resource.
    :type name: str
    :param id: The ID of the packet capture resource.
    :type id: str
    :param capture_start_time: The start time of the packet capture session.
    :type capture_start_time: ~datetime.datetime
    :param packet_capture_status: The status of the packet capture session. Possible values
     include: "NotStarted", "Running", "Stopped", "Error", "Unknown".
    :type packet_capture_status: str or ~azure.mgmt.network.v2018_01_01.models.PcStatus
    :param stop_reason: The reason the current packet capture session was stopped.
    :type stop_reason: str
    :param packet_capture_error: List of errors of packet capture session.
    :type packet_capture_error: list[str or ~azure.mgmt.network.v2018_01_01.models.PcError]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'capture_start_time': {'key': 'captureStartTime', 'type': 'iso-8601'},
        'packet_capture_status': {'key': 'packetCaptureStatus', 'type': 'str'},
        'stop_reason': {'key': 'stopReason', 'type': 'str'},
        'packet_capture_error': {'key': 'packetCaptureError', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,
        capture_start_time: Optional[datetime.datetime] = None,
        packet_capture_status: Optional[Union[str, "PcStatus"]] = None,
        stop_reason: Optional[str] = None,
        packet_capture_error: Optional[List[Union[str, "PcError"]]] = None,
        **kwargs
    ):
        super(PacketCaptureQueryStatusResult, self).__init__(**kwargs)
        self.name = name
        self.id = id
        self.capture_start_time = capture_start_time
        self.packet_capture_status = packet_capture_status
        self.stop_reason = stop_reason
        self.packet_capture_error = packet_capture_error


class PacketCaptureResult(msrest.serialization.Model):
    """Information about packet capture session.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the packet capture.
    :vartype name: str
    :ivar id: ID of the packet capture.
    :vartype id: str
    :ivar type: Packet capture type.
    :vartype type: str
    :param etag:
    :type etag: str
    :param target: The ID of the targeted resource, only VM is currently supported.
    :type target: str
    :param bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
     are truncated.
    :type bytes_to_capture_per_packet: int
    :param total_bytes_per_session: Maximum size of the capture output.
    :type total_bytes_per_session: int
    :param time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :type time_limit_in_seconds: int
    :param storage_location: Describes the storage location for a packet capture session.
    :type storage_location: ~azure.mgmt.network.v2018_01_01.models.PacketCaptureStorageLocation
    :param filters:
    :type filters: list[~azure.mgmt.network.v2018_01_01.models.PacketCaptureFilter]
    :param provisioning_state: The provisioning state of the packet capture session. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :type provisioning_state: str or ~azure.mgmt.network.v2018_01_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'target': {'key': 'properties.target', 'type': 'str'},
        'bytes_to_capture_per_packet': {'key': 'properties.bytesToCapturePerPacket', 'type': 'int'},
        'total_bytes_per_session': {'key': 'properties.totalBytesPerSession', 'type': 'int'},
        'time_limit_in_seconds': {'key': 'properties.timeLimitInSeconds', 'type': 'int'},
        'storage_location': {'key': 'properties.storageLocation', 'type': 'PacketCaptureStorageLocation'},
        'filters': {'key': 'properties.filters', 'type': '[PacketCaptureFilter]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = "A unique read-only string that changes whenever the resource is updated.",
        target: Optional[str] = None,
        bytes_to_capture_per_packet: Optional[int] = 0,
        total_bytes_per_session: Optional[int] = 1073741824,
        time_limit_in_seconds: Optional[int] = 18000,
        storage_location: Optional["PacketCaptureStorageLocation"] = None,
        filters: Optional[List["PacketCaptureFilter"]] = None,
        provisioning_state: Optional[Union[str, "ProvisioningState"]] = None,
        **kwargs
    ):
        super(PacketCaptureResult, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.etag = etag
        self.target = target
        self.bytes_to_capture_per_packet = bytes_to_capture_per_packet
        self.total_bytes_per_session = total_bytes_per_session
        self.time_limit_in_seconds = time_limit_in_seconds
        self.storage_location = storage_location
        self.filters = filters
        self.provisioning_state = provisioning_state


class PacketCaptureResultProperties(PacketCaptureParameters):
    """Describes the properties of a packet capture session.

    All required parameters must be populated in order to send to Azure.

    :param target: Required. The ID of the targeted resource, only VM is currently supported.
    :type target: str
    :param bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
     are truncated.
    :type bytes_to_capture_per_packet: int
    :param total_bytes_per_session: Maximum size of the capture output.
    :type total_bytes_per_session: int
    :param time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :type time_limit_in_seconds: int
    :param storage_location: Required. Describes the storage location for a packet capture session.
    :type storage_location: ~azure.mgmt.network.v2018_01_01.models.PacketCaptureStorageLocation
    :param filters:
    :type filters: list[~azure.mgmt.network.v2018_01_01.models.PacketCaptureFilter]
    :param provisioning_state: The provisioning state of the packet capture session. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :type provisioning_state: str or ~azure.mgmt.network.v2018_01_01.models.ProvisioningState
    """

    _validation = {
        'target': {'required': True},
        'storage_location': {'required': True},
    }

    _attribute_map = {
        'target': {'key': 'target', 'type': 'str'},
        'bytes_to_capture_per_packet': {'key': 'bytesToCapturePerPacket', 'type': 'int'},
        'total_bytes_per_session': {'key': 'totalBytesPerSession', 'type': 'int'},
        'time_limit_in_seconds': {'key': 'timeLimitInSeconds', 'type': 'int'},
        'storage_location': {'key': 'storageLocation', 'type': 'PacketCaptureStorageLocation'},
        'filters': {'key': 'filters', 'type': '[PacketCaptureFilter]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target: str,
        storage_location: "PacketCaptureStorageLocation",
        bytes_to_capture_per_packet: Optional[int] = 0,
        total_bytes_per_session: Optional[int] = 1073741824,
        time_limit_in_seconds: Optional[int] = 18000,
        filters: Optional[List["PacketCaptureFilter"]] = None,
        provisioning_state: Optional[Union[str, "ProvisioningState"]] = None,
        **kwargs
    ):
        super(PacketCaptureResultProperties, self).__init__(target=target, bytes_to_capture_per_packet=bytes_to_capture_per_packet, total_bytes_per_session=total_bytes_per_session, time_limit_in_seconds=time_limit_in_seconds, storage_location=storage_location, filters=filters, **kwargs)
        self.provisioning_state = provisioning_state


class PacketCaptureStorageLocation(msrest.serialization.Model):
    """Describes the storage location for a packet capture session.

    :param storage_id: The ID of the storage account to save the packet capture session. Required
     if no local file path is provided.
    :type storage_id: str
    :param storage_path: The URI of the storage path to save the packet capture. Must be a well-
     formed URI describing the location to save the packet capture.
    :type storage_path: str
    :param file_path: A valid local path on the targeting VM. Must include the name of the capture
     file (*.cap). For linux virtual machine it must start with /var/captures. Required if no
     storage ID is provided, otherwise optional.
    :type file_path: str
    """

    _attribute_map = {
        'storage_id': {'key': 'storageId', 'type': 'str'},
        'storage_path': {'key': 'storagePath', 'type': 'str'},
        'file_path': {'key': 'filePath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_id: Optional[str] = None,
        storage_path: Optional[str] = None,
        file_path: Optional[str] = None,
        **kwargs
    ):
        super(PacketCaptureStorageLocation, self).__init__(**kwargs)
        self.storage_id = storage_id
        self.storage_path = storage_path
        self.file_path = file_path


class PatchRouteFilter(SubResource):
    """Route Filter Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param rules: Collection of RouteFilterRules contained within a route filter.
    :type rules: list[~azure.mgmt.network.v2018_01_01.models.RouteFilterRule]
    :param peerings: A collection of references to express route circuit peerings.
    :type peerings: list[~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitPeering]
    :ivar provisioning_state: The provisioning state of the resource. Possible values are:
     'Updating', 'Deleting', 'Succeeded' and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'rules': {'key': 'properties.rules', 'type': '[RouteFilterRule]'},
        'peerings': {'key': 'properties.peerings', 'type': '[ExpressRouteCircuitPeering]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        rules: Optional[List["RouteFilterRule"]] = None,
        peerings: Optional[List["ExpressRouteCircuitPeering"]] = None,
        **kwargs
    ):
        super(PatchRouteFilter, self).__init__(id=id, **kwargs)
        self.name = None
        self.etag = None
        self.type = None
        self.tags = tags
        self.rules = rules
        self.peerings = peerings
        self.provisioning_state = None


class PatchRouteFilterRule(SubResource):
    """Route Filter Rule Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param access: The access type of the rule. Valid values are: 'Allow', 'Deny'. Possible values
     include: "Allow", "Deny".
    :type access: str or ~azure.mgmt.network.v2018_01_01.models.Access
    :ivar route_filter_rule_type: The rule type of the rule. Valid value is: 'Community'. Default
     value: "Community".
    :vartype route_filter_rule_type: str
    :param communities: The collection for bgp community values to filter on. e.g.
     ['12076:5010','12076:5020'].
    :type communities: list[str]
    :ivar provisioning_state: The provisioning state of the resource. Possible values are:
     'Updating', 'Deleting', 'Succeeded' and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'etag': {'readonly': True},
        'route_filter_rule_type': {'constant': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'route_filter_rule_type': {'key': 'properties.routeFilterRuleType', 'type': 'str'},
        'communities': {'key': 'properties.communities', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    route_filter_rule_type = "Community"

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        access: Optional[Union[str, "Access"]] = None,
        communities: Optional[List[str]] = None,
        **kwargs
    ):
        super(PatchRouteFilterRule, self).__init__(id=id, **kwargs)
        self.name = None
        self.etag = None
        self.access = access
        self.communities = communities
        self.provisioning_state = None


class Probe(SubResource):
    """A load balancer probe.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :ivar load_balancing_rules: The load balancer rules that use this probe.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2018_01_01.models.SubResource]
    :param protocol: The protocol of the end point. Possible values are: 'Http' or 'Tcp'. If 'Tcp'
     is specified, a received ACK is required for the probe to be successful. If 'Http' is
     specified, a 200 OK response from the specifies URI is required for the probe to be successful.
     Possible values include: "Http", "Tcp".
    :type protocol: str or ~azure.mgmt.network.v2018_01_01.models.ProbeProtocol
    :param port: The port for communicating the probe. Possible values range from 1 to 65535,
     inclusive.
    :type port: int
    :param interval_in_seconds: The interval, in seconds, for how frequently to probe the endpoint
     for health status. Typically, the interval is slightly less than half the allocated timeout
     period (in seconds) which allows two full probes before taking the instance out of rotation.
     The default value is 15, the minimum value is 5.
    :type interval_in_seconds: int
    :param number_of_probes: The number of probes where if no response, will result in stopping
     further traffic from being delivered to the endpoint. This values allows endpoints to be taken
     out of rotation faster or slower than the typical times used in Azure.
    :type number_of_probes: int
    :param request_path: The URI used for requesting health status from the VM. Path is required if
     a protocol is set to http. Otherwise, it is not allowed. There is no default value.
    :type request_path: str
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'load_balancing_rules': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'interval_in_seconds': {'key': 'properties.intervalInSeconds', 'type': 'int'},
        'number_of_probes': {'key': 'properties.numberOfProbes', 'type': 'int'},
        'request_path': {'key': 'properties.requestPath', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        protocol: Optional[Union[str, "ProbeProtocol"]] = None,
        port: Optional[int] = None,
        interval_in_seconds: Optional[int] = None,
        number_of_probes: Optional[int] = None,
        request_path: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(Probe, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.load_balancing_rules = None
        self.protocol = protocol
        self.port = port
        self.interval_in_seconds = interval_in_seconds
        self.number_of_probes = number_of_probes
        self.request_path = request_path
        self.provisioning_state = provisioning_state


class PublicIPAddress(Resource):
    """Public IP address resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The public IP address SKU.
    :type sku: ~azure.mgmt.network.v2018_01_01.models.PublicIPAddressSku
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param zones: A list of availability zones denoting the IP allocated for the resource needs to
     come from.
    :type zones: list[str]
    :param public_ip_allocation_method: The public IP allocation method. Possible values are:
     'Static' and 'Dynamic'. Possible values include: "Static", "Dynamic".
    :type public_ip_allocation_method: str or
     ~azure.mgmt.network.v2018_01_01.models.IPAllocationMethod
    :param public_ip_address_version: The public IP address version. Possible values are: 'IPv4'
     and 'IPv6'. Possible values include: "IPv4", "IPv6".
    :type public_ip_address_version: str or ~azure.mgmt.network.v2018_01_01.models.IPVersion
    :ivar ip_configuration: The IP configuration associated with the public IP address.
    :vartype ip_configuration: ~azure.mgmt.network.v2018_01_01.models.IPConfiguration
    :param dns_settings: The FQDN of the DNS record associated with the public IP address.
    :type dns_settings: ~azure.mgmt.network.v2018_01_01.models.PublicIPAddressDnsSettings
    :param ip_tags: The list of tags associated with the public IP address.
    :type ip_tags: list[~azure.mgmt.network.v2018_01_01.models.IpTag]
    :param ip_address: The IP address associated with the public IP address resource.
    :type ip_address: str
    :param idle_timeout_in_minutes: The idle timeout of the public IP address.
    :type idle_timeout_in_minutes: int
    :param resource_guid: The resource GUID property of the public IP resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the PublicIP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'ip_configuration': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'PublicIPAddressSku'},
        'etag': {'key': 'etag', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'public_ip_allocation_method': {'key': 'properties.publicIPAllocationMethod', 'type': 'str'},
        'public_ip_address_version': {'key': 'properties.publicIPAddressVersion', 'type': 'str'},
        'ip_configuration': {'key': 'properties.ipConfiguration', 'type': 'IPConfiguration'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'PublicIPAddressDnsSettings'},
        'ip_tags': {'key': 'properties.ipTags', 'type': '[IpTag]'},
        'ip_address': {'key': 'properties.ipAddress', 'type': 'str'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["PublicIPAddressSku"] = None,
        etag: Optional[str] = None,
        zones: Optional[List[str]] = None,
        public_ip_allocation_method: Optional[Union[str, "IPAllocationMethod"]] = None,
        public_ip_address_version: Optional[Union[str, "IPVersion"]] = None,
        dns_settings: Optional["PublicIPAddressDnsSettings"] = None,
        ip_tags: Optional[List["IpTag"]] = None,
        ip_address: Optional[str] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(PublicIPAddress, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.etag = etag
        self.zones = zones
        self.public_ip_allocation_method = public_ip_allocation_method
        self.public_ip_address_version = public_ip_address_version
        self.ip_configuration = None
        self.dns_settings = dns_settings
        self.ip_tags = ip_tags
        self.ip_address = ip_address
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class PublicIPAddressDnsSettings(msrest.serialization.Model):
    """Contains FQDN of the DNS record associated with the public IP address.

    :param domain_name_label: Gets or sets the Domain name label.The concatenation of the domain
     name label and the regionalized DNS zone make up the fully qualified domain name associated
     with the public IP address. If a domain name label is specified, an A DNS record is created for
     the public IP in the Microsoft Azure DNS system.
    :type domain_name_label: str
    :param fqdn: Gets the FQDN, Fully qualified domain name of the A DNS record associated with the
     public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
    :type fqdn: str
    :param reverse_fqdn: Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name
     that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record
     is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
    :type reverse_fqdn: str
    """

    _attribute_map = {
        'domain_name_label': {'key': 'domainNameLabel', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'reverse_fqdn': {'key': 'reverseFqdn', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        domain_name_label: Optional[str] = None,
        fqdn: Optional[str] = None,
        reverse_fqdn: Optional[str] = None,
        **kwargs
    ):
        super(PublicIPAddressDnsSettings, self).__init__(**kwargs)
        self.domain_name_label = domain_name_label
        self.fqdn = fqdn
        self.reverse_fqdn = reverse_fqdn


class PublicIPAddressListResult(msrest.serialization.Model):
    """Response for ListPublicIpAddresses API service call.

    :param value: A list of public IP addresses that exists in a resource group.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.PublicIPAddress]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PublicIPAddress]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PublicIPAddress"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PublicIPAddressListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PublicIPAddressSku(msrest.serialization.Model):
    """SKU of a public IP address.

    :param name: Name of a public IP address SKU. Possible values include: "Basic", "Standard".
    :type name: str or ~azure.mgmt.network.v2018_01_01.models.PublicIPAddressSkuName
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "PublicIPAddressSkuName"]] = None,
        **kwargs
    ):
        super(PublicIPAddressSku, self).__init__(**kwargs)
        self.name = name


class QueryTroubleshootingParameters(msrest.serialization.Model):
    """Parameters that define the resource to query the troubleshooting result.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The target resource ID to query the troubleshooting
     result.
    :type target_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        **kwargs
    ):
        super(QueryTroubleshootingParameters, self).__init__(**kwargs)
        self.target_resource_id = target_resource_id


class ResourceNavigationLink(SubResource):
    """ResourceNavigationLink resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param linked_resource_type: Resource type of the linked resource.
    :type linked_resource_type: str
    :param link: Link to the external resource.
    :type link: str
    :ivar provisioning_state: Provisioning state of the ResourceNavigationLink resource.
    :vartype provisioning_state: str
    """

    _validation = {
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'linked_resource_type': {'key': 'properties.linkedResourceType', 'type': 'str'},
        'link': {'key': 'properties.link', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        linked_resource_type: Optional[str] = None,
        link: Optional[str] = None,
        **kwargs
    ):
        super(ResourceNavigationLink, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.linked_resource_type = linked_resource_type
        self.link = link
        self.provisioning_state = None


class RetentionPolicyParameters(msrest.serialization.Model):
    """Parameters that define the retention policy for flow log.

    :param days: Number of days to retain flow log records.
    :type days: int
    :param enabled: Flag to enable/disable retention.
    :type enabled: bool
    """

    _attribute_map = {
        'days': {'key': 'days', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        days: Optional[int] = 0,
        enabled: Optional[bool] = False,
        **kwargs
    ):
        super(RetentionPolicyParameters, self).__init__(**kwargs)
        self.days = days
        self.enabled = enabled


class Route(SubResource):
    """Route resource.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param address_prefix: The destination CIDR to which the route applies.
    :type address_prefix: str
    :param next_hop_type: The type of Azure hop the packet should be sent to. Possible values are:
     'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'. Possible
     values include: "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", "None".
    :type next_hop_type: str or ~azure.mgmt.network.v2018_01_01.models.RouteNextHopType
    :param next_hop_ip_address: The IP address packets should be forwarded to. Next hop values are
     only allowed in routes where the next hop type is VirtualAppliance.
    :type next_hop_ip_address: str
    :param provisioning_state: The provisioning state of the resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'next_hop_type': {'key': 'properties.nextHopType', 'type': 'str'},
        'next_hop_ip_address': {'key': 'properties.nextHopIpAddress', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        address_prefix: Optional[str] = None,
        next_hop_type: Optional[Union[str, "RouteNextHopType"]] = None,
        next_hop_ip_address: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(Route, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.address_prefix = address_prefix
        self.next_hop_type = next_hop_type
        self.next_hop_ip_address = next_hop_ip_address
        self.provisioning_state = provisioning_state


class RouteFilter(Resource):
    """Route Filter Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param rules: Collection of RouteFilterRules contained within a route filter.
    :type rules: list[~azure.mgmt.network.v2018_01_01.models.RouteFilterRule]
    :param peerings: A collection of references to express route circuit peerings.
    :type peerings: list[~azure.mgmt.network.v2018_01_01.models.ExpressRouteCircuitPeering]
    :ivar provisioning_state: The provisioning state of the resource. Possible values are:
     'Updating', 'Deleting', 'Succeeded' and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'rules': {'key': 'properties.rules', 'type': '[RouteFilterRule]'},
        'peerings': {'key': 'properties.peerings', 'type': '[ExpressRouteCircuitPeering]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        rules: Optional[List["RouteFilterRule"]] = None,
        peerings: Optional[List["ExpressRouteCircuitPeering"]] = None,
        **kwargs
    ):
        super(RouteFilter, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.rules = rules
        self.peerings = peerings
        self.provisioning_state = None


class RouteFilterListResult(msrest.serialization.Model):
    """Response for the ListRouteFilters API service call.

    :param value: Gets a list of route filters in a resource group.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.RouteFilter]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RouteFilter]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RouteFilter"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RouteFilterListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RouteFilterRule(SubResource):
    """Route Filter Rule Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param location: Resource location.
    :type location: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param access: The access type of the rule. Valid values are: 'Allow', 'Deny'. Possible values
     include: "Allow", "Deny".
    :type access: str or ~azure.mgmt.network.v2018_01_01.models.Access
    :ivar route_filter_rule_type: The rule type of the rule. Valid value is: 'Community'. Default
     value: "Community".
    :vartype route_filter_rule_type: str
    :param communities: The collection for bgp community values to filter on. e.g.
     ['12076:5010','12076:5020'].
    :type communities: list[str]
    :ivar provisioning_state: The provisioning state of the resource. Possible values are:
     'Updating', 'Deleting', 'Succeeded' and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        'etag': {'readonly': True},
        'route_filter_rule_type': {'constant': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'route_filter_rule_type': {'key': 'properties.routeFilterRuleType', 'type': 'str'},
        'communities': {'key': 'properties.communities', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    route_filter_rule_type = "Community"

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        location: Optional[str] = None,
        access: Optional[Union[str, "Access"]] = None,
        communities: Optional[List[str]] = None,
        **kwargs
    ):
        super(RouteFilterRule, self).__init__(id=id, **kwargs)
        self.name = name
        self.location = location
        self.etag = None
        self.access = access
        self.communities = communities
        self.provisioning_state = None


class RouteFilterRuleListResult(msrest.serialization.Model):
    """Response for the ListRouteFilterRules API service call.

    :param value: Gets a list of RouteFilterRules in a resource group.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.RouteFilterRule]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RouteFilterRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RouteFilterRule"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RouteFilterRuleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RouteListResult(msrest.serialization.Model):
    """Response for the ListRoute API service call.

    :param value: Gets a list of routes in a resource group.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.Route]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Route]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Route"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RouteListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RouteTable(Resource):
    """Route table resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param routes: Collection of routes contained within a route table.
    :type routes: list[~azure.mgmt.network.v2018_01_01.models.Route]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.v2018_01_01.models.Subnet]
    :param disable_bgp_route_propagation: Gets or sets whether to disable the routes learned by BGP
     on that route table. True means disable.
    :type disable_bgp_route_propagation: bool
    :param provisioning_state: The provisioning state of the resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'subnets': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'routes': {'key': 'properties.routes', 'type': '[Route]'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'disable_bgp_route_propagation': {'key': 'properties.disableBgpRoutePropagation', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        routes: Optional[List["Route"]] = None,
        disable_bgp_route_propagation: Optional[bool] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(RouteTable, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.routes = routes
        self.subnets = None
        self.disable_bgp_route_propagation = disable_bgp_route_propagation
        self.provisioning_state = provisioning_state


class RouteTableListResult(msrest.serialization.Model):
    """Response for the ListRouteTable API service call.

    :param value: Gets a list of route tables in a resource group.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.RouteTable]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RouteTable]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RouteTable"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RouteTableListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SecurityGroupNetworkInterface(msrest.serialization.Model):
    """Network interface and all its associated security rules.

    :param id: ID of the network interface.
    :type id: str
    :param security_rule_associations: All security rules associated with the network interface.
    :type security_rule_associations:
     ~azure.mgmt.network.v2018_01_01.models.SecurityRuleAssociations
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'security_rule_associations': {'key': 'securityRuleAssociations', 'type': 'SecurityRuleAssociations'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        security_rule_associations: Optional["SecurityRuleAssociations"] = None,
        **kwargs
    ):
        super(SecurityGroupNetworkInterface, self).__init__(**kwargs)
        self.id = id
        self.security_rule_associations = security_rule_associations


class SecurityGroupViewParameters(msrest.serialization.Model):
    """Parameters that define the VM to check security groups for.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. ID of the target VM.
    :type target_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        **kwargs
    ):
        super(SecurityGroupViewParameters, self).__init__(**kwargs)
        self.target_resource_id = target_resource_id


class SecurityGroupViewResult(msrest.serialization.Model):
    """The information about security rules applied to the specified VM.

    :param network_interfaces: List of network interfaces on the specified VM.
    :type network_interfaces:
     list[~azure.mgmt.network.v2018_01_01.models.SecurityGroupNetworkInterface]
    """

    _attribute_map = {
        'network_interfaces': {'key': 'networkInterfaces', 'type': '[SecurityGroupNetworkInterface]'},
    }

    def __init__(
        self,
        *,
        network_interfaces: Optional[List["SecurityGroupNetworkInterface"]] = None,
        **kwargs
    ):
        super(SecurityGroupViewResult, self).__init__(**kwargs)
        self.network_interfaces = network_interfaces


class SecurityRule(SubResource):
    """Network security rule.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param description: A description for this rule. Restricted to 140 chars.
    :type description: str
    :param protocol: Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and
     '*'. Possible values include: "Tcp", "Udp", "*".
    :type protocol: str or ~azure.mgmt.network.v2018_01_01.models.SecurityRuleProtocol
    :param source_port_range: The source port or range. Integer or range between 0 and 65535.
     Asterisk '*' can also be used to match all ports.
    :type source_port_range: str
    :param destination_port_range: The destination port or range. Integer or range between 0 and
     65535. Asterisk '*' can also be used to match all ports.
    :type destination_port_range: str
    :param source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to
     match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet'
     can also be used. If this is an ingress rule, specifies where network traffic originates from.
    :type source_address_prefix: str
    :param source_address_prefixes: The CIDR or source IP ranges.
    :type source_address_prefixes: list[str]
    :param source_application_security_groups: The application security group specified as source.
    :type source_application_security_groups:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationSecurityGroup]
    :param destination_address_prefix: The destination address prefix. CIDR or destination IP
     range. Asterisk '*' can also be used to match all source IPs. Default tags such as
     'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
    :type destination_address_prefix: str
    :param destination_address_prefixes: The destination address prefixes. CIDR or destination IP
     ranges.
    :type destination_address_prefixes: list[str]
    :param destination_application_security_groups: The application security group specified as
     destination.
    :type destination_application_security_groups:
     list[~azure.mgmt.network.v2018_01_01.models.ApplicationSecurityGroup]
    :param source_port_ranges: The source port ranges.
    :type source_port_ranges: list[str]
    :param destination_port_ranges: The destination port ranges.
    :type destination_port_ranges: list[str]
    :param access: The network traffic is allowed or denied. Possible values are: 'Allow' and
     'Deny'. Possible values include: "Allow", "Deny".
    :type access: str or ~azure.mgmt.network.v2018_01_01.models.SecurityRuleAccess
    :param priority: The priority of the rule. The value can be between 100 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :type priority: int
    :param direction: The direction of the rule. The direction specifies if rule will be evaluated
     on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'. Possible values
     include: "Inbound", "Outbound".
    :type direction: str or ~azure.mgmt.network.v2018_01_01.models.SecurityRuleDirection
    :param provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'source_port_range': {'key': 'properties.sourcePortRange', 'type': 'str'},
        'destination_port_range': {'key': 'properties.destinationPortRange', 'type': 'str'},
        'source_address_prefix': {'key': 'properties.sourceAddressPrefix', 'type': 'str'},
        'source_address_prefixes': {'key': 'properties.sourceAddressPrefixes', 'type': '[str]'},
        'source_application_security_groups': {'key': 'properties.sourceApplicationSecurityGroups', 'type': '[ApplicationSecurityGroup]'},
        'destination_address_prefix': {'key': 'properties.destinationAddressPrefix', 'type': 'str'},
        'destination_address_prefixes': {'key': 'properties.destinationAddressPrefixes', 'type': '[str]'},
        'destination_application_security_groups': {'key': 'properties.destinationApplicationSecurityGroups', 'type': '[ApplicationSecurityGroup]'},
        'source_port_ranges': {'key': 'properties.sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'properties.destinationPortRanges', 'type': '[str]'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'direction': {'key': 'properties.direction', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "SecurityRuleProtocol"]] = None,
        source_port_range: Optional[str] = None,
        destination_port_range: Optional[str] = None,
        source_address_prefix: Optional[str] = None,
        source_address_prefixes: Optional[List[str]] = None,
        source_application_security_groups: Optional[List["ApplicationSecurityGroup"]] = None,
        destination_address_prefix: Optional[str] = None,
        destination_address_prefixes: Optional[List[str]] = None,
        destination_application_security_groups: Optional[List["ApplicationSecurityGroup"]] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        access: Optional[Union[str, "SecurityRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "SecurityRuleDirection"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(SecurityRule, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.description = description
        self.protocol = protocol
        self.source_port_range = source_port_range
        self.destination_port_range = destination_port_range
        self.source_address_prefix = source_address_prefix
        self.source_address_prefixes = source_address_prefixes
        self.source_application_security_groups = source_application_security_groups
        self.destination_address_prefix = destination_address_prefix
        self.destination_address_prefixes = destination_address_prefixes
        self.destination_application_security_groups = destination_application_security_groups
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.access = access
        self.priority = priority
        self.direction = direction
        self.provisioning_state = provisioning_state


class SecurityRuleAssociations(msrest.serialization.Model):
    """All security rules associated with the network interface.

    :param network_interface_association: Network interface and its custom security rules.
    :type network_interface_association:
     ~azure.mgmt.network.v2018_01_01.models.NetworkInterfaceAssociation
    :param subnet_association: Network interface and its custom security rules.
    :type subnet_association: ~azure.mgmt.network.v2018_01_01.models.SubnetAssociation
    :param default_security_rules: Collection of default security rules of the network security
     group.
    :type default_security_rules: list[~azure.mgmt.network.v2018_01_01.models.SecurityRule]
    :param effective_security_rules: Collection of effective security rules.
    :type effective_security_rules:
     list[~azure.mgmt.network.v2018_01_01.models.EffectiveNetworkSecurityRule]
    """

    _attribute_map = {
        'network_interface_association': {'key': 'networkInterfaceAssociation', 'type': 'NetworkInterfaceAssociation'},
        'subnet_association': {'key': 'subnetAssociation', 'type': 'SubnetAssociation'},
        'default_security_rules': {'key': 'defaultSecurityRules', 'type': '[SecurityRule]'},
        'effective_security_rules': {'key': 'effectiveSecurityRules', 'type': '[EffectiveNetworkSecurityRule]'},
    }

    def __init__(
        self,
        *,
        network_interface_association: Optional["NetworkInterfaceAssociation"] = None,
        subnet_association: Optional["SubnetAssociation"] = None,
        default_security_rules: Optional[List["SecurityRule"]] = None,
        effective_security_rules: Optional[List["EffectiveNetworkSecurityRule"]] = None,
        **kwargs
    ):
        super(SecurityRuleAssociations, self).__init__(**kwargs)
        self.network_interface_association = network_interface_association
        self.subnet_association = subnet_association
        self.default_security_rules = default_security_rules
        self.effective_security_rules = effective_security_rules


class SecurityRuleListResult(msrest.serialization.Model):
    """Response for ListSecurityRule API service call. Retrieves all security rules that belongs to a network security group.

    :param value: The security rules in a network security group.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.SecurityRule]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SecurityRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SecurityRule"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SecurityRuleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServiceEndpointPropertiesFormat(msrest.serialization.Model):
    """The service endpoint properties.

    :param service: The type of the endpoint service.
    :type service: str
    :param locations: A list of locations.
    :type locations: list[str]
    :param provisioning_state: The provisioning state of the resource.
    :type provisioning_state: str
    """

    _attribute_map = {
        'service': {'key': 'service', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        service: Optional[str] = None,
        locations: Optional[List[str]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ServiceEndpointPropertiesFormat, self).__init__(**kwargs)
        self.service = service
        self.locations = locations
        self.provisioning_state = provisioning_state


class Subnet(SubResource):
    """Subnet in a virtual network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param address_prefix: The address prefix for the subnet.
    :type address_prefix: str
    :param network_security_group: The reference of the NetworkSecurityGroup resource.
    :type network_security_group: ~azure.mgmt.network.v2018_01_01.models.NetworkSecurityGroup
    :param route_table: The reference of the RouteTable resource.
    :type route_table: ~azure.mgmt.network.v2018_01_01.models.RouteTable
    :param service_endpoints: An array of service endpoints.
    :type service_endpoints:
     list[~azure.mgmt.network.v2018_01_01.models.ServiceEndpointPropertiesFormat]
    :ivar ip_configurations: Gets an array of references to the network interface IP configurations
     using subnet.
    :vartype ip_configurations: list[~azure.mgmt.network.v2018_01_01.models.IPConfiguration]
    :param resource_navigation_links: Gets an array of references to the external resources using
     subnet.
    :type resource_navigation_links:
     list[~azure.mgmt.network.v2018_01_01.models.ResourceNavigationLink]
    :param provisioning_state: The provisioning state of the resource.
    :type provisioning_state: str
    """

    _validation = {
        'ip_configurations': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'NetworkSecurityGroup'},
        'route_table': {'key': 'properties.routeTable', 'type': 'RouteTable'},
        'service_endpoints': {'key': 'properties.serviceEndpoints', 'type': '[ServiceEndpointPropertiesFormat]'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[IPConfiguration]'},
        'resource_navigation_links': {'key': 'properties.resourceNavigationLinks', 'type': '[ResourceNavigationLink]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        address_prefix: Optional[str] = None,
        network_security_group: Optional["NetworkSecurityGroup"] = None,
        route_table: Optional["RouteTable"] = None,
        service_endpoints: Optional[List["ServiceEndpointPropertiesFormat"]] = None,
        resource_navigation_links: Optional[List["ResourceNavigationLink"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(Subnet, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.address_prefix = address_prefix
        self.network_security_group = network_security_group
        self.route_table = route_table
        self.service_endpoints = service_endpoints
        self.ip_configurations = None
        self.resource_navigation_links = resource_navigation_links
        self.provisioning_state = provisioning_state


class SubnetAssociation(msrest.serialization.Model):
    """Network interface and its custom security rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Subnet ID.
    :vartype id: str
    :param security_rules: Collection of custom security rules.
    :type security_rules: list[~azure.mgmt.network.v2018_01_01.models.SecurityRule]
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'security_rules': {'key': 'securityRules', 'type': '[SecurityRule]'},
    }

    def __init__(
        self,
        *,
        security_rules: Optional[List["SecurityRule"]] = None,
        **kwargs
    ):
        super(SubnetAssociation, self).__init__(**kwargs)
        self.id = None
        self.security_rules = security_rules


class SubnetListResult(msrest.serialization.Model):
    """Response for ListSubnets API service callRetrieves all subnet that belongs to a virtual network.

    :param value: The subnets in a virtual network.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.Subnet]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Subnet]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Subnet"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SubnetListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TagsObject(msrest.serialization.Model):
    """Tags object for patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TagsObject, self).__init__(**kwargs)
        self.tags = tags


class Topology(msrest.serialization.Model):
    """Topology of the specified resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: GUID representing the operation id.
    :vartype id: str
    :ivar created_date_time: The datetime when the topology was initially created for the resource
     group.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_modified: The datetime when the topology was last modified.
    :vartype last_modified: ~datetime.datetime
    :param resources:
    :type resources: list[~azure.mgmt.network.v2018_01_01.models.TopologyResource]
    """

    _validation = {
        'id': {'readonly': True},
        'created_date_time': {'readonly': True},
        'last_modified': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_modified': {'key': 'lastModified', 'type': 'iso-8601'},
        'resources': {'key': 'resources', 'type': '[TopologyResource]'},
    }

    def __init__(
        self,
        *,
        resources: Optional[List["TopologyResource"]] = None,
        **kwargs
    ):
        super(Topology, self).__init__(**kwargs)
        self.id = None
        self.created_date_time = None
        self.last_modified = None
        self.resources = resources


class TopologyAssociation(msrest.serialization.Model):
    """Resources that have an association with the parent resource.

    :param name: The name of the resource that is associated with the parent resource.
    :type name: str
    :param resource_id: The ID of the resource that is associated with the parent resource.
    :type resource_id: str
    :param association_type: The association type of the child resource to the parent resource.
     Possible values include: "Associated", "Contains".
    :type association_type: str or ~azure.mgmt.network.v2018_01_01.models.AssociationType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'association_type': {'key': 'associationType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        resource_id: Optional[str] = None,
        association_type: Optional[Union[str, "AssociationType"]] = None,
        **kwargs
    ):
        super(TopologyAssociation, self).__init__(**kwargs)
        self.name = name
        self.resource_id = resource_id
        self.association_type = association_type


class TopologyParameters(msrest.serialization.Model):
    """Parameters that define the representation of topology.

    :param target_resource_group_name: The name of the target resource group to perform topology
     on.
    :type target_resource_group_name: str
    :param target_virtual_network: The reference of the Virtual Network resource.
    :type target_virtual_network: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param target_subnet: The reference of the Subnet resource.
    :type target_subnet: ~azure.mgmt.network.v2018_01_01.models.SubResource
    """

    _attribute_map = {
        'target_resource_group_name': {'key': 'targetResourceGroupName', 'type': 'str'},
        'target_virtual_network': {'key': 'targetVirtualNetwork', 'type': 'SubResource'},
        'target_subnet': {'key': 'targetSubnet', 'type': 'SubResource'},
    }

    def __init__(
        self,
        *,
        target_resource_group_name: Optional[str] = None,
        target_virtual_network: Optional["SubResource"] = None,
        target_subnet: Optional["SubResource"] = None,
        **kwargs
    ):
        super(TopologyParameters, self).__init__(**kwargs)
        self.target_resource_group_name = target_resource_group_name
        self.target_virtual_network = target_virtual_network
        self.target_subnet = target_subnet


class TopologyResource(msrest.serialization.Model):
    """The network resource topology information for the given resource group.

    :param name: Name of the resource.
    :type name: str
    :param id: ID of the resource.
    :type id: str
    :param location: Resource location.
    :type location: str
    :param associations: Holds the associations the resource has with other resources in the
     resource group.
    :type associations: list[~azure.mgmt.network.v2018_01_01.models.TopologyAssociation]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'associations': {'key': 'associations', 'type': '[TopologyAssociation]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,
        location: Optional[str] = None,
        associations: Optional[List["TopologyAssociation"]] = None,
        **kwargs
    ):
        super(TopologyResource, self).__init__(**kwargs)
        self.name = name
        self.id = id
        self.location = location
        self.associations = associations


class TrafficAnalyticsConfigurationProperties(msrest.serialization.Model):
    """Parameters that define the configuration of traffic analytics.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Flag to enable/disable traffic analytics.
    :type enabled: bool
    :param workspace_id: Required. The resource guid of the attached workspace.
    :type workspace_id: str
    :param workspace_region: Required. The location of the attached workspace.
    :type workspace_region: str
    :param workspace_resource_id: Required. Resource Id of the attached workspace.
    :type workspace_resource_id: str
    """

    _validation = {
        'enabled': {'required': True},
        'workspace_id': {'required': True},
        'workspace_region': {'required': True},
        'workspace_resource_id': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
        'workspace_region': {'key': 'workspaceRegion', 'type': 'str'},
        'workspace_resource_id': {'key': 'workspaceResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        workspace_id: str,
        workspace_region: str,
        workspace_resource_id: str,
        **kwargs
    ):
        super(TrafficAnalyticsConfigurationProperties, self).__init__(**kwargs)
        self.enabled = enabled
        self.workspace_id = workspace_id
        self.workspace_region = workspace_region
        self.workspace_resource_id = workspace_resource_id


class TroubleshootingDetails(msrest.serialization.Model):
    """Information gained from troubleshooting of specified resource.

    :param id: The id of the get troubleshoot operation.
    :type id: str
    :param reason_type: Reason type of failure.
    :type reason_type: str
    :param summary: A summary of troubleshooting.
    :type summary: str
    :param detail: Details on troubleshooting results.
    :type detail: str
    :param recommended_actions: List of recommended actions.
    :type recommended_actions:
     list[~azure.mgmt.network.v2018_01_01.models.TroubleshootingRecommendedActions]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'reason_type': {'key': 'reasonType', 'type': 'str'},
        'summary': {'key': 'summary', 'type': 'str'},
        'detail': {'key': 'detail', 'type': 'str'},
        'recommended_actions': {'key': 'recommendedActions', 'type': '[TroubleshootingRecommendedActions]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        reason_type: Optional[str] = None,
        summary: Optional[str] = None,
        detail: Optional[str] = None,
        recommended_actions: Optional[List["TroubleshootingRecommendedActions"]] = None,
        **kwargs
    ):
        super(TroubleshootingDetails, self).__init__(**kwargs)
        self.id = id
        self.reason_type = reason_type
        self.summary = summary
        self.detail = detail
        self.recommended_actions = recommended_actions


class TroubleshootingParameters(msrest.serialization.Model):
    """Parameters that define the resource to troubleshoot.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The target resource to troubleshoot.
    :type target_resource_id: str
    :param storage_id: Required. The ID for the storage account to save the troubleshoot result.
    :type storage_id: str
    :param storage_path: Required. The path to the blob to save the troubleshoot result in.
    :type storage_path: str
    """

    _validation = {
        'target_resource_id': {'required': True},
        'storage_id': {'required': True},
        'storage_path': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'storage_id': {'key': 'properties.storageId', 'type': 'str'},
        'storage_path': {'key': 'properties.storagePath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        storage_id: str,
        storage_path: str,
        **kwargs
    ):
        super(TroubleshootingParameters, self).__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.storage_id = storage_id
        self.storage_path = storage_path


class TroubleshootingRecommendedActions(msrest.serialization.Model):
    """Recommended actions based on discovered issues.

    :param action_id: ID of the recommended action.
    :type action_id: str
    :param action_text: Description of recommended actions.
    :type action_text: str
    :param action_uri: The uri linking to a documentation for the recommended troubleshooting
     actions.
    :type action_uri: str
    :param action_uri_text: The information from the URI for the recommended troubleshooting
     actions.
    :type action_uri_text: str
    """

    _attribute_map = {
        'action_id': {'key': 'actionId', 'type': 'str'},
        'action_text': {'key': 'actionText', 'type': 'str'},
        'action_uri': {'key': 'actionUri', 'type': 'str'},
        'action_uri_text': {'key': 'actionUriText', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        action_id: Optional[str] = None,
        action_text: Optional[str] = None,
        action_uri: Optional[str] = None,
        action_uri_text: Optional[str] = None,
        **kwargs
    ):
        super(TroubleshootingRecommendedActions, self).__init__(**kwargs)
        self.action_id = action_id
        self.action_text = action_text
        self.action_uri = action_uri
        self.action_uri_text = action_uri_text


class TroubleshootingResult(msrest.serialization.Model):
    """Troubleshooting information gained from specified resource.

    :param start_time: The start time of the troubleshooting.
    :type start_time: ~datetime.datetime
    :param end_time: The end time of the troubleshooting.
    :type end_time: ~datetime.datetime
    :param code: The result code of the troubleshooting.
    :type code: str
    :param results: Information from troubleshooting.
    :type results: list[~azure.mgmt.network.v2018_01_01.models.TroubleshootingDetails]
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'code': {'key': 'code', 'type': 'str'},
        'results': {'key': 'results', 'type': '[TroubleshootingDetails]'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        code: Optional[str] = None,
        results: Optional[List["TroubleshootingDetails"]] = None,
        **kwargs
    ):
        super(TroubleshootingResult, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.code = code
        self.results = results


class TunnelConnectionHealth(msrest.serialization.Model):
    """VirtualNetworkGatewayConnection properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tunnel: Tunnel name.
    :vartype tunnel: str
    :ivar connection_status: Virtual network Gateway connection status. Possible values include:
     "Unknown", "Connecting", "Connected", "NotConnected".
    :vartype connection_status: str or
     ~azure.mgmt.network.v2018_01_01.models.VirtualNetworkGatewayConnectionStatus
    :ivar ingress_bytes_transferred: The Ingress Bytes Transferred in this connection.
    :vartype ingress_bytes_transferred: long
    :ivar egress_bytes_transferred: The Egress Bytes Transferred in this connection.
    :vartype egress_bytes_transferred: long
    :ivar last_connection_established_utc_time: The time at which connection was established in Utc
     format.
    :vartype last_connection_established_utc_time: str
    """

    _validation = {
        'tunnel': {'readonly': True},
        'connection_status': {'readonly': True},
        'ingress_bytes_transferred': {'readonly': True},
        'egress_bytes_transferred': {'readonly': True},
        'last_connection_established_utc_time': {'readonly': True},
    }

    _attribute_map = {
        'tunnel': {'key': 'tunnel', 'type': 'str'},
        'connection_status': {'key': 'connectionStatus', 'type': 'str'},
        'ingress_bytes_transferred': {'key': 'ingressBytesTransferred', 'type': 'long'},
        'egress_bytes_transferred': {'key': 'egressBytesTransferred', 'type': 'long'},
        'last_connection_established_utc_time': {'key': 'lastConnectionEstablishedUtcTime', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TunnelConnectionHealth, self).__init__(**kwargs)
        self.tunnel = None
        self.connection_status = None
        self.ingress_bytes_transferred = None
        self.egress_bytes_transferred = None
        self.last_connection_established_utc_time = None


class Usage(msrest.serialization.Model):
    """Describes network resource usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource identifier.
    :vartype id: str
    :ivar unit: Required. An enum describing the unit of measurement. Default value: "Count".
    :vartype unit: str
    :param current_value: Required. The current value of the usage.
    :type current_value: long
    :param limit: Required. The limit of usage.
    :type limit: long
    :param name: Required. The name of the type of usage.
    :type name: ~azure.mgmt.network.v2018_01_01.models.UsageName
    """

    _validation = {
        'id': {'readonly': True},
        'unit': {'required': True, 'constant': True},
        'current_value': {'required': True},
        'limit': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    unit = "Count"

    def __init__(
        self,
        *,
        current_value: int,
        limit: int,
        name: "UsageName",
        **kwargs
    ):
        super(Usage, self).__init__(**kwargs)
        self.id = None
        self.current_value = current_value
        self.limit = limit
        self.name = name


class UsageName(msrest.serialization.Model):
    """The usage names.

    :param value: A string describing the resource name.
    :type value: str
    :param localized_value: A localized string describing the resource name.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        super(UsageName, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class UsagesListResult(msrest.serialization.Model):
    """The list usages operation response.

    :param value: The list network resource usages.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.Usage]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Usage"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(UsagesListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VerificationIPFlowParameters(msrest.serialization.Model):
    """Parameters that define the IP flow to be verified.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The ID of the target resource to perform next-hop on.
    :type target_resource_id: str
    :param direction: Required. The direction of the packet represented as a 5-tuple. Possible
     values include: "Inbound", "Outbound".
    :type direction: str or ~azure.mgmt.network.v2018_01_01.models.Direction
    :param protocol: Required. Protocol to be verified on. Possible values include: "TCP", "UDP".
    :type protocol: str or ~azure.mgmt.network.v2018_01_01.models.Protocol
    :param local_port: Required. The local port. Acceptable values are a single integer in the
     range (0-65535). Support for * for the source port, which depends on the direction.
    :type local_port: str
    :param remote_port: Required. The remote port. Acceptable values are a single integer in the
     range (0-65535). Support for * for the source port, which depends on the direction.
    :type remote_port: str
    :param local_ip_address: Required. The local IP address. Acceptable values are valid IPv4
     addresses.
    :type local_ip_address: str
    :param remote_ip_address: Required. The remote IP address. Acceptable values are valid IPv4
     addresses.
    :type remote_ip_address: str
    :param target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP forwarding is
     enabled on any of them, then this parameter must be specified. Otherwise optional).
    :type target_nic_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
        'direction': {'required': True},
        'protocol': {'required': True},
        'local_port': {'required': True},
        'remote_port': {'required': True},
        'local_ip_address': {'required': True},
        'remote_ip_address': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'direction': {'key': 'direction', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'local_port': {'key': 'localPort', 'type': 'str'},
        'remote_port': {'key': 'remotePort', 'type': 'str'},
        'local_ip_address': {'key': 'localIPAddress', 'type': 'str'},
        'remote_ip_address': {'key': 'remoteIPAddress', 'type': 'str'},
        'target_nic_resource_id': {'key': 'targetNicResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        direction: Union[str, "Direction"],
        protocol: Union[str, "Protocol"],
        local_port: str,
        remote_port: str,
        local_ip_address: str,
        remote_ip_address: str,
        target_nic_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(VerificationIPFlowParameters, self).__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.direction = direction
        self.protocol = protocol
        self.local_port = local_port
        self.remote_port = remote_port
        self.local_ip_address = local_ip_address
        self.remote_ip_address = remote_ip_address
        self.target_nic_resource_id = target_nic_resource_id


class VerificationIPFlowResult(msrest.serialization.Model):
    """Results of IP flow verification on the target resource.

    :param access: Indicates whether the traffic is allowed or denied. Possible values include:
     "Allow", "Deny".
    :type access: str or ~azure.mgmt.network.v2018_01_01.models.Access
    :param rule_name: Name of the rule. If input is not matched against any security rule, it is
     not displayed.
    :type rule_name: str
    """

    _attribute_map = {
        'access': {'key': 'access', 'type': 'str'},
        'rule_name': {'key': 'ruleName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        access: Optional[Union[str, "Access"]] = None,
        rule_name: Optional[str] = None,
        **kwargs
    ):
        super(VerificationIPFlowResult, self).__init__(**kwargs)
        self.access = access
        self.rule_name = rule_name


class VirtualNetwork(Resource):
    """Virtual Network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param address_space: The AddressSpace that contains an array of IP address ranges that can be
     used by subnets.
    :type address_space: ~azure.mgmt.network.v2018_01_01.models.AddressSpace
    :param dhcp_options: The dhcpOptions that contains an array of DNS servers available to VMs
     deployed in the virtual network.
    :type dhcp_options: ~azure.mgmt.network.v2018_01_01.models.DhcpOptions
    :param subnets: A list of subnets in a Virtual Network.
    :type subnets: list[~azure.mgmt.network.v2018_01_01.models.Subnet]
    :param virtual_network_peerings: A list of peerings in a Virtual Network.
    :type virtual_network_peerings:
     list[~azure.mgmt.network.v2018_01_01.models.VirtualNetworkPeering]
    :param resource_guid: The resourceGuid property of the Virtual Network resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the PublicIP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param enable_ddos_protection: Indicates if DDoS protection is enabled for all the protected
     resources in a Virtual Network.
    :type enable_ddos_protection: bool
    :param enable_vm_protection: Indicates if Vm protection is enabled for all the subnets in a
     Virtual Network.
    :type enable_vm_protection: bool
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'address_space': {'key': 'properties.addressSpace', 'type': 'AddressSpace'},
        'dhcp_options': {'key': 'properties.dhcpOptions', 'type': 'DhcpOptions'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'virtual_network_peerings': {'key': 'properties.virtualNetworkPeerings', 'type': '[VirtualNetworkPeering]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'enable_ddos_protection': {'key': 'properties.enableDdosProtection', 'type': 'bool'},
        'enable_vm_protection': {'key': 'properties.enableVmProtection', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        address_space: Optional["AddressSpace"] = None,
        dhcp_options: Optional["DhcpOptions"] = None,
        subnets: Optional[List["Subnet"]] = None,
        virtual_network_peerings: Optional[List["VirtualNetworkPeering"]] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        enable_ddos_protection: Optional[bool] = None,
        enable_vm_protection: Optional[bool] = None,
        **kwargs
    ):
        super(VirtualNetwork, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.address_space = address_space
        self.dhcp_options = dhcp_options
        self.subnets = subnets
        self.virtual_network_peerings = virtual_network_peerings
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state
        self.enable_ddos_protection = enable_ddos_protection
        self.enable_vm_protection = enable_vm_protection


class VirtualNetworkConnectionGatewayReference(msrest.serialization.Model):
    """A reference to VirtualNetworkGateway or LocalNetworkGateway resource.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of VirtualNetworkGateway or LocalNetworkGateway resource.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        super(VirtualNetworkConnectionGatewayReference, self).__init__(**kwargs)
        self.id = id


class VirtualNetworkGateway(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param ip_configurations: IP configurations for virtual network gateway.
    :type ip_configurations:
     list[~azure.mgmt.network.v2018_01_01.models.VirtualNetworkGatewayIPConfiguration]
    :param gateway_type: The type of this virtual network gateway. Possible values are: 'Vpn' and
     'ExpressRoute'. Possible values include: "Vpn", "ExpressRoute".
    :type gateway_type: str or ~azure.mgmt.network.v2018_01_01.models.VirtualNetworkGatewayType
    :param vpn_type: The type of this virtual network gateway. Possible values are: 'PolicyBased'
     and 'RouteBased'. Possible values include: "PolicyBased", "RouteBased".
    :type vpn_type: str or ~azure.mgmt.network.v2018_01_01.models.VpnType
    :param enable_bgp: Whether BGP is enabled for this virtual network gateway or not.
    :type enable_bgp: bool
    :param active: ActiveActive flag.
    :type active: bool
    :param gateway_default_site: The reference of the LocalNetworkGateway resource which represents
     local network site having default routes. Assign Null value in case of removing existing
     default site setting.
    :type gateway_default_site: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param sku: The reference of the VirtualNetworkGatewaySku resource which represents the SKU
     selected for Virtual network gateway.
    :type sku: ~azure.mgmt.network.v2018_01_01.models.VirtualNetworkGatewaySku
    :param vpn_client_configuration: The reference of the VpnClientConfiguration resource which
     represents the P2S VpnClient configurations.
    :type vpn_client_configuration: ~azure.mgmt.network.v2018_01_01.models.VpnClientConfiguration
    :param bgp_settings: Virtual network gateway's BGP speaker settings.
    :type bgp_settings: ~azure.mgmt.network.v2018_01_01.models.BgpSettings
    :param resource_guid: The resource GUID property of the VirtualNetworkGateway resource.
    :type resource_guid: str
    :ivar provisioning_state: The provisioning state of the VirtualNetworkGateway resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[VirtualNetworkGatewayIPConfiguration]'},
        'gateway_type': {'key': 'properties.gatewayType', 'type': 'str'},
        'vpn_type': {'key': 'properties.vpnType', 'type': 'str'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'active': {'key': 'properties.activeActive', 'type': 'bool'},
        'gateway_default_site': {'key': 'properties.gatewayDefaultSite', 'type': 'SubResource'},
        'sku': {'key': 'properties.sku', 'type': 'VirtualNetworkGatewaySku'},
        'vpn_client_configuration': {'key': 'properties.vpnClientConfiguration', 'type': 'VpnClientConfiguration'},
        'bgp_settings': {'key': 'properties.bgpSettings', 'type': 'BgpSettings'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        ip_configurations: Optional[List["VirtualNetworkGatewayIPConfiguration"]] = None,
        gateway_type: Optional[Union[str, "VirtualNetworkGatewayType"]] = None,
        vpn_type: Optional[Union[str, "VpnType"]] = None,
        enable_bgp: Optional[bool] = None,
        active: Optional[bool] = None,
        gateway_default_site: Optional["SubResource"] = None,
        sku: Optional["VirtualNetworkGatewaySku"] = None,
        vpn_client_configuration: Optional["VpnClientConfiguration"] = None,
        bgp_settings: Optional["BgpSettings"] = None,
        resource_guid: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkGateway, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.ip_configurations = ip_configurations
        self.gateway_type = gateway_type
        self.vpn_type = vpn_type
        self.enable_bgp = enable_bgp
        self.active = active
        self.gateway_default_site = gateway_default_site
        self.sku = sku
        self.vpn_client_configuration = vpn_client_configuration
        self.bgp_settings = bgp_settings
        self.resource_guid = resource_guid
        self.provisioning_state = None


class VirtualNetworkGatewayConnection(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param authorization_key: The authorizationKey.
    :type authorization_key: str
    :param virtual_network_gateway1: Required. The reference to virtual network gateway resource.
    :type virtual_network_gateway1: ~azure.mgmt.network.v2018_01_01.models.VirtualNetworkGateway
    :param virtual_network_gateway2: The reference to virtual network gateway resource.
    :type virtual_network_gateway2: ~azure.mgmt.network.v2018_01_01.models.VirtualNetworkGateway
    :param local_network_gateway2: The reference to local network gateway resource.
    :type local_network_gateway2: ~azure.mgmt.network.v2018_01_01.models.LocalNetworkGateway
    :param connection_type: Required. Gateway connection type. Possible values are:
     'IPsec','Vnet2Vnet','ExpressRoute', and 'VPNClient. Possible values include: "IPsec",
     "Vnet2Vnet", "ExpressRoute", "VPNClient".
    :type connection_type: str or
     ~azure.mgmt.network.v2018_01_01.models.VirtualNetworkGatewayConnectionType
    :param routing_weight: The routing weight.
    :type routing_weight: int
    :param shared_key: The IPSec shared key.
    :type shared_key: str
    :ivar connection_status: Virtual network Gateway connection status. Possible values are
     'Unknown', 'Connecting', 'Connected' and 'NotConnected'. Possible values include: "Unknown",
     "Connecting", "Connected", "NotConnected".
    :vartype connection_status: str or
     ~azure.mgmt.network.v2018_01_01.models.VirtualNetworkGatewayConnectionStatus
    :ivar tunnel_connection_status: Collection of all tunnels' connection health status.
    :vartype tunnel_connection_status:
     list[~azure.mgmt.network.v2018_01_01.models.TunnelConnectionHealth]
    :ivar egress_bytes_transferred: The egress bytes transferred in this connection.
    :vartype egress_bytes_transferred: long
    :ivar ingress_bytes_transferred: The ingress bytes transferred in this connection.
    :vartype ingress_bytes_transferred: long
    :param peer: The reference to peerings resource.
    :type peer: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param enable_bgp: EnableBgp flag.
    :type enable_bgp: bool
    :param use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
    :type use_policy_based_traffic_selectors: bool
    :param ipsec_policies: The IPSec Policies to be considered by this connection.
    :type ipsec_policies: list[~azure.mgmt.network.v2018_01_01.models.IpsecPolicy]
    :param resource_guid: The resource GUID property of the VirtualNetworkGatewayConnection
     resource.
    :type resource_guid: str
    :ivar provisioning_state: The provisioning state of the VirtualNetworkGatewayConnection
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_network_gateway1': {'required': True},
        'connection_type': {'required': True},
        'connection_status': {'readonly': True},
        'tunnel_connection_status': {'readonly': True},
        'egress_bytes_transferred': {'readonly': True},
        'ingress_bytes_transferred': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'virtual_network_gateway1': {'key': 'properties.virtualNetworkGateway1', 'type': 'VirtualNetworkGateway'},
        'virtual_network_gateway2': {'key': 'properties.virtualNetworkGateway2', 'type': 'VirtualNetworkGateway'},
        'local_network_gateway2': {'key': 'properties.localNetworkGateway2', 'type': 'LocalNetworkGateway'},
        'connection_type': {'key': 'properties.connectionType', 'type': 'str'},
        'routing_weight': {'key': 'properties.routingWeight', 'type': 'int'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'connection_status': {'key': 'properties.connectionStatus', 'type': 'str'},
        'tunnel_connection_status': {'key': 'properties.tunnelConnectionStatus', 'type': '[TunnelConnectionHealth]'},
        'egress_bytes_transferred': {'key': 'properties.egressBytesTransferred', 'type': 'long'},
        'ingress_bytes_transferred': {'key': 'properties.ingressBytesTransferred', 'type': 'long'},
        'peer': {'key': 'properties.peer', 'type': 'SubResource'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'use_policy_based_traffic_selectors': {'key': 'properties.usePolicyBasedTrafficSelectors', 'type': 'bool'},
        'ipsec_policies': {'key': 'properties.ipsecPolicies', 'type': '[IpsecPolicy]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        virtual_network_gateway1: "VirtualNetworkGateway",
        connection_type: Union[str, "VirtualNetworkGatewayConnectionType"],
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        authorization_key: Optional[str] = None,
        virtual_network_gateway2: Optional["VirtualNetworkGateway"] = None,
        local_network_gateway2: Optional["LocalNetworkGateway"] = None,
        routing_weight: Optional[int] = None,
        shared_key: Optional[str] = None,
        peer: Optional["SubResource"] = None,
        enable_bgp: Optional[bool] = None,
        use_policy_based_traffic_selectors: Optional[bool] = None,
        ipsec_policies: Optional[List["IpsecPolicy"]] = None,
        resource_guid: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkGatewayConnection, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.authorization_key = authorization_key
        self.virtual_network_gateway1 = virtual_network_gateway1
        self.virtual_network_gateway2 = virtual_network_gateway2
        self.local_network_gateway2 = local_network_gateway2
        self.connection_type = connection_type
        self.routing_weight = routing_weight
        self.shared_key = shared_key
        self.connection_status = None
        self.tunnel_connection_status = None
        self.egress_bytes_transferred = None
        self.ingress_bytes_transferred = None
        self.peer = peer
        self.enable_bgp = enable_bgp
        self.use_policy_based_traffic_selectors = use_policy_based_traffic_selectors
        self.ipsec_policies = ipsec_policies
        self.resource_guid = resource_guid
        self.provisioning_state = None


class VirtualNetworkGatewayConnectionListEntity(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param authorization_key: The authorizationKey.
    :type authorization_key: str
    :param virtual_network_gateway1: Required. The reference to virtual network gateway resource.
    :type virtual_network_gateway1:
     ~azure.mgmt.network.v2018_01_01.models.VirtualNetworkConnectionGatewayReference
    :param virtual_network_gateway2: The reference to virtual network gateway resource.
    :type virtual_network_gateway2:
     ~azure.mgmt.network.v2018_01_01.models.VirtualNetworkConnectionGatewayReference
    :param local_network_gateway2: The reference to local network gateway resource.
    :type local_network_gateway2:
     ~azure.mgmt.network.v2018_01_01.models.VirtualNetworkConnectionGatewayReference
    :param connection_type: Required. Gateway connection type. Possible values are:
     'IPsec','Vnet2Vnet','ExpressRoute', and 'VPNClient. Possible values include: "IPsec",
     "Vnet2Vnet", "ExpressRoute", "VPNClient".
    :type connection_type: str or
     ~azure.mgmt.network.v2018_01_01.models.VirtualNetworkGatewayConnectionType
    :param routing_weight: The routing weight.
    :type routing_weight: int
    :param shared_key: The IPSec shared key.
    :type shared_key: str
    :ivar connection_status: Virtual network Gateway connection status. Possible values are
     'Unknown', 'Connecting', 'Connected' and 'NotConnected'. Possible values include: "Unknown",
     "Connecting", "Connected", "NotConnected".
    :vartype connection_status: str or
     ~azure.mgmt.network.v2018_01_01.models.VirtualNetworkGatewayConnectionStatus
    :ivar tunnel_connection_status: Collection of all tunnels' connection health status.
    :vartype tunnel_connection_status:
     list[~azure.mgmt.network.v2018_01_01.models.TunnelConnectionHealth]
    :ivar egress_bytes_transferred: The egress bytes transferred in this connection.
    :vartype egress_bytes_transferred: long
    :ivar ingress_bytes_transferred: The ingress bytes transferred in this connection.
    :vartype ingress_bytes_transferred: long
    :param peer: The reference to peerings resource.
    :type peer: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param enable_bgp: EnableBgp flag.
    :type enable_bgp: bool
    :param use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
    :type use_policy_based_traffic_selectors: bool
    :param ipsec_policies: The IPSec Policies to be considered by this connection.
    :type ipsec_policies: list[~azure.mgmt.network.v2018_01_01.models.IpsecPolicy]
    :param resource_guid: The resource GUID property of the VirtualNetworkGatewayConnection
     resource.
    :type resource_guid: str
    :ivar provisioning_state: The provisioning state of the VirtualNetworkGatewayConnection
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_network_gateway1': {'required': True},
        'connection_type': {'required': True},
        'connection_status': {'readonly': True},
        'tunnel_connection_status': {'readonly': True},
        'egress_bytes_transferred': {'readonly': True},
        'ingress_bytes_transferred': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'virtual_network_gateway1': {'key': 'properties.virtualNetworkGateway1', 'type': 'VirtualNetworkConnectionGatewayReference'},
        'virtual_network_gateway2': {'key': 'properties.virtualNetworkGateway2', 'type': 'VirtualNetworkConnectionGatewayReference'},
        'local_network_gateway2': {'key': 'properties.localNetworkGateway2', 'type': 'VirtualNetworkConnectionGatewayReference'},
        'connection_type': {'key': 'properties.connectionType', 'type': 'str'},
        'routing_weight': {'key': 'properties.routingWeight', 'type': 'int'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'connection_status': {'key': 'properties.connectionStatus', 'type': 'str'},
        'tunnel_connection_status': {'key': 'properties.tunnelConnectionStatus', 'type': '[TunnelConnectionHealth]'},
        'egress_bytes_transferred': {'key': 'properties.egressBytesTransferred', 'type': 'long'},
        'ingress_bytes_transferred': {'key': 'properties.ingressBytesTransferred', 'type': 'long'},
        'peer': {'key': 'properties.peer', 'type': 'SubResource'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'use_policy_based_traffic_selectors': {'key': 'properties.usePolicyBasedTrafficSelectors', 'type': 'bool'},
        'ipsec_policies': {'key': 'properties.ipsecPolicies', 'type': '[IpsecPolicy]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        virtual_network_gateway1: "VirtualNetworkConnectionGatewayReference",
        connection_type: Union[str, "VirtualNetworkGatewayConnectionType"],
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        authorization_key: Optional[str] = None,
        virtual_network_gateway2: Optional["VirtualNetworkConnectionGatewayReference"] = None,
        local_network_gateway2: Optional["VirtualNetworkConnectionGatewayReference"] = None,
        routing_weight: Optional[int] = None,
        shared_key: Optional[str] = None,
        peer: Optional["SubResource"] = None,
        enable_bgp: Optional[bool] = None,
        use_policy_based_traffic_selectors: Optional[bool] = None,
        ipsec_policies: Optional[List["IpsecPolicy"]] = None,
        resource_guid: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkGatewayConnectionListEntity, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.authorization_key = authorization_key
        self.virtual_network_gateway1 = virtual_network_gateway1
        self.virtual_network_gateway2 = virtual_network_gateway2
        self.local_network_gateway2 = local_network_gateway2
        self.connection_type = connection_type
        self.routing_weight = routing_weight
        self.shared_key = shared_key
        self.connection_status = None
        self.tunnel_connection_status = None
        self.egress_bytes_transferred = None
        self.ingress_bytes_transferred = None
        self.peer = peer
        self.enable_bgp = enable_bgp
        self.use_policy_based_traffic_selectors = use_policy_based_traffic_selectors
        self.ipsec_policies = ipsec_policies
        self.resource_guid = resource_guid
        self.provisioning_state = None


class VirtualNetworkGatewayConnectionListResult(msrest.serialization.Model):
    """Response for the ListVirtualNetworkGatewayConnections API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: Gets a list of VirtualNetworkGatewayConnection resources that exists in a
     resource group.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.VirtualNetworkGatewayConnection]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkGatewayConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VirtualNetworkGatewayConnection"]] = None,
        **kwargs
    ):
        super(VirtualNetworkGatewayConnectionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class VirtualNetworkGatewayIPConfiguration(SubResource):
    """IP configuration for virtual network gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param private_ip_allocation_method: The private IP allocation method. Possible values are:
     'Static' and 'Dynamic'. Possible values include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2018_01_01.models.IPAllocationMethod
    :param subnet: The reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param public_ip_address: The reference of the public IP resource.
    :type public_ip_address: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "IPAllocationMethod"]] = None,
        subnet: Optional["SubResource"] = None,
        public_ip_address: Optional["SubResource"] = None,
        **kwargs
    ):
        super(VirtualNetworkGatewayIPConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = None


class VirtualNetworkGatewayListConnectionsResult(msrest.serialization.Model):
    """Response for the VirtualNetworkGatewayListConnections API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: Gets a list of VirtualNetworkGatewayConnection resources that exists in a
     resource group.
    :type value:
     list[~azure.mgmt.network.v2018_01_01.models.VirtualNetworkGatewayConnectionListEntity]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkGatewayConnectionListEntity]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VirtualNetworkGatewayConnectionListEntity"]] = None,
        **kwargs
    ):
        super(VirtualNetworkGatewayListConnectionsResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class VirtualNetworkGatewayListResult(msrest.serialization.Model):
    """Response for the ListVirtualNetworkGateways API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: Gets a list of VirtualNetworkGateway resources that exists in a resource group.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.VirtualNetworkGateway]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkGateway]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VirtualNetworkGateway"]] = None,
        **kwargs
    ):
        super(VirtualNetworkGatewayListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class VirtualNetworkGatewaySku(msrest.serialization.Model):
    """VirtualNetworkGatewaySku details.

    :param name: Gateway SKU name. Possible values include: "Basic", "HighPerformance", "Standard",
     "UltraPerformance", "VpnGw1", "VpnGw2", "VpnGw3".
    :type name: str or ~azure.mgmt.network.v2018_01_01.models.VirtualNetworkGatewaySkuName
    :param tier: Gateway SKU tier. Possible values include: "Basic", "HighPerformance", "Standard",
     "UltraPerformance", "VpnGw1", "VpnGw2", "VpnGw3".
    :type tier: str or ~azure.mgmt.network.v2018_01_01.models.VirtualNetworkGatewaySkuTier
    :param capacity: The capacity.
    :type capacity: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "VirtualNetworkGatewaySkuName"]] = None,
        tier: Optional[Union[str, "VirtualNetworkGatewaySkuTier"]] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(VirtualNetworkGatewaySku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class VirtualNetworkListResult(msrest.serialization.Model):
    """Response for the ListVirtualNetworks API service call.

    :param value: Gets a list of VirtualNetwork resources in a resource group.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.VirtualNetwork]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetwork]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VirtualNetwork"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualNetworkListUsageResult(msrest.serialization.Model):
    """Response for the virtual networks GetUsage API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: VirtualNetwork usage stats.
    :vartype value: list[~azure.mgmt.network.v2018_01_01.models.VirtualNetworkUsage]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkUsage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkListUsageResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class VirtualNetworkPeering(SubResource):
    """Peerings in a virtual network resource.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param allow_virtual_network_access: Whether the VMs in the linked virtual network space would
     be able to access all the VMs in local Virtual network space.
    :type allow_virtual_network_access: bool
    :param allow_forwarded_traffic: Whether the forwarded traffic from the VMs in the remote
     virtual network will be allowed/disallowed.
    :type allow_forwarded_traffic: bool
    :param allow_gateway_transit: If gateway links can be used in remote virtual networking to link
     to this virtual network.
    :type allow_gateway_transit: bool
    :param use_remote_gateways: If remote gateways can be used on this virtual network. If the flag
     is set to true, and allowGatewayTransit on remote peering is also true, virtual network will
     use gateways of remote virtual network for transit. Only one peering can have this flag set to
     true. This flag cannot be set if virtual network already has a gateway.
    :type use_remote_gateways: bool
    :param remote_virtual_network: The reference of the remote virtual network. The remote virtual
     network can be in the same or different region (preview). See here to register for the preview
     and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-
     peering).
    :type remote_virtual_network: ~azure.mgmt.network.v2018_01_01.models.SubResource
    :param remote_address_space: The reference of the remote virtual network address space.
    :type remote_address_space: ~azure.mgmt.network.v2018_01_01.models.AddressSpace
    :param peering_state: The status of the virtual network peering. Possible values are
     'Initiated', 'Connected', and 'Disconnected'. Possible values include: "Initiated",
     "Connected", "Disconnected".
    :type peering_state: str or ~azure.mgmt.network.v2018_01_01.models.VirtualNetworkPeeringState
    :param provisioning_state: The provisioning state of the resource.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'allow_virtual_network_access': {'key': 'properties.allowVirtualNetworkAccess', 'type': 'bool'},
        'allow_forwarded_traffic': {'key': 'properties.allowForwardedTraffic', 'type': 'bool'},
        'allow_gateway_transit': {'key': 'properties.allowGatewayTransit', 'type': 'bool'},
        'use_remote_gateways': {'key': 'properties.useRemoteGateways', 'type': 'bool'},
        'remote_virtual_network': {'key': 'properties.remoteVirtualNetwork', 'type': 'SubResource'},
        'remote_address_space': {'key': 'properties.remoteAddressSpace', 'type': 'AddressSpace'},
        'peering_state': {'key': 'properties.peeringState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        allow_virtual_network_access: Optional[bool] = None,
        allow_forwarded_traffic: Optional[bool] = None,
        allow_gateway_transit: Optional[bool] = None,
        use_remote_gateways: Optional[bool] = None,
        remote_virtual_network: Optional["SubResource"] = None,
        remote_address_space: Optional["AddressSpace"] = None,
        peering_state: Optional[Union[str, "VirtualNetworkPeeringState"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkPeering, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.allow_virtual_network_access = allow_virtual_network_access
        self.allow_forwarded_traffic = allow_forwarded_traffic
        self.allow_gateway_transit = allow_gateway_transit
        self.use_remote_gateways = use_remote_gateways
        self.remote_virtual_network = remote_virtual_network
        self.remote_address_space = remote_address_space
        self.peering_state = peering_state
        self.provisioning_state = provisioning_state


class VirtualNetworkPeeringListResult(msrest.serialization.Model):
    """Response for ListSubnets API service call. Retrieves all subnets that belong to a virtual network.

    :param value: The peerings in a virtual network.
    :type value: list[~azure.mgmt.network.v2018_01_01.models.VirtualNetworkPeering]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkPeering]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VirtualNetworkPeering"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkPeeringListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualNetworkUsage(msrest.serialization.Model):
    """Usage details for subnet.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar current_value: Indicates number of IPs used from the Subnet.
    :vartype current_value: float
    :ivar id: Subnet identifier.
    :vartype id: str
    :ivar limit: Indicates the size of the subnet.
    :vartype limit: float
    :ivar name: The name containing common and localized value for usage.
    :vartype name: ~azure.mgmt.network.v2018_01_01.models.VirtualNetworkUsageName
    :ivar unit: Usage units. Returns 'Count'.
    :vartype unit: str
    """

    _validation = {
        'current_value': {'readonly': True},
        'id': {'readonly': True},
        'limit': {'readonly': True},
        'name': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'current_value': {'key': 'currentValue', 'type': 'float'},
        'id': {'key': 'id', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'float'},
        'name': {'key': 'name', 'type': 'VirtualNetworkUsageName'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkUsage, self).__init__(**kwargs)
        self.current_value = None
        self.id = None
        self.limit = None
        self.name = None
        self.unit = None


class VirtualNetworkUsageName(msrest.serialization.Model):
    """Usage strings container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar localized_value: Localized subnet size and usage string.
    :vartype localized_value: str
    :ivar value: Subnet size and usage string.
    :vartype value: str
    """

    _validation = {
        'localized_value': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkUsageName, self).__init__(**kwargs)
        self.localized_value = None
        self.value = None


class VpnClientConfiguration(msrest.serialization.Model):
    """VpnClientConfiguration for P2S client.

    :param vpn_client_address_pool: The reference of the address space resource which represents
     Address space for P2S VpnClient.
    :type vpn_client_address_pool: ~azure.mgmt.network.v2018_01_01.models.AddressSpace
    :param vpn_client_root_certificates: VpnClientRootCertificate for virtual network gateway.
    :type vpn_client_root_certificates:
     list[~azure.mgmt.network.v2018_01_01.models.VpnClientRootCertificate]
    :param vpn_client_revoked_certificates: VpnClientRevokedCertificate for Virtual network
     gateway.
    :type vpn_client_revoked_certificates:
     list[~azure.mgmt.network.v2018_01_01.models.VpnClientRevokedCertificate]
    :param vpn_client_protocols: VpnClientProtocols for Virtual network gateway.
    :type vpn_client_protocols: list[str or
     ~azure.mgmt.network.v2018_01_01.models.VpnClientProtocol]
    :param radius_server_address: The radius server address property of the VirtualNetworkGateway
     resource for vpn client connection.
    :type radius_server_address: str
    :param radius_server_secret: The radius secret property of the VirtualNetworkGateway resource
     for vpn client connection.
    :type radius_server_secret: str
    """

    _attribute_map = {
        'vpn_client_address_pool': {'key': 'vpnClientAddressPool', 'type': 'AddressSpace'},
        'vpn_client_root_certificates': {'key': 'vpnClientRootCertificates', 'type': '[VpnClientRootCertificate]'},
        'vpn_client_revoked_certificates': {'key': 'vpnClientRevokedCertificates', 'type': '[VpnClientRevokedCertificate]'},
        'vpn_client_protocols': {'key': 'vpnClientProtocols', 'type': '[str]'},
        'radius_server_address': {'key': 'radiusServerAddress', 'type': 'str'},
        'radius_server_secret': {'key': 'radiusServerSecret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        vpn_client_address_pool: Optional["AddressSpace"] = None,
        vpn_client_root_certificates: Optional[List["VpnClientRootCertificate"]] = None,
        vpn_client_revoked_certificates: Optional[List["VpnClientRevokedCertificate"]] = None,
        vpn_client_protocols: Optional[List[Union[str, "VpnClientProtocol"]]] = None,
        radius_server_address: Optional[str] = None,
        radius_server_secret: Optional[str] = None,
        **kwargs
    ):
        super(VpnClientConfiguration, self).__init__(**kwargs)
        self.vpn_client_address_pool = vpn_client_address_pool
        self.vpn_client_root_certificates = vpn_client_root_certificates
        self.vpn_client_revoked_certificates = vpn_client_revoked_certificates
        self.vpn_client_protocols = vpn_client_protocols
        self.radius_server_address = radius_server_address
        self.radius_server_secret = radius_server_secret


class VpnClientParameters(msrest.serialization.Model):
    """Vpn Client Parameters for package generation.

    :param processor_architecture: VPN client Processor Architecture. Possible values are: 'AMD64'
     and 'X86'. Possible values include: "Amd64", "X86".
    :type processor_architecture: str or
     ~azure.mgmt.network.v2018_01_01.models.ProcessorArchitecture
    :param authentication_method: VPN client Authentication Method. Possible values are: 'EAPTLS'
     and 'EAPMSCHAPv2'. Possible values include: "EAPTLS", "EAPMSCHAPv2".
    :type authentication_method: str or ~azure.mgmt.network.v2018_01_01.models.AuthenticationMethod
    :param radius_server_auth_certificate: The public certificate data for the radius server
     authentication certificate as a Base-64 encoded string. Required only if external radius
     authentication has been configured with EAPTLS authentication.
    :type radius_server_auth_certificate: str
    :param client_root_certificates: A list of client root certificates public certificate data
     encoded as Base-64 strings. Optional parameter for external radius based authentication with
     EAPTLS.
    :type client_root_certificates: list[str]
    """

    _attribute_map = {
        'processor_architecture': {'key': 'processorArchitecture', 'type': 'str'},
        'authentication_method': {'key': 'authenticationMethod', 'type': 'str'},
        'radius_server_auth_certificate': {'key': 'radiusServerAuthCertificate', 'type': 'str'},
        'client_root_certificates': {'key': 'clientRootCertificates', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        processor_architecture: Optional[Union[str, "ProcessorArchitecture"]] = None,
        authentication_method: Optional[Union[str, "AuthenticationMethod"]] = None,
        radius_server_auth_certificate: Optional[str] = None,
        client_root_certificates: Optional[List[str]] = None,
        **kwargs
    ):
        super(VpnClientParameters, self).__init__(**kwargs)
        self.processor_architecture = processor_architecture
        self.authentication_method = authentication_method
        self.radius_server_auth_certificate = radius_server_auth_certificate
        self.client_root_certificates = client_root_certificates


class VpnClientRevokedCertificate(SubResource):
    """VPN client revoked certificate of virtual network gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param thumbprint: The revoked VPN client certificate thumbprint.
    :type thumbprint: str
    :ivar provisioning_state: The provisioning state of the VPN client revoked certificate
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        thumbprint: Optional[str] = None,
        **kwargs
    ):
        super(VpnClientRevokedCertificate, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.thumbprint = thumbprint
        self.provisioning_state = None


class VpnClientRootCertificate(SubResource):
    """VPN client root certificate of virtual network gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param public_cert_data: Required. The certificate public data.
    :type public_cert_data: str
    :ivar provisioning_state: The provisioning state of the VPN client root certificate resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        'public_cert_data': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'public_cert_data': {'key': 'properties.publicCertData', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        public_cert_data: str,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        **kwargs
    ):
        super(VpnClientRootCertificate, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.public_cert_data = public_cert_data
        self.provisioning_state = None


class VpnDeviceScriptParameters(msrest.serialization.Model):
    """Vpn device configuration script generation parameters.

    :param vendor: The vendor for the vpn device.
    :type vendor: str
    :param device_family: The device family for the vpn device.
    :type device_family: str
    :param firmware_version: The firmware version for the vpn device.
    :type firmware_version: str
    """

    _attribute_map = {
        'vendor': {'key': 'vendor', 'type': 'str'},
        'device_family': {'key': 'deviceFamily', 'type': 'str'},
        'firmware_version': {'key': 'firmwareVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        vendor: Optional[str] = None,
        device_family: Optional[str] = None,
        firmware_version: Optional[str] = None,
        **kwargs
    ):
        super(VpnDeviceScriptParameters, self).__init__(**kwargs)
        self.vendor = vendor
        self.device_family = device_family
        self.firmware_version = firmware_version
