# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource_py3 import Resource


class Zone(Resource):
    """Describes a DNS zone.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param etag: The etag of the zone.
    :type etag: str
    :ivar max_number_of_record_sets: The maximum number of record sets that
     can be created in this DNS zone.  This is a read-only property and any
     attempt to set this value will be ignored.
    :vartype max_number_of_record_sets: long
    :ivar number_of_record_sets: The current number of record sets in this DNS
     zone.  This is a read-only property and any attempt to set this value will
     be ignored.
    :vartype number_of_record_sets: long
    :ivar name_servers: The name servers for this DNS zone. This is a
     read-only property and any attempt to set this value will be ignored.
    :vartype name_servers: list[str]
    :param zone_type: The type of this DNS zone (Public or Private). Possible
     values include: 'Public', 'Private'. Default value: "Public" .
    :type zone_type: str or
     ~azure.mgmt.dns.v2018_03_01_preview.models.ZoneType
    :param registration_virtual_networks: A list of references to virtual
     networks that register hostnames in this DNS zone. This is a only when
     ZoneType is Private.
    :type registration_virtual_networks:
     list[~azure.mgmt.dns.v2018_03_01_preview.models.SubResource]
    :param resolution_virtual_networks: A list of references to virtual
     networks that resolve records in this DNS zone. This is a only when
     ZoneType is Private.
    :type resolution_virtual_networks:
     list[~azure.mgmt.dns.v2018_03_01_preview.models.SubResource]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'max_number_of_record_sets': {'readonly': True},
        'number_of_record_sets': {'readonly': True},
        'name_servers': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'max_number_of_record_sets': {'key': 'properties.maxNumberOfRecordSets', 'type': 'long'},
        'number_of_record_sets': {'key': 'properties.numberOfRecordSets', 'type': 'long'},
        'name_servers': {'key': 'properties.nameServers', 'type': '[str]'},
        'zone_type': {'key': 'properties.zoneType', 'type': 'ZoneType'},
        'registration_virtual_networks': {'key': 'properties.registrationVirtualNetworks', 'type': '[SubResource]'},
        'resolution_virtual_networks': {'key': 'properties.resolutionVirtualNetworks', 'type': '[SubResource]'},
    }

    def __init__(self, *, location: str, tags=None, etag: str=None, zone_type="Public", registration_virtual_networks=None, resolution_virtual_networks=None, **kwargs) -> None:
        super(Zone, self).__init__(location=location, tags=tags, **kwargs)
        self.etag = etag
        self.max_number_of_record_sets = None
        self.number_of_record_sets = None
        self.name_servers = None
        self.zone_type = zone_type
        self.registration_virtual_networks = registration_virtual_networks
        self.resolution_virtual_networks = resolution_virtual_networks
