
from matplotlib.colors import ListedColormap
from numpy import nan, inf

# Used to reconstruct the colormap in viscm
parameters = {'xp': [-4.3429173827393939, 30.455597643097661, 32.13539565942996],
              'yp': [-30.15894006799769, -17.274305555555571, 19.646086516203709],
              'min_Jp': 19.0625,
              'max_Jp': 41.25}

cm_data = [[ 0.06429848, 0.07030845, 0.56081293],
           [ 0.07059874, 0.07234365, 0.55815849],
           [ 0.07652544, 0.07428576, 0.55555489],
           [ 0.08213769, 0.07614194, 0.5530008 ],
           [ 0.08748082, 0.07791851, 0.55049496],
           [ 0.09259046, 0.07962114, 0.54803615],
           [ 0.09749518, 0.08125486, 0.54562319],
           [ 0.10221832, 0.08282422, 0.5432549 ],
           [ 0.10677924, 0.08433334, 0.54093019],
           [ 0.11119415, 0.08578593, 0.53864797],
           [ 0.11547698, 0.08718537, 0.5364071 ],
           [ 0.11964013, 0.08853469, 0.53420608],
           [ 0.12369304, 0.08983677, 0.53204452],
           [ 0.12764463, 0.09109418, 0.52992146],
           [ 0.13150274, 0.09230929, 0.52783595],
           [ 0.13527429, 0.09348431, 0.52578708],
           [ 0.13896543, 0.09462124, 0.52377397],
           [ 0.14258169, 0.09572196, 0.52179573],
           [ 0.14612799, 0.09678819, 0.51985154],
           [ 0.1496088 , 0.09782155, 0.51794057],
           [ 0.15302817, 0.09882353, 0.51606202],
           [ 0.15638977, 0.09979551, 0.5142151 ],
           [ 0.15969695, 0.10073879, 0.51239904],
           [ 0.16295306, 0.10165455, 0.51061287],
           [ 0.16616079, 0.10254391, 0.50885595],
           [ 0.16932259, 0.10340798, 0.50712773],
           [ 0.17244087, 0.10424772, 0.50542751],
           [ 0.17551784, 0.10506408, 0.50375461],
           [ 0.1785556 , 0.10585792, 0.50210834],
           [ 0.18155607, 0.10663006, 0.50048806],
           [ 0.18452106, 0.10738127, 0.49889312],
           [ 0.18745224, 0.10811228, 0.49732288],
           [ 0.19035121, 0.10882375, 0.49577672],
           [ 0.19321944, 0.10951634, 0.49425404],
           [ 0.19605832, 0.11019064, 0.49275422],
           [ 0.19886917, 0.11084722, 0.49127669],
           [ 0.20165323, 0.11148664, 0.48982085],
           [ 0.20441167, 0.11210938, 0.48838614],
           [ 0.20714559, 0.11271593, 0.48697199],
           [ 0.20985605, 0.11330674, 0.48557784],
           [ 0.21254404, 0.11388224, 0.48420315],
           [ 0.2152105 , 0.11444284, 0.48284737],
           [ 0.21785634, 0.11498892, 0.48150997],
           [ 0.22048241, 0.11552084, 0.48019043],
           [ 0.2230896 , 0.11603893, 0.47888815],
           [ 0.22567863, 0.11654352, 0.47760264],
           [ 0.22825023, 0.11703493, 0.47633344],
           [ 0.2308051 , 0.11751345, 0.47508006],
           [ 0.23334392, 0.11797936, 0.47384197],
           [ 0.23586735, 0.11843293, 0.4726187 ],
           [ 0.238376  , 0.11887439, 0.47140974],
           [ 0.24087047, 0.119304  , 0.47021461],
           [ 0.24335134, 0.11972197, 0.46903282],
           [ 0.24581917, 0.12012852, 0.46786389],
           [ 0.24827447, 0.12052385, 0.46670734],
           [ 0.25071777, 0.12090815, 0.4655627 ],
           [ 0.25314954, 0.1212816 , 0.46442949],
           [ 0.25557026, 0.12164439, 0.46330726],
           [ 0.25798039, 0.12199667, 0.46219552],
           [ 0.26038035, 0.1223386 , 0.46109382],
           [ 0.26277058, 0.12267033, 0.46000169],
           [ 0.26515147, 0.12299201, 0.45891868],
           [ 0.26752341, 0.12330377, 0.45784433],
           [ 0.26988678, 0.12360574, 0.45677818],
           [ 0.27224195, 0.12389804, 0.45571977],
           [ 0.27458926, 0.1241808 , 0.45466867],
           [ 0.27692905, 0.12445412, 0.45362441],
           [ 0.27926164, 0.12471811, 0.45258655],
           [ 0.28158735, 0.12497288, 0.45155464],
           [ 0.28390648, 0.12521853, 0.45052824],
           [ 0.28621932, 0.12545514, 0.4495069 ],
           [ 0.28852615, 0.12568281, 0.44849017],
           [ 0.29082724, 0.12590163, 0.44747763],
           [ 0.29312286, 0.12611169, 0.44646883],
           [ 0.29541325, 0.12631305, 0.44546333],
           [ 0.29769866, 0.1265058 , 0.44446068],
           [ 0.29997937, 0.12668998, 0.44346041],
           [ 0.30225556, 0.12686571, 0.44246213],
           [ 0.30452744, 0.12703303, 0.44146542],
           [ 0.30679521, 0.12719203, 0.44046984],
           [ 0.30905908, 0.12734277, 0.43947496],
           [ 0.31131924, 0.12748531, 0.43848037],
           [ 0.31357588, 0.12761972, 0.43748562],
           [ 0.31582916, 0.12774605, 0.43649031],
           [ 0.31807926, 0.12786436, 0.435494  ],
           [ 0.32032634, 0.12797471, 0.43449628],
           [ 0.32257056, 0.12807717, 0.43349674],
           [ 0.32481206, 0.12817177, 0.43249495],
           [ 0.32705099, 0.12825859, 0.43149051],
           [ 0.32928748, 0.12833767, 0.43048301],
           [ 0.33152166, 0.12840906, 0.42947203],
           [ 0.33375365, 0.12847281, 0.42845718],
           [ 0.33598357, 0.12852899, 0.42743805],
           [ 0.33821153, 0.12857763, 0.42641424],
           [ 0.34043763, 0.12861879, 0.42538536],
           [ 0.34266198, 0.12865252, 0.42435101],
           [ 0.34488466, 0.12867886, 0.42331081],
           [ 0.34710577, 0.12869787, 0.42226437],
           [ 0.34932539, 0.1287096 , 0.42121131],
           [ 0.35154359, 0.12871408, 0.42015124],
           [ 0.35376051, 0.12871135, 0.41908372],
           [ 0.35597615, 0.12870147, 0.41800847],
           [ 0.35819057, 0.1286845 , 0.4169251 ],
           [ 0.36040383, 0.12866049, 0.41583327],
           [ 0.36261599, 0.12862948, 0.41473261],
           [ 0.36482709, 0.12859152, 0.41362277],
           [ 0.36703718, 0.12854666, 0.41250341],
           [ 0.3692463 , 0.12849495, 0.41137419],
           [ 0.37145448, 0.12843643, 0.41023475],
           [ 0.37366176, 0.12837115, 0.40908479],
           [ 0.37586816, 0.12829916, 0.40792396],
           [ 0.37807371, 0.1282205 , 0.40675195],
           [ 0.38027843, 0.12813522, 0.40556844],
           [ 0.38248233, 0.12804337, 0.40437312],
           [ 0.38468543, 0.12794499, 0.40316569],
           [ 0.38688773, 0.12784013, 0.40194585],
           [ 0.38908927, 0.12772882, 0.40071328],
           [ 0.39129003, 0.12761111, 0.39946772],
           [ 0.39349   , 0.12748707, 0.39820889],
           [ 0.39568919, 0.12735672, 0.39693654],
           [ 0.39788757, 0.12722013, 0.39565039],
           [ 0.40008516, 0.12707733, 0.39435018],
           [ 0.40228193, 0.12692837, 0.39303567],
           [ 0.40447786, 0.12677329, 0.39170661],
           [ 0.40667296, 0.12661213, 0.39036275],
           [ 0.40886719, 0.12644494, 0.38900387],
           [ 0.41106054, 0.12627176, 0.38762974],
           [ 0.41325298, 0.12609263, 0.38624015],
           [ 0.41544449, 0.12590759, 0.38483488],
           [ 0.41763504, 0.12571668, 0.38341373],
           [ 0.41982461, 0.12551994, 0.38197651],
           [ 0.42201315, 0.12531741, 0.38052303],
           [ 0.42420064, 0.12510914, 0.37905311],
           [ 0.42638705, 0.12489516, 0.37756658],
           [ 0.42857233, 0.1246755 , 0.37606326],
           [ 0.43075646, 0.1244502 , 0.37454301],
           [ 0.43293939, 0.1242193 , 0.37300565],
           [ 0.43512109, 0.12398282, 0.37145106],
           [ 0.43730152, 0.12374081, 0.36987908],
           [ 0.43948064, 0.12349329, 0.36828958],
           [ 0.4416584 , 0.1232403 , 0.36668245],
           [ 0.44383476, 0.12298185, 0.36505756],
           [ 0.44600968, 0.12271799, 0.3634148 ],
           [ 0.44818312, 0.12244874, 0.36175406],
           [ 0.45035503, 0.12217413, 0.36007525],
           [ 0.45252536, 0.12189418, 0.35837829],
           [ 0.45469404, 0.12160894, 0.35666314],
           [ 0.45686104, 0.12131841, 0.35492967],
           [ 0.45902634, 0.12102262, 0.35317781],
           [ 0.46118987, 0.12072157, 0.35140748],
           [ 0.46335159, 0.12041529, 0.34961863],
           [ 0.46551146, 0.1201038 , 0.34781121],
           [ 0.46766943, 0.11978711, 0.34598516],
           [ 0.46982545, 0.11946524, 0.34414044],
           [ 0.47197947, 0.1191382 , 0.34227701],
           [ 0.47413145, 0.11880599, 0.34039484],
           [ 0.47628134, 0.11846864, 0.3384939 ],
           [ 0.47842909, 0.11812614, 0.33657417],
           [ 0.48057466, 0.11777852, 0.33463562],
           [ 0.48271801, 0.11742576, 0.33267825],
           [ 0.48485908, 0.11706789, 0.33070205],
           [ 0.48699783, 0.11670489, 0.328707  ],
           [ 0.48913421, 0.11633679, 0.32669314],
           [ 0.49126814, 0.11596361, 0.32466055],
           [ 0.49339962, 0.11558532, 0.32260912],
           [ 0.4955286 , 0.11520191, 0.32053887],
           [ 0.49765504, 0.11481337, 0.31844981],
           [ 0.4997789 , 0.1144197 , 0.31634195],
           [ 0.50190014, 0.1140209 , 0.31421531],
           [ 0.50401871, 0.11361695, 0.3120699 ],
           [ 0.50613459, 0.11320784, 0.30990576],
           [ 0.50824772, 0.11279356, 0.30772289],
           [ 0.51035807, 0.1123741 , 0.30552132],
           [ 0.5124656 , 0.11194945, 0.30330108],
           [ 0.51457028, 0.11151958, 0.30106219],
           [ 0.51667206, 0.11108448, 0.29880468],
           [ 0.51877092, 0.11064413, 0.29652856],
           [ 0.52086682, 0.11019852, 0.29423388],
           [ 0.52295972, 0.10974761, 0.29192064],
           [ 0.52504958, 0.10929139, 0.28958888],
           [ 0.52713639, 0.10882982, 0.28723862],
           [ 0.52922011, 0.1083629 , 0.28486987],
           [ 0.5313007 , 0.10789058, 0.28248267],
           [ 0.53337814, 0.10741283, 0.28007701],
           [ 0.5354524 , 0.10692964, 0.27765292],
           [ 0.53752345, 0.10644096, 0.27521041],
           [ 0.53959126, 0.10594676, 0.27274949],
           [ 0.54165581, 0.10544701, 0.27027015],
           [ 0.54371708, 0.10494168, 0.26777239],
           [ 0.54577503, 0.10443071, 0.26525622],
           [ 0.54782966, 0.10391408, 0.26272161],
           [ 0.54988092, 0.10339174, 0.26016854],
           [ 0.55192881, 0.10286366, 0.257597  ],
           [ 0.5539733 , 0.10232978, 0.25500695],
           [ 0.55601437, 0.10179006, 0.25239834],
           [ 0.55805201, 0.10124446, 0.24977113],
           [ 0.56008619, 0.10069294, 0.24712528],
           [ 0.5621169 , 0.10013543, 0.2444607 ],
           [ 0.56414412, 0.09957189, 0.2417773 ],
           [ 0.56616785, 0.09900225, 0.23907499],
           [ 0.56818807, 0.09842646, 0.23635366],
           [ 0.57020476, 0.09784448, 0.23361322],
           [ 0.5722179 , 0.09725625, 0.23085354],
           [ 0.57422749, 0.0966617 , 0.22807446],
           [ 0.57623352, 0.09606077, 0.22527582],
           [ 0.57823597, 0.09545339, 0.22245744],
           [ 0.58023484, 0.09483951, 0.21961911],
           [ 0.58223013, 0.09421906, 0.21676062],
           [ 0.58422181, 0.09359195, 0.21388171],
           [ 0.58620989, 0.09295813, 0.21098213],
           [ 0.58819437, 0.09231752, 0.20806158],
           [ 0.59017522, 0.09167004, 0.20511974],
           [ 0.59215246, 0.09101561, 0.20215625],
           [ 0.59412608, 0.09035415, 0.19917073],
           [ 0.59609607, 0.08968558, 0.19616277],
           [ 0.59806243, 0.08900982, 0.19313191],
           [ 0.60002517, 0.08832676, 0.19007764],
           [ 0.60198428, 0.08763633, 0.18699943],
           [ 0.60393975, 0.08693843, 0.18389669],
           [ 0.6058916 , 0.08623295, 0.18076877],
           [ 0.60783982, 0.0855198 , 0.17761497],
           [ 0.60978442, 0.08479887, 0.17443452],
           [ 0.61172539, 0.08407007, 0.1712266 ],
           [ 0.61366275, 0.08333326, 0.16799029],
           [ 0.61559649, 0.08258834, 0.16472461],
           [ 0.61752661, 0.0818352 , 0.16142846],
           [ 0.61945313, 0.0810737 , 0.15810066],
           [ 0.62137605, 0.08030372, 0.15473991],
           [ 0.62329538, 0.07952512, 0.15134478],
           [ 0.62521111, 0.07873778, 0.14791371],
           [ 0.62712327, 0.07794154, 0.14444498],
           [ 0.62903185, 0.07713626, 0.14093668],
           [ 0.63093679, 0.07632198, 0.13738715],
           [ 0.63283812, 0.07549845, 0.13379386],
           [ 0.63473591, 0.07466542, 0.13015404],
           [ 0.63663015, 0.07382271, 0.12646483],
           [ 0.63852086, 0.07297015, 0.12272302],
           [ 0.64040805, 0.07210755, 0.11892502],
           [ 0.64229172, 0.07123472, 0.11506677],
           [ 0.64417189, 0.07035145, 0.11114371],
           [ 0.64604857, 0.06945753, 0.10715064],
           [ 0.64792177, 0.06855275, 0.10308164],
           [ 0.64979151, 0.06763686, 0.09892989],
           [ 0.65165779, 0.06670962, 0.09468753],
           [ 0.65352062, 0.0657708 , 0.0903454 ],
           [ 0.65537998, 0.06482024, 0.08589306],
           [ 0.6572358 , 0.06385792, 0.08131836],
           [ 0.65908822, 0.06288319, 0.07660526],
           [ 0.66093724, 0.06189575, 0.07173527],
           [ 0.66278289, 0.06089528, 0.06668569],
           [ 0.66462516, 0.05988142, 0.06142811],
           [ 0.66646409, 0.05885384, 0.05592632],
           [ 0.66829968, 0.05781214, 0.05013301],
           [ 0.67013194, 0.05675593, 0.04398455],
           [ 0.67196089, 0.05568478, 0.0374093 ],
           [ 0.67378656, 0.05459825, 0.03081908]]

hotwater = ListedColormap(cm_data, name=__file__)


if __name__ == "__main__":
    import matplotlib.pyplot as plt
    import numpy as np

    try:
        from viscm import viscm
        viscm(hotwater)
    except ImportError:
        print("viscm not found, falling back on simple display")
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',
                   cmap=hotwater)
    plt.show()
