/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.ExpressionProcessor;
import net.sf.saxon.expr.flwor.LetClausePull;
import net.sf.saxon.expr.flwor.LetClausePush;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LetClause
extends Clause {
    private LocalVariableBinding rangeVariable;
    private Expression sequence;

    @Override
    public int getClauseKey() {
        return 1;
    }

    @Override
    public LetClause copy() {
        LetClause let2 = new LetClause();
        let2.setLocationId(this.getLocationId());
        let2.rangeVariable = this.rangeVariable.copy();
        let2.sequence = this.sequence.copy();
        return let2;
    }

    public void setSequence(Expression sequence) {
        this.sequence = sequence;
    }

    public Expression getSequence() {
        return this.sequence;
    }

    public void setRangeVariable(LocalVariableBinding binding) {
        this.rangeVariable = binding;
    }

    public LocalVariableBinding getRangeVariable() {
        return this.rangeVariable;
    }

    @Override
    public LocalVariableBinding[] getRangeVariables() {
        return new LocalVariableBinding[]{this.rangeVariable};
    }

    @Override
    public TuplePull getPullStream(TuplePull base, XPathContext context) {
        return new LetClausePull(base, this);
    }

    @Override
    public TuplePush getPushStream(TuplePush destination, XPathContext context) {
        return new LetClausePush(destination, this);
    }

    @Override
    public void processSubExpressions(ExpressionProcessor processor) throws XPathException {
        this.sequence = processor.processExpression(this.sequence);
    }

    @Override
    public void typeCheck(ExpressionVisitor visitor) throws XPathException {
        RoleLocator role = new RoleLocator(3, this.rangeVariable.getVariableQName(), 0);
        this.sequence = TypeChecker.strictTypeCheck(this.sequence, this.rangeVariable.getRequiredType(), role, visitor.getStaticContext());
    }

    @Override
    public void gatherVariableReferences(ExpressionVisitor visitor, Binding binding, List<VariableReference> references) {
        ExpressionTool.gatherVariableReferences(this.sequence, binding, references);
    }

    @Override
    public void refineVariableType(ExpressionVisitor visitor, List<VariableReference> references, Expression returnExpr) {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        ItemType actualItemType = this.sequence.getItemType();
        for (VariableReference ref : references) {
            ref.refineVariableType(actualItemType, this.sequence.getCardinality(), this.sequence instanceof Literal ? ((Literal)this.sequence).getValue() : null, this.sequence.getSpecialProperties(), visitor);
            visitor.resetStaticProperties();
        }
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("let");
        out.emitAttribute("var", this.getRangeVariable().getVariableQName().getDisplayName());
        out.emitAttribute("slot", this.getRangeVariable().getLocalSlotNumber() + "");
        this.sequence.explain(out);
        out.endElement();
    }

    public String toString() {
        FastStringBuffer fsb = new FastStringBuffer(64);
        fsb.append("let $");
        fsb.append(this.rangeVariable.getVariableQName().getDisplayName());
        fsb.append(" := ");
        fsb.append(this.sequence.toString());
        return fsb.toString();
    }
}

