# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobRecurrence(Model):
    """JobRecurrence.

    :param frequency: Gets or sets the frequency of recurrence (second,
     minute, hour, day, week, month). Possible values include: 'Minute',
     'Hour', 'Day', 'Week', 'Month'
    :type frequency: str or ~azure.mgmt.scheduler.models.RecurrenceFrequency
    :param interval: Gets or sets the interval between retries.
    :type interval: int
    :param count: Gets or sets the maximum number of times that the job should
     run.
    :type count: int
    :param end_time: Gets or sets the time at which the job will complete.
    :type end_time: datetime
    :param schedule:
    :type schedule: ~azure.mgmt.scheduler.models.JobRecurrenceSchedule
    """

    _attribute_map = {
        'frequency': {'key': 'frequency', 'type': 'RecurrenceFrequency'},
        'interval': {'key': 'interval', 'type': 'int'},
        'count': {'key': 'count', 'type': 'int'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'schedule': {'key': 'schedule', 'type': 'JobRecurrenceSchedule'},
    }

    def __init__(self, **kwargs):
        super(JobRecurrence, self).__init__(**kwargs)
        self.frequency = kwargs.get('frequency', None)
        self.interval = kwargs.get('interval', None)
        self.count = kwargs.get('count', None)
        self.end_time = kwargs.get('end_time', None)
        self.schedule = kwargs.get('schedule', None)
