/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.component.ValueExpressionValueBindingAdapter;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.render.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIComponent
implements StateHolder {
    protected Map<String, ValueExpression> bindings = null;
    private boolean isUIComponentBase;
    private boolean isUIComponentBaseIsSet = false;

    public abstract Map<String, Object> getAttributes();

    public abstract ValueBinding getValueBinding(String var1);

    public abstract void setValueBinding(String var1, ValueBinding var2);

    public ValueExpression getValueExpression(String name) {
        ValueExpressionValueBindingAdapter result = null;
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.bindings == null) {
            ValueBinding binding;
            if (!this.isUIComponentBase() && null != (binding = this.getValueBinding(name))) {
                result = new ValueExpressionValueBindingAdapter(binding);
                this.bindings = new HashMap<String, ValueExpression>();
                this.bindings.put(name, result);
            }
            return result;
        }
        return this.bindings.get(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (name == null) {
            throw new NullPointerException();
        }
        if ("id".equals(name) || "parent".equals(name)) {
            throw new IllegalArgumentException();
        }
        if (binding != null) {
            if (!binding.isLiteralText()) {
                if (this.bindings == null) {
                    this.bindings = new HashMap<String, ValueExpression>();
                }
                this.bindings.put(name, binding);
            } else {
                ELContext context = FacesContext.getCurrentInstance().getELContext();
                try {
                    this.getAttributes().put(name, binding.getValue(context));
                }
                catch (ELException ele) {
                    throw new FacesException(ele);
                }
            }
        } else if (this.bindings != null) {
            this.bindings.remove(name);
            if (this.bindings.size() == 0) {
                this.bindings = null;
            }
        }
    }

    public abstract String getClientId(FacesContext var1);

    public String getContainerClientId(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        return this.getClientId(context);
    }

    public abstract String getFamily();

    public abstract String getId();

    public abstract void setId(String var1);

    public abstract UIComponent getParent();

    public abstract void setParent(UIComponent var1);

    public abstract boolean isRendered();

    public abstract void setRendered(boolean var1);

    public abstract String getRendererType();

    public abstract void setRendererType(String var1);

    public abstract boolean getRendersChildren();

    private boolean isUIComponentBase() {
        if (!this.isUIComponentBaseIsSet) {
            this.isUIComponentBase = this instanceof UIComponentBase;
        }
        return this.isUIComponentBase;
    }

    public abstract List<UIComponent> getChildren();

    public abstract int getChildCount();

    public abstract UIComponent findComponent(String var1);

    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        if (null == context || null == clientId || null == callback) {
            throw new NullPointerException();
        }
        boolean found = false;
        if (clientId.equals(this.getClientId(context))) {
            try {
                callback.invokeContextCallback(context, this);
                return true;
            }
            catch (Exception e) {
                throw new FacesException(e);
            }
        }
        Iterator<UIComponent> itr = this.getFacetsAndChildren();
        while (itr.hasNext() && !found) {
            found = itr.next().invokeOnComponent(context, clientId, callback);
        }
        return found;
    }

    public abstract Map<String, UIComponent> getFacets();

    public int getFacetCount() {
        return this.getFacets().size();
    }

    public abstract UIComponent getFacet(String var1);

    public abstract Iterator<UIComponent> getFacetsAndChildren();

    public abstract void broadcast(FacesEvent var1) throws AbortProcessingException;

    public abstract void decode(FacesContext var1);

    public abstract void encodeBegin(FacesContext var1) throws IOException;

    public abstract void encodeChildren(FacesContext var1) throws IOException;

    public abstract void encodeEnd(FacesContext var1) throws IOException;

    public void encodeAll(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        this.encodeBegin(context);
        if (this.getRendersChildren()) {
            this.encodeChildren(context);
        } else if (this.getChildCount() > 0) {
            for (UIComponent kid : this.getChildren()) {
                kid.encodeAll(context);
            }
        }
        this.encodeEnd(context);
    }

    protected abstract void addFacesListener(FacesListener var1);

    protected abstract FacesListener[] getFacesListeners(Class var1);

    protected abstract void removeFacesListener(FacesListener var1);

    public abstract void queueEvent(FacesEvent var1);

    public abstract void processRestoreState(FacesContext var1, Object var2);

    public abstract void processDecodes(FacesContext var1);

    public abstract void processValidators(FacesContext var1);

    public abstract void processUpdates(FacesContext var1);

    public abstract Object processSaveState(FacesContext var1);

    protected abstract FacesContext getFacesContext();

    protected abstract Renderer getRenderer(FacesContext var1);
}

