# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RunCommandListResult(Model):
    """The List Virtual Machine operation response.

    :param value: The list of virtual machine run commands.
    :type value:
     list[~azure.mgmt.compute.v2017_12_01.models.RunCommandDocumentBase]
    :param next_link: The uri to fetch the next page of run commands. Call
     ListNext() with this to fetch the next page of run commands.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RunCommandDocumentBase]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, value, next_link=None):
        super(RunCommandListResult, self).__init__()
        self.value = value
        self.next_link = next_link
