/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.portfolio;

import com.portfolioeffect.quant.client.portfolio.Portfolio;
import com.portfolioeffect.quant.client.result.Metric;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import java.sql.Timestamp;

public class Position {
    private final String name;
    private final Portfolio portfolio;

    public static Position[] create(Portfolio portfolio, String[] symbols, TIntArrayList quantity) {
        return Position.create(portfolio, symbols, quantity.toArray());
    }

    public static Position[] create(Portfolio portfolio, String[] symbols, int[] quantity) {
        Position[] positions = new Position[symbols.length];
        int i = 0;
        while (i < symbols.length) {
            positions[i] = new Position(portfolio, symbols[i], quantity[i]);
            ++i;
        }
        return positions;
    }

    public Position(Portfolio portfolio, String assetName, int quantity) {
        this.name = assetName;
        this.portfolio = portfolio;
        portfolio.addPosition(assetName, quantity);
    }

    public Position(Portfolio portfolio, String assetName) {
        this.name = assetName;
        this.portfolio = portfolio;
    }

    public Position(Portfolio portfolio, String assetName, TIntArrayList quantity, TLongArrayList timeMillSec) {
        this(portfolio, assetName, quantity.toArray(), timeMillSec.toArray());
    }

    public Position(Portfolio portfolio, String assetName, int[] quantity, long[] timeMillSec) {
        this.name = assetName;
        this.portfolio = portfolio;
        portfolio.addPosition(assetName, quantity, timeMillSec);
    }

    public Position(Portfolio portfolio, String assetName, TIntArrayList quantity, String[] timeMillSec) {
        this(portfolio, assetName, quantity.toArray(), timeMillSec);
    }

    public Position(Portfolio portfolio, String assetName, int[] quantity, String[] timeMillSec) {
        this.name = assetName;
        this.portfolio = portfolio;
        long[] time = new long[timeMillSec.length];
        int i = 0;
        String[] stringArray = timeMillSec;
        int n = timeMillSec.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            time[i++] = Timestamp.valueOf(e).getTime();
            ++n2;
        }
        portfolio.addPosition(assetName, quantity, time);
    }

    public Position(Portfolio portfolio, String assetName, TDoubleArrayList price, TIntArrayList quantity, TLongArrayList timeMillSec) {
        this(portfolio, assetName, price.toArray(), quantity.toArray(), timeMillSec.toArray());
    }

    public Position(Portfolio portfolio, String assetName, double[] price, int[] quantity, long[] timeMillSec) {
        this.name = assetName;
        this.portfolio = portfolio;
        portfolio.addPosition(assetName, price, quantity, timeMillSec);
    }

    public Position(Portfolio portfolio, String assetName, TDoubleArrayList price, TIntArrayList quantity, long timeStepMilliSec) {
        this(portfolio, assetName, price.toArray(), quantity.toArray(), timeStepMilliSec);
    }

    public Position(Portfolio portfolio, String assetName, double[] price, int[] quantity, long timeStepMilliSec) {
        this.name = assetName;
        this.portfolio = portfolio;
        portfolio.addPosition(assetName, price, quantity, timeStepMilliSec);
    }

    public Position(Portfolio portfolio, String assetName, TDoubleArrayList price, int quantity, long timeStepMilliSec) {
        this(portfolio, assetName, price.toArray(), quantity, timeStepMilliSec);
    }

    public Position(Portfolio portfolio, String assetName, double[] price, int quantity, long timeStepMilliSec) {
        this.name = assetName;
        this.portfolio = portfolio;
        portfolio.addPosition(assetName, price, quantity, timeStepMilliSec);
    }

    public Position(Portfolio portfolio, String assetName, double[] price, int quantity, long[] priceTimeMillSec) {
        this.name = assetName;
        this.portfolio = portfolio;
        portfolio.addPosition(assetName, price, quantity, priceTimeMillSec);
    }

    public Position(Portfolio portfolio, String assetName, TFloatArrayList price, int quantity, TLongArrayList priceTimeMillSec) {
        this(portfolio, assetName, price.toArray(), quantity, priceTimeMillSec.toArray());
    }

    public Position(Portfolio portfolio, String assetName, float[] price, int quantity, long[] priceTimeMillSec) {
        this.name = assetName;
        this.portfolio = portfolio;
        portfolio.addPosition(assetName, price, quantity, priceTimeMillSec);
    }

    public Position(Portfolio portfolio, String assetName, TDoubleArrayList price, TLongArrayList priceTimeMillSec, TIntArrayList quantity, TLongArrayList quantityTimeMillSec) {
        this(portfolio, assetName, price.toArray(), priceTimeMillSec.toArray(), quantity.toArray(), quantityTimeMillSec.toArray());
    }

    public Position(Portfolio portfolio, String assetName, double[] price, long[] priceTimeMillSec, int[] quantity, long[] quantityTimeMillSec) {
        this.name = assetName;
        this.portfolio = portfolio;
        portfolio.addPosition(assetName, price, priceTimeMillSec, quantity, quantityTimeMillSec);
    }

    public Position(Portfolio portfolio, String assetName, TFloatArrayList price, TLongArrayList priceTimeMillSec, TIntArrayList quantity, TLongArrayList quantityTimeMillSec) {
        this(portfolio, assetName, price.toArray(), priceTimeMillSec.toArray(), quantity.toArray(), quantityTimeMillSec.toArray());
    }

    public Position(Portfolio portfolio, String assetName, float[] price, long[] priceTimeMillSec, int[] quantity, long[] quantityTimeMillSec) {
        this.name = assetName;
        this.portfolio = portfolio;
        portfolio.addPosition(assetName, price, priceTimeMillSec, quantity, quantityTimeMillSec);
    }

    public void removePositionPrice() {
        this.portfolio.removePositionPrice(this.name);
    }

    public void removePositionQuantity() {
        this.portfolio.removePositionQuantity(this.name);
    }

    public void setPositionQuantity(int quantity) {
        this.portfolio.setPositionQuantity(this.name, quantity);
    }

    public Metric setPositionQuantity(TIntArrayList quantity, TLongArrayList timeMillesc) {
        return this.setPositionQuantity(quantity.toArray(), timeMillesc.toArray());
    }

    public Metric setPositionQuantity(int[] quantity, long[] timeMillesc) {
        return this.portfolio.setPositionQuantity(this.name, quantity, timeMillesc);
    }

    public Metric setPositionQuantity(TDoubleArrayList quantityD, TLongArrayList timeMillesc) {
        return this.setPositionQuantity(quantityD.toArray(), timeMillesc.toArray());
    }

    public Metric setPositionQuantity(double[] quantityD, long[] timeMillesc) {
        return this.portfolio.setPositionQuantity(this.name, quantityD, timeMillesc);
    }

    public Metric setPositionQuantity(TIntArrayList quantity, String[] timeMillesc) {
        return this.setPositionQuantity(quantity.toArray(), timeMillesc);
    }

    public Metric setPositionQuantity(int[] quantity, String[] timeMillesc) {
        return this.portfolio.setPositionQuantity(this.name, quantity, timeMillesc);
    }

    public String getName() {
        return this.name;
    }

    public Portfolio getPortfolio() {
        return this.portfolio;
    }
}

