"""
Auto generated code

"""

import json
from snapp_email.datacontract.classes import Post_20
from snapp_email.datacontract.utils import export_dict, fill


class Post_20Endpoint:
    def __init__(self, api_client):
        self.api_client = api_client
    
    def options(self, accept_type=None):
        """
        Retrieve options available for resource 'Post_20'.
        
        :param accept_type: 
        :type accept_type: str
        
        :return: 
        :rtype: Post_20
        """
        url_parameters = {
        }
        endpoint_parameters = {
        }
        endpoint = 'post'.format(**endpoint_parameters)
        add_headers = {
            'Content-Type': 'application/vnd.4thoffice.post-5.15+json',
            'Accept': 'application/vnd.4thoffice.post-5.15+json' if accept_type is None else accept_type,
        }
        response = self.api_client.api_call('options', endpoint, url_parameters, add_headers)
        
        return fill(Post_20, response.json())
    
    def get(self, postId, accept_type=None):
        """
        Retrieve post resource.
        
        :param postId: 
        :type postId: 
        
        :param accept_type: 
        :type accept_type: str
        
        :return: 
        :rtype: Post_20
        """
        url_parameters = {
        }
        endpoint_parameters = {
            'postId': postId,
        }
        endpoint = 'post/{postId}'.format(**endpoint_parameters)
        add_headers = {
            'Content-Type': 'application/vnd.4thoffice.post-5.15+json',
            'Accept': 'application/vnd.4thoffice.post-5.15+json' if accept_type is None else accept_type,
        }
        response = self.api_client.api_call('get', endpoint, url_parameters, add_headers)
        
        return fill(Post_20, response.json())
    
    def create(self, obj, clientResourceId=None, customDateTime=None, signatureId=None, accept_type=None):
        """
        Create new post.
        
        :param obj: Object to be persisted
        :type obj: Post_20
        
        :param clientResourceId: Resource id generated by client-side. Required for double-post prevention on server-side.
        :type clientResourceId: String
        
        :param customDateTime: Specify custom create date time.
        :type customDateTime: DateTime
        
        :param signatureId: Specify signature id
        :type signatureId: String
        
        :param accept_type: 
        :type accept_type: str
        
        :return: 
        :rtype: Post_20
        """
        url_parameters = {
            'clientResourceId': clientResourceId,
            'customDateTime': customDateTime,
            'signatureId': signatureId,
        }
        endpoint_parameters = {
        }
        endpoint = 'post'.format(**endpoint_parameters)
        add_headers = {
            'Content-Type': 'application/vnd.4thoffice.post-5.15+json',
            'Accept': 'application/vnd.4thoffice.post-5.15+json' if accept_type is None else accept_type,
        }
        data = export_dict(obj)
        response = self.api_client.api_call('post', endpoint, url_parameters, add_headers, data=json.dumps(data))
        
        return fill(Post_20, response.json())
    
    def create_2(self, obj, sourceResourceId, sourceResourceModified, accept_type=None):
        """
        Copy existing post.
        
        :param obj: Object to be persisted
        :type obj: Post_20
        
        :param sourceResourceId: Specify id of source resource.
        :type sourceResourceId: String
        
        :param sourceResourceModified: Boolean flag indicating wheter source resource was modified by client-side while copying it.
        :type sourceResourceModified: String
        
        :param accept_type: 
        :type accept_type: str
        
        :return: 
        :rtype: Post_20
        """
        url_parameters = {
            'sourceResourceId': sourceResourceId,
            'sourceResourceModified': sourceResourceModified,
        }
        endpoint_parameters = {
        }
        endpoint = 'post'.format(**endpoint_parameters)
        add_headers = {
            'Content-Type': 'application/vnd.4thoffice.post-5.15+json',
            'Accept': 'application/vnd.4thoffice.post-5.15+json' if accept_type is None else accept_type,
        }
        data = export_dict(obj)
        response = self.api_client.api_call('post', endpoint, url_parameters, add_headers, data=json.dumps(data))
        
        return fill(Post_20, response.json())
