# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ConnectedResource(Model):
    """Describes properties of a connected resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar connected_resource_id: The Azure resource id of the connected
     resource
    :vartype connected_resource_id: str
    :ivar tcp_ports: The allowed tcp ports
    :vartype tcp_ports: str
    :ivar udp_ports: The allowed udp ports
    :vartype udp_ports: str
    """

    _validation = {
        'connected_resource_id': {'readonly': True},
        'tcp_ports': {'readonly': True},
        'udp_ports': {'readonly': True},
    }

    _attribute_map = {
        'connected_resource_id': {'key': 'connectedResourceId', 'type': 'str'},
        'tcp_ports': {'key': 'tcpPorts', 'type': 'str'},
        'udp_ports': {'key': 'udpPorts', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ConnectedResource, self).__init__(**kwargs)
        self.connected_resource_id = None
        self.tcp_ports = None
        self.udp_ports = None
