# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AllowedConnectionsResource(Model):
    """The resource whose properties describes the allowed traffic between Azure
    resources.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :ivar calculated_date_time: The UTC time on which the allowed connections
     resource was calculated
    :vartype calculated_date_time: datetime
    :ivar connectable_resources: List of connectable resources
    :vartype connectable_resources:
     list[~azure.mgmt.security.models.ConnectableResource]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'calculated_date_time': {'readonly': True},
        'connectable_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'calculated_date_time': {'key': 'properties.calculatedDateTime', 'type': 'iso-8601'},
        'connectable_resources': {'key': 'properties.connectableResources', 'type': '[ConnectableResource]'},
    }

    def __init__(self, **kwargs) -> None:
        super(AllowedConnectionsResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.calculated_date_time = None
        self.connectable_resources = None
