/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.IOError;
import java.io.IOException;
import java.util.Comparator;
import jdbm.PrimaryHashMap;
import jdbm.PrimaryStoreMap;
import jdbm.PrimaryTreeMap;
import jdbm.RecordManager;
import jdbm.Serializer;
import jdbm.btree.BTree;
import jdbm.helper.ComparableComparator;
import jdbm.helper.DefaultSerializer;
import jdbm.helper.PrimaryStoreMapImpl;
import jdbm.htree.HTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RecordManagerImpl
implements RecordManager {
    @Override
    public <K, V> PrimaryHashMap<K, V> hashMap(String name) {
        try {
            HTree tree = null;
            long recid = this.getNamedObject(name);
            if (recid != 0L) {
                tree = HTree.load(this, recid);
            } else {
                tree = HTree.createInstance(this);
                this.setNamedObject(name, tree.getRecid());
            }
            return tree.asMap();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public <K extends Comparable, V> PrimaryTreeMap<K, V> treeMap(String name) {
        return this.treeMap(name, ComparableComparator.INSTANCE);
    }

    @Override
    public <K extends Comparable, V> PrimaryTreeMap<K, V> treeMap(String name, Serializer<V> valueSerializer) {
        return this.treeMap(name, ComparableComparator.INSTANCE, valueSerializer);
    }

    @Override
    public <K extends Comparable, V> PrimaryTreeMap<K, V> treeMap(String name, Serializer<V> valueSerializer, Serializer<K> keySerializer) {
        return this.treeMap(name, ComparableComparator.INSTANCE, valueSerializer, keySerializer);
    }

    @Override
    public <K, V> PrimaryTreeMap<K, V> treeMap(String name, Comparator<K> keyComparator) {
        return this.treeMap(name, keyComparator, null);
    }

    @Override
    public <K, V> PrimaryTreeMap<K, V> treeMap(String name, Comparator<K> keyComparator, Serializer<V> valueSerializer) {
        return this.treeMap(name, keyComparator, valueSerializer, null);
    }

    @Override
    public <K, V> PrimaryTreeMap<K, V> treeMap(String name, Comparator<K> keyComparator, Serializer<V> valueSerializer, Serializer<K> keySerializer) {
        try {
            BTree<K, V> tree = null;
            long recid = this.getNamedObject(name);
            if (recid != 0L) {
                tree = BTree.load(this, recid);
            } else {
                tree = BTree.createInstance(this, keyComparator);
                this.setNamedObject(name, tree.getRecid());
            }
            tree.setKeySerializer(keySerializer);
            tree.setValueSerializer(valueSerializer);
            return tree.asMap();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public <V> PrimaryStoreMap<Long, V> storeMap(String name, Serializer<V> valueSerializer) {
        try {
            BTree tree = null;
            long recid = this.getNamedObject(name);
            if (recid != 0L) {
                tree = BTree.load(this, recid);
            } else {
                tree = BTree.createInstance(this);
                this.setNamedObject(name, tree.getRecid());
            }
            return new PrimaryStoreMapImpl(tree.asMap(), valueSerializer);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public <V> PrimaryStoreMap<Long, V> storeMap(String name) {
        return this.storeMap(name, DefaultSerializer.INSTANCE);
    }

    @Override
    public void update(long recid, Object obj) throws IOException {
        this.update(recid, obj, DefaultSerializer.INSTANCE);
    }

    @Override
    public Object fetch(long recid) throws IOException {
        return this.fetch(recid, DefaultSerializer.INSTANCE);
    }

    @Override
    public long insert(Object obj) throws IOException {
        return this.insert(obj, DefaultSerializer.INSTANCE);
    }
}

