# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.credentials import TokenCredential

from ._configuration import MicrosoftDatadogClientConfiguration
from .operations import ApiKeysOperations
from .operations import HostsOperations
from .operations import LinkedResourcesOperations
from .operations import MonitoredResourcesOperations
from .operations import Operations
from .operations import MonitorsOperations
from .operations import RefreshSetPasswordOperations
from .operations import TagRulesOperations
from .operations import SingleSignOnConfigurationsOperations
from . import models


class MicrosoftDatadogClient(object):
    """MicrosoftDatadogClient.

    :ivar api_keys: ApiKeysOperations operations
    :vartype api_keys: microsoft_datadog_client.operations.ApiKeysOperations
    :ivar hosts: HostsOperations operations
    :vartype hosts: microsoft_datadog_client.operations.HostsOperations
    :ivar linked_resources: LinkedResourcesOperations operations
    :vartype linked_resources: microsoft_datadog_client.operations.LinkedResourcesOperations
    :ivar monitored_resources: MonitoredResourcesOperations operations
    :vartype monitored_resources: microsoft_datadog_client.operations.MonitoredResourcesOperations
    :ivar operations: Operations operations
    :vartype operations: microsoft_datadog_client.operations.Operations
    :ivar monitors: MonitorsOperations operations
    :vartype monitors: microsoft_datadog_client.operations.MonitorsOperations
    :ivar refresh_set_password: RefreshSetPasswordOperations operations
    :vartype refresh_set_password: microsoft_datadog_client.operations.RefreshSetPasswordOperations
    :ivar tag_rules: TagRulesOperations operations
    :vartype tag_rules: microsoft_datadog_client.operations.TagRulesOperations
    :ivar single_sign_on_configurations: SingleSignOnConfigurationsOperations operations
    :vartype single_sign_on_configurations: microsoft_datadog_client.operations.SingleSignOnConfigurationsOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The Microsoft Azure subscription ID.
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        subscription_id,  # type: str
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = MicrosoftDatadogClientConfiguration(credential, subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.api_keys = ApiKeysOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.hosts = HostsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.linked_resources = LinkedResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.monitored_resources = MonitoredResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.monitors = MonitorsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.refresh_set_password = RefreshSetPasswordOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.tag_rules = TagRulesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.single_sign_on_configurations = SingleSignOnConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> MicrosoftDatadogClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
