#
# Author: Qiming Sun <osirpt.sun@gmail.com>
#

import os
L_MAX      = 8
MAX_MEMORY = int(os.environ.get('PYSCF_MAX_MEMORY', 4000)) # MB
TMPDIR = os.environ.get('TMPDIR', '.')
TMPDIR = os.environ.get('PYSCF_TMPDIR', TMPDIR)

LIGHT_SPEED = 137.03599967994  #http://physics.nist.gov/cgi-bin/cuu/Value?alph
#LIGHT_SPEED = 137.0359895
ALPHA = 1./ LIGHT_SPEED
LIGHT_SPEED = float(os.environ.get('PYSCF_LIGHT_SPEED', LIGHT_SPEED))
# BOHR = .529 177 210 92(17) e-10m  #http://physics.nist.gov/cgi-bin/cuu/Value?bohrrada0
BOHR = 0.52917721092  # Angstroms

G_ELECTRON = 2.00231930436182   # http://physics.nist.gov/cgi-bin/cuu/Value?gem
E_MASS = 9.10938356e-31         # kg https://physics.nist.gov/cgi-bin/cuu/Value?me
PROTON_MASS = 1.672621898e-27   # kg https://physics.nist.gov/cgi-bin/cuu/Value?mp
BOHR_MAGNETON = 927.4009994e-26 # J/T http://physics.nist.gov/cgi-bin/cuu/Value?mub
NUC_MAGNETON = BOHR_MAGNETON * E_MASS / PROTON_MASS
PLANCK = 6.626070040e-34        # J*s http://physics.nist.gov/cgi-bin/cuu/Value?h
HARTREE2J = 4.359744650e-18     # J https://physics.nist.gov/cgi-bin/cuu/Value?hrj
HARTREE2EV = 27.21138602        # eV https://physics.nist.gov/cgi-bin/cuu/Value?threv
E_CHARGE = 1.6021766208e-19     # C https://physics.nist.gov/cgi-bin/cuu/Value?e
LIGHT_SPEED_SI = 299792458      # https://physics.nist.gov/cgi-bin/cuu/Value?c

OUTPUT_DIGITS = int(os.environ.get('PYSCF_OUTPUT_DIGITS', 5))
OUTPUT_COLS   = int(os.environ.get('PYSCF_OUTPUT_COLS', 5))

ANGULAR = 'spdfghik'
ANGULARMAP = {'s': 0,
              'p': 1,
              'd': 2,
              'f': 3,
              'g': 4,
              'h': 5,
              'i': 6,
              'k': 7}

REAL_SPHERIC = (
    ('',), \
    ('x', 'y', 'z'), \
    ('xy', 'yz', 'z^2', 'xz', 'x2-y2',), \
    ('y^3', 'xyz', 'yz^2', 'z^3', 'xz^2', 'zx^2', 'x^3'), \
    ('-4', '-3', '-2', '-1', ' 0', ' 1', ' 2', ' 3', ' 4'),
    ('-5', '-4', '-3', '-2', '-1', ' 0', ' 1', ' 2', ' 3', ' 4', ' 5'),
    ('-6', '-5', '-4', '-3', '-2', '-1', ' 0', ' 1', ' 2', ' 3', ' 4', ' 5',' 6'),
)

ELEMENTS_PROTON = NUC = {
        'GHOST':  0, 'H'    :  1, 'He'   :  2, 'Li'   :  3, 'Be'   :  4,
        'B'    :  5, 'C'    :  6, 'N'    :  7, 'O'    :  8, 'F'    :  9,
        'Ne'   : 10, 'Na'   : 11, 'Mg'   : 12, 'Al'   : 13, 'Si'   : 14,
        'P'    : 15, 'S'    : 16, 'Cl'   : 17, 'Ar'   : 18, 'K'    : 19,
        'Ca'   : 20, 'Sc'   : 21, 'Ti'   : 22, 'V'    : 23, 'Cr'   : 24,
        'Mn'   : 25, 'Fe'   : 26, 'Co'   : 27, 'Ni'   : 28, 'Cu'   : 29,
        'Zn'   : 30, 'Ga'   : 31, 'Ge'   : 32, 'As'   : 33, 'Se'   : 34,
        'Br'   : 35, 'Kr'   : 36, 'Rb'   : 37, 'Sr'   : 38, 'Y'    : 39,
        'Zr'   : 40, 'Nb'   : 41, 'Mo'   : 42, 'Tc'   : 43, 'Ru'   : 44,
        'Rh'   : 45, 'Pd'   : 46, 'Ag'   : 47, 'Cd'   : 48, 'In'   : 49,
        'Sn'   : 50, 'Sb'   : 51, 'Te'   : 52, 'I'    : 53, 'Xe'   : 54,
        'Cs'   : 55, 'Ba'   : 56, 'La'   : 57, 'Ce'   : 58, 'Pr'   : 59,
        'Nd'   : 60, 'Pm'   : 61, 'Sm'   : 62, 'Eu'   : 63, 'Gd'   : 64,
        'Tb'   : 65, 'Dy'   : 66, 'Ho'   : 67, 'Er'   : 68, 'Tm'   : 69,
        'Yb'   : 70, 'Lu'   : 71, 'Hf'   : 72, 'Ta'   : 73, 'W'    : 74,
        'Re'   : 75, 'Os'   : 76, 'Ir'   : 77, 'Pt'   : 78, 'Au'   : 79,
        'Hg'   : 80, 'Tl'   : 81, 'Pb'   : 82, 'Bi'   : 83, 'Po'   : 84,
        'At'   : 85, 'Rn'   : 86, 'Fr'   : 87, 'Ra'   : 88, 'Ac'   : 89,
        'Th'   : 90, 'Pa'   : 91, 'U'    : 92, 'Np'   : 93, 'Pu'   : 94,
        'Am'   : 95, 'Cm'   : 96, 'Bk'   : 97, 'Cf'   : 98, 'Es'   : 99,
        'Fm'   :100, 'Md'   :101, 'No'   :102, 'Lr'   :103, 'Rf'   :104,
        'Db'   :105, 'Sg'   :106, 'Bh'   :107, 'Hs'   :108, 'Mt'   :109,
        'E110' :110, 'E111' :111, 'E112' :112, 'E113' :113, 'E114' :114,
        'E115' :115, 'E116' :116, 'E117' :117, 'E118' :118 }

# symbol, mass, ground state configuration
# configuration = (num. electrons for each irrep./angular momentum)
ELEMENTS = (
        ('GHOST', 0   , ( 0, 0, 0, 0,)),               #  0
        ('H'    , 1   , ( 1, 0, 0, 0,)),               #  1
        ('He'   , 4   , ( 2, 0, 0, 0,)),               #  2
        ('Li'   , 7   , ( 3, 0, 0, 0,)),               #  3
        ('Be'   , 9   , ( 4, 0, 0, 0,)),               #  4
        ('B'    , 11  , ( 4, 1, 0, 0,)),               #  5
        ('C'    , 12  , ( 4, 2, 0, 0,)),               #  6
        ('N'    , 14  , ( 4, 3, 0, 0,)),               #  7
        ('O'    , 16  , ( 4, 4, 0, 0,)),               #  8
        ('F'    , 19  , ( 4, 5, 0, 0,)),               #  9
        ('Ne'   , 20  , ( 4, 6, 0, 0,)),               # 10
        ('Na'   , 23  , ( 5, 6, 0, 0,)),               # 11
        ('Mg'   , 24  , ( 6, 6, 0, 0,)),               # 12
        ('Al'   , 27  , ( 6, 7, 0, 0,)),               # 13
        ('Si'   , 28  , ( 6, 8, 0, 0,)),               # 14
        ('P'    , 31  , ( 6, 9, 0, 0,)),               # 15
        ('S'    , 32  , ( 6,10, 0, 0,)),               # 16
        ('Cl'   , 35  , ( 6,11, 0, 0,)),               # 17
        ('Ar'   , 40  , ( 6,12, 0, 0,)),               # 18
        ('K'    , 39  , ( 7,12, 0, 0,)),               # 19
        ('Ca'   , 40  , ( 8,12, 0, 0,)),               # 20
        ('Sc'   , 45  , ( 8,12, 1, 0,)),               # 21
        ('Ti'   , 48  , ( 8,12, 2, 0,)),               # 22
        ('V'    , 51  , ( 8,12, 3, 0,)),               # 23
        ('Cr'   , 52  , ( 7,12, 5, 0,)),               # 24
        ('Mn'   , 55  , ( 8,12, 5, 0,)),               # 25
        ('Fe'   , 56  , ( 8,12, 6, 0,)),               # 26
        ('Co'   , 59  , ( 8,12, 7, 0,)),               # 27
        ('Ni'   , 58  , ( 8,12, 8, 0,)),               # 28
        ('Cu'   , 63  , ( 7,12,10, 0,)),               # 29
        ('Zn'   , 64  , ( 8,12,10, 0,)),               # 30
        ('Ga'   , 69  , ( 8,13,10, 0,)),               # 31
        ('Ge'   , 74  , ( 8,14,10, 0,)),               # 32
        ('As'   , 75  , ( 8,15,10, 0,)),               # 33
        ('Se'   , 80  , ( 8,16,10, 0,)),               # 34
        ('Br'   , 79  , ( 8,17,10, 0,)),               # 35
        ('Kr'   , 84  , ( 8,18,10, 0,)),               # 36
        ('Rb'   , 85  , ( 9,18,10, 0,)),               # 37
        ('Sr'   , 88  , (10,18,10, 0,)),               # 38
        ('Y'    , 89  , (10,18,11, 0,)),               # 39
        ('Zr'   , 90  , (10,18,12, 0,)),               # 40
        ('Nb'   , 93  , ( 9,18,14, 0,)),               # 41
        ('Mo'   , 98  , ( 9,18,15, 0,)),               # 42
        ('Tc'   , 98  , (10,18,15, 0,)),               # 43
        ('Ru'   , 102 , ( 9,18,17, 0,)),               # 44
        ('Rh'   , 103 , ( 9,18,18, 0,)),               # 45
        ('Pd'   , 106 , ( 8,18,20, 0,)),               # 46
        ('Ag'   , 107 , ( 9,18,20, 0,)),               # 47
        ('Cd'   , 114 , (10,18,20, 0,)),               # 48
        ('In'   , 115 , (10,19,20, 0,)),               # 49
        ('Sn'   , 120 , (10,20,20, 0,)),               # 50
        ('Sb'   , 121 , (10,21,20, 0,)),               # 51
        ('Te'   , 130 , (10,22,20, 0,)),               # 52
        ('I'    , 127 , (10,23,20, 0,)),               # 53
        ('Xe'   , 132 , (10,24,20, 0,)),               # 54
        ('Cs'   , 133 , (11,24,20, 0,)),               # 55
        ('Ba'   , 138 , (12,24,20, 0,)),               # 56
        ('La'   , 139 , (12,24,21, 0,)),               # 57
        ('Ce'   , 140 , (12,24,21, 1,)),               # 58
        ('Pr'   , 141 , (12,24,20, 3,)),               # 59
        ('Nd'   , 144 , (12,24,20, 4,)),               # 60
        ('Pm'   , 145 , (12,24,20, 5,)),               # 61
        ('Sm'   , 152 , (12,24,20, 6,)),               # 62
        ('Eu'   , 153 , (12,24,20, 7,)),               # 63
        ('Gd'   , 158 , (12,24,21, 7,)),               # 64
        ('Tb'   , 159 , (12,24,21, 8,)),               # 65
        ('Dy'   , 162 , (12,24,20,10,)),               # 66
        ('Ho'   , 162 , (12,24,20,11,)),               # 67
        ('Er'   , 168 , (12,24,20,12,)),               # 68
        ('Tm'   , 169 , (12,24,20,13,)),               # 69
        ('Yb'   , 174 , (12,24,20,14,)),               # 70
        ('Lu'   , 175 , (12,24,21,14,)),               # 71
        ('Hf'   , 180 , (12,24,22,14,)),               # 72
        ('Ta'   , 181 , (12,24,23,14,)),               # 73
        ('W'    , 184 , (12,24,24,14,)),               # 74
        ('Re'   , 187 , (12,24,25,14,)),               # 75
        ('Os'   , 192 , (12,24,26,14,)),               # 76
        ('Ir'   , 193 , (12,24,27,14,)),               # 77
        ('Pt'   , 195 , (11,24,29,14,)),               # 78
        ('Au'   , 197 , (11,24,30,14,)),               # 79
        ('Hg'   , 202 , (12,24,30,14,)),               # 80
        ('Tl'   , 205 , (12,25,30,14,)),               # 81
        ('Pb'   , 208 , (12,26,30,14,)),               # 82
        ('Bi'   , 209 , (12,27,30,14,)),               # 83
        ('Po'   , 209 , (12,28,30,14,)),               # 84
        ('At'   , 210 , (12,29,30,14,)),               # 85
        ('Rn'   , 222 , (12,30,30,14,)),               # 86
        ('Fr'   , 223 , (13,30,30,14,)),               # 87
        ('Ra'   , 226 , (14,30,30,14,)),               # 88
        ('Ac'   , 227 , (14,30,31,14,)),               # 89
        ('Th'   , 232 , (14,30,32,14,)),               # 90
        ('Pa'   , 231 , (14,30,31,16,)),               # 91
        ('U'    , 238 , (14,30,31,17,)),               # 92
        ('Np'   , 237 , (14,30,31,18,)),               # 93
        ('Pu'   , 244 , (14,30,30,20,)),               # 94
        ('Am'   , 243 , (14,30,30,21,)),               # 95
        ('Cm'   , 247 , (14,30,31,21,)),               # 96
        ('Bk'   , 247 , (14,30,31,22,)),               # 97
        ('Cf'   , 251 , (14,30,30,24,)),               # 98
        ('Es'   , 252 , (14,30,30,25,)),               # 99
        ('Fm'   , 257 , (14,30,30,26,)),               #100
        ('Md'   , 258 , (14,30,30,27,)),               #101
        ('No'   , 259 , (14,30,30,28,)),               #102
        ('Lr'   , 262 , (14,30,31,28,)),               #103
        ('Rf'   , 261 , (14,30,32,28,)),               #104
        ('Db'   , 262 , (14,30,33,28,)),               #105
        ('Sg'   , 263 , (14,30,34,28,)),               #106
        ('Bh'   , 262 , (14,30,35,28,)),               #107
        ('Hs'   , 265 , (14,30,36,28,)),               #108
        ('Mt'   , 266 , (14,30,37,28,)),               #109
        ('E110' , 0   , (14,30,38,28,)),               #110
        ('E111' , 0   , (14,30,39,28,)),               #111
        ('E112' , 0   , (14,30,40,28,)),               #112
        ('E113' , 0   , (14,31,40,28,)),               #113
        ('E114' , 0   , (14,32,40,28,)),               #114
        ('E115' , 0   , (14,33,40,28,)),               #115
        ('E116' , 0   , (14,34,40,28,)),               #116
        ('E117' , 0   , (14,35,40,28,)),               #117
        ('E118' , 0   , (14,36,40,28,))                #118
        )

VERBOSE_DEBUG  = 5
VERBOSE_INFO   = 4
VERBOSE_NOTICE = 3
VERBOSE_WARN   = 2
VERBOSE_ERR    = 1
VERBOSE_QUIET  = 0
VERBOSE_CRIT   = -1
VERBOSE_ALERT  = -2
VERBOSE_PANIC  = -3
TIMER_LEVEL    = VERBOSE_DEBUG

POSX = 1
POSY = 2
POSZ = 3
POS1 = 4
POSXX = 1
POSXY = 2
POSXZ = 3
POSYX = 4
POSYY = 5
POSYZ = 6
POSZX = 7
POSZY = 8
POSZZ = 9


