/*
 * Copyright (C) 2013  Qiming Sun <osirpt.sun@gmail.com>
 *
 * Cartisen GTO to spheric or spinor GTO transformation
 * (and reorder the integrals from block(i,j,k,l)_{contr_idx(I,K,L,J)}
 * to (iI,jJ,kK,lL))
 *
 * Cartesian to real-spheric coefficients
 * ref: H. B. Schlegel and M. J.  Frisch, Int. J. Quant. Chem., 54(1995), 83-87.
 */

#include <stdlib.h>
#include <string.h>
#include <complex.h>
#include "cint_const.h"
#include "cint_bas.h"
#include "cart2sph.h"
#include "g1e.h"
#include "misc.h"


static const double g_trans_cart2sph[] = {
        1, /* factors of s and p are moved to CINTcommon_fac_sp */
        // px
        1,
        0,
        0,
        // py
        0,
        1,
        0,
        // pz
        0,
        0,
        1,
        // dxy
        0,
        1.092548430592079070,
        0,
        0,
        0,
        0,
        // dyz
        0,
        0,
        0,
        0,
        1.092548430592079070,
        0,
        // dz2
        -0.315391565252520002,
        0,
        0,
        -0.315391565252520002,
        0,
        0.630783130505040012,
        // dxz
        0,
        0,
        1.092548430592079070,
        0,
        0,
        0,
        // dy2
        0.546274215296039535,
        0,
        0,
        -0.546274215296039535,
        0,
        0,
        // f-3 ~ fyx2
        0,
        1.770130769779930531,
        0,
        0,
        0,
        0,
        -0.590043589926643510,
        0,
        0,
        0,
        // f-2 ~ fxyz
        0,
        0,
        0,
        0,
        2.890611442640554055,
        0,
        0,
        0,
        0,
        0,
        // f-1 ~ fyz2
        0,
        -0.457045799464465739,
        0,
        0,
        0,
        0,
        -0.457045799464465739,
        0,
        1.828183197857862944,
        0,
        // f0 ~ fz3
        0,
        0,
        -1.119528997770346170,
        0,
        0,
        0,
        0,
        -1.119528997770346170,
        0,
        0.746352665180230782,
        // f1 ~ fxz2
        -0.457045799464465739,
        0,
        0,
        -0.457045799464465739,
        0,
        1.828183197857862944,
        0,
        0,
        0,
        0,
        // f2 ~ fzx2
        0,
        0,
        1.445305721320277020,
        0,
        0,
        0,
        0,
        -1.445305721320277020,
        0,
        0,
        // f3 ~ fx3
        0.590043589926643510,
        0,
        0,
        -1.770130769779930530,
        0,
        0,
        0,
        0,
        0,
        0,
        // g-4 ~ gyx3
        0,
        2.503342941796704538,
        0,
        0,
        0,
        0,
        -2.503342941796704530,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        // g-3 ~ gx2yz
        0,
        0,
        0,
        0,
        5.310392309339791593,
        0,
        0,
        0,
        0,
        0,
        0,
        -1.770130769779930530,
        0,
        0,
        0,
        // g-2 ~ gxyz2
        0,
        -0.946174695757560014,
        0,
        0,
        0,
        0,
        -0.946174695757560014,
        0,
        5.677048174545360108,
        0,
        0,
        0,
        0,
        0,
        0,
        // g-1 ~ gyz3
        0,
        0,
        0,
        0,
        -2.007139630671867500,
        0,
        0,
        0,
        0,
        0,
        0,
        -2.007139630671867500,
        0,
        2.676186174229156671,
        0,
        // g0 ~ gz4
        0.317356640745612911,
        0,
        0,
        0.634713281491225822,
        0,
        -2.538853125964903290,
        0,
        0,
        0,
        0,
        0.317356640745612911,
        0,
        -2.538853125964903290,
        0,
        0.846284375321634430,
        // g1 ~ gxz3
        0,
        0,
        -2.007139630671867500,
        0,
        0,
        0,
        0,
        -2.007139630671867500,
        0,
        2.676186174229156671,
        0,
        0,
        0,
        0,
        0,
        // g2 ~ gx2z2
        -0.473087347878780002,
        0,
        0,
        0,
        0,
        2.838524087272680054,
        0,
        0,
        0,
        0,
        0.473087347878780009,
        0,
        -2.838524087272680050,
        0,
        0,
        // g3 ~ gzx3
        0,
        0,
        1.770130769779930531,
        0,
        0,
        0,
        0,
        -5.310392309339791590,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        // g4 ~ gy4
        0.625835735449176134,
        0,
        0,
        -3.755014412695056800,
        0,
        0,
        0,
        0,
        0,
        0,
        0.625835735449176134,
        0,
        0,
        0,
        0,
        // h-5 ~ hyx4
        0,
        3.281910284200850514,
        0,
        0,
        0,
        0,
        -6.563820568401701020,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0.656382056840170102,
        0,
        0,
        0,
        0,
        0,
        // h-4 ~ hx3yz
        0,
        0,
        0,
        0,
        8.302649259524165115,
        0,
        0,
        0,
        0,
        0,
        0,
        -8.302649259524165110,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        // h-3 ~ hyx2z2
        0,
        -1.467714898305751160,
        0,
        0,
        0,
        0,
        -0.978476598870500779,
        0,
        11.741719186446009300,
        0,
        0,
        0,
        0,
        0,
        0,
        0.489238299435250387,
        0,
        -3.913906395482003100,
        0,
        0,
        0,
        // h-2 ~ hxyz3
        0,
        0,
        0,
        0,
        -4.793536784973323750,
        0,
        0,
        0,
        0,
        0,
        0,
        -4.793536784973323750,
        0,
        9.587073569946647510,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        // h-1 ~ hyz4
        0,
        0.452946651195696921,
        0,
        0,
        0,
        0,
        0.905893302391393842,
        0,
        -5.435359814348363050,
        0,
        0,
        0,
        0,
        0,
        0,
        0.452946651195696921,
        0,
        -5.435359814348363050,
        0,
        3.623573209565575370,
        0,
        // h0 ~ hx2y2z
        0,
        0,
        1.754254836801353946,
        0,
        0,
        0,
        0,
        3.508509673602707893,
        0,
        -4.678012898136943850,
        0,
        0,
        0,
        0,
        0,
        0,
        1.754254836801353946,
        0,
        -4.678012898136943850,
        0,
        0.935602579627388771,
        // h1 ~ xz4
        0.452946651195696921,
        0,
        0,
        0.905893302391393842,
        0,
        -5.435359814348363050,
        0,
        0,
        0,
        0,
        0.452946651195696921,
        0,
        -5.435359814348363050,
        0,
        3.623573209565575370,
        0,
        0,
        0,
        0,
        0,
        0,
        // h2 ~ hx2z3
        0,
        0,
        -2.396768392486661870,
        0,
        0,
        0,
        0,
        0,
        0,
        4.793536784973323755,
        0,
        0,
        0,
        0,
        0,
        0,
        2.396768392486661877,
        0,
        -4.793536784973323750,
        0,
        0,
        // h3 ~ hx3z2
        -0.489238299435250389,
        0,
        0,
        0.978476598870500775,
        0,
        3.913906395482003101,
        0,
        0,
        0,
        0,
        1.467714898305751163,
        0,
        -11.741719186446009300,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        // h4 ~ hzy4
        0,
        0,
        2.075662314881041278,
        0,
        0,
        0,
        0,
        -12.453973889286247600,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        2.075662314881041278,
        0,
        0,
        0,
        0,
        // h5 ~ hxy4
        0.656382056840170102,
        0,
        0,
        -6.563820568401701020,
        0,
        0,
        0,
        0,
        0,
        0,
        3.281910284200850514,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        //i-6
        0, 4.0991046311514863, 0, 0, 0, 0, -13.6636821038382887, 0, 0, 0, 0, 0, 0, 0, 0, 4.0991046311514863, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        //i-5
        0, 0, 0, 0, 11.8330958111587634, 0, 0, 0, 0, 0, 0, -23.6661916223175268, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.3666191622317525, 0, 0, 0, 0, 0,
        //i-4
        0, -2.0182596029148963, 0, 0, 0, 0, 0, 0, 20.1825960291489679, 0, 0, 0, 0, 0, 0, 2.0182596029148963, 0, -20.1825960291489679, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        //i-3
        0, 0, 0, 0, -8.2908473356343109, 0, 0, 0, 0, 0, 0, -5.5272315570895412, 0, 22.1089262283581647, 0, 0, 0, 0, 0, 0, 0, 0, 2.7636157785447706, 0, -7.3696420761193888, 0, 0, 0,
        //i-2
        0, 0.9212052595149236, 0, 0, 0, 0, 1.8424105190298472, 0, -14.7392841522387776, 0, 0, 0, 0, 0, 0, 0.9212052595149236, 0, -14.7392841522387776, 0, 14.7392841522387776, 0, 0, 0, 0, 0, 0, 0, 0,
        //i-1
        0, 0, 0, 0, 2.9131068125936568, 0, 0, 0, 0, 0, 0, 5.8262136251873136, 0, -11.6524272503746271, 0, 0, 0, 0, 0, 0, 0, 0, 2.9131068125936568, 0, -11.6524272503746271, 0, 4.6609709001498505, 0,
        //i0
        -0.3178460113381421, 0, 0, -0.9535380340144264, 0, 5.7212282040865583, 0, 0, 0, 0, -0.9535380340144264, 0, 11.4424564081731166, 0, -7.6283042721154111, 0, 0, 0, 0, 0, 0, -0.3178460113381421, 0, 5.7212282040865583, 0, -7.6283042721154111, 0, 1.0171072362820548,
        //i1
        0, 0, 2.9131068125936568, 0, 0, 0, 0, 5.8262136251873136, 0, -11.6524272503746271, 0, 0, 0, 0, 0, 0, 2.9131068125936568, 0, -11.6524272503746271, 0, 4.6609709001498505, 0, 0, 0, 0, 0, 0, 0,
        //i2
        0.4606026297574618, 0, 0, 0.4606026297574618, 0, -7.3696420761193888, 0, 0, 0, 0, -0.4606026297574618, 0, 0, 0, 7.3696420761193888, 0, 0, 0, 0, 0, 0, -0.4606026297574618, 0, 7.3696420761193888, 0, -7.3696420761193888, 0, 0,
        //i3
        0, 0, -2.7636157785447706, 0, 0, 0, 0, 5.5272315570895412, 0, 7.3696420761193888, 0, 0, 0, 0, 0, 0, 8.2908473356343109, 0, -22.1089262283581647, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        //i4
        -0.5045649007287241, 0, 0, 2.5228245036436201, 0, 5.0456490072872420, 0, 0, 0, 0, 2.5228245036436201, 0, -30.2738940437234518, 0, 0, 0, 0, 0, 0, 0, 0, -0.5045649007287241, 0, 5.0456490072872420, 0, 0, 0, 0,
        //i5
        0, 0, 2.3666191622317525, 0, 0, 0, 0, -23.6661916223175268, 0, 0, 0, 0, 0, 0, 0, 0, 11.8330958111587634, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        //i6
        0.6831841051919144, 0, 0, -10.2477615778787161, 0, 0, 0, 0, 0, 0, 10.2477615778787161, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.6831841051919144, 0, 0, 0, 0, 0, 0,
        //j-7
        0, 4.9501391276721742, 0, 0, 0, 0, -24.7506956383608703, 0, 0, 0, 0, 0, 0, 0, 0, 14.8504173830165218, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.7071627325245963, 0, 0, 0, 0, 0, 0, 0,
        //j-6
        0, 0, 0, 0, 15.8757639708114002, 0, 0, 0, 0, 0, 0, -52.9192132360380043, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15.8757639708114002, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        //j-5
        0, -2.5945778936013020, 0, 0, 0, 0, 2.5945778936013020, 0, 31.1349347232156219, 0, 0, 0, 0, 0, 0, 4.6702402084823440, 0, -62.2698694464312439, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.5189155787202604, 0, 6.2269869446431247, 0, 0, 0, 0, 0,
        //j-4
        0, 0, 0, 0, -12.4539738892862495, 0, 0, 0, 0, 0, 0, 0, 0, 41.5132462976208316, 0, 0, 0, 0, 0, 0, 0, 0, 12.4539738892862495, 0, -41.5132462976208316, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        //j-3
        0, 1.4081304047606462, 0, 0, 0, 0, 2.3468840079344107, 0, -28.1626080952129243, 0, 0, 0, 0, 0, 0, 0.4693768015868821, 0, -18.7750720634752817, 0, 37.5501441269505705, 0, 0, 0, 0, 0, 0, 0, 0, -0.4693768015868821, 0, 9.3875360317376408, 0, -12.5167147089835229, 0, 0, 0,
        //j-2
        0, 0, 0, 0, 6.6379903866747414, 0, 0, 0, 0, 0, 0, 13.2759807733494828, 0, -35.4026153955986160, 0, 0, 0, 0, 0, 0, 0, 0, 6.6379903866747414, 0, -35.4026153955986160, 0, 21.2415692373591725, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        //j-1
        0, -0.4516580379125866, 0, 0, 0, 0, -1.3549741137377600, 0, 10.8397929099020782, 0, 0, 0, 0, 0, 0, -1.3549741137377600, 0, 21.6795858198041564, 0, -21.6795858198041564, 0, 0, 0, 0, 0, 0, 0, 0, -0.4516580379125866, 0, 10.8397929099020782, 0, -21.6795858198041564, 0, 5.7812228852811094, 0,
        //j0
        0, 0, -2.3899496919201728, 0, 0, 0, 0, -7.1698490757605189, 0, 14.3396981515210360, 0, 0, 0, 0, 0, 0, -7.1698490757605189, 0, 28.6793963030420720, 0, -11.4717585212168292, 0, 0, 0, 0, 0, 0, 0, 0, -2.3899496919201728, 0, 14.3396981515210360, 0, -11.4717585212168292, 0, 1.0925484305920790,
        //j1
        -0.4516580379125866, 0, 0, -1.3549741137377600, 0, 10.8397929099020782, 0, 0, 0, 0, -1.3549741137377600, 0, 21.6795858198041564, 0, -21.6795858198041564, 0, 0, 0, 0, 0, 0, -0.4516580379125866, 0, 10.8397929099020782, 0, -21.6795858198041564, 0, 5.7812228852811094, 0, 0, 0, 0, 0, 0, 0, 0,
        //j2
        0, 0, 3.3189951933373707, 0, 0, 0, 0, 3.3189951933373707, 0, -17.7013076977993080, 0, 0, 0, 0, 0, 0, -3.3189951933373707, 0, 0, 0, 10.6207846186795862, 0, 0, 0, 0, 0, 0, 0, 0, -3.3189951933373707, 0, 17.7013076977993080, 0, -10.6207846186795862, 0, 0,
        //j3
        0.4693768015868821, 0, 0, -0.4693768015868821, 0, -9.3875360317376408, 0, 0, 0, 0, -2.3468840079344107, 0, 18.7750720634752817, 0, 12.5167147089835229, 0, 0, 0, 0, 0, 0, -1.4081304047606462, 0, 28.1626080952129243, 0, -37.5501441269505705, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        //j4
        0, 0, -3.1134934723215624, 0, 0, 0, 0, 15.5674673616078110, 0, 10.3783115744052079, 0, 0, 0, 0, 0, 0, 15.5674673616078110, 0, -62.2698694464312439, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3.1134934723215624, 0, 10.3783115744052079, 0, 0, 0, 0,
        //j5
        -0.5189155787202604, 0, 0, 4.6702402084823440, 0, 6.2269869446431247, 0, 0, 0, 0, 2.5945778936013020, 0, -62.2698694464312439, 0, 0, 0, 0, 0, 0, 0, 0, -2.5945778936013020, 0, 31.1349347232156219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        //j6
        0, 0, 2.6459606618019000, 0, 0, 0, 0, -39.6894099270284997, 0, 0, 0, 0, 0, 0, 0, 0, 39.6894099270284997, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2.6459606618019000, 0, 0, 0, 0, 0, 0,
        //j7
        0.7071627325245963, 0, 0, -14.8504173830165218, 0, 0, 0, 0, 0, 0, 24.7506956383608703, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4.9501391276721742, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        // l = 8
        0, 5.83141328139864, 0, 0, 0, 0, -40.81989296979048, 0, 0, 0, 0, 0, 0, 0, 0, 40.81989296979048, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5.83141328139864, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 20.40994648489524, 0, 0, 0, 0, 0, 0, -102.0497324244762, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61.22983945468572, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2.91570664069932, 0, 0, 0, 0, 0, 0, 0,
        0, -3.193996596357255, 0, 0, 0, 0, 7.452658724833595, 0, 44.71595234900157, 0, 0, 0, 0, 0, 0, 7.452658724833595, 0, -149.0531744966719, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3.193996596357255, 0, 44.71595234900157, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, -17.24955311049054, 0, 0, 0, 0, 0, 0, 17.24955311049054, 0, 68.99821244196217, 0, 0, 0, 0, 0, 0, 0, 0, 31.04919559888297, 0, -137.9964248839243, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3.449910622098108, 0, 13.79964248839243, 0, 0, 0, 0, 0,
        0, 1.913666099037323, 0, 0, 0, 0, 1.913666099037323, 0, -45.92798637689575, 0, 0, 0, 0, 0, 0, -1.913666099037323, 0, 0, 0, 76.54664396149292, 0, 0, 0, 0, 0, 0, 0, 0, -1.913666099037323, 0, 45.92798637689575, 0, -76.54664396149292, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 11.1173953976599, 0, 0, 0, 0, 0, 0, 18.52899232943316, 0, -74.11596931773265, 0, 0, 0, 0, 0, 0, 0, 0, 3.705798465886632, 0, -49.41064621182176, 0, 59.29277545418611, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3.705798465886632, 0, 24.70532310591088, 0, -19.7642584847287, 0, 0, 0,
        0, -0.9123045168698189, 0, 0, 0, 0, -2.736913550609457, 0, 27.36913550609457, 0, 0, 0, 0, 0, 0, -2.736913550609457, 0, 54.73827101218914, 0, -72.98436134958553, 0, 0, 0, 0, 0, 0, 0, 0, -0.9123045168698189, 0, 27.36913550609457, 0, -72.98436134958553, 0, 29.19374453983421, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, -3.8164436064573, 0, 0, 0, 0, 0, 0, -11.4493308193719, 0, 30.5315488516584, 0, 0, 0, 0, 0, 0, 0, 0, -11.4493308193719, 0, 61.06309770331679, 0, -36.63785862199007, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3.8164436064573, 0, 30.5315488516584, 0, -36.63785862199007, 0, 6.978639737521918, 0,
        0.3180369672047749, 0, 0, 1.272147868819099, 0, -10.1771829505528, 0, 0, 0, 0, 1.908221803228649, 0, -30.53154885165839, 0, 30.53154885165839, 0, 0, 0, 0, 0, 0, 1.272147868819099, 0, -30.53154885165839, 0, 61.06309770331677, 0, -16.28349272088447, 0, 0, 0, 0, 0, 0, 0, 0, 0.3180369672047749, 0, -10.1771829505528, 0, 30.53154885165839, 0, -16.28349272088447, 0, 1.16310662292032,
        0, 0, -3.8164436064573, 0, 0, 0, 0, -11.4493308193719, 0, 30.5315488516584, 0, 0, 0, 0, 0, 0, -11.4493308193719, 0, 61.06309770331679, 0, -36.63785862199007, 0, 0, 0, 0, 0, 0, 0, 0, -3.8164436064573, 0, 30.5315488516584, 0, -36.63785862199007, 0, 6.978639737521918, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        -0.4561522584349095, 0, 0, -0.9123045168698189, 0, 13.68456775304729, 0, 0, 0, 0, 0, 0, 13.68456775304729, 0, -36.49218067479276, 0, 0, 0, 0, 0, 0, 0.9123045168698189, 0, -13.68456775304729, 0, 0, 0, 14.5968722699171, 0, 0, 0, 0, 0, 0, 0, 0, 0.4561522584349095, 0, -13.68456775304729, 0, 36.49218067479276, 0, -14.5968722699171, 0, 0,
        0, 0, 3.705798465886632, 0, 0, 0, 0, -3.705798465886632, 0, -24.70532310591088, 0, 0, 0, 0, 0, 0, -18.52899232943316, 0, 49.41064621182176, 0, 19.7642584847287, 0, 0, 0, 0, 0, 0, 0, 0, -11.1173953976599, 0, 74.11596931773265, 0, -59.29277545418611, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0.4784165247593308, 0, 0, -1.913666099037323, 0, -11.48199659422394, 0, 0, 0, 0, -4.784165247593307, 0, 57.40998297111968, 0, 19.13666099037323, 0, 0, 0, 0, 0, 0, -1.913666099037323, 0, 57.40998297111968, 0, -114.8199659422394, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.4784165247593308, 0, -11.48199659422394, 0, 19.13666099037323, 0, 0, 0, 0,
        0, 0, -3.449910622098108, 0, 0, 0, 0, 31.04919559888297, 0, 13.79964248839243, 0, 0, 0, 0, 0, 0, 17.24955311049054, 0, -137.9964248839243, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -17.24955311049054, 0, 68.99821244196217, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        -0.5323327660595425, 0, 0, 7.452658724833595, 0, 7.452658724833595, 0, 0, 0, 0, 0, 0, -111.7898808725039, 0, 0, 0, 0, 0, 0, 0, 0, -7.452658724833595, 0, 111.7898808725039, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5323327660595425, 0, -7.452658724833595, 0, 0, 0, 0, 0, 0,
        0, 0, 2.91570664069932, 0, 0, 0, 0, -61.22983945468572, 0, 0, 0, 0, 0, 0, 0, 0, 102.0497324244762, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -20.40994648489524, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0.72892666017483, 0, 0, -20.40994648489524, 0, 0, 0, 0, 0, 0, 51.0248662122381, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -20.40994648489524, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.72892666017483, 0, 0, 0, 0, 0, 0, 0, 0,
        // l = 9
        0, 6.740108566678694, 0, 0, 0, 0, -62.9076799556678, 0, 0, 0, 0, 0, 0, 0, 0, 94.36151993350171, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -26.96043426671477, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.7489009518531882, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 25.41854119163758, 0, 0, 0, 0, 0, 0, -177.9297883414631, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 177.9297883414631, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -25.41854119163758, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, -3.814338369408373, 0, 0, 0, 0, 15.25735347763349, 0, 61.02941391053396, 0, 0, 0, 0, 0, 0, 7.628676738816745, 0, -305.1470695526698, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -10.89810962688107, 0, 183.0882417316019, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5449054813440533, 0, -8.718487701504852, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, -22.65129549625621, 0, 0, 0, 0, 0, 0, 52.85302282459782, 0, 105.7060456491956, 0, 0, 0, 0, 0, 0, 0, 0, 52.85302282459782, 0, -352.3534854973187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -22.65129549625621, 0, 105.7060456491956, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 2.436891395195093, 0, 0, 0, 0, 0, 0, -68.23295906546261, 0, 0, 0, 0, 0, 0, -6.82329590654626, 0, 68.23295906546261, 0, 136.4659181309252, 0, 0, 0, 0, 0, 0, 0, 0, -3.899026232312149, 0, 122.8193263178327, 0, -272.9318362618504, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.4873782790390186, 0, -13.64659181309252, 0, 27.29318362618504, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 16.31079695491669, 0, 0, 0, 0, 0, 0, 16.31079695491669, 0, -130.4863756393335, 0, 0, 0, 0, 0, 0, 0, 0, -16.31079695491669, 0, 0, 0, 130.4863756393335, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -16.31079695491669, 0, 130.4863756393335, 0, -130.4863756393335, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, -1.385125560048583, 0, 0, 0, 0, -3.693668160129556, 0, 49.864520161749, 0, 0, 0, 0, 0, 0, -2.770251120097167, 0, 83.107533602915, 0, -166.21506720583, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16.621506720583, 0, -110.8100448038867, 0, 88.64803584310934, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.4617085200161945, 0, -16.621506720583, 0, 55.40502240194333, 0, -29.54934528103645, 0, 0, 0,
        0, 0, 0, 0, -8.46325696792098, 0, 0, 0, 0, 0, 0, -25.38977090376294, 0, 84.63256967920979, 0, 0, 0, 0, 0, 0, 0, 0, -25.38977090376294, 0, 169.2651393584196, 0, -135.4121114867357, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -8.46325696792098, 0, 84.63256967920979, 0, -135.4121114867357, 0, 38.68917471049591, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0.451093112065591, 0, 0, 0, 0, 1.804372448262364, 0, -18.04372448262364, 0, 0, 0, 0, 0, 0, 2.706558672393546, 0, -54.13117344787092, 0, 72.17489793049457, 0, 0, 0, 0, 0, 0, 0, 0, 1.804372448262364, 0, -54.13117344787092, 0, 144.3497958609891, 0, -57.73991834439565, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.451093112065591, 0, -18.04372448262364, 0, 72.17489793049457, 0, -57.73991834439565, 0, 8.248559763485094, 0,
        0, 0, 3.026024588281776, 0, 0, 0, 0, 12.1040983531271, 0, -32.27759560833895, 0, 0, 0, 0, 0, 0, 18.15614752969066, 0, -96.83278682501685, 0, 58.0996720950101, 0, 0, 0, 0, 0, 0, 0, 0, 12.1040983531271, 0, -96.83278682501685, 0, 116.1993441900202, 0, -22.1332084171467, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.026024588281776, 0, -32.27759560833895, 0, 58.0996720950101, 0, -22.1332084171467, 0, 1.229622689841484,
        0.451093112065591, 0, 0, 1.804372448262364, 0, -18.04372448262364, 0, 0, 0, 0, 2.706558672393546, 0, -54.13117344787092, 0, 72.17489793049457, 0, 0, 0, 0, 0, 0, 1.804372448262364, 0, -54.13117344787092, 0, 144.3497958609891, 0, -57.73991834439565, 0, 0, 0, 0, 0, 0, 0, 0, 0.451093112065591, 0, -18.04372448262364, 0, 72.17489793049457, 0, -57.73991834439565, 0, 8.248559763485094, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, -4.23162848396049, 0, 0, 0, 0, -8.46325696792098, 0, 42.3162848396049, 0, 0, 0, 0, 0, 0, 0, 0, 42.3162848396049, 0, -67.70605574336784, 0, 0, 0, 0, 0, 0, 0, 0, 8.46325696792098, 0, -42.3162848396049, 0, 0, 0, 19.34458735524795, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.23162848396049, 0, -42.3162848396049, 0, 67.70605574336784, 0, -19.34458735524795, 0, 0,
        -0.4617085200161945, 0, 0, 0, 0, 16.621506720583, 0, 0, 0, 0, 2.770251120097167, 0, -16.621506720583, 0, -55.40502240194333, 0, 0, 0, 0, 0, 0, 3.693668160129556, 0, -83.107533602915, 0, 110.8100448038867, 0, 29.54934528103645, 0, 0, 0, 0, 0, 0, 0, 0, 1.385125560048583, 0, -49.864520161749, 0, 166.21506720583, 0, -88.64803584310934, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 4.077699238729173, 0, 0, 0, 0, -16.31079695491669, 0, -32.62159390983339, 0, 0, 0, 0, 0, 0, -40.77699238729173, 0, 163.1079695491669, 0, 32.62159390983339, 0, 0, 0, 0, 0, 0, 0, 0, -16.31079695491669, 0, 163.1079695491669, 0, -195.7295634590003, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.077699238729173, 0, -32.62159390983339, 0, 32.62159390983339, 0, 0, 0, 0,
        0.4873782790390186, 0, 0, -3.899026232312149, 0, -13.64659181309252, 0, 0, 0, 0, -6.82329590654626, 0, 122.8193263178327, 0, 27.29318362618504, 0, 0, 0, 0, 0, 0, 0, 0, 68.23295906546261, 0, -272.9318362618504, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.436891395195093, 0, -68.23295906546261, 0, 136.4659181309252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, -3.775215916042701, 0, 0, 0, 0, 52.85302282459782, 0, 17.61767427486594, 0, 0, 0, 0, 0, 0, 0, 0, -264.2651141229891, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -52.85302282459782, 0, 264.2651141229891, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.775215916042701, 0, -17.61767427486594, 0, 0, 0, 0, 0, 0,
        -0.5449054813440533, 0, 0, 10.89810962688107, 0, 8.718487701504852, 0, 0, 0, 0, -7.628676738816745, 0, -183.0882417316019, 0, 0, 0, 0, 0, 0, 0, 0, -15.25735347763349, 0, 305.1470695526698, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.814338369408373, 0, -61.02941391053396, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 3.177317648954698, 0, 0, 0, 0, -88.96489417073154, 0, 0, 0, 0, 0, 0, 0, 0, 222.4122354268289, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -88.96489417073154, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.177317648954698, 0, 0, 0, 0, 0, 0, 0, 0,
        0.7489009518531882, 0, 0, -26.96043426671477, 0, 0, 0, 0, 0, 0, 94.36151993350171, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -62.9076799556678, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6.740108566678694, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        // l = 10
        0, 7.673951182219901, 0, 0, 0, 0, -92.08741418663881, 0, 0, 0, 0, 0, 0, 0, 0, 193.3835697919415, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -92.08741418663881, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7.673951182219901, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 30.88705769902543, 0, 0, 0, 0, 0, 0, -288.2792051909041, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 432.4188077863561, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -123.5482307961017, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.431895299891715, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, -4.453815461763347, 0, 0, 0, 0, 26.72289277058008, 0, 80.16867831174027, 0, 0, 0, 0, 0, 0, 0, 0, -561.1807481821819, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -26.72289277058008, 0, 561.1807481821819, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.453815461763347, 0, -80.16867831174027, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, -28.63763513582592, 0, 0, 0, 0, 0, 0, 114.5505405433037, 0, 152.7340540577382, 0, 0, 0, 0, 0, 0, 0, 0, 57.27527027165184, 0, -763.6702702886912, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -81.82181467378834, 0, 458.2021621732147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.091090733689417, 0, -21.81915057967689, 0, 0, 0, 0, 0, 0, 0,
        0, 2.976705744527138, 0, 0, 0, 0, -3.968940992702851, 0, -95.25458382486842, 0, 0, 0, 0, 0, 0, -13.89129347445998, 0, 222.2606955913596, 0, 222.2606955913597, 0, 0, 0, 0, 0, 0, 0, 0, -3.968940992702851, 0, 222.2606955913596, 0, -740.8689853045323, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.976705744527138, 0, -95.25458382486842, 0, 222.2606955913597, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 22.18705464592268, 0, 0, 0, 0, 0, 0, 0, 0, -207.0791766952783, 0, 0, 0, 0, 0, 0, 0, 0, -62.12375300858349, 0, 207.0791766952783, 0, 248.495012034334, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -35.49928743347628, 0, 372.742518051501, 0, -496.990024068668, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.437410929184535, 0, -41.41583533905566, 0, 49.6990024068668, 0, 0, 0, 0, 0,
        0, -1.870976726712969, 0, 0, 0, 0, -3.741953453425937, 0, 78.58102252194469, 0, 0, 0, 0, 0, 0, 0, 0, 78.58102252194469, 0, -314.3240900877788, 0, 0, 0, 0, 0, 0, 0, 0, 3.741953453425937, 0, -78.58102252194469, 0, 0, 0, 209.5493933918525, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.870976726712969, 0, -78.58102252194469, 0, 314.3240900877788, 0, -209.5493933918525, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, -13.89129347445998, 0, 0, 0, 0, 0, 0, -37.04344926522661, 0, 166.6955216935197, 0, 0, 0, 0, 0, 0, 0, 0, -27.78258694891996, 0, 277.8258694891996, 0, -333.3910433870395, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55.56517389783991, 0, -222.2606955913596, 0, 127.0061117664912, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.630431158153326, 0, -55.56517389783991, 0, 111.1303477956798, 0, -42.33537058883041, 0, 0, 0,
        0, 0.9081022627604556, 0, 0, 0, 0, 3.632409051041822, 0, -43.58890861250187, 0, 0, 0, 0, 0, 0, 5.448613576562733, 0, -130.7667258375056, 0, 217.9445430625093, 0, 0, 0, 0, 0, 0, 0, 0, 3.632409051041822, 0, -130.7667258375056, 0, 435.8890861250187, 0, -232.4741792666766, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.9081022627604556, 0, -43.58890861250187, 0, 217.9445430625093, 0, -232.4741792666766, 0, 49.815895557145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 4.718637772708116, 0, 0, 0, 0, 0, 0, 18.87455109083247, 0, -62.91517030277488, 0, 0, 0, 0, 0, 0, 0, 0, 28.3118266362487, 0, -188.7455109083247, 0, 150.9964087266597, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18.87455109083247, 0, -188.7455109083247, 0, 301.9928174533194, 0, -86.28366212951984, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.718637772708116, 0, -62.91517030277488, 0, 150.9964087266597, 0, -86.28366212951984, 0, 9.587073569946648, 0,
        -0.3181304937373671, 0, 0, -1.590652468686835, 0, 15.90652468686835, 0, 0, 0, 0, -3.181304937373671, 0, 63.62609874747341, 0, -84.83479832996456, 0, 0, 0, 0, 0, 0, -3.181304937373671, 0, 95.43914812121012, 0, -254.5043949898937, 0, 101.8017579959575, 0, 0, 0, 0, 0, 0, 0, 0, -1.590652468686835, 0, 63.62609874747341, 0, -254.5043949898937, 0, 203.6035159919149, 0, -29.08621657027356, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.3181304937373671, 0, 15.90652468686835, 0, -84.83479832996456, 0, 101.8017579959575, 0, -29.08621657027356, 0, 1.292720736456603,
        0, 0, 4.718637772708116, 0, 0, 0, 0, 18.87455109083247, 0, -62.91517030277488, 0, 0, 0, 0, 0, 0, 28.3118266362487, 0, -188.7455109083247, 0, 150.9964087266597, 0, 0, 0, 0, 0, 0, 0, 0, 18.87455109083247, 0, -188.7455109083247, 0, 301.9928174533194, 0, -86.28366212951984, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.718637772708116, 0, -62.91517030277488, 0, 150.9964087266597, 0, -86.28366212951984, 0, 9.587073569946648, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0.4540511313802278, 0, 0, 1.362153394140683, 0, -21.79445430625093, 0, 0, 0, 0, 0.9081022627604556, 0, -43.58890861250187, 0, 108.9722715312547, 0, 0, 0, 0, 0, 0, -0.9081022627604556, 0, 0, 0, 108.9722715312547, 0, -116.2370896333383, 0, 0, 0, 0, 0, 0, 0, 0, -1.362153394140683, 0, 43.58890861250187, 0, -108.9722715312547, 0, 0, 0, 24.9079477785725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.4540511313802278, 0, 21.79445430625093, 0, -108.9722715312547, 0, 116.2370896333383, 0, -24.9079477785725, 0, 0,
        0, 0, -4.630431158153326, 0, 0, 0, 0, 0, 0, 55.56517389783991, 0, 0, 0, 0, 0, 0, 27.78258694891996, 0, -55.56517389783991, 0, -111.1303477956798, 0, 0, 0, 0, 0, 0, 0, 0, 37.04344926522661, 0, -277.8258694891996, 0, 222.2606955913596, 0, 42.33537058883041, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13.89129347445998, 0, -166.6955216935197, 0, 333.3910433870395, 0, -127.0061117664912, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        -0.4677441816782422, 0, 0, 1.403232545034726, 0, 19.64525563048617, 0, 0, 0, 0, 6.548418543495391, 0, -78.58102252194469, 0, -78.58102252194469, 0, 0, 0, 0, 0, 0, 6.548418543495391, 0, -196.4525563048617, 0, 392.9051126097235, 0, 52.38734834796313, 0, 0, 0, 0, 0, 0, 0, 0, 1.403232545034726, 0, -78.58102252194469, 0, 392.9051126097235, 0, -314.3240900877788, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.4677441816782422, 0, 19.64525563048617, 0, -78.58102252194469, 0, 52.38734834796313, 0, 0, 0, 0,
        0, 0, 4.437410929184535, 0, 0, 0, 0, -35.49928743347628, 0, -41.41583533905566, 0, 0, 0, 0, 0, 0, -62.12375300858349, 0, 372.742518051501, 0, 49.6990024068668, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207.0791766952783, 0, -496.990024068668, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 22.18705464592268, 0, -207.0791766952783, 0, 248.495012034334, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0.4961176240878564, 0, 0, -6.449529113142133, 0, -15.8757639708114, 0, 0, 0, 0, -6.945646737229989, 0, 222.2606955913596, 0, 37.04344926522661, 0, 0, 0, 0, 0, 0, 6.945646737229989, 0, 0, 0, -555.6517389783992, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6.449529113142133, 0, -222.2606955913596, 0, 555.6517389783992, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.4961176240878564, 0, 15.8757639708114, 0, -37.04344926522661, 0, 0, 0, 0, 0, 0,
        0, 0, -4.091090733689417, 0, 0, 0, 0, 81.82181467378834, 0, 21.81915057967689, 0, 0, 0, 0, 0, 0, -57.27527027165184, 0, -458.2021621732147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -114.5505405433037, 0, 763.6702702886912, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28.63763513582592, 0, -152.7340540577382, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        -0.5567269327204184, 0, 0, 15.0316271834513, 0, 10.02108478896753, 0, 0, 0, 0, -23.38253117425757, 0, -280.590374091091, 0, 0, 0, 0, 0, 0, 0, 0, -23.38253117425757, 0, 701.4759352277273, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15.0316271834513, 0, -280.590374091091, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.5567269327204184, 0, 10.02108478896753, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 3.431895299891715, 0, 0, 0, 0, -123.5482307961017, 0, 0, 0, 0, 0, 0, 0, 0, 432.4188077863561, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -288.2792051909041, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30.88705769902543, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0.7673951182219901, 0, 0, -34.53278031998956, 0, 0, 0, 0, 0, 0, 161.1529748266179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -161.1529748266179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 34.53278031998956, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.7673951182219901, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        // l = 11
        0, 8.631063163659167, 0, 0, 0, 0, -129.4659474548875, 0, 0, 0, 0, 0, 0, 0, 0, 362.504652873685, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -258.9318949097751, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43.15531581829584, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.7846421057871971, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 36.80297698805311, 0, 0, 0, 0, 0, 0, -441.6357238566373, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 927.4350200989384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -441.6357238566373, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36.80297698805311, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, -5.110940374050938, 0, 0, 0, 0, 42.59116978375781, 0, 102.2188074810188, 0, 0, 0, 0, 0, 0, -23.85105507890438, 0, -954.0422031561751, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -51.10940374050938, 0, 1431.063304734263, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19.87587923242031, 0, -408.875229924075, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.5678822637834375, 0, 11.35764527566875, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, -35.19037680383713, 0, 0, 0, 0, 0, 0, 211.1422608230228, 0, 211.1422608230228, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1477.995825761159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -211.1422608230228, 0, 1477.995825761159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35.19037680383713, 0, -211.1422608230228, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 3.532036427339827, 0, 0, 0, 0, -10.59610928201948, 0, -127.1533113842337, 0, 0, 0, 0, 0, 0, -21.19221856403896, 0, 508.613245536935, 0, 339.0754970246234, 0, 0, 0, 0, 0, 0, 0, 0, 3.027459794862709, 0, 254.3066227684675, 0, -1695.377485123117, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9.586956017065244, 0, -363.295175383525, 0, 1017.22649107387, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.5045766324771181, 0, 18.16475876917625, 0, -48.43935671780334, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 28.72100542905686, 0, 0, 0, 0, 0, 0, -38.29467390540915, 0, -306.3573912432732, 0, 0, 0, 0, 0, 0, 0, 0, -134.031358668932, 0, 714.8339129009709, 0, 428.9003477405824, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -38.29467390540915, 0, 714.8339129009709, 0, -1429.667825801941, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28.72100542905686, 0, -306.3573912432732, 0, 428.9003477405824, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, -2.369836079783365, 0, 0, 0, 0, -2.369836079783365, 0, 113.7521318296015, 0, 0, 0, 0, 0, 0, 6.63554102339342, 0, 0, 0, -530.8432818714737, 0, 0, 0, 0, 0, 0, 0, 0, 10.4272787510468, 0, -318.5059691228842, 0, 530.8432818714737, 0, 424.674625497179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.31777051169671, 0, -182.0034109273624, 0, 955.5179073686526, 0, -849.349250994358, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.4739672159566729, 0, 22.7504263659203, 0, -106.1686563742947, 0, 84.9349250994358, 0, 0, 0, 0, 0,
        0, 0, 0, 0, -20.06399012830402, 0, 0, 0, 0, 0, 0, -40.12798025660804, 0, 280.8958617962563, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 280.8958617962563, 0, -674.150068311015, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40.12798025660804, 0, -280.8958617962563, 0, 0, 0, 321.0238420528643, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20.06399012830402, 0, -280.8958617962563, 0, 674.150068311015, 0, -321.0238420528643, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 1.373687498354136, 0, 0, 0, 0, 5.036854160631831, 0, -76.92649990783158, 0, 0, 0, 0, 0, 0, 6.410541658985967, 0, -205.1373330875509, 0, 461.5589994469895, 0, 0, 0, 0, 0, 0, 0, 0, 2.747374996708271, 0, -153.8529998156632, 0, 769.2649990783159, 0, -615.4119992626527, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.4578958327847119, 0, 0, 0, 153.8529998156632, 0, -410.2746661751018, 0, 175.8319997893294, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.4578958327847119, 0, 25.64216663594386, 0, -153.8529998156632, 0, 205.1373330875509, 0, -58.61066659644312, 0, 0, 0,
        0, 0, 0, 0, 10.27973595067153, 0, 0, 0, 0, 0, 0, 41.11894380268614, 0, -164.4757752107446, 0, 0, 0, 0, 0, 0, 0, 0, 61.67841570402921, 0, -493.4273256322336, 0, 493.4273256322337, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 41.11894380268614, 0, -493.4273256322336, 0, 986.8546512644674, 0, -375.9446290531304, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10.27973595067153, 0, -164.4757752107446, 0, 493.4273256322337, 0, -375.9446290531304, 0, 62.65743817552173, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, -0.4507962425947618, 0, 0, 0, 0, -2.253981212973809, 0, 27.04777455568571, 0, 0, 0, 0, 0, 0, -4.507962425947618, 0, 108.1910982227429, 0, -180.3184970379047, 0, 0, 0, 0, 0, 0, 0, 0, -4.507962425947618, 0, 162.2866473341143, 0, -540.9554911137142, 0, 288.5095952606476, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2.253981212973809, 0, 108.1910982227429, 0, -540.9554911137142, 0, 577.0191905212952, 0, -123.6469693974204, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.4507962425947618, 0, 27.04777455568571, 0, -180.3184970379047, 0, 288.5095952606476, 0, -123.6469693974204, 0, 10.99084172421515, 0,
        0, 0, -3.662285987505434, 0, 0, 0, 0, -18.31142993752717, 0, 61.03809979175723, 0, 0, 0, 0, 0, 0, -36.62285987505434, 0, 244.1523991670289, 0, -195.3219193336232, 0, 0, 0, 0, 0, 0, 0, 0, -36.62285987505434, 0, 366.2285987505434, 0, -585.9657580008695, 0, 167.4187880002484, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -18.31142993752717, 0, 244.1523991670289, 0, -585.9657580008695, 0, 334.8375760004968, 0, -37.20417511116631, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3.662285987505434, 0, 61.03809979175723, 0, -195.3219193336232, 0, 167.4187880002484, 0, -37.20417511116631, 0, 1.352879094951502,
        -0.4507962425947618, 0, 0, -2.253981212973809, 0, 27.04777455568571, 0, 0, 0, 0, -4.507962425947618, 0, 108.1910982227429, 0, -180.3184970379047, 0, 0, 0, 0, 0, 0, -4.507962425947618, 0, 162.2866473341143, 0, -540.9554911137142, 0, 288.5095952606476, 0, 0, 0, 0, 0, 0, 0, 0, -2.253981212973809, 0, 108.1910982227429, 0, -540.9554911137142, 0, 577.0191905212952, 0, -123.6469693974204, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.4507962425947618, 0, 27.04777455568571, 0, -180.3184970379047, 0, 288.5095952606476, 0, -123.6469693974204, 0, 10.99084172421515, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 5.139867975335767, 0, 0, 0, 0, 15.4196039260073, 0, -82.23788760537228, 0, 0, 0, 0, 0, 0, 10.27973595067153, 0, -164.4757752107446, 0, 246.7136628161169, 0, 0, 0, 0, 0, 0, 0, 0, -10.27973595067153, 0, 0, 0, 246.7136628161169, 0, -187.9723145265652, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -15.4196039260073, 0, 164.4757752107446, 0, -246.7136628161169, 0, 0, 0, 31.32871908776087, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5.139867975335767, 0, 82.23788760537228, 0, -246.7136628161169, 0, 187.9723145265652, 0, -31.32871908776087, 0, 0,
        0.4578958327847119, 0, 0, 0.4578958327847119, 0, -25.64216663594386, 0, 0, 0, 0, -2.747374996708271, 0, 0, 0, 153.8529998156632, 0, 0, 0, 0, 0, 0, -6.410541658985967, 0, 153.8529998156632, 0, -153.8529998156632, 0, -205.1373330875509, 0, 0, 0, 0, 0, 0, 0, 0, -5.036854160631831, 0, 205.1373330875509, 0, -769.2649990783159, 0, 410.2746661751018, 0, 58.61066659644312, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1.373687498354136, 0, 76.92649990783158, 0, -461.5589994469895, 0, 615.4119992626527, 0, -175.8319997893294, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, -5.015997532076005, 0, 0, 0, 0, 15.04799259622802, 0, 70.22396544906408, 0, 0, 0, 0, 0, 0, 70.22396544906407, 0, -280.8958617962563, 0, -168.5375170777538, 0, 0, 0, 0, 0, 0, 0, 0, 70.22396544906407, 0, -702.2396544906408, 0, 842.6875853887689, 0, 80.25596051321608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15.04799259622802, 0, -280.8958617962563, 0, 842.6875853887689, 0, -481.5357630792965, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5.015997532076005, 0, 70.22396544906408, 0, -168.5375170777538, 0, 80.25596051321608, 0, 0, 0, 0,
        -0.4739672159566729, 0, 0, 3.31777051169671, 0, 22.7504263659203, 0, 0, 0, 0, 10.4272787510468, 0, -182.0034109273624, 0, -106.1686563742947, 0, 0, 0, 0, 0, 0, 6.63554102339342, 0, -318.5059691228842, 0, 955.5179073686526, 0, 84.9349250994358, 0, 0, 0, 0, 0, 0, 0, 0, -2.369836079783365, 0, 0, 0, 530.8432818714737, 0, -849.349250994358, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2.369836079783365, 0, 113.7521318296015, 0, -530.8432818714737, 0, 424.674625497179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 4.786834238176144, 0, 0, 0, 0, -62.22884509628987, 0, -51.0595652072122, 0, 0, 0, 0, 0, 0, -67.01567933446601, 0, 714.8339129009709, 0, 71.48339129009707, 0, 0, 0, 0, 0, 0, 0, 0, 67.01567933446601, 0, 0, 0, -1072.250869351456, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62.22884509628987, 0, -714.8339129009709, 0, 1072.250869351456, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4.786834238176144, 0, 51.0595652072122, 0, -71.48339129009707, 0, 0, 0, 0, 0, 0,
        0.5045766324771181, 0, 0, -9.586956017065244, 0, -18.16475876917625, 0, 0, 0, 0, -3.027459794862709, 0, 363.295175383525, 0, 48.43935671780334, 0, 0, 0, 0, 0, 0, 21.19221856403896, 0, -254.3066227684675, 0, -1017.22649107387, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10.59610928201948, 0, -508.613245536935, 0, 1695.377485123117, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3.532036427339827, 0, 127.1533113842337, 0, -339.0754970246234, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, -4.398797100479641, 0, 0, 0, 0, 118.7675217129503, 0, 26.39278260287784, 0, 0, 0, 0, 0, 0, -184.7494782201449, 0, -738.9979128805796, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -184.7494782201449, 0, 1847.494782201449, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 118.7675217129503, 0, -738.9979128805796, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4.398797100479641, 0, 26.39278260287784, 0, 0, 0, 0, 0, 0, 0, 0,
        -0.5678822637834375, 0, 0, 19.87587923242031, 0, 11.35764527566875, 0, 0, 0, 0, -51.10940374050938, 0, -408.875229924075, 0, 0, 0, 0, 0, 0, 0, 0, -23.85105507890438, 0, 1431.063304734263, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 42.59116978375781, 0, -954.0422031561751, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5.110940374050938, 0, 102.2188074810188, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 3.680297698805311, 0, 0, 0, 0, -165.613396446239, 0, 0, 0, 0, 0, 0, 0, 0, 772.8625167491152, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -772.8625167491152, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 165.613396446239, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3.680297698805311, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0.7846421057871971, 0, 0, -43.15531581829584, 0, 0, 0, 0, 0, 0, 258.9318949097751, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -362.504652873685, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 129.4659474548875, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -8.631063163659167, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        // l = 12
        0, 9.609863949407661, 0, 0, 0, 0, -176.1808390724738, 0, 0, 0, 0, 0, 0, 0, 0, 634.2510206609056, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -634.2510206609056, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 176.1808390724738, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -9.609863949407661, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 43.15531581829583, 0, 0, 0, 0, 0, 0, -647.3297372744373, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1812.523264368425, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1294.659474548875, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 215.7765790914791, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3.923210528935984, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, -5.784458347938102, 0, 0, 0, 0, 63.62904182731912, 0, 127.2580836546383, 0, 0, 0, 0, 0, 0, -76.35485019278295, 0, -1527.097003855659, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -76.35485019278295, 0, 3206.903708096884, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63.62904182731912, 0, -1527.097003855659, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5.784458347938102, 0, 127.2580836546383, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, -42.2938455917996, 0, 0, 0, 0, 0, 0, 352.4487132649967, 0, 281.9589706119974, 0, 0, 0, 0, 0, 0, 0, 0, -197.3712794283981, 0, -2631.617059045309, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -422.938455917996, 0, 3947.425588567963, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 164.4760661903318, 0, -1127.835882447989, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4.699316176866622, 0, 31.32877451244415, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 4.101899446670816, 0, 0, 0, 0, -20.50949723335408, 0, -164.0759778668327, 0, 0, 0, 0, 0, 0, -24.6113966800249, 0, 984.455867200996, 0, 492.2279336004979, 0, 0, 0, 0, 0, 0, 0, 0, 24.6113966800249, 0, 0, 0, -3445.595535203485, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20.50949723335408, 0, -984.455867200996, 0, 3445.595535203485, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4.101899446670816, 0, 164.0759778668327, 0, -492.2279336004979, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 35.89162015836965, 0, 0, 0, 0, 0, 0, -107.6748604751089, 0, -430.6994419004357, 0, 0, 0, 0, 0, 0, 0, 0, -215.3497209502179, 0, 1722.797767601743, 0, 689.1191070406971, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30.76424585003112, 0, 861.3988838008713, 0, -3445.595535203485, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97.42011185843189, 0, -1230.569834001245, 0, 2067.357321122091, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5.127374308338521, 0, 61.52849170006224, 0, -98.44558672009958, 0, 0, 0, 0, 0, 0, 0,
        0, -2.881335616715016, 0, 0, 0, 0, 0.9604452055716719, 0, 155.5921233026108, 0, 0, 0, 0, 0, 0, 17.28801370029009, 0, -207.4561644034811, 0, -829.8246576139245, 0, 0, 0, 0, 0, 0, 0, 0, 17.28801370029009, 0, -726.0965754121839, 0, 1936.257534432491, 0, 774.5030137729962, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.9604452055716719, 0, -207.4561644034811, 0, 1936.257534432491, 0, -2581.676712576654, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2.881335616715016, 0, 155.5921233026108, 0, -829.8246576139245, 0, 774.5030137729962, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, -26.95242673514147, 0, 0, 0, 0, 0, 0, -26.95242673514147, 0, 431.2388277622634, 0, 0, 0, 0, 0, 0, 0, 0, 75.4667948583961, 0, 0, 0, -1207.468717734338, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 118.5906776346225, 0, -1207.468717734338, 0, 1207.468717734338, 0, 689.9821244196215, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37.73339742919805, 0, -689.9821244196215, 0, 2173.443691921808, 0, -1379.964248839243, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5.390485347028293, 0, 86.24776555245269, 0, -241.4937435468676, 0, 137.9964248839243, 0, 0, 0, 0, 0,
        0, 1.848921220493557, 0, 0, 0, 0, 5.54676366148067, 0, -118.3309581115876, 0, 0, 0, 0, 0, 0, 3.697842440987113, 0, -236.6619162231752, 0, 828.3167067811135, 0, 0, 0, 0, 0, 0, 0, 0, -3.697842440987113, 0, 0, 0, 828.3167067811135, 0, -1325.306730849781, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5.54676366148067, 0, 236.6619162231752, 0, -828.3167067811135, 0, 0, 0, 473.3238324463505, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1.848921220493557, 0, 118.3309581115876, 0, -828.3167067811135, 0, 1325.306730849781, 0, -473.3238324463505, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 16.64029098444201, 0, 0, 0, 0, 0, 0, 61.01440027628737, 0, -310.6187650429175, 0, 0, 0, 0, 0, 0, 0, 0, 77.65469126072938, 0, -828.3167067811133, 0, 1118.227554154503, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33.28058196888402, 0, -621.237530085835, 0, 1863.712590257505, 0, -1064.978623004289, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5.54676366148067, 0, 0, 0, 372.742518051501, 0, -709.9857486695257, 0, 236.6619162231752, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5.54676366148067, 0, 103.5395883476392, 0, -372.742518051501, 0, 354.9928743347629, 0, -78.88730540772508, 0, 0, 0,
        0, -0.9057827129626244, 0, 0, 0, 0, -4.528913564813122, 0, 63.4047899073837, 0, 0, 0, 0, 0, 0, -9.057827129626244, 0, 253.6191596295348, 0, -507.2383192590696, 0, 0, 0, 0, 0, 0, 0, 0, -9.057827129626244, 0, 380.4287394443022, 0, -1521.714957777209, 0, 1014.476638518139, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4.528913564813122, 0, 253.6191596295348, 0, -1521.714957777209, 0, 2028.953277036278, 0, -579.7009362960796, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.9057827129626244, 0, 63.4047899073837, 0, -507.2383192590696, 0, 1014.476638518139, 0, -579.7009362960796, 0, 77.2934581728106, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, -5.620233931023189, 0, 0, 0, 0, 0, 0, -28.10116965511595, 0, 112.4046786204638, 0, 0, 0, 0, 0, 0, 0, 0, -56.20233931023189, 0, 449.6187144818551, 0, -449.6187144818551, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -56.20233931023189, 0, 674.4280717227828, 0, -1348.856143445566, 0, 513.8499594078344, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -28.10116965511595, 0, 449.6187144818551, 0, -1348.856143445566, 0, 1027.699918815669, 0, -171.2833198026115, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5.620233931023189, 0, 112.4046786204638, 0, -449.6187144818551, 0, 513.8499594078344, 0, -171.2833198026115, 0, 12.4569687129172, 0,
        0.318183090330888, 0, 0, 1.909098541985328, 0, -22.90918250382393, 0, 0, 0, 0, 4.77274635496332, 0, -114.5459125191197, 0, 190.9098541985328, 0, 0, 0, 0, 0, 0, 6.36366180661776, 0, -229.0918250382393, 0, 763.6394167941311, 0, -407.2743556235366, 0, 0, 0, 0, 0, 0, 0, 0, 4.77274635496332, 0, -229.0918250382393, 0, 1145.459125191197, 0, -1221.82306687061, 0, 261.8192286151307, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.909098541985328, 0, -114.5459125191197, 0, 763.6394167941311, 0, -1221.82306687061, 0, 523.6384572302613, 0, -46.5456406426899, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.318183090330888, 0, -22.90918250382393, 0, 190.9098541985328, 0, -407.2743556235366, 0, 261.8192286151307, 0, -46.5456406426899, 0, 1.410473958869391,
        0, 0, -5.620233931023189, 0, 0, 0, 0, -28.10116965511595, 0, 112.4046786204638, 0, 0, 0, 0, 0, 0, -56.20233931023189, 0, 449.6187144818551, 0, -449.6187144818551, 0, 0, 0, 0, 0, 0, 0, 0, -56.20233931023189, 0, 674.4280717227828, 0, -1348.856143445566, 0, 513.8499594078344, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -28.10116965511595, 0, 449.6187144818551, 0, -1348.856143445566, 0, 1027.699918815669, 0, -171.2833198026115, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5.620233931023189, 0, 112.4046786204638, 0, -449.6187144818551, 0, 513.8499594078344, 0, -171.2833198026115, 0, 12.4569687129172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        -0.4528913564813122, 0, 0, -1.811565425925249, 0, 31.70239495369185, 0, 0, 0, 0, -2.264456782406561, 0, 95.10718486107555, 0, -253.6191596295348, 0, 0, 0, 0, 0, 0, 0, 0, 63.4047899073837, 0, -507.2383192590696, 0, 507.2383192590696, 0, 0, 0, 0, 0, 0, 0, 0, 2.264456782406561, 0, -63.4047899073837, 0, 0, 0, 507.2383192590696, 0, -289.8504681480398, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.811565425925249, 0, -95.10718486107555, 0, 507.2383192590696, 0, -507.2383192590696, 0, 0, 0, 38.6467290864053, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.4528913564813122, 0, -31.70239495369185, 0, 253.6191596295348, 0, -507.2383192590696, 0, 289.8504681480398, 0, -38.6467290864053, 0, 0,
        0, 0, 5.54676366148067, 0, 0, 0, 0, 5.54676366148067, 0, -103.5395883476392, 0, 0, 0, 0, 0, 0, -33.28058196888402, 0, 0, 0, 372.742518051501, 0, 0, 0, 0, 0, 0, 0, 0, -77.65469126072938, 0, 621.237530085835, 0, -372.742518051501, 0, -354.9928743347629, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -61.01440027628737, 0, 828.3167067811133, 0, -1863.712590257505, 0, 709.9857486695257, 0, 78.88730540772508, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -16.64029098444201, 0, 310.6187650429175, 0, -1118.227554154503, 0, 1064.978623004289, 0, -236.6619162231752, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0.4622303051233891, 0, 0, -0.9244606102467783, 0, -29.5827395278969, 0, 0, 0, 0, -7.857915187097616, 0, 88.74821858369071, 0, 207.0791766952784, 0, 0, 0, 0, 0, 0, -12.9424485434549, 0, 414.1583533905567, 0, -828.3167067811135, 0, -331.3266827124453, 0, 0, 0, 0, 0, 0, 0, 0, -7.857915187097616, 0, 414.1583533905567, 0, -2070.791766952784, 0, 1656.633413562227, 0, 118.3309581115876, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.9244606102467783, 0, 88.74821858369071, 0, -828.3167067811135, 0, 1656.633413562227, 0, -709.9857486695257, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.4622303051233891, 0, -29.5827395278969, 0, 207.0791766952784, 0, -331.3266827124453, 0, 118.3309581115876, 0, 0, 0, 0,
        0, 0, -5.390485347028293, 0, 0, 0, 0, 37.73339742919805, 0, 86.24776555245269, 0, 0, 0, 0, 0, 0, 118.5906776346225, 0, -689.9821244196215, 0, -241.4937435468676, 0, 0, 0, 0, 0, 0, 0, 0, 75.4667948583961, 0, -1207.468717734338, 0, 2173.443691921808, 0, 137.9964248839243, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -26.95242673514147, 0, 0, 0, 1207.468717734338, 0, -1379.964248839243, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -26.95242673514147, 0, 431.2388277622634, 0, -1207.468717734338, 0, 689.9821244196215, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        -0.480222602785836, 0, 0, 5.762671233430032, 0, 25.93202055043514, 0, 0, 0, 0, 12.96601027521757, 0, -337.1162671556568, 0, -138.3041096023208, 0, 0, 0, 0, 0, 0, 0, 0, -363.048287706092, 0, 1936.257534432491, 0, 129.0838356288327, 0, 0, 0, 0, 0, 0, 0, 0, -12.96601027521757, 0, 363.048287706092, 0, 0, 0, -1936.257534432491, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5.762671233430032, 0, 337.1162671556568, 0, -1936.257534432491, 0, 1936.257534432491, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.480222602785836, 0, -25.93202055043514, 0, 138.3041096023208, 0, -129.0838356288327, 0, 0, 0, 0, 0, 0,
        0, 0, 5.127374308338521, 0, 0, 0, 0, -97.42011185843189, 0, -61.52849170006224, 0, 0, 0, 0, 0, 0, -30.76424585003112, 0, 1230.569834001245, 0, 98.44558672009958, 0, 0, 0, 0, 0, 0, 0, 0, 215.3497209502179, 0, -861.3988838008713, 0, -2067.357321122091, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 107.6748604751089, 0, -1722.797767601743, 0, 3445.595535203485, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -35.89162015836965, 0, 430.6994419004357, 0, -689.1191070406971, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0.512737430833852, 0, 0, -13.33117320168015, 0, -20.50949723335408, 0, 0, 0, 0, 7.691061462507781, 0, 553.7564253005602, 0, 61.52849170006224, 0, 0, 0, 0, 0, 0, 43.06994419004357, 0, -861.3988838008714, 0, -1722.797767601743, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7.691061462507781, 0, -861.3988838008714, 0, 4306.994419004357, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -13.33117320168015, 0, 553.7564253005602, 0, -1722.797767601743, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.512737430833852, 0, -20.50949723335408, 0, 61.52849170006224, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, -4.699316176866622, 0, 0, 0, 0, 164.4760661903318, 0, 31.32877451244415, 0, 0, 0, 0, 0, 0, -422.938455917996, 0, -1127.835882447989, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -197.3712794283981, 0, 3947.425588567963, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 352.4487132649967, 0, -2631.617059045309, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -42.2938455917996, 0, 281.9589706119974, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        -0.5784458347938102, 0, 0, 25.45161673092765, 0, 12.72580836546383, 0, 0, 0, 0, -95.44356274097868, 0, -572.6613764458722, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2672.419756747403, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95.44356274097868, 0, -2672.419756747403, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -25.45161673092765, 0, 572.6613764458722, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5784458347938102, 0, -12.72580836546383, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 3.923210528935984, 0, 0, 0, 0, -215.7765790914791, 0, 0, 0, 0, 0, 0, 0, 0, 1294.659474548875, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1812.523264368425, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 647.3297372744373, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -43.15531581829583, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0.8008219957839717, 0, 0, -52.85425172174213, 0, 0, 0, 0, 0, 0, 396.406887913066, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -739.9595241043899, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 396.406887913066, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -52.85425172174213, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.8008219957839717, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

/*
 * / xyz_alpha \
 * \ xyz_beta  /
 */
static const double complex g_trans_cart2j[] = {
        0 + 0*_Complex_I,
        1 + 0*_Complex_I,
        1 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.577350269189625764 + 0*_Complex_I,  // p1/2
        0 + 0.577350269189625764*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.577350269189625764 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.577350269189625764 + 0*_Complex_I,
       -0.577350269189625764 + 0*_Complex_I,
        0 - 0.577350269189625764*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,  // p3/2
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.707106781186547524 + 0*_Complex_I,
        0 - 0.707106781186547524*_Complex_I,
        0 + 0*_Complex_I,
        0.408248290463863016 + 0*_Complex_I,
        0 - 0.408248290463863016*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.816496580927726033 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.816496580927726033 + 0*_Complex_I,
       -0.408248290463863016 + 0*_Complex_I,
        0 - 0.408248290463863016*_Complex_I,
        0 + 0*_Complex_I,
       -0.707106781186547524 + 0*_Complex_I,
        0 - 0.707106781186547524*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.345494149471335479 + 0*_Complex_I,  // d3/2
        0 + 0.690988298942670958*_Complex_I,
        0 + 0*_Complex_I,
        0.345494149471335479 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.345494149471335479 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.345494149471335479*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.598413420602149016 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.598413420602149016*_Complex_I,
        0 + 0*_Complex_I,
       -0.199471140200716338 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.199471140200716338 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.398942280401432677 + 0*_Complex_I,
        0.199471140200716338 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.199471140200716338 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.398942280401432677 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.598413420602149016 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.598413420602149016*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.345494149471335479 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.345494149471335479*_Complex_I,
        0 + 0*_Complex_I,
        0.345494149471335479 + 0*_Complex_I,
        0 + 0.690988298942670958*_Complex_I,
        0 + 0*_Complex_I,
       -0.345494149471335479 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.386274202023189580 + 0*_Complex_I,
        0 - 0.772548404046379160*_Complex_I,
        0 + 0*_Complex_I,
       -0.386274202023189580 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.172747074735667739 + 0*_Complex_I,
        0 - 0.345494149471335479*_Complex_I,
        0 + 0*_Complex_I,
       -0.172747074735667739 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.690988298942670958 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.690988298942670958*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.488602511902919921 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.488602511902919921*_Complex_I,
        0 + 0*_Complex_I,
       -0.244301255951459960 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.244301255951459960 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.488602511902919921 + 0*_Complex_I,
       -0.244301255951459960 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.244301255951459960 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.488602511902919921 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.488602511902919921 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.488602511902919921*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.690988298942670958 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.690988298942670958*_Complex_I,
        0 + 0*_Complex_I,
        0.172747074735667739 + 0*_Complex_I,
        0 + 0.345494149471335479*_Complex_I,
        0 + 0*_Complex_I,
       -0.172747074735667739 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.386274202023189580 + 0*_Complex_I,
        0 + 0.772548404046379160*_Complex_I,
        0 + 0*_Complex_I,
       -0.386274202023189580 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.386274202023189580 + 0*_Complex_I,
        0 + 1.158822606069568741*_Complex_I,
        0 + 0*_Complex_I,
        1.158822606069568741 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.386274202023189580*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.386274202023189580 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.772548404046379160*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.386274202023189580 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.863735373678338698 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.727470747356677396*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.863735373678338698 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.172747074735667739 + 0*_Complex_I,
        0 + 0.172747074735667739*_Complex_I,
        0 + 0*_Complex_I,
       -0.172747074735667739 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.690988298942670958 + 0*_Complex_I,
        0 + 0.172747074735667739*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.690988298942670958*_Complex_I,
        0 + 0*_Complex_I,
        0.244301255951459960 + 0*_Complex_I,
        0 - 0.244301255951459960*_Complex_I,
        0 + 0*_Complex_I,
        0.244301255951459960 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.977205023805839843 + 0*_Complex_I,
        0 - 0.244301255951459960*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.977205023805839843*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.732903767854379882 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.732903767854379882 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.488602511902919921 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.732903767854379882 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.732903767854379882 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.488602511902919921 + 0*_Complex_I,
        0.244301255951459960 + 0*_Complex_I,
        0 + 0.244301255951459960*_Complex_I,
        0 + 0*_Complex_I,
        0.244301255951459960 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.977205023805839843 + 0*_Complex_I,
        0 + 0.244301255951459960*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.977205023805839843*_Complex_I,
        0 + 0*_Complex_I,
       -0.172747074735667739 + 0*_Complex_I,
        0 - 0.172747074735667739*_Complex_I,
        0 + 0*_Complex_I,
       -0.172747074735667739 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.690988298942670958 + 0*_Complex_I,
        0 - 0.172747074735667739*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.690988298942670958*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.863735373678338698 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.727470747356677396*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.863735373678338698 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.386274202023189580 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.772548404046379160*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.386274202023189580 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.386274202023189580 + 0*_Complex_I,
        0 - 1.158822606069568741*_Complex_I,
        0 + 0*_Complex_I,
        1.158822606069568741 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.386274202023189580*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.417223823632784089 + 0*_Complex_I,
        0 - 1.251671470898352269*_Complex_I,
        0 + 0*_Complex_I,
       -1.251671470898352269 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.417223823632784089*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.157695782626260003 + 0*_Complex_I,
        0 - 0.473087347878780009*_Complex_I,
        0 + 0*_Complex_I,
       -0.473087347878780009 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.157695782626260003*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.946174695757560018 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.892349391515120036*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.946174695757560018 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.546274215296039535 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.092548430592079070*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.546274215296039535 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.273137107648019767 + 0*_Complex_I,
        0 + 0.273137107648019767*_Complex_I,
        0 + 0*_Complex_I,
       -0.273137107648019767 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.092548430592079070 + 0*_Complex_I,
        0 + 0.273137107648019767*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.092548430592079070*_Complex_I,
        0 + 0*_Complex_I,
       -0.211571093830408607 + 0*_Complex_I,
        0 + 0.211571093830408607*_Complex_I,
        0 + 0*_Complex_I,
       -0.211571093830408607 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.846284375321634430 + 0*_Complex_I,
        0 + 0.211571093830408607*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.846284375321634430*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.846284375321634430 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.846284375321634430 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.564189583547756286 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.846284375321634430 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.846284375321634430 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.564189583547756286 + 0*_Complex_I,
        0.211571093830408607 + 0*_Complex_I,
        0 + 0.211571093830408607*_Complex_I,
        0 + 0*_Complex_I,
        0.211571093830408607 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.846284375321634430 + 0*_Complex_I,
        0 + 0.211571093830408607*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.846284375321634430*_Complex_I,
        0 + 0*_Complex_I,
        0.273137107648019767 + 0*_Complex_I,
        0 + 0.273137107648019767*_Complex_I,
        0 + 0*_Complex_I,
        0.273137107648019767 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.092548430592079070 + 0*_Complex_I,
        0 + 0.273137107648019767*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.092548430592079070*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.546274215296039535 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.092548430592079070*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.546274215296039535 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.946174695757560018 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.892349391515120036*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.946174695757560018 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.157695782626260003 + 0*_Complex_I,
        0 - 0.473087347878780009*_Complex_I,
        0 + 0*_Complex_I,
        0.473087347878780009 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.157695782626260003*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.417223823632784089 + 0*_Complex_I,
        0 - 1.251671470898352269*_Complex_I,
        0 + 0*_Complex_I,
        1.251671470898352269 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.417223823632784089*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.417223823632784089 + 0*_Complex_I,
        0 + 1.668895294531136358*_Complex_I,
        0 + 0*_Complex_I,
        2.503342941796704538 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.668895294531136358*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.417223823632784089 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.417223823632784089 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.251671470898352269*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.251671470898352269 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.417223823632784089*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.103870478383820021 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 3.311611435151460063*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        3.311611435151460063 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.103870478383820021*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.157695782626260003 + 0*_Complex_I,
        0 + 0.315391565252520006*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.946174695757560018 + 0*_Complex_I,
        0 + 0.315391565252520006*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.892349391515120036*_Complex_I,
        0 + 0*_Complex_I,
        0.157695782626260003 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.946174695757560018 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.273137107648019767 + 0*_Complex_I,
        0 - 0.546274215296039535*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.638822645888118605 + 0*_Complex_I,
        0 - 0.546274215296039535*_Complex_I,
        0 + 0*_Complex_I,
        0 + 3.277645291776237211*_Complex_I,
        0 + 0*_Complex_I,
       -0.273137107648019767 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.638822645888118605 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.819411322944059302 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.819411322944059302*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.819411322944059302 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.092548430592079070 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.819411322944059302*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.092548430592079070*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.057855469152043038 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.057855469152043038*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.057855469152043038 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.410473958869390717 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.057855469152043038*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.410473958869390717*_Complex_I,
        0 + 0*_Complex_I,
        0.211571093830408607 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.423142187660817215 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.692568750643268860 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.211571093830408607 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.692568750643268860 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.564189583547756286 + 0*_Complex_I,
       -0.211571093830408607 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.423142187660817215 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.692568750643268860 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.211571093830408607 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.692568750643268860 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.564189583547756286 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.057855469152043038 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.057855469152043038*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.057855469152043038 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.410473958869390717 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.057855469152043038*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.410473958869390717*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.819411322944059302 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.819411322944059302*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.819411322944059302 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.092548430592079070 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.819411322944059302*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.092548430592079070*_Complex_I,
        0 + 0*_Complex_I,
       -0.273137107648019767 + 0*_Complex_I,
        0 - 0.546274215296039535*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.638822645888118605 + 0*_Complex_I,
        0 - 0.546274215296039535*_Complex_I,
        0 + 0*_Complex_I,
        0 + 3.277645291776237211*_Complex_I,
        0 + 0*_Complex_I,
        0.273137107648019767 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.638822645888118605 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.157695782626260003 + 0*_Complex_I,
        0 + 0.315391565252520006*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.946174695757560018 + 0*_Complex_I,
        0 + 0.315391565252520006*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.892349391515120036*_Complex_I,
        0 + 0*_Complex_I,
       -0.157695782626260003 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.946174695757560018 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.103870478383820021 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 3.311611435151460063*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        3.311611435151460063 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.103870478383820021*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.417223823632784089 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.251671470898352269*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.251671470898352269 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.417223823632784089*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.417223823632784089 + 0*_Complex_I,
        0 + 1.668895294531136358*_Complex_I,
        0 + 0*_Complex_I,
       -2.503342941796704538 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.668895294531136358*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.417223823632784089 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.442532692444982632 + 0*_Complex_I,
        0 - 1.770130769779930531*_Complex_I,
        0 + 0*_Complex_I,
       -2.655196154669895796 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.770130769779930531*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.442532692444982632 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.147510897481660877 + 0*_Complex_I,
        0 - 0.590043589926643510*_Complex_I,
        0 + 0*_Complex_I,
       -0.885065384889965265 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.590043589926643510*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.147510897481660877 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.180087179853287020 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 3.540261539559861062*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -3.540261539559861062 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.180087179853287020*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.590043589926643510 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.770130769779930531*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.770130769779930531 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.590043589926643510*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.295021794963321755 + 0*_Complex_I,
        0 + 0.590043589926643510*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.770130769779930531 + 0*_Complex_I,
        0 + 0.590043589926643510*_Complex_I,
        0 + 0*_Complex_I,
        0 - 3.540261539559861062*_Complex_I,
        0 + 0*_Complex_I,
        0.295021794963321755 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.770130769779930531 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.193137101011594790 + 0*_Complex_I,
        0 + 0.386274202023189580*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.158822606069568741 + 0*_Complex_I,
        0 + 0.386274202023189580*_Complex_I,
        0 + 0*_Complex_I,
        0 - 2.317645212139137482*_Complex_I,
        0 + 0*_Complex_I,
        0.193137101011594790 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.158822606069568741 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.158822606069568741 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.158822606069568741*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.158822606069568741 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.545096808092758321 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.158822606069568741*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.545096808092758321*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.946174695757560018 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.946174695757560018*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.946174695757560018 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.261566261010080024 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.946174695757560018*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.261566261010080024*_Complex_I,
        0 + 0*_Complex_I,
        0.236543673939390004 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.473087347878780009 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.892349391515120036 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.236543673939390004 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.892349391515120036 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.630783130505040012 + 0*_Complex_I,
        0.236543673939390004 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.473087347878780009 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.892349391515120036 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.236543673939390004 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.892349391515120036 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.630783130505040012 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.946174695757560018 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.946174695757560018*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.946174695757560018 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.261566261010080024 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.946174695757560018*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.261566261010080024*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.158822606069568741 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.158822606069568741*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.158822606069568741 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.545096808092758321 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.158822606069568741*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.545096808092758321*_Complex_I,
        0 + 0*_Complex_I,
       -0.193137101011594790 + 0*_Complex_I,
        0 - 0.386274202023189580*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.158822606069568741 + 0*_Complex_I,
        0 - 0.386274202023189580*_Complex_I,
        0 + 0*_Complex_I,
        0 + 2.317645212139137482*_Complex_I,
        0 + 0*_Complex_I,
        0.193137101011594790 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.158822606069568741 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.295021794963321755 + 0*_Complex_I,
        0 - 0.590043589926643510*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.770130769779930531 + 0*_Complex_I,
        0 - 0.590043589926643510*_Complex_I,
        0 + 0*_Complex_I,
        0 + 3.540261539559861062*_Complex_I,
        0 + 0*_Complex_I,
        0.295021794963321755 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.770130769779930531 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.590043589926643510 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.770130769779930531*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.770130769779930531 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.590043589926643510*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.180087179853287020 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 3.540261539559861062*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        3.540261539559861062 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.180087179853287020*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.147510897481660877 + 0*_Complex_I,
        0 + 0.590043589926643510*_Complex_I,
        0 + 0*_Complex_I,
       -0.885065384889965265 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.590043589926643510*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.147510897481660877 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.442532692444982632 + 0*_Complex_I,
        0 + 1.770130769779930531*_Complex_I,
        0 + 0*_Complex_I,
       -2.655196154669895796 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.770130769779930531*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.442532692444982632 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.442532692444982632 + 0*_Complex_I,
        0 + 2.212663462224913163*_Complex_I,
        0 + 0*_Complex_I,
        4.425326924449826327 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 4.425326924449826327*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.212663462224913163 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.442532692444982632*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.442532692444982632 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.770130769779930531*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.655196154669895796 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.770130769779930531*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.442532692444982632 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.327598077334947898 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 5.310392309339791593*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        7.965588464009687389 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 5.310392309339791593*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.327598077334947898 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.147510897481660877 + 0*_Complex_I,
        0 + 0.442532692444982632*_Complex_I,
        0 + 0*_Complex_I,
        0.295021794963321755 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.180087179853287020 + 0*_Complex_I,
        0 + 0.295021794963321755*_Complex_I,
        0 + 0*_Complex_I,
        0 - 3.540261539559861062*_Complex_I,
        0 + 0*_Complex_I,
        0.442532692444982632 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -3.540261539559861062 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.147510897481660877*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.180087179853287020*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.295021794963321755 + 0*_Complex_I,
        0 - 0.885065384889965265*_Complex_I,
        0 + 0*_Complex_I,
       -0.590043589926643510 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.360174359706574041 + 0*_Complex_I,
        0 - 0.590043589926643510*_Complex_I,
        0 + 0*_Complex_I,
        0 + 7.080523079119722124*_Complex_I,
        0 + 0*_Complex_I,
       -0.885065384889965265 + 0*_Complex_I,
        0 + 0*_Complex_I,
        7.080523079119722124 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.295021794963321755*_Complex_I,
        0 + 0*_Complex_I,
        0 - 2.360174359706574041*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.885065384889965265 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.770130769779930531*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.770130769779930531 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.770130769779930531*_Complex_I,
        0 + 0*_Complex_I,
        0 - 3.540261539559861062*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.885065384889965265 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.770130769779930531 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.351959707081163531 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 2.703919414162327062*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.703919414162327062 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 2.703919414162327062*_Complex_I,
        0 + 0*_Complex_I,
        0 + 5.407838828324654124*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.351959707081163531 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.703919414162327062 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.193137101011594790 + 0*_Complex_I,
        0 - 0.193137101011594790*_Complex_I,
        0 + 0*_Complex_I,
        0.386274202023189580 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.317645212139137482 + 0*_Complex_I,
        0 - 0.386274202023189580*_Complex_I,
        0 + 0*_Complex_I,
        0 + 2.317645212139137482*_Complex_I,
        0 + 0*_Complex_I,
        0.193137101011594790 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.317645212139137482 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.545096808092758321 + 0*_Complex_I,
        0 - 0.193137101011594790*_Complex_I,
        0 + 0*_Complex_I,
        0 + 2.317645212139137482*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.545096808092758321*_Complex_I,
        0 + 0*_Complex_I,
       -0.236543673939390004 + 0*_Complex_I,
        0 + 0.236543673939390004*_Complex_I,
        0 + 0*_Complex_I,
       -0.473087347878780009 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.838524087272680054 + 0*_Complex_I,
        0 + 0.473087347878780009*_Complex_I,
        0 + 0*_Complex_I,
        0 - 2.838524087272680054*_Complex_I,
        0 + 0*_Complex_I,
       -0.236543673939390004 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.838524087272680054 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.892349391515120036 + 0*_Complex_I,
        0 + 0.236543673939390004*_Complex_I,
        0 + 0*_Complex_I,
        0 - 2.838524087272680054*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.892349391515120036*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.182718369696950022 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.365436739393900045 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -3.153915652525200060 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.182718369696950022 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -3.153915652525200060 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.630783130505040012 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.182718369696950022 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.365436739393900045 + 0*_Complex_I,
        0 + 0*_Complex_I,
        3.153915652525200060 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.182718369696950022 + 0*_Complex_I,
        0 + 0*_Complex_I,
        3.153915652525200060 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.630783130505040012 + 0*_Complex_I,
       -0.236543673939390004 + 0*_Complex_I,
        0 - 0.236543673939390004*_Complex_I,
        0 + 0*_Complex_I,
       -0.473087347878780009 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.838524087272680054 + 0*_Complex_I,
        0 - 0.473087347878780009*_Complex_I,
        0 + 0*_Complex_I,
        0 + 2.838524087272680054*_Complex_I,
        0 + 0*_Complex_I,
       -0.236543673939390004 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.838524087272680054 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.892349391515120036 + 0*_Complex_I,
        0 - 0.236543673939390004*_Complex_I,
        0 + 0*_Complex_I,
        0 + 2.838524087272680054*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.892349391515120036*_Complex_I,
        0 + 0*_Complex_I,
        0.193137101011594790 + 0*_Complex_I,
        0 + 0.193137101011594790*_Complex_I,
        0 + 0*_Complex_I,
        0.386274202023189580 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.317645212139137482 + 0*_Complex_I,
        0 + 0.386274202023189580*_Complex_I,
        0 + 0*_Complex_I,
        0 - 2.317645212139137482*_Complex_I,
        0 + 0*_Complex_I,
        0.193137101011594790 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.317645212139137482 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.545096808092758321 + 0*_Complex_I,
        0 + 0.193137101011594790*_Complex_I,
        0 + 0*_Complex_I,
        0 - 2.317645212139137482*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.545096808092758321*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.351959707081163531 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 2.703919414162327062*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.703919414162327062 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 2.703919414162327062*_Complex_I,
        0 + 0*_Complex_I,
        0 + 5.407838828324654124*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.351959707081163531 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.703919414162327062 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.885065384889965265 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.770130769779930531*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.770130769779930531 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.770130769779930531*_Complex_I,
        0 + 0*_Complex_I,
        0 - 3.540261539559861062*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.885065384889965265 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.770130769779930531 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.295021794963321755 + 0*_Complex_I,
        0 + 0.885065384889965265*_Complex_I,
        0 + 0*_Complex_I,
       -0.590043589926643510 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.360174359706574041 + 0*_Complex_I,
        0 + 0.590043589926643510*_Complex_I,
        0 + 0*_Complex_I,
        0 - 7.080523079119722124*_Complex_I,
        0 + 0*_Complex_I,
       -0.885065384889965265 + 0*_Complex_I,
        0 + 0*_Complex_I,
        7.080523079119722124 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.295021794963321755*_Complex_I,
        0 + 0*_Complex_I,
        0 + 2.360174359706574041*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.147510897481660877 + 0*_Complex_I,
        0 - 0.442532692444982632*_Complex_I,
        0 + 0*_Complex_I,
        0.295021794963321755 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.180087179853287020 + 0*_Complex_I,
        0 - 0.295021794963321755*_Complex_I,
        0 + 0*_Complex_I,
        0 + 3.540261539559861062*_Complex_I,
        0 + 0*_Complex_I,
        0.442532692444982632 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -3.540261539559861062 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0.147510897481660877*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.180087179853287020*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.327598077334947898 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 5.310392309339791593*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -7.965588464009687389 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 5.310392309339791593*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.327598077334947898 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.442532692444982632 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.770130769779930531*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.655196154669895796 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.770130769779930531*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.442532692444982632 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.442532692444982632 + 0*_Complex_I,
        0 - 2.212663462224913163*_Complex_I,
        0 + 0*_Complex_I,
        4.425326924449826327 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 4.425326924449826327*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.212663462224913163 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.442532692444982632*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.464132203440858160 + 0*_Complex_I,
        0 - 2.320661017204290803*_Complex_I,
        0 + 0*_Complex_I,
       -4.641322034408581606 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 4.641322034408581606*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.320661017204290803 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.464132203440858160*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.139941124721293271 + 0*_Complex_I,
        0 - 0.699705623606466358*_Complex_I,
        0 + 0*_Complex_I,
       -1.399411247212932717 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.399411247212932717*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.699705623606466358 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.139941124721293271*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.399411247212932717 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 5.597644988851730871*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -8.396467483277596306 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 5.597644988851730871*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.399411247212932717 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.625835735449176134 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 2.503342941796704538*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -3.755014412695056807 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 2.503342941796704538*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.625835735449176134 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.312917867724588067 + 0*_Complex_I,
        0 + 0.938753603173764201*_Complex_I,
        0 + 0*_Complex_I,
        0.625835735449176134 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.503342941796704538 + 0*_Complex_I,
        0 + 0.625835735449176134*_Complex_I,
        0 + 0*_Complex_I,
        0 - 7.510028825390113615*_Complex_I,
        0 + 0*_Complex_I,
        0.938753603173764201 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -7.510028825390113615 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.312917867724588067*_Complex_I,
        0 + 0*_Complex_I,
        0 + 2.503342941796704538*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.180663215165034628 + 0*_Complex_I,
        0 + 0.541989645495103885*_Complex_I,
        0 + 0*_Complex_I,
        0.361326430330069256 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.445305721320277027 + 0*_Complex_I,
        0 + 0.361326430330069256*_Complex_I,
        0 + 0*_Complex_I,
        0 - 4.335917163960831083*_Complex_I,
        0 + 0*_Complex_I,
        0.541989645495103885 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -4.335917163960831083 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.180663215165034628*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.445305721320277027*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.445305721320277027 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 2.890611442640554055*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.890611442640554055 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 2.890611442640554055*_Complex_I,
        0 + 0*_Complex_I,
        0 - 5.781222885281108110*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.445305721320277027 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.890611442640554055 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.021985476433282363 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 2.043970952866564726*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.043970952866564726 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 2.043970952866564726*_Complex_I,
        0 + 0*_Complex_I,
        0 - 4.087941905733129453*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.021985476433282363 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.043970952866564726 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.255496369108320590 + 0*_Complex_I,
        0 - 0.255496369108320590*_Complex_I,
        0 + 0*_Complex_I,
        0.510992738216641181 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -3.065956429299847090 + 0*_Complex_I,
        0 - 0.510992738216641181*_Complex_I,
        0 + 0*_Complex_I,
        0 + 3.065956429299847090*_Complex_I,
        0 + 0*_Complex_I,
        0.255496369108320590 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -3.065956429299847090 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.043970952866564726 + 0*_Complex_I,
        0 - 0.255496369108320590*_Complex_I,
        0 + 0*_Complex_I,
        0 + 3.065956429299847090*_Complex_I,
        0 + 0*_Complex_I,
        0 - 2.043970952866564726*_Complex_I,
        0 + 0*_Complex_I,
        0.215933843419584674 + 0*_Complex_I,
        0 - 0.215933843419584674*_Complex_I,
        0 + 0*_Complex_I,
        0.431867686839169349 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.591206121035016094 + 0*_Complex_I,
        0 - 0.431867686839169349*_Complex_I,
        0 + 0*_Complex_I,
        0 + 2.591206121035016094*_Complex_I,
        0 + 0*_Complex_I,
        0.215933843419584674 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.591206121035016094 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.727470747356677396 + 0*_Complex_I,
        0 - 0.215933843419584674*_Complex_I,
        0 + 0*_Complex_I,
        0 + 2.591206121035016094*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.727470747356677396*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.295603060517508047 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.591206121035016094 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -3.454941494713354792 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.295603060517508047 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -3.454941494713354792 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.690988298942670958 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.295603060517508047 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.591206121035016094 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -3.454941494713354792 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.295603060517508047 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -3.454941494713354792 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.690988298942670958 + 0*_Complex_I,
       -0.215933843419584674 + 0*_Complex_I,
        0 - 0.215933843419584674*_Complex_I,
        0 + 0*_Complex_I,
       -0.431867686839169349 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.591206121035016094 + 0*_Complex_I,
        0 - 0.431867686839169349*_Complex_I,
        0 + 0*_Complex_I,
        0 + 2.591206121035016094*_Complex_I,
        0 + 0*_Complex_I,
       -0.215933843419584674 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.591206121035016094 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.727470747356677396 + 0*_Complex_I,
        0 - 0.215933843419584674*_Complex_I,
        0 + 0*_Complex_I,
        0 + 2.591206121035016094*_Complex_I,
        0 + 0*_Complex_I,
        0 - 1.727470747356677396*_Complex_I,
        0 + 0*_Complex_I,
       -0.255496369108320590 + 0*_Complex_I,
        0 - 0.255496369108320590*_Complex_I,
        0 + 0*_Complex_I,
       -0.510992738216641181 + 0*_Complex_I,
        0 + 0*_Complex_I,
        3.065956429299847090 + 0*_Complex_I,
        0 - 0.510992738216641181*_Complex_I,
        0 + 0*_Complex_I,
        0 + 3.065956429299847090*_Complex_I,
        0 + 0*_Complex_I,
       -0.255496369108320590 + 0*_Complex_I,
        0 + 0*_Complex_I,
        3.065956429299847090 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.043970952866564726 + 0*_Complex_I,
        0 - 0.255496369108320590*_Complex_I,
        0 + 0*_Complex_I,
        0 + 3.065956429299847090*_Complex_I,
        0 + 0*_Complex_I,
        0 - 2.043970952866564726*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.021985476433282363 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 2.043970952866564726*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.043970952866564726 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 2.043970952866564726*_Complex_I,
        0 + 0*_Complex_I,
        0 + 4.087941905733129453*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.021985476433282363 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.043970952866564726 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.445305721320277027 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 2.890611442640554055*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        2.890611442640554055 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 2.890611442640554055*_Complex_I,
        0 + 0*_Complex_I,
        0 + 5.781222885281108110*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.445305721320277027 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.890611442640554055 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.180663215165034628 + 0*_Complex_I,
        0 + 0.541989645495103885*_Complex_I,
        0 + 0*_Complex_I,
       -0.361326430330069256 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -1.445305721320277027 + 0*_Complex_I,
        0 + 0.361326430330069256*_Complex_I,
        0 + 0*_Complex_I,
        0 - 4.335917163960831083*_Complex_I,
        0 + 0*_Complex_I,
       -0.541989645495103885 + 0*_Complex_I,
        0 + 0*_Complex_I,
        4.335917163960831083 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.180663215165034628*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.445305721320277027*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.312917867724588067 + 0*_Complex_I,
        0 + 0.938753603173764201*_Complex_I,
        0 + 0*_Complex_I,
       -0.625835735449176134 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.503342941796704538 + 0*_Complex_I,
        0 + 0.625835735449176134*_Complex_I,
        0 + 0*_Complex_I,
        0 - 7.510028825390113615*_Complex_I,
        0 + 0*_Complex_I,
       -0.938753603173764201 + 0*_Complex_I,
        0 + 0*_Complex_I,
        7.510028825390113615 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.312917867724588067*_Complex_I,
        0 + 0*_Complex_I,
        0 + 2.503342941796704538*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.625835735449176134 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 2.503342941796704538*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -3.755014412695056807 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 2.503342941796704538*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0.625835735449176134 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.399411247212932717 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 5.597644988851730871*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -8.396467483277596306 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 5.597644988851730871*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        1.399411247212932717 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.139941124721293271 + 0*_Complex_I,
        0 - 0.699705623606466358*_Complex_I,
        0 + 0*_Complex_I,
        1.399411247212932717 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 1.399411247212932717*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.699705623606466358 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.139941124721293271*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -0.464132203440858160 + 0*_Complex_I,
        0 - 2.320661017204290803*_Complex_I,
        0 + 0*_Complex_I,
        4.641322034408581606 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 4.641322034408581606*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
       -2.320661017204290803 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 - 0.464132203440858160*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        0 + 0*_Complex_I,
        -0.4641322034408583, 2.7847932206451498*_Complex_I, 0, 6.9619830516128740, 0, 0, -9.2826440688171665*_Complex_I, 0, 0, 0, -6.9619830516128740, 0, 0, 0, 0, 2.7847932206451498*_Complex_I, 0, 0, 0, 0, 0, 0.4641322034408583, 0, 0, 0, 0, 0, 0,
        0, 0, 0.4641322034408583, 0, -2.3206610172042916*_Complex_I, 0, 0, -4.6413220344085833, 0, 0, 0, 4.6413220344085833*_Complex_I, 0, 0, 0, 0, 2.3206610172042916, 0, 0, 0, 0, 0, -0.4641322034408583*_Complex_I, 0, 0, 0, 0, 0,
        //i11/2,-9/2
        0, 0, -1.5393523719342264, 0, 7.6967618596711320*_Complex_I, 0, 0, 15.3935237193422640, 0, 0, 0, -15.3935237193422640*_Complex_I, 0, 0, 0, 0, -7.6967618596711320, 0, 0, 0, 0, 0, 1.5393523719342264*_Complex_I, 0, 0, 0, 0, 0,
        -0.1399411247212932, 0.5597644988851730*_Complex_I, 0, 0.6997056236064662, 0, 1.3994112472129330, 0, 0, -5.5976449888517319*_Complex_I, 0, 0.6997056236064662, 0, -8.3964674832775970, 0, 0, -0.5597644988851730*_Complex_I, 0, 5.5976449888517319*_Complex_I, 0, 0, 0, -0.1399411247212932, 0, 1.3994112472129330, 0, 0, 0, 0,
        //i11/2,-7/2
        0.3129178677245880, -1.2516714708983521*_Complex_I, 0, -1.5645893386229399, 0, -3.1291786772458812, 0, 0, 12.5167147089835247*_Complex_I, 0, -1.5645893386229399, 0, 18.7750720634752852, 0, 0, 1.2516714708983521*_Complex_I, 0, -12.5167147089835247*_Complex_I, 0, 0, 0, 0.3129178677245880, 0, -3.1291786772458812, 0, 0, 0, 0,
        0, 0, -0.9387536031737643, 0, 2.8162608095212929*_Complex_I, 0, 0, 1.8775072063475287, 0, 2.5033429417967050, 0, 1.8775072063475287*_Complex_I, 0, -7.5100288253901146*_Complex_I, 0, 0, 2.8162608095212929, 0, -7.5100288253901146, 0, 0, 0, -0.9387536031737643*_Complex_I, 0, 2.5033429417967050*_Complex_I, 0, 0, 0,
        //i11/2,-5/2
        0, 0, 1.6259689364853118, 0, -4.8779068094559346*_Complex_I, 0, 0, -3.2519378729706236, 0, -4.3359171639608318, 0, -3.2519378729706236*_Complex_I, 0, 13.0077514918824946*_Complex_I, 0, 0, -4.8779068094559346, 0, 13.0077514918824946, 0, 0, 0, 1.6259689364853118*_Complex_I, 0, -4.3359171639608318*_Complex_I, 0, 0, 0,
        0.1806632151650347, -0.3613264303300693*_Complex_I, 0, 0.1806632151650347, 0, -2.8906114426405547, -0.7226528606601387*_Complex_I, 0, 5.7812228852811094*_Complex_I, 0, -0.1806632151650347, 0, 0, 0, 2.8906114426405547, -0.3613264303300693*_Complex_I, 0, 5.7812228852811094*_Complex_I, 0, -5.7812228852811094*_Complex_I, 0, -0.1806632151650347, 0, 2.8906114426405547, 0, -2.8906114426405547, 0, 0,
        //i11/2,-3/2
        -0.2554963691083206, 0.5109927382166413*_Complex_I, 0, -0.2554963691083206, 0, 4.0879419057331301, 1.0219854764332825*_Complex_I, 0, -8.1758838114662602*_Complex_I, 0, 0.2554963691083206, 0, 0, 0, -4.0879419057331301, 0.5109927382166413*_Complex_I, 0, -8.1758838114662602*_Complex_I, 0, 8.1758838114662602*_Complex_I, 0, 0.2554963691083206, 0, -4.0879419057331301, 0, 4.0879419057331301, 0, 0,
        0, 0, 1.2774818455416030, 0, -1.2774818455416030*_Complex_I, 0, 0, 2.5549636910832061, 0, -5.1099273821664122, 0, -2.5549636910832061*_Complex_I, 0, 5.1099273821664122*_Complex_I, 0, 0, 1.2774818455416030, 0, -5.1099273821664122, 0, 2.0439709528665646, 0, -1.2774818455416030*_Complex_I, 0, 5.1099273821664122*_Complex_I, 0, -2.0439709528665646*_Complex_I, 0,
        //i11/2,-1/2
        0, 0, -1.5115369039370925, 0, 1.5115369039370925*_Complex_I, 0, 0, -3.0230738078741850, 0, 6.0461476157483700, 0, 3.0230738078741850*_Complex_I, 0, -6.0461476157483700*_Complex_I, 0, 0, -1.5115369039370925, 0, 6.0461476157483700, 0, -2.4184590462993478, 0, 1.5115369039370925*_Complex_I, 0, -6.0461476157483700*_Complex_I, 0, 2.4184590462993478*_Complex_I, 0,
        -0.2159338434195847, 0, 0, -0.6478015302587540, 0, 3.8868091815525241, 0, 0, 0, 0, -0.6478015302587540, 0, 7.7736183631050482, 0, -5.1824122420700318, 0, 0, 0, 0, 0, 0, -0.2159338434195847, 0, 3.8868091815525241, 0, -5.1824122420700318, 0, 0.6909882989426709,
        //i11/2,1/2
        0.2159338434195847, 0, 0, 0.6478015302587540, 0, -3.8868091815525241, 0, 0, 0, 0, 0.6478015302587540, 0, -7.7736183631050482, 0, 5.1824122420700318, 0, 0, 0, 0, 0, 0, 0.2159338434195847, 0, -3.8868091815525241, 0, 5.1824122420700318, 0, -0.6909882989426709,
        0, 0, -1.5115369039370925, 0, -1.5115369039370925*_Complex_I, 0, 0, -3.0230738078741850, 0, 6.0461476157483700, 0, -3.0230738078741850*_Complex_I, 0, 6.0461476157483700*_Complex_I, 0, 0, -1.5115369039370925, 0, 6.0461476157483700, 0, -2.4184590462993478, 0, -1.5115369039370925*_Complex_I, 0, 6.0461476157483700*_Complex_I, 0, -2.4184590462993478*_Complex_I, 0,
        //i11/2,3/2
        0, 0, 1.2774818455416030, 0, 1.2774818455416030*_Complex_I, 0, 0, 2.5549636910832061, 0, -5.1099273821664122, 0, 2.5549636910832061*_Complex_I, 0, -5.1099273821664122*_Complex_I, 0, 0, 1.2774818455416030, 0, -5.1099273821664122, 0, 2.0439709528665646, 0, 1.2774818455416030*_Complex_I, 0, -5.1099273821664122*_Complex_I, 0, 2.0439709528665646*_Complex_I, 0,
        0.2554963691083206, 0.5109927382166413*_Complex_I, 0, 0.2554963691083206, 0, -4.0879419057331301, 1.0219854764332825*_Complex_I, 0, -8.1758838114662602*_Complex_I, 0, -0.2554963691083206, 0, 0, 0, 4.0879419057331301, 0.5109927382166413*_Complex_I, 0, -8.1758838114662602*_Complex_I, 0, 8.1758838114662602*_Complex_I, 0, -0.2554963691083206, 0, 4.0879419057331301, 0, -4.0879419057331301, 0, 0,
        //i11/2,5/2
        -0.1806632151650347, -0.3613264303300693*_Complex_I, 0, -0.1806632151650347, 0, 2.8906114426405547, -0.7226528606601387*_Complex_I, 0, 5.7812228852811094*_Complex_I, 0, 0.1806632151650347, 0, 0, 0, -2.8906114426405547, -0.3613264303300693*_Complex_I, 0, 5.7812228852811094*_Complex_I, 0, -5.7812228852811094*_Complex_I, 0, 0.1806632151650347, 0, -2.8906114426405547, 0, 2.8906114426405547, 0, 0,
        0, 0, 1.6259689364853118, 0, 4.8779068094559346*_Complex_I, 0, 0, -3.2519378729706236, 0, -4.3359171639608318, 0, 3.2519378729706236*_Complex_I, 0, -13.0077514918824946*_Complex_I, 0, 0, -4.8779068094559346, 0, 13.0077514918824946, 0, 0, 0, -1.6259689364853118*_Complex_I, 0, 4.3359171639608318*_Complex_I, 0, 0, 0,
        //i11/2,7/2
        0, 0, -0.9387536031737643, 0, -2.8162608095212929*_Complex_I, 0, 0, 1.8775072063475287, 0, 2.5033429417967050, 0, -1.8775072063475287*_Complex_I, 0, 7.5100288253901146*_Complex_I, 0, 0, 2.8162608095212929, 0, -7.5100288253901146, 0, 0, 0, 0.9387536031737643*_Complex_I, 0, -2.5033429417967050*_Complex_I, 0, 0, 0,
        -0.3129178677245880, -1.2516714708983521*_Complex_I, 0, 1.5645893386229399, 0, 3.1291786772458812, 0, 0, 12.5167147089835247*_Complex_I, 0, 1.5645893386229399, 0, -18.7750720634752852, 0, 0, 1.2516714708983521*_Complex_I, 0, -12.5167147089835247*_Complex_I, 0, 0, 0, -0.3129178677245880, 0, 3.1291786772458812, 0, 0, 0, 0,
        //i11/2,9/2
        0.1399411247212932, 0.5597644988851730*_Complex_I, 0, -0.6997056236064662, 0, -1.3994112472129330, 0, 0, -5.5976449888517319*_Complex_I, 0, -0.6997056236064662, 0, 8.3964674832775970, 0, 0, -0.5597644988851730*_Complex_I, 0, 5.5976449888517319*_Complex_I, 0, 0, 0, 0.1399411247212932, 0, -1.3994112472129330, 0, 0, 0, 0,
        0, 0, -1.5393523719342264, 0, -7.6967618596711320*_Complex_I, 0, 0, 15.3935237193422640, 0, 0, 0, 15.3935237193422640*_Complex_I, 0, 0, 0, 0, -7.6967618596711320, 0, 0, 0, 0, 0, -1.5393523719342264*_Complex_I, 0, 0, 0, 0, 0,
        //i11/2,11/2
        0, 0, 0.4641322034408583, 0, 2.3206610172042916*_Complex_I, 0, 0, -4.6413220344085833, 0, 0, 0, -4.6413220344085833*_Complex_I, 0, 0, 0, 0, 2.3206610172042916, 0, 0, 0, 0, 0, 0.4641322034408583*_Complex_I, 0, 0, 0, 0, 0,
        0.4641322034408583, 2.7847932206451498*_Complex_I, 0, -6.9619830516128740, 0, 0, -9.2826440688171665*_Complex_I, 0, 0, 0, 6.9619830516128740, 0, 0, 0, 0, 2.7847932206451498*_Complex_I, 0, 0, 0, 0, 0, -0.4641322034408583, 0, 0, 0, 0, 0, 0,
        //i13/2,-13/2
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0.4830841135800663, -2.8985046814803979*_Complex_I, 0, -7.2462617037009949, 0, 0, 9.6616822716013271*_Complex_I, 0, 0, 0, 7.2462617037009949, 0, 0, 0, 0, -2.8985046814803979*_Complex_I, 0, 0, 0, 0, 0, -0.4830841135800663, 0, 0, 0, 0, 0, 0,
        //i13/2,-11/2
        0.1339834262980768, -0.8039005577884609*_Complex_I, 0, -2.0097513944711523, 0, 0, 2.6796685259615369*_Complex_I, 0, 0, 0, 2.0097513944711523, 0, 0, 0, 0, -0.8039005577884609*_Complex_I, 0, 0, 0, 0, 0, -0.1339834262980768, 0, 0, 0, 0, 0, 0,
        0, 0, 1.6078011155769223, 0, -8.0390055778846108*_Complex_I, 0, 0, -16.0780111557692216, 0, 0, 0, 16.0780111557692216*_Complex_I, 0, 0, 0, 0, 8.0390055778846108, 0, 0, 0, 0, 0, -1.6078011155769223*_Complex_I, 0, 0, 0, 0, 0,
        //i13/2,-9/2
        0, 0, 0.6563820568401703, 0, -3.2819102842008516*_Complex_I, 0, 0, -6.5638205684017032, 0, 0, 0, 6.5638205684017032*_Complex_I, 0, 0, 0, 0, 3.2819102842008516, 0, 0, 0, 0, 0, -0.6563820568401703*_Complex_I, 0, 0, 0, 0, 0,
        -0.3281910284200850, 1.3127641136803401*_Complex_I, 0, 1.6409551421004249, 0, 3.2819102842008507, 0, 0, -13.1276411368034029*_Complex_I, 0, 1.6409551421004249, 0, -19.6914617052051035, 0, 0, -1.3127641136803401*_Complex_I, 0, 13.1276411368034029*_Complex_I, 0, 0, 0, -0.3281910284200850, 0, 3.2819102842008507, 0, 0, 0, 0,
        //i13/2,-7/2
        -0.1713921747991747, 0.6855686991966986*_Complex_I, 0, 0.8569608739958732, 0, 1.7139217479917468, 0, 0, -6.8556869919669872*_Complex_I, 0, 0.8569608739958732, 0, -10.2835304879504807, 0, 0, -0.6855686991966986*_Complex_I, 0, 6.8556869919669872*_Complex_I, 0, 0, 0, -0.1713921747991747, 0, 1.7139217479917468, 0, 0, 0, 0,
        0, 0, -1.7139217479917466, 0, 5.1417652439752395*_Complex_I, 0, 0, 3.4278434959834931, 0, 4.5704579946446584, 0, 3.4278434959834931*_Complex_I, 0, -13.7113739839339726*_Complex_I, 0, 0, 5.1417652439752395, 0, -13.7113739839339726, 0, 0, 0, -1.7139217479917466*_Complex_I, 0, 4.5704579946446584*_Complex_I, 0, 0, 0,
        //i13/2,-5/2
        0, 0, -1.0839792909902080, 0, 3.2519378729706232*_Complex_I, 0, 0, 2.1679585819804159, 0, 2.8906114426405547, 0, 2.1679585819804159*_Complex_I, 0, -8.6718343279216636*_Complex_I, 0, 0, 3.2519378729706232, 0, -8.6718343279216636, 0, 0, 0, -1.0839792909902080*_Complex_I, 0, 2.8906114426405547*_Complex_I, 0, 0, 0,
        0.2709948227475520, -0.5419896454951040*_Complex_I, 0, 0.2709948227475520, 0, -4.3359171639608318, -1.0839792909902080*_Complex_I, 0, 8.6718343279216636*_Complex_I, 0, -0.2709948227475520, 0, 0, 0, 4.3359171639608318, -0.5419896454951040*_Complex_I, 0, 8.6718343279216636*_Complex_I, 0, -8.6718343279216636*_Complex_I, 0, -0.2709948227475520, 0, 4.3359171639608318, 0, -4.3359171639608318, 0, 0,
        //i13/2,-3/2
        0.2019876150713442, -0.4039752301426884*_Complex_I, 0, 0.2019876150713442, 0, -3.2318018411415070, -0.8079504602853768*_Complex_I, 0, 6.4636036822830141*_Complex_I, 0, -0.2019876150713442, 0, 0, 0, 3.2318018411415070, -0.4039752301426884*_Complex_I, 0, 6.4636036822830141*_Complex_I, 0, -6.4636036822830141*_Complex_I, 0, -0.2019876150713442, 0, 3.2318018411415070, 0, -3.2318018411415070, 0, 0,
        0, 0, 1.6159009205707533, 0, -1.6159009205707533*_Complex_I, 0, 0, 3.2318018411415066, 0, -6.4636036822830132, 0, -3.2318018411415066*_Complex_I, 0, 6.4636036822830132*_Complex_I, 0, 0, 1.6159009205707533, 0, -6.4636036822830132, 0, 2.5854414729132049, 0, -1.6159009205707533*_Complex_I, 0, 6.4636036822830132*_Complex_I, 0, -2.5854414729132049*_Complex_I, 0,
        //i13/2,-1/2
        0, 0, 1.3994112472129328, 0, -1.3994112472129328*_Complex_I, 0, 0, 2.7988224944258655, 0, -5.5976449888517310, 0, -2.7988224944258655*_Complex_I, 0, 5.5976449888517310*_Complex_I, 0, 0, 1.3994112472129328, 0, -5.5976449888517310, 0, 2.2390579955406920, 0, -1.3994112472129328*_Complex_I, 0, 5.5976449888517310*_Complex_I, 0, -2.2390579955406920*_Complex_I, 0,
        -0.2332352078688221, 0, 0, -0.6997056236064663, 0, 4.1982337416387976, 0, 0, 0, 0, -0.6997056236064663, 0, 8.3964674832775952, 0, -5.5976449888517301, 0, 0, 0, 0, 0, 0, -0.2332352078688221, 0, 4.1982337416387976, 0, -5.5976449888517301, 0, 0.7463526651802307,
        //i13/2,1/2
        -0.2332352078688221, 0, 0, -0.6997056236064663, 0, 4.1982337416387976, 0, 0, 0, 0, -0.6997056236064663, 0, 8.3964674832775952, 0, -5.5976449888517301, 0, 0, 0, 0, 0, 0, -0.2332352078688221, 0, 4.1982337416387976, 0, -5.5976449888517301, 0, 0.7463526651802307,
        0, 0, -1.3994112472129328, 0, -1.3994112472129328*_Complex_I, 0, 0, -2.7988224944258655, 0, 5.5976449888517310, 0, -2.7988224944258655*_Complex_I, 0, 5.5976449888517310*_Complex_I, 0, 0, -1.3994112472129328, 0, 5.5976449888517310, 0, -2.2390579955406920, 0, -1.3994112472129328*_Complex_I, 0, 5.5976449888517310*_Complex_I, 0, -2.2390579955406920*_Complex_I, 0,
        //i13/2,3/2
        0, 0, -1.6159009205707533, 0, -1.6159009205707533*_Complex_I, 0, 0, -3.2318018411415066, 0, 6.4636036822830132, 0, -3.2318018411415066*_Complex_I, 0, 6.4636036822830132*_Complex_I, 0, 0, -1.6159009205707533, 0, 6.4636036822830132, 0, -2.5854414729132049, 0, -1.6159009205707533*_Complex_I, 0, 6.4636036822830132*_Complex_I, 0, -2.5854414729132049*_Complex_I, 0,
        0.2019876150713442, 0.4039752301426884*_Complex_I, 0, 0.2019876150713442, 0, -3.2318018411415070, 0.8079504602853768*_Complex_I, 0, -6.4636036822830141*_Complex_I, 0, -0.2019876150713442, 0, 0, 0, 3.2318018411415070, 0.4039752301426884*_Complex_I, 0, -6.4636036822830141*_Complex_I, 0, 6.4636036822830141*_Complex_I, 0, -0.2019876150713442, 0, 3.2318018411415070, 0, -3.2318018411415070, 0, 0,
        //i13/2,5/2
        0.2709948227475520, 0.5419896454951040*_Complex_I, 0, 0.2709948227475520, 0, -4.3359171639608318, 1.0839792909902080*_Complex_I, 0, -8.6718343279216636*_Complex_I, 0, -0.2709948227475520, 0, 0, 0, 4.3359171639608318, 0.5419896454951040*_Complex_I, 0, -8.6718343279216636*_Complex_I, 0, 8.6718343279216636*_Complex_I, 0, -0.2709948227475520, 0, 4.3359171639608318, 0, -4.3359171639608318, 0, 0,
        0, 0, 1.0839792909902080, 0, 3.2519378729706232*_Complex_I, 0, 0, -2.1679585819804159, 0, -2.8906114426405547, 0, 2.1679585819804159*_Complex_I, 0, -8.6718343279216636*_Complex_I, 0, 0, -3.2519378729706232, 0, 8.6718343279216636, 0, 0, 0, -1.0839792909902080*_Complex_I, 0, 2.8906114426405547*_Complex_I, 0, 0, 0,
        //i13/2,7/2
        0, 0, 1.7139217479917466, 0, 5.1417652439752395*_Complex_I, 0, 0, -3.4278434959834931, 0, -4.5704579946446584, 0, 3.4278434959834931*_Complex_I, 0, -13.7113739839339726*_Complex_I, 0, 0, -5.1417652439752395, 0, 13.7113739839339726, 0, 0, 0, -1.7139217479917466*_Complex_I, 0, 4.5704579946446584*_Complex_I, 0, 0, 0,
        -0.1713921747991747, -0.6855686991966986*_Complex_I, 0, 0.8569608739958732, 0, 1.7139217479917468, 0, 0, 6.8556869919669872*_Complex_I, 0, 0.8569608739958732, 0, -10.2835304879504807, 0, 0, 0.6855686991966986*_Complex_I, 0, -6.8556869919669872*_Complex_I, 0, 0, 0, -0.1713921747991747, 0, 1.7139217479917468, 0, 0, 0, 0,
        //i13/2,9/2
        -0.3281910284200850, -1.3127641136803401*_Complex_I, 0, 1.6409551421004249, 0, 3.2819102842008507, 0, 0, 13.1276411368034029*_Complex_I, 0, 1.6409551421004249, 0, -19.6914617052051035, 0, 0, 1.3127641136803401*_Complex_I, 0, -13.1276411368034029*_Complex_I, 0, 0, 0, -0.3281910284200850, 0, 3.2819102842008507, 0, 0, 0, 0,
        0, 0, -0.6563820568401703, 0, -3.2819102842008516*_Complex_I, 0, 0, 6.5638205684017032, 0, 0, 0, 6.5638205684017032*_Complex_I, 0, 0, 0, 0, -3.2819102842008516, 0, 0, 0, 0, 0, -0.6563820568401703*_Complex_I, 0, 0, 0, 0, 0,
        //i13/2,11/2
        0, 0, -1.6078011155769223, 0, -8.0390055778846108*_Complex_I, 0, 0, 16.0780111557692216, 0, 0, 0, 16.0780111557692216*_Complex_I, 0, 0, 0, 0, -8.0390055778846108, 0, 0, 0, 0, 0, -1.6078011155769223*_Complex_I, 0, 0, 0, 0, 0,
        0.1339834262980768, 0.8039005577884609*_Complex_I, 0, -2.0097513944711523, 0, 0, -2.6796685259615369*_Complex_I, 0, 0, 0, 2.0097513944711523, 0, 0, 0, 0, 0.8039005577884609*_Complex_I, 0, 0, 0, 0, 0, -0.1339834262980768, 0, 0, 0, 0, 0, 0,
        //i13/2,13/2
        0.4830841135800663, 2.8985046814803979*_Complex_I, 0, -7.2462617037009949, 0, 0, -9.6616822716013271*_Complex_I, 0, 0, 0, 7.2462617037009949, 0, 0, 0, 0, 2.8985046814803979*_Complex_I, 0, 0, 0, 0, 0, -0.4830841135800663, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        //j13/2,-13/2
        -0.4830841135800663, 3.3815887950604644*_Complex_I, 0, 10.1447663851813932, 0, 0, -16.9079439753023237*_Complex_I, 0, 0, 0, -16.9079439753023237, 0, 0, 0, 0, 10.1447663851813932*_Complex_I, 0, 0, 0, 0, 0, 3.3815887950604644, 0, 0, 0, 0, 0, 0, -0.4830841135800663*_Complex_I, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0.4830841135800661, 0, -2.8985046814803970*_Complex_I, 0, 0, -7.2462617037009922, 0, 0, 0, 9.6616822716013235*_Complex_I, 0, 0, 0, 0, 7.2462617037009922, 0, 0, 0, 0, 0, -2.8985046814803970*_Complex_I, 0, 0, 0, 0, 0, 0, -0.4830841135800661, 0, 0, 0, 0, 0, 0,
        //j13/2,-11/2
        0, 0, -1.7417845418749984, 0, 10.4507072512499910*_Complex_I, 0, 0, 26.1267681281249757, 0, 0, 0, -34.8356908374999676*_Complex_I, 0, 0, 0, 0, -26.1267681281249757, 0, 0, 0, 0, 0, 10.4507072512499910*_Complex_I, 0, 0, 0, 0, 0, 0, 1.7417845418749984, 0, 0, 0, 0, 0, 0,
        -0.1339834262980768, 0.6699171314903840*_Complex_I, 0, 1.2058508366826914, 0, 1.6078011155769216, -0.6699171314903840*_Complex_I, 0, -8.0390055778846072*_Complex_I, 0, 0.6699171314903840, 0, -16.0780111557692145, 0, 0, -1.2058508366826914*_Complex_I, 0, 16.0780111557692145*_Complex_I, 0, 0, 0, -0.6699171314903840, 0, 8.0390055778846072, 0, 0, 0, 0, 0.1339834262980768*_Complex_I, 0, -1.6078011155769216*_Complex_I, 0, 0, 0, 0, 0,
        //j13/2,-9/2
        0.3281910284200851, -1.6409551421004256*_Complex_I, 0, -2.9537192557807663, 0, -3.9382923410410213, 1.6409551421004256*_Complex_I, 0, 19.6914617052051071*_Complex_I, 0, -1.6409551421004256, 0, 39.3829234104102142, 0, 0, 2.9537192557807663*_Complex_I, 0, -39.3829234104102142*_Complex_I, 0, 0, 0, 1.6409551421004256, 0, -19.6914617052051071, 0, 0, 0, 0, -0.3281910284200851*_Complex_I, 0, 3.9382923410410213*_Complex_I, 0, 0, 0, 0, 0,
        0, 0, -0.9845730852602553, 0, 3.9382923410410213*_Complex_I, 0, 0, 4.9228654263012768, 0, 3.2819102842008512, 0, 0, 0, -13.1276411368034047*_Complex_I, 0, 0, 4.9228654263012768, 0, -19.6914617052051071, 0, 0, 0, -3.9382923410410213*_Complex_I, 0, 13.1276411368034047*_Complex_I, 0, 0, 0, 0, -0.9845730852602553, 0, 3.2819102842008512, 0, 0, 0, 0,
        //j13/2,-7/2
        0, 0, 1.8853139227909212, 0, -7.5412556911636850*_Complex_I, 0, 0, -9.4265696139546051, 0, -6.2843797426364043, 0, 0, 0, 25.1375189705456172*_Complex_I, 0, 0, -9.4265696139546051, 0, 37.7062784558184205, 0, 0, 0, 7.5412556911636850*_Complex_I, 0, -25.1375189705456172*_Complex_I, 0, 0, 0, 0, 1.8853139227909212, 0, -6.2843797426364043, 0, 0, 0, 0,
        0.1713921747991747, -0.5141765243975239*_Complex_I, 0, -0.1713921747991747, 0, -3.4278434959834923, -0.8569608739958733*_Complex_I, 0, 10.2835304879504772*_Complex_I, 0, -0.8569608739958733, 0, 6.8556869919669845, 0, 4.5704579946446575, -0.1713921747991747*_Complex_I, 0, 6.8556869919669845*_Complex_I, 0, -13.7113739839339726*_Complex_I, 0, -0.5141765243975239, 0, 10.2835304879504772, 0, -13.7113739839339726, 0, 0, 0.1713921747991747*_Complex_I, 0, -3.4278434959834923*_Complex_I, 0, 4.5704579946446575*_Complex_I, 0, 0, 0,
        //j13/2,-5/2
        -0.2709948227475520, 0.8129844682426559*_Complex_I, 0, 0.2709948227475520, 0, 5.4198964549510391, 1.3549741137377600*_Complex_I, 0, -16.2596893648531164*_Complex_I, 0, 1.3549741137377600, 0, -10.8397929099020782, 0, -7.2265286066013861, 0.2709948227475520*_Complex_I, 0, -10.8397929099020782*_Complex_I, 0, 21.6795858198041600*_Complex_I, 0, 0.8129844682426559, 0, -16.2596893648531164, 0, 21.6795858198041600, 0, 0, -0.2709948227475520*_Complex_I, 0, 5.4198964549510391*_Complex_I, 0, -7.2265286066013861*_Complex_I, 0, 0, 0,
        0, 0, 1.3549741137377600, 0, -2.7099482274755200*_Complex_I, 0, 0, 1.3549741137377600, 0, -7.2265286066013861, 0, -5.4198964549510400*_Complex_I, 0, 14.4530572132027721*_Complex_I, 0, 0, -1.3549741137377600, 0, 0, 0, 4.3359171639608327, 0, -2.7099482274755200*_Complex_I, 0, 14.4530572132027721*_Complex_I, 0, -8.6718343279216654*_Complex_I, 0, 0, -1.3549741137377600, 0, 7.2265286066013861, 0, -4.3359171639608327, 0, 0,
        //j13/2,-3/2
        0, 0, -1.8178885356420982, 0, 3.6357770712841964*_Complex_I, 0, 0, -1.8178885356420982, 0, 9.6954055234245224, 0, 7.2715541425683927*_Complex_I, 0, -19.3908110468490449*_Complex_I, 0, 0, 1.8178885356420982, 0, 0, 0, -5.8172433140547142, 0, 3.6357770712841964*_Complex_I, 0, -19.3908110468490449*_Complex_I, 0, 11.6344866281094284*_Complex_I, 0, 0, 1.8178885356420982, 0, -9.6954055234245224, 0, 5.8172433140547142, 0, 0,
        -0.2019876150713442, 0.2019876150713442*_Complex_I, 0, -0.6059628452140327, 0, 4.8477027617122603, 0.6059628452140327*_Complex_I, 0, -4.8477027617122603*_Complex_I, 0, -0.6059628452140327, 0, 9.6954055234245207, 0, -9.6954055234245207, 0.6059628452140327*_Complex_I, 0, -9.6954055234245207*_Complex_I, 0, 9.6954055234245207*_Complex_I, 0, -0.2019876150713442, 0, 4.8477027617122603, 0, -9.6954055234245207, 0, 2.5854414729132063, 0.2019876150713442*_Complex_I, 0, -4.8477027617122603*_Complex_I, 0, 9.6954055234245207*_Complex_I, 0, -2.5854414729132063*_Complex_I, 0,
        //j13/2,-1/2
        0.2332352078688221, -0.2332352078688221*_Complex_I, 0, 0.6997056236064664, 0, -5.5976449888517301, -0.6997056236064664*_Complex_I, 0, 5.5976449888517301*_Complex_I, 0, 0.6997056236064664, 0, -11.1952899777034602, 0, 11.1952899777034602, -0.6997056236064664*_Complex_I, 0, 11.1952899777034602*_Complex_I, 0, -11.1952899777034602*_Complex_I, 0, 0.2332352078688221, 0, -5.5976449888517301, 0, 11.1952899777034602, 0, -2.9854106607209236, -0.2332352078688221*_Complex_I, 0, 5.5976449888517301*_Complex_I, 0, -11.1952899777034602*_Complex_I, 0, 2.9854106607209236*_Complex_I, 0,
        0, 0, -1.6326464550817545, 0, 0, 0, 0, -4.8979393652452643, 0, 9.7958787304905268, 0, 0, 0, 0, 0, 0, -4.8979393652452643, 0, 19.5917574609810536, 0, -7.8367029843924216, 0, 0, 0, 0, 0, 0, 0, 0, -1.6326464550817545, 0, 9.7958787304905268, 0, -7.8367029843924216, 0, 0.7463526651802307,
        //j13/2,1/2
        0, 0, 1.6326464550817545, 0, 0, 0, 0, 4.8979393652452643, 0, -9.7958787304905268, 0, 0, 0, 0, 0, 0, 4.8979393652452643, 0, -19.5917574609810536, 0, 7.8367029843924216, 0, 0, 0, 0, 0, 0, 0, 0, 1.6326464550817545, 0, -9.7958787304905268, 0, 7.8367029843924216, 0, -0.7463526651802307,
        0.2332352078688221, 0.2332352078688221*_Complex_I, 0, 0.6997056236064664, 0, -5.5976449888517301, 0.6997056236064664*_Complex_I, 0, -5.5976449888517301*_Complex_I, 0, 0.6997056236064664, 0, -11.1952899777034602, 0, 11.1952899777034602, 0.6997056236064664*_Complex_I, 0, -11.1952899777034602*_Complex_I, 0, 11.1952899777034602*_Complex_I, 0, 0.2332352078688221, 0, -5.5976449888517301, 0, 11.1952899777034602, 0, -2.9854106607209236, 0.2332352078688221*_Complex_I, 0, -5.5976449888517301*_Complex_I, 0, 11.1952899777034602*_Complex_I, 0, -2.9854106607209236*_Complex_I, 0,
        //j13/2,3/2
        -0.2019876150713442, -0.2019876150713442*_Complex_I, 0, -0.6059628452140327, 0, 4.8477027617122603, -0.6059628452140327*_Complex_I, 0, 4.8477027617122603*_Complex_I, 0, -0.6059628452140327, 0, 9.6954055234245207, 0, -9.6954055234245207, -0.6059628452140327*_Complex_I, 0, 9.6954055234245207*_Complex_I, 0, -9.6954055234245207*_Complex_I, 0, -0.2019876150713442, 0, 4.8477027617122603, 0, -9.6954055234245207, 0, 2.5854414729132063, -0.2019876150713442*_Complex_I, 0, 4.8477027617122603*_Complex_I, 0, -9.6954055234245207*_Complex_I, 0, 2.5854414729132063*_Complex_I, 0,
        0, 0, 1.8178885356420982, 0, 3.6357770712841964*_Complex_I, 0, 0, 1.8178885356420982, 0, -9.6954055234245224, 0, 7.2715541425683927*_Complex_I, 0, -19.3908110468490449*_Complex_I, 0, 0, -1.8178885356420982, 0, 0, 0, 5.8172433140547142, 0, 3.6357770712841964*_Complex_I, 0, -19.3908110468490449*_Complex_I, 0, 11.6344866281094284*_Complex_I, 0, 0, -1.8178885356420982, 0, 9.6954055234245224, 0, -5.8172433140547142, 0, 0,
        //j13/2,5/2
        0, 0, -1.3549741137377600, 0, -2.7099482274755200*_Complex_I, 0, 0, -1.3549741137377600, 0, 7.2265286066013861, 0, -5.4198964549510400*_Complex_I, 0, 14.4530572132027721*_Complex_I, 0, 0, 1.3549741137377600, 0, 0, 0, -4.3359171639608327, 0, -2.7099482274755200*_Complex_I, 0, 14.4530572132027721*_Complex_I, 0, -8.6718343279216654*_Complex_I, 0, 0, 1.3549741137377600, 0, -7.2265286066013861, 0, 4.3359171639608327, 0, 0,
        -0.2709948227475520, -0.8129844682426559*_Complex_I, 0, 0.2709948227475520, 0, 5.4198964549510391, -1.3549741137377600*_Complex_I, 0, 16.2596893648531164*_Complex_I, 0, 1.3549741137377600, 0, -10.8397929099020782, 0, -7.2265286066013861, -0.2709948227475520*_Complex_I, 0, 10.8397929099020782*_Complex_I, 0, -21.6795858198041600*_Complex_I, 0, 0.8129844682426559, 0, -16.2596893648531164, 0, 21.6795858198041600, 0, 0, 0.2709948227475520*_Complex_I, 0, -5.4198964549510391*_Complex_I, 0, 7.2265286066013861*_Complex_I, 0, 0, 0,
        //j13/2,7/2
        0.1713921747991747, 0.5141765243975239*_Complex_I, 0, -0.1713921747991747, 0, -3.4278434959834923, 0.8569608739958733*_Complex_I, 0, -10.2835304879504772*_Complex_I, 0, -0.8569608739958733, 0, 6.8556869919669845, 0, 4.5704579946446575, 0.1713921747991747*_Complex_I, 0, -6.8556869919669845*_Complex_I, 0, 13.7113739839339726*_Complex_I, 0, -0.5141765243975239, 0, 10.2835304879504772, 0, -13.7113739839339726, 0, 0, -0.1713921747991747*_Complex_I, 0, 3.4278434959834923*_Complex_I, 0, -4.5704579946446575*_Complex_I, 0, 0, 0,
        0, 0, -1.8853139227909212, 0, -7.5412556911636850*_Complex_I, 0, 0, 9.4265696139546051, 0, 6.2843797426364043, 0, 0, 0, 25.1375189705456172*_Complex_I, 0, 0, 9.4265696139546051, 0, -37.7062784558184205, 0, 0, 0, 7.5412556911636850*_Complex_I, 0, -25.1375189705456172*_Complex_I, 0, 0, 0, 0, -1.8853139227909212, 0, 6.2843797426364043, 0, 0, 0, 0,
        //j13/2,9/2
        0, 0, 0.9845730852602553, 0, 3.9382923410410213*_Complex_I, 0, 0, -4.9228654263012768, 0, -3.2819102842008512, 0, 0, 0, -13.1276411368034047*_Complex_I, 0, 0, -4.9228654263012768, 0, 19.6914617052051071, 0, 0, 0, -3.9382923410410213*_Complex_I, 0, 13.1276411368034047*_Complex_I, 0, 0, 0, 0, 0.9845730852602553, 0, -3.2819102842008512, 0, 0, 0, 0,
        0.3281910284200851, 1.6409551421004256*_Complex_I, 0, -2.9537192557807663, 0, -3.9382923410410213, -1.6409551421004256*_Complex_I, 0, -19.6914617052051071*_Complex_I, 0, -1.6409551421004256, 0, 39.3829234104102142, 0, 0, -2.9537192557807663*_Complex_I, 0, 39.3829234104102142*_Complex_I, 0, 0, 0, 1.6409551421004256, 0, -19.6914617052051071, 0, 0, 0, 0, 0.3281910284200851*_Complex_I, 0, -3.9382923410410213*_Complex_I, 0, 0, 0, 0, 0,
        //j13/2,11/2
        -0.1339834262980768, -0.6699171314903840*_Complex_I, 0, 1.2058508366826914, 0, 1.6078011155769216, 0.6699171314903840*_Complex_I, 0, 8.0390055778846072*_Complex_I, 0, 0.6699171314903840, 0, -16.0780111557692145, 0, 0, 1.2058508366826914*_Complex_I, 0, -16.0780111557692145*_Complex_I, 0, 0, 0, -0.6699171314903840, 0, 8.0390055778846072, 0, 0, 0, 0, -0.1339834262980768*_Complex_I, 0, 1.6078011155769216*_Complex_I, 0, 0, 0, 0, 0,
        0, 0, 1.7417845418749984, 0, 10.4507072512499910*_Complex_I, 0, 0, -26.1267681281249757, 0, 0, 0, -34.8356908374999676*_Complex_I, 0, 0, 0, 0, 26.1267681281249757, 0, 0, 0, 0, 0, 10.4507072512499910*_Complex_I, 0, 0, 0, 0, 0, 0, -1.7417845418749984, 0, 0, 0, 0, 0, 0,
        //j13/2,13/2
        0, 0, -0.4830841135800661, 0, -2.8985046814803970*_Complex_I, 0, 0, 7.2462617037009922, 0, 0, 0, 9.6616822716013235*_Complex_I, 0, 0, 0, 0, -7.2462617037009922, 0, 0, 0, 0, 0, -2.8985046814803970*_Complex_I, 0, 0, 0, 0, 0, 0, 0.4830841135800661, 0, 0, 0, 0, 0, 0,
        -0.4830841135800663, -3.3815887950604644*_Complex_I, 0, 10.1447663851813932, 0, 0, 16.9079439753023237*_Complex_I, 0, 0, 0, -16.9079439753023237, 0, 0, 0, 0, -10.1447663851813932*_Complex_I, 0, 0, 0, 0, 0, 3.3815887950604644, 0, 0, 0, 0, 0, 0, 0.4830841135800663*_Complex_I, 0, 0, 0, 0, 0, 0, 0,
        //j15/2,-15/2
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0.5000395635705508, -3.5002769449938556*_Complex_I, 0, -10.5008308349815653, 0, 0, 17.5013847249692773*_Complex_I, 0, 0, 0, 17.5013847249692773, 0, 0, 0, 0, -10.5008308349815653*_Complex_I, 0, 0, 0, 0, 0, -3.5002769449938556, 0, 0, 0, 0, 0, 0, 0.5000395635705508*_Complex_I, 0, 0, 0, 0, 0, 0, 0,
        //j15/2,-13/2
        0.1291096601435712, -0.9037676210049984*_Complex_I, 0, -2.7113028630149949, 0, 0, 4.5188381050249919*_Complex_I, 0, 0, 0, 4.5188381050249919, 0, 0, 0, 0, -2.7113028630149949*_Complex_I, 0, 0, 0, 0, 0, -0.9037676210049984, 0, 0, 0, 0, 0, 0, 0.1291096601435712*_Complex_I, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 1.8075352420099966, 0, -10.8452114520599796*_Complex_I, 0, 0, -27.1130286301499481, 0, 0, 0, 36.1507048401999356*_Complex_I, 0, 0, 0, 0, 27.1130286301499481, 0, 0, 0, 0, 0, -10.8452114520599796*_Complex_I, 0, 0, 0, 0, 0, 0, -1.8075352420099966, 0, 0, 0, 0, 0, 0,
        //j15/2,-11/2
        0, 0, 0.6831841051919142, 0, -4.0991046311514854*_Complex_I, 0, 0, -10.2477615778787126, 0, 0, 0, 13.6636821038382852*_Complex_I, 0, 0, 0, 0, 10.2477615778787126, 0, 0, 0, 0, 0, -4.0991046311514854*_Complex_I, 0, 0, 0, 0, 0, 0, -0.6831841051919142, 0, 0, 0, 0, 0, 0,
        -0.3415920525959572, 1.7079602629797861*_Complex_I, 0, 3.0743284733636154, 0, 4.0991046311514863, -1.7079602629797861*_Complex_I, 0, -20.4955231557574322*_Complex_I, 0, 1.7079602629797861, 0, -40.9910463115148644, 0, 0, -3.0743284733636154*_Complex_I, 0, 40.9910463115148644*_Complex_I, 0, 0, 0, -1.7079602629797861, 0, 20.4955231557574322, 0, 0, 0, 0, 0.3415920525959572*_Complex_I, 0, -4.0991046311514863*_Complex_I, 0, 0, 0, 0, 0,
        //j15/2,-9/2
        -0.1640955142100426, 0.8204775710502128*_Complex_I, 0, 1.4768596278903832, 0, 1.9691461705205107, -0.8204775710502128*_Complex_I, 0, -9.8457308526025535*_Complex_I, 0, 0.8204775710502128, 0, -19.6914617052051071, 0, 0, -1.4768596278903832*_Complex_I, 0, 19.6914617052051071*_Complex_I, 0, 0, 0, -0.8204775710502128, 0, 9.8457308526025535, 0, 0, 0, 0, 0.1640955142100426*_Complex_I, 0, -1.9691461705205107*_Complex_I, 0, 0, 0, 0, 0,
        0, 0, -1.9691461705205107, 0, 7.8765846820820427*_Complex_I, 0, 0, 9.8457308526025535, 0, 6.5638205684017024, 0, 0, 0, -26.2552822736068094*_Complex_I, 0, 0, 9.8457308526025535, 0, -39.3829234104102142, 0, 0, 0, -7.8765846820820427*_Complex_I, 0, 26.2552822736068094*_Complex_I, 0, 0, 0, 0, -1.9691461705205107, 0, 6.5638205684017024, 0, 0, 0, 0,
        //j15/2,-7/2
        0, 0, -1.1368870716237374, 0, 4.5475482864949495*_Complex_I, 0, 0, 5.6844353581186864, 0, 3.7896235720791247, 0, 0, 0, -15.1584942883164988*_Complex_I, 0, 0, 5.6844353581186864, 0, -22.7377414324747456, 0, 0, 0, -4.5475482864949495*_Complex_I, 0, 15.1584942883164988*_Complex_I, 0, 0, 0, 0, -1.1368870716237374, 0, 3.7896235720791247, 0, 0, 0, 0,
        0.2842217679059343, -0.8526653037178029*_Complex_I, 0, -0.2842217679059343, 0, -5.6844353581186855, -1.4211088395296716*_Complex_I, 0, 17.0533060743560583*_Complex_I, 0, -1.4211088395296716, 0, 11.3688707162373710, 0, 7.5792471441582485, -0.2842217679059343*_Complex_I, 0, 11.3688707162373710*_Complex_I, 0, -22.7377414324747456*_Complex_I, 0, -0.8526653037178029, 0, 17.0533060743560583, 0, -22.7377414324747456, 0, 0, 0.2842217679059343*_Complex_I, 0, -5.6844353581186855*_Complex_I, 0, 7.5792471441582485*_Complex_I, 0, 0, 0,
        //j15/2,-5/2
        0.1916222768312404, -0.5748668304937213*_Complex_I, 0, -0.1916222768312404, 0, -3.8324455366248085, -0.9581113841562022*_Complex_I, 0, 11.4973366098744254*_Complex_I, 0, -0.9581113841562022, 0, 7.6648910732496169, 0, 5.1099273821664122, -0.1916222768312404*_Complex_I, 0, 7.6648910732496169*_Complex_I, 0, -15.3297821464992357*_Complex_I, 0, -0.5748668304937213, 0, 11.4973366098744254, 0, -15.3297821464992357, 0, 0, 0.1916222768312404*_Complex_I, 0, -3.8324455366248085*_Complex_I, 0, 5.1099273821664122*_Complex_I, 0, 0, 0,
        0, 0, 1.9162227683124053, 0, -3.8324455366248107*_Complex_I, 0, 0, 1.9162227683124053, 0, -10.2198547643328261, 0, -7.6648910732496214*_Complex_I, 0, 20.4397095286656523*_Complex_I, 0, 0, -1.9162227683124053, 0, 0, 0, 6.1319128585996969, 0, -3.8324455366248107*_Complex_I, 0, 20.4397095286656523*_Complex_I, 0, -12.2638257171993938*_Complex_I, 0, 0, -1.9162227683124053, 0, 10.2198547643328261, 0, -6.1319128585996969, 0, 0,
        //j15/2,-3/2
        0, 0, 1.4842997738594836, 0, -2.9685995477189673*_Complex_I, 0, 0, 1.4842997738594836, 0, -7.9162654605839124, 0, -5.9371990954379346*_Complex_I, 0, 15.8325309211678249*_Complex_I, 0, 0, -1.4842997738594836, 0, 0, 0, 4.7497592763503480, 0, -2.9685995477189673*_Complex_I, 0, 15.8325309211678249*_Complex_I, 0, -9.4995185527006960*_Complex_I, 0, 0, -1.4842997738594836, 0, 7.9162654605839124, 0, -4.7497592763503480, 0, 0,
        -0.2473832956432473, 0.2473832956432473*_Complex_I, 0, -0.7421498869297418, 0, 5.9371990954379337, 0.7421498869297418*_Complex_I, 0, -5.9371990954379337*_Complex_I, 0, -0.7421498869297418, 0, 11.8743981908758673, 0, -11.8743981908758673, 0.7421498869297418*_Complex_I, 0, -11.8743981908758673*_Complex_I, 0, 11.8743981908758673*_Complex_I, 0, -0.2473832956432473, 0, 5.9371990954379337, 0, -11.8743981908758673, 0, 3.1665061842335653, 0.2473832956432473*_Complex_I, 0, -5.9371990954379337*_Complex_I, 0, 11.8743981908758673*_Complex_I, 0, -3.1665061842335653*_Complex_I, 0,
        //j15/2,-1/2
        -0.2181715595945335, 0.2181715595945335*_Complex_I, 0, -0.6545146787836006, 0, 5.2361174302688038, 0.6545146787836006*_Complex_I, 0, -5.2361174302688038*_Complex_I, 0, -0.6545146787836006, 0, 10.4722348605376077, 0, -10.4722348605376077, 0.6545146787836006*_Complex_I, 0, -10.4722348605376077*_Complex_I, 0, 10.4722348605376077*_Complex_I, 0, -0.2181715595945335, 0, 5.2361174302688038, 0, -10.4722348605376077, 0, 2.7925959628100294, 0.2181715595945335*_Complex_I, 0, -5.2361174302688038*_Complex_I, 0, 10.4722348605376077*_Complex_I, 0, -2.7925959628100294*_Complex_I, 0,
        0, 0, -1.7453724767562677, 0, 0, 0, 0, -5.2361174302688038, 0, 10.4722348605376059, 0, 0, 0, 0, 0, 0, -5.2361174302688038, 0, 20.9444697210752118, 0, -8.3777878884300847, 0, 0, 0, 0, 0, 0, 0, 0, -1.7453724767562677, 0, 10.4722348605376059, 0, -8.3777878884300847, 0, 0.7978845608028652,
        //j15/2,1/2
        0, 0, -1.7453724767562677, 0, 0, 0, 0, -5.2361174302688038, 0, 10.4722348605376059, 0, 0, 0, 0, 0, 0, -5.2361174302688038, 0, 20.9444697210752118, 0, -8.3777878884300847, 0, 0, 0, 0, 0, 0, 0, 0, -1.7453724767562677, 0, 10.4722348605376059, 0, -8.3777878884300847, 0, 0.7978845608028652,
        0.2181715595945335, 0.2181715595945335*_Complex_I, 0, 0.6545146787836006, 0, -5.2361174302688038, 0.6545146787836006*_Complex_I, 0, -5.2361174302688038*_Complex_I, 0, 0.6545146787836006, 0, -10.4722348605376077, 0, 10.4722348605376077, 0.6545146787836006*_Complex_I, 0, -10.4722348605376077*_Complex_I, 0, 10.4722348605376077*_Complex_I, 0, 0.2181715595945335, 0, -5.2361174302688038, 0, 10.4722348605376077, 0, -2.7925959628100294, 0.2181715595945335*_Complex_I, 0, -5.2361174302688038*_Complex_I, 0, 10.4722348605376077*_Complex_I, 0, -2.7925959628100294*_Complex_I, 0,
        //j15/2,3/2
        0.2473832956432473, 0.2473832956432473*_Complex_I, 0, 0.7421498869297418, 0, -5.9371990954379337, 0.7421498869297418*_Complex_I, 0, -5.9371990954379337*_Complex_I, 0, 0.7421498869297418, 0, -11.8743981908758673, 0, 11.8743981908758673, 0.7421498869297418*_Complex_I, 0, -11.8743981908758673*_Complex_I, 0, 11.8743981908758673*_Complex_I, 0, 0.2473832956432473, 0, -5.9371990954379337, 0, 11.8743981908758673, 0, -3.1665061842335653, 0.2473832956432473*_Complex_I, 0, -5.9371990954379337*_Complex_I, 0, 11.8743981908758673*_Complex_I, 0, -3.1665061842335653*_Complex_I, 0,
        0, 0, 1.4842997738594836, 0, 2.9685995477189673*_Complex_I, 0, 0, 1.4842997738594836, 0, -7.9162654605839124, 0, 5.9371990954379346*_Complex_I, 0, -15.8325309211678249*_Complex_I, 0, 0, -1.4842997738594836, 0, 0, 0, 4.7497592763503480, 0, 2.9685995477189673*_Complex_I, 0, -15.8325309211678249*_Complex_I, 0, 9.4995185527006960*_Complex_I, 0, 0, -1.4842997738594836, 0, 7.9162654605839124, 0, -4.7497592763503480, 0, 0,
        //j15/2,5/2
        0, 0, 1.9162227683124053, 0, 3.8324455366248107*_Complex_I, 0, 0, 1.9162227683124053, 0, -10.2198547643328261, 0, 7.6648910732496214*_Complex_I, 0, -20.4397095286656523*_Complex_I, 0, 0, -1.9162227683124053, 0, 0, 0, 6.1319128585996969, 0, 3.8324455366248107*_Complex_I, 0, -20.4397095286656523*_Complex_I, 0, 12.2638257171993938*_Complex_I, 0, 0, -1.9162227683124053, 0, 10.2198547643328261, 0, -6.1319128585996969, 0, 0,
        -0.1916222768312404, -0.5748668304937213*_Complex_I, 0, 0.1916222768312404, 0, 3.8324455366248085, -0.9581113841562022*_Complex_I, 0, 11.4973366098744254*_Complex_I, 0, 0.9581113841562022, 0, -7.6648910732496169, 0, -5.1099273821664122, -0.1916222768312404*_Complex_I, 0, 7.6648910732496169*_Complex_I, 0, -15.3297821464992357*_Complex_I, 0, 0.5748668304937213, 0, -11.4973366098744254, 0, 15.3297821464992357, 0, 0, 0.1916222768312404*_Complex_I, 0, -3.8324455366248085*_Complex_I, 0, 5.1099273821664122*_Complex_I, 0, 0, 0,
        //j15/2,7/2
        -0.2842217679059343, -0.8526653037178029*_Complex_I, 0, 0.2842217679059343, 0, 5.6844353581186855, -1.4211088395296716*_Complex_I, 0, 17.0533060743560583*_Complex_I, 0, 1.4211088395296716, 0, -11.3688707162373710, 0, -7.5792471441582485, -0.2842217679059343*_Complex_I, 0, 11.3688707162373710*_Complex_I, 0, -22.7377414324747456*_Complex_I, 0, 0.8526653037178029, 0, -17.0533060743560583, 0, 22.7377414324747456, 0, 0, 0.2842217679059343*_Complex_I, 0, -5.6844353581186855*_Complex_I, 0, 7.5792471441582485*_Complex_I, 0, 0, 0,
        0, 0, -1.1368870716237374, 0, -4.5475482864949495*_Complex_I, 0, 0, 5.6844353581186864, 0, 3.7896235720791247, 0, 0, 0, 15.1584942883164988*_Complex_I, 0, 0, 5.6844353581186864, 0, -22.7377414324747456, 0, 0, 0, 4.5475482864949495*_Complex_I, 0, -15.1584942883164988*_Complex_I, 0, 0, 0, 0, -1.1368870716237374, 0, 3.7896235720791247, 0, 0, 0, 0,
        //j15/2,9/2
        0, 0, -1.9691461705205107, 0, -7.8765846820820427*_Complex_I, 0, 0, 9.8457308526025535, 0, 6.5638205684017024, 0, 0, 0, 26.2552822736068094*_Complex_I, 0, 0, 9.8457308526025535, 0, -39.3829234104102142, 0, 0, 0, 7.8765846820820427*_Complex_I, 0, -26.2552822736068094*_Complex_I, 0, 0, 0, 0, -1.9691461705205107, 0, 6.5638205684017024, 0, 0, 0, 0,
        0.1640955142100426, 0.8204775710502128*_Complex_I, 0, -1.4768596278903832, 0, -1.9691461705205107, -0.8204775710502128*_Complex_I, 0, -9.8457308526025535*_Complex_I, 0, -0.8204775710502128, 0, 19.6914617052051071, 0, 0, -1.4768596278903832*_Complex_I, 0, 19.6914617052051071*_Complex_I, 0, 0, 0, 0.8204775710502128, 0, -9.8457308526025535, 0, 0, 0, 0, 0.1640955142100426*_Complex_I, 0, -1.9691461705205107*_Complex_I, 0, 0, 0, 0, 0,
        //j15/2,11/2
        0.3415920525959572, 1.7079602629797861*_Complex_I, 0, -3.0743284733636154, 0, -4.0991046311514863, -1.7079602629797861*_Complex_I, 0, -20.4955231557574322*_Complex_I, 0, -1.7079602629797861, 0, 40.9910463115148644, 0, 0, -3.0743284733636154*_Complex_I, 0, 40.9910463115148644*_Complex_I, 0, 0, 0, 1.7079602629797861, 0, -20.4955231557574322, 0, 0, 0, 0, 0.3415920525959572*_Complex_I, 0, -4.0991046311514863*_Complex_I, 0, 0, 0, 0, 0,
        0, 0, 0.6831841051919142, 0, 4.0991046311514854*_Complex_I, 0, 0, -10.2477615778787126, 0, 0, 0, -13.6636821038382852*_Complex_I, 0, 0, 0, 0, 10.2477615778787126, 0, 0, 0, 0, 0, 4.0991046311514854*_Complex_I, 0, 0, 0, 0, 0, 0, -0.6831841051919142, 0, 0, 0, 0, 0, 0,
        //j15/2,13/2
        0, 0, 1.8075352420099966, 0, 10.8452114520599796*_Complex_I, 0, 0, -27.1130286301499481, 0, 0, 0, -36.1507048401999356*_Complex_I, 0, 0, 0, 0, 27.1130286301499481, 0, 0, 0, 0, 0, 10.8452114520599796*_Complex_I, 0, 0, 0, 0, 0, 0, -1.8075352420099966, 0, 0, 0, 0, 0, 0,
        -0.1291096601435712, -0.9037676210049984*_Complex_I, 0, 2.7113028630149949, 0, 0, 4.5188381050249919*_Complex_I, 0, 0, 0, -4.5188381050249919, 0, 0, 0, 0, -2.7113028630149949*_Complex_I, 0, 0, 0, 0, 0, 0.9037676210049984, 0, 0, 0, 0, 0, 0, 0.1291096601435712*_Complex_I, 0, 0, 0, 0, 0, 0, 0,
        //j15/2,15/2
        -0.5000395635705508, -3.5002769449938556*_Complex_I, 0, 10.5008308349815653, 0, 0, 17.5013847249692773*_Complex_I, 0, 0, 0, -17.5013847249692773, 0, 0, 0, 0, -10.5008308349815653*_Complex_I, 0, 0, 0, 0, 0, 3.5002769449938556, 0, 0, 0, 0, 0, 0, 0.5000395635705508*_Complex_I, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};


static FINT _len_spinor(FINT kappa, FINT l)
{
        if (0 == kappa) {
                return 4 * l + 2;
        } else if (kappa < 0) {
                return 2 * l + 2;
        } else {
                return 2 * l;
        }
}

struct cart2sp_t {
        const double *cart2sph;
        const double complex *cart2j_lt_l; // j < kappa, l > 0
        const double complex *cart2j_gt_l; // j > kappa, l < 0
};

// [*] = n(n+1)(n+2)(n+3)/4+(n+1)(n+2)(n+3)/6
static struct cart2sp_t g_c2s[] = {
        {g_trans_cart2sph    , g_trans_cart2j    , g_trans_cart2j     },
        {g_trans_cart2sph+1  , g_trans_cart2j+4  , g_trans_cart2j+16  },
        {g_trans_cart2sph+10 , g_trans_cart2j+40 , g_trans_cart2j+88  },
        {g_trans_cart2sph+40 , g_trans_cart2j+160, g_trans_cart2j+280 },
        {g_trans_cart2sph+110, g_trans_cart2j+440, g_trans_cart2j+680 },
        {g_trans_cart2sph+245, g_trans_cart2j+980, g_trans_cart2j+1400},
        {g_trans_cart2sph+476, g_trans_cart2j+1904,g_trans_cart2j+2576},
        {g_trans_cart2sph+840, g_trans_cart2j+3360,g_trans_cart2j+4368},
        {g_trans_cart2sph+1380,NULL,NULL},
        {g_trans_cart2sph+2145,NULL,NULL},
        {g_trans_cart2sph+3190,NULL,NULL},
        {g_trans_cart2sph+4576,NULL,NULL},
        {g_trans_cart2sph+6370,NULL,NULL},
};

const double *CINTaddress_cart2sph(FINT l)
{
        return g_c2s[l].cart2sph;
}

const double complex *CINTaddress_cart2j_lt_l(FINT l)
{
        return g_c2s[l].cart2j_lt_l;
}

const double complex *CINTaddress_cart2j_gt_l(FINT l)
{
        return g_c2s[l].cart2j_gt_l;
}


static void c2s_dgemm(const char transa, const char transb,
                      const FINT m, const FINT n, const FINT k,
                      const double alpha, const double *a, const FINT lda,
                      const double *b, const FINT ldb,
                      const double beta, double *c, const FINT ldc)
{
#if defined I8
        FINT i, j, kp;
        const double *pa, *pb;
        double btmp[k];
        for (j = 0; j < n; j++) {
                if (beta == 0) {
                        memset(c, 0, sizeof(double)*m);
                } else {
                        for (i = 0; i < m; i++) {
                                c[i] *= beta;
                        }
                }
                if (transa == 'T') {
                        pb = b + ldb * j;
                        for (kp = 0; kp < k; kp++) {
                                btmp[kp] = alpha * pb[kp];
                        }
                        for (i = 0; i < m; i++) {
                                pa = a + lda * i;
                                for (kp = 0; kp < k; kp++) {
                                        c[i] += pa[kp] * btmp[kp];
                                }
                        }
                } else {
                        pb = b + ldb * j;
                        for (kp = 0; kp < k; kp++) {
                                btmp[0] = alpha * pb[kp];
                                pa = a + lda * kp;
                                for (i = 0; i < m; i++) {
                                        c[i] += pa[i] * btmp[0];
                                }
                        }
                }
                c += ldc;
        }
#else
        dgemm_(&transa, &transb, &m, &n, &k,
               &alpha, a, &lda, b, &ldb, &beta, c, &ldc);
#endif
}

static void c2s_zgemm(const char transa, const char transb,
                      const FINT m, const FINT n, const FINT k,
                      const double complex alpha, const double complex *a, const FINT lda,
                      const double complex *b, const FINT ldb,
                      const double complex beta, double complex *c, const FINT ldc)
{
#if defined I8
        FINT i, j, kp;
        const double complex *pa, *pb;
        double complex btmp[k];
        for (j = 0; j < n; j++) {
                if (beta == 0) {
                        memset(c, 0, sizeof(double complex)*m);
                } else {
                        for (i = 0; i < m; i++) {
                                c[i] *= beta;
                        }
                }
                if (transa == 'C') {
                        pb = b + ldb * j;
                        for (kp = 0; kp < k; kp++) {
                                btmp[kp] = alpha * pb[kp];
                        }
                        for (i = 0; i < m; i++) {
                                pa = a + lda * i;
                                for (kp = 0; kp < k; kp++) {
                                        c[i] += conj(pa[kp]) * btmp[kp];
                                }
                        }
                } else {
                        pb = b + ldb * j;
                        for (kp = 0; kp < k; kp++) {
                                btmp[0] = alpha * pb[kp];
                                pa = a + lda * kp;
                                for (i = 0; i < m; i++) {
                                        c[i] += pa[i] * btmp[0];
                                }
                        }
                }
                c += ldc;
        }
#else
        zgemm_(&transa, &transb, &m, &n, &k,
               &alpha, a, &lda, b, &ldb, &beta, c, &ldc);
#endif
}

// transform integrals from cartesian to spheric
static double *a_bra_cart2spheric(double *gsph, FINT nket, double *gcart, FINT l)
{
        const FINT nf = (l+1)*(l+2)/2;
        const FINT nd = l * 2 + 1;
        c2s_dgemm('T', 'N', nd, nket, nf,
                  1, g_c2s[l].cart2sph, nf, gcart, nf, 0, gsph, nd);
        return gsph;
}

static double *a_ket_cart2spheric(double *gsph, double *gcart,
                                  FINT lds, FINT nbra, FINT l)
{
        const FINT nf = (l+1)*(l+2)/2;
        const FINT nd = l * 2 + 1;
        c2s_dgemm('N', 'N', nbra, nd, nf,
                  1, gcart, nbra, g_c2s[l].cart2sph, nf, 0, gsph, lds);
        return gsph;
}

// transform s function from cartesian to spheric
static double *s_bra_cart2spheric(double *gsph, FINT nket, double *gcart, FINT l)
{
        /*
        FINT i;
        for (i = 0; i < nket; i++) {
                *gsph = gcart[i];
        }*/
        return gcart;
}
static double *s_ket_cart2spheric(double *gsph, double *gcart,
                                  FINT lds, FINT nbra, FINT l)
{
        /*
        FINT i;
        for (i = 0; i < nbra; i++) {
                gsph[i] = gcart[i];
        }*/
        return gcart;
}
static double *s_ket_cart2spheric1(double *gsph, double *gcart,
                                   FINT lds, FINT nbra, FINT l)
{
        FINT i;
        for (i = 0; i < nbra; i++) {
                gsph[i] = gcart[i];
        }
        return gsph;
}

// transform p function from cartesian to spheric
static double *p_bra_cart2spheric(double *gsph, FINT nket, double *gcart, FINT l)
{
        /*
        double *pgcart = gcart;
        FINT i;
        for (i = 0; i < nket; i++) {
                gsph[0] = gcart[0];
                gsph[1] = gcart[1];
                gsph[2] = gcart[2];
                gsph += 3;
                gcart += 3;
        }
        return pgcart;*/
        return gcart;
}
static double *p_ket_cart2spheric(double *gsph, double *gcart,
                                  FINT lds, FINT nbra, FINT l)
{
        /*
        FINT i;
        for (i = 0; i < nbra; i++) {
                gsph[0*nbra+i] = gcart[0*nbra+i];
                gsph[1*nbra+i] = gcart[1*nbra+i];
                gsph[2*nbra+i] = gcart[2*nbra+i];
        }*/
        return gcart;
}
static double *p_ket_cart2spheric1(double *gsph, double *gcart,
                                   FINT lds, FINT nbra, FINT l)
{
        FINT i;
        for (i = 0; i < nbra; i++) {
                gsph[0*lds+i] = gcart[0*nbra+i];
                gsph[1*lds+i] = gcart[1*nbra+i];
                gsph[2*lds+i] = gcart[2*nbra+i];
        }
        return gsph;
}

// transform d function from cartesian to spheric
static double *d_bra_cart2spheric(double *gsph, FINT nket, double *gcart, FINT l)
{
        const double *coeff_c2s = g_c2s[2].cart2sph;
        double *pgsph = gsph;
        FINT i;
        for (i = 0; i < nket; i++) {
                gsph[0] = coeff_c2s[ 1] * gcart[1];
                gsph[1] = coeff_c2s[10] * gcart[4];
                gsph[2] = coeff_c2s[12] * gcart[0]
                        + coeff_c2s[15] * gcart[3]
                        + coeff_c2s[17] * gcart[5];
                gsph[3] = coeff_c2s[20] * gcart[2];
                gsph[4] = coeff_c2s[24] * gcart[0]
                        + coeff_c2s[27] * gcart[3];
                gsph += 5;
                gcart += 6;
        }
        return pgsph;
}
static double *d_ket_cart2spheric(double *gsph, double *gcart,
                                  FINT lds, FINT nbra, FINT l)
{
        const double *coeff_c2s = g_c2s[2].cart2sph;
        double *pgsph = gsph;
        FINT i;
        for (i = 0; i < nbra; i++) {
                gsph[0*lds+i] = coeff_c2s[ 1] * gcart[1*nbra+i];
                gsph[1*lds+i] = coeff_c2s[10] * gcart[4*nbra+i];
                gsph[2*lds+i] = coeff_c2s[12] * gcart[0*nbra+i]
                              + coeff_c2s[15] * gcart[3*nbra+i]
                              + coeff_c2s[17] * gcart[5*nbra+i];
                gsph[3*lds+i] = coeff_c2s[20] * gcart[2*nbra+i];
                gsph[4*lds+i] = coeff_c2s[24] * gcart[0*nbra+i]
                              + coeff_c2s[27] * gcart[3*nbra+i];
        }
        return pgsph;
}

// transform f function from cartesian to spheric
static double *f_bra_cart2spheric(double *gsph, FINT nket, double *gcart, FINT l)
{
        const double *coeff_c2s = g_c2s[3].cart2sph;
        double *pgsph = gsph;
        FINT i;
        for (i = 0; i < nket; i++) {
                gsph[0] = coeff_c2s[ 1] * gcart[1]
                        + coeff_c2s[ 6] * gcart[6];
                gsph[1] = coeff_c2s[14] * gcart[4];
                gsph[2] = coeff_c2s[21] * gcart[1]
                        + coeff_c2s[26] * gcart[6]
                        + coeff_c2s[28] * gcart[8];
                gsph[3] = coeff_c2s[32] * gcart[2]
                        + coeff_c2s[37] * gcart[7]
                        + coeff_c2s[39] * gcart[9];
                gsph[4] = coeff_c2s[40] * gcart[0]
                        + coeff_c2s[43] * gcart[3]
                        + coeff_c2s[45] * gcart[5];
                gsph[5] = coeff_c2s[52] * gcart[2]
                        + coeff_c2s[57] * gcart[7];
                gsph[6] = coeff_c2s[60] * gcart[0]
                        + coeff_c2s[63] * gcart[3];
                gsph += 7;
                gcart += 10;
        }
        return pgsph;
}
static double *f_ket_cart2spheric(double *gsph, double *gcart,
                                  FINT lds, FINT nbra, FINT l)
{
        const double *coeff_c2s = g_c2s[3].cart2sph;
        double *pgsph = gsph;
        FINT i;
        for (i = 0; i < nbra; i++) {
                gsph[0*lds+i] = coeff_c2s[ 1] * gcart[1*nbra+i]
                              + coeff_c2s[ 6] * gcart[6*nbra+i];
                gsph[1*lds+i] = coeff_c2s[14] * gcart[4*nbra+i];
                gsph[2*lds+i] = coeff_c2s[21] * gcart[1*nbra+i]
                              + coeff_c2s[26] * gcart[6*nbra+i]
                              + coeff_c2s[28] * gcart[8*nbra+i];
                gsph[3*lds+i] = coeff_c2s[32] * gcart[2*nbra+i]
                              + coeff_c2s[37] * gcart[7*nbra+i]
                              + coeff_c2s[39] * gcart[9*nbra+i];
                gsph[4*lds+i] = coeff_c2s[40] * gcart[0*nbra+i]
                              + coeff_c2s[43] * gcart[3*nbra+i]
                              + coeff_c2s[45] * gcart[5*nbra+i];
                gsph[5*lds+i] = coeff_c2s[52] * gcart[2*nbra+i]
                              + coeff_c2s[57] * gcart[7*nbra+i];
                gsph[6*lds+i] = coeff_c2s[60] * gcart[0*nbra+i]
                              + coeff_c2s[63] * gcart[3*nbra+i];
        }
        return pgsph;
}

// transform g function from cartesian to spheric
static double *g_bra_cart2spheric(double *gsph, FINT nket, double *gcart, FINT l)
{
        const double *coeff_c2s = g_c2s[4].cart2sph;
        double *pgsph = gsph;
        FINT i;
        for (i = 0; i < nket; i++) {
                gsph[0] = coeff_c2s[  1] * gcart[ 1]
                        + coeff_c2s[  6] * gcart[ 6];
                gsph[1] = coeff_c2s[ 19] * gcart[ 4]
                        + coeff_c2s[ 26] * gcart[11];
                gsph[2] = coeff_c2s[ 31] * gcart[ 1]
                        + coeff_c2s[ 36] * gcart[ 6]
                        + coeff_c2s[ 38] * gcart[ 8];
                gsph[3] = coeff_c2s[ 49] * gcart[ 4]
                        + coeff_c2s[ 56] * gcart[11]
                        + coeff_c2s[ 58] * gcart[13];
                gsph[4] = coeff_c2s[ 60] * gcart[ 0]
                        + coeff_c2s[ 63] * gcart[ 3]
                        + coeff_c2s[ 65] * gcart[ 5]
                        + coeff_c2s[ 70] * gcart[10]
                        + coeff_c2s[ 72] * gcart[12]
                        + coeff_c2s[ 74] * gcart[14];
                gsph[5] = coeff_c2s[ 77] * gcart[ 2]
                        + coeff_c2s[ 82] * gcart[ 7]
                        + coeff_c2s[ 84] * gcart[ 9];
                gsph[6] = coeff_c2s[ 90] * gcart[ 0]
                        + coeff_c2s[ 95] * gcart[ 5]
                        + coeff_c2s[100] * gcart[10]
                        + coeff_c2s[102] * gcart[12];
                gsph[7] = coeff_c2s[107] * gcart[ 2]
                        + coeff_c2s[112] * gcart[ 7];
                gsph[8] = coeff_c2s[120] * gcart[ 0]
                        + coeff_c2s[123] * gcart[ 3]
                        + coeff_c2s[130] * gcart[10];
                gsph += 9;
                gcart += 15;
        }
        return pgsph;
}
static double *g_ket_cart2spheric(double *gsph, double *gcart,
                                  FINT lds, FINT nbra, FINT l)
{
        const double *coeff_c2s = g_c2s[4].cart2sph;
        double *pgsph = gsph;
        FINT i;
        for (i = 0; i < nbra; i++) {
                gsph[0*lds+i] = coeff_c2s[  1] * gcart[ 1*nbra+i]
                              + coeff_c2s[  6] * gcart[ 6*nbra+i];
                gsph[1*lds+i] = coeff_c2s[ 19] * gcart[ 4*nbra+i]
                              + coeff_c2s[ 26] * gcart[11*nbra+i];
                gsph[2*lds+i] = coeff_c2s[ 31] * gcart[ 1*nbra+i]
                              + coeff_c2s[ 36] * gcart[ 6*nbra+i]
                              + coeff_c2s[ 38] * gcart[ 8*nbra+i];
                gsph[3*lds+i] = coeff_c2s[ 49] * gcart[ 4*nbra+i]
                              + coeff_c2s[ 56] * gcart[11*nbra+i]
                              + coeff_c2s[ 58] * gcart[13*nbra+i];
                gsph[4*lds+i] = coeff_c2s[ 60] * gcart[ 0*nbra+i]
                              + coeff_c2s[ 63] * gcart[ 3*nbra+i]
                              + coeff_c2s[ 65] * gcart[ 5*nbra+i]
                              + coeff_c2s[ 70] * gcart[10*nbra+i]
                              + coeff_c2s[ 72] * gcart[12*nbra+i]
                              + coeff_c2s[ 74] * gcart[14*nbra+i];
                gsph[5*lds+i] = coeff_c2s[ 77] * gcart[ 2*nbra+i]
                              + coeff_c2s[ 82] * gcart[ 7*nbra+i]
                              + coeff_c2s[ 84] * gcart[ 9*nbra+i];
                gsph[6*lds+i] = coeff_c2s[ 90] * gcart[ 0*nbra+i]
                              + coeff_c2s[ 95] * gcart[ 5*nbra+i]
                              + coeff_c2s[100] * gcart[10*nbra+i]
                              + coeff_c2s[102] * gcart[12*nbra+i];
                gsph[7*lds+i] = coeff_c2s[107] * gcart[ 2*nbra+i]
                              + coeff_c2s[112] * gcart[ 7*nbra+i];
                gsph[8*lds+i] = coeff_c2s[120] * gcart[ 0*nbra+i]
                              + coeff_c2s[123] * gcart[ 3*nbra+i]
                              + coeff_c2s[130] * gcart[10*nbra+i];
        }
        return pgsph;
}

/*
 * return the address of gemm results, for s,p function, results ==
 * input, so return the input address optimize
 */
double *(*c2s_bra_sph[])() = {
        s_bra_cart2spheric,
        p_bra_cart2spheric,
        d_bra_cart2spheric,
        f_bra_cart2spheric,
        g_bra_cart2spheric,
        a_bra_cart2spheric,
        a_bra_cart2spheric,
        a_bra_cart2spheric,
        a_bra_cart2spheric,
        a_bra_cart2spheric,
        a_bra_cart2spheric,
        a_bra_cart2spheric,
        a_bra_cart2spheric,
};

double *(*c2s_ket_sph[])(double *gsph, double *gcart,
                         FINT lds, FINT nbra, FINT l) = {
        s_ket_cart2spheric,
        p_ket_cart2spheric,
        d_ket_cart2spheric,
        f_ket_cart2spheric,
        g_ket_cart2spheric,
        a_ket_cart2spheric,
        a_ket_cart2spheric,
        a_ket_cart2spheric,
        a_ket_cart2spheric,
        a_ket_cart2spheric,
        a_ket_cart2spheric,
        a_ket_cart2spheric,
        a_ket_cart2spheric,
};

double *(*c2s_ket_sph1[])(double *gsph, double *gcart,
                          FINT lds, FINT nbra, FINT l) = {
        s_ket_cart2spheric1,
        p_ket_cart2spheric1,
        d_ket_cart2spheric,
        f_ket_cart2spheric,
        g_ket_cart2spheric,
        a_ket_cart2spheric,
        a_ket_cart2spheric,
        a_ket_cart2spheric,
        a_ket_cart2spheric,
        a_ket_cart2spheric,
        a_ket_cart2spheric,
        a_ket_cart2spheric,
        a_ket_cart2spheric,
};


/* transform spin free integrals from cartesian to spinor
 * In the return vector gsp, the first nd*nket elements stores the upper
 * components of the two-component vector, the lower component vector
 * are next to the upper component.
 */
static void a_bra_cart2spinor_sf(double complex *gsp, FINT nket,
                                 double complex *gcart, FINT kappa, FINT l)
{
        FINT nf = (l+1)*(l+2)/2;
        FINT nd = _len_spinor(kappa, l);
        const double complex *coeff_c2s;

        if (kappa < 0) { // j = l + 1/2
                coeff_c2s = g_c2s[l].cart2j_gt_l;
        } else {
                coeff_c2s = g_c2s[l].cart2j_lt_l;
        }
        c2s_zgemm('C', 'N', nd, nket, nf,
                  1, coeff_c2s, nf*2, gcart, nf, 0, gsp, nd);
        c2s_zgemm('C', 'N', nd, nket, nf,
                  1, coeff_c2s+nf, nf*2, gcart, nf, 0, gsp+nd*nket, nd);
}
static void a_bra_cart2spinor_e1sf(double complex *gsp, FINT nket,
                                   double *gcart, FINT kappa, FINT l)
{
        const FINT nf = (l+1)*(l+2)/2;
        double complex *tmp1 = malloc(sizeof(double complex)*nf*nket);

        CINTdcmplx_re(nf*nket, tmp1, gcart);
        a_bra_cart2spinor_sf(gsp, nket, tmp1, kappa, l);
        free(tmp1);
}

static void a_bra_cart2spinor_si(double complex *gsp, FINT nket,
                                 double complex *gcart, FINT kappa, FINT l)
{
        FINT nf = (l+1)*(l+2)/2;
        FINT nd = _len_spinor(kappa, l);
        const double complex *coeff_c2s;

        if (kappa < 0) { // j = l + 1/2
                coeff_c2s = g_c2s[l].cart2j_gt_l;
        } else {
                coeff_c2s = g_c2s[l].cart2j_lt_l;
        }
        c2s_zgemm('C', 'N', nd, nket, nf,
                  1, coeff_c2s, nf*2, gcart, nf, 0, gsp, nd);
        c2s_zgemm('C', 'N', nd, nket, nf,
                  1, coeff_c2s+nf, nf*2, gcart+nf*nket, nf, 1, gsp, nd);
}

static void a_ket_cart2spinor(double complex *gsp, FINT nbra,
                              double complex *gcart, FINT kappa, FINT l)
{
        FINT nf = (l+1)*(l+2)/2;
        FINT nd = _len_spinor(kappa, l);
        const double complex *coeff_c2s;

        if (kappa < 0) { // j = l + 1/2
                coeff_c2s = g_c2s[l].cart2j_gt_l;
        } else {
                coeff_c2s = g_c2s[l].cart2j_lt_l;
        }
        c2s_zgemm('N', 'N', nbra, nd, nf*2,
                  1, gcart, nbra, coeff_c2s, nf*2, 0, gsp, nbra);
}
// with phase "i"
static void a_iket_cart2spinor(double complex *gsp, FINT nbra,
                               double complex *gcart, FINT kappa, FINT l)
{
        const double complex ZI = 0 + 1 * _Complex_I;
        FINT nf = (l+1)*(l+2)/2;
        FINT nd = _len_spinor(kappa, l);
        const double complex *coeff_c2s;

        if (kappa < 0) { // j = l + 1/2
                coeff_c2s = g_c2s[l].cart2j_gt_l;
        } else {
                coeff_c2s = g_c2s[l].cart2j_lt_l;
        }
        c2s_zgemm('N', 'N', nbra, nd, nf*2,
                  ZI, gcart, nbra, coeff_c2s, nf*2, 0, gsp, nbra);
}

static void s_bra_cart2spinor_sf(double complex *gsp, FINT nket,
                                 double complex *gcart, FINT kappa, FINT l)
{
        //const double *coeff_c2s = g_c2s[0].cart2j_lt_l;
        double complex *gsp1 = gsp + nket * 2;
        FINT i;
        for (i = 0; i < nket; i++) {
                gsp [i*2+0] = 0;
                gsp [i*2+1] = gcart[i];
                gsp1[i*2+0] = gcart[i];
                gsp1[i*2+1] = 0;
        }
}
static void s_bra_cart2spinor_e1sf(double complex *gsp, FINT nket,
                                   double *gcart, FINT kappa, FINT l)
{
        //const double *coeff_c2s = g_c2s[0].cart2j_lt_l;;
        double complex *gsp1 = gsp + nket * 2;
        FINT i;
        for (i = 0; i < nket; i++) {
                gsp [i*2+0] = 0;
                gsp [i*2+1] = gcart[i];
                gsp1[i*2+0] = gcart[i];
                gsp1[i*2+1] = 0;
        }
}
static void s_bra_cart2spinor_si(double complex *gsp, FINT nket,
                                 double complex *gcart, FINT kappa, FINT l)
{
        //const double *coeff_c2s = g_c2s[0].cart2j_lt_l;;
        double complex *gcart1 = gcart + nket;
        FINT i;
        for (i = 0; i < nket; i++) {
                gsp[i*2+0] = gcart1[i];
                gsp[i*2+1] = gcart [i];
        }
}
static void s_ket_cart2spinor(double complex *gsp, FINT nbra,
                              double complex *gcart, FINT kappa, FINT l)
{
        double complex *gsp1 = gsp + nbra;
        double complex *gcart1 = gcart + nbra;
        FINT i;
        for (i = 0; i < nbra; i++) {
                gsp [i] = gcart1[i];
                gsp1[i] = gcart [i];
        }
}
static void s_iket_cart2spinor(double complex *gsp, FINT nbra,
                               double complex *gcart, FINT kappa, FINT l)
{
        double complex *gsp1 = gsp + nbra;
        double complex *gcart1 = gcart + nbra;
        FINT i;
        for (i = 0; i < nbra; i++) {
                gsp [i] = gcart1[i] * _Complex_I;
                gsp1[i] = gcart [i] * _Complex_I;
        }
}

static void p_bra_cart2spinor_sf(double complex *gsp, FINT nket,
                                 double complex *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT nd = _len_spinor(kappa, l);
        double complex *gsp1 = gsp + nket * nd;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[1].cart2j_lt_l;
                for (i = 0; i < nket; i++) {
                        // spin-up part
                        gsp [i*nd+0] = creal(coeff_c2s[0])*gcart[3*i+0]
                                     - cimag(coeff_c2s[1])*gcart[3*i+1]*_Complex_I;
                        gsp [i*nd+1] = creal(coeff_c2s[8])*gcart[3*i+2];
                        // spin-down part
                        gsp1[i*nd+0] = creal(coeff_c2s[5])*gcart[3*i+2];
                        gsp1[i*nd+1] = creal(coeff_c2s[9])*gcart[3*i+0]
                                     - cimag(coeff_c2s[10])*gcart[3*i+1]*_Complex_I;
                }
                gsp  += 2;
                gsp1 += 2;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[1].cart2j_gt_l;
                for (i = 0; i < nket; i++) {
                        gsp [i*nd+0] = 0;
                        gsp [i*nd+1] = creal(coeff_c2s[6])*gcart[3*i+0]
                                     - cimag(coeff_c2s[7])*gcart[3*i+1]*_Complex_I;
                        gsp [i*nd+2] = creal(coeff_c2s[14])*gcart[3*i+2];
                        gsp [i*nd+3] = creal(coeff_c2s[18])*gcart[3*i+0]
                                     - cimag(coeff_c2s[19])*gcart[3*i+1]*_Complex_I;
                        gsp1[i*nd+0] = creal(coeff_c2s[3])*gcart[3*i+0]
                                     - cimag(coeff_c2s[4])*gcart[3*i+1]*_Complex_I;
                        gsp1[i*nd+1] = creal(coeff_c2s[11])*gcart[3*i+2];
                        gsp1[i*nd+2] = creal(coeff_c2s[15])*gcart[3*i+0]
                                     - cimag(coeff_c2s[16])*gcart[3*i+1]*_Complex_I;
                        gsp1[i*nd+3] = 0;
                }
        }
}
static void p_bra_cart2spinor_e1sf(double complex *gsp, FINT nket,
                                   double *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT nd = _len_spinor(kappa, l);
        double complex *gsp1 = gsp + nket * nd;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[1].cart2j_lt_l;
                for (i = 0; i < nket; i++) {
                        // spin-up part
                        gsp [i*nd+0] = creal(coeff_c2s[0])*gcart[3*i+0]
                                     - cimag(coeff_c2s[1])*gcart[3*i+1]*_Complex_I;
                        gsp [i*nd+1] = creal(coeff_c2s[8])*gcart[3*i+2];
                        // spin-down part
                        gsp1[i*nd+0] = creal(coeff_c2s[5])*gcart[3*i+2];
                        gsp1[i*nd+1] = creal(coeff_c2s[9])*gcart[3*i+0]
                                     - cimag(coeff_c2s[10])*gcart[3*i+1]*_Complex_I;
                }
                gsp  += 2;
                gsp1 += 2;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[1].cart2j_gt_l;
                for (i = 0; i < nket; i++) {
                        gsp [i*nd+0] = 0;
                        gsp [i*nd+1] = creal(coeff_c2s[6])*gcart[3*i+0]
                                     - cimag(coeff_c2s[7])*gcart[3*i+1]*_Complex_I;
                        gsp [i*nd+2] = creal(coeff_c2s[14])*gcart[3*i+2];
                        gsp [i*nd+3] = creal(coeff_c2s[18])*gcart[3*i+0]
                                     - cimag(coeff_c2s[19])*gcart[3*i+1]*_Complex_I;
                        gsp1[i*nd+0] = creal(coeff_c2s[3])*gcart[3*i+0]
                                     - cimag(coeff_c2s[4])*gcart[3*i+1]*_Complex_I;
                        gsp1[i*nd+1] = creal(coeff_c2s[11])*gcart[3*i+2];
                        gsp1[i*nd+2] = creal(coeff_c2s[15])*gcart[3*i+0]
                                     - cimag(coeff_c2s[16])*gcart[3*i+1]*_Complex_I;
                        gsp1[i*nd+3] = 0;
                }
        }
}
static void p_bra_cart2spinor_si(double complex *gsp, FINT nket,
                                 double complex *gcart, FINT kappa, FINT l)
{
        double complex *gcart1 = gcart + nket * 3;
        const complex double *coeff_c2s;
        FINT nd = _len_spinor(kappa, l);
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[1].cart2j_lt_l;
                for (i = 0; i < nket; i++) {
                        // spin-up part
                        gsp[i*nd+0] = creal(coeff_c2s[0])*gcart[3*i+0]
                                    - cimag(coeff_c2s[1])*gcart[3*i+1]*_Complex_I;
                        gsp[i*nd+1] = creal(coeff_c2s[8])*gcart[3*i+2];
                        // spin-down part
                        gsp[i*nd+0]+= creal(coeff_c2s[5])*gcart1[3*i+2];
                        gsp[i*nd+1]+= creal(coeff_c2s[9])*gcart1[3*i+0]
                                    - cimag(coeff_c2s[10])*gcart1[3*i+1]*_Complex_I;
                }
                gsp += 2;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[1].cart2j_gt_l;
                for (i = 0; i < nket; i++) {
                        gsp[i*nd+0] = 0;
                        gsp[i*nd+1] = creal(coeff_c2s[6])*gcart[3*i+0]
                                    - cimag(coeff_c2s[7])*gcart[3*i+1]*_Complex_I;
                        gsp[i*nd+2] = creal(coeff_c2s[14])*gcart[3*i+2];
                        gsp[i*nd+3] = creal(coeff_c2s[18])*gcart[3*i+0]
                                    - cimag(coeff_c2s[19])*gcart[3*i+1]*_Complex_I;

                        gsp[i*nd+0]+= creal(coeff_c2s[3])*gcart1[3*i+0]
                                    - cimag(coeff_c2s[4])*gcart1[3*i+1]*_Complex_I;
                        gsp[i*nd+1]+= creal(coeff_c2s[11])*gcart1[3*i+2];
                        gsp[i*nd+2]+= creal(coeff_c2s[15])*gcart1[3*i+0]
                                    - cimag(coeff_c2s[16])*gcart1[3*i+1]*_Complex_I;
                        gsp[i*nd+3]+= 0;
                }
        }
}
static void p_ket_cart2spinor(double complex *gsp, FINT nbra,
                              double complex *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[1].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gsp[     i] = creal(coeff_c2s[0])*gcart[nbra*0+i]
                                    + cimag(coeff_c2s[1])*gcart[nbra*1+i]*_Complex_I
                                    + creal(coeff_c2s[5])*gcart[nbra*5+i];
                        gsp[nbra+i] = creal(coeff_c2s[8])*gcart[nbra*2+i]
                                    + creal(coeff_c2s[9])*gcart[nbra*3+i]
                                    + cimag(coeff_c2s[10])*gcart[nbra*4+i]*_Complex_I;
                }
                gsp += nbra * 2;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[1].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gsp[0*nbra+i] = creal(coeff_c2s[3])*gcart[nbra*3+i]
                                      + cimag(coeff_c2s[4])*gcart[nbra*4+i]*_Complex_I;
                        gsp[1*nbra+i] = creal(coeff_c2s[6])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[7])*gcart[nbra*1+i]*_Complex_I
                                      + creal(coeff_c2s[11])*gcart[nbra*5+i];
                        gsp[2*nbra+i] = creal(coeff_c2s[14])*gcart[nbra*2+i]
                                      + creal(coeff_c2s[15])*gcart[nbra*3+i]
                                      + cimag(coeff_c2s[16])*gcart[nbra*4+i]*_Complex_I;
                        gsp[3*nbra+i] = creal(coeff_c2s[18])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[19])*gcart[nbra*1+i]*_Complex_I;
                }
        }
}
static void p_iket_cart2spinor(double complex *gsp, FINT nbra,
                               double complex *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[1].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gsp[     i] = creal(coeff_c2s[0])*gcart[nbra*0+i]*_Complex_I
                                    - cimag(coeff_c2s[1])*gcart[nbra*1+i]
                                    + creal(coeff_c2s[5])*gcart[nbra*5+i]*_Complex_I;
                        gsp[nbra+i] = creal(coeff_c2s[8])*gcart[nbra*2+i]*_Complex_I
                                    + creal(coeff_c2s[9])*gcart[nbra*3+i]*_Complex_I
                                    - cimag(coeff_c2s[10])*gcart[nbra*4+i];
                }
                gsp += nbra * 2;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[1].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gsp[0*nbra+i] = creal(coeff_c2s[3])*gcart[nbra*3+i]*_Complex_I
                                      - cimag(coeff_c2s[4])*gcart[nbra*4+i];
                        gsp[1*nbra+i] = creal(coeff_c2s[6])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[7])*gcart[nbra*1+i]
                                      + creal(coeff_c2s[11])*gcart[nbra*5+i]*_Complex_I;
                        gsp[2*nbra+i] = creal(coeff_c2s[14])*gcart[nbra*2+i]*_Complex_I
                                      + creal(coeff_c2s[15])*gcart[nbra*3+i]*_Complex_I
                                      - cimag(coeff_c2s[16])*gcart[nbra*4+i];
                        gsp[3*nbra+i] = creal(coeff_c2s[18])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[19])*gcart[nbra*1+i];
                }
        }
}

static void d_bra_cart2spinor_sf(double complex *gsp, FINT nket,
                                 double complex *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT nd = _len_spinor(kappa, l);
        double complex *gsp1 = gsp + nket * nd;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[2].cart2j_lt_l;
                for (i = 0; i < nket; i++) {
                        // spin-up part
                        gsp [i*nd+0] = creal(coeff_c2s[0])*gcart[6*i+0]
                                     + creal(coeff_c2s[3])*gcart[6*i+3]
                                     - cimag(coeff_c2s[1])*gcart[6*i+1]*_Complex_I;
                        gsp [i*nd+1] = creal(coeff_c2s[14])*gcart[6*i+2]
                                     - cimag(coeff_c2s[16])*gcart[6*i+4]*_Complex_I;
                        gsp [i*nd+2] = creal(coeff_c2s[24])*gcart[6*i+0]
                                     + creal(coeff_c2s[27])*gcart[6*i+3]
                                     + creal(coeff_c2s[29])*gcart[6*i+5];
                        gsp [i*nd+3] = creal(coeff_c2s[38])*gcart[6*i+2]
                                     - cimag(coeff_c2s[40])*gcart[6*i+4]*_Complex_I;
                        // spin-down part
                        gsp1[i*nd+0] = creal(coeff_c2s[8])*gcart[6*i+2]
                                     - cimag(coeff_c2s[10])*gcart[6*i+4]*_Complex_I;
                        gsp1[i*nd+1] = creal(coeff_c2s[18])*gcart[6*i+0]
                                     + creal(coeff_c2s[21])*gcart[6*i+3]
                                     + creal(coeff_c2s[23])*gcart[6*i+5];
                        gsp1[i*nd+2] = creal(coeff_c2s[32])*gcart[6*i+2]
                                     - cimag(coeff_c2s[34])*gcart[6*i+4]*_Complex_I;
                        gsp1[i*nd+3] = creal(coeff_c2s[42])*gcart[6*i+0]
                                     + creal(coeff_c2s[45])*gcart[6*i+3]
                                     - cimag(coeff_c2s[43])*gcart[6*i+1]*_Complex_I;
                }
                gsp  += 4;
                gsp1 += 4;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[2].cart2j_gt_l;
                for (i = 0; i < nket; i++) {
                        gsp [i*nd+0] = 0;
                        gsp [i*nd+1] = creal(coeff_c2s[12])*gcart[6*i+0]
                                     + creal(coeff_c2s[15])*gcart[6*i+3]
                                     - cimag(coeff_c2s[13])*gcart[6*i+1]*_Complex_I;
                        gsp [i*nd+2] = creal(coeff_c2s[26])*gcart[6*i+2]
                                     - cimag(coeff_c2s[28])*gcart[6*i+4]*_Complex_I;
                        gsp [i*nd+3] = creal(coeff_c2s[36])*gcart[6*i+0]
                                     + creal(coeff_c2s[39])*gcart[6*i+3]
                                     + creal(coeff_c2s[41])*gcart[6*i+5];
                        gsp [i*nd+4] = creal(coeff_c2s[50])*gcart[6*i+2]
                                     - cimag(coeff_c2s[52])*gcart[6*i+4]*_Complex_I;
                        gsp [i*nd+5] = creal(coeff_c2s[60])*gcart[6*i+0]
                                     + creal(coeff_c2s[63])*gcart[6*i+3]
                                     - cimag(coeff_c2s[61])*gcart[6*i+1]*_Complex_I;

                        gsp1[i*nd+0] = creal(coeff_c2s[6])*gcart[6*i+0]
                                     + creal(coeff_c2s[9])*gcart[6*i+3]
                                     - cimag(coeff_c2s[7])*gcart[6*i+1]*_Complex_I;
                        gsp1[i*nd+1] = creal(coeff_c2s[20])*gcart[6*i+2]
                                     - cimag(coeff_c2s[22])*gcart[6*i+4]*_Complex_I;
                        gsp1[i*nd+2] = creal(coeff_c2s[30])*gcart[6*i+0]
                                     + creal(coeff_c2s[33])*gcart[6*i+3]
                                     + creal(coeff_c2s[35])*gcart[6*i+5];
                        gsp1[i*nd+3] = creal(coeff_c2s[44])*gcart[6*i+2]
                                     - cimag(coeff_c2s[46])*gcart[6*i+4]*_Complex_I;
                        gsp1[i*nd+4] = creal(coeff_c2s[54])*gcart[6*i+0]
                                     + creal(coeff_c2s[57])*gcart[6*i+3]
                                     - cimag(coeff_c2s[55])*gcart[6*i+1]*_Complex_I;
                        gsp1[i*nd+5] = 0;
                }
        }
}
static void d_bra_cart2spinor_e1sf(double complex *gsp, FINT nket,
                                   double *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT nd = _len_spinor(kappa, l);
        double complex *gsp1 = gsp + nket * nd;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[2].cart2j_lt_l;
                for (i = 0; i < nket; i++) {
                        // spin-up part
                        gsp [i*nd+0] = creal(coeff_c2s[0])*gcart[6*i+0]
                                     + creal(coeff_c2s[3])*gcart[6*i+3]
                                     - cimag(coeff_c2s[1])*gcart[6*i+1]*_Complex_I;
                        gsp [i*nd+1] = creal(coeff_c2s[14])*gcart[6*i+2]
                                     - cimag(coeff_c2s[16])*gcart[6*i+4]*_Complex_I;
                        gsp [i*nd+2] = creal(coeff_c2s[24])*gcart[6*i+0]
                                     + creal(coeff_c2s[27])*gcart[6*i+3]
                                     + creal(coeff_c2s[29])*gcart[6*i+5];
                        gsp [i*nd+3] = creal(coeff_c2s[38])*gcart[6*i+2]
                                     - cimag(coeff_c2s[40])*gcart[6*i+4]*_Complex_I;
                        // spin-down part
                        gsp1[i*nd+0] = creal(coeff_c2s[8])*gcart[6*i+2]
                                     - cimag(coeff_c2s[10])*gcart[6*i+4]*_Complex_I;
                        gsp1[i*nd+1] = creal(coeff_c2s[18])*gcart[6*i+0]
                                     + creal(coeff_c2s[21])*gcart[6*i+3]
                                     + creal(coeff_c2s[23])*gcart[6*i+5];
                        gsp1[i*nd+2] = creal(coeff_c2s[32])*gcart[6*i+2]
                                     - cimag(coeff_c2s[34])*gcart[6*i+4]*_Complex_I;
                        gsp1[i*nd+3] = creal(coeff_c2s[42])*gcart[6*i+0]
                                     + creal(coeff_c2s[45])*gcart[6*i+3]
                                     - cimag(coeff_c2s[43])*gcart[6*i+1]*_Complex_I;
                }
                gsp  += 4;
                gsp1 += 4;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[2].cart2j_gt_l;
                for (i = 0; i < nket; i++) {
                        gsp [i*nd+0] = 0;
                        gsp [i*nd+1] = creal(coeff_c2s[12])*gcart[6*i+0]
                                     + creal(coeff_c2s[15])*gcart[6*i+3]
                                     - cimag(coeff_c2s[13])*gcart[6*i+1]*_Complex_I;
                        gsp [i*nd+2] = creal(coeff_c2s[26])*gcart[6*i+2]
                                     - cimag(coeff_c2s[28])*gcart[6*i+4]*_Complex_I;
                        gsp [i*nd+3] = creal(coeff_c2s[36])*gcart[6*i+0]
                                     + creal(coeff_c2s[39])*gcart[6*i+3]
                                     + creal(coeff_c2s[41])*gcart[6*i+5];
                        gsp [i*nd+4] = creal(coeff_c2s[50])*gcart[6*i+2]
                                     - cimag(coeff_c2s[52])*gcart[6*i+4]*_Complex_I;
                        gsp [i*nd+5] = creal(coeff_c2s[60])*gcart[6*i+0]
                                     + creal(coeff_c2s[63])*gcart[6*i+3]
                                     - cimag(coeff_c2s[61])*gcart[6*i+1]*_Complex_I;

                        gsp1[i*nd+0] = creal(coeff_c2s[6])*gcart[6*i+0]
                                     + creal(coeff_c2s[9])*gcart[6*i+3]
                                     - cimag(coeff_c2s[7])*gcart[6*i+1]*_Complex_I;
                        gsp1[i*nd+1] = creal(coeff_c2s[20])*gcart[6*i+2]
                                     - cimag(coeff_c2s[22])*gcart[6*i+4]*_Complex_I;
                        gsp1[i*nd+2] = creal(coeff_c2s[30])*gcart[6*i+0]
                                     + creal(coeff_c2s[33])*gcart[6*i+3]
                                     + creal(coeff_c2s[35])*gcart[6*i+5];
                        gsp1[i*nd+3] = creal(coeff_c2s[44])*gcart[6*i+2]
                                     - cimag(coeff_c2s[46])*gcart[6*i+4]*_Complex_I;
                        gsp1[i*nd+4] = creal(coeff_c2s[54])*gcart[6*i+0]
                                     + creal(coeff_c2s[57])*gcart[6*i+3]
                                     - cimag(coeff_c2s[55])*gcart[6*i+1]*_Complex_I;
                        gsp1[i*nd+5] = 0;
                }
        }
}
static void d_bra_cart2spinor_si(double complex *gsp, FINT nket,
                                 double complex *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT nd = _len_spinor(kappa, l);
        double complex *gcart1 = gcart + nket * 6;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[2].cart2j_lt_l;
                for (i = 0; i < nket; i++) {
                        // spin-up part
                        gsp[i*nd+0] = creal(coeff_c2s[0])*gcart[6*i+0]
                                    + creal(coeff_c2s[3])*gcart[6*i+3]
                                    - cimag(coeff_c2s[1])*gcart[6*i+1]*_Complex_I;
                        gsp[i*nd+1] = creal(coeff_c2s[14])*gcart[6*i+2]
                                    - cimag(coeff_c2s[16])*gcart[6*i+4]*_Complex_I;
                        gsp[i*nd+2] = creal(coeff_c2s[24])*gcart[6*i+0]
                                    + creal(coeff_c2s[27])*gcart[6*i+3]
                                    + creal(coeff_c2s[29])*gcart[6*i+5];
                        gsp[i*nd+3] = creal(coeff_c2s[38])*gcart[6*i+2]
                                    - cimag(coeff_c2s[40])*gcart[6*i+4]*_Complex_I;
                        // spin-down part
                        gsp[i*nd+0]+= creal(coeff_c2s[8])*gcart1[6*i+2]
                                    - cimag(coeff_c2s[10])*gcart1[6*i+4]*_Complex_I;
                        gsp[i*nd+1]+= creal(coeff_c2s[18])*gcart1[6*i+0]
                                    + creal(coeff_c2s[21])*gcart1[6*i+3]
                                    + creal(coeff_c2s[23])*gcart1[6*i+5];
                        gsp[i*nd+2]+= creal(coeff_c2s[32])*gcart1[6*i+2]
                                    - cimag(coeff_c2s[34])*gcart1[6*i+4]*_Complex_I;
                        gsp[i*nd+3]+= creal(coeff_c2s[42])*gcart1[6*i+0]
                                    + creal(coeff_c2s[45])*gcart1[6*i+3]
                                    - cimag(coeff_c2s[43])*gcart1[6*i+1]*_Complex_I;
                }
                gsp += 4;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[2].cart2j_gt_l;
                for (i = 0; i < nket; i++) {
                        gsp[i*nd+0] = 0;
                        gsp[i*nd+1] = creal(coeff_c2s[12])*gcart[6*i+0]
                                    + creal(coeff_c2s[15])*gcart[6*i+3]
                                    - cimag(coeff_c2s[13])*gcart[6*i+1]*_Complex_I;
                        gsp[i*nd+2] = creal(coeff_c2s[26])*gcart[6*i+2]
                                    - cimag(coeff_c2s[28])*gcart[6*i+4]*_Complex_I;
                        gsp[i*nd+3] = creal(coeff_c2s[36])*gcart[6*i+0]
                                    + creal(coeff_c2s[39])*gcart[6*i+3]
                                    + creal(coeff_c2s[41])*gcart[6*i+5];
                        gsp[i*nd+4] = creal(coeff_c2s[50])*gcart[6*i+2]
                                    - cimag(coeff_c2s[52])*gcart[6*i+4]*_Complex_I;
                        gsp[i*nd+5] = creal(coeff_c2s[60])*gcart[6*i+0]
                                    + creal(coeff_c2s[63])*gcart[6*i+3]
                                    - cimag(coeff_c2s[61])*gcart[6*i+1]*_Complex_I;

                        gsp[i*nd+0]+= creal(coeff_c2s[6])*gcart1[6*i+0]
                                    + creal(coeff_c2s[9])*gcart1[6*i+3]
                                    - cimag(coeff_c2s[7])*gcart1[6*i+1]*_Complex_I;
                        gsp[i*nd+1]+= creal(coeff_c2s[20])*gcart1[6*i+2]
                                    - cimag(coeff_c2s[22])*gcart1[6*i+4]*_Complex_I;
                        gsp[i*nd+2]+= creal(coeff_c2s[30])*gcart1[6*i+0]
                                    + creal(coeff_c2s[33])*gcart1[6*i+3]
                                    + creal(coeff_c2s[35])*gcart1[6*i+5];
                        gsp[i*nd+3]+= creal(coeff_c2s[44])*gcart1[6*i+2]
                                    - cimag(coeff_c2s[46])*gcart1[6*i+4]*_Complex_I;
                        gsp[i*nd+4]+= creal(coeff_c2s[54])*gcart1[6*i+0]
                                    + creal(coeff_c2s[57])*gcart1[6*i+3]
                                    - cimag(coeff_c2s[55])*gcart1[6*i+1]*_Complex_I;
                        gsp[i*nd+5]+= 0;
                }
        }
}
static void d_ket_cart2spinor(double complex *gsp, FINT nbra,
                              double complex *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[2].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gsp[0*nbra+i] = creal(coeff_c2s[0])*gcart[nbra* 0+i]
                                      + creal(coeff_c2s[3])*gcart[nbra* 3+i]
                                      + cimag(coeff_c2s[1])*gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[8])*gcart[nbra* 8+i]
                                      + cimag(coeff_c2s[10])*gcart[nbra*10+i]*_Complex_I;
                        gsp[1*nbra+i] = creal(coeff_c2s[14])*gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[16])*gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[18])*gcart[nbra* 6+i]
                                      + creal(coeff_c2s[21])*gcart[nbra* 9+i]
                                      + creal(coeff_c2s[23])*gcart[nbra*11+i];
                        gsp[2*nbra+i] = creal(coeff_c2s[24])*gcart[nbra* 0+i]
                                      + creal(coeff_c2s[27])*gcart[nbra* 3+i]
                                      + creal(coeff_c2s[29])*gcart[nbra* 5+i]
                                      + creal(coeff_c2s[32])*gcart[nbra* 8+i]
                                      + cimag(coeff_c2s[34])*gcart[nbra*10+i]*_Complex_I;
                        gsp[3*nbra+i] = creal(coeff_c2s[38])*gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[40])*gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[42])*gcart[nbra* 6+i]
                                      + creal(coeff_c2s[45])*gcart[nbra* 9+i]
                                      + cimag(coeff_c2s[43])*gcart[nbra* 7+i]*_Complex_I;
                }
                gsp += nbra * 4;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[2].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gsp[0*nbra+i] = creal(coeff_c2s[6])*gcart[nbra* 6+i]
                                      + creal(coeff_c2s[9])*gcart[nbra* 9+i]
                                      + cimag(coeff_c2s[7])*gcart[nbra* 7+i]*_Complex_I;
                        gsp[1*nbra+i] = creal(coeff_c2s[12])*gcart[nbra* 0+i]
                                      + creal(coeff_c2s[15])*gcart[nbra* 3+i]
                                      + cimag(coeff_c2s[13])*gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[20])*gcart[nbra* 8+i]
                                      + cimag(coeff_c2s[22])*gcart[nbra*10+i]*_Complex_I;
                        gsp[2*nbra+i] = creal(coeff_c2s[26])*gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[28])*gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[30])*gcart[nbra* 6+i]
                                      + creal(coeff_c2s[33])*gcart[nbra* 9+i]
                                      + creal(coeff_c2s[35])*gcart[nbra*11+i];
                        gsp[3*nbra+i] = creal(coeff_c2s[36])*gcart[nbra* 0+i]
                                      + creal(coeff_c2s[39])*gcart[nbra* 3+i]
                                      + creal(coeff_c2s[41])*gcart[nbra* 5+i]
                                      + creal(coeff_c2s[44])*gcart[nbra* 8+i]
                                      + cimag(coeff_c2s[46])*gcart[nbra*10+i]*_Complex_I;
                        gsp[4*nbra+i] = creal(coeff_c2s[50])*gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[52])*gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[54])*gcart[nbra* 6+i]
                                      + creal(coeff_c2s[57])*gcart[nbra* 9+i]
                                      + cimag(coeff_c2s[55])*gcart[nbra* 7+i]*_Complex_I;
                        gsp[5*nbra+i] = creal(coeff_c2s[60])*gcart[nbra* 0+i]
                                      + creal(coeff_c2s[63])*gcart[nbra* 3+i]
                                      + cimag(coeff_c2s[61])*gcart[nbra* 1+i]*_Complex_I;
                }
        }
}
static void d_iket_cart2spinor(double complex *gsp, FINT nbra,
                               double complex *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[2].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gsp[0*nbra+i] = creal(coeff_c2s[0])*gcart[nbra* 0+i]*_Complex_I
                                      + creal(coeff_c2s[3])*gcart[nbra* 3+i]*_Complex_I
                                      - cimag(coeff_c2s[1])*gcart[nbra* 1+i]
                                      + creal(coeff_c2s[8])*gcart[nbra* 8+i]*_Complex_I
                                      - cimag(coeff_c2s[10])*gcart[nbra*10+i];
                        gsp[1*nbra+i] = creal(coeff_c2s[14])*gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[16])*gcart[nbra* 4+i]
                                      + creal(coeff_c2s[18])*gcart[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[21])*gcart[nbra* 9+i]*_Complex_I
                                      + creal(coeff_c2s[23])*gcart[nbra*11+i]*_Complex_I;
                        gsp[2*nbra+i] = creal(coeff_c2s[24])*gcart[nbra* 0+i]*_Complex_I
                                      + creal(coeff_c2s[27])*gcart[nbra* 3+i]*_Complex_I
                                      + creal(coeff_c2s[29])*gcart[nbra* 5+i]*_Complex_I
                                      + creal(coeff_c2s[32])*gcart[nbra* 8+i]*_Complex_I
                                      - cimag(coeff_c2s[34])*gcart[nbra*10+i];
                        gsp[3*nbra+i] = creal(coeff_c2s[38])*gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[40])*gcart[nbra* 4+i]
                                      + creal(coeff_c2s[42])*gcart[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[45])*gcart[nbra* 9+i]*_Complex_I
                                      - cimag(coeff_c2s[43])*gcart[nbra* 7+i];
                }
                gsp += nbra * 4;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[2].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gsp[0*nbra+i] = creal(coeff_c2s[6])*gcart[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[9])*gcart[nbra* 9+i]*_Complex_I
                                      - cimag(coeff_c2s[7])*gcart[nbra* 7+i];
                        gsp[1*nbra+i] = creal(coeff_c2s[12])*gcart[nbra* 0+i]*_Complex_I
                                      + creal(coeff_c2s[15])*gcart[nbra* 3+i]*_Complex_I
                                      - cimag(coeff_c2s[13])*gcart[nbra* 1+i]
                                      + creal(coeff_c2s[20])*gcart[nbra* 8+i]*_Complex_I
                                      - cimag(coeff_c2s[22])*gcart[nbra*10+i];
                        gsp[2*nbra+i] = creal(coeff_c2s[26])*gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[28])*gcart[nbra* 4+i]
                                      + creal(coeff_c2s[30])*gcart[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[33])*gcart[nbra* 9+i]*_Complex_I
                                      + creal(coeff_c2s[35])*gcart[nbra*11+i]*_Complex_I;
                        gsp[3*nbra+i] = creal(coeff_c2s[36])*gcart[nbra* 0+i]*_Complex_I
                                      + creal(coeff_c2s[39])*gcart[nbra* 3+i]*_Complex_I
                                      + creal(coeff_c2s[41])*gcart[nbra* 5+i]*_Complex_I
                                      + creal(coeff_c2s[44])*gcart[nbra* 8+i]*_Complex_I
                                      - cimag(coeff_c2s[46])*gcart[nbra*10+i];
                        gsp[4*nbra+i] = creal(coeff_c2s[50])*gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[52])*gcart[nbra* 4+i]
                                      + creal(coeff_c2s[54])*gcart[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[57])*gcart[nbra* 9+i]*_Complex_I
                                      - cimag(coeff_c2s[55])*gcart[nbra* 7+i];
                        gsp[5*nbra+i] = creal(coeff_c2s[60])*gcart[nbra* 0+i]*_Complex_I
                                      + creal(coeff_c2s[63])*gcart[nbra* 3+i]*_Complex_I
                                      - cimag(coeff_c2s[61])*gcart[nbra* 1+i];
                }
        }
}

static void f_bra_cart2spinor_sf(double complex *gsp, FINT nket,
                                 double complex *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT nd = _len_spinor(kappa, l);
        double complex *gsp1 = gsp + nket * nd;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[3].cart2j_lt_l;
                for (i = 0; i < nket; i++) {
                        gsp [i*nd+0] = creal(coeff_c2s[0])*gcart[10*i+0]
                                     - cimag(coeff_c2s[1])*gcart[10*i+1]*_Complex_I
                                     + creal(coeff_c2s[3])*gcart[10*i+3]
                                     - cimag(coeff_c2s[6])*gcart[10*i+6]*_Complex_I;
                        gsp [i*nd+1] = creal(coeff_c2s[22])*gcart[10*i+2]
                                     - cimag(coeff_c2s[24])*gcart[10*i+4]*_Complex_I
                                     + creal(coeff_c2s[27])*gcart[10*i+7];
                        gsp [i*nd+2] = creal(coeff_c2s[40])*gcart[10*i+0]
                                     - cimag(coeff_c2s[41])*gcart[10*i+1]*_Complex_I
                                     + creal(coeff_c2s[43])*gcart[10*i+3]
                                     + creal(coeff_c2s[45])*gcart[10*i+5]
                                     - cimag(coeff_c2s[46])*gcart[10*i+6]*_Complex_I
                                     - cimag(coeff_c2s[48])*gcart[10*i+8]*_Complex_I;
                        gsp [i*nd+3] = creal(coeff_c2s[62])*gcart[10*i+2]
                                     + creal(coeff_c2s[67])*gcart[10*i+7]
                                     + creal(coeff_c2s[69])*gcart[10*i+9];
                        gsp [i*nd+4] = creal(coeff_c2s[80])*gcart[10*i+0]
                                     - cimag(coeff_c2s[81])*gcart[10*i+1]*_Complex_I
                                     + creal(coeff_c2s[83])*gcart[10*i+3]
                                     + creal(coeff_c2s[85])*gcart[10*i+5]
                                     - cimag(coeff_c2s[86])*gcart[10*i+6]*_Complex_I
                                     - cimag(coeff_c2s[88])*gcart[10*i+8]*_Complex_I;
                        gsp [i*nd+5] = creal(coeff_c2s[102])*gcart[10*i+2]
                                     - cimag(coeff_c2s[104])*gcart[10*i+4]*_Complex_I
                                     + creal(coeff_c2s[107])*gcart[10*i+7];

                        gsp1[i*nd+0] = creal(coeff_c2s[12])*gcart[10*i+2]
                                     - cimag(coeff_c2s[14])*gcart[10*i+4]*_Complex_I
                                     + creal(coeff_c2s[17])*gcart[10*i+7];
                        gsp1[i*nd+1] = creal(coeff_c2s[30])*gcart[10*i+0]
                                     - cimag(coeff_c2s[31])*gcart[10*i+1]*_Complex_I
                                     + creal(coeff_c2s[33])*gcart[10*i+3]
                                     + creal(coeff_c2s[35])*gcart[10*i+5]
                                     - cimag(coeff_c2s[36])*gcart[10*i+6]*_Complex_I
                                     - cimag(coeff_c2s[38])*gcart[10*i+8]*_Complex_I;
                        gsp1[i*nd+2] = creal(coeff_c2s[52])*gcart[10*i+2]
                                     + creal(coeff_c2s[57])*gcart[10*i+7]
                                     + creal(coeff_c2s[59])*gcart[10*i+9];
                        gsp1[i*nd+3] = creal(coeff_c2s[70])*gcart[10*i+0]
                                     - cimag(coeff_c2s[71])*gcart[10*i+1]*_Complex_I
                                     + creal(coeff_c2s[73])*gcart[10*i+3]
                                     + creal(coeff_c2s[75])*gcart[10*i+5]
                                     - cimag(coeff_c2s[76])*gcart[10*i+6]*_Complex_I
                                     - cimag(coeff_c2s[78])*gcart[10*i+8]*_Complex_I;
                        gsp1[i*nd+4] = creal(coeff_c2s[92])*gcart[10*i+2]
                                     - cimag(coeff_c2s[94])*gcart[10*i+4]*_Complex_I
                                     + creal(coeff_c2s[97])*gcart[10*i+7];
                        gsp1[i*nd+5] = creal(coeff_c2s[110])*gcart[10*i+0]
                                     - cimag(coeff_c2s[111])*gcart[10*i+1]*_Complex_I
                                     + creal(coeff_c2s[113])*gcart[10*i+3]
                                     - cimag(coeff_c2s[116])*gcart[10*i+6]*_Complex_I;
                }
                gsp  += 6;
                gsp1 += 6;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[3].cart2j_gt_l;
                for (i = 0; i < nket; i++) {
                        gsp [i*nd+0] = 0;
                        gsp [i*nd+1] = creal(coeff_c2s[20])*gcart[10*i+0]
                                     - cimag(coeff_c2s[21])*gcart[10*i+1]*_Complex_I
                                     + creal(coeff_c2s[23])*gcart[10*i+3]
                                     - cimag(coeff_c2s[26])*gcart[10*i+6]*_Complex_I;
                        gsp [i*nd+2] = creal(coeff_c2s[42])*gcart[10*i+2]
                                     - cimag(coeff_c2s[44])*gcart[10*i+4]*_Complex_I
                                     + creal(coeff_c2s[47])*gcart[10*i+7];
                        gsp [i*nd+3] = creal(coeff_c2s[60])*gcart[10*i+0]
                                     - cimag(coeff_c2s[61])*gcart[10*i+1]*_Complex_I
                                     + creal(coeff_c2s[63])*gcart[10*i+3]
                                     + creal(coeff_c2s[65])*gcart[10*i+5]
                                     - cimag(coeff_c2s[66])*gcart[10*i+6]*_Complex_I
                                     - cimag(coeff_c2s[68])*gcart[10*i+8]*_Complex_I;
                        gsp [i*nd+4] = creal(coeff_c2s[82])*gcart[10*i+2]
                                     + creal(coeff_c2s[87])*gcart[10*i+7]
                                     + creal(coeff_c2s[89])*gcart[10*i+9];
                        gsp [i*nd+5] = creal(coeff_c2s[100])*gcart[10*i+0]
                                     - cimag(coeff_c2s[101])*gcart[10*i+1]*_Complex_I
                                     + creal(coeff_c2s[103])*gcart[10*i+3]
                                     + creal(coeff_c2s[105])*gcart[10*i+5]
                                     - cimag(coeff_c2s[106])*gcart[10*i+6]*_Complex_I
                                     - cimag(coeff_c2s[108])*gcart[10*i+8]*_Complex_I;
                        gsp [i*nd+6] = creal(coeff_c2s[122])*gcart[10*i+2]
                                     - cimag(coeff_c2s[124])*gcart[10*i+4]*_Complex_I
                                     + creal(coeff_c2s[127])*gcart[10*i+7];
                        gsp [i*nd+7] = creal(coeff_c2s[140])*gcart[10*i+0]
                                     - cimag(coeff_c2s[141])*gcart[10*i+1]*_Complex_I
                                     + creal(coeff_c2s[143])*gcart[10*i+3]
                                     - cimag(coeff_c2s[146])*gcart[10*i+6]*_Complex_I;

                        gsp1[i*nd+0] = creal(coeff_c2s[10])*gcart[10*i+0]
                                     - cimag(coeff_c2s[11])*gcart[10*i+1]*_Complex_I
                                     + creal(coeff_c2s[13])*gcart[10*i+3]
                                     - cimag(coeff_c2s[16])*gcart[10*i+6]*_Complex_I;
                        gsp1[i*nd+1] = creal(coeff_c2s[32])*gcart[10*i+2]
                                     - cimag(coeff_c2s[34])*gcart[10*i+4]*_Complex_I
                                     + creal(coeff_c2s[37])*gcart[10*i+7];
                        gsp1[i*nd+2] = creal(coeff_c2s[50])*gcart[10*i+0]
                                     - cimag(coeff_c2s[51])*gcart[10*i+1]*_Complex_I
                                     + creal(coeff_c2s[53])*gcart[10*i+3]
                                     + creal(coeff_c2s[55])*gcart[10*i+5]
                                     - cimag(coeff_c2s[56])*gcart[10*i+6]*_Complex_I
                                     - cimag(coeff_c2s[58])*gcart[10*i+8]*_Complex_I;
                        gsp1[i*nd+3] = creal(coeff_c2s[72])*gcart[10*i+2]
                                     + creal(coeff_c2s[77])*gcart[10*i+7]
                                     + creal(coeff_c2s[79])*gcart[10*i+9];
                        gsp1[i*nd+4] = creal(coeff_c2s[90])*gcart[10*i+0]
                                     - cimag(coeff_c2s[91])*gcart[10*i+1]*_Complex_I
                                     + creal(coeff_c2s[93])*gcart[10*i+3]
                                     + creal(coeff_c2s[95])*gcart[10*i+5]
                                     - cimag(coeff_c2s[96])*gcart[10*i+6]*_Complex_I
                                     - cimag(coeff_c2s[98])*gcart[10*i+8]*_Complex_I;
                        gsp1[i*nd+5] = creal(coeff_c2s[112])*gcart[10*i+2]
                                     - cimag(coeff_c2s[114])*gcart[10*i+4]*_Complex_I
                                     + creal(coeff_c2s[117])*gcart[10*i+7];
                        gsp1[i*nd+6] = creal(coeff_c2s[130])*gcart[10*i+0]
                                     - cimag(coeff_c2s[131])*gcart[10*i+1]*_Complex_I
                                     + creal(coeff_c2s[133])*gcart[10*i+3]
                                     - cimag(coeff_c2s[136])*gcart[10*i+6]*_Complex_I;
                        gsp1[i*nd+7] = 0;
                }
        }
}
static void f_bra_cart2spinor_e1sf(double complex *gsp, FINT nket,
                                   double *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT nd = _len_spinor(kappa, l);
        double complex *gsp1 = gsp + nket * nd;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[3].cart2j_lt_l;
                for (i = 0; i < nket; i++) {
                        gsp [i*nd+0] = creal(coeff_c2s[0])*gcart[10*i+0]
                                     + creal(coeff_c2s[3])*gcart[10*i+3]
                                     - cimag(coeff_c2s[1])*gcart[10*i+1]*_Complex_I
                                     - cimag(coeff_c2s[6])*gcart[10*i+6]*_Complex_I;
                        gsp [i*nd+1] = creal(coeff_c2s[22])*gcart[10*i+2]
                                     + creal(coeff_c2s[27])*gcart[10*i+7]
                                     - cimag(coeff_c2s[24])*gcart[10*i+4]*_Complex_I;
                        gsp [i*nd+2] = creal(coeff_c2s[40])*gcart[10*i+0]
                                     + creal(coeff_c2s[43])*gcart[10*i+3]
                                     + creal(coeff_c2s[45])*gcart[10*i+5]
                                     - cimag(coeff_c2s[41])*gcart[10*i+1]*_Complex_I
                                     - cimag(coeff_c2s[46])*gcart[10*i+6]*_Complex_I
                                     - cimag(coeff_c2s[48])*gcart[10*i+8]*_Complex_I;
                        gsp [i*nd+3] = creal(coeff_c2s[62])*gcart[10*i+2]
                                     + creal(coeff_c2s[67])*gcart[10*i+7]
                                     + creal(coeff_c2s[69])*gcart[10*i+9];
                        gsp [i*nd+4] = creal(coeff_c2s[80])*gcart[10*i+0]
                                     + creal(coeff_c2s[83])*gcart[10*i+3]
                                     + creal(coeff_c2s[85])*gcart[10*i+5]
                                     - cimag(coeff_c2s[81])*gcart[10*i+1]*_Complex_I
                                     - cimag(coeff_c2s[86])*gcart[10*i+6]*_Complex_I
                                     - cimag(coeff_c2s[88])*gcart[10*i+8]*_Complex_I;
                        gsp [i*nd+5] = creal(coeff_c2s[102])*gcart[10*i+2]
                                     + creal(coeff_c2s[107])*gcart[10*i+7]
                                     - cimag(coeff_c2s[104])*gcart[10*i+4]*_Complex_I;

                        gsp1[i*nd+0] = creal(coeff_c2s[12])*gcart[10*i+2]
                                     + creal(coeff_c2s[17])*gcart[10*i+7]
                                     - cimag(coeff_c2s[14])*gcart[10*i+4]*_Complex_I;
                        gsp1[i*nd+1] = creal(coeff_c2s[30])*gcart[10*i+0]
                                     + creal(coeff_c2s[33])*gcart[10*i+3]
                                     + creal(coeff_c2s[35])*gcart[10*i+5]
                                     - cimag(coeff_c2s[31])*gcart[10*i+1]*_Complex_I
                                     - cimag(coeff_c2s[36])*gcart[10*i+6]*_Complex_I
                                     - cimag(coeff_c2s[38])*gcart[10*i+8]*_Complex_I;
                        gsp1[i*nd+2] = creal(coeff_c2s[52])*gcart[10*i+2]
                                     + creal(coeff_c2s[57])*gcart[10*i+7]
                                     + creal(coeff_c2s[59])*gcart[10*i+9];
                        gsp1[i*nd+3] = creal(coeff_c2s[70])*gcart[10*i+0]
                                     + creal(coeff_c2s[73])*gcart[10*i+3]
                                     + creal(coeff_c2s[75])*gcart[10*i+5]
                                     - cimag(coeff_c2s[71])*gcart[10*i+1]*_Complex_I
                                     - cimag(coeff_c2s[76])*gcart[10*i+6]*_Complex_I
                                     - cimag(coeff_c2s[78])*gcart[10*i+8]*_Complex_I;
                        gsp1[i*nd+4] = creal(coeff_c2s[92])*gcart[10*i+2]
                                     + creal(coeff_c2s[97])*gcart[10*i+7]
                                     - cimag(coeff_c2s[94])*gcart[10*i+4]*_Complex_I;
                        gsp1[i*nd+5] = creal(coeff_c2s[110])*gcart[10*i+0]
                                     + creal(coeff_c2s[113])*gcart[10*i+3]
                                     - cimag(coeff_c2s[111])*gcart[10*i+1]*_Complex_I
                                     - cimag(coeff_c2s[116])*gcart[10*i+6]*_Complex_I;
                }
                gsp  += 6;
                gsp1 += 6;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[3].cart2j_gt_l;
                for (i = 0; i < nket; i++) {
                        gsp [i*nd+0] = 0;
                        gsp [i*nd+1] = creal(coeff_c2s[20])*gcart[10*i+0]
                                     + creal(coeff_c2s[23])*gcart[10*i+3]
                                     - cimag(coeff_c2s[21])*gcart[10*i+1]*_Complex_I
                                     - cimag(coeff_c2s[26])*gcart[10*i+6]*_Complex_I;
                        gsp [i*nd+2] = creal(coeff_c2s[42])*gcart[10*i+2]
                                     + creal(coeff_c2s[47])*gcart[10*i+7]
                                     - cimag(coeff_c2s[44])*gcart[10*i+4]*_Complex_I;
                        gsp [i*nd+3] = creal(coeff_c2s[60])*gcart[10*i+0]
                                     + creal(coeff_c2s[63])*gcart[10*i+3]
                                     + creal(coeff_c2s[65])*gcart[10*i+5]
                                     - cimag(coeff_c2s[61])*gcart[10*i+1]*_Complex_I
                                     - cimag(coeff_c2s[66])*gcart[10*i+6]*_Complex_I
                                     - cimag(coeff_c2s[68])*gcart[10*i+8]*_Complex_I;
                        gsp [i*nd+4] = creal(coeff_c2s[82])*gcart[10*i+2]
                                     + creal(coeff_c2s[87])*gcart[10*i+7]
                                     + creal(coeff_c2s[89])*gcart[10*i+9];
                        gsp [i*nd+5] = creal(coeff_c2s[100])*gcart[10*i+0]
                                     + creal(coeff_c2s[103])*gcart[10*i+3]
                                     + creal(coeff_c2s[105])*gcart[10*i+5]
                                     - cimag(coeff_c2s[101])*gcart[10*i+1]*_Complex_I
                                     - cimag(coeff_c2s[106])*gcart[10*i+6]*_Complex_I
                                     - cimag(coeff_c2s[108])*gcart[10*i+8]*_Complex_I;
                        gsp [i*nd+6] = creal(coeff_c2s[122])*gcart[10*i+2]
                                     + creal(coeff_c2s[127])*gcart[10*i+7]
                                     - cimag(coeff_c2s[124])*gcart[10*i+4]*_Complex_I;
                        gsp [i*nd+7] = creal(coeff_c2s[140])*gcart[10*i+0]
                                     + creal(coeff_c2s[143])*gcart[10*i+3]
                                     - cimag(coeff_c2s[141])*gcart[10*i+1]*_Complex_I
                                     - cimag(coeff_c2s[146])*gcart[10*i+6]*_Complex_I;

                        gsp1[i*nd+0] = creal(coeff_c2s[10])*gcart[10*i+0]
                                     + creal(coeff_c2s[13])*gcart[10*i+3]
                                     - cimag(coeff_c2s[11])*gcart[10*i+1]*_Complex_I
                                     - cimag(coeff_c2s[16])*gcart[10*i+6]*_Complex_I;
                        gsp1[i*nd+1] = creal(coeff_c2s[32])*gcart[10*i+2]
                                     + creal(coeff_c2s[37])*gcart[10*i+7]
                                     - cimag(coeff_c2s[34])*gcart[10*i+4]*_Complex_I;
                        gsp1[i*nd+2] = creal(coeff_c2s[50])*gcart[10*i+0]
                                     + creal(coeff_c2s[53])*gcart[10*i+3]
                                     + creal(coeff_c2s[55])*gcart[10*i+5]
                                     - cimag(coeff_c2s[51])*gcart[10*i+1]*_Complex_I
                                     - cimag(coeff_c2s[56])*gcart[10*i+6]*_Complex_I
                                     - cimag(coeff_c2s[58])*gcart[10*i+8]*_Complex_I;
                        gsp1[i*nd+3] = creal(coeff_c2s[72])*gcart[10*i+2]
                                     + creal(coeff_c2s[77])*gcart[10*i+7]
                                     + creal(coeff_c2s[79])*gcart[10*i+9];
                        gsp1[i*nd+4] = creal(coeff_c2s[90])*gcart[10*i+0]
                                     + creal(coeff_c2s[93])*gcart[10*i+3]
                                     + creal(coeff_c2s[95])*gcart[10*i+5]
                                     - cimag(coeff_c2s[91])*gcart[10*i+1]*_Complex_I
                                     - cimag(coeff_c2s[96])*gcart[10*i+6]*_Complex_I
                                     - cimag(coeff_c2s[98])*gcart[10*i+8]*_Complex_I;
                        gsp1[i*nd+5] = creal(coeff_c2s[112])*gcart[10*i+2]
                                     + creal(coeff_c2s[117])*gcart[10*i+7]
                                     - cimag(coeff_c2s[114])*gcart[10*i+4]*_Complex_I;
                        gsp1[i*nd+6] = creal(coeff_c2s[130])*gcart[10*i+0]
                                     + creal(coeff_c2s[133])*gcart[10*i+3]
                                     - cimag(coeff_c2s[131])*gcart[10*i+1]*_Complex_I
                                     - cimag(coeff_c2s[136])*gcart[10*i+6]*_Complex_I;
                        gsp1[i*nd+7] = 0;
                }
        }
}
static void f_bra_cart2spinor_si(double complex *gsp, FINT nket,
                                 double complex *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT nd = _len_spinor(kappa, l);
        double complex *gcart1 = gcart + nket * 10;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[3].cart2j_lt_l;
                for (i = 0; i < nket; i++) {
                        gsp[i*nd+0] = creal(coeff_c2s[0])*gcart[10*i+0]
                                    - cimag(coeff_c2s[1])*gcart[10*i+1]*_Complex_I
                                    + creal(coeff_c2s[3])*gcart[10*i+3]
                                    - cimag(coeff_c2s[6])*gcart[10*i+6]*_Complex_I;
                        gsp[i*nd+1] = creal(coeff_c2s[22])*gcart[10*i+2]
                                    - cimag(coeff_c2s[24])*gcart[10*i+4]*_Complex_I
                                    + creal(coeff_c2s[27])*gcart[10*i+7];
                        gsp[i*nd+2] = creal(coeff_c2s[40])*gcart[10*i+0]
                                    - cimag(coeff_c2s[41])*gcart[10*i+1]*_Complex_I
                                    + creal(coeff_c2s[43])*gcart[10*i+3]
                                    + creal(coeff_c2s[45])*gcart[10*i+5]
                                    - cimag(coeff_c2s[46])*gcart[10*i+6]*_Complex_I
                                    - cimag(coeff_c2s[48])*gcart[10*i+8]*_Complex_I;
                        gsp[i*nd+3] = creal(coeff_c2s[62])*gcart[10*i+2]
                                    + creal(coeff_c2s[67])*gcart[10*i+7]
                                    + creal(coeff_c2s[69])*gcart[10*i+9];
                        gsp[i*nd+4] = creal(coeff_c2s[80])*gcart[10*i+0]
                                    - cimag(coeff_c2s[81])*gcart[10*i+1]*_Complex_I
                                    + creal(coeff_c2s[83])*gcart[10*i+3]
                                    + creal(coeff_c2s[85])*gcart[10*i+5]
                                    - cimag(coeff_c2s[86])*gcart[10*i+6]*_Complex_I
                                    - cimag(coeff_c2s[88])*gcart[10*i+8]*_Complex_I;
                        gsp[i*nd+5] = creal(coeff_c2s[102])*gcart[10*i+2]
                                    - cimag(coeff_c2s[104])*gcart[10*i+4]*_Complex_I
                                    + creal(coeff_c2s[107])*gcart[10*i+7];
                }
                for (i = 0; i < nket; i++) {
                        gsp[i*nd+0]+= creal(coeff_c2s[12])*gcart1[10*i+2]
                                    - cimag(coeff_c2s[14])*gcart1[10*i+4]*_Complex_I
                                    + creal(coeff_c2s[17])*gcart1[10*i+7];
                        gsp[i*nd+1]+= creal(coeff_c2s[30])*gcart1[10*i+0]
                                    - cimag(coeff_c2s[31])*gcart1[10*i+1]*_Complex_I
                                    + creal(coeff_c2s[33])*gcart1[10*i+3]
                                    + creal(coeff_c2s[35])*gcart1[10*i+5]
                                    - cimag(coeff_c2s[36])*gcart1[10*i+6]*_Complex_I
                                    - cimag(coeff_c2s[38])*gcart1[10*i+8]*_Complex_I;
                        gsp[i*nd+2]+= creal(coeff_c2s[52])*gcart1[10*i+2]
                                    + creal(coeff_c2s[57])*gcart1[10*i+7]
                                    + creal(coeff_c2s[59])*gcart1[10*i+9];
                        gsp[i*nd+3]+= creal(coeff_c2s[70])*gcart1[10*i+0]
                                    - cimag(coeff_c2s[71])*gcart1[10*i+1]*_Complex_I
                                    + creal(coeff_c2s[73])*gcart1[10*i+3]
                                    + creal(coeff_c2s[75])*gcart1[10*i+5]
                                    - cimag(coeff_c2s[76])*gcart1[10*i+6]*_Complex_I
                                    - cimag(coeff_c2s[78])*gcart1[10*i+8]*_Complex_I;
                        gsp[i*nd+4]+= creal(coeff_c2s[92])*gcart1[10*i+2]
                                    - cimag(coeff_c2s[94])*gcart1[10*i+4]*_Complex_I
                                    + creal(coeff_c2s[97])*gcart1[10*i+7];
                        gsp[i*nd+5]+= creal(coeff_c2s[110])*gcart1[10*i+0]
                                    - cimag(coeff_c2s[111])*gcart1[10*i+1]*_Complex_I
                                    + creal(coeff_c2s[113])*gcart1[10*i+3]
                                    - cimag(coeff_c2s[116])*gcart1[10*i+6]*_Complex_I;
                }
                gsp += 6;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[3].cart2j_gt_l;
                for (i = 0; i < nket; i++) {
                        gsp[i*nd+0] = 0;
                        gsp[i*nd+1] = creal(coeff_c2s[20])*gcart[10*i+0]
                                    - cimag(coeff_c2s[21])*gcart[10*i+1]*_Complex_I
                                    + creal(coeff_c2s[23])*gcart[10*i+3]
                                    - cimag(coeff_c2s[26])*gcart[10*i+6]*_Complex_I;
                        gsp[i*nd+2] = creal(coeff_c2s[42])*gcart[10*i+2]
                                    - cimag(coeff_c2s[44])*gcart[10*i+4]*_Complex_I
                                    + creal(coeff_c2s[47])*gcart[10*i+7];
                        gsp[i*nd+3] = creal(coeff_c2s[60])*gcart[10*i+0]
                                    - cimag(coeff_c2s[61])*gcart[10*i+1]*_Complex_I
                                    + creal(coeff_c2s[63])*gcart[10*i+3]
                                    + creal(coeff_c2s[65])*gcart[10*i+5]
                                    - cimag(coeff_c2s[66])*gcart[10*i+6]*_Complex_I
                                    - cimag(coeff_c2s[68])*gcart[10*i+8]*_Complex_I;
                        gsp[i*nd+4] = creal(coeff_c2s[82])*gcart[10*i+2]
                                    + creal(coeff_c2s[87])*gcart[10*i+7]
                                    + creal(coeff_c2s[89])*gcart[10*i+9];
                        gsp[i*nd+5] = creal(coeff_c2s[100])*gcart[10*i+0]
                                    - cimag(coeff_c2s[101])*gcart[10*i+1]*_Complex_I
                                    + creal(coeff_c2s[103])*gcart[10*i+3]
                                    + creal(coeff_c2s[105])*gcart[10*i+5]
                                    - cimag(coeff_c2s[106])*gcart[10*i+6]*_Complex_I
                                    - cimag(coeff_c2s[108])*gcart[10*i+8]*_Complex_I;
                        gsp[i*nd+6] = creal(coeff_c2s[122])*gcart[10*i+2]
                                    - cimag(coeff_c2s[124])*gcart[10*i+4]*_Complex_I
                                    + creal(coeff_c2s[127])*gcart[10*i+7];
                        gsp[i*nd+7] = creal(coeff_c2s[140])*gcart[10*i+0]
                                    - cimag(coeff_c2s[141])*gcart[10*i+1]*_Complex_I
                                    + creal(coeff_c2s[143])*gcart[10*i+3]
                                    - cimag(coeff_c2s[146])*gcart[10*i+6]*_Complex_I;
                }
                for (i = 0; i < nket; i++) {
                        gsp[i*nd+0]+= creal(coeff_c2s[10])*gcart1[10*i+0]
                                    - cimag(coeff_c2s[11])*gcart1[10*i+1]*_Complex_I
                                    + creal(coeff_c2s[13])*gcart1[10*i+3]
                                    - cimag(coeff_c2s[16])*gcart1[10*i+6]*_Complex_I;
                        gsp[i*nd+1]+= creal(coeff_c2s[32])*gcart1[10*i+2]
                                    - cimag(coeff_c2s[34])*gcart1[10*i+4]*_Complex_I
                                    + creal(coeff_c2s[37])*gcart1[10*i+7];
                        gsp[i*nd+2]+= creal(coeff_c2s[50])*gcart1[10*i+0]
                                    - cimag(coeff_c2s[51])*gcart1[10*i+1]*_Complex_I
                                    + creal(coeff_c2s[53])*gcart1[10*i+3]
                                    + creal(coeff_c2s[55])*gcart1[10*i+5]
                                    - cimag(coeff_c2s[56])*gcart1[10*i+6]*_Complex_I
                                    - cimag(coeff_c2s[58])*gcart1[10*i+8]*_Complex_I;
                        gsp[i*nd+3]+= creal(coeff_c2s[72])*gcart1[10*i+2]
                                    + creal(coeff_c2s[77])*gcart1[10*i+7]
                                    + creal(coeff_c2s[79])*gcart1[10*i+9];
                        gsp[i*nd+4]+= creal(coeff_c2s[90])*gcart1[10*i+0]
                                    - cimag(coeff_c2s[91])*gcart1[10*i+1]*_Complex_I
                                    + creal(coeff_c2s[93])*gcart1[10*i+3]
                                    + creal(coeff_c2s[95])*gcart1[10*i+5]
                                    - cimag(coeff_c2s[96])*gcart1[10*i+6]*_Complex_I
                                    - cimag(coeff_c2s[98])*gcart1[10*i+8]*_Complex_I;
                        gsp[i*nd+5]+= creal(coeff_c2s[112])*gcart1[10*i+2]
                                    - cimag(coeff_c2s[114])*gcart1[10*i+4]*_Complex_I
                                    + creal(coeff_c2s[117])*gcart1[10*i+7];
                        gsp[i*nd+6]+= creal(coeff_c2s[130])*gcart1[10*i+0]
                                    - cimag(coeff_c2s[131])*gcart1[10*i+1]*_Complex_I
                                    + creal(coeff_c2s[133])*gcart1[10*i+3]
                                    - cimag(coeff_c2s[136])*gcart1[10*i+6]*_Complex_I;
                        gsp[i*nd+7]+= 0;
                }
        }
}
static void f_ket_cart2spinor(double complex *gsp, FINT nbra,
                              double complex *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[3].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gsp[0*nbra+i] = creal(coeff_c2s[0])*gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[1])*gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[3])*gcart[nbra* 3+i]
                                      + cimag(coeff_c2s[6])*gcart[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[12])*gcart[nbra*12+i]
                                      + cimag(coeff_c2s[14])*gcart[nbra*14+i]*_Complex_I
                                      + creal(coeff_c2s[17])*gcart[nbra*17+i];
                        gsp[1*nbra+i] = creal(coeff_c2s[22])*gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[24])*gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[27])*gcart[nbra* 7+i]
                                      + creal(coeff_c2s[30])*gcart[nbra*10+i]
                                      + cimag(coeff_c2s[31])*gcart[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[33])*gcart[nbra*13+i]
                                      + creal(coeff_c2s[35])*gcart[nbra*15+i]
                                      + cimag(coeff_c2s[36])*gcart[nbra*16+i]*_Complex_I
                                      + cimag(coeff_c2s[38])*gcart[nbra*18+i]*_Complex_I;
                        gsp[2*nbra+i] = creal(coeff_c2s[40])*gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[41])*gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[43])*gcart[nbra* 3+i]
                                      + creal(coeff_c2s[45])*gcart[nbra* 5+i]
                                      + cimag(coeff_c2s[46])*gcart[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[48])*gcart[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[52])*gcart[nbra*12+i]
                                      + creal(coeff_c2s[57])*gcart[nbra*17+i]
                                      + creal(coeff_c2s[59])*gcart[nbra*19+i];
                        gsp[3*nbra+i] = creal(coeff_c2s[62])*gcart[nbra* 2+i]
                                      + creal(coeff_c2s[67])*gcart[nbra* 7+i]
                                      + creal(coeff_c2s[69])*gcart[nbra* 9+i]
                                      + creal(coeff_c2s[70])*gcart[nbra*10+i]
                                      + cimag(coeff_c2s[71])*gcart[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[73])*gcart[nbra*13+i]
                                      + creal(coeff_c2s[75])*gcart[nbra*15+i]
                                      + cimag(coeff_c2s[76])*gcart[nbra*16+i]*_Complex_I
                                      + cimag(coeff_c2s[78])*gcart[nbra*18+i]*_Complex_I;
                        gsp[4*nbra+i] = creal(coeff_c2s[80])*gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[81])*gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[83])*gcart[nbra* 3+i]
                                      + creal(coeff_c2s[85])*gcart[nbra* 5+i]
                                      + cimag(coeff_c2s[86])*gcart[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[88])*gcart[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[92])*gcart[nbra*12+i]
                                      + cimag(coeff_c2s[94])*gcart[nbra*14+i]*_Complex_I
                                      + creal(coeff_c2s[97])*gcart[nbra*17+i];
                        gsp[5*nbra+i] = creal(coeff_c2s[102])*gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[104])*gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[107])*gcart[nbra* 7+i]
                                      + creal(coeff_c2s[110])*gcart[nbra*10+i]
                                      + cimag(coeff_c2s[111])*gcart[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[113])*gcart[nbra*13+i]
                                      + cimag(coeff_c2s[116])*gcart[nbra*16+i]*_Complex_I;
                }
                gsp += nbra * 6;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[3].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gsp[0*nbra+i] = creal(coeff_c2s[10])*gcart[nbra*10+i]
                                      + cimag(coeff_c2s[11])*gcart[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[13])*gcart[nbra*13+i]
                                      + cimag(coeff_c2s[16])*gcart[nbra*16+i]*_Complex_I;
                        gsp[1*nbra+i] = creal(coeff_c2s[20])*gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[21])*gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[23])*gcart[nbra* 3+i]
                                      + cimag(coeff_c2s[26])*gcart[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[32])*gcart[nbra*12+i]
                                      + cimag(coeff_c2s[34])*gcart[nbra*14+i]*_Complex_I
                                      + creal(coeff_c2s[37])*gcart[nbra*17+i];
                        gsp[2*nbra+i] = creal(coeff_c2s[42])*gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[44])*gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[47])*gcart[nbra* 7+i]
                                      + creal(coeff_c2s[50])*gcart[nbra*10+i]
                                      + cimag(coeff_c2s[51])*gcart[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[53])*gcart[nbra*13+i]
                                      + creal(coeff_c2s[55])*gcart[nbra*15+i]
                                      + cimag(coeff_c2s[56])*gcart[nbra*16+i]*_Complex_I
                                      + cimag(coeff_c2s[58])*gcart[nbra*18+i]*_Complex_I;
                        gsp[3*nbra+i] = creal(coeff_c2s[60])*gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[61])*gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[63])*gcart[nbra* 3+i]
                                      + creal(coeff_c2s[65])*gcart[nbra* 5+i]
                                      + cimag(coeff_c2s[66])*gcart[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[68])*gcart[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[72])*gcart[nbra*12+i]
                                      + creal(coeff_c2s[77])*gcart[nbra*17+i]
                                      + creal(coeff_c2s[79])*gcart[nbra*19+i];
                        gsp[4*nbra+i] = creal(coeff_c2s[82])*gcart[nbra* 2+i]
                                      + creal(coeff_c2s[87])*gcart[nbra* 7+i]
                                      + creal(coeff_c2s[89])*gcart[nbra* 9+i]
                                      + creal(coeff_c2s[90])*gcart[nbra*10+i]
                                      + cimag(coeff_c2s[91])*gcart[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[93])*gcart[nbra*13+i]
                                      + creal(coeff_c2s[95])*gcart[nbra*15+i]
                                      + cimag(coeff_c2s[96])*gcart[nbra*16+i]*_Complex_I
                                      + cimag(coeff_c2s[98])*gcart[nbra*18+i]*_Complex_I;
                        gsp[5*nbra+i] = creal(coeff_c2s[100])*gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[101])*gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[103])*gcart[nbra* 3+i]
                                      + creal(coeff_c2s[105])*gcart[nbra* 5+i]
                                      + cimag(coeff_c2s[106])*gcart[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[108])*gcart[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[112])*gcart[nbra*12+i]
                                      + cimag(coeff_c2s[114])*gcart[nbra*14+i]*_Complex_I
                                      + creal(coeff_c2s[117])*gcart[nbra*17+i];
                        gsp[6*nbra+i] = creal(coeff_c2s[122])*gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[124])*gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[127])*gcart[nbra* 7+i]
                                      + creal(coeff_c2s[130])*gcart[nbra*10+i]
                                      + cimag(coeff_c2s[131])*gcart[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[133])*gcart[nbra*13+i]
                                      + cimag(coeff_c2s[136])*gcart[nbra*16+i]*_Complex_I;
                        gsp[7*nbra+i] = creal(coeff_c2s[140])*gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[141])*gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[143])*gcart[nbra* 3+i]
                                      + cimag(coeff_c2s[146])*gcart[nbra* 6+i]*_Complex_I;
                }
        }
}
static void f_iket_cart2spinor(double complex *gsp, FINT nbra,
                               double complex *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[3].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gsp[0*nbra+i] = creal(coeff_c2s[0])*gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[1])*gcart[nbra* 1+i]
                                      + creal(coeff_c2s[3])*gcart[nbra* 3+i]*_Complex_I
                                      - cimag(coeff_c2s[6])*gcart[nbra* 6+i]
                                      + creal(coeff_c2s[12])*gcart[nbra*12+i]*_Complex_I
                                      - cimag(coeff_c2s[14])*gcart[nbra*14+i]
                                      + creal(coeff_c2s[17])*gcart[nbra*17+i]*_Complex_I;
                        gsp[1*nbra+i] = creal(coeff_c2s[22])*gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[24])*gcart[nbra* 4+i]
                                      + creal(coeff_c2s[27])*gcart[nbra* 7+i]*_Complex_I
                                      + creal(coeff_c2s[30])*gcart[nbra*10+i]*_Complex_I
                                      - cimag(coeff_c2s[31])*gcart[nbra*11+i]
                                      + creal(coeff_c2s[33])*gcart[nbra*13+i]*_Complex_I
                                      + creal(coeff_c2s[35])*gcart[nbra*15+i]*_Complex_I
                                      - cimag(coeff_c2s[36])*gcart[nbra*16+i]
                                      - cimag(coeff_c2s[38])*gcart[nbra*18+i];
                        gsp[2*nbra+i] = creal(coeff_c2s[40])*gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[41])*gcart[nbra* 1+i]
                                      + creal(coeff_c2s[43])*gcart[nbra* 3+i]*_Complex_I
                                      + creal(coeff_c2s[45])*gcart[nbra* 5+i]*_Complex_I
                                      - cimag(coeff_c2s[46])*gcart[nbra* 6+i]
                                      - cimag(coeff_c2s[48])*gcart[nbra* 8+i]
                                      + creal(coeff_c2s[52])*gcart[nbra*12+i]*_Complex_I
                                      + creal(coeff_c2s[57])*gcart[nbra*17+i]*_Complex_I
                                      + creal(coeff_c2s[59])*gcart[nbra*19+i]*_Complex_I;
                        gsp[3*nbra+i] = creal(coeff_c2s[62])*gcart[nbra* 2+i]*_Complex_I
                                      + creal(coeff_c2s[67])*gcart[nbra* 7+i]*_Complex_I
                                      + creal(coeff_c2s[69])*gcart[nbra* 9+i]*_Complex_I
                                      + creal(coeff_c2s[70])*gcart[nbra*10+i]*_Complex_I
                                      - cimag(coeff_c2s[71])*gcart[nbra*11+i]
                                      + creal(coeff_c2s[73])*gcart[nbra*13+i]*_Complex_I
                                      + creal(coeff_c2s[75])*gcart[nbra*15+i]*_Complex_I
                                      - cimag(coeff_c2s[76])*gcart[nbra*16+i]
                                      - cimag(coeff_c2s[78])*gcart[nbra*18+i];
                        gsp[4*nbra+i] = creal(coeff_c2s[80])*gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[81])*gcart[nbra* 1+i]
                                      + creal(coeff_c2s[83])*gcart[nbra* 3+i]*_Complex_I
                                      + creal(coeff_c2s[85])*gcart[nbra* 5+i]*_Complex_I
                                      - cimag(coeff_c2s[86])*gcart[nbra* 6+i]
                                      - cimag(coeff_c2s[88])*gcart[nbra* 8+i]
                                      + creal(coeff_c2s[92])*gcart[nbra*12+i]*_Complex_I
                                      - cimag(coeff_c2s[94])*gcart[nbra*14+i]
                                      + creal(coeff_c2s[97])*gcart[nbra*17+i]*_Complex_I;
                        gsp[5*nbra+i] = creal(coeff_c2s[102])*gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[104])*gcart[nbra* 4+i]
                                      + creal(coeff_c2s[107])*gcart[nbra* 7+i]*_Complex_I
                                      + creal(coeff_c2s[110])*gcart[nbra*10+i]*_Complex_I
                                      - cimag(coeff_c2s[111])*gcart[nbra*11+i]
                                      + creal(coeff_c2s[113])*gcart[nbra*13+i]*_Complex_I
                                      - cimag(coeff_c2s[116])*gcart[nbra*16+i];
                }
                gsp += nbra * 6;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[3].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gsp[0*nbra+i] = creal(coeff_c2s[10])*gcart[nbra*10+i]*_Complex_I
                                      - cimag(coeff_c2s[11])*gcart[nbra*11+i]
                                      + creal(coeff_c2s[13])*gcart[nbra*13+i]*_Complex_I
                                      - cimag(coeff_c2s[16])*gcart[nbra*16+i];
                        gsp[1*nbra+i] = creal(coeff_c2s[20])*gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[21])*gcart[nbra* 1+i]
                                      + creal(coeff_c2s[23])*gcart[nbra* 3+i]*_Complex_I
                                      - cimag(coeff_c2s[26])*gcart[nbra* 6+i]
                                      + creal(coeff_c2s[32])*gcart[nbra*12+i]*_Complex_I
                                      - cimag(coeff_c2s[34])*gcart[nbra*14+i]
                                      + creal(coeff_c2s[37])*gcart[nbra*17+i]*_Complex_I;
                        gsp[2*nbra+i] = creal(coeff_c2s[42])*gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[44])*gcart[nbra* 4+i]
                                      + creal(coeff_c2s[47])*gcart[nbra* 7+i]*_Complex_I
                                      + creal(coeff_c2s[50])*gcart[nbra*10+i]*_Complex_I
                                      - cimag(coeff_c2s[51])*gcart[nbra*11+i]
                                      + creal(coeff_c2s[53])*gcart[nbra*13+i]*_Complex_I
                                      + creal(coeff_c2s[55])*gcart[nbra*15+i]*_Complex_I
                                      - cimag(coeff_c2s[56])*gcart[nbra*16+i]
                                      - cimag(coeff_c2s[58])*gcart[nbra*18+i];
                        gsp[3*nbra+i] = creal(coeff_c2s[60])*gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[61])*gcart[nbra* 1+i]
                                      + creal(coeff_c2s[63])*gcart[nbra* 3+i]*_Complex_I
                                      + creal(coeff_c2s[65])*gcart[nbra* 5+i]*_Complex_I
                                      - cimag(coeff_c2s[66])*gcart[nbra* 6+i]
                                      - cimag(coeff_c2s[68])*gcart[nbra* 8+i]
                                      + creal(coeff_c2s[72])*gcart[nbra*12+i]*_Complex_I
                                      + creal(coeff_c2s[77])*gcart[nbra*17+i]*_Complex_I
                                      + creal(coeff_c2s[79])*gcart[nbra*19+i]*_Complex_I;
                        gsp[4*nbra+i] = creal(coeff_c2s[82])*gcart[nbra* 2+i]*_Complex_I
                                      + creal(coeff_c2s[87])*gcart[nbra* 7+i]*_Complex_I
                                      + creal(coeff_c2s[89])*gcart[nbra* 9+i]*_Complex_I
                                      + creal(coeff_c2s[90])*gcart[nbra*10+i]*_Complex_I
                                      - cimag(coeff_c2s[91])*gcart[nbra*11+i]
                                      + creal(coeff_c2s[93])*gcart[nbra*13+i]*_Complex_I
                                      + creal(coeff_c2s[95])*gcart[nbra*15+i]*_Complex_I
                                      - cimag(coeff_c2s[96])*gcart[nbra*16+i]
                                      - cimag(coeff_c2s[98])*gcart[nbra*18+i];
                        gsp[5*nbra+i] = creal(coeff_c2s[100])*gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[101])*gcart[nbra* 1+i]
                                      + creal(coeff_c2s[103])*gcart[nbra* 3+i]*_Complex_I
                                      + creal(coeff_c2s[105])*gcart[nbra* 5+i]*_Complex_I
                                      - cimag(coeff_c2s[106])*gcart[nbra* 6+i]
                                      - cimag(coeff_c2s[108])*gcart[nbra* 8+i]
                                      + creal(coeff_c2s[112])*gcart[nbra*12+i]*_Complex_I
                                      - cimag(coeff_c2s[114])*gcart[nbra*14+i]
                                      + creal(coeff_c2s[117])*gcart[nbra*17+i]*_Complex_I;
                        gsp[6*nbra+i] = creal(coeff_c2s[122])*gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[124])*gcart[nbra* 4+i]
                                      + creal(coeff_c2s[127])*gcart[nbra* 7+i]*_Complex_I
                                      + creal(coeff_c2s[130])*gcart[nbra*10+i]*_Complex_I
                                      - cimag(coeff_c2s[131])*gcart[nbra*11+i]
                                      + creal(coeff_c2s[133])*gcart[nbra*13+i]*_Complex_I
                                      - cimag(coeff_c2s[136])*gcart[nbra*16+i];
                        gsp[7*nbra+i] = creal(coeff_c2s[140])*gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[141])*gcart[nbra* 1+i]
                                      + creal(coeff_c2s[143])*gcart[nbra* 3+i]*_Complex_I
                                      - cimag(coeff_c2s[146])*gcart[nbra* 6+i];
                }
        }
}

static void g_bra_cart2spinor_sf(double complex *gsp, FINT nket,
                                 double complex *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT nd = _len_spinor(kappa, l);
        double complex *gsp1 = gsp + nket * nd;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[4].cart2j_lt_l;
                for (i = 0; i < nket; i++) {
                        gsp [i*nd+0] = creal(coeff_c2s[0]) * gcart[15*i+ 0]
                                     - cimag(coeff_c2s[1]) * gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[3]) * gcart[15*i+ 3]
                                     - cimag(coeff_c2s[6]) * gcart[15*i+ 6]*_Complex_I
                                     + creal(coeff_c2s[10]) * gcart[15*i+10];
                        gsp [i*nd+1] = creal(coeff_c2s[32]) * gcart[15*i+ 2]
                                     - cimag(coeff_c2s[34]) * gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[37]) * gcart[15*i+ 7]
                                     - cimag(coeff_c2s[41]) * gcart[15*i+11]*_Complex_I;
                        gsp [i*nd+2] = creal(coeff_c2s[60]) * gcart[15*i+ 0]
                                     - cimag(coeff_c2s[61]) * gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[65]) * gcart[15*i+ 5]
                                     - cimag(coeff_c2s[66]) * gcart[15*i+ 6]*_Complex_I
                                     - cimag(coeff_c2s[68]) * gcart[15*i+ 8]*_Complex_I
                                     + creal(coeff_c2s[70]) * gcart[15*i+10]
                                     + creal(coeff_c2s[72]) * gcart[15*i+12];
                        gsp [i*nd+3] = creal(coeff_c2s[92]) * gcart[15*i+ 2]
                                     - cimag(coeff_c2s[94]) * gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[97]) * gcart[15*i+ 7]
                                     + creal(coeff_c2s[99]) * gcart[15*i+ 9]
                                     - cimag(coeff_c2s[101]) * gcart[15*i+11]*_Complex_I
                                     - cimag(coeff_c2s[103]) * gcart[15*i+13]*_Complex_I;
                        gsp [i*nd+4] = creal(coeff_c2s[120]) * gcart[15*i+ 0]
                                     + creal(coeff_c2s[123]) * gcart[15*i+ 3]
                                     + creal(coeff_c2s[125]) * gcart[15*i+ 5]
                                     + creal(coeff_c2s[130]) * gcart[15*i+10]
                                     + creal(coeff_c2s[132]) * gcart[15*i+12]
                                     + creal(coeff_c2s[134]) * gcart[15*i+14];
                        gsp [i*nd+5] = creal(coeff_c2s[152]) * gcart[15*i+ 2]
                                     - cimag(coeff_c2s[154]) * gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[157]) * gcart[15*i+ 7]
                                     + creal(coeff_c2s[159]) * gcart[15*i+ 9]
                                     - cimag(coeff_c2s[161]) * gcart[15*i+11]*_Complex_I
                                     - cimag(coeff_c2s[163]) * gcart[15*i+13]*_Complex_I;
                        gsp [i*nd+6] = creal(coeff_c2s[180]) * gcart[15*i+ 0]
                                     - cimag(coeff_c2s[181]) * gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[185]) * gcart[15*i+ 5]
                                     - cimag(coeff_c2s[186]) * gcart[15*i+ 6]*_Complex_I
                                     - cimag(coeff_c2s[188]) * gcart[15*i+ 8]*_Complex_I
                                     + creal(coeff_c2s[190]) * gcart[15*i+10]
                                     + creal(coeff_c2s[192]) * gcart[15*i+12];
                        gsp [i*nd+7] = creal(coeff_c2s[212]) * gcart[15*i+ 2]
                                     - cimag(coeff_c2s[214]) * gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[217]) * gcart[15*i+ 7]
                                     - cimag(coeff_c2s[221]) * gcart[15*i+11]*_Complex_I;

                        gsp1[i*nd+0] = creal(coeff_c2s[17]) * gcart[15*i+ 2]
                                     - cimag(coeff_c2s[19]) * gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[22]) * gcart[15*i+ 7]
                                     - cimag(coeff_c2s[26]) * gcart[15*i+11]*_Complex_I;
                        gsp1[i*nd+1] = creal(coeff_c2s[45]) * gcart[15*i+ 0]
                                     - cimag(coeff_c2s[46]) * gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[50]) * gcart[15*i+ 5]
                                     - cimag(coeff_c2s[51]) * gcart[15*i+ 6]*_Complex_I
                                     - cimag(coeff_c2s[53]) * gcart[15*i+ 8]*_Complex_I
                                     + creal(coeff_c2s[55]) * gcart[15*i+10]
                                     + creal(coeff_c2s[57]) * gcart[15*i+12];
                        gsp1[i*nd+2] = creal(coeff_c2s[77]) * gcart[15*i+ 2]
                                     - cimag(coeff_c2s[79]) * gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[82]) * gcart[15*i+ 7]
                                     + creal(coeff_c2s[84]) * gcart[15*i+ 9]
                                     - cimag(coeff_c2s[86]) * gcart[15*i+11]*_Complex_I
                                     - cimag(coeff_c2s[88]) * gcart[15*i+13]*_Complex_I;
                        gsp1[i*nd+3] = creal(coeff_c2s[105]) * gcart[15*i+ 0]
                                     + creal(coeff_c2s[108]) * gcart[15*i+ 3]
                                     + creal(coeff_c2s[110]) * gcart[15*i+ 5]
                                     + creal(coeff_c2s[115]) * gcart[15*i+10]
                                     + creal(coeff_c2s[117]) * gcart[15*i+12]
                                     + creal(coeff_c2s[119]) * gcart[15*i+14];
                        gsp1[i*nd+4] = creal(coeff_c2s[137]) * gcart[15*i+ 2]
                                     - cimag(coeff_c2s[139]) * gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[142]) * gcart[15*i+ 7]
                                     + creal(coeff_c2s[144]) * gcart[15*i+ 9]
                                     - cimag(coeff_c2s[146]) * gcart[15*i+11]*_Complex_I
                                     - cimag(coeff_c2s[148]) * gcart[15*i+13]*_Complex_I;
                        gsp1[i*nd+5] = creal(coeff_c2s[165]) * gcart[15*i+ 0]
                                     - cimag(coeff_c2s[166]) * gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[170]) * gcart[15*i+ 5]
                                     - cimag(coeff_c2s[171]) * gcart[15*i+ 6]*_Complex_I
                                     - cimag(coeff_c2s[173]) * gcart[15*i+ 8]*_Complex_I
                                     + creal(coeff_c2s[175]) * gcart[15*i+10]
                                     + creal(coeff_c2s[177]) * gcart[15*i+12];
                        gsp1[i*nd+6] = creal(coeff_c2s[197]) * gcart[15*i+ 2]
                                     - cimag(coeff_c2s[199]) * gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[202]) * gcart[15*i+ 7]
                                     - cimag(coeff_c2s[206]) * gcart[15*i+11]*_Complex_I;
                        gsp1[i*nd+7] = creal(coeff_c2s[225]) * gcart[15*i+ 0]
                                     - cimag(coeff_c2s[226]) * gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[228]) * gcart[15*i+ 3]
                                     - cimag(coeff_c2s[231]) * gcart[15*i+ 6]*_Complex_I
                                     + creal(coeff_c2s[235]) * gcart[15*i+10];
                }
                gsp  += 8;
                gsp1 += 8;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[4].cart2j_gt_l;
                for (i = 0; i < nket; i++) {
                        gsp [i*nd+0] = 0;
                        gsp [i*nd+1] = creal(coeff_c2s[30]) * gcart[15*i+ 0]
                                     - cimag(coeff_c2s[31]) * gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[33]) * gcart[15*i+ 3]
                                     - cimag(coeff_c2s[36]) * gcart[15*i+ 6]*_Complex_I
                                     + creal(coeff_c2s[40]) * gcart[15*i+10];
                        gsp [i*nd+2] = creal(coeff_c2s[62]) * gcart[15*i+ 2]
                                     - cimag(coeff_c2s[64]) * gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[67]) * gcart[15*i+ 7]
                                     - cimag(coeff_c2s[71]) * gcart[15*i+11]*_Complex_I;
                        gsp [i*nd+3] = creal(coeff_c2s[90]) * gcart[15*i+ 0]
                                     - cimag(coeff_c2s[91]) * gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[95]) * gcart[15*i+ 5]
                                     - cimag(coeff_c2s[96]) * gcart[15*i+ 6]*_Complex_I
                                     - cimag(coeff_c2s[98]) * gcart[15*i+ 8]*_Complex_I
                                     + creal(coeff_c2s[100]) * gcart[15*i+10]
                                     + creal(coeff_c2s[102]) * gcart[15*i+12];
                        gsp [i*nd+4] = creal(coeff_c2s[122]) * gcart[15*i+ 2]
                                     - cimag(coeff_c2s[124]) * gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[127]) * gcart[15*i+ 7]
                                     + creal(coeff_c2s[129]) * gcart[15*i+ 9]
                                     - cimag(coeff_c2s[131]) * gcart[15*i+11]*_Complex_I
                                     - cimag(coeff_c2s[133]) * gcart[15*i+13]*_Complex_I;
                        gsp [i*nd+5] = creal(coeff_c2s[150]) * gcart[15*i+ 0]
                                     + creal(coeff_c2s[153]) * gcart[15*i+ 3]
                                     + creal(coeff_c2s[155]) * gcart[15*i+ 5]
                                     + creal(coeff_c2s[160]) * gcart[15*i+10]
                                     + creal(coeff_c2s[162]) * gcart[15*i+12]
                                     + creal(coeff_c2s[164]) * gcart[15*i+14];
                        gsp [i*nd+6] = creal(coeff_c2s[182]) * gcart[15*i+ 2]
                                     - cimag(coeff_c2s[184]) * gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[187]) * gcart[15*i+ 7]
                                     + creal(coeff_c2s[189]) * gcart[15*i+ 9]
                                     - cimag(coeff_c2s[191]) * gcart[15*i+11]*_Complex_I
                                     - cimag(coeff_c2s[193]) * gcart[15*i+13]*_Complex_I;
                        gsp [i*nd+7] = creal(coeff_c2s[210]) * gcart[15*i+ 0]
                                     - cimag(coeff_c2s[211]) * gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[215]) * gcart[15*i+ 5]
                                     - cimag(coeff_c2s[216]) * gcart[15*i+ 6]*_Complex_I
                                     - cimag(coeff_c2s[218]) * gcart[15*i+ 8]*_Complex_I
                                     + creal(coeff_c2s[220]) * gcart[15*i+10]
                                     + creal(coeff_c2s[222]) * gcart[15*i+12];
                        gsp [i*nd+8] = creal(coeff_c2s[242]) * gcart[15*i+ 2]
                                     - cimag(coeff_c2s[244]) * gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[247]) * gcart[15*i+ 7]
                                     - cimag(coeff_c2s[251]) * gcart[15*i+11]*_Complex_I;
                        gsp [i*nd+9] = creal(coeff_c2s[270]) * gcart[15*i+ 0]
                                     - cimag(coeff_c2s[271]) * gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[273]) * gcart[15*i+ 3]
                                     - cimag(coeff_c2s[276]) * gcart[15*i+ 6]*_Complex_I
                                     + creal(coeff_c2s[280]) * gcart[15*i+10];

                        gsp1[i*nd+0] = creal(coeff_c2s[15]) * gcart[15*i+ 0]
                                     - cimag(coeff_c2s[16]) * gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[18]) * gcart[15*i+ 3]
                                     - cimag(coeff_c2s[21]) * gcart[15*i+ 6]*_Complex_I
                                     + creal(coeff_c2s[25]) * gcart[15*i+10];
                        gsp1[i*nd+1] = creal(coeff_c2s[47]) * gcart[15*i+ 2]
                                     - cimag(coeff_c2s[49]) * gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[52]) * gcart[15*i+ 7]
                                     - cimag(coeff_c2s[56]) * gcart[15*i+11]*_Complex_I;
                        gsp1[i*nd+2] = creal(coeff_c2s[75]) * gcart[15*i+ 0]
                                     - cimag(coeff_c2s[76]) * gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[80]) * gcart[15*i+ 5]
                                     - cimag(coeff_c2s[81]) * gcart[15*i+ 6]*_Complex_I
                                     - cimag(coeff_c2s[83]) * gcart[15*i+ 8]*_Complex_I
                                     + creal(coeff_c2s[85]) * gcart[15*i+10]
                                     + creal(coeff_c2s[87]) * gcart[15*i+12];
                        gsp1[i*nd+3] = creal(coeff_c2s[107]) * gcart[15*i+ 2]
                                     - cimag(coeff_c2s[109]) * gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[112]) * gcart[15*i+ 7]
                                     + creal(coeff_c2s[114]) * gcart[15*i+ 9]
                                     - cimag(coeff_c2s[116]) * gcart[15*i+11]*_Complex_I
                                     - cimag(coeff_c2s[118]) * gcart[15*i+13]*_Complex_I;
                        gsp1[i*nd+4] = creal(coeff_c2s[135]) * gcart[15*i+ 0]
                                     + creal(coeff_c2s[138]) * gcart[15*i+ 3]
                                     + creal(coeff_c2s[140]) * gcart[15*i+ 5]
                                     + creal(coeff_c2s[145]) * gcart[15*i+10]
                                     + creal(coeff_c2s[147]) * gcart[15*i+12]
                                     + creal(coeff_c2s[149]) * gcart[15*i+14];
                        gsp1[i*nd+5] = creal(coeff_c2s[167]) * gcart[15*i+ 2]
                                     - cimag(coeff_c2s[169]) * gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[172]) * gcart[15*i+ 7]
                                     + creal(coeff_c2s[174]) * gcart[15*i+ 9]
                                     - cimag(coeff_c2s[176]) * gcart[15*i+11]*_Complex_I
                                     - cimag(coeff_c2s[178]) * gcart[15*i+13]*_Complex_I;
                        gsp1[i*nd+6] = creal(coeff_c2s[195]) * gcart[15*i+ 0]
                                     - cimag(coeff_c2s[196]) * gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[200]) * gcart[15*i+ 5]
                                     - cimag(coeff_c2s[201]) * gcart[15*i+ 6]*_Complex_I
                                     - cimag(coeff_c2s[203]) * gcart[15*i+ 8]*_Complex_I
                                     + creal(coeff_c2s[205]) * gcart[15*i+10]
                                     + creal(coeff_c2s[207]) * gcart[15*i+12];
                        gsp1[i*nd+7] = creal(coeff_c2s[227]) * gcart[15*i+ 2]
                                     - cimag(coeff_c2s[229]) * gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[232]) * gcart[15*i+ 7]
                                     - cimag(coeff_c2s[236]) * gcart[15*i+11]*_Complex_I;
                        gsp1[i*nd+8] = creal(coeff_c2s[255]) * gcart[15*i+ 0]
                                     - cimag(coeff_c2s[256]) * gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[258]) * gcart[15*i+ 3]
                                     - cimag(coeff_c2s[261]) * gcart[15*i+ 6]*_Complex_I
                                     + creal(coeff_c2s[265]) * gcart[15*i+10];
                        gsp1[i*nd+9] = 0;

                }
        }
}
static void g_bra_cart2spinor_e1sf(double complex *gsp, FINT nket,
                                   double *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT nd = _len_spinor(kappa, l);
        double complex *gsp1 = gsp + nket * nd;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[4].cart2j_lt_l;
                for (i = 0; i < nket; i++) {
                        gsp [i*nd+0] = creal(coeff_c2s[0])*gcart[15*i+ 0]
                                     - cimag(coeff_c2s[1])*gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[3])*gcart[15*i+ 3]
                                     - cimag(coeff_c2s[6])*gcart[15*i+ 6]*_Complex_I
                                     + creal(coeff_c2s[10])*gcart[15*i+10];
                        gsp [i*nd+1] = creal(coeff_c2s[32])*gcart[15*i+ 2]
                                     - cimag(coeff_c2s[34])*gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[37])*gcart[15*i+ 7]
                                     - cimag(coeff_c2s[41])*gcart[15*i+11]*_Complex_I;
                        gsp [i*nd+2] = creal(coeff_c2s[60])*gcart[15*i+ 0]
                                     - cimag(coeff_c2s[61])*gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[65])*gcart[15*i+ 5]
                                     - cimag(coeff_c2s[66])*gcart[15*i+ 6]*_Complex_I
                                     - cimag(coeff_c2s[68])*gcart[15*i+ 8]*_Complex_I
                                     + creal(coeff_c2s[70])*gcart[15*i+10]
                                     + creal(coeff_c2s[72])*gcart[15*i+12];
                        gsp [i*nd+3] = creal(coeff_c2s[92])*gcart[15*i+ 2]
                                     - cimag(coeff_c2s[94])*gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[97])*gcart[15*i+ 7]
                                     + creal(coeff_c2s[99])*gcart[15*i+ 9]
                                     - cimag(coeff_c2s[101])*gcart[15*i+11]*_Complex_I
                                     - cimag(coeff_c2s[103])*gcart[15*i+13]*_Complex_I;
                        gsp [i*nd+4] = creal(coeff_c2s[120])*gcart[15*i+ 0]
                                     + creal(coeff_c2s[123])*gcart[15*i+ 3]
                                     + creal(coeff_c2s[125])*gcart[15*i+ 5]
                                     + creal(coeff_c2s[130])*gcart[15*i+10]
                                     + creal(coeff_c2s[132])*gcart[15*i+12]
                                     + creal(coeff_c2s[134])*gcart[15*i+14];
                        gsp [i*nd+5] = creal(coeff_c2s[152])*gcart[15*i+ 2]
                                     - cimag(coeff_c2s[154])*gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[157])*gcart[15*i+ 7]
                                     + creal(coeff_c2s[159])*gcart[15*i+ 9]
                                     - cimag(coeff_c2s[161])*gcart[15*i+11]*_Complex_I
                                     - cimag(coeff_c2s[163])*gcart[15*i+13]*_Complex_I;
                        gsp [i*nd+6] = creal(coeff_c2s[180])*gcart[15*i+ 0]
                                     - cimag(coeff_c2s[181])*gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[185])*gcart[15*i+ 5]
                                     - cimag(coeff_c2s[186])*gcart[15*i+ 6]*_Complex_I
                                     - cimag(coeff_c2s[188])*gcart[15*i+ 8]*_Complex_I
                                     + creal(coeff_c2s[190])*gcart[15*i+10]
                                     + creal(coeff_c2s[192])*gcart[15*i+12];
                        gsp [i*nd+7] = creal(coeff_c2s[212])*gcart[15*i+ 2]
                                     - cimag(coeff_c2s[214])*gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[217])*gcart[15*i+ 7]
                                     - cimag(coeff_c2s[221])*gcart[15*i+11]*_Complex_I;

                        gsp1[i*nd+0] = creal(coeff_c2s[17])*gcart[15*i+ 2]
                                     - cimag(coeff_c2s[19])*gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[22])*gcart[15*i+ 7]
                                     - cimag(coeff_c2s[26])*gcart[15*i+11]*_Complex_I;
                        gsp1[i*nd+1] = creal(coeff_c2s[45])*gcart[15*i+ 0]
                                     - cimag(coeff_c2s[46])*gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[50])*gcart[15*i+ 5]
                                     - cimag(coeff_c2s[51])*gcart[15*i+ 6]*_Complex_I
                                     - cimag(coeff_c2s[53])*gcart[15*i+ 8]*_Complex_I
                                     + creal(coeff_c2s[55])*gcart[15*i+10]
                                     + creal(coeff_c2s[57])*gcart[15*i+12];
                        gsp1[i*nd+2] = creal(coeff_c2s[77])*gcart[15*i+ 2]
                                     - cimag(coeff_c2s[79])*gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[82])*gcart[15*i+ 7]
                                     + creal(coeff_c2s[84])*gcart[15*i+ 9]
                                     - cimag(coeff_c2s[86])*gcart[15*i+11]*_Complex_I
                                     - cimag(coeff_c2s[88])*gcart[15*i+13]*_Complex_I;
                        gsp1[i*nd+3] = creal(coeff_c2s[105])*gcart[15*i+ 0]
                                     + creal(coeff_c2s[108])*gcart[15*i+ 3]
                                     + creal(coeff_c2s[110])*gcart[15*i+ 5]
                                     + creal(coeff_c2s[115])*gcart[15*i+10]
                                     + creal(coeff_c2s[117])*gcart[15*i+12]
                                     + creal(coeff_c2s[119])*gcart[15*i+14];
                        gsp1[i*nd+4] = creal(coeff_c2s[137])*gcart[15*i+ 2]
                                     - cimag(coeff_c2s[139])*gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[142])*gcart[15*i+ 7]
                                     + creal(coeff_c2s[144])*gcart[15*i+ 9]
                                     - cimag(coeff_c2s[146])*gcart[15*i+11]*_Complex_I
                                     - cimag(coeff_c2s[148])*gcart[15*i+13]*_Complex_I;
                        gsp1[i*nd+5] = creal(coeff_c2s[165])*gcart[15*i+ 0]
                                     - cimag(coeff_c2s[166])*gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[170])*gcart[15*i+ 5]
                                     - cimag(coeff_c2s[171])*gcart[15*i+ 6]*_Complex_I
                                     - cimag(coeff_c2s[173])*gcart[15*i+ 8]*_Complex_I
                                     + creal(coeff_c2s[175])*gcart[15*i+10]
                                     + creal(coeff_c2s[177])*gcart[15*i+12];
                        gsp1[i*nd+6] = creal(coeff_c2s[197])*gcart[15*i+ 2]
                                     - cimag(coeff_c2s[199])*gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[202])*gcart[15*i+ 7]
                                     - cimag(coeff_c2s[206])*gcart[15*i+11]*_Complex_I;
                        gsp1[i*nd+7] = creal(coeff_c2s[225])*gcart[15*i+ 0]
                                     - cimag(coeff_c2s[226])*gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[228])*gcart[15*i+ 3]
                                     - cimag(coeff_c2s[231])*gcart[15*i+ 6]*_Complex_I
                                     + creal(coeff_c2s[235])*gcart[15*i+10];
                }
                gsp  += 8;
                gsp1 += 8;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[4].cart2j_gt_l;
                for (i = 0; i < nket; i++) {
                        gsp [i*nd+0] = 0;
                        gsp [i*nd+1] = creal(coeff_c2s[30])*gcart[15*i+ 0]
                                     - cimag(coeff_c2s[31])*gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[33])*gcart[15*i+ 3]
                                     - cimag(coeff_c2s[36])*gcart[15*i+ 6]*_Complex_I
                                     + creal(coeff_c2s[40])*gcart[15*i+10];
                        gsp [i*nd+2] = creal(coeff_c2s[62])*gcart[15*i+ 2]
                                     - cimag(coeff_c2s[64])*gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[67])*gcart[15*i+ 7]
                                     - cimag(coeff_c2s[71])*gcart[15*i+11]*_Complex_I;
                        gsp [i*nd+3] = creal(coeff_c2s[90])*gcart[15*i+ 0]
                                     - cimag(coeff_c2s[91])*gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[95])*gcart[15*i+ 5]
                                     - cimag(coeff_c2s[96])*gcart[15*i+ 6]*_Complex_I
                                     - cimag(coeff_c2s[98])*gcart[15*i+ 8]*_Complex_I
                                     + creal(coeff_c2s[100])*gcart[15*i+10]
                                     + creal(coeff_c2s[102])*gcart[15*i+12];
                        gsp [i*nd+4] = creal(coeff_c2s[122])*gcart[15*i+ 2]
                                     - cimag(coeff_c2s[124])*gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[127])*gcart[15*i+ 7]
                                     + creal(coeff_c2s[129])*gcart[15*i+ 9]
                                     - cimag(coeff_c2s[131])*gcart[15*i+11]*_Complex_I
                                     - cimag(coeff_c2s[133])*gcart[15*i+13]*_Complex_I;
                        gsp [i*nd+5] = creal(coeff_c2s[150])*gcart[15*i+ 0]
                                     + creal(coeff_c2s[153])*gcart[15*i+ 3]
                                     + creal(coeff_c2s[155])*gcart[15*i+ 5]
                                     + creal(coeff_c2s[160])*gcart[15*i+10]
                                     + creal(coeff_c2s[162])*gcart[15*i+12]
                                     + creal(coeff_c2s[164])*gcart[15*i+14];
                        gsp [i*nd+6] = creal(coeff_c2s[182])*gcart[15*i+ 2]
                                     - cimag(coeff_c2s[184])*gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[187])*gcart[15*i+ 7]
                                     + creal(coeff_c2s[189])*gcart[15*i+ 9]
                                     - cimag(coeff_c2s[191])*gcart[15*i+11]*_Complex_I
                                     - cimag(coeff_c2s[193])*gcart[15*i+13]*_Complex_I;
                        gsp [i*nd+7] = creal(coeff_c2s[210])*gcart[15*i+ 0]
                                     - cimag(coeff_c2s[211])*gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[215])*gcart[15*i+ 5]
                                     - cimag(coeff_c2s[216])*gcart[15*i+ 6]*_Complex_I
                                     - cimag(coeff_c2s[218])*gcart[15*i+ 8]*_Complex_I
                                     + creal(coeff_c2s[220])*gcart[15*i+10]
                                     + creal(coeff_c2s[222])*gcart[15*i+12];
                        gsp [i*nd+8] = creal(coeff_c2s[242])*gcart[15*i+ 2]
                                     - cimag(coeff_c2s[244])*gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[247])*gcart[15*i+ 7]
                                     - cimag(coeff_c2s[251])*gcart[15*i+11]*_Complex_I;
                        gsp [i*nd+9] = creal(coeff_c2s[270])*gcart[15*i+ 0]
                                     - cimag(coeff_c2s[271])*gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[273])*gcart[15*i+ 3]
                                     - cimag(coeff_c2s[276])*gcart[15*i+ 6]*_Complex_I
                                     + creal(coeff_c2s[280])*gcart[15*i+10];

                        gsp1[i*nd+0] = creal(coeff_c2s[15])*gcart[15*i+ 0]
                                     - cimag(coeff_c2s[16])*gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[18])*gcart[15*i+ 3]
                                     - cimag(coeff_c2s[21])*gcart[15*i+ 6]*_Complex_I
                                     + creal(coeff_c2s[25])*gcart[15*i+10];
                        gsp1[i*nd+1] = creal(coeff_c2s[47])*gcart[15*i+ 2]
                                     - cimag(coeff_c2s[49])*gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[52])*gcart[15*i+ 7]
                                     - cimag(coeff_c2s[56])*gcart[15*i+11]*_Complex_I;
                        gsp1[i*nd+2] = creal(coeff_c2s[75])*gcart[15*i+ 0]
                                     - cimag(coeff_c2s[76])*gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[80])*gcart[15*i+ 5]
                                     - cimag(coeff_c2s[81])*gcart[15*i+ 6]*_Complex_I
                                     - cimag(coeff_c2s[83])*gcart[15*i+ 8]*_Complex_I
                                     + creal(coeff_c2s[85])*gcart[15*i+10]
                                     + creal(coeff_c2s[87])*gcart[15*i+12];
                        gsp1[i*nd+3] = creal(coeff_c2s[107])*gcart[15*i+ 2]
                                     - cimag(coeff_c2s[109])*gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[112])*gcart[15*i+ 7]
                                     + creal(coeff_c2s[114])*gcart[15*i+ 9]
                                     - cimag(coeff_c2s[116])*gcart[15*i+11]*_Complex_I
                                     - cimag(coeff_c2s[118])*gcart[15*i+13]*_Complex_I;
                        gsp1[i*nd+4] = creal(coeff_c2s[135])*gcart[15*i+ 0]
                                     + creal(coeff_c2s[138])*gcart[15*i+ 3]
                                     + creal(coeff_c2s[140])*gcart[15*i+ 5]
                                     + creal(coeff_c2s[145])*gcart[15*i+10]
                                     + creal(coeff_c2s[147])*gcart[15*i+12]
                                     + creal(coeff_c2s[149])*gcart[15*i+14];
                        gsp1[i*nd+5] = creal(coeff_c2s[167])*gcart[15*i+ 2]
                                     - cimag(coeff_c2s[169])*gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[172])*gcart[15*i+ 7]
                                     + creal(coeff_c2s[174])*gcart[15*i+ 9]
                                     - cimag(coeff_c2s[176])*gcart[15*i+11]*_Complex_I
                                     - cimag(coeff_c2s[178])*gcart[15*i+13]*_Complex_I;
                        gsp1[i*nd+6] = creal(coeff_c2s[195])*gcart[15*i+ 0]
                                     - cimag(coeff_c2s[196])*gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[200])*gcart[15*i+ 5]
                                     - cimag(coeff_c2s[201])*gcart[15*i+ 6]*_Complex_I
                                     - cimag(coeff_c2s[203])*gcart[15*i+ 8]*_Complex_I
                                     + creal(coeff_c2s[205])*gcart[15*i+10]
                                     + creal(coeff_c2s[207])*gcart[15*i+12];
                        gsp1[i*nd+7] = creal(coeff_c2s[227])*gcart[15*i+ 2]
                                     - cimag(coeff_c2s[229])*gcart[15*i+ 4]*_Complex_I
                                     + creal(coeff_c2s[232])*gcart[15*i+ 7]
                                     - cimag(coeff_c2s[236])*gcart[15*i+11]*_Complex_I;
                        gsp1[i*nd+8] = creal(coeff_c2s[255])*gcart[15*i+ 0]
                                     - cimag(coeff_c2s[256])*gcart[15*i+ 1]*_Complex_I
                                     + creal(coeff_c2s[258])*gcart[15*i+ 3]
                                     - cimag(coeff_c2s[261])*gcart[15*i+ 6]*_Complex_I
                                     + creal(coeff_c2s[265])*gcart[15*i+10];
                        gsp1[i*nd+9] = 0;

                }
        }
}
static void g_bra_cart2spinor_si(double complex *gsp, FINT nket,
                                 double complex *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT nd = _len_spinor(kappa, l);
        double complex *gcart1 = gcart + nket * 15;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[4].cart2j_lt_l;
                for (i = 0; i < nket; i++) {
                        gsp[i*nd+0] = creal(coeff_c2s[0]) * gcart[15*i+ 0]
                                    - cimag(coeff_c2s[1]) * gcart[15*i+ 1]*_Complex_I
                                    + creal(coeff_c2s[3]) * gcart[15*i+ 3]
                                    - cimag(coeff_c2s[6]) * gcart[15*i+ 6]*_Complex_I
                                    + creal(coeff_c2s[10]) * gcart[15*i+10];
                        gsp[i*nd+1] = creal(coeff_c2s[32]) * gcart[15*i+ 2]
                                    - cimag(coeff_c2s[34]) * gcart[15*i+ 4]*_Complex_I
                                    + creal(coeff_c2s[37]) * gcart[15*i+ 7]
                                    - cimag(coeff_c2s[41]) * gcart[15*i+11]*_Complex_I;
                        gsp[i*nd+2] = creal(coeff_c2s[60]) * gcart[15*i+ 0]
                                    - cimag(coeff_c2s[61]) * gcart[15*i+ 1]*_Complex_I
                                    + creal(coeff_c2s[65]) * gcart[15*i+ 5]
                                    - cimag(coeff_c2s[66]) * gcart[15*i+ 6]*_Complex_I
                                    - cimag(coeff_c2s[68]) * gcart[15*i+ 8]*_Complex_I
                                    + creal(coeff_c2s[70]) * gcart[15*i+10]
                                    + creal(coeff_c2s[72]) * gcart[15*i+12];
                        gsp[i*nd+3] = creal(coeff_c2s[92]) * gcart[15*i+ 2]
                                    - cimag(coeff_c2s[94]) * gcart[15*i+ 4]*_Complex_I
                                    + creal(coeff_c2s[97]) * gcart[15*i+ 7]
                                    + creal(coeff_c2s[99]) * gcart[15*i+ 9]
                                    - cimag(coeff_c2s[101]) * gcart[15*i+11]*_Complex_I
                                    - cimag(coeff_c2s[103]) * gcart[15*i+13]*_Complex_I;
                        gsp[i*nd+4] = creal(coeff_c2s[120]) * gcart[15*i+ 0]
                                    + creal(coeff_c2s[123]) * gcart[15*i+ 3]
                                    + creal(coeff_c2s[125]) * gcart[15*i+ 5]
                                    + creal(coeff_c2s[130]) * gcart[15*i+10]
                                    + creal(coeff_c2s[132]) * gcart[15*i+12]
                                    + creal(coeff_c2s[134]) * gcart[15*i+14];
                        gsp[i*nd+5] = creal(coeff_c2s[152]) * gcart[15*i+ 2]
                                    - cimag(coeff_c2s[154]) * gcart[15*i+ 4]*_Complex_I
                                    + creal(coeff_c2s[157]) * gcart[15*i+ 7]
                                    + creal(coeff_c2s[159]) * gcart[15*i+ 9]
                                    - cimag(coeff_c2s[161]) * gcart[15*i+11]*_Complex_I
                                    - cimag(coeff_c2s[163]) * gcart[15*i+13]*_Complex_I;
                        gsp[i*nd+6] = creal(coeff_c2s[180]) * gcart[15*i+ 0]
                                    - cimag(coeff_c2s[181]) * gcart[15*i+ 1]*_Complex_I
                                    + creal(coeff_c2s[185]) * gcart[15*i+ 5]
                                    - cimag(coeff_c2s[186]) * gcart[15*i+ 6]*_Complex_I
                                    - cimag(coeff_c2s[188]) * gcart[15*i+ 8]*_Complex_I
                                    + creal(coeff_c2s[190]) * gcart[15*i+10]
                                    + creal(coeff_c2s[192]) * gcart[15*i+12];
                        gsp[i*nd+7] = creal(coeff_c2s[212]) * gcart[15*i+ 2]
                                    - cimag(coeff_c2s[214]) * gcart[15*i+ 4]*_Complex_I
                                    + creal(coeff_c2s[217]) * gcart[15*i+ 7]
                                    - cimag(coeff_c2s[221]) * gcart[15*i+11]*_Complex_I;
                }
                for (i = 0; i < nket; i++) {
                        gsp[i*nd+0]+= creal(coeff_c2s[17]) * gcart1[15*i+ 2]
                                    - cimag(coeff_c2s[19]) * gcart1[15*i+ 4]*_Complex_I
                                    + creal(coeff_c2s[22]) * gcart1[15*i+ 7]
                                    - cimag(coeff_c2s[26]) * gcart1[15*i+11]*_Complex_I;
                        gsp[i*nd+1]+= creal(coeff_c2s[45]) * gcart1[15*i+ 0]
                                    - cimag(coeff_c2s[46]) * gcart1[15*i+ 1]*_Complex_I
                                    + creal(coeff_c2s[50]) * gcart1[15*i+ 5]
                                    - cimag(coeff_c2s[51]) * gcart1[15*i+ 6]*_Complex_I
                                    - cimag(coeff_c2s[53]) * gcart1[15*i+ 8]*_Complex_I
                                    + creal(coeff_c2s[55]) * gcart1[15*i+10]
                                    + creal(coeff_c2s[57]) * gcart1[15*i+12];
                        gsp[i*nd+2]+= creal(coeff_c2s[77]) * gcart1[15*i+ 2]
                                    - cimag(coeff_c2s[79]) * gcart1[15*i+ 4]*_Complex_I
                                    + creal(coeff_c2s[82]) * gcart1[15*i+ 7]
                                    + creal(coeff_c2s[84]) * gcart1[15*i+ 9]
                                    - cimag(coeff_c2s[86]) * gcart1[15*i+11]*_Complex_I
                                    - cimag(coeff_c2s[88]) * gcart1[15*i+13]*_Complex_I;
                        gsp[i*nd+3]+= creal(coeff_c2s[105]) * gcart1[15*i+ 0]
                                    + creal(coeff_c2s[108]) * gcart1[15*i+ 3]
                                    + creal(coeff_c2s[110]) * gcart1[15*i+ 5]
                                    + creal(coeff_c2s[115]) * gcart1[15*i+10]
                                    + creal(coeff_c2s[117]) * gcart1[15*i+12]
                                    + creal(coeff_c2s[119]) * gcart1[15*i+14];
                        gsp[i*nd+4]+= creal(coeff_c2s[137]) * gcart1[15*i+ 2]
                                    - cimag(coeff_c2s[139]) * gcart1[15*i+ 4]*_Complex_I
                                    + creal(coeff_c2s[142]) * gcart1[15*i+ 7]
                                    + creal(coeff_c2s[144]) * gcart1[15*i+ 9]
                                    - cimag(coeff_c2s[146]) * gcart1[15*i+11]*_Complex_I
                                    - cimag(coeff_c2s[148]) * gcart1[15*i+13]*_Complex_I;
                        gsp[i*nd+5]+= creal(coeff_c2s[165]) * gcart1[15*i+ 0]
                                    - cimag(coeff_c2s[166]) * gcart1[15*i+ 1]*_Complex_I
                                    + creal(coeff_c2s[170]) * gcart1[15*i+ 5]
                                    - cimag(coeff_c2s[171]) * gcart1[15*i+ 6]*_Complex_I
                                    - cimag(coeff_c2s[173]) * gcart1[15*i+ 8]*_Complex_I
                                    + creal(coeff_c2s[175]) * gcart1[15*i+10]
                                    + creal(coeff_c2s[177]) * gcart1[15*i+12];
                        gsp[i*nd+6]+= creal(coeff_c2s[197]) * gcart1[15*i+ 2]
                                    - cimag(coeff_c2s[199]) * gcart1[15*i+ 4]*_Complex_I
                                    + creal(coeff_c2s[202]) * gcart1[15*i+ 7]
                                    - cimag(coeff_c2s[206]) * gcart1[15*i+11]*_Complex_I;
                        gsp[i*nd+7]+= creal(coeff_c2s[225]) * gcart1[15*i+ 0]
                                    - cimag(coeff_c2s[226]) * gcart1[15*i+ 1]*_Complex_I
                                    + creal(coeff_c2s[228]) * gcart1[15*i+ 3]
                                    - cimag(coeff_c2s[231]) * gcart1[15*i+ 6]*_Complex_I
                                    + creal(coeff_c2s[235]) * gcart1[15*i+10];
                }
                gsp += 8;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[4].cart2j_gt_l;
                for (i = 0; i < nket; i++) {
                        gsp[i*nd+0] = 0;
                        gsp[i*nd+1] = creal(coeff_c2s[30]) * gcart[15*i+ 0]
                                    - cimag(coeff_c2s[31]) * gcart[15*i+ 1]*_Complex_I
                                    + creal(coeff_c2s[33]) * gcart[15*i+ 3]
                                    - cimag(coeff_c2s[36]) * gcart[15*i+ 6]*_Complex_I
                                    + creal(coeff_c2s[40]) * gcart[15*i+10];
                        gsp[i*nd+2] = creal(coeff_c2s[62]) * gcart[15*i+ 2]
                                    - cimag(coeff_c2s[64]) * gcart[15*i+ 4]*_Complex_I
                                    + creal(coeff_c2s[67]) * gcart[15*i+ 7]
                                    - cimag(coeff_c2s[71]) * gcart[15*i+11]*_Complex_I;
                        gsp[i*nd+3] = creal(coeff_c2s[90]) * gcart[15*i+ 0]
                                    - cimag(coeff_c2s[91]) * gcart[15*i+ 1]*_Complex_I
                                    + creal(coeff_c2s[95]) * gcart[15*i+ 5]
                                    - cimag(coeff_c2s[96]) * gcart[15*i+ 6]*_Complex_I
                                    - cimag(coeff_c2s[98]) * gcart[15*i+ 8]*_Complex_I
                                    + creal(coeff_c2s[100]) * gcart[15*i+10]
                                    + creal(coeff_c2s[102]) * gcart[15*i+12];
                        gsp[i*nd+4] = creal(coeff_c2s[122]) * gcart[15*i+ 2]
                                    - cimag(coeff_c2s[124]) * gcart[15*i+ 4]*_Complex_I
                                    + creal(coeff_c2s[127]) * gcart[15*i+ 7]
                                    + creal(coeff_c2s[129]) * gcart[15*i+ 9]
                                    - cimag(coeff_c2s[131]) * gcart[15*i+11]*_Complex_I
                                    - cimag(coeff_c2s[133]) * gcart[15*i+13]*_Complex_I;
                        gsp[i*nd+5] = creal(coeff_c2s[150]) * gcart[15*i+ 0]
                                    + creal(coeff_c2s[153]) * gcart[15*i+ 3]
                                    + creal(coeff_c2s[155]) * gcart[15*i+ 5]
                                    + creal(coeff_c2s[160]) * gcart[15*i+10]
                                    + creal(coeff_c2s[162]) * gcart[15*i+12]
                                    + creal(coeff_c2s[164]) * gcart[15*i+14];
                        gsp[i*nd+6] = creal(coeff_c2s[182]) * gcart[15*i+ 2]
                                    - cimag(coeff_c2s[184]) * gcart[15*i+ 4]*_Complex_I
                                    + creal(coeff_c2s[187]) * gcart[15*i+ 7]
                                    + creal(coeff_c2s[189]) * gcart[15*i+ 9]
                                    - cimag(coeff_c2s[191]) * gcart[15*i+11]*_Complex_I
                                    - cimag(coeff_c2s[193]) * gcart[15*i+13]*_Complex_I;
                        gsp[i*nd+7] = creal(coeff_c2s[210]) * gcart[15*i+ 0]
                                    - cimag(coeff_c2s[211]) * gcart[15*i+ 1]*_Complex_I
                                    + creal(coeff_c2s[215]) * gcart[15*i+ 5]
                                    - cimag(coeff_c2s[216]) * gcart[15*i+ 6]*_Complex_I
                                    - cimag(coeff_c2s[218]) * gcart[15*i+ 8]*_Complex_I
                                    + creal(coeff_c2s[220]) * gcart[15*i+10]
                                    + creal(coeff_c2s[222]) * gcart[15*i+12];
                        gsp[i*nd+8] = creal(coeff_c2s[242]) * gcart[15*i+ 2]
                                    - cimag(coeff_c2s[244]) * gcart[15*i+ 4]*_Complex_I
                                    + creal(coeff_c2s[247]) * gcart[15*i+ 7]
                                    - cimag(coeff_c2s[251]) * gcart[15*i+11]*_Complex_I;
                        gsp[i*nd+9] = creal(coeff_c2s[270]) * gcart[15*i+ 0]
                                    - cimag(coeff_c2s[271]) * gcart[15*i+ 1]*_Complex_I
                                    + creal(coeff_c2s[273]) * gcart[15*i+ 3]
                                    - cimag(coeff_c2s[276]) * gcart[15*i+ 6]*_Complex_I
                                    + creal(coeff_c2s[280]) * gcart[15*i+10];
                }
                for (i = 0; i < nket; i++) {
                        gsp[i*nd+0]+= creal(coeff_c2s[15]) * gcart1[15*i+ 0]
                                    - cimag(coeff_c2s[16]) * gcart1[15*i+ 1]*_Complex_I
                                    + creal(coeff_c2s[18]) * gcart1[15*i+ 3]
                                    - cimag(coeff_c2s[21]) * gcart1[15*i+ 6]*_Complex_I
                                    + creal(coeff_c2s[25]) * gcart1[15*i+10];
                        gsp[i*nd+1]+= creal(coeff_c2s[47]) * gcart1[15*i+ 2]
                                    - cimag(coeff_c2s[49]) * gcart1[15*i+ 4]*_Complex_I
                                    + creal(coeff_c2s[52]) * gcart1[15*i+ 7]
                                    - cimag(coeff_c2s[56]) * gcart1[15*i+11]*_Complex_I;
                        gsp[i*nd+2]+= creal(coeff_c2s[75]) * gcart1[15*i+ 0]
                                    - cimag(coeff_c2s[76]) * gcart1[15*i+ 1]*_Complex_I
                                    + creal(coeff_c2s[80]) * gcart1[15*i+ 5]
                                    - cimag(coeff_c2s[81]) * gcart1[15*i+ 6]*_Complex_I
                                    - cimag(coeff_c2s[83]) * gcart1[15*i+ 8]*_Complex_I
                                    + creal(coeff_c2s[85]) * gcart1[15*i+10]
                                    + creal(coeff_c2s[87]) * gcart1[15*i+12];
                        gsp[i*nd+3]+= creal(coeff_c2s[107]) * gcart1[15*i+ 2]
                                    - cimag(coeff_c2s[109]) * gcart1[15*i+ 4]*_Complex_I
                                    + creal(coeff_c2s[112]) * gcart1[15*i+ 7]
                                    + creal(coeff_c2s[114]) * gcart1[15*i+ 9]
                                    - cimag(coeff_c2s[116]) * gcart1[15*i+11]*_Complex_I
                                    - cimag(coeff_c2s[118]) * gcart1[15*i+13]*_Complex_I;
                        gsp[i*nd+4]+= creal(coeff_c2s[135]) * gcart1[15*i+ 0]
                                    + creal(coeff_c2s[138]) * gcart1[15*i+ 3]
                                    + creal(coeff_c2s[140]) * gcart1[15*i+ 5]
                                    + creal(coeff_c2s[145]) * gcart1[15*i+10]
                                    + creal(coeff_c2s[147]) * gcart1[15*i+12]
                                    + creal(coeff_c2s[149]) * gcart1[15*i+14];
                        gsp[i*nd+5]+= creal(coeff_c2s[167]) * gcart1[15*i+ 2]
                                    - cimag(coeff_c2s[169]) * gcart1[15*i+ 4]*_Complex_I
                                    + creal(coeff_c2s[172]) * gcart1[15*i+ 7]
                                    + creal(coeff_c2s[174]) * gcart1[15*i+ 9]
                                    - cimag(coeff_c2s[176]) * gcart1[15*i+11]*_Complex_I
                                    - cimag(coeff_c2s[178]) * gcart1[15*i+13]*_Complex_I;
                        gsp[i*nd+6]+= creal(coeff_c2s[195]) * gcart1[15*i+ 0]
                                    - cimag(coeff_c2s[196]) * gcart1[15*i+ 1]*_Complex_I
                                    + creal(coeff_c2s[200]) * gcart1[15*i+ 5]
                                    - cimag(coeff_c2s[201]) * gcart1[15*i+ 6]*_Complex_I
                                    - cimag(coeff_c2s[203]) * gcart1[15*i+ 8]*_Complex_I
                                    + creal(coeff_c2s[205]) * gcart1[15*i+10]
                                    + creal(coeff_c2s[207]) * gcart1[15*i+12];
                        gsp[i*nd+7]+= creal(coeff_c2s[227]) * gcart1[15*i+ 2]
                                    - cimag(coeff_c2s[229]) * gcart1[15*i+ 4]*_Complex_I
                                    + creal(coeff_c2s[232]) * gcart1[15*i+ 7]
                                    - cimag(coeff_c2s[236]) * gcart1[15*i+11]*_Complex_I;
                        gsp[i*nd+8]+= creal(coeff_c2s[255]) * gcart1[15*i+ 0]
                                    - cimag(coeff_c2s[256]) * gcart1[15*i+ 1]*_Complex_I
                                    + creal(coeff_c2s[258]) * gcart1[15*i+ 3]
                                    - cimag(coeff_c2s[261]) * gcart1[15*i+ 6]*_Complex_I
                                    + creal(coeff_c2s[265]) * gcart1[15*i+10];
                        gsp[i*nd+9]+= 0;

                }
        }
}
static void g_ket_cart2spinor(double complex *gsp, FINT nbra,
                              double complex *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[4].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gsp[0*nbra+i] = creal(coeff_c2s[ 0]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[ 1]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 3]) * gcart[nbra* 3+i]
                                      + cimag(coeff_c2s[ 6]) * gcart[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[10]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[17]) * gcart[nbra*17+i]
                                      + cimag(coeff_c2s[19]) * gcart[nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[22]) * gcart[nbra*22+i]
                                      + cimag(coeff_c2s[26]) * gcart[nbra*26+i]*_Complex_I;
                        gsp[1*nbra+i] = creal(coeff_c2s[32]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[34]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[37]) * gcart[nbra* 7+i]
                                      + cimag(coeff_c2s[41]) * gcart[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[45]) * gcart[nbra*15+i]
                                      + cimag(coeff_c2s[46]) * gcart[nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[50]) * gcart[nbra*20+i]
                                      + cimag(coeff_c2s[51]) * gcart[nbra*21+i]*_Complex_I
                                      + cimag(coeff_c2s[53]) * gcart[nbra*23+i]*_Complex_I
                                      + creal(coeff_c2s[55]) * gcart[nbra*25+i]
                                      + creal(coeff_c2s[57]) * gcart[nbra*27+i];
                        gsp[2*nbra+i] = creal(coeff_c2s[60]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[61]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[65]) * gcart[nbra* 5+i]
                                      + cimag(coeff_c2s[66]) * gcart[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[68]) * gcart[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[70]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[72]) * gcart[nbra*12+i]
                                      + creal(coeff_c2s[77]) * gcart[nbra*17+i]
                                      + cimag(coeff_c2s[79]) * gcart[nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[82]) * gcart[nbra*22+i]
                                      + creal(coeff_c2s[84]) * gcart[nbra*24+i]
                                      + cimag(coeff_c2s[86]) * gcart[nbra*26+i]*_Complex_I
                                      + cimag(coeff_c2s[88]) * gcart[nbra*28+i]*_Complex_I;
                        gsp[3*nbra+i] = creal(coeff_c2s[92]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[94]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[97]) * gcart[nbra* 7+i]
                                      + creal(coeff_c2s[99]) * gcart[nbra* 9+i]
                                      + cimag(coeff_c2s[101]) * gcart[nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[103]) * gcart[nbra*13+i]*_Complex_I
                                      + creal(coeff_c2s[105]) * gcart[nbra*15+i]
                                      + creal(coeff_c2s[108]) * gcart[nbra*18+i]
                                      + creal(coeff_c2s[110]) * gcart[nbra*20+i]
                                      + creal(coeff_c2s[115]) * gcart[nbra*25+i]
                                      + creal(coeff_c2s[117]) * gcart[nbra*27+i]
                                      + creal(coeff_c2s[119]) * gcart[nbra*29+i];
                        gsp[4*nbra+i] = creal(coeff_c2s[120]) * gcart[nbra* 0+i]
                                      + creal(coeff_c2s[123]) * gcart[nbra* 3+i]
                                      + creal(coeff_c2s[125]) * gcart[nbra* 5+i]
                                      + creal(coeff_c2s[130]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[132]) * gcart[nbra*12+i]
                                      + creal(coeff_c2s[134]) * gcart[nbra*14+i]
                                      + creal(coeff_c2s[137]) * gcart[nbra*17+i]
                                      + cimag(coeff_c2s[139]) * gcart[nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[142]) * gcart[nbra*22+i]
                                      + creal(coeff_c2s[144]) * gcart[nbra*24+i]
                                      + cimag(coeff_c2s[146]) * gcart[nbra*26+i]*_Complex_I
                                      + cimag(coeff_c2s[148]) * gcart[nbra*28+i]*_Complex_I;
                        gsp[5*nbra+i] = creal(coeff_c2s[152]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[154]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[157]) * gcart[nbra* 7+i]
                                      + creal(coeff_c2s[159]) * gcart[nbra* 9+i]
                                      + cimag(coeff_c2s[161]) * gcart[nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[163]) * gcart[nbra*13+i]*_Complex_I
                                      + creal(coeff_c2s[165]) * gcart[nbra*15+i]
                                      + cimag(coeff_c2s[166]) * gcart[nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[170]) * gcart[nbra*20+i]
                                      + cimag(coeff_c2s[171]) * gcart[nbra*21+i]*_Complex_I
                                      + cimag(coeff_c2s[173]) * gcart[nbra*23+i]*_Complex_I
                                      + creal(coeff_c2s[175]) * gcart[nbra*25+i]
                                      + creal(coeff_c2s[177]) * gcart[nbra*27+i];
                        gsp[6*nbra+i] = creal(coeff_c2s[180]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[181]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[185]) * gcart[nbra* 5+i]
                                      + cimag(coeff_c2s[186]) * gcart[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[188]) * gcart[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[190]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[192]) * gcart[nbra*12+i]
                                      + creal(coeff_c2s[197]) * gcart[nbra*17+i]
                                      + cimag(coeff_c2s[199]) * gcart[nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[202]) * gcart[nbra*22+i]
                                      + cimag(coeff_c2s[206]) * gcart[nbra*26+i]*_Complex_I;
                        gsp[7*nbra+i] = creal(coeff_c2s[212]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[214]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[217]) * gcart[nbra* 7+i]
                                      + cimag(coeff_c2s[221]) * gcart[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[225]) * gcart[nbra*15+i]
                                      + cimag(coeff_c2s[226]) * gcart[nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[228]) * gcart[nbra*18+i]
                                      + cimag(coeff_c2s[231]) * gcart[nbra*21+i]*_Complex_I
                                      + creal(coeff_c2s[235]) * gcart[nbra*25+i];
                };
                gsp += nbra * 8;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[4].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gsp[0*nbra+i] = creal(coeff_c2s[15]) * gcart[nbra*15+i]
                                      + cimag(coeff_c2s[16]) * gcart[nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[18]) * gcart[nbra*18+i]
                                      + cimag(coeff_c2s[21]) * gcart[nbra*21+i]*_Complex_I
                                      + creal(coeff_c2s[25]) * gcart[nbra*25+i];
                        gsp[1*nbra+i] = creal(coeff_c2s[30]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[31]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[33]) * gcart[nbra* 3+i]
                                      + cimag(coeff_c2s[36]) * gcart[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[40]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[47]) * gcart[nbra*17+i]
                                      + cimag(coeff_c2s[49]) * gcart[nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[52]) * gcart[nbra*22+i]
                                      + cimag(coeff_c2s[56]) * gcart[nbra*26+i]*_Complex_I;
                        gsp[2*nbra+i] = creal(coeff_c2s[62]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[64]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[67]) * gcart[nbra* 7+i]
                                      + cimag(coeff_c2s[71]) * gcart[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[75]) * gcart[nbra*15+i]
                                      + cimag(coeff_c2s[76]) * gcart[nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[80]) * gcart[nbra*20+i]
                                      + cimag(coeff_c2s[81]) * gcart[nbra*21+i]*_Complex_I
                                      + cimag(coeff_c2s[83]) * gcart[nbra*23+i]*_Complex_I
                                      + creal(coeff_c2s[85]) * gcart[nbra*25+i]
                                      + creal(coeff_c2s[87]) * gcart[nbra*27+i];
                        gsp[3*nbra+i] = creal(coeff_c2s[90]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[91]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[95]) * gcart[nbra* 5+i]
                                      + cimag(coeff_c2s[96]) * gcart[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[98]) * gcart[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[100]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[102]) * gcart[nbra*12+i]
                                      + creal(coeff_c2s[107]) * gcart[nbra*17+i]
                                      + cimag(coeff_c2s[109]) * gcart[nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[112]) * gcart[nbra*22+i]
                                      + creal(coeff_c2s[114]) * gcart[nbra*24+i]
                                      + cimag(coeff_c2s[116]) * gcart[nbra*26+i]*_Complex_I
                                      + cimag(coeff_c2s[118]) * gcart[nbra*28+i]*_Complex_I;
                        gsp[4*nbra+i] = creal(coeff_c2s[122]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[124]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[127]) * gcart[nbra* 7+i]
                                      + creal(coeff_c2s[129]) * gcart[nbra* 9+i]
                                      + cimag(coeff_c2s[131]) * gcart[nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[133]) * gcart[nbra*13+i]*_Complex_I
                                      + creal(coeff_c2s[135]) * gcart[nbra*15+i]
                                      + creal(coeff_c2s[138]) * gcart[nbra*18+i]
                                      + creal(coeff_c2s[140]) * gcart[nbra*20+i]
                                      + creal(coeff_c2s[145]) * gcart[nbra*25+i]
                                      + creal(coeff_c2s[147]) * gcart[nbra*27+i]
                                      + creal(coeff_c2s[149]) * gcart[nbra*29+i];
                        gsp[5*nbra+i] = creal(coeff_c2s[150]) * gcart[nbra* 0+i]
                                      + creal(coeff_c2s[153]) * gcart[nbra* 3+i]
                                      + creal(coeff_c2s[155]) * gcart[nbra* 5+i]
                                      + creal(coeff_c2s[160]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[162]) * gcart[nbra*12+i]
                                      + creal(coeff_c2s[164]) * gcart[nbra*14+i]
                                      + creal(coeff_c2s[167]) * gcart[nbra*17+i]
                                      + cimag(coeff_c2s[169]) * gcart[nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[172]) * gcart[nbra*22+i]
                                      + creal(coeff_c2s[174]) * gcart[nbra*24+i]
                                      + cimag(coeff_c2s[176]) * gcart[nbra*26+i]*_Complex_I
                                      + cimag(coeff_c2s[178]) * gcart[nbra*28+i]*_Complex_I;
                        gsp[6*nbra+i] = creal(coeff_c2s[182]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[184]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[187]) * gcart[nbra* 7+i]
                                      + creal(coeff_c2s[189]) * gcart[nbra* 9+i]
                                      + cimag(coeff_c2s[191]) * gcart[nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[193]) * gcart[nbra*13+i]*_Complex_I
                                      + creal(coeff_c2s[195]) * gcart[nbra*15+i]
                                      + cimag(coeff_c2s[196]) * gcart[nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[200]) * gcart[nbra*20+i]
                                      + cimag(coeff_c2s[201]) * gcart[nbra*21+i]*_Complex_I
                                      + cimag(coeff_c2s[203]) * gcart[nbra*23+i]*_Complex_I
                                      + creal(coeff_c2s[205]) * gcart[nbra*25+i]
                                      + creal(coeff_c2s[207]) * gcart[nbra*27+i];
                        gsp[7*nbra+i] = creal(coeff_c2s[210]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[211]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[215]) * gcart[nbra* 5+i]
                                      + cimag(coeff_c2s[216]) * gcart[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[218]) * gcart[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[220]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[222]) * gcart[nbra*12+i]
                                      + creal(coeff_c2s[227]) * gcart[nbra*17+i]
                                      + cimag(coeff_c2s[229]) * gcart[nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[232]) * gcart[nbra*22+i]
                                      + cimag(coeff_c2s[236]) * gcart[nbra*26+i]*_Complex_I;
                        gsp[8*nbra+i] = creal(coeff_c2s[242]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[244]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[247]) * gcart[nbra* 7+i]
                                      + cimag(coeff_c2s[251]) * gcart[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[255]) * gcart[nbra*15+i]
                                      + cimag(coeff_c2s[256]) * gcart[nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[258]) * gcart[nbra*18+i]
                                      + cimag(coeff_c2s[261]) * gcart[nbra*21+i]*_Complex_I
                                      + creal(coeff_c2s[265]) * gcart[nbra*25+i];
                        gsp[9*nbra+i] = creal(coeff_c2s[270]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[271]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[273]) * gcart[nbra* 3+i]
                                      + cimag(coeff_c2s[276]) * gcart[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[280]) * gcart[nbra*10+i];
                }
        }
}
static void g_iket_cart2spinor(double complex *gsp, FINT nbra,
                               double complex *gcart, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[4].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gsp[0*nbra+i] = creal(coeff_c2s[ 0]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[ 1]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[ 3]) * gcart[nbra* 3+i]*_Complex_I
                                      - cimag(coeff_c2s[ 6]) * gcart[nbra* 6+i]
                                      + creal(coeff_c2s[10]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[17]) * gcart[nbra*17+i]*_Complex_I
                                      - cimag(coeff_c2s[19]) * gcart[nbra*19+i]
                                      + creal(coeff_c2s[22]) * gcart[nbra*22+i]*_Complex_I
                                      - cimag(coeff_c2s[26]) * gcart[nbra*26+i];
                        gsp[1*nbra+i] = creal(coeff_c2s[32]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[34]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[37]) * gcart[nbra* 7+i]*_Complex_I
                                      - cimag(coeff_c2s[41]) * gcart[nbra*11+i]
                                      + creal(coeff_c2s[45]) * gcart[nbra*15+i]*_Complex_I
                                      - cimag(coeff_c2s[46]) * gcart[nbra*16+i]
                                      + creal(coeff_c2s[50]) * gcart[nbra*20+i]*_Complex_I
                                      - cimag(coeff_c2s[51]) * gcart[nbra*21+i]
                                      - cimag(coeff_c2s[53]) * gcart[nbra*23+i]
                                      + creal(coeff_c2s[55]) * gcart[nbra*25+i]*_Complex_I
                                      + creal(coeff_c2s[57]) * gcart[nbra*27+i]*_Complex_I;
                        gsp[2*nbra+i] = creal(coeff_c2s[60]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[61]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[65]) * gcart[nbra* 5+i]*_Complex_I
                                      - cimag(coeff_c2s[66]) * gcart[nbra* 6+i]
                                      - cimag(coeff_c2s[68]) * gcart[nbra* 8+i]
                                      + creal(coeff_c2s[70]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[72]) * gcart[nbra*12+i]*_Complex_I
                                      + creal(coeff_c2s[77]) * gcart[nbra*17+i]*_Complex_I
                                      - cimag(coeff_c2s[79]) * gcart[nbra*19+i]
                                      + creal(coeff_c2s[82]) * gcart[nbra*22+i]*_Complex_I
                                      + creal(coeff_c2s[84]) * gcart[nbra*24+i]*_Complex_I
                                      - cimag(coeff_c2s[86]) * gcart[nbra*26+i]
                                      - cimag(coeff_c2s[88]) * gcart[nbra*28+i];
                        gsp[3*nbra+i] = creal(coeff_c2s[92]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[94]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[97]) * gcart[nbra* 7+i]*_Complex_I
                                      + creal(coeff_c2s[99]) * gcart[nbra* 9+i]*_Complex_I
                                      - cimag(coeff_c2s[101]) * gcart[nbra*11+i]
                                      - cimag(coeff_c2s[103]) * gcart[nbra*13+i]
                                      + creal(coeff_c2s[105]) * gcart[nbra*15+i]*_Complex_I
                                      + creal(coeff_c2s[108]) * gcart[nbra*18+i]*_Complex_I
                                      + creal(coeff_c2s[110]) * gcart[nbra*20+i]*_Complex_I
                                      + creal(coeff_c2s[115]) * gcart[nbra*25+i]*_Complex_I
                                      + creal(coeff_c2s[117]) * gcart[nbra*27+i]*_Complex_I
                                      + creal(coeff_c2s[119]) * gcart[nbra*29+i]*_Complex_I;
                        gsp[4*nbra+i] = creal(coeff_c2s[120]) * gcart[nbra* 0+i]*_Complex_I
                                      + creal(coeff_c2s[123]) * gcart[nbra* 3+i]*_Complex_I
                                      + creal(coeff_c2s[125]) * gcart[nbra* 5+i]*_Complex_I
                                      + creal(coeff_c2s[130]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[132]) * gcart[nbra*12+i]*_Complex_I
                                      + creal(coeff_c2s[134]) * gcart[nbra*14+i]*_Complex_I
                                      + creal(coeff_c2s[137]) * gcart[nbra*17+i]*_Complex_I
                                      - cimag(coeff_c2s[139]) * gcart[nbra*19+i]
                                      + creal(coeff_c2s[142]) * gcart[nbra*22+i]*_Complex_I
                                      + creal(coeff_c2s[144]) * gcart[nbra*24+i]*_Complex_I
                                      - cimag(coeff_c2s[146]) * gcart[nbra*26+i]
                                      - cimag(coeff_c2s[148]) * gcart[nbra*28+i];
                        gsp[5*nbra+i] = creal(coeff_c2s[152]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[154]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[157]) * gcart[nbra* 7+i]*_Complex_I
                                      + creal(coeff_c2s[159]) * gcart[nbra* 9+i]*_Complex_I
                                      - cimag(coeff_c2s[161]) * gcart[nbra*11+i]
                                      - cimag(coeff_c2s[163]) * gcart[nbra*13+i]
                                      + creal(coeff_c2s[165]) * gcart[nbra*15+i]*_Complex_I
                                      - cimag(coeff_c2s[166]) * gcart[nbra*16+i]
                                      + creal(coeff_c2s[170]) * gcart[nbra*20+i]*_Complex_I
                                      - cimag(coeff_c2s[171]) * gcart[nbra*21+i]
                                      - cimag(coeff_c2s[173]) * gcart[nbra*23+i]
                                      + creal(coeff_c2s[175]) * gcart[nbra*25+i]*_Complex_I
                                      + creal(coeff_c2s[177]) * gcart[nbra*27+i]*_Complex_I;
                        gsp[6*nbra+i] = creal(coeff_c2s[180]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[181]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[185]) * gcart[nbra* 5+i]*_Complex_I
                                      - cimag(coeff_c2s[186]) * gcart[nbra* 6+i]
                                      - cimag(coeff_c2s[188]) * gcart[nbra* 8+i]
                                      + creal(coeff_c2s[190]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[192]) * gcart[nbra*12+i]*_Complex_I
                                      + creal(coeff_c2s[197]) * gcart[nbra*17+i]*_Complex_I
                                      - cimag(coeff_c2s[199]) * gcart[nbra*19+i]
                                      + creal(coeff_c2s[202]) * gcart[nbra*22+i]*_Complex_I
                                      - cimag(coeff_c2s[206]) * gcart[nbra*26+i];
                        gsp[7*nbra+i] = creal(coeff_c2s[212]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[214]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[217]) * gcart[nbra* 7+i]*_Complex_I
                                      - cimag(coeff_c2s[221]) * gcart[nbra*11+i]
                                      + creal(coeff_c2s[225]) * gcart[nbra*15+i]*_Complex_I
                                      - cimag(coeff_c2s[226]) * gcart[nbra*16+i]
                                      + creal(coeff_c2s[228]) * gcart[nbra*18+i]*_Complex_I
                                      - cimag(coeff_c2s[231]) * gcart[nbra*21+i]
                                      + creal(coeff_c2s[235]) * gcart[nbra*25+i]*_Complex_I;
                };
                gsp += nbra * 8;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[4].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gsp[0*nbra+i] = creal(coeff_c2s[15]) * gcart[nbra*15+i]*_Complex_I
                                      - cimag(coeff_c2s[16]) * gcart[nbra*16+i]
                                      + creal(coeff_c2s[18]) * gcart[nbra*18+i]*_Complex_I
                                      - cimag(coeff_c2s[21]) * gcart[nbra*21+i]
                                      + creal(coeff_c2s[25]) * gcart[nbra*25+i]*_Complex_I;
                        gsp[1*nbra+i] = creal(coeff_c2s[30]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[31]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[33]) * gcart[nbra* 3+i]*_Complex_I
                                      - cimag(coeff_c2s[36]) * gcart[nbra* 6+i]
                                      + creal(coeff_c2s[40]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[47]) * gcart[nbra*17+i]*_Complex_I
                                      - cimag(coeff_c2s[49]) * gcart[nbra*19+i]
                                      + creal(coeff_c2s[52]) * gcart[nbra*22+i]*_Complex_I
                                      - cimag(coeff_c2s[56]) * gcart[nbra*26+i];
                        gsp[2*nbra+i] = creal(coeff_c2s[62]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[64]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[67]) * gcart[nbra* 7+i]*_Complex_I
                                      - cimag(coeff_c2s[71]) * gcart[nbra*11+i]
                                      + creal(coeff_c2s[75]) * gcart[nbra*15+i]*_Complex_I
                                      - cimag(coeff_c2s[76]) * gcart[nbra*16+i]
                                      + creal(coeff_c2s[80]) * gcart[nbra*20+i]*_Complex_I
                                      - cimag(coeff_c2s[81]) * gcart[nbra*21+i]
                                      - cimag(coeff_c2s[83]) * gcart[nbra*23+i]
                                      + creal(coeff_c2s[85]) * gcart[nbra*25+i]*_Complex_I
                                      + creal(coeff_c2s[87]) * gcart[nbra*27+i]*_Complex_I;
                        gsp[3*nbra+i] = creal(coeff_c2s[90]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[91]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[95]) * gcart[nbra* 5+i]*_Complex_I
                                      - cimag(coeff_c2s[96]) * gcart[nbra* 6+i]
                                      - cimag(coeff_c2s[98]) * gcart[nbra* 8+i]
                                      + creal(coeff_c2s[100]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[102]) * gcart[nbra*12+i]*_Complex_I
                                      + creal(coeff_c2s[107]) * gcart[nbra*17+i]*_Complex_I
                                      - cimag(coeff_c2s[109]) * gcart[nbra*19+i]
                                      + creal(coeff_c2s[112]) * gcart[nbra*22+i]*_Complex_I
                                      + creal(coeff_c2s[114]) * gcart[nbra*24+i]*_Complex_I
                                      - cimag(coeff_c2s[116]) * gcart[nbra*26+i]
                                      - cimag(coeff_c2s[118]) * gcart[nbra*28+i];
                        gsp[4*nbra+i] = creal(coeff_c2s[122]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[124]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[127]) * gcart[nbra* 7+i]*_Complex_I
                                      + creal(coeff_c2s[129]) * gcart[nbra* 9+i]*_Complex_I
                                      - cimag(coeff_c2s[131]) * gcart[nbra*11+i]
                                      - cimag(coeff_c2s[133]) * gcart[nbra*13+i]
                                      + creal(coeff_c2s[135]) * gcart[nbra*15+i]*_Complex_I
                                      + creal(coeff_c2s[138]) * gcart[nbra*18+i]*_Complex_I
                                      + creal(coeff_c2s[140]) * gcart[nbra*20+i]*_Complex_I
                                      + creal(coeff_c2s[145]) * gcart[nbra*25+i]*_Complex_I
                                      + creal(coeff_c2s[147]) * gcart[nbra*27+i]*_Complex_I
                                      + creal(coeff_c2s[149]) * gcart[nbra*29+i]*_Complex_I;
                        gsp[5*nbra+i] = creal(coeff_c2s[150]) * gcart[nbra* 0+i]*_Complex_I
                                      + creal(coeff_c2s[153]) * gcart[nbra* 3+i]*_Complex_I
                                      + creal(coeff_c2s[155]) * gcart[nbra* 5+i]*_Complex_I
                                      + creal(coeff_c2s[160]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[162]) * gcart[nbra*12+i]*_Complex_I
                                      + creal(coeff_c2s[164]) * gcart[nbra*14+i]*_Complex_I
                                      + creal(coeff_c2s[167]) * gcart[nbra*17+i]*_Complex_I
                                      - cimag(coeff_c2s[169]) * gcart[nbra*19+i]
                                      + creal(coeff_c2s[172]) * gcart[nbra*22+i]*_Complex_I
                                      + creal(coeff_c2s[174]) * gcart[nbra*24+i]*_Complex_I
                                      - cimag(coeff_c2s[176]) * gcart[nbra*26+i]
                                      - cimag(coeff_c2s[178]) * gcart[nbra*28+i];
                        gsp[6*nbra+i] = creal(coeff_c2s[182]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[184]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[187]) * gcart[nbra* 7+i]*_Complex_I
                                      + creal(coeff_c2s[189]) * gcart[nbra* 9+i]*_Complex_I
                                      - cimag(coeff_c2s[191]) * gcart[nbra*11+i]
                                      - cimag(coeff_c2s[193]) * gcart[nbra*13+i]
                                      + creal(coeff_c2s[195]) * gcart[nbra*15+i]*_Complex_I
                                      - cimag(coeff_c2s[196]) * gcart[nbra*16+i]
                                      + creal(coeff_c2s[200]) * gcart[nbra*20+i]*_Complex_I
                                      - cimag(coeff_c2s[201]) * gcart[nbra*21+i]
                                      - cimag(coeff_c2s[203]) * gcart[nbra*23+i]
                                      + creal(coeff_c2s[205]) * gcart[nbra*25+i]*_Complex_I
                                      + creal(coeff_c2s[207]) * gcart[nbra*27+i]*_Complex_I;
                        gsp[7*nbra+i] = creal(coeff_c2s[210]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[211]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[215]) * gcart[nbra* 5+i]*_Complex_I
                                      - cimag(coeff_c2s[216]) * gcart[nbra* 6+i]
                                      - cimag(coeff_c2s[218]) * gcart[nbra* 8+i]
                                      + creal(coeff_c2s[220]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[222]) * gcart[nbra*12+i]*_Complex_I
                                      + creal(coeff_c2s[227]) * gcart[nbra*17+i]*_Complex_I
                                      - cimag(coeff_c2s[229]) * gcart[nbra*19+i]
                                      + creal(coeff_c2s[232]) * gcart[nbra*22+i]*_Complex_I
                                      - cimag(coeff_c2s[236]) * gcart[nbra*26+i];
                        gsp[8*nbra+i] = creal(coeff_c2s[242]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[244]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[247]) * gcart[nbra* 7+i]*_Complex_I
                                      - cimag(coeff_c2s[251]) * gcart[nbra*11+i]
                                      + creal(coeff_c2s[255]) * gcart[nbra*15+i]*_Complex_I
                                      - cimag(coeff_c2s[256]) * gcart[nbra*16+i]
                                      + creal(coeff_c2s[258]) * gcart[nbra*18+i]*_Complex_I
                                      - cimag(coeff_c2s[261]) * gcart[nbra*21+i]
                                      + creal(coeff_c2s[265]) * gcart[nbra*25+i]*_Complex_I;
                        gsp[9*nbra+i] = creal(coeff_c2s[270]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[271]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[273]) * gcart[nbra* 3+i]*_Complex_I
                                      - cimag(coeff_c2s[276]) * gcart[nbra* 6+i]
                                      + creal(coeff_c2s[280]) * gcart[nbra*10+i]*_Complex_I;
                }
        }
}

void (*c2s_bra_spinor_e1sf[])() = {
        s_bra_cart2spinor_e1sf,
        p_bra_cart2spinor_e1sf,
        d_bra_cart2spinor_e1sf,
        f_bra_cart2spinor_e1sf,
        g_bra_cart2spinor_e1sf,
        a_bra_cart2spinor_e1sf,
        a_bra_cart2spinor_e1sf,
        a_bra_cart2spinor_e1sf,
};

void (*c2s_bra_spinor_sf[])() = {
        s_bra_cart2spinor_sf,
        p_bra_cart2spinor_sf,
        d_bra_cart2spinor_sf,
        f_bra_cart2spinor_sf,
        g_bra_cart2spinor_sf,
        a_bra_cart2spinor_sf,
        a_bra_cart2spinor_sf,
        a_bra_cart2spinor_sf,
};

void (*c2s_ket_spinor[])() = {
        s_ket_cart2spinor,
        p_ket_cart2spinor,
        d_ket_cart2spinor,
        f_ket_cart2spinor,
        g_ket_cart2spinor,
        a_ket_cart2spinor,
        a_ket_cart2spinor,
        a_ket_cart2spinor,
};

void (*c2s_iket_spinor[])() = {
        s_iket_cart2spinor,
        p_iket_cart2spinor,
        d_iket_cart2spinor,
        f_iket_cart2spinor,
        g_iket_cart2spinor,
        a_iket_cart2spinor,
        a_iket_cart2spinor,
        a_iket_cart2spinor,
};

void (*c2s_bra_spinor_si[])() = {
        s_bra_cart2spinor_si,
        p_bra_cart2spinor_si,
        d_bra_cart2spinor_si,
        f_bra_cart2spinor_si,
        g_bra_cart2spinor_si,
        a_bra_cart2spinor_si,
        a_bra_cart2spinor_si,
        a_bra_cart2spinor_si,
};

/*
 * gspa and gspb for upper and lower components of two component vector
 */
static void a_ket_cart2spinor_e1sf(double complex *gspa, double complex *gspb,
                                   double *gcart,
                                   FINT lds, FINT nbra, FINT kappa, FINT l)
{
        const double complex Z0 = 0;
        const double complex Z1 = 1;
        const char TRANS_N = 'N';
        FINT nf = (l+1)*(l+2)/2;
        FINT nf2 = nf * 2;
        FINT nd = _len_spinor(kappa, l);
        const double complex *coeff_c2s;
        double complex *tmp = malloc(sizeof(double complex)*nf*nbra);
        CINTdcmplx_re(nf*nbra, tmp, gcart);

        if (kappa < 0) { // j = l + 1/2
                coeff_c2s = g_c2s[l].cart2j_gt_l;
        } else {
                coeff_c2s = g_c2s[l].cart2j_lt_l;
        }
        zgemm_(&TRANS_N, &TRANS_N, &nbra, &nd, &nf,
               &Z1, tmp, &nbra, coeff_c2s, &nf2, &Z0, gspa, &lds);
        zgemm_(&TRANS_N, &TRANS_N, &nbra, &nd, &nf,
               &Z1, tmp, &nbra, coeff_c2s+nf, &nf2, &Z0, gspb, &lds);
        free(tmp);
}
// with phase "i"
static void a_iket_cart2spinor_e1sf(double complex *gspa, double complex *gspb,
                                    double *gcart,
                                    FINT lds, FINT nbra, FINT kappa, FINT l)
{
        const double complex Z0 = 0;
        const double complex ZI = 0 + 1 * _Complex_I;
        const char TRANS_N = 'N';
        FINT nf = (l+1)*(l+2)/2;
        FINT nf2 = nf * 2;
        FINT nd = _len_spinor(kappa, l);
        const double complex *coeff_c2s;
        double complex *tmp = malloc(sizeof(double complex)*nf*nbra);
        CINTdcmplx_re(nf*nbra, tmp, gcart);

        if (kappa < 0) { // j = l + 1/2
                coeff_c2s = g_c2s[l].cart2j_gt_l;
        } else {
                coeff_c2s = g_c2s[l].cart2j_lt_l;
        }
        zgemm_(&TRANS_N, &TRANS_N, &nbra, &nd, &nf,
               &ZI, tmp, &nbra, coeff_c2s, &nf2, &Z0, gspa, &lds);
        zgemm_(&TRANS_N, &TRANS_N, &nbra, &nd, &nf,
               &ZI, tmp, &nbra, coeff_c2s+nf, &nf2, &Z0, gspb, &lds);
        free(tmp);
}

static void a_ket_cart2spinor_si(double complex *gspa, double complex *gspb,
                                 double complex *gcart,
                                 FINT lds, FINT nbra, FINT kappa, FINT l)
{
        const double complex Z0 = 0;
        const double complex Z1 = 1;
        const char TRANS_N = 'N';
        FINT nf = (l+1)*(l+2)/2;
        FINT nf2 = nf * 2;
        FINT nd = _len_spinor(kappa, l);
        const double complex *coeff_c2s;
        double complex *gcart1 = gcart + nbra * nf2;

        if (kappa < 0) { // j = l + 1/2
                coeff_c2s = g_c2s[l].cart2j_gt_l;
        } else {
                coeff_c2s = g_c2s[l].cart2j_lt_l;
        }
        zgemm_(&TRANS_N, &TRANS_N, &nbra, &nd, &nf2,
               &Z1, gcart, &nbra, coeff_c2s, &nf2, &Z0, gspa, &lds);
        zgemm_(&TRANS_N, &TRANS_N, &nbra, &nd, &nf2,
               &Z1, gcart1, &nbra, coeff_c2s, &nf2, &Z0, gspb, &lds);
}

static void s_ket_cart2spinor_e1sf(double complex *gspa, double complex *gspb,
                                   double *gcart,
                                   FINT lds, FINT nbra, FINT kappa, FINT l)
{
        FINT i;
        for (i = 0; i < nbra; i++) {
                gspa[    i] = 0;
                gspa[lds+i] = gcart[i];
                gspb[    i] = gcart[i];
                gspb[lds+i] = 0;
        }
}
static void s_iket_cart2spinor_e1sf(double complex *gspa, double complex *gspb,
                                    double *gcart,
                                    FINT lds, FINT nbra, FINT kappa, FINT l)
{
        FINT i;
        for (i = 0; i < nbra; i++) {
                gspa[    i] = 0;
                gspa[lds+i] = gcart[i] * _Complex_I;
                gspb[    i] = gcart[i] * _Complex_I;
                gspb[lds+i] = 0;
        }
}
static void s_ket_cart2spinor_si(double complex *gspa, double complex *gspb,
                                 double complex *gcart,
                                 FINT lds, FINT nbra, FINT kappa, FINT l)
{
        double complex *gcart11 = gcart;
        double complex *gcart12 = gcart11 + nbra;
        double complex *gcart21 = gcart12 + nbra;
        double complex *gcart22 = gcart21 + nbra;
        FINT i;
        for (i = 0; i < nbra; i++) {
                gspa[    i] = gcart12[i];
                gspa[lds+i] = gcart11[i];
                gspb[    i] = gcart22[i];
                gspb[lds+i] = gcart21[i];
        }
}

static void p_ket_cart2spinor_e1sf(double complex *gspa, double complex *gspb,
                                   double *gcart,
                                   FINT lds, FINT nbra, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[1].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[    i] = creal(coeff_c2s[ 0])*gcart[nbra*0+i]
                                    + cimag(coeff_c2s[ 1])*gcart[nbra*1+i]*_Complex_I;
                        gspa[lds+i] = creal(coeff_c2s[ 8])*gcart[nbra*2+i];
                        gspb[    i] = creal(coeff_c2s[ 5])*gcart[nbra*2+i];
                        gspb[lds+i] = creal(coeff_c2s[ 9])*gcart[nbra*0+i]
                                    + cimag(coeff_c2s[10])*gcart[nbra*1+i]*_Complex_I;
                }
                gspa += lds * 2;
                gspb += lds * 2;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[1].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = 0;
                        gspa[1*lds+i] = creal(coeff_c2s[ 6])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[ 7])*gcart[nbra*1+i]*_Complex_I;
                        gspa[2*lds+i] = creal(coeff_c2s[14])*gcart[nbra*2+i];
                        gspa[3*lds+i] = creal(coeff_c2s[18])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[19])*gcart[nbra*1+i]*_Complex_I;
                        gspb[0*lds+i] = creal(coeff_c2s[ 3])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[ 4])*gcart[nbra*1+i]*_Complex_I;
                        gspb[1*lds+i] = creal(coeff_c2s[11])*gcart[nbra*2+i];
                        gspb[2*lds+i] = creal(coeff_c2s[15])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[16])*gcart[nbra*1+i]*_Complex_I;
                        gspb[3*lds+i] = 0;
                }
        }
}
static void p_iket_cart2spinor_e1sf(double complex *gspa, double complex *gspb,
                                    double *gcart,
                                    FINT lds, FINT nbra, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[1].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[    i] = creal(coeff_c2s[ 0])*gcart[nbra*0+i]*_Complex_I
                                    - cimag(coeff_c2s[ 1])*gcart[nbra*1+i];
                        gspa[lds+i] = creal(coeff_c2s[ 8])*gcart[nbra*2+i]*_Complex_I;
                        gspb[    i] = creal(coeff_c2s[ 5])*gcart[nbra*2+i]*_Complex_I;
                        gspb[lds+i] = creal(coeff_c2s[ 9])*gcart[nbra*0+i]*_Complex_I
                                    - cimag(coeff_c2s[10])*gcart[nbra*1+i];
                }
                gspa += lds * 2;
                gspb += lds * 2;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[1].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = 0;
                        gspa[1*lds+i] = creal(coeff_c2s[ 6])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[ 7])*gcart[nbra*1+i];
                        gspa[2*lds+i] = creal(coeff_c2s[14])*gcart[nbra*2+i]*_Complex_I;
                        gspa[3*lds+i] = creal(coeff_c2s[18])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[19])*gcart[nbra*1+i];
                        gspb[0*lds+i] = creal(coeff_c2s[ 3])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[ 4])*gcart[nbra*1+i];
                        gspb[1*lds+i] = creal(coeff_c2s[11])*gcart[nbra*2+i]*_Complex_I;
                        gspb[2*lds+i] = creal(coeff_c2s[15])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[16])*gcart[nbra*1+i];
                        gspb[3*lds+i] = 0;
                }
        }
}
static void p_ket_cart2spinor_si(double complex *gspa, double complex *gspb,
                                 double complex *gcart,
                                 FINT lds, FINT nbra, FINT kappa, FINT l)
{
        double complex *gcart1 = gcart + nbra*6;
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[1].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[    i] = creal(coeff_c2s[ 0])*gcart [nbra*0+i]
                                    + cimag(coeff_c2s[ 1])*gcart [nbra*1+i]*_Complex_I
                                    + creal(coeff_c2s[ 5])*gcart [nbra*5+i];
                        gspa[lds+i] = creal(coeff_c2s[ 8])*gcart [nbra*2+i]
                                    + creal(coeff_c2s[ 9])*gcart [nbra*3+i]
                                    + cimag(coeff_c2s[10])*gcart [nbra*4+i]*_Complex_I;
                        gspb[    i] = creal(coeff_c2s[ 0])*gcart1[nbra*0+i]
                                    + cimag(coeff_c2s[ 1])*gcart1[nbra*1+i]*_Complex_I
                                    + creal(coeff_c2s[ 5])*gcart1[nbra*5+i];
                        gspb[lds+i] = creal(coeff_c2s[ 8])*gcart1[nbra*2+i]
                                    + creal(coeff_c2s[ 9])*gcart1[nbra*3+i]
                                    + cimag(coeff_c2s[10])*gcart1[nbra*4+i]*_Complex_I;
                }
                gspa += lds * 2;
                gspb += lds * 2;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[1].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = creal(coeff_c2s[ 3])*gcart [nbra*3+i]
                                      + cimag(coeff_c2s[ 4])*gcart [nbra*4+i]*_Complex_I;
                        gspa[1*lds+i] = creal(coeff_c2s[ 6])*gcart [nbra*0+i]
                                      + cimag(coeff_c2s[ 7])*gcart [nbra*1+i]*_Complex_I
                                      + creal(coeff_c2s[11])*gcart [nbra*5+i];
                        gspa[2*lds+i] = creal(coeff_c2s[14])*gcart [nbra*2+i]
                                      + creal(coeff_c2s[15])*gcart [nbra*3+i]
                                      + cimag(coeff_c2s[16])*gcart [nbra*4+i]*_Complex_I;
                        gspa[3*lds+i] = creal(coeff_c2s[18])*gcart [nbra*0+i]
                                      + cimag(coeff_c2s[19])*gcart [nbra*1+i]*_Complex_I;
                        gspb[0*lds+i] = creal(coeff_c2s[ 3])*gcart1[nbra*3+i]
                                      + cimag(coeff_c2s[ 4])*gcart1[nbra*4+i]*_Complex_I;
                        gspb[1*lds+i] = creal(coeff_c2s[ 6])*gcart1[nbra*0+i]
                                      + cimag(coeff_c2s[ 7])*gcart1[nbra*1+i]*_Complex_I
                                      + creal(coeff_c2s[11])*gcart1[nbra*5+i];
                        gspb[2*lds+i] = creal(coeff_c2s[14])*gcart1[nbra*2+i]
                                      + creal(coeff_c2s[15])*gcart1[nbra*3+i]
                                      + cimag(coeff_c2s[16])*gcart1[nbra*4+i]*_Complex_I;
                        gspb[3*lds+i] = creal(coeff_c2s[18])*gcart1[nbra*0+i]
                                      + cimag(coeff_c2s[19])*gcart1[nbra*1+i]*_Complex_I;
                }
        }
}

static void d_ket_cart2spinor_e1sf(double complex *gspa, double complex *gspb,
                                   double *gcart,
                                   FINT lds, FINT nbra, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[2].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = creal(coeff_c2s[ 0])*gcart[nbra*0+i]
                                      + creal(coeff_c2s[ 3])*gcart[nbra*3+i]
                                      + cimag(coeff_c2s[ 1])*gcart[nbra*1+i]*_Complex_I;
                        gspa[1*lds+i] = creal(coeff_c2s[14])*gcart[nbra*2+i]
                                      + cimag(coeff_c2s[16])*gcart[nbra*4+i]*_Complex_I;
                        gspa[2*lds+i] = creal(coeff_c2s[24])*gcart[nbra*0+i]
                                      + creal(coeff_c2s[27])*gcart[nbra*3+i]
                                      + creal(coeff_c2s[29])*gcart[nbra*5+i];
                        gspa[3*lds+i] = creal(coeff_c2s[38])*gcart[nbra*2+i]
                                      + cimag(coeff_c2s[40])*gcart[nbra*4+i]*_Complex_I;
                        gspb[0*lds+i] = creal(coeff_c2s[ 8])*gcart[nbra*2+i]
                                      + cimag(coeff_c2s[10])*gcart[nbra*4+i]*_Complex_I;
                        gspb[1*lds+i] = creal(coeff_c2s[18])*gcart[nbra*0+i]
                                      + creal(coeff_c2s[21])*gcart[nbra*3+i]
                                      + creal(coeff_c2s[23])*gcart[nbra*5+i];
                        gspb[2*lds+i] = creal(coeff_c2s[32])*gcart[nbra*2+i]
                                      + cimag(coeff_c2s[34])*gcart[nbra*4+i]*_Complex_I;
                        gspb[3*lds+i] = creal(coeff_c2s[42])*gcart[nbra*0+i]
                                      + creal(coeff_c2s[45])*gcart[nbra*3+i]
                                      + cimag(coeff_c2s[43])*gcart[nbra*1+i]*_Complex_I;
                }
                gspa += lds * 4;
                gspb += lds * 4;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[2].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = 0;
                        gspa[1*lds+i] = creal(coeff_c2s[12])*gcart[nbra*0+i]
                                      + creal(coeff_c2s[15])*gcart[nbra*3+i]
                                      + cimag(coeff_c2s[13])*gcart[nbra*1+i]*_Complex_I;
                        gspa[2*lds+i] = creal(coeff_c2s[26])*gcart[nbra*2+i]
                                      + cimag(coeff_c2s[28])*gcart[nbra*4+i]*_Complex_I;
                        gspa[3*lds+i] = creal(coeff_c2s[36])*gcart[nbra*0+i]
                                      + creal(coeff_c2s[39])*gcart[nbra*3+i]
                                      + creal(coeff_c2s[41])*gcart[nbra*5+i];
                        gspa[4*lds+i] = creal(coeff_c2s[50])*gcart[nbra*2+i]
                                      + cimag(coeff_c2s[52])*gcart[nbra*4+i]*_Complex_I;
                        gspa[5*lds+i] = creal(coeff_c2s[60])*gcart[nbra*0+i]
                                      + creal(coeff_c2s[63])*gcart[nbra*3+i]
                                      + cimag(coeff_c2s[61])*gcart[nbra*1+i]*_Complex_I;
                                      
                        gspb[0*lds+i] = creal(coeff_c2s[ 6])*gcart[nbra*0+i]
                                      + creal(coeff_c2s[ 9])*gcart[nbra*3+i]
                                      + cimag(coeff_c2s[ 7])*gcart[nbra*1+i]*_Complex_I;
                        gspb[1*lds+i] = creal(coeff_c2s[20])*gcart[nbra*2+i]
                                      + cimag(coeff_c2s[22])*gcart[nbra*4+i]*_Complex_I;
                        gspb[2*lds+i] = creal(coeff_c2s[30])*gcart[nbra*0+i]
                                      + creal(coeff_c2s[33])*gcart[nbra*3+i]
                                      + creal(coeff_c2s[35])*gcart[nbra*5+i];
                        gspb[3*lds+i] = creal(coeff_c2s[44])*gcart[nbra*2+i]
                                      + cimag(coeff_c2s[46])*gcart[nbra*4+i]*_Complex_I;
                        gspb[4*lds+i] = creal(coeff_c2s[54])*gcart[nbra*0+i]
                                      + creal(coeff_c2s[57])*gcart[nbra*3+i]
                                      + cimag(coeff_c2s[55])*gcart[nbra*1+i]*_Complex_I;
                        gspb[5*lds+i] = 0;
                }
        }
}
static void d_iket_cart2spinor_e1sf(double complex *gspa, double complex *gspb,
                                    double *gcart,
                                    FINT lds, FINT nbra, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[2].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = creal(coeff_c2s[ 0])*gcart[nbra*0+i]*_Complex_I
                                      + creal(coeff_c2s[ 3])*gcart[nbra*3+i]*_Complex_I
                                      - cimag(coeff_c2s[ 1])*gcart[nbra*1+i];
                        gspa[1*lds+i] = creal(coeff_c2s[14])*gcart[nbra*2+i]*_Complex_I
                                      - cimag(coeff_c2s[16])*gcart[nbra*4+i];
                        gspa[2*lds+i] = creal(coeff_c2s[24])*gcart[nbra*0+i]*_Complex_I
                                      + creal(coeff_c2s[27])*gcart[nbra*3+i]*_Complex_I
                                      + creal(coeff_c2s[29])*gcart[nbra*5+i]*_Complex_I;
                        gspa[3*lds+i] = creal(coeff_c2s[38])*gcart[nbra*2+i]*_Complex_I
                                      - cimag(coeff_c2s[40])*gcart[nbra*4+i];

                        gspb[0*lds+i] = creal(coeff_c2s[ 8])*gcart[nbra*2+i]*_Complex_I
                                      - cimag(coeff_c2s[10])*gcart[nbra*4+i];
                        gspb[1*lds+i] = creal(coeff_c2s[18])*gcart[nbra*0+i]*_Complex_I
                                      + creal(coeff_c2s[21])*gcart[nbra*3+i]*_Complex_I
                                      + creal(coeff_c2s[23])*gcart[nbra*5+i]*_Complex_I;
                        gspb[2*lds+i] = creal(coeff_c2s[32])*gcart[nbra*2+i]*_Complex_I
                                      - cimag(coeff_c2s[34])*gcart[nbra*4+i];
                        gspb[3*lds+i] = creal(coeff_c2s[42])*gcart[nbra*0+i]*_Complex_I
                                      + creal(coeff_c2s[45])*gcart[nbra*3+i]*_Complex_I
                                      - cimag(coeff_c2s[43])*gcart[nbra*1+i];
                }
                gspa += lds * 4;
                gspb += lds * 4;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[2].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = 0;
                        gspa[1*lds+i] = creal(coeff_c2s[12])*gcart[nbra*0+i]*_Complex_I
                                      + creal(coeff_c2s[15])*gcart[nbra*3+i]*_Complex_I
                                      - cimag(coeff_c2s[13])*gcart[nbra*1+i];
                        gspa[2*lds+i] = creal(coeff_c2s[26])*gcart[nbra*2+i]*_Complex_I
                                      - cimag(coeff_c2s[28])*gcart[nbra*4+i];
                        gspa[3*lds+i] = creal(coeff_c2s[36])*gcart[nbra*0+i]*_Complex_I
                                      + creal(coeff_c2s[39])*gcart[nbra*3+i]*_Complex_I
                                      + creal(coeff_c2s[41])*gcart[nbra*5+i]*_Complex_I;
                        gspa[4*lds+i] = creal(coeff_c2s[50])*gcart[nbra*2+i]*_Complex_I
                                      - cimag(coeff_c2s[52])*gcart[nbra*4+i];
                        gspa[5*lds+i] = creal(coeff_c2s[60])*gcart[nbra*0+i]*_Complex_I
                                      + creal(coeff_c2s[63])*gcart[nbra*3+i]*_Complex_I
                                      - cimag(coeff_c2s[61])*gcart[nbra*1+i];
                                     
                        gspb[0*lds+i] = creal(coeff_c2s[ 6])*gcart[nbra*0+i]*_Complex_I
                                      + creal(coeff_c2s[ 9])*gcart[nbra*3+i]*_Complex_I
                                      - cimag(coeff_c2s[ 7])*gcart[nbra*1+i];
                        gspb[1*lds+i] = creal(coeff_c2s[20])*gcart[nbra*2+i]*_Complex_I
                                      - cimag(coeff_c2s[22])*gcart[nbra*4+i];
                        gspb[2*lds+i] = creal(coeff_c2s[30])*gcart[nbra*0+i]*_Complex_I
                                      + creal(coeff_c2s[33])*gcart[nbra*3+i]*_Complex_I
                                      + creal(coeff_c2s[35])*gcart[nbra*5+i]*_Complex_I;
                        gspb[3*lds+i] = creal(coeff_c2s[44])*gcart[nbra*2+i]*_Complex_I
                                      - cimag(coeff_c2s[46])*gcart[nbra*4+i];
                        gspb[4*lds+i] = creal(coeff_c2s[54])*gcart[nbra*0+i]*_Complex_I
                                      + creal(coeff_c2s[57])*gcart[nbra*3+i]*_Complex_I
                                      - cimag(coeff_c2s[55])*gcart[nbra*1+i];
                        gspb[5*lds+i] = 0;
                }
        }
}
static void d_ket_cart2spinor_si(double complex *gspa, double complex *gspb,
                                 double complex *gcart,
                                 FINT lds, FINT nbra, FINT kappa, FINT l)
{
        double complex *gcart1 = gcart + nbra*12;
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[2].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = creal(coeff_c2s[ 0])*gcart [nbra* 0+i]
                                      + creal(coeff_c2s[ 3])*gcart [nbra* 3+i]
                                      + cimag(coeff_c2s[ 1])*gcart [nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 8])*gcart [nbra* 8+i]
                                      + cimag(coeff_c2s[10])*gcart [nbra*10+i]*_Complex_I;
                        gspa[1*lds+i] = creal(coeff_c2s[14])*gcart [nbra* 2+i]
                                      + cimag(coeff_c2s[16])*gcart [nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[18])*gcart [nbra* 6+i]
                                      + creal(coeff_c2s[21])*gcart [nbra* 9+i]
                                      + creal(coeff_c2s[23])*gcart [nbra*11+i];
                        gspa[2*lds+i] = creal(coeff_c2s[24])*gcart [nbra* 0+i]
                                      + creal(coeff_c2s[27])*gcart [nbra* 3+i]
                                      + creal(coeff_c2s[29])*gcart [nbra* 5+i]
                                      + creal(coeff_c2s[32])*gcart [nbra* 8+i]
                                      + cimag(coeff_c2s[34])*gcart [nbra*10+i]*_Complex_I;
                        gspa[3*lds+i] = creal(coeff_c2s[38])*gcart [nbra* 2+i]
                                      + cimag(coeff_c2s[40])*gcart [nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[42])*gcart [nbra* 6+i]
                                      + creal(coeff_c2s[45])*gcart [nbra* 9+i]
                                      + cimag(coeff_c2s[43])*gcart [nbra* 7+i]*_Complex_I;
                        gspb[0*lds+i] = creal(coeff_c2s[ 0])*gcart1[nbra* 0+i]
                                      + creal(coeff_c2s[ 3])*gcart1[nbra* 3+i]
                                      + cimag(coeff_c2s[ 1])*gcart1[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 8])*gcart1[nbra* 8+i]
                                      + cimag(coeff_c2s[10])*gcart1[nbra*10+i]*_Complex_I;
                        gspb[1*lds+i] = creal(coeff_c2s[14])*gcart1[nbra* 2+i]
                                      + cimag(coeff_c2s[16])*gcart1[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[18])*gcart1[nbra* 6+i]
                                      + creal(coeff_c2s[21])*gcart1[nbra* 9+i]
                                      + creal(coeff_c2s[23])*gcart1[nbra*11+i];
                        gspb[2*lds+i] = creal(coeff_c2s[24])*gcart1[nbra* 0+i]
                                      + creal(coeff_c2s[27])*gcart1[nbra* 3+i]
                                      + creal(coeff_c2s[29])*gcart1[nbra* 5+i]
                                      + creal(coeff_c2s[32])*gcart1[nbra* 8+i]
                                      + cimag(coeff_c2s[34])*gcart1[nbra*10+i]*_Complex_I;
                        gspb[3*lds+i] = creal(coeff_c2s[38])*gcart1[nbra* 2+i]
                                      + cimag(coeff_c2s[40])*gcart1[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[42])*gcart1[nbra* 6+i]
                                      + creal(coeff_c2s[45])*gcart1[nbra* 9+i]
                                      + cimag(coeff_c2s[43])*gcart1[nbra* 7+i]*_Complex_I;
                }
                gspa += lds * 4;
                gspb += lds * 4;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[2].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = creal(coeff_c2s[ 6])*gcart [nbra* 6+i]
                                      + creal(coeff_c2s[ 9])*gcart [nbra* 9+i]
                                      + cimag(coeff_c2s[ 7])*gcart [nbra* 7+i]*_Complex_I;
                        gspa[1*lds+i] = creal(coeff_c2s[12])*gcart [nbra* 0+i]
                                      + creal(coeff_c2s[15])*gcart [nbra* 3+i]
                                      + cimag(coeff_c2s[13])*gcart [nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[20])*gcart [nbra* 8+i]
                                      + cimag(coeff_c2s[22])*gcart [nbra*10+i]*_Complex_I;
                        gspa[2*lds+i] = creal(coeff_c2s[26])*gcart [nbra* 2+i]
                                      + cimag(coeff_c2s[28])*gcart [nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[30])*gcart [nbra* 6+i]
                                      + creal(coeff_c2s[33])*gcart [nbra* 9+i]
                                      + creal(coeff_c2s[35])*gcart [nbra*11+i];
                        gspa[3*lds+i] = creal(coeff_c2s[36])*gcart [nbra* 0+i]
                                      + creal(coeff_c2s[39])*gcart [nbra* 3+i]
                                      + creal(coeff_c2s[41])*gcart [nbra* 5+i]
                                      + creal(coeff_c2s[44])*gcart [nbra* 8+i]
                                      + cimag(coeff_c2s[46])*gcart [nbra*10+i]*_Complex_I;
                        gspa[4*lds+i] = creal(coeff_c2s[50])*gcart [nbra* 2+i]
                                      + cimag(coeff_c2s[52])*gcart [nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[54])*gcart [nbra* 6+i]
                                      + creal(coeff_c2s[57])*gcart [nbra* 9+i]
                                      + cimag(coeff_c2s[55])*gcart [nbra* 7+i]*_Complex_I;
                        gspa[5*lds+i] = creal(coeff_c2s[60])*gcart [nbra* 0+i]
                                      + creal(coeff_c2s[63])*gcart [nbra* 3+i]
                                      + cimag(coeff_c2s[61])*gcart [nbra* 1+i]*_Complex_I;
                        gspb[0*lds+i] = creal(coeff_c2s[ 6])*gcart1[nbra* 6+i]
                                      + creal(coeff_c2s[ 9])*gcart1[nbra* 9+i]
                                      + cimag(coeff_c2s[ 7])*gcart1[nbra* 7+i]*_Complex_I;
                        gspb[1*lds+i] = creal(coeff_c2s[12])*gcart1[nbra* 0+i]
                                      + creal(coeff_c2s[15])*gcart1[nbra* 3+i]
                                      + cimag(coeff_c2s[13])*gcart1[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[20])*gcart1[nbra* 8+i]
                                      + cimag(coeff_c2s[22])*gcart1[nbra*10+i]*_Complex_I;
                        gspb[2*lds+i] = creal(coeff_c2s[26])*gcart1[nbra* 2+i]
                                      + cimag(coeff_c2s[28])*gcart1[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[30])*gcart1[nbra* 6+i]
                                      + creal(coeff_c2s[33])*gcart1[nbra* 9+i]
                                      + creal(coeff_c2s[35])*gcart1[nbra*11+i];
                        gspb[3*lds+i] = creal(coeff_c2s[36])*gcart1[nbra* 0+i]
                                      + creal(coeff_c2s[39])*gcart1[nbra* 3+i]
                                      + creal(coeff_c2s[41])*gcart1[nbra* 5+i]
                                      + creal(coeff_c2s[44])*gcart1[nbra* 8+i]
                                      + cimag(coeff_c2s[46])*gcart1[nbra*10+i]*_Complex_I;
                        gspb[4*lds+i] = creal(coeff_c2s[50])*gcart1[nbra* 2+i]
                                      + cimag(coeff_c2s[52])*gcart1[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[54])*gcart1[nbra* 6+i]
                                      + creal(coeff_c2s[57])*gcart1[nbra* 9+i]
                                      + cimag(coeff_c2s[55])*gcart1[nbra* 7+i]*_Complex_I;
                        gspb[5*lds+i] = creal(coeff_c2s[60])*gcart1[nbra* 0+i]
                                      + creal(coeff_c2s[63])*gcart1[nbra* 3+i]
                                      + cimag(coeff_c2s[61])*gcart1[nbra* 1+i]*_Complex_I;
                }
        }
}

static void f_ket_cart2spinor_e1sf(double complex *gspa, double complex *gspb,
                                   double *gcart,
                                   FINT lds, FINT nbra, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[3].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = creal(coeff_c2s[  0])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[  1])*gcart[nbra*1+i]*_Complex_I
                                      + creal(coeff_c2s[  3])*gcart[nbra*3+i]
                                      + cimag(coeff_c2s[  6])*gcart[nbra*6+i]*_Complex_I;
                        gspa[1*lds+i] = creal(coeff_c2s[ 22])*gcart[nbra*2+i]
                                      + cimag(coeff_c2s[ 24])*gcart[nbra*4+i]*_Complex_I
                                      + creal(coeff_c2s[ 27])*gcart[nbra*7+i];
                        gspa[2*lds+i] = creal(coeff_c2s[ 40])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[ 41])*gcart[nbra*1+i]*_Complex_I
                                      + creal(coeff_c2s[ 43])*gcart[nbra*3+i]
                                      + creal(coeff_c2s[ 45])*gcart[nbra*5+i]
                                      + cimag(coeff_c2s[ 46])*gcart[nbra*6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 48])*gcart[nbra*8+i]*_Complex_I;
                        gspa[3*lds+i] = creal(coeff_c2s[ 62])*gcart[nbra*2+i]
                                      + creal(coeff_c2s[ 67])*gcart[nbra*7+i]
                                      + creal(coeff_c2s[ 69])*gcart[nbra*9+i];
                        gspa[4*lds+i] = creal(coeff_c2s[ 80])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[ 81])*gcart[nbra*1+i]*_Complex_I
                                      + creal(coeff_c2s[ 83])*gcart[nbra*3+i]
                                      + creal(coeff_c2s[ 85])*gcart[nbra*5+i]
                                      + cimag(coeff_c2s[ 86])*gcart[nbra*6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 88])*gcart[nbra*8+i]*_Complex_I;
                        gspa[5*lds+i] = creal(coeff_c2s[102])*gcart[nbra*2+i]
                                      + cimag(coeff_c2s[104])*gcart[nbra*4+i]*_Complex_I
                                      + creal(coeff_c2s[107])*gcart[nbra*7+i];
                        gspb[0*lds+i] = creal(coeff_c2s[ 12])*gcart[nbra*2+i]
                                      + cimag(coeff_c2s[ 14])*gcart[nbra*4+i]*_Complex_I
                                      + creal(coeff_c2s[ 17])*gcart[nbra*7+i];
                        gspb[1*lds+i] = creal(coeff_c2s[ 30])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[ 31])*gcart[nbra*1+i]*_Complex_I
                                      + creal(coeff_c2s[ 33])*gcart[nbra*3+i]
                                      + creal(coeff_c2s[ 35])*gcart[nbra*5+i]
                                      + cimag(coeff_c2s[ 36])*gcart[nbra*6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 38])*gcart[nbra*8+i]*_Complex_I;
                        gspb[2*lds+i] = creal(coeff_c2s[ 52])*gcart[nbra*2+i]
                                      + creal(coeff_c2s[ 57])*gcart[nbra*7+i]
                                      + creal(coeff_c2s[ 59])*gcart[nbra*9+i];
                        gspb[3*lds+i] = creal(coeff_c2s[ 70])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[ 71])*gcart[nbra*1+i]*_Complex_I
                                      + creal(coeff_c2s[ 73])*gcart[nbra*3+i]
                                      + creal(coeff_c2s[ 75])*gcart[nbra*5+i]
                                      + cimag(coeff_c2s[ 76])*gcart[nbra*6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 78])*gcart[nbra*8+i]*_Complex_I;
                        gspb[4*lds+i] = creal(coeff_c2s[ 92])*gcart[nbra*2+i]
                                      + cimag(coeff_c2s[ 94])*gcart[nbra*4+i]*_Complex_I
                                      + creal(coeff_c2s[ 97])*gcart[nbra*7+i];
                        gspb[5*lds+i] = creal(coeff_c2s[110])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[111])*gcart[nbra*1+i]*_Complex_I
                                      + creal(coeff_c2s[113])*gcart[nbra*3+i]
                                      + cimag(coeff_c2s[116])*gcart[nbra*6+i]*_Complex_I;
                }
                gspa += lds * 6;
                gspb += lds * 6;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[3].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = 0;
                        gspa[1*lds+i] = creal(coeff_c2s[ 20])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[ 21])*gcart[nbra*1+i]*_Complex_I
                                      + creal(coeff_c2s[ 23])*gcart[nbra*3+i]
                                      + cimag(coeff_c2s[ 26])*gcart[nbra*6+i]*_Complex_I;
                        gspa[2*lds+i] = creal(coeff_c2s[ 42])*gcart[nbra*2+i]
                                      + cimag(coeff_c2s[ 44])*gcart[nbra*4+i]*_Complex_I
                                      + creal(coeff_c2s[ 47])*gcart[nbra*7+i];
                        gspa[3*lds+i] = creal(coeff_c2s[ 60])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[ 61])*gcart[nbra*1+i]*_Complex_I
                                      + creal(coeff_c2s[ 63])*gcart[nbra*3+i]
                                      + creal(coeff_c2s[ 65])*gcart[nbra*5+i]
                                      + cimag(coeff_c2s[ 66])*gcart[nbra*6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 68])*gcart[nbra*8+i]*_Complex_I;
                        gspa[4*lds+i] = creal(coeff_c2s[ 82])*gcart[nbra*2+i]
                                      + creal(coeff_c2s[ 87])*gcart[nbra*7+i]
                                      + creal(coeff_c2s[ 89])*gcart[nbra*9+i];
                        gspa[5*lds+i] = creal(coeff_c2s[100])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[101])*gcart[nbra*1+i]*_Complex_I
                                      + creal(coeff_c2s[103])*gcart[nbra*3+i]
                                      + creal(coeff_c2s[105])*gcart[nbra*5+i]
                                      + cimag(coeff_c2s[106])*gcart[nbra*6+i]*_Complex_I
                                      + cimag(coeff_c2s[108])*gcart[nbra*8+i]*_Complex_I;
                        gspa[6*lds+i] = creal(coeff_c2s[122])*gcart[nbra*2+i]
                                      + cimag(coeff_c2s[124])*gcart[nbra*4+i]*_Complex_I
                                      + creal(coeff_c2s[127])*gcart[nbra*7+i];
                        gspa[7*lds+i] = creal(coeff_c2s[140])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[141])*gcart[nbra*1+i]*_Complex_I
                                      + creal(coeff_c2s[143])*gcart[nbra*3+i]
                                      + cimag(coeff_c2s[146])*gcart[nbra*6+i]*_Complex_I;
                        gspb[0*lds+i] = creal(coeff_c2s[ 10])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[ 11])*gcart[nbra*1+i]*_Complex_I
                                      + creal(coeff_c2s[ 13])*gcart[nbra*3+i]
                                      + cimag(coeff_c2s[ 16])*gcart[nbra*6+i]*_Complex_I;
                        gspb[1*lds+i] = creal(coeff_c2s[ 32])*gcart[nbra*2+i]
                                      + cimag(coeff_c2s[ 34])*gcart[nbra*4+i]*_Complex_I
                                      + creal(coeff_c2s[ 37])*gcart[nbra*7+i];
                        gspb[2*lds+i] = creal(coeff_c2s[ 50])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[ 51])*gcart[nbra*1+i]*_Complex_I
                                      + creal(coeff_c2s[ 53])*gcart[nbra*3+i]
                                      + creal(coeff_c2s[ 55])*gcart[nbra*5+i]
                                      + cimag(coeff_c2s[ 56])*gcart[nbra*6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 58])*gcart[nbra*8+i]*_Complex_I;
                        gspb[3*lds+i] = creal(coeff_c2s[ 72])*gcart[nbra*2+i]
                                      + creal(coeff_c2s[ 77])*gcart[nbra*7+i]
                                      + creal(coeff_c2s[ 79])*gcart[nbra*9+i];
                        gspb[4*lds+i] = creal(coeff_c2s[ 90])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[ 91])*gcart[nbra*1+i]*_Complex_I
                                      + creal(coeff_c2s[ 93])*gcart[nbra*3+i]
                                      + creal(coeff_c2s[ 95])*gcart[nbra*5+i]
                                      + cimag(coeff_c2s[ 96])*gcart[nbra*6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 98])*gcart[nbra*8+i]*_Complex_I;
                        gspb[5*lds+i] = creal(coeff_c2s[112])*gcart[nbra*2+i]
                                      + cimag(coeff_c2s[114])*gcart[nbra*4+i]*_Complex_I
                                      + creal(coeff_c2s[117])*gcart[nbra*7+i];
                        gspb[6*lds+i] = creal(coeff_c2s[130])*gcart[nbra*0+i]
                                      + cimag(coeff_c2s[131])*gcart[nbra*1+i]*_Complex_I
                                      + creal(coeff_c2s[133])*gcart[nbra*3+i]
                                      + cimag(coeff_c2s[136])*gcart[nbra*6+i]*_Complex_I;
                        gspb[7*lds+i] = 0;
                }
        }
}
static void f_iket_cart2spinor_e1sf(double complex *gspa, double complex *gspb,
                                    double *gcart,
                                    FINT lds, FINT nbra, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[3].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = creal(coeff_c2s[  0])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[  1])*gcart[nbra*1+i]
                                      + creal(coeff_c2s[  3])*gcart[nbra*3+i]*_Complex_I
                                      - cimag(coeff_c2s[  6])*gcart[nbra*6+i];
                        gspa[1*lds+i] = creal(coeff_c2s[ 22])*gcart[nbra*2+i]*_Complex_I
                                      - cimag(coeff_c2s[ 24])*gcart[nbra*4+i]
                                      + creal(coeff_c2s[ 27])*gcart[nbra*7+i]*_Complex_I;
                        gspa[2*lds+i] = creal(coeff_c2s[ 40])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[ 41])*gcart[nbra*1+i]
                                      + creal(coeff_c2s[ 43])*gcart[nbra*3+i]*_Complex_I
                                      + creal(coeff_c2s[ 45])*gcart[nbra*5+i]*_Complex_I
                                      - cimag(coeff_c2s[ 46])*gcart[nbra*6+i]
                                      - cimag(coeff_c2s[ 48])*gcart[nbra*8+i];
                        gspa[3*lds+i] = creal(coeff_c2s[ 62])*gcart[nbra*2+i]*_Complex_I
                                      + creal(coeff_c2s[ 67])*gcart[nbra*7+i]*_Complex_I
                                      + creal(coeff_c2s[ 69])*gcart[nbra*9+i]*_Complex_I;
                        gspa[4*lds+i] = creal(coeff_c2s[ 80])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[ 81])*gcart[nbra*1+i]
                                      + creal(coeff_c2s[ 83])*gcart[nbra*3+i]*_Complex_I
                                      + creal(coeff_c2s[ 85])*gcart[nbra*5+i]*_Complex_I
                                      - cimag(coeff_c2s[ 86])*gcart[nbra*6+i]
                                      - cimag(coeff_c2s[ 88])*gcart[nbra*8+i];
                        gspa[5*lds+i] = creal(coeff_c2s[102])*gcart[nbra*2+i]*_Complex_I
                                      - cimag(coeff_c2s[104])*gcart[nbra*4+i]
                                      + creal(coeff_c2s[107])*gcart[nbra*7+i]*_Complex_I;
                        gspb[0*lds+i] = creal(coeff_c2s[ 12])*gcart[nbra*2+i]*_Complex_I
                                      - cimag(coeff_c2s[ 14])*gcart[nbra*4+i]
                                      + creal(coeff_c2s[ 17])*gcart[nbra*7+i]*_Complex_I;
                        gspb[1*lds+i] = creal(coeff_c2s[ 30])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[ 31])*gcart[nbra*1+i]
                                      + creal(coeff_c2s[ 33])*gcart[nbra*3+i]*_Complex_I
                                      + creal(coeff_c2s[ 35])*gcart[nbra*5+i]*_Complex_I
                                      - cimag(coeff_c2s[ 36])*gcart[nbra*6+i]
                                      - cimag(coeff_c2s[ 38])*gcart[nbra*8+i];
                        gspb[2*lds+i] = creal(coeff_c2s[ 52])*gcart[nbra*2+i]*_Complex_I
                                      + creal(coeff_c2s[ 57])*gcart[nbra*7+i]*_Complex_I
                                      + creal(coeff_c2s[ 59])*gcart[nbra*9+i]*_Complex_I;
                        gspb[3*lds+i] = creal(coeff_c2s[ 70])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[ 71])*gcart[nbra*1+i]
                                      + creal(coeff_c2s[ 73])*gcart[nbra*3+i]*_Complex_I
                                      + creal(coeff_c2s[ 75])*gcart[nbra*5+i]*_Complex_I
                                      - cimag(coeff_c2s[ 76])*gcart[nbra*6+i]
                                      - cimag(coeff_c2s[ 78])*gcart[nbra*8+i];
                        gspb[4*lds+i] = creal(coeff_c2s[ 92])*gcart[nbra*2+i]*_Complex_I
                                      - cimag(coeff_c2s[ 94])*gcart[nbra*4+i]
                                      + creal(coeff_c2s[ 97])*gcart[nbra*7+i]*_Complex_I;
                        gspb[5*lds+i] = creal(coeff_c2s[110])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[111])*gcart[nbra*1+i]
                                      + creal(coeff_c2s[113])*gcart[nbra*3+i]*_Complex_I
                                      - cimag(coeff_c2s[116])*gcart[nbra*6+i];
                }
                gspa += lds * 6;
                gspb += lds * 6;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[3].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = 0;
                        gspa[1*lds+i] = creal(coeff_c2s[ 20])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[ 21])*gcart[nbra*1+i]
                                      + creal(coeff_c2s[ 23])*gcart[nbra*3+i]*_Complex_I
                                      - cimag(coeff_c2s[ 26])*gcart[nbra*6+i];
                        gspa[2*lds+i] = creal(coeff_c2s[ 42])*gcart[nbra*2+i]*_Complex_I
                                      - cimag(coeff_c2s[ 44])*gcart[nbra*4+i]
                                      + creal(coeff_c2s[ 47])*gcart[nbra*7+i]*_Complex_I;
                        gspa[3*lds+i] = creal(coeff_c2s[ 60])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[ 61])*gcart[nbra*1+i]
                                      + creal(coeff_c2s[ 63])*gcart[nbra*3+i]*_Complex_I
                                      + creal(coeff_c2s[ 65])*gcart[nbra*5+i]*_Complex_I
                                      - cimag(coeff_c2s[ 66])*gcart[nbra*6+i]
                                      - cimag(coeff_c2s[ 68])*gcart[nbra*8+i];
                        gspa[4*lds+i] = creal(coeff_c2s[ 82])*gcart[nbra*2+i]*_Complex_I
                                      + creal(coeff_c2s[ 87])*gcart[nbra*7+i]*_Complex_I
                                      + creal(coeff_c2s[ 89])*gcart[nbra*9+i]*_Complex_I;
                        gspa[5*lds+i] = creal(coeff_c2s[100])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[101])*gcart[nbra*1+i]
                                      + creal(coeff_c2s[103])*gcart[nbra*3+i]*_Complex_I
                                      + creal(coeff_c2s[105])*gcart[nbra*5+i]*_Complex_I
                                      - cimag(coeff_c2s[106])*gcart[nbra*6+i]
                                      - cimag(coeff_c2s[108])*gcart[nbra*8+i];
                        gspa[6*lds+i] = creal(coeff_c2s[122])*gcart[nbra*2+i]*_Complex_I
                                      - cimag(coeff_c2s[124])*gcart[nbra*4+i]
                                      + creal(coeff_c2s[127])*gcart[nbra*7+i]*_Complex_I;
                        gspa[7*lds+i] = creal(coeff_c2s[140])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[141])*gcart[nbra*1+i]
                                      + creal(coeff_c2s[143])*gcart[nbra*3+i]*_Complex_I
                                      - cimag(coeff_c2s[146])*gcart[nbra*6+i];
                        gspb[0*lds+i] = creal(coeff_c2s[ 10])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[ 11])*gcart[nbra*1+i]
                                      + creal(coeff_c2s[ 13])*gcart[nbra*3+i]*_Complex_I
                                      - cimag(coeff_c2s[ 16])*gcart[nbra*6+i];
                        gspb[1*lds+i] = creal(coeff_c2s[ 32])*gcart[nbra*2+i]*_Complex_I
                                      - cimag(coeff_c2s[ 34])*gcart[nbra*4+i]
                                      + creal(coeff_c2s[ 37])*gcart[nbra*7+i]*_Complex_I;
                        gspb[2*lds+i] = creal(coeff_c2s[ 50])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[ 51])*gcart[nbra*1+i]
                                      + creal(coeff_c2s[ 53])*gcart[nbra*3+i]*_Complex_I
                                      + creal(coeff_c2s[ 55])*gcart[nbra*5+i]*_Complex_I
                                      - cimag(coeff_c2s[ 56])*gcart[nbra*6+i]
                                      - cimag(coeff_c2s[ 58])*gcart[nbra*8+i];
                        gspb[3*lds+i] = creal(coeff_c2s[ 72])*gcart[nbra*2+i]*_Complex_I
                                      + creal(coeff_c2s[ 77])*gcart[nbra*7+i]*_Complex_I
                                      + creal(coeff_c2s[ 79])*gcart[nbra*9+i]*_Complex_I;
                        gspb[4*lds+i] = creal(coeff_c2s[ 90])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[ 91])*gcart[nbra*1+i]
                                      + creal(coeff_c2s[ 93])*gcart[nbra*3+i]*_Complex_I
                                      + creal(coeff_c2s[ 95])*gcart[nbra*5+i]*_Complex_I
                                      - cimag(coeff_c2s[ 96])*gcart[nbra*6+i]
                                      - cimag(coeff_c2s[ 98])*gcart[nbra*8+i];
                        gspb[5*lds+i] = creal(coeff_c2s[112])*gcart[nbra*2+i]*_Complex_I
                                      - cimag(coeff_c2s[114])*gcart[nbra*4+i]
                                      + creal(coeff_c2s[117])*gcart[nbra*7+i]*_Complex_I;
                        gspb[6*lds+i] = creal(coeff_c2s[130])*gcart[nbra*0+i]*_Complex_I
                                      - cimag(coeff_c2s[131])*gcart[nbra*1+i]
                                      + creal(coeff_c2s[133])*gcart[nbra*3+i]*_Complex_I
                                      - cimag(coeff_c2s[136])*gcart[nbra*6+i];
                        gspb[7*lds+i] = 0;
                }
        }
}
static void f_ket_cart2spinor_si(double complex *gspa, double complex *gspb,
                                 double complex *gcart,
                                 FINT lds, FINT nbra, FINT kappa, FINT l)
{
        double complex *gcart1 = gcart + nbra*20;
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[3].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = creal(coeff_c2s[  0])*gcart [nbra* 0+i]
                                      + cimag(coeff_c2s[  1])*gcart [nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[  3])*gcart [nbra* 3+i]
                                      + cimag(coeff_c2s[  6])*gcart [nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[ 12])*gcart [nbra*12+i]
                                      + cimag(coeff_c2s[ 14])*gcart [nbra*14+i]*_Complex_I
                                      + creal(coeff_c2s[ 17])*gcart [nbra*17+i];
                        gspa[1*lds+i] = creal(coeff_c2s[ 22])*gcart [nbra* 2+i]
                                      + cimag(coeff_c2s[ 24])*gcart [nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[ 27])*gcart [nbra* 7+i]
                                      + creal(coeff_c2s[ 30])*gcart [nbra*10+i]
                                      + cimag(coeff_c2s[ 31])*gcart [nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[ 33])*gcart [nbra*13+i]
                                      + creal(coeff_c2s[ 35])*gcart [nbra*15+i]
                                      + cimag(coeff_c2s[ 36])*gcart [nbra*16+i]*_Complex_I
                                      + cimag(coeff_c2s[ 38])*gcart [nbra*18+i]*_Complex_I;
                        gspa[2*lds+i] = creal(coeff_c2s[ 40])*gcart [nbra* 0+i]
                                      + cimag(coeff_c2s[ 41])*gcart [nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 43])*gcart [nbra* 3+i]
                                      + creal(coeff_c2s[ 45])*gcart [nbra* 5+i]
                                      + cimag(coeff_c2s[ 46])*gcart [nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 48])*gcart [nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[ 52])*gcart [nbra*12+i]
                                      + creal(coeff_c2s[ 57])*gcart [nbra*17+i]
                                      + creal(coeff_c2s[ 59])*gcart [nbra*19+i];
                        gspa[3*lds+i] = creal(coeff_c2s[ 62])*gcart [nbra* 2+i]
                                      + creal(coeff_c2s[ 67])*gcart [nbra* 7+i]
                                      + creal(coeff_c2s[ 69])*gcart [nbra* 9+i]
                                      + creal(coeff_c2s[ 70])*gcart [nbra*10+i]
                                      + cimag(coeff_c2s[ 71])*gcart [nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[ 73])*gcart [nbra*13+i]
                                      + creal(coeff_c2s[ 75])*gcart [nbra*15+i]
                                      + cimag(coeff_c2s[ 76])*gcart [nbra*16+i]*_Complex_I
                                      + cimag(coeff_c2s[ 78])*gcart [nbra*18+i]*_Complex_I;
                        gspa[4*lds+i] = creal(coeff_c2s[ 80])*gcart [nbra* 0+i]
                                      + cimag(coeff_c2s[ 81])*gcart [nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 83])*gcart [nbra* 3+i]
                                      + creal(coeff_c2s[ 85])*gcart [nbra* 5+i]
                                      + cimag(coeff_c2s[ 86])*gcart [nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 88])*gcart [nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[ 92])*gcart [nbra*12+i]
                                      + cimag(coeff_c2s[ 94])*gcart [nbra*14+i]*_Complex_I
                                      + creal(coeff_c2s[ 97])*gcart [nbra*17+i];
                        gspa[5*lds+i] = creal(coeff_c2s[102])*gcart [nbra* 2+i]
                                      + cimag(coeff_c2s[104])*gcart [nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[107])*gcart [nbra* 7+i]
                                      + creal(coeff_c2s[110])*gcart [nbra*10+i]
                                      + cimag(coeff_c2s[111])*gcart [nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[113])*gcart [nbra*13+i]
                                      + cimag(coeff_c2s[116])*gcart [nbra*16+i]*_Complex_I;
                        gspb[0*lds+i] = creal(coeff_c2s[  0])*gcart1[nbra* 0+i]
                                      + cimag(coeff_c2s[  1])*gcart1[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[  3])*gcart1[nbra* 3+i]
                                      + cimag(coeff_c2s[  6])*gcart1[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[ 12])*gcart1[nbra*12+i]
                                      + cimag(coeff_c2s[ 14])*gcart1[nbra*14+i]*_Complex_I
                                      + creal(coeff_c2s[ 17])*gcart1[nbra*17+i];
                        gspb[1*lds+i] = creal(coeff_c2s[ 22])*gcart1[nbra* 2+i]
                                      + cimag(coeff_c2s[ 24])*gcart1[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[ 27])*gcart1[nbra* 7+i]
                                      + creal(coeff_c2s[ 30])*gcart1[nbra*10+i]
                                      + cimag(coeff_c2s[ 31])*gcart1[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[ 33])*gcart1[nbra*13+i]
                                      + creal(coeff_c2s[ 35])*gcart1[nbra*15+i]
                                      + cimag(coeff_c2s[ 36])*gcart1[nbra*16+i]*_Complex_I
                                      + cimag(coeff_c2s[ 38])*gcart1[nbra*18+i]*_Complex_I;
                        gspb[2*lds+i] = creal(coeff_c2s[ 40])*gcart1[nbra* 0+i]
                                      + cimag(coeff_c2s[ 41])*gcart1[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 43])*gcart1[nbra* 3+i]
                                      + creal(coeff_c2s[ 45])*gcart1[nbra* 5+i]
                                      + cimag(coeff_c2s[ 46])*gcart1[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 48])*gcart1[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[ 52])*gcart1[nbra*12+i]
                                      + creal(coeff_c2s[ 57])*gcart1[nbra*17+i]
                                      + creal(coeff_c2s[ 59])*gcart1[nbra*19+i];
                        gspb[3*lds+i] = creal(coeff_c2s[ 62])*gcart1[nbra* 2+i]
                                      + creal(coeff_c2s[ 67])*gcart1[nbra* 7+i]
                                      + creal(coeff_c2s[ 69])*gcart1[nbra* 9+i]
                                      + creal(coeff_c2s[ 70])*gcart1[nbra*10+i]
                                      + cimag(coeff_c2s[ 71])*gcart1[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[ 73])*gcart1[nbra*13+i]
                                      + creal(coeff_c2s[ 75])*gcart1[nbra*15+i]
                                      + cimag(coeff_c2s[ 76])*gcart1[nbra*16+i]*_Complex_I
                                      + cimag(coeff_c2s[ 78])*gcart1[nbra*18+i]*_Complex_I;
                        gspb[4*lds+i] = creal(coeff_c2s[ 80])*gcart1[nbra* 0+i]
                                      + cimag(coeff_c2s[ 81])*gcart1[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 83])*gcart1[nbra* 3+i]
                                      + creal(coeff_c2s[ 85])*gcart1[nbra* 5+i]
                                      + cimag(coeff_c2s[ 86])*gcart1[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 88])*gcart1[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[ 92])*gcart1[nbra*12+i]
                                      + cimag(coeff_c2s[ 94])*gcart1[nbra*14+i]*_Complex_I
                                      + creal(coeff_c2s[ 97])*gcart1[nbra*17+i];
                        gspb[5*lds+i] = creal(coeff_c2s[102])*gcart1[nbra* 2+i]
                                      + cimag(coeff_c2s[104])*gcart1[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[107])*gcart1[nbra* 7+i]
                                      + creal(coeff_c2s[110])*gcart1[nbra*10+i]
                                      + cimag(coeff_c2s[111])*gcart1[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[113])*gcart1[nbra*13+i]
                                      + cimag(coeff_c2s[116])*gcart1[nbra*16+i]*_Complex_I;
                }
                gspa += lds * 6;
                gspb += lds * 6;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[3].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = creal(coeff_c2s[ 10])*gcart [nbra*10+i]
                                      + cimag(coeff_c2s[ 11])*gcart [nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[ 13])*gcart [nbra*13+i]
                                      + cimag(coeff_c2s[ 16])*gcart [nbra*16+i]*_Complex_I;
                        gspa[1*lds+i] = creal(coeff_c2s[ 20])*gcart [nbra* 0+i]
                                      + cimag(coeff_c2s[ 21])*gcart [nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 23])*gcart [nbra* 3+i]
                                      + cimag(coeff_c2s[ 26])*gcart [nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[ 32])*gcart [nbra*12+i]
                                      + cimag(coeff_c2s[ 34])*gcart [nbra*14+i]*_Complex_I
                                      + creal(coeff_c2s[ 37])*gcart [nbra*17+i];
                        gspa[2*lds+i] = creal(coeff_c2s[ 42])*gcart [nbra* 2+i]
                                      + cimag(coeff_c2s[ 44])*gcart [nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[ 47])*gcart [nbra* 7+i]
                                      + creal(coeff_c2s[ 50])*gcart [nbra*10+i]
                                      + cimag(coeff_c2s[ 51])*gcart [nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[ 53])*gcart [nbra*13+i]
                                      + creal(coeff_c2s[ 55])*gcart [nbra*15+i]
                                      + cimag(coeff_c2s[ 56])*gcart [nbra*16+i]*_Complex_I
                                      + cimag(coeff_c2s[ 58])*gcart [nbra*18+i]*_Complex_I;
                        gspa[3*lds+i] = creal(coeff_c2s[ 60])*gcart [nbra* 0+i]
                                      + cimag(coeff_c2s[ 61])*gcart [nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 63])*gcart [nbra* 3+i]
                                      + creal(coeff_c2s[ 65])*gcart [nbra* 5+i]
                                      + cimag(coeff_c2s[ 66])*gcart [nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 68])*gcart [nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[ 72])*gcart [nbra*12+i]
                                      + creal(coeff_c2s[ 77])*gcart [nbra*17+i]
                                      + creal(coeff_c2s[ 79])*gcart [nbra*19+i];
                        gspa[4*lds+i] = creal(coeff_c2s[ 82])*gcart [nbra* 2+i]
                                      + creal(coeff_c2s[ 87])*gcart [nbra* 7+i]
                                      + creal(coeff_c2s[ 89])*gcart [nbra* 9+i]
                                      + creal(coeff_c2s[ 90])*gcart [nbra*10+i]
                                      + cimag(coeff_c2s[ 91])*gcart [nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[ 93])*gcart [nbra*13+i]
                                      + creal(coeff_c2s[ 95])*gcart [nbra*15+i]
                                      + cimag(coeff_c2s[ 96])*gcart [nbra*16+i]*_Complex_I
                                      + cimag(coeff_c2s[ 98])*gcart [nbra*18+i]*_Complex_I;
                        gspa[5*lds+i] = creal(coeff_c2s[100])*gcart [nbra* 0+i]
                                      + cimag(coeff_c2s[101])*gcart [nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[103])*gcart [nbra* 3+i]
                                      + creal(coeff_c2s[105])*gcart [nbra* 5+i]
                                      + cimag(coeff_c2s[106])*gcart [nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[108])*gcart [nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[112])*gcart [nbra*12+i]
                                      + cimag(coeff_c2s[114])*gcart [nbra*14+i]*_Complex_I
                                      + creal(coeff_c2s[117])*gcart [nbra*17+i];
                        gspa[6*lds+i] = creal(coeff_c2s[122])*gcart [nbra* 2+i]
                                      + cimag(coeff_c2s[124])*gcart [nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[127])*gcart [nbra* 7+i]
                                      + creal(coeff_c2s[130])*gcart [nbra*10+i]
                                      + cimag(coeff_c2s[131])*gcart [nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[133])*gcart [nbra*13+i]
                                      + cimag(coeff_c2s[136])*gcart [nbra*16+i]*_Complex_I;
                        gspa[7*lds+i] = creal(coeff_c2s[140])*gcart [nbra* 0+i]
                                      + cimag(coeff_c2s[141])*gcart [nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[143])*gcart [nbra* 3+i]
                                      + cimag(coeff_c2s[146])*gcart [nbra* 6+i]*_Complex_I;
                        gspb[0*lds+i] = creal(coeff_c2s[ 10])*gcart1[nbra*10+i]
                                      + cimag(coeff_c2s[ 11])*gcart1[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[ 13])*gcart1[nbra*13+i]
                                      + cimag(coeff_c2s[ 16])*gcart1[nbra*16+i]*_Complex_I;
                        gspb[1*lds+i] = creal(coeff_c2s[ 20])*gcart1[nbra* 0+i]
                                      + cimag(coeff_c2s[ 21])*gcart1[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 23])*gcart1[nbra* 3+i]
                                      + cimag(coeff_c2s[ 26])*gcart1[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[ 32])*gcart1[nbra*12+i]
                                      + cimag(coeff_c2s[ 34])*gcart1[nbra*14+i]*_Complex_I
                                      + creal(coeff_c2s[ 37])*gcart1[nbra*17+i];
                        gspb[2*lds+i] = creal(coeff_c2s[ 42])*gcart1[nbra* 2+i]
                                      + cimag(coeff_c2s[ 44])*gcart1[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[ 47])*gcart1[nbra* 7+i]
                                      + creal(coeff_c2s[ 50])*gcart1[nbra*10+i]
                                      + cimag(coeff_c2s[ 51])*gcart1[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[ 53])*gcart1[nbra*13+i]
                                      + creal(coeff_c2s[ 55])*gcart1[nbra*15+i]
                                      + cimag(coeff_c2s[ 56])*gcart1[nbra*16+i]*_Complex_I
                                      + cimag(coeff_c2s[ 58])*gcart1[nbra*18+i]*_Complex_I;
                        gspb[3*lds+i] = creal(coeff_c2s[ 60])*gcart1[nbra* 0+i]
                                      + cimag(coeff_c2s[ 61])*gcart1[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 63])*gcart1[nbra* 3+i]
                                      + creal(coeff_c2s[ 65])*gcart1[nbra* 5+i]
                                      + cimag(coeff_c2s[ 66])*gcart1[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 68])*gcart1[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[ 72])*gcart1[nbra*12+i]
                                      + creal(coeff_c2s[ 77])*gcart1[nbra*17+i]
                                      + creal(coeff_c2s[ 79])*gcart1[nbra*19+i];
                        gspb[4*lds+i] = creal(coeff_c2s[ 82])*gcart1[nbra* 2+i]
                                      + creal(coeff_c2s[ 87])*gcart1[nbra* 7+i]
                                      + creal(coeff_c2s[ 89])*gcart1[nbra* 9+i]
                                      + creal(coeff_c2s[ 90])*gcart1[nbra*10+i]
                                      + cimag(coeff_c2s[ 91])*gcart1[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[ 93])*gcart1[nbra*13+i]
                                      + creal(coeff_c2s[ 95])*gcart1[nbra*15+i]
                                      + cimag(coeff_c2s[ 96])*gcart1[nbra*16+i]*_Complex_I
                                      + cimag(coeff_c2s[ 98])*gcart1[nbra*18+i]*_Complex_I;
                        gspb[5*lds+i] = creal(coeff_c2s[100])*gcart1[nbra* 0+i]
                                      + cimag(coeff_c2s[101])*gcart1[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[103])*gcart1[nbra* 3+i]
                                      + creal(coeff_c2s[105])*gcart1[nbra* 5+i]
                                      + cimag(coeff_c2s[106])*gcart1[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[108])*gcart1[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[112])*gcart1[nbra*12+i]
                                      + cimag(coeff_c2s[114])*gcart1[nbra*14+i]*_Complex_I
                                      + creal(coeff_c2s[117])*gcart1[nbra*17+i];
                        gspb[6*lds+i] = creal(coeff_c2s[122])*gcart1[nbra* 2+i]
                                      + cimag(coeff_c2s[124])*gcart1[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[127])*gcart1[nbra* 7+i]
                                      + creal(coeff_c2s[130])*gcart1[nbra*10+i]
                                      + cimag(coeff_c2s[131])*gcart1[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[133])*gcart1[nbra*13+i]
                                      + cimag(coeff_c2s[136])*gcart1[nbra*16+i]*_Complex_I;
                        gspb[7*lds+i] = creal(coeff_c2s[140])*gcart1[nbra* 0+i]
                                      + cimag(coeff_c2s[141])*gcart1[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[143])*gcart1[nbra* 3+i]
                                      + cimag(coeff_c2s[146])*gcart1[nbra* 6+i]*_Complex_I;
                }
        }
}

static void g_ket_cart2spinor_e1sf(double complex *gspa, double complex *gspb,
                                   double *gcart,
                                   FINT lds, FINT nbra, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[4].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = creal(coeff_c2s[ 0]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[ 1]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 3]) * gcart[nbra* 3+i]
                                      + cimag(coeff_c2s[ 6]) * gcart[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[10]) * gcart[nbra*10+i];
                        gspa[1*lds+i] = creal(coeff_c2s[32]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[34]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[37]) * gcart[nbra* 7+i]
                                      + cimag(coeff_c2s[41]) * gcart[nbra*11+i]*_Complex_I;
                        gspa[2*lds+i] = creal(coeff_c2s[60]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[61]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[65]) * gcart[nbra* 5+i]
                                      + cimag(coeff_c2s[66]) * gcart[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[68]) * gcart[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[70]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[72]) * gcart[nbra*12+i];
                        gspa[3*lds+i] = creal(coeff_c2s[92]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[94]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[97]) * gcart[nbra* 7+i]
                                      + creal(coeff_c2s[99]) * gcart[nbra* 9+i]
                                      + cimag(coeff_c2s[101]) * gcart[nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[103]) * gcart[nbra*13+i]*_Complex_I;
                        gspa[4*lds+i] = creal(coeff_c2s[120]) * gcart[nbra* 0+i]
                                      + creal(coeff_c2s[123]) * gcart[nbra* 3+i]
                                      + creal(coeff_c2s[125]) * gcart[nbra* 5+i]
                                      + creal(coeff_c2s[130]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[132]) * gcart[nbra*12+i]
                                      + creal(coeff_c2s[134]) * gcart[nbra*14+i];
                        gspa[5*lds+i] = creal(coeff_c2s[152]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[154]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[157]) * gcart[nbra* 7+i]
                                      + creal(coeff_c2s[159]) * gcart[nbra* 9+i]
                                      + cimag(coeff_c2s[161]) * gcart[nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[163]) * gcart[nbra*13+i]*_Complex_I;
                        gspa[6*lds+i] = creal(coeff_c2s[180]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[181]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[185]) * gcart[nbra* 5+i]
                                      + cimag(coeff_c2s[186]) * gcart[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[188]) * gcart[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[190]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[192]) * gcart[nbra*12+i];
                        gspa[7*lds+i] = creal(coeff_c2s[212]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[214]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[217]) * gcart[nbra* 7+i]
                                      + cimag(coeff_c2s[221]) * gcart[nbra*11+i]*_Complex_I;
                        gspb[0*lds+i] = creal(coeff_c2s[17]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[19]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[22]) * gcart[nbra* 7+i]
                                      + cimag(coeff_c2s[26]) * gcart[nbra*11+i]*_Complex_I;
                        gspb[1*lds+i] = creal(coeff_c2s[45]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[46]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[50]) * gcart[nbra* 5+i]
                                      + cimag(coeff_c2s[51]) * gcart[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[53]) * gcart[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[55]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[57]) * gcart[nbra*12+i];
                        gspb[2*lds+i] = creal(coeff_c2s[77]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[79]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[82]) * gcart[nbra* 7+i]
                                      + creal(coeff_c2s[84]) * gcart[nbra* 9+i]
                                      + cimag(coeff_c2s[86]) * gcart[nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[88]) * gcart[nbra*13+i]*_Complex_I;
                        gspb[3*lds+i] = creal(coeff_c2s[105]) * gcart[nbra* 0+i]
                                      + creal(coeff_c2s[108]) * gcart[nbra* 3+i]
                                      + creal(coeff_c2s[110]) * gcart[nbra* 5+i]
                                      + creal(coeff_c2s[115]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[117]) * gcart[nbra*12+i]
                                      + creal(coeff_c2s[119]) * gcart[nbra*14+i];
                        gspb[4*lds+i] = creal(coeff_c2s[137]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[139]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[142]) * gcart[nbra* 7+i]
                                      + creal(coeff_c2s[144]) * gcart[nbra* 9+i]
                                      + cimag(coeff_c2s[146]) * gcart[nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[148]) * gcart[nbra*13+i]*_Complex_I;
                        gspb[5*lds+i] = creal(coeff_c2s[165]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[166]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[170]) * gcart[nbra* 5+i]
                                      + cimag(coeff_c2s[171]) * gcart[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[173]) * gcart[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[175]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[177]) * gcart[nbra*12+i];
                        gspb[6*lds+i] = creal(coeff_c2s[197]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[199]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[202]) * gcart[nbra* 7+i]
                                      + cimag(coeff_c2s[206]) * gcart[nbra*11+i]*_Complex_I;
                        gspb[7*lds+i] = creal(coeff_c2s[225]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[226]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[228]) * gcart[nbra* 3+i]
                                      + cimag(coeff_c2s[231]) * gcart[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[235]) * gcart[nbra*10+i];
                };
                gspa += lds * 8;
                gspb += lds * 8;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[4].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = 0;
                        gspa[1*lds+i] = creal(coeff_c2s[ 30]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[ 31]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 33]) * gcart[nbra* 3+i]
                                      + cimag(coeff_c2s[ 36]) * gcart[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[ 40]) * gcart[nbra*10+i];
                        gspa[2*lds+i] = creal(coeff_c2s[ 62]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[ 64]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[ 67]) * gcart[nbra* 7+i]
                                      + cimag(coeff_c2s[ 71]) * gcart[nbra*11+i]*_Complex_I;
                        gspa[3*lds+i] = creal(coeff_c2s[ 90]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[ 91]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 95]) * gcart[nbra* 5+i]
                                      + cimag(coeff_c2s[ 96]) * gcart[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 98]) * gcart[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[100]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[102]) * gcart[nbra*12+i];
                        gspa[4*lds+i] = creal(coeff_c2s[122]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[124]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[127]) * gcart[nbra* 7+i]
                                      + creal(coeff_c2s[129]) * gcart[nbra* 9+i]
                                      + cimag(coeff_c2s[131]) * gcart[nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[133]) * gcart[nbra*13+i]*_Complex_I;
                        gspa[5*lds+i] = creal(coeff_c2s[150]) * gcart[nbra* 0+i]
                                      + creal(coeff_c2s[153]) * gcart[nbra* 3+i]
                                      + creal(coeff_c2s[155]) * gcart[nbra* 5+i]
                                      + creal(coeff_c2s[160]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[162]) * gcart[nbra*12+i]
                                      + creal(coeff_c2s[164]) * gcart[nbra*14+i];
                        gspa[6*lds+i] = creal(coeff_c2s[182]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[184]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[187]) * gcart[nbra* 7+i]
                                      + creal(coeff_c2s[189]) * gcart[nbra* 9+i]
                                      + cimag(coeff_c2s[191]) * gcart[nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[193]) * gcart[nbra*13+i]*_Complex_I;
                        gspa[7*lds+i] = creal(coeff_c2s[210]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[211]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[215]) * gcart[nbra* 5+i]
                                      + cimag(coeff_c2s[216]) * gcart[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[218]) * gcart[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[220]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[222]) * gcart[nbra*12+i];
                        gspa[8*lds+i] = creal(coeff_c2s[242]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[244]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[247]) * gcart[nbra* 7+i]
                                      + cimag(coeff_c2s[251]) * gcart[nbra*11+i]*_Complex_I;
                        gspa[9*lds+i] = creal(coeff_c2s[270]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[271]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[273]) * gcart[nbra* 3+i]
                                      + cimag(coeff_c2s[276]) * gcart[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[280]) * gcart[nbra*10+i];
                        gspb[0*lds+i] = creal(coeff_c2s[ 15]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[ 16]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 18]) * gcart[nbra* 3+i]
                                      + cimag(coeff_c2s[ 21]) * gcart[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[ 25]) * gcart[nbra*10+i];
                        gspb[1*lds+i] = creal(coeff_c2s[ 47]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[ 49]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[ 52]) * gcart[nbra* 7+i]
                                      + cimag(coeff_c2s[ 56]) * gcart[nbra*11+i]*_Complex_I;
                        gspb[2*lds+i] = creal(coeff_c2s[ 75]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[ 76]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 80]) * gcart[nbra* 5+i]
                                      + cimag(coeff_c2s[ 81]) * gcart[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 83]) * gcart[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[ 85]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[ 87]) * gcart[nbra*12+i];
                        gspb[3*lds+i] = creal(coeff_c2s[107]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[109]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[112]) * gcart[nbra* 7+i]
                                      + creal(coeff_c2s[114]) * gcart[nbra* 9+i]
                                      + cimag(coeff_c2s[116]) * gcart[nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[118]) * gcart[nbra*13+i]*_Complex_I;
                        gspb[4*lds+i] = creal(coeff_c2s[135]) * gcart[nbra* 0+i]
                                      + creal(coeff_c2s[138]) * gcart[nbra* 3+i]
                                      + creal(coeff_c2s[140]) * gcart[nbra* 5+i]
                                      + creal(coeff_c2s[145]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[147]) * gcart[nbra*12+i]
                                      + creal(coeff_c2s[149]) * gcart[nbra*14+i];
                        gspb[5*lds+i] = creal(coeff_c2s[167]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[169]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[172]) * gcart[nbra* 7+i]
                                      + creal(coeff_c2s[174]) * gcart[nbra* 9+i]
                                      + cimag(coeff_c2s[176]) * gcart[nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[178]) * gcart[nbra*13+i]*_Complex_I;
                        gspb[6*lds+i] = creal(coeff_c2s[195]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[196]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[200]) * gcart[nbra* 5+i]
                                      + cimag(coeff_c2s[201]) * gcart[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[203]) * gcart[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[205]) * gcart[nbra*10+i]
                                      + creal(coeff_c2s[207]) * gcart[nbra*12+i];
                        gspb[7*lds+i] = creal(coeff_c2s[227]) * gcart[nbra* 2+i]
                                      + cimag(coeff_c2s[229]) * gcart[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[232]) * gcart[nbra* 7+i]
                                      + cimag(coeff_c2s[236]) * gcart[nbra*11+i]*_Complex_I;
                        gspb[8*lds+i] = creal(coeff_c2s[255]) * gcart[nbra* 0+i]
                                      + cimag(coeff_c2s[256]) * gcart[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[258]) * gcart[nbra* 3+i]
                                      + cimag(coeff_c2s[261]) * gcart[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[265]) * gcart[nbra*10+i];
                        gspb[9*lds+i] = 0;
                }
        }
}
static void g_iket_cart2spinor_e1sf(double complex *gspa, double complex *gspb,
                                    double *gcart,
                                    FINT lds, FINT nbra, FINT kappa, FINT l)
{
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[4].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = creal(coeff_c2s[  0]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[  1]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[  3]) * gcart[nbra* 3+i]*_Complex_I
                                      - cimag(coeff_c2s[  6]) * gcart[nbra* 6+i]
                                      + creal(coeff_c2s[ 10]) * gcart[nbra*10+i]*_Complex_I;
                        gspa[1*lds+i] = creal(coeff_c2s[ 32]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[ 34]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[ 37]) * gcart[nbra* 7+i]*_Complex_I
                                      - cimag(coeff_c2s[ 41]) * gcart[nbra*11+i];
                        gspa[2*lds+i] = creal(coeff_c2s[ 60]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[ 61]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[ 65]) * gcart[nbra* 5+i]*_Complex_I
                                      - cimag(coeff_c2s[ 66]) * gcart[nbra* 6+i]
                                      - cimag(coeff_c2s[ 68]) * gcart[nbra* 8+i]
                                      + creal(coeff_c2s[ 70]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[ 72]) * gcart[nbra*12+i]*_Complex_I;
                        gspa[3*lds+i] = creal(coeff_c2s[ 92]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[ 94]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[ 97]) * gcart[nbra* 7+i]*_Complex_I
                                      + creal(coeff_c2s[ 99]) * gcart[nbra* 9+i]*_Complex_I
                                      - cimag(coeff_c2s[101]) * gcart[nbra*11+i]
                                      - cimag(coeff_c2s[103]) * gcart[nbra*13+i];
                        gspa[4*lds+i] = creal(coeff_c2s[120]) * gcart[nbra* 0+i]*_Complex_I
                                      + creal(coeff_c2s[123]) * gcart[nbra* 3+i]*_Complex_I
                                      + creal(coeff_c2s[125]) * gcart[nbra* 5+i]*_Complex_I
                                      + creal(coeff_c2s[130]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[132]) * gcart[nbra*12+i]*_Complex_I
                                      + creal(coeff_c2s[134]) * gcart[nbra*14+i]*_Complex_I;
                        gspa[5*lds+i] = creal(coeff_c2s[152]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[154]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[157]) * gcart[nbra* 7+i]*_Complex_I
                                      + creal(coeff_c2s[159]) * gcart[nbra* 9+i]*_Complex_I
                                      - cimag(coeff_c2s[161]) * gcart[nbra*11+i]
                                      - cimag(coeff_c2s[163]) * gcart[nbra*13+i];
                        gspa[6*lds+i] = creal(coeff_c2s[180]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[181]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[185]) * gcart[nbra* 5+i]*_Complex_I
                                      - cimag(coeff_c2s[186]) * gcart[nbra* 6+i]
                                      - cimag(coeff_c2s[188]) * gcart[nbra* 8+i]
                                      + creal(coeff_c2s[190]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[192]) * gcart[nbra*12+i]*_Complex_I;
                        gspa[7*lds+i] = creal(coeff_c2s[212]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[214]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[217]) * gcart[nbra* 7+i]*_Complex_I
                                      - cimag(coeff_c2s[221]) * gcart[nbra*11+i];
                        gspb[0*lds+i] = creal(coeff_c2s[ 17]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[ 19]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[ 22]) * gcart[nbra* 7+i]*_Complex_I
                                      - cimag(coeff_c2s[ 26]) * gcart[nbra*11+i];
                        gspb[1*lds+i] = creal(coeff_c2s[ 45]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[ 46]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[ 50]) * gcart[nbra* 5+i]*_Complex_I
                                      - cimag(coeff_c2s[ 51]) * gcart[nbra* 6+i]
                                      - cimag(coeff_c2s[ 53]) * gcart[nbra* 8+i]
                                      + creal(coeff_c2s[ 55]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[ 57]) * gcart[nbra*12+i]*_Complex_I;
                        gspb[2*lds+i] = creal(coeff_c2s[ 77]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[ 79]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[ 82]) * gcart[nbra* 7+i]*_Complex_I
                                      + creal(coeff_c2s[ 84]) * gcart[nbra* 9+i]*_Complex_I
                                      - cimag(coeff_c2s[ 86]) * gcart[nbra*11+i]
                                      - cimag(coeff_c2s[ 88]) * gcart[nbra*13+i];
                        gspb[3*lds+i] = creal(coeff_c2s[105]) * gcart[nbra* 0+i]*_Complex_I
                                      + creal(coeff_c2s[108]) * gcart[nbra* 3+i]*_Complex_I
                                      + creal(coeff_c2s[110]) * gcart[nbra* 5+i]*_Complex_I
                                      + creal(coeff_c2s[115]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[117]) * gcart[nbra*12+i]*_Complex_I
                                      + creal(coeff_c2s[119]) * gcart[nbra*14+i]*_Complex_I;
                        gspb[4*lds+i] = creal(coeff_c2s[137]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[139]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[142]) * gcart[nbra* 7+i]*_Complex_I
                                      + creal(coeff_c2s[144]) * gcart[nbra* 9+i]*_Complex_I
                                      - cimag(coeff_c2s[146]) * gcart[nbra*11+i]
                                      - cimag(coeff_c2s[148]) * gcart[nbra*13+i];
                        gspb[5*lds+i] = creal(coeff_c2s[165]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[166]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[170]) * gcart[nbra* 5+i]*_Complex_I
                                      - cimag(coeff_c2s[171]) * gcart[nbra* 6+i]
                                      - cimag(coeff_c2s[173]) * gcart[nbra* 8+i]
                                      + creal(coeff_c2s[175]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[177]) * gcart[nbra*12+i]*_Complex_I;
                        gspb[6*lds+i] = creal(coeff_c2s[197]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[199]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[202]) * gcart[nbra* 7+i]*_Complex_I
                                      - cimag(coeff_c2s[206]) * gcart[nbra*11+i];
                        gspb[7*lds+i] = creal(coeff_c2s[225]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[226]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[228]) * gcart[nbra* 3+i]*_Complex_I
                                      - cimag(coeff_c2s[231]) * gcart[nbra* 6+i]
                                      + creal(coeff_c2s[235]) * gcart[nbra*10+i]*_Complex_I;
                };
                gspa += lds * 8;
                gspb += lds * 8;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[4].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = 0;
                        gspa[1*lds+i] = creal(coeff_c2s[ 30]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[ 31]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[ 33]) * gcart[nbra* 3+i]*_Complex_I
                                      - cimag(coeff_c2s[ 36]) * gcart[nbra* 6+i]
                                      + creal(coeff_c2s[ 40]) * gcart[nbra*10+i]*_Complex_I;
                        gspa[2*lds+i] = creal(coeff_c2s[ 62]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[ 64]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[ 67]) * gcart[nbra* 7+i]*_Complex_I
                                      - cimag(coeff_c2s[ 71]) * gcart[nbra*11+i];
                        gspa[3*lds+i] = creal(coeff_c2s[ 90]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[ 91]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[ 95]) * gcart[nbra* 5+i]*_Complex_I
                                      - cimag(coeff_c2s[ 96]) * gcart[nbra* 6+i]
                                      - cimag(coeff_c2s[ 98]) * gcart[nbra* 8+i]
                                      + creal(coeff_c2s[100]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[102]) * gcart[nbra*12+i]*_Complex_I;
                        gspa[4*lds+i] = creal(coeff_c2s[122]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[124]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[127]) * gcart[nbra* 7+i]*_Complex_I
                                      + creal(coeff_c2s[129]) * gcart[nbra* 9+i]*_Complex_I
                                      - cimag(coeff_c2s[131]) * gcart[nbra*11+i]
                                      - cimag(coeff_c2s[133]) * gcart[nbra*13+i];
                        gspa[5*lds+i] = creal(coeff_c2s[150]) * gcart[nbra* 0+i]*_Complex_I
                                      + creal(coeff_c2s[153]) * gcart[nbra* 3+i]*_Complex_I
                                      + creal(coeff_c2s[155]) * gcart[nbra* 5+i]*_Complex_I
                                      + creal(coeff_c2s[160]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[162]) * gcart[nbra*12+i]*_Complex_I
                                      + creal(coeff_c2s[164]) * gcart[nbra*14+i]*_Complex_I;
                        gspa[6*lds+i] = creal(coeff_c2s[182]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[184]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[187]) * gcart[nbra* 7+i]*_Complex_I
                                      + creal(coeff_c2s[189]) * gcart[nbra* 9+i]*_Complex_I
                                      - cimag(coeff_c2s[191]) * gcart[nbra*11+i]
                                      - cimag(coeff_c2s[193]) * gcart[nbra*13+i];
                        gspa[7*lds+i] = creal(coeff_c2s[210]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[211]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[215]) * gcart[nbra* 5+i]*_Complex_I
                                      - cimag(coeff_c2s[216]) * gcart[nbra* 6+i]
                                      - cimag(coeff_c2s[218]) * gcart[nbra* 8+i]
                                      + creal(coeff_c2s[220]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[222]) * gcart[nbra*12+i]*_Complex_I;
                        gspa[8*lds+i] = creal(coeff_c2s[242]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[244]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[247]) * gcart[nbra* 7+i]*_Complex_I
                                      - cimag(coeff_c2s[251]) * gcart[nbra*11+i];
                        gspa[9*lds+i] = creal(coeff_c2s[270]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[271]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[273]) * gcart[nbra* 3+i]*_Complex_I
                                      - cimag(coeff_c2s[276]) * gcart[nbra* 6+i]
                                      + creal(coeff_c2s[280]) * gcart[nbra*10+i]*_Complex_I;
                        gspb[0*lds+i] = creal(coeff_c2s[ 15]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[ 16]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[ 18]) * gcart[nbra* 3+i]*_Complex_I
                                      - cimag(coeff_c2s[ 21]) * gcart[nbra* 6+i]
                                      + creal(coeff_c2s[ 25]) * gcart[nbra*10+i]*_Complex_I;
                        gspb[1*lds+i] = creal(coeff_c2s[ 47]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[ 49]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[ 52]) * gcart[nbra* 7+i]*_Complex_I
                                      - cimag(coeff_c2s[ 56]) * gcart[nbra*11+i];
                        gspb[2*lds+i] = creal(coeff_c2s[ 75]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[ 76]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[ 80]) * gcart[nbra* 5+i]*_Complex_I
                                      - cimag(coeff_c2s[ 81]) * gcart[nbra* 6+i]
                                      - cimag(coeff_c2s[ 83]) * gcart[nbra* 8+i]
                                      + creal(coeff_c2s[ 85]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[ 87]) * gcart[nbra*12+i]*_Complex_I;
                        gspb[3*lds+i] = creal(coeff_c2s[107]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[109]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[112]) * gcart[nbra* 7+i]*_Complex_I
                                      + creal(coeff_c2s[114]) * gcart[nbra* 9+i]*_Complex_I
                                      - cimag(coeff_c2s[116]) * gcart[nbra*11+i]
                                      - cimag(coeff_c2s[118]) * gcart[nbra*13+i];
                        gspb[4*lds+i] = creal(coeff_c2s[135]) * gcart[nbra* 0+i]*_Complex_I
                                      + creal(coeff_c2s[138]) * gcart[nbra* 3+i]*_Complex_I
                                      + creal(coeff_c2s[140]) * gcart[nbra* 5+i]*_Complex_I
                                      + creal(coeff_c2s[145]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[147]) * gcart[nbra*12+i]*_Complex_I
                                      + creal(coeff_c2s[149]) * gcart[nbra*14+i]*_Complex_I;
                        gspb[5*lds+i] = creal(coeff_c2s[167]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[169]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[172]) * gcart[nbra* 7+i]*_Complex_I
                                      + creal(coeff_c2s[174]) * gcart[nbra* 9+i]*_Complex_I
                                      - cimag(coeff_c2s[176]) * gcart[nbra*11+i]
                                      - cimag(coeff_c2s[178]) * gcart[nbra*13+i];
                        gspb[6*lds+i] = creal(coeff_c2s[195]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[196]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[200]) * gcart[nbra* 5+i]*_Complex_I
                                      - cimag(coeff_c2s[201]) * gcart[nbra* 6+i]
                                      - cimag(coeff_c2s[203]) * gcart[nbra* 8+i]
                                      + creal(coeff_c2s[205]) * gcart[nbra*10+i]*_Complex_I
                                      + creal(coeff_c2s[207]) * gcart[nbra*12+i]*_Complex_I;
                        gspb[7*lds+i] = creal(coeff_c2s[227]) * gcart[nbra* 2+i]*_Complex_I
                                      - cimag(coeff_c2s[229]) * gcart[nbra* 4+i]
                                      + creal(coeff_c2s[232]) * gcart[nbra* 7+i]*_Complex_I
                                      - cimag(coeff_c2s[236]) * gcart[nbra*11+i];
                        gspb[8*lds+i] = creal(coeff_c2s[255]) * gcart[nbra* 0+i]*_Complex_I
                                      - cimag(coeff_c2s[256]) * gcart[nbra* 1+i]
                                      + creal(coeff_c2s[258]) * gcart[nbra* 3+i]*_Complex_I
                                      - cimag(coeff_c2s[261]) * gcart[nbra* 6+i]
                                      + creal(coeff_c2s[265]) * gcart[nbra*10+i]*_Complex_I;
                        gspb[9*lds+i] = 0;
                }
        }
}
static void g_ket_cart2spinor_si(double complex *gspa, double complex *gspb,
                                 double complex *gcart,
                                 FINT lds, FINT nbra, FINT kappa, FINT l)
{
        double complex *gcart1 = gcart + nbra*30;
        const double complex *coeff_c2s;
        FINT i;

        if (kappa >= 0) {
                coeff_c2s = g_c2s[4].cart2j_lt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = creal(coeff_c2s[  0]) * gcart [nbra* 0+i]
                                      + cimag(coeff_c2s[  1]) * gcart [nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[  3]) * gcart [nbra* 3+i]
                                      + cimag(coeff_c2s[  6]) * gcart [nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[ 10]) * gcart [nbra*10+i]
                                      + creal(coeff_c2s[ 17]) * gcart [nbra*17+i]
                                      + cimag(coeff_c2s[ 19]) * gcart [nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[ 22]) * gcart [nbra*22+i]
                                      + cimag(coeff_c2s[ 26]) * gcart [nbra*26+i]*_Complex_I;
                        gspa[1*lds+i] = creal(coeff_c2s[ 32]) * gcart [nbra* 2+i]
                                      + cimag(coeff_c2s[ 34]) * gcart [nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[ 37]) * gcart [nbra* 7+i]
                                      + cimag(coeff_c2s[ 41]) * gcart [nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[ 45]) * gcart [nbra*15+i]
                                      + cimag(coeff_c2s[ 46]) * gcart [nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[ 50]) * gcart [nbra*20+i]
                                      + cimag(coeff_c2s[ 51]) * gcart [nbra*21+i]*_Complex_I
                                      + cimag(coeff_c2s[ 53]) * gcart [nbra*23+i]*_Complex_I
                                      + creal(coeff_c2s[ 55]) * gcart [nbra*25+i]
                                      + creal(coeff_c2s[ 57]) * gcart [nbra*27+i];
                        gspa[2*lds+i] = creal(coeff_c2s[ 60]) * gcart [nbra* 0+i]
                                      + cimag(coeff_c2s[ 61]) * gcart [nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 65]) * gcart [nbra* 5+i]
                                      + cimag(coeff_c2s[ 66]) * gcart [nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 68]) * gcart [nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[ 70]) * gcart [nbra*10+i]
                                      + creal(coeff_c2s[ 72]) * gcart [nbra*12+i]
                                      + creal(coeff_c2s[ 77]) * gcart [nbra*17+i]
                                      + cimag(coeff_c2s[ 79]) * gcart [nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[ 82]) * gcart [nbra*22+i]
                                      + creal(coeff_c2s[ 84]) * gcart [nbra*24+i]
                                      + cimag(coeff_c2s[ 86]) * gcart [nbra*26+i]*_Complex_I
                                      + cimag(coeff_c2s[ 88]) * gcart [nbra*28+i]*_Complex_I;
                        gspa[3*lds+i] = creal(coeff_c2s[ 92]) * gcart [nbra* 2+i]
                                      + cimag(coeff_c2s[ 94]) * gcart [nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[ 97]) * gcart [nbra* 7+i]
                                      + creal(coeff_c2s[ 99]) * gcart [nbra* 9+i]
                                      + cimag(coeff_c2s[101]) * gcart [nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[103]) * gcart [nbra*13+i]*_Complex_I
                                      + creal(coeff_c2s[105]) * gcart [nbra*15+i]
                                      + creal(coeff_c2s[108]) * gcart [nbra*18+i]
                                      + creal(coeff_c2s[110]) * gcart [nbra*20+i]
                                      + creal(coeff_c2s[115]) * gcart [nbra*25+i]
                                      + creal(coeff_c2s[117]) * gcart [nbra*27+i]
                                      + creal(coeff_c2s[119]) * gcart [nbra*29+i];
                        gspa[4*lds+i] = creal(coeff_c2s[120]) * gcart [nbra* 0+i]
                                      + creal(coeff_c2s[123]) * gcart [nbra* 3+i]
                                      + creal(coeff_c2s[125]) * gcart [nbra* 5+i]
                                      + creal(coeff_c2s[130]) * gcart [nbra*10+i]
                                      + creal(coeff_c2s[132]) * gcart [nbra*12+i]
                                      + creal(coeff_c2s[134]) * gcart [nbra*14+i]
                                      + creal(coeff_c2s[137]) * gcart [nbra*17+i]
                                      + cimag(coeff_c2s[139]) * gcart [nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[142]) * gcart [nbra*22+i]
                                      + creal(coeff_c2s[144]) * gcart [nbra*24+i]
                                      + cimag(coeff_c2s[146]) * gcart [nbra*26+i]*_Complex_I
                                      + cimag(coeff_c2s[148]) * gcart [nbra*28+i]*_Complex_I;
                        gspa[5*lds+i] = creal(coeff_c2s[152]) * gcart [nbra* 2+i]
                                      + cimag(coeff_c2s[154]) * gcart [nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[157]) * gcart [nbra* 7+i]
                                      + creal(coeff_c2s[159]) * gcart [nbra* 9+i]
                                      + cimag(coeff_c2s[161]) * gcart [nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[163]) * gcart [nbra*13+i]*_Complex_I
                                      + creal(coeff_c2s[165]) * gcart [nbra*15+i]
                                      + cimag(coeff_c2s[166]) * gcart [nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[170]) * gcart [nbra*20+i]
                                      + cimag(coeff_c2s[171]) * gcart [nbra*21+i]*_Complex_I
                                      + cimag(coeff_c2s[173]) * gcart [nbra*23+i]*_Complex_I
                                      + creal(coeff_c2s[175]) * gcart [nbra*25+i]
                                      + creal(coeff_c2s[177]) * gcart [nbra*27+i];
                        gspa[6*lds+i] = creal(coeff_c2s[180]) * gcart [nbra* 0+i]
                                      + cimag(coeff_c2s[181]) * gcart [nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[185]) * gcart [nbra* 5+i]
                                      + cimag(coeff_c2s[186]) * gcart [nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[188]) * gcart [nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[190]) * gcart [nbra*10+i]
                                      + creal(coeff_c2s[192]) * gcart [nbra*12+i]
                                      + creal(coeff_c2s[197]) * gcart [nbra*17+i]
                                      + cimag(coeff_c2s[199]) * gcart [nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[202]) * gcart [nbra*22+i]
                                      + cimag(coeff_c2s[206]) * gcart [nbra*26+i]*_Complex_I;
                        gspa[7*lds+i] = creal(coeff_c2s[212]) * gcart [nbra* 2+i]
                                      + cimag(coeff_c2s[214]) * gcart [nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[217]) * gcart [nbra* 7+i]
                                      + cimag(coeff_c2s[221]) * gcart [nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[225]) * gcart [nbra*15+i]
                                      + cimag(coeff_c2s[226]) * gcart [nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[228]) * gcart [nbra*18+i]
                                      + cimag(coeff_c2s[231]) * gcart [nbra*21+i]*_Complex_I
                                      + creal(coeff_c2s[235]) * gcart [nbra*25+i];
                        gspb[0*lds+i] = creal(coeff_c2s[  0]) * gcart1[nbra* 0+i]
                                      + cimag(coeff_c2s[  1]) * gcart1[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[  3]) * gcart1[nbra* 3+i]
                                      + cimag(coeff_c2s[  6]) * gcart1[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[ 10]) * gcart1[nbra*10+i]
                                      + creal(coeff_c2s[ 17]) * gcart1[nbra*17+i]
                                      + cimag(coeff_c2s[ 19]) * gcart1[nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[ 22]) * gcart1[nbra*22+i]
                                      + cimag(coeff_c2s[ 26]) * gcart1[nbra*26+i]*_Complex_I;
                        gspb[1*lds+i] = creal(coeff_c2s[ 32]) * gcart1[nbra* 2+i]
                                      + cimag(coeff_c2s[ 34]) * gcart1[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[ 37]) * gcart1[nbra* 7+i]
                                      + cimag(coeff_c2s[ 41]) * gcart1[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[ 45]) * gcart1[nbra*15+i]
                                      + cimag(coeff_c2s[ 46]) * gcart1[nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[ 50]) * gcart1[nbra*20+i]
                                      + cimag(coeff_c2s[ 51]) * gcart1[nbra*21+i]*_Complex_I
                                      + cimag(coeff_c2s[ 53]) * gcart1[nbra*23+i]*_Complex_I
                                      + creal(coeff_c2s[ 55]) * gcart1[nbra*25+i]
                                      + creal(coeff_c2s[ 57]) * gcart1[nbra*27+i];
                        gspb[2*lds+i] = creal(coeff_c2s[ 60]) * gcart1[nbra* 0+i]
                                      + cimag(coeff_c2s[ 61]) * gcart1[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 65]) * gcart1[nbra* 5+i]
                                      + cimag(coeff_c2s[ 66]) * gcart1[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 68]) * gcart1[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[ 70]) * gcart1[nbra*10+i]
                                      + creal(coeff_c2s[ 72]) * gcart1[nbra*12+i]
                                      + creal(coeff_c2s[ 77]) * gcart1[nbra*17+i]
                                      + cimag(coeff_c2s[ 79]) * gcart1[nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[ 82]) * gcart1[nbra*22+i]
                                      + creal(coeff_c2s[ 84]) * gcart1[nbra*24+i]
                                      + cimag(coeff_c2s[ 86]) * gcart1[nbra*26+i]*_Complex_I
                                      + cimag(coeff_c2s[ 88]) * gcart1[nbra*28+i]*_Complex_I;
                        gspb[3*lds+i] = creal(coeff_c2s[ 92]) * gcart1[nbra* 2+i]
                                      + cimag(coeff_c2s[ 94]) * gcart1[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[ 97]) * gcart1[nbra* 7+i]
                                      + creal(coeff_c2s[ 99]) * gcart1[nbra* 9+i]
                                      + cimag(coeff_c2s[101]) * gcart1[nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[103]) * gcart1[nbra*13+i]*_Complex_I
                                      + creal(coeff_c2s[105]) * gcart1[nbra*15+i]
                                      + creal(coeff_c2s[108]) * gcart1[nbra*18+i]
                                      + creal(coeff_c2s[110]) * gcart1[nbra*20+i]
                                      + creal(coeff_c2s[115]) * gcart1[nbra*25+i]
                                      + creal(coeff_c2s[117]) * gcart1[nbra*27+i]
                                      + creal(coeff_c2s[119]) * gcart1[nbra*29+i];
                        gspb[4*lds+i] = creal(coeff_c2s[120]) * gcart1[nbra* 0+i]
                                      + creal(coeff_c2s[123]) * gcart1[nbra* 3+i]
                                      + creal(coeff_c2s[125]) * gcart1[nbra* 5+i]
                                      + creal(coeff_c2s[130]) * gcart1[nbra*10+i]
                                      + creal(coeff_c2s[132]) * gcart1[nbra*12+i]
                                      + creal(coeff_c2s[134]) * gcart1[nbra*14+i]
                                      + creal(coeff_c2s[137]) * gcart1[nbra*17+i]
                                      + cimag(coeff_c2s[139]) * gcart1[nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[142]) * gcart1[nbra*22+i]
                                      + creal(coeff_c2s[144]) * gcart1[nbra*24+i]
                                      + cimag(coeff_c2s[146]) * gcart1[nbra*26+i]*_Complex_I
                                      + cimag(coeff_c2s[148]) * gcart1[nbra*28+i]*_Complex_I;
                        gspb[5*lds+i] = creal(coeff_c2s[152]) * gcart1[nbra* 2+i]
                                      + cimag(coeff_c2s[154]) * gcart1[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[157]) * gcart1[nbra* 7+i]
                                      + creal(coeff_c2s[159]) * gcart1[nbra* 9+i]
                                      + cimag(coeff_c2s[161]) * gcart1[nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[163]) * gcart1[nbra*13+i]*_Complex_I
                                      + creal(coeff_c2s[165]) * gcart1[nbra*15+i]
                                      + cimag(coeff_c2s[166]) * gcart1[nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[170]) * gcart1[nbra*20+i]
                                      + cimag(coeff_c2s[171]) * gcart1[nbra*21+i]*_Complex_I
                                      + cimag(coeff_c2s[173]) * gcart1[nbra*23+i]*_Complex_I
                                      + creal(coeff_c2s[175]) * gcart1[nbra*25+i]
                                      + creal(coeff_c2s[177]) * gcart1[nbra*27+i];
                        gspb[6*lds+i] = creal(coeff_c2s[180]) * gcart1[nbra* 0+i]
                                      + cimag(coeff_c2s[181]) * gcart1[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[185]) * gcart1[nbra* 5+i]
                                      + cimag(coeff_c2s[186]) * gcart1[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[188]) * gcart1[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[190]) * gcart1[nbra*10+i]
                                      + creal(coeff_c2s[192]) * gcart1[nbra*12+i]
                                      + creal(coeff_c2s[197]) * gcart1[nbra*17+i]
                                      + cimag(coeff_c2s[199]) * gcart1[nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[202]) * gcart1[nbra*22+i]
                                      + cimag(coeff_c2s[206]) * gcart1[nbra*26+i]*_Complex_I;
                        gspb[7*lds+i] = creal(coeff_c2s[212]) * gcart1[nbra* 2+i]
                                      + cimag(coeff_c2s[214]) * gcart1[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[217]) * gcart1[nbra* 7+i]
                                      + cimag(coeff_c2s[221]) * gcart1[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[225]) * gcart1[nbra*15+i]
                                      + cimag(coeff_c2s[226]) * gcart1[nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[228]) * gcart1[nbra*18+i]
                                      + cimag(coeff_c2s[231]) * gcart1[nbra*21+i]*_Complex_I
                                      + creal(coeff_c2s[235]) * gcart1[nbra*25+i];
                };
                gspa += lds * 8;
                gspb += lds * 8;
        }
        if (kappa <= 0) {
                coeff_c2s = g_c2s[4].cart2j_gt_l;
                for (i = 0; i < nbra; i++) {
                        gspa[0*lds+i] = creal(coeff_c2s[ 15]) * gcart [nbra*15+i]
                                      + cimag(coeff_c2s[ 16]) * gcart [nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[ 18]) * gcart [nbra*18+i]
                                      + cimag(coeff_c2s[ 21]) * gcart [nbra*21+i]*_Complex_I
                                      + creal(coeff_c2s[ 25]) * gcart [nbra*25+i];
                        gspa[1*lds+i] = creal(coeff_c2s[ 30]) * gcart [nbra* 0+i]
                                      + cimag(coeff_c2s[ 31]) * gcart [nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 33]) * gcart [nbra* 3+i]
                                      + cimag(coeff_c2s[ 36]) * gcart [nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[ 40]) * gcart [nbra*10+i]
                                      + creal(coeff_c2s[ 47]) * gcart [nbra*17+i]
                                      + cimag(coeff_c2s[ 49]) * gcart [nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[ 52]) * gcart [nbra*22+i]
                                      + cimag(coeff_c2s[ 56]) * gcart [nbra*26+i]*_Complex_I;
                        gspa[2*lds+i] = creal(coeff_c2s[ 62]) * gcart [nbra* 2+i]
                                      + cimag(coeff_c2s[ 64]) * gcart [nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[ 67]) * gcart [nbra* 7+i]
                                      + cimag(coeff_c2s[ 71]) * gcart [nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[ 75]) * gcart [nbra*15+i]
                                      + cimag(coeff_c2s[ 76]) * gcart [nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[ 80]) * gcart [nbra*20+i]
                                      + cimag(coeff_c2s[ 81]) * gcart [nbra*21+i]*_Complex_I
                                      + cimag(coeff_c2s[ 83]) * gcart [nbra*23+i]*_Complex_I
                                      + creal(coeff_c2s[ 85]) * gcart [nbra*25+i]
                                      + creal(coeff_c2s[ 87]) * gcart [nbra*27+i];
                        gspa[3*lds+i] = creal(coeff_c2s[ 90]) * gcart [nbra* 0+i]
                                      + cimag(coeff_c2s[ 91]) * gcart [nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 95]) * gcart [nbra* 5+i]
                                      + cimag(coeff_c2s[ 96]) * gcart [nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 98]) * gcart [nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[100]) * gcart [nbra*10+i]
                                      + creal(coeff_c2s[102]) * gcart [nbra*12+i]
                                      + creal(coeff_c2s[107]) * gcart [nbra*17+i]
                                      + cimag(coeff_c2s[109]) * gcart [nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[112]) * gcart [nbra*22+i]
                                      + creal(coeff_c2s[114]) * gcart [nbra*24+i]
                                      + cimag(coeff_c2s[116]) * gcart [nbra*26+i]*_Complex_I
                                      + cimag(coeff_c2s[118]) * gcart [nbra*28+i]*_Complex_I;
                        gspa[4*lds+i] = creal(coeff_c2s[122]) * gcart [nbra* 2+i]
                                      + cimag(coeff_c2s[124]) * gcart [nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[127]) * gcart [nbra* 7+i]
                                      + creal(coeff_c2s[129]) * gcart [nbra* 9+i]
                                      + cimag(coeff_c2s[131]) * gcart [nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[133]) * gcart [nbra*13+i]*_Complex_I
                                      + creal(coeff_c2s[135]) * gcart [nbra*15+i]
                                      + creal(coeff_c2s[138]) * gcart [nbra*18+i]
                                      + creal(coeff_c2s[140]) * gcart [nbra*20+i]
                                      + creal(coeff_c2s[145]) * gcart [nbra*25+i]
                                      + creal(coeff_c2s[147]) * gcart [nbra*27+i]
                                      + creal(coeff_c2s[149]) * gcart [nbra*29+i];
                        gspa[5*lds+i] = creal(coeff_c2s[150]) * gcart [nbra* 0+i]
                                      + creal(coeff_c2s[153]) * gcart [nbra* 3+i]
                                      + creal(coeff_c2s[155]) * gcart [nbra* 5+i]
                                      + creal(coeff_c2s[160]) * gcart [nbra*10+i]
                                      + creal(coeff_c2s[162]) * gcart [nbra*12+i]
                                      + creal(coeff_c2s[164]) * gcart [nbra*14+i]
                                      + creal(coeff_c2s[167]) * gcart [nbra*17+i]
                                      + cimag(coeff_c2s[169]) * gcart [nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[172]) * gcart [nbra*22+i]
                                      + creal(coeff_c2s[174]) * gcart [nbra*24+i]
                                      + cimag(coeff_c2s[176]) * gcart [nbra*26+i]*_Complex_I
                                      + cimag(coeff_c2s[178]) * gcart [nbra*28+i]*_Complex_I;
                        gspa[6*lds+i] = creal(coeff_c2s[182]) * gcart [nbra* 2+i]
                                      + cimag(coeff_c2s[184]) * gcart [nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[187]) * gcart [nbra* 7+i]
                                      + creal(coeff_c2s[189]) * gcart [nbra* 9+i]
                                      + cimag(coeff_c2s[191]) * gcart [nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[193]) * gcart [nbra*13+i]*_Complex_I
                                      + creal(coeff_c2s[195]) * gcart [nbra*15+i]
                                      + cimag(coeff_c2s[196]) * gcart [nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[200]) * gcart [nbra*20+i]
                                      + cimag(coeff_c2s[201]) * gcart [nbra*21+i]*_Complex_I
                                      + cimag(coeff_c2s[203]) * gcart [nbra*23+i]*_Complex_I
                                      + creal(coeff_c2s[205]) * gcart [nbra*25+i]
                                      + creal(coeff_c2s[207]) * gcart [nbra*27+i];
                        gspa[7*lds+i] = creal(coeff_c2s[210]) * gcart [nbra* 0+i]
                                      + cimag(coeff_c2s[211]) * gcart [nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[215]) * gcart [nbra* 5+i]
                                      + cimag(coeff_c2s[216]) * gcart [nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[218]) * gcart [nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[220]) * gcart [nbra*10+i]
                                      + creal(coeff_c2s[222]) * gcart [nbra*12+i]
                                      + creal(coeff_c2s[227]) * gcart [nbra*17+i]
                                      + cimag(coeff_c2s[229]) * gcart [nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[232]) * gcart [nbra*22+i]
                                      + cimag(coeff_c2s[236]) * gcart [nbra*26+i]*_Complex_I;
                        gspa[8*lds+i] = creal(coeff_c2s[242]) * gcart [nbra* 2+i]
                                      + cimag(coeff_c2s[244]) * gcart [nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[247]) * gcart [nbra* 7+i]
                                      + cimag(coeff_c2s[251]) * gcart [nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[255]) * gcart [nbra*15+i]
                                      + cimag(coeff_c2s[256]) * gcart [nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[258]) * gcart [nbra*18+i]
                                      + cimag(coeff_c2s[261]) * gcart [nbra*21+i]*_Complex_I
                                      + creal(coeff_c2s[265]) * gcart [nbra*25+i];
                        gspa[9*lds+i] = creal(coeff_c2s[270]) * gcart [nbra* 0+i]
                                      + cimag(coeff_c2s[271]) * gcart [nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[273]) * gcart [nbra* 3+i]
                                      + cimag(coeff_c2s[276]) * gcart [nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[280]) * gcart [nbra*10+i];
                        gspb[0*lds+i] = creal(coeff_c2s[ 15]) * gcart1[nbra*15+i]
                                      + cimag(coeff_c2s[ 16]) * gcart1[nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[ 18]) * gcart1[nbra*18+i]
                                      + cimag(coeff_c2s[ 21]) * gcart1[nbra*21+i]*_Complex_I
                                      + creal(coeff_c2s[ 25]) * gcart1[nbra*25+i];
                        gspb[1*lds+i] = creal(coeff_c2s[ 30]) * gcart1[nbra* 0+i]
                                      + cimag(coeff_c2s[ 31]) * gcart1[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 33]) * gcart1[nbra* 3+i]
                                      + cimag(coeff_c2s[ 36]) * gcart1[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[ 40]) * gcart1[nbra*10+i]
                                      + creal(coeff_c2s[ 47]) * gcart1[nbra*17+i]
                                      + cimag(coeff_c2s[ 49]) * gcart1[nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[ 52]) * gcart1[nbra*22+i]
                                      + cimag(coeff_c2s[ 56]) * gcart1[nbra*26+i]*_Complex_I;
                        gspb[2*lds+i] = creal(coeff_c2s[ 62]) * gcart1[nbra* 2+i]
                                      + cimag(coeff_c2s[ 64]) * gcart1[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[ 67]) * gcart1[nbra* 7+i]
                                      + cimag(coeff_c2s[ 71]) * gcart1[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[ 75]) * gcart1[nbra*15+i]
                                      + cimag(coeff_c2s[ 76]) * gcart1[nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[ 80]) * gcart1[nbra*20+i]
                                      + cimag(coeff_c2s[ 81]) * gcart1[nbra*21+i]*_Complex_I
                                      + cimag(coeff_c2s[ 83]) * gcart1[nbra*23+i]*_Complex_I
                                      + creal(coeff_c2s[ 85]) * gcart1[nbra*25+i]
                                      + creal(coeff_c2s[ 87]) * gcart1[nbra*27+i];
                        gspb[3*lds+i] = creal(coeff_c2s[ 90]) * gcart1[nbra* 0+i]
                                      + cimag(coeff_c2s[ 91]) * gcart1[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[ 95]) * gcart1[nbra* 5+i]
                                      + cimag(coeff_c2s[ 96]) * gcart1[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[ 98]) * gcart1[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[100]) * gcart1[nbra*10+i]
                                      + creal(coeff_c2s[102]) * gcart1[nbra*12+i]
                                      + creal(coeff_c2s[107]) * gcart1[nbra*17+i]
                                      + cimag(coeff_c2s[109]) * gcart1[nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[112]) * gcart1[nbra*22+i]
                                      + creal(coeff_c2s[114]) * gcart1[nbra*24+i]
                                      + cimag(coeff_c2s[116]) * gcart1[nbra*26+i]*_Complex_I
                                      + cimag(coeff_c2s[118]) * gcart1[nbra*28+i]*_Complex_I;
                        gspb[4*lds+i] = creal(coeff_c2s[122]) * gcart1[nbra* 2+i]
                                      + cimag(coeff_c2s[124]) * gcart1[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[127]) * gcart1[nbra* 7+i]
                                      + creal(coeff_c2s[129]) * gcart1[nbra* 9+i]
                                      + cimag(coeff_c2s[131]) * gcart1[nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[133]) * gcart1[nbra*13+i]*_Complex_I
                                      + creal(coeff_c2s[135]) * gcart1[nbra*15+i]
                                      + creal(coeff_c2s[138]) * gcart1[nbra*18+i]
                                      + creal(coeff_c2s[140]) * gcart1[nbra*20+i]
                                      + creal(coeff_c2s[145]) * gcart1[nbra*25+i]
                                      + creal(coeff_c2s[147]) * gcart1[nbra*27+i]
                                      + creal(coeff_c2s[149]) * gcart1[nbra*29+i];
                        gspb[5*lds+i] = creal(coeff_c2s[150]) * gcart1[nbra* 0+i]
                                      + creal(coeff_c2s[153]) * gcart1[nbra* 3+i]
                                      + creal(coeff_c2s[155]) * gcart1[nbra* 5+i]
                                      + creal(coeff_c2s[160]) * gcart1[nbra*10+i]
                                      + creal(coeff_c2s[162]) * gcart1[nbra*12+i]
                                      + creal(coeff_c2s[164]) * gcart1[nbra*14+i]
                                      + creal(coeff_c2s[167]) * gcart1[nbra*17+i]
                                      + cimag(coeff_c2s[169]) * gcart1[nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[172]) * gcart1[nbra*22+i]
                                      + creal(coeff_c2s[174]) * gcart1[nbra*24+i]
                                      + cimag(coeff_c2s[176]) * gcart1[nbra*26+i]*_Complex_I
                                      + cimag(coeff_c2s[178]) * gcart1[nbra*28+i]*_Complex_I;
                        gspb[6*lds+i] = creal(coeff_c2s[182]) * gcart1[nbra* 2+i]
                                      + cimag(coeff_c2s[184]) * gcart1[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[187]) * gcart1[nbra* 7+i]
                                      + creal(coeff_c2s[189]) * gcart1[nbra* 9+i]
                                      + cimag(coeff_c2s[191]) * gcart1[nbra*11+i]*_Complex_I
                                      + cimag(coeff_c2s[193]) * gcart1[nbra*13+i]*_Complex_I
                                      + creal(coeff_c2s[195]) * gcart1[nbra*15+i]
                                      + cimag(coeff_c2s[196]) * gcart1[nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[200]) * gcart1[nbra*20+i]
                                      + cimag(coeff_c2s[201]) * gcart1[nbra*21+i]*_Complex_I
                                      + cimag(coeff_c2s[203]) * gcart1[nbra*23+i]*_Complex_I
                                      + creal(coeff_c2s[205]) * gcart1[nbra*25+i]
                                      + creal(coeff_c2s[207]) * gcart1[nbra*27+i];
                        gspb[7*lds+i] = creal(coeff_c2s[210]) * gcart1[nbra* 0+i]
                                      + cimag(coeff_c2s[211]) * gcart1[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[215]) * gcart1[nbra* 5+i]
                                      + cimag(coeff_c2s[216]) * gcart1[nbra* 6+i]*_Complex_I
                                      + cimag(coeff_c2s[218]) * gcart1[nbra* 8+i]*_Complex_I
                                      + creal(coeff_c2s[220]) * gcart1[nbra*10+i]
                                      + creal(coeff_c2s[222]) * gcart1[nbra*12+i]
                                      + creal(coeff_c2s[227]) * gcart1[nbra*17+i]
                                      + cimag(coeff_c2s[229]) * gcart1[nbra*19+i]*_Complex_I
                                      + creal(coeff_c2s[232]) * gcart1[nbra*22+i]
                                      + cimag(coeff_c2s[236]) * gcart1[nbra*26+i]*_Complex_I;
                        gspb[8*lds+i] = creal(coeff_c2s[242]) * gcart1[nbra* 2+i]
                                      + cimag(coeff_c2s[244]) * gcart1[nbra* 4+i]*_Complex_I
                                      + creal(coeff_c2s[247]) * gcart1[nbra* 7+i]
                                      + cimag(coeff_c2s[251]) * gcart1[nbra*11+i]*_Complex_I
                                      + creal(coeff_c2s[255]) * gcart1[nbra*15+i]
                                      + cimag(coeff_c2s[256]) * gcart1[nbra*16+i]*_Complex_I
                                      + creal(coeff_c2s[258]) * gcart1[nbra*18+i]
                                      + cimag(coeff_c2s[261]) * gcart1[nbra*21+i]*_Complex_I
                                      + creal(coeff_c2s[265]) * gcart1[nbra*25+i];
                        gspb[9*lds+i] = creal(coeff_c2s[270]) * gcart1[nbra* 0+i]
                                      + cimag(coeff_c2s[271]) * gcart1[nbra* 1+i]*_Complex_I
                                      + creal(coeff_c2s[273]) * gcart1[nbra* 3+i]
                                      + cimag(coeff_c2s[276]) * gcart1[nbra* 6+i]*_Complex_I
                                      + creal(coeff_c2s[280]) * gcart1[nbra*10+i];
                }
        }
}

void (*c2s_ket_spinor_e1sf[])() = {
        s_ket_cart2spinor_e1sf,
        p_ket_cart2spinor_e1sf,
        d_ket_cart2spinor_e1sf,
        f_ket_cart2spinor_e1sf,
        g_ket_cart2spinor_e1sf,
        a_ket_cart2spinor_e1sf,
        a_ket_cart2spinor_e1sf,
        a_ket_cart2spinor_e1sf,
};

void (*c2s_iket_spinor_e1sf[])() = {
        s_iket_cart2spinor_e1sf,
        p_iket_cart2spinor_e1sf,
        d_iket_cart2spinor_e1sf,
        f_iket_cart2spinor_e1sf,
        g_iket_cart2spinor_e1sf,
        a_iket_cart2spinor_e1sf,
        a_iket_cart2spinor_e1sf,
        a_iket_cart2spinor_e1sf,
};

void (*c2s_ket_spinor_si[])() = {
        s_ket_cart2spinor_si,
        p_ket_cart2spinor_si,
        d_ket_cart2spinor_si,
        f_ket_cart2spinor_si,
        g_ket_cart2spinor_si,
        a_ket_cart2spinor_si,
        a_ket_cart2spinor_si,
        a_ket_cart2spinor_si,
};

/*************************************************
 *
 * transform matrices
 *
 *************************************************/

/*
 * (i,k,l,j) -> (k,i,j,l)
 */
static void zswap_ik_jl(double complex *new, const double complex *old,
                        const FINT ni, const FINT nj, const FINT nk, const FINT nl)
{
        FINT j, l;
        FINT dlo = ni * nk; // stride of (i,k,l++,j)
        FINT djo = ni * nk * nl; // stride of (i,k,l,j++)
        FINT djn = nk * ni; // stride of (k,i,j++,l)
        const double complex *pold;

        for (l = 0; l < nl; l++) {
                pold = old + l * dlo;
                for (j = 0; j < nj; j++) {
                        CINTzmat_transpose(new, pold, nk, ni);
                        new += djn;
                        pold += djo;
                }
        }
}


static void dcopy_ij(double *opij, const double *gctr, 
                     const FINT ni, const FINT nj, const FINT mi, const FINT mj)
{
        FINT i, j;

        for (j = 0; j < mj; j++) {
                for (i = 0; i < mi; i++) {
                        opij[i] = gctr[i];
                }
                opij += ni;
                gctr += mi;
        }
}
static void zcopy_ij(double complex *opij, const double complex *gctr, 
                     const FINT ni, const FINT nj, const FINT mi, const FINT mj)
{
        FINT i, j;

        for (j = 0; j < mj; j++) {
                for (i = 0; i < mi; i++) {
                        opij[j*ni+i] = gctr[j*mi+i];
                }
        }
}

/*
 * gctr(i,k,l,j) -> fijkl(i,j,k,l)
 * fijkl(ic:ic-1+di,jc:jc-1+dj,kc:kc-1+dk,lc:lc-1+dl)
 * fijkl(ni,nj,nk,nl), gctr(mi,mk,ml,mj)
 */
static void dcopy_iklj(double *fijkl, const double *gctr, 
                       const FINT ni, const FINT nj, const FINT nk, const FINT nl,
                       const FINT mi, const FINT mj, const FINT mk, const FINT ml)
{
        const FINT nij = ni * nj;
        const FINT nijk = nij * nk;
        const FINT mik = mi * mk;
        const FINT mikl = mik * ml;
        FINT i, j, k, l;
        double *pijkl;
        const double *pgctr;

        switch (mi) {
        case 1:
                for (l = 0; l < ml; l++) {
                        for (k = 0; k < mk; k++) {
                                pijkl = fijkl + k * nij;
                                pgctr = gctr + k * mi;
                                for (j = 0; j < mj; j++) {
                                        pijkl[ni*j] = pgctr[mikl*j];
                                }
                        }
                        fijkl += nijk;
                        gctr += mik;
                }
                break;
        case 3:
                for (l = 0; l < ml; l++) {
                        for (k = 0; k < mk; k++) {
                                pijkl = fijkl + k * nij;
                                pgctr = gctr + k * mi;
                                for (j = 0; j < mj; j++) {
                                        pijkl[ni*j+0] = pgctr[mikl*j+0];
                                        pijkl[ni*j+1] = pgctr[mikl*j+1];
                                        pijkl[ni*j+2] = pgctr[mikl*j+2];
                                }
                        }
                        fijkl += nijk;
                        gctr += mik;
                }
                break;
        case 5:
                for (l = 0; l < ml; l++) {
                        for (k = 0; k < mk; k++) {
                                pijkl = fijkl + k * nij;
                                pgctr = gctr + k * mi;
                                for (j = 0; j < mj; j++) {
                                        pijkl[ni*j+0] = pgctr[mikl*j+0];
                                        pijkl[ni*j+1] = pgctr[mikl*j+1];
                                        pijkl[ni*j+2] = pgctr[mikl*j+2];
                                        pijkl[ni*j+3] = pgctr[mikl*j+3];
                                        pijkl[ni*j+4] = pgctr[mikl*j+4];
                                }
                        }
                        fijkl += nijk;
                        gctr += mik;
                }
                break;
        case 7:
                for (l = 0; l < ml; l++) {
                        for (k = 0; k < mk; k++) {
                                pijkl = fijkl + k * nij;
                                pgctr = gctr + k * mi;
                                for (j = 0; j < mj; j++) {
                                        pijkl[ni*j+0] = pgctr[mikl*j+0];
                                        pijkl[ni*j+1] = pgctr[mikl*j+1];
                                        pijkl[ni*j+2] = pgctr[mikl*j+2];
                                        pijkl[ni*j+3] = pgctr[mikl*j+3];
                                        pijkl[ni*j+4] = pgctr[mikl*j+4];
                                        pijkl[ni*j+5] = pgctr[mikl*j+5];
                                        pijkl[ni*j+6] = pgctr[mikl*j+6];
                                }
                        }
                        fijkl += nijk;
                        gctr += mik;
                }
                break;
        default:
                for (l = 0; l < ml; l++) {
                        for (k = 0; k < mk; k++) {
                                pijkl = fijkl + k * nij;
                                pgctr = gctr + k * mi;
                                for (j = 0; j < mj; j++) {
                                        for (i = 0; i < mi; i++) {
                                                pijkl[ni*j+i] = pgctr[mikl*j+i];
                                        }
                                }
                        }
                        fijkl += nijk;
                        gctr += mik;
                }
        }
}

static void zcopy_kijl(double complex *fijkl, const double complex *gctr,
                       const FINT ni, const FINT nj, const FINT nk, const FINT nl,
                       const FINT mi, const FINT mj, const FINT mk, const FINT ml)
{
        FINT i, j, k, l;
        double complex *pl, *pk;
        const double complex *pgctr;

        for (l = 0; l < ml; l++) {
                pl = fijkl + l * nk * ni * nj;
                for (k = 0; k < mk; k++) {
                        pk = pl + k * ni * nj;
                        pgctr = gctr + (l * mk * mi * mj + k);
                        for (j = 0; j < mj; j++) {
                                for (i = 0; i < mi; i++) {
                                        pk[j*ni+i] = pgctr[i*mk];
                                }
                                pgctr += mk * mi;
                        }
                }
        }
}
static void zcopy_iklj(double complex *fijkl, const double complex *gctr, 
                       const FINT ni, const FINT nj, const FINT nk, const FINT nl,
                       const FINT mi, const FINT mj, const FINT mk, const FINT ml)
{
        const FINT nij = ni * nj;
        const FINT nijk = nij * nk;
        const FINT mik = mi * mk;
        const FINT mikl = mik * ml;
        FINT i, j, k, l;
        double complex *pijkl;
        const double complex *pgctr;

        for (l = 0; l < ml; l++) {
                for (k = 0; k < mk; k++) {
                        pijkl = fijkl + k * nij;
                        pgctr = gctr + k * mi;
                        for (j = 0; j < mj; j++) {
                                for (i = 0; i < mi; i++) {
                                        pijkl[j*ni+i] = pgctr[j*mikl+i];
                                }
                        }
                }
                fijkl += nijk;
                gctr += mik;
        }
}

void c2s_dset0(double *out, FINT *dims, FINT *counts)
{
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT nk = dims[2];
        FINT nij = ni * nj;
        FINT nijk = nij * nk;
        FINT i, j, k, l;
        if (dims == counts) {
                for (i = 0; i < nijk * counts[3]; i++) {
                        out[i] = 0;
                }
                return;
        }
        FINT di = counts[0];
        FINT dj = counts[1];
        FINT dk = counts[2];
        FINT dl = counts[3];
        double *pout;
        for (l = 0; l < dl; l++) {
                for (k = 0; k < dk; k++) {
                        pout = out + k * nij;
                        for (j = 0; j < dj; j++) {
                        for (i = 0; i < di; i++) {
                                pout[j*ni+i] = 0;
                        } }
                }
                out += nijk;
        }
}
void c2s_zset0(double complex *out, FINT *dims, FINT *counts)
{
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT nk = dims[2];
        FINT nij = ni * nj;
        FINT nijk = nij * nk;
        FINT i, j, k, l;
        if (dims == counts) {
                for (i = 0; i < nijk * counts[3]; i++) {
                        out[i] = 0;
                }
                return;
        }
        FINT di = counts[0];
        FINT dj = counts[1];
        FINT dk = counts[2];
        FINT dl = counts[3];
        double complex *pout;
        for (l = 0; l < dl; l++) {
                for (k = 0; k < dk; k++) {
                        pout = out + k * nij;
                        for (j = 0; j < dj; j++) {
                        for (i = 0; i < di; i++) {
                                pout[j*ni+i] = 0;
                        } }
                }
                out += nijk;
        }
}


/*
 * 1e integrals, cartesian to real spheric.
 */
void c2s_sph_1e(double *opij, double *gctr, FINT *dims,
                CINTEnvVars *envs, double *cache)
{
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT di = i_l * 2 + 1;
        FINT dj = j_l * 2 + 1;
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT ofj = ni * dj;
        FINT nfi = envs->nfi;
        FINT nf = envs->nf;
        FINT ic, jc;
        FINT buflen = nfi*dj;
        double *buf1, *buf2;
        MALLOC_INSTACK(buf1, double, buflen);
        MALLOC_INSTACK(buf2, double, buflen);
        double *pij;
        double *tmp1;

        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                pij = opij + ofj * jc + di * ic;
                tmp1 = (c2s_ket_sph[j_l])(buf1, gctr, nfi, nfi, j_l);
                tmp1 = (c2s_bra_sph[i_l])(buf2, dj, tmp1, i_l);
                dcopy_ij(pij, tmp1, ni, nj, di, dj);
                gctr += nf;
        } }
}


/*
 * 1e integrals, cartesian to spin free spinor.
 */
void c2s_sf_1e(double complex *opij, double *gctr, FINT *dims,
               CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT ofj = ni * dj;
        FINT nfj = envs->nfj;
        FINT nf2j = nfj + nfj;
        FINT nf = envs->nf;
        FINT ic, jc;
        double complex *tmp1, *tmp2;
        MALLOC_INSTACK(tmp1, double complex, di*nf2j);
        MALLOC_INSTACK(tmp2, double complex, di*nf2j);

        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                (c2s_bra_spinor_e1sf[i_l])(tmp1, nfj, gctr, i_kp, i_l);
                (c2s_ket_spinor[j_l])(tmp2, di, tmp1, j_kp, j_l);
                zcopy_ij(opij+ofj*jc+di*ic, tmp2, ni, nj, di, dj);
                gctr += nf;
        } }
}
void c2s_sf_1ei(double complex *opij, double *gctr, FINT *dims,
                CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT ofj = ni * dj;
        FINT nfj = envs->nfj;
        FINT nf2j = nfj + nfj;
        FINT nf = envs->nf;
        FINT ic, jc;
        double complex *tmp1, *tmp2;
        MALLOC_INSTACK(tmp1, double complex, di*nf2j);
        MALLOC_INSTACK(tmp2, double complex, di*nf2j);

        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                (c2s_bra_spinor_e1sf[i_l])(tmp1, nfj, gctr, i_kp, i_l);
                (c2s_iket_spinor[j_l])(tmp2, di, tmp1, j_kp, j_l);
                zcopy_ij(opij+ofj*jc+di*ic, tmp2, ni, nj, di, dj);
                gctr += nf;
        } }
}


/*
 * 1e integrals, cartesian to spinor.
 */
void c2s_si_1e(double complex *opij, double *gctr, FINT *dims,
               CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT ofj = ni * dj;
        FINT nfi = envs->nfi;
        FINT nfj = envs->nfj;
        FINT nf2i = nfi + nfi;
        FINT nf2j = nfj + nfj;
        FINT nf = envs->nf;
        FINT ic, jc;
        double *gc_x = gctr;
        double *gc_y = gc_x + nf * i_ctr * j_ctr;
        double *gc_z = gc_y + nf * i_ctr * j_ctr;
        double *gc_1 = gc_z + nf * i_ctr * j_ctr;
        double complex *tmp1, *tmp2;
        MALLOC_INSTACK(tmp1, double complex, nf2i*nf2j);
        MALLOC_INSTACK(tmp2, double complex, di*nf2j);

        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                //cmplx( gctr.POS_1, gctr.POS_Z)
                //cmplx( gctr.POS_Y, gctr.POS_X)
                CINTdcmplx_pp(nf, tmp1, gc_1, gc_z);
                CINTdcmplx_pp(nf, tmp1+nf, gc_y, gc_x);
                //cmplx(-gctr.POS_Y, gctr.POS_X)
                //cmplx( gctr.POS_1,-gctr.POS_Z)
                CINTdcmplx_np(nf, tmp1+nfi*nf2j, gc_y, gc_x);
                CINTdcmplx_pn(nf, tmp1+nfi*nf2j+nf, gc_1, gc_z);
                (c2s_bra_spinor_si[i_l])(tmp2, nf2j, tmp1, i_kp, i_l);
                (c2s_ket_spinor[j_l])(tmp1, di, tmp2, j_kp, j_l);
                zcopy_ij(opij+ofj*jc+di*ic, tmp1, ni, nj, di, dj);

                gc_x += nf;
                gc_y += nf;
                gc_z += nf;
                gc_1 += nf;
        } }
}
void c2s_si_1ei(double complex *opij, double *gctr, FINT *dims,
                CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT ofj = ni * dj;
        FINT nfi = envs->nfi;
        FINT nfj = envs->nfj;
        FINT nf2i = nfi + nfi;
        FINT nf2j = nfj + nfj;
        FINT nf = envs->nf;
        FINT ic, jc;
        double *gc_x = gctr;
        double *gc_y = gc_x + nf * i_ctr * j_ctr;
        double *gc_z = gc_y + nf * i_ctr * j_ctr;
        double *gc_1 = gc_z + nf * i_ctr * j_ctr;
        double complex *tmp1, *tmp2;
        MALLOC_INSTACK(tmp1, double complex, nf2i*nf2j);
        MALLOC_INSTACK(tmp2, double complex, di*nf2j);

        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                //cmplx( gctr.POS_1, gctr.POS_Z)
                //cmplx( gctr.POS_Y, gctr.POS_X)
                CINTdcmplx_pp(nf, tmp1, gc_1, gc_z);
                CINTdcmplx_pp(nf, tmp1+nf, gc_y, gc_x);
                //cmplx(-gctr.POS_Y, gctr.POS_X)
                //cmplx( gctr.POS_1,-gctr.POS_Z)
                CINTdcmplx_np(nf, tmp1+nfi*nf2j, gc_y, gc_x);
                CINTdcmplx_pn(nf, tmp1+nfi*nf2j+nf, gc_1, gc_z);
                (c2s_bra_spinor_si[i_l])(tmp2, nf2j, tmp1, i_kp, i_l);
                (c2s_iket_spinor[j_l])(tmp1, di, tmp2, j_kp, j_l);
                zcopy_ij(opij+ofj*jc+di*ic, tmp1, ni, nj, di, dj);

                gc_x += nf;
                gc_y += nf;
                gc_z += nf;
                gc_1 += nf;
        } }
}


/*
 * 2e integrals, cartesian to real spheric.
 *
 * gctr: Cartesian GTO integrals, ordered as <ik|lj>
 */
static double *sph2e_inner(double *gsph, double *gcart,
                           FINT l, FINT nbra, FINT ncall, FINT sizsph, FINT sizcart);
void c2s_sph_2e1(double *out, double *gctr, FINT *dims,
                 CINTEnvVars *envs, double *cache)
{
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT k_l = envs->k_l;
        FINT l_l = envs->l_l;
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT l_ctr = envs->x_ctr[3];
        FINT di = i_l * 2 + 1;
        FINT dj = j_l * 2 + 1;
        FINT dk = k_l * 2 + 1;
        FINT dl = l_l * 2 + 1;
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT nk = dims[2];
        FINT nl = dims[3];
        FINT nfi = envs->nfi;
        FINT nfk = envs->nfk;
        FINT nfl = envs->nfl;
        FINT nfik = nfi * nfk;
        FINT nfikl = nfik * nfl;
        FINT dlj = dl * dj;
        FINT nf = envs->nf;
        FINT ofj = ni * dj;
        FINT ofk = ni * nj * dk;
        FINT ofl = ni * nj * nk * dl;
        FINT ic, jc, kc, lc;
        FINT buflen = nfikl*dj;
        double *buf1;
        MALLOC_INSTACK(buf1, double, buflen*4);
        double *buf2 = buf1 + buflen;
        double *buf3 = buf2 + buflen;
        double *buf4 = buf3 + buflen;
        double *pout, *tmp1;

        for (lc = 0; lc < l_ctr; lc++) {
        for (kc = 0; kc < k_ctr; kc++) {
        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                tmp1 = (c2s_ket_sph[j_l])(buf1, gctr, nfikl, nfikl, j_l);
                tmp1 = sph2e_inner(buf2, tmp1, l_l, nfik, dj, nfik*dl, nfikl);
                tmp1 = sph2e_inner(buf3, tmp1, k_l, nfi, dlj, nfi*dk, nfik);

                tmp1 = (c2s_bra_sph[i_l])(buf4, dk*dlj, tmp1, i_l);

                pout = out + ofl * lc + ofk * kc + ofj * jc + di * ic;
                dcopy_iklj(pout, tmp1, ni, nj, nk, nl, di, dj, dk, dl);
                gctr += nf;
        } } } }
}
/*
 * use f_ket to transform k,l for gctr(i,j,k,l), where
 * sizsph = nbra * (2*l+1)
 * sizcart = nbra * (l*(l+1)/2)
 * and return the pointer to the buffer which holds the transformed gctr
 */
static double *sph2e_inner(double *gsph, double *gcart,
                           FINT l, FINT nbra, FINT ncall, FINT sizsph, FINT sizcart)
{
        FINT n;
        switch (l) {
        case 0: case 1:
                return gcart;
        case 2:
                for (n = 0; n < ncall; n++) {
                        d_ket_cart2spheric(gsph+n*sizsph, gcart+n*sizcart, nbra, nbra, l);
                }
                break;
        case 3:
                for (n = 0; n < ncall; n++) {
                        f_ket_cart2spheric(gsph+n*sizsph, gcart+n*sizcart, nbra, nbra, l);
                }
                break;
        case 4:
                for (n = 0; n < ncall; n++) {
                        g_ket_cart2spheric(gsph+n*sizsph, gcart+n*sizcart, nbra, nbra, l);
                }
                break;
        default:
                for (n = 0; n < ncall; n++) {
                        a_ket_cart2spheric(gsph+n*sizsph, gcart+n*sizcart, nbra, nbra, l);
                }
        }
        return gsph;
}


/*
 * 2e integrals, cartesian to spin free spinor for electron 1.
 *
 * gctr: Cartesian GTO integrals, ordered as <ik|lj>
 * opij: partial transformed GTO integrals, ordered as <ik|lj>
 */
void c2s_sf_2e1(double complex *opij, double *gctr, FINT *dims,
                CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT l_ctr = envs->x_ctr[3];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT nfj = envs->nfj;
        FINT nfk = envs->nfk;
        FINT nfl = envs->nfl;
        FINT nf2j = nfj + nfj;
        FINT nf = envs->nf;
        FINT no = di * nfk * nfl * dj;
        FINT d_i = di * nfk * nfl;
        FINT d_j = nfk * nfl * nfj;
        FINT i;
        double complex *tmp1;
        MALLOC_INSTACK(tmp1, double complex, di*nfk*nfl*nf2j);

        for (i = 0; i < i_ctr * j_ctr * k_ctr * l_ctr; i++) {
                (c2s_bra_spinor_e1sf[i_l])(tmp1, d_j, gctr, i_kp, i_l);
                (c2s_ket_spinor[j_l])(opij, d_i, tmp1, j_kp, j_l);
                gctr += nf;
                opij += no;
        }
}
void c2s_sf_2e1i(double complex *opij, double *gctr, FINT *dims,
                 CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT l_ctr = envs->x_ctr[3];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT nfj = envs->nfj;
        FINT nfk = envs->nfk;
        FINT nfl = envs->nfl;
        FINT nf2j = nfj + nfj;
        FINT nf = envs->nf;
        FINT no = di * nfk * nfl * dj;
        FINT d_i = di * nfk * nfl;
        FINT d_j = nfk * nfl * nfj;
        FINT i;
        double complex *tmp1;
        MALLOC_INSTACK(tmp1, double complex, di*nfk*nfl*nf2j);

        for (i = 0; i < i_ctr * j_ctr * k_ctr * l_ctr; i++) {
                (c2s_bra_spinor_e1sf[i_l])(tmp1, d_j, gctr, i_kp, i_l);
                (c2s_iket_spinor[j_l])(opij, d_i, tmp1, j_kp, j_l);
                gctr += nf;
                opij += no;
        }
}


/*
 * 2e integrals, cartesian to spin free spinor for electron 2.
 *
 * opij: partial transformed GTO integrals, ordered as <ik|lj>
 */
void c2s_sf_2e2(double complex *fijkl, double complex *opij, FINT *dims,
                CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT k_sh = shls[2];
        FINT l_sh = shls[3];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT k_l = envs->k_l;
        FINT l_l = envs->l_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT k_kp = bas(KAPPA_OF, k_sh);
        FINT l_kp = bas(KAPPA_OF, l_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT l_ctr = envs->x_ctr[3];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT dk = _len_spinor(k_kp, k_l);
        FINT dl = _len_spinor(l_kp, l_l);
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT nk = dims[2];
        FINT nl = dims[3];
        FINT nfk = envs->nfk;
        FINT nfl = envs->nfl;
        FINT nf2k = nfk + nfk;
        FINT nf2l = nfl + nfl;
        FINT d_k = dk * di * dj;
        FINT d_l = di * dj * nfl;
        FINT nop = nfk * di * dj * nfl;
        FINT ofj = ni * dj;
        FINT ofk = ni * nj * dk;
        FINT ofl = ni * nj * nk * dl;
        FINT ic, jc, kc, lc;
        double complex *pfijkl;
        FINT len1 = nf2k*di*dj*nf2l;
        FINT len2 = dk*di*dj*nf2l;
        double complex *tmp1, *tmp2;
        MALLOC_INSTACK(tmp1, double complex, len1);
        MALLOC_INSTACK(tmp2, double complex, len2);

        for (lc = 0; lc < l_ctr; lc++) {
        for (kc = 0; kc < k_ctr; kc++) {
        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                zswap_ik_jl(tmp1, opij, di, dj, nfk, nfl);
                (c2s_bra_spinor_sf[k_l])(tmp2, d_l, tmp1, k_kp, k_l);
                (c2s_ket_spinor[l_l])(tmp1, d_k, tmp2, l_kp, l_l);
                pfijkl = fijkl + (ofl * lc + ofk * kc + ofj * jc + di * ic);

                zcopy_kijl(pfijkl, tmp1, ni, nj, nk, nl, di, dj, dk, dl);
                opij += nop;
        } } } }
}
void c2s_sf_2e2i(double complex *fijkl, double complex *opij, FINT *dims,
                 CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT k_sh = shls[2];
        FINT l_sh = shls[3];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT k_l = envs->k_l;
        FINT l_l = envs->l_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT k_kp = bas(KAPPA_OF, k_sh);
        FINT l_kp = bas(KAPPA_OF, l_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT l_ctr = envs->x_ctr[3];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT dk = _len_spinor(k_kp, k_l);
        FINT dl = _len_spinor(l_kp, l_l);
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT nk = dims[2];
        FINT nl = dims[3];
        FINT nfk = envs->nfk;
        FINT nfl = envs->nfl;
        FINT nf2k = nfk + nfk;
        FINT nf2l = nfl + nfl;
        FINT d_k = dk * di * dj;
        FINT d_l = di * dj * nfl;
        FINT nop = nfk * di * dj * nfl;
        FINT ofj = ni * dj;
        FINT ofk = ni * nj * dk;
        FINT ofl = ni * nj * nk * dl;
        FINT ic, jc, kc, lc;
        double complex *pfijkl;
        FINT len1 = nf2k*di*dj*nf2l;
        FINT len2 = dk*di*dj*nf2l;
        double complex *tmp1, *tmp2;
        MALLOC_INSTACK(tmp1, double complex, len1);
        MALLOC_INSTACK(tmp2, double complex, len2);

        for (lc = 0; lc < l_ctr; lc++) {
        for (kc = 0; kc < k_ctr; kc++) {
        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                zswap_ik_jl(tmp1, opij, di, dj, nfk, nfl);
                (c2s_bra_spinor_sf[k_l])(tmp2, d_l, tmp1, k_kp, k_l);
                (c2s_iket_spinor[l_l])(tmp1, d_k, tmp2, l_kp, l_l);
                pfijkl = fijkl + (ofl * lc + ofk * kc + ofj * jc + di * ic);

                zcopy_kijl(pfijkl, tmp1, ni, nj, nk, nl, di, dj, dk, dl);
                opij += nop;
        } } } }
}

/*
 * 2e integrals, cartesian to spinor for electron 1.
 *
 * gctr: Cartesian GTO integrals, ordered as <ik|lj>
 * opij: partial transformed GTO integrals, ordered as <ik|lj>
 */
void c2s_si_2e1(double complex *opij, double *gctr, FINT *dims,
                CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT l_ctr = envs->x_ctr[3];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT nfi = envs->nfi;
        FINT nfj = envs->nfj;
        FINT nfk = envs->nfk;
        FINT nfl = envs->nfl;
        FINT nf2i = nfi + nfi;
        FINT nf2j = nfj + nfj;
        FINT nf = envs->nf;
        FINT no = di * nfk * nfl * dj;
        FINT d_i = di * nfk * nfl;
        FINT d_j = nfk * nfl * nf2j;
        FINT i;
        double *gc_x = gctr;
        double *gc_y = gc_x + nf * i_ctr * j_ctr * k_ctr * l_ctr;
        double *gc_z = gc_y + nf * i_ctr * j_ctr * k_ctr * l_ctr;
        double *gc_1 = gc_z + nf * i_ctr * j_ctr * k_ctr * l_ctr;
        FINT len1 = nf2i*nfk*nfl*nf2j;
        FINT len2 = di*nfk*nfl*nf2j;
        double complex *tmp1, *tmp2;
        MALLOC_INSTACK(tmp1, double complex, len1);
        MALLOC_INSTACK(tmp2, double complex, len2);

        for (i = 0; i < i_ctr * j_ctr * k_ctr * l_ctr; i++) {
                //cmplx( gctr.POS_1, gctr.POS_Z)
                //cmplx( gctr.POS_Y, gctr.POS_X)
                CINTdcmplx_pp(nf, tmp1, gc_1, gc_z);
                CINTdcmplx_pp(nf, tmp1+nf, gc_y, gc_x);
                //cmplx(-gctr.POS_Y, gctr.POS_X)
                //cmplx( gctr.POS_1,-gctr.POS_Z)
                CINTdcmplx_np(nf, tmp1+nfi*d_j, gc_y, gc_x);
                CINTdcmplx_pn(nf, tmp1+nfi*d_j+nf, gc_1, gc_z);
                (c2s_bra_spinor_si[i_l])(tmp2, d_j, tmp1, i_kp, i_l);
                (c2s_ket_spinor[j_l])(opij, d_i, tmp2, j_kp, j_l);
                gc_x += nf;
                gc_y += nf;
                gc_z += nf;
                gc_1 += nf;
                opij += no;
        }
}
void c2s_si_2e1i(double complex *opij, double *gctr, FINT *dims,
                 CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT l_ctr = envs->x_ctr[3];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT nfi = envs->nfi;
        FINT nfj = envs->nfj;
        FINT nfk = envs->nfk;
        FINT nfl = envs->nfl;
        FINT nf2i = nfi + nfi;
        FINT nf2j = nfj + nfj;
        FINT nf = envs->nf;
        FINT no = di * nfk * nfl * dj;
        FINT d_i = di * nfk * nfl;
        FINT d_j = nfk * nfl * nf2j;
        FINT i;
        double *gc_x = gctr;
        double *gc_y = gc_x + nf * i_ctr * j_ctr * k_ctr * l_ctr;
        double *gc_z = gc_y + nf * i_ctr * j_ctr * k_ctr * l_ctr;
        double *gc_1 = gc_z + nf * i_ctr * j_ctr * k_ctr * l_ctr;
        FINT len1 = nf2i*nfk*nfl*nf2j;
        FINT len2 = di*nfk*nfl*nf2j;
        double complex *tmp1, *tmp2;
        MALLOC_INSTACK(tmp1, double complex, len1);
        MALLOC_INSTACK(tmp2, double complex, len2);

        for (i = 0; i < i_ctr * j_ctr * k_ctr * l_ctr; i++) {
                //cmplx( gctr.POS_1, gctr.POS_Z)
                //cmplx( gctr.POS_Y, gctr.POS_X)
                CINTdcmplx_pp(nf, tmp1, gc_1, gc_z);
                CINTdcmplx_pp(nf, tmp1+nf, gc_y, gc_x);
                //cmplx(-gctr.POS_Y, gctr.POS_X)
                //cmplx( gctr.POS_1,-gctr.POS_Z)
                CINTdcmplx_np(nf, tmp1+nfi*d_j, gc_y, gc_x);
                CINTdcmplx_pn(nf, tmp1+nfi*d_j+nf, gc_1, gc_z);
                (c2s_bra_spinor_si[i_l])(tmp2, d_j, tmp1, i_kp, i_l);
                (c2s_iket_spinor[j_l])(opij, d_i, tmp2, j_kp, j_l);
                gc_x += nf;
                gc_y += nf;
                gc_z += nf;
                gc_1 += nf;
                opij += no;
        }
}

/*
 * 2e integrals, cartesian to spinor for electron 2.
 *
 * opij: partial transformed GTO integrals, ordered as <ik|lj>
 */
static void si2e_swap(double complex *new,
                      const double complex *oldx, const double complex *oldy,
                      const double complex *oldz, const double complex *old1,
                      const FINT ni, const FINT nj, const FINT nk, const FINT nl)
{
        FINT i, j, k, l;
        FINT dlo = ni * nk; // stride of (i,k,l++,j)
        FINT djo = ni * nk * nl; // stride of (i,k,l,j++)
        FINT djn = nk * ni; // stride of (k,i,j++,l)
        FINT dln = nk * ni * nj; // stride of (k,i,j,l++)
        double complex *new11 = new;
        double complex *new12 = new11 + nk * ni * nj * nl;
        double complex *new21 = new12 + nk * ni * nj * nl;
        double complex *new22 = new21 + nk * ni * nj * nl;
        double complex *pn11, *pn12, *pn21, *pn22;
        const double complex *ox, *oy, *oz, *o1;

        //tmp1(k    ,i,j,l    ) = opij(m,n,POS_1) + IZ1*opij(m,n,POS_Z)
        //tmp1(k    ,i,j,l+nfl) = opij(m,n,POS_Y) + IZ1*opij(m,n,POS_X)
        //tmp1(k+nfk,i,j,l    ) =-opij(m,n,POS_Y) + IZ1*opij(m,n,POS_X)
        //tmp1(k+nfk,i,j,l+nfl) = opij(m,n,POS_1) - IZ1*opij(m,n,POS_Z)
        for (l = 0; l < nl; l++) {
        for (j = 0; j < nj; j++) {
                pn11 = new11 + l * dln + j * djn;
                pn12 = new12 + l * dln + j * djn;
                pn21 = new21 + l * dln + j * djn;
                pn22 = new22 + l * dln + j * djn;
                ox = oldx + l * dlo + j * djo;
                oy = oldy + l * dlo + j * djo;
                oz = oldz + l * dlo + j * djo;
                o1 = old1 + l * dlo + j * djo;
                for (i = 0; i < ni; i++) {
                for (k = 0; k < nk; k++) {
                        pn11[i*nk+k] = o1[k*ni+i] + oz[k*ni+i]*_Complex_I;
                        pn12[i*nk+k] = oy[k*ni+i] + ox[k*ni+i]*_Complex_I;
                        pn21[i*nk+k] =-oy[k*ni+i] + ox[k*ni+i]*_Complex_I;
                        pn22[i*nk+k] = o1[k*ni+i] - oz[k*ni+i]*_Complex_I;
                } }
        } }
}
void c2s_si_2e2(double complex *fijkl, double complex *opij, FINT *dims,
                CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT k_sh = shls[2];
        FINT l_sh = shls[3];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT k_l = envs->k_l;
        FINT l_l = envs->l_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT k_kp = bas(KAPPA_OF, k_sh);
        FINT l_kp = bas(KAPPA_OF, l_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT l_ctr = envs->x_ctr[3];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT dk = _len_spinor(k_kp, k_l);
        FINT dl = _len_spinor(l_kp, l_l);
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT nk = dims[2];
        FINT nl = dims[3];
        FINT nfk = envs->nfk;
        FINT nfl = envs->nfl;
        FINT nf2k = nfk + nfk;
        FINT nf2l = nfl + nfl;
        FINT d_k = dk * di * dj;
        FINT d_l = di * dj * nf2l;
        FINT nop = nfk * di * dj * nfl;
        FINT ofj = ni * dj;
        FINT ofk = ni * nj * dk;
        FINT ofl = ni * nj * nk * dl;
        FINT ic, jc, kc, lc;
        double complex *pfijkl;
        double complex *ox = opij;
        double complex *oy = ox + nop * i_ctr * j_ctr * k_ctr * l_ctr;
        double complex *oz = oy + nop * i_ctr * j_ctr * k_ctr * l_ctr;
        double complex *o1 = oz + nop * i_ctr * j_ctr * k_ctr * l_ctr;
        FINT len1 = nf2k*di*dj*nf2l;
        FINT len2 = dk*di*dj*nf2l;
        double complex *tmp1, *tmp2;
        MALLOC_INSTACK(tmp1, double complex, len1);
        MALLOC_INSTACK(tmp2, double complex, len2);

        for (lc = 0; lc < l_ctr; lc++) {
        for (kc = 0; kc < k_ctr; kc++) {
        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                si2e_swap(tmp1, ox, oy, oz, o1, di, dj, nfk, nfl);
                (c2s_bra_spinor_si[k_l])(tmp2, d_l, tmp1, k_kp, k_l);
                (c2s_ket_spinor[l_l])(tmp1, d_k, tmp2, l_kp, l_l);
                pfijkl = fijkl + (ofl * lc + ofk * kc + ofj * jc + di * ic);

                zcopy_kijl(pfijkl, tmp1, ni, nj, nk, nl, di, dj, dk, dl);

                ox += nop;
                oy += nop;
                oz += nop;
                o1 += nop;
        } } } }
}
void c2s_si_2e2i(double complex *fijkl, double complex *opij, FINT *dims,
                 CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT k_sh = shls[2];
        FINT l_sh = shls[3];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT k_l = envs->k_l;
        FINT l_l = envs->l_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT k_kp = bas(KAPPA_OF, k_sh);
        FINT l_kp = bas(KAPPA_OF, l_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT l_ctr = envs->x_ctr[3];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT dk = _len_spinor(k_kp, k_l);
        FINT dl = _len_spinor(l_kp, l_l);
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT nk = dims[2];
        FINT nl = dims[3];
        FINT nfk = envs->nfk;
        FINT nfl = envs->nfl;
        FINT nf2k = nfk + nfk;
        FINT nf2l = nfl + nfl;
        FINT d_k = dk * di * dj;
        FINT d_l = di * dj * nf2l;
        FINT nop = nfk * di * dj * nfl;
        FINT ofj = ni * dj;
        FINT ofk = ni * nj * dk;
        FINT ofl = ni * nj * nk * dl;
        FINT ic, jc, kc, lc;
        double complex *pfijkl;
        double complex *ox = opij;
        double complex *oy = ox + nop * i_ctr * j_ctr * k_ctr * l_ctr;
        double complex *oz = oy + nop * i_ctr * j_ctr * k_ctr * l_ctr;
        double complex *o1 = oz + nop * i_ctr * j_ctr * k_ctr * l_ctr;
        FINT len1 = nf2k*di*dj*nf2l;
        FINT len2 = dk*di*dj*nf2l;
        double complex *tmp1, *tmp2;
        MALLOC_INSTACK(tmp1, double complex, len1);
        MALLOC_INSTACK(tmp2, double complex, len2);

        for (lc = 0; lc < l_ctr; lc++) {
        for (kc = 0; kc < k_ctr; kc++) {
        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                si2e_swap(tmp1, ox, oy, oz, o1, di, dj, nfk, nfl);
                (c2s_bra_spinor_si[k_l])(tmp2, d_l, tmp1, k_kp, k_l);
                (c2s_iket_spinor[l_l])(tmp1, d_k, tmp2, l_kp, l_l);
                pfijkl = fijkl + (ofl * lc + ofk * kc + ofj * jc + di * ic);

                zcopy_kijl(pfijkl, tmp1, ni, nj, nk, nl, di, dj, dk, dl);

                ox += nop;
                oy += nop;
                oz += nop;
                o1 += nop;
        } } } }
}

/*
 * 1e integrals, reorder cartesian integrals.
 */
void c2s_cart_1e(double *opij, double *gctr, FINT *dims,
                 CINTEnvVars *envs, double *cache)
{
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT nfi = envs->nfi;
        FINT nfj = envs->nfj;
        FINT nf = envs->nf;
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT ofj = ni * nfj;
        FINT ic, jc;
        double *popij;

        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                popij = opij + ofj * jc + nfi * ic;
                dcopy_ij(popij, gctr, ni, nj, nfi, nfj);
                gctr += nf;
        } }
}

/*
 * 2e integrals, reorder cartesian integrals.
 */
void c2s_cart_2e1(double *fijkl, double *gctr, FINT *dims, CINTEnvVars *envs,
                  double *cache)
{
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT l_ctr = envs->x_ctr[3];
        FINT nfi = envs->nfi;
        FINT nfj = envs->nfj;
        FINT nfk = envs->nfk;
        FINT nfl = envs->nfl;
        FINT nf = envs->nf;
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT nk = dims[2];
        FINT nl = dims[3];
        FINT ofj = ni * nfj;
        FINT ofk = ni * nj * nfk;
        FINT ofl = ni * nj * nk * nfl;
        FINT ic, jc, kc, lc;
        double *pfijkl;

        for (lc = 0; lc < l_ctr; lc++) {
        for (kc = 0; kc < k_ctr; kc++) {
        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                pfijkl = fijkl + ofl * lc + ofk * kc + ofj * jc + nfi * ic;
                dcopy_iklj(pfijkl, gctr, ni, nj, nk, nl, nfi, nfj, nfk, nfl);
                gctr += nf;
        } } } }
}
void c2s_cart_2e2() {};


/*************************************************
 *
 * 3-center 2-electron integral transformation
 *
 *************************************************/
void c2s_sph_3c2e1(double *bufijk, double *gctr, FINT *dims,
                   CINTEnvVars *envs, double *cache)
{
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT k_l = envs->k_l;
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT di = i_l * 2 + 1;
        FINT dj = j_l * 2 + 1;
        FINT dk = k_l * 2 + 1;
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT nk = dims[2];
        FINT nfi = envs->nfi;
        FINT nfk = envs->nfk;
        FINT nf = envs->nf;
        FINT nfik = nfi * nfk;
        FINT ofj = ni * dj;
        FINT ofk = ni * nj * dk;
        FINT ic, jc, kc;
        FINT buflen = nfi*nfk*dj;
        double *buf1;
        MALLOC_INSTACK(buf1, double, buflen*3);
        double *buf2 = buf1 + buflen;
        double *buf3 = buf2 + buflen;
        double *pijk;
        double *tmp1;

        for (kc = 0; kc < k_ctr; kc++) {
        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                tmp1 = (c2s_ket_sph[j_l])(buf1, gctr, nfik, nfik, j_l);
                tmp1 = sph2e_inner(buf2, tmp1, k_l, nfi, dj, nfi*dk, nfik);
                tmp1 = (c2s_bra_sph[i_l])(buf3, dk*dj, tmp1, i_l);
                pijk = bufijk + ofk * kc + ofj * jc + di * ic;
                dcopy_iklj(pijk, tmp1, ni, nj, nk, 1, di, dj, dk, 1);
                gctr += nf;
        } } }
}

void c2s_cart_3c2e1(double *bufijk, double *gctr, FINT *dims,
                    CINTEnvVars *envs, double *cache)
{
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT nfi = envs->nfi;
        FINT nfj = envs->nfj;
        FINT nfk = envs->nfk;
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT nk = dims[2];
        FINT nf = envs->nf;
        FINT ofj = ni * nfj;
        FINT ofk = ni * nj * nfk;
        FINT ic, jc, kc;
        double *pijk;

        for (kc = 0; kc < k_ctr; kc++) {
        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                pijk = bufijk + ofk * kc + ofj * jc + nfi * ic;
                dcopy_iklj(pijk, gctr, ni, nj, nk, 1, nfi, nfj, nfk, 1);
                gctr += nf;
        } } }
}

/*
 * ssc ~ (spheric,spheric|cartesian)
 */
void c2s_sph_3c2e1_ssc(double *bufijk, double *gctr, FINT *dims,
                       CINTEnvVars *envs, double *cache)
{
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT di = i_l * 2 + 1;
        FINT dj = j_l * 2 + 1;
        FINT nfi = envs->nfi;
        FINT nfk = envs->nfk;
        FINT ni = di * i_ctr;
        FINT nj = dj * j_ctr;
        FINT nk = nfk * k_ctr;
        FINT nf = envs->nf;
        FINT nfik = nfi * nfk;
        FINT ofj = ni * dj;
        FINT ofk = ni * nj * nfk;
        FINT ic, jc, kc;
        FINT buflen = nfi*nfk*dj;
        double *buf1, *buf2;
        MALLOC_INSTACK(buf1, double, buflen);
        MALLOC_INSTACK(buf2, double, buflen);
        double *pijk;
        double *tmp1;

        for (kc = 0; kc < k_ctr; kc++) {
        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                tmp1 = (c2s_ket_sph[j_l])(buf1, gctr, nfik, nfik, j_l);
                tmp1 = (c2s_bra_sph[i_l])(buf2, nfk*dj, tmp1, i_l);
                pijk = bufijk + ofk * kc + ofj * jc + nfi * ic;
                dcopy_iklj(pijk, tmp1, ni, nj, nk, 1, di, dj, nfk, 1);
                gctr += nf;
        } } }
}

/*
 * 3c2e spinor integrals, cartesian to spin free spinor for electron 1.
 */
void c2s_sf_3c2e1(double complex *opijk, double *gctr, FINT *dims,
                  CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT k_l = envs->k_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT dk = k_l * 2 + 1;
        FINT nfi = envs->nfi;
        FINT nfj = envs->nfj;
        FINT nfk = envs->nfk;
        FINT nf2j = nfj + nfj;
        FINT nf = envs->nf;
        FINT nfik = nfi * nfk;
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT nk = dims[2];
        FINT ofj = ni * dj;
        FINT ofk = ni * nj * dk;
        FINT d_i = di * dk;
        FINT d_j = dk * nfj;
        FINT ic, jc, kc;
        FINT buflen = nfi*dk*nfj;
        double *buf, *pbuf;
        MALLOC_INSTACK(buf, double, buflen);
        FINT len1 = di*dk*nf2j;
        FINT len2 = di*dk*dj;
        double complex *tmp1, *tmp2;
        MALLOC_INSTACK(tmp1, double complex, len1);
        MALLOC_INSTACK(tmp2, double complex, len2);
        double complex *pijk;

        for (kc = 0; kc < k_ctr; kc++) {
        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                pbuf = sph2e_inner(buf, gctr, k_l, nfi, nfj, nfi*dk, nfik);
                (c2s_bra_spinor_e1sf[i_l])(tmp1, d_j, pbuf, i_kp, i_l);
                (c2s_ket_spinor[j_l])(tmp2, d_i, tmp1, j_kp, j_l);
                pijk = opijk + ofk * kc + ofj * jc + di * ic;
                zcopy_iklj(pijk, tmp2, ni, nj, nk, 1, di, dj, dk, 1);
                gctr += nf;
        } } }
}
void c2s_sf_3c2e1i(double complex *opijk, double *gctr, FINT *dims,
                   CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT k_l = envs->k_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT dk = k_l * 2 + 1;
        FINT nfi = envs->nfi;
        FINT nfj = envs->nfj;
        FINT nfk = envs->nfk;
        FINT nf2j = nfj + nfj;
        FINT nf = envs->nf;
        FINT nfik = nfi * nfk;
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT nk = dims[2];
        FINT ofj = ni * dj;
        FINT ofk = ni * nj * dk;
        FINT d_i = di * dk;
        FINT d_j = dk * nfj;
        FINT ic, jc, kc;
        FINT buflen = nfi*dk*nfj;
        double *buf, *pbuf;
        MALLOC_INSTACK(buf, double, buflen);
        FINT len1 = di*dk*nf2j;
        FINT len2 = di*dk*dj;
        double complex *tmp1, *tmp2;
        MALLOC_INSTACK(tmp1, double complex, len1);
        MALLOC_INSTACK(tmp2, double complex, len2);
        double complex *pijk;

        for (kc = 0; kc < k_ctr; kc++) {
        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                pbuf = sph2e_inner(buf, gctr, k_l, nfi, nfj, nfi*dk, nfik);
                (c2s_bra_spinor_e1sf[i_l])(tmp1, d_j, pbuf, i_kp, i_l);
                (c2s_iket_spinor[j_l])(tmp2, d_i, tmp1, j_kp, j_l);
                pijk = opijk + ofk * kc + ofj * jc + di * ic;
                zcopy_iklj(pijk, tmp2, ni, nj, nk, 1, di, dj, dk, 1);
                gctr += nf;
        } } }
}
/*
 * 3c2e integrals, cartesian to spinor for electron 1.
 */
void c2s_si_3c2e1(double complex *opijk, double *gctr, FINT *dims,
                  CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT k_l = envs->k_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT dk = k_l * 2 + 1;
        FINT nfi = envs->nfi;
        FINT nfj = envs->nfj;
        FINT nfk = envs->nfk;
        FINT nf2i = nfi + nfi;
        FINT nf2j = nfj + nfj;
        FINT nf = envs->nf;
        FINT nfik = nfi * nfk;
        FINT nfijdk = nfi * nfj * dk;
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT nk = dims[2];
        FINT ofj = ni * dj;
        FINT ofk = ni * nj * dk;
        FINT d_i = di * dk;
        FINT d_j = dk * nf2j;
        FINT ic, jc, kc;
        double *gc_x = gctr;
        double *gc_y = gc_x + nf * i_ctr * j_ctr * k_ctr;
        double *gc_z = gc_y + nf * i_ctr * j_ctr * k_ctr;
        double *gc_1 = gc_z + nf * i_ctr * j_ctr * k_ctr;
        FINT buflen = nfi*dk*nfj;
        double *bufx;
        MALLOC_INSTACK(bufx, double, buflen*4);
        double *bufy = bufx + buflen;
        double *bufz = bufy + buflen;
        double *buf1 = bufz + buflen;
        double *pbufx, *pbufy, *pbufz, *pbuf1;
        FINT len1 = nf2i*dk*nf2j;
        FINT len2 = di*dk*nf2j;
        FINT len3 = di*dk*dj;
        double complex *tmp1;
        MALLOC_INSTACK(tmp1, double complex, len1+len2+len3);
        double complex *tmp2 = tmp1 + len1;
        double complex *tmp3 = tmp2 + len2;
        double complex *pijk;

        for (kc = 0; kc < k_ctr; kc++) {
        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                pbufx = sph2e_inner(bufx, gc_x, k_l, nfi, nfj, nfi*dk, nfik);
                pbufy = sph2e_inner(bufy, gc_y, k_l, nfi, nfj, nfi*dk, nfik);
                pbufz = sph2e_inner(bufz, gc_z, k_l, nfi, nfj, nfi*dk, nfik);
                pbuf1 = sph2e_inner(buf1, gc_1, k_l, nfi, nfj, nfi*dk, nfik);
                //cmplx( gctr.POS_1, gctr.POS_Z)
                //cmplx( gctr.POS_Y, gctr.POS_X)
                CINTdcmplx_pp(nfijdk, tmp1, pbuf1, pbufz);
                CINTdcmplx_pp(nfijdk, tmp1+nfijdk, pbufy, pbufx);
                //cmplx(-gctr.POS_Y, gctr.POS_X)
                //cmplx( gctr.POS_1,-gctr.POS_Z)
                CINTdcmplx_np(nfijdk, tmp1+nfi*d_j, pbufy, pbufx);
                CINTdcmplx_pn(nfijdk, tmp1+nfi*d_j+nfijdk, pbuf1, pbufz);
                (c2s_bra_spinor_si[i_l])(tmp2, d_j, tmp1, i_kp, i_l);
                (c2s_ket_spinor[j_l])(tmp3, d_i, tmp2, j_kp, j_l);
                pijk = opijk + ofk * kc + ofj * jc + di * ic;
                zcopy_iklj(pijk, tmp3, ni, nj, nk, 1, di, dj, dk, 1);
                gc_x += nf;
                gc_y += nf;
                gc_z += nf;
                gc_1 += nf;
        } } }
}

void c2s_si_3c2e1i(double complex *opijk, double *gctr, FINT *dims,
                   CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT k_l = envs->k_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT dk = k_l * 2 + 1;
        FINT nfi = envs->nfi;
        FINT nfj = envs->nfj;
        FINT nfk = envs->nfk;
        FINT nf2i = nfi + nfi;
        FINT nf2j = nfj + nfj;
        FINT nf = envs->nf;
        FINT nfik = nfi * nfk;
        FINT nfijdk = nfi * nfj * dk;
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT nk = dims[2];
        FINT ofj = ni * dj;
        FINT ofk = ni * nj * dk;
        FINT d_i = di * dk;
        FINT d_j = dk * nf2j;
        FINT ic, jc, kc;
        double *gc_x = gctr;
        double *gc_y = gc_x + nf * i_ctr * j_ctr * k_ctr;
        double *gc_z = gc_y + nf * i_ctr * j_ctr * k_ctr;
        double *gc_1 = gc_z + nf * i_ctr * j_ctr * k_ctr;
        double *bufx;
        FINT buflen = nfi*dk*nfj;
        MALLOC_INSTACK(bufx, double, buflen*4);
        double *bufy = bufx + buflen;
        double *bufz = bufy + buflen;
        double *buf1 = bufz + buflen;
        double *pbufx, *pbufy, *pbufz, *pbuf1;
        FINT len1 = nf2i*dk*nf2j;
        FINT len2 = di*dk*nf2j;
        FINT len3 = di*dk*dj;
        double complex *tmp1;
        MALLOC_INSTACK(tmp1, double complex, len1+len2+len3);
        double complex *tmp2 = tmp1 + len1;
        double complex *tmp3 = tmp2 + len2;
        double complex *pijk;

        for (kc = 0; kc < k_ctr; kc++) {
        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                pbufx = sph2e_inner(bufx, gc_x, k_l, nfi, nfj, nfi*dk, nfik);
                pbufy = sph2e_inner(bufy, gc_y, k_l, nfi, nfj, nfi*dk, nfik);
                pbufz = sph2e_inner(bufz, gc_z, k_l, nfi, nfj, nfi*dk, nfik);
                pbuf1 = sph2e_inner(buf1, gc_1, k_l, nfi, nfj, nfi*dk, nfik);
                //cmplx( gctr.POS_1, gctr.POS_Z)
                //cmplx( gctr.POS_Y, gctr.POS_X)
                CINTdcmplx_pp(nfijdk, tmp1, pbuf1, pbufz);
                CINTdcmplx_pp(nfijdk, tmp1+nfijdk, pbufy, pbufx);
                //cmplx(-gctr.POS_Y, gctr.POS_X)
                //cmplx( gctr.POS_1,-gctr.POS_Z)
                CINTdcmplx_np(nfijdk, tmp1+nfi*d_j, pbufy, pbufx);
                CINTdcmplx_pn(nfijdk, tmp1+nfi*d_j+nfijdk, pbuf1, pbufz);
                (c2s_bra_spinor_si[i_l])(tmp2, d_j, tmp1, i_kp, i_l);
                (c2s_iket_spinor[j_l])(tmp3, d_i, tmp2, j_kp, j_l);
                pijk = opijk + ofk * kc + ofj * jc + di * ic;
                zcopy_iklj(pijk, tmp3, ni, nj, nk, 1, di, dj, dk, 1);
                gc_x += nf;
                gc_y += nf;
                gc_z += nf;
                gc_1 += nf;
        } } }
}

void c2s_sf_3c2e1_ssc(double complex *opijk, double *gctr, FINT *dims,
                      CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT nfj = envs->nfj;
        FINT nfk = envs->nfk;
        FINT nf2j = nfj + nfj;
        FINT nf = envs->nf;
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT nk = dims[2];
        FINT ofj = ni * dj;
        FINT ofk = ni * nj * nfk;
        FINT d_i = di * nfk;
        FINT d_j = nfk * nfj;
        FINT ic, jc, kc;
        FINT len1 = di*nfk*nf2j;
        FINT len2 = di*nfk*dj;
        double complex *tmp1, *tmp2;
        MALLOC_INSTACK(tmp1, double complex, len1);
        MALLOC_INSTACK(tmp2, double complex, len2);
        double complex *pijk;

        for (kc = 0; kc < k_ctr; kc++) {
        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                (c2s_bra_spinor_e1sf[i_l])(tmp1, d_j, gctr, i_kp, i_l);
                (c2s_ket_spinor[j_l])(tmp2, d_i, tmp1, j_kp, j_l);
                pijk = opijk + ofk * kc + ofj * jc + di * ic;
                zcopy_iklj(pijk, tmp2, ni, nj, nk, 1, di, dj, nfk, 1);
                gctr += nf;
        } } }
}

void c2s_sf_3c2e1i_ssc(double complex *opijk, double *gctr, FINT *dims,
                       CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT nfj = envs->nfj;
        FINT nfk = envs->nfk;
        FINT nf2j = nfj + nfj;
        FINT nf = envs->nf;
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT nk = dims[2];
        FINT ofj = ni * dj;
        FINT ofk = ni * nj * nfk;
        FINT d_i = di * nfk;
        FINT d_j = nfk * nfj;
        FINT ic, jc, kc;
        FINT len1 = di*nfk*nf2j;
        FINT len2 = di*nfk*dj;
        double complex *tmp1, *tmp2;
        MALLOC_INSTACK(tmp1, double complex, len1);
        MALLOC_INSTACK(tmp2, double complex, len2);
        double complex *pijk;

        for (kc = 0; kc < k_ctr; kc++) {
        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                (c2s_bra_spinor_e1sf[i_l])(tmp1, d_j, gctr, i_kp, i_l);
                (c2s_iket_spinor[j_l])(tmp2, d_i, tmp1, j_kp, j_l);
                pijk = opijk + ofk * kc + ofj * jc + di * ic;
                zcopy_iklj(pijk, tmp2, ni, nj, nk, 1, di, dj, nfk, 1);
                gctr += nf;
        } } }
}
void c2s_si_3c2e1_ssc(double complex *opijk, double *gctr, FINT *dims,
                      CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT nfi = envs->nfi;
        FINT nfj = envs->nfj;
        FINT nfk = envs->nfk;
        FINT nf2i = nfi + nfi;
        FINT nf2j = nfj + nfj;
        FINT nf = envs->nf;
        FINT nfijdk = nfi * nfj * nfk;
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT nk = dims[2];
        FINT ofj = ni * dj;
        FINT ofk = ni * nj * nfk;
        FINT d_i = di * nfk;
        FINT d_j = nfk * nf2j;
        FINT ic, jc, kc;
        double *gc_x = gctr;
        double *gc_y = gc_x + nf * i_ctr * j_ctr * k_ctr;
        double *gc_z = gc_y + nf * i_ctr * j_ctr * k_ctr;
        double *gc_1 = gc_z + nf * i_ctr * j_ctr * k_ctr;
        FINT len1 = nf2i*nfk*nf2j;
        FINT len2 = di*nfk*nf2j;
        FINT len3 = di*nfk*dj;
        double complex *tmp1;
        MALLOC_INSTACK(tmp1, double complex, len1+len2+len3);
        double complex *tmp2 = tmp1 + len1;
        double complex *tmp3 = tmp2 + len2;
        double complex *pijk;

        for (kc = 0; kc < k_ctr; kc++) {
        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                //cmplx( gctr.POS_1, gctr.POS_Z)
                //cmplx( gctr.POS_Y, gctr.POS_X)
                CINTdcmplx_pp(nfijdk, tmp1, gc_1, gc_z);
                CINTdcmplx_pp(nfijdk, tmp1+nfijdk, gc_y, gc_x);
                //cmplx(-gctr.POS_Y, gctr.POS_X)
                //cmplx( gctr.POS_1,-gctr.POS_Z)
                CINTdcmplx_np(nfijdk, tmp1+nfi*d_j, gc_y, gc_x);
                CINTdcmplx_pn(nfijdk, tmp1+nfi*d_j+nfijdk, gc_1, gc_z);
                (c2s_bra_spinor_si[i_l])(tmp2, d_j, tmp1, i_kp, i_l);
                (c2s_ket_spinor[j_l])(tmp3, d_i, tmp2, j_kp, j_l);
                pijk = opijk + ofk * kc + ofj * jc + di * ic;
                zcopy_iklj(pijk, tmp3, ni, nj, nk, 1, di, dj, nfk, 1);
                gc_x += nf;
                gc_y += nf;
                gc_z += nf;
                gc_1 += nf;
        } } }
}
void c2s_si_3c2e1i_ssc(double complex *opijk, double *gctr, FINT *dims,
                       CINTEnvVars *envs, double *cache)
{
        FINT *shls = envs->shls;
        FINT *bas = envs->bas;
        FINT i_sh = shls[0];
        FINT j_sh = shls[1];
        FINT i_l = envs->i_l;
        FINT j_l = envs->j_l;
        FINT i_kp = bas(KAPPA_OF, i_sh);
        FINT j_kp = bas(KAPPA_OF, j_sh);
        FINT i_ctr = envs->x_ctr[0];
        FINT j_ctr = envs->x_ctr[1];
        FINT k_ctr = envs->x_ctr[2];
        FINT di = _len_spinor(i_kp, i_l);
        FINT dj = _len_spinor(j_kp, j_l);
        FINT nfi = envs->nfi;
        FINT nfj = envs->nfj;
        FINT nfk = envs->nfk;
        FINT nf2i = nfi + nfi;
        FINT nf2j = nfj + nfj;
        FINT nf = envs->nf;
        FINT nfijdk = nfi * nfj * nfk;
        FINT ni = dims[0];
        FINT nj = dims[1];
        FINT nk = dims[2];
        FINT ofj = ni * dj;
        FINT ofk = ni * nj * nfk;
        FINT d_i = di * nfk;
        FINT d_j = nfk * nf2j;
        FINT ic, jc, kc;
        double *gc_x = gctr;
        double *gc_y = gc_x + nf * i_ctr * j_ctr * k_ctr;
        double *gc_z = gc_y + nf * i_ctr * j_ctr * k_ctr;
        double *gc_1 = gc_z + nf * i_ctr * j_ctr * k_ctr;
        FINT len1 = nf2i*nfk*nf2j;
        FINT len2 = di*nfk*nf2j;
        FINT len3 = di*nfk*dj;
        double complex *tmp1;
        MALLOC_INSTACK(tmp1, double complex, len1+len2+len3);
        double complex *tmp2 = tmp1 + len1;
        double complex *tmp3 = tmp2 + len2;
        double complex *pijk;

        for (kc = 0; kc < k_ctr; kc++) {
        for (jc = 0; jc < j_ctr; jc++) {
        for (ic = 0; ic < i_ctr; ic++) {
                //cmplx( gctr.POS_1, gctr.POS_Z)
                //cmplx( gctr.POS_Y, gctr.POS_X)
                CINTdcmplx_pp(nfijdk, tmp1, gc_1, gc_z);
                CINTdcmplx_pp(nfijdk, tmp1+nfijdk, gc_y, gc_x);
                //cmplx(-gctr.POS_Y, gctr.POS_X)
                //cmplx( gctr.POS_1,-gctr.POS_Z)
                CINTdcmplx_np(nfijdk, tmp1+nfi*d_j, gc_y, gc_x);
                CINTdcmplx_pn(nfijdk, tmp1+nfi*d_j+nfijdk, gc_1, gc_z);
                (c2s_bra_spinor_si[i_l])(tmp2, d_j, tmp1, i_kp, i_l);
                (c2s_iket_spinor[j_l])(tmp3, d_i, tmp2, j_kp, j_l);
                pijk = opijk + ofk * kc + ofj * jc + di * ic;
                zcopy_iklj(pijk, tmp3, ni, nj, nk, 1, di, dj, nfk, 1);
                gc_x += nf;
                gc_y += nf;
                gc_z += nf;
                gc_1 += nf;
        } } }
}


/*************************************************
 *
 * 3-center 1-electron integral transformation
 *
 *************************************************/
void c2s_sph_3c1e(double *out, double *gctr, FINT *dims,
                  CINTEnvVars *envs, double *cache)
{
        c2s_sph_3c2e1(out, gctr, dims, envs, cache);
}

void c2s_cart_3c1e(double *out, double *gctr, FINT *dims,
                   CINTEnvVars *envs, double *cache)
{
        c2s_cart_3c2e1(out, gctr, dims, envs, cache);
}


/*************************************************
 *
 * transform vectors
 *
 *************************************************/
double *CINTc2s_bra_sph(double *gsph, FINT nket, double *gcart, FINT l)
{
        return (c2s_bra_sph[l])(gsph, nket, gcart, l);
}
double *CINTc2s_ket_sph(double *gsph, FINT nbra, double *gcart, FINT l)
{
        return (c2s_ket_sph[l])(gsph, gcart, nbra, nbra, l);
}
double *CINTc2s_ket_sph1(double *sph, double *cart, FINT lds, FINT ldc, FINT l)
{
        return (c2s_ket_sph1[l])(sph, cart, lds, ldc, l);
}
void CINTc2s_bra_spinor_e1sf(double complex *gsp, FINT nket,
                             double *gcart, FINT kappa, FINT l)
{
        (c2s_bra_spinor_e1sf[l])(gsp, nket, gcart, kappa, l);
}
void CINTc2s_bra_spinor_sf(double complex *gsp, FINT nket,
                           double complex *gcart, FINT kappa, FINT l)
{
        (c2s_bra_spinor_sf[l])(gsp, nket, gcart, kappa, l);
}
void CINTc2s_ket_spinor(double complex *gsp, FINT nbra,
                        double complex *gcart, FINT kappa, FINT l)
{
        (c2s_ket_spinor[l])(gsp, nbra, gcart, kappa, l);
}
void CINTc2s_iket_spinor(double complex *gsp, FINT nbra,
                         double complex *gcart, FINT kappa, FINT l)
{
        (c2s_iket_spinor[l])(gsp, nbra, gcart, kappa, l);
}
void CINTc2s_bra_spinor_si(double complex *gsp, FINT nket,
                           double complex *gcart, FINT kappa, FINT l)
{
        (c2s_bra_spinor_si[l])(gsp, nket, gcart, kappa, l);
}


/*
 * vectors gspa and gspb are the upper and lower components of the
 * two-component vector
 */
void CINTc2s_ket_spinor_sf1(double complex *gspa, double complex *gspb, double *gcart,
                            FINT lds, FINT ldc, FINT nctr, FINT kappa, FINT l)
{
        FINT nf = (l+1)*(l+2)/2;
        FINT deg = _len_spinor(kappa, l);
        FINT k;
        for (k = 0; k < nctr; k++) {
                (c2s_ket_spinor_e1sf[l])(gspa, gspb, gcart, lds, ldc, kappa, l);
                gspa += deg * lds;
                gspb += deg * lds;
                gcart += nf * ldc;
        }
}
void CINTc2s_iket_spinor_sf1(double complex *gspa, double complex *gspb, double *gcart,
                             FINT lds, FINT ldc, FINT nctr, FINT kappa, FINT l)
{
        FINT nf = (l+1)*(l+2)/2;
        FINT deg = _len_spinor(kappa, l);
        FINT k;
        for (k = 0; k < nctr; k++) {
                (c2s_iket_spinor_e1sf[l])(gspa, gspb, gcart, lds, ldc, kappa, l);
                gspa += deg * lds;
                gspb += deg * lds;
                gcart += nf * ldc;
        }
}
void CINTc2s_ket_spinor_si1(double complex *gspa, double complex *gspb, double *gcart,
                            FINT lds, FINT ldc, FINT nctr, FINT kappa, FINT l)
{
        FINT nf = (l+1)*(l+2)/2;
        FINT deg = _len_spinor(kappa, l);
        FINT ngc = nf * ldc;
        double *gc_x = gcart;
        double *gc_y = gc_x + nctr*ngc;
        double *gc_z = gc_y + nctr*ngc;
        double *gc_1 = gc_z + nctr*ngc;
        double complex *tmp = malloc(sizeof(double complex)*ngc*4);
        FINT k;

        for (k = 0; k < nctr; k++) {
                //cmplx( gctr.POS_1, gctr.POS_Z)
                //cmplx( gctr.POS_Y, gctr.POS_X)
                CINTdcmplx_pp(ngc, tmp      , gc_1+k*ngc, gc_z+k*ngc);
                CINTdcmplx_pp(ngc, tmp+ngc  , gc_y+k*ngc, gc_x+k*ngc);
                //cmplx(-gctr.POS_Y, gctr.POS_X)
                //cmplx( gctr.POS_1,-gctr.POS_Z)
                CINTdcmplx_np(ngc, tmp+ngc*2, gc_y+k*ngc, gc_x+k*ngc);
                CINTdcmplx_pn(ngc, tmp+ngc*3, gc_1+k*ngc, gc_z+k*ngc);
                (c2s_ket_spinor_si[l])(gspa, gspb, tmp, lds, ldc, kappa, l);
                gspa += deg * lds;
                gspb += deg * lds;
        }
        free(tmp);
}
void CINTc2s_iket_spinor_si1(double complex *gspa, double complex *gspb, double *gcart,
                             FINT lds, FINT ldc, FINT nctr, FINT kappa, FINT l)
{
        FINT nf = (l+1)*(l+2)/2;
        FINT deg = _len_spinor(kappa, l);
        FINT ngc = nf * ldc;
        double *gc_x = gcart;
        double *gc_y = gc_x + nctr*ngc;
        double *gc_z = gc_y + nctr*ngc;
        double *gc_1 = gc_z + nctr*ngc;
        double complex *tmp = malloc(sizeof(double complex)*ngc*4);
        FINT k;

        for (k = 0; k < nctr; k++) {
                //i*cmplx( gctr.POS_1, gctr.POS_Z)
                //i*cmplx( gctr.POS_Y, gctr.POS_X)
                CINTdcmplx_np(ngc, tmp      , gc_z+k*ngc, gc_1+k*ngc);
                CINTdcmplx_np(ngc, tmp+ngc  , gc_x+k*ngc, gc_y+k*ngc);
                //i*cmplx(-gctr.POS_Y, gctr.POS_X)
                //i*cmplx( gctr.POS_1,-gctr.POS_Z)
                CINTdcmplx_nn(ngc, tmp+ngc*2, gc_x+k*ngc, gc_y+k*ngc);
                CINTdcmplx_pp(ngc, tmp+ngc*3, gc_z+k*ngc, gc_1+k*ngc);
                (c2s_ket_spinor_si[l])(gspa, gspb, tmp, lds, ldc, kappa, l);
                gspa += deg * lds;
                gspb += deg * lds;
        }
        free(tmp);
}

/*
 * Spherical to Cartesian back transformation
 * The input gsph (Fortran contiguous) has l*2+1 rows
 * The output gcart (Fortran contiguous) has (l+1)*(l+2)/2 rows
 */
double *CINTs2c_bra_sph(double *gsph, FINT nket, double *gcart, FINT l)
{
        const double D0 = 0;
        const double D1 = 1;
        const char TRANS_N = 'N';
        FINT nf = (l+1)*(l+2)/2;
        FINT nd = l * 2 + 1;
        dgemm_(&TRANS_N, &TRANS_N, &nf, &nket, &nd,
               &D1, g_c2s[l].cart2sph, &nf, gsph, &nd,
               &D0, gcart, &nf);
        return gcart;
}
double *CINTs2c_ket_sph(double *gsph, FINT nbra, double *gcart, FINT l)
{
        const double D0 = 0;
        const double D1 = 1;
        const char TRANS_T = 'T';
        const char TRANS_N = 'N';
        FINT nf = (l+1)*(l+2)/2;
        FINT nd = l * 2 + 1;
        dgemm_(&TRANS_N, &TRANS_T, &nbra, &nf, &nd,
               &D1, gsph, &nbra, g_c2s[l].cart2sph, &nf,
               &D0, gcart, &nbra);
        return gcart;
}
