/*
 * Copyright (C) 2013-  Qiming Sun <osirpt.sun@gmail.com>
 * Description: code generated by  gen-code.cl
 */
#include <stdlib.h>
#include "cint_bas.h"
#include "cart2sph.h"
#include "g1e.h"
#include "g2e.h"
#include "optimizer.h"
#include "cint1e.h"
#include "cint2e.h"
#include "misc.h"
#include "c2f.h"
/* <i|OVLP |SIGMA j> */
static void CINTgout1e_int1e_sigma(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double s[1];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g0[ix+0]*g0[iy+0]*g0[iz+0];
gout[n*12+0] += - s[0];
gout[n*12+1] += 0;
gout[n*12+2] += 0;
gout[n*12+3] += 0;
gout[n*12+4] += 0;
gout[n*12+5] += - s[0];
gout[n*12+6] += 0;
gout[n*12+7] += 0;
gout[n*12+8] += 0;
gout[n*12+9] += 0;
gout[n*12+10] += - s[0];
gout[n*12+11] += 0;
}}
void int1e_sigma_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 0, 0, 0, 0, 4, 1, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_sigma_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 0, 0, 0, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_sigma;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_sigma_cart
int int1e_sigma_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 0, 0, 0, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_sigma;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_sigma_sph
int int1e_sigma_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 0, 0, 0, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_sigma;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_si_1ei, 0);
} // int1e_sigma_spinor
ALL_CINT1E(int1e_sigma)
ALL_CINT1E_FORTRAN_(int1e_sigma)
/* <SIGMA DOT P i|OVLP |SIGMA SIGMA DOT P j> */
static void CINTgout1e_int1e_spsigmasp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, 0);
G1E_D_I(g2, g0, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g3, g1, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*12+0] += - s[0] + s[8] + s[4];
gout[n*12+1] += -2*s[3];
gout[n*12+2] += -2*s[6];
gout[n*12+3] += 0;
gout[n*12+4] += -2*s[1];
gout[n*12+5] += - s[4] + s[0] + s[8];
gout[n*12+6] += -2*s[7];
gout[n*12+7] += 0;
gout[n*12+8] += -2*s[2];
gout[n*12+9] += -2*s[5];
gout[n*12+10] += - s[8] + s[4] + s[0];
gout[n*12+11] += 0;
}}
void int1e_spsigmasp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_spsigmasp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_spsigmasp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_spsigmasp_cart
int int1e_spsigmasp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_spsigmasp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_spsigmasp_sph
int int1e_spsigmasp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_spsigmasp;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_si_1ei, 0);
} // int1e_spsigmasp_spinor
ALL_CINT1E(int1e_spsigmasp)
ALL_CINT1E_FORTRAN_(int1e_spsigmasp)
/* <SIGMA DOT R i|OVLP |SIGMA DOT R j> */
static void CINTgout1e_int1e_srsr(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_R_J(g1, g0, envs->i_l+1, envs->j_l+0, 0);
G1E_R_I(g2, g0, envs->i_l+0, envs->j_l, 0);
G1E_R_I(g3, g1, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*4+0] += + s[5] - s[7];
gout[n*4+1] += + s[6] - s[2];
gout[n*4+2] += + s[1] - s[3];
gout[n*4+3] += + s[0] + s[4] + s[8];
}}
void int1e_srsr_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_srsr_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_srsr;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_srsr_cart
int int1e_srsr_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_srsr;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_srsr_sph
int int1e_srsr_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_srsr;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_si_1e, 0);
} // int1e_srsr_spinor
ALL_CINT1E(int1e_srsr)
ALL_CINT1E_FORTRAN_(int1e_srsr)
/* <SIGMA DOT R i|OVLP |j> */
static void CINTgout1e_int1e_sr(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double s[3];
G1E_R_I(g1, g0, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
gout[n*4+0] += - s[0];
gout[n*4+1] += - s[1];
gout[n*4+2] += - s[2];
gout[n*4+3] += 0;
}}
void int1e_sr_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 0, 0, 0, 1, 4, 1, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_sr_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_sr;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_sr_cart
int int1e_sr_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_sr;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_sr_sph
int int1e_sr_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_sr;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_si_1ei, 0);
} // int1e_sr_spinor
ALL_CINT1E(int1e_sr)
ALL_CINT1E_FORTRAN_(int1e_sr)
/* <SIGMA DOT R i|OVLP |SIGMA DOT P j> */
static void CINTgout1e_int1e_srsp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, 0);
G1E_R_I(g2, g0, envs->i_l+0, envs->j_l, 0);
G1E_R_I(g3, g1, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*4+0] += - s[5] + s[7];
gout[n*4+1] += - s[6] + s[2];
gout[n*4+2] += - s[1] + s[3];
gout[n*4+3] += - s[0] - s[4] - s[8];
}}
void int1e_srsp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_srsp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_srsp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_srsp_cart
int int1e_srsp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_srsp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_srsp_sph
int int1e_srsp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_srsp;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_si_1ei, 0);
} // int1e_srsp_spinor
ALL_CINT1E(int1e_srsp)
ALL_CINT1E_FORTRAN_(int1e_srsp)
/* <SIGMA DOT P i|OVLP |SIGMA DOT P j> */
static void CINTgout1e_int1e_spsp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, 0);
G1E_D_I(g2, g0, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g3, g1, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*1+0] += + s[0] + s[4] + s[8];
}}
void int1e_spsp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_spsp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_spsp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_spsp_cart
int int1e_spsp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_spsp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_spsp_sph
int int1e_spsp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_spsp;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_spsp_spinor
ALL_CINT1E(int1e_spsp)
ALL_CINT1E_FORTRAN_(int1e_spsp)
/* <SIGMA DOT P i|OVLP |j> */
static void CINTgout1e_int1e_sp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double s[3];
G1E_D_I(g1, g0, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
gout[n*4+0] += + s[0];
gout[n*4+1] += + s[1];
gout[n*4+2] += + s[2];
gout[n*4+3] += 0;
}}
void int1e_sp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 0, 0, 0, 1, 4, 1, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_sp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_sp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_sp_cart
int int1e_sp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_sp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_sp_sph
int int1e_sp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_sp;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_si_1e, 0);
} // int1e_sp_spinor
ALL_CINT1E(int1e_sp)
ALL_CINT1E_FORTRAN_(int1e_sp)
/* <SIGMA DOT P i|NUC |SIGMA DOT P j> */
static void CINTgout1e_int1e_spnucsp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, 0);
G1E_D_I(g2, g0, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g3, g1, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*4+0] += + s[5] - s[7];
gout[n*4+1] += + s[6] - s[2];
gout[n*4+2] += + s[1] - s[3];
gout[n*4+3] += + s[0] + s[4] + s[8];
}}
void int1e_spnucsp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_spnucsp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_spnucsp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 2);
} // int1e_spnucsp_cart
int int1e_spnucsp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_spnucsp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 2);
} // int1e_spnucsp_sph
int int1e_spnucsp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_spnucsp;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_si_1e, 2);
} // int1e_spnucsp_spinor
ALL_CINT1E(int1e_spnucsp)
ALL_CINT1E_FORTRAN_(int1e_spnucsp)
/* <SIGMA DOT R i|NUC |SIGMA DOT R j> */
static void CINTgout1e_int1e_srnucsr(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_R_J(g1, g0, envs->i_l+1, envs->j_l+0, 0);
G1E_R_I(g2, g0, envs->i_l+0, envs->j_l, 0);
G1E_R_I(g3, g1, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*4+0] += + s[5] - s[7];
gout[n*4+1] += + s[6] - s[2];
gout[n*4+2] += + s[1] - s[3];
gout[n*4+3] += + s[0] + s[4] + s[8];
}}
void int1e_srnucsr_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_srnucsr_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_srnucsr;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 2);
} // int1e_srnucsr_cart
int int1e_srnucsr_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_srnucsr;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 2);
} // int1e_srnucsr_sph
int int1e_srnucsr_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_srnucsr;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_si_1e, 2);
} // int1e_srnucsr_spinor
ALL_CINT1E(int1e_srnucsr)
ALL_CINT1E_FORTRAN_(int1e_srnucsr)
/* <G i|OVLP |j> */
static void CINTgout1e_int1e_govlp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double rirj[3], c[3];
rirj[0] = envs->ri[0] - envs->rj[0];
rirj[1] = envs->ri[1] - envs->rj[1];
rirj[2] = envs->ri[2] - envs->rj[2];
c[0] = 1 * rirj[0];
c[1] = 1 * rirj[1];
c[2] = 1 * rirj[2];
double s[3];
G1E_R0I(g1, g0, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
gout[n*3+0] += + c[1]*s[2] - c[2]*s[1];
gout[n*3+1] += + c[2]*s[0] - c[0]*s[2];
gout[n*3+2] += + c[0]*s[1] - c[1]*s[0];
}}
void int1e_govlp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_govlp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_govlp;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_govlp_cart
int int1e_govlp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_govlp;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_govlp_sph
int int1e_govlp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_govlp;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1ei, 0);
} // int1e_govlp_spinor
ALL_CINT1E(int1e_govlp)
ALL_CINT1E_FORTRAN_(int1e_govlp)
/* <G i|NUC |j> */
static void CINTgout1e_int1e_gnuc(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double rirj[3], c[3];
rirj[0] = envs->ri[0] - envs->rj[0];
rirj[1] = envs->ri[1] - envs->rj[1];
rirj[2] = envs->ri[2] - envs->rj[2];
c[0] = 1 * rirj[0];
c[1] = 1 * rirj[1];
c[2] = 1 * rirj[2];
double s[3];
G1E_R0I(g1, g0, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
gout[n*3+0] += + c[1]*s[2] - c[2]*s[1];
gout[n*3+1] += + c[2]*s[0] - c[0]*s[2];
gout[n*3+2] += + c[0]*s[1] - c[1]*s[0];
}}
void int1e_gnuc_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 0, 0, 0, 1, 1, 0, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_gnuc_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_gnuc;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 2);
} // int1e_gnuc_cart
int int1e_gnuc_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_gnuc;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 2);
} // int1e_gnuc_sph
int int1e_gnuc_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_gnuc;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1ei, 2);
} // int1e_gnuc_spinor
ALL_CINT1E(int1e_gnuc)
ALL_CINT1E_FORTRAN_(int1e_gnuc)
/* <SIGMA CROSS RC i|SIGMA CROSS NABLA-RINV |j> */
static void CINTgout1e_int1e_cg_sa10sa01(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double dri[3];
dri[0] = envs->ri[0] - envs->env[PTR_COMMON_ORIG+0];
dri[1] = envs->ri[1] - envs->env[PTR_COMMON_ORIG+1];
dri[2] = envs->ri[2] - envs->env[PTR_COMMON_ORIG+2];
double s[9];
G1E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, 0);
G1E_D_I(g2, g0, envs->i_l+1, envs->j_l+0, 0);
for (ix = 0; ix < envs->g_size * 3; ix++) {g1[ix] += g2[ix];}
G1E_RCI(g2, g0, envs->i_l+0, envs->j_l, 0);
G1E_RCI(g3, g1, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*36+0] += - s[7] + s[5];
gout[n*36+1] += 0;
gout[n*36+2] += 0;
gout[n*36+3] += + s[8] + s[4];
gout[n*36+4] += + s[6];
gout[n*36+5] += + s[5];
gout[n*36+6] += + s[8];
gout[n*36+7] += - s[3];
gout[n*36+8] += - s[3];
gout[n*36+9] += - s[4];
gout[n*36+10] += - s[7];
gout[n*36+11] += - s[6];
gout[n*36+12] += - s[2];
gout[n*36+13] += - s[7];
gout[n*36+14] += - s[8];
gout[n*36+15] += - s[1];
gout[n*36+16] += 0;
gout[n*36+17] += - s[2] + s[6];
gout[n*36+18] += 0;
gout[n*36+19] += + s[8] + s[0];
gout[n*36+20] += + s[0];
gout[n*36+21] += + s[1];
gout[n*36+22] += + s[6];
gout[n*36+23] += - s[7];
gout[n*36+24] += + s[1];
gout[n*36+25] += + s[4];
gout[n*36+26] += + s[5];
gout[n*36+27] += - s[2];
gout[n*36+28] += - s[0];
gout[n*36+29] += - s[3];
gout[n*36+30] += - s[2];
gout[n*36+31] += - s[5];
gout[n*36+32] += 0;
gout[n*36+33] += 0;
gout[n*36+34] += - s[3] + s[1];
gout[n*36+35] += + s[4] + s[0];
}}
void int1e_cg_sa10sa01_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 9};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_cg_sa10sa01_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_cg_sa10sa01;
envs.common_factor *= 0.5;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 1);
} // int1e_cg_sa10sa01_cart
int int1e_cg_sa10sa01_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_cg_sa10sa01;
envs.common_factor *= 0.5;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 1);
} // int1e_cg_sa10sa01_sph
int int1e_cg_sa10sa01_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_cg_sa10sa01;
envs.common_factor *= 0.5;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_si_1e, 1);
} // int1e_cg_sa10sa01_spinor
ALL_CINT1E(int1e_cg_sa10sa01)
ALL_CINT1E_FORTRAN_(int1e_cg_sa10sa01)
/* <RC CROSS SIGMA i|OVLP |SIGMA DOT P j> */
static void CINTgout1e_int1e_cg_sa10sp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double dri[3];
dri[0] = envs->ri[0] - envs->env[PTR_COMMON_ORIG+0];
dri[1] = envs->ri[1] - envs->env[PTR_COMMON_ORIG+1];
dri[2] = envs->ri[2] - envs->env[PTR_COMMON_ORIG+2];
double s[9];
G1E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, 0);
G1E_RCI(g2, g0, envs->i_l+0, envs->j_l, 0);
G1E_RCI(g3, g1, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*12+0] += + s[8] + s[4];
gout[n*12+1] += - s[3];
gout[n*12+2] += - s[6];
gout[n*12+3] += + s[7] - s[5];
gout[n*12+4] += - s[1];
gout[n*12+5] += + s[0] + s[8];
gout[n*12+6] += - s[7];
gout[n*12+7] += - s[6] + s[2];
gout[n*12+8] += - s[2];
gout[n*12+9] += - s[5];
gout[n*12+10] += + s[4] + s[0];
gout[n*12+11] += + s[3] - s[1];
}}
void int1e_cg_sa10sp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_cg_sa10sp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_cg_sa10sp;
envs.common_factor *= 0.5;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_cg_sa10sp_cart
int int1e_cg_sa10sp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_cg_sa10sp;
envs.common_factor *= 0.5;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_cg_sa10sp_sph
int int1e_cg_sa10sp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_cg_sa10sp;
envs.common_factor *= 0.5;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_si_1ei, 0);
} // int1e_cg_sa10sp_spinor
ALL_CINT1E(int1e_cg_sa10sp)
ALL_CINT1E_FORTRAN_(int1e_cg_sa10sp)
/* <RC CROSS SIGMA i|NUC |SIGMA DOT P j> */
static void CINTgout1e_int1e_cg_sa10nucsp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double dri[3];
dri[0] = envs->ri[0] - envs->env[PTR_COMMON_ORIG+0];
dri[1] = envs->ri[1] - envs->env[PTR_COMMON_ORIG+1];
dri[2] = envs->ri[2] - envs->env[PTR_COMMON_ORIG+2];
double s[9];
G1E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, 0);
G1E_RCI(g2, g0, envs->i_l+0, envs->j_l, 0);
G1E_RCI(g3, g1, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*12+0] += + s[8] + s[4];
gout[n*12+1] += - s[3];
gout[n*12+2] += - s[6];
gout[n*12+3] += + s[7] - s[5];
gout[n*12+4] += - s[1];
gout[n*12+5] += + s[0] + s[8];
gout[n*12+6] += - s[7];
gout[n*12+7] += - s[6] + s[2];
gout[n*12+8] += - s[2];
gout[n*12+9] += - s[5];
gout[n*12+10] += + s[4] + s[0];
gout[n*12+11] += + s[3] - s[1];
}}
void int1e_cg_sa10nucsp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_cg_sa10nucsp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_cg_sa10nucsp;
envs.common_factor *= 0.5;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 2);
} // int1e_cg_sa10nucsp_cart
int int1e_cg_sa10nucsp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_cg_sa10nucsp;
envs.common_factor *= 0.5;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 2);
} // int1e_cg_sa10nucsp_sph
int int1e_cg_sa10nucsp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_cg_sa10nucsp;
envs.common_factor *= 0.5;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_si_1ei, 2);
} // int1e_cg_sa10nucsp_spinor
ALL_CINT1E(int1e_cg_sa10nucsp)
ALL_CINT1E_FORTRAN_(int1e_cg_sa10nucsp)
/* <SIGMA CROSS R i|SIGMA CROSS NABLA-RINV |j> */
static void CINTgout1e_int1e_giao_sa10sa01(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, 0);
G1E_D_I(g2, g0, envs->i_l+1, envs->j_l+0, 0);
for (ix = 0; ix < envs->g_size * 3; ix++) {g1[ix] += g2[ix];}
G1E_R_I(g2, g0, envs->i_l+0, envs->j_l, 0);
G1E_R_I(g3, g1, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*36+0] += - s[7] + s[5];
gout[n*36+1] += 0;
gout[n*36+2] += 0;
gout[n*36+3] += + s[8] + s[4];
gout[n*36+4] += + s[6];
gout[n*36+5] += + s[5];
gout[n*36+6] += + s[8];
gout[n*36+7] += - s[3];
gout[n*36+8] += - s[3];
gout[n*36+9] += - s[4];
gout[n*36+10] += - s[7];
gout[n*36+11] += - s[6];
gout[n*36+12] += - s[2];
gout[n*36+13] += - s[7];
gout[n*36+14] += - s[8];
gout[n*36+15] += - s[1];
gout[n*36+16] += 0;
gout[n*36+17] += - s[2] + s[6];
gout[n*36+18] += 0;
gout[n*36+19] += + s[8] + s[0];
gout[n*36+20] += + s[0];
gout[n*36+21] += + s[1];
gout[n*36+22] += + s[6];
gout[n*36+23] += - s[7];
gout[n*36+24] += + s[1];
gout[n*36+25] += + s[4];
gout[n*36+26] += + s[5];
gout[n*36+27] += - s[2];
gout[n*36+28] += - s[0];
gout[n*36+29] += - s[3];
gout[n*36+30] += - s[2];
gout[n*36+31] += - s[5];
gout[n*36+32] += 0;
gout[n*36+33] += 0;
gout[n*36+34] += - s[3] + s[1];
gout[n*36+35] += + s[4] + s[0];
}}
void int1e_giao_sa10sa01_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 9};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_giao_sa10sa01_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_giao_sa10sa01;
envs.common_factor *= 0.5;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 1);
} // int1e_giao_sa10sa01_cart
int int1e_giao_sa10sa01_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_giao_sa10sa01;
envs.common_factor *= 0.5;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 1);
} // int1e_giao_sa10sa01_sph
int int1e_giao_sa10sa01_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_giao_sa10sa01;
envs.common_factor *= 0.5;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_si_1e, 1);
} // int1e_giao_sa10sa01_spinor
ALL_CINT1E(int1e_giao_sa10sa01)
ALL_CINT1E_FORTRAN_(int1e_giao_sa10sa01)
/* <R CROSS SIGMA i|OVLP |SIGMA DOT P j> */
static void CINTgout1e_int1e_giao_sa10sp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, 0);
G1E_R_I(g2, g0, envs->i_l+0, envs->j_l, 0);
G1E_R_I(g3, g1, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*12+0] += + s[8] + s[4];
gout[n*12+1] += - s[3];
gout[n*12+2] += - s[6];
gout[n*12+3] += + s[7] - s[5];
gout[n*12+4] += - s[1];
gout[n*12+5] += + s[0] + s[8];
gout[n*12+6] += - s[7];
gout[n*12+7] += - s[6] + s[2];
gout[n*12+8] += - s[2];
gout[n*12+9] += - s[5];
gout[n*12+10] += + s[4] + s[0];
gout[n*12+11] += + s[3] - s[1];
}}
void int1e_giao_sa10sp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_giao_sa10sp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_giao_sa10sp;
envs.common_factor *= 0.5;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_giao_sa10sp_cart
int int1e_giao_sa10sp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_giao_sa10sp;
envs.common_factor *= 0.5;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_giao_sa10sp_sph
int int1e_giao_sa10sp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_giao_sa10sp;
envs.common_factor *= 0.5;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_si_1ei, 0);
} // int1e_giao_sa10sp_spinor
ALL_CINT1E(int1e_giao_sa10sp)
ALL_CINT1E_FORTRAN_(int1e_giao_sa10sp)
/* <R CROSS SIGMA i|NUC |SIGMA DOT P j> */
static void CINTgout1e_int1e_giao_sa10nucsp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, 0);
G1E_R_I(g2, g0, envs->i_l+0, envs->j_l, 0);
G1E_R_I(g3, g1, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*12+0] += + s[8] + s[4];
gout[n*12+1] += - s[3];
gout[n*12+2] += - s[6];
gout[n*12+3] += + s[7] - s[5];
gout[n*12+4] += - s[1];
gout[n*12+5] += + s[0] + s[8];
gout[n*12+6] += - s[7];
gout[n*12+7] += - s[6] + s[2];
gout[n*12+8] += - s[2];
gout[n*12+9] += - s[5];
gout[n*12+10] += + s[4] + s[0];
gout[n*12+11] += + s[3] - s[1];
}}
void int1e_giao_sa10nucsp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_giao_sa10nucsp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_giao_sa10nucsp;
envs.common_factor *= 0.5;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 2);
} // int1e_giao_sa10nucsp_cart
int int1e_giao_sa10nucsp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_giao_sa10nucsp;
envs.common_factor *= 0.5;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 2);
} // int1e_giao_sa10nucsp_sph
int int1e_giao_sa10nucsp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_giao_sa10nucsp;
envs.common_factor *= 0.5;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_si_1ei, 2);
} // int1e_giao_sa10nucsp_spinor
ALL_CINT1E(int1e_giao_sa10nucsp)
ALL_CINT1E_FORTRAN_(int1e_giao_sa10nucsp)
/* <i|NABLA-RINV CROSS SIGMA |SIGMA DOT P j> */
static void CINTgout1e_int1e_sa01sp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_D_J(g1, g0, envs->i_l+0, envs->j_l+0, 0);
G1E_D_J(g2, g0, envs->i_l+0, envs->j_l+1, 0);
G1E_D_I(g3, g0, envs->i_l+0, envs->j_l+1, 0);
for (ix = 0; ix < envs->g_size * 3; ix++) {g2[ix] += g3[ix];}
G1E_D_J(g3, g2, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*12+0] += + s[8] + s[4];
gout[n*12+1] += - s[3];
gout[n*12+2] += - s[6];
gout[n*12+3] += + s[7] - s[5];
gout[n*12+4] += - s[1];
gout[n*12+5] += + s[0] + s[8];
gout[n*12+6] += - s[7];
gout[n*12+7] += - s[6] + s[2];
gout[n*12+8] += - s[2];
gout[n*12+9] += - s[5];
gout[n*12+10] += + s[4] + s[0];
gout[n*12+11] += + s[3] - s[1];
}}
void int1e_sa01sp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 2, 0, 0, 2, 4, 0, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_sa01sp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 4, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_sa01sp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 1);
} // int1e_sa01sp_cart
int int1e_sa01sp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 4, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_sa01sp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 1);
} // int1e_sa01sp_sph
int int1e_sa01sp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 4, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_sa01sp;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_si_1ei, 1);
} // int1e_sa01sp_spinor
ALL_CINT1E(int1e_sa01sp)
ALL_CINT1E_FORTRAN_(int1e_sa01sp)
/* <G SIGMA DOT P i|OVLP |SIGMA DOT P j> */
static void CINTgout1e_int1e_spgsp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double *g4 = g3  + envs->g_size * 3;
double *g5 = g4  + envs->g_size * 3;
double *g6 = g5  + envs->g_size * 3;
double *g7 = g6  + envs->g_size * 3;
double rirj[3], c[3];
rirj[0] = envs->ri[0] - envs->rj[0];
rirj[1] = envs->ri[1] - envs->rj[1];
rirj[2] = envs->ri[2] - envs->rj[2];
c[0] = 1 * rirj[0];
c[1] = 1 * rirj[1];
c[2] = 1 * rirj[2];
double s[27];
G1E_D_J(g1, g0, envs->i_l+2, envs->j_l+0, 0);
G1E_R0I(g2, g0, envs->i_l+1, envs->j_l, 0);
G1E_R0I(g3, g1, envs->i_l+1, envs->j_l, 0);
G1E_D_I(g4, g0, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g5, g1, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g6, g2, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g7, g3, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g7[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g6[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g6[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g5[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g4[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g4[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g5[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g4[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g4[ix+0]*g0[iy+0]*g3[iz+0];
s[9] = + g3[ix+0]*g4[iy+0]*g0[iz+0];
s[10] = + g2[ix+0]*g5[iy+0]*g0[iz+0];
s[11] = + g2[ix+0]*g4[iy+0]*g1[iz+0];
s[12] = + g1[ix+0]*g6[iy+0]*g0[iz+0];
s[13] = + g0[ix+0]*g7[iy+0]*g0[iz+0];
s[14] = + g0[ix+0]*g6[iy+0]*g1[iz+0];
s[15] = + g1[ix+0]*g4[iy+0]*g2[iz+0];
s[16] = + g0[ix+0]*g5[iy+0]*g2[iz+0];
s[17] = + g0[ix+0]*g4[iy+0]*g3[iz+0];
s[18] = + g3[ix+0]*g0[iy+0]*g4[iz+0];
s[19] = + g2[ix+0]*g1[iy+0]*g4[iz+0];
s[20] = + g2[ix+0]*g0[iy+0]*g5[iz+0];
s[21] = + g1[ix+0]*g2[iy+0]*g4[iz+0];
s[22] = + g0[ix+0]*g3[iy+0]*g4[iz+0];
s[23] = + g0[ix+0]*g2[iy+0]*g5[iz+0];
s[24] = + g1[ix+0]*g0[iy+0]*g6[iz+0];
s[25] = + g0[ix+0]*g1[iy+0]*g6[iz+0];
s[26] = + g0[ix+0]*g0[iy+0]*g7[iz+0];
gout[n*12+0] += + c[1]*s[17] - c[2]*s[14] - c[1]*s[25] + c[2]*s[22];
gout[n*12+1] += + c[1]*s[24] - c[1]*s[8];
gout[n*12+2] += - c[2]*s[4] + c[2]*s[12];
gout[n*12+3] += + c[1]*s[6] - c[2]*s[3] + c[1]*s[16] - c[2]*s[13] + c[1]*s[26] - c[2]*s[23];
gout[n*12+4] += - c[0]*s[17] + c[0]*s[25];
gout[n*12+5] += + c[2]*s[18] - c[0]*s[24] - c[2]*s[2] + c[0]*s[8];
gout[n*12+6] += + c[2]*s[1] - c[2]*s[9];
gout[n*12+7] += + c[2]*s[0] - c[0]*s[6] + c[2]*s[10] - c[0]*s[16] + c[2]*s[20] - c[0]*s[26];
gout[n*12+8] += + c[0]*s[14] - c[0]*s[22];
gout[n*12+9] += - c[1]*s[18] + c[1]*s[2];
gout[n*12+10] += + c[0]*s[4] - c[1]*s[1] - c[0]*s[12] + c[1]*s[9];
gout[n*12+11] += + c[0]*s[3] - c[1]*s[0] + c[0]*s[13] - c[1]*s[10] + c[0]*s[23] - c[1]*s[20];
}}
void int1e_spgsp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_spgsp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_spgsp;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_spgsp_cart
int int1e_spgsp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_spgsp;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_spgsp_sph
int int1e_spgsp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_spgsp;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_si_1ei, 0);
} // int1e_spgsp_spinor
ALL_CINT1E(int1e_spgsp)
ALL_CINT1E_FORTRAN_(int1e_spgsp)
/* <G SIGMA DOT P i|NUC |SIGMA DOT P j> */
static void CINTgout1e_int1e_spgnucsp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double *g4 = g3  + envs->g_size * 3;
double *g5 = g4  + envs->g_size * 3;
double *g6 = g5  + envs->g_size * 3;
double *g7 = g6  + envs->g_size * 3;
double rirj[3], c[3];
rirj[0] = envs->ri[0] - envs->rj[0];
rirj[1] = envs->ri[1] - envs->rj[1];
rirj[2] = envs->ri[2] - envs->rj[2];
c[0] = 1 * rirj[0];
c[1] = 1 * rirj[1];
c[2] = 1 * rirj[2];
double s[27];
G1E_D_J(g1, g0, envs->i_l+2, envs->j_l+0, 0);
G1E_R0I(g2, g0, envs->i_l+1, envs->j_l, 0);
G1E_R0I(g3, g1, envs->i_l+1, envs->j_l, 0);
G1E_D_I(g4, g0, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g5, g1, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g6, g2, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g7, g3, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g7[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g6[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g6[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g5[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g4[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g4[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g5[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g4[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g4[ix+0]*g0[iy+0]*g3[iz+0];
s[9] = + g3[ix+0]*g4[iy+0]*g0[iz+0];
s[10] = + g2[ix+0]*g5[iy+0]*g0[iz+0];
s[11] = + g2[ix+0]*g4[iy+0]*g1[iz+0];
s[12] = + g1[ix+0]*g6[iy+0]*g0[iz+0];
s[13] = + g0[ix+0]*g7[iy+0]*g0[iz+0];
s[14] = + g0[ix+0]*g6[iy+0]*g1[iz+0];
s[15] = + g1[ix+0]*g4[iy+0]*g2[iz+0];
s[16] = + g0[ix+0]*g5[iy+0]*g2[iz+0];
s[17] = + g0[ix+0]*g4[iy+0]*g3[iz+0];
s[18] = + g3[ix+0]*g0[iy+0]*g4[iz+0];
s[19] = + g2[ix+0]*g1[iy+0]*g4[iz+0];
s[20] = + g2[ix+0]*g0[iy+0]*g5[iz+0];
s[21] = + g1[ix+0]*g2[iy+0]*g4[iz+0];
s[22] = + g0[ix+0]*g3[iy+0]*g4[iz+0];
s[23] = + g0[ix+0]*g2[iy+0]*g5[iz+0];
s[24] = + g1[ix+0]*g0[iy+0]*g6[iz+0];
s[25] = + g0[ix+0]*g1[iy+0]*g6[iz+0];
s[26] = + g0[ix+0]*g0[iy+0]*g7[iz+0];
gout[n*12+0] += + c[1]*s[17] - c[2]*s[14] - c[1]*s[25] + c[2]*s[22];
gout[n*12+1] += + c[1]*s[24] - c[2]*s[21] - c[1]*s[8] + c[2]*s[5];
gout[n*12+2] += + c[1]*s[7] - c[2]*s[4] - c[1]*s[15] + c[2]*s[12];
gout[n*12+3] += + c[1]*s[6] - c[2]*s[3] + c[1]*s[16] - c[2]*s[13] + c[1]*s[26] - c[2]*s[23];
gout[n*12+4] += + c[2]*s[11] - c[0]*s[17] - c[2]*s[19] + c[0]*s[25];
gout[n*12+5] += + c[2]*s[18] - c[0]*s[24] - c[2]*s[2] + c[0]*s[8];
gout[n*12+6] += + c[2]*s[1] - c[0]*s[7] - c[2]*s[9] + c[0]*s[15];
gout[n*12+7] += + c[2]*s[0] - c[0]*s[6] + c[2]*s[10] - c[0]*s[16] + c[2]*s[20] - c[0]*s[26];
gout[n*12+8] += + c[0]*s[14] - c[1]*s[11] - c[0]*s[22] + c[1]*s[19];
gout[n*12+9] += + c[0]*s[21] - c[1]*s[18] - c[0]*s[5] + c[1]*s[2];
gout[n*12+10] += + c[0]*s[4] - c[1]*s[1] - c[0]*s[12] + c[1]*s[9];
gout[n*12+11] += + c[0]*s[3] - c[1]*s[0] + c[0]*s[13] - c[1]*s[10] + c[0]*s[23] - c[1]*s[20];
}}
void int1e_spgnucsp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {2, 1, 0, 0, 3, 4, 0, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_spgnucsp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_spgnucsp;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 2);
} // int1e_spgnucsp_cart
int int1e_spgnucsp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_spgnucsp;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 2);
} // int1e_spgnucsp_sph
int int1e_spgnucsp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_spgnucsp;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_si_1ei, 2);
} // int1e_spgnucsp_spinor
ALL_CINT1E(int1e_spgnucsp)
ALL_CINT1E_FORTRAN_(int1e_spgnucsp)
/* <G SIGMA DOT P i|NABLA-RINV CROSS SIGMA |j> */
static void CINTgout1e_int1e_spgsa01(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double *g4 = g3  + envs->g_size * 3;
double *g5 = g4  + envs->g_size * 3;
double *g6 = g5  + envs->g_size * 3;
double *g7 = g6  + envs->g_size * 3;
double rirj[3], c[3];
rirj[0] = envs->ri[0] - envs->rj[0];
rirj[1] = envs->ri[1] - envs->rj[1];
rirj[2] = envs->ri[2] - envs->rj[2];
c[0] = 1 * rirj[0];
c[1] = 1 * rirj[1];
c[2] = 1 * rirj[2];
double s[27];
G1E_D_J(g1, g0, envs->i_l+2, envs->j_l+0, 0);
G1E_D_I(g2, g0, envs->i_l+2, envs->j_l+0, 0);
for (ix = 0; ix < envs->g_size * 3; ix++) {g1[ix] += g2[ix];}
G1E_R0I(g2, g0, envs->i_l+1, envs->j_l, 0);
G1E_R0I(g3, g1, envs->i_l+1, envs->j_l, 0);
G1E_D_I(g4, g0, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g5, g1, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g6, g2, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g7, g3, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g7[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g6[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g6[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g5[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g4[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g4[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g5[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g4[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g4[ix+0]*g0[iy+0]*g3[iz+0];
s[9] = + g3[ix+0]*g4[iy+0]*g0[iz+0];
s[10] = + g2[ix+0]*g5[iy+0]*g0[iz+0];
s[11] = + g2[ix+0]*g4[iy+0]*g1[iz+0];
s[12] = + g1[ix+0]*g6[iy+0]*g0[iz+0];
s[13] = + g0[ix+0]*g7[iy+0]*g0[iz+0];
s[14] = + g0[ix+0]*g6[iy+0]*g1[iz+0];
s[15] = + g1[ix+0]*g4[iy+0]*g2[iz+0];
s[16] = + g0[ix+0]*g5[iy+0]*g2[iz+0];
s[17] = + g0[ix+0]*g4[iy+0]*g3[iz+0];
s[18] = + g3[ix+0]*g0[iy+0]*g4[iz+0];
s[19] = + g2[ix+0]*g1[iy+0]*g4[iz+0];
s[20] = + g2[ix+0]*g0[iy+0]*g5[iz+0];
s[21] = + g1[ix+0]*g2[iy+0]*g4[iz+0];
s[22] = + g0[ix+0]*g3[iy+0]*g4[iz+0];
s[23] = + g0[ix+0]*g2[iy+0]*g5[iz+0];
s[24] = + g1[ix+0]*g0[iy+0]*g6[iz+0];
s[25] = + g0[ix+0]*g1[iy+0]*g6[iz+0];
s[26] = + g0[ix+0]*g0[iy+0]*g7[iz+0];
gout[n*36+0] += - c[1]*s[16] + c[2]*s[13] - c[1]*s[26] + c[2]*s[23];
gout[n*36+1] += + c[1]*s[7] - c[2]*s[4];
gout[n*36+2] += + c[1]*s[8] - c[2]*s[5];
gout[n*36+3] += + c[1]*s[17] - c[2]*s[14] - c[1]*s[25] + c[2]*s[22];
gout[n*36+4] += + c[1]*s[15] - c[2]*s[12];
gout[n*36+5] += - c[1]*s[26] + c[2]*s[23] - c[1]*s[6] + c[2]*s[3];
gout[n*36+6] += + c[1]*s[17] - c[2]*s[14];
gout[n*36+7] += - c[1]*s[8] + c[2]*s[5] + c[1]*s[24] - c[2]*s[21];
gout[n*36+8] += + c[1]*s[24] - c[2]*s[21];
gout[n*36+9] += + c[1]*s[25] - c[2]*s[22];
gout[n*36+10] += - c[1]*s[6] + c[2]*s[3] - c[1]*s[16] + c[2]*s[13];
gout[n*36+11] += + c[1]*s[7] - c[2]*s[4] - c[1]*s[15] + c[2]*s[12];
gout[n*36+12] += - c[2]*s[10] + c[0]*s[16] - c[2]*s[20] + c[0]*s[26];
gout[n*36+13] += + c[2]*s[1] - c[0]*s[7];
gout[n*36+14] += + c[2]*s[2] - c[0]*s[8];
gout[n*36+15] += + c[2]*s[11] - c[0]*s[17] - c[2]*s[19] + c[0]*s[25];
gout[n*36+16] += + c[2]*s[9] - c[0]*s[15];
gout[n*36+17] += - c[2]*s[20] + c[0]*s[26] - c[2]*s[0] + c[0]*s[6];
gout[n*36+18] += + c[2]*s[11] - c[0]*s[17];
gout[n*36+19] += - c[2]*s[2] + c[0]*s[8] + c[2]*s[18] - c[0]*s[24];
gout[n*36+20] += + c[2]*s[18] - c[0]*s[24];
gout[n*36+21] += + c[2]*s[19] - c[0]*s[25];
gout[n*36+22] += - c[2]*s[0] + c[0]*s[6] - c[2]*s[10] + c[0]*s[16];
gout[n*36+23] += + c[2]*s[1] - c[0]*s[7] - c[2]*s[9] + c[0]*s[15];
gout[n*36+24] += - c[0]*s[13] + c[1]*s[10] - c[0]*s[23] + c[1]*s[20];
gout[n*36+25] += + c[0]*s[4] - c[1]*s[1];
gout[n*36+26] += + c[0]*s[5] - c[1]*s[2];
gout[n*36+27] += + c[0]*s[14] - c[1]*s[11] - c[0]*s[22] + c[1]*s[19];
gout[n*36+28] += + c[0]*s[12] - c[1]*s[9];
gout[n*36+29] += - c[0]*s[23] + c[1]*s[20] - c[0]*s[3] + c[1]*s[0];
gout[n*36+30] += + c[0]*s[14] - c[1]*s[11];
gout[n*36+31] += - c[0]*s[5] + c[1]*s[2] + c[0]*s[21] - c[1]*s[18];
gout[n*36+32] += + c[0]*s[21] - c[1]*s[18];
gout[n*36+33] += + c[0]*s[22] - c[1]*s[19];
gout[n*36+34] += - c[0]*s[3] + c[1]*s[0] - c[0]*s[13] + c[1]*s[10];
gout[n*36+35] += + c[0]*s[4] - c[1]*s[1] - c[0]*s[12] + c[1]*s[9];
}}
void int1e_spgsa01_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {2, 1, 0, 0, 3, 4, 0, 9};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_spgsa01_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 0, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_spgsa01;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 1);
} // int1e_spgsa01_cart
int int1e_spgsa01_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 0, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_spgsa01;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 1);
} // int1e_spgsa01_sph
int int1e_spgsa01_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 0, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_spgsa01;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_si_1e, 1);
} // int1e_spgsa01_spinor
ALL_CINT1E(int1e_spgsa01)
ALL_CINT1E_FORTRAN_(int1e_spgsa01)
