/*
 * Copyright (C) 2013-  Qiming Sun <osirpt.sun@gmail.com>
 * Description: code generated by  gen-code.cl
 */
#include <stdlib.h>
#include "cint_bas.h"
#include "cart2sph.h"
#include "g1e.h"
#include "g2e.h"
#include "optimizer.h"
#include "cint1e.h"
#include "cint2e.h"
#include "misc.h"
#include "c2f.h"
/* <k G i|R12 |j l> : i,j \in electron 1; k,l \in electron 2
 * = (G i j|R12 |k l) */
static void CINTgout2e_int2e_ig1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double rirj[3];
rirj[0] = envs->ri[0] - envs->rj[0];
rirj[1] = envs->ri[1] - envs->rj[1];
rirj[2] = envs->ri[2] - envs->rj[2];
double c[3];
c[0] = 1 * rirj[0];
c[1] = 1 * rirj[1];
c[2] = 1 * rirj[2];
G2E_R0I(g1, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[3];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
switch (nrys_roots) {
case 1:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
break;
case 2:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1];
break;
case 3:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1]+ g1[ix+2]*g0[iy+2]*g0[iz+2];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1]+ g0[ix+2]*g1[iy+2]*g0[iz+2];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1]+ g0[ix+2]*g0[iy+2]*g1[iz+2];
break;
case 4:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1]+ g1[ix+2]*g0[iy+2]*g0[iz+2]+ g1[ix+3]*g0[iy+3]*g0[iz+3];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1]+ g0[ix+2]*g1[iy+2]*g0[iz+2]+ g0[ix+3]*g1[iy+3]*g0[iz+3];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1]+ g0[ix+2]*g0[iy+2]*g1[iz+2]+ g0[ix+3]*g0[iy+3]*g1[iz+3];
break;
default:
for (i = 0; i < 3; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g1[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g0[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g0[ix+i] * g0[iy+i] * g1[iz+i];
} break;}
if (gout_empty) {
gout[n*3+0] = - c[1]*s[2] + c[2]*s[1];
gout[n*3+1] = - c[2]*s[0] + c[0]*s[2];
gout[n*3+2] = - c[0]*s[1] + c[1]*s[0];
} else {
gout[n*3+0] += - c[1]*s[2] + c[2]*s[1];
gout[n*3+1] += - c[2]*s[0] + c[0]*s[2];
gout[n*3+2] += - c[0]*s[1] + c[1]*s[0];
}}}
void int2e_ig1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_ig1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ig1;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = envs.nfk * envs.x_ctr[2];
counts[3] = envs.nfl * envs.x_ctr[3];
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_ig1_cart
int int2e_ig1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ig1;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = (envs.k_l*2+1) * envs.x_ctr[2];
counts[3] = (envs.l_l*2+1) * envs.x_ctr[3];
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_ig1_sph
int int2e_ig1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ig1;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = CINTcgto_spinor(envs.shls[2], envs.bas);
counts[3] = CINTcgto_spinor(envs.shls[3], envs.bas);
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_2e1, &c2s_sf_2e2);
} // int2e_ig1_spinor
ALL_CINT(int2e_ig1)
ALL_CINT_FORTRAN_(int2e_ig1)
/* <G k G i|R12 |j l> : i,j \in electron 1; k,l \in electron 2
 * = (G i j|R12 |G k l) */
static void CINTgout2e_int2e_ig1ig2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double rirj[3];
rirj[0] = envs->ri[0] - envs->rj[0];
rirj[1] = envs->ri[1] - envs->rj[1];
rirj[2] = envs->ri[2] - envs->rj[2];
double rkrl[3];
rkrl[0] = envs->rk[0] - envs->rl[0];
rkrl[1] = envs->rk[1] - envs->rl[1];
rkrl[2] = envs->rk[2] - envs->rl[2];
double c[9];
c[0] = 1 * rirj[0] * rkrl[0];
c[1] = 1 * rirj[0] * rkrl[1];
c[2] = 1 * rirj[0] * rkrl[2];
c[3] = 1 * rirj[1] * rkrl[0];
c[4] = 1 * rirj[1] * rkrl[1];
c[5] = 1 * rirj[1] * rkrl[2];
c[6] = 1 * rirj[2] * rkrl[0];
c[7] = 1 * rirj[2] * rkrl[1];
c[8] = 1 * rirj[2] * rkrl[2];
G2E_R0K(g1, g0, envs->i_l+1, envs->j_l+0, envs->k_l+0, envs->l_l);
G2E_R0I(g2, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R0I(g3, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[9];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 9; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g3[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g2[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g2[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g1[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g0[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g0[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g1[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g0[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g0[ix+i] * g0[iy+i] * g3[iz+i];
}
if (gout_empty) {
gout[n*9+0] = + c[4]*s[8] - c[7]*s[5] - c[5]*s[7] + c[8]*s[4];
gout[n*9+1] = + c[5]*s[6] - c[8]*s[3] - c[3]*s[8] + c[6]*s[5];
gout[n*9+2] = + c[3]*s[7] - c[6]*s[4] - c[4]*s[6] + c[7]*s[3];
gout[n*9+3] = + c[7]*s[2] - c[1]*s[8] - c[8]*s[1] + c[2]*s[7];
gout[n*9+4] = + c[8]*s[0] - c[2]*s[6] - c[6]*s[2] + c[0]*s[8];
gout[n*9+5] = + c[6]*s[1] - c[0]*s[7] - c[7]*s[0] + c[1]*s[6];
gout[n*9+6] = + c[1]*s[5] - c[4]*s[2] - c[2]*s[4] + c[5]*s[1];
gout[n*9+7] = + c[2]*s[3] - c[5]*s[0] - c[0]*s[5] + c[3]*s[2];
gout[n*9+8] = + c[0]*s[4] - c[3]*s[1] - c[1]*s[3] + c[4]*s[0];
} else {
gout[n*9+0] += + c[4]*s[8] - c[7]*s[5] - c[5]*s[7] + c[8]*s[4];
gout[n*9+1] += + c[5]*s[6] - c[8]*s[3] - c[3]*s[8] + c[6]*s[5];
gout[n*9+2] += + c[3]*s[7] - c[6]*s[4] - c[4]*s[6] + c[7]*s[3];
gout[n*9+3] += + c[7]*s[2] - c[1]*s[8] - c[8]*s[1] + c[2]*s[7];
gout[n*9+4] += + c[8]*s[0] - c[2]*s[6] - c[6]*s[2] + c[0]*s[8];
gout[n*9+5] += + c[6]*s[1] - c[0]*s[7] - c[7]*s[0] + c[1]*s[6];
gout[n*9+6] += + c[1]*s[5] - c[4]*s[2] - c[2]*s[4] + c[5]*s[1];
gout[n*9+7] += + c[2]*s[3] - c[5]*s[0] - c[0]*s[5] + c[3]*s[2];
gout[n*9+8] += + c[0]*s[4] - c[3]*s[1] - c[1]*s[3] + c[4]*s[0];
}}}
void int2e_ig1ig2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 0, 1, 0, 2, 1, 1, 9};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_ig1ig2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 1, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ig1ig2;
envs.common_factor *= -0.25;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = envs.nfk * envs.x_ctr[2];
counts[3] = envs.nfl * envs.x_ctr[3];
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
if (out != NULL && envs.shls[2] == envs.shls[3]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = envs.nfk * envs.x_ctr[2];
counts[3] = envs.nfl * envs.x_ctr[3];
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_ig1ig2_cart
int int2e_ig1ig2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 1, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ig1ig2;
envs.common_factor *= -0.25;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = (envs.k_l*2+1) * envs.x_ctr[2];
counts[3] = (envs.l_l*2+1) * envs.x_ctr[3];
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
if (out != NULL && envs.shls[2] == envs.shls[3]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = (envs.k_l*2+1) * envs.x_ctr[2];
counts[3] = (envs.l_l*2+1) * envs.x_ctr[3];
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_ig1ig2_sph
int int2e_ig1ig2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 1, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ig1ig2;
envs.common_factor *= -0.25;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = CINTcgto_spinor(envs.shls[2], envs.bas);
counts[3] = CINTcgto_spinor(envs.shls[3], envs.bas);
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
if (out != NULL && envs.shls[2] == envs.shls[3]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = CINTcgto_spinor(envs.shls[2], envs.bas);
counts[3] = CINTcgto_spinor(envs.shls[3], envs.bas);
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_2e1i, &c2s_sf_2e2i);
} // int2e_ig1ig2_spinor
ALL_CINT(int2e_ig1ig2)
ALL_CINT_FORTRAN_(int2e_ig1ig2)
/* <k i|NABLA-R12 |RC j l> : i,j \in electron 1; k,l \in electron 2
 * = (i RC j|NABLA-R12 |k l) */
static void CINTgout2e_int2e_ip1v_rc1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double drj[3];
drj[0] = envs->rj[0] - envs->env[PTR_COMMON_ORIG+0];
drj[1] = envs->rj[1] - envs->env[PTR_COMMON_ORIG+1];
drj[2] = envs->rj[2] - envs->env[PTR_COMMON_ORIG+2];
G2E_RCJ(g1, g0, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g2, g0, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_I(g3, g0, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g2[ix] += g3[ix];}
G2E_RCJ(g3, g2, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
double s[9];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 9; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g3[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g2[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g2[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g1[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g0[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g0[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g1[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g0[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g0[ix+i] * g0[iy+i] * g3[iz+i];
}
if (gout_empty) {
gout[n*9+0] = + s[0];
gout[n*9+1] = + s[1];
gout[n*9+2] = + s[2];
gout[n*9+3] = + s[3];
gout[n*9+4] = + s[4];
gout[n*9+5] = + s[5];
gout[n*9+6] = + s[6];
gout[n*9+7] = + s[7];
gout[n*9+8] = + s[8];
} else {
gout[n*9+0] += + s[0];
gout[n*9+1] += + s[1];
gout[n*9+2] += + s[2];
gout[n*9+3] += + s[3];
gout[n*9+4] += + s[4];
gout[n*9+5] += + s[5];
gout[n*9+6] += + s[6];
gout[n*9+7] += + s[7];
gout[n*9+8] += + s[8];
}}}
void int2e_ip1v_rc1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 2, 0, 0, 2, 1, 1, 9};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_ip1v_rc1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 2, 0, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ip1v_rc1;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_ip1v_rc1_cart
int int2e_ip1v_rc1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 2, 0, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ip1v_rc1;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_ip1v_rc1_sph
int int2e_ip1v_rc1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 2, 0, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ip1v_rc1;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_2e1, &c2s_sf_2e2);
} // int2e_ip1v_rc1_spinor
ALL_CINT(int2e_ip1v_rc1)
ALL_CINT_FORTRAN_(int2e_ip1v_rc1)
/* <k i|NABLA-R12 |R j l> : i,j \in electron 1; k,l \in electron 2
 * = (i R j|NABLA-R12 |k l) */
static void CINTgout2e_int2e_ip1v_r1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
G2E_R_J(g1, g0, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g2, g0, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_I(g3, g0, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g2[ix] += g3[ix];}
G2E_R_J(g3, g2, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
double s[9];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 9; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g3[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g2[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g2[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g1[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g0[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g0[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g1[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g0[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g0[ix+i] * g0[iy+i] * g3[iz+i];
}
if (gout_empty) {
gout[n*9+0] = + s[0];
gout[n*9+1] = + s[1];
gout[n*9+2] = + s[2];
gout[n*9+3] = + s[3];
gout[n*9+4] = + s[4];
gout[n*9+5] = + s[5];
gout[n*9+6] = + s[6];
gout[n*9+7] = + s[7];
gout[n*9+8] = + s[8];
} else {
gout[n*9+0] += + s[0];
gout[n*9+1] += + s[1];
gout[n*9+2] += + s[2];
gout[n*9+3] += + s[3];
gout[n*9+4] += + s[4];
gout[n*9+5] += + s[5];
gout[n*9+6] += + s[6];
gout[n*9+7] += + s[7];
gout[n*9+8] += + s[8];
}}}
void int2e_ip1v_r1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 2, 0, 0, 2, 1, 1, 9};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_ip1v_r1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 2, 0, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ip1v_r1;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_ip1v_r1_cart
int int2e_ip1v_r1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 2, 0, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ip1v_r1;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_ip1v_r1_sph
int int2e_ip1v_r1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 2, 0, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ip1v_r1;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_2e1, &c2s_sf_2e2);
} // int2e_ip1v_r1_spinor
ALL_CINT(int2e_ip1v_r1)
ALL_CINT_FORTRAN_(int2e_ip1v_r1)
/* <k G i|NABLA-R12 CROSS P |j l> : i,j \in electron 1; k,l \in electron 2
 * = (G i j|NABLA-R12 CROSS P |k l) */
static void CINTgout2e_int2e_ipvg1_xp1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double *g8 = g7 + envs->g_size * 3;
double rirj[3];
rirj[0] = envs->ri[0] - envs->rj[0];
rirj[1] = envs->ri[1] - envs->rj[1];
rirj[2] = envs->ri[2] - envs->rj[2];
double c[3];
c[0] = 1 * rirj[0];
c[1] = 1 * rirj[1];
c[2] = 1 * rirj[2];
G2E_D_J(g1, g0, envs->i_l+2, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g2, g0, envs->i_l+1, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_I(g3, g0, envs->i_l+1, envs->j_l+1, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g2[ix] += g3[ix];}
G2E_D_J(g3, g2, envs->i_l+2, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R0I(g4, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R0I(g5, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R0I(g6, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R0I(g7, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[27];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 27; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g7[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g6[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g6[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g5[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g4[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g4[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g5[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g4[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g4[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g3[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g2[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g2[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g1[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g0[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g0[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g1[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g0[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g0[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g3[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g2[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g2[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g1[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g0[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g0[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g1[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g0[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g0[ix+i] * g0[iy+i] * g7[iz+i];
}
if (gout_empty) {
gout[n*9+0] = + c[1]*s[23] - c[2]*s[14] - c[1]*s[25] + c[2]*s[16];
gout[n*9+1] = + c[1]*s[24] - c[2]*s[15] - c[1]*s[20] + c[2]*s[11];
gout[n*9+2] = + c[1]*s[19] - c[2]*s[10] - c[1]*s[21] + c[2]*s[12];
gout[n*9+3] = + c[2]*s[5] - c[0]*s[23] - c[2]*s[7] + c[0]*s[25];
gout[n*9+4] = + c[2]*s[6] - c[0]*s[24] - c[2]*s[2] + c[0]*s[20];
gout[n*9+5] = + c[2]*s[1] - c[0]*s[19] - c[2]*s[3] + c[0]*s[21];
gout[n*9+6] = + c[0]*s[14] - c[1]*s[5] - c[0]*s[16] + c[1]*s[7];
gout[n*9+7] = + c[0]*s[15] - c[1]*s[6] - c[0]*s[11] + c[1]*s[2];
gout[n*9+8] = + c[0]*s[10] - c[1]*s[1] - c[0]*s[12] + c[1]*s[3];
} else {
gout[n*9+0] += + c[1]*s[23] - c[2]*s[14] - c[1]*s[25] + c[2]*s[16];
gout[n*9+1] += + c[1]*s[24] - c[2]*s[15] - c[1]*s[20] + c[2]*s[11];
gout[n*9+2] += + c[1]*s[19] - c[2]*s[10] - c[1]*s[21] + c[2]*s[12];
gout[n*9+3] += + c[2]*s[5] - c[0]*s[23] - c[2]*s[7] + c[0]*s[25];
gout[n*9+4] += + c[2]*s[6] - c[0]*s[24] - c[2]*s[2] + c[0]*s[20];
gout[n*9+5] += + c[2]*s[1] - c[0]*s[19] - c[2]*s[3] + c[0]*s[21];
gout[n*9+6] += + c[0]*s[14] - c[1]*s[5] - c[0]*s[16] + c[1]*s[7];
gout[n*9+7] += + c[0]*s[15] - c[1]*s[6] - c[0]*s[11] + c[1]*s[2];
gout[n*9+8] += + c[0]*s[10] - c[1]*s[1] - c[0]*s[12] + c[1]*s[3];
}}}
void int2e_ipvg1_xp1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {2, 1, 0, 0, 3, 1, 1, 9};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_ipvg1_xp1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ipvg1_xp1;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = envs.nfk * envs.x_ctr[2];
counts[3] = envs.nfl * envs.x_ctr[3];
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_ipvg1_xp1_cart
int int2e_ipvg1_xp1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ipvg1_xp1;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = (envs.k_l*2+1) * envs.x_ctr[2];
counts[3] = (envs.l_l*2+1) * envs.x_ctr[3];
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_ipvg1_xp1_sph
int int2e_ipvg1_xp1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ipvg1_xp1;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = CINTcgto_spinor(envs.shls[2], envs.bas);
counts[3] = CINTcgto_spinor(envs.shls[3], envs.bas);
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_2e1, &c2s_sf_2e2);
} // int2e_ipvg1_xp1_spinor
ALL_CINT(int2e_ipvg1_xp1)
ALL_CINT_FORTRAN_(int2e_ipvg1_xp1)
/* <G k i|NABLA-R12 CROSS P |j l> : i,j \in electron 1; k,l \in electron 2
 * = (i j|NABLA-R12 CROSS P |G k l) */
static void CINTgout2e_int2e_ipvg2_xp1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double *g8 = g7 + envs->g_size * 3;
double rkrl[3];
rkrl[0] = envs->rk[0] - envs->rl[0];
rkrl[1] = envs->rk[1] - envs->rl[1];
rkrl[2] = envs->rk[2] - envs->rl[2];
double c[3];
c[0] = 1 * rkrl[0];
c[1] = 1 * rkrl[1];
c[2] = 1 * rkrl[2];
G2E_R0K(g1, g0, envs->i_l+1, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_D_J(g2, g0, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g3, g1, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g4, g0, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_I(g5, g0, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g4[ix] += g5[ix];}
G2E_D_J(g5, g1, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_I(g6, g1, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g5[ix] += g6[ix];}
G2E_D_J(g6, g4, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g7, g5, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
double s[27];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 27; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g7[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g6[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g6[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g5[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g4[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g4[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g5[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g4[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g4[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g3[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g2[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g2[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g1[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g0[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g0[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g1[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g0[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g0[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g3[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g2[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g2[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g1[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g0[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g0[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g1[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g0[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g0[ix+i] * g0[iy+i] * g7[iz+i];
}
if (gout_empty) {
gout[n*9+0] = - c[1]*s[17] + c[1]*s[23] + c[2]*s[16] - c[2]*s[22];
gout[n*9+1] = - c[2]*s[15] + c[2]*s[21] + c[0]*s[17] - c[0]*s[23];
gout[n*9+2] = - c[0]*s[16] + c[0]*s[22] + c[1]*s[15] - c[1]*s[21];
gout[n*9+3] = - c[1]*s[20] + c[1]*s[8] + c[2]*s[19] - c[2]*s[7];
gout[n*9+4] = - c[2]*s[18] + c[2]*s[6] + c[0]*s[20] - c[0]*s[8];
gout[n*9+5] = - c[0]*s[19] + c[0]*s[7] + c[1]*s[18] - c[1]*s[6];
gout[n*9+6] = - c[1]*s[5] + c[1]*s[11] + c[2]*s[4] - c[2]*s[10];
gout[n*9+7] = - c[2]*s[3] + c[2]*s[9] + c[0]*s[5] - c[0]*s[11];
gout[n*9+8] = - c[0]*s[4] + c[0]*s[10] + c[1]*s[3] - c[1]*s[9];
} else {
gout[n*9+0] += - c[1]*s[17] + c[1]*s[23] + c[2]*s[16] - c[2]*s[22];
gout[n*9+1] += - c[2]*s[15] + c[2]*s[21] + c[0]*s[17] - c[0]*s[23];
gout[n*9+2] += - c[0]*s[16] + c[0]*s[22] + c[1]*s[15] - c[1]*s[21];
gout[n*9+3] += - c[1]*s[20] + c[1]*s[8] + c[2]*s[19] - c[2]*s[7];
gout[n*9+4] += - c[2]*s[18] + c[2]*s[6] + c[0]*s[20] - c[0]*s[8];
gout[n*9+5] += - c[0]*s[19] + c[0]*s[7] + c[1]*s[18] - c[1]*s[6];
gout[n*9+6] += - c[1]*s[5] + c[1]*s[11] + c[2]*s[4] - c[2]*s[10];
gout[n*9+7] += - c[2]*s[3] + c[2]*s[9] + c[0]*s[5] - c[0]*s[11];
gout[n*9+8] += - c[0]*s[4] + c[0]*s[10] + c[1]*s[3] - c[1]*s[9];
}}}
void int2e_ipvg2_xp1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 1, 0, 3, 1, 1, 9};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_ipvg2_xp1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 0, 3, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ipvg2_xp1;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[2] == envs.shls[3]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = envs.nfk * envs.x_ctr[2];
counts[3] = envs.nfl * envs.x_ctr[3];
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_ipvg2_xp1_cart
int int2e_ipvg2_xp1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 0, 3, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ipvg2_xp1;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[2] == envs.shls[3]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = (envs.k_l*2+1) * envs.x_ctr[2];
counts[3] = (envs.l_l*2+1) * envs.x_ctr[3];
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_ipvg2_xp1_sph
int int2e_ipvg2_xp1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 0, 3, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ipvg2_xp1;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[2] == envs.shls[3]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = CINTcgto_spinor(envs.shls[2], envs.bas);
counts[3] = CINTcgto_spinor(envs.shls[3], envs.bas);
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_2e1i, &c2s_sf_2e2i);
} // int2e_ipvg2_xp1_spinor
ALL_CINT(int2e_ipvg2_xp1)
ALL_CINT_FORTRAN_(int2e_ipvg2_xp1)
/* <i|NUC |RC CROSS P j> */
static void CINTgout1e_int1e_inuc_rcxp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double drj[3];
drj[0] = envs->rj[0] - envs->env[PTR_COMMON_ORIG+0];
drj[1] = envs->rj[1] - envs->env[PTR_COMMON_ORIG+1];
drj[2] = envs->rj[2] - envs->env[PTR_COMMON_ORIG+2];
double s[9];
G1E_D_J(g1, g0, envs->i_l+0, envs->j_l+0, 0);
G1E_RCJ(g2, g0, envs->i_l+0, envs->j_l+1, 0);
G1E_D_J(g3, g2, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*3+0] += + s[5] - s[7];
gout[n*3+1] += + s[6] - s[2];
gout[n*3+2] += + s[1] - s[3];
}}
void int1e_inuc_rcxp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_inuc_rcxp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_inuc_rcxp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 2);
} // int1e_inuc_rcxp_cart
int int1e_inuc_rcxp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_inuc_rcxp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 2);
} // int1e_inuc_rcxp_sph
int int1e_inuc_rcxp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_inuc_rcxp;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 2);
} // int1e_inuc_rcxp_spinor
ALL_CINT1E(int1e_inuc_rcxp)
ALL_CINT1E_FORTRAN_(int1e_inuc_rcxp)
/* <i|NUC |R CROSS P j> */
static void CINTgout1e_int1e_inuc_rxp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_D_J(g1, g0, envs->i_l+0, envs->j_l+0, 0);
G1E_R_J(g2, g0, envs->i_l+0, envs->j_l+1, 0);
G1E_D_J(g3, g2, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*3+0] += + s[5] - s[7];
gout[n*3+1] += + s[6] - s[2];
gout[n*3+2] += + s[1] - s[3];
}}
void int1e_inuc_rxp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_inuc_rxp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_inuc_rxp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 2);
} // int1e_inuc_rxp_cart
int int1e_inuc_rxp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_inuc_rxp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 2);
} // int1e_inuc_rxp_sph
int int1e_inuc_rxp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_inuc_rxp;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 2);
} // int1e_inuc_rxp_spinor
ALL_CINT1E(int1e_inuc_rxp)
ALL_CINT1E_FORTRAN_(int1e_inuc_rxp)
