/*
 * Copyright (C) 2013-  Qiming Sun <osirpt.sun@gmail.com>
 * Description: code generated by  gen-code.cl
 */
#include <stdlib.h>
#include "cint_bas.h"
#include "cart2sph.h"
#include "g1e.h"
#include "g2e.h"
#include "optimizer.h"
#include "cint1e.h"
#include "cint2e.h"
#include "misc.h"
#include "c2f.h"
/* <i|OVLP |j> */
static void CINTgout1e_int1e_ovlp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double s[1];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g0[ix+0]*g0[iy+0]*g0[iz+0];
gout[n*1+0] += + s[0];
}}
void int1e_ovlp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 0, 0, 0, 0, 1, 1, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_ovlp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 0, 0, 0, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_ovlp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_ovlp_cart
int int1e_ovlp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 0, 0, 0, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_ovlp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_ovlp_sph
int int1e_ovlp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 0, 0, 0, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_ovlp;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_ovlp_spinor
ALL_CINT1E(int1e_ovlp)
ALL_CINT1E_FORTRAN_(int1e_ovlp)
/* <i|NUC |j> */
static void CINTgout1e_int1e_nuc(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double s[1];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g0[ix+0]*g0[iy+0]*g0[iz+0];
gout[n*1+0] += + s[0];
}}
void int1e_nuc_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 0, 0, 0, 0, 1, 0, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_nuc_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 0, 0, 0, 1, 0, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_nuc;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 2);
} // int1e_nuc_cart
int int1e_nuc_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 0, 0, 0, 1, 0, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_nuc;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 2);
} // int1e_nuc_sph
int int1e_nuc_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 0, 0, 0, 1, 0, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_nuc;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 2);
} // int1e_nuc_spinor
ALL_CINT1E(int1e_nuc)
ALL_CINT1E_FORTRAN_(int1e_nuc)
/* <i|OVLP |P DOT P j> */
static void CINTgout1e_int1e_kin(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_D_J(g1, g0, envs->i_l+0, envs->j_l+0, 0);
G1E_D_J(g2, g0, envs->i_l+0, envs->j_l+1, 0);
G1E_D_J(g3, g2, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*1+0] += - s[0] - s[4] - s[8];
}}
void int1e_kin_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_kin_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_kin;
envs.common_factor *= 0.5;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_kin_cart
int int1e_kin_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_kin;
envs.common_factor *= 0.5;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_kin_sph
int int1e_kin_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_kin;
envs.common_factor *= 0.5;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_kin_spinor
ALL_CINT1E(int1e_kin)
ALL_CINT1E_FORTRAN_(int1e_kin)
/* <i|NABLA-RINV |CROSS P j> */
static void CINTgout1e_int1e_ia01p(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_D_J(g1, g0, envs->i_l+0, envs->j_l+0, 0);
G1E_D_J(g2, g0, envs->i_l+0, envs->j_l+1, 0);
G1E_D_I(g3, g0, envs->i_l+0, envs->j_l+1, 0);
for (ix = 0; ix < envs->g_size * 3; ix++) {g2[ix] += g3[ix];}
G1E_D_J(g3, g2, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*3+0] += + s[5] - s[7];
gout[n*3+1] += + s[6] - s[2];
gout[n*3+2] += + s[1] - s[3];
}}
void int1e_ia01p_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_ia01p_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_ia01p;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 1);
} // int1e_ia01p_cart
int int1e_ia01p_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_ia01p;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 1);
} // int1e_ia01p_sph
int int1e_ia01p_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_ia01p;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 1);
} // int1e_ia01p_spinor
ALL_CINT1E(int1e_ia01p)
ALL_CINT1E_FORTRAN_(int1e_ia01p)
/* <i|OVLP |R CROSS P j> */
static void CINTgout1e_int1e_giao_irjxp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_D_J(g1, g0, envs->i_l+0, envs->j_l+0, 0);
G1E_R_J(g2, g0, envs->i_l+0, envs->j_l+1, 0);
G1E_D_J(g3, g2, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*3+0] += + s[5] - s[7];
gout[n*3+1] += + s[6] - s[2];
gout[n*3+2] += + s[1] - s[3];
}}
void int1e_giao_irjxp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_giao_irjxp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_giao_irjxp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_giao_irjxp_cart
int int1e_giao_irjxp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_giao_irjxp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_giao_irjxp_sph
int int1e_giao_irjxp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_giao_irjxp;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_giao_irjxp_spinor
ALL_CINT1E(int1e_giao_irjxp)
ALL_CINT1E_FORTRAN_(int1e_giao_irjxp)
/* <i|OVLP |RC CROSS P j> */
static void CINTgout1e_int1e_cg_irxp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double drj[3];
drj[0] = envs->rj[0] - envs->env[PTR_COMMON_ORIG+0];
drj[1] = envs->rj[1] - envs->env[PTR_COMMON_ORIG+1];
drj[2] = envs->rj[2] - envs->env[PTR_COMMON_ORIG+2];
double s[9];
G1E_D_J(g1, g0, envs->i_l+0, envs->j_l+0, 0);
G1E_RCJ(g2, g0, envs->i_l+0, envs->j_l+1, 0);
G1E_D_J(g3, g2, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*3+0] += + s[5] - s[7];
gout[n*3+1] += + s[6] - s[2];
gout[n*3+2] += + s[1] - s[3];
}}
void int1e_cg_irxp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_cg_irxp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_cg_irxp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_cg_irxp_cart
int int1e_cg_irxp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_cg_irxp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_cg_irxp_sph
int int1e_cg_irxp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_cg_irxp;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_cg_irxp_spinor
ALL_CINT1E(int1e_cg_irxp)
ALL_CINT1E_FORTRAN_(int1e_cg_irxp)
/* <i|NABLA-RINV |R j> */
static void CINTgout1e_int1e_giao_a11part(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_R_J(g1, g0, envs->i_l+0, envs->j_l+0, 0);
G1E_D_J(g2, g0, envs->i_l+0, envs->j_l+1, 0);
G1E_D_I(g3, g0, envs->i_l+0, envs->j_l+1, 0);
for (ix = 0; ix < envs->g_size * 3; ix++) {g2[ix] += g3[ix];}
G1E_R_J(g3, g2, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*9+0] += + s[0];
gout[n*9+1] += + s[1];
gout[n*9+2] += + s[2];
gout[n*9+3] += + s[3];
gout[n*9+4] += + s[4];
gout[n*9+5] += + s[5];
gout[n*9+6] += + s[6];
gout[n*9+7] += + s[7];
gout[n*9+8] += + s[8];
}}
void int1e_giao_a11part_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 9};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_giao_a11part_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_giao_a11part;
envs.common_factor *= -0.5;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 1);
} // int1e_giao_a11part_cart
int int1e_giao_a11part_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_giao_a11part;
envs.common_factor *= -0.5;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 1);
} // int1e_giao_a11part_sph
int int1e_giao_a11part_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_giao_a11part;
envs.common_factor *= -0.5;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 1);
} // int1e_giao_a11part_spinor
ALL_CINT1E(int1e_giao_a11part)
ALL_CINT1E_FORTRAN_(int1e_giao_a11part)
/* <i|NABLA-RINV |RC j> */
static void CINTgout1e_int1e_cg_a11part(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double drj[3];
drj[0] = envs->rj[0] - envs->env[PTR_COMMON_ORIG+0];
drj[1] = envs->rj[1] - envs->env[PTR_COMMON_ORIG+1];
drj[2] = envs->rj[2] - envs->env[PTR_COMMON_ORIG+2];
double s[9];
G1E_RCJ(g1, g0, envs->i_l+0, envs->j_l+0, 0);
G1E_D_J(g2, g0, envs->i_l+0, envs->j_l+1, 0);
G1E_D_I(g3, g0, envs->i_l+0, envs->j_l+1, 0);
for (ix = 0; ix < envs->g_size * 3; ix++) {g2[ix] += g3[ix];}
G1E_RCJ(g3, g2, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*9+0] += + s[0];
gout[n*9+1] += + s[1];
gout[n*9+2] += + s[2];
gout[n*9+3] += + s[3];
gout[n*9+4] += + s[4];
gout[n*9+5] += + s[5];
gout[n*9+6] += + s[6];
gout[n*9+7] += + s[7];
gout[n*9+8] += + s[8];
}}
void int1e_cg_a11part_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 9};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_cg_a11part_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_cg_a11part;
envs.common_factor *= -0.5;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 1);
} // int1e_cg_a11part_cart
int int1e_cg_a11part_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_cg_a11part;
envs.common_factor *= -0.5;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 1);
} // int1e_cg_a11part_sph
int int1e_cg_a11part_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 0, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_cg_a11part;
envs.common_factor *= -0.5;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 1);
} // int1e_cg_a11part_spinor
ALL_CINT1E(int1e_cg_a11part)
ALL_CINT1E_FORTRAN_(int1e_cg_a11part)
/* <G i|NABLA-RINV CROSS P |j> */
static void CINTgout1e_int1e_a01gp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double *g4 = g3  + envs->g_size * 3;
double *g5 = g4  + envs->g_size * 3;
double *g6 = g5  + envs->g_size * 3;
double *g7 = g6  + envs->g_size * 3;
double rirj[3], c[3];
rirj[0] = envs->ri[0] - envs->rj[0];
rirj[1] = envs->ri[1] - envs->rj[1];
rirj[2] = envs->ri[2] - envs->rj[2];
c[0] = 1 * rirj[0];
c[1] = 1 * rirj[1];
c[2] = 1 * rirj[2];
double s[27];
G1E_D_J(g1, g0, envs->i_l+2, envs->j_l+0, 0);
G1E_D_J(g2, g0, envs->i_l+1, envs->j_l+1, 0);
G1E_D_I(g3, g0, envs->i_l+1, envs->j_l+1, 0);
for (ix = 0; ix < envs->g_size * 3; ix++) {g2[ix] += g3[ix];}
G1E_D_J(g3, g2, envs->i_l+2, envs->j_l+0, 0);
G1E_R0I(g4, g0, envs->i_l+0, envs->j_l, 0);
G1E_R0I(g5, g1, envs->i_l+0, envs->j_l, 0);
G1E_R0I(g6, g2, envs->i_l+0, envs->j_l, 0);
G1E_R0I(g7, g3, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g7[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g6[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g6[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g5[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g4[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g4[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g5[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g4[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g4[ix+0]*g0[iy+0]*g3[iz+0];
s[9] = + g3[ix+0]*g4[iy+0]*g0[iz+0];
s[10] = + g2[ix+0]*g5[iy+0]*g0[iz+0];
s[11] = + g2[ix+0]*g4[iy+0]*g1[iz+0];
s[12] = + g1[ix+0]*g6[iy+0]*g0[iz+0];
s[13] = + g0[ix+0]*g7[iy+0]*g0[iz+0];
s[14] = + g0[ix+0]*g6[iy+0]*g1[iz+0];
s[15] = + g1[ix+0]*g4[iy+0]*g2[iz+0];
s[16] = + g0[ix+0]*g5[iy+0]*g2[iz+0];
s[17] = + g0[ix+0]*g4[iy+0]*g3[iz+0];
s[18] = + g3[ix+0]*g0[iy+0]*g4[iz+0];
s[19] = + g2[ix+0]*g1[iy+0]*g4[iz+0];
s[20] = + g2[ix+0]*g0[iy+0]*g5[iz+0];
s[21] = + g1[ix+0]*g2[iy+0]*g4[iz+0];
s[22] = + g0[ix+0]*g3[iy+0]*g4[iz+0];
s[23] = + g0[ix+0]*g2[iy+0]*g5[iz+0];
s[24] = + g1[ix+0]*g0[iy+0]*g6[iz+0];
s[25] = + g0[ix+0]*g1[iy+0]*g6[iz+0];
s[26] = + g0[ix+0]*g0[iy+0]*g7[iz+0];
gout[n*9+0] += + c[1]*s[23] - c[2]*s[14] - c[1]*s[25] + c[2]*s[16];
gout[n*9+1] += + c[1]*s[24] - c[2]*s[15] - c[1]*s[20] + c[2]*s[11];
gout[n*9+2] += + c[1]*s[19] - c[2]*s[10] - c[1]*s[21] + c[2]*s[12];
gout[n*9+3] += + c[2]*s[5] - c[0]*s[23] - c[2]*s[7] + c[0]*s[25];
gout[n*9+4] += + c[2]*s[6] - c[0]*s[24] - c[2]*s[2] + c[0]*s[20];
gout[n*9+5] += + c[2]*s[1] - c[0]*s[19] - c[2]*s[3] + c[0]*s[21];
gout[n*9+6] += + c[0]*s[14] - c[1]*s[5] - c[0]*s[16] + c[1]*s[7];
gout[n*9+7] += + c[0]*s[15] - c[1]*s[6] - c[0]*s[11] + c[1]*s[2];
gout[n*9+8] += + c[0]*s[10] - c[1]*s[1] - c[0]*s[12] + c[1]*s[3];
}}
void int1e_a01gp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 2, 0, 0, 3, 1, 0, 9};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_a01gp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 2, 0, 0, 3, 1, 0, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_a01gp;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 1);
} // int1e_a01gp_cart
int int1e_a01gp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 2, 0, 0, 3, 1, 0, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_a01gp;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 1);
} // int1e_a01gp_sph
int int1e_a01gp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 2, 0, 0, 3, 1, 0, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_a01gp;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 1);
} // int1e_a01gp_spinor
ALL_CINT1E(int1e_a01gp)
ALL_CINT1E_FORTRAN_(int1e_a01gp)
/* <G i|OVLP |P DOT P j> */
static void CINTgout1e_int1e_igkin(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double *g4 = g3  + envs->g_size * 3;
double *g5 = g4  + envs->g_size * 3;
double *g6 = g5  + envs->g_size * 3;
double *g7 = g6  + envs->g_size * 3;
double rirj[3], c[3];
rirj[0] = envs->ri[0] - envs->rj[0];
rirj[1] = envs->ri[1] - envs->rj[1];
rirj[2] = envs->ri[2] - envs->rj[2];
c[0] = 1 * rirj[0];
c[1] = 1 * rirj[1];
c[2] = 1 * rirj[2];
double s[27];
G1E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, 0);
G1E_D_J(g2, g0, envs->i_l+1, envs->j_l+1, 0);
G1E_D_J(g3, g2, envs->i_l+1, envs->j_l+0, 0);
G1E_R0I(g4, g0, envs->i_l+0, envs->j_l, 0);
G1E_R0I(g5, g1, envs->i_l+0, envs->j_l, 0);
G1E_R0I(g6, g2, envs->i_l+0, envs->j_l, 0);
G1E_R0I(g7, g3, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g7[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g6[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g6[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g5[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g4[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g4[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g5[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g4[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g4[ix+0]*g0[iy+0]*g3[iz+0];
s[9] = + g3[ix+0]*g4[iy+0]*g0[iz+0];
s[10] = + g2[ix+0]*g5[iy+0]*g0[iz+0];
s[11] = + g2[ix+0]*g4[iy+0]*g1[iz+0];
s[12] = + g1[ix+0]*g6[iy+0]*g0[iz+0];
s[13] = + g0[ix+0]*g7[iy+0]*g0[iz+0];
s[14] = + g0[ix+0]*g6[iy+0]*g1[iz+0];
s[15] = + g1[ix+0]*g4[iy+0]*g2[iz+0];
s[16] = + g0[ix+0]*g5[iy+0]*g2[iz+0];
s[17] = + g0[ix+0]*g4[iy+0]*g3[iz+0];
s[18] = + g3[ix+0]*g0[iy+0]*g4[iz+0];
s[19] = + g2[ix+0]*g1[iy+0]*g4[iz+0];
s[20] = + g2[ix+0]*g0[iy+0]*g5[iz+0];
s[21] = + g1[ix+0]*g2[iy+0]*g4[iz+0];
s[22] = + g0[ix+0]*g3[iy+0]*g4[iz+0];
s[23] = + g0[ix+0]*g2[iy+0]*g5[iz+0];
s[24] = + g1[ix+0]*g0[iy+0]*g6[iz+0];
s[25] = + g0[ix+0]*g1[iy+0]*g6[iz+0];
s[26] = + g0[ix+0]*g0[iy+0]*g7[iz+0];
gout[n*3+0] += + c[1]*s[18] - c[2]*s[9] + c[1]*s[22] - c[2]*s[13] + c[1]*s[26] - c[2]*s[17];
gout[n*3+1] += + c[2]*s[0] - c[0]*s[18] + c[2]*s[4] - c[0]*s[22] + c[2]*s[8] - c[0]*s[26];
gout[n*3+2] += + c[0]*s[9] - c[1]*s[0] + c[0]*s[13] - c[1]*s[4] + c[0]*s[17] - c[1]*s[8];
}}
void int1e_igkin_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 2, 0, 0, 3, 1, 1, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_igkin_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 2, 0, 0, 3, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_igkin;
envs.common_factor *= 0.25;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_igkin_cart
int int1e_igkin_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 2, 0, 0, 3, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_igkin;
envs.common_factor *= 0.25;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_igkin_sph
int int1e_igkin_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 2, 0, 0, 3, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_igkin;
envs.common_factor *= 0.25;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_igkin_spinor
ALL_CINT1E(int1e_igkin)
ALL_CINT1E_FORTRAN_(int1e_igkin)
/* <G i|OVLP |j> */
static void CINTgout1e_int1e_igovlp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double rirj[3], c[3];
rirj[0] = envs->ri[0] - envs->rj[0];
rirj[1] = envs->ri[1] - envs->rj[1];
rirj[2] = envs->ri[2] - envs->rj[2];
c[0] = 1 * rirj[0];
c[1] = 1 * rirj[1];
c[2] = 1 * rirj[2];
double s[3];
G1E_R0I(g1, g0, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
gout[n*3+0] += - c[1]*s[2] + c[2]*s[1];
gout[n*3+1] += - c[2]*s[0] + c[0]*s[2];
gout[n*3+2] += - c[0]*s[1] + c[1]*s[0];
}}
void int1e_igovlp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_igovlp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_igovlp;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_igovlp_cart
int int1e_igovlp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_igovlp;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_igovlp_sph
int int1e_igovlp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_igovlp;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_igovlp_spinor
ALL_CINT1E(int1e_igovlp)
ALL_CINT1E_FORTRAN_(int1e_igovlp)
/* <G i|NUC |j> */
static void CINTgout1e_int1e_ignuc(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double rirj[3], c[3];
rirj[0] = envs->ri[0] - envs->rj[0];
rirj[1] = envs->ri[1] - envs->rj[1];
rirj[2] = envs->ri[2] - envs->rj[2];
c[0] = 1 * rirj[0];
c[1] = 1 * rirj[1];
c[2] = 1 * rirj[2];
double s[3];
G1E_R0I(g1, g0, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
gout[n*3+0] += - c[1]*s[2] + c[2]*s[1];
gout[n*3+1] += - c[2]*s[0] + c[0]*s[2];
gout[n*3+2] += - c[0]*s[1] + c[1]*s[0];
}}
void int1e_ignuc_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 0, 0, 0, 1, 1, 0, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_ignuc_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_ignuc;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 2);
} // int1e_ignuc_cart
int int1e_ignuc_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_ignuc;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 2);
} // int1e_ignuc_sph
int int1e_ignuc_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_ignuc;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = 1;
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 2);
} // int1e_ignuc_spinor
ALL_CINT1E(int1e_ignuc)
ALL_CINT1E_FORTRAN_(int1e_ignuc)
/* <P* i|NUC DOT P |j> */
static void CINTgout1e_int1e_pnucp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, 0);
G1E_D_I(g2, g0, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g3, g1, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*1+0] += + s[0] + s[4] + s[8];
}}
void int1e_pnucp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 1, 0, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_pnucp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 0, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_pnucp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 2);
} // int1e_pnucp_cart
int int1e_pnucp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 0, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_pnucp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 2);
} // int1e_pnucp_sph
int int1e_pnucp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 0, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_pnucp;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 2);
} // int1e_pnucp_spinor
ALL_CINT1E(int1e_pnucp)
ALL_CINT1E_FORTRAN_(int1e_pnucp)
/* <i|ZC |j> */
static void CINTgout1e_int1e_z(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double drj[3];
drj[0] = envs->rj[0] - envs->env[PTR_COMMON_ORIG+0];
drj[1] = envs->rj[1] - envs->env[PTR_COMMON_ORIG+1];
drj[2] = envs->rj[2] - envs->env[PTR_COMMON_ORIG+2];
double s[3];
G1E_RCJ(g1, g0, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
gout[n*1+0] += + s[2];
}}
void int1e_z_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 1, 0, 0, 1, 1, 1, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_z_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 1, 0, 0, 1, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_z;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_z_cart
int int1e_z_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 1, 0, 0, 1, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_z;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_z_sph
int int1e_z_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 1, 0, 0, 1, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_z;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_z_spinor
ALL_CINT1E(int1e_z)
ALL_CINT1E_FORTRAN_(int1e_z)
/* <i|ZC ZC |j> */
static void CINTgout1e_int1e_zz(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double drj[3];
drj[0] = envs->rj[0] - envs->env[PTR_COMMON_ORIG+0];
drj[1] = envs->rj[1] - envs->env[PTR_COMMON_ORIG+1];
drj[2] = envs->rj[2] - envs->env[PTR_COMMON_ORIG+2];
double s[9];
G1E_RCJ(g1, g0, envs->i_l+0, envs->j_l+0, 0);
G1E_RCJ(g2, g0, envs->i_l+0, envs->j_l+1, 0);
G1E_RCJ(g3, g2, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*1+0] += + s[8];
}}
void int1e_zz_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_zz_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_zz;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_zz_cart
int int1e_zz_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_zz;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_zz_sph
int int1e_zz_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_zz;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_zz_spinor
ALL_CINT1E(int1e_zz)
ALL_CINT1E_FORTRAN_(int1e_zz)
/* <i|RC |j> */
static void CINTgout1e_int1e_r(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double drj[3];
drj[0] = envs->rj[0] - envs->env[PTR_COMMON_ORIG+0];
drj[1] = envs->rj[1] - envs->env[PTR_COMMON_ORIG+1];
drj[2] = envs->rj[2] - envs->env[PTR_COMMON_ORIG+2];
double s[3];
G1E_RCJ(g1, g0, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
gout[n*3+0] += + s[0];
gout[n*3+1] += + s[1];
gout[n*3+2] += + s[2];
}}
void int1e_r_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 1, 0, 0, 1, 1, 1, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_r_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 1, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_r;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_r_cart
int int1e_r_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 1, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_r;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_r_sph
int int1e_r_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 1, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_r;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_r_spinor
ALL_CINT1E(int1e_r)
ALL_CINT1E_FORTRAN_(int1e_r)
/* <i|RC DOT RC |j> */
static void CINTgout1e_int1e_r2(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double drj[3];
drj[0] = envs->rj[0] - envs->env[PTR_COMMON_ORIG+0];
drj[1] = envs->rj[1] - envs->env[PTR_COMMON_ORIG+1];
drj[2] = envs->rj[2] - envs->env[PTR_COMMON_ORIG+2];
double s[9];
G1E_RCJ(g1, g0, envs->i_l+0, envs->j_l+0, 0);
G1E_RCJ(g2, g0, envs->i_l+0, envs->j_l+1, 0);
G1E_RCJ(g3, g2, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*1+0] += + s[0] + s[4] + s[8];
}}
void int1e_r2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_r2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_r2;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_r2_cart
int int1e_r2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_r2;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_r2_sph
int int1e_r2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_r2;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_r2_spinor
ALL_CINT1E(int1e_r2)
ALL_CINT1E_FORTRAN_(int1e_r2)
/* <i|RC RC |j> */
static void CINTgout1e_int1e_rr(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double drj[3];
drj[0] = envs->rj[0] - envs->env[PTR_COMMON_ORIG+0];
drj[1] = envs->rj[1] - envs->env[PTR_COMMON_ORIG+1];
drj[2] = envs->rj[2] - envs->env[PTR_COMMON_ORIG+2];
double s[9];
G1E_RCJ(g1, g0, envs->i_l+0, envs->j_l+0, 0);
G1E_RCJ(g2, g0, envs->i_l+0, envs->j_l+1, 0);
G1E_RCJ(g3, g2, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*9+0] += + s[0];
gout[n*9+1] += + s[1];
gout[n*9+2] += + s[2];
gout[n*9+3] += + s[3];
gout[n*9+4] += + s[4];
gout[n*9+5] += + s[5];
gout[n*9+6] += + s[6];
gout[n*9+7] += + s[7];
gout[n*9+8] += + s[8];
}}
void int1e_rr_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 9};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_rr_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_rr;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_rr_cart
int int1e_rr_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_rr;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_rr_sph
int int1e_rr_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_rr;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_rr_spinor
ALL_CINT1E(int1e_rr)
ALL_CINT1E_FORTRAN_(int1e_rr)
/* <i|Z |j> */
static void CINTgout1e_int1e_z_origj(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double s[3];
G1E_R_J(g1, g0, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
gout[n*1+0] += + s[2];
}}
void int1e_z_origj_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 1, 0, 0, 1, 1, 1, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_z_origj_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 1, 0, 0, 1, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_z_origj;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_z_origj_cart
int int1e_z_origj_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 1, 0, 0, 1, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_z_origj;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_z_origj_sph
int int1e_z_origj_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 1, 0, 0, 1, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_z_origj;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_z_origj_spinor
ALL_CINT1E(int1e_z_origj)
ALL_CINT1E_FORTRAN_(int1e_z_origj)
/* <i|Z Z |j> */
static void CINTgout1e_int1e_zz_origj(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_R_J(g1, g0, envs->i_l+0, envs->j_l+0, 0);
G1E_R_J(g2, g0, envs->i_l+0, envs->j_l+1, 0);
G1E_R_J(g3, g2, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*1+0] += + s[8];
}}
void int1e_zz_origj_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_zz_origj_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_zz_origj;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_zz_origj_cart
int int1e_zz_origj_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_zz_origj;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_zz_origj_sph
int int1e_zz_origj_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_zz_origj;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_zz_origj_spinor
ALL_CINT1E(int1e_zz_origj)
ALL_CINT1E_FORTRAN_(int1e_zz_origj)
/* <i|R |j> */
static void CINTgout1e_int1e_r_origj(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double s[3];
G1E_R_J(g1, g0, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
gout[n*3+0] += + s[0];
gout[n*3+1] += + s[1];
gout[n*3+2] += + s[2];
}}
void int1e_r_origj_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 1, 0, 0, 1, 1, 1, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_r_origj_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 1, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_r_origj;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_r_origj_cart
int int1e_r_origj_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 1, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_r_origj;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_r_origj_sph
int int1e_r_origj_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 1, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_r_origj;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_r_origj_spinor
ALL_CINT1E(int1e_r_origj)
ALL_CINT1E_FORTRAN_(int1e_r_origj)
/* <i|R R |j> */
static void CINTgout1e_int1e_rr_origj(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_R_J(g1, g0, envs->i_l+0, envs->j_l+0, 0);
G1E_R_J(g2, g0, envs->i_l+0, envs->j_l+1, 0);
G1E_R_J(g3, g2, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*9+0] += + s[0];
gout[n*9+1] += + s[1];
gout[n*9+2] += + s[2];
gout[n*9+3] += + s[3];
gout[n*9+4] += + s[4];
gout[n*9+5] += + s[5];
gout[n*9+6] += + s[6];
gout[n*9+7] += + s[7];
gout[n*9+8] += + s[8];
}}
void int1e_rr_origj_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 9};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_rr_origj_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_rr_origj;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_rr_origj_cart
int int1e_rr_origj_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_rr_origj;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_rr_origj_sph
int int1e_rr_origj_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_rr_origj;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_rr_origj_spinor
ALL_CINT1E(int1e_rr_origj)
ALL_CINT1E_FORTRAN_(int1e_rr_origj)
/* <i|R DOT R |j> */
static void CINTgout1e_int1e_r2_origj(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_R_J(g1, g0, envs->i_l+0, envs->j_l+0, 0);
G1E_R_J(g2, g0, envs->i_l+0, envs->j_l+1, 0);
G1E_R_J(g3, g2, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*1+0] += + s[0] + s[4] + s[8];
}}
void int1e_r2_origj_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_r2_origj_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_r2_origj;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_r2_origj_cart
int int1e_r2_origj_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_r2_origj;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_r2_origj_sph
int int1e_r2_origj_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 2, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_r2_origj;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_r2_origj_spinor
ALL_CINT1E(int1e_r2_origj)
ALL_CINT1E_FORTRAN_(int1e_r2_origj)
/* <i|OVLP |R DOT R R DOT R j> */
static void CINTgout1e_int1e_r4_origj(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double *g4 = g3  + envs->g_size * 3;
double *g5 = g4  + envs->g_size * 3;
double *g6 = g5  + envs->g_size * 3;
double *g7 = g6  + envs->g_size * 3;
double *g8 = g7  + envs->g_size * 3;
double *g9 = g8  + envs->g_size * 3;
double *g10 = g9  + envs->g_size * 3;
double *g11 = g10  + envs->g_size * 3;
double *g12 = g11  + envs->g_size * 3;
double *g13 = g12  + envs->g_size * 3;
double *g14 = g13  + envs->g_size * 3;
double *g15 = g14  + envs->g_size * 3;
double s[81];
G1E_R_J(g1, g0, envs->i_l+0, envs->j_l+0, 0);
G1E_R_J(g2, g0, envs->i_l+0, envs->j_l+1, 0);
G1E_R_J(g3, g2, envs->i_l+0, envs->j_l+0, 0);
G1E_R_J(g4, g0, envs->i_l+0, envs->j_l+2, 0);
G1E_R_J(g5, g4, envs->i_l+0, envs->j_l+0, 0);
G1E_R_J(g6, g4, envs->i_l+0, envs->j_l+1, 0);
G1E_R_J(g7, g6, envs->i_l+0, envs->j_l+0, 0);
G1E_R_J(g8, g0, envs->i_l+0, envs->j_l+3, 0);
G1E_R_J(g9, g8, envs->i_l+0, envs->j_l+0, 0);
G1E_R_J(g10, g8, envs->i_l+0, envs->j_l+1, 0);
G1E_R_J(g11, g10, envs->i_l+0, envs->j_l+0, 0);
G1E_R_J(g12, g8, envs->i_l+0, envs->j_l+2, 0);
G1E_R_J(g13, g12, envs->i_l+0, envs->j_l+0, 0);
G1E_R_J(g14, g12, envs->i_l+0, envs->j_l+1, 0);
G1E_R_J(g15, g14, envs->i_l+0, envs->j_l+0, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g15[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g14[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g14[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g13[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g12[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g12[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g13[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g12[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g12[ix+0]*g0[iy+0]*g3[iz+0];
s[9] = + g11[ix+0]*g4[iy+0]*g0[iz+0];
s[10] = + g10[ix+0]*g5[iy+0]*g0[iz+0];
s[11] = + g10[ix+0]*g4[iy+0]*g1[iz+0];
s[12] = + g9[ix+0]*g6[iy+0]*g0[iz+0];
s[13] = + g8[ix+0]*g7[iy+0]*g0[iz+0];
s[14] = + g8[ix+0]*g6[iy+0]*g1[iz+0];
s[15] = + g9[ix+0]*g4[iy+0]*g2[iz+0];
s[16] = + g8[ix+0]*g5[iy+0]*g2[iz+0];
s[17] = + g8[ix+0]*g4[iy+0]*g3[iz+0];
s[18] = + g11[ix+0]*g0[iy+0]*g4[iz+0];
s[19] = + g10[ix+0]*g1[iy+0]*g4[iz+0];
s[20] = + g10[ix+0]*g0[iy+0]*g5[iz+0];
s[21] = + g9[ix+0]*g2[iy+0]*g4[iz+0];
s[22] = + g8[ix+0]*g3[iy+0]*g4[iz+0];
s[23] = + g8[ix+0]*g2[iy+0]*g5[iz+0];
s[24] = + g9[ix+0]*g0[iy+0]*g6[iz+0];
s[25] = + g8[ix+0]*g1[iy+0]*g6[iz+0];
s[26] = + g8[ix+0]*g0[iy+0]*g7[iz+0];
s[27] = + g7[ix+0]*g8[iy+0]*g0[iz+0];
s[28] = + g6[ix+0]*g9[iy+0]*g0[iz+0];
s[29] = + g6[ix+0]*g8[iy+0]*g1[iz+0];
s[30] = + g5[ix+0]*g10[iy+0]*g0[iz+0];
s[31] = + g4[ix+0]*g11[iy+0]*g0[iz+0];
s[32] = + g4[ix+0]*g10[iy+0]*g1[iz+0];
s[33] = + g5[ix+0]*g8[iy+0]*g2[iz+0];
s[34] = + g4[ix+0]*g9[iy+0]*g2[iz+0];
s[35] = + g4[ix+0]*g8[iy+0]*g3[iz+0];
s[36] = + g3[ix+0]*g12[iy+0]*g0[iz+0];
s[37] = + g2[ix+0]*g13[iy+0]*g0[iz+0];
s[38] = + g2[ix+0]*g12[iy+0]*g1[iz+0];
s[39] = + g1[ix+0]*g14[iy+0]*g0[iz+0];
s[40] = + g0[ix+0]*g15[iy+0]*g0[iz+0];
s[41] = + g0[ix+0]*g14[iy+0]*g1[iz+0];
s[42] = + g1[ix+0]*g12[iy+0]*g2[iz+0];
s[43] = + g0[ix+0]*g13[iy+0]*g2[iz+0];
s[44] = + g0[ix+0]*g12[iy+0]*g3[iz+0];
s[45] = + g3[ix+0]*g8[iy+0]*g4[iz+0];
s[46] = + g2[ix+0]*g9[iy+0]*g4[iz+0];
s[47] = + g2[ix+0]*g8[iy+0]*g5[iz+0];
s[48] = + g1[ix+0]*g10[iy+0]*g4[iz+0];
s[49] = + g0[ix+0]*g11[iy+0]*g4[iz+0];
s[50] = + g0[ix+0]*g10[iy+0]*g5[iz+0];
s[51] = + g1[ix+0]*g8[iy+0]*g6[iz+0];
s[52] = + g0[ix+0]*g9[iy+0]*g6[iz+0];
s[53] = + g0[ix+0]*g8[iy+0]*g7[iz+0];
s[54] = + g7[ix+0]*g0[iy+0]*g8[iz+0];
s[55] = + g6[ix+0]*g1[iy+0]*g8[iz+0];
s[56] = + g6[ix+0]*g0[iy+0]*g9[iz+0];
s[57] = + g5[ix+0]*g2[iy+0]*g8[iz+0];
s[58] = + g4[ix+0]*g3[iy+0]*g8[iz+0];
s[59] = + g4[ix+0]*g2[iy+0]*g9[iz+0];
s[60] = + g5[ix+0]*g0[iy+0]*g10[iz+0];
s[61] = + g4[ix+0]*g1[iy+0]*g10[iz+0];
s[62] = + g4[ix+0]*g0[iy+0]*g11[iz+0];
s[63] = + g3[ix+0]*g4[iy+0]*g8[iz+0];
s[64] = + g2[ix+0]*g5[iy+0]*g8[iz+0];
s[65] = + g2[ix+0]*g4[iy+0]*g9[iz+0];
s[66] = + g1[ix+0]*g6[iy+0]*g8[iz+0];
s[67] = + g0[ix+0]*g7[iy+0]*g8[iz+0];
s[68] = + g0[ix+0]*g6[iy+0]*g9[iz+0];
s[69] = + g1[ix+0]*g4[iy+0]*g10[iz+0];
s[70] = + g0[ix+0]*g5[iy+0]*g10[iz+0];
s[71] = + g0[ix+0]*g4[iy+0]*g11[iz+0];
s[72] = + g3[ix+0]*g0[iy+0]*g12[iz+0];
s[73] = + g2[ix+0]*g1[iy+0]*g12[iz+0];
s[74] = + g2[ix+0]*g0[iy+0]*g13[iz+0];
s[75] = + g1[ix+0]*g2[iy+0]*g12[iz+0];
s[76] = + g0[ix+0]*g3[iy+0]*g12[iz+0];
s[77] = + g0[ix+0]*g2[iy+0]*g13[iz+0];
s[78] = + g1[ix+0]*g0[iy+0]*g14[iz+0];
s[79] = + g0[ix+0]*g1[iy+0]*g14[iz+0];
s[80] = + g0[ix+0]*g0[iy+0]*g15[iz+0];
gout[n*1+0] += + s[0] + 2*s[4] + 2*s[8] + s[40] + 2*s[44] + s[80];
}}
void int1e_r4_origj_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 4, 0, 0, 4, 1, 1, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_r4_origj_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 4, 0, 0, 4, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_r4_origj;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_r4_origj_cart
int int1e_r4_origj_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 4, 0, 0, 4, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_r4_origj;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_r4_origj_sph
int int1e_r4_origj_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 4, 0, 0, 4, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_r4_origj;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_r4_origj_spinor
ALL_CINT1E(int1e_r4_origj)
ALL_CINT1E_FORTRAN_(int1e_r4_origj)
/* <P DOT P i|OVLP |P DOT P j> */
static void CINTgout1e_int1e_p4(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double *g4 = g3  + envs->g_size * 3;
double *g5 = g4  + envs->g_size * 3;
double *g6 = g5  + envs->g_size * 3;
double *g7 = g6  + envs->g_size * 3;
double *g8 = g7  + envs->g_size * 3;
double *g9 = g8  + envs->g_size * 3;
double *g10 = g9  + envs->g_size * 3;
double *g11 = g10  + envs->g_size * 3;
double *g12 = g11  + envs->g_size * 3;
double *g13 = g12  + envs->g_size * 3;
double *g14 = g13  + envs->g_size * 3;
double *g15 = g14  + envs->g_size * 3;
double s[81];
G1E_D_J(g1, g0, envs->i_l+2, envs->j_l+0, 0);
G1E_D_J(g2, g0, envs->i_l+2, envs->j_l+1, 0);
G1E_D_J(g3, g2, envs->i_l+2, envs->j_l+0, 0);
G1E_D_I(g4, g0, envs->i_l+1, envs->j_l, 0);
G1E_D_I(g5, g1, envs->i_l+1, envs->j_l, 0);
G1E_D_I(g6, g2, envs->i_l+1, envs->j_l, 0);
G1E_D_I(g7, g3, envs->i_l+1, envs->j_l, 0);
G1E_D_I(g8, g0, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g9, g1, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g10, g2, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g11, g3, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g12, g4, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g13, g5, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g14, g6, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g15, g7, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g15[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g14[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g14[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g13[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g12[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g12[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g13[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g12[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g12[ix+0]*g0[iy+0]*g3[iz+0];
s[9] = + g11[ix+0]*g4[iy+0]*g0[iz+0];
s[10] = + g10[ix+0]*g5[iy+0]*g0[iz+0];
s[11] = + g10[ix+0]*g4[iy+0]*g1[iz+0];
s[12] = + g9[ix+0]*g6[iy+0]*g0[iz+0];
s[13] = + g8[ix+0]*g7[iy+0]*g0[iz+0];
s[14] = + g8[ix+0]*g6[iy+0]*g1[iz+0];
s[15] = + g9[ix+0]*g4[iy+0]*g2[iz+0];
s[16] = + g8[ix+0]*g5[iy+0]*g2[iz+0];
s[17] = + g8[ix+0]*g4[iy+0]*g3[iz+0];
s[18] = + g11[ix+0]*g0[iy+0]*g4[iz+0];
s[19] = + g10[ix+0]*g1[iy+0]*g4[iz+0];
s[20] = + g10[ix+0]*g0[iy+0]*g5[iz+0];
s[21] = + g9[ix+0]*g2[iy+0]*g4[iz+0];
s[22] = + g8[ix+0]*g3[iy+0]*g4[iz+0];
s[23] = + g8[ix+0]*g2[iy+0]*g5[iz+0];
s[24] = + g9[ix+0]*g0[iy+0]*g6[iz+0];
s[25] = + g8[ix+0]*g1[iy+0]*g6[iz+0];
s[26] = + g8[ix+0]*g0[iy+0]*g7[iz+0];
s[27] = + g7[ix+0]*g8[iy+0]*g0[iz+0];
s[28] = + g6[ix+0]*g9[iy+0]*g0[iz+0];
s[29] = + g6[ix+0]*g8[iy+0]*g1[iz+0];
s[30] = + g5[ix+0]*g10[iy+0]*g0[iz+0];
s[31] = + g4[ix+0]*g11[iy+0]*g0[iz+0];
s[32] = + g4[ix+0]*g10[iy+0]*g1[iz+0];
s[33] = + g5[ix+0]*g8[iy+0]*g2[iz+0];
s[34] = + g4[ix+0]*g9[iy+0]*g2[iz+0];
s[35] = + g4[ix+0]*g8[iy+0]*g3[iz+0];
s[36] = + g3[ix+0]*g12[iy+0]*g0[iz+0];
s[37] = + g2[ix+0]*g13[iy+0]*g0[iz+0];
s[38] = + g2[ix+0]*g12[iy+0]*g1[iz+0];
s[39] = + g1[ix+0]*g14[iy+0]*g0[iz+0];
s[40] = + g0[ix+0]*g15[iy+0]*g0[iz+0];
s[41] = + g0[ix+0]*g14[iy+0]*g1[iz+0];
s[42] = + g1[ix+0]*g12[iy+0]*g2[iz+0];
s[43] = + g0[ix+0]*g13[iy+0]*g2[iz+0];
s[44] = + g0[ix+0]*g12[iy+0]*g3[iz+0];
s[45] = + g3[ix+0]*g8[iy+0]*g4[iz+0];
s[46] = + g2[ix+0]*g9[iy+0]*g4[iz+0];
s[47] = + g2[ix+0]*g8[iy+0]*g5[iz+0];
s[48] = + g1[ix+0]*g10[iy+0]*g4[iz+0];
s[49] = + g0[ix+0]*g11[iy+0]*g4[iz+0];
s[50] = + g0[ix+0]*g10[iy+0]*g5[iz+0];
s[51] = + g1[ix+0]*g8[iy+0]*g6[iz+0];
s[52] = + g0[ix+0]*g9[iy+0]*g6[iz+0];
s[53] = + g0[ix+0]*g8[iy+0]*g7[iz+0];
s[54] = + g7[ix+0]*g0[iy+0]*g8[iz+0];
s[55] = + g6[ix+0]*g1[iy+0]*g8[iz+0];
s[56] = + g6[ix+0]*g0[iy+0]*g9[iz+0];
s[57] = + g5[ix+0]*g2[iy+0]*g8[iz+0];
s[58] = + g4[ix+0]*g3[iy+0]*g8[iz+0];
s[59] = + g4[ix+0]*g2[iy+0]*g9[iz+0];
s[60] = + g5[ix+0]*g0[iy+0]*g10[iz+0];
s[61] = + g4[ix+0]*g1[iy+0]*g10[iz+0];
s[62] = + g4[ix+0]*g0[iy+0]*g11[iz+0];
s[63] = + g3[ix+0]*g4[iy+0]*g8[iz+0];
s[64] = + g2[ix+0]*g5[iy+0]*g8[iz+0];
s[65] = + g2[ix+0]*g4[iy+0]*g9[iz+0];
s[66] = + g1[ix+0]*g6[iy+0]*g8[iz+0];
s[67] = + g0[ix+0]*g7[iy+0]*g8[iz+0];
s[68] = + g0[ix+0]*g6[iy+0]*g9[iz+0];
s[69] = + g1[ix+0]*g4[iy+0]*g10[iz+0];
s[70] = + g0[ix+0]*g5[iy+0]*g10[iz+0];
s[71] = + g0[ix+0]*g4[iy+0]*g11[iz+0];
s[72] = + g3[ix+0]*g0[iy+0]*g12[iz+0];
s[73] = + g2[ix+0]*g1[iy+0]*g12[iz+0];
s[74] = + g2[ix+0]*g0[iy+0]*g13[iz+0];
s[75] = + g1[ix+0]*g2[iy+0]*g12[iz+0];
s[76] = + g0[ix+0]*g3[iy+0]*g12[iz+0];
s[77] = + g0[ix+0]*g2[iy+0]*g13[iz+0];
s[78] = + g1[ix+0]*g0[iy+0]*g14[iz+0];
s[79] = + g0[ix+0]*g1[iy+0]*g14[iz+0];
s[80] = + g0[ix+0]*g0[iy+0]*g15[iz+0];
gout[n*1+0] += + s[0] + 2*s[4] + 2*s[8] + s[40] + 2*s[44] + s[80];
}}
void int1e_p4_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {2, 2, 0, 0, 4, 1, 1, 1};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_p4_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 2, 0, 0, 4, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_p4;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 0);
} // int1e_p4_cart
int int1e_p4_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 2, 0, 0, 4, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_p4;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 0);
} // int1e_p4_sph
int int1e_p4_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 2, 0, 0, 4, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_p4;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 0);
} // int1e_p4_spinor
ALL_CINT1E(int1e_p4)
ALL_CINT1E_FORTRAN_(int1e_p4)
/* <P* i|RINV CROSS P |j> */
static void CINTgout1e_int1e_prinvxp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, 0);
G1E_D_I(g2, g0, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g3, g1, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*3+0] += + s[5] - s[7];
gout[n*3+1] += + s[6] - s[2];
gout[n*3+2] += + s[1] - s[3];
}}
void int1e_prinvxp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 1, 0, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_prinvxp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_prinvxp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 1);
} // int1e_prinvxp_cart
int int1e_prinvxp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_prinvxp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 1);
} // int1e_prinvxp_sph
int int1e_prinvxp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_prinvxp;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 1);
} // int1e_prinvxp_spinor
ALL_CINT1E(int1e_prinvxp)
ALL_CINT1E_FORTRAN_(int1e_prinvxp)
/* <P* i|NUC CROSS P |j> */
static void CINTgout1e_int1e_pnucxp(double *gout, double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int ix, iy, iz, n;
double *g0 = g;
double *g1 = g0  + envs->g_size * 3;
double *g2 = g1  + envs->g_size * 3;
double *g3 = g2  + envs->g_size * 3;
double s[9];
G1E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, 0);
G1E_D_I(g2, g0, envs->i_l+0, envs->j_l, 0);
G1E_D_I(g3, g1, envs->i_l+0, envs->j_l, 0);
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
s[0] = + g3[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g2[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g2[ix+0]*g0[iy+0]*g1[iz+0];
s[3] = + g1[ix+0]*g2[iy+0]*g0[iz+0];
s[4] = + g0[ix+0]*g3[iy+0]*g0[iz+0];
s[5] = + g0[ix+0]*g2[iy+0]*g1[iz+0];
s[6] = + g1[ix+0]*g0[iy+0]*g2[iz+0];
s[7] = + g0[ix+0]*g1[iy+0]*g2[iz+0];
s[8] = + g0[ix+0]*g0[iy+0]*g3[iz+0];
gout[n*3+0] += + s[5] - s[7];
gout[n*3+1] += + s[6] - s[2];
gout[n*3+2] += + s[1] - s[3];
}}
void int1e_pnucxp_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 1, 0, 3};
CINTall_1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int1e_pnucxp_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_pnucxp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_cart_1e, 2);
} // int1e_pnucxp_cart
int int1e_pnucxp_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_pnucxp;
return CINT1e_drv(out, dims, &envs, cache, &c2s_sph_1e, 2);
} // int1e_pnucxp_sph
int int1e_pnucxp_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 0, 3};
CINTEnvVars envs;
CINTinit_int1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout1e_int1e_pnucxp;
return CINT1e_spinor_drv(out, dims, &envs, cache, &c2s_sf_1e, 2);
} // int1e_pnucxp_spinor
ALL_CINT1E(int1e_pnucxp)
ALL_CINT1E_FORTRAN_(int1e_pnucxp)
/* <k P* i|R12 |CROSS P j l> : i,j \in electron 1; k,l \in electron 2
 * = (P* i CROSS P j|R12 |k l) */
static void CINTgout2e_int2e_p1vxp1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
G2E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g2, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g3, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[9];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 9; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g3[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g2[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g2[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g1[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g0[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g0[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g1[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g0[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g0[ix+i] * g0[iy+i] * g3[iz+i];
}
if (gout_empty) {
gout[n*3+0] = + s[5] - s[7];
gout[n*3+1] = + s[6] - s[2];
gout[n*3+2] = + s[1] - s[3];
} else {
gout[n*3+0] += + s[5] - s[7];
gout[n*3+1] += + s[6] - s[2];
gout[n*3+2] += + s[1] - s[3];
}}}
void int2e_p1vxp1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 3};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_p1vxp1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_p1vxp1;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_p1vxp1_cart
int int2e_p1vxp1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_p1vxp1;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_p1vxp1_sph
int int2e_p1vxp1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_p1vxp1;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_2e1, &c2s_sf_2e2);
} // int2e_p1vxp1_spinor
ALL_CINT(int2e_p1vxp1)
ALL_CINT_FORTRAN_(int2e_p1vxp1)
