/*
 * Copyright (C) 2013-  Qiming Sun <osirpt.sun@gmail.com>
 * Description: code generated by  gen-code.cl
 */
#include <stdlib.h>
#include "cint_bas.h"
#include "cart2sph.h"
#include "g1e.h"
#include "g2e.h"
#include "optimizer.h"
#include "cint1e.h"
#include "cint2e.h"
#include "misc.h"
#include "c2f.h"
/* (NABLA i j|R12 |k) */
void CINTgout2e_int3c2e_ip1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
G2E_D_I(g1, g0, envs->i_l+0, envs->j_l, envs->k_l, 0);
double s[3];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
switch (nrys_roots) {
case 1:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
break;
case 2:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1];
break;
case 3:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1]+ g1[ix+2]*g0[iy+2]*g0[iz+2];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1]+ g0[ix+2]*g1[iy+2]*g0[iz+2];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1]+ g0[ix+2]*g0[iy+2]*g1[iz+2];
break;
case 4:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1]+ g1[ix+2]*g0[iy+2]*g0[iz+2]+ g1[ix+3]*g0[iy+3]*g0[iz+3];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1]+ g0[ix+2]*g1[iy+2]*g0[iz+2]+ g0[ix+3]*g1[iy+3]*g0[iz+3];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1]+ g0[ix+2]*g0[iy+2]*g1[iz+2]+ g0[ix+3]*g0[iy+3]*g1[iz+3];
break;
default:
for (i = 0; i < 3; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g1[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g0[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g0[ix+i] * g0[iy+i] * g1[iz+i];
} break;}
if (gout_empty) {
gout[n*3+0] = + s[0];
gout[n*3+1] = + s[1];
gout[n*3+2] = + s[2];
} else {
gout[n*3+0] += + s[0];
gout[n*3+1] += + s[1];
gout[n*3+2] += + s[2];
}}}
void int3c2e_ip1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTall_3c2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int3c2e_ip1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ip1;
return CINT3c2e_cart_drv(out, dims, &envs, opt, cache);
} // int3c2e_ip1_cart
int int3c2e_ip1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ip1;
return CINT3c2e_spheric_drv(out, dims, &envs, opt, cache, &c2s_sph_3c2e1, 0);
} // int3c2e_ip1_sph
int int3c2e_ip1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ip1;
return CINT3c2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_3c2e1, 0);
} // int3c2e_ip1_spinor
ALL_CINT(int3c2e_ip1)
ALL_CINT_FORTRAN_(int3c2e_ip1)
/* (i j|R12 |NABLA k) */
void CINTgout2e_int3c2e_ip2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
G2E_D_K(g1, g0, envs->i_l+0, envs->j_l+0, envs->k_l+0, 0);
double s[3];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
switch (nrys_roots) {
case 1:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
break;
case 2:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1];
break;
case 3:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1]+ g1[ix+2]*g0[iy+2]*g0[iz+2];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1]+ g0[ix+2]*g1[iy+2]*g0[iz+2];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1]+ g0[ix+2]*g0[iy+2]*g1[iz+2];
break;
case 4:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1]+ g1[ix+2]*g0[iy+2]*g0[iz+2]+ g1[ix+3]*g0[iy+3]*g0[iz+3];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1]+ g0[ix+2]*g1[iy+2]*g0[iz+2]+ g0[ix+3]*g1[iy+3]*g0[iz+3];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1]+ g0[ix+2]*g0[iy+2]*g1[iz+2]+ g0[ix+3]*g0[iy+3]*g1[iz+3];
break;
default:
for (i = 0; i < 3; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g1[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g0[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g0[ix+i] * g0[iy+i] * g1[iz+i];
} break;}
if (gout_empty) {
gout[n*3+0] = + s[0];
gout[n*3+1] = + s[1];
gout[n*3+2] = + s[2];
} else {
gout[n*3+0] += + s[0];
gout[n*3+1] += + s[1];
gout[n*3+2] += + s[2];
}}}
void int3c2e_ip2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 0, 1, 0, 1, 1, 1, 3};
CINTall_3c2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int3c2e_ip2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 1, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ip2;
return CINT3c2e_cart_drv(out, dims, &envs, opt, cache);
} // int3c2e_ip2_cart
int int3c2e_ip2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 1, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ip2;
return CINT3c2e_spheric_drv(out, dims, &envs, opt, cache, &c2s_sph_3c2e1, 0);
} // int3c2e_ip2_sph
int int3c2e_ip2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 1, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ip2;
return CINT3c2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_3c2e1, 0);
} // int3c2e_ip2_spinor
ALL_CINT(int3c2e_ip2)
ALL_CINT_FORTRAN_(int3c2e_ip2)
/* (P* i DOT P j|R12 |k) */
void CINTgout2e_int3c2e_pvp1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
G2E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, envs->k_l, 0);
G2E_D_I(g2, g0, envs->i_l+0, envs->j_l, envs->k_l, 0);
G2E_D_I(g3, g1, envs->i_l+0, envs->j_l, envs->k_l, 0);
double s[9];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 9; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g3[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g2[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g2[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g1[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g0[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g0[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g1[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g0[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g0[ix+i] * g0[iy+i] * g3[iz+i];
}
if (gout_empty) {
gout[n*1+0] = + s[0] + s[4] + s[8];
} else {
gout[n*1+0] += + s[0] + s[4] + s[8];
}}}
void int3c2e_pvp1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 1};
CINTall_3c2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int3c2e_pvp1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_pvp1;
return CINT3c2e_cart_drv(out, dims, &envs, opt, cache);
} // int3c2e_pvp1_cart
int int3c2e_pvp1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_pvp1;
return CINT3c2e_spheric_drv(out, dims, &envs, opt, cache, &c2s_sph_3c2e1, 0);
} // int3c2e_pvp1_sph
int int3c2e_pvp1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_pvp1;
return CINT3c2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_3c2e1, 0);
} // int3c2e_pvp1_spinor
ALL_CINT(int3c2e_pvp1)
ALL_CINT_FORTRAN_(int3c2e_pvp1)
/* (NABLA i |R12 |j) */
static void CINTgout2e_int2c2e_ip1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
G2E_D_I(g1, g0, envs->i_l+0, 0, envs->k_l, 0);
double s[3];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
switch (nrys_roots) {
case 1:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
break;
case 2:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1];
break;
case 3:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1]+ g1[ix+2]*g0[iy+2]*g0[iz+2];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1]+ g0[ix+2]*g1[iy+2]*g0[iz+2];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1]+ g0[ix+2]*g0[iy+2]*g1[iz+2];
break;
case 4:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1]+ g1[ix+2]*g0[iy+2]*g0[iz+2]+ g1[ix+3]*g0[iy+3]*g0[iz+3];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1]+ g0[ix+2]*g1[iy+2]*g0[iz+2]+ g0[ix+3]*g1[iy+3]*g0[iz+3];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1]+ g0[ix+2]*g0[iy+2]*g1[iz+2]+ g0[ix+3]*g0[iy+3]*g1[iz+3];
break;
default:
for (i = 0; i < 3; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g1[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g0[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g0[ix+i] * g0[iy+i] * g1[iz+i];
} break;}
if (gout_empty) {
gout[n*3+0] = + s[0];
gout[n*3+1] = + s[1];
gout[n*3+2] = + s[2];
} else {
gout[n*3+0] += + s[0];
gout[n*3+1] += + s[1];
gout[n*3+2] += + s[2];
}}}
void int2c2e_ip1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTall_2c2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2c2e_ip1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2c2e_ip1;
return CINT2c2e_cart_drv(out, dims, &envs, opt, cache);
} // int2c2e_ip1_cart
int int2c2e_ip1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2c2e_ip1;
return CINT2c2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2c2e_ip1_sph
int int2c2e_ip1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2c2e_ip1;
return CINT2c2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_1e);
} // int2c2e_ip1_spinor
ALL_CINT(int2c2e_ip1)
ALL_CINT_FORTRAN_(int2c2e_ip1)
/* (i |R12 |NABLA j) */
static void CINTgout2e_int2c2e_ip2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
G2E_D_K(g1, g0, envs->i_l+0, 0, envs->k_l+0, 0);
double s[3];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
switch (nrys_roots) {
case 1:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
break;
case 2:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1];
break;
case 3:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1]+ g1[ix+2]*g0[iy+2]*g0[iz+2];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1]+ g0[ix+2]*g1[iy+2]*g0[iz+2];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1]+ g0[ix+2]*g0[iy+2]*g1[iz+2];
break;
case 4:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1]+ g1[ix+2]*g0[iy+2]*g0[iz+2]+ g1[ix+3]*g0[iy+3]*g0[iz+3];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1]+ g0[ix+2]*g1[iy+2]*g0[iz+2]+ g0[ix+3]*g1[iy+3]*g0[iz+3];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1]+ g0[ix+2]*g0[iy+2]*g1[iz+2]+ g0[ix+3]*g0[iy+3]*g1[iz+3];
break;
default:
for (i = 0; i < 3; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g1[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g0[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g0[ix+i] * g0[iy+i] * g1[iz+i];
} break;}
if (gout_empty) {
gout[n*3+0] = + s[0];
gout[n*3+1] = + s[1];
gout[n*3+2] = + s[2];
} else {
gout[n*3+0] += + s[0];
gout[n*3+1] += + s[1];
gout[n*3+2] += + s[2];
}}}
void int2c2e_ip2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 0, 1, 0, 1, 1, 1, 3};
CINTall_2c2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2c2e_ip2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 1, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2c2e_ip2;
return CINT2c2e_cart_drv(out, dims, &envs, opt, cache);
} // int2c2e_ip2_cart
int int2c2e_ip2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 1, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2c2e_ip2;
return CINT2c2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2c2e_ip2_sph
int int2c2e_ip2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 1, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2c2e_ip2;
return CINT2c2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_1e);
} // int2c2e_ip2_spinor
ALL_CINT(int2c2e_ip2)
ALL_CINT_FORTRAN_(int2c2e_ip2)
/* (G i j|R12 |k) */
void CINTgout2e_int3c2e_ig1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double rirj[3], c[3];
rirj[0] = envs->ri[0] - envs->rj[0];
rirj[1] = envs->ri[1] - envs->rj[1];
rirj[2] = envs->ri[2] - envs->rj[2];
c[0] = 1 * rirj[0];
c[1] = 1 * rirj[1];
c[2] = 1 * rirj[2];
G2E_R0I(g1, g0, envs->i_l+0, envs->j_l, envs->k_l, 0);
double s[3];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
switch (nrys_roots) {
case 1:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
break;
case 2:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1];
break;
case 3:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1]+ g1[ix+2]*g0[iy+2]*g0[iz+2];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1]+ g0[ix+2]*g1[iy+2]*g0[iz+2];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1]+ g0[ix+2]*g0[iy+2]*g1[iz+2];
break;
case 4:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1]+ g1[ix+2]*g0[iy+2]*g0[iz+2]+ g1[ix+3]*g0[iy+3]*g0[iz+3];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1]+ g0[ix+2]*g1[iy+2]*g0[iz+2]+ g0[ix+3]*g1[iy+3]*g0[iz+3];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1]+ g0[ix+2]*g0[iy+2]*g1[iz+2]+ g0[ix+3]*g0[iy+3]*g1[iz+3];
break;
default:
for (i = 0; i < 3; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g1[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g0[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g0[ix+i] * g0[iy+i] * g1[iz+i];
} break;}
if (gout_empty) {
gout[n*3+0] = - c[1]*s[2] + c[2]*s[1];
gout[n*3+1] = - c[2]*s[0] + c[0]*s[2];
gout[n*3+2] = - c[0]*s[1] + c[1]*s[0];
} else {
gout[n*3+0] += - c[1]*s[2] + c[2]*s[1];
gout[n*3+1] += - c[2]*s[0] + c[0]*s[2];
gout[n*3+2] += - c[0]*s[1] + c[1]*s[0];
}}}
void int3c2e_ig1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTall_3c2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int3c2e_ig1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ig1;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = envs.nfk * envs.x_ctr[2];
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT3c2e_cart_drv(out, dims, &envs, opt, cache);
} // int3c2e_ig1_cart
int int3c2e_ig1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ig1;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = (envs.k_l*2+1) * envs.x_ctr[2];
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT3c2e_spheric_drv(out, dims, &envs, opt, cache, &c2s_sph_3c2e1, 0);
} // int3c2e_ig1_sph
int int3c2e_ig1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ig1;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = (envs.k_l*2+1) * envs.x_ctr[2];
counts[3] = 1;
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
return CINT3c2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_3c2e1, 0);
} // int3c2e_ig1_spinor
ALL_CINT(int3c2e_ig1)
ALL_CINT_FORTRAN_(int3c2e_ig1)
/* (SIGMA DOT P i SIGMA DOT P j|R12 |k) */
void CINTgout2e_int3c2e_spsp1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
G2E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, envs->k_l, 0);
G2E_D_I(g2, g0, envs->i_l+0, envs->j_l, envs->k_l, 0);
G2E_D_I(g3, g1, envs->i_l+0, envs->j_l, envs->k_l, 0);
double s[9];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 9; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g3[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g2[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g2[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g1[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g0[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g0[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g1[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g0[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g0[ix+i] * g0[iy+i] * g3[iz+i];
}
if (gout_empty) {
gout[n*4+0] = + s[5] - s[7];
gout[n*4+1] = + s[6] - s[2];
gout[n*4+2] = + s[1] - s[3];
gout[n*4+3] = + s[0] + s[4] + s[8];
} else {
gout[n*4+0] += + s[5] - s[7];
gout[n*4+1] += + s[6] - s[2];
gout[n*4+2] += + s[1] - s[3];
gout[n*4+3] += + s[0] + s[4] + s[8];
}}}
void int3c2e_spsp1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTall_3c2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int3c2e_spsp1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_spsp1;
return CINT3c2e_cart_drv(out, dims, &envs, opt, cache);
} // int3c2e_spsp1_cart
int int3c2e_spsp1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_spsp1;
return CINT3c2e_spheric_drv(out, dims, &envs, opt, cache, &c2s_sph_3c2e1, 0);
} // int3c2e_spsp1_sph
int int3c2e_spsp1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_spsp1;
return CINT3c2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_3c2e1, 0);
} // int3c2e_spsp1_spinor
ALL_CINT(int3c2e_spsp1)
ALL_CINT_FORTRAN_(int3c2e_spsp1)
/* (NABLA SIGMA DOT P i SIGMA DOT P j|R12 |k) */
void CINTgout2e_int3c2e_ipspsp1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
G2E_D_J(g1, g0, envs->i_l+2, envs->j_l+0, envs->k_l, 0);
G2E_D_I(g2, g0, envs->i_l+1, envs->j_l, envs->k_l, 0);
G2E_D_I(g3, g1, envs->i_l+1, envs->j_l, envs->k_l, 0);
G2E_D_I(g4, g0, envs->i_l+0, envs->j_l, envs->k_l, 0);
G2E_D_I(g5, g1, envs->i_l+0, envs->j_l, envs->k_l, 0);
G2E_D_I(g6, g2, envs->i_l+0, envs->j_l, envs->k_l, 0);
G2E_D_I(g7, g3, envs->i_l+0, envs->j_l, envs->k_l, 0);
double s[27];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 27; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g7[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g6[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g6[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g5[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g4[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g4[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g5[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g4[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g4[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g3[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g2[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g2[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g1[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g0[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g0[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g1[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g0[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g0[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g3[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g2[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g2[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g1[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g0[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g0[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g1[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g0[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g0[ix+i] * g0[iy+i] * g7[iz+i];
}
if (gout_empty) {
gout[n*12+0] = + s[11] - s[19];
gout[n*12+1] = + s[18] - s[2];
gout[n*12+2] = + s[1] - s[9];
gout[n*12+3] = + s[0] + s[10] + s[20];
gout[n*12+4] = + s[14] - s[22];
gout[n*12+5] = + s[21] - s[5];
gout[n*12+6] = + s[4] - s[12];
gout[n*12+7] = + s[3] + s[13] + s[23];
gout[n*12+8] = + s[17] - s[25];
gout[n*12+9] = + s[24] - s[8];
gout[n*12+10] = + s[7] - s[15];
gout[n*12+11] = + s[6] + s[16] + s[26];
} else {
gout[n*12+0] += + s[11] - s[19];
gout[n*12+1] += + s[18] - s[2];
gout[n*12+2] += + s[1] - s[9];
gout[n*12+3] += + s[0] + s[10] + s[20];
gout[n*12+4] += + s[14] - s[22];
gout[n*12+5] += + s[21] - s[5];
gout[n*12+6] += + s[4] - s[12];
gout[n*12+7] += + s[3] + s[13] + s[23];
gout[n*12+8] += + s[17] - s[25];
gout[n*12+9] += + s[24] - s[8];
gout[n*12+10] += + s[7] - s[15];
gout[n*12+11] += + s[6] + s[16] + s[26];
}}}
void int3c2e_ipspsp1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTall_3c2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int3c2e_ipspsp1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ipspsp1;
return CINT3c2e_cart_drv(out, dims, &envs, opt, cache);
} // int3c2e_ipspsp1_cart
int int3c2e_ipspsp1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ipspsp1;
return CINT3c2e_spheric_drv(out, dims, &envs, opt, cache, &c2s_sph_3c2e1, 0);
} // int3c2e_ipspsp1_sph
int int3c2e_ipspsp1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ipspsp1;
return CINT3c2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_3c2e1, 0);
} // int3c2e_ipspsp1_spinor
ALL_CINT(int3c2e_ipspsp1)
ALL_CINT_FORTRAN_(int3c2e_ipspsp1)
/* (SIGMA DOT P i SIGMA DOT P j|R12 |NABLA k) */
void CINTgout2e_int3c2e_spsp1ip2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
G2E_D_K(g1, g0, envs->i_l+1, envs->j_l+1, envs->k_l+0, 0);
G2E_D_J(g2, g0, envs->i_l+1, envs->j_l+0, envs->k_l, 0);
G2E_D_J(g3, g1, envs->i_l+1, envs->j_l+0, envs->k_l, 0);
G2E_D_I(g4, g0, envs->i_l+0, envs->j_l, envs->k_l, 0);
G2E_D_I(g5, g1, envs->i_l+0, envs->j_l, envs->k_l, 0);
G2E_D_I(g6, g2, envs->i_l+0, envs->j_l, envs->k_l, 0);
G2E_D_I(g7, g3, envs->i_l+0, envs->j_l, envs->k_l, 0);
double s[27];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 27; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g7[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g6[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g6[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g5[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g4[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g4[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g5[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g4[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g4[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g3[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g2[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g2[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g1[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g0[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g0[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g1[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g0[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g0[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g3[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g2[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g2[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g1[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g0[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g0[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g1[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g0[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g0[ix+i] * g0[iy+i] * g7[iz+i];
}
if (gout_empty) {
gout[n*12+0] = + s[15] - s[21];
gout[n*12+1] = + s[18] - s[6];
gout[n*12+2] = + s[3] - s[9];
gout[n*12+3] = + s[0] + s[12] + s[24];
gout[n*12+4] = + s[16] - s[22];
gout[n*12+5] = + s[19] - s[7];
gout[n*12+6] = + s[4] - s[10];
gout[n*12+7] = + s[1] + s[13] + s[25];
gout[n*12+8] = + s[17] - s[23];
gout[n*12+9] = + s[20] - s[8];
gout[n*12+10] = + s[5] - s[11];
gout[n*12+11] = + s[2] + s[14] + s[26];
} else {
gout[n*12+0] += + s[15] - s[21];
gout[n*12+1] += + s[18] - s[6];
gout[n*12+2] += + s[3] - s[9];
gout[n*12+3] += + s[0] + s[12] + s[24];
gout[n*12+4] += + s[16] - s[22];
gout[n*12+5] += + s[19] - s[7];
gout[n*12+6] += + s[4] - s[10];
gout[n*12+7] += + s[1] + s[13] + s[25];
gout[n*12+8] += + s[17] - s[23];
gout[n*12+9] += + s[20] - s[8];
gout[n*12+10] += + s[5] - s[11];
gout[n*12+11] += + s[2] + s[14] + s[26];
}}}
void int3c2e_spsp1ip2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 1, 0, 3, 4, 1, 3};
CINTall_3c2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int3c2e_spsp1ip2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 0, 3, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_spsp1ip2;
return CINT3c2e_cart_drv(out, dims, &envs, opt, cache);
} // int3c2e_spsp1ip2_cart
int int3c2e_spsp1ip2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 0, 3, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_spsp1ip2;
return CINT3c2e_spheric_drv(out, dims, &envs, opt, cache, &c2s_sph_3c2e1, 0);
} // int3c2e_spsp1ip2_sph
int int3c2e_spsp1ip2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 0, 3, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_spsp1ip2;
return CINT3c2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_3c2e1, 0);
} // int3c2e_spsp1ip2_spinor
ALL_CINT(int3c2e_spsp1ip2)
ALL_CINT_FORTRAN_(int3c2e_spsp1ip2)
/* (NABLA NABLA i j|R12 |k) */
void CINTgout2e_int3c2e_ipip1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
G2E_D_I(g1, g0, envs->i_l+1, envs->j_l, envs->k_l, 0);
G2E_D_I(g2, g0, envs->i_l+0, envs->j_l, envs->k_l, 0);
G2E_D_I(g3, g1, envs->i_l+0, envs->j_l, envs->k_l, 0);
double s[9];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 9; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g3[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g2[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g2[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g1[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g0[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g0[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g1[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g0[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g0[ix+i] * g0[iy+i] * g3[iz+i];
}
if (gout_empty) {
gout[n*9+0] = + s[0];
gout[n*9+1] = + s[3];
gout[n*9+2] = + s[6];
gout[n*9+3] = + s[1];
gout[n*9+4] = + s[4];
gout[n*9+5] = + s[7];
gout[n*9+6] = + s[2];
gout[n*9+7] = + s[5];
gout[n*9+8] = + s[8];
} else {
gout[n*9+0] += + s[0];
gout[n*9+1] += + s[3];
gout[n*9+2] += + s[6];
gout[n*9+3] += + s[1];
gout[n*9+4] += + s[4];
gout[n*9+5] += + s[7];
gout[n*9+6] += + s[2];
gout[n*9+7] += + s[5];
gout[n*9+8] += + s[8];
}}}
void int3c2e_ipip1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {2, 0, 0, 0, 2, 1, 1, 9};
CINTall_3c2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int3c2e_ipip1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 0, 0, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ipip1;
return CINT3c2e_cart_drv(out, dims, &envs, opt, cache);
} // int3c2e_ipip1_cart
int int3c2e_ipip1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 0, 0, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ipip1;
return CINT3c2e_spheric_drv(out, dims, &envs, opt, cache, &c2s_sph_3c2e1, 0);
} // int3c2e_ipip1_sph
int int3c2e_ipip1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 0, 0, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ipip1;
return CINT3c2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_3c2e1, 0);
} // int3c2e_ipip1_spinor
ALL_CINT(int3c2e_ipip1)
ALL_CINT_FORTRAN_(int3c2e_ipip1)
/* (NABLA i NABLA j|R12 |k) */
void CINTgout2e_int3c2e_ipvip1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
G2E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, envs->k_l, 0);
G2E_D_I(g2, g0, envs->i_l+0, envs->j_l, envs->k_l, 0);
G2E_D_I(g3, g1, envs->i_l+0, envs->j_l, envs->k_l, 0);
double s[9];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 9; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g3[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g2[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g2[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g1[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g0[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g0[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g1[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g0[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g0[ix+i] * g0[iy+i] * g3[iz+i];
}
if (gout_empty) {
gout[n*9+0] = + s[0];
gout[n*9+1] = + s[1];
gout[n*9+2] = + s[2];
gout[n*9+3] = + s[3];
gout[n*9+4] = + s[4];
gout[n*9+5] = + s[5];
gout[n*9+6] = + s[6];
gout[n*9+7] = + s[7];
gout[n*9+8] = + s[8];
} else {
gout[n*9+0] += + s[0];
gout[n*9+1] += + s[1];
gout[n*9+2] += + s[2];
gout[n*9+3] += + s[3];
gout[n*9+4] += + s[4];
gout[n*9+5] += + s[5];
gout[n*9+6] += + s[6];
gout[n*9+7] += + s[7];
gout[n*9+8] += + s[8];
}}}
void int3c2e_ipvip1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 9};
CINTall_3c2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int3c2e_ipvip1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ipvip1;
return CINT3c2e_cart_drv(out, dims, &envs, opt, cache);
} // int3c2e_ipvip1_cart
int int3c2e_ipvip1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ipvip1;
return CINT3c2e_spheric_drv(out, dims, &envs, opt, cache, &c2s_sph_3c2e1, 0);
} // int3c2e_ipvip1_sph
int int3c2e_ipvip1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ipvip1;
return CINT3c2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_3c2e1, 0);
} // int3c2e_ipvip1_spinor
ALL_CINT(int3c2e_ipvip1)
ALL_CINT_FORTRAN_(int3c2e_ipvip1)
/* (NABLA i j|R12 |NABLA k) */
void CINTgout2e_int3c2e_ip1ip2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
G2E_D_K(g1, g0, envs->i_l+1, envs->j_l+0, envs->k_l+0, 0);
G2E_D_I(g2, g0, envs->i_l+0, envs->j_l, envs->k_l, 0);
G2E_D_I(g3, g1, envs->i_l+0, envs->j_l, envs->k_l, 0);
double s[9];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 9; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g3[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g2[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g2[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g1[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g0[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g0[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g1[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g0[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g0[ix+i] * g0[iy+i] * g3[iz+i];
}
if (gout_empty) {
gout[n*9+0] = + s[0];
gout[n*9+1] = + s[1];
gout[n*9+2] = + s[2];
gout[n*9+3] = + s[3];
gout[n*9+4] = + s[4];
gout[n*9+5] = + s[5];
gout[n*9+6] = + s[6];
gout[n*9+7] = + s[7];
gout[n*9+8] = + s[8];
} else {
gout[n*9+0] += + s[0];
gout[n*9+1] += + s[1];
gout[n*9+2] += + s[2];
gout[n*9+3] += + s[3];
gout[n*9+4] += + s[4];
gout[n*9+5] += + s[5];
gout[n*9+6] += + s[6];
gout[n*9+7] += + s[7];
gout[n*9+8] += + s[8];
}}}
void int3c2e_ip1ip2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 0, 1, 0, 2, 1, 1, 9};
CINTall_3c2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int3c2e_ip1ip2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 1, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ip1ip2;
return CINT3c2e_cart_drv(out, dims, &envs, opt, cache);
} // int3c2e_ip1ip2_cart
int int3c2e_ip1ip2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 1, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ip1ip2;
return CINT3c2e_spheric_drv(out, dims, &envs, opt, cache, &c2s_sph_3c2e1, 0);
} // int3c2e_ip1ip2_sph
int int3c2e_ip1ip2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 1, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int3c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int3c2e_ip1ip2;
return CINT3c2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_3c2e1, 0);
} // int3c2e_ip1ip2_spinor
ALL_CINT(int3c2e_ip1ip2)
ALL_CINT_FORTRAN_(int3c2e_ip1ip2)
/* (NABLA i |R12 |NABLA j) */
static void CINTgout2e_int2c2e_ip1ip2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
G2E_D_K(g1, g0, envs->i_l+1, 0, envs->k_l+0, 0);
G2E_D_I(g2, g0, envs->i_l+0, 0, envs->k_l, 0);
G2E_D_I(g3, g1, envs->i_l+0, 0, envs->k_l, 0);
double s[9];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 9; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g3[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g2[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g2[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g1[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g0[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g0[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g1[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g0[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g0[ix+i] * g0[iy+i] * g3[iz+i];
}
if (gout_empty) {
gout[n*9+0] = + s[0];
gout[n*9+1] = + s[1];
gout[n*9+2] = + s[2];
gout[n*9+3] = + s[3];
gout[n*9+4] = + s[4];
gout[n*9+5] = + s[5];
gout[n*9+6] = + s[6];
gout[n*9+7] = + s[7];
gout[n*9+8] = + s[8];
} else {
gout[n*9+0] += + s[0];
gout[n*9+1] += + s[1];
gout[n*9+2] += + s[2];
gout[n*9+3] += + s[3];
gout[n*9+4] += + s[4];
gout[n*9+5] += + s[5];
gout[n*9+6] += + s[6];
gout[n*9+7] += + s[7];
gout[n*9+8] += + s[8];
}}}
void int2c2e_ip1ip2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 0, 1, 0, 2, 1, 1, 9};
CINTall_2c2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2c2e_ip1ip2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 1, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int2c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2c2e_ip1ip2;
return CINT2c2e_cart_drv(out, dims, &envs, opt, cache);
} // int2c2e_ip1ip2_cart
int int2c2e_ip1ip2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 1, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int2c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2c2e_ip1ip2;
return CINT2c2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2c2e_ip1ip2_sph
int int2c2e_ip1ip2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 1, 0, 2, 1, 1, 9};
CINTEnvVars envs;
CINTinit_int2c2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2c2e_ip1ip2;
return CINT2c2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_1e);
} // int2c2e_ip1ip2_spinor
ALL_CINT(int2c2e_ip1ip2)
ALL_CINT_FORTRAN_(int2c2e_ip1ip2)
