/*
 * Copyright (C) 2013-  Qiming Sun <osirpt.sun@gmail.com>
 * Description: code generated by  gen-code.cl
 */
#include <stdlib.h>
#include "cint_bas.h"
#include "cart2sph.h"
#include "g1e.h"
#include "g2e.h"
#include "optimizer.h"
#include "cint1e.h"
#include "cint2e.h"
#include "misc.h"
#include "c2f.h"
/* <k NABLA i|R12 |j l> : i,j \in electron 1; k,l \in electron 2
 * = (NABLA i j|R12 |k l) */
static void CINTgout2e_int2e_ip1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
G2E_D_I(g1, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[3];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
switch (nrys_roots) {
case 1:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
break;
case 2:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1];
break;
case 3:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1]+ g1[ix+2]*g0[iy+2]*g0[iz+2];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1]+ g0[ix+2]*g1[iy+2]*g0[iz+2];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1]+ g0[ix+2]*g0[iy+2]*g1[iz+2];
break;
case 4:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1]+ g1[ix+2]*g0[iy+2]*g0[iz+2]+ g1[ix+3]*g0[iy+3]*g0[iz+3];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1]+ g0[ix+2]*g1[iy+2]*g0[iz+2]+ g0[ix+3]*g1[iy+3]*g0[iz+3];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1]+ g0[ix+2]*g0[iy+2]*g1[iz+2]+ g0[ix+3]*g0[iy+3]*g1[iz+3];
break;
default:
for (i = 0; i < 3; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g1[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g0[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g0[ix+i] * g0[iy+i] * g1[iz+i];
} break;}
if (gout_empty) {
gout[n*3+0] = + s[0];
gout[n*3+1] = + s[1];
gout[n*3+2] = + s[2];
} else {
gout[n*3+0] += + s[0];
gout[n*3+1] += + s[1];
gout[n*3+2] += + s[2];
}}}
void int2e_ip1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_ip1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ip1;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_ip1_cart
int int2e_ip1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ip1;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_ip1_sph
int int2e_ip1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ip1;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_2e1, &c2s_sf_2e2);
} // int2e_ip1_spinor
ALL_CINT(int2e_ip1)
ALL_CINT_FORTRAN_(int2e_ip1)
/* <NABLA k i|R12 |j l> : i,j \in electron 1; k,l \in electron 2
 * = (i j|R12 |NABLA k l) */
static void CINTgout2e_int2e_ip2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
G2E_D_K(g1, g0, envs->i_l+0, envs->j_l+0, envs->k_l+0, envs->l_l);
double s[3];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
switch (nrys_roots) {
case 1:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
break;
case 2:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1];
break;
case 3:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1]+ g1[ix+2]*g0[iy+2]*g0[iz+2];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1]+ g0[ix+2]*g1[iy+2]*g0[iz+2];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1]+ g0[ix+2]*g0[iy+2]*g1[iz+2];
break;
case 4:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1]+ g1[ix+2]*g0[iy+2]*g0[iz+2]+ g1[ix+3]*g0[iy+3]*g0[iz+3];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1]+ g0[ix+2]*g1[iy+2]*g0[iz+2]+ g0[ix+3]*g1[iy+3]*g0[iz+3];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1]+ g0[ix+2]*g0[iy+2]*g1[iz+2]+ g0[ix+3]*g0[iy+3]*g1[iz+3];
break;
default:
for (i = 0; i < 3; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g1[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g0[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g0[ix+i] * g0[iy+i] * g1[iz+i];
} break;}
if (gout_empty) {
gout[n*3+0] = + s[0];
gout[n*3+1] = + s[1];
gout[n*3+2] = + s[2];
} else {
gout[n*3+0] += + s[0];
gout[n*3+1] += + s[1];
gout[n*3+2] += + s[2];
}}}
void int2e_ip2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 0, 1, 0, 1, 1, 1, 3};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_ip2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 1, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ip2;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_ip2_cart
int int2e_ip2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 1, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ip2;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_ip2_sph
int int2e_ip2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 1, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ip2;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_2e1, &c2s_sf_2e2);
} // int2e_ip2_spinor
ALL_CINT(int2e_ip2)
ALL_CINT_FORTRAN_(int2e_ip2)
/* <k NABLA SIGMA DOT P i|R12 |SIGMA DOT P j l> : i,j \in electron 1; k,l \in electron 2
 * = (NABLA SIGMA DOT P i SIGMA DOT P j|R12 |k l) */
static void CINTgout2e_int2e_ipspsp1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
G2E_D_J(g1, g0, envs->i_l+2, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g2, g0, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g3, g1, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g4, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g5, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g6, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g7, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[27];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 27; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g7[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g6[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g6[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g5[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g4[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g4[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g5[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g4[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g4[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g3[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g2[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g2[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g1[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g0[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g0[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g1[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g0[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g0[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g3[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g2[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g2[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g1[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g0[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g0[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g1[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g0[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g0[ix+i] * g0[iy+i] * g7[iz+i];
}
if (gout_empty) {
gout[n*12+0] = + s[11] - s[19];
gout[n*12+1] = + s[18] - s[2];
gout[n*12+2] = + s[1] - s[9];
gout[n*12+3] = + s[0] + s[10] + s[20];
gout[n*12+4] = + s[14] - s[22];
gout[n*12+5] = + s[21] - s[5];
gout[n*12+6] = + s[4] - s[12];
gout[n*12+7] = + s[3] + s[13] + s[23];
gout[n*12+8] = + s[17] - s[25];
gout[n*12+9] = + s[24] - s[8];
gout[n*12+10] = + s[7] - s[15];
gout[n*12+11] = + s[6] + s[16] + s[26];
} else {
gout[n*12+0] += + s[11] - s[19];
gout[n*12+1] += + s[18] - s[2];
gout[n*12+2] += + s[1] - s[9];
gout[n*12+3] += + s[0] + s[10] + s[20];
gout[n*12+4] += + s[14] - s[22];
gout[n*12+5] += + s[21] - s[5];
gout[n*12+6] += + s[4] - s[12];
gout[n*12+7] += + s[3] + s[13] + s[23];
gout[n*12+8] += + s[17] - s[25];
gout[n*12+9] += + s[24] - s[8];
gout[n*12+10] += + s[7] - s[15];
gout[n*12+11] += + s[6] + s[16] + s[26];
}}}
void int2e_ipspsp1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_ipspsp1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ipspsp1;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_ipspsp1_cart
int int2e_ipspsp1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ipspsp1;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_ipspsp1_sph
int int2e_ipspsp1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ipspsp1;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1, &c2s_sf_2e2);
} // int2e_ipspsp1_spinor
ALL_CINT(int2e_ipspsp1)
ALL_CINT_FORTRAN_(int2e_ipspsp1)
/* <SIGMA DOT P k NABLA i|R12 |j SIGMA DOT P l> : i,j \in electron 1; k,l \in electron 2
 * = (NABLA i j|R12 |SIGMA DOT P k SIGMA DOT P l) */
static void CINTgout2e_int2e_ip1spsp2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
G2E_D_L(g1, g0, envs->i_l+1, envs->j_l+0, envs->k_l+1, envs->l_l+0);
G2E_D_K(g2, g0, envs->i_l+1, envs->j_l+0, envs->k_l+0, envs->l_l);
G2E_D_K(g3, g1, envs->i_l+1, envs->j_l+0, envs->k_l+0, envs->l_l);
G2E_D_I(g4, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g5, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g6, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g7, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[27];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 27; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g7[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g6[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g6[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g5[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g4[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g4[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g5[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g4[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g4[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g3[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g2[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g2[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g1[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g0[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g0[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g1[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g0[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g0[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g3[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g2[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g2[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g1[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g0[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g0[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g1[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g0[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g0[ix+i] * g0[iy+i] * g7[iz+i];
}
if (gout_empty) {
gout[n*12+0] = + s[5] - s[7];
gout[n*12+1] = + s[6] - s[2];
gout[n*12+2] = + s[1] - s[3];
gout[n*12+3] = + s[0] + s[4] + s[8];
gout[n*12+4] = + s[14] - s[16];
gout[n*12+5] = + s[15] - s[11];
gout[n*12+6] = + s[10] - s[12];
gout[n*12+7] = + s[9] + s[13] + s[17];
gout[n*12+8] = + s[23] - s[25];
gout[n*12+9] = + s[24] - s[20];
gout[n*12+10] = + s[19] - s[21];
gout[n*12+11] = + s[18] + s[22] + s[26];
} else {
gout[n*12+0] += + s[5] - s[7];
gout[n*12+1] += + s[6] - s[2];
gout[n*12+2] += + s[1] - s[3];
gout[n*12+3] += + s[0] + s[4] + s[8];
gout[n*12+4] += + s[14] - s[16];
gout[n*12+5] += + s[15] - s[11];
gout[n*12+6] += + s[10] - s[12];
gout[n*12+7] += + s[9] + s[13] + s[17];
gout[n*12+8] += + s[23] - s[25];
gout[n*12+9] += + s[24] - s[20];
gout[n*12+10] += + s[19] - s[21];
gout[n*12+11] += + s[18] + s[22] + s[26];
}}}
void int2e_ip1spsp2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 0, 1, 1, 3, 1, 4, 3};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_ip1spsp2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 1, 1, 3, 1, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ip1spsp2;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_ip1spsp2_cart
int int2e_ip1spsp2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 1, 1, 3, 1, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ip1spsp2;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_ip1spsp2_sph
int int2e_ip1spsp2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 1, 1, 3, 1, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ip1spsp2;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_2e1, &c2s_si_2e2);
} // int2e_ip1spsp2_spinor
ALL_CINT(int2e_ip1spsp2)
ALL_CINT_FORTRAN_(int2e_ip1spsp2)
/* <SIGMA DOT P k NABLA SIGMA DOT P i|R12 |SIGMA DOT P j SIGMA DOT P l> : i,j \in electron 1; k,l \in electron 2
 * = (NABLA SIGMA DOT P i SIGMA DOT P j|R12 |SIGMA DOT P k SIGMA DOT P l) */
static void CINTgout2e_int2e_ipspsp1spsp2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double *g8 = g7 + envs->g_size * 3;
double *g9 = g8 + envs->g_size * 3;
double *g10 = g9 + envs->g_size * 3;
double *g11 = g10 + envs->g_size * 3;
double *g12 = g11 + envs->g_size * 3;
double *g13 = g12 + envs->g_size * 3;
double *g14 = g13 + envs->g_size * 3;
double *g15 = g14 + envs->g_size * 3;
double *g16 = g15 + envs->g_size * 3;
double *g17 = g16 + envs->g_size * 3;
double *g18 = g17 + envs->g_size * 3;
double *g19 = g18 + envs->g_size * 3;
double *g20 = g19 + envs->g_size * 3;
double *g21 = g20 + envs->g_size * 3;
double *g22 = g21 + envs->g_size * 3;
double *g23 = g22 + envs->g_size * 3;
double *g24 = g23 + envs->g_size * 3;
double *g25 = g24 + envs->g_size * 3;
double *g26 = g25 + envs->g_size * 3;
double *g27 = g26 + envs->g_size * 3;
double *g28 = g27 + envs->g_size * 3;
double *g29 = g28 + envs->g_size * 3;
double *g30 = g29 + envs->g_size * 3;
double *g31 = g30 + envs->g_size * 3;
G2E_D_L(g1, g0, envs->i_l+2, envs->j_l+1, envs->k_l+1, envs->l_l+0);
G2E_D_K(g2, g0, envs->i_l+2, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_D_K(g3, g1, envs->i_l+2, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_D_J(g4, g0, envs->i_l+2, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g5, g1, envs->i_l+2, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g6, g2, envs->i_l+2, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g7, g3, envs->i_l+2, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g8, g0, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g9, g1, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g10, g2, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g11, g3, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g12, g4, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g13, g5, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g14, g6, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g15, g7, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g16, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g17, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g18, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g19, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g20, g4, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g21, g5, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g22, g6, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g23, g7, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g24, g8, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g25, g9, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g26, g10, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g27, g11, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g28, g12, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g29, g13, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g30, g14, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g31, g15, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[243];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 243; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g31[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g30[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g30[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g29[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g28[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g28[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g29[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g28[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g28[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g27[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g26[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g26[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g25[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g24[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g24[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g25[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g24[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g24[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g27[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g26[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g26[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g25[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g24[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g24[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g25[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g24[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g24[ix+i] * g0[iy+i] * g7[iz+i];
s[27] += g23[ix+i] * g8[iy+i] * g0[iz+i];
s[28] += g22[ix+i] * g9[iy+i] * g0[iz+i];
s[29] += g22[ix+i] * g8[iy+i] * g1[iz+i];
s[30] += g21[ix+i] * g10[iy+i] * g0[iz+i];
s[31] += g20[ix+i] * g11[iy+i] * g0[iz+i];
s[32] += g20[ix+i] * g10[iy+i] * g1[iz+i];
s[33] += g21[ix+i] * g8[iy+i] * g2[iz+i];
s[34] += g20[ix+i] * g9[iy+i] * g2[iz+i];
s[35] += g20[ix+i] * g8[iy+i] * g3[iz+i];
s[36] += g19[ix+i] * g12[iy+i] * g0[iz+i];
s[37] += g18[ix+i] * g13[iy+i] * g0[iz+i];
s[38] += g18[ix+i] * g12[iy+i] * g1[iz+i];
s[39] += g17[ix+i] * g14[iy+i] * g0[iz+i];
s[40] += g16[ix+i] * g15[iy+i] * g0[iz+i];
s[41] += g16[ix+i] * g14[iy+i] * g1[iz+i];
s[42] += g17[ix+i] * g12[iy+i] * g2[iz+i];
s[43] += g16[ix+i] * g13[iy+i] * g2[iz+i];
s[44] += g16[ix+i] * g12[iy+i] * g3[iz+i];
s[45] += g19[ix+i] * g8[iy+i] * g4[iz+i];
s[46] += g18[ix+i] * g9[iy+i] * g4[iz+i];
s[47] += g18[ix+i] * g8[iy+i] * g5[iz+i];
s[48] += g17[ix+i] * g10[iy+i] * g4[iz+i];
s[49] += g16[ix+i] * g11[iy+i] * g4[iz+i];
s[50] += g16[ix+i] * g10[iy+i] * g5[iz+i];
s[51] += g17[ix+i] * g8[iy+i] * g6[iz+i];
s[52] += g16[ix+i] * g9[iy+i] * g6[iz+i];
s[53] += g16[ix+i] * g8[iy+i] * g7[iz+i];
s[54] += g23[ix+i] * g0[iy+i] * g8[iz+i];
s[55] += g22[ix+i] * g1[iy+i] * g8[iz+i];
s[56] += g22[ix+i] * g0[iy+i] * g9[iz+i];
s[57] += g21[ix+i] * g2[iy+i] * g8[iz+i];
s[58] += g20[ix+i] * g3[iy+i] * g8[iz+i];
s[59] += g20[ix+i] * g2[iy+i] * g9[iz+i];
s[60] += g21[ix+i] * g0[iy+i] * g10[iz+i];
s[61] += g20[ix+i] * g1[iy+i] * g10[iz+i];
s[62] += g20[ix+i] * g0[iy+i] * g11[iz+i];
s[63] += g19[ix+i] * g4[iy+i] * g8[iz+i];
s[64] += g18[ix+i] * g5[iy+i] * g8[iz+i];
s[65] += g18[ix+i] * g4[iy+i] * g9[iz+i];
s[66] += g17[ix+i] * g6[iy+i] * g8[iz+i];
s[67] += g16[ix+i] * g7[iy+i] * g8[iz+i];
s[68] += g16[ix+i] * g6[iy+i] * g9[iz+i];
s[69] += g17[ix+i] * g4[iy+i] * g10[iz+i];
s[70] += g16[ix+i] * g5[iy+i] * g10[iz+i];
s[71] += g16[ix+i] * g4[iy+i] * g11[iz+i];
s[72] += g19[ix+i] * g0[iy+i] * g12[iz+i];
s[73] += g18[ix+i] * g1[iy+i] * g12[iz+i];
s[74] += g18[ix+i] * g0[iy+i] * g13[iz+i];
s[75] += g17[ix+i] * g2[iy+i] * g12[iz+i];
s[76] += g16[ix+i] * g3[iy+i] * g12[iz+i];
s[77] += g16[ix+i] * g2[iy+i] * g13[iz+i];
s[78] += g17[ix+i] * g0[iy+i] * g14[iz+i];
s[79] += g16[ix+i] * g1[iy+i] * g14[iz+i];
s[80] += g16[ix+i] * g0[iy+i] * g15[iz+i];
s[81] += g15[ix+i] * g16[iy+i] * g0[iz+i];
s[82] += g14[ix+i] * g17[iy+i] * g0[iz+i];
s[83] += g14[ix+i] * g16[iy+i] * g1[iz+i];
s[84] += g13[ix+i] * g18[iy+i] * g0[iz+i];
s[85] += g12[ix+i] * g19[iy+i] * g0[iz+i];
s[86] += g12[ix+i] * g18[iy+i] * g1[iz+i];
s[87] += g13[ix+i] * g16[iy+i] * g2[iz+i];
s[88] += g12[ix+i] * g17[iy+i] * g2[iz+i];
s[89] += g12[ix+i] * g16[iy+i] * g3[iz+i];
s[90] += g11[ix+i] * g20[iy+i] * g0[iz+i];
s[91] += g10[ix+i] * g21[iy+i] * g0[iz+i];
s[92] += g10[ix+i] * g20[iy+i] * g1[iz+i];
s[93] += g9[ix+i] * g22[iy+i] * g0[iz+i];
s[94] += g8[ix+i] * g23[iy+i] * g0[iz+i];
s[95] += g8[ix+i] * g22[iy+i] * g1[iz+i];
s[96] += g9[ix+i] * g20[iy+i] * g2[iz+i];
s[97] += g8[ix+i] * g21[iy+i] * g2[iz+i];
s[98] += g8[ix+i] * g20[iy+i] * g3[iz+i];
s[99] += g11[ix+i] * g16[iy+i] * g4[iz+i];
s[100] += g10[ix+i] * g17[iy+i] * g4[iz+i];
s[101] += g10[ix+i] * g16[iy+i] * g5[iz+i];
s[102] += g9[ix+i] * g18[iy+i] * g4[iz+i];
s[103] += g8[ix+i] * g19[iy+i] * g4[iz+i];
s[104] += g8[ix+i] * g18[iy+i] * g5[iz+i];
s[105] += g9[ix+i] * g16[iy+i] * g6[iz+i];
s[106] += g8[ix+i] * g17[iy+i] * g6[iz+i];
s[107] += g8[ix+i] * g16[iy+i] * g7[iz+i];
s[108] += g7[ix+i] * g24[iy+i] * g0[iz+i];
s[109] += g6[ix+i] * g25[iy+i] * g0[iz+i];
s[110] += g6[ix+i] * g24[iy+i] * g1[iz+i];
s[111] += g5[ix+i] * g26[iy+i] * g0[iz+i];
s[112] += g4[ix+i] * g27[iy+i] * g0[iz+i];
s[113] += g4[ix+i] * g26[iy+i] * g1[iz+i];
s[114] += g5[ix+i] * g24[iy+i] * g2[iz+i];
s[115] += g4[ix+i] * g25[iy+i] * g2[iz+i];
s[116] += g4[ix+i] * g24[iy+i] * g3[iz+i];
s[117] += g3[ix+i] * g28[iy+i] * g0[iz+i];
s[118] += g2[ix+i] * g29[iy+i] * g0[iz+i];
s[119] += g2[ix+i] * g28[iy+i] * g1[iz+i];
s[120] += g1[ix+i] * g30[iy+i] * g0[iz+i];
s[121] += g0[ix+i] * g31[iy+i] * g0[iz+i];
s[122] += g0[ix+i] * g30[iy+i] * g1[iz+i];
s[123] += g1[ix+i] * g28[iy+i] * g2[iz+i];
s[124] += g0[ix+i] * g29[iy+i] * g2[iz+i];
s[125] += g0[ix+i] * g28[iy+i] * g3[iz+i];
s[126] += g3[ix+i] * g24[iy+i] * g4[iz+i];
s[127] += g2[ix+i] * g25[iy+i] * g4[iz+i];
s[128] += g2[ix+i] * g24[iy+i] * g5[iz+i];
s[129] += g1[ix+i] * g26[iy+i] * g4[iz+i];
s[130] += g0[ix+i] * g27[iy+i] * g4[iz+i];
s[131] += g0[ix+i] * g26[iy+i] * g5[iz+i];
s[132] += g1[ix+i] * g24[iy+i] * g6[iz+i];
s[133] += g0[ix+i] * g25[iy+i] * g6[iz+i];
s[134] += g0[ix+i] * g24[iy+i] * g7[iz+i];
s[135] += g7[ix+i] * g16[iy+i] * g8[iz+i];
s[136] += g6[ix+i] * g17[iy+i] * g8[iz+i];
s[137] += g6[ix+i] * g16[iy+i] * g9[iz+i];
s[138] += g5[ix+i] * g18[iy+i] * g8[iz+i];
s[139] += g4[ix+i] * g19[iy+i] * g8[iz+i];
s[140] += g4[ix+i] * g18[iy+i] * g9[iz+i];
s[141] += g5[ix+i] * g16[iy+i] * g10[iz+i];
s[142] += g4[ix+i] * g17[iy+i] * g10[iz+i];
s[143] += g4[ix+i] * g16[iy+i] * g11[iz+i];
s[144] += g3[ix+i] * g20[iy+i] * g8[iz+i];
s[145] += g2[ix+i] * g21[iy+i] * g8[iz+i];
s[146] += g2[ix+i] * g20[iy+i] * g9[iz+i];
s[147] += g1[ix+i] * g22[iy+i] * g8[iz+i];
s[148] += g0[ix+i] * g23[iy+i] * g8[iz+i];
s[149] += g0[ix+i] * g22[iy+i] * g9[iz+i];
s[150] += g1[ix+i] * g20[iy+i] * g10[iz+i];
s[151] += g0[ix+i] * g21[iy+i] * g10[iz+i];
s[152] += g0[ix+i] * g20[iy+i] * g11[iz+i];
s[153] += g3[ix+i] * g16[iy+i] * g12[iz+i];
s[154] += g2[ix+i] * g17[iy+i] * g12[iz+i];
s[155] += g2[ix+i] * g16[iy+i] * g13[iz+i];
s[156] += g1[ix+i] * g18[iy+i] * g12[iz+i];
s[157] += g0[ix+i] * g19[iy+i] * g12[iz+i];
s[158] += g0[ix+i] * g18[iy+i] * g13[iz+i];
s[159] += g1[ix+i] * g16[iy+i] * g14[iz+i];
s[160] += g0[ix+i] * g17[iy+i] * g14[iz+i];
s[161] += g0[ix+i] * g16[iy+i] * g15[iz+i];
s[162] += g15[ix+i] * g0[iy+i] * g16[iz+i];
s[163] += g14[ix+i] * g1[iy+i] * g16[iz+i];
s[164] += g14[ix+i] * g0[iy+i] * g17[iz+i];
s[165] += g13[ix+i] * g2[iy+i] * g16[iz+i];
s[166] += g12[ix+i] * g3[iy+i] * g16[iz+i];
s[167] += g12[ix+i] * g2[iy+i] * g17[iz+i];
s[168] += g13[ix+i] * g0[iy+i] * g18[iz+i];
s[169] += g12[ix+i] * g1[iy+i] * g18[iz+i];
s[170] += g12[ix+i] * g0[iy+i] * g19[iz+i];
s[171] += g11[ix+i] * g4[iy+i] * g16[iz+i];
s[172] += g10[ix+i] * g5[iy+i] * g16[iz+i];
s[173] += g10[ix+i] * g4[iy+i] * g17[iz+i];
s[174] += g9[ix+i] * g6[iy+i] * g16[iz+i];
s[175] += g8[ix+i] * g7[iy+i] * g16[iz+i];
s[176] += g8[ix+i] * g6[iy+i] * g17[iz+i];
s[177] += g9[ix+i] * g4[iy+i] * g18[iz+i];
s[178] += g8[ix+i] * g5[iy+i] * g18[iz+i];
s[179] += g8[ix+i] * g4[iy+i] * g19[iz+i];
s[180] += g11[ix+i] * g0[iy+i] * g20[iz+i];
s[181] += g10[ix+i] * g1[iy+i] * g20[iz+i];
s[182] += g10[ix+i] * g0[iy+i] * g21[iz+i];
s[183] += g9[ix+i] * g2[iy+i] * g20[iz+i];
s[184] += g8[ix+i] * g3[iy+i] * g20[iz+i];
s[185] += g8[ix+i] * g2[iy+i] * g21[iz+i];
s[186] += g9[ix+i] * g0[iy+i] * g22[iz+i];
s[187] += g8[ix+i] * g1[iy+i] * g22[iz+i];
s[188] += g8[ix+i] * g0[iy+i] * g23[iz+i];
s[189] += g7[ix+i] * g8[iy+i] * g16[iz+i];
s[190] += g6[ix+i] * g9[iy+i] * g16[iz+i];
s[191] += g6[ix+i] * g8[iy+i] * g17[iz+i];
s[192] += g5[ix+i] * g10[iy+i] * g16[iz+i];
s[193] += g4[ix+i] * g11[iy+i] * g16[iz+i];
s[194] += g4[ix+i] * g10[iy+i] * g17[iz+i];
s[195] += g5[ix+i] * g8[iy+i] * g18[iz+i];
s[196] += g4[ix+i] * g9[iy+i] * g18[iz+i];
s[197] += g4[ix+i] * g8[iy+i] * g19[iz+i];
s[198] += g3[ix+i] * g12[iy+i] * g16[iz+i];
s[199] += g2[ix+i] * g13[iy+i] * g16[iz+i];
s[200] += g2[ix+i] * g12[iy+i] * g17[iz+i];
s[201] += g1[ix+i] * g14[iy+i] * g16[iz+i];
s[202] += g0[ix+i] * g15[iy+i] * g16[iz+i];
s[203] += g0[ix+i] * g14[iy+i] * g17[iz+i];
s[204] += g1[ix+i] * g12[iy+i] * g18[iz+i];
s[205] += g0[ix+i] * g13[iy+i] * g18[iz+i];
s[206] += g0[ix+i] * g12[iy+i] * g19[iz+i];
s[207] += g3[ix+i] * g8[iy+i] * g20[iz+i];
s[208] += g2[ix+i] * g9[iy+i] * g20[iz+i];
s[209] += g2[ix+i] * g8[iy+i] * g21[iz+i];
s[210] += g1[ix+i] * g10[iy+i] * g20[iz+i];
s[211] += g0[ix+i] * g11[iy+i] * g20[iz+i];
s[212] += g0[ix+i] * g10[iy+i] * g21[iz+i];
s[213] += g1[ix+i] * g8[iy+i] * g22[iz+i];
s[214] += g0[ix+i] * g9[iy+i] * g22[iz+i];
s[215] += g0[ix+i] * g8[iy+i] * g23[iz+i];
s[216] += g7[ix+i] * g0[iy+i] * g24[iz+i];
s[217] += g6[ix+i] * g1[iy+i] * g24[iz+i];
s[218] += g6[ix+i] * g0[iy+i] * g25[iz+i];
s[219] += g5[ix+i] * g2[iy+i] * g24[iz+i];
s[220] += g4[ix+i] * g3[iy+i] * g24[iz+i];
s[221] += g4[ix+i] * g2[iy+i] * g25[iz+i];
s[222] += g5[ix+i] * g0[iy+i] * g26[iz+i];
s[223] += g4[ix+i] * g1[iy+i] * g26[iz+i];
s[224] += g4[ix+i] * g0[iy+i] * g27[iz+i];
s[225] += g3[ix+i] * g4[iy+i] * g24[iz+i];
s[226] += g2[ix+i] * g5[iy+i] * g24[iz+i];
s[227] += g2[ix+i] * g4[iy+i] * g25[iz+i];
s[228] += g1[ix+i] * g6[iy+i] * g24[iz+i];
s[229] += g0[ix+i] * g7[iy+i] * g24[iz+i];
s[230] += g0[ix+i] * g6[iy+i] * g25[iz+i];
s[231] += g1[ix+i] * g4[iy+i] * g26[iz+i];
s[232] += g0[ix+i] * g5[iy+i] * g26[iz+i];
s[233] += g0[ix+i] * g4[iy+i] * g27[iz+i];
s[234] += g3[ix+i] * g0[iy+i] * g28[iz+i];
s[235] += g2[ix+i] * g1[iy+i] * g28[iz+i];
s[236] += g2[ix+i] * g0[iy+i] * g29[iz+i];
s[237] += g1[ix+i] * g2[iy+i] * g28[iz+i];
s[238] += g0[ix+i] * g3[iy+i] * g28[iz+i];
s[239] += g0[ix+i] * g2[iy+i] * g29[iz+i];
s[240] += g1[ix+i] * g0[iy+i] * g30[iz+i];
s[241] += g0[ix+i] * g1[iy+i] * g30[iz+i];
s[242] += g0[ix+i] * g0[iy+i] * g31[iz+i];
}
if (gout_empty) {
gout[n*48+0] = + s[104] - s[176] - s[106] + s[178];
gout[n*48+1] = + s[167] - s[23] - s[169] + s[25];
gout[n*48+2] = + s[14] - s[86] - s[16] + s[88];
gout[n*48+3] = + s[5] + s[95] + s[185] - s[7] - s[97] - s[187];
gout[n*48+4] = + s[105] - s[177] - s[101] + s[173];
gout[n*48+5] = + s[168] - s[24] - s[164] + s[20];
gout[n*48+6] = + s[15] - s[87] - s[11] + s[83];
gout[n*48+7] = + s[6] + s[96] + s[186] - s[2] - s[92] - s[182];
gout[n*48+8] = + s[100] - s[172] - s[102] + s[174];
gout[n*48+9] = + s[163] - s[19] - s[165] + s[21];
gout[n*48+10] = + s[10] - s[82] - s[12] + s[84];
gout[n*48+11] = + s[1] + s[91] + s[181] - s[3] - s[93] - s[183];
gout[n*48+12] = + s[99] - s[171] + s[103] - s[175] + s[107] - s[179];
gout[n*48+13] = + s[162] - s[18] + s[166] - s[22] + s[170] - s[26];
gout[n*48+14] = + s[9] - s[81] + s[13] - s[85] + s[17] - s[89];
gout[n*48+15] = + s[0] + s[90] + s[180] + s[4] + s[94] + s[184] + s[8] + s[98] + s[188];
gout[n*48+16] = + s[131] - s[203] - s[133] + s[205];
gout[n*48+17] = + s[194] - s[50] - s[196] + s[52];
gout[n*48+18] = + s[41] - s[113] - s[43] + s[115];
gout[n*48+19] = + s[32] + s[122] + s[212] - s[34] - s[124] - s[214];
gout[n*48+20] = + s[132] - s[204] - s[128] + s[200];
gout[n*48+21] = + s[195] - s[51] - s[191] + s[47];
gout[n*48+22] = + s[42] - s[114] - s[38] + s[110];
gout[n*48+23] = + s[33] + s[123] + s[213] - s[29] - s[119] - s[209];
gout[n*48+24] = + s[127] - s[199] - s[129] + s[201];
gout[n*48+25] = + s[190] - s[46] - s[192] + s[48];
gout[n*48+26] = + s[37] - s[109] - s[39] + s[111];
gout[n*48+27] = + s[28] + s[118] + s[208] - s[30] - s[120] - s[210];
gout[n*48+28] = + s[126] - s[198] + s[130] - s[202] + s[134] - s[206];
gout[n*48+29] = + s[189] - s[45] + s[193] - s[49] + s[197] - s[53];
gout[n*48+30] = + s[36] - s[108] + s[40] - s[112] + s[44] - s[116];
gout[n*48+31] = + s[27] + s[117] + s[207] + s[31] + s[121] + s[211] + s[35] + s[125] + s[215];
gout[n*48+32] = + s[158] - s[230] - s[160] + s[232];
gout[n*48+33] = + s[221] - s[77] - s[223] + s[79];
gout[n*48+34] = + s[68] - s[140] - s[70] + s[142];
gout[n*48+35] = + s[59] + s[149] + s[239] - s[61] - s[151] - s[241];
gout[n*48+36] = + s[159] - s[231] - s[155] + s[227];
gout[n*48+37] = + s[222] - s[78] - s[218] + s[74];
gout[n*48+38] = + s[69] - s[141] - s[65] + s[137];
gout[n*48+39] = + s[60] + s[150] + s[240] - s[56] - s[146] - s[236];
gout[n*48+40] = + s[154] - s[226] - s[156] + s[228];
gout[n*48+41] = + s[217] - s[73] - s[219] + s[75];
gout[n*48+42] = + s[64] - s[136] - s[66] + s[138];
gout[n*48+43] = + s[55] + s[145] + s[235] - s[57] - s[147] - s[237];
gout[n*48+44] = + s[153] - s[225] + s[157] - s[229] + s[161] - s[233];
gout[n*48+45] = + s[216] - s[72] + s[220] - s[76] + s[224] - s[80];
gout[n*48+46] = + s[63] - s[135] + s[67] - s[139] + s[71] - s[143];
gout[n*48+47] = + s[54] + s[144] + s[234] + s[58] + s[148] + s[238] + s[62] + s[152] + s[242];
} else {
gout[n*48+0] += + s[104] - s[176] - s[106] + s[178];
gout[n*48+1] += + s[167] - s[23] - s[169] + s[25];
gout[n*48+2] += + s[14] - s[86] - s[16] + s[88];
gout[n*48+3] += + s[5] + s[95] + s[185] - s[7] - s[97] - s[187];
gout[n*48+4] += + s[105] - s[177] - s[101] + s[173];
gout[n*48+5] += + s[168] - s[24] - s[164] + s[20];
gout[n*48+6] += + s[15] - s[87] - s[11] + s[83];
gout[n*48+7] += + s[6] + s[96] + s[186] - s[2] - s[92] - s[182];
gout[n*48+8] += + s[100] - s[172] - s[102] + s[174];
gout[n*48+9] += + s[163] - s[19] - s[165] + s[21];
gout[n*48+10] += + s[10] - s[82] - s[12] + s[84];
gout[n*48+11] += + s[1] + s[91] + s[181] - s[3] - s[93] - s[183];
gout[n*48+12] += + s[99] - s[171] + s[103] - s[175] + s[107] - s[179];
gout[n*48+13] += + s[162] - s[18] + s[166] - s[22] + s[170] - s[26];
gout[n*48+14] += + s[9] - s[81] + s[13] - s[85] + s[17] - s[89];
gout[n*48+15] += + s[0] + s[90] + s[180] + s[4] + s[94] + s[184] + s[8] + s[98] + s[188];
gout[n*48+16] += + s[131] - s[203] - s[133] + s[205];
gout[n*48+17] += + s[194] - s[50] - s[196] + s[52];
gout[n*48+18] += + s[41] - s[113] - s[43] + s[115];
gout[n*48+19] += + s[32] + s[122] + s[212] - s[34] - s[124] - s[214];
gout[n*48+20] += + s[132] - s[204] - s[128] + s[200];
gout[n*48+21] += + s[195] - s[51] - s[191] + s[47];
gout[n*48+22] += + s[42] - s[114] - s[38] + s[110];
gout[n*48+23] += + s[33] + s[123] + s[213] - s[29] - s[119] - s[209];
gout[n*48+24] += + s[127] - s[199] - s[129] + s[201];
gout[n*48+25] += + s[190] - s[46] - s[192] + s[48];
gout[n*48+26] += + s[37] - s[109] - s[39] + s[111];
gout[n*48+27] += + s[28] + s[118] + s[208] - s[30] - s[120] - s[210];
gout[n*48+28] += + s[126] - s[198] + s[130] - s[202] + s[134] - s[206];
gout[n*48+29] += + s[189] - s[45] + s[193] - s[49] + s[197] - s[53];
gout[n*48+30] += + s[36] - s[108] + s[40] - s[112] + s[44] - s[116];
gout[n*48+31] += + s[27] + s[117] + s[207] + s[31] + s[121] + s[211] + s[35] + s[125] + s[215];
gout[n*48+32] += + s[158] - s[230] - s[160] + s[232];
gout[n*48+33] += + s[221] - s[77] - s[223] + s[79];
gout[n*48+34] += + s[68] - s[140] - s[70] + s[142];
gout[n*48+35] += + s[59] + s[149] + s[239] - s[61] - s[151] - s[241];
gout[n*48+36] += + s[159] - s[231] - s[155] + s[227];
gout[n*48+37] += + s[222] - s[78] - s[218] + s[74];
gout[n*48+38] += + s[69] - s[141] - s[65] + s[137];
gout[n*48+39] += + s[60] + s[150] + s[240] - s[56] - s[146] - s[236];
gout[n*48+40] += + s[154] - s[226] - s[156] + s[228];
gout[n*48+41] += + s[217] - s[73] - s[219] + s[75];
gout[n*48+42] += + s[64] - s[136] - s[66] + s[138];
gout[n*48+43] += + s[55] + s[145] + s[235] - s[57] - s[147] - s[237];
gout[n*48+44] += + s[153] - s[225] + s[157] - s[229] + s[161] - s[233];
gout[n*48+45] += + s[216] - s[72] + s[220] - s[76] + s[224] - s[80];
gout[n*48+46] += + s[63] - s[135] + s[67] - s[139] + s[71] - s[143];
gout[n*48+47] += + s[54] + s[144] + s[234] + s[58] + s[148] + s[238] + s[62] + s[152] + s[242];
}}}
void int2e_ipspsp1spsp2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {2, 1, 1, 1, 5, 4, 4, 3};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_ipspsp1spsp2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 1, 1, 5, 4, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ipspsp1spsp2;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_ipspsp1spsp2_cart
int int2e_ipspsp1spsp2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 1, 1, 5, 4, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ipspsp1spsp2;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_ipspsp1spsp2_sph
int int2e_ipspsp1spsp2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 1, 1, 5, 4, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ipspsp1spsp2;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1, &c2s_si_2e2);
} // int2e_ipspsp1spsp2_spinor
ALL_CINT(int2e_ipspsp1spsp2)
ALL_CINT_FORTRAN_(int2e_ipspsp1spsp2)
/* <k NABLA SIGMA DOT R i|R12 |SIGMA DOT R j l> : i,j \in electron 1; k,l \in electron 2
 * = (NABLA SIGMA DOT R i SIGMA DOT R j|R12 |k l) */
static void CINTgout2e_int2e_ipsrsr1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
G2E_R_J(g1, g0, envs->i_l+2, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g2, g0, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g3, g1, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g4, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g5, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g6, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g7, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[27];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 27; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g7[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g6[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g6[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g5[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g4[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g4[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g5[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g4[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g4[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g3[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g2[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g2[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g1[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g0[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g0[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g1[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g0[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g0[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g3[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g2[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g2[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g1[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g0[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g0[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g1[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g0[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g0[ix+i] * g0[iy+i] * g7[iz+i];
}
if (gout_empty) {
gout[n*12+0] = + s[11] - s[19];
gout[n*12+1] = + s[18] - s[2];
gout[n*12+2] = + s[1] - s[9];
gout[n*12+3] = + s[0] + s[10] + s[20];
gout[n*12+4] = + s[14] - s[22];
gout[n*12+5] = + s[21] - s[5];
gout[n*12+6] = + s[4] - s[12];
gout[n*12+7] = + s[3] + s[13] + s[23];
gout[n*12+8] = + s[17] - s[25];
gout[n*12+9] = + s[24] - s[8];
gout[n*12+10] = + s[7] - s[15];
gout[n*12+11] = + s[6] + s[16] + s[26];
} else {
gout[n*12+0] += + s[11] - s[19];
gout[n*12+1] += + s[18] - s[2];
gout[n*12+2] += + s[1] - s[9];
gout[n*12+3] += + s[0] + s[10] + s[20];
gout[n*12+4] += + s[14] - s[22];
gout[n*12+5] += + s[21] - s[5];
gout[n*12+6] += + s[4] - s[12];
gout[n*12+7] += + s[3] + s[13] + s[23];
gout[n*12+8] += + s[17] - s[25];
gout[n*12+9] += + s[24] - s[8];
gout[n*12+10] += + s[7] - s[15];
gout[n*12+11] += + s[6] + s[16] + s[26];
}}}
void int2e_ipsrsr1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_ipsrsr1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ipsrsr1;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_ipsrsr1_cart
int int2e_ipsrsr1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ipsrsr1;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_ipsrsr1_sph
int int2e_ipsrsr1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ipsrsr1;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1, &c2s_sf_2e2);
} // int2e_ipsrsr1_spinor
ALL_CINT(int2e_ipsrsr1)
ALL_CINT_FORTRAN_(int2e_ipsrsr1)
/* <SIGMA DOT R k NABLA i|R12 |j SIGMA DOT R l> : i,j \in electron 1; k,l \in electron 2
 * = (NABLA i j|R12 |SIGMA DOT R k SIGMA DOT R l) */
static void CINTgout2e_int2e_ip1srsr2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
G2E_R_L(g1, g0, envs->i_l+1, envs->j_l+0, envs->k_l+1, envs->l_l+0);
G2E_R_K(g2, g0, envs->i_l+1, envs->j_l+0, envs->k_l+0, envs->l_l);
G2E_R_K(g3, g1, envs->i_l+1, envs->j_l+0, envs->k_l+0, envs->l_l);
G2E_D_I(g4, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g5, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g6, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g7, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[27];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 27; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g7[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g6[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g6[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g5[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g4[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g4[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g5[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g4[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g4[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g3[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g2[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g2[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g1[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g0[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g0[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g1[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g0[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g0[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g3[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g2[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g2[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g1[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g0[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g0[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g1[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g0[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g0[ix+i] * g0[iy+i] * g7[iz+i];
}
if (gout_empty) {
gout[n*12+0] = + s[5] - s[7];
gout[n*12+1] = + s[6] - s[2];
gout[n*12+2] = + s[1] - s[3];
gout[n*12+3] = + s[0] + s[4] + s[8];
gout[n*12+4] = + s[14] - s[16];
gout[n*12+5] = + s[15] - s[11];
gout[n*12+6] = + s[10] - s[12];
gout[n*12+7] = + s[9] + s[13] + s[17];
gout[n*12+8] = + s[23] - s[25];
gout[n*12+9] = + s[24] - s[20];
gout[n*12+10] = + s[19] - s[21];
gout[n*12+11] = + s[18] + s[22] + s[26];
} else {
gout[n*12+0] += + s[5] - s[7];
gout[n*12+1] += + s[6] - s[2];
gout[n*12+2] += + s[1] - s[3];
gout[n*12+3] += + s[0] + s[4] + s[8];
gout[n*12+4] += + s[14] - s[16];
gout[n*12+5] += + s[15] - s[11];
gout[n*12+6] += + s[10] - s[12];
gout[n*12+7] += + s[9] + s[13] + s[17];
gout[n*12+8] += + s[23] - s[25];
gout[n*12+9] += + s[24] - s[20];
gout[n*12+10] += + s[19] - s[21];
gout[n*12+11] += + s[18] + s[22] + s[26];
}}}
void int2e_ip1srsr2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 0, 1, 1, 3, 1, 4, 3};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_ip1srsr2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 1, 1, 3, 1, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ip1srsr2;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_ip1srsr2_cart
int int2e_ip1srsr2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 1, 1, 3, 1, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ip1srsr2;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_ip1srsr2_sph
int int2e_ip1srsr2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 1, 1, 3, 1, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ip1srsr2;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_2e1, &c2s_si_2e2);
} // int2e_ip1srsr2_spinor
ALL_CINT(int2e_ip1srsr2)
ALL_CINT_FORTRAN_(int2e_ip1srsr2)
/* <SIGMA DOT R k NABLA SIGMA DOT R i|R12 |SIGMA DOT R j SIGMA DOT R l> : i,j \in electron 1; k,l \in electron 2
 * = (NABLA SIGMA DOT R i SIGMA DOT R j|R12 |SIGMA DOT R k SIGMA DOT R l) */
static void CINTgout2e_int2e_ipsrsr1srsr2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double *g8 = g7 + envs->g_size * 3;
double *g9 = g8 + envs->g_size * 3;
double *g10 = g9 + envs->g_size * 3;
double *g11 = g10 + envs->g_size * 3;
double *g12 = g11 + envs->g_size * 3;
double *g13 = g12 + envs->g_size * 3;
double *g14 = g13 + envs->g_size * 3;
double *g15 = g14 + envs->g_size * 3;
double *g16 = g15 + envs->g_size * 3;
double *g17 = g16 + envs->g_size * 3;
double *g18 = g17 + envs->g_size * 3;
double *g19 = g18 + envs->g_size * 3;
double *g20 = g19 + envs->g_size * 3;
double *g21 = g20 + envs->g_size * 3;
double *g22 = g21 + envs->g_size * 3;
double *g23 = g22 + envs->g_size * 3;
double *g24 = g23 + envs->g_size * 3;
double *g25 = g24 + envs->g_size * 3;
double *g26 = g25 + envs->g_size * 3;
double *g27 = g26 + envs->g_size * 3;
double *g28 = g27 + envs->g_size * 3;
double *g29 = g28 + envs->g_size * 3;
double *g30 = g29 + envs->g_size * 3;
double *g31 = g30 + envs->g_size * 3;
G2E_R_L(g1, g0, envs->i_l+2, envs->j_l+1, envs->k_l+1, envs->l_l+0);
G2E_R_K(g2, g0, envs->i_l+2, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_R_K(g3, g1, envs->i_l+2, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_R_J(g4, g0, envs->i_l+2, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R_J(g5, g1, envs->i_l+2, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R_J(g6, g2, envs->i_l+2, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R_J(g7, g3, envs->i_l+2, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g8, g0, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g9, g1, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g10, g2, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g11, g3, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g12, g4, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g13, g5, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g14, g6, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g15, g7, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g16, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g17, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g18, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g19, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g20, g4, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g21, g5, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g22, g6, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g23, g7, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g24, g8, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g25, g9, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g26, g10, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g27, g11, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g28, g12, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g29, g13, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g30, g14, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g31, g15, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[243];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 243; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g31[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g30[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g30[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g29[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g28[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g28[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g29[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g28[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g28[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g27[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g26[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g26[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g25[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g24[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g24[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g25[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g24[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g24[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g27[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g26[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g26[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g25[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g24[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g24[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g25[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g24[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g24[ix+i] * g0[iy+i] * g7[iz+i];
s[27] += g23[ix+i] * g8[iy+i] * g0[iz+i];
s[28] += g22[ix+i] * g9[iy+i] * g0[iz+i];
s[29] += g22[ix+i] * g8[iy+i] * g1[iz+i];
s[30] += g21[ix+i] * g10[iy+i] * g0[iz+i];
s[31] += g20[ix+i] * g11[iy+i] * g0[iz+i];
s[32] += g20[ix+i] * g10[iy+i] * g1[iz+i];
s[33] += g21[ix+i] * g8[iy+i] * g2[iz+i];
s[34] += g20[ix+i] * g9[iy+i] * g2[iz+i];
s[35] += g20[ix+i] * g8[iy+i] * g3[iz+i];
s[36] += g19[ix+i] * g12[iy+i] * g0[iz+i];
s[37] += g18[ix+i] * g13[iy+i] * g0[iz+i];
s[38] += g18[ix+i] * g12[iy+i] * g1[iz+i];
s[39] += g17[ix+i] * g14[iy+i] * g0[iz+i];
s[40] += g16[ix+i] * g15[iy+i] * g0[iz+i];
s[41] += g16[ix+i] * g14[iy+i] * g1[iz+i];
s[42] += g17[ix+i] * g12[iy+i] * g2[iz+i];
s[43] += g16[ix+i] * g13[iy+i] * g2[iz+i];
s[44] += g16[ix+i] * g12[iy+i] * g3[iz+i];
s[45] += g19[ix+i] * g8[iy+i] * g4[iz+i];
s[46] += g18[ix+i] * g9[iy+i] * g4[iz+i];
s[47] += g18[ix+i] * g8[iy+i] * g5[iz+i];
s[48] += g17[ix+i] * g10[iy+i] * g4[iz+i];
s[49] += g16[ix+i] * g11[iy+i] * g4[iz+i];
s[50] += g16[ix+i] * g10[iy+i] * g5[iz+i];
s[51] += g17[ix+i] * g8[iy+i] * g6[iz+i];
s[52] += g16[ix+i] * g9[iy+i] * g6[iz+i];
s[53] += g16[ix+i] * g8[iy+i] * g7[iz+i];
s[54] += g23[ix+i] * g0[iy+i] * g8[iz+i];
s[55] += g22[ix+i] * g1[iy+i] * g8[iz+i];
s[56] += g22[ix+i] * g0[iy+i] * g9[iz+i];
s[57] += g21[ix+i] * g2[iy+i] * g8[iz+i];
s[58] += g20[ix+i] * g3[iy+i] * g8[iz+i];
s[59] += g20[ix+i] * g2[iy+i] * g9[iz+i];
s[60] += g21[ix+i] * g0[iy+i] * g10[iz+i];
s[61] += g20[ix+i] * g1[iy+i] * g10[iz+i];
s[62] += g20[ix+i] * g0[iy+i] * g11[iz+i];
s[63] += g19[ix+i] * g4[iy+i] * g8[iz+i];
s[64] += g18[ix+i] * g5[iy+i] * g8[iz+i];
s[65] += g18[ix+i] * g4[iy+i] * g9[iz+i];
s[66] += g17[ix+i] * g6[iy+i] * g8[iz+i];
s[67] += g16[ix+i] * g7[iy+i] * g8[iz+i];
s[68] += g16[ix+i] * g6[iy+i] * g9[iz+i];
s[69] += g17[ix+i] * g4[iy+i] * g10[iz+i];
s[70] += g16[ix+i] * g5[iy+i] * g10[iz+i];
s[71] += g16[ix+i] * g4[iy+i] * g11[iz+i];
s[72] += g19[ix+i] * g0[iy+i] * g12[iz+i];
s[73] += g18[ix+i] * g1[iy+i] * g12[iz+i];
s[74] += g18[ix+i] * g0[iy+i] * g13[iz+i];
s[75] += g17[ix+i] * g2[iy+i] * g12[iz+i];
s[76] += g16[ix+i] * g3[iy+i] * g12[iz+i];
s[77] += g16[ix+i] * g2[iy+i] * g13[iz+i];
s[78] += g17[ix+i] * g0[iy+i] * g14[iz+i];
s[79] += g16[ix+i] * g1[iy+i] * g14[iz+i];
s[80] += g16[ix+i] * g0[iy+i] * g15[iz+i];
s[81] += g15[ix+i] * g16[iy+i] * g0[iz+i];
s[82] += g14[ix+i] * g17[iy+i] * g0[iz+i];
s[83] += g14[ix+i] * g16[iy+i] * g1[iz+i];
s[84] += g13[ix+i] * g18[iy+i] * g0[iz+i];
s[85] += g12[ix+i] * g19[iy+i] * g0[iz+i];
s[86] += g12[ix+i] * g18[iy+i] * g1[iz+i];
s[87] += g13[ix+i] * g16[iy+i] * g2[iz+i];
s[88] += g12[ix+i] * g17[iy+i] * g2[iz+i];
s[89] += g12[ix+i] * g16[iy+i] * g3[iz+i];
s[90] += g11[ix+i] * g20[iy+i] * g0[iz+i];
s[91] += g10[ix+i] * g21[iy+i] * g0[iz+i];
s[92] += g10[ix+i] * g20[iy+i] * g1[iz+i];
s[93] += g9[ix+i] * g22[iy+i] * g0[iz+i];
s[94] += g8[ix+i] * g23[iy+i] * g0[iz+i];
s[95] += g8[ix+i] * g22[iy+i] * g1[iz+i];
s[96] += g9[ix+i] * g20[iy+i] * g2[iz+i];
s[97] += g8[ix+i] * g21[iy+i] * g2[iz+i];
s[98] += g8[ix+i] * g20[iy+i] * g3[iz+i];
s[99] += g11[ix+i] * g16[iy+i] * g4[iz+i];
s[100] += g10[ix+i] * g17[iy+i] * g4[iz+i];
s[101] += g10[ix+i] * g16[iy+i] * g5[iz+i];
s[102] += g9[ix+i] * g18[iy+i] * g4[iz+i];
s[103] += g8[ix+i] * g19[iy+i] * g4[iz+i];
s[104] += g8[ix+i] * g18[iy+i] * g5[iz+i];
s[105] += g9[ix+i] * g16[iy+i] * g6[iz+i];
s[106] += g8[ix+i] * g17[iy+i] * g6[iz+i];
s[107] += g8[ix+i] * g16[iy+i] * g7[iz+i];
s[108] += g7[ix+i] * g24[iy+i] * g0[iz+i];
s[109] += g6[ix+i] * g25[iy+i] * g0[iz+i];
s[110] += g6[ix+i] * g24[iy+i] * g1[iz+i];
s[111] += g5[ix+i] * g26[iy+i] * g0[iz+i];
s[112] += g4[ix+i] * g27[iy+i] * g0[iz+i];
s[113] += g4[ix+i] * g26[iy+i] * g1[iz+i];
s[114] += g5[ix+i] * g24[iy+i] * g2[iz+i];
s[115] += g4[ix+i] * g25[iy+i] * g2[iz+i];
s[116] += g4[ix+i] * g24[iy+i] * g3[iz+i];
s[117] += g3[ix+i] * g28[iy+i] * g0[iz+i];
s[118] += g2[ix+i] * g29[iy+i] * g0[iz+i];
s[119] += g2[ix+i] * g28[iy+i] * g1[iz+i];
s[120] += g1[ix+i] * g30[iy+i] * g0[iz+i];
s[121] += g0[ix+i] * g31[iy+i] * g0[iz+i];
s[122] += g0[ix+i] * g30[iy+i] * g1[iz+i];
s[123] += g1[ix+i] * g28[iy+i] * g2[iz+i];
s[124] += g0[ix+i] * g29[iy+i] * g2[iz+i];
s[125] += g0[ix+i] * g28[iy+i] * g3[iz+i];
s[126] += g3[ix+i] * g24[iy+i] * g4[iz+i];
s[127] += g2[ix+i] * g25[iy+i] * g4[iz+i];
s[128] += g2[ix+i] * g24[iy+i] * g5[iz+i];
s[129] += g1[ix+i] * g26[iy+i] * g4[iz+i];
s[130] += g0[ix+i] * g27[iy+i] * g4[iz+i];
s[131] += g0[ix+i] * g26[iy+i] * g5[iz+i];
s[132] += g1[ix+i] * g24[iy+i] * g6[iz+i];
s[133] += g0[ix+i] * g25[iy+i] * g6[iz+i];
s[134] += g0[ix+i] * g24[iy+i] * g7[iz+i];
s[135] += g7[ix+i] * g16[iy+i] * g8[iz+i];
s[136] += g6[ix+i] * g17[iy+i] * g8[iz+i];
s[137] += g6[ix+i] * g16[iy+i] * g9[iz+i];
s[138] += g5[ix+i] * g18[iy+i] * g8[iz+i];
s[139] += g4[ix+i] * g19[iy+i] * g8[iz+i];
s[140] += g4[ix+i] * g18[iy+i] * g9[iz+i];
s[141] += g5[ix+i] * g16[iy+i] * g10[iz+i];
s[142] += g4[ix+i] * g17[iy+i] * g10[iz+i];
s[143] += g4[ix+i] * g16[iy+i] * g11[iz+i];
s[144] += g3[ix+i] * g20[iy+i] * g8[iz+i];
s[145] += g2[ix+i] * g21[iy+i] * g8[iz+i];
s[146] += g2[ix+i] * g20[iy+i] * g9[iz+i];
s[147] += g1[ix+i] * g22[iy+i] * g8[iz+i];
s[148] += g0[ix+i] * g23[iy+i] * g8[iz+i];
s[149] += g0[ix+i] * g22[iy+i] * g9[iz+i];
s[150] += g1[ix+i] * g20[iy+i] * g10[iz+i];
s[151] += g0[ix+i] * g21[iy+i] * g10[iz+i];
s[152] += g0[ix+i] * g20[iy+i] * g11[iz+i];
s[153] += g3[ix+i] * g16[iy+i] * g12[iz+i];
s[154] += g2[ix+i] * g17[iy+i] * g12[iz+i];
s[155] += g2[ix+i] * g16[iy+i] * g13[iz+i];
s[156] += g1[ix+i] * g18[iy+i] * g12[iz+i];
s[157] += g0[ix+i] * g19[iy+i] * g12[iz+i];
s[158] += g0[ix+i] * g18[iy+i] * g13[iz+i];
s[159] += g1[ix+i] * g16[iy+i] * g14[iz+i];
s[160] += g0[ix+i] * g17[iy+i] * g14[iz+i];
s[161] += g0[ix+i] * g16[iy+i] * g15[iz+i];
s[162] += g15[ix+i] * g0[iy+i] * g16[iz+i];
s[163] += g14[ix+i] * g1[iy+i] * g16[iz+i];
s[164] += g14[ix+i] * g0[iy+i] * g17[iz+i];
s[165] += g13[ix+i] * g2[iy+i] * g16[iz+i];
s[166] += g12[ix+i] * g3[iy+i] * g16[iz+i];
s[167] += g12[ix+i] * g2[iy+i] * g17[iz+i];
s[168] += g13[ix+i] * g0[iy+i] * g18[iz+i];
s[169] += g12[ix+i] * g1[iy+i] * g18[iz+i];
s[170] += g12[ix+i] * g0[iy+i] * g19[iz+i];
s[171] += g11[ix+i] * g4[iy+i] * g16[iz+i];
s[172] += g10[ix+i] * g5[iy+i] * g16[iz+i];
s[173] += g10[ix+i] * g4[iy+i] * g17[iz+i];
s[174] += g9[ix+i] * g6[iy+i] * g16[iz+i];
s[175] += g8[ix+i] * g7[iy+i] * g16[iz+i];
s[176] += g8[ix+i] * g6[iy+i] * g17[iz+i];
s[177] += g9[ix+i] * g4[iy+i] * g18[iz+i];
s[178] += g8[ix+i] * g5[iy+i] * g18[iz+i];
s[179] += g8[ix+i] * g4[iy+i] * g19[iz+i];
s[180] += g11[ix+i] * g0[iy+i] * g20[iz+i];
s[181] += g10[ix+i] * g1[iy+i] * g20[iz+i];
s[182] += g10[ix+i] * g0[iy+i] * g21[iz+i];
s[183] += g9[ix+i] * g2[iy+i] * g20[iz+i];
s[184] += g8[ix+i] * g3[iy+i] * g20[iz+i];
s[185] += g8[ix+i] * g2[iy+i] * g21[iz+i];
s[186] += g9[ix+i] * g0[iy+i] * g22[iz+i];
s[187] += g8[ix+i] * g1[iy+i] * g22[iz+i];
s[188] += g8[ix+i] * g0[iy+i] * g23[iz+i];
s[189] += g7[ix+i] * g8[iy+i] * g16[iz+i];
s[190] += g6[ix+i] * g9[iy+i] * g16[iz+i];
s[191] += g6[ix+i] * g8[iy+i] * g17[iz+i];
s[192] += g5[ix+i] * g10[iy+i] * g16[iz+i];
s[193] += g4[ix+i] * g11[iy+i] * g16[iz+i];
s[194] += g4[ix+i] * g10[iy+i] * g17[iz+i];
s[195] += g5[ix+i] * g8[iy+i] * g18[iz+i];
s[196] += g4[ix+i] * g9[iy+i] * g18[iz+i];
s[197] += g4[ix+i] * g8[iy+i] * g19[iz+i];
s[198] += g3[ix+i] * g12[iy+i] * g16[iz+i];
s[199] += g2[ix+i] * g13[iy+i] * g16[iz+i];
s[200] += g2[ix+i] * g12[iy+i] * g17[iz+i];
s[201] += g1[ix+i] * g14[iy+i] * g16[iz+i];
s[202] += g0[ix+i] * g15[iy+i] * g16[iz+i];
s[203] += g0[ix+i] * g14[iy+i] * g17[iz+i];
s[204] += g1[ix+i] * g12[iy+i] * g18[iz+i];
s[205] += g0[ix+i] * g13[iy+i] * g18[iz+i];
s[206] += g0[ix+i] * g12[iy+i] * g19[iz+i];
s[207] += g3[ix+i] * g8[iy+i] * g20[iz+i];
s[208] += g2[ix+i] * g9[iy+i] * g20[iz+i];
s[209] += g2[ix+i] * g8[iy+i] * g21[iz+i];
s[210] += g1[ix+i] * g10[iy+i] * g20[iz+i];
s[211] += g0[ix+i] * g11[iy+i] * g20[iz+i];
s[212] += g0[ix+i] * g10[iy+i] * g21[iz+i];
s[213] += g1[ix+i] * g8[iy+i] * g22[iz+i];
s[214] += g0[ix+i] * g9[iy+i] * g22[iz+i];
s[215] += g0[ix+i] * g8[iy+i] * g23[iz+i];
s[216] += g7[ix+i] * g0[iy+i] * g24[iz+i];
s[217] += g6[ix+i] * g1[iy+i] * g24[iz+i];
s[218] += g6[ix+i] * g0[iy+i] * g25[iz+i];
s[219] += g5[ix+i] * g2[iy+i] * g24[iz+i];
s[220] += g4[ix+i] * g3[iy+i] * g24[iz+i];
s[221] += g4[ix+i] * g2[iy+i] * g25[iz+i];
s[222] += g5[ix+i] * g0[iy+i] * g26[iz+i];
s[223] += g4[ix+i] * g1[iy+i] * g26[iz+i];
s[224] += g4[ix+i] * g0[iy+i] * g27[iz+i];
s[225] += g3[ix+i] * g4[iy+i] * g24[iz+i];
s[226] += g2[ix+i] * g5[iy+i] * g24[iz+i];
s[227] += g2[ix+i] * g4[iy+i] * g25[iz+i];
s[228] += g1[ix+i] * g6[iy+i] * g24[iz+i];
s[229] += g0[ix+i] * g7[iy+i] * g24[iz+i];
s[230] += g0[ix+i] * g6[iy+i] * g25[iz+i];
s[231] += g1[ix+i] * g4[iy+i] * g26[iz+i];
s[232] += g0[ix+i] * g5[iy+i] * g26[iz+i];
s[233] += g0[ix+i] * g4[iy+i] * g27[iz+i];
s[234] += g3[ix+i] * g0[iy+i] * g28[iz+i];
s[235] += g2[ix+i] * g1[iy+i] * g28[iz+i];
s[236] += g2[ix+i] * g0[iy+i] * g29[iz+i];
s[237] += g1[ix+i] * g2[iy+i] * g28[iz+i];
s[238] += g0[ix+i] * g3[iy+i] * g28[iz+i];
s[239] += g0[ix+i] * g2[iy+i] * g29[iz+i];
s[240] += g1[ix+i] * g0[iy+i] * g30[iz+i];
s[241] += g0[ix+i] * g1[iy+i] * g30[iz+i];
s[242] += g0[ix+i] * g0[iy+i] * g31[iz+i];
}
if (gout_empty) {
gout[n*48+0] = + s[104] - s[176] - s[106] + s[178];
gout[n*48+1] = + s[167] - s[23] - s[169] + s[25];
gout[n*48+2] = + s[14] - s[86] - s[16] + s[88];
gout[n*48+3] = + s[5] + s[95] + s[185] - s[7] - s[97] - s[187];
gout[n*48+4] = + s[105] - s[177] - s[101] + s[173];
gout[n*48+5] = + s[168] - s[24] - s[164] + s[20];
gout[n*48+6] = + s[15] - s[87] - s[11] + s[83];
gout[n*48+7] = + s[6] + s[96] + s[186] - s[2] - s[92] - s[182];
gout[n*48+8] = + s[100] - s[172] - s[102] + s[174];
gout[n*48+9] = + s[163] - s[19] - s[165] + s[21];
gout[n*48+10] = + s[10] - s[82] - s[12] + s[84];
gout[n*48+11] = + s[1] + s[91] + s[181] - s[3] - s[93] - s[183];
gout[n*48+12] = + s[99] - s[171] + s[103] - s[175] + s[107] - s[179];
gout[n*48+13] = + s[162] - s[18] + s[166] - s[22] + s[170] - s[26];
gout[n*48+14] = + s[9] - s[81] + s[13] - s[85] + s[17] - s[89];
gout[n*48+15] = + s[0] + s[90] + s[180] + s[4] + s[94] + s[184] + s[8] + s[98] + s[188];
gout[n*48+16] = + s[131] - s[203] - s[133] + s[205];
gout[n*48+17] = + s[194] - s[50] - s[196] + s[52];
gout[n*48+18] = + s[41] - s[113] - s[43] + s[115];
gout[n*48+19] = + s[32] + s[122] + s[212] - s[34] - s[124] - s[214];
gout[n*48+20] = + s[132] - s[204] - s[128] + s[200];
gout[n*48+21] = + s[195] - s[51] - s[191] + s[47];
gout[n*48+22] = + s[42] - s[114] - s[38] + s[110];
gout[n*48+23] = + s[33] + s[123] + s[213] - s[29] - s[119] - s[209];
gout[n*48+24] = + s[127] - s[199] - s[129] + s[201];
gout[n*48+25] = + s[190] - s[46] - s[192] + s[48];
gout[n*48+26] = + s[37] - s[109] - s[39] + s[111];
gout[n*48+27] = + s[28] + s[118] + s[208] - s[30] - s[120] - s[210];
gout[n*48+28] = + s[126] - s[198] + s[130] - s[202] + s[134] - s[206];
gout[n*48+29] = + s[189] - s[45] + s[193] - s[49] + s[197] - s[53];
gout[n*48+30] = + s[36] - s[108] + s[40] - s[112] + s[44] - s[116];
gout[n*48+31] = + s[27] + s[117] + s[207] + s[31] + s[121] + s[211] + s[35] + s[125] + s[215];
gout[n*48+32] = + s[158] - s[230] - s[160] + s[232];
gout[n*48+33] = + s[221] - s[77] - s[223] + s[79];
gout[n*48+34] = + s[68] - s[140] - s[70] + s[142];
gout[n*48+35] = + s[59] + s[149] + s[239] - s[61] - s[151] - s[241];
gout[n*48+36] = + s[159] - s[231] - s[155] + s[227];
gout[n*48+37] = + s[222] - s[78] - s[218] + s[74];
gout[n*48+38] = + s[69] - s[141] - s[65] + s[137];
gout[n*48+39] = + s[60] + s[150] + s[240] - s[56] - s[146] - s[236];
gout[n*48+40] = + s[154] - s[226] - s[156] + s[228];
gout[n*48+41] = + s[217] - s[73] - s[219] + s[75];
gout[n*48+42] = + s[64] - s[136] - s[66] + s[138];
gout[n*48+43] = + s[55] + s[145] + s[235] - s[57] - s[147] - s[237];
gout[n*48+44] = + s[153] - s[225] + s[157] - s[229] + s[161] - s[233];
gout[n*48+45] = + s[216] - s[72] + s[220] - s[76] + s[224] - s[80];
gout[n*48+46] = + s[63] - s[135] + s[67] - s[139] + s[71] - s[143];
gout[n*48+47] = + s[54] + s[144] + s[234] + s[58] + s[148] + s[238] + s[62] + s[152] + s[242];
} else {
gout[n*48+0] += + s[104] - s[176] - s[106] + s[178];
gout[n*48+1] += + s[167] - s[23] - s[169] + s[25];
gout[n*48+2] += + s[14] - s[86] - s[16] + s[88];
gout[n*48+3] += + s[5] + s[95] + s[185] - s[7] - s[97] - s[187];
gout[n*48+4] += + s[105] - s[177] - s[101] + s[173];
gout[n*48+5] += + s[168] - s[24] - s[164] + s[20];
gout[n*48+6] += + s[15] - s[87] - s[11] + s[83];
gout[n*48+7] += + s[6] + s[96] + s[186] - s[2] - s[92] - s[182];
gout[n*48+8] += + s[100] - s[172] - s[102] + s[174];
gout[n*48+9] += + s[163] - s[19] - s[165] + s[21];
gout[n*48+10] += + s[10] - s[82] - s[12] + s[84];
gout[n*48+11] += + s[1] + s[91] + s[181] - s[3] - s[93] - s[183];
gout[n*48+12] += + s[99] - s[171] + s[103] - s[175] + s[107] - s[179];
gout[n*48+13] += + s[162] - s[18] + s[166] - s[22] + s[170] - s[26];
gout[n*48+14] += + s[9] - s[81] + s[13] - s[85] + s[17] - s[89];
gout[n*48+15] += + s[0] + s[90] + s[180] + s[4] + s[94] + s[184] + s[8] + s[98] + s[188];
gout[n*48+16] += + s[131] - s[203] - s[133] + s[205];
gout[n*48+17] += + s[194] - s[50] - s[196] + s[52];
gout[n*48+18] += + s[41] - s[113] - s[43] + s[115];
gout[n*48+19] += + s[32] + s[122] + s[212] - s[34] - s[124] - s[214];
gout[n*48+20] += + s[132] - s[204] - s[128] + s[200];
gout[n*48+21] += + s[195] - s[51] - s[191] + s[47];
gout[n*48+22] += + s[42] - s[114] - s[38] + s[110];
gout[n*48+23] += + s[33] + s[123] + s[213] - s[29] - s[119] - s[209];
gout[n*48+24] += + s[127] - s[199] - s[129] + s[201];
gout[n*48+25] += + s[190] - s[46] - s[192] + s[48];
gout[n*48+26] += + s[37] - s[109] - s[39] + s[111];
gout[n*48+27] += + s[28] + s[118] + s[208] - s[30] - s[120] - s[210];
gout[n*48+28] += + s[126] - s[198] + s[130] - s[202] + s[134] - s[206];
gout[n*48+29] += + s[189] - s[45] + s[193] - s[49] + s[197] - s[53];
gout[n*48+30] += + s[36] - s[108] + s[40] - s[112] + s[44] - s[116];
gout[n*48+31] += + s[27] + s[117] + s[207] + s[31] + s[121] + s[211] + s[35] + s[125] + s[215];
gout[n*48+32] += + s[158] - s[230] - s[160] + s[232];
gout[n*48+33] += + s[221] - s[77] - s[223] + s[79];
gout[n*48+34] += + s[68] - s[140] - s[70] + s[142];
gout[n*48+35] += + s[59] + s[149] + s[239] - s[61] - s[151] - s[241];
gout[n*48+36] += + s[159] - s[231] - s[155] + s[227];
gout[n*48+37] += + s[222] - s[78] - s[218] + s[74];
gout[n*48+38] += + s[69] - s[141] - s[65] + s[137];
gout[n*48+39] += + s[60] + s[150] + s[240] - s[56] - s[146] - s[236];
gout[n*48+40] += + s[154] - s[226] - s[156] + s[228];
gout[n*48+41] += + s[217] - s[73] - s[219] + s[75];
gout[n*48+42] += + s[64] - s[136] - s[66] + s[138];
gout[n*48+43] += + s[55] + s[145] + s[235] - s[57] - s[147] - s[237];
gout[n*48+44] += + s[153] - s[225] + s[157] - s[229] + s[161] - s[233];
gout[n*48+45] += + s[216] - s[72] + s[220] - s[76] + s[224] - s[80];
gout[n*48+46] += + s[63] - s[135] + s[67] - s[139] + s[71] - s[143];
gout[n*48+47] += + s[54] + s[144] + s[234] + s[58] + s[148] + s[238] + s[62] + s[152] + s[242];
}}}
void int2e_ipsrsr1srsr2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {2, 1, 1, 1, 5, 4, 4, 3};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_ipsrsr1srsr2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 1, 1, 5, 4, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ipsrsr1srsr2;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_ipsrsr1srsr2_cart
int int2e_ipsrsr1srsr2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 1, 1, 5, 4, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ipsrsr1srsr2;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_ipsrsr1srsr2_sph
int int2e_ipsrsr1srsr2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 1, 1, 5, 4, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_ipsrsr1srsr2;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1, &c2s_si_2e2);
} // int2e_ipsrsr1srsr2_spinor
ALL_CINT(int2e_ipsrsr1srsr2)
ALL_CINT_FORTRAN_(int2e_ipsrsr1srsr2)
