/*
 * Author: Qiming Sun <osirpt.sun@gmail.com>
 */

#include <stdlib.h>
#include <math.h>
#include <complex.h>
#include "cint.h"
#include "vhf/fblas.h"

//#define ATOM_OF         0
//#define ANG_OF          1
#define RADI_POWER      3
#define ECP_LMAX        4
//#define PTR_EXP         5
//#define PTR_COEFF       6
#define CART_MAX        128 // ~ lmax = 14
#define SIM_ZERO        1e-50
#define EXPCUTOFF       39   // 1e-17
#define CUTOFF          460  // ~ 1e200
#define CLOSE_ENOUGH(x, y)      (fabs(x-y) < 1e-10*fabs(y) || fabs(x-y) < 1e-10)
#define SQUARE(r)       (r[0]*r[0]+r[1]*r[1]+r[2]*r[2])
#define CART_CUM        (455+1) // upto l = 12
#define K_TAYLOR_MAX    7
#define K_TAB_COL       24      // >= (7*2+1+K_TAYLOR_MAX)
#define K_TAB_ENTRIES   400
#define K_TAB_INTERVAL  (16./K_TAB_ENTRIES)    // [0,16], interval 0.04
#define MAX(X,Y)        (X)>(Y)?(X):(Y)

// Held in env, to get *ecpbas, necpbas
#define PTR_ECPBAS_OFFSET       18
#define PTR_NECPBAS             19


// for radial grids
#define LEVEL0          5
//#define LEVEL_MAX       11      // 2047 points
#define LEVEL_MAX       11

double CINTcommon_fac_sp(int);

static double _sph_ine_tab[] = { // 400x24
9.802640211919197e-01, 6.534919212092035e-03, 2.613937811451498e-05, 7.468346329123935e-08, 1.659625812043017e-10, 3.017493035919202e-13, 4.642287455711235e-16, 6.189706898282851e-19, 7.281999097680386e-22, 7.665254523625293e-25, 7.300236357712470e-28, 6.348027199385843e-31, 5.078418750076879e-34, 3.761789744992798e-37, 2.594336600846831e-40, 1.673764894480139e-43, 1.014402615043443e-46, 5.796584581226479e-50, 3.133288094277013e-53, 1.606814005366913e-56, 7.838115320992611e-60, 3.645634279400473e-63, 1.620281595519583e-66, 6.894814102547425e-70,
9.423296940236874e-01, 1.884207224818979e-02, 2.260816141980705e-04, 1.937731683913445e-06, 1.291774150186003e-08, 7.045863444090539e-11, 3.251876940391953e-13, 1.300732413080320e-15, 4.590769115454675e-18, 1.449703482841226e-20, 4.141979079274455e-23, 1.080509516656789e-25, 2.593209009591830e-28, 5.762660193098549e-31, 1.192269748342981e-33, 2.307610747161589e-36, 4.195642826638227e-39, 7.192510565377163e-42, 1.166350154849031e-44, 1.794380813740386e-47, 2.625917780013486e-50, 3.664064504096460e-53, 4.885411023215048e-56, 6.236685174215352e-59,
9.063462346100909e-01, 3.019141928900223e-02, 6.036559400239012e-04, 8.622287807164008e-06, 9.579352242057132e-08, 8.707893125883569e-10, 6.698035852053903e-12, 4.465182134941749e-14, 2.626496412795802e-16, 1.382331888858186e-18, 6.582396524955082e-21, 2.861861761817600e-23, 1.144727746014053e-25, 4.239678246653739e-28, 1.461941754380445e-30, 4.715895044881049e-33, 1.429046731905972e-35, 4.082959134165019e-38, 1.103494821514312e-40, 2.829456206258353e-43, 6.901073554470799e-46, 1.604892532642074e-48, 3.566410987925639e-51, 7.588075536423757e-54,
8.722009233724092e-01, 4.064962396752648e-02, 1.137552639698620e-03, 2.274397829003244e-05, 3.537251969982054e-07, 4.501340147805141e-09, 4.847109923004117e-11, 4.523621584594117e-13, 3.725109389920223e-15, 2.744682624160316e-17, 1.829714169367008e-19, 1.113701098036058e-21, 6.236545062744792e-24, 3.233683163047443e-26, 1.561054390080907e-28, 7.049787985018583e-31, 2.990768393494177e-33, 1.196289251644110e-35, 4.526438390070580e-38, 1.624855402807172e-40, 5.548225060005377e-43, 1.806380559727397e-45, 5.619798551249213e-48, 1.673968300753623e-50,
8.397879831360249e-01, 5.027877721939270e-02, 1.808362812813033e-03, 4.647686347510318e-05, 9.292332256868268e-07, 1.520219076183037e-08, 2.104569083041292e-10, 2.525162087703369e-12, 2.673432884835239e-14, 2.532520256428454e-16, 2.170586052040690e-18, 1.698623809823192e-20, 1.222950443880237e-22, 8.152665619678108e-25, 5.060092852017936e-27, 2.938025380983860e-29, 1.602514346193933e-31, 8.241296164981470e-34, 4.009189198003429e-36, 1.850357521979083e-38, 8.123371541285905e-41, 3.400424173842929e-43, 1.360148833507746e-45, 5.209007356442930e-48,
8.090081339019514e-01, 5.913671199826918e-02, 2.598424834644346e-03, 8.160211998856853e-05, 1.993744098983762e-06, 3.986139377821739e-08, 6.744100728921062e-10, 9.889470956573337e-12, 1.279622166510847e-13, 1.481488080423163e-15, 1.551879635695967e-17, 1.484281679217320e-19, 1.306074233139604e-21, 1.064142859516303e-23, 8.072373323154131e-26, 5.728510053119174e-28, 3.818846680199104e-30, 2.400328205168628e-32, 1.427174308308297e-34, 8.050483194653290e-37, 4.319652884952700e-39, 2.209999687114206e-41, 1.080419567502579e-43, 5.057176802023883e-46,
7.797681769803957e-01, 6.727729617192950e-02, 3.491682688901381e-03, 1.295521545952391e-04, 3.740065183404311e-06, 8.835978508986519e-08, 1.766583448475031e-09, 3.061266611360877e-11, 4.680957668323452e-13, 6.404436109277377e-15, 7.928192361364623e-17, 8.961250982568824e-19, 9.318767845088264e-21, 8.972853685685055e-23, 8.044022614751631e-25, 6.746153851558893e-27, 5.314840467927241e-29, 3.947961127780111e-31, 2.774113001703102e-33, 1.849330487722149e-35, 1.172701198775740e-37, 7.090503732787043e-40, 4.096604557506365e-42, 2.266140260236755e-44,
7.519806065099561e-01, 7.475070512352422e-02, 4.473555274713588e-03, 1.914505449644170e-04, 6.375892210525950e-06, 1.737786486384450e-07, 4.008427116300951e-09, 8.014026540370688e-11, 1.413846115606957e-12, 2.231885264598680e-14, 3.187813611266366e-16, 4.157367122234428e-18, 4.988175533040940e-20, 5.541780336446298e-22, 5.732302392725156e-24, 5.546901453139527e-26, 5.042244809781671e-28, 4.321623796889308e-30, 3.503800774801065e-32, 2.695079679934517e-34, 1.971908861923835e-36, 1.375686386093325e-38, 9.170852340169328e-41, 5.853506792622323e-43,
7.255632465211918e-01, 8.160367547530310e-02, 5.530815856752632e-03, 2.681481701173305e-04, 1.011823668994520e-05, 3.124930305455487e-07, 8.168054648039442e-09, 1.850587087464627e-10, 3.699850401381123e-12, 6.618867740655736e-14, 1.071369838211224e-15, 1.583445821705979e-17, 2.153117630614553e-19, 2.710933129251171e-21, 3.177926797994465e-23, 3.485074323629212e-25, 3.590323325355264e-27, 3.487431373375834e-29, 3.204409977879080e-31, 2.793386250709058e-33, 2.316314775123981e-35, 1.831395301402106e-37, 1.383645271997669e-39, 1.000884640136975e-41,
7.004389118290668e-01, 8.787974125233637e-02, 6.651480889569160e-03, 3.602558632684483e-04, 1.518867146616316e-05, 5.241706487945403e-07, 1.531058000541370e-08, 3.876486093346255e-10, 8.661215889008114e-12, 1.731616684729988e-13, 3.132465358171466e-15, 5.174078457568593e-17, 7.862917483701786e-19, 1.106428817416875e-20, 1.449570476616633e-22, 1.776642094452763e-24, 2.045574577993796e-26, 2.220661949927553e-28, 2.280451657869560e-30, 2.221777914010818e-32, 2.059040163516108e-34, 1.819481118591509e-36, 1.536345836110685e-38, 1.242074078030305e-40,
6.765350911558576e-01, 9.361945371114844e-02, 7.824707504797336e-03, 4.681738921325179e-04, 2.180930258870306e-05, 8.316938031664069e-07, 2.684583910669537e-08, 7.511641496452160e-10, 1.854804793764511e-11, 4.098283595804409e-13, 8.193575672782376e-15, 1.495759413219887e-16, 2.512219435375146e-18, 3.907016870618316e-20, 5.657328347997245e-22, 7.663446202166263e-24, 9.751987792903223e-26, 1.170079170870446e-27, 1.328035649504993e-29, 1.430034493807493e-31, 1.464766837491307e-33, 1.430572088364921e-35, 1.335089272208570e-37, 1.192967128812958e-39,
6.537836509950933e-01, 9.886058597209520e-02, 9.040699003168024e-03, 5.921185463558279e-04, 3.019938470977199e-05, 1.261019425506075e-06, 4.457236071368571e-08, 1.365753162782863e-09, 3.693149250538184e-11, 8.936571491864001e-13, 1.956677811748755e-14, 3.911916489249546e-16, 7.195671239819596e-18, 1.225598043243590e-19, 1.943594694173485e-21, 2.883447429149476e-23, 4.018614857945507e-25, 5.280745363948835e-27, 6.564288540009260e-29, 7.741469848656017e-31, 8.684509313319550e-33, 9.289389581578651e-35, 9.494870612442851e-37, 9.291998410785926e-39,
6.321205588285578e-01, 1.036383235143269e-01, 1.029061774259589e-02, 7.321460883680680e-04, 4.057250544293857e-05, 1.840990395173499e-06, 7.071674912159513e-08, 2.354918012025038e-09, 6.920876084399665e-11, 1.820143329151406e-12, 4.331433624321587e-14, 9.412069363388704e-16, 1.881717162782282e-17, 3.483549477293463e-19, 6.004450438117013e-21, 9.682231855957900e-23, 1.466687423114293e-24, 2.094863403563336e-26, 2.830406199582482e-28, 3.628158722983189e-30, 4.423956555945650e-32, 5.143471077554361e-34, 5.714292488971905e-36, 6.078374796471110e-38,
6.114856244028342e-01, 1.079854415178434e-01, 1.156650485925946e-02, 8.881743024780179e-04, 5.313427158145224e-05, 2.603109453813832e-06, 1.079678926519672e-07, 3.882408488694344e-09, 1.232124104576527e-10, 3.499270583056130e-12, 8.992697975180006e-14, 2.110259375015334e-15, 4.556192707286104e-17, 9.108994199153757e-19, 1.695607709223078e-20, 2.952797770562511e-22, 4.830631594144867e-24, 7.451296962019681e-26, 1.087266909887928e-27, 1.505172046838923e-29, 1.982093931505646e-31, 2.488766216723909e-33, 2.986107810512032e-35, 3.430412972161793e-37,
5.918222578598231e-01, 1.119324699680684e-01, 1.286120630084882e-02, 1.060001857302613e-03, 6.808043685177060e-05, 3.581285464793354e-06, 1.595056229311132e-07, 6.159433578748354e-09, 2.099269290005269e-10, 6.402901146704448e-12, 1.767190222777191e-13, 4.453788373237586e-15, 1.032764424354891e-16, 2.217578604434540e-18, 4.433498767431274e-20, 8.292207189026603e-22, 1.456993986020573e-23, 2.413820288857954e-25, 3.782944683593620e-27, 5.624734620245826e-29, 7.955423938391327e-31, 1.072870693336584e-32, 1.382591240785306e-34, 1.705927272952057e-36,
5.730772435975399e-01, 1.155078473741702e-01, 1.416830469026474e-02, 1.247325678486786e-03, 8.559541702683246e-05, 4.811560355346477e-06, 2.290236255239660e-07, 9.452078231060181e-09, 3.443134821874354e-10, 1.122468721114226e-11, 3.311321685597624e-13, 8.920211537400009e-15, 2.210953981490762e-16, 5.074515259838354e-18, 1.084432851478003e-19, 2.168051312210924e-21, 4.071953725407970e-23, 7.211035260361866e-25, 1.208013913366905e-26, 1.919970914203807e-28, 2.902737870906804e-30, 4.184511847918588e-32, 5.764279955245770e-34, 7.602674982708987e-36,
5.552005288137498e-01, 1.187380638926901e-01, 1.548205657424927e-02, 1.449756512013810e-03, 1.058511437997683e-04, 6.331823835150759e-06, 3.207465472556373e-07, 1.408881344881271e-08, 5.462416008028229e-10, 1.895403419454607e-11, 5.951618689207405e-13, 1.706563797705505e-14, 4.502424476095938e-16, 1.099981002498531e-17, 2.502193147402336e-19, 5.324983368983020e-21, 1.064595304250064e-22, 2.006847732699146e-24, 3.578702429411037e-26, 6.054616656852117e-28, 9.744049075136297e-30, 1.495261691688425e-31, 2.192598984437593e-33, 3.078386627927686e-35,
5.381450257559952e-01, 1.216477945925827e-01, 1.679733464492681e-02, 1.666832843105426e-03, 1.290062138725492e-04, 8.181521886936468e-06, 4.394413635475253e-07, 2.046799248242602e-08, 8.415246383961493e-10, 3.096554994811516e-11, 1.031139804452122e-12, 3.135581455149412e-14, 8.773263316007978e-16, 2.273128003705574e-17, 5.483873143620322e-19, 1.237701348583612e-20, 2.624314178610683e-22, 5.246643814328488e-24, 9.922714464392029e-26, 1.780454578414938e-27, 3.038956080231845e-29, 4.945885648569614e-31, 7.691818247961134e-33, 1.145346308884449e-34,
5.218664267676943e-01, 1.242600235462328e-01, 1.810957455323678e-02, 1.898033321659904e-03, 1.552052942917376e-04, 1.040136405768962e-05, 5.904231639189556e-07, 2.906523208634183e-08, 1.263054060675248e-09, 4.912528704558056e-11, 1.729123018449930e-12, 5.557976524470974e-14, 1.643828411653500e-15, 4.502160776715399e-17, 1.148128257340755e-18, 2.739227677304166e-20, 6.139600917126357e-22, 1.297538585654849e-23, 2.594093083152433e-25, 4.920440786318391e-27, 8.878038765239024e-29, 1.527416388661771e-30, 2.511101393595806e-32, 3.952709345915435e-34,
5.063230312815611e-01, 1.265961593831042e-01, 1.941472596192939e-02, 2.142787832274750e-03, 1.845787492072705e-04, 1.303303372932079e-05, 7.795555886439546e-07, 4.044058525488137e-08, 1.852026050082128e-09, 7.591493257857583e-11, 2.816153937332171e-12, 9.540349655577745e-14, 2.973910687452203e-15, 8.584631692476067e-17, 2.307409287410072e-18, 5.802290566823627e-20, 1.370728800682073e-21, 3.053333168699244e-23, 6.434044708739933e-25, 1.286319681583461e-26, 2.446300822624709e-28, 4.436081525246771e-30, 7.686997322577973e-32, 1.275377605633448e-33,
4.914755839689684e-01, 1.286761428981434e-01, 2.070920751234611e-02, 2.400487335057321e-03, 2.172424569787300e-04, 1.611890480296700e-05, 1.013246207221353e-06, 5.524542018945295e-08, 2.659252536237624e-09, 1.145749259900188e-10, 4.467665737188296e-12, 1.590961351965341e-13, 5.213164602582841e-15, 1.581899958377264e-16, 4.469617682089592e-18, 1.181509833383892e-19, 2.934165638294525e-21, 6.870765092651597e-23, 1.522001187135905e-24, 3.198760453000486e-26, 6.395082698196713e-28, 1.219103902128570e-29, 2.220772400555977e-31, 3.873408478502617e-33,
4.772871233072715e-01, 1.305185472656688e-01, 2.198986540377530e-02, 2.670492592556639e-03, 2.532977899421938e-04, 1.970176758019172e-05, 1.298437172299717e-06, 7.422892914946797e-08, 3.746547599694751e-09, 1.692672950368288e-10, 6.921313997371905e-12, 2.584648684449999e-13, 8.881469191674576e-15, 2.826245009714687e-16, 8.374393733114801e-18, 2.321541571323740e-19, 6.046208575737749e-21, 1.484792261579577e-22, 3.449371634820574e-24, 7.602791567712239e-26, 1.594063416186110e-27, 3.186909150552418e-29, 6.088409099002073e-31, 1.113691772263508e-32,
4.637228398768964e-01, 1.321406713709966e-01, 2.325393530690784e-02, 2.952141888175205e-03, 2.928317322118046e-04, 2.382456605715973e-05, 1.642591513185447e-06, 9.824420003660245e-08, 5.188179242073002e-09, 2.452587974457146e-10, 1.049351821902704e-11, 4.100390017502337e-13, 1.474372985440144e-14, 4.909502390826970e-16, 1.522268192052498e-17, 4.415994213366805e-19, 1.203518559486136e-20, 3.092828584305877e-22, 7.518878116286068e-24, 1.734247610493291e-25, 3.805137481805247e-27, 7.960910042346302e-29, 1.591572684233594e-30, 3.046621178329281e-32,
4.507499437463384e-01, 1.335586267362804e-01, 2.449900735395414e-02, 3.244757832268982e-03, 3.359171136532075e-04, 2.853014835529238e-05, 2.053675452977424e-06, 1.282537928386357e-07, 7.072375765152941e-09, 3.491247454441267e-10, 1.559899553761352e-11, 6.365472633991269e-13, 2.390292252849138e-14, 8.312387052073418e-16, 2.691716615282967e-17, 8.154941094050264e-19, 2.321148096176872e-20, 6.229692578266206e-22, 1.581710652220588e-23, 3.810223780911893e-25, 8.731260975682391e-27, 1.907823433402614e-28, 3.983567564048736e-30, 7.964080601333788e-32,
4.383375403464057e-01, 1.347874184837927e-01, 2.572299396744824e-02, 3.547653343750640e-03, 3.826129406579544e-04, 3.386103158575271e-05, 2.540137144403378e-06, 1.653347722385133e-07, 9.502875446541776e-09, 4.889736760538936e-10, 2.277356386424946e-11, 9.687361056908022e-13, 3.792056742449943e-14, 1.374691800510619e-15, 4.640557369667094e-17, 1.465640098927549e-18, 4.348893467703801e-20, 1.216788374227624e-21, 3.220702605144225e-23, 8.088192241919460e-25, 1.932223155868460e-26, 4.401487775903390e-28, 9.581113394203530e-30, 1.996931626259359e-31,
4.264565142752815e-01, 1.358410207489525e-01, 2.692410030777407e-02, 3.860136887314880e-03, 4.329648065935144e-04, 3.985918207798759e-05, 3.110882223059918e-06, 2.106831566356877e-07, 1.260050782921510e-08, 6.746928154359849e-10, 3.270048285852203e-11, 1.447580113472258e-12, 5.897049591229833e-14, 2.224821504161001e-15, 7.816197862473802e-17, 2.569170712566940e-18, 7.933932123297500e-20, 2.310319735396152e-21, 6.364403800896397e-23, 1.663454678831074e-24, 4.135911248171025e-26, 9.805496642896888e-28, 2.221486949785825e-29, 4.818923253540470e-31,
4.150794205134639e-01, 1.367324469266647e-01, 2.810079713611093e-02, 4.181517039348980e-03, 4.870053668252036e-04, 4.656581158781715e-05, 3.775246574270852e-06, 2.656177524199028e-07, 1.650479474392589e-08, 9.182140739213761e-10, 4.624058873141649e-11, 2.126938676332228e-12, 9.003254684927274e-14, 3.529552528625667e-15, 1.288503654113993e-16, 4.401022087382670e-18, 1.412288936042003e-19, 4.273512912281968e-21, 1.223351797957075e-22, 3.322674129911450e-24, 8.584860085227303e-26, 2.115040342398278e-27, 4.979450970135818e-29, 1.122477717977500e-30,
4.041803825625755e-01, 1.374738151078104e-01, 2.925179590491080e-02, 4.511106449124962e-03, 5.447548650246665e-04, 5.402118983223654e-05, 4.542966702300934e-06, 3.315833504982300e-07, 2.137555914325091e-08, 1.233800102534078e-09, 6.446646311683142e-11, 3.076715758205237e-12, 1.351336270855626e-13, 5.496960806085457e-15, 2.082254816468680e-16, 7.379926304389835e-18, 2.457403413362632e-19, 7.716064301935494e-21, 2.292044564975168e-22, 6.459856109923757e-24, 1.731944184018176e-25, 4.427787674192443e-27, 1.081729561129788e-28, 2.530378661490762e-30,
3.937349970545889e-01, 1.380764090378772e-01, 3.037602590228065e-02, 4.848225255944393e-03, 6.062216991133203e-04, 6.226447347081187e-05, 5.424148079170711e-06, 4.101532697423487e-07, 2.739452992928001e-08, 1.638349744313387e-09, 8.870085739022343e-11, 4.386581861902783e-12, 1.996443869216674e-13, 8.415482041655604e-15, 3.303385666662072e-16, 1.213253874331463e-17, 4.186534708094826e-19, 1.362248304012762e-20, 4.193423845118719e-22, 1.224775333879586e-23, 3.402966056974939e-25, 9.015765464941986e-27, 2.282592128400278e-28, 5.533379151419477e-30,
3.837202444083465e-01, 1.385507349066142e-01, 3.147261328983589e-02, 5.192204017478982e-03, 6.714030166554952e-04, 7.133355146249174e-05, 6.429231835657036e-06, 5.030312391515119e-07, 3.476693118866270e-08, 2.151722026710229e-09, 1.205595721420649e-10, 6.170319097208865e-12, 2.906405862989211e-13, 1.267955697748544e-14, 5.151300344237047e-16, 1.958155520795158e-17, 6.993467571799697e-19, 2.355267664735317e-20, 7.504159449177737e-22, 2.268515416874374e-23, 6.523749338704123e-25, 1.788951731415518e-26, 4.687944562828863e-28, 1.176262540103868e-29,
3.741144051385323e-01, 1.389065742561134e-01, 3.254086188579429e-02, 5.542386199579401e-03, 7.402853308305028e-04, 8.126490656749639e-05, 7.568960139961226e-06, 6.120526170898748e-07, 4.372304459390935e-08, 2.797077666547796e-09, 1.619989673453005e-10, 8.570851587704483e-12, 4.173390525110545e-13, 1.882182313369200e-14, 7.905077490183600e-16, 3.106516522278015e-17, 1.146993357552872e-18, 3.993505946474331e-20, 1.315422088925013e-21, 4.111086619781969e-23, 1.222267847170291e-24, 3.465166176892603e-26, 9.387848228980078e-28, 2.435272760606764e-29,
3.648969814485983e-01, 1.391530332747365e-01, 3.358023555636850e-02, 5.898130273274167e-03, 8.128451492897891e-04, 9.209349263281528e-05, 8.854340590607863e-06, 7.391849519404663e-07, 5.451973417374016e-08, 3.601236897940160e-09, 2.153682524202943e-10, 1.176602426858727e-11, 5.916189460821345e-13, 2.755311616397114e-14, 1.195028282752820e-15, 4.849695775543332e-17, 1.849163373111096e-18, 6.648845966651454e-20, 2.261715707914099e-21, 7.299840237036043e-23, 2.241348831513184e-24, 6.562293223301923e-26, 1.836064830781135e-27, 4.918827655013383e-29,
3.560486237637179e-01, 1.392985887257301e-01, 3.459034208895584e-02, 6.258811460515381e-03, 8.890496092576374e-04, 1.038526271932738e-04, 1.029660992993553e-05, 8.865278939185038e-07, 6.744192318356455e-08, 4.595052287274921e-09, 2.834666772387812e-10, 1.597519341768570e-11, 8.286398489572602e-13, 3.981170696915269e-14, 1.781319597934949e-15, 7.457747675766402e-17, 2.933613713729934e-18, 1.088209475964497e-19, 3.818970748596355e-21, 1.271647517841659e-22, 4.028195071378156e-24, 1.216764560855555e-25, 3.512293163627576e-27, 9.707734460093321e-29,
3.475510618827322e-01, 1.393511307420947e-01, 3.557091843028139e-02, 6.623823166417808e-03, 9.688571131734360e-04, 1.165738988350273e-04, 1.190719736351077e-05, 1.056312472609347e-06, 8.280401340614420e-08, 5.813795068711027e-09, 3.696057154654393e-10, 2.146669201384344e-11, 1.147568959171322e-12, 5.682337258742760e-14, 2.620407036586626e-15, 1.130710493588168e-16, 4.584252912504971e-18, 1.752686777242528e-19, 6.339688364041067e-21, 2.175811052083428e-22, 7.103958723624817e-24, 2.211741123596198e-25, 6.580491189258019e-27, 1.874679442383687e-28,
3.393870404494055e-01, 1.393180027031992e-01, 3.652181718158129e-02, 6.992578132252412e-03, 1.052217960011074e-03, 1.302870887019291e-04, 1.369768774932064e-05, 1.250899759053537e-06, 1.009512378691427e-07, 7.297553419170279e-09, 4.776763008562863e-10, 2.856623222679077e-11, 1.572430409773340e-12, 8.017407872302174e-14, 3.807130409871074e-15, 1.691643126875407e-16, 7.062516165449783e-18, 2.780565572198018e-19, 1.035710552727266e-20, 3.660467059695056e-22, 1.230731509098104e-23, 3.945909476050821e-25, 1.208991198210601e-26, 3.546873190166561e-28,
3.315402584632040e-01, 1.392060383936947e-01, 3.744299425117287e-02, 7.364509340269057e-03, 1.139074968156388e-03, 1.450201054750447e-04, 1.567978489899919e-05, 1.472778934911314e-06, 1.222609386684030e-07, 9.091640993812774e-09, 6.122211455559952e-10, 3.766630601284408e-11, 2.133090418379660e-12, 1.118972385542788e-13, 5.466868403935684e-15, 2.499260795359301e-16, 1.073568167242192e-17, 4.348857402094188e-19, 1.666694895032650e-20, 6.060844614745924e-22, 2.096726193980781e-23, 6.916871561976714e-25, 2.180580142761447e-26, 6.582377169312970e-28,
3.239953125683712e-01, 1.390215966313745e-01, 3.833449757239620e-02, 7.739070698510760e-03, 1.229364086385704e-03, 1.607989331194340e-04, 1.786527521188571e-05, 1.724564794424193e-06, 1.471437623220848e-07, 1.124701396156072e-08, 7.785121373905439e-10, 4.923664292960372e-11, 2.866392609115190e-12, 1.545777050285408e-13, 7.763817491489760e-15, 3.648918414153805e-16, 1.611400938236543e-17, 6.710814030112164e-19, 2.644150195955087e-20, 9.885451321871727e-22, 3.515938742776468e-23, 1.192471544465722e-24, 3.865015925367335e-26, 1.199512674420084e-27,
3.167376438773787e-01, 1.387705935377022e-01, 3.919645680197430e-02, 8.115737531121173e-03, 1.323014990075486e-03, 1.776475906682549e-04, 2.026599184161661e-05, 2.008994707577581e-06, 1.760447658407939e-07, 1.382069471525057e-08, 9.826327809533161e-10, 6.383578190413857e-11, 3.817458423191229e-12, 2.114748509514019e-13, 1.091110606599415e-14, 5.268003421816089e-16, 2.389899424090054e-17, 1.022468881796839e-18, 4.138699897428618e-20, 1.589573764446808e-21, 5.808109866916380e-23, 2.023734156330698e-24, 6.738618768378848e-26, 2.148525817042914e-27,
3.097534881009597e-01, 1.384585326127029e-01, 4.002907392036965e-02, 8.494006897216999e-03, 1.419951660292376e-03, 1.955881033005169e-04, 2.289377957439741e-05, 2.328925075084238e-06, 2.094444274730120e-07, 1.687620038215691e-08, 1.231565615231965e-09, 8.212381081192616e-11, 5.041168040860234e-12, 2.866672914677912e-13, 1.518306058077738e-14, 7.525142973079053e-16, 3.504550509877000e-17, 1.539188048548056e-18, 6.395854085964807e-20, 2.521807114952327e-21, 9.459444202421528e-23, 3.383658463478232e-24, 1.156667452776131e-25, 3.786036534992000e-27,
3.030298287719901e-01, 1.380905327647251e-01, 4.083261466175257e-02, 8.873397759178957e-03, 1.520092943871091e-03, 2.146404839638840e-04, 2.576046057822729e-05, 2.687327307583511e-06, 2.478595568648531e-07, 2.048397422749491e-08, 1.533284508901659e-09, 1.048763243715983e-10, 6.603837669531600e-12, 3.852220055919211e-13, 2.092997903674564e-14, 1.064162512412560e-15, 5.084113498021895e-17, 2.290705863683043e-18, 9.765065812621827e-20, 3.949945537424934e-21, 1.520024556027878e-22, 5.578018618414923e-24, 1.956197851665111e-25, 6.569040887707279e-27,
2.965543533645102e-01, 1.376713544351749e-01, 4.160740070677883e-02, 9.253451019190893e-03, 1.623353092991000e-03, 2.348227247964477e-04, 2.887780116326788e-05, 3.087283362816655e-06, 2.918441001506866e-07, 2.472181802549871e-08, 1.896851703479486e-09, 1.329996470609208e-10, 8.585109404684350e-12, 5.133908157919169e-13, 2.859580815239925e-14, 1.490546397115378e-15, 7.300672611731081e-17, 3.372346577564978e-18, 1.473864785612879e-19, 6.112190671364763e-21, 2.411475839879966e-22, 9.072805001883372e-24, 3.262166540552584e-25, 1.123127812619426e-26,
2.903154121222752e-01, 1.372054239486434e-01, 4.235380257653409e-02, 9.633729441010559e-03, 1.729642283116076e-03, 2.561507976101467e-04, 3.225747967534396e-05, 3.531980875525333e-06, 3.419898362596080e-07, 2.967532346910637e-08, 2.332519444534969e-09, 1.675473635435145e-10, 1.108007013687573e-11, 6.788373857473865e-13, 3.873916387606940e-14, 2.068860201595509e-15, 1.038227619363957e-16, 4.913729365955101e-18, 2.200343409568583e-19, 9.349477157655533e-21, 3.779499035053902e-22, 1.456990240191820e-23, 5.367689978704487e-25, 1.893559217711539e-26,
2.843019794234335e-01, 1.366968562098409e-01, 4.307223317077308e-02, 1.001381747227299e-02, 1.838867108472546e-03, 2.786386627124473e-04, 3.591105562729834e-05, 4.024707915459860e-06, 3.989269614760471e-07, 3.543830069938784e-08, 2.851836012300631e-09, 2.097381944976908e-10, 1.420161615540204e-11, 8.908980947195154e-13, 5.205818044503287e-14, 2.846781245424932e-15, 1.462871461076388e-16, 7.089585688414832e-18, 3.250878167451203e-19, 1.414497102103920e-20, 5.855403801032775e-22, 2.311479501897800e-23, 8.720355055983907e-25, 3.150222372647934e-26,
2.785036175193246e-01, 1.361494758603743e-01, 4.376314189798957e-02, 1.039332098109390e-02, 1.950931054508343e-03, 3.022982853610882e-04, 3.984994015663642e-05, 4.568847409206838e-06, 4.633245600257414e-07, 4.211320205878873e-08, 3.467755935519483e-09, 2.609752507949753e-10, 1.808308018360121e-11, 1.160880340934964e-12, 6.941972081728179e-14, 3.884993980267404e-15, 2.043108240119132e-16, 1.013352486905050e-17, 4.755536574491686e-19, 2.117698076357475e-20, 8.971920587000661e-22, 3.624834592950840e-23, 1.399601821410321e-24, 5.174709993111551e-26,
2.729104424960156e-01, 1.355668370006049e-01, 4.442700934892873e-02, 1.077186691934439e-02, 2.065734947012602e-03, 3.271396591683073e-04, 4.408536788261310e-05, 5.167871261582347e-06, 5.358909591663460e-07, 4.981153920713413e-08, 4.194754146374686e-09, 3.228666937249010e-10, 2.288113756978625e-11, 1.502402014419863e-12, 9.189353083326822e-14, 5.260219945268276e-15, 2.829587527532799e-16, 1.435542793218845e-17, 6.891024012597329e-19, 3.138925431759747e-20, 1.360312278664685e-21, 5.621868543335782e-23, 2.220439544243604e-24, 8.397785416559883e-26,
2.675130923171188e-01, 1.349522415745743e-01, 4.506434246891924e-02, 1.114910292369731e-02, 2.183177377775736e-03, 3.531708357953129e-04, 4.862837022164750e-05, 5.825334212116348e-06, 6.173739679413336e-07, 5.865429178521006e-08, 5.048943810019688e-09, 3.972478234444184e-10, 2.877900824956542e-11, 1.931776060277849e-12, 1.207919707182170e-13, 7.068834548017870e-15, 3.887449003301430e-16, 2.016327829549693e-17, 9.895484936634991e-19, 4.608364409612389e-20, 2.041834460843925e-21, 8.627437381570197e-23, 3.483870692724179e-24, 1.347138307634770e-25,
2.623026968156744e-01, 1.343087565092318e-01, 4.567567018788122e-02, 1.152469686438979e-02, 2.303155106844358e-03, 3.803979603041867e-04, 5.348975020669369e-05, 6.544867461703996e-06, 7.085609994033794e-07, 6.877230586665584e-08, 6.048197539690497e-09, 4.862046120856994e-10, 3.598997088883854e-11, 2.468444224965961e-12, 1.577160103004093e-13, 9.431161142373488e-15, 5.299912608511696e-16, 2.809038533660722e-17, 1.408741076302708e-18, 6.704134563936011e-20, 3.035441929027442e-21, 1.310665586476669e-22, 5.408583946970400e-24, 2.137212209636289e-25,
2.572708495115354e-01, 1.336392296929197e-01, 4.626153947008321e-02, 1.189833635059545e-02, 2.425563441573644e-03, 4.088253115624028e-04, 5.868005884394271e-05, 7.330172103847369e-06, 8.102790767266242e-07, 8.030668050388841e-08, 7.212271687739871e-09, 5.920986920266629e-10, 4.476120531184657e-11, 3.135464239207823e-12, 2.046082283669703e-13, 1.249654308038134e-14, 7.172623186431428e-16, 3.882912500043738e-17, 1.988963371927909e-18, 9.668038920967802e-20, 4.471172360833380e-21, 1.971961601155882e-22, 8.311895059541521e-24, 3.354876527627058e-25,
2.524095811387339e-01, 1.329463048722280e-01, 4.682251174869052e-02, 1.226972820034529e-02, 2.550296592805432e-03, 4.384553471242144e-04, 6.420957302895828e-05, 8.185012394081542e-06, 9.233947242040750e-07, 9.340914074686446e-08, 8.562933384268132e-09, 7.175938037558023e-10, 5.537797891583720e-11, 3.960054840374392e-12, 2.638136116575206e-13, 1.644930528774337e-14, 9.638879873944283e-16, 5.327251247732946e-17, 2.785958164257050e-18, 1.382588291279975e-19, 6.528094158130402e-21, 2.939525901900280e-22, 1.265014876379945e-23, 5.213044317933619e-25,
2.477113347748456e-01, 1.322324355408890e-01, 4.735915971289247e-02, 1.263859788206964e-02, 2.677248008605874e-03, 4.692887520429316e-04, 7.008827503403195e-05, 9.113208890196372e-06, 1.048813744665487e-06, 1.082423955937070e-07, 1.012408997839977e-08, 8.656837015881776e-10, 6.816819227447365e-11, 4.974203173106290e-12, 3.381490048424089e-13, 2.151572844474455e-14, 1.286589798428498e-15, 7.256513760290919e-17, 3.872719589194127e-18, 1.961351785744829e-19, 9.450920302798393e-21, 4.343036175463979e-22, 1.907406315439576e-23, 8.021822192214482e-25,
2.431689424713804e-01, 1.314998978893225e-01, 4.787206441793114e-02, 1.300468893404728e-02, 2.806310686084126e-03, 5.013244910982041e-04, 7.632583356915183e-05, 1.011863149475180e-05, 1.187480885351353e-06, 1.249804794186240e-07, 1.192192052271088e-08, 1.039721509253442e-09, 8.350729853802546e-11, 6.215339228373909e-12, 4.309821191662597e-13, 2.797217103651508e-14, 1.706227021721269e-15, 9.816523611811440e-17, 5.344217694533194e-18, 2.761001291400407e-19, 1.357163687894197e-20, 6.362122902283963e-22, 2.850396813946906e-23, 1.222900982798086e-24,
2.387756032907889e-01, 1.307508028787311e-01, 4.836181269069502e-02, 1.336776236733540e-02, 2.937377461885402e-03, 5.345598639525769e-04, 8.293158641047512e-05, 1.120519243016101e-05, 1.340379394739554e-06, 1.438090755142104e-07, 1.398500892887465e-08, 1.243450511119309e-09, 1.018236105522716e-10, 7.727082086885474e-12, 5.463210639668395e-13, 3.615448735229818e-14, 2.248681480798816e-15, 1.319199414433490e-16, 7.323252392399206e-18, 3.857965313244892e-19, 1.933747897440969e-20, 9.243769794418862e-22, 4.223134528293280e-23, 1.847592193353908e-24,
2.345248626617911e-01, 1.299871074992608e-01, 4.882899480570405e-02, 1.372759605710834e-02, 3.070341282009589e-03, 5.689905627815265e-04, 8.991452458254394e-05, 1.237683917530219e-05, 1.508530473242587e-06, 1.649258204812459e-07, 1.634447841226723e-08, 1.481036358573503e-09, 1.236040088431540e-10, 9.560062821668581e-12, 6.889154217008568e-13, 4.646890294246039e-14, 2.945902074060522e-15, 1.761560643664694e-16, 9.967667952697991e-18, 5.352480570285288e-19, 2.734689359674038e-20, 1.332515377883336e-21, 6.205490674824379e-23, 2.767376135255029e-24,
2.304105929704487e-01, 1.292106252676593e-01, 4.927420240830942e-02, 1.408398412674950e-02, 3.205095451652153e-03, 6.046107319507289e-04, 9.728327807364015e-05, 1.363754739123259e-05, 1.692992621075216e-06, 1.885405882986285e-07, 1.903412683505603e-08, 1.757100664901112e-09, 1.494000627543524e-10, 1.177282898577986e-11, 8.643699431111368e-13, 5.940452305884500e-14, 3.837132445625164e-15, 2.337890842513309e-16, 1.347919852395653e-17, 7.375209866619280e-19, 3.839549600550405e-20, 1.906343565822296e-21, 9.046173898126511e-23, 4.110736777002109e-24,
2.264269753097395e-01, 1.284230360160681e-01, 4.969802666377426e-02, 1.443673632851237e-02, 3.341533865798745e-03, 6.414130293432445e-04, 1.050461030576012e-04, 1.499131386213677e-05, 1.894860886935300e-06, 2.148757530082863e-07, 2.209056255115271e-08, 2.076755955897776e-09, 1.798345760844235e-10, 1.443283566356191e-11, 1.079271994436417e-12, 7.554766417838440e-14, 4.970347863060271e-15, 3.084534072885598e-16, 1.811425980357590e-17, 1.009548237042286e-18, 5.353446199371938e-20, 2.707438077838494e-21, 1.308668803912617e-22, 6.057519303276453e-24,
2.225684823153713e-01, 1.276258950200471e-01, 5.010105661260493e-02, 1.478567742408999e-02, 3.479551221330201e-03, 6.793886889675535e-04, 1.132108705900694e-04, 1.644214947615638e-05, 2.115266021445135e-06, 2.441664290540028e-07, 2.555334035231750e-08, 2.445641937485893e-09, 2.156085675537424e-10, 1.761752809690177e-11, 1.341333942774876e-12, 9.559821380653224e-14, 6.403930161138142e-15, 4.046573571814454e-16, 2.419705242166027e-17, 1.373150153774117e-18, 7.414431481767217e-20, 3.818213447739163e-21, 1.879282173189978e-22, 8.857691272991169e-24,
2.188298620202313e-01, 1.268206415106398e-01, 5.048387771407230e-02, 1.513064656800191e-02, 3.619043211411513e-03, 7.185275845047294e-04, 1.217850567424776e-04, 1.799407226923841e-05, 2.355373539567841e-06, 2.766606884183602e-07, 2.946509711260120e-08, 2.869963035782624e-09, 2.575086953444034e-10, 2.141552091090534e-11, 1.659551718542970e-12, 1.203882393362644e-13, 8.208612603058901e-15, 5.279668137229596e-16, 3.213539938474687e-17, 1.856292822236208e-18, 1.020276735910807e-19, 5.348301336071242e-21, 2.679579047694275e-22, 1.285632960033924e-23,
2.152061226642101e-01, 1.260086066122203e-01, 5.084707056131403e-02, 1.547149669632021e-02, 3.759906702948174e-03, 7.588182934795266e-04, 1.307757341330463e-04, 1.965110055361234e-05, 2.616382696444153e-06, 3.126197538077270e-07, 3.387168672814635e-08, 3.356527159434232e-09, 3.064151338040195e-10, 2.592787895575978e-11, 2.044380845100312e-12, 1.509030827558400e-13, 1.046972969551249e-14, 6.852219071825048e-16, 4.243980360480815e-17, 2.494631800808508e-18, 1.395252432725777e-19, 7.442681601686989e-21, 3.794568062557210e-22, 1.852669668375348e-23,
2.116925184001998e-01, 1.251910207450140e-01, 5.119120975274613e-02, 1.580809392290680e-02, 3.902039897896717e-03, 8.002481617655858e-04, 1.401895648106296e-04, 2.141724615097686e-05, 2.899525381290731e-06, 3.523181672407793e-07, 3.882231395107046e-08, 3.912785628608414e-09, 3.633099091928756e-10, 3.126950475290677e-11, 2.507931274720439e-12, 1.883051944056023e-13, 1.328981037271645e-14, 8.847917134472425e-16, 5.574628269358832e-17, 3.333397352042022e-18, 1.896601595546448e-19, 1.029199232388613e-20, 5.338048849424690e-22, 2.651376730018451e-23,
2.082845358408618e-01, 1.243690205285241e-01, 5.151686290574738e-02, 1.614031694502115e-02, 4.045342479214558e-03, 8.428033681593683e-04, 1.500327944443684e-04, 2.329650774895254e-05, 3.206064934163240e-06, 3.960439335008293e-07, 4.436966671964435e-08, 4.546874209849617e-09, 4.292857000892338e-10, 3.757063748371274e-11, 3.064182416862182e-12, 2.339609757281609e-13, 1.679155653739564e-14, 1.136872478557552e-15, 7.284361743163611e-17, 4.429686553124577e-18, 2.563167711913482e-19, 1.414553680303238e-20, 7.461482794185162e-22, 3.769118377471619e-23,
2.049778813942989e-01, 1.235436552196272e-01, 5.182458979971968e-02, 1.646805645987577e-02, 4.189715742227769e-03, 8.864689887807654e-04, 1.603112477697429e-04, 2.529286439784840e-05, 3.537294890517355e-06, 4.440986380157334e-07, 5.057004659217497e-08, 5.267655191074505e-09, 5.055551067561081e-10, 4.497846838743746e-11, 3.729219788830520e-12, 2.894709179808033e-13, 2.112125271278987e-14, 1.453835533668701e-15, 9.470573824254437e-17, 5.855238224840072e-18, 3.444610653696568e-19, 1.932761320538854e-20, 1.036533207794243e-21, 5.323537450385715e-23,
2.017684693400837e-01, 1.227158927167930e-01, 5.211494163667758e-02, 1.679121459346454e-02, 4.335062712184973e-03, 9.312290610804855e-04, 1.710303252397130e-04, 2.741026916330252e-05, 3.894537658600025e-06, 4.967975388307893e-07, 5.748349689880746e-08, 6.084760426335258e-09, 5.934603924208944e-10, 5.365887734242697e-11, 4.521494760110542e-12, 3.567033411238451e-13, 2.645265651736945e-14, 1.850631744498733e-15, 1.225300712492619e-16, 7.699778554549216e-18, 4.604112381157535e-19, 2.625791928665555e-20, 1.431348145758103e-21, 7.472149839756594e-23,
1.986524106001829e-01, 1.218866251597439e-01, 5.238846040849018e-02, 1.710970434276354e-02, 4.481288248752242e-03, 9.770666472554675e-04, 1.821950008281857e-04, 2.965264294890196e-05, 4.279143134773891e-06, 5.544696324394864e-07, 6.517392823379289e-08, 7.008635275626011e-09, 6.944836980335828e-10, 6.379829529018103e-11, 5.462108899627622e-12, 4.378320545006036e-13, 3.299142382013542e-14, 2.345260074816242e-15, 1.577827727080216e-16, 1.007503873752100e-17, 6.121684026939446e-19, 3.547693334030653e-20, 1.965149240672341e-21, 1.042470082043822e-22,
1.956260021622161e-01, 1.210566741518722e-01, 5.264567836079223e-02, 1.742344903220241e-02, 4.628299138187186e-03, 1.023963896893475e-03, 1.938098209319776e-04, 3.202386850146301e-05, 4.692487261920499e-06, 6.174576933336826e-07, 7.370924092050948e-08, 8.050583360966392e-09, 8.102577306562983e-10, 7.560569702644718e-11, 6.575124469655019e-12, 5.353782784174228e-13, 4.098012676521090e-14, 2.959308633186727e-15, 2.022518984646506e-16, 1.311956106386274e-17, 8.098191376243186e-19, 4.767734630484053e-20, 2.682960022687382e-21, 1.445899973869000e-22,
1.926857171151833e-01, 1.202267956308697e-01, 5.288711754440458e-02, 1.773238178512438e-02, 4.776004173912075e-03, 1.071902108686904e-03, 2.058789043167466e-04, 3.452778461027369e-05, 5.135970536085675e-06, 6.861182872285344e-07, 8.316144409259124e-08, 9.222812056280018e-09, 9.425769242034612e-10, 8.931472872709893e-11, 7.887902640797860e-12, 6.522571832470058e-13, 5.070392736484444e-14, 3.718577417599990e-15, 2.581096842244262e-16, 1.700442678457372e-17, 1.066023527381566e-18, 6.374282230851803e-20, 3.643155572932476e-21, 1.994111527190195e-22,
1.898281952603302e-01, 1.193976844112997e-01, 5.311328944586480e-02, 1.803644501079430e-02, 4.924314226185366e-03, 1.120861791073585e-03, 2.184059430519927e-04, 3.716818051026190e-05, 5.611016466523848e-06, 7.608217580078889e-07, 9.360677104679201e-08, 1.053847862520468e-08, 1.093409069804365e-09, 1.051859743996657e-10, 9.431471029184358e-12, 7.918294201441390e-13, 6.249697404377995e-14, 4.653792875154941e-15, 3.279852535421540e-16, 2.194005795658254e-17, 1.396604570123841e-18, 8.479559968272427e-20, 4.921063880656446e-21, 2.735101294646874e-22,
1.870502342621731e-01, 1.185699784212206e-01, 5.332469468936789e-02, 1.833558990737117e-02, 5.073142301549013e-03, 1.170822721679013e-03, 2.313942043801630e-04, 3.994879049776506e-05, 6.119069994269698e-06, 8.419521885226344e-07, 1.051257905365954e-07, 1.201173691793367e-08, 1.264907411605061e-09, 1.235093652545218e-10, 1.124092217946351e-11, 9.579580348069089e-13, 7.674959336794779e-14, 5.801425354924987e-15, 4.150492241979683e-16, 2.818426645700747e-17, 1.821257347106951e-18, 1.122547158852660e-19, 6.613443698515993e-21, 3.731495569879228e-22,
1.843487813069236e-01, 1.177442626534751e-01, 5.352182280306236e-02, 1.862977598113738e-02, 5.222403592706187e-03, 1.221764005450088e-03, 2.448465334650863e-04, 4.287328876633859e-05, 6.661595874316418e-06, 9.299073354574434e-07, 1.178035136899641e-07, 1.365778453550012e-08, 1.459423202370472e-09, 1.446067357735239e-10, 1.335584463523381e-11, 1.155071172864388e-12, 9.391635419824336e-14, 7.204621552524809e-15, 5.231118506995316e-16, 3.605174664233856e-17, 2.364399199085875e-18, 1.479069525159949e-19, 8.844029386696875e-21, 5.064627377135960e-22,
1.817209252376088e-01, 1.169210728508552e-01, 5.370515204324169e-02, 1.891897058216598e-02, 5.372015519459983e-03, 1.273664131385013e-03, 2.587653569654053e-04, 4.594528446885604e-05, 7.240077026412376e-06, 1.025098538560272e-06, 1.317294962499032e-07, 1.549291036758309e-08, 1.679518711797021e-09, 1.688345300190213e-10, 1.582078825192015e-11, 1.388231002348238e-12, 1.145250866663636e-13, 8.914265125609914e-15, 6.567365217114034e-16, 4.592523388658358e-17, 3.056185369520458e-18, 1.939929558029759e-19, 1.177036969273409e-20, 6.839644989488950e-22,
1.791638891371204e-01, 1.161008989430521e-01, 5.387514927051740e-02, 1.920314845651000e-02, 5.521897761319558e-03, 1.326501027777624e-03, 2.731526873793189e-04, 4.916831701102441e-05, 7.856012859402920e-06, 1.127950604603681e-06, 1.469979358525796e-07, 1.753454240793620e-08, 1.927980679006659e-09, 1.965866614734391e-10, 1.868576541570374e-11, 1.663209295234552e-12, 1.391869436637782e-13, 1.099017980121349e-14, 8.213706269176335e-16, 5.826857964786663e-17, 3.933718188568888e-18, 2.533113991887845e-19, 1.559222989344525e-20, 9.191886833757944e-22,
1.766750233322303e-01, 1.152841882520853e-01, 5.403226987256507e-02, 1.948229131491310e-02, 5.671972282355222e-03, 1.380252115907068e-03, 2.880101281077927e-04, 5.254585158036358e-05, 8.510917573943887e-06, 1.238901666517456e-06, 1.637077640744977e-07, 1.980129574991908e-08, 2.207834199271177e-09, 2.282975294299227e-10, 2.200678983574641e-11, 1.986570126147439e-12, 1.686075979554213e-13, 1.350249049889164e-14, 1.023496018822777e-15, 7.364202497577559e-17, 5.042481923752294e-18, 3.293445240578483e-19, 2.056187606169633e-20, 1.229480520140960e-21,
1.742517987932966e-01, 1.144713484817746e-01, 5.417695772849809e-02, 1.975638741796667e-02, 5.822163348859373e-03, 1.434894362115493e-03, 3.033388791843982e-04, 5.608127491368288e-05, 9.206318448299210e-06, 1.358403018198035e-06, 1.819627329975815e-07, 2.231302066334520e-08, 2.522357033616579e-09, 2.644451946687952e-10, 2.584645457550551e-11, 2.365760161921046e-12, 2.035996735641042e-13, 1.653315925830400e-14, 1.270801521922462e-15, 9.271998867774468e-17, 6.438039953215487e-18, 4.264089288513385e-19, 2.699661733871705e-20, 1.636977717678559e-21,
1.718918009059697e-01, 1.136627505057649e-01, 5.430964521035081e-02, 2.002543117757382e-02, 5.972397540345018e-03, 1.490404328227219e-03, 3.191397436210821e-04, 5.977789130512631e-05, 9.943754111808075e-06, 1.486918925561727e-06, 2.018714960588318e-07, 2.509085065294397e-08, 2.875094328586462e-09, 3.055547168537799e-10, 3.027455098230337e-11, 2.809207030746160e-12, 2.450965157064939e-13, 2.017771408605497e-14, 1.572380185140870e-15, 1.163117239128209e-16, 8.188035968450324e-18, 5.498360830060387e-19, 3.529404801595501e-20, 2.169820689495317e-21,
1.695927235926808e-01, 1.128587309676319e-01, 5.443075321754627e-02, 2.028942277452592e-02, 6.122603754389304e-03, 1.546758220272946e-03, 3.354131343204574e-04, 6.363891885595759e-05, 1.072477281046975e-05, 1.624926414465832e-06, 2.235476829694729e-07, 2.815725039816774e-08, 3.269873732106299e-09, 3.522016557672229e-10, 3.536873016241568e-11, 3.326426274006827e-12, 2.941674092824639e-13, 2.454719022406848e-14, 1.938954234029676e-15, 1.453852379807214e-16, 1.037454653030997e-17, 7.061877280993231e-19, 4.595050708857649e-20, 2.863640008866593e-21,
1.673523637630827e-01, 1.120595947056815e-01, 5.454069124058453e-02, 2.054836779194909e-02, 6.272713205804780e-03, 1.603931935491698e-03, 3.521590815065665e-04, 6.766748596640713e-05, 1.155093066894670e-05, 1.772915036174226e-06, 2.471099685070066e-07, 3.153606347384377e-08, 3.710820890091603e-09, 4.050157381759440e-10, 4.121520863170900e-11, 3.928137397567509e-12, 3.520343617114321e-13, 2.977030478990504e-14, 2.383130957513902e-15, 1.810949147324173e-16, 1.309683853260181e-17, 9.035121026608506e-19, 5.958335997878807e-20, 3.763378148950387e-21,
1.651686160739045e-01, 1.112656170142066e-01, 5.463985745052047e-02, 2.080227686433832e-02, 6.422659420597207e-03, 1.661901107591669e-03, 3.693772406275470e-04, 7.186662806911570e-05, 1.242378995313125e-05, 1.931386611092069e-06, 2.726821350023424e-07, 3.525255975127690e-08, 4.202375307187213e-09, 4.646846917800972e-10, 4.790951974925718e-11, 4.626389552130761e-12, 4.200905717559886e-13, 3.599588724744037e-14, 2.919693060487681e-15, 2.248133275581633e-16, 1.647459202133408e-17, 1.151647798329722e-18, 7.695780670558985e-20, 4.925512981528106e-21,
1.630394679798950e-01, 1.104770457521655e-01, 5.472863881110535e-02, 2.105116534186255e-02, 6.572378225145246e-03, 1.720641150258896e-03, 3.870669006851634e-04, 7.623928460297264e-05, 1.334491733725826e-05, 2.100854951537863e-06, 3.003931283630270e-07, 3.933348237983412e-08, 4.749306553816339e-09, 5.319582473476689e-10, 5.555731251337836e-11, 5.434697384279114e-12, 4.999207118579017e-13, 4.339558973311540e-14, 3.565927328803965e-15, 2.781677835249653e-16, 2.065165642695740e-17, 1.462583033052327e-18, 9.901903439201416e-20, 6.420762581530840e-21,
1.609629950586620e-01, 1.096941033095116e-01, 5.480741121074754e-02, 2.129505296959617e-02, 6.721807731014247e-03, 1.780127298909644e-03, 4.052269929477654e-04, 8.078829622546670e-05, 1.431588217937822e-05, 2.281845564360301e-06, 3.303771074925048e-07, 4.380709424978378e-08, 5.356730800560682e-09, 6.076523097782591e-10, 6.427519926616862e-11, 6.368187610875154e-12, 5.933231574170524e-13, 5.216690288717773e-14, 4.341995787626243e-15, 3.430821961548295e-16, 2.580041664612842e-17, 1.850879222163324e-18, 1.269306612823136e-19, 8.337364839416777e-21,
1.589373565932767e-01, 1.089169884407117e-01, 5.487653961170507e-02, 2.153396358130867e-02, 6.870888315794009e-03, 1.840334650688896e-03, 4.238561000048821e-04, 8.551640226103980e-05, 1.533825480883202e-05, 2.474895334242216e-06, 3.627734869842188e-07, 4.870322383820459e-08, 6.030127659790311e-09, 6.926532984728133e-10, 7.419165381389061e-11, 7.443756879555851e-12, 7.023343023519599e-13, 6.253650451932612e-14, 5.271353888133747e-15, 4.218249457755871e-16, 3.212685461530848e-17, 2.334168951495491e-18, 1.621205661663952e-19, 1.078504146753500e-20,
1.569607913975067e-01, 1.081458779743465e-01, 5.493637821416099e-02, 2.176792480742669e-02, 7.019562600328638e-03, 1.901238202722991e-03, 4.429524651233245e-04, 9.042623838235619e-05, 1.641360482919161e-05, 2.680552188564582e-06, 3.977269729881253e-07, 5.405331034111178e-08, 6.775357313417457e-09, 7.879226570122615e-10, 8.544796142655676e-11, 8.680241487058746e-12, 8.292551061727205e-13, 7.476397017202495e-14, 6.381220631565204e-15, 5.170634525555989e-16, 3.987640210974750e-17, 2.933739819860418e-18, 2.063353632072692e-19, 1.389977447453197e-20,
1.550316138694702e-01, 1.073809284070919e-01, 5.498727063304911e-02, 2.199696779676722e-02, 7.167775422685585e-03, 1.962812888639803e-03, 4.625140018663808e-04, 9.552033452087340e-05, 1.754349943995185e-05, 2.899374744730055e-06, 4.353875921658027e-07, 5.989044799655926e-08, 7.598677904665000e-09, 8.945015317688931e-10, 9.819922213079778e-11, 1.009859953500006e-11, 9.766800236543830e-13, 8.914587643028703e-14, 7.703105933871686e-15, 6.319262584695150e-16, 4.934069153904919e-17, 3.675217133795399e-18, 2.617049697317254e-19, 1.784954437687675e-20,
1.531482102603752e-01, 1.066222773898165e-01, 5.502955008569738e-02, 2.222112695163034e-02, 7.315473809190481e-03, 2.025033613374415e-03, 4.825383039393877e-04, 1.008011130026233e-04, 1.872950178007776e-05, 3.131931940868083e-06, 4.759107136686909e-07, 6.624942950535031e-08, 8.506763170820374e-09, 1.013515618690992e-09, 1.126154086557200e-10, 1.172210610943232e-11, 1.147528474001606e-12, 1.060203296614624e-13, 9.273400949095195e-15, 7.700734907500714e-16, 6.086532355752768e-17, 4.589360118588596e-18, 3.308189258375810e-19, 2.284120365266216e-20,
1.513090351458261e-01, 1.058700451130145e-01, 5.506353958854016e-02, 2.244043967583244e-02, 7.462606942834981e-03, 2.087875286282491e-03, 5.030226552266760e-04, 1.062708869046764e-04, 1.997316929632864e-05, 3.378802650862142e-06, 5.194570640920617e-07, 7.316678845811305e-08, 9.506720293091732e-09, 1.146180177115074e-09, 1.288824803320337e-10, 1.357656207599037e-11, 1.345079012124060e-12, 1.257719547497773e-13, 1.113403750520870e-14, 9.357766610736825e-16, 7.485878342881418e-17, 5.712988170233588e-18, 4.168163621340898e-19, 2.912868658690642e-20,
1.495126080879398e-01, 1.051243355983058e-01, 5.508955216131777e-02, 2.265494613525525e-02, 7.609126129345693e-03, 2.151312852587214e-03, 5.239640399866040e-04, 1.119318586273776e-04, 2.127605213909967e-05, 3.640575284654747e-06, 5.661927353750535e-07, 8.068084067985922e-08, 1.060610793889712e-08, 1.293805209072361e-09, 1.472035541804243e-10, 1.569051708664170e-11, 1.573006370276698e-12, 1.488373803150500e-13, 1.333322326270099e-14, 1.134008842014989e-15, 9.180265234631822e-17, 7.090055727849656e-18, 5.234917781938731e-19, 3.702278811184694e-20,
1.477575104772330e-01, 1.043852379022838e-01, 5.510789103733620e-02, 2.286468903048471e-02, 7.754984761184410e-03, 2.215321323188935e-03, 5.453591531730786e-04, 1.177861186770946e-04, 2.263969158833917e-05, 3.917847374796955e-06, 6.162891856343984e-07, 8.883172440572211e-08, 1.181295447120052e-08, 1.457800802167935e-09, 1.678001343560670e-10, 1.809550739694611e-11, 1.835421543839323e-12, 1.757112588698804e-13, 1.592625968375593e-14, 1.370546355392365e-15, 1.122632753824863e-16, 8.772896610726532e-18, 6.554190921783206e-19, 4.690277995007207e-20,
1.460423825439123e-01, 1.036528272385694e-01, 5.511884987850058e-02, 2.306971338111248e-02, 7.900138279732313e-03, 2.279875802869548e-03, 5.672044108536511e-04, 1.238356446539146e-04, 2.406561851192031e-05, 4.211225150217110e-06, 6.699232329363626e-07, 9.766143920435864e-08, 1.313577629886283e-08, 1.639682633723904e-09, 1.909134010425302e-10, 2.082630909426127e-11, 2.136915100395883e-12, 2.069528623711737e-13, 1.897645039849101e-14, 1.652083206212382e-15, 1.369050644901706e-16, 1.082366115478018e-17, 8.180967546302786e-19, 5.923017280283006e-20,
1.443659205288250e-01, 1.029271660235378e-01, 5.512271299396565e-02, 2.327006632127528e-02, 8.044544135894267e-03, 2.344951516926025e-03, 5.894959606959210e-04, 1.300823004384599e-04, 2.555535185866709e-05, 4.521323098187999e-06, 7.272770420277886e-07, 1.072138835684739e-07, 1.458359634140138e-08, 1.841077633492788e-09, 2.168055598102552e-10, 2.392120733747015e-11, 2.482603896505327e-12, 2.431932956563200e-13, 2.255610807434373e-14, 1.986359601199296e-15, 1.665056330799795e-16, 1.331597221688059e-17, 1.018117089844914e-18, 7.456497901321475e-20,
1.427268740049208e-01, 1.022083048508161e-01, 5.511975556136410e-02, 2.346579690601028e-02, 8.188161749343522e-03, 2.410523836269787e-03, 6.122296924956216e-04, 1.365278355717644e-04, 2.711039718805995e-05, 4.848763515473122e-06, 7.885381040630072e-07, 1.175348910950804e-07, 1.616596258105007e-08, 2.063729801865607e-09, 2.457612523725274e-10, 2.742228220752262e-11, 2.878181391612639e-12, 2.851433723177419e-13, 2.674766843522072e-14, 2.382306002551293e-15, 2.019729782205940e-16, 1.633682911004938e-17, 1.263363439987228e-18, 9.358488164216416e-20,
1.411240433406245e-01, 1.014962833993121e-01, 5.511024384968205e-02, 2.365695592800974e-02, 8.330952466611937e-03, 2.476568301030247e-03, 6.354012487213348e-04, 1.431738848219555e-04, 2.873224523847226e-05, 5.194176049631120e-06, 8.538992093786652e-07, 1.286722651814110e-07, 1.789296667458254e-08, 2.309506180121823e-09, 2.780890295855831e-10, 3.137571176535129e-11, 3.329971753410781e-12, 3.336021996575621e-13, 3.164492063827365e-14, 2.850204285775370e-15, 2.443649475280433e-16, 1.998879180650827e-17, 1.563239143903218e-18, 1.171077738402447e-19,
1.395562772970367e-01, 1.007911312792101e-01, 5.509443544294999e-02, 2.384359574436376e-02, 8.472879518216377e-03, 2.543060642702471e-03, 6.590060350523606e-04, 1.500219679313286e-04, 3.042237053562081e-05, 5.558197231453179e-06, 9.235584133832661e-07, 1.406758121658615e-07, 1.977526259700536e-08, 2.580402968896671e-09, 3.141228874494485e-10, 3.583209290951913e-11, 3.844987953612337e-12, 3.894665214724492e-13, 3.735436379788890e-14, 3.401867695384972e-15, 2.949112503989894e-16, 2.439248131833316e-17, 1.928932888283866e-18, 1.461181974465692e-19,
1.380224707513661e-01, 1.000928688200797e-01, 5.507257946400726e-02, 2.402577011288738e-02, 8.613907974998494e-03, 2.609976804880075e-03, 6.830392308877672e-04, 1.570734895372648e-04, 3.218223004274733e-05, 5.941469999501066e-06, 9.977189956422860e-07, 1.535973728469174e-07, 2.182408528894371e-08, 2.878551790676287e-09, 3.542238667725098e-10, 4.084678062026842e-11, 4.430994057503868e-12, 4.537408695425423e-13, 4.399670004834926e-14, 4.050841424055329e-15, 3.550382974769147e-16, 2.968943605712515e-17, 2.373725527638150e-18, 1.817982826177472e-19,
1.365215625394519e-01, 9.940150780496021e-02, 5.504491679768124e-02, 2.420353403763610e-02, 8.754004703841717e-03, 2.677292962615475e-03, 7.074957998061353e-04, 1.643297392603486e-04, 3.401326185388696e-05, 6.344643217704178e-06, 1.076589412253243e-06, 1.674908523167179e-07, 2.405126927933182e-08, 3.206226091773820e-09, 3.987817170659304e-10, 4.648024616945390e-11, 5.096571914817954e-12, 5.275485768329867e-13, 5.170847515824731e-14, 4.812625779666554e-15, 4.263971781938428e-16, 3.604536820547452e-17, 2.913344085808744e-18, 2.255638717604414e-19,
1.350525334106582e-01, 9.871705215402882e-02, 5.501168031279696e-02, 2.437694362322211e-02, 8.893138322917294e-03, 2.744985540450303e-03, 7.323704999569361e-04, 1.717918919529598e-04, 3.591688393142303e-05, 6.768371186962053e-06, 1.160383241617890e-06, 1.824122480497016e-07, 2.646926725487995e-08, 3.565847678891097e-09, 4.482166251340895e-10, 5.279845486715294e-11, 5.851192463348640e-12, 6.121437075569326e-13, 6.064387835062761e-14, 5.704924050656394e-15, 5.108951139791197e-16, 4.365386872560748e-17, 3.566369330167751e-18, 2.791066019456286e-19,
1.336144040888272e-01, 9.803949856121902e-02, 5.497309508250176e-02, 2.454605593755356e-02, 9.031279156599358e-03, 2.813031229159386e-03, 7.576578943658639e-04, 1.794610081015710e-04, 3.789449288897494e-05, 7.213313151684881e-06, 1.249319123730876e-06, 1.984196761906523e-07, 2.909116854772088e-08, 3.959993385031350e-09, 5.029810087244999e-10, 5.987326390554728e-11, 6.705291860337856e-12, 7.089239613897369e-13, 7.097671364245414e-14, 6.747917333372424e-15, 6.107307543459468e-16, 5.274061460669575e-17, 4.354704055059755e-18, 3.444428212174060e-19,
1.322062334333486e-01, 9.736883708692963e-02, 5.492937860245202e-02, 2.471092888262801e-02, 9.168399190177930e-03, 2.881407001251973e-03, 7.833523611377963e-04, 1.873380343759537e-04, 3.994746282051951e-05, 7.680132802188750e-06, 1.343620693115701e-06, 2.155733959904160e-07, 3.193071751263983e-08, 4.391401859200216e-09, 5.635613754954379e-10, 6.778284084897165e-11, 7.670352659956033e-12, 8.194446112602215e-13, 8.290255569472042e-14, 7.964568745762543e-15, 7.284337146306570e-16, 6.356813733477883e-17, 5.304110028675692e-18, 4.239703267348593e-19,
1.308271166947568e-01, 9.670505170975720e-02, 5.488074100646578e-02, 2.487162107302187e-02, 9.304472024488522e-03, 2.950090125274044e-03, 8.094481035423225e-04, 1.954238043184951e-04, 4.207714417650384e-05, 8.169497773844485e-06, 1.443516505549581e-06, 2.339358323415532e-07, 3.500233176535981e-08, 4.862980474015098e-09, 6.304802474520491e-10, 7.661210330582599e-11, 8.758990258172757e-12, 9.454335362707468e-13, 9.664110385963187e-14, 9.380959619861901e-15, 8.669087877432848e-16, 7.644121738162290e-17, 6.444822452765226e-18, 5.205340375299165e-19,
1.294761838595980e-01, 9.604812083998791e-02, 5.482738527929657e-02, 2.502819172172810e-02, 9.439472830566873e-03, 3.019058178955588e-03, 8.359391599680432e-04, 2.037190391668415e-04, 4.428486268757119e-05, 8.682079143859520e-06, 1.549239958728982e-06, 2.535715963702347e-07, 3.832112025349037e-08, 5.377812345038096e-09, 7.042981508922770e-10, 8.645318030336949e-11, 9.985044828947013e-12, 1.088807413407960e-12, 1.124387488230190e-13, 1.102666044119773e-14, 1.029485297964165e-15, 9.171297577525697e-17, 7.812251763115590e-18, 6.375018529249059e-19,
1.281525980796180e-01, 9.539801779740308e-02, 5.476950746623100e-02, 2.518070053300432e-02, 9.573378304428374e-03, 3.088289061246533e-03, 8.628194137330224e-04, 2.122243488031243e-04, 4.657191833639025e-05, 9.218550926551460e-06, 1.661029207036958e-06, 2.745475040447625e-07, 4.190290113194748e-08, 5.939163455355666e-09, 7.856156717928644e-10, 9.740589587026389e-11, 1.136367897794635e-11, 1.251689133794771e-12, 1.305713669676290e-13, 1.293513948649666e-14, 1.219972102662260e-15, 1.097917405600809e-16, 9.447783666496933e-18, 7.788521005008553e-19,
1.268555541806114e-01, 9.475471125578176e-02, 5.470729687925472e-02, 2.532920760190519e-02, 9.706166622062740e-03, 3.157761003284721e-03, 8.900826027399140e-04, 2.209402328230751e-04, 4.893958437795266e-05, 9.779589567949451e-06, 1.779127070582193e-06, 2.969325927651768e-07, 4.576421941491665e-08, 6.550489878649850e-09, 8.750755764531960e-10, 1.095782753141433e-10, 1.291148134191576e-11, 1.436426511295615e-12, 1.513473583252680e-13, 1.514421230198152e-14, 1.442718787887443e-15, 1.311487732035538e-16, 1.139968947302281e-17, 9.492741461866736e-19,
1.255842772465503e-01, 9.411816565632655e-02, 5.464093629957048e-02, 2.547377332018273e-02, 9.837817394726452e-03, 3.227452578339005e-03, 9.177223289653836e-04, 2.298670817184043e-04, 5.138910640858330e-05, 1.036587344053602e-05, 1.903780938687686e-06, 3.207981359025003e-07, 4.992236437675441e-08, 7.215445093741475e-09, 9.733649971011873e-10, 1.230870746624711e-10, 1.464657636334663e-11, 1.645612353315621e-12, 1.751109447419193e-13, 1.769653536310466e-14, 1.702683646170032e-15, 1.563269477852398e-16, 1.372416004809464e-17, 1.154283924873196e-18,
1.243380212748608e-01, 9.348834159208924e-02, 5.457060217628678e-02, 2.561445828824996e-02, 9.968311624607729e-03, 3.297342710769967e-03, 9.457320677744865e-04, 2.390051781659056e-04, 5.392170148379368e-05, 1.097808233891751e-05, 2.035242668014388e-06, 3.462176552602570e-07, 5.439538667460883e-08, 7.937887383336384e-09, 1.081217682051028e-09, 1.380583337145413e-10, 1.658874047123174e-11, 1.882105965624088e-12, 2.022457456488766e-13, 2.064014746278555e-14, 2.005509069613683e-15, 1.859504841385383e-16, 1.648647808205435e-17, 1.400356354347746e-18,
1.231160678989604e-01, 9.286519616533510e-02, 5.449646482112658e-02, 2.575132323291315e-02, 1.009763166093150e-02, 3.367410684050201e-03, 9.741051770516493e-04, 2.483546984168397e-04, 5.653855728499979e-05, 1.161689697718534e-05, 2.173768475511741e-06, 3.732669314349478e-07, 5.920211516597738e-08, 8.721887309471263e-09, 1.199416309887676e-09, 1.546279531307197e-10, 1.875952489942157e-11, 2.149056164977742e-12, 2.331786496134585e-13, 2.402906258907949e-14, 2.357605038556871e-15, 2.207358450322651e-16, 1.976234486539309e-17, 1.695076819780033e-18,
1.219177251743936e-01, 9.224868331965672e-02, 5.441868859903508e-02, 2.588442893058950e-02, 1.022576115656519e-02, 3.437636147885430e-03, 1.002834906140860e-03, 2.579157137802621e-04, 5.924083133502276e-05, 1.228299848870427e-05, 2.319618826393191e-06, 4.020240120562139e-07, 6.436217339491737e-08, 9.571735257937252e-09, 1.328794867037888e-09, 1.729422959619434e-10, 2.118238537441184e-11, 2.449925875213996e-12, 2.683840006338174e-13, 2.792391827466692e-14, 2.766241435766172e-15, 2.615039170052016e-16, 2.363937937015477e-17, 2.047314162039355e-18,
1.207423264251166e-01, 9.163875414852680e-02, 5.433743211458994e-02, 2.601383613573698e-02, 1.035268502517959e-02, 3.507999124476987e-03, 1.031914404588558e-03, 2.676881921940767e-04, 6.202965026219221e-05, 1.297706792903621e-05, 2.473058317339980e-06, 4.325692178913861e-07, 6.989599572116743e-08, 1.049194904375657e-08, 1.470241087972411e-09, 1.931588139981313e-10, 2.388281890427782e-11, 2.788518384322531e-12, 3.083881189424036e-13, 3.239268362955123e-14, 3.239649968370208e-15, 3.091936046288577e-16, 2.821880918159009e-17, 2.467417872443522e-18,
1.195892291466784e-01, 9.103535718186752e-02, 5.425284839414182e-02, 2.613960551423375e-02, 1.047838939901352e-02, 3.578480013965384e-03, 1.061336730683569e-03, 2.776719998777261e-04, 6.490610911278168e-05, 1.369978578268087e-05, 2.634355555141388e-06, 4.649851468030775e-07, 7.582484306703713e-08, 1.148728156960176e-08, 1.624698957169279e-09, 2.154466992885770e-10, 2.688850789992763e-11, 3.169005341779859e-12, 3.537741768905319e-13, 3.751143150481489e-14, 3.787136534603534e-15, 3.648769787993429e-16, 3.361737470598624e-17, 2.967442490878436e-18,
1.184578139632368e-01, 9.043843865210993e-02, 5.416508506363257e-02, 2.626179758145523e-02, 1.060286158728501e-02, 3.649059599093826e-03, 1.091094859789258e-03, 2.878669030605655e-04, 6.787127071141763e-05, 1.445183147428588e-05, 2.803783030983595e-06, 4.993566755523418e-07, 8.217081825756083e-08, 1.256272852887715e-08, 1.793171271853922e-09, 2.399875611606185e-10, 3.022947185885699e-11, 3.595956577139638e-12, 4.051874513007427e-13, 4.336517947909532e-14, 4.419204929956599e-15, 4.297761311757424e-16, 3.996947010898570e-17, 3.561402525420737e-18,
1.173474836355207e-01, 8.984794274111772e-02, 5.407428452205746e-02, 2.638047264480611e-02, 1.072609003528685e-02, 3.719719049129664e-03, 1.121181692463777e-03, 2.982725697801101e-04, 7.092616506902224e-05, 1.523388288495087e-05, 2.981616990602874e-06, 5.357709594437394e-07, 8.895688093010009e-08, 1.372353614502975e-08, 1.976722264418545e-09, 2.669761290349659e-10, 3.393822684015390e-11, 4.074371822506171e-12, 4.633409744928546e-13, 5.004880461048477e-14, 5.147692847571348e-15, 5.052818991173129e-16, 4.742954662194323e-17, 4.265561561574634e-18,
1.162576621170154e-01, 8.926381180926009e-02, 5.398058411055487e-02, 2.649569075047536e-02, 1.084806428419963e-02, 3.790439923080778e-03, 1.151590062365078e-03, 3.088885717444935e-04, 7.407178883777493e-05, 1.604661587422048e-05, 3.168137300521657e-06, 5.743174298123831e-07, 9.620686199030421e-08, 1.497520893852113e-08, 2.176480283311047e-09, 2.966209813070890e-10, 3.804995295761406e-11, 4.609714423073937e-12, 5.290216070122378e-13, 5.766803715467948e-14, 5.985921190726236e-15, 5.929746384525723e-16, 5.617480620051040e-17, 5.098759610021732e-18,
1.151877936558066e-01, 8.868598660783249e-02, 5.388411627712053e-02, 2.660751163419133e-02, 1.096877493165064e-02, 3.861204172242992e-03, 1.182312743937984e-03, 3.197143862536378e-04, 7.730910481250720e-05, 1.689070380833303e-05, 3.363627310588440e-06, 6.150877893566993e-07, 1.039454775921055e-07, 1.632351751277337e-08, 2.393640531073054e-09, 3.291453005340596e-10, 4.260267011548482e-11, 5.207947121386859e-12, 6.030965559133740e-13, 6.634053871523686e-14, 6.948857781061010e-15, 6.946472351673900e-16, 6.640821603848010e-17, 6.082783155499179e-18,
1.141373419396591e-01, 8.811440647594390e-02, 5.378500873695780e-02, 2.671599467576376e-02, 1.108821359304311e-02, 3.931994142113540e-03, 1.213342459881241e-03, 3.307493981737822e-04, 8.063904147787762e-05, 1.776681709526162e-05, 3.568373713044090e-06, 6.581760053241968e-07, 1.121983426202265e-07, 1.777450635030094e-08, 2.629467858097434e-09, 3.647876551352681e-10, 4.763742220855074e-11, 5.875570002351460e-12, 6.865203632765153e-13, 7.619707056354244e-14, 8.053296614835920e-15, 8.123305616536796e-16, 7.836187713997864e-17, 7.242782818282207e-18,
1.131057892820495e-01, 8.754900952291669e-02, 5.368338462848608e-02, 2.682119885720846e-02, 1.120637286367630e-02, 4.002792573704689e-03, 1.244671888393129e-03, 3.419929019601937e-04, 8.406249260061578e-05, 1.867562272705607e-05, 3.782666398338486e-06, 7.036783005610074e-07, 1.209919836545104e-07, 1.933450161015640e-08, 2.885299610568547e-09, 4.038028077835747e-10, 5.319847000501301e-11, 6.619660687323712e-12, 7.803423904587248e-13, 8.738275814433822e-14, 9.318053891034583e-15, 9.483215985423291e-16, 9.230078304359727e-17, 8.607744026066598e-18,
1.120926358469965e-01, 8.698973279717474e-02, 5.357936266504040e-02, 2.692318272425947e-02, 1.132324628167351e-02, 4.073582604290505e-03, 1.276293670194684e-03, 3.534441037230420e-04, 8.758031686606622e-05, 1.961778382996438e-05, 4.006798307921984e-06, 7.516931424393378e-07, 1.303538513962511e-07, 2.101011891775084e-08, 3.162548530943296e-09, 4.464625506307475e-10, 5.933349292688851e-11, 7.447916866774136e-12, 8.857148244008938e-13, 1.000584580671662e-13, 1.076418210952989e-14, 1.105214459380178e-15, 1.085270078824299e-16, 1.021101662023580e-17,
1.110973989106571e-01, 8.643651244253032e-02, 5.347305728230351e-02, 2.702200435108194e-02, 1.143882829173159e-02, 4.144347767618759e-03, 1.308200415330174e-03, 3.651021233315883e-04, 9.119333755821293e-05, 2.059395922278389e-05, 4.241065284236497e-06, 8.023212296802212e-07, 1.403123325375890e-07, 2.280827113806011e-08, 3.462705709228326e-09, 4.930565674775595e-10, 6.609379993846965e-11, 8.368701262115363e-12, 1.003901233127932e-12, 1.144022341745853e-13, 1.241520361485999e-14, 1.285934572527504e-15, 1.273843662638437e-16, 1.209090988906689e-17,
1.101196121577691e-01, 8.588928384272233e-02, 5.336457878152082e-02, 2.711772130800772e-02, 1.155311420970277e-02, 4.215071993618967e-03, 1.340384709744920e-03, 3.769659965520141e-04, 9.490234228231784e-05, 2.160480298386368e-05, 4.485765918130611e-06, 8.556654770921268e-07, 1.508967610559579e-07, 2.473617612319563e-08, 3.787343583208556e-09, 5.438933229647592e-10, 7.353454974874452e-11, 9.391089108246191e-12, 1.136285698388396e-12, 1.306109495742375e-13, 1.429736504142176e-14, 1.493776292675397e-15, 1.492635909719554e-16, 1.429136013398945e-17,
1.091588250111299e-01, 8.534798175499896e-02, 5.325403346855420e-02, 2.721039063212317e-02, 1.166610018801660e-02, 4.285739607636393e-03, 1.372839121640986e-03, 3.890346772143788e-04, 9.870808272926486e-05, 2.265096402715097e-05, 4.741201393922428e-06, 9.118309982490058e-07, 1.621374289165025e-07, 2.680136442530169e-08, 4.138118985684733e-09, 5.993009788262967e-10, 8.171498052857595e-11, 1.052491824922088e-11, 1.284382554180545e-12, 1.489019818234629e-13, 1.643991419909213e-14, 1.732444233336832e-15, 1.746080782441462e-16, 1.686267853626817e-17,
1.082146019924001e-01, 8.481254043348736e-02, 5.314152378883687e-02, 2.730006880054705e-02, 1.177778318194738e-02, 4.356335329220968e-03, 1.405556207611744e-03, 4.013070394043727e-04, 1.026112744806632e-04, 2.373308568764667e-05, 5.007675332332722e-06, 9.709250861342889e-07, 1.740655961663474e-07, 2.901168696574251e-08, 4.516776236683323e-09, 6.596283372108351e-10, 9.069864933789046e-11, 1.178084194018881e-11, 1.449846760702500e-12, 1.695150687618628e-13, 1.887540102443722e-14, 2.006098631575670e-15, 2.039202543606360e-16, 1.986238780324160e-17,
1.072865221126177e-01, 8.428289374304372e-02, 5.302714845829771e-02, 2.738681170624362e-02, 1.188816091673003e-02, 4.426844270498913e-03, 1.438528518556629e-03, 4.137818796757009e-04, 1.066125968537280e-04, 2.485180531660733e-05, 5.285493631509270e-06, 1.033057191780141e-06, 1.867135004055678e-07, 3.137532265155873e-08, 4.925150278510668e-09, 7.252458110417028e-10, 1.005536814521304e-10, 1.317038444936251e-11, 1.634484944042908e-12, 1.927142927986446e-13, 2.164000431176257e-14, 2.319405077128251e-15, 2.377686215233470e-16, 2.335615683841950e-17,
1.063741782908982e-01, 8.375897526422982e-02, 5.291100259032602e-02, 2.747067463622340e-02, 1.199723185552519e-02, 4.497251934153883e-03, 1.471748605377806e-03, 4.264579192791012e-04, 1.107126927849293e-04, 2.600775388680366e-05, 5.574964306361314e-06, 1.098338900933951e-06, 2.001143656207040e-07, 3.390078593020601e-08, 5.365169851435418e-09, 7.965464213491537e-10, 1.113530297707881e-10, 1.470599955425841e-11, 1.840267132693538e-12, 2.187902117773660e-13, 2.477388603028737e-14, 2.677588959965421e-15, 2.767955454973615e-16, 2.741884350132016e-17,
1.054771767998783e-01, 8.324071839002097e-02, 5.279317781885227e-02, 2.755171225199113e-02, 1.210499516823246e-02, 4.567544211043430e-03, 1.505209024460776e-03, 4.393338064041719e-04, 1.149121687513700e-04, 2.720155560811893e-05, 5.876397326420727e-06, 1.166883908786589e-06, 2.143024103676556e-07, 3.659693427363687e-08, 5.838860707698643e-09, 8.739468214721787e-10, 1.231747444839711e-10, 1.640113202681015e-11, 2.069339222714637e-12, 2.480621448604476e-13, 2.832157512867473e-14, 3.086495013261083e-15, 3.217258522556111e-16, 3.213565640401483e-17,
1.045951367365417e-01, 8.272805641480951e-02, 5.267376241762353e-02, 2.762997857210708e-02, 1.221145070114872e-02, 4.637707377475605e-03, 1.538902342941252e-03, 4.524081184303565e-04, 1.192115947288355e-04, 2.843382755374485e-05, 6.190104452443771e-06, 1.238807992799408e-06, 2.293128552918055e-07, 3.947297558285191e-08, 6.348348861470309e-09, 9.578883479902003e-10, 1.361022531656592e-10, 1.827028220217646e-11, 2.324036204115989e-12, 2.808806221991320e-13, 3.233238282599894e-14, 3.552652352697643e-15, 3.733763059155292e-16, 3.760344763512949e-17,
1.037276895171424e-01, 8.222092261623058e-02, 5.255284141575403e-02, 2.770552695673468e-02, 1.231659894746715e-02, 4.707728092169458e-03, 1.572821143760915e-03, 4.656793641835879e-04, 1.236115041854329e-04, 2.970517929720627e-05, 6.516399071964220e-06, 1.314228983669206e-06, 2.451819299742280e-07, 4.253847550412311e-08, 6.895863872293499e-09, 1.048838098207854e-09, 1.502246514546004e-10, 2.032907372614967e-11, 2.606896181729272e-12, 3.176300074809836e-13, 3.686085148894753e-14, 4.083345438068735e-15, 4.326660455957411e-16, 4.393214931181413e-17,
1.028744783950055e-01, 8.171925033030206e-02, 5.243049670963385e-02, 2.777841009405322e-02, 1.242044101861067e-02, 4.777593392922325e-03, 1.606958030514883e-03, 4.791459861952700e-04, 1.281123941097272e-04, 3.101621256042150e-05, 6.855596034005318e-06, 1.393266734472594e-06, 2.619468790938644e-07, 4.580336464818830e-08, 7.483742159484760e-09, 1.147290033978840e-09, 1.656370044756885e-10, 2.259432457601674e-11, 2.920675224539171e-12, 3.587313027761313e-13, 4.196723929861020e-14, 4.686691409254878e-15, 5.006280644620816e-16, 5.124636793930753e-17,
1.020351580000580e-01, 8.122297302033844e-02, 5.230680717127934e-02, 2.784867998842071e-02, 1.252297861639259e-02, 4.847290693005737e-03, 1.641305632093999e-03, 4.928063629604328e-04, 1.327147250722654e-04, 3.236752087298121e-05, 7.208011483154531e-06, 1.476043088033219e-06, 2.796459678965618e-07, 4.927794570382195e-08, 8.114430344889711e-09, 1.253766111617529e-09, 1.824406591461578e-10, 2.508412144952676e-11, 3.268363078109481e-12, 4.046451454347528e-13, 4.771804301655001e-14, 5.371724275864760e-15, 5.784218201857783e-16, 5.968715170965052e-17,
1.012093938990012e-01, 8.073202434006753e-02, 5.218184875321113e-02, 2.791638795017771e-02, 1.262421400599575e-02, 4.916807777310960e-03, 1.675856607125186e-03, 5.066588111920489e-04, 1.374189213193689e-04, 3.375968924280369e-05, 7.573962693200839e-06, 1.562681842557194e-06, 2.983184869628893e-07, 5.297290043730790e-08, 8.790488621327901e-09, 1.368817437609669e-09, 2.007435675020411e-10, 2.781789761627666e-11, 3.653199775384526e-12, 4.558750071213074e-13, 5.418656126893893e-14, 6.148486468170496e-15, 6.673470723131394e-16, 6.941394709938614e-17,
1.003968621750960e-01, 8.024633819135066e-02, 5.205569458994495e-02, 2.798158458698825e-02, 1.272414998976066e-02, 4.986132798264149e-03, 1.710603648213344e-03, 5.207015880686700e-04, 1.422253708980722e-04, 3.519329383830303e-05, 7.953767900530540e-06, 1.653308715583873e-06, 3.180047562676678e-07, 5.689929656947644e-08, 9.514594144000221e-09, 1.493025449796421e-09, 2.206606211710906e-10, 3.081651432533847e-11, 4.078693181763980e-12, 5.129706054052729e-13, 6.145350087931256e-14, 7.028128286434180e-15, 7.688590486559805e-16, 8.060676243435522e-17,
9.959724902658827e-02, 7.976584877688027e-02, 5.192841509618175e-02, 2.804431979661956e-02, 1.282278988177199e-02, 5.055254271530322e-03, 1.745539485988411e-03, 5.349328934726814e-04, 1.471344258110764e-04, 3.666890168218364e-05, 8.347746137472945e-06, 1.748051306300778e-06, 3.387461285251557e-07, 6.106859452211341e-08, 1.028954444207558e-08, 1.627003123668822e-09, 2.423139971087474e-10, 3.410234586231429e-11, 4.548637510938625e-12, 5.765315386630650e-13, 6.960762889489191e-14, 8.023015816337981e-15, 8.845850497657506e-16, 9.346855748165081e-17,
9.881025038285256e-02, 7.929049064820420e-02, 5.180007806178290e-02, 2.810464276106697e-02, 1.292013748323172e-02, 5.124161071524382e-03, 1.780656892961327e-03, 5.493508722166236e-04, 1.521464022005844e-04, 3.818707035695243e-05, 8.756217065782770e-06, 1.847039056272944e-06, 3.605849918148403e-07, 6.549265402570843e-08, 1.111826084762129e-08, 1.771396203372983e-09, 2.658335147037972e-10, 3.769936834821805e-11, 5.067132848533944e-12, 6.472111553809190e-13, 7.874647306836179e-14, 9.146847910002976e-15, 1.016342607862166e-15, 1.082278796082170e-16,
9.803557153738396e-02, 7.882019874940359e-02, 5.167074874361711e-02, 2.816260194193581e-02, 1.301619705860717e-02, 5.192842426746662e-03, 1.815948687192807e-03, 5.639536162551915e-04, 1.572615805598912e-04, 3.974834772222070e-05, 9.179500810441406e-06, 1.950403208638429e-06, 3.835647714837804e-07, 7.018374058068185e-08, 1.200379193899411e-08, 1.926884456989824e-09, 2.913570043500818e-10, 4.163325237164632e-11, 5.638605721136532e-12, 7.257206692832463e-13, 8.897707367641312e-14, 1.041478286502288e-14, 1.166159324259410e-15, 1.251417686163139e-16,
9.727292679681152e-02, 7.835490845672709e-02, 5.154048995436377e-02, 2.821824507699580e-02, 1.311097331254068e-02, 5.261287914959592e-03, 1.851407735778908e-03, 5.787391668806391e-04, 1.624802059715950e-04, 4.135327164384598e-05, 9.617917793954212e-06, 2.058276765822928e-06, 4.077299313224313e-07, 7.515453176440972e-08, 1.294931699576535e-08, 2.094182955616897e-09, 3.190306875700471e-10, 4.593145954461002e-11, 6.267830748772579e-12, 8.128335320447525e-13, 1.004167896781518e-13, 1.184357546805510e-14, 1.336294517379524e-15, 1.444989540320274e-16,
9.652203914515441e-02, 7.789455561446834e-02, 5.140936214835806e-02, 2.827161917782927e-02, 1.320447136750770e-02, 5.329487458221292e-03, 1.887026958157459e-03, 5.937055168994826e-04, 1.678024883713117e-04, 4.300236973494619e-05, 1.007178857131592e-05, 2.170794445827609e-06, 4.331259740118572e-07, 8.041812337656099e-08, 1.395814946221485e-08, 2.274043375744194e-09, 3.490095687650399e-10, 5.062334307115951e-11, 6.959953419367560e-12, 9.093900756769175e-13, 1.131941623405734e-13, 1.345172510481082e-14, 1.529262821873541e-15, 1.666233703881662e-16,
9.578263992257842e-02, 7.743907656734916e-02, 5.127742350456166e-02, 2.832277052849697e-02, 1.329669674220937e-02, 5.397431317791147e-03, 1.922799329239522e-03, 6.088506127885058e-04, 1.732286028357688e-04, 4.469615910879892e-05, 1.054143366581103e-05, 2.288092637145328e-06, 4.597994408411959e-07, 8.598803541546158e-08, 1.503374041639460e-08, 2.467255324380478e-09, 3.814578386561139e-10, 5.574025241654021e-11, 7.720514024139179e-12, 1.016302437009615e-12, 1.274498395845826e-13, 1.525963567477069e-14, 1.747859888195692e-15, 1.918780179112654e-16,
9.505446851795438e-02, 7.698840818965891e-02, 5.114473000674206e-02, 2.837174468515122e-02, 1.338765533068529e-02, 5.465110088921628e-03, 1.958717882370100e-03, 6.241723568282236e-04, 1.787586898941769e-04, 4.643514614362133e-05, 1.102717340581086e-05, 2.410309352361236e-06, 4.877979106951858e-07, 9.187821787841344e-08, 1.617968204173252e-08, 2.674647686352031e-09, 4.165492894676945e-10, 6.131564216307201e-11, 8.555472793260899e-12, 1.134559777016221e-12, 1.433375644334063e-13, 1.728978808662751e-14, 1.995190341204236e-15, 2.206691979981083e-16,
9.433727207455363e-02, 7.654248791137964e-02, 5.101133552094250e-02, 2.841858647652822e-02, 1.347735338213166e-02, 5.532514695549932e-03, 1.994775712122358e-03, 6.396686092120724e-04, 1.843928558617751e-04, 4.821982625920918e-05, 1.152932776272319e-05, 2.537584180494639e-06, 5.171699983124910e-07, 9.810305637911664e-08, 1.739971109812282e-08, 2.897089993161563e-09, 4.544677418948141e-10, 6.738518513724787e-11, 9.471236271479002e-12, 1.265233808054822e-12, 1.610252310755892e-13, 1.956692614932106e-14, 2.274698166003197e-15, 2.534511549542866e-16,
9.363080520825191e-02, 7.610125374151366e-02, 5.087729187032287e-02, 2.846334000525633e-02, 1.356579748141006e-02, 5.599636384902300e-03, 2.030965976929657e-03, 6.553371901297279e-04, 1.901311731944663e-04, 5.005068370539680e-05, 1.204821619024540e-05, 2.670058238139586e-06, 5.479653518164733e-07, 1.046773775755713e-07, 1.869771238942770e-08, 3.135493812761613e-09, 4.954074838827477e-10, 7.398688989069914e-11, 1.047468497367077e-11, 1.409484642418555e-12, 1.806960121869403e-13, 2.211825671358120e-14, 2.590199699301462e-15, 2.907311576700012e-16,
9.293482973764515e-02, 7.566464428881489e-02, 5.074264890745096e-02, 2.850604864991997e-02, 1.365299453023164e-02, 5.666466722023168e-03, 2.067281901559736e-03, 6.711758818230607e-04, 1.959736808634691e-04, 5.192819136228470e-05, 1.258415746506593e-05, 2.807874119462260e-06, 5.802346495209521e-07, 1.116164544020736e-07, 2.007772222430005e-08, 3.390814159564047e-09, 5.395737212358250e-10, 8.116122261567833e-11, 1.157320236059420e-11, 1.568566975904055e-12, 2.025495612897148e-13, 2.497366496013148e-14, 2.945919415057906e-15, 3.330750572307769e-16,
9.224911442551280e-02, 7.523259878011221e-02, 5.060745458412230e-02, 2.854675506782223e-02, 1.373895172900133e-02, 5.732997584240676e-03, 2.103716779435382e-03, 6.871824306133729e-04, 2.019203847489258e-04, 5.385281055216658e-05, 1.313746952915364e-05, 2.951175845113694e-06, 6.140295960143499e-07, 1.189360110991636e-07, 2.154393186722485e-08, 3.664050923975288e-09, 5.871830400599200e-10, 8.895123357356137e-11, 1.277470517529832e-11, 1.743836620417860e-12, 2.268032940627927e-13, 2.816594577311748e-14, 3.346528704111551e-15, 3.811133589071830e-16,
9.157343473109215e-02, 7.480505707640023e-02, 5.047175501878433e-02, 2.858550119839258e-02, 1.382367655930664e-02, 5.799221155579441e-03, 2.140263974805935e-03, 7.033545488986418e-04, 2.079712580514236e-04, 5.582499086307346e-05, 1.370846933376877e-05, 3.100108810116645e-06, 6.494029175264932e-07, 1.266522280356309e-07, 2.310069097667020e-08, 3.956250320715854e-09, 6.384638810307232e-10, 9.740268811258213e-11, 1.408767518083769e-11, 1.936757399945776e-12, 2.536937526535655e-13, 3.173105218090755e-14, 3.797187858872315e-15, 4.355478495423137e-16,
9.090757257265547e-02, 7.438195968686179e-02, 5.033559456163991e-02, 2.862232826718910e-02, 1.390717676703562e-02, 5.865129921130825e-03, 2.176916924773963e-03, 7.196899171196377e-04, 2.141262417204054e-04, 5.784516998383944e-05, 1.429747268532359e-05, 3.254819730785757e-06, 6.864083565831388e-07, 1.347817463169431e-07, 2.475251102723615e-08, 4.268506355152533e-09, 6.936570254673271e-10, 1.065642023485700e-10, 1.552119234006311e-11, 2.148908424509092e-12, 2.834780571804550e-13, 3.570836189115405e-14, 4.303591485977814e-15, 4.971588240628567e-16,
9.025131609990869e-02, 7.396324778097428e-02, 5.019901585750386e-02, 2.865727679044730e-02, 1.398946034610833e-02, 5.930716661390439e-03, 2.213669141181466e-03, 7.361861856938581e-04, 2.203852448984561e-04, 5.991377355058082e-05, 1.490479409321508e-05, 3.415456590740248e-06, 7.251006659541204e-07, 1.433416721747228e-07, 2.650406871269168e-08, 4.601962306842127e-09, 7.530160931779643e-10, 1.164873835798832e-10, 1.708496947834169e-11, 2.381991757023430e-12, 3.164354487543704e-13, 4.014096299289093e-14, 4.872017582112220e-15, 5.668129576833615e-16,
8.960445947575328e-02, 7.354886319884295e-02, 5.006205990648286e-02, 2.869038658013066e-02, 1.407053552280639e-02, 5.995974446571959e-03, 2.250514212359875e-03, 7.528409769163339e-04, 2.267481453804826e-04, 6.203121500446885e-05, 1.553074661974640e-05, 3.582168586068393e-06, 7.655356019017667e-07, 1.523495811321605e-07, 2.836020932679596e-08, 4.957812229457516e-09, 8.168080520319696e-10, 1.272269755050077e-10, 1.878938847009322e-11, 2.637840488260475e-12, 3.528689284877506e-13, 4.507595994546043e-14, 5.509380520940699e-15, 6.454718733579984e-16,
8.896680266697786e-02, 7.313874845989443e-02, 4.992476612255025e-02, 2.872169674944044e-02, 1.415041074068492e-02, 6.060896630905864e-03, 2.287445804748173e-03, 7.696518868264576e-04, 2.332147900868091e-04, 6.419789546066492e-05, 1.617564173224787e-05, 3.755106069703085e-06, 8.077699167370219e-07, 1.618235219405313e-07, 3.032595011881105e-08, 5.337302466239320e-09, 8.853137391991378e-10, 1.388410083084364e-10, 2.064553799001422e-11, 2.918427235389030e-12, 3.931069971010149e-13, 5.056480102219375e-14, 6.223288212343722e-15, 7.342014571639364e-16,
8.833815124346769e-02, 7.273284677005402e-02, 4.978717239008213e-02, 2.875124571874467e-02, 1.422909464605162e-02, 6.125476846931134e-03, 2.324457664383341e-03, 7.866164870400660e-04, 2.397849955492429e-04, 6.641420358827621e-05, 1.683978915750290e-05, 3.934420495067529e-06, 8.518613506913889e-07, 1.717820202822412e-07, 3.240648362062672e-08, 5.741733180090119e-09, 9.588283939847188e-10, 1.513909536774420e-10, 2.266525286979543e-11, 3.225873079839293e-12, 4.375054998780313e-13, 5.666362842599061e-14, 7.022103708844586e-15, 8.341819775795760e-16,
8.771831618554012e-02, 7.233110202752301e-02, 4.964931511842275e-02, 2.877907122188902e-02, 1.430659607399763e-02, 6.189708999787495e-03, 2.361543618267375e-03, 8.037323265461126e-04, 2.464585484091828e-04, 6.868051550118127e-05, 1.752349673857848e-05, 4.120264359050001e-06, 8.978686231135631e-07, 1.822440822361263e-07, 3.460718094243863e-08, 6.172459897403254e-09, 1.037662202175329e-09, 1.649418848092439e-10, 2.486115510102385e-11, 3.562456960492517e-12, 4.864495818645163e-13, 6.343365234424037e-14, 7.915011548316989e-15, 9.467190680535732e-16,
8.710711369903623e-02, 7.193345882726405e-02, 4.951122929454283e-02, 2.880521031285392e-02, 1.438292403496486e-02, 6.253587261515280e-03, 2.398697575615016e-03, 8.209969334673345e-04, 2.532352059268588e-04, 7.099719465956443e-05, 1.822707029415417e-05, 4.312791144366235e-06, 9.458514230002605e-07, 1.932291975009876e-07, 3.693359503394228e-08, 6.630895064693805e-09, 1.122140851798014e-09, 1.795626414648082e-10, 2.724669652479237e-11, 3.930625538446235e-12, 5.403557583458121e-13, 7.094155026186215e-14, 8.912089136740115e-15, 1.073255635850778e-15,
8.650436503781372e-02, 7.153986246429463e-02, 4.937294853385461e-02, 2.882969937272487e-02, 1.445808770183487e-02, 6.317106065369519e-03, 2.435913528986304e-03, 8.384078167844056e-04, 2.601146965008212e-04, 7.336459178199023e-05, 1.895081348043803e-05, 4.512155261367611e-06, 9.958703988714055e-07, 2.047573423736406e-07, 3.939146390803239e-08, 7.118509617076674e-09, 1.212606100181732e-09, 1.953260001221459e-10, 2.983620324832191e-11, 4.333003549842922e-12, 5.996741057831531e-13, 7.925989290359910e-14, 1.002438348994188e-14, 1.215384763913170e-15,
8.590989633330798e-02, 7.115025893588313e-02, 4.923450512924451e-02, 2.885257411694455e-02, 1.453209639752427e-02, 6.380260100154423e-03, 2.473185555308003e-03, 8.559624680231413e-04, 2.670967201968144e-04, 7.578304476784109e-05, 1.969502765575244e-05, 4.718511989352887e-06, 1.047987148000466e-06, 2.168489824780320e-07, 4.198671382402859e-08, 7.636834557614739e-09, 1.309416352197485e-09, 2.123088492784782e-10, 3.264492182862999e-11, 4.772404663476446e-12, 6.648905785300986e-13, 8.846759823004524e-14, 1.126399366893922e-14, 1.374863676391478e-15,
8.532353843084148e-02, 7.076459494273507e-02, 4.909593009838325e-02, 2.887386960281764e-02, 1.460495958307206e-02, 6.443044304584093e-03, 2.510507816787925e-03, 8.736583629043982e-04, 2.741809492851974e-04, 7.825287862993440e-05, 2.046001174786731e-05, 4.932017417440698e-06, 1.102264205011312e-06, 2.295250752422682e-07, 4.472546242748164e-08, 8.187462546539856e-09, 1.412947249540423e-09, 2.305923699470273e-10, 3.568906726295573e-11, 5.251842860105466e-12, 7.365294567930774e-13, 9.865041496618333e-14, 1.264415925965009e-14, 1.553628842590462e-15,
8.474512673238008e-02, 7.038281788925040e-02, 4.895725322937138e-02, 2.889362023724076e-02, 1.467668684620438e-02, 6.505453861674750e-03, 2.547874561726030e-03, 8.914929629563759e-04, 2.813670287860916e-04, 8.077440543712841e-05, 2.124606212415273e-05, 5.152828385059360e-06, 1.158765029853529e-06, 2.428070721206764e-07, 4.761402184365330e-08, 8.772049499329649e-09, 1.523592270904280e-09, 2.502622213904608e-10, 3.898587282527422e-11, 5.774544350605421e-12, 8.151559314417813e-13, 1.099014371964290e-13, 1.417935526441722e-14, 1.753812298331547e-15,
8.417450104544752e-02, 7.000487588292834e-02, 4.881850312477660e-02, 2.891185978463156e-02, 1.474728789036233e-02, 6.567484193173479e-03, 2.585280125226249e-03, 9.094637170890942e-04, 2.886545770214650e-04, 8.334792426671947e-05, 2.205347246461811e-05, 5.381102422109983e-06, 1.217553995168677e-06, 2.567169205583122e-07, 5.065890172180333e-08, 9.392316192605499e-09, 1.641763342885735e-09, 2.714087321291917e-10, 4.255364178780358e-11, 6.343960050280533e-12, 9.013788314162349e-13, 1.223216516162821e-13, 1.588539378995019e-14, 1.977759268174587e-15,
8.361150543792507e-02, 6.963071773299051e-02, 4.867970724411712e-02, 2.892862137503302e-02, 1.481677252417881e-02, 6.629130954028107e-03, 2.622718929812723e-03, 9.275680631308848e-04, 2.960431861733788e-04, 8.597372116642990e-05, 2.288253363789904e-05, 5.616997688858032e-06, 1.278696373060453e-06, 2.712770656956028e-07, 5.386681222746345e-08, 1.005004987679996e-08, 1.767891461443520e-09, 2.941270962588008e-10, 4.641180106592335e-11, 6.963778626833549e-12, 9.958534996175758e-13, 1.360205190876284e-13, 1.777953293395981e-14, 2.228047176559527e-15,
8.305598809847667e-02, 6.926029294828803e-02, 4.854089194484477e-02, 2.894393751237044e-02, 1.488515065139077e-02, 6.690390026902507e-03, 2.660185485954291e-03, 9.458034293267960e-04, 3.035324228476546e-04, 8.865206912577801e-05, 2.373353358024880e-05, 5.860672915607767e-06, 1.342258321282236e-06, 2.865104518111078e-07, 5.724466697992477e-08, 1.074710589452664e-08, 1.902427323724464e-09, 3.185175751068132e-10, 5.058095682438653e-11, 7.637940139653554e-12, 1.099284823308669e-12, 1.511165922024837e-13, 1.988059329092763e-14, 2.507506140732277e-15,
8.250780120235121e-02, 6.889355173455455e-02, 4.840208252187864e-02, 2.895784008283953e-02, 1.495243226117289e-02, 6.751257516741171e-03, 2.697674392500799e-03, 9.641672357988601e-04, 3.111218286422339e-04, 9.138322805661938e-05, 2.460675717758578e-05, 6.112287342213174e-06, 1.408306868855915e-06, 3.024405235006519e-07, 6.079958593221763e-08, 1.148540930357091e-08, 2.045841970056204e-09, 3.446857042549420e-10, 5.508295208211549e-11, 8.370650288230199e-12, 1.212430425188464e-12, 1.677381706184742e-13, 2.220908251612202e-14, 2.819241043310619e-15,
8.196680078232728e-02, 6.853044499106169e-02, 4.826330324573958e-02, 2.897036036340630e-02, 1.501862741887988e-02, 6.811729745386784e-03, 2.735180337034859e-03, 9.826568959682318e-04, 3.188109207195344e-04, 9.416744478264390e-05, 2.550248615064344e-05, 6.372000657477973e-06, 1.476909901136330e-06, 3.190912265913713e-07, 6.453889819091647e-08, 1.226695650340765e-08, 2.198627435893929e-09, 3.727425059486960e-10, 5.994092635222876e-11, 9.166395287636151e-12, 1.336104021440251e-12, 1.860239959885599e-13, 2.478732840613976e-14, 3.166655287528912e-15,
8.143284660457649e-02, 6.817092430673032e-02, 4.812457739933368e-02, 2.898152903039991e-02, 1.508374625718396e-02, 6.871803246254041e-03, 2.772698096142521e-03, 1.001269817939256e-03, 3.265991923821236e-04, 9.700495303761020e-05, 2.642099894326464e-05, 6.639972938496584e-06, 1.548136144336063e-06, 3.364870087894894e-07, 6.847014477316021e-08, 1.309381686413987e-08, 2.361297413496344e-09, 4.028047069119606e-10, 6.517937735324686e-11, 1.002995738913739e-11, 1.471178953188484e-12, 2.061239883673826e-13, 2.763962097391472e-14, 3.553476343577641e-15,
8.090580204923133e-02, 6.781494195574747e-02, 4.798592731343156e-02, 2.899137616818150e-02, 1.514779896759491e-02, 6.931474759062689e-03, 2.810222535606298e-03, 1.020003405845558e-03, 3.344861136510592e-04, 9.989597347209389e-05, 2.736257061387726e-05, 6.916364589986651e-06, 1.622055149525641e-06, 3.546528200609161e-07, 7.260108129833773e-08, 1.396813435674213e-08, 2.534387923094040e-09, 4.349949615797805e-10, 7.082422482667426e-11, 1.096643106409310e-11, 1.618591897931368e-12, 2.282000260370971e-13, 3.079236401629072e-14, 3.983783200028840e-15,
8.038553399545546e-02, 6.746245089273502e-02, 4.784737440088871e-02, 2.899993127787272e-02, 1.521079579235029e-02, 6.990741224632737e-03, 2.847748610523909e-03, 1.038855061158328e-03, 3.424711318462677e-04, 1.028407136685285e-04, 2.832747273018395e-05, 7.201336283662997e-06, 1.698737276124637e-06, 3.736141127440334e-07, 7.693968061195227e-08, 1.489212918348408e-08, 2.718457993301675e-09, 4.694420807581520e-10, 7.690287649535350e-11, 1.198123986939321e-11, 1.779346767646824e-12, 2.524267707565908e-13, 3.427423669289969e-14, 4.462035840113916e-15,
7.987191271082310e-02, 6.711340474751191e-02, 4.770893918965124e-02, 2.900722328612913e-02, 1.527274701666340e-02, 7.049599779744059e-03, 2.885271365355943e-03, 1.057822183956955e-03, 3.505536721683508e-04, 1.058393681643090e-04, 2.931597326709345e-05, 7.495048897701528e-06, 1.778253674899330e-06, 3.933968413943018e-07, 8.149413533924132e-08, 1.586809940740110e-08, 2.914090350513770e-09, 5.062812657150984e-10, 8.344429619612695e-11, 1.308015401275044e-11, 1.954518800397336e-12, 2.789925404995215e-13, 3.811636565621280e-14, 4.993106868598780e-15,
7.936481174482268e-02, 6.676775781949117e-02, 4.757064135458880e-02, 2.901328055394450e-02, 1.533366296131711e-02, 7.108047752062906e-03, 2.922785933905691e-03, 1.076902174162270e-03, 3.587331382812401e-04, 1.088921184827332e-04, 3.032833650791770e-05, 7.797663456340807e-06, 1.860676270483014e-06, 4.140274623605901e-07, 8.627286036619915e-08, 1.689842257967340e-08, 3.121892117012574e-09, 5.456543477027641e-10, 9.047907421943917e-11, 1.426930863621650e-11, 2.145258852384630e-12, 3.081002318085924e-13, 4.235250829423693e-14, 5.582315421185734e-15,
7.886410782631049e-02, 6.642546507174778e-02, 4.743249974819640e-02, 2.901813088547301e-02, 1.539355397559212e-02, 7.166082655137193e-03, 2.960287539234215e-03, 1.096092432732650e-03, 3.670089128951394e-04, 1.119991331715499e-04, 3.136482294885398e-05, 8.109341069667609e-06, 1.946077743435222e-06, 4.355329330933875e-07, 9.128449524571643e-08, 1.798555736376961e-08, 3.342495517505382e-09, 5.877100329056299e-10, 9.803949988755083e-11, 1.555522283632685e-11, 2.352797897527614e-12, 3.399682939558383e-13, 4.701924766940470e-14, 6.235463494763875e-15,
7.836968076474624e-02, 6.608648212479200e-02, 4.729453243020457e-02, 2.902180153685738e-02, 1.545243043051778e-02, 7.223702183462390e-03, 2.997771493513656e-03, 1.115390362823277e-03, 3.753803583492131e-04, 1.151605678488844e-04, 3.242568920676721e-05, 8.430242873631802e-06, 2.034531511856342e-06, 4.579407111853183e-07, 9.653790652662438e-08, 1.913204515520753e-08, 3.576558593797769e-09, 6.326041528052808e-10, 1.061596364020267e-10, 1.694481943929548e-11, 2.578451741756477e-12, 3.748317571613756e-13, 5.215619975974394e-14, 6.958874843432474e-15,
7.788141335505212e-02, 6.575076525008000e-02, 4.715675669613623e-02, 2.902431922505177e-02, 1.551030271243490e-02, 7.280904207619661e-03, 3.035233197821775e-03, 1.134793370908898e-03, 3.838468171935070e-04, 1.183765652563100e-04, 3.351118793028392e-05, 8.760529970334574e-06, 2.126111712574376e-06, 4.812787531446298e-07, 1.020421900035035e-07, 2.034051169578177e-08, 3.824765927298674e-09, 6.804999199474581e-10, 1.148753979901009e-10, 1.844544554968041e-11, 2.823625959332049e-12, 4.129433171860029e-13, 5.780623363140584e-14, 7.759436592036678e-15,
7.739919128594314e-02, 6.541827136329174e-02, 4.701918910484786e-02, 2.902571013662929e-02, 1.556718121685946e-02, 7.337686769487623e-03, 3.072668141880537e-03, 1.154298867870439e-03, 3.924076127696088e-04, 1.216472553188371e-04, 3.462156771420560e-05, 9.100363368633046e-06, 2.220893181920752e-06, 5.055755129025807e-07, 1.078066728851970e-07, 2.161366868110819e-08, 4.087829369043091e-09, 7.315681890923935e-10, 1.242246293784191e-10, 2.006489389092182e-11, 3.089821058612361e-12, 4.545744786761786e-13, 6.401570519507235e-14, 8.644643725984110e-15,
7.692290305158411e-02, 6.508895801740301e-02, 4.688184550509042e-02, 2.902599993656424e-02, 1.562307634263661e-02, 7.394048077528912e-03, 3.110071903741529e-03, 1.173904270045849e-03, 4.010620497895711e-04, 1.249727552115854e-04, 3.575707301724466e-05, 9.449903925102655e-06, 2.318951436112160e-06, 5.308599400558814e-07, 1.138409158800366e-07, 2.295431536033345e-08, 4.366488776907803e-09, 7.859877237246008e-10, 1.342471876214906e-10, 2.181142495611558e-11, 3.378637884797098e-12, 5.000167597031163e-13, 7.083470522263225e-14, 9.622646623354714e-15,
7.645243986643553e-02, 6.476278339557746e-02, 4.674474106112476e-02, 2.902521377698054e-02, 1.567799848637493e-02, 7.449986502152651e-03, 3.147440149420926e-03, 1.193607000245609e-03, 4.098094149126485e-04, 1.283531694329134e-04, 3.691794408308338e-05, 9.809312285397957e-06, 2.420362651255696e-06, 5.571614778455995e-07, 1.201547151958809e-07, 2.436534012686166e-08, 4.661512759686401e-09, 8.439454678935754e-10, 1.449850263109958e-10, 2.369378998732977e-11, 3.691783267286088e-12, 5.495829600010856e-13, 7.831732232482064e-14, 1.070230180277835e-14,
7.598769558315616e-02, 6.443970630390224e-02, 4.660789027742566e-02, 2.902337630585839e-02, 1.573195803715078e-02, 7.505500571153663e-03, 3.184768632486596e-03, 1.213404488733335e-03, 4.186489773194185e-04, 1.317885898837735e-04, 3.810441686475307e-05, 1.017874882605092e-05, 2.525203642994524e-06, 5.845100608741607e-07, 1.267581044531337e-07, 2.584972209895112e-08, 4.973699427680071e-09, 9.056368233519765e-10, 1.564822821908338e-10, 2.572125480169507e-11, 4.031075919388770e-12, 6.036084954732542e-13, 8.652192161522304e-14, 1.189322606823322e-14,
7.552856661343754e-02, 6.411968616398876e-02, 4.647130702250610e-02, 2.902051167569114e-02, 1.578496537147315e-02, 7.560588965229161e-03, 3.222053193599917e-03, 1.233294174171922e-03, 4.275799892828726e-04, 1.352790959530643e-04, 3.931672295232556e-05, 1.055837359674450e-05, 2.633551845811444e-06, 6.129361125623025e-07, 1.336613565090002e-07, 2.741053268903903e-08, 5.303877149451791e-09, 9.712659319530542e-10, 1.687853642015054e-10, 2.790362448240413e-11, 4.398452598218188e-12, 6.624528015966174e-13, 9.551143981115605e-14, 1.320585423981618e-14,
7.507495185165002e-02, 6.380268300545967e-02, 4.633500455189338e-02, 2.901664355208624e-02, 1.583703084849944e-02, 7.615250513573470e-03, 3.259289760014727e-03, 1.253273504535714e-03, 4.366016867360910e-04, 1.388247546087545e-04, 4.055508950390816e-05, 1.094834626309810e-05, 2.745485292007808e-06, 6.424705423480680e-07, 1.408749851913157e-07, 2.905093716065716e-08, 5.652905314382928e-09, 1.041045963264271e-09, 1.819430449760933e-10, 3.025126895264177e-11, 4.795974532695441e-12, 7.265008084205979e-13, 1.053536975474357e-13, 1.465150066765331e-14,
7.462675260118568e-02, 6.348865745833888e-02, 4.619899553028767e-02, 2.901179512230330e-02, 1.588816480549316e-02, 7.669484189551280e-03, 3.296474345035838e-03, 1.273339937989204e-03, 4.457132898361268e-04, 1.424256204945539e-04, 4.181973917992898e-05, 1.134882605000043e-05, 2.861082590375238e-06, 6.731447426301336e-07, 1.484097469403717e-07, 3.077419617180802e-08, 6.021675100662848e-09, 1.115199407349219e-09, 1.960065548087172e-10, 3.277514945033245e-11, 5.225834127677692e-12, 7.961644899166893e-13, 1.161217297049102e-13, 1.624242473445602e-14,
7.418387250339044e-02, 6.317757074536473e-02, 4.606329205293137e-02, 2.900598910372423e-02, 1.593837755351451e-02, 7.723289106449664e-03, 3.333603047439381e-03, 1.293490943732756e-03, 4.549140035237497e-04, 1.460817360319044e-04, 4.311089008069562e-05, 1.175997168552328e-05, 2.980422904577607e-06, 7.049905854579729e-07, 1.562766423572395e-07, 3.258366730367811e-08, 6.411110248334179e-09, 1.193958372665079e-09, 2.110296781149230e-10, 3.548684592143698e-11, 5.690361952305413e-12, 8.718844904989942e-13, 1.278941345818564e-13, 1.799190056078363e-14,
7.374621746897907e-02, 6.286938467423947e-02, 4.592790566621820e-02, 2.899924775224958e-02, 1.598767937333514e-02, 7.776664513309116e-03, 3.370672050857234e-03, 1.313724002815890e-03, 4.642030180787159e-04, 1.497931315270741e-04, 4.442875568721024e-05, 1.218194134544944e-05, 3.103585931260796e-06, 7.380404189715728e-07, 1.644869176571872e-07, 3.448280657357448e-08, 6.822167837008848e-09, 1.277564889018125e-09, 2.270688524020064e-10, 3.839858534935829e-11, 6.192034020741885e-12, 9.541318315976153e-13, 1.407554427629060e-13, 1.991429113584998e-14,
7.331369561183487e-02, 6.256406162983155e-02, 4.579284738756880e-02, 2.899159287061688e-02, 1.603608051156908e-02, 7.829609790833643e-03, 3.407677623127708e-03, 1.334036608918657e-03, 4.735795096702512e-04, 1.535598252831331e-04, 4.577354480521748e-05, 1.261489259844578e-05, 3.230651877907673e-06, 7.723270635935970e-07, 1.730520660268637e-07, 3.647516993098018e-08, 7.255839067862820e-09, 1.366271215514909e-09, 2.441832697657770e-10, 4.152327103782014e-11, 6.733479373550124e-12, 1.043409701228478e-12, 1.547965065670513e-13, 2.202512710570575e-14,
7.288621718509930e-02, 6.226156456634402e-02, 4.565812772459898e-02, 2.898304581663628e-02, 1.608359117701095e-02, 7.882124447379938e-03, 3.444616115614535e-03, 1.354426269101662e-03, 4.830426409024451e-04, 1.573818237165936e-04, 4.714546151246276e-05, 1.305898235191168e-05, 3.361701440455651e-06, 8.078838079770900e-07, 1.819838288840131e-07, 3.856441473563510e-08, 7.713150049510441e-09, 1.460340153442016e-09, 2.624349809287205e-10, 4.487451286436960e-11, 7.317487968018654e-12, 1.140255329564218e-12, 1.701149109834673e-13, 2.434119045984036e-14,
7.246369451945861e-02, 6.196185699946040e-02, 4.552375669360625e-02, 2.897362751133992e-02, 1.613022153717445e-02, 7.934208115025428e-03, 3.481483962496226e-03, 1.374890504525292e-03, 4.925915613542850e-04, 1.612591214785025e-04, 4.854470510913325e-05, 1.351436679853170e-05, 3.496815780694236e-06, 8.447444047120029e-07, 1.912941970385706e-07, 4.075430121656128e-08, 8.195162587353188e-09, 1.560045364002557e-09, 2.818890018329687e-10, 4.846665852142059e-11, 7.947018885808786e-12, 1.245241953571260e-12, 1.868154070313692e-13, 2.688060336667768e-14,
7.204604196354375e-02, 6.166490299848167e-02, 4.538974383739894e-02, 2.896335844704150e-02, 1.617598171502280e-02, 7.985860545715090e-03, 3.518277680027698e-03, 1.395426851138709e-03, 5.022254081140595e-04, 1.651917015797730e-04, 4.997147007145333e-05, 1.398120136355979e-05, 3.636076503459787e-06, 8.829430657939865e-07, 2.009954117540748e-07, 4.304869391096449e-08, 8.702974975991325e-09, 1.665671690832821e-09, 3.026134227998636e-10, 5.231482576150200e-11, 8.625208866350938e-12, 1.358980873837929e-12, 2.050103685078606e-13, 2.966292241808410e-14,
7.163317582635749e-02, 6.137066717846239e-02, 4.525609824249111e-02, 2.895225869530258e-02, 1.622088178588393e-02, 8.037081607486618e-03, 3.554993865776076e-03, 1.416032860339196e-03, 5.119433063078914e-04, 1.691795355205490e-04, 5.142594600840282e-05, 1.445964065286139e-05, 3.779565633644647e-06, 9.225144578590683e-07, 2.110999657084216e-07, 4.545156308195805e-08, 9.237722794281402e-09, 1.777515487217873e-09, 3.246795202662790e-10, 5.643493566309873e-11, 9.355381174466409e-12, 1.482123606777392e-12, 2.248202731157153e-13, 3.270923855286627e-14,
7.122501432165160e-02, 6.107911469235813e-02, 4.512282855568654e-02, 2.894034791480361e-02, 1.626493177454335e-02, 8.087871280773668e-03, 3.591629197832472e-03, 1.436706099602424e-03, 5.217443696221640e-04, 1.732225834233940e-04, 5.290831762152491e-05, 1.494983840173826e-05, 3.927365593037711e-06, 9.634936971880065e-07, 2.216206038530700e-07, 4.796698611407023e-08, 9.800579702617361e-09, 1.895884947920240e-09, 3.481618711061928e-10, 6.084374693318259e-11, 1.014105481073418e-11, 1.615364135447333e-12, 2.463742089912519e-13, 3.604228293930704e-14,
7.082147751417743e-02, 6.079021122319121e-02, 4.498994300007353e-02, 2.892764535911647e-02, 1.630814165250761e-02, 8.138229654786670e-03, 3.628180434001468e-03, 1.457444153084248e-03, 5.316277008196371e-04, 1.773207941701077e-04, 5.441876466778897e-05, 1.545194742455982e-05, 4.079559177013339e-06, 1.005916344484248e-06, 2.325703241698988e-07, 5.059914888551312e-08, 1.039275824200823e-08, 2.021100445531293e-09, 3.731384695443159e-10, 6.555889126221466e-11, 1.098595407315854e-11, 1.759441262285404e-12, 2.698104076808680e-13, 3.968653910706696e-14,
7.042248726773703e-02, 6.050392297624368e-02, 4.485744939045095e-02, 2.891416988437681e-02, 1.635052133543154e-02, 8.188156923970635e-03, 3.664644410969994e-03, 1.478244622194587e-03, 5.415923922490364e-04, 1.814741055419643e-04, 5.595746192546970e-05, 1.596611956522299e-05, 4.236229531085330e-06, 1.049818399429570e-06, 2.439623783249959e-07, 5.335234711620562e-08, 1.101551063452068e-08, 2.153494871250348e-09, 3.996908466668455e-10, 7.059890974706834e-11, 1.189401847872353e-11, 1.915141067115557e-12, 2.952768046433924e-13, 4.366836162926616e-14,
7.002796719496594e-02, 6.022021667128533e-02, 4.472535514820737e-02, 2.889993995685439e-02, 1.639208068070309e-02, 8.237653384539568e-03, 3.701018043457246e-03, 1.499105126144024e-03, 5.516375263479519e-04, 1.856824443631851e-04, 5.752457916300570e-05, 1.649250564846235e-05, 4.397460127342664e-06, 1.095236295021655e-06, 2.558102722187579e-07, 5.623098769056521e-08, 1.167012958465125e-08, 2.293413979992185e-09, 4.279041925326979e-10, 7.598329039697115e-11, 1.286941305344363e-11, 2.083299473835452e-12, 3.229316283841796e-13, 4.801610166625223e-14,
6.963784260878120e-02, 5.993905953484260e-02, 4.459366731567153e-02, 2.888497366041952e-02, 1.643282948517894e-02, 8.286719431086590e-03, 3.737298323347112e-03, 1.520023302463684e-03, 5.617621761388578e-04, 1.899457266474468e-04, 5.912028111079497e-05, 1.703125543202973e-05, 4.563334740783292e-06, 1.142206891697929e-06, 2.681277664317486e-07, 5.923958995409737e-08, 1.235794908118896e-08, 2.441216739719134e-09, 4.578674808867668e-10, 8.173250673718753e-11, 1.391653899953658e-11, 2.264804929248804e-12, 3.529440193557211e-13, 5.276023969344861e-14,
6.925204047543074e-02, 5.966041929251516e-02, 4.446239256995353e-02, 2.886928870390470e-02, 1.647277748306531e-02, 8.335355553269244e-03, 3.773482318804697e-03, 1.540996807499013e-03, 5.719654057181046e-04, 1.942638577472429e-04, 6.074472743588612e-05, 1.758251755976249e-05, 4.733937425562362e-06, 1.190767471250172e-06, 2.809288765658683e-07, 6.238278698283474e-08, 1.308034519912615e-08, 2.597275684889751e-09, 4.896735964750023e-10, 8.786805752477944e-11, 1.504004474835440e-11, 2.460601197559191e-12, 3.854946797885707e-13, 5.793352574676913e-14,
6.887048936908335e-02, 5.938426416134595e-02, 4.433153723629576e-02, 2.885290242835987e-02, 1.651193434393777e-02, 8.383562332569237e-03, 3.809567173378316e-03, 1.562023316878037e-03, 5.822462707377434e-04, 1.986367325059099e-04, 6.239807271952174e-05, 1.814643951555775e-05, 4.909352491170749e-06, 1.240955730534501e-06, 2.942278734804546e-07, 6.566532682469636e-08, 1.383873690117263e-08, 2.761977273911685e-09, 5.234194649592642e-10, 9.441250759036607e-11, 1.624483740771081e-11, 2.671690274092899e-12, 4.207765556454227e-13, 6.357112753036123e-14,
6.849311942790161e-02, 5.911056284224889e-02, 4.420110730094999e-02, 2.883583181420094e-02, 1.655030967089430e-02, 8.431340439125761e-03, 3.845550105088358e-03, 1.583100525954712e-03, 5.926038188800454e-04, 2.030642354121401e-04, 6.408046643748863e-05, 1.872316757826868e-05, 5.089664478559874e-06, 1.292809774981442e-06, 3.080392834230328e-07, 6.909207371185907e-08, 1.463458683842576e-08, 2.935722250482366e-09, 5.592061854281030e-10, 1.013895298193795e-10, 1.753609461223981e-11, 2.899135421868191e-12, 4.589955519203229e-13, 6.971078674291237e-14,
6.811986231154099e-02, 5.883928451249980e-02, 4.407110842359827e-02, 2.881809348825028e-02, 1.658791299883642e-02, 8.478690628641598e-03, 3.881428405504322e-03, 1.604226150227944e-03, 6.030370903245988e-04, 2.075462407568028e-04, 6.579205294322863e-05, 1.931284677753837e-05, 5.274958136228216e-06, 1.346368111910927e-06, 3.223778880545070e-07, 7.266800924325601e-08, 1.546940214974738e-08, 3.118926008696918e-09, 5.971391654977603e-10, 1.088239482858633e-10, 1.891927678540757e-11, 3.144064334676535e-12, 5.003712825341372e-13, 7.639298399040622e-14,
6.775065116002271e-02, 5.857039881829402e-02, 4.394154594933408e-02, 2.879970373066931e-02, 1.662475379287267e-02, 8.525613739361162e-03, 3.917199438811318e-03, 1.625397925736890e-03, 6.135451182078826e-04, 2.120826127919021e-04, 6.753297145366294e-05, 1.991562085058473e-05, 5.465318396285024e-06, 1.401669643657136e-06, 3.372587243686722e-07, 7.639823353633718e-08, 1.634473525939675e-08, 3.312018961798821e-09, 6.373282589958372e-10, 1.167417825513981e-10, 2.040013982178182e-11, 3.407672430387986e-12, 5.451378561065618e-13, 8.366111266504702e-14,
6.738542055392871e-02, 5.830387586737479e-02, 4.381242492021922e-02, 2.878067848178231e-02, 1.666084144683968e-02, 8.572110689119608e-03, 3.952860640867216e-03, 1.646613609433107e-03, 6.241269290752186e-04, 2.166732058915013e-04, 6.930335603768157e-05, 2.053163219994961e-05, 5.660830350506209e-06, 1.458753660508203e-06, 3.526970845060082e-07, 8.028796634725380e-08, 1.726218467246794e-08, 3.515446914444942e-09, 6.798879062181991e-10, 1.251702931412531e-10, 2.198474819813592e-11, 3.691226278237814e-12, 5.935446989140791e-13, 9.156166218207708e-14,
6.702410647586948e-02, 5.803968622173518e-02, 4.368375008643172e-02, 2.876103334879166e-02, 1.669618528193550e-02, 8.618182472461966e-03, 3.988409518251630e-03, 1.667870979530170e-03, 6.347815433250156e-04, 2.213178647144498e-04, 7.110333560724791e-05, 2.116102185222370e-05, 5.861579226397329e-06, 1.517659833465892e-06, 3.687085154617942e-07, 8.434254815864838e-08, 1.822339576767895e-08, 3.729671438352747e-09, 7.249372767478276e-10, 1.341380282093636e-10, 2.367948852193166e-11, 3.996067163894707e-12, 6.458574163723500e-13, 1.001444109783868e-13,
6.666664627317863e-02, 5.777780089039754e-02, 4.355552591701962e-02, 2.874078361238446e-02, 1.673079454546077e-02, 8.663830157831547e-03, 4.023843647307833e-03, 1.689167835831297e-03, 6.455079756452400e-04, 2.260164243687517e-04, 7.293303391106919e-05, 2.180392941775792e-05, 6.067650363278241e-06, 1.578428206830437e-06, 3.853088186886666e-07, 8.856744123425953e-08, 1.923006158706038e-08, 3.955170251193848e-09, 7.726004148224242e-10, 1.436748714032194e-10, 2.549108352568303e-11, 4.323614796152183e-12, 7.023586944105050e-13, 1.094626296891519e-13,
6.631297862178834e-02, 5.751819132227164e-02, 4.342775661027442e-02, 2.871994423323024e-02, 1.676467840966277e-02, 8.709054884826390e-03, 4.059160673178653e-03, 1.710502000035603e-03, 6.563052354420426e-04, 2.307687105774166e-04, 7.479256953078036e-05, 2.246049305137046e-05, 6.279129188403611e-06, 1.641099190615773e-06, 4.025140495938118e-07, 9.296823063957352e-08, 2.028392362209037e-08, 4.192437598594409e-09, 8.230063872356820e-10, 1.538120909392054e-10, 2.742660651565395e-11, 4.675371159124250e-12, 7.633492421336758e-13, 1.195732949312246e-13,
6.596304349124257e-02, 5.726082939909481e-02, 4.330044610373806e-02, 2.869852985837051e-02, 1.679784597067821e-02, 8.753857861523023e-03, 4.094358308837400e-03, 1.731871316023529e-03, 6.671723272604923e-04, 2.355745398456437e-04, 7.668205587959116e-05, 2.313084941405865e-05, 6.496101193133467e-06, 1.705713552800521e-06, 4.203405169310813e-07, 9.755062522778213e-08, 2.138677259582464e-08, 4.441984639099594e-09, 8.762894337552711e-10, 1.645823898984009e-10, 2.949349628328754e-11, 5.052924513864004e-12, 8.291487771988555e-13, 1.305373141346491e-13,
6.561678211080789e-02, 5.700568742845619e-02, 4.317359808385662e-02, 2.867655482750041e-02, 1.683030624757016e-02, 8.798240361866367e-03, 4.129434334114756e-03, 1.753273650122028e-03, 6.781082511973791e-04, 2.404337196291871e-04, 7.860160120334285e-05, 2.381513363572248e-05, 6.718651909167373e-06, 1.772312411420074e-06, 4.388047820883673e-07, 1.023204585903295e-07, 2.254044924056996e-08, 4.704339831955674e-09, 9.325891200386477e-10, 1.760199577522624e-10, 3.169957248769863e-11, 5.457953553359017e-12, 9.000970553577137e-13, 1.424197618764537e-13,
6.527413693664004e-02, 5.675273813690573e-02, 4.304721599529310e-02, 2.865403317914260e-02, 1.686206818145522e-02, 8.842203723124713e-03, 4.164386594722602e-03, 1.774706891350058e-03, 6.891120033060385e-04, 2.453460485037584e-04, 8.055130858392215e-05, 2.451347927890647e-05, 6.946866884855736e-06, 1.840937226505243e-06, 4.579236582706737e-07, 1.072836899713603e-07, 2.374684507065172e-08, 4.980049327560386e-09, 9.920504930259299e-10, 1.881605231270422e-10, 3.405305151748975e-11, 5.892231714890817e-12, 9.765549456483516e-13, 1.552901281837902e-13,
6.493505161997030e-02, 5.650195466315047e-02, 4.292130304991167e-02, 2.863097865671431e-02, 1.689314063471685e-02, 8.885749343408897e-03, 4.199213001275565e-03, 1.796168951644955e-03, 7.001825759931849e-04, 2.503113163353255e-04, 8.253127594497870e-05, 2.522601830356547e-05, 7.180831661601304e-06, 1.911629791872921e-06, 4.777142095793749e-07, 1.124464051454037e-07, 2.500790314982745e-08, 5.269677360428862e-09, 1.054824238787168e-09, 2.010414078151960e-10, 3.656256284007140e-11, 6.357631653776849e-12, 1.058905552746119e-12, 1.692225792865428e-13,
6.459947097627419e-02, 5.625331055133896e-02, 4.279586223544515e-02, 2.860740471448808e-02, 1.692353239030087e-02, 8.928878679254510e-03, 4.233911528311260e-03, 1.817657766070221e-03, 7.113189584077313e-04, 2.553293044511720e-04, 8.454159605989258e-05, 2.595288103285883e-05, 7.420631750363763e-06, 1.984432226774318e-06, 4.981937499882381e-07, 1.178148172576617e-07, 2.632561885290062e-08, 5.573806644519508e-09, 1.121066842799470e-09, 2.147015820414200e-10, 3.923716584657842e-11, 6.856129882542052e-12, 1.147555388011450e-12, 1.842962313126899e-13,
6.426734095538703e-02, 5.600677974443471e-02, 4.267089632385693e-02, 2.858332452344697e-02, 1.695325215108972e-02, 8.971593243266069e-03, 4.268480213309918e-03, 1.839171293005281e-03, 7.225201368215867e-04, 2.603997858115823e-04, 8.658235656193780e-05, 2.669419611997647e-05, 7.666352608279837e-06, 2.059386967406299e-06, 5.193798422168439e-07, 1.233952676262889e-07, 2.770204062109105e-08, 5.893038770761321e-09, 1.190940752627520e-09, 2.291817209903371e-10, 4.208636720038008e-11, 7.389811579593748e-12, 1.242935590800238e-12, 2.005954374329844e-13,
6.393860861253350e-02, 5.576233657767962e-02, 4.254640787940833e-02, 2.855875097703490e-02, 1.698230853935151e-02, 9.013894601822160e-03, 4.302917155714197e-03, 1.860707514317736e-03, 7.337850950024272e-04, 2.655225251820249e-04, 8.865363995658652e-05, 2.745009051599962e-05, 7.918079615411124e-06, 2.136536758291423e-06, 5.412902965021146e-07, 1.291942265060869e-07, 2.913927071072182e-08, 6.227994606621354e-09, 1.264614542979181e-09, 2.445242626022066e-10, 4.512013869707671e-11, 7.960875571497602e-12, 1.345503201629501e-12, 2.182100889748979e-13,
6.361322208023887e-02, 5.551995577214802e-02, 4.242239926644193e-02, 2.853369669680327e-02, 1.701071009626091e-02, 9.055784372840398e-03, 4.337220515949919e-03, 1.882264435518647e-03, 7.451128145784530e-04, 2.706972793057084e-04, 9.075552363590072e-05, 2.822068943879807e-05, 8.175898051631558e-06, 2.215924643532290e-06, 5.639431692687294e-07, 1.352182938130581e-07, 3.063946593478504e-08, 6.579314697548487e-09, 1.342263083105998e-09, 2.607734666423884e-10, 4.834893564376574e-11, 8.571639492974171e-12, 1.455742488817966e-12, 2.372359310392526e-13,
6.329113054109038e-02, 5.527961242839192e-02, 4.229887265689086e-02, 2.850817403795464e-02, 1.703846528148801e-02, 9.097264223601204e-03, 4.371388514448362e-03, 1.903840085901366e-03, 7.565022753951354e-04, 2.759237970763907e-04, 9.288807989495545e-05, 2.900611634296466e-05, 8.439893073665953e-06, 2.297593957945810e-06, 5.873567616992568e-07, 1.414741998092968e-07, 3.220483839695278e-08, 6.947659670127034e-09, 1.424067706516529e-09, 2.779754750496201e-10, 5.178371576523995e-11, 9.224545128754402e-12, 1.574166330247649e-12, 2.577748931665227e-13,
6.297228420131896e-02, 5.504128202017744e-02, 4.217583003752395e-02, 2.848219509478449e-02, 1.706558247285248e-02, 9.138335868629287e-03, 4.405419430670840e-03, 1.925432518664431e-03, 7.679524558639812e-04, 2.812018197113215e-04, 9.505137595023991e-05, 2.980649289078760e-05, 8.710149692290953e-06, 2.381588318083077e-06, 6.115496182049219e-07, 1.479688057477196e-07, 3.383765621760385e-08, 7.333710636771527e-09, 1.510216382968648e-09, 2.961783735675000e-10, 5.543595864465468e-11, 9.922163941449405e-12, 1.701317651918613e-12, 2.799354356134301e-13,
6.265663426517402e-02, 5.480494038831292e-02, 4.205327321693610e-02, 2.845577170602214e-02, 1.709206996603949e-02, 9.179001067631733e-03, 4.439311602136103e-03, 1.947039811019032e-03, 7.794623333033348e-04, 2.865310809242087e-04, 9.724547395998073e-05, 3.062193892425942e-05, 8.986752749709181e-06, 2.467951613140427e-06, 6.365405247979582e-07, 1.547091044761681e-07, 3.554024425144015e-08, 7.738169601791599e-09, 1.600903892705060e-09, 3.154322546628714e-10, 5.931768570606533e-11, 1.066720278960335e-11, 1.837770924994617e-12, 3.038329118141584e-13,
6.234413291006188e-02, 5.457056373456878e-02, 4.193120383229301e-02, 2.842891546007192e-02, 1.711793597437487e-02, 9.219261623491647e-03, 4.473063423451163e-03, 1.968660064281531e-03, 7.910308842712444e-04, 2.919113070980945e-04, 9.947043104633255e-05, 3.145257243812123e-05, 9.269786897107117e-06, 2.556727995767374e-06, 6.623485073665779e-07, 1.617022210004468e-07, 3.731498479627209e-08, 8.161759868653943e-09, 1.696332002894515e-09, 3.357892817341111e-10, 6.344148074609485e-11, 1.146250984010975e-11, 1.984133723062527e-12, 3.295899476142726e-13,
6.203473326242272e-02, 5.433812861568868e-02, 4.180962335583884e-02, 2.840163770015589e-02, 1.714318862865631e-02, 9.259119380316332e-03, 4.506673345346169e-03, 1.990291403951541e-03, 8.026570848904477e-04, 2.973422174580411e-04, 1.017262993193833e-04, 3.229850955394038e-05, 9.559336572407053e-06, 2.647961872777055e-06, 6.889928298536433e-07, 1.689554130058823e-07, 3.916431829255711e-08, 8.605226448266314e-09, 1.796709646239373e-09, 3.573037546116231e-10, 6.782051102184126e-11, 1.231108067917990e-11, 2.141048341352961e-12, 3.573368378792432e-13,
6.172838937432052e-02, 5.410761193749184e-02, 4.168853310117537e-02, 2.837394952935888e-02, 1.716783597703806e-02, 9.298576221538820e-03, 4.540139873713729e-03, 2.011931979776045e-03, 8.143399111654960e-04, 3.028235242435206e-04, 1.040131259029166e-04, 3.315986449521821e-05, 9.855485978222897e-06, 2.741697895764816e-06, 7.164929923401757e-07, 1.764760713370274e-07, 4.109074401328054e-08, 9.069336468106683e-09, 1.902253101708433e-09, 3.800321763521101e-10, 7.246854890197618e-11, 1.321606462605788e-11, 2.309193479693620e-12, 3.872119610933113e-13,
6.142505620072142e-02, 5.387899094906709e-02, 4.156793422932075e-02, 2.834586181557770e-02, 1.719188598496646e-02, 9.337634068071778e-03, 4.573461568653251e-03, 2.033579965799995e-03, 8.260783392920822e-04, 3.083549328804129e-04, 1.063309529618797e-04, 3.403674956352441e-05, 1.015831906002938e-05, 2.837980951640558e-06, 7.448687290348965e-07, 1.842717204351530e-07, 4.309682074377301e-08, 9.554879582019031e-09, 2.013186177352141e-09, 4.040333213274758e-10, 7.739999408782202e-11, 1.418077125367931e-11, 2.489285990990270e-12, 4.193622125783034e-13,
6.112468957743721e-02, 5.365224323705702e-02, 4.144782775455566e-02, 2.831738519637507e-02, 1.721534653516379e-02, 9.376294876512708e-03, 4.606637043520771e-03, 2.055233560403899e-03, 8.378713459586085e-04, 3.139361421525126e-04, 1.086798177315005e-04, 3.492927511565320e-05, 1.046791948455382e-05, 2.936856153080412e-06, 7.741400061710389e-07, 1.923500187332057e-07, 4.518516745106574e-08, 1.006266838049557e-08, 2.129740395155579e-09, 4.293683046084739e-10, 8.262989641102103e-11, 1.520867712047110e-11, 2.682082697053128e-12, 4.539434569758873e-13,
6.082724619971101e-02, 5.342734672003219e-02, 4.132821455006422e-02, 2.828853008374010e-02, 1.723822542765781e-02, 9.414560637399415e-03, 4.639664963984638e-03, 2.076890986328821e-03, 8.497179086400733e-04, 3.195668443724637e-04, 1.110597525480036e-04, 3.583754954179759e-05, 1.078437061839960e-05, 3.038368828903413e-06, 8.043270198117513e-07, 2.007187590079403e-07, 4.735846394239019e-08, 1.059353880126426e-08, 2.252155177882997e-09, 4.561006526424933e-10, 8.817397921423301e-11, 1.630343271748678e-11, 2.888382273608729e-12, 4.911210006506652e-13,
6.053268360142414e-02, 5.320427964295556e-02, 4.120909535337731e-02, 2.825930666875621e-02, 1.726053037985509e-02, 9.452433373514578e-03, 4.672544047087494e-03, 2.098550490689220e-03, 8.616170058843088e-04, 3.252467255520226e-04, 1.134707848808668e-04, 3.676167924473422e-05, 1.110775550690949e-05, 3.142564514378599e-06, 8.354501935653964e-07, 2.093858686889504e-07, 4.961945151243467e-08, 1.114835053999825e-08, 2.380678037865800e-09, 4.842963752240817e-10, 9.404866332110430e-11, 1.746886963506510e-11, 3.109027206358596e-12, 5.310700846853378e-13,
6.024096013490281e-02, 5.298302057173541e-02, 4.109047077162496e-02, 2.822972492617820e-02, 1.728226902665537e-02, 9.489915138238632e-03, 4.705273060315021e-03, 2.120210344974143e-03, 8.735676175906643e-04, 3.309754655715778e-04, 1.159129373665703e-04, 3.770176862001439e-05, 1.143815685327735e-05, 3.249488941468177e-06, 8.675301762121910e-07, 2.183594101243761e-07, 5.197093357897934e-08, 1.172798746096420e-08, 2.515564767684515e-09, 5.140240387561146e-10, 1.002710916015672e-10, 1.870900795319254e-11, 3.344905819967271e-12, 5.739763991531074e-13,
5.995203495130507e-02, 5.276354838786700e-02, 4.097234128660470e-02, 2.819979461891934e-02, 1.730344892060523e-02, 9.527008013949666e-03, 4.737850820671610e-03, 2.141868845037083e-03, 8.855687252811750e-04, 3.367527383488347e-04, 1.183862278437820e-04, 3.865792003715320e-05, 1.177565699791586e-05, 3.359188029012108e-06, 9.005878392435674e-07, 2.276475808030601e-07, 5.441577630653358e-08, 1.233335800742365e-08, 2.657079632693303e-09, 5.453548407986823e-10, 1.068591541383126e-10, 2.002806385973565e-11, 3.596954381881797e-12, 6.200366193662250e-13,
5.966586798156785e-02, 5.254584228316154e-02, 4.085470725967231e-02, 2.816952530245015e-02, 1.732407753208865e-02, 9.563714110469503e-03, 4.770276193763519e-03, 2.163524311075021e-03, 8.976193123643167e-04, 3.425782120065980e-04, 1.208906693899296e-04, 3.963023382181006e-05, 1.212033789808816e-05, 3.471707872859719e-06, 9.346442743157917e-07, 2.372587135329915e-07, 5.695690921761325e-08, 1.296539561160277e-08, 2.805495565334372e-09, 5.783626859020842e-10, 1.138315140000883e-10, 2.143045750069764e-11, 3.866159282904652e-12, 6.694589648134782e-13,
5.938241991789675e-02, 5.232988175456211e-02, 4.073756893646131e-02, 2.813892632911003e-02, 1.734416224955273e-02, 9.600035563554850e-03, 4.802548092889618e-03, 2.185175087597007e-03, 9.097183643913887e-04, 3.484515490395699e-04, 1.234262703591048e-04, 4.061880823895228e-05, 1.247228110780997e-05, 3.587094735953533e-06, 9.697207906193080e-07, 2.472012765758666e-07, 5.959732579129555e-08, 1.362505910404309e-08, 2.961094361187700e-09, 6.131242627194632e-10, 1.212076336272400e-10, 2.292082106663180e-11, 4.153559296459995e-12, 7.224637815130540e-13,
5.910165219577958e-02, 5.211564659904557e-02, 4.062092645143717e-02, 2.810800685233329e-02, 1.736371037976660e-02, 9.635974533432661e-03, 4.834665478140207e-03, 2.206819543382694e-03, 9.218648693056425e-04, 3.543724064801023e-04, 1.259930344212523e-04, 4.162373947699390e-05, 1.283156775803002e-05, 3.705395038370907e-06, 1.005838912165423e-06, 2.574838737376594e-07, 6.234008404870404e-08, 1.431333312214718e-08, 3.124166876700336e-09, 6.497191223939281e-10, 1.290078018347104e-10, 2.450400711932660e-11, 4.460247918511457e-12, 7.792841485209701e-13,
5.882352697650724e-02, 5.190311690860958e-02, 4.050477983229208e-02, 2.807677583079071e-02, 1.738272914811151e-02, 9.671533203378522e-03, 4.866627355504005e-03, 2.228456071431223e-03, 9.340578176841986e-04, 3.603404360628253e-04, 1.285909606025887e-04, 4.264512163290009e-05, 1.319827853709432e-05, 3.826655347328548e-06, 1.043020374991876e-06, 2.681152444150897e-07, 6.518830712507726e-08, 1.503122851773103e-08, 3.295013228537662e-09, 6.882297582141461e-10, 1.372531614374637e-10, 2.618509716284983e-11, 4.787375790105758e-12, 8.401665093487599e-13,
5.854800713018492e-02, 5.169227306534380e-02, 4.038912900418591e-02, 2.804524203244806e-02, 1.740122569890061e-02, 9.706713778337336e-03, 4.898432775983675e-03, 2.250083088900825e-03, 9.462962029728623e-04, 3.663552843881000e-04, 1.312200433272063e-04, 4.368304669824864e-05, 1.357249367150146e-05, 3.950922367155355e-06, 1.081287124288978e-06, 2.791042635979351e-07, 6.814518382808970e-08, 1.577978276339638e-08, 3.473942994497958e-09, 7.287416865316974e-10, 1.459657375030865e-10, 2.796941046301500e-11, 5.136153204533227e-12, 9.053713290577143e-13,
5.827505621921784e-02, 5.148309573658430e-02, 4.027397379383871e-02, 2.801341403854310e-02, 1.741920709572662e-02, 9.741518483585095e-03, 4.930080834720079e-03, 2.271699037039526e-03, 9.585790217139118e-04, 3.724165930842226e-04, 1.338802724598053e-04, 4.473760454623755e-05, 1.395429290695404e-05, 4.078242929238602e-06, 1.120661311447946e-06, 2.904599418271291e-07, 7.121396918209469e-08, 1.656006035753415e-08, 3.661275415929760e-09, 7.713435289326147e-10, 1.551684662360549e-10, 2.986251311929824e-11, 5.507852701110379e-12, 9.751737778102283e-13,
5.800463848225620e-02, 5.127556587015033e-02, 4.015931393348000e-02, 2.798130024748210e-02, 1.743668032183556e-02, 9.775949563431049e-03, 4.961570670125415e-03, 2.293302381107330e-03, 9.709052737669508e-04, 3.785239989683314e-04, 1.365716333495145e-04, 4.580888291963012e-05, 1.434375548971253e-05, 4.208663981948745e-06, 1.161165291033159e-06, 3.021914251086482e-07, 7.439798495797429e-08, 1.737315322777220e-08, 3.857339601590585e-09, 8.161270956548372e-10, 1.648852244979333e-10, 3.187022739320537e-11, 5.903811747604788e-12, 1.049864441672252e-12,
5.773671881858443e-02, 5.106966468966218e-02, 4.004514906465990e-02, 2.794890887865764e-02, 1.745365228052553e-02, 9.810009279959057e-03, 4.992901463025563e-03, 2.314891610290196e-03, 9.832739625229134e-04, 3.846771342059550e-04, 1.392941068747436e-04, 4.689696741962520e-05, 1.474096014825640e-05, 4.342232580547817e-06, 1.202821617680059e-06, 3.143079947831859e-07, 7.770062018828449e-08, 1.822018113267913e-08, 4.062474732883828e-09, 8.631874702424481e-10, 1.751408599674921e-10, 3.399864129704658e-11, 6.325435513334666e-12, 1.129750061473828e-12,
5.747126277294067e-02, 5.086537368993974e-02, 3.993147874192697e-02, 2.791624797618858e-02, 1.747012979556833e-02, 9.843699911807550e-03, 5.024072435811667e-03, 2.336465237606204e-03, 9.956840951113139e-04, 3.908756264691531e-04, 1.420476694890257e-04, 4.800194149564270e-05, 1.514598507525758e-05, 4.478995877086414e-06, 1.245653042920427e-06, 3.268190673516571e-07, 8.112533166739546e-08, 1.910229206153648e-08, 4.277030270409568e-09, 9.126230954268243e-10, 1.859612219444910e-10, 3.625411844703891e-11, 6.774199734988282e-12, 1.215154300547801e-12,
5.720823652075249e-02, 5.066267463247954e-02, 3.981830243637735e-02, 2.788332541258403e-02, 1.748611961165329e-02, 9.877023752986824e-03, 5.055082851601225e-03, 2.358021799804221e-03, 1.008134682600843e-03, 3.971190990931993e-04, 1.448322932678003e-04, 4.912388643601305e-05, 1.555890790987127e-05, 4.619001110294314e-06, 1.289682511936881e-06, 3.397341942566052e-07, 8.467564443633656e-08, 2.002066263199330e-08, 4.501366161763863e-09, 9.645358602240735e-10, 1.973731928006067e-10, 3.864330818461406e-11, 7.251653677219474e-12, 1.306418542179672e-12,
5.694760685377569e-02, 5.046154954101074e-02, 3.970561953907953e-02, 2.785014889233219e-02, 1.750162839485112e-02, 9.909983111733075e-03, 5.085932013408769e-03, 2.379559857255403e-03, 1.020624740193387e-03, 4.034071712317602e-04, 1.476479459560922e-04, 5.026288135955800e-05, 1.597980572034790e-05, 4.762295595469416e-06, 1.334933160248327e-06, 3.530630616195873e-07, 8.835515225206150e-08, 2.097649848541537e-08, 4.735853050519561e-09, 1.019031188237261e-09, 2.094047200806994e-10, 4.117315596975800e-11, 7.759423190084968e-12, 1.403902717614091e-12,
5.668934116612372e-02, 5.026198069712758e-02, 3.959342936437963e-02, 2.781672595541578e-02, 1.751666273309725e-02, 9.942580309398165e-03, 5.116619263326305e-03, 2.401077993837851e-03, 1.033153287411590e-03, 4.097394580105237e-04, 1.504945910170381e-04, 5.141900320805183e-05, 1.640875498697096e-05, 4.908926714369952e-06, 1.381428310328248e-06, 3.668154899346693e-07, 9.216751804086172e-08, 2.197103467974430e-08, 4.980872486320824e-09, 1.076218127151276e-09, 2.220848492573607e-10, 4.385091405016516e-11, 8.299213865399033e-12, 1.507986165476205e-12,
5.643340744067494e-02, 5.006395063599833e-02, 3.948173115309085e-02, 2.778306398075519e-02, 1.753122913669284e-02, 9.974817679374193e-03, 5.147143981713587e-03, 2.422574816814750e-03, 1.045719348280037e-03, 4.161155706792377e-04, 1.533721876812206e-04, 5.259232673954979e-05, 1.684583158532385e-05, 5.058941905114536e-06, 1.429191468157652e-06, 3.810014337181554e-07, 9.611647433566325e-08, 2.300553607968055e-08, 5.236817136022193e-09, 1.136209439407282e-09, 2.354437571413789e-10, 4.668415240993014e-11, 8.872814294088098e-12, 1.619068523478176e-12,
5.617977423584612e-02, 4.986744214214872e-02, 3.937052407557126e-02, 2.774917018958059e-02, 1.754533403882249e-02, 1.000669756605223e-02, 5.177505586398382e-03, 2.444048956706272e-03, 1.058321951500171e-03, 4.225351167621234e-04, 1.562806909967621e-04, 5.378292452257228e-05, 1.729111076988995e-05, 5.212388652094843e-06, 1.478246319714584e-06, 3.956309811147386e-07, 1.002058236969548e-07, 2.408129774400736e-08, 5.504090995802217e-09, 1.199121694043084e-09, 2.495127859505007e-10, 4.968077000145114e-11, 9.482099426635624e-12, 1.737570653293502e-12,
5.592841067272071e-02, 4.967243824531953e-02, 3.925980723469402e-02, 2.771505164873452e-02, 1.755898379608758e-02, 1.003822232381413e-02, 5.207703531886741e-03, 2.465499067155554e-03, 1.070960130619030e-03, 4.289977002066166e-04, 1.592200518801355e-04, 5.499086693113020e-05, 1.774466715798844e-05, 5.369314475905275e-06, 1.528616727402024e-06, 4.107143534602332e-07, 1.044394391170981e-07, 2.519964530987103e-08, 5.783109604180138e-09, 1.265075359684766e-09, 2.643244780385437e-10, 5.284900626415105e-11, 1.012903403871198e-11, 1.863935599493388e-12,
5.567928642252076e-02, 4.947892221639674e-02, 3.914957966871339e-02, 2.768071527390599e-02, 1.757218468905393e-02, 1.006939431605683e-02, 5.237737308583432e-03, 2.486923824789053e-03, 1.083632924191917e-03, 4.355029215304149e-04, 1.621902171676529e-04, 5.621622214058082e-05, 1.820657471404933e-05, 5.529766923294290e-06, 1.580326726416156e-06, 4.262619048011329e-07, 1.088212644077913e-07, 2.636193537383738e-08, 6.074300255863869e-09, 1.334194898674445e-09, 2.799126112866598e-10, 5.619745293356919e-11, 1.081567630409017e-11, 1.998629583451410e-12,
5.543237169441222e-02, 4.928687756341349e-02, 3.903984035403080e-02, 2.764616783279775e-02, 1.758494292281302e-02, 1.010021591424817e-02, 5.267606442022564e-03, 2.508321929071524e-03, 1.096339375939098e-03, 4.420503779667918e-04, 1.651911296675853e-04, 5.745905612429839e-05, 1.867690673423015e-05, 5.693793557141597e-06, 1.633400521056860e-06, 4.422841213712053e-07, 1.133553145704546e-07, 2.756955586954206e-08, 6.378102216355704e-09, 1.406608862317985e-09, 2.963122351582101e-10, 5.973506614430158e-11, 1.154418147694964e-11, 2.142143033133735e-12,
5.518763722363244e-02, 4.909628802762226e-02, 3.893058820786347e-02, 2.761141594822740e-02, 1.759726462755531e-02, 1.013068949701352e-02, 5.297310492108442e-03, 2.529692102155929e-03, 1.109078534896639e-03, 4.486396636081510e-04, 1.682227282128785e-04, 5.871943265114801e-05, 1.915573583137687e-05, 5.861441946465704e-06, 1.687862480982384e-06, 4.587916210254027e-07, 1.180456761493281e-07, 2.882392644175709e-08, 6.694966937242196e-09, 1.482449987235979e-09, 3.135597074184460e-10, 6.347117883020716e-11, 1.231680568567470e-11, 2.294991649703679e-12,
5.494505425993117e-02, 4.890713757963684e-02, 3.882182209082013e-02, 2.757646610116425e-02, 1.760915585915531e-02, 1.016081744925239e-02, 5.326849052366708e-03, 2.551033088728522e-03, 1.121849455561451e-03, 4.552703695477894e-04, 1.712849477144181e-04, 5.999741328374763e-05, 1.964313392033059e-05, 6.032759656465787e-06, 1.743737137410117e-06, 4.757951526313458e-07, 1.228965075670706e-07, 3.012649881669421e-08, 7.025358272092811e-09, 1.561855292800358e-09, 3.316927315198483e-10, 6.741551342521674e-11, 1.313590984025256e-11, 2.457717511879916e-12,
5.470459455631450e-02, 4.871941041564233e-02, 3.871354080938592e-02, 2.754132463370255e-02, 1.762062259976691e-02, 1.019060216128438e-02, 5.356221749205835e-03, 2.572343655849382e-03, 1.134651198030700e-03, 4.619420840198534e-04, 1.743777192148122e-04, 6.129305737750581e-05, 2.013917220358310e-05, 6.207794238602343e-06, 1.801049179265459e-06, 4.933055954187183e-07, 1.279120394426719e-07, 3.147875716837103e-08, 7.369752692892310e-09, 1.644966179638482e-09, 3.507503946537085e-10, 7.157819486801710e-11, 1.400396365537842e-11, 2.630890218998595e-12,
5.446623035808300e-02, 4.853309095367270e-02, 3.860574311832067e-02, 2.750599775197296e-02, 1.763167075842844e-02, 1.022004602802351e-02, 5.385428241188940e-03, 2.593622592788624e-03, 1.147482828135632e-03, 4.686543925374532e-04, 1.775009699426461e-04, 6.260642208041943e-05, 2.064392115728152e-05, 6.386593220720292e-06, 1.859823449280653e-06, 5.113339582868566e-07, 1.330965748914854e-07, 3.288221848086342e-08, 7.728639506929800e-09, 1.731928529185582e-09, 3.707732064681716e-10, 7.596976391379145e-11, 1.492354979137060e-11, 2.815108073739515e-12,
5.422993439215503e-02, 4.834816382995399e-02, 3.849842772297257e-02, 2.747049152899272e-02, 1.764230617167658e-02, 1.024915144818044e-02, 5.414468218315977e-03, 2.614868710858557e-03, 1.160343417569953e-03, 4.754068780289255e-04, 1.806546233671772e-04, 6.393756233361935e-05, 2.115745051758451e-05, 6.569204097218827e-06, 1.920084940045646e-06, 5.298913790709148e-07, 1.384544898072118e-07, 3.433843290627389e-08, 8.102521074067925e-09, 1.822892804265958e-09, 3.918031384526978e-10, 8.060119075613000e-11, 1.589736811499842e-11, 3.010999305486920e-12,
5.399567985666652e-02, 4.816461389531333e-02, 3.839159328151102e-02, 2.743481190745639e-02, 1.765253460416817e-02, 1.027792082349166e-02, 5.443341401316296e-03, 2.636080843242002e-03, 1.173232044012836e-03, 4.821991209722165e-04, 1.838385992534288e-04, 6.528653087264779e-05, 2.167982926737054e-05, 6.755674319271562e-06, 1.981858790012853e-06, 5.489891237669466e-07, 1.439902331256663e-07, 3.584898411824351e-08, 8.491913024313946e-09, 1.918014150682393e-09, 4.138836639885281e-10, 8.548388896212768e-11, 1.692824008231957e-11, 3.219223335304749e-12,
5.376344041083923e-02, 4.798242621165114e-02, 3.828523840708081e-02, 2.739896470246793e-02, 1.766236174930923e-02, 1.030635655797512e-02, 5.472047540951564e-03, 2.657257844817022e-03, 1.186147791246691e-03, 4.890306995273724e-04, 1.870528137176494e-04, 6.665337822945452e-05, 2.221112562329950e-05, 6.946051285101012e-06, 2.045170279457854e-06, 5.686385857163037e-07, 1.497083270701760e-07, 3.741548966084055e-08, 8.897344475614716e-09, 2.017452499792752e-09, 4.370597990644638e-10, 9.062972972361047e-11, 1.801911324561956e-11, 3.440472083515835e-12,
5.353319016510886e-02, 4.780158604847692e-02, 3.817936166988073e-02, 2.736295560421530e-02, 1.767179322989068e-02, 1.033446105721142e-02, 5.500586417329057e-03, 2.678398591978254e-03, 1.199089749269761e-03, 4.959011896671256e-04, 1.902971792831024e-04, 6.803815273509679e-05, 2.275140702322802e-05, 7.140382330310844e-06, 2.110044826397954e-06, 5.888512847497441e-07, 1.556133673784600e-07, 3.903960129265826e-08, 9.319358251796318e-09, 2.121372672051849e-09, 4.613781436569024e-10, 9.605105642733029e-11, 1.917306588653813e-11, 3.675471320883193e-12,
5.330490367150585e-02, 4.762207887950630e-02, 3.807396159916906e-02, 2.732679018058891e-02, 1.768083459872960e-02, 1.036223672765005e-02, 5.528957839225281e-03, 2.699501982455101e-03, 1.212057014403690e-03, 5.028101653055543e-04, 1.935716049361500e-04, 6.944090052312874e-05, 2.330074011397935e-05, 7.338714718279705e-06, 2.176507982470606e-06, 6.096388662916894e-07, 1.617100235108651e-07, 4.072300532595925e-08, 9.758511100569287e-09, 2.229944481496183e-09, 4.868869237727898e-10, 1.017606995468880e-10, 2.039331177746072e-11, 3.924982064400578e-12,
5.307855591428117e-02, 4.744389037931954e-02, 3.796903668519852e-02, 2.729047387974494e-02, 1.768949133931587e-02, 1.038968597593998e-02, 5.557161643419913e-03, 2.720566935126939e-03, 1.225048689396121e-03, 5.097571984248092e-04, 1.968759961825989e-04, 7.086166553366515e-05, 2.385919073946746e-05, 7.541095630619850e-06, 2.244585428773622e-06, 6.310131004250453e-07, 1.680030388398213e-07, 4.246742296070303e-08, 1.021537391151908e-08, 2.343342841148238e-09, 5.136360341537634e-10, 1.077719918590351e-10, 2.168320507324197e-11, 4.189802018707220e-12,
5.285412230076975e-02, 4.726700642007915e-02, 3.786458538108289e-02, 2.725401203261461e-02, 1.769776886646318e-02, 1.041681120828389e-02, 5.585197694040054e-03, 2.741592389835617e-03, 1.238063883518461e-03, 5.167418591999044e-04, 2.002102551042765e-04, 7.230048951810642e-05, 2.442682392917617e-05, 7.747572157704294e-06, 2.314302971669206e-06, 6.529858809170816e-07, 1.744972308204174e-07, 4.427461061329967e-08, 1.069053193400214e-08, 2.461747869316679e-09, 5.416770816395005e-10, 1.140987839869197e-10, 2.304624533531999e-11, 4.470767064150121e-12,
5.263157865248445e-02, 4.709141306830672e-02, 3.776060610459807e-02, 2.721740985536038e-02, 1.770567252696412e-02, 1.044361482981542e-02, 5.613065881914677e-03, 2.762577307195334e-03, 1.251101712658884e-03, 5.237637161215413e-04, 2.035742804158009e-04, 7.375741204450795e-05, 2.500370388699216e-05, 7.958191289265395e-06, 2.385686538553674e-06, 6.755692242068093e-07, 1.811974911419801e-07, 4.614636023993093e-08, 1.118458499486620e-08, 2.585344996767796e-09, 5.710634291878812e-10, 1.207554602727290e-10, 2.448608269026547e-11, 4.768752792524152e-12,
5.241090119643434e-02, 4.691709658171721e-02, 3.765709723991949e-02, 2.718067245178037e-02, 1.771320760024835e-02, 1.047009924399890e-02, 5.640766123939341e-03, 2.783520668400214e-03, 1.264161299410704e-03, 5.308223361169894e-04, 2.069679675215200e-04, 7.523247050358077e-05, 2.558989398039230e-05, 8.172999905068414e-06, 2.458762173594896e-06, 6.987752683543699e-07, 1.881087858605696e-07, 4.808449965428599e-08, 1.169814771591454e-08, 2.714325074743192e-09, 6.018502405492915e-10, 1.277569549820852e-10, 2.600652312479817e-11, 5.084676091527718e-12,
5.219206655666035e-02, 4.674404340611002e-02, 3.755405713929813e-02, 2.714380481566215e-02, 1.772037929904395e-02, 1.049626685205091e-02, 5.668298362451048e-03, 2.804421475029652e-03, 1.277241773156184e-03, 5.379172846689930e-04, 2.103912085725852e-04, 7.672570011530931e-05, 2.618545672998446e-05, 8.392044765663028e-06, 2.533556033439396e-06, 7.226162719529507e-07, 1.952361555123112e-07, 5.009089283956134e-08, 1.223184973103278e-08, 2.848884483798002e-09, 6.340945255920545e-10, 1.351187688424440e-10, 2.761153391928892e-11, 5.419496778978368e-12,
5.197505174598153e-02, 4.657224017231565e-02, 3.745148412467725e-02, 2.710681183308629e-02, 1.772719277004066e-02, 1.052212005238296e-02, 5.695662564613155e-03, 2.825278748851666e-03, 1.290342270145903e-03, 5.450481259327086e-04, 2.138438925241291e-04, 7.823713393616903e-05, 2.679045379940049e-05, 8.615372503215608e-06, 2.610094382890978e-06, 7.471046130037181e-07, 2.025847152074778e-07, 5.216744025457352e-08, 1.278633590289649e-08, 2.989225243433154e-09, 6.678551862755939e-10, 1.428569859176282e-10, 2.930524922174615e-11, 5.774219287838463e-12,
5.175983415794697e-02, 4.640167369319730e-02, 3.734937648925214e-02, 2.706969828468170e-02, 1.773365309455526e-02, 1.054766124006498e-02, 5.722858721810452e-03, 2.846091531624416e-03, 1.303461933573781e-03, 5.522144228506813e-04, 2.173259051925241e-04, 7.976680286693275e-05, 2.740494598554151e-05, 8.843029612425669e-06, 2.688403590562928e-06, 7.722527877543521e-07, 2.101596547052763e-07, 5.431607913384287e-08, 1.336226653917895e-08, 3.135555122494943e-09, 7.031930632676782e-10, 1.509882908205322e-10, 3.109197576427378e-11, 6.149894403107698e-12,
5.154639155898624e-02, 4.623233096070589e-02, 3.724773249897410e-02, 2.703246884783263e-02, 1.773976528919798e-02, 1.057289280630872e-02, 5.749886849054074e-03, 2.866858884896041e-03, 1.316599913647824e-03, 5.594157372658330e-04, 2.208371293126868e-04, 8.131473566104707e-05, 2.802899320917312e-05, 9.075062441528700e-06, 2.768510124505588e-06, 7.980734095016873e-07, 2.179662384692665e-07, 5.653878378150213e-08, 1.396031760817630e-08, 3.288087750314200e-09, 7.401709832016705e-10, 1.595299862659016e-10, 3.297619872396227e-11, 6.547621051643552e-12,
5.133470208075373e-02, 4.606419914298818e-02, 3.714655039400171e-02, 2.699512809883945e-02, 1.774553430654009e-02, 1.059781713797079e-02, 5.776746984396482e-03, 2.887579889803002e-03, 1.329755367656747e-03, 5.666516300324971e-04, 2.243774445954076e-04, 8.288095893356922e-05, 2.866265450587033e-05, 9.311517183388693e-06, 2.850440547811326e-06, 8.245792073590747e-07, 2.260098057033869e-07, 5.883756585889349e-08, 1.458118095376961e-08, 3.447042728557165e-09, 7.788538065694573e-10, 1.685000109649941e-10, 3.496258773016065e-11, 6.968548145976690e-12,
5.112474421266013e-02, 4.589726558154641e-02, 3.704582839009986e-02, 2.695768051503319e-02, 1.775096503578164e-02, 1.062243661707464e-02, 5.803439188356178e-03, 2.908253646867034e-03, 1.342927460032504e-03, 5.739216611254623e-04, 2.279467277846725e-04, 8.446549717064383e-05, 2.930598801730970e-05, 9.552439866682433e-06, 2.934221514198682e-06, 8.517830249889944e-07, 2.342957703685357e-07, 6.121447466571400e-08, 1.522556450964101e-08, 3.612645743759230e-09, 8.193084762453024e-10, 1.779169578637899e-10, 3.705600302005000e-11, 7.413876483191706e-12,
5.091649679458695e-02, 4.573151778844901e-02, 3.694556467998950e-02, 2.692013047684538e-02, 1.775606230341950e-02, 1.064675362035093e-02, 5.829963543352247e-03, 2.928879275790932e-03, 1.356115362408869e-03, 5.812253897470626e-04, 2.315448527149598e-04, 8.606837273951081e-05, 2.995905098290805e-05, 9.797876347178667e-06, 3.019879763577697e-06, 8.796978193015585e-07, 2.428296211797008e-07, 6.367159741458022e-08, 1.589419251266334e-08, 3.785128680512617e-09, 8.616040666356440e-10, 1.878000927263210e-10, 3.926150174442169e-11, 7.884860699948615e-12,
5.070993900977822e-02, 4.556694344359116e-02, 3.684575743464905e-02, 2.688248226983403e-02, 1.776083087391496e-02, 1.067077051879602e-02, 5.856320153148607e-03, 2.949455915253231e-03, 1.369318253676143e-03, 5.885623744322940e-04, 2.351716903684774e-04, 8.768960589902557e-05, 3.062189973180508e-05, 1.004787229911408e-05, 3.107442117598167e-06, 9.083366591194692e-07, 2.516169215836071e-07, 6.621105949887742e-08, 1.658780571538081e-08, 3.964729735278044e-09, 9.058118334493937e-10, 1.981693730645409e-10, 4.158434442553348e-11, 8.382811284722764e-12,
5.050505037790413e-02, 4.540353039200457e-02, 3.674640480456939e-02, 2.684474008666650e-02, 1.776527545036076e-02, 1.069448967724763e-02, 5.882509142307826e-03, 2.969982722701997e-03, 1.382535320032072e-03, 5.959321731519741e-04, 2.388271089323241e-04, 8.932921481068012e-05, 3.129458967518851e-05, 1.030247320666876e-05, 3.196935475182791e-06, 9.377127238100771e-07, 2.606633097168919e-07, 6.883502475377084e-08, 1.730716159750014e-08, 4.151693530790480e-09, 9.520052640830922e-10, 2.090454674160589e-10, 4.403000156889702e-11, 8.909096648345075e-12,
5.030181074829257e-02, 4.524126664121525e-02, 3.664750492096400e-02, 2.680690802906032e-02, 1.776940067514687e-02, 1.071791345397764e-02, 5.908530655654515e-03, 2.990458874147786e-03, 1.395765755029082e-03, 6.033343434139431e-04, 2.425109738555484e-04, 9.098721555010854e-05, 3.197717529895915e-05, 1.056172435554324e-05, 3.288386808046946e-06, 9.678393018851397e-07, 2.699744983447997e-07, 7.154569571025100e-08, 1.805303457631017e-08, 4.346271231027994e-09, 1.000260128614816e-09, 2.204497749709057e-10, 4.660416043081739e-11, 9.465145253925589e-12,
5.010020029332312e-02, 4.508014035864855e-02, 3.654905589693578e-02, 2.676899010968272e-02, 1.777321113062525e-02, 1.074104420030123e-02, 5.934384857748132e-03, 3.010883563955969e-03, 1.409008759617917e-03, 6.107684423623219e-04, 2.462231479060814e-04, 9.266362211906444e-05, 3.266971015673448e-05, 1.082567082463941e-05, 3.381823156207006e-06, 9.987297895689455e-07, 2.795562747804223e-07, 7.434531384209811e-08, 1.882621621594985e-08, 4.548720656712876e-09, 1.050654531400523e-09, 2.324044455484015e-10, 4.931273194348278e-11, 1.005244780724673e-11,
4.990019950197933e-02, 4.492013986908066e-02, 3.645105582860189e-02, 2.673099025400986e-02, 1.777671133977264e-02, 1.076388426020209e-02, 5.960071932365161e-03, 3.031256004638500e-03, 1.422263542187767e-03, 6.182340268748224e-04, 2.499634912275244e-04, 9.435844645785481e-05, 3.337224686318702e-05, 1.109435747784723e-05, 3.477271623478908e-06, 1.030397689335420e-06, 2.894145007844956e-07, 7.723615980564308e-08, 1.962751543544288e-08, 4.759306401313118e-09, 1.103268963266064e-09, 2.449323999250303e-10, 5.216185779936677e-11, 1.067255950871246e-11,
4.970178917355474e-02, 4.476125365213571e-02, 3.635350279617828e-02, 2.669291230214650e-02, 1.777990576685169e-02, 1.078643596997301e-02, 5.985592081990547e-03, 3.051575426645266e-03, 1.435529318602975e-03, 6.257306536581311e-04, 2.537318613957682e-04, 9.607169845821731e-05, 3.408483708771664e-05, 1.136782895593937e-05, 3.574759372968833e-06, 1.062856608414895e-06, 2.995551124457981e-07, 8.022055367221731e-08, 2.045775871541974e-08, 4.978299947512471e-09, 1.158186354287886e-09, 2.580573505141284e-10, 5.515791769668081e-11, 1.132710236794201e-11,
4.950495041150847e-02, 4.460347033982739e-02, 3.625639486502504e-02, 2.665476001060706e-02, 1.778279881806965e-02, 1.080870165787172e-02, 6.010945527318278e-03, 3.071841078155124e-03, 1.448805312236410e-03, 6.332578793413663e-04, 2.575281134754226e-04, 9.780338597662601e-05, 3.480753154845243e-05, 1.164612966857544e-05, 3.674313622557688e-06, 1.096120257271182e-06, 3.099841200421774e-07, 8.330085515317671e-08, 2.131779030344619e-08, 5.205979784116429e-09, 1.215492127155021e-09, 2.718038223980276e-10, 5.830753674757582e-11, 1.201776758209583e-11,
4.930966461746618e-02, 4.444677871414468e-02, 3.615973008665411e-02, 2.661653705405882e-02, 1.778539484223481e-02, 1.083068364379124e-02, 6.036132506761086e-03, 3.092052224866762e-03, 1.462090753999602e-03, 6.408152605676265e-04, 2.613521000760417e-04, 9.955351484801348e-05, 3.554038000658311e-05, 1.192930378641804e-05, 3.775961640381221e-06, 1.130202448049656e-06, 3.207076078822749e-07, 8.647946381739914e-08, 2.220847241787952e-08, 5.442631523361448e-09, 1.275274251104716e-09, 2.861971747131874e-10, 6.161759305076516e-11, 1.274631797902238e-11,
4.911591348536256e-02, 4.429116770468041e-02, 3.606350649970037e-02, 2.657824702702797e-02, 1.778769813141002e-02, 1.085238423894444e-02, 6.061153275969073e-03, 3.112208149789433e-03, 1.475384882369710e-03, 6.484023540836322e-04, 2.652036714081173e-04, 1.013220888998929e-04, 3.628343126101144e-05, 1.221739523336176e-05, 3.879730740307363e-06, 1.165117092996970e-06, 3.317317341279844e-07, 8.975881930114639e-08, 2.313068545017253e-08, 5.688548018593939e-09, 1.337623296423647e-09, 3.012636223886814e-10, 6.509522543019818e-11, 1.351459052631235e-11,
4.892367899572123e-02, 4.413662638630213e-02, 3.596772213085759e-02, 2.653989344556944e-02, 1.778971292156344e-02, 1.087380574556250e-02, 6.086008107357231e-03, 3.132308153033729e-03, 1.488686943413403e-03, 6.560187168274806e-04, 2.690826753388306e-04, 1.031091099668697e-04, 3.703673314333126e-05, 1.251044767887734e-05, 3.985648277412653e-06, 1.200878202853177e-06, 3.430627305977342e-07, 9.314140151019842e-08, 2.408532816554778e-08, 5.944029482285703e-09, 1.402632489506450e-09, 3.170302582383011e-10, 6.874784134138555e-11, 1.432449890734718e-11,
4.873294341006831e-02, 4.398314397686461e-02, 3.587237499578041e-02, 2.650147974890143e-02, 1.779144339321610e-02, 1.089495045660661e-02, 6.110697289641747e-03, 3.152351551602443e-03, 1.501996190807767e-03, 6.636639060145234e-04, 2.729889574475385e-04, 1.049145779055264e-04, 3.780033251312236e-05, 1.280850453047198e-05, 4.093741643459231e-06, 1.237499885216840e-06, 3.547069025506517e-07, 9.662973081415857e-08, 2.507331790196271e-08, 6.209383604351499e-09, 1.470397768462857e-09, 3.335250754063577e-10, 7.258312494693261e-11, 1.517803616542504e-11,
4.854368926547647e-02, 4.383070983496273e-02, 3.577746309995333e-02, 2.646300930100481e-02, 1.779289367208600e-02, 1.091582065549278e-02, 6.135221127384963e-03, 3.172337679181653e-03, 1.515311885858284e-03, 6.713374792213792e-04, 2.769223610809810e-04, 1.067384906096703e-04, 3.857427525356180e-05, 1.311160892626783e-05, 4.204038262374272e-06, 1.274996342883948e-06, 3.666706284517085e-07, 1.002263682328432e-07, 2.609559076728963e-08, 6.484925670734826e-09, 1.541017839264559e-09, 3.507769901671642e-10, 7.660904536280459e-11, 1.607727741704685e-11,
4.835589936923524e-02, 4.367931345772460e-02, 3.568298443952789e-02, 2.642448539218887e-02, 1.779406782972884e-02, 1.093641861582915e-02, 6.159579940548899e-03, 3.192265885932076e-03, 1.528633297513974e-03, 6.790389944680943e-04, 2.808827274081908e-04, 1.085808440259272e-04, 3.935860626734697e-05, 1.341980372769947e-05, 4.316565585733281e-06, 1.313381872161249e-06, 3.789603597179296e-07, 1.039339156146654e-07, 2.715310183463276e-08, 6.770978682227037e-09, 1.614594232422463e-09, 3.688158650780031e-10, 8.083386507680218e-11, 1.702438263544048e-11,
4.816955679364489e-02, 4.352894447864365e-02, 3.558893700212938e-02, 2.638591124062373e-02, 1.779496988417502e-02, 1.095674660116565e-02, 6.183774064057273e-03, 3.212135538280808e-03, 1.541959702379804e-03, 6.867680102984689e-04, 2.848698954750911e-04, 1.104416321696720e-04, 4.015336947292757e-05, 1.373313151233200e-05, 4.431351088248959e-06, 1.352670861154746e-06, 3.915826204457684e-07, 1.077550158069270e-07, 2.824682533570618e-08, 7.067873473484921e-09, 1.691231360184793e-09, 3.876725324852518e-10, 8.526614854068629e-11, 1.802159950539794e-11,
4.798464487092990e-02, 4.337959266544927e-02, 3.549531876763355e-02, 2.634728999384005e-02, 1.779560380056248e-02, 1.097680686475537e-02, 6.207803847365841e-03, 3.231946018713532e-03, 1.555290384726397e-03, 6.945240858585638e-04, 2.888837022587659e-04, 1.123208471412813e-04, 4.095860780104335e-05, 1.405163456680099e-05, 4.548422263267276e-06, 1.392877788034098e-06, 4.045440071197671e-07, 1.116923528179448e-07, 2.937775485219830e-08, 7.375948832211816e-09, 1.771036574246196e-09, 4.073788183832126e-10, 8.991477093735310e-11, 1.907126635049774e-11,
4.780114718826921e-02, 4.323124791801487e-02, 3.540212770891502e-02, 2.630862473019698e-02, 1.779597349176600e-02, 1.099660164932758e-02, 6.231669654041005e-03, 3.251696725567244e-03, 1.568624636497155e-03, 7.023067809733960e-04, 2.929239827213876e-04, 1.142184791426940e-04, 4.177436319156342e-05, 1.437535487987507e-05, 4.667806618272121e-06, 1.434017219273586e-06, 4.178511883026006e-07, 1.157486519709261e-07, 3.054690350504668e-08, 7.695551618466452e-09, 1.854120223957599e-09, 4.279675666250045e-10, 9.478892712440543e-11, 2.017581513377660e-11,
4.761904758294018e-02, 4.308390026630361e-02, 3.530936179256772e-02, 2.626991846031896e-02, 1.779608281902175e-02, 1.101613318687175e-02, 6.255371861346576e-03, 3.271387072823608e-03, 1.581961757312850e-03, 7.101156562218495e-04, 2.969905698637891e-04, 1.161345164942711e-04, 4.260067659062395e-05, 1.470433413564255e-05, 4.789531670400255e-06, 1.476103807870416e-06, 4.315109043066458e-07, 1.199266800495285e-07, 3.175530414155066e-08, 8.027036884064213e-09, 1.940595715026441e-09, 4.494726634847800e-10, 9.989814075543555e-11, 2.133777453291327e-11,
4.743833013757313e-02, 4.293753986834974e-02, 3.521701897959884e-02, 2.623117412850210e-02, 1.779593559254810e-02, 1.103540369843257e-02, 6.278910859838581e-03, 3.291016489903003e-03, 1.595301054473777e-03, 7.179502730098132e-04, 3.010832947786666e-04, 1.180689456519385e-04, 4.343758794806073e-05, 1.503861370682289e-05, 4.913624941967946e-06, 1.519152291541055e-06, 4.455299668471969e-07, 1.242292454350298e-07, 3.300400952024782e-08, 8.370767992034648e-09, 2.030579568696436e-09, 4.719290625703331e-10, 1.052522735802756e-10, 2.255977309097792e-11,
4.725897917551310e-02, 4.279215700827585e-02, 3.512509722609648e-02, 2.619239461409037e-02, 1.779553557216146e-02, 1.105441539391520e-02, 6.302287052967961e-03, 3.310584421459296e-03, 1.608641842959508e-03, 7.258101936415591e-04, 3.052019867033996e-04, 1.200217512246031e-04, 4.428513621513215e-05, 1.537823464820384e-05, 5.040113956010804e-06, 1.563177490896344e-06, 4.599152586774707e-07, 1.286591982350455e-07, 3.429409249348245e-08, 8.727116736099376e-09, 2.124191481395890e-09, 4.953728100850563e-10, 1.108615349254341e-10, 2.384454244379610e-11,
4.708097925628696e-02, 4.264774209434517e-02, 3.503359448387307e-02, 2.615358273282303e-02, 1.779488646788802e-02, 1.107317047190098e-02, 6.325500856691145e-03, 3.330090327175465e-03, 1.621983445426364e-03, 7.336949813893826e-04, 3.093464730724775e-04, 1.219929159918282e-04, 4.514335934252944e-05, 1.572323769020520e-05, 5.169026231838230e-06, 1.608194307596100e-06, 4.746737332055436e-07, 1.332194304037319e-07, 3.562664618759487e-08, 9.096463460133921e-09, 2.221554384843180e-09, 5.198410704380258e-10, 1.167364913558817e-10, 2.519492062496801e-11,
4.690431517117231e-02, 4.250428565704796e-02, 3.494250870108374e-02, 2.611474123815314e-02, 1.779399194057043e-02, 1.109167111947267e-02, 6.348552699088311e-03, 3.349533681560090e-03, 1.635325192202630e-03, 7.416042005615245e-04, 3.135165795695190e-04, 1.239824209217587e-04, 4.601229427867011e-05, 1.607366323256981e-05, 5.300389280603969e-06, 1.654217722483963e-06, 4.898124140933825e-07, 1.379128758534175e-07, 3.700278418066096e-08, 9.479197177577245e-09, 2.322794506597858e-09, 5.453721522008689e-10, 1.228880765193060e-10, 2.661385544957729e-11,
4.672897193886569e-02, 4.236177834722165e-02, 3.485183782282227e-02, 2.607587282253836e-02, 1.779285560247008e-02, 1.110991951204951e-02, 6.371443019989266e-03, 3.368913973744788e-03, 1.648666421281617e-03, 7.495374165683856e-04, 3.177121301788765e-04, 1.259902451892819e-04, 4.689197696827053e-05, 1.642955133818251e-05, 5.434230600894089e-06, 1.701262793703192e-06, 5.053383948381133e-07, 1.427425105576083e-07, 3.842364067771240e-08, 9.875715690752219e-09, 2.428041431045435e-09, 5.720055344098941e-10, 1.293276011738979e-10, 2.810440797761302e-11,
4.655493480124785e-02, 4.222021093420397e-02, 3.476157979169368e-02, 2.603698011870410e-02, 1.779148101786419e-02, 1.112791781323130e-02, 6.394172270606816e-03, 3.388230707282642e-03, 1.662006478312619e-03, 7.574941959870622e-04, 3.219329472368112e-04, 1.280163661944144e-04, 4.778244235119368e-05, 1.679094172701760e-05, 5.570577674333781e-06, 1.749344654794168e-06, 5.212588383357159e-07, 1.477113526453199e-07, 3.989037068336987e-08, 1.028642571006051e-08, 2.537428160803772e-09, 5.997818932118402e-10, 1.360667634006872e-10, 2.966975605812295e-11,
4.638218921924295e-02, 4.207957430401844e-02, 3.467173254836582e-02, 2.599806570088028e-02, 1.778987170363837e-02, 1.114566817465160e-02, 6.416740913177544e-03, 3.407483399947697e-03, 1.675344716589835e-03, 7.654741066242090e-04, 3.261788514822309e-04, 1.300607595809019e-04, 4.868372436156807e-05, 1.715787377021532e-05, 5.709457961214276e-06, 1.798478512774312e-06, 5.375809764272916e-07, 1.528224624866850e-07, 4.140415017182063e-08, 1.071174297301488e-08, 2.651091178538587e-09, 6.287431288514196e-10, 1.431176590013844e-10, 3.131319795510233e-11,
4.621072086876975e-02, 4.193985945759166e-02, 3.458229403209923e-02, 2.595913208601159e-02, 1.778803112987363e-02, 1.116317273583945e-02, 6.439149420609862e-03, 3.426671583535544e-03, 1.688680497039330e-03, 7.734767175772624e-04, 3.304496621069825e-04, 1.321233992550229e-04, 4.959585592717409e-05, 1.753038648428795e-05, 5.850898896141330e-06, 1.848679646201195e-06, 5.543121094281112e-07, 1.580789427698017e-07, 4.296617625407598e-08, 1.115209236307238e-08, 2.769170509175534e-09, 6.589323929987227e-10, 1.504927920826442e-10, 3.303815605611736e-11,
4.604051563678258e-02, 4.180105750900177e-02, 3.449326218125724e-02, 2.592018173494225e-02, 1.778596272042889e-02, 1.118043362408959e-02, 6.461398276139252e-03, 3.445794803665062e-03, 1.702013188204082e-03, 7.815015992940307e-04, 3.347451968056858e-04, 1.342042574045827e-04, 5.051886896909283e-05, 1.790851852545547e-05, 5.994927883706295e-06, 1.899963403219493e-06, 5.714596056395996e-07, 1.634839385687755e-07, 4.457766734244092e-08, 1.160790802823088e-08, 2.891809782495794e-09, 6.903941164143408e-10, 1.582050858275930e-10, 3.484818066464597e-11,
4.587155961739878e-02, 4.166315968375730e-02, 3.440463493379588e-02, 2.588121705357570e-02, 1.778366985351790e-02, 1.119745295434074e-02, 6.483487972990548e-03, 3.464852619581364e-03, 1.715342166227204e-03, 7.895483236306779e-04, 3.390652718251053e-04, 1.363033045180892e-04, 5.145279440161418e-05, 1.829230818411178e-05, 6.141572294181332e-06, 1.952345199592634e-06, 5.890309008444785e-07, 1.690406374029299e-07, 4.623986331213488e-08, 1.207963349935273e-08, 3.019156296102189e-09, 7.231740369499922e-10, 1.662678934554306e-10, 3.674695387711352e-11,
4.570383910811191e-02, 4.152615731710641e-02, 3.431641022773538e-02, 2.584224039400981e-02, 1.778115586228123e-02, 1.121423282906180e-02, 6.505419014047229e-03, 3.483844603959974e-03, 1.728666814833369e-03, 7.976164639081216e-04, 3.434097020130475e-04, 1.384205094040996e-04, 5.239766213239934e-05, 1.868179337942098e-05, 6.290859459239708e-06, 2.005840516719740e-06, 6.070334977852304e-07, 1.747522692871443e-07, 4.795402565999714e-08, 1.256772180817765e-08, 3.151361078742252e-09, 7.573192278821917e-10, 1.746950093698334e-10, 3.873829354558238e-11,
4.553734060608693e-02, 4.139004185237512e-02, 3.422858600161288e-02, 2.580325405564792e-02, 1.777842403535281e-02, 1.123077533814561e-02, 6.527191911527517e-03, 3.502770342712301e-03, 1.741986525308525e-03, 8.057055949668610e-04, 3.477783008667798e-04, 1.405558392107246e-04, 5.335350106289392e-05, 1.907701165404446e-05, 6.442816667702599e-06, 2.060464899638698e-06, 6.254749656261227e-07, 1.806221067733035e-07, 4.972143766021883e-08, 1.307263560498871e-08, 3.288578953974790e-09, 7.928781265764585e-10, 1.835006804968560e-10, 4.082615732704855e-11,
4.537205080453680e-02, 4.125480483933464e-02, 3.414116019491756e-02, 2.576426028628676e-02, 1.777547761742144e-02, 1.124708255881008e-02, 6.548807186667278e-03, 3.521629434792420e-03, 1.755300696477955e-03, 8.138152932202563e-04, 3.521708805809611e-04, 1.427092594452849e-04, 5.432033908898698e-05, 1.947800016899863e-05, 6.597471161313387e-06, 2.116233955016029e-06, 6.443629393989669e-07, 1.866534649828246e-07, 5.154340451703734e-08, 1.359484727589341e-08, 3.430968604165937e-09, 8.299005634793020e-10, 1.926996178129430e-10, 4.301464682027878e-11,
4.520795658917705e-02, 4.112043793259718e-02, 3.405413074850873e-02, 2.572526128318092e-02, 1.777231980978664e-02, 1.126315655550645e-02, 6.570265369409510e-03, 3.540421492005219e-03, 1.768608734682721e-03, 8.219451367062801e-04, 3.565872520950788e-04, 1.448807339941052e-04, 5.529820310191234e-05, 1.988479569864333e-05, 6.754850130540710e-06, 2.173163349124288e-06, 6.637051194328501e-07, 1.928497016302502e-07, 5.342125351433687e-08, 1.413483905968383e-08, 3.578692634800735e-09, 8.684377914351718e-10, 2.023070080636286e-10, 4.530801179111378e-11,
4.504504503475756e-02, 4.098693289003906e-02, 3.396749560501728e-02, 2.568625919408534e-02, 1.776895377090940e-02, 1.127899937983449e-02, 6.591566998100445e-03, 3.559146138815943e-03, 1.781910053754575e-03, 8.300947051377634e-04, 3.610272251403859e-04, 1.470702251424386e-04, 5.628711898938702e-05, 2.029743462580113e-05, 6.914980710411266e-06, 2.231268805807734e-06, 6.835092707680403e-07, 1.992142170378856e-07, 5.535633416209428e-08, 1.469310316423800e-08, 3.731917639095868e-09, 9.085425153253296e-10, 2.123385256734191e-10, 4.771065448714377e-11,
4.488330340166864e-02, 4.085428157125165e-02, 3.388125270923101e-02, 2.564725611827542e-02, 1.776538261695741e-02, 1.129461307046422e-02, 6.612712619192014e-03, 3.577803012161155e-03, 1.795204074989377e-03, 8.382635799511534e-04, 3.654906082863329e-04, 1.492776935945109e-04, 5.728711163698362e-05, 2.071595293700726e-05, 7.077889976373547e-06, 2.290566104436979e-06, 7.037832225543008e-07, 2.057504541414740e-07, 5.735001833961595e-08, 1.527014188242628e-08, 3.890814262899134e-09, 9.502689220255176e-10, 2.228103448473138e-10, 5.022713404265211e-11,
4.472271913262009e-02, 4.072247593601856e-02, 3.379540000846487e-02, 2.560825410754588e-02, 1.776160942234490e-02, 1.130999965306429e-02, 6.633702786950691e-03, 3.596391761261163e-03, 1.808490227119074e-03, 8.464513443538058e-04, 3.699772089864881e-04, 1.515030984936758e-04, 5.829820492973132e-05, 2.114038621789011e-05, 7.243604940193490e-06, 2.351071077853321e-06, 7.245348674338373e-07, 2.124618984868949e-07, 5.940370043550801e-08, 1.586646770748551e-08, 4.055557269860872e-09, 9.936727106790988e-10, 2.337391518643365e-10, 5.286217097470293e-11,
4.456327984939165e-02, 4.059150804281948e-02, 3.370993545291584e-02, 2.556925516718852e-02, 1.775763722026702e-02, 1.132516114023635e-02, 6.654538063172564e-03, 3.614912047433917e-03, 1.821767946282297e-03, 8.546575833698299e-04, 3.744868336239402e-04, 1.537463974426689e-04, 5.932042175394131e-05, 2.157076964868201e-05, 7.412152545883008e-06, 2.412799610303462e-06, 7.457721609090959e-07, 2.193520782178834e-07, 6.151879748432610e-08, 1.648260344782414e-08, 4.226325606862447e-09, 1.038811123282216e-09, 2.451421575634041e-10, 5.562065177123565e-11,
4.440497334965190e-02, 4.046137004735952e-02, 3.362485699600370e-02, 2.553026125694932e-02, 1.775346900322881e-02, 1.134009953145561e-02, 6.675219016904510e-03, 3.633363543910429e-03, 1.835036675993636e-03, 8.628818838845118e-04, 3.790192875561827e-04, 1.560075465239576e-04, 6.035378399925335e-05, 2.200713799986046e-05, 7.583559665662564e-06, 2.475767635365390e-06, 7.675031206956829e-07, 2.264245640547726e-07, 6.369674929985336e-08, 1.711908234122241e-08, 4.403302469686895e-09, 1.085742975577419e-09, 2.570371100217970e-10, 5.850763357201293e-11,
4.424778760384563e-02, 4.033205420112382e-02, 3.354016259469772e-02, 2.549127429196554e-02, 1.774910772356860e-02, 1.135481681301709e-02, 6.695746224171436e-03, 3.651745935651723e-03, 1.848295867111625e-03, 8.711238346873321e-04, 3.835743751594729e-04, 1.582865003201697e-04, 6.139831256089741e-05, 2.244952562791885e-05, 7.757853095958515e-06, 2.539991133866013e-06, 7.897358260606025e-07, 2.336829692642527e-07, 6.593901860495263e-08, 1.777644816839006e-08, 4.586675368916113e-09, 1.134528688251946e-09, 2.694423074264067e-10, 6.152834894324661e-11,
4.409171075214642e-02, 4.020355284995708e-02, 3.345585020982976e-02, 2.545229614368294e-02, 1.774455629397607e-02, 1.136931495798764e-02, 6.716120267709398e-03, 3.670058919167346e-03, 1.861544977805499e-03, 8.793830265135998e-04, 3.881518998726601e-04, 1.605832119345994e-04, 6.245402734216756e-05, 2.289796647126709e-05, 7.935059553436375e-06, 2.605486131791345e-06, 8.124784171460975e-07, 2.411309496201616e-07, 6.824709115794425e-08, 1.845525536584613e-08, 4.776636196039541e-09, 1.185230318436848e-09, 2.823766111379131e-10, 6.468821074671570e-11,
4.393673110147393e-02, 4.007585843266726e-02, 3.337191780639467e-02, 2.541332864075396e-02, 1.773981758800472e-02, 1.138359592616321e-02, 6.736341736704600e-03, 3.688302202335457e-03, 1.874783473520783e-03, 8.876590520847261e-04, 3.927516642404837e-04, 1.628976330117771e-04, 6.352094725710288e-05, 2.335249404626098e-05, 8.115205671070667e-06, 2.672268698189861e-06, 8.357390942793088e-07, 2.487722033553086e-07, 7.062247587545981e-08, 1.915606913808415e-08, 4.973381289758415e-09, 1.237911591502865e-09, 2.958594589479379e-10, 6.799281710416473e-11,
4.378283712257336e-02, 3.994896347965313e-02, 3.328836335383787e-02, 2.537437356991676e-02, 1.773489444057891e-02, 1.139766166403146e-02, 6.756411226538099e-03, 3.706475504224514e-03, 1.888010826943728e-03, 8.959515061471583e-04, 3.973734699563366e-04, 1.652297137580981e-04, 6.459909023337196e-05, 2.381314144336087e-05, 8.298317994252555e-06, 2.740354943069782e-06, 8.595261172680369e-07, 2.566104711043506e-07, 7.306670495172569e-08, 1.987946556898715e-08, 5.177111502470055e-09, 1.292637933148947e-09, 3.099108785291862e-10, 7.144795645775775e-11,
4.363001744715687e-02, 3.982286061155552e-02, 3.320518482633081e-02, 2.533543267685622e-02, 1.772978964849540e-02, 1.141151410473940e-02, 6.776329338536115e-03, 3.724578554916578e-03, 1.901226517964677e-03, 9.042599855099881e-04, 4.020171179044872e-04, 1.675794029624983e-04, 6.568847321535449e-05, 2.427994132341776e-05, 8.484422976935653e-06, 2.809761015290885e-06, 8.838478046828231e-07, 2.646495358377285e-07, 7.558133397422763e-08, 2.062603173245615e-08, 5.388032266916089e-09, 1.349476501779041e-09, 3.245515010785000e-10, 7.505961272733913e-11,
4.347826086510354e-02, 3.969754253793097e-02, 3.312238020303462e-02, 2.529650766704636e-02, 1.772450597091944e-02, 1.142515516806592e-02, 6.796096679725934e-03, 3.742611095332259e-03, 1.914430033640378e-03, 9.125840890812658e-04, 4.066824082017649e-04, 1.699466480171729e-04, 6.678911216741908e-05, 2.475292591408794e-05, 8.673546977821301e-06, 2.880503100451610e-06, 9.087125331256531e-07, 2.728932227866936e-07, 7.816794203571558e-08, 2.139636580221729e-08, 5.606353662978705e-09, 1.408496221162769e-09, 3.398025751527026e-10, 7.883397056523605e-11,
4.332755632171881e-02, 3.957300205594846e-02, 3.303994746835268e-02, 2.525760020657558e-02, 1.771904612987528e-02, 1.143858676039902e-02, 6.815713862597188e-03, 3.760572877057291e-03, 1.927620868155304e-03, 9.209234179030315e-04, 4.113691402386995e-04, 1.723313949383268e-04, 6.790102207738942e-05, 2.523212700637400e-05, 8.865716256583677e-06, 2.952597418772032e-06, 9.341287364854967e-07, 2.813453993594332e-07, 8.082813184250149e-08, 2.219107716077141e-08, 5.832290484608552e-09, 1.469767813375328e-09, 3.556859806970178e-10, 8.277742070931332e-11,
4.317789291504982e-02, 3.944923204910822e-02, 3.295788461217205e-02, 2.521871192295450e-02, 1.771341281073151e-02, 1.145181077471755e-02, 6.835181504868561e-03, 3.778463662170803e-03, 1.940798522782027e-03, 9.292775751850987e-04, 4.160771127201205e-04, 1.747335883869525e-04, 6.902421696019748e-05, 2.571757595129307e-05, 9.060956970135894e-06, 3.026060222973472e-06, 9.601049051810014e-07, 2.900099750483380e-07, 8.356352981901240e-08, 2.301078650745206e-08, 6.066062306868192e-09, 1.533363832011988e-09, 3.722242432658182e-10, 8.689656543497484e-11,
4.302925989325634e-02, 3.932622548598150e-02, 3.287618963009415e-02, 2.517984440590657e-02, 1.770760866268056e-02, 1.146482909057739e-02, 6.854500229259625e-03, 3.796283223075221e-03, 1.953962505840666e-03, 9.376461663375829e-04, 4.208061237052044e-04, 1.771531716896230e-04, 7.015870986171649e-05, 2.620930365667012e-05, 9.259295168937327e-06, 3.100907796155277e-06, 9.866495853905470e-07, 2.988909013284215e-07, 8.637578620855405e-08, 2.385612596555576e-08, 6.307893553074310e-09, 1.599358695672206e-09, 3.894405484353396e-10, 9.119822410677692e-11,
4.288164665203621e-02, 3.920397541897279e-02, 3.279486052365558e-02, 2.514099920814277e-02, 1.770163629921307e-02, 1.147764357410180e-02, 6.873670663267980e-03, 3.814031342327893e-03, 1.967112332657482e-03, 9.460287990022332e-04, 4.255559706469815e-04, 1.795900868592989e-04, 7.130451286277274e-05, 2.670734058405723e-05, 9.460756793343449e-06, 3.177156449669564e-06, 1.013771378269993e-06, 3.079921715469423e-07, 8.926657517025145e-08, 2.472773918851151e-08, 6.558013562022514e-09, 1.667828721708496e-09, 4.073587564079930e-10, 9.568943883030656e-11,
4.273504273210309e-02, 3.908247498310176e-02, 3.271389530053854e-02, 2.510217784611947e-02, 1.769549829858671e-02, 1.149025607797584e-02, 6.892693438951311e-03, 3.831707812474384e-03, 1.980247525522613e-03, 9.544250830825521e-04, 4.303264504312887e-04, 1.820442746161363e-04, 7.246163708332843e-05, 2.721171674577641e-05, 9.665367669998247e-06, 3.254822520994418e-06, 1.041478939158333e-06, 3.173178208042473e-07, 9.223759487212331e-08, 2.562628146505372e-08, 6.816656655277590e-09, 1.738852160234812e-09, 4.260034168077658e-10, 1.003774802049437e-10,
4.258943781671641e-02, 3.896171739480690e-02, 3.263329197477258e-02, 2.506338180078111e-02, 1.768919720428979e-02, 1.150266844144480e-02, 6.911569192714587e-03, 3.849312435883509e-03, 1.993367613647071e-03, 9.628346307727579e-04, 4.351173594151808e-04, 1.845156744082946e-04, 7.363009268683509e-05, 2.772246170208700e-05, 9.873153508270447e-06, 3.333922371606340e-06, 1.069780976771590e-06, 3.268719258258916e-07, 9.529056758026075e-08, 2.655241982336615e-08, 7.084062204512885e-09, 1.812509228389301e-09, 4.453997836662070e-10, 1.052698531781155e-10,
4.244482172926076e-02, 3.884169595076808e-02, 3.255304856692594e-02, 2.502461251828677e-02, 1.768273552549917e-02, 1.151488249031626e-02, 6.930298565101977e-03, 3.866845024584022e-03, 2.006472133118927e-03, 9.712570565855695e-04, 4.399284934647830e-04, 1.870042244327303e-04, 7.480988888474914e-05, 2.823960455847494e-05, 1.008413989673356e-05, 3.414472384852394e-06, 1.098686252385158e-06, 3.366586048260582e-07, 9.842723974406862e-08, 2.750683313416166e-08, 7.360474698881444e-09, 1.888882144845925e-09, 4.655738305983553e-10, 1.103743030016134e-10,
4.230118443087523e-02, 3.872240402674958e-02, 3.247316310428903e-02, 2.498587141072206e-02, 1.767611573753314e-02, 1.152690003696585e-02, 6.948882200593694e-03, 3.884305400103078e-03, 2.019560626858823e-03, 9.796919773788799e-04, 4.447596479926045e-04, 1.895098616559779e-04, 7.600103394120935e-05, 2.876317396306470e-05, 1.029835229969098e-05, 3.496488963822866e-06, 1.128203579004952e-06, 3.466820173623413e-07, 1.016493820775449e-07, 2.849021221266620e-08, 7.646143812402489e-09, 1.968055164569584e-09, 4.865522661679635e-10, 1.156988212905344e-10,
4.215851601813029e-02, 3.860383507646247e-02, 3.239363362104873e-02, 2.494715985679606e-02, 1.766934028229894e-02, 1.153872288034661e-02, 6.967320747407472e-03, 3.901693393306374e-03, 2.032632644574788e-03, 9.881390123812975e-04, 4.496106179942956e-04, 1.920325218349051e-04, 7.720353517786928e-05, 2.929319810415191e-05, 1.051581605374602e-05, 3.579988529224871e-06, 1.158341820527557e-06, 3.569463641819213e-07, 1.049587896365579e-07, 2.950325991947229e-08, 7.941324471345538e-09, 2.050114613808953e-09, 5.083625494412379e-10, 1.212516521853688e-10,
4.201680672075168e-02, 3.848598263044563e-02, 3.231445815845447e-02, 2.490847920252360e-02, 1.766241156873471e-02, 1.155035280600153e-02, 6.985614857304730e-03, 3.919008844240061e-03, 2.045687742716417e-03, 9.965977832166063e-04, 4.544811980848606e-04, 1.945721395374409e-04, 7.841739897888219e-05, 2.982970470785642e-05, 1.073655636441811e-05, 3.664987517257661e-06, 1.189109890889748e-06, 3.674558870591999e-07, 1.083572818921008e-07, 3.054669126023103e-08, 8.246276921595711e-09, 2.135148925321442e-09, 5.310329057283112e-10, 1.270412986177445e-10,
4.187604689939010e-02, 3.836884029496588e-02, 3.223563476497658e-02, 2.486983076189359e-02, 1.765533197324667e-02, 1.156179158607951e-02, 7.003765185401221e-03, 3.936251601974332e-03, 2.058725484428436e-03, 1.005067913927145e-03, 4.593711825343193e-04, 1.971286481632668e-04, 7.964263079603312e-05, 3.037272103589420e-05, 1.096059830280500e-05, 3.751502377490102e-06, 1.220516753207580e-06, 3.782148686249325e-07, 1.118467027994851e-07, 3.162123348414930e-08, 8.561266795982457e-09, 2.223248673824253e-09, 5.545923425115287e-10, 1.330765286803012e-10,
4.173622704343527e-02, 3.825240175093583e-02, 3.215716149645632e-02, 2.483121581752333e-02, 1.764810384014053e-02, 1.157304097935430e-02, 7.021772389982155e-03, 3.953421524448793e-03, 2.071745439503698e-03, 1.013549030996130e-03, 4.642803653028247e-04, 1.997019799644671e-04, 8.087923515401469e-05, 3.092227388346803e-05, 1.118796680229205e-05, 3.839549570741034e-06, 1.252571418905400e-06, 3.892276321869278e-07, 1.154289208634564e-07, 3.272762618126102e-08, 8.886565181554929e-09, 2.314506611665670e-09, 5.790706655596202e-10, 1.393663821011525e-10,
4.159733776887393e-02, 3.813666075285039e-02, 3.207903641624904e-02, 2.479263562129921e-02, 1.764072948204816e-02, 1.158410273124651e-02, 7.039637132321727e-03, 3.970518478319520e-03, 2.084747184335637e-03, 1.022040763368951e-03, 4.692085400752321e-04, 2.022920660661329e-04, 8.212721565584288e-05, 3.147838957727490e-05, 1.141868665530859e-05, 3.929145566962976e-06, 1.285282946835024e-06, 4.004985415423609e-07, 1.191058291991978e-07, 3.386662137844068e-08, 9.222448686786292e-09, 2.409017704710376e-09, 6.044984952267103e-10, 1.459201768233571e-10,
4.145936981619061e-02, 3.802161112774051e-02, 3.200125759535964e-02, 2.475409139500433e-02, 1.763321118034881e-02, 1.159497857384850e-02, 7.057360076506897e-03, 3.987542338807896e-03, 2.097730301870206e-03, 1.030542742473446e-03, 4.741555002951237e-04, 2.048988364869128e-04, 8.338657498840769e-05, 3.204109397362979e-05, 1.165278251013205e-05, 4.020306843129830e-06, 1.318660442385382e-06, 4.120320007817689e-07, 1.228793455892039e-07, 3.503898363412816e-08, 9.569199508689945e-09, 2.506879168432642e-09, 6.309072829350814e-10, 1.527475156898007e-10,
4.132231404830956e-02, 3.790724677414416e-02, 3.192382311257134e-02, 2.471558433093285e-02, 1.762555118558539e-02, 1.160567022595200e-02, 7.074941889265393e-03, 4.004492989551160e-03, 2.110694381557345e-03, 1.039054602239186e-03, 4.791210391982916e-04, 2.075222201595062e-04, 8.465731492815587e-05, 3.261041245670480e-05, 1.189027886774019e-05, 4.113049881129128e-06, 1.352713056582923e-06, 4.238324540847931e-07, 1.267514125360001e-07, 3.624549013173479e-08, 9.927105499830171e-09, 2.608190504211038e-09, 6.583293278405294e-10, 1.598582932338628e-10,
4.118616144857777e-02, 3.779356166109458e-02, 3.184673105456758e-02, 2.467711559249179e-02, 1.761775171787544e-02, 1.161617939307836e-02, 7.092383239797841e-03, 4.021370322454642e-03, 2.123639019301992e-03, 1.047575979115772e-03, 4.841049498456764e-04, 2.101621449510928e-04, 8.593943634690076e-05, 3.318636993688195e-05, 1.213120007871182e-05, 4.207391165659334e-06, 1.387449985183045e-06, 4.359043855077267e-07, 1.307239973106857e-07, 3.748693077169945e-08, 1.029646023520971e-08, 2.713053535818188e-09, 6.867977936790586e-10, 1.672627025762078e-10,
4.105090311878745e-02, 3.768054982712495e-02, 3.176997951604731e-02, 2.463868631479026e-02, 1.760981496731729e-02, 1.162650776751148e-02, 7.109684799613973e-03, 4.038174237545823e-03, 2.136563817414683e-03, 1.056106512090189e-03, 4.891070251557668e-04, 2.128185376836942e-04, 8.723293921775619e-05, 3.376899084921935e-05, 1.237557034017633e-05, 4.303347182132827e-06, 1.422880467752882e-06, 4.482523187629477e-07, 1.347990919972842e-07, 3.876410826216650e-08, 1.067756307901709e-08, 2.821572446099107e-09, 7.163467257936396e-10, 1.749712424280235e-10,
4.091653027723763e-02, 3.756820537928963e-02, 3.169356659983426e-02, 2.460029760521669e-02, 1.760174309439098e-02, 1.163665702833298e-02, 7.126847242372760e-03, 4.054904642830034e-03, 2.149468384561750e-03, 1.064645842703211e-03, 4.941270579364624e-04, 2.154913241544623e-04, 8.853782262118966e-05, 3.435829915202849e-05, 1.262341369281239e-05, 4.400934414585009e-06, 1.459013786745677e-06, 4.608808169902966e-07, 1.389787135328798e-07, 4.007783820825466e-08, 1.107071925121592e-08, 2.933853813831355e-09, 7.470110683396239e-10, 1.829947242009882e-10,
4.078303425683345e-02, 3.745652249220135e-02, 3.161749041697993e-02, 2.456195054400399e-02, 1.759353823035449e-02, 1.164662884145991e-02, 7.143871243726519e-03, 4.071561454147932e-03, 2.162352335715179e-03, 1.073193615064896e-03, 4.991648409164007e-04, 2.181804291558894e-04, 8.985408475119198e-05, 3.495431832556321e-05, 1.287475401789619e-05, 4.500169343590152e-06, 1.495859266567094e-06, 4.737944825204840e-07, 1.432649037435267e-07, 4.142894919988966e-08, 1.147623989395914e-08, 3.050006650760387e-09, 7.788266816674060e-10, 1.913442792242310e-10,
4.065040650322284e-02, 3.734549540708427e-02, 3.154174908686082e-02, 2.452364618478312e-02, 1.758520247763465e-02, 1.165642485968458e-02, 7.160757481168766e-03, 4.088144595034666e-03, 2.175215292102098e-03, 1.081749475869164e-03, 5.042201667757478e-04, 2.208857764959359e-04, 9.118172292155853e-05, 3.555707137081697e-05, 1.312961503439931e-05, 4.601068444184422e-06, 1.533426272633699e-06, 4.869979566305933e-07, 1.476597293759133e-07, 4.281828289817094e-08, 1.189444213781034e-08, 3.170142438803105e-09, 8.118303598807880e-10, 2.000313660685136e-10,
4.051863857296897e-02, 3.723511843084226e-02, 3.146634073726986e-02, 2.448538555512514e-02, 1.757673791021348e-02, 1.166604672271660e-02, 7.177506633885870e-03, 4.104653996580759e-03, 2.188056881153993e-03, 1.090313074407511e-03, 5.092928281764620e-04, 2.236072890180703e-04, 9.252073357227882e-05, 3.616658080842935e-05, 1.338802029613680e-05, 4.703648183796663e-06, 1.571724210423951e-06, 5.004959192917673e-07, 1.521652821247724e-07, 4.424669412024594e-08, 1.232564916775514e-08, 3.294375167412809e-09, 8.460598485695019e-10, 2.090677779778346e-10,
4.038772213175872e-02, 3.712538593514290e-02, 3.139126350450276e-02, 2.444716965707232e-02, 1.756814657400952e-02, 1.167549605722695e-02, 7.194119382612382e-03, 4.121089597294722e-03, 2.200876736455609e-03, 1.098884062581849e-03, 5.143826177920284e-04, 2.263448886212192e-04, 9.387111227603113e-05, 3.678286867769905e-05, 1.364999318896533e-05, 4.807925020187387e-06, 1.610762524521955e-06, 5.142930889091511e-07, 1.567836786560192e-07, 4.571505092266371e-08, 1.277019028898484e-08, 3.422821371098384e-09, 8.815538627142039e-10, 2.184656504086260e-10,
4.025764895264505e-02, 3.701629235551563e-02, 3.131651553343838e-02, 2.440899946765798e-02, 1.755943048725431e-02, 1.168477447689398e-02, 7.210596409489916e-03, 4.137451342967338e-03, 2.213674497693617e-03, 1.107462094916492e-03, 5.194893283366645e-04, 2.290984962796190e-04, 9.523285374477747e-05, 3.740595653570294e-05, 1.391555692803194e-05, 4.913915399396468e-06, 1.650550697654282e-06, 5.283942220541727e-07, 1.615170606256139e-07, 4.722423468318147e-08, 1.322840099243531e-08, 3.555600167090678e-09, 9.183521047622615e-10, 2.282374686766872e-10,
4.012841091432406e-02, 3.690783219046537e-02, 3.124209497761492e-02, 2.437087593941605e-02, 1.755059164086432e-02, 1.169388358245144e-02, 7.226938397929665e-03, 4.153739186537665e-03, 2.226449810605027e-03, 1.116046828569329e-03, 5.246127525940098e-04, 2.318680320625705e-04, 9.660595183645583e-05, 3.803586545651944e-05, 1.418473455507343e-05, 5.021635753700062e-06, 1.691098249720140e-06, 5.428041131892583e-07, 1.663675946941331e-07, 4.877514018099766e-08, 1.370062302006335e-08, 3.692833293148786e-09, 9.564952828725077e-10, 2.383960757119602e-10,
3.999999999944447e-02, 3.680000000059995e-02, 3.116799999930049e-02, 2.433280000087975e-02, 1.754163199880782e-02, 1.170282496173812e-02, 7.243146032478268e-03, 4.169953087960721e-03, 2.239202326925400e-03, 1.124637923342177e-03, 5.297526834452905e-04, 2.346534151540891e-04, 9.799039956176666e-05, 3.867261603055560e-05, 1.445754893576657e-05, 5.131102499577167e-06, 1.732414736815195e-06, 5.575275943850521e-07, 1.713374725370491e-07, 5.036867567538636e-08, 1.418720442984371e-08, 3.834645145498997e-09, 9.960251293271561e-10, 2.489546799212349e-10,
3.987240829294975e-02, 3.669279040777199e-02, 3.109422876955934e-02, 2.429477255707047e-02, 1.753255349846737e-02, 1.171160018974939e-02, 7.259219998687194e-03, 4.186093014076861e-03, 2.251931704336881e-03, 1.133235041690341e-03, 5.349089138969706e-04, 2.374545638724462e-04, 9.938618909104867e-05, 3.931622836397586e-05, 1.473402275712934e-05, 5.242332035686311e-06, 1.774509750249306e-06, 5.725695350302413e-07, 1.764289108507050e-07, 5.200576298270665e-08, 1.468849966046898e-08, 3.981162816898958e-09, 1.036984419108917e-09, 2.599268631588246e-10,
3.974562798045175e-02, 3.658619809423417e-02, 3.102077946831322e-02, 2.425679448997611e-02, 1.752335805099742e-02, 1.172021082869019e-02, 7.275160982985326e-03, 4.202158938482781e-03, 2.264637606416029e-03, 1.141837848731389e-03, 5.400812371078899e-04, 2.402713956896017e-04, 1.007933117612414e-04, 3.996672207823158e-05, 1.501417852497326e-05, 5.355340740852835e-06, 1.817392915558485e-06, 5.879348415340744e-07, 1.816441513539856e-07, 5.368733755176373e-08, 1.520486959573552e-08, 4.132516134819641e-09, 1.079416988641360e-09, 2.713265888052371e-10,
3.961965134663534e-02, 3.648021780180880e-02, 3.094765028439870e-02, 2.421886665902011e-02, 1.751404754167754e-02, 1.172865842802977e-02, 7.290969672554919e-03, 4.218150841404258e-03, 2.277319702581555e-03, 1.150446012253192e-03, 5.452694464158916e-04, 2.431038272505201e-04, 1.022117580829310e-04, 4.062411630969009e-05, 1.529803856140694e-05, 5.470144972067174e-06, 1.861073891511347e-06, 6.036284570216551e-07, 1.869854607856780e-07, 5.541434853749613e-08, 1.573668162859790e-08, 4.288837699737492e-09, 1.123367754690443e-09, 2.831682099538219e-10,
3.949447077369333e-02, 3.637484433107026e-02, 3.087483941561983e-02, 2.418098990152054e-02, 1.750462383026093e-02, 1.173694452455779e-02, 7.306646755210712e-03, 4.234068709570487e-03, 2.289977668041886e-03, 1.159059202721194e-03, 5.504733353639474e-04, 2.459517743923709e-04, 1.036415177474757e-04, 4.128842970936193e-05, 1.558562500239104e-05, 5.586761062494625e-06, 1.905562369110358e-06, 6.196553610221282e-07, 1.924551308975236e-07, 5.718775887296739e-08, 1.628430972487528e-08, 4.450262923529275e-09, 1.168882733425129e-09, 2.954664777053561e-10,
3.937007873979098e-02, 3.627007254054043e-02, 3.080234506879716e-02, 2.414316503313999e-02, 1.749508875131842e-02, 1.174507064244189e-02, 7.322192919282138e-03, 4.249912536090095e-03, 2.302611183742655e-03, 1.167677093284966e-03, 5.556926977257756e-04, 2.488151521636050e-04, 1.050825796342074e-04, 4.195968044272438e-05, 1.587695979534443e-05, 5.705205319496937e-06, 1.950868070588132e-06, 6.360205691498211e-07, 1.980554784429553e-07, 5.900854533963631e-08, 1.684813448659187e-08, 4.616930067961722e-09, 1.216009059634861e-09, 3.082365495704795e-10,
3.924646781755913e-02, 3.616589734589777e-02, 3.073016545981238e-02, 2.410539284832619e-02, 1.748544411457821e-02, 1.175303829328663e-02, 7.337608853498699e-03, 4.265682320328783e-03, 2.315219936314103e-03, 1.176299359784061e-03, 5.609273275309655e-04, 2.516938748429099e-04, 1.065349318177057e-04, 4.263788618964119e-05, 1.617206469680208e-05, 5.825494022666257e-06, 1.997000748399101e-06, 6.527291327784759e-07, 2.037888451615292e-07, 6.087769863588720e-08, 1.742854321493567e-08, 4.788980283268482e-09, 1.264795006101704e-09, 3.214939979798890e-10,
3.912363067261609e-02, 3.606231371919799e-02, 3.065829881364941e-02, 2.406767412074359e-02, 1.747569170526090e-02, 1.176084897619367e-02, 7.352895246878233e-03, 4.281378067788583e-03, 2.327803618018397e-03, 1.184925680753157e-03, 5.661770190896024e-04, 2.545878559580346e-04, 1.079985615751426e-04, 4.332306414437542e-05, 1.647096127012404e-05, 5.947643421871695e-06, 2.043970184206786e-06, 6.697861387086326e-07, 2.096575977590440e-07, 6.279622344379430e-08, 1.802592997281725e-08, 4.966557646806273e-09, 1.315290003124777e-09, 3.352548189021262e-10,
3.900156006211686e-02, 3.595931668810799e-02, 3.058674336443170e-02, 2.403000960369626e-02, 1.746583328441035e-02, 1.176850417782316e-02, 7.368052788618237e-03, 4.296999789988752e-03, 2.340361926696920e-03, 1.193555737426534e-03, 5.714415670164097e-04, 2.574970083044884e-04, 1.094734553936927e-04, 4.401523101569607e-05, 1.677367088325632e-05, 6.071669735319061e-06, 2.091786187867017e-06, 6.871967088282984e-07, 2.156641278833619e-07, 6.476513849410231e-08, 1.864069564701314e-08, 5.149809201782617e-09, 1.367544658194687e-09, 3.495354405688139e-10,
3.888024883332973e-02, 3.585690133515168e-02, 3.051549735545609e-02, 2.399240003054199e-02, 1.745587058922016e-02, 1.177600537245635e-02, 7.383082167989998e-03, 4.312547504348263e-03, 2.352894565717528e-03, 1.202189213741888e-03, 5.767207662543962e-04, 2.604212439641027e-04, 1.109595989780070e-04, 4.471440302707514e-05, 1.708021470654282e-05, 6.197589147623963e-06, 2.140458596407297e-06, 7.049659997669780e-07, 2.218108520959257e-07, 6.678547662939995e-08, 1.927324800987608e-08, 5.338884996046974e-09, 1.421610775815437e-09, 3.643527323071068e-10,
3.875968992223875e-02, 3.575506279696755e-02, 3.044455903922304e-02, 2.395484611509814e-02, 1.744580533335582e-02, 1.178335402205920e-02, 7.397984074235567e-03, 4.328021234069863e-03, 2.365401243921774e-03, 1.210825796343495e-03, 5.820144120980216e-04, 2.633604743234590e-04, 1.124569772577458e-04, 4.542059591697489e-05, 1.739061371058900e-05, 6.325417807898830e-06, 2.189997273002662e-06, 7.230992025431827e-07, 2.281002118389871e-07, 6.885828486546779e-08, 1.992400178059613e-08, 5.533938120937425e-09, 1.477541377471376e-09, 3.797240134791344e-10,
3.863987635217310e-02, 3.565379626357861e-02, 3.037392667746399e-02, 2.391734855203921e-02, 1.743563920727277e-02, 1.179055157634717e-02, 7.412759196467593e-03, 4.343421008025780e-03, 2.377881675572174e-03, 1.219465174584749e-03, 5.873223002158957e-04, 2.663146100921818e-04, 1.139655743951708e-04, 4.613382493922443e-05, 1.770488866417695e-05, 6.455171827854157e-06, 2.240412105948280e-06, 7.416015422055282e-07, 2.345346733985519e-07, 7.098462445078127e-08, 2.059337868599627e-08, 5.735124750174875e-09, 1.535390721736630e-09, 3.956670625281694e-10,
3.852080123246081e-02, 3.555309697767318e-02, 3.030359854116499e-02, 2.387990801728606e-02, 1.742537387852998e-02, 1.179759947285077e-02, 7.427408223571695e-03, 4.358746860644917e-03, 2.390335580299448e-03, 1.228107040530077e-03, 5.926442266729860e-04, 2.692835613210856e-04, 1.154853737927877e-04, 4.685410486348223e-05, 1.802306013223148e-05, 6.586867279914184e-06, 2.291713007629029e-06, 7.604782774674990e-07, 2.411167278630460e-07, 7.316557092414774e-08, 2.128180752084535e-08, 5.942604178796439e-09, 1.595214324524331e-09, 4.122001261311924e-10,
3.840245775710795e-02, 3.545296023389757e-02, 3.023357291058778e-02, 2.384252516838766e-02, 1.741501099209978e-02, 1.180449913698228e-02, 7.441931844111666e-03, 4.373998831801670e-03, 2.402762683049834e-03, 1.236751088956263e-03, 5.979799879523682e-04, 2.722672374201849e-04, 1.170163581010432e-04, 4.758144997578560e-05, 1.834514847383800e-05, 6.720520195347664e-06, 2.343909913486408e-06, 7.797347003360309e-07, 2.478488910777216e-07, 7.540221417046223e-08, 2.198972420767349e-08, 6.156538862120222e-09, 1.657068979473067e-09, 4.293419284575479e-10,
3.828483920350188e-02, 3.535338137815956e-02, 3.016384807528759e-02, 2.380520064489480e-02, 1.740455217067322e-02, 1.181125198210315e-02, 7.456330746237179e-03, 4.389176966706263e-03, 2.415162714032431e-03, 1.245397017353176e-03, 6.033293809765083e-04, 2.752655471765549e-04, 1.185585092260665e-04, 4.831587407918396e-05, 1.867117384031102e-05, 6.856146562413700e-06, 2.397012780982945e-06, 7.993761357339727e-07, 2.547337035948083e-07, 7.769565847456141e-08, 2.271757185607220e-08, 6.377094454732898e-09, 1.721012778467708e-09, 4.471116805332902e-10,
3.816793893113805e-02, 3.525435580694303e-02, 3.009442233412822e-02, 2.376793506872615e-02, 1.739399901496158e-02, 1.181785940959224e-02, 7.470605617594037e-03, 4.404281315796625e-03, 2.427535408666605e-03, 1.254044525923931e-03, 6.086922031280789e-04, 2.782783987720487e-04, 1.201118083374589e-04, 4.905739049445539e-05, 1.900115617331417e-05, 6.993762324523258e-06, 2.451031588564470e-06, 8.194079411165740e-07, 2.617737306194247e-07, 8.004702257316086e-08, 2.346580082146485e-08, 6.604439849492218e-09, 1.787105132291912e-09, 4.655290897108403e-10,
3.805175038037058e-02, 3.515587896663319e-02, 3.002529399529451e-02, 2.373072904452722e-02, 1.738335310399386e-02, 1.182432280891499e-02, 7.484757145237018e-03, 4.419311934631790e-03, 2.439880507529494e-03, 1.262693317584496e-03, 6.140682522703294e-04, 2.813056998008642e-04, 1.216762358761227e-04, 4.980601206090469e-05, 1.933511520303083e-05, 7.133383378416532e-06, 2.505976334620443e-06, 8.398355060820853e-07, 2.689715619512641e-07, 8.245743970485763e-08, 2.423486876333043e-08, 6.838747216535875e-09, 1.855406791409374e-09, 4.846143692434978e-10,
3.793626707118496e-02, 3.505794635285259e-02, 2.995646137630198e-02, 2.369358316002180e-02, 1.737261599541027e-02, 1.183064355769310e-02, 7.498786015545006e-03, 4.434268883786796e-03, 2.452197756303585e-03, 1.271343097962749e-03, 6.194573267669947e-04, 2.843473572869607e-04, 1.232517715621317e-04, 5.056175113724188e-05, 1.967307044638584e-05, 7.275025572356492e-06, 2.561857036442635e-06, 8.606642519766002e-07, 2.763298119220738e-07, 8.492805765818359e-08, 2.502524070286576e-08, 7.080192042288629e-09, 1.925979866870977e-09, 5.043882479643514e-10,
3.782148260199357e-02, 3.496055350980725e-02, 2.988792280400401e-02, 2.365649798635641e-02, 1.736178922575176e-02, 1.183682302177502e-02, 7.512692914138655e-03, 4.449152228749104e-03, 2.464486905724394e-03, 1.279993575397010e-03, 6.248592255017611e-04, 2.874032777013226e-04, 1.248383944026367e-04, 5.132461960253921e-05, 2.001504120531752e-05, 7.418704704338900e-06, 2.618683729182417e-06, 8.818996314932297e-07, 2.838511193289351e-07, 8.746003881769229e-08, 2.583738908006979e-08, 7.328953168459164e-09, 1.998887851344822e-09, 5.248719800690718e-10,
3.770739064845260e-02, 3.486369602964300e-02, 2.981967661459671e-02, 2.361947407843761e-02, 1.735087431074578e-02, 1.184286255530698e-02, 7.526478525800318e-03, 4.463962039816473e-03, 2.476747711528288e-03, 1.288644460934055e-03, 6.302737478972892e-04, 2.904733669790712e-04, 1.264360826998053e-04, 5.209462885726612e-05, 2.036104656510058e-05, 7.564436520319159e-06, 2.676466464806914e-06, 9.035471282657517e-07, 2.915381473633755e-07, 9.005456020806748e-08, 2.667179381023582e-08, 7.585212831018542e-09, 2.074195640266188e-09, 5.460873550020635e-10,
3.759398496230062e-02, 3.476736955181213e-02, 2.975172115362119e-02, 2.358251197526283e-02, 1.733987274558812e-02, 1.184876350080470e-02, 7.540143534396260e-03, 4.478698391996321e-03, 2.488979934400409e-03, 1.297295468326627e-03, 6.357006939337993e-04, 2.935575305364166e-04, 1.280448140587930e-04, 5.287178982439950e-05, 2.071110539271887e-05, 7.712236712456104e-06, 2.735215311054258e-06, 9.256122564568168e-07, 2.993935835363168e-07, 9.271281353623620e-08, 2.752894233983478e-08, 7.849156699151529e-09, 2.151969553104259e-09, 5.680567074453905e-10,
3.748125937021783e-02, 3.467156976244951e-02, 2.968405477596381e-02, 2.354561220024418e-02, 1.732878600522100e-02, 1.185452718922551e-02, 7.553688622801165e-03, 4.493361364906533e-03, 2.501183339922753e-03, 1.305946314030461e-03, 6.411398641672218e-04, 2.966556732874582e-04, 1.296645653957425e-04, 5.365611295060943e-05, 2.106523633528864e-05, 7.862120917373262e-06, 2.794940350388250e-06, 9.481005603408566e-07, 3.074201395988954e-07, 9.543600523147612e-08, 2.840932970177627e-08, 8.120973914172769e-09, 2.232277354742595e-09, 5.908029274098870e-10,
3.736920777270594e-02, 3.457629239375851e-02, 2.961667584585425e-02, 2.350877526152598e-02, 1.731761554460748e-02, 1.186015494004112e-02, 7.567114472824786e-03, 4.507951042677726e-03, 2.513357698522400e-03, 1.314596717200835e-03, 6.465910597469230e-04, 2.997676996608220e-04, 1.312953129458087e-04, 5.444760820751739e-05, 2.142345781853135e-05, 8.014104714437528e-06, 2.855651678952604e-06, 9.710176138817788e-07, 3.156205514591607e-07, 9.822535648350146e-08, 2.931345857003100e-08, 8.400857128398954e-09, 2.315188276970087e-09, 6.143494704278026e-10,
3.725782414298787e-02, 3.448153322340651e-02, 2.954958273686125e-02, 2.347200165229575e-02, 1.730636279900205e-02, 1.186564806131075e-02, 7.580421765140781e-03, 4.522467513856938e-03, 2.525502785419909e-03, 1.323246399688647e-03, 6.520540824330011e-04, 3.028935136161420e-04, 1.329370322712080e-04, 5.524628509302717e-05, 2.178578804529638e-05, 8.168203624055831e-06, 2.917359405525093e-06, 9.943690203056002e-07, 3.239975790946880e-07, 1.010821032785176e-07, 3.024183931360104e-08, 8.689002543968908e-09, 2.400773040079223e-09, 6.387203678463211e-10,
3.714710252592735e-02, 3.438728807392948e-02, 2.948277383188662e-02, 2.343529185108899e-02, 1.729502918421773e-02, 1.187100784975469e-02, 7.593611179217610e-03, 4.536910871312719e-03, 2.537618380577878e-03, 1.331895086036051e-03, 6.575287346131701e-04, 3.060330186603766e-04, 1.345896982692875e-04, 5.605215263272511e-05, 2.215224499413305e-05, 8.324433105989695e-06, 2.980073650471780e-06, 1.018160411668100e-06, 3.325540064611170e-07, 1.040074964332314e-07, 3.119499004982245e-08, 8.985609951602796e-09, 2.489103874568348e-09, 6.639402372212471e-10,
3.703703703696740e-02, 3.429355281214610e-02, 2.941624752315718e-02, 2.339864632208788e-02, 1.728361609688939e-02, 1.187623559082828e-02, 7.606683393251519e-03, 4.551281212141638e-03, 2.549704268649696e-03, 1.340542503471651e-03, 6.630148193192248e-04, 3.091861178639677e-04, 1.362532851806132e-04, 5.686521938135068e-05, 2.252284641791179e-05, 8.482808557688296e-06, 3.043804544701633e-06, 1.042397448417635e-06, 3.412926413966533e-07, 1.070028016268076e-07, 3.217343669698676e-08, 9.290882769292286e-09, 2.580254542944648e-09, 6.900342928101224e-10,
3.692762186108808e-02, 3.420032334858045e-02, 2.935000221221500e-02, 2.336206551541391e-02, 1.727212491473365e-02, 1.188133255879627e-02, 7.619639084101524e-03, 4.565578637576194e-03, 2.561760238928487e-03, 1.349188381905272e-03, 6.685121402430980e-04, 3.123527138768333e-04, 1.379277665970738e-04, 5.768549342433359e-05, 2.289760984249425e-05, 8.643345312639817e-06, 3.108562228621711e-06, 1.067085818953220e-06, 3.502163155225440e-07, 1.100692994307589e-07, 3.317771302626626e-08, 9.605028080912800e-09, 2.674300361624415e-09, 7.170283561640024e-10,
3.681885125178197e-02, 3.410759563689388e-02, 2.928403630990557e-02, 2.332554986741465e-02, 1.726055699680523e-02, 1.188630001680736e-02, 7.632478927226360e-03, 4.579803252894058e-03, 2.573786085296252e-03, 1.357832453922314e-03, 6.740205017525145e-04, 3.155327089441980e-04, 1.396131154699993e-04, 5.851298237939815e-05, 2.327655256545218e-05, 8.806058638741769e-06, 3.174356851093206e-06, 1.092231239178011e-06, 3.593278841395712e-07, 1.132082853367636e-07, 3.420836071293041e-08, 9.928256674749836e-09, 2.771318222927256e-09, 7.449488668170986e-10,
3.671071953004852e-02, 3.401536567332530e-02, 2.921834823636451e-02, 2.328909980094478e-02, 1.724891368374972e-02, 1.189113921696920e-02, 7.645203596623346e-03, 4.593955167328710e-03, 2.585781606173224e-03, 1.366474454777698e-03, 6.795397089062428e-04, 3.187260049222577e-04, 1.413093041182893e-04, 5.934769339823167e-05, 2.365969165483436e-05, 8.970963736690072e-06, 3.241198568388526e-06, 1.117839452048271e-06, 3.686302261205731e-07, 1.164210697823968e-07, 3.526592938683788e-08, 1.026078308193031e-08, 2.871386617160681e-09, 7.738228930734313e-10,
3.660322108340542e-02, 3.392362949614033e-02, 2.915293642100268e-02, 2.325271572564156e-02, 1.723719629805312e-02, 1.189585140042354e-02, 7.657813764769168e-03, 4.608034493981433e-03, 2.597746604467447e-03, 1.375114122389441e-03, 6.850695674689567e-04, 3.219325032936800e-04, 1.430163042365527e-04, 6.018963316821755e-05, 2.404704394798206e-05, 9.138075738387419e-06, 3.309097543149704e-06, 1.143916227118001e-06, 3.781262437990406e-07, 1.197089781747729e-07, 3.635097668219262e-08, 1.060282561475108e-08, 2.974585654791709e-09, 8.036781428896620e-10,
3.649635036491754e-02, 3.383238318508851e-02, 2.908779930248939e-02, 2.321639803819457e-02, 1.722540614428779e-02, 1.190043779742156e-02, 7.670310102562438e-03, 4.622041349734580e-03, 2.609680887524576e-03, 1.383751197331820e-03, 6.906098839257004e-04, 3.251521051829368e-04, 1.447340869032518e-04, 6.103880791422901e-05, 2.443862605039165e-05, 9.307409705370771e-06, 3.378063943348289e-06, 1.170467360079272e-06, 3.878188628537964e-07, 1.230733509120845e-07, 3.746406828654857e-08, 1.095460640489538e-08, 3.080997088701744e-09, 8.345429748531526e-10,
3.639010189224301e-02, 3.374162286086890e-02, 2.902293532873450e-02, 2.318014712261035e-02, 1.721354450935512e-02, 1.190489962739956e-02, 7.682693279268141e-03, 4.635975855166241e-03, 2.621584267077919e-03, 1.392385422828205e-03, 6.961604654959765e-04, 3.283847113714719e-04, 1.464626225888542e-04, 6.189522340048538e-05, 2.483445433462535e-05, 9.478980627258635e-06, 3.448107941247049e-06, 1.197498672298468e-06, 3.977110321898162e-07, 1.265155434030385e-07, 3.860577798905199e-08, 1.131635144152955e-08, 3.190704336521352e-09, 8.664464092543794e-10,
3.628447024669545e-02, 3.365134468460388e-02, 2.895834295686877e-02, 2.314396335047153e-02, 1.720161266272503e-02, 1.190923809905459e-02, 7.694963962463745e-03, 4.649838134466145e-03, 2.633456559198713e-03, 1.401016544743497e-03, 7.017211201474464e-04, 3.316302223127001e-04, 1.482018811639848e-04, 6.275888493246632e-05, 2.523454493926847e-05, 9.652803420217721e-06, 3.519239712363578e-06, 1.225016010348479e-06, 4.078057238151922e-07, 1.300369260841743e-07, 3.977668772790655e-08, 1.168829060927083e-08, 3.303792503041112e-09, 8.994181392526841e-10,
3.617945007232306e-02, 3.356154485732074e-02, 2.889402065322304e-02, 2.310784708119085e-02, 1.718961185667196e-02, 1.191345441042039e-02, 7.707122817987133e-03, 4.663628315352892e-03, 2.645297584246656e-03, 1.409644311576252e-03, 7.072916566092624e-04, 3.348885381468369e-04, 1.499518319075796e-04, 6.362979735888538e-05, 2.563891376793385e-05, 9.828892925449623e-06, 3.591469434436128e-06, 1.253025245537019e-06, 4.181059327142972e-07, 1.336388844350657e-07, 4.097738763704964e-08, 1.207065772601818e-08, 3.420348402694973e-09, 9.334885421343944e-10,
3.607503607500306e-02, 3.347221961944113e-02, 2.882996689330585e-02, 2.307179866226010e-02, 1.717754332650782e-02, 1.191754974894334e-02, 7.719170509886116e-03, 4.677346528992435e-03, 2.657107166820703e-03, 1.418268474450449e-03, 7.128718843850237e-04, 3.381595587155646e-04, 1.517124435150389e-04, 6.450796507371950e-05, 2.604757648831258e-05, 1.000726390769747e-05, 3.664807286391843e-06, 1.281532273431170e-06, 4.286146767171692e-07, 1.373228189913966e-07, 4.220847609202728e-08, 1.246369058063767e-08, 3.540460582112417e-09, 9.686886906622886e-10,
3.597122302155237e-02, 3.338336525027844e-02, 2.876618016178005e-02, 2.303581842949423e-02, 1.716540829081173e-02, 1.192152529155858e-02, 7.731107700369682e-03, 4.690992909917869e-03, 2.668885135710112e-03, 1.426888787106941e-03, 7.184616137653716e-04, 3.414431835765234e-04, 1.534836841063754e-04, 6.539339201829451e-05, 2.646054853127084e-05, 1.018793105377257e-05, 3.739263447317606e-06, 1.310543013378259e-06, 4.393349963651539e-07, 1.410901453559072e-07, 4.347055975505472e-08, 1.286763097049386e-08, 3.664219342735592e-09, 1.005050364515318e-09,
3.586800573885297e-02, 3.329497806754212e-02, 2.870265895243788e-02, 2.299990670727026e-02, 1.715320795165653e-02, 1.192538220476604e-02, 7.742935049760798e-03, 4.704567595950382e-03, 2.680631323845752e-03, 1.435505005894585e-03, 7.240606558402206e-04, 3.447393120176397e-04, 1.552655212343583e-04, 6.628608168342446e-05, 2.687784508999245e-05, 1.037090897110157e-05, 3.814848095433708e-06, 1.340063408023213e-06, 4.502699547728415e-07, 1.449422942072062e-07, 4.476425361925169e-08, 1.328272473881884e-08, 3.791716763497737e-09, 1.042606061817529e-09,
3.576537911299288e-02, 3.320705442685030e-02, 2.863940176817521e-02, 2.296406380876187e-02, 1.714094349483235e-02, 1.192912164470671e-02, 7.754653216450818e-03, 4.718070728121550e-03, 2.692345568251730e-03, 1.444116889761077e-03, 7.296688225106364e-04, 3.480478430712798e-04, 1.570579218926507e-04, 6.718603711160387e-05, 2.729948111916677e-05, 1.055621218629372e-05, 3.891571407070539e-06, 1.370099422822490e-06, 4.614226374863322e-07, 1.488807113064465e-07, 4.609018105203931e-08, 1.370922181191058e-08, 3.923046723558988e-09, 1.081389010755031e-09,
3.566333808842139e-02, 3.311959072124899e-02, 2.857640712096440e-02, 2.292829003616895e-02, 1.712861609006692e-02, 1.193274475723870e-02, 7.766262856855386e-03, 4.731502450596756e-03, 2.704027709997232e-03, 1.452724200243479e-03, 7.352859265003638e-04, 3.513686755282397e-04, 1.588608525239364e-04, 6.809326089925180e-05, 2.772547133422175e-05, 1.074385514372891e-05, 3.969443555648547e-06, 1.400657045554733e-06, 4.727961523378720e-07, 1.529068575018607e-07, 4.744897383768859e-08, 1.414737623615234e-08, 4.058304925095815e-09, 1.121433181279892e-09,
3.556187766711905e-02, 3.303258338073882e-02, 2.851367353182626e-02, 2.289258568094285e-02, 1.711622689124304e-02, 1.193625267801345e-02, 7.777764625371913e-03, 4.744862910599873e-03, 2.715677594148716e-03, 1.461326701458467e-03, 7.409117813670049e-04, 3.547017079515605e-04, 1.606742790280369e-04, 6.900775519900533e-05, 2.815583021060130e-05, 1.093385220416620e-05, 4.048474710661580e-06, 1.431742285828217e-06, 4.843936292968844e-07, 1.570222087311527e-07, 4.884127221900715e-08, 1.459744621484444e-08, 4.197588916140057e-09, 1.162773296899730e-09,
3.546099290778136e-02, 3.294602887180864e-02, 2.845119953080078e-02, 2.285695102400694e-02, 1.710377703661294e-02, 1.193964653255186e-02, 7.789159174338436e-03, 4.758152258339117e-03, 2.727295069722353e-03, 1.469924160092308e-03, 7.465462015128592e-04, 3.580468386901775e-04, 1.624981667700165e-04, 6.992952172206311e-05, 2.859057198308715e-05, 1.112621764337316e-05, 4.128675036663907e-06, 1.463361174585285e-06, 4.962182203174560e-07, 1.612282560217471e-07, 5.026772493815556e-08, 1.505969414484076e-08, 4.340998113463860e-09, 1.205444846551854e-09,
3.536067892501690e-02, 3.285992369697630e-02, 2.838898365691727e-02, 2.282138633597301e-02, 1.709126764900984e-02, 1.194292743632035e-02, 7.800447153993999e-03, 4.771370646934071e-03, 2.738879989636777e-03, 1.478516345390562e-03, 7.521890021954287e-04, 3.614039658923999e-04, 1.643324805882719e-04, 7.085856174057556e-05, 2.902971064516436e-05, 1.132096565077591e-05, 4.210054692261015e-06, 1.495519763603804e-06, 5.082730991822932e-07, 1.655265054888920e-07, 5.172898927658001e-08, 1.553438665298098e-08, 4.488633825506306e-09, 1.249484096560627e-09,
3.526093088855844e-02, 3.277426439433587e-02, 2.832702445816298e-02, 2.278589187735316e-02, 1.707869983605635e-02, 1.194609649480681e-02, 7.811629212440340e-03, 4.784518232343879e-03, 2.750432210666140e-03, 1.487103029147520e-03, 7.578399995375864e-04, 3.647729875192182e-04, 1.661771848026060e-04, 7.179487609008199e-05, 2.947325994843017e-05, 1.151811032813029e-05, 4.292623829104438e-06, 1.528224124995836e-06, 5.205614613432066e-07, 1.699184783316156e-07, 5.322573109405222e-08, 1.602179463231087e-08, 4.640599275338010e-09, 1.294928102676854e-09,
3.516174402248786e-02, 3.268904753711219e-02, 2.826532049145156e-02, 2.275046789876774e-02, 1.706607469037038e-02, 1.194915480359661e-02, 7.822705995605077e-03, 4.797595173296605e-03, 2.761951593393466e-03, 1.495683985695416e-03, 7.634990105374248e-04, 3.681538013574466e-04, 1.680322432222860e-04, 7.273846517199289e-05, 2.992123340204616e-05, 1.171766568821385e-05, 4.376392590890778e-06, 1.561480350703597e-06, 5.330865237581557e-07, 1.744057108265384e-07, 5.475862486680597e-08, 1.652219327808238e-08, 4.796999623659512e-09, 1.341814722197845e-09,
3.506311360447367e-02, 3.260426973322104e-02, 2.820387032258986e-02, 2.271511464114885e-02, 1.705339328976785e-02, 1.195210344844825e-02, 7.833678147206079e-03, 4.810601631219702e-03, 2.773438002164320e-03, 1.504258991893373e-03, 7.691658530777763e-04, 3.715463050326924e-04, 1.698976191540792e-04, 7.368932895611596e-05, 3.037364427223264e-05, 1.191964565353906e-05, 4.461371112365122e-06, 1.595294551992843e-06, 5.458515247249006e-07, 1.789897543195387e-07, 5.632835372475979e-08, 1.703586212352523e-08, 4.957941991829567e-09, 1.390182626166841e-09,
3.496503496502171e-02, 3.251992762483692e-02, 2.814267252624472e-02, 2.267983233594017e-02, 1.704065669746281e-02, 1.195494350536917e-02, 7.844546308717306e-03, 4.823537770171617e-03, 2.784891305040782e-03, 1.512827827116139e-03, 7.748403459354237e-04, 3.749503960221599e-04, 1.717732754102711e-04, 7.464746698322441e-05, 3.083050558180541e-05, 1.212406405508753e-05, 4.547569518328953e-06, 1.629672858943788e-06, 5.588597237112903e-07, 1.836721752152740e-07, 5.793560948781598e-08, 1.756308507538197e-08, 5.123535484919132e-09, 1.440071311650427e-09,
3.486750348673814e-02, 3.243601788796632e-02, 2.808172568590837e-02, 2.264462120529256e-02, 1.702786596226486e-02, 1.195767604069118e-02, 7.855311119335776e-03, 4.836403756774503e-03, 2.796311373755752e-03, 1.521390273242580e-03, 7.805223087899881e-04, 3.783659716672837e-04, 1.736591743166598e-04, 7.561287836766759e-05, 3.129183010975423e-05, 1.233093463106559e-05, 4.634997922652892e-06, 1.664621419939685e-06, 5.721144011822507e-07, 1.884545549645611e-07, 5.958109270122675e-08, 1.810415044919870e-08, 5.293891214787152e-09, 1.491521114092564e-09,
3.477051460360489e-02, 3.235253723202759e-02, 2.802102839386339e-02, 2.260948146225591e-02, 1.701502211877360e-02, 1.196030211114587e-02, 7.865973215949913e-03, 4.849199760148032e-03, 2.807698083667542e-03, 1.529946114643980e-03, 7.862115622325210e-04, 3.817929291861946e-04, 1.755552777205269e-04, 7.658556180002123e-05, 3.175763039086248e-05, 1.254027102568102e-05, 4.723666427294248e-06, 1.700146401153183e-06, 5.856188584234944e-07, 1.933384900496153e-07, 6.126551267001773e-08, 1.865935100436311e-08, 5.469122323173904e-09, 1.544573219743791e-09,
3.467406380026703e-02, 3.226948239943703e-02, 2.796057925114699e-02, 2.257441331096721e-02, 1.700212618757066e-02, 1.196282276393974e-02, 7.876533233109004e-03, 4.861925951844251e-03, 2.819051313714841e-03, 1.538495138172108e-03, 7.919079277737827e-04, 3.852311656860164e-04, 1.774615469985832e-04, 7.756551554977649e-05, 3.222791871536780e-05, 1.275208678794109e-05, 4.813585121319688e-06, 1.736253986030564e-06, 5.993764173620105e-07, 1.983255919671519e-07, 6.298958749245968e-08, 1.922898397888230e-08, 5.649344004807888e-09, 1.599269678164197e-09,
3.457814661133210e-02, 3.218685016520096e-02, 2.790037686751448e-02, 2.253941694683494e-02, 1.698917917540904e-02, 1.196523903682931e-02, 7.886991802993936e-03, 4.874582505783584e-03, 2.830370946371958e-03, 1.547037133147119e-03, 7.976112278522313e-04, 3.886805781749985e-04, 1.793779430648888e-04, 7.855273746806755e-05, 3.270270712866311e-05, 1.296639537047209e-05, 4.904764079933165e-06, 1.772950374774000e-06, 6.133904203833719e-07, 2.034174872093550e-07, 6.475404409258032e-08, 1.981335112389215e-08, 5.834673530522046e-09, 1.655653414798634e-09,
3.448275862068088e-02, 3.210463733651354e-02, 2.784041986140223e-02, 2.250449255671967e-02, 1.697618207539963e-02, 1.196755195819576e-02, 7.897349555389040e-03, 4.887169598191796e-03, 2.841656867604425e-03, 1.555571891345230e-03, 8.033212858417094e-04, 3.921410635744777e-04, 1.813044263787447e-04, 7.954722499043526e-05, 3.318200743103759e-05, 1.318321012836007e-05, 4.997213363509180e-06, 1.810241783821927e-06, 6.276642301459073e-07, 2.086158172427156e-07, 6.655961825170637e-08, 2.041275873789072e-08, 6.025230270375239e-09, 1.713768243622734e-09,
3.438789546078974e-02, 3.202284075236093e-02, 2.778070685988996e-02, 2.246964031911129e-02, 1.696313586719539e-02, 1.196976254711964e-02, 7.907607117655088e-03, 4.899687407538055e-03, 2.852908966824908e-03, 1.564099206986236e-03, 8.090379260588495e-04, 3.956125187306754e-04, 1.832409569525541e-04, 8.054897513962629e-05, 3.366583117745715e-05, 1.340254431801299e-05, 5.090943016631658e-06, 1.848134445327651e-06, 6.422012293917807e-07, 2.139222384847438e-07, 6.840705463902864e-08, 2.102751770068774e-08, 6.221135716774718e-09, 1.773658879858132e-09,
3.429355281206389e-02, 3.194145728313063e-02, 2.772123649866253e-02, 2.243486040430259e-02, 1.695004151717295e-02, 1.197187181345510e-02, 7.917765114703398e-03, 4.912136114474009e-03, 2.864127136849479e-03, 1.572618876720844e-03, 8.147609737701902e-04, 3.990948404263298e-04, 1.851874943596567e-04, 8.155798452842717e-05, 3.415418967738410e-05, 1.362441109604452e-05, 5.185963067138529e-06, 1.886634606636326e-06, 6.570048207550315e-07, 2.193384222785622e-07, 7.029710684118208e-08, 2.165794350706260e-08, 6.422513507595519e-09, 1.835370952755427e-09,
3.419972640218195e-02, 3.186048383022697e-02, 2.766200742197122e-02, 2.240015297455965e-02, 1.693689997861160e-02, 1.197388075790408e-02, 7.927824168971040e-03, 4.924515901773879e-03, 2.875311273854201e-03, 1.581130699617832e-03, 8.204902551990149e-04, 4.025879253921606e-04, 1.871439977421274e-04, 8.257424936253088e-05, 3.464709399463528e-05, 1.384882351817906e-05, 5.282283525172158e-06, 1.925748529760372e-06, 6.720784265666145e-07, 2.248660548653832e-07, 7.223053739083165e-08, 2.230435630012330e-08, 6.629489449292505e-09, 1.898951018443229e-09,
3.410641200545073e-02, 3.177991732569180e-02, 2.760301828259431e-02, 2.236551818428856e-02, 1.692371219186988e-02, 1.197579037209013e-02, 7.937784900397066e-03, 4.936826954275541e-03, 2.886461277332054e-03, 1.589634477151057e-03, 8.262255975319103e-04, 4.060916703181711e-04, 1.891104258185447e-04, 8.359776544343567e-05, 3.514455494727841e-05, 1.407579453817823e-05, 5.379914382235773e-06, 1.965482490853497e-06, 6.874254886564801e-07, 2.305068373548763e-07, 7.420811779425827e-08, 2.296708090435849e-08, 6.842191540000798e-09, 1.964446572841716e-09,
3.401360544217107e-02, 3.169975473183089e-02, 2.754426774179743e-02, 2.233095618019912e-02, 1.691047908455974e-02, 1.197760163863193e-02, 7.947647926399791e-03, 4.949069458822592e-03, 2.897577050050206e-03, 1.598130013186298e-03, 8.319668289250596e-04, 4.096059718647838e-04, 1.910867368917243e-04, 8.462852817137506e-05, 3.564658310756606e-05, 1.430533700678892e-05, 5.478865610256097e-06, 2.005842779683397e-06, 7.030494681527680e-07, 2.362624856934365e-07, 7.623062855793645e-08, 2.364644685837544e-08, 7.060749992620539e-09, 2.031906064639100e-09,
3.392130257801365e-02, 3.161999304084569e-02, 2.748575446929337e-02, 2.229646710146529e-02, 1.689720157171829e-02, 1.197931553121667e-02, 7.957413861855089e-03, 4.961243604207430e-03, 2.908658498007636e-03, 1.606617113967957e-03, 8.377137785102690e-04, 4.131307266738158e-04, 1.930728888564176e-04, 8.566653254827726e-05, 3.615318880190693e-05, 1.453746367071272e-05, 5.579147160652224e-06, 2.046835699103263e-06, 7.189538452781260e-07, 2.421347306303536e-07, 7.829885921409673e-08, 2.434278844731653e-08, 7.285297257881594e-09, 2.101378908329306e-09,
3.382949932340510e-02, 3.154062927447007e-02, 2.742747714320144e-02, 2.226205107988230e-02, 1.688388055597708e-02, 1.198093301467299e-02, 7.967083319075656e-03, 4.973349581115242e-03, 2.919705530393068e-03, 1.615095588105623e-03, 8.434662764007249e-04, 4.166658313792886e-04, 1.950688392069737e-04, 8.671177318075392e-05, 3.666438211087385e-05, 1.477218717159681e-05, 5.680768963410987e-06, 2.088467564522209e-06, 7.351421191432378e-07, 2.481253176818977e-07, 8.041360834526676e-08, 2.505644473494666e-08, 7.515968047384035e-09, 2.172915497309209e-09,
3.373819163292396e-02, 3.146166048361291e-02, 2.736943445000636e-02, 2.222770824002099e-02, 1.687051692772923e-02, 1.198245504504374e-02, 7.976656907791225e-03, 4.985387582068971e-03, 2.930718059543279e-03, 1.623565246560487e-03, 8.492241536965005e-04, 4.202111826180766e-04, 1.970745450449649e-04, 8.776424428311569e-05, 3.718017286924790e-05, 1.500952004504620e-05, 5.783740926168824e-06, 2.130744703374717e-06, 7.516178075375755e-07, 2.542360070933209e-07, 8.257568360778343e-08, 2.578775959540440e-08, 7.752899356610075e-09, 2.246567217033730e-09,
3.364737550470646e-02, 3.138308374800507e-02, 2.731162508451702e-02, 2.219343869937888e-02, 1.685711156529411e-02, 1.198388256965836e-02, 7.986135235129780e-03, 4.997357801375238e-03, 2.941696000901748e-03, 1.632025902631651e-03, 8.549872424898108e-04, 4.237666770403972e-04, 1.990899630867731e-04, 8.882393968041559e-05, 3.770057066609878e-05, 1.524947471965752e-05, 5.888072933300445e-06, 2.173673454589234e-06, 7.683844467174581e-07, 2.604685737987933e-07, 8.478590175427219e-08, 2.653708174461022e-08, 7.996230487903408e-09, 2.322386458227082e-09,
3.355704697986196e-02, 3.130489617585202e-02, 2.725404774982462e-02, 2.215924256852834e-02, 1.684366533507976e-02, 1.198521652720499e-02, 7.995518905599576e-03, 5.009260435071127e-03, 2.952639272977627e-03, 1.640477371942292e-03, 8.607553758700055e-04, 4.273322113201361e-04, 2.011150496711375e-04, 8.989085281151639e-05, 3.822558484489969e-05, 1.549206351607399e-05, 5.993774845014191e-06, 2.217260168055976e-06, 7.854455911914296e-07, 2.668248073792708e-07, 8.704508865508328e-08, 2.730476477132353e-08, 8.246103073411334e-09, 2.400426630148360e-09,
3.346720214189743e-02, 3.122709490349100e-02, 2.719670115726067e-02, 2.212511995126185e-02, 1.683017909174307e-02, 1.198645784780217e-02, 8.004808521072116e-03, 5.021095680871954e-03, 2.963547797305094e-03, 1.648919472425726e-03, 8.665283879283334e-04, 4.309076821650169e-04, 2.031497607666609e-04, 9.096497673218388e-05, 3.875522450367802e-05, 1.573729864606190e-05, 6.100856496454498e-06, 2.261511204094134e-06, 8.028048135030463e-07, 2.733065120183169e-07, 8.935407931868487e-08, 2.809116716784289e-08, 8.502661097985780e-09, 2.480742173909800e-09,
3.337783711615164e-02, 3.114967709505322e-02, 2.713958402635458e-02, 2.209107094473459e-02, 1.681665367834778e-02, 1.198760745307038e-02, 8.014004680766048e-03, 5.032863738119868e-03, 2.974421498403028e-03, 1.657352024311358e-03, 8.723061137624541e-04, 4.344929863266088e-04, 2.051940519792768e-04, 9.204630411820278e-05, 3.928949849519954e-05, 1.598519221160825e-05, 6.209327696811291e-06, 2.306432932918490e-06, 8.204657040110797e-07, 2.799155064558757e-07, 9.171371791100259e-08, 2.889665236034135e-08, 8.766050922038725e-09, 2.563388575845839e-09,
3.328894806923802e-02, 3.107263994213095e-02, 2.708269508479108e-02, 2.205709563960396e-02, 1.680308992652027e-02, 1.198866625620300e-02, 8.023107981231783e-03, 5.044564807733407e-03, 2.985260303735041e-03, 1.665774850110522e-03, 8.780883894807203e-04, 4.380880206101802e-04, 2.072478785596720e-04, 9.313482726851565e-05, 3.982841542718717e-05, 1.623575620403976e-05, 6.319198228436677e-06, 2.352031734105632e-06, 8.384318706672297e-07, 2.866536239400195e-07, 9.412485777370372e-08, 2.972158873883082e-08, 9.036421304347828e-09, 2.648422380931202e-09,
3.320053120849659e-02, 3.099598066344918e-02, 2.702603306836725e-02, 2.202319412016657e-02, 1.678948865660324e-02, 1.198963516203714e-02, 8.032119016337071e-03, 5.056199092157866e-03, 2.996064143669869e-03, 1.674187774602237e-03, 8.838750522062243e-04, 4.416926818843938e-04, 2.093111954106691e-04, 9.423053810838268e-05, 4.037198366257268e-05, 1.648900250316299e-05, 6.430477845968902e-06, 2.398313996059822e-06, 8.567069387913592e-07, 2.935227121766688e-07, 9.658836144141960e-08, 3.056634968674815e-08, 9.313923424807994e-09, 2.735901206246189e-09,
3.311258278145443e-02, 3.091969650454199e-02, 2.696959672094938e-02, 2.198936646449252e-02, 1.677585067780716e-02, 1.199051506712400e-02, 8.041038377253252e-03, 5.067766795316571e-03, 3.006832951442088e-03, 1.682590624818853e-03, 8.896659400806164e-04, 4.453068670908443e-04, 2.113839570945622e-04, 9.533342819256251e-05, 4.092021131978154e-05, 1.674494287642578e-05, 6.543176275463695e-06, 2.445286115478640e-06, 8.752945508443275e-07, 3.005246332773083e-07, 9.910510065790209e-08, 3.143131361015674e-08, 9.598710907124632e-09, 2.825883754487297e-09,
3.302509907529487e-02, 3.084378473743330e-02, 2.691338479442964e-02, 2.195561274455695e-02, 1.676217678835970e-02, 1.199130685979887e-02, 8.049866652442429e-03, 5.079268122562965e-03, 3.017566663113203e-03, 1.690983230031627e-03, 8.954608922677003e-04, 4.489304732534423e-04, 2.134661178404097e-04, 9.644348870851215e-05, 4.147310627304992e-05, 1.700358897809947e-05, 6.657303213533155e-06, 2.492954496818494e-06, 8.941983661984556e-07, 3.076612637046982e-07, 1.016759563911089e-07, 3.231686396655635e-08, 9.890939841444240e-09, 2.918429827521287e-09,
3.293807641633515e-02, 3.076824266032263e-02, 2.685739604868245e-02, 2.192193302636927e-02, 1.674846777565315e-02, 1.199201142025079e-02, 8.058604427645322e-03, 5.090703280633589e-03, 3.028265217533080e-03, 1.699365421736198e-03, 9.012597489568097e-04, 4.525633974876477e-04, 2.155576315512828e-04, 9.756071047960593e-05, 4.203067615277425e-05, 1.726495234848257e-05, 6.772868326492317e-06, 2.541325551760140e-06, 9.134220609056971e-07, 3.149344942166085e-07, 1.043018188472166e-07, 3.322338929329600e-08, 1.019076880691830e-08, 3.013600339980882e-09,
3.285151116951183e-02, 3.069306759727454e-02, 2.680162925152080e-02, 2.188832737009952e-02, 1.673472441638961e-02, 1.199262962059186e-02, 8.067252285869870e-03, 5.102072477601819e-03, 3.038928556301718e-03, 1.707737033638008e-03, 9.070623513659635e-04, 4.562055370095424e-04, 2.176584518114649e-04, 9.868508396837141e-05, 4.259292834589139e-05, 1.752904441312496e-05, 6.889881249513337e-06, 2.590405698674231e-06, 9.329693274635289e-07, 3.223462298075700e-07, 1.069835874835527e-07, 3.415128323558165e-08, 1.049835889419586e-08, 3.111457332900074e-09,
3.276539973787501e-02, 3.061825689791304e-02, 2.674608317865225e-02, 2.185479583020260e-02, 1.672094747672443e-02, 1.199316232492606e-02, 8.075810807380616e-03, 5.113375922832484e-03, 3.049556623731383e-03, 1.716097901637630e-03, 9.128685417448183e-04, 4.598567891447602e-04, 2.197685318936068e-04, 9.981659927974240e-05, 4.315986999629063e-05, 1.779587648207342e-05, 7.008351585787607e-06, 2.640201362087103e-06, 9.528438745786597e-07, 3.298983896486743e-07, 1.097221710204487e-07, 3.510094457407426e-08, 1.081387372784097e-08, 3.212063987387233e-09,
3.267973856208984e-02, 3.054380793712002e-02, 2.669075661363493e-02, 2.182133845553996e-02, 1.670713771240749e-02, 1.199361038941789e-02, 8.084280569688752e-03, 5.124613826937254e-03, 3.060149366809089e-03, 1.724447863816043e-03, 9.186781633773999e-04, 4.635170513372591e-04, 2.218878247658340e-04, 1.009552461643277e-04, 4.373150800525550e-05, 1.806545974913757e-05, 7.128288905695723e-06, 2.690718972146786e-06, 9.730494269285649e-07, 3.375929070254193e-07, 1.125184874520058e-07, 3.607277725207048e-08, 1.113747948867041e-08, 3.315484638333971e-09,
3.259452411994630e-02, 3.046971811473775e-02, 2.663564834783331e-02, 2.178795528949875e-02, 1.669329586892253e-02, 1.199397466236036e-02, 8.092662147542869e-03, 5.135786401730806e-03, 3.070706735159421e-03, 1.732786760419846e-03, 9.244910605846440e-04, 4.671862211579469e-04, 2.240162830988044e-04, 1.021010140216948e-04, 4.430784903193605e-05, 1.833780529117682e-05, 7.249702745985475e-06, 2.741964964089431e-06, 9.935897249209299e-07, 3.454317292736277e-07, 1.153734640557747e-07, 3.706719040226107e-08, 1.146934493600762e-08, 3.421784788157884e-09,
3.250975292587634e-02, 3.039598485527604e-02, 2.658075718037387e-02, 2.175464637010899e-02, 1.667942268162466e-02, 1.199425598424281e-02, 8.100956112920428e-03, 5.146893860187832e-03, 3.081228681007718e-03, 1.741114433846401e-03, 9.303070787267272e-04, 4.708641963131584e-04, 2.261538592727192e-04, 1.032538919036667e-04, 4.488889949385036e-05, 1.861292406740791e-05, 7.372602608957954e-06, 2.793945777706182e-06, 1.014468524451036e-06, 3.534168177134427e-07, 1.182880374013435e-07, 3.808459837306024e-08, 1.180964142984867e-08, 3.531031120577131e-09,
3.242542153047859e-02, 3.032260560762267e-02, 2.652608191810064e-02, 2.172141173015814e-02, 1.666551887587580e-02, 1.199445518781817e-02, 8.109163035019776e-03, 5.157936416400723e-03, 3.091715159143582e-03, 1.749430728628938e-03, 9.361260642052020e-04, 4.745508746529816e-04, 2.283005053842828e-04, 1.044138685176332e-04, 4.547466556741528e-05, 1.889082691873284e-05, 7.496997961661827e-06, 2.846667856810633e-06, 1.035689596657147e-06, 3.615501475814212e-07, 1.212631533578323e-07, 3.912542075450005e-08, 1.215854295293584e-08, 3.643291514414888e-09,
3.234152652005055e-02, 3.024957784475862e-02, 2.647162137553076e-02, 2.168825139730365e-02, 1.665158516717853e-02, 1.199457309816996e-02, 8.117283480252946e-03, 5.168914285538121e-03, 3.102166126884779e-03, 1.757735491421610e-03, 9.419478644649468e-04, 4.782461541794436e-04, 2.304561732536142e-04, 1.055809322298732e-04, 4.606515318850572e-05, 1.917152456708759e-05, 7.622898235095902e-06, 2.900137648706949e-06, 1.057256727673957e-06, 3.698337079607392e-07, 1.242997671002940e-07, 4.019008240368514e-08, 1.251622613273507e-08, 3.758635057431711e-09,
3.225806451612794e-02, 3.017689906347673e-02, 2.641737437480985e-02, 2.165516539418323e-02, 1.663762226130774e-02, 1.199461053277873e-02, 8.125318012238956e-03, 5.179827683804118e-03, 3.112581544041424e-03, 1.766028570984494e-03, 9.477723279959140e-04, 4.819499330545443e-04, 2.326208144311063e-04, 1.067550710688890e-04, 4.666036805304173e-05, 1.945502761481088e-05, 7.750312823419953e-06, 2.954361603658722e-06, 1.079173718384126e-06, 3.782695017095182e-07, 1.273988431150154e-07, 4.127901346979996e-08, 1.288287026331229e-08, 3.877132060183636e-09,
3.217503217503116e-02, 3.010456678410455e-02, 2.636333974566735e-02, 2.162215373852305e-02, 1.662363085444075e-02, 1.199456830158825e-02, 8.133267191797839e-03, 5.190676828398287e-03, 3.122961372880576e-03, 1.774309818168568e-03, 9.535993043347074e-04, 4.856621096081528e-04, 2.347943802042363e-04, 1.079362727287508e-04, 4.726031561760370e-05, 1.974134654403342e-05, 7.879251083174090e-06, 3.009346174358708e-06, 1.101444384167990e-06, 3.868595453873009e-07, 1.305613552037218e-07, 4.239264941866550e-08, 1.325865732710556e-08, 3.998854069904220e-09,
3.209242618741884e-02, 3.003257855023081e-02, 2.630951632537182e-02, 2.158921644324370e-02, 1.660961163328543e-02, 1.199444720707111e-02, 8.141131576945113e-03, 5.201461937476335e-03, 3.133305578091134e-03, 1.782579085900642e-03, 9.594286440659605e-04, 4.893825823457532e-04, 2.369768216043218e-04, 1.091245245724511e-04, 4.786500110007411e-05, 2.003049171608719e-05, 8.009722332506509e-06, 3.065097815399470e-06, 1.124072554651469e-06, 3.956058691796775e-07, 1.337882864866791e-07, 4.353143105683771e-08, 1.364377201658781e-08, 4.123873884408201e-09,
3.201024327784804e-02, 2.996093192843568e-02, 2.625590295868627e-02, 2.155635351656428e-02, 1.659556527520675e-02, 1.199424804429407e-02, 8.148911722886971e-03, 5.212183230111576e-03, 3.143614126749094e-03, 1.790836229168260e-03, 9.652601988235532e-04, 4.931112499560559e-04, 2.391680894132281e-04, 1.103198136352681e-04, 4.847442948030632e-05, 2.032247337093493e-05, 8.141735850409860e-06, 3.121622982745085e-06, 1.147062073452237e-06, 4.045105168210920e-07, 1.370806294046962e-07, 4.469580455524409e-08, 1.403840175581685e-08, 4.252265566014968e-09,
3.192848020434149e-02, 2.988962450802498e-02, 2.620249849782328e-02, 2.152356496210438e-02, 1.658149244835134e-02, 1.199397160098292e-02, 8.156608182015948e-03, 5.222840926257039e-03, 3.153886988283150e-03, 1.799081105004577e-03, 9.710938212916450e-04, 4.968480113184626e-04, 2.413681341700202e-04, 1.115221266281365e-04, 4.908860550081929e-05, 2.061730162661931e-05, 8.275300875966212e-06, 3.178928133203935e-06, 1.170416797924207e-06, 4.135755455158338e-07, 1.404393857200228e-07, 4.588622147235129e-08, 1.444273672186788e-08, 4.384104455489532e-09,
3.184713375796104e-02, 2.981865390076755e-02, 2.614930180240037e-02, 2.149085077898399e-02, 1.656739381177057e-02, 1.199361865758684e-02, 8.164221503907164e-03, 5.233435246708298e-03, 3.164124134440635e-03, 1.807313572473215e-03, 9.769293652055354e-04, 5.005927655103972e-04, 2.435769061775646e-04, 1.127314499410270e-04, 4.970753366751811e-05, 2.091498647873234e-05, 8.410426607600748e-06, 3.237019723902736e-06, 1.194140598900384e-06, 4.228030258572442e-07, 1.438655665161468e-07, 4.710313877686102e-08, 1.485696986614514e-08, 4.519467185999145e-09,
3.176620076238813e-02, 2.974801774063675e-02, 2.609631173939511e-02, 2.145821096192166e-02, 1.655327001554176e-02, 1.199318998734250e-02, 8.171752235315110e-03, 5.243966413066994e-03, 3.174325539253810e-03, 1.815533492653094e-03, 9.827666853523607e-04, 5.043454118144921e-04, 2.457943555090748e-04, 1.139477696463302e-04, 5.033121825043964e-05, 2.121553779990396e-05, 8.547122202344153e-06, 3.295904211761825e-06, 1.218237360434124e-06, 4.321950417451397e-07, 1.473601921964844e-07, 4.834701886992622e-08, 1.528129693556775e-08, 4.658431697083198e-09,
3.168567807351017e-02, 2.967771368355512e-02, 2.604352718310043e-02, 2.142564550133065e-02, 1.653912170088786e-02, 1.199268635633757e-02, 8.179200920170918e-03, 5.254434647705000e-03, 3.184491179006470e-03, 1.823740728623251e-03, 9.886056375716301e-04, 5.081058497256445e-04, 2.480204320146069e-04, 1.151710715022490e-04, 5.095966328452299e-05, 2.151896533931076e-05, 8.685396775103864e-06, 3.355588052971870e-06, 1.242710979538881e-06, 4.417536903014879e-07, 1.509242924819713e-07, 4.961832960688554e-08, 1.571591649362666e-08, 4.801077248634611e-09,
3.160556257901333e-02, 2.960773940714259e-02, 2.599094701507985e-02, 2.139315438341317e-02, 1.652494950029525e-02, 1.199210852357390e-02, 8.186568099580143e-03, 5.264840173729287e-03, 3.194621032200918e-03, 1.831935145447641e-03, 9.944460787555840e-04, 5.118739789579275e-04, 2.502550853274974e-04, 1.164013409561933e-04, 5.159287257040394e-05, 2.182527872220369e-05, 8.825259397944108e-06, 3.416077702471983e-06, 1.267565365926449e-06, 4.514810817843343e-07, 1.545589064075453e-07, 5.091754431850883e-08, 1.616102994130768e-08, 4.947484434890251e-09,
3.152585119798183e-02, 2.953809261046826e-02, 2.593857012412275e-02, 2.136073759025302e-02, 1.651075403763026e-02, 1.199145724103030e-02, 8.193854311821090e-03, 5.275183214947443e-03, 3.204715079525274e-03, 1.840116610159948e-03, 1.000287866849423e-03, 5.156496994513802e-04, 2.524982648707496e-04, 1.176385631481808e-04, 5.223084967523386e-05, 2.213448744945555e-05, 8.966719099374971e-06, 3.477379613429438e-06, 1.292804441743800e-06, 4.613793395000169e-07, 1.582650823175293e-07, 5.224514183175063e-08, 1.661684153787751e-08, 5.097735198428547e-09,
3.144654088050266e-02, 2.946877101380535e-02, 2.588639540619975e-02, 2.132839509990605e-02, 1.649653592825369e-02, 1.199073325372471e-02, 8.201060092343518e-03, 5.285463995833784e-03, 3.214773303821078e-03, 1.848284991748354e-03, 1.006130860851347e-03, 5.194329113786493e-04, 2.547499198633639e-04, 1.188827229142408e-04, 5.287359793352091e-05, 2.244660089712720e-05, 9.109784863650277e-06, 3.539500236720960e-06, 1.318432141308537e-06, 4.714505997136713e-07, 1.620438778599092e-07, 5.360160649000604e-08, 1.708355842152804e-08, 5.251912844171947e-09,
3.136762860727686e-02, 2.939977235838962e-02, 2.583442176441808e-02, 2.129612688648933e-02, 1.648229577913417e-02, 1.198993729977619e-02, 8.208185973767919e-03, 5.295682741496197e-03, 3.224795690051300e-03, 1.856440161140355e-03, 1.011974920812484e-03, 5.232235151515115e-04, 2.570099993266136e-04, 1.201338047898214e-04, 5.352112044799525e-05, 2.276162831605336e-05, 9.254465630074640e-06, 3.602446020415770e-06, 1.344452410843024e-06, 4.816970115580610e-07, 1.658963599795125e-07, 5.498742817286539e-08, 1.756139062987560e-08, 5.410102053392232e-09,
3.128911138923616e-02, 2.933109440618089e-02, 2.578264810897690e-02, 2.126393292026822e-02, 1.646803418895953e-02, 1.198907011046623e-02, 8.215232485885160e-03, 5.305839677643497e-03, 3.234782225268609e-03, 1.864581991187529e-03, 1.017819907836628e-03, 5.270214114272550e-04, 2.592784520902656e-04, 1.213917930131973e-04, 5.417342009049552e-05, 2.307957883144690e-05, 9.400770292319421e-06, 3.666223409260362e-06, 1.370869208207234e-06, 4.921207369407304e-07, 1.698236049100827e-07, 5.640310231536183e-08, 1.805055112031054e-08, 5.572388897716357e-09,
};

// rs, ws = dft.radi.gauss_chebyshev(nrs)
static double rs_gauss_chebyshev2047[] = {
2.109423746787797e-15, 6.672440377997191e-14, 5.055955654142963e-13, 2.130295939650750e-12, 6.500799898390142e-12,
1.617572742418361e-11, 3.496158917926095e-11, 6.816192055225656e-11, 1.228277479725648e-10, 2.080052796671339e-10,
3.349868160640312e-10, 5.175581074823299e-10, 7.722494865802787e-10, 1.118582004799862e-09, 1.579318786859574e-09,
2.180712166399701e-09, 2.952752042872930e-09, 3.929414571501866e-09, 5.148910409147334e-09, 6.653931405864455e-09,
8.491899960993976e-09, 1.071521438245071e-08, 1.338149835383717e-08, 1.655384551657590e-08, 2.030106827088929e-08,
2.469794224690958e-08, 2.982545377339108e-08, 3.577104545904319e-08, 4.262886077466277e-08, 5.049999096673474e-08,
5.949271808525225e-08, 6.972276078709427e-08, 8.131351858509106e-08, 9.439631398766579e-08, 1.091106383022122e-07,
1.256043927755357e-07, 1.440341329539407e-07, 1.645653087134491e-07, 1.873725090639766e-07, 2.126397006252390e-07,
2.405604703215047e-07, 2.713382656338581e-07, 3.051866345193943e-07, 3.423294646642816e-07, 3.830012232919344e-07,
4.274471947507408e-07, 4.759237197671240e-07, 5.286984324781585e-07, 5.860504967980518e-07, 6.482708438948492e-07,
7.156624082238494e-07, 7.885403613405728e-07, 8.672323489333778e-07, 9.520787229710947e-07, 1.043432776848263e-06,
1.141660977199699e-06, 1.247143197269374e-06, 1.360272948169872e-06, 1.481457609364689e-06, 1.611118660815869e-06,
1.749691911134832e-06, 1.897627727176499e-06, 2.055391262745232e-06, 2.223462686079536e-06, 2.402337407003685e-06,
2.592526303746290e-06, 2.794555946650235e-06, 3.008968825213287e-06, 3.236323571464972e-06, 3.477195182233217e-06,
3.732175243409408e-06, 4.001872150327657e-06, 4.286911329698384e-06, 4.587935458988390e-06, 4.905604686689102e-06,
5.240596849920287e-06, 5.593607693366032e-06, 5.965351084213921e-06, 6.356559230646930e-06, 6.767982894895219e-06,
7.200391608730428e-06, 7.654573886295424e-06, 8.131337437489172e-06, 8.631509378020930e-06, 9.155936441795909e-06,
9.705485189082097e-06, 1.028104221745263e-05, 1.088351436739909e-05, 1.151382893083142e-05, 1.217293385680218e-05,
1.286179795578768e-05, 1.358141110463507e-05, 1.433278444951114e-05, 1.511695060718576e-05, 1.593496386720350e-05,
1.678790039139066e-05, 1.767685841225219e-05, 1.860295843236770e-05, 1.956734342012378e-05, 2.057117900589045e-05,
2.161565367753138e-05, 2.270197897313864e-05, 2.383138967454457e-05, 2.500514399861320e-05, 2.622452378708839e-05,
2.749083469755220e-05, 2.880540638994233e-05, 3.016959271540109e-05, 3.158477190057241e-05, 3.305234673423030e-05,
3.457374474935548e-05, 3.615041840676625e-05, 3.778384527719503e-05, 3.947552821959022e-05, 4.122699556186049e-05,
4.303980127806639e-05, 4.491552516561192e-05, 4.685577301977162e-05, 4.886217680932781e-05, 5.093639484854418e-05,
5.308011196969442e-05, 5.529503969314842e-05, 5.758291639734736e-05, 5.994550748600336e-05, 6.238460555652026e-05,
6.490203056430666e-05, 6.749962998708892e-05, 7.017927898900211e-05, 7.294288058168341e-05, 7.579236578481030e-05,
7.872969378541761e-05, 8.175685209610428e-05, 8.487585671101971e-05, 8.808875226173907e-05, 9.139761217080711e-05,
9.480453880483797e-05, 9.831166362528343e-05, 1.019211473387571e-04, 1.056351800459154e-04, 1.094559813878959e-04,
1.133858006934219e-04, 1.174269171216880e-04, 1.215816398080216e-04, 1.258523080027718e-04, 1.302412912136397e-04,
1.347509893450116e-04, 1.393838328340724e-04, 1.441422827881400e-04, 1.490288311192245e-04, 1.540460006780320e-04,
1.591963453845269e-04, 1.644824503607145e-04, 1.699069320578728e-04, 1.754724383852269e-04, 1.811816488362927e-04,
1.870372746145543e-04, 1.930420587546999e-04, 1.991987762471892e-04, 2.055102341569359e-04, 2.119792717443225e-04,
2.186087605804410e-04, 2.254016046659979e-04, 2.323607405440020e-04, 2.394891374138952e-04, 2.467897972433519e-04,
2.542657548791905e-04, 2.619200781547315e-04, 2.697558679988221e-04, 2.777762585403076e-04, 2.859844172141690e-04,
2.943835448622201e-04, 3.029768758371354e-04, 3.117676780998169e-04, 3.207592533200909e-04, 3.299549369719657e-04,
3.393580984301092e-04, 3.489721410631086e-04, 3.588005023260621e-04, 3.688466538522839e-04, 3.791141015414556e-04,
3.896063856482224e-04, 4.003270808684567e-04, 4.112797964238579e-04, 4.224681761463289e-04, 4.338958985578012e-04,
4.455666769520583e-04, 4.574842594735617e-04, 4.696524291936122e-04, 4.820750041871769e-04, 4.947558376058314e-04,
5.076988177517006e-04, 5.209078681476242e-04, 5.343869476069907e-04, 5.481400503023481e-04, 5.621712058306860e-04,
5.764844792799373e-04, 5.910839712907068e-04, 6.059738181199981e-04, 6.211581917001663e-04, 6.366412996980930e-04,
6.524273855731400e-04, 6.685207286318828e-04, 6.849256440834006e-04, 7.016464830910119e-04, 7.186876328242331e-04,
7.360535165076287e-04, 7.537485934698829e-04, 7.717773591888744e-04, 7.901443453385282e-04, 8.088541198311150e-04,
8.279112868591065e-04, 8.473204869365869e-04, 8.670863969370002e-04, 8.872137301316751e-04, 9.077072362243532e-04,
9.285717013873818e-04, 9.498119482923562e-04, 9.714328361428715e-04, 9.934392607039433e-04, 1.015836154330207e-03,
1.038628485992676e-03, 1.061821261303719e-03, 1.085419522541042e-03, 1.109428348670116e-03, 1.133852855364603e-03,
1.158698195025232e-03, 1.183969556797670e-03, 1.209672166589626e-03, 1.235811287083721e-03, 1.262392217753150e-03,
1.289420294870558e-03, 1.316900891520256e-03, 1.344839417606991e-03, 1.373241319861718e-03, 1.402112081848927e-03,
1.431457223969756e-03, 1.461282303466205e-03, 1.491592914420803e-03, 1.522394687758388e-03, 1.553693291242553e-03,
1.585494429474199e-03, 1.617803843886989e-03, 1.650627312739905e-03, 1.683970651111810e-03, 1.717839710891900e-03,
1.752240380768710e-03, 1.787178586219684e-03, 1.822660289497513e-03, 1.858691489615705e-03, 1.895278222332486e-03,
1.932426560133482e-03, 1.970142612213621e-03, 2.008432524456039e-03, 2.047302479410984e-03, 2.086758696273061e-03,
2.126807430856470e-03, 2.167454975569916e-03, 2.208707659388853e-03, 2.250571847827287e-03, 2.293053942908019e-03,
2.336160383131225e-03, 2.379897643443152e-03, 2.424272235199809e-03, 2.469290706133775e-03, 2.514959640316894e-03,
2.561285658122636e-03, 2.608275416186467e-03, 2.655935607365323e-03, 2.704272960696308e-03, 2.753294241353399e-03,
2.803006250601814e-03, 2.853415825754047e-03, 2.904529840121461e-03, 2.956355202966998e-03, 3.008898859453768e-03,
3.062167790596981e-03, 3.116169013208991e-03, 3.170909579848002e-03, 3.226396578761892e-03, 3.282637133833477e-03,
3.339638404522671e-03, 3.397407585808199e-03, 3.455951908129085e-03, 3.515278637321595e-03, 3.575395074560062e-03,
3.636308556291601e-03, 3.698026454172276e-03, 3.760556175002594e-03, 3.823905160659002e-03, 3.888080888027168e-03,
3.953090868932585e-03, 4.018942650070745e-03, 4.085643812935302e-03, 4.153201973745579e-03, 4.221624783372957e-03,
4.290919927267156e-03, 4.361095125378189e-03, 4.432158132081643e-03, 4.504116736099295e-03, 4.576978760420625e-03,
4.650752062221875e-03, 4.725444532785894e-03, 4.801064097417984e-03, 4.877618715364740e-03, 4.955116379727453e-03,
5.033565117378069e-03, 5.112972988871589e-03, 5.193348088359806e-03, 5.274698543501044e-03, 5.357032515371896e-03,
5.440358198376516e-03, 5.524683820154142e-03, 5.610017641487719e-03, 5.696367956208759e-03, 5.783743091105631e-03,
5.872151405824644e-03, 5.961601292776342e-03, 6.052101177037361e-03, 6.143659516251621e-03, 6.236284800532066e-03,
6.329985552359529e-03, 6.424770326483253e-03, 6.520647709817085e-03, 6.617626321339221e-03, 6.715714811986073e-03,
6.814921864549350e-03, 6.915256193570474e-03, 7.016726545233665e-03, 7.119341697260251e-03, 7.223110458799420e-03,
7.328041670320640e-03, 7.434144203503856e-03, 7.541426961128916e-03, 7.649898876964545e-03, 7.759568915657322e-03,
7.870446072618553e-03, 7.982539373910136e-03, 8.095857876131873e-03, 8.210410666305679e-03, 8.326206861760221e-03,
8.443255610015132e-03, 8.561566088662653e-03, 8.681147505251285e-03, 8.802009097167107e-03, 8.924160131514092e-03,
9.047609904994536e-03, 9.172367743788712e-03, 9.298443003434631e-03, 9.425845068704142e-03, 9.554583353483359e-03,
9.684667300646432e-03, 9.816106381935530e-03, 9.948910097833163e-03, 1.008308797743995e-02, 1.021864957834762e-02,
1.035560448651363e-02, 1.049396231613464e-02, 1.063373270951939e-02, 1.077492533696045e-02, 1.091754989660665e-02,
1.106161611433398e-02, 1.120713374361704e-02, 1.135411256539764e-02, 1.150256238795655e-02, 1.165249304678062e-02,
1.180391440443351e-02, 1.195683635042222e-02, 1.211126880106639e-02, 1.226722169936456e-02, 1.242470501486137e-02,
1.258372874351443e-02, 1.274430290755935e-02, 1.290643755537668e-02, 1.307014276135632e-02, 1.323542862576210e-02,
1.340230527459707e-02, 1.357078285946678e-02, 1.374087155744330e-02, 1.391258157092867e-02, 1.408592312751711e-02,
1.426090647985911e-02, 1.443754190552227e-02, 1.461583970685365e-02, 1.479581021084275e-02, 1.497746376898046e-02,
1.516081075712217e-02, 1.534586157534801e-02, 1.553262664782251e-02, 1.572111642265639e-02, 1.591134137176486e-02,
1.610331199072890e-02, 1.629703879865418e-02, 1.649253233802961e-02, 1.668980317458724e-02, 1.688886189716132e-02,
1.708971911754642e-02, 1.729238547035528e-02, 1.749687161287938e-02, 1.770318822494388e-02, 1.791134600876854e-02,
1.812135568882300e-02, 1.833322801168658e-02, 1.854697374590397e-02, 1.876260368184401e-02, 1.898012863155596e-02,
1.919955942862750e-02, 1.942090692804088e-02, 1.964418200603013e-02, 1.986939555993894e-02, 2.009655850807557e-02,
2.032568178957128e-02, 2.055677636423647e-02, 2.078985321241644e-02, 2.102492333484884e-02, 2.126199775252069e-02,
2.150108750652369e-02, 2.174220365791113e-02, 2.198535728755502e-02, 2.223055949600172e-02, 2.247782140332888e-02,
2.272715414900195e-02, 2.297856889173067e-02, 2.323207680932560e-02, 2.348768909855503e-02, 2.374541697500121e-02,
2.400527167291688e-02, 2.426726444508320e-02, 2.453140656266606e-02, 2.479770931507197e-02, 2.506618400980654e-02,
2.533684197233121e-02, 2.560969454592055e-02, 2.588475309151861e-02, 2.616202898759867e-02, 2.644153363001833e-02,
2.672327843187916e-02, 2.700727482338328e-02, 2.729353425169223e-02, 2.758206818078524e-02, 2.787288809131727e-02,
2.816600548047699e-02, 2.846143186184702e-02, 2.875917876526146e-02, 2.905925773666584e-02, 2.936168033797626e-02,
2.966645814693858e-02, 2.997360275698868e-02, 3.028312577711201e-02, 3.059503883170467e-02, 3.090935356043223e-02,
3.122608161809270e-02, 3.154523467447490e-02, 3.186682441422239e-02, 3.219086253669268e-02, 3.251736075582046e-02,
3.284633079997867e-02, 3.317778441184183e-02, 3.351173334824786e-02, 3.384818938006162e-02, 3.418716429203716e-02,
3.452866988268266e-02, 3.487271796412339e-02, 3.521932036196629e-02, 3.556848891516351e-02, 3.592023547587964e-02,
3.627457190935368e-02, 3.663151009376786e-02, 3.699106192011115e-02, 3.735323929204692e-02, 3.771805412577878e-02,
3.808551834991891e-02, 3.845564390535294e-02, 3.882844274511099e-02, 3.920392683423346e-02, 3.958210814964069e-02,
3.996299868000186e-02, 4.034661042560395e-02, 4.073295539822197e-02, 4.112204562098976e-02, 4.151389312826947e-02,
4.190850996552320e-02, 4.230590818918512e-02, 4.270609986653273e-02, 4.310909707555954e-02, 4.351491190484791e-02,
4.392355645344292e-02, 4.433504283072520e-02, 4.474938315628607e-02, 4.516658955980202e-02, 4.558667418091022e-02,
4.600964916908301e-02, 4.643552668350659e-02, 4.686431889295495e-02, 4.729603797566861e-02, 4.773069611923253e-02,
4.816830552045337e-02, 4.860887838523908e-02, 4.905242692847755e-02, 4.949896337391668e-02, 4.994849995404438e-02,
5.040104890996966e-02, 5.085662249130440e-02, 5.131523295604434e-02, 5.177689257045137e-02, 5.224161360893820e-02,
5.270940835394999e-02, 5.318028909584915e-02, 5.365426813280050e-02, 5.413135777065581e-02, 5.461157032283936e-02,
5.509491811023537e-02, 5.558141346107348e-02, 5.607106871081735e-02, 5.656389620205238e-02, 5.705990828437424e-02,
5.755911731427787e-02, 5.806153565504846e-02, 5.856717567665026e-02, 5.907604975561864e-02, 5.958817027495178e-02,
6.010354962400222e-02, 6.062220019837017e-02, 6.114413439979682e-02, 6.166936463605877e-02, 6.219790332086217e-02,
6.272976287373844e-02, 6.326495571993940e-02, 6.380349429033505e-02, 6.434539102131032e-02, 6.489065835466190e-02,
6.543930873749826e-02, 6.599135462213745e-02, 6.654680846600769e-02, 6.710568273154727e-02, 6.766798988610578e-02,
6.823374240184577e-02, 6.880295275564441e-02, 6.937563342899777e-02, 6.995179690792341e-02, 7.053145568286479e-02,
7.111462224859677e-02, 7.170130910413064e-02, 7.229152875262046e-02, 7.288529370127028e-02, 7.348261646124121e-02,
7.408350954756104e-02, 7.468798547903088e-02, 7.529605677813689e-02, 7.590773597096001e-02, 7.652303558708617e-02,
7.714196815951879e-02, 7.776454622459050e-02, 7.839078232187713e-02, 7.902068899411019e-02, 7.965427878709253e-02,
8.029156424961181e-02, 8.093255793335807e-02, 8.157727239283941e-02, 8.222572018529828e-02, 8.287791387063070e-02,
8.353386601130464e-02, 8.419358917227782e-02, 8.485709592092017e-02, 8.552439882693175e-02, 8.619551046226637e-02,
8.687044340105243e-02, 8.754921021951523e-02, 8.823182349590231e-02, 8.891829581040556e-02, 8.960863974508770e-02,
9.030286788380648e-02, 9.100099281214191e-02, 9.170302711732337e-02, 9.240898338815640e-02, 9.311887421495202e-02,
9.383271218945555e-02, 9.455050990477631e-02, 9.527227995531851e-02, 9.599803493671222e-02, 9.672778744574539e-02,
9.746155008029700e-02, 9.819933543926984e-02, 9.894115612252541e-02, 9.968702473081781e-02, 1.004369538657303e-01,
1.011909561296108e-01, 1.019490441255099e-01, 1.027112304571168e-01, 1.034775277287007e-01, 1.042479485450465e-01,
1.050225055113976e-01, 1.058012112333943e-01, 1.065840783170174e-01, 1.073711193685279e-01, 1.081623469944119e-01,
1.089577738013222e-01, 1.097574123960239e-01, 1.105612753853389e-01, 1.113693753760913e-01, 1.121817249750545e-01,
1.129983367888973e-01, 1.138192234241328e-01, 1.146443974870655e-01, 1.154738715837426e-01, 1.163076583199018e-01,
1.171457703009237e-01, 1.179882201317826e-01, 1.188350204169984e-01, 1.196861837605896e-01, 1.205417227660276e-01,
1.214016500361893e-01, 1.222659781733142e-01, 1.231347197789590e-01, 1.240078874539534e-01, 1.248854937983590e-01,
1.257675514114263e-01, 1.266540728915522e-01, 1.275450708362414e-01, 1.284405578420657e-01, 1.293405465046229e-01,
1.302450494185015e-01, 1.311540791772403e-01, 1.320676483732928e-01, 1.329857695979896e-01, 1.339084554415035e-01,
1.348357184928154e-01, 1.357675713396769e-01, 1.367040265685807e-01, 1.376450967647247e-01, 1.385907945119819e-01,
1.395411323928671e-01, 1.404961229885086e-01, 1.414557788786153e-01, 1.424201126414496e-01, 1.433891368537974e-01,
1.443628640909412e-01, 1.453413069266331e-01, 1.463244779330659e-01, 1.473123896808505e-01, 1.483050547389889e-01,
1.493024856748500e-01, 1.503046950541461e-01, 1.513116954409096e-01, 1.523234993974717e-01, 1.533401194844389e-01,
1.543615682606737e-01, 1.553878582832733e-01, 1.564190021075507e-01, 1.574550122870155e-01, 1.584959013733559e-01,
1.595416819164206e-01, 1.605923664642027e-01, 1.616479675628233e-01, 1.627084977565156e-01, 1.637739695876110e-01,
1.648443955965244e-01, 1.659197883217403e-01, 1.670001602998014e-01, 1.680855240652955e-01, 1.691758921508438e-01,
1.702712770870920e-01, 1.713716914026971e-01, 1.724771476243222e-01, 1.735876582766231e-01, 1.747032358822443e-01,
1.758238929618096e-01, 1.769496420339153e-01, 1.780804956151250e-01, 1.792164662199631e-01, 1.803575663609118e-01,
1.815038085484055e-01, 1.826552052908276e-01, 1.838117690945084e-01, 1.849735124637223e-01, 1.861404479006873e-01,
1.873125879055626e-01, 1.884899449764504e-01, 1.896725316093949e-01, 1.908603602983842e-01, 1.920534435353513e-01,
1.932517938101783e-01, 1.944554236106973e-01, 1.956643454226953e-01, 1.968785717299186e-01, 1.980981150140780e-01,
1.993229877548531e-01, 2.005532024298998e-01, 2.017887715148576e-01, 2.030297074833560e-01, 2.042760228070226e-01,
2.055277299554933e-01, 2.067848413964206e-01, 2.080473695954835e-01, 2.093153270163990e-01, 2.105887261209327e-01,
2.118675793689117e-01, 2.131518992182352e-01, 2.144416981248900e-01, 2.157369885429627e-01, 2.170377829246547e-01,
2.183440937202972e-01, 2.196559333783660e-01, 2.209733143454988e-01, 2.222962490665121e-01, 2.236247499844177e-01,
2.249588295404408e-01, 2.262985001740399e-01, 2.276437743229242e-01, 2.289946644230754e-01, 2.303511829087662e-01,
2.317133422125836e-01, 2.330811547654477e-01, 2.344546329966364e-01, 2.358337893338069e-01, 2.372186362030203e-01,
2.386091860287636e-01, 2.400054512339762e-01, 2.414074442400741e-01, 2.428151774669761e-01, 2.442286633331299e-01,
2.456479142555387e-01, 2.470729426497893e-01, 2.485037609300803e-01, 2.499403815092498e-01, 2.513828167988050e-01,
2.528310792089532e-01, 2.542851811486299e-01, 2.557451350255318e-01, 2.572109532461475e-01, 2.586826482157885e-01,
2.601602323386246e-01, 2.616437180177138e-01, 2.631331176550388e-01, 2.646284436515390e-01, 2.661297084071472e-01,
2.676369243208250e-01, 2.691501037905967e-01, 2.706692592135881e-01, 2.721944029860626e-01, 2.737255475034589e-01,
2.752627051604298e-01, 2.768058883508796e-01, 2.783551094680049e-01, 2.799103809043336e-01, 2.814717150517650e-01,
2.830391243016115e-01, 2.846126210446394e-01, 2.861922176711112e-01, 2.877779265708287e-01, 2.893697601331744e-01,
2.909677307471566e-01, 2.925718508014534e-01, 2.941821326844561e-01, 2.957985887843163e-01, 2.974212314889901e-01,
2.990500731862850e-01, 3.006851262639058e-01, 3.023264031095035e-01, 3.039739161107222e-01, 3.056276776552466e-01,
3.072877001308524e-01, 3.089539959254547e-01, 3.106265774271579e-01, 3.123054570243069e-01, 3.139906471055368e-01,
3.156821600598255e-01, 3.173800082765443e-01, 3.190842041455124e-01, 3.207947600570477e-01, 3.225116884020204e-01,
3.242350015719100e-01, 3.259647119588548e-01, 3.277008319557116e-01, 3.294433739561082e-01, 3.311923503545005e-01,
3.329477735462284e-01, 3.347096559275741e-01, 3.364780098958174e-01, 3.382528478492958e-01, 3.400341821874614e-01,
3.418220253109411e-01, 3.436163896215949e-01, 3.454172875225767e-01, 3.472247314183941e-01, 3.490387337149696e-01,
3.508593068197022e-01, 3.526864631415291e-01, 3.545202150909875e-01, 3.563605750802787e-01, 3.582075555233305e-01,
3.600611688358608e-01, 3.619214274354428e-01, 3.637883437415691e-01, 3.656619301757168e-01, 3.675421991614147e-01,
3.694291631243073e-01, 3.713228344922228e-01, 3.732232256952404e-01, 3.751303491657568e-01, 3.770442173385560e-01,
3.789648426508764e-01, 3.808922375424802e-01, 3.828264144557234e-01, 3.847673858356254e-01, 3.867151641299390e-01,
3.886697617892225e-01, 3.906311912669101e-01, 3.925994650193838e-01, 3.945745955060461e-01, 3.965565951893925e-01,
3.985454765350852e-01, 4.005412520120260e-01, 4.025439340924303e-01, 4.045535352519037e-01, 4.065700679695144e-01,
4.085935447278706e-01, 4.106239780131954e-01, 4.126613803154038e-01, 4.147057641281797e-01, 4.167571419490529e-01,
4.188155262794768e-01, 4.208809296249073e-01, 4.229533644948806e-01, 4.250328434030933e-01, 4.271193788674812e-01,
4.292129834102998e-01, 4.313136695582048e-01, 4.334214498423336e-01, 4.355363367983851e-01, 4.376583429667026e-01,
4.397874808923573e-01, 4.419237631252284e-01, 4.440672022200890e-01, 4.462178107366874e-01, 4.483756012398330e-01,
4.505405862994800e-01, 4.527127784908120e-01, 4.548921903943288e-01, 4.570788345959309e-01, 4.592727236870064e-01,
4.614738702645177e-01, 4.636822869310888e-01, 4.658979862950926e-01, 4.681209809707396e-01, 4.703512835781659e-01,
4.725889067435219e-01, 4.748338630990631e-01, 4.770861652832382e-01, 4.793458259407801e-01, 4.816128577227978e-01,
4.838872732868651e-01, 4.861690852971143e-01, 4.884583064243279e-01, 4.907549493460301e-01, 4.930590267465806e-01,
4.953705513172678e-01, 4.976895357564027e-01, 5.000159927694126e-01, 5.023499350689369e-01, 5.046913753749205e-01,
5.070403264147112e-01, 5.093968009231546e-01, 5.117608116426910e-01, 5.141323713234518e-01, 5.165114927233572e-01,
5.188981886082140e-01, 5.212924717518137e-01, 5.236943549360304e-01, 5.261038509509224e-01, 5.285209725948272e-01,
5.309457326744665e-01, 5.333781440050431e-01, 5.358182194103427e-01, 5.382659717228360e-01, 5.407214137837790e-01,
5.431845584433166e-01, 5.456554185605835e-01, 5.481340070038090e-01, 5.506203366504190e-01, 5.531144203871413e-01,
5.556162711101083e-01, 5.581259017249632e-01, 5.606433251469644e-01, 5.631685543010918e-01, 5.657016021221524e-01,
5.682424815548867e-01, 5.707912055540767e-01, 5.733477870846521e-01, 5.759122391217992e-01, 5.784845746510683e-01,
5.810648066684829e-01, 5.836529481806498e-01, 5.862490122048672e-01, 5.888530117692359e-01, 5.914649599127690e-01,
5.940848696855039e-01, 5.967127541486132e-01, 5.993486263745167e-01, 6.019924994469936e-01, 6.046443864612955e-01,
6.073043005242590e-01, 6.099722547544215e-01, 6.126482622821319e-01, 6.153323362496688e-01, 6.180244898113527e-01,
6.207247361336633e-01, 6.234330883953553e-01, 6.261495597875734e-01, 6.288741635139710e-01, 6.316069127908261e-01,
6.343478208471607e-01, 6.370969009248573e-01, 6.398541662787782e-01, 6.426196301768863e-01, 6.453933059003619e-01,
6.481752067437248e-01, 6.509653460149543e-01, 6.537637370356102e-01, 6.565703931409543e-01, 6.593853276800731e-01,
6.622085540159985e-01, 6.650400855258326e-01, 6.678799356008698e-01, 6.707281176467215e-01, 6.735846450834394e-01,
6.764495313456413e-01, 6.793227898826366e-01, 6.822044341585503e-01, 6.850944776524510e-01, 6.879929338584769e-01,
6.908998162859632e-01, 6.938151384595697e-01, 6.967389139194078e-01, 6.996711562211717e-01, 7.026118789362655e-01,
7.055610956519328e-01, 7.085188199713881e-01, 7.114850655139461e-01, 7.144598459151537e-01, 7.174431748269205e-01,
7.204350659176528e-01, 7.234355328723833e-01, 7.264445893929071e-01, 7.294622491979135e-01, 7.324885260231198e-01,
7.355234336214076e-01, 7.385669857629564e-01, 7.416191962353794e-01, 7.446800788438597e-01, 7.477496474112875e-01,
7.508279157783965e-01, 7.539148978039009e-01, 7.570106073646355e-01, 7.601150583556924e-01, 7.632282646905613e-01,
7.663502403012684e-01, 7.694809991385172e-01, 7.726205551718293e-01, 7.757689223896850e-01, 7.789261147996659e-01,
7.820921464285965e-01, 7.852670313226878e-01, 7.884507835476791e-01, 7.916434171889846e-01, 7.948449463518353e-01,
7.980553851614256e-01, 8.012747477630576e-01, 8.045030483222885e-01, 8.077403010250762e-01, 8.109865200779265e-01,
8.142417197080427e-01, 8.175059141634705e-01, 8.207791177132497e-01, 8.240613446475629e-01, 8.273526092778845e-01,
8.306529259371322e-01, 8.339623089798182e-01, 8.372807727821995e-01, 8.406083317424322e-01, 8.439450002807229e-01,
8.472907928394819e-01, 8.506457238834783e-01, 8.540098078999933e-01, 8.573830593989762e-01, 8.607654929132000e-01,
8.641571229984173e-01, 8.675579642335178e-01, 8.709680312206844e-01, 8.743873385855537e-01, 8.778159009773718e-01,
8.812537330691559e-01, 8.847008495578534e-01, 8.881572651645022e-01, 8.916229946343914e-01, 8.950980527372238e-01,
8.985824542672787e-01, 9.020762140435729e-01, 9.055793469100264e-01, 9.090918677356259e-01, 9.126137914145884e-01,
9.161451328665288e-01, 9.196859070366245e-01, 9.232361288957822e-01, 9.267958134408062e-01, 9.303649756945656e-01,
9.339436307061634e-01, 9.375317935511056e-01, 9.411294793314710e-01, 9.447367031760827e-01, 9.483534802406778e-01,
9.519798257080818e-01, 9.556157547883781e-01, 9.592612827190845e-01, 9.629164247653245e-01, 9.665811962200039e-01,
9.702556124039845e-01, 9.739396886662626e-01, 9.776334403841419e-01, 9.813368829634150e-01, 9.850500318385387e-01,
9.887729024728134e-01, 9.925055103585639e-01, 9.962478710173183e-01, 9.999999999999885e-01, 1.003761912887053e+00,
1.007533625288741e+00, 1.011315152845208e+00, 1.015106511226732e+00, 1.018907716133886e+00, 1.022718783297729e+00,
1.026539728479992e+00, 1.030370567473266e+00, 1.034211316101185e+00, 1.038061990218617e+00, 1.041922605711853e+00,
1.045793178498799e+00, 1.049673724529162e+00, 1.053564259784643e+00, 1.057464800279131e+00, 1.061375362058895e+00,
1.065295961202775e+00, 1.069226613822382e+00, 1.073167336062285e+00, 1.077118144100216e+00, 1.081079054147261e+00,
1.085050082448059e+00, 1.089031245281002e+00, 1.093022558958432e+00, 1.097024039826843e+00, 1.101035704267078e+00,
1.105057568694538e+00, 1.109089649559378e+00, 1.113131963346712e+00, 1.117184526576819e+00, 1.121247355805347e+00,
1.125320467623518e+00, 1.129403878658337e+00, 1.133497605572798e+00, 1.137601665066093e+00, 1.141716073873820e+00,
1.145840848768196e+00, 1.149976006558267e+00, 1.154121564090119e+00, 1.158277538247093e+00, 1.162443945949996e+00,
1.166620804157320e+00, 1.170808129865452e+00, 1.175005940108896e+00, 1.179214251960488e+00, 1.183433082531615e+00,
1.187662448972432e+00, 1.191902368472086e+00, 1.196152858258938e+00, 1.200413935600778e+00, 1.204685617805057e+00,
1.208967922219106e+00, 1.213260866230362e+00, 1.217564467266596e+00, 1.221878742796136e+00, 1.226203710328099e+00,
1.230539387412619e+00, 1.234885791641076e+00, 1.239242940646329e+00, 1.243610852102946e+00, 1.247989543727436e+00,
1.252379033278489e+00, 1.256779338557203e+00, 1.261190477407328e+00, 1.265612467715497e+00, 1.270045327411469e+00,
1.274489074468365e+00, 1.278943726902908e+00, 1.283409302775671e+00, 1.287885820191309e+00, 1.292373297298812e+00,
1.296871752291744e+00, 1.301381203408493e+00, 1.305901668932515e+00, 1.310433167192582e+00, 1.314975716563032e+00,
1.319529335464022e+00, 1.324094042361773e+00, 1.328669855768829e+00, 1.333256794244309e+00, 1.337854876394158e+00,
1.342464120871408e+00, 1.347084546376432e+00, 1.351716171657208e+00, 1.356359015509568e+00, 1.361013096777469e+00,
1.365678434353252e+00, 1.370355047177901e+00, 1.375042954241313e+00, 1.379742174582563e+00, 1.384452727290165e+00,
1.389174631502349e+00, 1.393907906407323e+00, 1.398652571243548e+00, 1.403408645300008e+00, 1.408176147916483e+00,
1.412955098483826e+00, 1.417745516444234e+00, 1.422547421291532e+00, 1.427360832571444e+00, 1.432185769881879e+00,
1.437022252873206e+00, 1.441870301248542e+00, 1.446729934764032e+00, 1.451601173229137e+00, 1.456484036506918e+00,
1.461378544514324e+00, 1.466284717222483e+00, 1.471202574656990e+00, 1.476132136898203e+00, 1.481073424081531e+00,
1.486026456397735e+00, 1.490991254093218e+00, 1.495967837470327e+00, 1.500956226887651e+00, 1.505956442760323e+00,
1.510968505560318e+00, 1.515992435816760e+00, 1.521028254116228e+00, 1.526075981103059e+00, 1.531135637479659e+00,
1.536207244006810e+00, 1.541290821503984e+00, 1.546386390849654e+00, 1.551493972981610e+00, 1.556613588897271e+00,
1.561745259654005e+00, 1.566889006369449e+00, 1.572044850221828e+00, 1.577212812450277e+00, 1.582392914355164e+00,
1.587585177298418e+00, 1.592789622703854e+00, 1.598006272057504e+00, 1.603235146907942e+00, 1.608476268866623e+00,
1.613729659608212e+00, 1.618995340870920e+00, 1.624273334456844e+00, 1.629563662232302e+00, 1.634866346128176e+00,
1.640181408140253e+00, 1.645508870329571e+00, 1.650848754822764e+00, 1.656201083812407e+00, 1.661565879557370e+00,
1.666943164383165e+00, 1.672332960682303e+00, 1.677735290914645e+00, 1.683150177607763e+00, 1.688577643357294e+00,
1.694017710827305e+00, 1.699470402750651e+00, 1.704935741929343e+00, 1.710413751234912e+00, 1.715904453608779e+00,
1.721407872062620e+00, 1.726924029678748e+00, 1.732452949610475e+00, 1.737994655082498e+00, 1.743549169391268e+00,
1.749116515905380e+00, 1.754696718065947e+00, 1.760289799386987e+00, 1.765895783455807e+00, 1.771514693933398e+00,
1.777146554554815e+00, 1.782791389129577e+00, 1.788449221542058e+00, 1.794120075751887e+00, 1.799803975794342e+00,
1.805500945780753e+00, 1.811211009898908e+00, 1.816934192413453e+00, 1.822670517666302e+00, 1.828420010077050e+00,
1.834182694143378e+00, 1.839958594441473e+00, 1.845747735626441e+00, 1.851550142432729e+00, 1.857365839674541e+00,
1.863194852246269e+00, 1.869037205122911e+00, 1.874892923360502e+00, 1.880762032096549e+00, 1.886644556550454e+00,
1.892540522023960e+00, 1.898449953901579e+00, 1.904372877651041e+00, 1.910309318823730e+00, 1.916259303055132e+00,
1.922222856065283e+00, 1.928200003659215e+00, 1.934190771727414e+00, 1.940195186246274e+00, 1.946213273278552e+00,
1.952245058973829e+00, 1.958290569568978e+00, 1.964349831388619e+00, 1.970422870845602e+00, 1.976509714441463e+00,
1.982610388766907e+00, 1.988724920502281e+00, 1.994853336418056e+00, 2.000995663375304e+00, 2.007151928326185e+00,
2.013322158314437e+00, 2.019506380475860e+00, 2.025704622038817e+00, 2.031916910324722e+00, 2.038143272748544e+00,
2.044383736819307e+00, 2.050638330140594e+00, 2.056907080411055e+00, 2.063190015424920e+00, 2.069487163072505e+00,
2.075798551340740e+00, 2.082124208313677e+00, 2.088464162173019e+00, 2.094818441198647e+00, 2.101187073769142e+00,
2.107570088362325e+00, 2.113967513555783e+00, 2.120379378027419e+00, 2.126805710555982e+00, 2.133246540021617e+00,
2.139701895406415e+00, 2.146171805794957e+00, 2.152656300374876e+00, 2.159155408437412e+00, 2.165669159377972e+00,
2.172197582696696e+00, 2.178740707999024e+00, 2.185298564996266e+00, 2.191871183506183e+00, 2.198458593453555e+00,
2.205060824870774e+00, 2.211677907898422e+00, 2.218309872785862e+00, 2.224956749891828e+00, 2.231618569685028e+00,
2.238295362744736e+00, 2.244987159761402e+00, 2.251693991537250e+00, 2.258415888986902e+00, 2.265152883137981e+00,
2.271905005131734e+00, 2.278672286223657e+00, 2.285454757784115e+00, 2.292252451298977e+00, 2.299065398370248e+00,
2.305893630716707e+00, 2.312737180174549e+00, 2.319596078698030e+00, 2.326470358360118e+00, 2.333360051353147e+00,
2.340265189989474e+00, 2.347185806702143e+00, 2.354121934045548e+00, 2.361073604696108e+00, 2.368040851452938e+00,
2.375023707238529e+00, 2.382022205099434e+00, 2.389036378206953e+00, 2.396066259857824e+00, 2.403111883474923e+00,
2.410173282607964e+00, 2.417250490934200e+00, 2.424343542259140e+00, 2.431452470517258e+00, 2.438577309772715e+00,
2.445718094220081e+00, 2.452874858185064e+00, 2.460047636125243e+00, 2.467236462630808e+00, 2.474441372425298e+00,
2.481662400366349e+00, 2.488899581446454e+00, 2.496152950793708e+00, 2.503422543672581e+00, 2.510708395484677e+00,
2.518010541769510e+00, 2.525329018205282e+00, 2.532663860609661e+00, 2.540015104940573e+00, 2.547382787296993e+00,
2.554766943919739e+00, 2.562167611192282e+00, 2.569584825641548e+00, 2.577018623938735e+00, 2.584469042900134e+00,
2.591936119487944e+00, 2.599419890811117e+00, 2.606920394126182e+00, 2.614437666838086e+00, 2.621971746501049e+00,
2.629522670819411e+00, 2.637090477648490e+00, 2.644675204995446e+00, 2.652276891020153e+00, 2.659895574036073e+00,
2.667531292511137e+00, 2.675184085068634e+00, 2.682853990488102e+00, 2.690541047706231e+00, 2.698245295817766e+00,
2.705966774076419e+00, 2.713705521895790e+00, 2.721461578850285e+00, 2.729234984676057e+00, 2.737025779271931e+00,
2.744834002700356e+00, 2.752659695188352e+00, 2.760502897128468e+00, 2.768363649079740e+00, 2.776241991768669e+00,
2.784137966090191e+00, 2.792051613108661e+00, 2.799982974058850e+00, 2.807932090346928e+00, 2.815899003551485e+00,
2.823883755424526e+00, 2.831886387892502e+00, 2.839906943057326e+00, 2.847945463197409e+00, 2.856001990768700e+00,
2.864076568405733e+00, 2.872169238922677e+00, 2.880280045314406e+00, 2.888409030757559e+00, 2.896556238611621e+00,
2.904721712420011e+00, 2.912905495911168e+00, 2.921107632999655e+00, 2.929328167787261e+00, 2.937567144564127e+00,
2.945824607809858e+00, 2.954100602194663e+00, 2.962395172580491e+00, 2.970708364022179e+00, 2.979040221768610e+00,
2.987390791263878e+00, 2.995760118148456e+00, 3.004148248260384e+00, 3.012555227636456e+00, 3.020981102513418e+00,
3.029425919329174e+00, 3.037889724724010e+00, 3.046372565541807e+00, 3.054874488831285e+00, 3.063395541847244e+00,
3.071935772051809e+00, 3.080495227115702e+00, 3.089073954919505e+00, 3.097672003554945e+00, 3.106289421326176e+00,
3.114926256751088e+00, 3.123582558562608e+00, 3.132258375710021e+00, 3.140953757360297e+00, 3.149668752899430e+00,
3.158403411933788e+00, 3.167157784291462e+00, 3.175931920023649e+00, 3.184725869406014e+00, 3.193539682940093e+00,
3.202373411354682e+00, 3.211227105607252e+00, 3.220100816885367e+00, 3.228994596608115e+00, 3.237908496427554e+00,
3.246842568230157e+00, 3.255796864138282e+00, 3.264771436511644e+00, 3.273766337948806e+00, 3.282781621288667e+00,
3.291817339611980e+00, 3.300873546242867e+00, 3.309950294750358e+00, 3.319047638949922e+00, 3.328165632905038e+00,
3.337304330928749e+00, 3.346463787585256e+00, 3.355644057691494e+00, 3.364845196318752e+00, 3.374067258794277e+00,
3.383310300702911e+00, 3.392574377888732e+00, 3.401859546456707e+00, 3.411165862774356e+00, 3.420493383473447e+00,
3.429842165451671e+00, 3.439212265874365e+00, 3.448603742176221e+00, 3.458016652063027e+00, 3.467451053513418e+00,
3.476907004780629e+00, 3.486384564394270e+00, 3.495883791162131e+00, 3.505404744171970e+00, 3.514947482793334e+00,
3.524512066679399e+00, 3.534098555768812e+00, 3.543707010287551e+00, 3.553337490750810e+00, 3.562990057964882e+00,
3.572664773029073e+00, 3.582361697337624e+00, 3.592080892581644e+00, 3.601822420751070e+00, 3.611586344136635e+00,
3.621372725331849e+00, 3.631181627235008e+00, 3.641013113051205e+00, 3.650867246294375e+00, 3.660744090789333e+00,
3.670643710673850e+00, 3.680566170400736e+00, 3.690511534739940e+00, 3.700479868780675e+00, 3.710471237933548e+00,
3.720485707932715e+00, 3.730523344838058e+00, 3.740584215037369e+00, 3.750668385248565e+00, 3.760775922521908e+00,
3.770906894242247e+00, 3.781061368131299e+00, 3.791239412249907e+00, 3.801441095000366e+00, 3.811666485128723e+00,
3.821915651727133e+00, 3.832188664236210e+00, 3.842485592447412e+00, 3.852806506505434e+00, 3.863151476910643e+00,
3.873520574521499e+00, 3.883913870557034e+00, 3.894331436599327e+00, 3.904773344596001e+00, 3.915239666862761e+00,
3.925730476085937e+00, 3.936245845325039e+00, 3.946785848015371e+00, 3.957350557970621e+00, 3.967940049385509e+00,
3.978554396838440e+00, 3.989193675294189e+00, 3.999857960106600e+00, 4.010547327021312e+00, 4.021261852178517e+00,
4.032001612115733e+00, 4.042766683770594e+00, 4.053557144483683e+00, 4.064373072001384e+00, 4.075214544478740e+00,
4.086081640482366e+00, 4.096974438993361e+00, 4.107893019410271e+00, 4.118837461552051e+00, 4.129807845661077e+00,
4.140804252406161e+00, 4.151826762885632e+00, 4.162875458630386e+00, 4.173950421607024e+00, 4.185051734220966e+00,
4.196179479319638e+00, 4.207333740195653e+00, 4.218514600590035e+00, 4.229722144695478e+00, 4.240956457159616e+00,
4.252217623088338e+00, 4.263505728049137e+00, 4.274820858074468e+00, 4.286163099665153e+00, 4.297532539793814e+00,
4.308929265908342e+00, 4.320353365935387e+00, 4.331804928283875e+00, 4.343284041848587e+00, 4.354790796013735e+00,
4.366325280656599e+00, 4.377887586151166e+00, 4.389477803371849e+00, 4.401096023697188e+00, 4.412742339013631e+00,
4.424416841719308e+00, 4.436119624727885e+00, 4.447850781472409e+00, 4.459610405909228e+00, 4.471398592521917e+00,
4.483215436325263e+00, 4.495061032869268e+00, 4.506935478243211e+00, 4.518838869079734e+00, 4.530771302558964e+00,
4.542732876412686e+00, 4.554723688928536e+00, 4.566743838954274e+00, 4.578793425902044e+00, 4.590872549752711e+00,
4.602981311060233e+00, 4.615119810956068e+00, 4.627288151153625e+00, 4.639486433952758e+00, 4.651714762244315e+00,
4.663973239514709e+00, 4.676261969850549e+00, 4.688581057943313e+00, 4.700930609094060e+00, 4.713310729218199e+00,
4.725721524850293e+00, 4.738163103148915e+00, 4.750635571901562e+00, 4.763139039529587e+00, 4.775673615093210e+00,
4.788239408296574e+00, 4.800836529492834e+00, 4.813465089689299e+00, 4.826125200552656e+00, 4.838816974414199e+00,
4.851540524275148e+00, 4.864295963811994e+00, 4.877083407381912e+00, 4.889902970028242e+00, 4.902754767485968e+00,
4.915638916187349e+00, 4.928555533267491e+00, 4.941504736570079e+00, 4.954486644653096e+00, 4.967501376794639e+00,
4.980549052998763e+00, 4.993629794001427e+00, 5.006743721276453e+00, 5.019890957041582e+00, 5.033071624264576e+00,
5.046285846669371e+00, 5.059533748742330e+00, 5.072815455738514e+00, 5.086131093688055e+00, 5.099480789402581e+00,
5.112864670481698e+00, 5.126282865319549e+00, 5.139735503111452e+00, 5.153222713860579e+00, 5.166744628384741e+00,
5.180301378323200e+00, 5.193893096143594e+00, 5.207519915148915e+00, 5.221181969484560e+00, 5.234879394145455e+00,
5.248612324983266e+00, 5.262380898713673e+00, 5.276185252923733e+00, 5.290025526079311e+00, 5.303901857532590e+00,
5.317814387529677e+00, 5.331763257218268e+00, 5.345748608655417e+00, 5.359770584815368e+00, 5.373829329597493e+00,
5.387924987834285e+00, 5.402057705299476e+00, 5.416227628716221e+00, 5.430434905765360e+00, 5.444679685093800e+00,
5.458962116322963e+00, 5.473282350057335e+00, 5.487640537893116e+00, 5.502036832426946e+00, 5.516471387264770e+00,
5.530944357030720e+00, 5.545455897376190e+00, 5.560006164988958e+00, 5.574595317602406e+00, 5.589223514004851e+00,
5.603890914049015e+00, 5.618597678661549e+00, 5.633343969852670e+00, 5.648129950725965e+00, 5.662955785488214e+00,
5.677821639459424e+00, 5.692727679082864e+00, 5.707674071935328e+00, 5.722660986737433e+00, 5.737688593364079e+00,
5.752757062854974e+00, 5.767866567425386e+00, 5.783017280476891e+00, 5.798209376608307e+00, 5.813443031626794e+00,
5.828718422558992e+00, 5.844035727662364e+00, 5.859395126436613e+00, 5.874796799635312e+00, 5.890240929277553e+00,
5.905727698659847e+00, 5.921257292368080e+00, 5.936829896289670e+00, 5.952445697625814e+00, 5.968104884903939e+00,
5.983807647990229e+00, 5.999554178102374e+00, 6.015344667822389e+00, 6.031179311109692e+00, 6.047058303314223e+00,
6.062981841189806e+00, 6.078950122907638e+00, 6.094963348069916e+00, 6.111021717723705e+00, 6.127125434374859e+00,
6.143274702002223e+00, 6.159469726071964e+00, 6.175710713552025e+00, 6.191997872926832e+00, 6.208331414212177e+00,
6.224711548970203e+00, 6.241138490324660e+00, 6.257612452976330e+00, 6.274133653218585e+00, 6.290702308953236e+00,
6.307318639706492e+00, 6.323982866645138e+00, 6.340695212592962e+00, 6.357455902047350e+00, 6.374265161196075e+00,
6.391123217934304e+00, 6.408030301881873e+00, 6.424986644400687e+00, 6.441992478612433e+00, 6.459048039416443e+00,
6.476153563507849e+00, 6.493309289395911e+00, 6.510515457422603e+00, 6.527772309781480e+00, 6.545080090536701e+00,
6.562439045642397e+00, 6.579849422962180e+00, 6.597311472288993e+00, 6.614825445365213e+00, 6.632391595902918e+00,
6.650010179604594e+00, 6.667681454183917e+00, 6.685405679386927e+00, 6.703183117013510e+00, 6.721014030939050e+00,
6.738898687136427e+00, 6.756837353698344e+00, 6.774830300859905e+00, 6.792877801021459e+00, 6.810980128771898e+00,
6.829137560912018e+00, 6.847350376478465e+00, 6.865618856767845e+00, 6.883943285361148e+00, 6.902323948148620e+00,
6.920761133354844e+00, 6.939255131564280e+00, 6.957806235747054e+00, 6.976414741285144e+00, 6.995080945998938e+00,
7.013805150174196e+00, 7.032587656589204e+00, 7.051428770542594e+00, 7.070328799881272e+00, 7.089288055028900e+00,
7.108306849014756e+00, 7.127385497502940e+00, 7.146524318822049e+00, 7.165723633995188e+00, 7.184983766770552e+00,
7.204305043652314e+00, 7.223687793931977e+00, 7.243132349720228e+00, 7.262639045979126e+00, 7.282208220554966e+00,
7.301840214211342e+00, 7.321535370662962e+00, 7.341294036609699e+00, 7.361116561771329e+00, 7.381003298922700e+00,
7.400954603929380e+00, 7.420970835783875e+00, 7.441052356642428e+00, 7.461199531862184e+00, 7.481412730039120e+00,
7.501692323046366e+00, 7.522038686073230e+00, 7.542452197664677e+00, 7.562933239761500e+00, 7.583482197741078e+00,
7.604099460458579e+00, 7.624785420289157e+00, 7.645540473170391e+00, 7.666365018645576e+00, 7.687259459907600e+00,
7.708224203843671e+00, 7.729259661080338e+00, 7.750366246029681e+00, 7.771544376935775e+00, 7.792794475922316e+00,
7.814116969040460e+00, 7.835512286317934e+00, 7.856980861808525e+00, 7.878523133642516e+00, 7.900139544077947e+00,
7.921830539552562e+00, 7.943596570736623e+00, 7.965438092586653e+00, 7.987355564399849e+00, 8.009349449869553e+00,
8.031420217141484e+00, 8.053568338870971e+00, 8.075794292280927e+00, 8.098098559221048e+00, 8.120481626227640e+00,
8.142943984584740e+00, 8.165486130385943e+00, 8.188108564597510e+00, 8.210811793122247e+00, 8.233596326864642e+00,
8.256462681797082e+00, 8.279411379026904e+00, 8.302442944864886e+00, 8.325557910894734e+00, 8.348756814043647e+00,
8.372040196654362e+00, 8.395408606558021e+00, 8.418862597148458e+00, 8.442402727457974e+00, 8.466029562234013e+00,
8.489743672017255e+00, 8.513545633221351e+00, 8.537436028213545e+00, 8.561415445397042e+00, 8.585484479294841e+00,
8.609643730634522e+00, 8.633893806435257e+00, 8.658235320095770e+00, 8.682668891483992e+00, 8.707195147028431e+00,
8.731814719811089e+00, 8.756528249661875e+00, 8.781336383255059e+00, 8.806239774206903e+00, 8.831239083175706e+00,
8.856334977963076e+00, 8.881528133617271e+00, 8.906819232538691e+00, 8.932208964586735e+00, 8.957698027188872e+00,
8.983287125451987e+00, 9.008976972275276e+00, 9.034768288465537e+00, 9.060661802854733e+00, 9.086658252419237e+00,
9.112758382401763e+00, 9.138962946435646e+00, 9.165272706670864e+00, 9.191688433903026e+00, 9.218210907704670e+00,
9.244840916558999e+00, 9.271579257996139e+00, 9.298426738731981e+00, 9.325384174809844e+00, 9.352452391744864e+00,
9.379632224671093e+00, 9.406924518491431e+00, 9.434330128030593e+00, 9.461849918191293e+00, 9.489484764112710e+00,
9.517235551333323e+00, 9.545103175955768e+00, 9.573088544815768e+00, 9.601192575654281e+00, 9.629416197292837e+00,
9.657760349812646e+00, 9.686225984737575e+00, 9.714814065220347e+00, 9.743525566232606e+00, 9.772361474759579e+00,
9.801322789997847e+00, 9.830410523557575e+00, 9.859625699669385e+00, 9.888969355394741e+00, 9.918442540841205e+00,
9.948046319382158e+00, 9.977781767881448e+00, 1.000764997692218e+01, 1.003765205104090e+01, 1.006778910896657e+01,
1.009806228386475e+01, 1.012847272358711e+01, 1.015902159092605e+01, 1.018971006387557e+01, 1.022053933589693e+01,
1.025151061619078e+01, 1.028262512997506e+01, 1.031388411876938e+01, 1.034528884068487e+01, 1.037684057072195e+01,
1.040854060107327e+01, 1.044039024143443e+01, 1.047239081932158e+01, 1.050454368039601e+01, 1.053685018879641e+01,
1.056931172747886e+01, 1.060192969856399e+01, 1.063470552369310e+01, 1.066764064439239e+01, 1.070073652244486e+01,
1.073399464027219e+01, 1.076741650132477e+01, 1.080100363048166e+01, 1.083475757445879e+01, 1.086867990222930e+01,
1.090277220545159e+01, 1.093703609890872e+01, 1.097147322095934e+01, 1.100608523399792e+01, 1.104087382492768e+01,
1.107584070564463e+01, 1.111098761353359e+01, 1.114631631197722e+01, 1.118182859087630e+01, 1.121752626718531e+01,
1.125341118545871e+01, 1.128948521841485e+01, 1.132575026751078e+01, 1.136220826353296e+01, 1.139886116720549e+01,
1.143571096980984e+01, 1.147275969382474e+01, 1.151000939358083e+01, 1.154746215593246e+01, 1.158512010094877e+01,
1.162298538262129e+01, 1.166106018959245e+01, 1.169934674590217e+01, 1.173784731175548e+01, 1.177656418431080e+01,
1.181549969848945e+01, 1.185465622780946e+01, 1.189403618523908e+01, 1.193364202407642e+01, 1.197347623885395e+01,
1.201354136626696e+01, 1.205383998612883e+01, 1.209437472235599e+01, 1.213514824397457e+01, 1.217616326616551e+01,
1.221742255133045e+01, 1.225892891019650e+01, 1.230068520294748e+01, 1.234269434039220e+01, 1.238495928516590e+01,
1.242748305296925e+01, 1.247026871384086e+01, 1.251331939347148e+01, 1.255663827455916e+01, 1.260022859820111e+01,
1.264409366533197e+01, 1.268823683820882e+01, 1.273266154193326e+01, 1.277737126603530e+01, 1.282236956609193e+01,
1.286766006541033e+01, 1.291324645675497e+01, 1.295913250413619e+01, 1.300532204465481e+01, 1.305181899040709e+01,
1.309862733044861e+01, 1.314575113283309e+01, 1.319319454670351e+01, 1.324096180446875e+01, 1.328905722404351e+01,
1.333748521116541e+01, 1.338625026179792e+01, 1.343535696460546e+01, 1.348481000352272e+01, 1.353461416040978e+01,
1.358477431779985e+01, 1.363529546174767e+01, 1.368618268477408e+01, 1.373744118891886e+01, 1.378907628890699e+01,
1.384109341542250e+01, 1.389349811851252e+01, 1.394629607110189e+01, 1.399949307265937e+01, 1.405309505297676e+01,
1.410710807611295e+01, 1.416153834447302e+01, 1.421639220305289e+01, 1.427167614383876e+01, 1.432739681038808e+01,
1.438356100257590e+01, 1.444017568155371e+01, 1.449724797487072e+01, 1.455478518183584e+01, 1.461279477907283e+01,
1.467128442631195e+01, 1.473026197241717e+01, 1.478973546166729e+01, 1.484971314029506e+01, 1.491020346330665e+01,
1.497121510158665e+01, 1.503275694931317e+01, 1.509483813168130e+01, 1.515746801299181e+01, 1.522065620506818e+01,
1.528441257604393e+01, 1.534874725958989e+01, 1.541367066449597e+01, 1.547919348473382e+01, 1.554532670997873e+01,
1.561208163660320e+01, 1.567946987918948e+01, 1.574750338260948e+01, 1.581619443467032e+01, 1.588555567934477e+01,
1.595560013069564e+01, 1.602634118744881e+01, 1.609779264831570e+01, 1.616996872804772e+01, 1.624288407436192e+01,
1.631655378568588e+01, 1.639099342984711e+01, 1.646621906374661e+01, 1.654224725402799e+01, 1.661909509891309e+01,
1.669678025119957e+01, 1.677532094246386e+01, 1.685473600869450e+01, 1.693504491725503e+01, 1.701626779547523e+01,
1.709842546078591e+01, 1.718153945262697e+01, 1.726563206626724e+01, 1.735072638856963e+01, 1.743684633586383e+01,
1.752401669422101e+01, 1.761226316217449e+01, 1.770161239597318e+01, 1.779209205780555e+01, 1.788373086712009e+01,
1.797655865508622e+01, 1.807060642285958e+01, 1.816590640344814e+01, 1.826249212791489e+01, 1.836039849606064e+01,
1.845966185186158e+01, 1.856032006432152e+01, 1.866241261403591e+01, 1.876598068591657e+01, 1.887106726862854e+01,
1.897771726169035e+01, 1.908597759027450e+01, 1.919589732891547e+01, 1.930752783498753e+01, 1.942092289218180e+01,
1.953613886627202e+01, 1.965323487269077e+01, 1.977227295834986e+01, 1.989331829915240e+01, 2.001643941341685e+01,
2.014170839483397e+01, 2.026920116529554e+01, 2.039899775129894e+01, 2.053118258471455e+01, 2.066584483244346e+01,
2.080307875718952e+01, 2.094298411360127e+01, 2.108566658297434e+01, 2.123123825214442e+01, 2.137981814251149e+01,
2.153153279315106e+01, 2.168651690873131e+01, 2.184491407636305e+01, 2.200687756536829e+01, 2.217257121614261e+01,
2.234217043696705e+01, 2.251586331910539e+01, 2.269385188821027e+01, 2.287635351670385e+01, 2.306360251909887e+01,
2.325585195976869e+01, 2.345337570600628e+01, 2.365647077640220e+01, 2.386546002269716e+01, 2.408069521580909e+01,
2.430256060899734e+01, 2.453147706166365e+01, 2.476790684179502e+01, 2.501235924363743e+01, 2.526539718737621e+01,
2.552764503779376e+01, 2.579979785401857e+01, 2.608263251337429e+01, 2.637702106424066e+01, 2.668394692894125e+01,
2.700452472831961e+01, 2.734002470651923e+01, 2.769190305493776e+01, 2.806184022922345e+01, 2.845178925765459e+01,
2.886403827217789e+01, 2.930129173049771e+01, 2.976677786933950e+01, 3.026439315807712e+01, 3.079890061034902e+01,
3.137620667940138e+01, 3.200375858512068e+01, 3.269112884843310e+01, 3.345090536982737e+01, 3.430009548529412e+01,
3.526242585320269e+01, 3.637228801250404e+01, 3.768170434501420e+01, 3.927176058857470e+01, 4.125684860588751e+01,
4.357373524529790e+01, 4.484012866322161e+01,
};
static double ws_gauss_chebyshev2047[] = {
1.040141248065865e-14, 1.664218164750223e-13, 8.425038375613978e-13, 2.662698938341439e-12, 6.500638049218187e-12,
1.347949045313434e-11, 2.497191092593100e-11, 4.259997513447332e-11, 6.823510329518064e-11, 1.039979720960954e-10,
1.522584148861276e-10, 2.156353101356187e-10, 2.969964581728792e-10, 3.994584462018767e-10, 5.263865016067688e-10,
6.813943335495081e-10, 8.683439628672716e-10, 1.091345540277019e-09, 1.354757152895011e-09, 1.663184619079679e-09,
2.021481271606787e-09, 2.434747729186377e-09, 2.908331656331578e-09, 3.447827511589876e-09, 4.059076284148074e-09,
4.748165218822718e-09, 5.521427529448322e-09, 6.385442100676363e-09, 7.347033178198594e-09, 8.413270047408767e-09,
9.591466700517525e-09, 1.088918149213580e-08, 1.231421678334267e-08, 1.387461857425417e-08, 1.557867612511033e-08,
1.743492156589815e-08, 1.945212949452899e-08, 2.163931656358931e-08, 2.400574105568472e-08, 2.656090244739723e-08,
2.931454096187701e-08, 3.227663711009019e-08, 3.545741122074478e-08, 3.886732295891794e-08, 4.251707083340754e-08,
4.641759169283316e-08, 5.058006021051052e-08, 5.501588835812526e-08, 5.973672486823235e-08, 6.475445468560805e-08,
7.008119840748126e-08, 7.572931171267393e-08, 8.171138477967768e-08, 8.804024169369759e-08, 9.472893984269302e-08,
1.017907693024461e-07, 1.092392522106895e-07, 1.170881421303271e-07, 1.253514234017782e-07, 1.340433104844819e-07,
1.431782472875931e-07, 1.527709064899079e-07, 1.628361888490526e-07, 1.733892224999729e-07, 1.844453622427615e-07,
1.960201888198618e-07, 2.081295081826847e-07, 2.207893507476806e-07, 2.340159706419043e-07, 2.478258449381154e-07,
2.622356728794542e-07, 2.772623750937361e-07, 2.929230927974077e-07, 3.092351869892072e-07, 3.262162376335751e-07,
3.438840428338576e-07, 3.622566179953528e-07, 3.813521949782404e-07, 4.011892212404484e-07, 4.217863589704992e-07,
4.431624842103876e-07, 4.653366859685397e-07, 4.883282653228972e-07, 5.121567345141900e-07, 5.368418160294339e-07,
5.624034416757178e-07, 5.888617516443246e-07, 6.162370935652473e-07, 6.445500215521485e-07, 6.738212952378205e-07,
7.040718788002010e-07, 7.353229399790054e-07, 7.675958490830255e-07, 8.009121779881582e-07, 8.352936991262199e-07,
8.707623844646103e-07, 9.073404044768766e-07, 9.450501271042501e-07, 9.839141167082072e-07, 1.023955133014124e-06,
1.065196130046081e-06, 1.107660255052889e-06, 1.151370847425387e-06, 1.196351437605098e-06, 1.242625745984290e-06,
1.290217681797505e-06, 1.339151342004658e-06, 1.389451010165717e-06, 1.441141155307085e-06, 1.494246430779724e-06,
1.548791673109100e-06, 1.604801900837008e-06, 1.662302313355369e-06, 1.721318289732056e-06, 1.781875387528808e-06,
1.843999341611350e-06, 1.907716062951728e-06, 1.973051637422997e-06, 2.040032324586289e-06, 2.108684556470367e-06,
2.179034936343711e-06, 2.251110237479259e-06, 2.324937401911818e-06, 2.400543539188280e-06, 2.477955925110695e-06,
2.557202000472260e-06, 2.638309369786361e-06, 2.721305800008688e-06, 2.806219219252532e-06, 2.893077715497351e-06,
2.981909535290667e-06, 3.072743082443399e-06, 3.165606916718688e-06, 3.260529752514328e-06, 3.357540457538860e-06,
3.456668051481431e-06, 3.557941704675495e-06, 3.661390736756436e-06, 3.767044615313231e-06, 3.874932954534179e-06,
3.985085513846858e-06, 4.097532196552325e-06, 4.212303048453703e-06, 4.329428256479206e-06, 4.448938147299731e-06,
4.570863185941045e-06, 4.695233974390732e-06, 4.822081250199928e-06, 4.951435885079957e-06, 5.083328883493989e-06,
5.217791381243743e-06, 5.354854644051410e-06, 5.494550066136807e-06, 5.636909168789926e-06, 5.781963598938928e-06,
5.929745127713672e-06, 6.080285649004919e-06, 6.233617178019247e-06, 6.389771849829812e-06, 6.548781917923036e-06,
6.710679752741318e-06, 6.875497840221862e-06, 7.043268780331725e-06, 7.214025285599178e-06, 7.387800179641464e-06,
7.564626395689084e-06, 7.744536975106645e-06, 7.927565065910472e-06, 8.113743921282948e-06, 8.303106898083802e-06,
8.495687455358355e-06, 8.691519152842916e-06, 8.890635649467278e-06, 9.093070701854592e-06, 9.298858162818577e-06,
9.508031979858272e-06, 9.720626193650294e-06, 9.936674936538866e-06, 1.015621243102359e-05, 1.037927298824514e-05,
1.060589100646889e-05, 1.083610096956668e-05, 1.106993744549677e-05, 1.130743508478207e-05, 1.154862861898671e-05,
1.179355285919124e-05, 1.204224269446626e-05, 1.229473309034487e-05, 1.255105908729385e-05, 1.281125579918375e-05,
1.307535841175794e-05, 1.334340218110088e-05, 1.361542243210544e-05, 1.389145455693961e-05, 1.417153401351257e-05,
1.445569632394033e-05, 1.474397707301086e-05, 1.503641190664907e-05, 1.533303653038143e-05, 1.563388670780067e-05,
1.593899825903037e-05, 1.624840705918968e-05, 1.656214903685833e-05, 1.688026017254180e-05, 1.720277649713706e-05,
1.752973409039879e-05, 1.786116907940605e-05, 1.819711763702992e-05, 1.853761598040180e-05, 1.888270036938262e-05,
1.923240710503310e-05, 1.958677252808520e-05, 1.994583301741460e-05, 2.030962498851467e-05, 2.067818489197178e-05,
2.105154921194211e-05, 2.142975446463005e-05, 2.181283719676846e-05, 2.220083398410049e-05, 2.259378142986352e-05,
2.299171616327497e-05, 2.339467483802035e-05, 2.380269413074333e-05, 2.421581073953821e-05, 2.463406138244480e-05,
2.505748279594576e-05, 2.548611173346647e-05, 2.591998496387769e-05, 2.635913927000087e-05, 2.680361144711646e-05,
2.725343830147506e-05, 2.770865664881174e-05, 2.816930331286343e-05, 2.863541512388956e-05, 2.910702891719618e-05,
2.958418153166319e-05, 3.006690980827557e-05, 3.055525058865775e-05, 3.104924071361195e-05, 3.154891702166033e-05,
3.205431634759091e-05, 3.256547552100752e-05, 3.308243136488386e-05, 3.360522069412160e-05, 3.413388031411296e-05,
3.466844701930729e-05, 3.520895759178239e-05, 3.575544879982014e-05, 3.630795739648679e-05, 3.686652011821800e-05,
3.743117368340845e-05, 3.800195479100652e-05, 3.857890011911388e-05, 3.916204632358986e-05, 3.975143003666123e-05,
4.034708786553705e-05, 4.094905639102867e-05, 4.155737216617530e-05, 4.217207171487484e-05, 4.279319153052027e-05,
4.342076807464162e-05, 4.405483777555371e-05, 4.469543702700952e-05, 4.534260218685934e-05, 4.599636957571602e-05,
4.665677547562603e-05, 4.732385612874658e-05, 4.799764773602905e-05, 4.867818645590837e-05, 4.936550840299880e-05,
5.005964964679621e-05, 5.076064621038638e-05, 5.146853406916034e-05, 5.218334914953576e-05, 5.290512732768527e-05,
5.363390442827151e-05, 5.436971622318876e-05, 5.511259843031145e-05, 5.586258671224988e-05, 5.661971667511242e-05,
5.738402386727515e-05, 5.815554377815850e-05, 5.893431183701092e-05, 5.972036341169999e-05, 6.051373380751069e-05,
6.131445826595104e-05, 6.212257196356532e-05, 6.293811001075455e-05, 6.376110745060453e-05, 6.459159925772174e-05,
6.542962033707660e-05, 6.627520552285457e-05, 6.712838957731503e-05, 6.798920718965801e-05, 6.885769297489864e-05,
6.973388147274975e-05, 7.061780714651241e-05, 7.150950438197435e-05, 7.240900748631658e-05, 7.331635068702844e-05,
7.423156813083007e-05, 7.515469388260424e-05, 7.608576192433516e-05, 7.702480615405702e-05, 7.797186038480962e-05,
7.892695834360343e-05, 7.989013367039261e-05, 8.086141991705641e-05, 8.184085054638986e-05, 8.282845893110208e-05,
8.382427835282426e-05, 8.482834200112533e-05, 8.584068297253709e-05, 8.686133426958791e-05, 8.789032879984498e-05,
8.892769937496572e-05, 8.997347870975792e-05, 9.102769942124888e-05, 9.209039402776333e-05, 9.316159494801040e-05,
9.424133450017977e-05, 9.532964490104668e-05, 9.642655826508612e-05, 9.753210660359589e-05, 9.864632182382916e-05,
9.976923572813601e-05, 1.009008800131141e-04, 1.020412862687685e-04, 1.031904859776813e-04, 1.043485105141895e-04,
1.055153911435733e-04, 1.066911590212530e-04, 1.078758451919952e-04, 1.090694805891289e-04, 1.102720960337706e-04,
1.114837222340585e-04, 1.127043897843972e-04, 1.139341291647103e-04, 1.151729707397040e-04, 1.164209447581390e-04,
1.176780813521125e-04, 1.189444105363494e-04, 1.202199622075036e-04, 1.215047661434677e-04, 1.227988520026934e-04,
1.241022493235213e-04, 1.254149875235187e-04, 1.267370958988300e-04, 1.280686036235332e-04, 1.294095397490088e-04,
1.307599332033168e-04, 1.321198127905837e-04, 1.334892071903992e-04, 1.348681449572223e-04, 1.362566545197973e-04,
1.376547641805787e-04, 1.390625021151673e-04, 1.404798963717541e-04, 1.419069748705747e-04, 1.433437654033735e-04,
1.447902956328773e-04, 1.462465930922782e-04, 1.477126851847265e-04, 1.491885991828338e-04, 1.506743622281835e-04,
1.521700013308543e-04, 1.536755433689502e-04, 1.551910150881418e-04, 1.567164431012165e-04, 1.582518538876389e-04,
1.597972737931201e-04, 1.613527290291968e-04, 1.629182456728204e-04, 1.644938496659547e-04, 1.660795668151841e-04,
1.676754227913305e-04, 1.692814431290808e-04, 1.708976532266223e-04, 1.725240783452890e-04, 1.741607436092166e-04,
1.758076740050074e-04, 1.774648943814041e-04, 1.791324294489737e-04, 1.808103037797998e-04, 1.824985418071853e-04,
1.841971678253639e-04, 1.859062059892214e-04, 1.876256803140252e-04, 1.893556146751645e-04, 1.910960328078987e-04,
1.928469583071162e-04, 1.946084146271005e-04, 1.963804250813080e-04, 1.981630128421530e-04, 1.999562009408019e-04,
2.017600122669788e-04, 2.035744695687768e-04, 2.053995954524815e-04, 2.072354123824008e-04, 2.090819426807068e-04,
2.109392085272828e-04, 2.128072319595839e-04, 2.146860348725012e-04, 2.165756390182408e-04, 2.184760660062060e-04,
2.203873373028921e-04, 2.223094742317892e-04, 2.242424979732927e-04, 2.261864295646231e-04, 2.281412898997552e-04,
2.301070997293556e-04, 2.320838796607275e-04, 2.340716501577664e-04, 2.360704315409226e-04, 2.380802439871731e-04,
2.401011075300011e-04, 2.421330420593855e-04, 2.441760673217970e-04, 2.462302029202041e-04, 2.482954683140862e-04,
2.503718828194557e-04, 2.524594656088888e-04, 2.545582357115631e-04, 2.566682120133047e-04, 2.587894132566430e-04,
2.609218580408731e-04, 2.630655648221270e-04, 2.652205519134529e-04, 2.673868374849010e-04, 2.695644395636195e-04,
2.717533760339563e-04, 2.739536646375701e-04, 2.761653229735487e-04, 2.783883684985345e-04, 2.806228185268591e-04,
2.828686902306837e-04, 2.851260006401490e-04, 2.873947666435315e-04, 2.896750049874076e-04, 2.919667322768250e-04,
2.942699649754819e-04, 2.965847194059135e-04, 2.989110117496859e-04, 3.012488580475965e-04, 3.035982741998826e-04,
3.059592759664368e-04, 3.083318789670301e-04, 3.107160986815408e-04, 3.131119504501917e-04, 3.155194494737932e-04,
3.179386108139953e-04, 3.203694493935436e-04, 3.228119799965451e-04, 3.252662172687377e-04, 3.277321757177702e-04,
3.302098697134855e-04, 3.326993134882123e-04, 3.352005211370629e-04, 3.377135066182381e-04, 3.402382837533370e-04,
3.427748662276758e-04, 3.453232675906103e-04, 3.478835012558668e-04, 3.504555805018779e-04, 3.530395184721255e-04,
3.556353281754891e-04, 3.582430224866012e-04, 3.608626141462079e-04, 3.634941157615361e-04, 3.661375398066666e-04,
3.687928986229120e-04, 3.714602044192030e-04, 3.741394692724774e-04, 3.768307051280776e-04, 3.795339238001522e-04,
3.822491369720627e-04, 3.849763561967983e-04, 3.877155928973940e-04, 3.904668583673545e-04, 3.932301637710847e-04,
3.960055201443236e-04, 3.987929383945862e-04, 4.015924293016081e-04, 4.044040035177969e-04, 4.072276715686880e-04,
4.100634438534058e-04, 4.129113306451308e-04, 4.157713420915693e-04, 4.186434882154309e-04, 4.215277789149090e-04,
4.244242239641671e-04, 4.273328330138292e-04, 4.302536155914753e-04, 4.331865811021422e-04, 4.361317388288270e-04,
4.390890979329977e-04, 4.420586674551062e-04, 4.450404563151080e-04, 4.480344733129833e-04, 4.510407271292643e-04,
4.540592263255682e-04, 4.570899793451313e-04, 4.601329945133497e-04, 4.631882800383226e-04, 4.662558440114014e-04,
4.693356944077416e-04, 4.724278390868573e-04, 4.755322857931844e-04, 4.786490421566419e-04, 4.817781156932010e-04,
4.849195138054566e-04, 4.880732437832014e-04, 4.912393128040070e-04, 4.944177279338045e-04, 4.976084961274720e-04,
5.008116242294236e-04, 5.040271189742027e-04, 5.072549869870787e-04, 5.104952347846467e-04, 5.137478687754309e-04,
5.170128952604911e-04, 5.202903204340321e-04, 5.235801503840174e-04, 5.268823910927835e-04, 5.301970484376614e-04,
5.335241281915956e-04, 5.368636360237720e-04, 5.402155775002437e-04, 5.435799580845628e-04, 5.469567831384141e-04,
5.503460579222496e-04, 5.537477875959304e-04, 5.571619772193661e-04, 5.605886317531597e-04, 5.640277560592544e-04,
5.674793549015840e-04, 5.709434329467235e-04, 5.744199947645423e-04, 5.779090448288642e-04, 5.814105875181230e-04,
5.849246271160254e-04, 5.884511678122138e-04, 5.919902137029317e-04, 5.955417687916932e-04, 5.991058369899493e-04,
6.026824221177637e-04, 6.062715279044843e-04, 6.098731579894190e-04, 6.134873159225146e-04, 6.171140051650352e-04,
6.207532290902446e-04, 6.244049909840886e-04, 6.280692940458802e-04, 6.317461413889855e-04, 6.354355360415141e-04,
6.391374809470055e-04, 6.428519789651233e-04, 6.465790328723465e-04, 6.503186453626651e-04, 6.540708190482726e-04,
6.578355564602680e-04, 6.616128600493504e-04, 6.654027321865197e-04, 6.692051751637780e-04, 6.730201911948322e-04,
6.768477824157961e-04, 6.806879508858959e-04, 6.845406985881742e-04, 6.884060274301990e-04, 6.922839392447706e-04,
6.961744357906278e-04, 7.000775187531607e-04, 7.039931897451191e-04, 7.079214503073249e-04, 7.118623019093831e-04,
7.158157459503961e-04, 7.197817837596751e-04, 7.237604165974570e-04, 7.277516456556172e-04, 7.317554720583863e-04,
7.357718968630661e-04, 7.398009210607466e-04, 7.438425455770220e-04, 7.478967712727107e-04, 7.519635989445709e-04,
7.560430293260209e-04, 7.601350630878570e-04, 7.642397008389751e-04, 7.683569431270868e-04, 7.724867904394422e-04,
7.766292432035483e-04, 7.807843017878903e-04, 7.849519665026520e-04, 7.891322376004361e-04, 7.933251152769854e-04,
7.975305996719031e-04, 8.017486908693738e-04, 8.059793888988861e-04, 8.102226937359504e-04, 8.144786053028222e-04,
8.187471234692219e-04, 8.230282480530560e-04, 8.273219788211371e-04, 8.316283154899045e-04, 8.359472577261449e-04,
8.402788051477102e-04, 8.446229573242417e-04, 8.489797137778836e-04, 8.533490739840077e-04, 8.577310373719284e-04,
8.621256033256228e-04, 8.665327711844485e-04, 8.709525402438601e-04, 8.753849097561286e-04, 8.798298789310573e-04,
8.842874469366952e-04, 8.887576129000573e-04, 8.932403759078367e-04, 8.977357350071205e-04, 9.022436892061025e-04,
9.067642374747980e-04, 9.112973787457555e-04, 9.158431119147699e-04, 9.204014358415920e-04, 9.249723493506418e-04,
9.295558512317152e-04, 9.341519402406968e-04, 9.387606151002647e-04, 9.433818745006012e-04, 9.480157171000975e-04,
9.526621415260607e-04, 9.573211463754183e-04, 9.619927302154228e-04, 9.666768915843550e-04, 9.713736289922255e-04,
9.760829409214781e-04, 9.808048258276882e-04, 9.855392821402627e-04, 9.902863082631398e-04, 9.950459025754846e-04,
9.998180634323880e-04, 1.004602789165559e-03, 1.009400078084022e-03, 1.014209928474807e-03, 1.019032338603644e-03,
1.023867306715656e-03, 1.028714831036042e-03, 1.033574909770772e-03, 1.038447541107274e-03, 1.043332723215116e-03,
1.048230454246695e-03, 1.053140732337921e-03, 1.058063555608898e-03, 1.062998922164606e-03, 1.067946830095583e-03,
1.072907277478600e-03, 1.077880262377342e-03, 1.082865782843085e-03, 1.087863836915367e-03, 1.092874422622665e-03,
1.097897537983070e-03, 1.102933181004948e-03, 1.107981349687624e-03, 1.113042042022036e-03, 1.118115255991414e-03,
1.123200989571937e-03, 1.128299240733402e-03, 1.133410007439886e-03, 1.138533287650405e-03, 1.143669079319576e-03,
1.148817380398275e-03, 1.153978188834293e-03, 1.159151502572996e-03, 1.164337319557971e-03, 1.169535637731687e-03,
1.174746455036140e-03, 1.179969769413505e-03, 1.185205578806785e-03, 1.190453881160458e-03, 1.195714674421117e-03,
1.200987956538121e-03, 1.206273725464232e-03, 1.211571979156258e-03, 1.216882715575688e-03, 1.222205932689336e-03,
1.227541628469970e-03, 1.232889800896952e-03, 1.238250447956866e-03, 1.243623567644155e-03, 1.249009157961744e-03,
1.254407216921670e-03, 1.259817742545715e-03, 1.265240732866018e-03, 1.270676185925710e-03, 1.276124099779532e-03,
1.281584472494451e-03, 1.287057302150285e-03, 1.292542586840314e-03, 1.298040324671899e-03, 1.303550513767096e-03,
1.309073152263264e-03, 1.314608238313678e-03, 1.320155770088140e-03, 1.325715745773583e-03, 1.331288163574675e-03,
1.336873021714429e-03, 1.342470318434799e-03, 1.348080051997286e-03, 1.353702220683530e-03, 1.359336822795918e-03,
1.364983856658168e-03, 1.370643320615932e-03, 1.376315213037385e-03, 1.381999532313815e-03, 1.387696276860216e-03,
1.393405445115871e-03, 1.399127035544942e-03, 1.404861046637053e-03, 1.410607476907871e-03, 1.416366324899691e-03,
1.422137589182013e-03, 1.427921268352119e-03, 1.433717361035654e-03, 1.439525865887196e-03, 1.445346781590830e-03,
1.451180106860721e-03, 1.457025840441686e-03, 1.462883981109755e-03, 1.468754527672747e-03, 1.474637478970828e-03,
1.480532833877078e-03, 1.486440591298053e-03, 1.492360750174345e-03, 1.498293309481139e-03, 1.504238268228772e-03,
1.510195625463290e-03, 1.516165380267002e-03, 1.522147531759027e-03, 1.528142079095853e-03, 1.534149021471882e-03,
1.540168358119979e-03, 1.546200088312017e-03, 1.552244211359424e-03, 1.558300726613727e-03, 1.564369633467090e-03,
1.570450931352859e-03, 1.576544619746096e-03, 1.582650698164120e-03, 1.588769166167043e-03, 1.594900023358301e-03,
1.601043269385190e-03, 1.607198903939396e-03, 1.613366926757525e-03, 1.619547337621631e-03, 1.625740136359746e-03,
1.631945322846402e-03, 1.638162897003155e-03, 1.644392858799110e-03, 1.650635208251442e-03, 1.656889945425916e-03,
1.663157070437401e-03, 1.669436583450396e-03, 1.675728484679535e-03, 1.682032774390111e-03, 1.688349452898584e-03,
1.694678520573089e-03, 1.701019977833958e-03, 1.707373825154215e-03, 1.713740063060091e-03, 1.720118692131533e-03,
1.726509713002701e-03, 1.732913126362475e-03, 1.739328932954962e-03, 1.745757133579991e-03, 1.752197729093613e-03,
1.758650720408603e-03, 1.765116108494956e-03, 1.771593894380381e-03, 1.778084079150797e-03, 1.784586663950828e-03,
1.791101649984293e-03, 1.797629038514698e-03, 1.804168830865727e-03, 1.810721028421728e-03, 1.817285632628205e-03,
1.823862644992299e-03, 1.830452067083279e-03, 1.837053900533017e-03, 1.843668147036486e-03, 1.850294808352228e-03,
1.856933886302837e-03, 1.863585382775449e-03, 1.870249299722206e-03, 1.876925639160746e-03, 1.883614403174672e-03,
1.890315593914029e-03, 1.897029213595781e-03, 1.903755264504283e-03, 1.910493748991751e-03, 1.917244669478736e-03,
1.924008028454597e-03, 1.930783828477964e-03, 1.937572072177212e-03, 1.944372762250927e-03, 1.951185901468371e-03,
1.958011492669951e-03, 1.964849538767680e-03, 1.971700042745647e-03, 1.978563007660472e-03, 1.985438436641774e-03,
1.992326332892634e-03, 1.999226699690051e-03, 2.006139540385400e-03, 2.013064858404899e-03, 2.020002657250060e-03,
2.026952940498152e-03, 2.033915711802652e-03, 2.040890974893706e-03, 2.047878733578579e-03, 2.054878991742117e-03,
2.061891753347190e-03, 2.068917022435158e-03, 2.075954803126312e-03, 2.083005099620334e-03, 2.090067916196741e-03,
2.097143257215342e-03, 2.104231127116682e-03, 2.111331530422500e-03, 2.118444471736166e-03, 2.125569955743138e-03,
2.132707987211408e-03, 2.139858570991944e-03, 2.147021712019144e-03, 2.154197415311275e-03, 2.161385685970927e-03,
2.168586529185447e-03, 2.175799950227394e-03, 2.183025954454976e-03, 2.190264547312499e-03, 2.197515734330805e-03,
2.204779521127718e-03, 2.212055913408489e-03, 2.219344916966232e-03, 2.226646537682371e-03, 2.233960781527081e-03,
2.241287654559725e-03, 2.248627162929299e-03, 2.255979312874872e-03, 2.263344110726025e-03, 2.270721562903292e-03,
2.278111675918600e-03, 2.285514456375707e-03, 2.292929910970647e-03, 2.300358046492159e-03, 2.307798869822137e-03,
2.315252387936060e-03, 2.322718607903439e-03, 2.330197536888250e-03, 2.337689182149375e-03, 2.345193551041036e-03,
2.352710651013242e-03, 2.360240489612221e-03, 2.367783074480859e-03, 2.375338413359142e-03, 2.382906514084590e-03,
2.390487384592697e-03, 2.398081032917372e-03, 2.405687467191373e-03, 2.413306695646751e-03, 2.420938726615280e-03,
2.428583568528909e-03, 2.436241229920188e-03, 2.443911719422715e-03, 2.451595045771571e-03, 2.459291217803764e-03,
2.467000244458666e-03, 2.474722134778448e-03, 2.482456897908532e-03, 2.490204543098019e-03, 2.497965079700139e-03,
2.505738517172686e-03, 2.513524865078463e-03, 2.521324133085721e-03, 2.529136330968601e-03, 2.536961468607580e-03,
2.544799555989911e-03, 2.552650603210064e-03, 2.560514620470175e-03, 2.568391618080485e-03, 2.576281606459787e-03,
2.584184596135872e-03, 2.592100597745971e-03, 2.600029622037205e-03, 2.607971679867029e-03, 2.615926782203679e-03,
2.623894940126623e-03, 2.631876164827006e-03, 2.639870467608097e-03, 2.647877859885747e-03, 2.655898353188831e-03,
2.663931959159700e-03, 2.671978689554639e-03, 2.680038556244310e-03, 2.688111571214213e-03, 2.696197746565139e-03,
2.704297094513615e-03, 2.712409627392378e-03, 2.720535357650811e-03, 2.728674297855413e-03, 2.736826460690255e-03,
2.744991858957436e-03, 2.753170505577544e-03, 2.761362413590119e-03, 2.769567596154110e-03, 2.777786066548343e-03,
2.786017838171981e-03, 2.794262924544991e-03, 2.802521339308605e-03, 2.810793096225794e-03, 2.819078209181730e-03,
2.827376692184259e-03, 2.835688559364366e-03, 2.844013824976652e-03, 2.852352503399803e-03, 2.860704609137063e-03,
2.869070156816711e-03, 2.877449161192534e-03, 2.885841637144308e-03, 2.894247599678274e-03, 2.902667063927618e-03,
2.911100045152951e-03, 2.919546558742797e-03, 2.928006620214066e-03, 2.936480245212553e-03, 2.944967449513408e-03,
2.953468249021643e-03, 2.961982659772607e-03, 2.970510697932479e-03, 2.979052379798768e-03, 2.987607721800798e-03,
2.996176740500210e-03, 3.004759452591455e-03, 3.013355874902293e-03, 3.021966024394295e-03, 3.030589918163346e-03,
3.039227573440141e-03, 3.047879007590703e-03, 3.056544238116873e-03, 3.065223282656839e-03, 3.073916158985626e-03,
3.082622885015625e-03, 3.091343478797093e-03, 3.100077958518677e-03, 3.108826342507934e-03, 3.117588649231843e-03,
3.126364897297326e-03, 3.135155105451781e-03, 3.143959292583598e-03, 3.152777477722690e-03, 3.161609680041020e-03,
3.170455918853137e-03, 3.179316213616700e-03, 3.188190583933023e-03, 3.197079049547611e-03, 3.205981630350691e-03,
3.214898346377762e-03, 3.223829217810140e-03, 3.232774264975497e-03, 3.241733508348410e-03, 3.250706968550920e-03,
3.259694666353076e-03, 3.268696622673492e-03, 3.277712858579906e-03, 3.286743395289742e-03, 3.295788254170665e-03,
3.304847456741151e-03, 3.313921024671054e-03, 3.323008979782171e-03, 3.332111344048820e-03, 3.341228139598410e-03,
3.350359388712017e-03, 3.359505113824968e-03, 3.368665337527422e-03, 3.377840082564948e-03, 3.387029371839125e-03,
3.396233228408118e-03, 3.405451675487281e-03, 3.414684736449748e-03, 3.423932434827034e-03, 3.433194794309631e-03,
3.442471838747614e-03, 3.451763592151255e-03, 3.461070078691621e-03, 3.470391322701189e-03, 3.479727348674470e-03,
3.489078181268620e-03, 3.498443845304058e-03, 3.507824365765101e-03, 3.517219767800581e-03, 3.526630076724482e-03,
3.536055318016570e-03, 3.545495517323032e-03, 3.554950700457116e-03, 3.564420893399770e-03, 3.573906122300295e-03,
3.583406413476988e-03, 3.592921793417801e-03, 3.602452288780990e-03, 3.611997926395784e-03, 3.621558733263036e-03,
3.631134736555906e-03, 3.640725963620508e-03, 3.650332441976608e-03, 3.659954199318280e-03, 3.669591263514602e-03,
3.679243662610329e-03, 3.688911424826586e-03, 3.698594578561560e-03, 3.708293152391191e-03, 3.718007175069875e-03,
3.727736675531158e-03, 3.737481682888456e-03, 3.747242226435750e-03, 3.757018335648312e-03, 3.766810040183414e-03,
3.776617369881058e-03, 3.786440354764689e-03, 3.796279025041939e-03, 3.806133411105349e-03, 3.816003543533116e-03,
3.825889453089826e-03, 3.835791170727205e-03, 3.845708727584870e-03, 3.855642154991075e-03, 3.865591484463484e-03,
3.875556747709919e-03, 3.885537976629134e-03, 3.895535203311589e-03, 3.905548460040218e-03, 3.915577779291216e-03,
3.925623193734818e-03, 3.935684736236098e-03, 3.945762439855748e-03, 3.955856337850889e-03, 3.965966463675867e-03,
3.976092850983063e-03, 3.986235533623705e-03, 3.996394545648685e-03, 4.006569921309378e-03, 4.016761695058474e-03,
4.026969901550805e-03, 4.037194575644181e-03, 4.047435752400232e-03, 4.057693467085260e-03, 4.067967755171079e-03,
4.078258652335882e-03, 4.088566194465093e-03, 4.098890417652241e-03, 4.109231358199830e-03, 4.119589052620210e-03,
4.129963537636466e-03, 4.140354850183307e-03, 4.150763027407947e-03, 4.161188106671022e-03, 4.171630125547470e-03,
4.182089121827466e-03, 4.192565133517314e-03, 4.203058198840382e-03, 4.213568356238023e-03, 4.224095644370506e-03,
4.234640102117952e-03, 4.245201768581279e-03, 4.255780683083156e-03, 4.266376885168946e-03, 4.276990414607677e-03,
4.287621311393004e-03, 4.298269615744183e-03, 4.308935368107046e-03, 4.319618609154993e-03, 4.330319379789976e-03,
4.341037721143498e-03, 4.351773674577621e-03, 4.362527281685966e-03, 4.373298584294739e-03, 4.384087624463746e-03,
4.394894444487430e-03, 4.405719086895895e-03, 4.416561594455955e-03, 4.427422010172186e-03, 4.438300377287975e-03,
4.449196739286576e-03, 4.460111139892199e-03, 4.471043623071064e-03, 4.481994233032492e-03, 4.492963014229998e-03,
4.503950011362383e-03, 4.514955269374831e-03, 4.525978833460038e-03, 4.537020749059307e-03, 4.548081061863686e-03,
4.559159817815101e-03, 4.570257063107489e-03, 4.581372844187947e-03, 4.592507207757890e-03, 4.603660200774202e-03,
4.614831870450419e-03, 4.626022264257898e-03, 4.637231429927001e-03, 4.648459415448289e-03, 4.659706269073727e-03,
4.670972039317881e-03, 4.682256774959145e-03, 4.693560525040954e-03, 4.704883338873028e-03, 4.716225266032601e-03,
4.727586356365682e-03, 4.738966659988293e-03, 4.750366227287751e-03, 4.761785108923933e-03, 4.773223355830562e-03,
4.784681019216490e-03, 4.796158150567003e-03, 4.807654801645130e-03, 4.819171024492950e-03, 4.830706871432923e-03,
4.842262395069231e-03, 4.853837648289104e-03, 4.865432684264185e-03, 4.877047556451888e-03, 4.888682318596760e-03,
4.900337024731874e-03, 4.912011729180208e-03, 4.923706486556039e-03, 4.935421351766368e-03, 4.947156380012312e-03,
4.958911626790550e-03, 4.970687147894749e-03, 4.982482999417019e-03, 4.994299237749355e-03, 5.006135919585112e-03,
5.017993101920480e-03, 5.029870842055970e-03, 5.041769197597902e-03, 5.053688226459919e-03, 5.065627986864500e-03,
5.077588537344490e-03, 5.089569936744633e-03, 5.101572244223115e-03, 5.113595519253135e-03, 5.125639821624469e-03,
5.137705211445035e-03, 5.149791749142511e-03, 5.161899495465915e-03, 5.174028511487223e-03, 5.186178858602998e-03,
5.198350598536022e-03, 5.210543793336942e-03, 5.222758505385920e-03, 5.234994797394323e-03, 5.247252732406380e-03,
5.259532373800900e-03, 5.271833785292947e-03, 5.284157030935582e-03, 5.296502175121579e-03, 5.308869282585166e-03,
5.321258418403784e-03, 5.333669647999844e-03, 5.346103037142512e-03, 5.358558651949491e-03, 5.371036558888829e-03,
5.383536824780734e-03, 5.396059516799403e-03, 5.408604702474849e-03, 5.421172449694784e-03, 5.433762826706455e-03,
5.446375902118539e-03, 5.459011744903043e-03, 5.471670424397192e-03, 5.484352010305373e-03, 5.497056572701046e-03,
5.509784182028711e-03, 5.522534909105857e-03, 5.535308825124935e-03, 5.548106001655373e-03, 5.560926510645547e-03,
5.573770424424820e-03, 5.586637815705573e-03, 5.599528757585244e-03, 5.612443323548393e-03, 5.625381587468796e-03,
5.638343623611504e-03, 5.651329506634977e-03, 5.664339311593203e-03, 5.677373113937820e-03, 5.690430989520284e-03,
5.703513014594033e-03, 5.716619265816672e-03, 5.729749820252168e-03, 5.742904755373072e-03, 5.756084149062754e-03,
5.769288079617635e-03, 5.782516625749480e-03, 5.795769866587641e-03, 5.809047881681397e-03, 5.822350751002235e-03,
5.835678554946196e-03, 5.849031374336230e-03, 5.862409290424545e-03, 5.875812384895002e-03, 5.889240739865511e-03,
5.902694437890457e-03, 5.916173561963120e-03, 5.929678195518148e-03, 5.943208422434011e-03, 5.956764327035512e-03,
5.970345994096276e-03, 5.983953508841284e-03, 5.997586956949422e-03, 6.011246424556044e-03, 6.024931998255565e-03,
6.038643765104035e-03, 6.052381812621802e-03, 6.066146228796115e-03, 6.079937102083826e-03, 6.093754521414024e-03,
6.107598576190774e-03, 6.121469356295836e-03, 6.135366952091377e-03, 6.149291454422770e-03, 6.163242954621352e-03,
6.177221544507241e-03, 6.191227316392156e-03, 6.205260363082269e-03, 6.219320777881060e-03, 6.233408654592230e-03,
6.247524087522573e-03, 6.261667171484964e-03, 6.275838001801265e-03, 6.290036674305325e-03, 6.304263285345981e-03,
6.318517931790077e-03, 6.332800711025510e-03, 6.347111720964301e-03, 6.361451060045690e-03, 6.375818827239243e-03,
6.390215122048009e-03, 6.404640044511657e-03, 6.419093695209700e-03, 6.433576175264676e-03, 6.448087586345402e-03,
6.462628030670227e-03, 6.477197611010331e-03, 6.491796430693024e-03, 6.506424593605101e-03, 6.521082204196177e-03,
6.535769367482112e-03, 6.550486189048400e-03, 6.565232775053622e-03, 6.580009232232915e-03, 6.594815667901467e-03,
6.609652189958031e-03, 6.624518906888495e-03, 6.639415927769442e-03, 6.654343362271752e-03, 6.669301320664272e-03,
6.684289913817420e-03, 6.699309253206926e-03, 6.714359450917528e-03, 6.729440619646729e-03, 6.744552872708567e-03,
6.759696324037432e-03, 6.774871088191893e-03, 6.790077280358572e-03, 6.805315016356052e-03, 6.820584412638785e-03,
6.835885586301073e-03, 6.851218655081042e-03, 6.866583737364674e-03, 6.881980952189866e-03, 6.897410419250503e-03,
6.912872258900598e-03, 6.928366592158420e-03, 6.943893540710698e-03, 6.959453226916829e-03, 6.975045773813136e-03,
6.990671305117153e-03, 7.006329945231943e-03, 7.022021819250457e-03, 7.037747052959918e-03, 7.053505772846260e-03,
7.069298106098562e-03, 7.085124180613572e-03, 7.100984125000227e-03, 7.116878068584224e-03, 7.132806141412632e-03,
7.148768474258519e-03, 7.164765198625652e-03, 7.180796446753205e-03, 7.196862351620524e-03, 7.212963046951918e-03,
7.229098667221484e-03, 7.245269347658009e-03, 7.261475224249852e-03, 7.277716433749919e-03, 7.293993113680652e-03,
7.310305402339063e-03, 7.326653438801819e-03, 7.343037362930333e-03, 7.359457315375968e-03, 7.375913437585204e-03,
7.392405871804904e-03, 7.408934761087583e-03, 7.425500249296766e-03, 7.442102481112347e-03, 7.458741602036012e-03,
7.475417758396709e-03, 7.492131097356175e-03, 7.508881766914444e-03, 7.525669915915508e-03, 7.542495694052939e-03,
7.559359251875582e-03, 7.576260740793320e-03, 7.593200313082834e-03, 7.610178121893490e-03, 7.627194321253184e-03,
7.644249066074310e-03, 7.661342512159740e-03, 7.678474816208876e-03, 7.695646135823700e-03, 7.712856629514985e-03,
7.730106456708420e-03, 7.747395777750914e-03, 7.764724753916831e-03, 7.782093547414429e-03, 7.799502321392179e-03,
7.816951239945280e-03, 7.834440468122161e-03, 7.851970171931068e-03, 7.869540518346639e-03, 7.887151675316669e-03,
7.904803811768781e-03, 7.922497097617250e-03, 7.940231703769899e-03, 7.958007802134938e-03, 7.975825565628019e-03,
7.993685168179212e-03, 8.011586784740149e-03, 8.029530591291146e-03, 8.047516764848430e-03, 8.065545483471454e-03,
8.083616926270206e-03, 8.101731273412632e-03, 8.119888706132112e-03, 8.138089406735001e-03, 8.156333558608215e-03,
8.174621346226938e-03, 8.192952955162340e-03, 8.211328572089376e-03, 8.229748384794663e-03, 8.248212582184456e-03,
8.266721354292610e-03, 8.285274892288705e-03, 8.303873388486184e-03, 8.322517036350587e-03, 8.341206030507855e-03,
8.359940566752672e-03, 8.378720842056975e-03, 8.397547054578423e-03, 8.416419403669016e-03, 8.435338089883771e-03,
8.454303314989468e-03, 8.473315281973502e-03, 8.492374195052756e-03, 8.511480259682633e-03, 8.530633682566095e-03,
8.549834671662825e-03, 8.569083436198470e-03, 8.588380186673948e-03, 8.607725134874851e-03, 8.627118493880932e-03,
8.646560478075679e-03, 8.666051303155974e-03, 8.685591186141838e-03, 8.705180345386272e-03, 8.724819000585157e-03,
8.744507372787319e-03, 8.764245684404568e-03, 8.784034159221962e-03, 8.803873022408055e-03, 8.823762500525304e-03,
8.843702821540542e-03, 8.863694214835561e-03, 8.883736911217778e-03, 8.903831142931017e-03, 8.923977143666401e-03,
8.944175148573270e-03, 8.964425394270316e-03, 8.984728118856722e-03, 9.005083561923479e-03, 9.025491964564734e-03,
9.045953569389292e-03, 9.066468620532241e-03, 9.087037363666658e-03, 9.107660046015370e-03, 9.128336916362959e-03,
9.149068225067752e-03, 9.169854224073999e-03, 9.190695166924124e-03, 9.211591308771135e-03, 9.232542906391089e-03,
9.253550218195721e-03, 9.274613504245221e-03, 9.295733026261044e-03, 9.316909047638886e-03, 9.338141833461872e-03,
9.359431650513653e-03, 9.380778767291899e-03, 9.402183454021674e-03, 9.423645982669100e-03, 9.445166626955121e-03,
9.466745662369309e-03, 9.488383366183930e-03, 9.510080017468087e-03, 9.531835897101966e-03, 9.553651287791249e-03,
9.575526474081740e-03, 9.597461742373987e-03, 9.619457380938133e-03, 9.641513679928972e-03, 9.663630931400984e-03,
9.685809429323670e-03, 9.708049469596991e-03, 9.730351350066908e-03, 9.752715370541115e-03, 9.775141832804975e-03,
9.797631040637501e-03, 9.820183299827583e-03, 9.842798918190355e-03, 9.865478205583735e-03, 9.888221473925039e-03,
9.911029037207924e-03, 9.933901211519325e-03, 9.956838315056690e-03, 9.979840668145326e-03, 1.000290859325594e-02,
1.002604241502231e-02, 1.004924246025923e-02, 1.007250905798048e-02, 1.009584253941720e-02, 1.011924323803621e-02,
1.014271148955861e-02, 1.016624763197874e-02, 1.018985200558295e-02, 1.021352495296898e-02, 1.023726681906519e-02,
1.026107795115023e-02, 1.028495869887279e-02, 1.030890941427156e-02, 1.033293045179539e-02, 1.035702216832375e-02,
1.038118492318724e-02, 1.040541907818845e-02, 1.042972499762299e-02, 1.045410304830064e-02, 1.047855359956690e-02,
1.050307702332464e-02, 1.052767369405598e-02, 1.055234398884446e-02, 1.057708828739730e-02, 1.060190697206813e-02,
1.062680042787970e-02, 1.065176904254702e-02, 1.067681320650062e-02, 1.070193331291010e-02, 1.072712975770793e-02,
1.075240293961358e-02, 1.077775326015763e-02, 1.080318112370651e-02, 1.082868693748724e-02, 1.085427111161248e-02,
1.087993405910594e-02, 1.090567619592789e-02, 1.093149794100121e-02, 1.095739971623735e-02, 1.098338194656292e-02,
1.100944505994634e-02, 1.103558948742490e-02, 1.106181566313198e-02, 1.108812402432474e-02, 1.111451501141189e-02,
1.114098906798199e-02, 1.116754664083192e-02, 1.119418817999560e-02, 1.122091413877324e-02, 1.124772497376062e-02,
1.127462114487897e-02, 1.130160311540496e-02, 1.132867135200120e-02, 1.135582632474683e-02, 1.138306850716874e-02,
1.141039837627290e-02, 1.143781641257618e-02, 1.146532310013834e-02, 1.149291892659469e-02, 1.152060438318872e-02,
1.154837996480544e-02, 1.157624617000478e-02, 1.160420350105569e-02, 1.163225246397035e-02, 1.166039356853888e-02,
1.168862732836438e-02, 1.171695426089850e-02, 1.174537488747718e-02, 1.177388973335706e-02, 1.180249932775206e-02,
1.183120420387054e-02, 1.186000489895274e-02, 1.188890195430881e-02, 1.191789591535714e-02, 1.194698733166317e-02,
1.197617675697864e-02, 1.200546474928123e-02, 1.203485187081489e-02, 1.206433868813025e-02, 1.209392577212579e-02,
1.212361369808943e-02, 1.215340304574051e-02, 1.218329439927223e-02, 1.221328834739487e-02, 1.224338548337907e-02,
1.227358640510000e-02, 1.230389171508179e-02, 1.233430202054263e-02, 1.236481793344028e-02, 1.239544007051825e-02,
1.242616905335236e-02, 1.245700550839801e-02, 1.248795006703791e-02, 1.251900336563033e-02, 1.255016604555801e-02,
1.258143875327768e-02, 1.261282214037004e-02, 1.264431686359038e-02, 1.267592358491992e-02, 1.270764297161758e-02,
1.273947569627254e-02, 1.277142243685724e-02, 1.280348387678115e-02, 1.283566070494534e-02, 1.286795361579713e-02,
1.290036330938631e-02, 1.293289049142105e-02, 1.296553587332530e-02, 1.299830017229638e-02, 1.303118411136354e-02,
1.306418841944702e-02, 1.309731383141807e-02, 1.313056108815955e-02, 1.316393093662730e-02, 1.319742412991231e-02,
1.323104142730351e-02, 1.326478359435161e-02, 1.329865140293344e-02, 1.333264563131727e-02, 1.336676706422893e-02,
1.340101649291860e-02, 1.343539471522860e-02, 1.346990253566205e-02, 1.350454076545214e-02, 1.353931022263269e-02,
1.357421173210904e-02, 1.360924612573037e-02, 1.364441424236268e-02, 1.367971692796268e-02, 1.371515503565263e-02,
1.375072942579620e-02, 1.378644096607529e-02, 1.382229053156778e-02, 1.385827900482626e-02, 1.389440727595776e-02,
1.393067624270475e-02, 1.396708681052673e-02, 1.400363989268329e-02, 1.404033641031803e-02, 1.407717729254367e-02,
1.411416347652804e-02, 1.415129590758156e-02, 1.418857553924561e-02, 1.422600333338206e-02, 1.426358026026407e-02,
1.430130729866801e-02, 1.433918543596660e-02, 1.437721566822335e-02, 1.441539900028810e-02, 1.445373644589412e-02,
1.449222902775596e-02, 1.453087777766923e-02, 1.456968373661141e-02, 1.460864795484384e-02, 1.464777149201522e-02,
1.468705541726691e-02, 1.472650080933894e-02, 1.476610875667771e-02, 1.480588035754554e-02, 1.484581672013110e-02,
1.488591896266188e-02, 1.492618821351756e-02, 1.496662561134564e-02, 1.500723230517818e-02, 1.504800945455032e-02,
1.508895822962001e-02, 1.513007981129053e-02, 1.517137539133318e-02, 1.521284617251262e-02, 1.525449336871400e-02,
1.529631820507124e-02, 1.533832191809772e-02, 1.538050575581815e-02, 1.542287097790333e-02, 1.546541885580534e-02,
1.550815067289600e-02, 1.555106772460633e-02, 1.559417131856857e-02, 1.563746277475980e-02, 1.568094342564815e-02,
1.572461461634021e-02, 1.576847770473152e-02, 1.581253406165821e-02, 1.585678507105207e-02, 1.590123213009646e-02,
1.594587664938543e-02, 1.599072005308491e-02, 1.603576377909583e-02, 1.608100927922045e-02, 1.612645801932985e-02,
1.617211147953517e-02, 1.621797115436089e-02, 1.626403855291985e-02, 1.631031519909193e-02, 1.635680263170528e-02,
1.640350240471923e-02, 1.645041608741085e-02, 1.649754526456423e-02, 1.654489153666180e-02, 1.659245652007957e-02,
1.664024184728447e-02, 1.668824916703465e-02, 1.673648014458352e-02, 1.678493646188629e-02, 1.683361981780957e-02,
1.688253192834415e-02, 1.693167452682158e-02, 1.698104936413313e-02, 1.703065820895296e-02, 1.708050284796394e-02,
1.713058508608766e-02, 1.718090674671726e-02, 1.723146967195416e-02, 1.728227572284884e-02, 1.733332677964450e-02,
1.738462474202547e-02, 1.743617152936838e-02, 1.748796908099802e-02, 1.754001935644755e-02, 1.759232433572124e-02,
1.764488601956353e-02, 1.769770642973010e-02, 1.775078760926455e-02, 1.780413162277975e-02, 1.785774055674251e-02,
1.791161651976318e-02, 1.796576164289061e-02, 1.802017807991104e-02, 1.807486800765155e-02, 1.812983362629009e-02,
1.818507715966739e-02, 1.824060085560747e-02, 1.829640698624108e-02, 1.835249784833453e-02, 1.840887576362522e-02,
1.846554307916088e-02, 1.852250216764616e-02, 1.857975542779336e-02, 1.863730528467974e-02, 1.869515419011060e-02,
1.875330462298914e-02, 1.881175908969003e-02, 1.887052012444288e-02, 1.892959028971854e-02, 1.898897217662410e-02,
1.904866840530422e-02, 1.910868162534834e-02, 1.916901451620577e-02, 1.922966978760644e-02, 1.929065017999102e-02,
1.935195846494646e-02, 1.941359744564956e-02, 1.947556995731843e-02, 1.953787886767066e-02, 1.960052707739179e-02,
1.966351752060845e-02, 1.972685316537331e-02, 1.979053701415509e-02, 1.985457210433970e-02, 1.991896150873915e-02,
1.998370833610892e-02, 2.004881573167511e-02, 2.011428687767150e-02, 2.018012499388372e-02, 2.024633333820618e-02,
2.031291520720639e-02, 2.037987393670128e-02, 2.044721290234211e-02, 2.051493552021124e-02, 2.058304524742958e-02,
2.065154558277237e-02, 2.072044006730178e-02, 2.078973228500506e-02, 2.085942586344740e-02, 2.092952447443580e-02,
2.100003183469754e-02, 2.107095170656559e-02, 2.114228789868358e-02, 2.121404426671748e-02, 2.128622471408687e-02,
2.135883319270234e-02, 2.143187370372428e-02, 2.150535029833013e-02, 2.157926707849882e-02, 2.165362819781039e-02,
2.172843786225875e-02, 2.180370033108101e-02, 2.187941991760355e-02, 2.195560099010175e-02, 2.203224797267893e-02,
2.210936534616029e-02, 2.218695764900585e-02, 2.226502947823779e-02, 2.234358549039082e-02, 2.242263040247537e-02,
2.250216899296502e-02, 2.258220610279877e-02, 2.266274663640658e-02, 2.274379556275214e-02, 2.282535791639834e-02,
2.290743879859470e-02, 2.299004337838211e-02, 2.307317689372474e-02, 2.315684465266255e-02, 2.324105203448501e-02,
2.332580449093428e-02, 2.341110754742538e-02, 2.349696680429491e-02, 2.358338793807881e-02, 2.367037670280953e-02,
2.375793893134233e-02, 2.384608053671298e-02, 2.393480751351643e-02, 2.402412593931946e-02, 2.411404197610328e-02,
2.420456187172841e-02, 2.429569196144224e-02, 2.438743866940886e-02, 2.447980851027393e-02, 2.457280809076451e-02,
2.466644411132216e-02, 2.476072336776829e-02, 2.485565275301090e-02, 2.495123925877904e-02, 2.504748997740596e-02,
2.514441210364089e-02, 2.524201293650426e-02, 2.534029988118842e-02, 2.543928045099013e-02, 2.553896226928997e-02,
2.563935307158047e-02, 2.574046070753016e-02, 2.584229314309888e-02, 2.594485846270281e-02, 2.604816487141887e-02,
2.615222069724678e-02, 2.625703439342325e-02, 2.636261454077797e-02, 2.646896985015335e-02, 2.657610916487720e-02,
2.668404146329106e-02, 2.679277586133560e-02, 2.690232161519538e-02, 2.701268812400749e-02, 2.712388493263305e-02,
2.723592173449138e-02, 2.734880837446026e-02, 2.746255485184616e-02, 2.757717132342871e-02, 2.769266810656219e-02,
2.780905568237425e-02, 2.792634469901796e-02, 2.804454597501693e-02, 2.816367050268771e-02, 2.828372945163976e-02,
2.840473417236485e-02, 2.852669619991867e-02, 2.864962725768253e-02, 2.877353926121912e-02, 2.889844432223664e-02,
2.902435475263360e-02, 2.915128306865165e-02, 2.927924199514086e-02, 2.940824446991570e-02, 2.953830364823060e-02,
2.966943290736689e-02, 2.980164585134262e-02, 2.993495631572943e-02, 3.006937837260377e-02, 3.020492633562041e-02,
3.034161476522032e-02, 3.047945847397167e-02, 3.061847253204799e-02, 3.075867227286098e-02, 3.090007329882428e-02,
3.104269148728242e-02, 3.118654299659147e-02, 3.133164427236997e-02, 3.147801205389776e-02, 3.162566338071767e-02,
3.177461559938440e-02, 3.192488637041469e-02, 3.207649367542481e-02, 3.222945582445920e-02, 3.238379146352317e-02,
3.253951958232969e-02, 3.269665952224297e-02, 3.285523098446536e-02, 3.301525403844999e-02, 3.317674913053018e-02,
3.333973709282004e-02, 3.350423915235164e-02, 3.367027694048347e-02, 3.383787250255348e-02, 3.400704830786234e-02,
3.417782725989016e-02, 3.435023270683548e-02, 3.452428845247981e-02, 3.470001876733313e-02, 3.487744840014063e-02,
3.505660258971859e-02, 3.523750707714193e-02, 3.542018811831329e-02, 3.560467249687511e-02, 3.579098753756513e-02,
3.597916111990912e-02, 3.616922169242633e-02, 3.636119828718146e-02, 3.655512053481785e-02, 3.675101868011221e-02,
3.694892359790976e-02, 3.714886680965672e-02, 3.735088050040769e-02, 3.755499753636665e-02, 3.776125148302575e-02,
3.796967662383875e-02, 3.818030797954344e-02, 3.839318132807511e-02, 3.860833322514509e-02, 3.882580102549109e-02,
3.904562290481691e-02, 3.926783788251161e-02, 3.949248584503809e-02, 3.971960757016504e-02, 3.994924475202519e-02,
4.018144002697931e-02, 4.041623700037718e-02, 4.065368027430393e-02, 4.089381547610095e-02, 4.113668928814092e-02,
4.138234947837477e-02, 4.163084493216903e-02, 4.188222568510071e-02, 4.213654295701793e-02, 4.239384918727856e-02,
4.265419807130007e-02, 4.291764459832381e-02, 4.318424509064794e-02, 4.345405724432615e-02, 4.372714017122246e-02,
4.400355444273073e-02, 4.428336213519293e-02, 4.456662687673602e-02, 4.485341389631300e-02, 4.514379007413232e-02,
4.543782399442618e-02, 4.573558599994006e-02, 4.603714824871848e-02, 4.634258477304224e-02, 4.665197154069028e-02,
4.696538651850100e-02, 4.728290973878899e-02, 4.760462336791700e-02, 4.793061177813619e-02, 4.826096162201311e-02,
4.859576190993245e-02, 4.893510409101161e-02, 4.927908213701429e-02, 4.962779263004886e-02, 4.998133485382108e-02,
5.033981088872321e-02, 5.070332571109194e-02, 5.107198729654266e-02, 5.144590672785330e-02, 5.182519830765808e-02,
5.220997967580562e-02, 5.260037193226379e-02, 5.299649976494240e-02, 5.339849158400164e-02, 5.380647966132648e-02,
5.422060027715941e-02, 5.464099387290190e-02, 5.506780521131065e-02, 5.550118354380304e-02, 5.594128278599803e-02,
5.638826170099771e-02, 5.684228409236822e-02, 5.730351900500930e-02, 5.777214093711701e-02, 5.824833006154496e-02,
5.873227245843550e-02, 5.922416035927789e-02, 5.972419240331855e-02, 6.023257390671135e-02, 6.074951714552922e-02,
6.127524165309805e-02, 6.180997453292713e-02, 6.235395078742177e-02, 6.290741366510025e-02, 6.347061502504725e-02,
6.404381572070365e-02, 6.462728600642950e-02, 6.522130596345847e-02, 6.582616595121359e-02, 6.644216708351365e-02,
6.706962173067801e-02, 6.770885405015876e-02, 6.836020054851545e-02, 6.902401067524323e-02, 6.970064744995147e-02,
7.039048812873928e-02, 7.109392490838246e-02, 7.181136567395162e-02, 7.254323478986174e-02, 7.328997394213939e-02,
7.405204303036350e-02, 7.482992111660267e-02, 7.562410743459462e-02, 7.643512246096959e-02, 7.726350905876482e-02,
7.810983369459748e-02, 7.897468773330364e-02, 7.985868882391924e-02, 8.076248237350624e-02, 8.168674312725339e-02,
8.263217685253897e-02, 8.359952214218136e-02, 8.458955234763808e-02, 8.560307764709922e-02, 8.664094726097721e-02,
8.770405183579809e-02, 8.879332600333216e-02, 8.990975112426186e-02, 9.105435824770836e-02, 9.222823130012905e-02,
9.343251051187931e-02, 9.466839612987468e-02, 9.593715241066648e-02, 9.724011194914539e-02, 9.857868036165565e-02,
9.995434135119849e-02, 1.013686622100244e-01, 1.028232997924972e-01, 1.043200070026139e-01, 1.058606398495997e-01,
1.074471651569439e-01, 1.090816689466604e-01, 1.107663656076400e-01, 1.125036079374191e-01, 1.142958981007997e-01,
1.161458997119761e-01, 1.180564510381272e-01, 1.200305795535312e-01, 1.220715180084827e-01, 1.241827220798729e-01,
1.263678899607639e-01, 1.286309839853891e-01, 1.309762546828021e-01, 1.334082674145709e-01, 1.359319320967154e-01,
1.385525363255699e-01, 1.412757824333732e-01, 1.441078289265746e-01, 1.470553370223640e-01, 1.501255230791583e-01,
1.533262175560458e-01, 1.566659318789719e-01, 1.601539339820259e-01, 1.638003344031104e-01, 1.676161840762574e-01,
1.716135864704616e-01, 1.758058259373194e-01, 1.802075151350041e-01, 1.848347654315720e-01, 1.897053841569125e-01,
1.948391038040393e-01, 2.002578490946182e-01, 2.059860506445547e-01, 2.120510130261529e-01, 2.184833502462140e-01,
2.253175032175642e-01, 2.325923566075963e-01, 2.403519793681240e-01, 2.486465186036903e-01, 2.575332842542348e-01,
2.670780780746819e-01, 2.773568211297051e-01, 2.884575825808999e-01, 3.004831077874051e-01, 3.135540067457522e-01,
3.278128156815317e-01, 3.434292159604898e-01, 3.606068021496177e-01, 3.795920373061096e-01, 4.006860971742861e-01,
4.242609931230809e-01, 4.507816611158829e-01, 4.808368643715972e-01, 5.151832674168473e-01, 5.548098809961413e-01,
6.010342738416996e-01, 6.556508252475161e-01, 7.211660049076284e-01, 8.011867377877530e-01, 9.010874494589812e-01,
1.029199766035716e+00, 1.199011029546746e+00, 1.433109190324988e+00, 1.767258115946684e+00, 2.213710600108230e+00,
2.178771019099798e+00, 3.275790025202306e-01,
};

static double _factorial[] = {
        1.0, 1.0, 2.0, 6.0, 24.,
        1.2e+2, 7.2e+2, 5.04e+3, 4.032e+4, 3.6288e+5,
        3.6288e+6, 3.99168e+7, 4.790016e+8, 6.2270208e+9, 8.71782912e+10,
        1.307674368e+12, 2.0922789888e+13, 3.55687428096e+14,
        6.402373705728e+15, 1.21645100408832e+17,
        2.43290200817664e+18, 5.109094217170944e+19,
        1.1240007277776077e+21, 2.5852016738884978e+22,
};

const static double _factorial2[] = {
        1., 1., 2., 3., 8.,
        15., 48., 105., 384., 945.,
        3840., 10395., 46080., 135135., 645120.,
        2027025., 10321920., 34459425., 185794560., 654729075.,
        3715891200., 13749310575., 81749606400., 316234143225., 1961990553600.,
        7905853580625., 51011754393600., 213458046676875.,
        1428329123020800., 6190283353629376.,
        42849873690624000., 1.9189878396251069e+17,
        1.371195958099968e+18, 6.3326598707628524e+18,
        4.6620662575398912e+19, 2.2164309547669976e+20,
        1.6783438527143608e+21, 8.2007945326378929e+21,
        6.3777066403145712e+22, 3.1983098677287775e+23,
};

static double factorial2(int n)
{
        if (n < 0) {
                return 1;
        } else {
                return _factorial2[n];
        }
}

const static double _binom[] = {
        1,
        1, 1,
        1, 2, 1,
        1, 3, 3, 1,
        1, 4, 6, 4, 1,
        1, 5, 10, 10, 5, 1,
        1, 6, 15, 20, 15, 6, 1,
        1, 7, 21, 35, 35, 21, 7, 1,
        1, 8, 28, 56, 70, 56, 28, 8, 1,
        1, 9, 36, 84, 126, 126, 84, 36, 9, 1,};
static double binom(int n, int m)
{
        if (n < 10) {
                return _binom[n*(n+1)/2+m];
        } else {
                return _factorial[n] / (_factorial[m]*_factorial[n-m]);
        }
}

static int _cart_powxyz[] = {
        0, 0, 0, // s
        1, 0, 0,
        0, 1, 0,
        0, 0, 1, // p
        2, 0, 0,
        1, 1, 0,
        1, 0, 1,
        0, 2, 0,
        0, 1, 1,
        0, 0, 2, // d
        3, 0, 0,
        2, 1, 0,
        2, 0, 1,
        1, 2, 0,
        1, 1, 1,
        1, 0, 2,
        0, 3, 0,
        0, 2, 1,
        0, 1, 2,
        0, 0, 3, // f
        4, 0, 0, 3, 1, 0, 3, 0, 1, 2, 2, 0, 2, 1, 1,
        2, 0, 2, 1, 3, 0, 1, 2, 1, 1, 1, 2, 1, 0, 3,
        0, 4, 0, 0, 3, 1, 0, 2, 2, 0, 1, 3, 0, 0, 4, // g
        5, 0, 0, 4, 1, 0, 4, 0, 1, 3, 2, 0, 3, 1, 1,
        3, 0, 2, 2, 3, 0, 2, 2, 1, 2, 1, 2, 2, 0, 3,
        1, 4, 0, 1, 3, 1, 1, 2, 2, 1, 1, 3, 1, 0, 4,
        0, 5, 0, 0, 4, 1, 0, 3, 2, 0, 2, 3, 0, 1, 4,
        0, 0, 5,
        6, 0, 0, 5, 1, 0, 5, 0, 1, 4, 2, 0, 4, 1, 1,
        4, 0, 2, 3, 3, 0, 3, 2, 1, 3, 1, 2, 3, 0, 3,
        2, 4, 0, 2, 3, 1, 2, 2, 2, 2, 1, 3, 2, 0, 4,
        1, 5, 0, 1, 4, 1, 1, 3, 2, 1, 2, 3, 1, 1, 4,
        1, 0, 5, 0, 6, 0, 0, 5, 1, 0, 4, 2, 0, 3, 3,
        0, 2, 4, 0, 1, 5, 0, 0, 6,
        7, 0, 0, 6, 1, 0, 6, 0, 1, 5, 2, 0, 5, 1, 1,
        5, 0, 2, 4, 3, 0, 4, 2, 1, 4, 1, 2, 4, 0, 3,
        3, 4, 0, 3, 3, 1, 3, 2, 2, 3, 1, 3, 3, 0, 4,
        2, 5, 0, 2, 4, 1, 2, 3, 2, 2, 2, 3, 2, 1, 4,
        2, 0, 5, 1, 6, 0, 1, 5, 1, 1, 4, 2, 1, 3, 3,
        1, 2, 4, 1, 1, 5, 1, 0, 6, 0, 7, 0, 0, 6, 1,
        0, 5, 2, 0, 4, 3, 0, 3, 4, 0, 2, 5, 0, 1, 6,
        0, 0, 7,
        8, 0, 0, 7, 1, 0, 7, 0, 1, 6, 2, 0, 6, 1, 1,
        6, 0, 2, 5, 3, 0, 5, 2, 1, 5, 1, 2, 5, 0, 3,
        4, 4, 0, 4, 3, 1, 4, 2, 2, 4, 1, 3, 4, 0, 4,
        3, 5, 0, 3, 4, 1, 3, 3, 2, 3, 2, 3, 3, 1, 4,
        3, 0, 5, 2, 6, 0, 2, 5, 1, 2, 4, 2, 2, 3, 3,
        2, 2, 4, 2, 1, 5, 2, 0, 6, 1, 7, 0, 1, 6, 1,
        1, 5, 2, 1, 4, 3, 1, 3, 4, 1, 2, 5, 1, 1, 6,
        1, 0, 7, 0, 8, 0, 0, 7, 1, 0, 6, 2, 0, 5, 3,
        0, 4, 4, 0, 3, 5, 0, 2, 6, 0, 1, 7, 0, 0, 8,
        9, 0, 0, 8, 1, 0, 8, 0, 1, 7, 2, 0, 7, 1, 1,
        7, 0, 2, 6, 3, 0, 6, 2, 1, 6, 1, 2, 6, 0, 3,
        5, 4, 0, 5, 3, 1, 5, 2, 2, 5, 1, 3, 5, 0, 4,
        4, 5, 0, 4, 4, 1, 4, 3, 2, 4, 2, 3, 4, 1, 4,
        4, 0, 5, 3, 6, 0, 3, 5, 1, 3, 4, 2, 3, 3, 3,
        3, 2, 4, 3, 1, 5, 3, 0, 6, 2, 7, 0, 2, 6, 1,
        2, 5, 2, 2, 4, 3, 2, 3, 4, 2, 2, 5, 2, 1, 6,
        2, 0, 7, 1, 8, 0, 1, 7, 1, 1, 6, 2, 1, 5, 3,
        1, 4, 4, 1, 3, 5, 1, 2, 6, 1, 1, 7, 1, 0, 8,
        0, 9, 0, 0, 8, 1, 0, 7, 2, 0, 6, 3, 0, 5, 4,
        0, 4, 5, 0, 3, 6, 0, 2, 7, 0, 1, 8, 0, 0, 9,
        10, 0, 0, 9, 1, 0, 9, 0, 1, 8, 2, 0, 8, 1, 1,
        8, 0, 2, 7, 3, 0, 7, 2, 1, 7, 1, 2, 7, 0, 3,
        6, 4, 0, 6, 3, 1, 6, 2, 2, 6, 1, 3, 6, 0, 4,
        5, 5, 0, 5, 4, 1, 5, 3, 2, 5, 2, 3, 5, 1, 4,
        5, 0, 5, 4, 6, 0, 4, 5, 1, 4, 4, 2, 4, 3, 3,
        4, 2, 4, 4, 1, 5, 4, 0, 6, 3, 7, 0, 3, 6, 1,
        3, 5, 2, 3, 4, 3, 3, 3, 4, 3, 2, 5, 3, 1, 6,
        3, 0, 7, 2, 8, 0, 2, 7, 1, 2, 6, 2, 2, 5, 3,
        2, 4, 4, 2, 3, 5, 2, 2, 6, 2, 1, 7, 2, 0, 8,
        1, 9, 0, 1, 8, 1, 1, 7, 2, 1, 6, 3, 1, 5, 4,
        1, 4, 5, 1, 3, 6, 1, 2, 7, 1, 1, 8, 1, 0, 9,
        0, 10, 0, 0, 9, 1, 0, 8, 2, 0, 7, 3, 0, 6, 4,
        0, 5, 5, 0, 4, 6, 0, 3, 7, 0, 2, 8, 0, 1, 9,
        0, 0, 10,
        11, 0, 0, 10, 1, 0, 10, 0, 1, 9, 2, 0, 9, 1, 1,
        9, 0, 2, 8, 3, 0, 8, 2, 1, 8, 1, 2, 8, 0, 3,
        7, 4, 0, 7, 3, 1, 7, 2, 2, 7, 1, 3, 7, 0, 4,
        6, 5, 0, 6, 4, 1, 6, 3, 2, 6, 2, 3, 6, 1, 4,
        6, 0, 5, 5, 6, 0, 5, 5, 1, 5, 4, 2, 5, 3, 3,
        5, 2, 4, 5, 1, 5, 5, 0, 6, 4, 7, 0, 4, 6, 1,
        4, 5, 2, 4, 4, 3, 4, 3, 4, 4, 2, 5, 4, 1, 6,
        4, 0, 7, 3, 8, 0, 3, 7, 1, 3, 6, 2, 3, 5, 3,
        3, 4, 4, 3, 3, 5, 3, 2, 6, 3, 1, 7, 3, 0, 8,
        2, 9, 0, 2, 8, 1, 2, 7, 2, 2, 6, 3, 2, 5, 4,
        2, 4, 5, 2, 3, 6, 2, 2, 7, 2, 1, 8, 2, 0, 9,
        1, 10, 0, 1, 9, 1, 1, 8, 2, 1, 7, 3, 1, 6, 4,
        1, 5, 5, 1, 4, 6, 1, 3, 7, 1, 2, 8, 1, 1, 9,
        1, 0, 10, 0, 11, 0, 0, 10, 1, 0, 9, 2, 0, 8, 3,
        0, 7, 4, 0, 6, 5, 0, 5, 6, 0, 4, 7, 0, 3, 8,
        0, 2, 9, 0, 1, 10, 0, 0, 11,
        12, 0, 0, 11, 1, 0, 11, 0, 1, 10, 2, 0, 10, 1, 1,
        10, 0, 2, 9, 3, 0, 9, 2, 1, 9, 1, 2, 9, 0, 3,
        8, 4, 0, 8, 3, 1, 8, 2, 2, 8, 1, 3, 8, 0, 4,
        7, 5, 0, 7, 4, 1, 7, 3, 2, 7, 2, 3, 7, 1, 4,
        7, 0, 5, 6, 6, 0, 6, 5, 1, 6, 4, 2, 6, 3, 3,
        6, 2, 4, 6, 1, 5, 6, 0, 6, 5, 7, 0, 5, 6, 1,
        5, 5, 2, 5, 4, 3, 5, 3, 4, 5, 2, 5, 5, 1, 6,
        5, 0, 7, 4, 8, 0, 4, 7, 1, 4, 6, 2, 4, 5, 3,
        4, 4, 4, 4, 3, 5, 4, 2, 6, 4, 1, 7, 4, 0, 8,
        3, 9, 0, 3, 8, 1, 3, 7, 2, 3, 6, 3, 3, 5, 4,
        3, 4, 5, 3, 3, 6, 3, 2, 7, 3, 1, 8, 3, 0, 9,
        2, 10, 0, 2, 9, 1, 2, 8, 2, 2, 7, 3, 2, 6, 4,
        2, 5, 5, 2, 4, 6, 2, 3, 7, 2, 2, 8, 2, 1, 9,
        2, 0, 10, 1, 11, 0, 1, 10, 1, 1, 9, 2, 1, 8, 3,
        1, 7, 4, 1, 6, 5, 1, 5, 6, 1, 4, 7, 1, 3, 8,
        1, 2, 9, 1, 1, 10, 1, 0, 11, 0, 12, 0, 0, 11, 1,
        0, 10, 2, 0, 9, 3, 0, 8, 4, 0, 7, 5, 0, 6, 6,
        0, 5, 7, 0, 4, 8, 0, 3, 9, 0, 2, 10, 0, 1, 11,
        0, 0, 12,
};
static int _offset_cart[] = {0, 1, 4, 10, 20, 35, 56, 84, 120,
                             165, 220, 286, 364, 455, 560};
#define LOOP_CART(l, i, pxyz)   pxyz = _cart_powxyz + _offset_cart[l] * 3; \
                        for (i = 0; i < _offset_cart[l+1]-_offset_cart[l]; i++, pxyz+=3)
#define LOOP_XYZ(i, j, k, pxyz) \
        for (i = 0; i <= pxyz[0]; i++) \
        for (j = 0; j <= pxyz[1]; j++) \
        for (k = 0; k <= pxyz[2]; k++)


/*
 * exponentially scaled modified spherical Bessel function of the first kind
 * scipy.special.sph_in(order, z) * numpy.exp(-z)
 *
 * JCC, 27, 1009
 */
void ECPsph_ine(double *out, int order, double z)
{
        int i, k;
        if (z < 1e-7) {
                // (1-z) * z^l / (2l+1)!!
                out[0] = 1. - z;
                for (i = 1; i <= order; i++) {
                        out[i] = out[i-1] * z / (i*2+1);
                }
        } else if (z > 16) {
                // R_l(z) = \sum_k (l+k)!/(k!(l-k)!(2x)^k)
                double z2 = -.5 / z;
                double ti;
                for (i = 0; i <= order; i++) {
                        ti = .5 / z;
                        out[i] = ti;
                        for (k = 1; k <= i; k++) {
                                ti *= z2;
                                out[i] += ti * _factorial[i+k]
                                        / (_factorial[k] * _factorial[i-k]);
                        }
                }
        } else {
                // z^l e^{-z} \sum (z^2/2)^k/(k!(2k+2l+1)!!)
                double z2 = .5 * z * z;
                double t0 = exp(-z);
                double ti, next;
                for (i = 0; i <= order; i++) {
                        ti = t0;
                        out[i] = ti;
                        for (k = 1;; k++) {
                                ti *= z2 / (k * (k*2+i*2+1));
                                next = out[i] + ti;
                                if (next == out[i]) {
                                        break;
                                } else {
                                        out[i] = next;
                                }
                        }
                        t0 *= z/(i*2+3);  // k = 0
                }
        }

}


static const double _l2[] = { // l/(2l+1)
        0., 1./3, 2./5, 3./7, 4./9, 5./11, 6./13, 7./15,
        8./17, 9./19, 10./21, 11./23, 12./25, 13./27,
        14./29, 15./31, 16./33, 17./35, 18./37, 19./39,
        20./41, 21./43, 22./45, 23./47,
};
void ECPsph_ine_opt(double *out, int order, double z)
{
        if (z < 1e-7 || z > 16) {
                return ECPsph_ine(out, order, z);
        } else {
                /*
                 * j_n' = j_{n-1} - (n+1)/z j_n = j_{n+1} + n/z j_n
                 *      => n/(2n+1) j_{n-1} + (n+1)/(2n+1) j_{n+1}
                 * K_n' = n/(2n+1) K_{n-1} + (n+1)/(2n+1) K_{n+1} - K_n
                 */
                int i, j;
                double buf[K_TAB_COL*2];
                double *k0 = buf;
                double *k1 = buf + K_TAB_COL;
                double *tmp;
                int idx = (int)floor(z/K_TAB_INTERVAL);
                double *tabu = _sph_ine_tab + idx * K_TAB_COL;
                double z0 = idx*K_TAB_INTERVAL + K_TAB_INTERVAL/2;
                double dz = z - z0;

                for (i = 0; i <= order+K_TAYLOR_MAX; i++) {
                        k0[i] = tabu[i];
                }
                for (i = 0; i <= order; i++) {
                        out[i] = k0[i];
                }

                double fac = 1;
                for (j = 1; j <= K_TAYLOR_MAX; j++) {
                        k1[0] = k0[1] - k0[0];
                        for (i = 1; i <= order+K_TAYLOR_MAX-j; i++) {
                                k1[i] = _l2[i]*k0[i-1] + (1-_l2[i])*k0[i+1] - k0[i];
                        }
                        fac *= dz/j;
                        for (i = 0; i <= order; i++) {
                                out[i] += k1[i] * fac;
                        }
                        tmp = k0;
                        k0 = k1;
                        k1 = tmp;
                }
        }
}

void ECPsph_ine_a(double *out, int order, double *zs, int n)
{
        int i;
        for (i = 0; i < n; i++) {
                ECPsph_ine(out, order, zs[i]);
                out += order+1;
        }
}

void ECPgauss_chebyshev(double *rs, double *ws, int n)
{
        int i;
        double step = 1./(n+1);
        double fac = 16 * step / 3;
        double xinc = M_PI * step;
        double x1 = 0;
        double x2, x3, x4, xi;
        for (i = 0; i < n; i++) {
                x1 += xinc;
                x2 = sin(x1);
                x3 = sin(x1*2);
                x4 = x2 * x2;
                xi = (n-i*2-1) * step + M_1_PI * (1+2./3.*x4) * x3;
                rs[i] = 1 - log(1+xi) * M_LOG2E;  // 1/ln2
                ws[i] = fac * x4 * x4 * M_LOG2E / (1+xi);
        }
}

/*
 * Return the number of effective grids
 */
int ECPrad_part_step(double *ur, double *rs, int nrs, int step,
                     int *ecpshls, int *ecpbas,
                     int *atm, int natm, int *bas, int nbas, double *env)
{
        double ubuf[nrs];
        double r2[nrs];
        double *ak, *ck;
        int npk;
        int ish, i, kp;
        int nrs_now;
        int nrs_max = 0;

        for (i = 0; i < nrs; i++) {
                r2[i] = rs[i] * rs[i];
                ur[i] = 0;
        }

        for (ish = 0; ecpshls[ish] != -1; ish++) {
                npk = ecpbas[ecpshls[ish]*BAS_SLOTS+NPRIM_OF];
                ak = env + ecpbas[ecpshls[ish]*BAS_SLOTS+PTR_EXP];
                ck = env + ecpbas[ecpshls[ish]*BAS_SLOTS+PTR_COEFF];

                for (i = 0; i < nrs; i++) {
                        ubuf[i] = ck[0] * exp(-ak[0]*r2[i]);
                        for (kp = 1; kp < npk; kp++) {
                                ubuf[i] += ck[kp] * exp(-ak[kp]*r2[i]);
                        }
                        if (i > 2 &&
                            fabs(ubuf[i]) < SIM_ZERO &&
                            fabs(ubuf[i-1]) < SIM_ZERO) {
                                break;
                        }
                }
                nrs_now = i;
                nrs_max = MAX(nrs_max, nrs_now);
                switch (ecpbas[ecpshls[ish]*BAS_SLOTS+RADI_POWER]) {
                case 1:
                        for (i = 0; i < nrs_now; i++) {
                                ubuf[i] *= rs[i];
                        }
                        break;
                case 2:
                        for (i = 0; i < nrs_now; i++) {
                                ubuf[i] *= r2[i];
                        }
                        break;
                case 3:
                        for (i = 0; i < nrs_now; i++) {
                                ubuf[i] *= r2[i] * rs[i];
                        }
                        break;
                }

                for (i = 0; i < nrs_now; i++) {
                        ur[i] += ubuf[i];
                }
        }
        return nrs_max;
}

int ECPrad_part(double *ur, double *rs, int nrs, int inc,
                int *ecpshls, int *ecpbas,
                int *atm, int natm, int *bas, int nbas, double *env)
{
        double ubuf[nrs];
        double r2[nrs];
        double *ak, *ck;
        int npk;
        int ish, i, kp;
        int nrs_now;
        int nrs_max = 0;

        for (i = 0; i < nrs; i++) {
                r2[i] = rs[i*inc] * rs[i*inc];
                ur[i] = 0;
        }

        for (ish = 0; ecpshls[ish] != -1; ish++) {
                npk = ecpbas[ecpshls[ish]*BAS_SLOTS+NPRIM_OF];
                ak = env + ecpbas[ecpshls[ish]*BAS_SLOTS+PTR_EXP];
                ck = env + ecpbas[ecpshls[ish]*BAS_SLOTS+PTR_COEFF];

                for (i = 0; i < nrs; i++) {
                        ubuf[i] = ck[0] * exp(-ak[0]*r2[i]);
                        for (kp = 1; kp < npk; kp++) {
                                ubuf[i] += ck[kp] * exp(-ak[kp]*r2[i]);
                        }
                        if (i > 2 &&
                            fabs(ubuf[i]) < SIM_ZERO &&
                            fabs(ubuf[i-1]) < SIM_ZERO) {
                                break;
                        }
                }
                nrs_now = i;
                nrs_max = MAX(nrs_max, nrs_now);
                switch (ecpbas[ecpshls[ish]*BAS_SLOTS+RADI_POWER]) {
                case 1:
                        for (i = 0; i < nrs_now; i++) {
                                ubuf[i] *= rs[i*inc];
                        }
                        break;
                case 2:
                        for (i = 0; i < nrs_now; i++) {
                                ubuf[i] *= r2[i];
                        }
                        break;
                case 3:
                        for (i = 0; i < nrs_now; i++) {
                                ubuf[i] *= r2[i] * rs[i*inc];
                        }
                        break;
                }

                for (i = 0; i < nrs_now; i++) {
                        ur[i] += ubuf[i];
                }
        }
        return nrs_max;
}

static double int_unit_xyz(int i, int j, int k)
{
        if (i % 2 || j % 2 || k % 2) {
                return 0;
        } else {
                return (factorial2(i-1) * factorial2(j-1) *
                        factorial2(k-1) / factorial2(i+j+k+1));
        }
}
/*
 * Angular part integration then transform back to cartesian basis
 */
double *CINTc2s_bra_sph(double *gsph, int nket, double *gcart, int l);
double *CINTs2c_bra_sph(double *gsph, int nket, double *gcart, int l);
static void ang_nuc_in_cart(double *omega, int l, double *r)
{
        double buf[CART_MAX];
        double xx[16];
        double yy[16];
        double zz[16];
        int i, j, k, n;

        switch (l) {
        case 0:
                omega[0] = 0.07957747154594767;
                break;
        case 1:
                omega[0] = r[0] * 0.2387324146378430;
                omega[1] = r[1] * 0.2387324146378430;
                omega[2] = r[2] * 0.2387324146378430;
                break;
        default:
                xx[0] = 1;
                yy[0] = 1;
                zz[0] = 1;
                for (i = 1; i <= l; i++) {
                        xx[i] = xx[i-1] * r[0];
                        yy[i] = yy[i-1] * r[1];
                        zz[i] = zz[i-1] * r[2];
                }
                for (n = 0, i = l; i >= 0; i--) {
                        for (j = l-i; j >= 0; j--, n++) {
                                k = l - i - j;
                                omega[n] = xx[i] * yy[j] * zz[k];
                        }
                }
                CINTc2s_bra_sph(buf, 1, omega, l);
                CINTs2c_bra_sph(buf, 1, omega, l);
        }
}

static void cache_3dfac(double *facs, int l, double *r)
{
        int l1 = l + 1;
        double *facx = facs;
        double *facy = facs + l1*l1;
        double *facz = facy + l1*l1;
        double xx[16];
        double yy[16];
        double zz[16];
        double bfac;
        int i, j, off;
        xx[0] = 1;
        yy[0] = 1;
        zz[0] = 1;
        for (i = 1; i <= l; i++) {
                xx[i] = xx[i-1] * r[0];
                yy[i] = yy[i-1] * r[1];
                zz[i] = zz[i-1] * r[2];
        }
        for (i = 0; i <= l; i++) {
                for (j = 0; j <= i; j++) {
                        bfac = binom(i,j);
                        off = i*l1+j;
                        facx[off] = bfac * xx[i-j];
                        facy[off] = bfac * yy[i-j];
                        facz[off] = bfac * zz[i-j];
                }
        }
}

void type2_facs_ang(double *facs, int li, int lc, double *ri)
{
        double unitr[3];
        if (ri[0] == 0 && ri[1] == 0 && ri[2] == 0) {
                unitr[0] = 0;
                unitr[1] = 0;
                unitr[2] = 0;
        } else {
                double norm_ri = -1/sqrt(SQUARE(ri));
                unitr[0] = ri[0] * norm_ri;
                unitr[1] = ri[1] * norm_ri;
                unitr[2] = ri[2] * norm_ri;
        }

        const int li1 = li + 1;
        const int dlc = lc * 2 + 1;
        const int dlambda = li + lc + 1;
        double omega_nuc[CART_CUM];
        double *pnuc;
        int m, n, i, j, k, lmb, mi;
        for (i = 0; i <= li+lc; i++) {
                pnuc = omega_nuc + _offset_cart[i];
                ang_nuc_in_cart(pnuc, i, unitr);
        }
        for (i = 0; i < _offset_cart[li+lc+1]; i++) {
                omega_nuc[i] *= 4 * M_PI;
        }

        double buf[CART_MAX];
        double omega[li1*li1*li1*dlambda*dlc];
        double *pomega;
        int dlclmb = dlambda * dlc;
        int need_even;
        int need_odd;
        int *puvw, *prst;
        for (i = 0; i <= li; i++) {
        for (j = 0; j <= li-i; j++) {
        for (k = 0; k <= li-i-j; k++) {
                // use need_even to ensure (lc+a+b+c+lmb) is even
                need_even = (lc+i+j+k)%2;
                pomega = omega + (i*li1*li1+j*li1+k)*dlclmb+need_even*dlc;
                for (lmb = need_even; lmb <= li+lc; lmb+=2) {
                        pnuc = omega_nuc + _offset_cart[lmb];
                        LOOP_CART(lc, m, puvw) {
                                buf[m] = 0;
                                LOOP_CART(lmb, n, prst) {
                                        buf[m] += pnuc[n] *
                                                int_unit_xyz(i+puvw[0]+prst[0],
                                                             j+puvw[1]+prst[1],
                                                             k+puvw[2]+prst[2]);
                                }
                        }
                        switch (lc) {
                        case 0:
                                pomega[0] = buf[0] * 0.282094791773878143;
                                break;
                        case 1:
                                pomega[0] = buf[0] * 0.488602511902919921;
                                pomega[1] = buf[1] * 0.488602511902919921;
                                pomega[2] = buf[2] * 0.488602511902919921;
                                break;
                        default:
                                CINTc2s_bra_sph(pomega, 1, buf, lc);
                        }
                        pomega += dlc*2;
                }

                need_odd = need_even ^ 1;
                pomega = omega + (i*li1*li1+j*li1+k)*dlclmb+need_odd*dlc;
                for (lmb = need_odd; lmb <= li+lc; lmb+=2) {
                        for (m = 0; m < dlc; m++) {
                                pomega[m] = 0;
                        }
                        pomega += dlc*2;
                }
        } } }

        const int nfi = _offset_cart[li+1]-_offset_cart[li];//(li+1)*(li+2)/2;
        double fac3d[3*li1*li1];
        double *fac3dx = fac3d;
        double *fac3dy = fac3dx + li1*li1;
        double *fac3dz = fac3dy + li1*li1;
        double *pfacs;
        double fac;
        cache_3dfac(fac3d, li, ri);

        for (i = 0; i < li1*nfi*dlclmb; i++) { facs[i] = 0; }
        LOOP_CART(li, mi, prst) {
                LOOP_XYZ(i, j, k, prst) {
                        need_even = (lc+i+j+k)%2;
                        fac = fac3dx[prst[0]*li1+i] * fac3dy[prst[1]*li1+j] *
                              fac3dz[prst[2]*li1+k];
                        pomega = omega + (i*li1*li1+j*li1+k)*dlclmb;
                        pfacs = facs + ((i+j+k)*nfi+mi)*dlclmb;
                        for (m = 0; m < dlc; m++) {
                        for (n = need_even; n < dlambda; n+=2) {
                                pfacs[m*dlambda+n] += fac * pomega[n*dlc+m];
                        } }
                }
        }
}

void type2_facs_rad(double *facs, int ish, int lc, double rca,
                    double *rs, int nrs, int inc,
                    int *atm, int natm, int *bas, int nbas, double *env)
{
        const int li = bas[ANG_OF  +ish*BAS_SLOTS];
        const int np = bas[NPRIM_OF+ish*BAS_SLOTS];
        const int nc = bas[NCTR_OF +ish*BAS_SLOTS];
        const double *ai = env + bas[PTR_EXP+ish*BAS_SLOTS];
        const double *ci = env + bas[PTR_COEFF+ish*BAS_SLOTS];
        int ip, i, j;
        double ka;
        double r2[nrs];
        double buf[np*nrs*(li+lc+1)];
        double t1;
        double *pbuf = buf;

        for (i = 0; i < nrs; i++) {
                t1 = rs[i*inc] - rca;
                r2[i] = -t1 * t1;
        }
        for (ip = 0; ip < np; ip++) {
                ka = 2 * ai[ip] * rca;
                for (i = 0; i < nrs; i++) {
                        t1 = exp(r2[i] * ai[ip]);
                        ECPsph_ine_opt(pbuf, li+lc, ka*rs[i*inc]);
                        for (j = 0; j <= li+lc; j++) {
                                pbuf[j] *= t1;
                        }
                        pbuf += li + lc + 1;
                }
        }

        const double D0 = 0;
        const double D1 = 1;
        const char TRANS_N = 'N';
        const int m = nrs * (li+lc+1);
        dgemm_(&TRANS_N, &TRANS_N, &m, &nc, &np,
               &D1, buf, &m, ci, &np, &D0, facs, &m);
}

void type1_static_facs(double *facs, int li, double *ri)
{
        const int d1 = li + 1;
        const int d2 = d1 * d1;
        const int d3 = d2 * d1;
        double fac3d[3*d1*d1];
        double *fac3dx = fac3d;
        double *fac3dy = fac3dx + d1*d1;
        double *fac3dz = fac3dy + d1*d1;
        double *pfacs;
        cache_3dfac(fac3d, li, ri);
        int mi, i, j, k;
        int *pxyz;

        LOOP_CART(li, mi, pxyz) {
                pfacs = facs + mi * d3;
                LOOP_XYZ(i, j, k, pxyz) {
                        pfacs[i*d2+j*d1+k] = fac3dx[pxyz[0]*d1+i]
                                           * fac3dy[pxyz[1]*d1+j]
                                           * fac3dz[pxyz[2]*d1+k];
                }
        }
}

void type1_rad_ang(double *rad_ang, int lmax, double *r, double *rad_all)
{
        double unitr[3];
        if (r[0] == 0 && r[1] == 0 && r[2] == 0) {
                unitr[0] = 0;
                unitr[1] = 0;
                unitr[2] = 0;
        } else {
                double norm_r = -1/sqrt(SQUARE(r));
                unitr[0] = r[0] * norm_r;
                unitr[1] = r[1] * norm_r;
                unitr[2] = r[2] * norm_r;
        }

        double omega_nuc[CART_CUM];
        double *pnuc;
        int n, i, j, k, lmb;
        for (i = 0; i <= lmax; i++) {
                pnuc = omega_nuc + _offset_cart[i];
                ang_nuc_in_cart(pnuc, i, unitr);
        }

        const int d1 = lmax + 1;
        const int d2 = d1 * d1;
        const int d3 = d2 * d1;
        int need_even;
        double tmp;
        int *prst;
        double *pout, *prad;
        for (i = 0; i < d3; i++) { rad_ang[i] = 0; }
        for (i = 0; i <= lmax; i++) {
        for (j = 0; j <= lmax-i; j++) {
        for (k = 0; k <= lmax-i-j; k++) {
                pout = rad_ang + i*d2+j*d1+k;
                prad = rad_all + (i+j+k)*d1;
                // need_even to ensure (a+b+c+lmb) is even
                need_even = (i+j+k)%2;
                for (lmb = need_even; lmb <= lmax; lmb+=2) {
                        tmp = 0;
                        pnuc = omega_nuc + _offset_cart[lmb];
                        LOOP_CART(lmb, n, prst) {
                                tmp += pnuc[n] * int_unit_xyz(i+prst[0],
                                                              j+prst[1],
                                                              k+prst[2]);
                        }
                        *pout += prad[lmb] * tmp;
                }
        } } }
}

static void search_ecpatms(int *ecpatmlst, int *ecpbas, int necpbas)
{
        int i, j, atm_id;
        int necpatm = 0;
        for (i = 0; i < necpbas; i++) {
                atm_id = ecpbas[ATOM_OF+i*BAS_SLOTS];
                for (j = 0; j < necpatm; j++) {
                        if (atm_id == ecpatmlst[j]) {
                                goto next_expbas;
                        }
                }
                ecpatmlst[necpatm] = atm_id;
                necpatm += 1;
next_expbas:;
        }
        ecpatmlst[necpatm] = -1;
}

static void search_ecpshls(int *ecpshls, int atm_id, int lc,
                           int *ecpbas, int necpbas)
{
        int i, k;
        for (k = 0, i = 0; i < necpbas; i++) {
                if (ecpbas[ATOM_OF+i*BAS_SLOTS] == atm_id &&
                    ecpbas[ANG_OF +i*BAS_SLOTS] == lc) {
                        ecpshls[k] = i;
                        k++;
                }
        }
        ecpshls[k] = -1;
}

static double distance_square(const double *r1, const double *r2)
{
        double r12[3];
        r12[0] = r1[0] - r2[0];
        r12[1] = r1[1] - r2[1];
        r12[2] = r1[2] - r2[2];
        return SQUARE(r12);
}

static int check_3c_overlap(int *shls, int *atm, int *bas, double *env,
                            double *rc, int *ecpshls, int *ecpbas)
{
        const int ish = shls[0];
        const int jsh = shls[1];
        const int iprim = bas[NPRIM_OF+ish*BAS_SLOTS];
        const int jprim = bas[NPRIM_OF+jsh*BAS_SLOTS];
        const double *ai = env + bas[PTR_EXP+ish*BAS_SLOTS];
        const double *aj = env + bas[PTR_EXP+jsh*BAS_SLOTS];
        const double *ri = env + atm[PTR_COORD+bas[ATOM_OF+ish*BAS_SLOTS]*ATM_SLOTS];
        const double *rj = env + atm[PTR_COORD+bas[ATOM_OF+jsh*BAS_SLOTS]*ATM_SLOTS];
        double rrab = distance_square(ri, rj);
        double rrca = distance_square(rc, ri);
        double rrcb = distance_square(rc, rj);
        double aiaj, ajak, aiak, aijk, eijk;
        double *ak;
        int csh, ip, jp, kp, kprim;

        for (csh = 0; ecpshls[csh] != -1; csh++) {
                kprim = ecpbas[ecpshls[csh]*BAS_SLOTS+NPRIM_OF];
                ak = env + ecpbas[ecpshls[csh]*BAS_SLOTS+PTR_EXP];

                for (kp = 0; kp < kprim; kp++) {
                for (jp = 0; jp < jprim; jp++) {
                for (ip = 0; ip < iprim; ip++) {
                        aijk = ai[ip] + aj[jp] + ak[kp];
                        aiaj = ai[ip] * aj[jp] * rrab;
                        aiak = ai[ip] * ak[kp] * rrca;
                        ajak = aj[jp] * ak[kp] * rrcb;
                        eijk = (aiaj+aiak+ajak) / aijk;
                        if (eijk < EXPCUTOFF) {
                                return 1;
                        }
                } } }
        }
        return 0;
}

int ECPtype2_cart(double *gctr, int *shls, int *ecpbas, int necpbas,
                  int *atm, int natm, int *bas, int nbas, double *env, double *cache)
{
        const int ish = shls[0];
        const int jsh = shls[1];
        const int li = bas[ANG_OF+ish*BAS_SLOTS];
        const int lj = bas[ANG_OF+jsh*BAS_SLOTS];
        const int nci = bas[NCTR_OF+ish*BAS_SLOTS];
        const int ncj = bas[NCTR_OF+jsh*BAS_SLOTS];
        const int nfi = (li+1) * (li+2) / 2;
        const int nfj = (lj+1) * (lj+2) / 2;
        const int di = nfi * nci;
        const double *ri = env + atm[PTR_COORD+bas[ATOM_OF+ish*BAS_SLOTS]*ATM_SLOTS];
        const double *rj = env + atm[PTR_COORD+bas[ATOM_OF+jsh*BAS_SLOTS]*ATM_SLOTS];

        int nrs = 1 << LEVEL_MAX;
        int ecpatmlst[natm+1];
        search_ecpatms(ecpatmlst, ecpbas, necpbas);

        const double D0 = 0;
        const double D1 = 1;
        const char TRANS_N = 'N';
        const char TRANS_T = 'T';
        const double common_fac = CINTcommon_fac_sp(li) *
                                  CINTcommon_fac_sp(lj) * 16 * M_PI * M_PI;
        int ecpshls[necpbas+1];
        int ia, atm_id, lc, lab, lilc1, ljlc1, lilj1, dlc, im, mq;
        int i, j, n, ic, jc;
        int d2, d3;
        double ur[nrs];
        double rur[nrs*(li+lj+1)];
        double radi[nci*(li+ECP_LMAX+1)*nrs];
        double radj[ncj*(lj+ECP_LMAX+1)*nrs];
        double angi[(li+1)*nfi*(ECP_LMAX*2+1)*(li+ECP_LMAX+1)];
        double angj[(lj+1)*nfj*(ECP_LMAX*2+1)*(lj+ECP_LMAX+1)];
        double rad_all[nci*ncj*(li+lj+1)*(li+ECP_LMAX+1)*(lj+ECP_LMAX+1)];
        double rca[3];
        double rcb[3];
        double buf[nfi*(ECP_LMAX*2+1)*(lj+ECP_LMAX+1)];
        double dca, dcb;
        double *rc, *pradi, *pradj, *prur;
        int has_value;

        for (i = 0; i < nci*ncj*nfi*nfj; i++) { gctr[i] = 0; }

        for (ia = 0; ecpatmlst[ia] != -1; ia++) {
                atm_id = ecpatmlst[ia];
                rc = env + atm[PTR_COORD+atm_id*ATM_SLOTS];
                for (lc = 0; lc <= ECP_LMAX; lc++) { // upto g function
                        search_ecpshls(ecpshls, atm_id, lc, ecpbas, necpbas);
                        if (ecpshls[0] == -1) {
                                continue;
                        }
        if (!check_3c_overlap(shls, atm, bas, env, rc, ecpshls, ecpbas)) {
                continue;
        }

        has_value = 1;
        rca[0] = rc[0] - ri[0];
        rca[1] = rc[1] - ri[1];
        rca[2] = rc[2] - ri[2];
        rcb[0] = rc[0] - rj[0];
        rcb[1] = rc[1] - rj[1];
        rcb[2] = rc[2] - rj[2];
        dca = sqrt(SQUARE(rca));
        dcb = sqrt(SQUARE(rcb));

        dlc = lc * 2 + 1;
        lilj1 = li + lj + 1;
        lilc1 = li + lc + 1;
        ljlc1 = lj + lc + 1;
        d2 = lilc1 * ljlc1;
        d3 = lilj1 * d2;
        im = nfi * dlc;
        mq = dlc * ljlc1;

        int level, nrs0, start, step, ijl;
        double wtscale;
        double *prad;
        double plast[d2];
        char converged[nci*ncj*lilj1];
        char all_conv;
        double *rs = rs_gauss_chebyshev2047;
        double *ws = ws_gauss_chebyshev2047;
        for (i = 0; i < nci*ncj*lilj1; i++) { converged[i] = 0; }
        for (i = 0; i < nci*ncj*d3; i++) { rad_all[i] = 0; }
        nrs0 = (1 << LEVEL0) - 1;
        step = 1 << (LEVEL_MAX - LEVEL0);
        start = step - 1;
        wtscale = step;
        for (level = LEVEL0; level <= LEVEL_MAX; level++) {
                nrs = ECPrad_part(ur, rs+start, nrs0, step, ecpshls, ecpbas,
                                  atm, natm, bas, nbas, env);
                for (i = 0; i < nrs; i++) {
                        ur[i] *= ws[start+i*step] * wtscale;
                        rur[i] = ur[i];
                        for (lab = 1; lab <= li+lj; lab++) {
                                rur[nrs*lab+i] = rur[nrs*(lab-1)+i] * rs[start+i*step];
                        }
                }

                type2_facs_rad(radi, ish, lc, dca, rs+start, nrs, step,
                               atm, natm, bas, nbas, env);
                type2_facs_rad(radj, jsh, lc, dcb, rs+start, nrs, step,
                               atm, natm, bas, nbas, env);
                all_conv = 1;
                for (ijl = 0, ic = 0; ic < nci; ic++) {
                for (jc = 0; jc < ncj; jc++) {
                        pradi = radi + ic * nrs * lilc1;
                        pradj = radj + jc * nrs * ljlc1;
                        for (lab = 0; lab <= li+lj; lab++, ijl++) {
                                if (!converged[ijl]) {
                                        prur = rur + lab * nrs;
                                        prad = rad_all + ijl*d2;
                                        for (i = 0; i < d2; i++) {
                                                plast[i] = prad[i];
                                                prad[i] *= .5;
                                        }

                                        for (n = 0; n < nrs; n++) {
                                        for (i = 0; i < lilc1; i++) {
                                        for (j = 0; j < ljlc1; j++) {
                                                prad[i*ljlc1+j] += prur[n] *
                                                        pradi[n*lilc1+i] * pradj[n*ljlc1+j];
                                        } } }

                                        for (i = 0; i < d2; i++) {
                                                if (CLOSE_ENOUGH(plast[i],prad[i])) {
                                                        converged[ijl] = 0;
                                                        all_conv = 0;
                                                        break;
                                                }
                                        }
                                }
                        }
                } }

                if (all_conv) {
                        break;
                } else {
                        nrs0 = (1 << level) - 1;
                        step = 1 << (LEVEL_MAX - level);
                        start = (start - 1) / 2;
                        wtscale *= .5;
                }
        }

        type2_facs_ang(angi, li, lc, rca);
        type2_facs_ang(angj, lj, lc, rcb);
        for (ic = 0; ic < nci; ic++) {
        for (jc = 0; jc < ncj; jc++) {
                prad = rad_all + (ic*ncj+jc)*d3;
                for (i = 0; i <= li; i++) {
                for (j = 0; j <= lj; j++) {
                        dgemm_(&TRANS_N, &TRANS_N, &ljlc1, &im, &lilc1,
                               &D1, prad+(i+j)*d2, &ljlc1,
                               angi+i*nfi*dlc*lilc1, &lilc1, &D0, buf, &ljlc1);
                        dgemm_(&TRANS_T, &TRANS_N, &nfi, &nfj, &mq,
                               &common_fac, buf, &mq, angj+j*nfj*dlc*ljlc1, &mq,
                               &D1, gctr+jc*nfj*di+ic*nfi, &di);
                } }
        } }
                }
        }
        return has_value;
}

static void scale_coeff(double *cei, const double *ci, const double *ai,
                        const double r2ca, const int npi, const int nci, const int li)
{
        int ip, ic;
        double tmp;
        double common_fac = CINTcommon_fac_sp(li) * 4 * M_PI;
        for (ip = 0; ip < npi; ip++) {
                tmp = exp(-ai[ip] * r2ca) * common_fac;
                for (ic = 0; ic < nci; ic++) {
                        cei[ic*npi+ip] = ci[ic*npi+ip] * tmp;
                }
        }
}

void type1_rad_part(double *rad_all, int lmax, double k, double aij,
                    double *ur, double *rs, int nrs, int inc)
{
        const int lmax1 = lmax + 1;
        double rur[nrs];
        double bval[nrs*lmax1];
        int lab, i, n;
        double kaij, fac, tmp;
        double *prad;

        kaij = k / (2*aij);
        fac = kaij*kaij*aij;
        for (n = 0; n < nrs; n++) {
                tmp = rs[n*inc] - kaij;
                tmp = fac - aij*tmp*tmp;
                if (ur[n] == 0 || tmp > CUTOFF || tmp < -CUTOFF) {
/* Avoid exp(tmp) goto infinity!  Usually such points correspond to remote
 * functions.  Most likely, they can be dropped without affecting accuracy. */
                        rur[n] = 0;
                        for (i = 0; i < lmax1; i++) {
                                bval[n*lmax1+i] = 0;
                        }
                } else {
                        rur[n] = ur[n] * exp(tmp);
                        ECPsph_ine_opt(bval+n*lmax1, lmax, k*rs[n*inc]);
                }
        }

        for (lab = 0; lab <= lmax; lab++) {
                if (lab > 0) {
                        for (n = 0; n < nrs; n++) {
                                rur[n] *= rs[n*inc];
                        }
                }
                prad = rad_all + lab * lmax1;
                for (i = lab%2; i <= lmax; i+=2) {
                        for (n = 0; n < nrs; n++) {
                                prad[i] += rur[n] * bval[n*lmax1+i];
                        }
                }
        }
}

int ECPtype1_cart(double *gctr, int *shls, int *ecpbas, int necpbas,
                  int *atm, int natm, int *bas, int nbas, double *env, double *cache)
{
        const int ish = shls[0];
        const int jsh = shls[1];
        const int li = bas[ANG_OF+ish*BAS_SLOTS];
        const int lj = bas[ANG_OF+jsh*BAS_SLOTS];
        const int npi = bas[NPRIM_OF+ish*BAS_SLOTS];
        const int npj = bas[NPRIM_OF+jsh*BAS_SLOTS];
        const int nci = bas[NCTR_OF+ish*BAS_SLOTS];
        const int ncj = bas[NCTR_OF+jsh*BAS_SLOTS];
        const int nfi = (li+1) * (li+2) / 2;
        const int nfj = (lj+1) * (lj+2) / 2;
        const double *ai = env + bas[PTR_EXP+ish*BAS_SLOTS];
        const double *aj = env + bas[PTR_EXP+jsh*BAS_SLOTS];
        const double *ci = env + bas[PTR_COEFF+ish*BAS_SLOTS];
        const double *cj = env + bas[PTR_COEFF+jsh*BAS_SLOTS];
        const double *ri = env + atm[PTR_COORD+bas[ATOM_OF+ish*BAS_SLOTS]*ATM_SLOTS];
        const double *rj = env + atm[PTR_COORD+bas[ATOM_OF+jsh*BAS_SLOTS]*ATM_SLOTS];

        int nrs = 1 << LEVEL_MAX;
        int ecpatmlst[natm+1];
        search_ecpatms(ecpatmlst, ecpbas, necpbas);

        const int lilj1 = li + lj + 1;
        const int d1 = lilj1;
        const int d2 = d1 * d1;
        const int d3 = d2 * d1;
        const int di1 = li + 1;
        const int di2 = di1 * di1;
        const int di3 = di2 * di1;
        const int dj1 = lj + 1;
        const int dj2 = dj1 * dj1;
        const int dj3 = dj2 * dj1;
        int ecpshls[necpbas+1];
        int ia, atm_id;
        int i, n, ip, jp, ic, jc, mi, mj;
        int i1, i2, i3, j1, j2, j3;
        int *ixyz, *jxyz;
        double ur[nrs];
        double rad_all[npi*npj*d2];
        double rad_ang[d3];
        double rad_ang_all[nci*ncj*d3];
        double ifac[nfi*di3];
        double jfac[nfj*dj3];
        double cei[npi*nci];
        double cej[npj*ncj];
        double rca[3];
        double rcb[3];
        double rij[3];
        double fac;
        double *rc, *pifac, *pjfac, *pout;
        int has_value = 0;

        for (i = 0; i < nci*ncj*nfi*nfj; i++) { gctr[i] = 0; }
        for (i = 0; i < d3; i++) { rad_all[i] = 0; }

        for (ia = 0; ecpatmlst[ia] != -1; ia++) {
                atm_id = ecpatmlst[ia];
                search_ecpshls(ecpshls, atm_id, -1, ecpbas, necpbas);
                if (ecpshls[0] == -1) {
                        continue;
                }

        rc = env + atm[PTR_COORD+atm_id*ATM_SLOTS];
        if (!check_3c_overlap(shls, atm, bas, env, rc, ecpshls, ecpbas)) {
                continue;
        }

        has_value = 1;
        rca[0] = rc[0] - ri[0];
        rca[1] = rc[1] - ri[1];
        rca[2] = rc[2] - ri[2];
        rcb[0] = rc[0] - rj[0];
        rcb[1] = rc[1] - rj[1];
        rcb[2] = rc[2] - rj[2];
        scale_coeff(cei, ci, ai, SQUARE(rca), npi, nci, li);
        scale_coeff(cej, cj, aj, SQUARE(rcb), npj, ncj, lj);

        int level, nrs0, start, step;
        double wtscale;
        double *prad;
        double plast[d2];
        char converged[npi*npj];
        char all_conv;
        double *rs = rs_gauss_chebyshev2047;
        double *ws = ws_gauss_chebyshev2047;
        for (i = 0; i < npi*npj; i++) { converged[i] = 0; }
        for (i = 0; i < npi*npj*d2; i++) { rad_all[i] = 0; }
        nrs0 = (1 << LEVEL0) - 1;
        step = 1 << (LEVEL_MAX - LEVEL0);
        start = step - 1;
        wtscale = step;
        for (level = LEVEL0; level <= LEVEL_MAX; level++) {
                nrs = ECPrad_part(ur, rs+start, nrs0, step, ecpshls, ecpbas,
                                  atm, natm, bas, nbas, env);
                for (n = 0; n < nrs; n++) {
                        ur[n] *= ws[start+n*step] * wtscale;
                }

                all_conv = 1;
                for (ip = 0; ip < npi; ip++) {
                for (jp = 0; jp < npj; jp++) {
                        if (!converged[ip*npj+jp]) {
                                prad = rad_all + (ip*npj+jp)*d2;
                                for (i = 0; i < d2; i++) {
                                        plast[i] = prad[i];
                                        prad[i] *= .5;
                                }
                                rij[0] = ai[ip] * rca[0] + aj[jp] * rcb[0];
                                rij[1] = ai[ip] * rca[1] + aj[jp] * rcb[1];
                                rij[2] = ai[ip] * rca[2] + aj[jp] * rcb[2];
                                type1_rad_part(prad, li+lj, sqrt(SQUARE(rij))*2,
                                               ai[ip]+aj[jp], ur, rs+start, nrs, step);
                                converged[ip*npj+jp] = 1;
                                for (i = 0; i < d2; i++) {
                                        if (CLOSE_ENOUGH(plast[i],prad[i])) {
                                                converged[ip*npj+jp] = 0;
                                                all_conv = 0;
                                                break;
                                        }
                                }
                        }
                } }

                if (all_conv) {
                        break;
                } else {
                        nrs0 = (1 << level) - 1;
                        step = 1 << (LEVEL_MAX - level);
                        start = (start - 1) / 2;
                        wtscale *= .5;
                }
        }

        for (i = 0; i < nci*ncj*d3; i++) { rad_ang_all[i] = 0; }
        for (ip = 0; ip < npi; ip++) {
        for (jp = 0; jp < npj; jp++) {
                type1_rad_ang(rad_ang, li+lj, rij, rad_all+(ip*npj+jp)*d2);
                for (ic = 0; ic < nci; ic++) {
                for (jc = 0; jc < ncj; jc++) {
                        fac = cei[ic*npi+ip] * cej[jc*npj+jp];
                        prad = rad_ang_all + (ic*ncj+jc)*d3;
                        for (n = 0; n < d3; n++) {
                                prad[n] += fac * rad_ang[n];
                        }
                } }
        } }

        type1_static_facs(ifac, li, rca);
        type1_static_facs(jfac, lj, rcb);
        for (ic = 0; ic < nci; ic++) {
        for (jc = 0; jc < ncj; jc++) {
                prad = rad_ang_all + (ic*ncj+jc)*d3;
                LOOP_CART(li, mi, ixyz) {
                LOOP_CART(lj, mj, jxyz) {
                        pifac = ifac + mi * di3;
                        pjfac = jfac + mj * dj3;
                        pout = gctr + (jc*nfj+mj) * nci*nfi + ic*nfi+mi;
                        LOOP_XYZ(i1, i2, i3, ixyz) {
                        LOOP_XYZ(j1, j2, j3, jxyz) {
                                *pout += pifac[i1*di2+i2*di1+i3] *
                                         pjfac[j1*dj2+j2*dj1+j3] *
                                         prad[(i1+j1)*d2+(i2+j2)*d1+i3+j3];
                        } }
                } }
        } }

        }
        return has_value;
}

static int c2s_factory(double *gctr, int *shls, int *ecpbas, int necpbas,
                       int *atm, int natm, int *bas, int nbas, double *env,
                       double *cache, int (*fcart)())
{
        const int ish = shls[0];
        const int jsh = shls[1];
        const int li = bas[ANG_OF+ish*BAS_SLOTS];
        const int lj = bas[ANG_OF+jsh*BAS_SLOTS];
        const int nfi = (li+1) * (li+2) / 2;
        const int nfj = (lj+1) * (lj+2) / 2;
        const int nci = bas[NCTR_OF+ish*BAS_SLOTS];
        const int ncj = bas[NCTR_OF+jsh*BAS_SLOTS];

        if (li < 2 && lj < 2) {
                return (*fcart)(gctr, shls, ecpbas, necpbas,
                                atm, natm, bas, nbas, env);
        }

        int j;
        int di = nfi * nci;
        int dji = di * (lj*2+1);
        double *gcart, *gtmp;
        gcart = cache;
        gtmp = gcart + nfi*nfj*nci*ncj;
        int has_value = (*fcart)(gcart, shls, ecpbas, necpbas,
                                 atm, natm, bas, nbas, env);

        if (has_value) {
                if (li < 2) {
                        for (j = 0; j < ncj; j++) {
                                CINTc2s_ket_sph(gctr+j*dji, di, gcart+j*nfj*di, lj);
                        }
                } else if (lj < 2 ) {
                        CINTc2s_bra_sph(gctr, (lj*2+1)*nci*ncj, gcart, li);
                } else {
                        for (j = 0; j < ncj; j++) {
                                CINTc2s_ket_sph(gtmp+j*dji, di, gcart+j*nfj*di, lj);
                        }
                        CINTc2s_bra_sph(gctr, (lj*2+1)*nci*ncj, gtmp, li);
                }
        } else {
                for (j = 0; j < (li*2+1)*(lj*2+1)*nci*ncj; j++) { gctr[j] = 0; }
        }
        return has_value;
}

int ECPtype1_sph(double *gctr, int *shls, int *ecpbas, int necpbas,
                 int *atm, int natm, int *bas, int nbas, double *env, double *cache)
{
        return c2s_factory(gctr, shls, ecpbas, necpbas,
                           atm, natm, bas, nbas, env, cache, ECPtype1_cart);
}

int ECPtype2_sph(double *gctr, int *shls, int *ecpbas, int necpbas,
                 int *atm, int natm, int *bas, int nbas, double *env, double *cache)
{
        return c2s_factory(gctr, shls, ecpbas, necpbas,
                           atm, natm, bas, nbas, env, cache, ECPtype2_cart);
}

/*
 * For moleintor.getints function
 */
int ECPscalar_sph(double *out, int *dims, int *shls, int *atm, int natm,
                  int *bas, int nbas, double *env, void *opt, double *cache)

{
        const int ish = shls[0];
        const int jsh = shls[1];
        const int li = bas[ANG_OF+ish*BAS_SLOTS];
        const int lj = bas[ANG_OF+jsh*BAS_SLOTS];
        const int di = (li*2+1) * bas[NCTR_OF+ish*BAS_SLOTS];
        const int dj = (lj*2+1) * bas[NCTR_OF+jsh*BAS_SLOTS];
        const int dij = di * dj;

        if (out == NULL) {
                const int nfi = (li+1) * (li+2) / 2;
                const int nfj = (lj+1) * (lj+2) / 2;
                const int nci = bas[NCTR_OF+ish*BAS_SLOTS];
                const int ncj = bas[NCTR_OF+jsh*BAS_SLOTS];
                return dij*2 + nfi*nfj*nci*ncj*2;
        }
        double *stack = NULL;
        if (cache == NULL) {
                const int nfi = (li+1) * (li+2) / 2;
                const int nfj = (lj+1) * (lj+2) / 2;
                const int nci = bas[NCTR_OF+ish*BAS_SLOTS];
                const int ncj = bas[NCTR_OF+jsh*BAS_SLOTS];
                stack = malloc(sizeof(double) * (dij*2+nfi*nfj*nci*ncj*2));
                cache = stack;
        }

        int *ecpbas = bas + (int)(env[PTR_ECPBAS_OFFSET])*BAS_SLOTS;
        int necpbas = (int)(env[PTR_NECPBAS]);
        double *buf1 = cache;
        double *buf2 = cache + dij;
        cache += dij * 2;
        int has_value;
        has_value = ECPtype1_sph(buf1, shls, ecpbas, necpbas, atm, natm, bas, nbas, env, cache);
        has_value =(ECPtype2_sph(buf2, shls, ecpbas, necpbas, atm, natm, bas, nbas, env, cache) | has_value);

        int i, j, ni;
        if (dims == NULL) {
                for (i = 0; i < dij; i++) {
                        out[i] = buf1[i] + buf2[i];
                }
        } else {
                ni = dims[0];
                for (i = 0; i < di; i++) {
                for (j = 0; j < dj; j++) {
                        out[i+j*ni] = buf1[i+j*di] + buf2[i+j*di];
                } }
        }
        if (stack != NULL) {
                free(stack);
        }
        return has_value;
}

int ECPscalar_cart(double *out, int *dims, int *shls, int *atm, int natm,
                   int *bas, int nbas, double *env, void *opt, double *cache)
{
        const int ish = shls[0];
        const int jsh = shls[1];
        const int li = bas[ANG_OF+ish*BAS_SLOTS];
        const int lj = bas[ANG_OF+jsh*BAS_SLOTS];
        const int di = (li+1) * (li+2) / 2 * bas[NCTR_OF+ish*BAS_SLOTS];;
        const int dj = (lj+1) * (lj+2) / 2 * bas[NCTR_OF+jsh*BAS_SLOTS];
        const int dij = di * dj;

        if (out == NULL) {
                return dij * 2;
        }
        double *stack = NULL;
        if (cache == NULL) {
                stack = malloc(sizeof(double) * dij * 2);
                cache = stack;
        }

        int *ecpbas = bas + ((int)env[PTR_ECPBAS_OFFSET])*BAS_SLOTS;
        int necpbas = (int)env[PTR_NECPBAS];
        double *buf1 = cache;
        double *buf2 = cache + dij;
        cache += dij * 2;
        int has_value;
        has_value = ECPtype1_cart(buf1, shls, ecpbas, necpbas, atm, natm, bas, nbas, env, cache);
        has_value =(ECPtype2_cart(buf2, shls, ecpbas, necpbas, atm, natm, bas, nbas, env, cache) | has_value);

        int i, j, ni;
        if (dims == NULL) {
                for (i = 0; i < dij; i++) {
                        out[i] = buf1[i] + buf2[i];
                }
        } else {
                ni = dims[0];
                for (i = 0; i < di; i++) {
                for (j = 0; j < dj; j++) {
                        out[i+j*ni] = buf1[i+j*di] + buf2[i+j*di];
                } }
        }
        if (stack != NULL) {
                free(stack);
        }
        return has_value;
}

void ECPscalar_optimizer(void **opt, int *atm, int natm, int *bas, int nbas, double *env)
{
        *opt = NULL;
}

