# The minimal basis sets used by Molpro.
#
# Comments from Molpro
#
# ! These are minimal basis sets created by taking the first
# ! nOcc contracted functions out of the cc-pVTZ or cc-pVTZ-PP
# ! basis sets. They are intended as auxiliary sets for SCF
# ! convergence experiments and atomic density guess purposes.
# ! See "When SCF does not converge" chapter in SCF program
# ! documentation.
# !
# ! -- Gerald Knizia, 29.5.2011


H  = [[0,
        (33.87 , 6.0680e-03),
        (5.095 , 4.5308e-02),
        (1.159 , 0.202822),
        (0.3258, 0.503903),
        (0.1027, 0.383421),]]

He = [[0,
        (234   , 2.5870000000e-03),
        (35.16 , 1.9533000000e-02),
        (7.989 , 9.0998000000e-02),
        (2.212 , 0.27205),
        (0.6669, 0.478065),
        (0.2089, 0.307737),]]

Li = [[0,
        (5988            , 1.3300000000e-04 , -2.1000000000e-05),
        (898.9           , 1.0250000000e-03 , -1.6100000000e-04),
        (205.9           , 5.2720000000e-03 , -8.2000000000e-04),
        (59.24           , 2.0929000000e-02 , -3.3260000000e-03),
        (19.87           , 6.6340000000e-02 , -1.0519000000e-02),
        (7.406           , 0.165775         , -2.8097000000e-02),
        (2.93            , 0.315038         , -5.5936000000e-02),
        (1.189           , 0.393523         , -9.9237000000e-02),
        (0.4798          , 0.19087          , -0.112189),
        (7.5090000000e-02, 5.4140000000e-03 , 0.567889),
        (2.8320000000e-02, -1.3280000000e-03, 0.530382),]]

Be = [[0,
        (6863            , 2.3600000000e-04 , -4.3000000000e-05),
        (1030            , 1.8260000000e-03 , -3.3300000000e-04),
        (234.7           , 9.4520000000e-03 , -1.7360000000e-03),
        (66.56           , 3.7957000000e-02 , -7.0120000000e-03),
        (21.69           , 0.119965         , -2.3126000000e-02),
        (7.734           , 0.282162         , -5.8138000000e-02),
        (2.916           , 0.427404         , -0.114556),
        (1.13            , 0.266278         , -0.135908),
        (0.2577          , 1.8193000000e-02 , 0.228026),
        (0.1101          , -7.2750000000e-03, 0.577441),
        (4.4090000000e-02, 1.9030000000e-03 , 0.317873),]]

B = [[0,
       (5473            , 5.5500000000e-04 , -1.1200000000e-04),
       (820.9           , 4.2910000000e-03 , -8.6800000000e-04),
       (186.8           , 2.1949000000e-02 , -4.4840000000e-03),
       (52.83           , 8.4441000000e-02 , -1.7683000000e-02),
       (17.08           , 0.238557         , -5.3639000000e-02),
       (5.999           , 0.435072         , -0.119005),
       (2.208           , 0.341955         , -0.165824),
       (0.5879          , 3.6856000000e-02 , 0.120107),
       (0.2415          , -9.5450000000e-03, 0.595981),
       (8.6100000000e-02, 2.3680000000e-03 , 0.411021),],
      [1,
       (12.05           , 1.3118000000e-02),
       (2.613           , 7.9896000000e-02),
       (0.7475          , 0.277275),
       (0.2385          , 0.50427),
       (7.6980000000e-02, 0.35368),]]

C = [[0,
       (8236  , 5.3100000000e-04 , -1.1300000000e-04),
       (1235  , 4.1080000000e-03 , -8.7800000000e-04),
       (280.8 , 2.1087000000e-02 , -4.5400000000e-03),
       (79.27 , 8.1853000000e-02 , -1.8133000000e-02),
       (25.59 , 0.234817         , -5.5760000000e-02),
       (8.997 , 0.434401         , -0.126895),
       (3.319 , 0.346129         , -0.170352),
       (0.9059, 3.9378000000e-02 , 0.140382),
       (0.3643, -8.9830000000e-03, 0.598684),
       (0.1285, 2.3850000000e-03 , 0.395389),],
      [1,
       (18.71 , 1.4031000000e-02),
       (4.133 , 8.6866000000e-02),
       (1.2   , 0.290216),
       (0.3827, 0.501008),
       (0.1209, 0.343406),]]

N = [[0,
       (11420 , 5.2300000000e-04 , -1.1500000000e-04),
       (1712  , 4.0450000000e-03 , -8.9500000000e-04),
       (389.3 , 2.0775000000e-02 , -4.6240000000e-03),
       (110   , 8.0727000000e-02 , -1.8528000000e-02),
       (35.57 , 0.233074         , -5.7339000000e-02),
       (12.54 , 0.433501         , -0.132076),
       (4.644 , 0.347472         , -0.17251),
       (1.293 , 4.1262000000e-02 , 0.151814),
       (0.5118, -8.5080000000e-03, 0.599944),
       (0.1787, 2.3840000000e-03 , 0.387462),],
      [1,
       (26.63 , 1.4670000000e-02),
       (5.948 , 9.1764000000e-02),
       (1.742 , 0.298683),
       (0.555 , 0.498487),
       (0.1725, 0.337023),]]

O = [[0,
       (15330 , 5.0800000000e-04 , -1.1500000000e-04),
       (2299  , 3.9290000000e-03 , -8.9500000000e-04),
       (522.4 , 2.0243000000e-02 , -4.6360000000e-03),
       (147.3 , 7.9181000000e-02 , -1.8724000000e-02),
       (47.55 , 0.230687         , -5.8463000000e-02),
       (16.76 , 0.433118         , -0.136463),
       (6.207 , 0.35026          , -0.17574),
       (1.752 , 4.2728000000e-02 , 0.160934),
       (0.6882, -8.1540000000e-03, 0.603418),
       (0.2384, 2.3810000000e-03 , 0.378765),],
      [1,
       (34.46 , 1.5928000000e-02),
       (7.749 , 9.9740000000e-02),
       (2.28  , 0.310492),
       (0.7156, 0.491026),
       (0.214 , 0.336337),]]

F = [[0,
       (19500 , 5.0700000000e-04 , -1.1700000000e-04),
       (2923  , 3.9230000000e-03 , -9.1200000000e-04),
       (664.5 , 2.0200000000e-02 , -4.7170000000e-03),
       (187.5 , 7.9010000000e-02 , -1.9086000000e-02),
       (60.62 , 0.230439         , -5.9655000000e-02),
       (21.42 , 0.432872         , -0.14001),
       (7.95  , 0.349964         , -0.176782),
       (2.257 , 4.3233000000e-02 , 0.171625),
       (0.8815, -7.8920000000e-03, 0.605043),
       (0.3041, 2.3840000000e-03 , 0.369512),],
      [1,
       (43.88 , 1.6665000000e-02),
       (9.926 , 0.104472),
       (2.93  , 0.31726),
       (0.9132, 0.487343),
       (0.2672, 0.334604),]]

Ne = [[0,
        (24350 , 5.0200000000e-04 , -1.1800000000e-04),
        (3650  , 3.8810000000e-03 , -9.1500000000e-04),
        (829.6 , 1.9997000000e-02 , -4.7370000000e-03),
        (234   , 7.8418000000e-02 , -1.9233000000e-02),
        (75.61 , 0.229676         , -6.0369000000e-02),
        (26.73 , 0.432722         , -0.142508),
        (9.927 , 0.350642         , -0.17771),
        (2.836 , 4.3911000000e-02 , 0.177352),
        (1.102 , -7.6450000000e-03, 0.605836),
        (0.3782, 2.3750000000e-03 , 0.365109),],
       [1,
        (54.7 , 1.7151000000e-02),
        (12.43, 0.107656),
        (3.679, 0.321681),
        (1.143, 0.485232),
        (0.33 , 0.332584),]]

Na = [[0,
        (423000          , 1.8061800000e-05 , -4.4065300000e-06, 6.6301900000e-07),
        (63340           , 1.4043000000e-04 , -3.4344300000e-05, 5.1576900000e-06),
        (14410           , 7.3843800000e-04 , -1.8011400000e-04, 2.7125000000e-05),
        (4077            , 3.1118200000e-03 , -7.6390000000e-04, 1.1463500000e-04),
        (1328            , 1.1208100000e-02 , -2.7524800000e-03, 4.1511800000e-04),
        (478.6           , 3.5282800000e-02 , -8.8601600000e-03, 1.3297800000e-03),
        (186.2           , 9.5989700000e-02 , -2.4793900000e-02, 3.7559500000e-03),
        (76.92           , 0.213735         , -6.0599500000e-02, 9.1402500000e-03),
        (33.32           , 0.348688         , -0.116446        , 1.7985900000e-02),
        (15              , 0.324566         , -0.162437        , 2.5147700000e-02),
        (6.869           , 0.112633         , -4.3889100000e-02, 7.6352200000e-03),
        (2.683           , 7.0679700000e-03 , 0.337917         , -6.1458900000e-02),
        (1.109           , 5.9801000000e-04 , 0.561347         , -0.115721),
        (0.454           , 2.0413000000e-04 , 0.24524          , -0.158906),
        (6.0150000000e-02, -5.3087000000e-06, 4.0675400000e-03 , 0.626406),
        (2.3820000000e-02, 1.8260500000e-06 , -1.2674600000e-03, 0.475402),],
       [1,
        (243.3           , 2.2439200000e-03),
        (57.39           , 1.7399700000e-02),
        (18.1            , 7.7412500000e-02),
        (6.575           , 0.219102),
        (2.521           , 0.378522),
        (0.9607          , 0.394902),
        (0.3512          , 0.160424),
        (9.8270000000e-02, 2.3331100000e-03),
        (3.7340000000e-02, 1.9953600000e-03),
        (1.5000000000e-02, -7.7734400000e-04),]]

Mg = [[0,
        (164900          , 7.2992900000e-05 , -1.8424800000e-05, 3.5517600000e-06),
        (24710           , 5.6665200000e-04 , -1.4350000000e-04, 2.7642000000e-05),
        (5628            , 2.9626900000e-03 , -7.4871000000e-04, 1.4440400000e-04),
        (1596            , 1.2296200000e-02 , -3.1440700000e-03, 6.0574400000e-04),
        (521             , 4.2732400000e-02 , -1.1048100000e-02, 2.1352700000e-03),
        (188             , 0.123013         , -3.3605800000e-02, 6.4993400000e-03),
        (73.01           , 0.274832         , -8.2594600000e-02, 1.6144600000e-02),
        (29.9            , 0.401818         , -0.159314        , 3.1576600000e-02),
        (12.54           , 0.264697         , -0.152888        , 3.1637400000e-02),
        (4.306           , 3.3261200000e-02 , 0.190849         , -4.3914000000e-02),
        (1.826           , -4.4133500000e-03, 0.579964         , -0.151093),
        (0.7417          , 2.0602400000e-03 , 0.372029         , -0.217668),
        (0.1457          , -8.3847000000e-04, 2.1169100000e-02 , 0.259807),
        (7.6120000000e-02, 7.0819500000e-04 , -1.1934400000e-02, 0.547245),
        (3.3100000000e-02, -2.0060200000e-04, 2.7732900000e-03 , 0.32591),],
       [1,
        (316.9           , 2.0753200000e-03),
        (74.86           , 1.6286900000e-02),
        (23.72           , 7.3869700000e-02),
        (8.669           , 0.214297),
        (3.363           , 0.382154),
        (1.31            , 0.398178),
        (0.4911          , 0.152878),
        (0.2364          , -4.3754000000e-03),
        (8.7330000000e-02, 6.2958200000e-03),
        (3.2370000000e-02, -1.5676900000e-03),]]

Al = [[0,
        (205500          , 6.7883600000e-05 , -1.7637700000e-05, 4.0731500000e-06),
        (30780           , 5.2714900000e-04 , -1.3719500000e-04, 3.1656600000e-05),
        (7006            , 2.7620300000e-03 , -7.1891000000e-04, 1.6611600000e-04),
        (1985            , 1.1472800000e-02 , -3.0114600000e-03, 6.9499200000e-04),
        (649.1           , 3.9818800000e-02 , -1.0601400000e-02, 2.4551100000e-03),
        (235             , 0.11504          , -3.2134500000e-02, 7.4459800000e-03),
        (91.62           , 0.260887         , -8.0315600000e-02, 1.8825300000e-02),
        (37.67           , 0.396386         , -0.156794        , 3.7277200000e-02),
        (15.91           , 0.284597         , -0.168376        , 4.1949600000e-02),
        (5.85            , 4.4458300000e-02 , 0.126879         , -3.5437500000e-02),
        (2.542           , -4.8983800000e-03, 0.561494         , -0.175132),
        (1.057           , 2.6125300000e-03 , 0.436613         , -0.276203),
        (0.2931          , -1.0891500000e-03, 3.5729300000e-02 , 0.108729),
        (0.1455          , 7.2206800000e-04 , -1.1456300000e-02, 0.652809),
        (5.6500000000e-02, -1.7848500000e-04, 2.2020100000e-03 , 0.394587),],
       [1,
        (444.4           , 1.6278600000e-03 , -2.8634100000e-04),
        (105.1           , 1.3068700000e-02 , -2.4230800000e-03),
        (33.47           , 6.1234100000e-02 , -1.0865800000e-02),
        (12.33           , 0.18787          , -3.6430700000e-02),
        (4.869           , 0.360452         , -6.4107400000e-02),
        (1.961           , 0.408454         , -9.7223900000e-02),
        (0.7834          , 0.18864          , 1.4743700000e-02),
        (0.1888          , 9.7651400000e-03 , 0.503448),
        (5.5570000000e-02, -1.1505700000e-03, 0.597984),]]

Si = [[0,
        (254900          , 6.2510100000e-05 , -1.6637000000e-05, 4.2625700000e-06),
        (38190           , 4.8555300000e-04 , -1.2931000000e-04, 3.3106200000e-05),
        (8690            , 2.5451600000e-03 , -6.7882800000e-04, 1.7401500000e-04),
        (2462            , 1.0586600000e-02 , -2.8411700000e-03, 7.2757400000e-04),
        (804.8           , 3.6878700000e-02 , -1.0055100000e-02, 2.5833300000e-03),
        (291.3           , 0.107479         , -3.0577400000e-02, 7.8635400000e-03),
        (113.6           , 0.247936         , -7.7725600000e-02, 2.0215500000e-02),
        (46.75           , 0.390927         , -0.154236        , 4.0732000000e-02),
        (19.82           , 0.302026         , -0.180368        , 4.9935800000e-02),
        (7.708           , 5.5923600000e-02 , 7.9821800000e-02 , -2.4939600000e-02),
        (3.34            , -4.0240600000e-03, 0.547441         , -0.19035),
        (1.402           , 2.5803000000e-03 , 0.480119         , -0.31835),
        (0.4387          , -1.0382100000e-03, 4.7484600000e-02 , 9.4803600000e-02),
        (0.207           , 6.0793000000e-04 , -1.0699600000e-02, 0.68118),
        (7.9440000000e-02, -1.5402200000e-04, 2.1987100000e-03 , 0.395672),],
       [1,
        (481.5           , 1.9204500000e-03, -4.0522000000e-04),
        (113.9           , 1.5355200000e-02, -3.3589600000e-03),
        (36.23           , 7.1399100000e-02, -1.5286000000e-02),
        (13.34           , 0.213052        , -4.8921800000e-02),
        (5.252           , 0.390354        , -8.5500800000e-02),
        (2.12            , 0.393721        , -0.112137),
        (0.8561          , 0.132565        , 6.1827400000e-02),
        (0.2528          , 3.9563000000e-03, 0.551919),
        (7.8890000000e-02, 3.3162400000e-04, 0.523492),]]

P = [[0,
       (312400, 5.7696000000e-05 , -1.5670900000e-05, 4.3063100000e-06),
       (46800 , 4.4829600000e-04 , -1.2172400000e-04, 3.3419400000e-05),
       (10650 , 2.3493900000e-03 , -6.3967200000e-04, 1.7588500000e-04),
       (3018  , 9.7826500000e-03 , -2.6742600000e-03, 7.3434000000e-04),
       (986.8 , 3.4146700000e-02 , -9.4983100000e-03, 2.6177500000e-03),
       (357.4 , 0.100204         , -2.8934900000e-02, 7.9785200000e-03),
       (139.6 , 0.234372         , -7.4512100000e-02, 2.0794000000e-02),
       (57.63 , 0.382434         , -0.149938        , 4.2444600000e-02),
       (24.6  , 0.318088         , -0.189467        , 5.6343600000e-02),
       (10.12 , 7.0778800000e-02 , 3.6327000000e-02 , -1.2735800000e-02),
       (4.283 , -1.8179900000e-03, 0.528816         , -0.196495),
       (1.805 , 2.1618000000e-03 , 0.519115         , -0.353555),
       (0.6158, -8.3474200000e-04, 6.0554700000e-02 , 7.4140700000e-02),
       (0.2782, 4.3229700000e-04 , -9.2569500000e-03, 0.700912),
       (0.1055, -1.1425100000e-04, 2.1037200000e-03 , 0.404739),],
      [1,
       (504.9           , 2.3372800000e-03 , -5.5523600000e-04),
       (119.4           , 1.8541000000e-02 , -4.4591300000e-03),
       (37.96           , 8.4969300000e-02 , -2.0635000000e-02),
       (13.95           , 0.244615         , -6.1769400000e-02),
       (5.457           , 0.422766         , -0.108924),
       (2.177           , 0.368439         , -0.105599),
       (0.801           , 7.7273400000e-02 , 0.153483),
       (0.2877          , -3.7900500000e-03, 0.576981),
       (9.7140000000e-02, 1.5993900000e-03 , 0.422439),]]

S = [[0,
       (374100, 5.4214000000e-05 , -1.4983700000e-05, 4.3506600000e-06),
       (56050 , 4.2085500000e-04 , -1.1619800000e-04, 3.3714000000e-05),
       (12760 , 2.2069800000e-03 , -6.1158300000e-04, 1.7767400000e-04),
       (3615  , 9.1925800000e-03 , -2.5537000000e-03, 7.4111600000e-04),
       (1183  , 3.2112300000e-02 , -9.0870800000e-03, 2.6459100000e-03),
       (428.8 , 9.4668300000e-02 , -2.7704500000e-02, 8.0748700000e-03),
       (167.8 , 0.22363          , -7.2002000000e-02, 2.1227600000e-02),
       (69.47 , 0.374393         , -0.146439        , 4.3832300000e-02),
       (29.84 , 0.329108         , -0.19515         , 6.1271600000e-02),
       (12.72 , 8.4703800000e-02 , 8.1919300000e-03 , -3.6151000000e-03),
       (5.244 , 4.4085100000e-04 , 0.516601         , -0.20451),
       (2.219 , 1.6482700000e-03 , 0.542178         , -0.381871),
       (0.7767, -6.2233200000e-04, 6.8843000000e-02 , 8.2684400000e-02),
       (0.349 , 3.0130600000e-04 , -9.1807200000e-03, 0.714147),
       (0.1322, -8.4129000000e-05, 2.2683200000e-03 , 0.393791),],
      [1,
       (574.4 , 2.4226400000e-03 , -6.2010200000e-04),
       (135.8 , 1.9279600000e-02 , -4.9388200000e-03),
       (43.19 , 8.8540100000e-02 , -2.3264700000e-02),
       (15.87 , 0.254654         , -6.8519500000e-02),
       (6.208 , 0.433984         , -0.123896),
       (2.483 , 0.354953         , -9.6949900000e-02),
       (0.8688, 6.1894100000e-02 , 0.228215),
       (0.3229, -5.0297700000e-03, 0.569394),
       (0.1098, 2.0981300000e-03 , 0.366302),]]

Cl = [[0,
        (456100, 4.9297000000e-05 , -1.3830400000e-05, 4.1854600000e-06),
        (68330 , 3.8302900000e-04 , -1.0727900000e-04, 3.2439500000e-05),
        (15550 , 2.0085400000e-03 , -5.6508300000e-04, 1.7110500000e-04),
        (4405  , 8.3855800000e-03 , -2.3613500000e-03, 7.1417600000e-04),
        (1439  , 2.9470300000e-02 , -8.4588600000e-03, 2.5670500000e-03),
        (520.4 , 8.7832500000e-02 , -2.5963800000e-02, 7.8855200000e-03),
        (203.1 , 0.211473         , -6.8636200000e-02, 2.1086700000e-02),
        (83.96 , 0.365364         , -0.141874        , 4.4226400000e-02),
        (36.2  , 0.340884         , -0.199319        , 6.5167000000e-02),
        (15.83 , 0.102133         , -1.9566200000e-02, 6.0301200000e-03),
        (6.334 , 3.1167500000e-03 , 0.499741         , -0.206495),
        (2.694 , 1.0575100000e-03 , 0.563736         , -0.405871),
        (0.9768, -3.7800000000e-04, 7.9032500000e-02 , 7.5955800000e-02),
        (0.4313, 1.5613600000e-04 , -8.3509100000e-03, 0.725661),
        (0.1625, -5.1412600000e-05, 2.3245600000e-03 , 0.394423),],
       [1,
        (663.3 , 2.4044800000e-03 , -6.5214500000e-04),
        (156.8 , 1.9214800000e-02 , -5.1944500000e-03),
        (49.98 , 8.8509700000e-02 , -2.4693800000e-02),
        (18.42 , 0.25602          , -7.2816700000e-02),
        (7.24  , 0.436927         , -0.13403),
        (2.922 , 0.350334         , -9.4774200000e-02),
        (1.022 , 5.8549500000e-02 , 0.262289),
        (0.3818, -4.5842300000e-03, 0.564667),
        (0.1301, 2.2697000000e-03 , 0.34125),]]

Ar = [[0,
        (545000, 4.5582800000e-05 , -1.2955100000e-05, 4.0499000000e-06),
        (81640 , 3.5410800000e-04 , -1.0042800000e-04, 3.1369100000e-05),
        (18580 , 1.8579700000e-03 , -5.2958300000e-04, 1.6564600000e-04),
        (5261  , 7.7685100000e-03 , -2.2139600000e-03, 6.9166200000e-04),
        (1717  , 2.7423200000e-02 , -7.9684500000e-03, 2.4979000000e-03),
        (619.9 , 8.2383600000e-02 , -2.4580300000e-02, 7.7107400000e-03),
        (241.6 , 0.20123          , -6.5779800000e-02, 2.0871400000e-02),
        (99.79 , 0.356781         , -0.137942        , 4.4396500000e-02),
        (43.15 , 0.349563         , -0.20163         , 6.8022400000e-02),
        (19.14 , 0.118266         , -4.1283400000e-02, 1.4135000000e-02),
        (7.488 , 5.6019000000e-03 , 0.48468          , -0.207489),
        (3.205 , 4.8347300000e-04 , 0.579224         , -0.425045),
        (1.196 , -1.4808500000e-04, 8.7908300000e-02 , 7.0485500000e-02),
        (0.5204, 2.9202500000e-05 , -7.2755300000e-03, 0.733627),
        (0.1954, -2.3160400000e-05, 2.3288400000e-03 , 0.396005),],
       [1,
        (761.8 , 2.3697600000e-03 , -6.6721100000e-04),
        (180.2 , 1.9019900000e-02 , -5.3271700000e-03),
        (57.5  , 8.8080700000e-02 , -2.5549400000e-02),
        (21.24 , 0.256377         , -7.5719700000e-02),
        (8.388 , 0.438711         , -0.141133),
        (3.416 , 0.347569         , -9.3276800000e-02),
        (1.206 , 5.6674000000e-02 , 0.282872),
        (0.4523, -5.2388200000e-03, 0.56245),
        (0.1545, 1.6437600000e-03 , 0.325059),]]

Ca = [[0,
        (2402654         , 9.3100000000e-06 , -2.7000000000e-06, 9.3000000000e-07 , -2.2000000000e-07),
        (359789.8        , 7.2390000000e-05 , -2.1020000000e-05, 7.2500000000e-06 , -1.7300000000e-06),
        (81878.09        , 3.8059000000e-04 , -1.1052000000e-04, 3.8110000000e-05 , -9.1000000000e-06),
        (23190.89        , 1.6045300000e-03 , -4.6666000000e-04, 1.6101000000e-04 , -3.8440000000e-05),
        (7565.212        , 5.8078000000e-03 , -1.6951300000e-03, 5.8466000000e-04 , -1.3965000000e-04),
        (2730.702        , 1.8595660000e-02 , -5.4834600000e-03, 1.8950400000e-03 , -4.5251000000e-04),
        (1064.64         , 5.2877760000e-02 , -1.5965970000e-02, 5.5252500000e-03 , -1.3203800000e-03),
        (441.0605        , 0.13015149       , -4.1513840000e-02, 1.4470100000e-02 , -3.4584100000e-03),
        (191.7269        , 0.25931471       , -9.2863870000e-02, 3.2715810000e-02 , -7.8368600000e-03),
        (86.53774        , 0.3614961        , -0.16531657      , 6.0031900000e-02 , -1.4415170000e-02),
        (39.89924        , 0.2641116        , -0.17664074      , 6.7016830000e-02 , -1.6216480000e-02),
        (17.64065        , 5.7093980000e-02 , 6.4444220000e-02 , -2.5936600000e-02, 6.3442000000e-03),
        (8.35999         , -1.8220000000e-03, 0.51087962       , -0.26747467      , 6.7406260000e-02),
        (3.95133         , 2.1116400000e-03 , 0.49463804       , -0.42697256      , 0.11447396),
        (1.7134          , -9.7709000000e-04, 8.7500940000e-02 , 6.7964050000e-02 , -2.6344770000e-02),
        (0.81086         , 4.5581000000e-04 , -3.5910100000e-03, 0.71020539       , -0.23369885),
        (0.36025         , -1.9146000000e-04, 2.4922000000e-03 , 0.44180057       , -0.31607538),
        (8.1080000000e-02, 9.1710000000e-05 , -7.5825000000e-04, 2.1931390000e-02 , 0.33281936),
        (4.4840000000e-02, -7.8740000000e-05, 6.4587000000e-04 , -1.1869240000e-02, 0.56111035),
        (2.1430000000e-02, 2.2320000000e-05 , -1.8174000000e-04, 2.6527200000e-03 , 0.28081781),],
       [1,
        (4061.289        , 1.9799000000e-04 , -6.4550000000e-05),
        (962.2465        , 1.7320800000e-03 , -5.6458000000e-04),
        (312.1686        , 9.5337900000e-03 , -3.1312500000e-03),
        (118.7144        , 3.8390120000e-02 , -1.2740860000e-02),
        (49.8067         , 0.11675881       , -3.9914030000e-02),
        (22.25998        , 0.25626874       , -9.0504480000e-02),
        (10.28764        , 0.3797808        , -0.14261898),
        (4.861154        , 0.30829326       , -0.10980904),
        (2.248773        , 8.5920900000e-02 , 0.1516249),
        (1.033662        , 2.1206700000e-03 , 0.46176411),
        (0.464132        , 1.2888000000e-03 , 0.43260031),
        (0.19875         , -4.6835000000e-04, 0.11127411),
        (6.7390000000e-02, 1.4728000000e-04 , 2.5287400000e-03),
        (2.5420000000e-02, -5.2880000000e-05, 7.1032000000e-04),]]

Sc = [[0,
        (2715278         , 8.1472210000e-06 , -4.7221090000e-06, 9.1399050000e-07 , -2.2019510000e-07, -3.7572380000e-07),
        (406598.4        , 6.3347880000e-05 , -3.6718290000e-05, 7.1085130000e-06 , -1.7114190000e-06, -2.9819070000e-06),
        (92530.04        , 3.3303840000e-04 , -1.9308830000e-04, 3.7381260000e-05 , -9.0084690000e-06, -1.5225860000e-05),
        (26207.92        , 1.4040550000e-03 , -8.1468700000e-04, 1.5788280000e-04 , -3.7999970000e-05, -6.6846860000e-05),
        (8549.429        , 5.0817250000e-03 , -2.9555260000e-03, 5.7376860000e-04 , -1.3832270000e-04, -2.3131290000e-04),
        (3085.975        , 1.6269260000e-02 , -9.5200350000e-03, 1.8592440000e-03 , -4.4736920000e-04, -7.9597290000e-04),
        (1203.172        , 4.6245770000e-02 , -2.7468580000e-02, 5.4331820000e-03 , -1.3106910000e-03, -2.1619610000e-03),
        (498.4869        , 0.1137223        , -6.9915280000e-02, 1.4253870000e-02 , -3.4298600000e-03, -6.2064590000e-03),
        (216.736         , 0.2257636        , -0.1499251       , 3.2461440000e-02 , -7.8475790000e-03, -1.2619050000e-02),
        (97.87476        , 0.31067          , -0.2459153       , 6.0034540000e-02 , -1.4471890000e-02, -2.7394590000e-02),
        (45.20433        , 0.2191906        , -0.2401293       , 6.9161050000e-02 , -1.6906690000e-02, -2.3365160000e-02),
        (20.21187        , 7.2158790000e-02 , 3.5679870000e-02 , -2.1130840000e-02, 5.3961150000e-03 , -5.7346270000e-03),
        (9.574751        , 0.118703         , 0.4915023        , -0.2666832       , 6.6710620000e-02 , 0.1536025),
        (4.540346        , 0.1220532        , 0.4911381        , -0.4367591       , 0.1178356        , 0.14471),
        (1.995687        , 2.1367950000e-02 , 9.1206330000e-02 , 6.4982430000e-02 , -2.7381340000e-02, 9.3596990000e-02),
        (0.942215        , -5.3572460000e-04, -5.3567230000e-03, 0.7009599        , -0.2260149       , -0.868773),
        (0.417845        , 2.4357740000e-04 , 8.8128360000e-04 , 0.4515562        , -0.3073539       , 2.1145970000e-02),
        (9.5761000000e-02, -8.7966170000e-05, -7.6055360000e-04, 3.0119100000e-02 , 0.2544054        , 2.275498),
        (5.1351000000e-02, 7.8782460000e-05 , 6.3401160000e-04 , -1.3294800000e-02, 0.598159         , -1.19077),
        (2.3878000000e-02, -1.6371550000e-05, -1.5561630000e-04, 4.6336790000e-03 , 0.3115202        , -0.7674257),],
       [1,
        (10592.19        , 4.5000000000e-05 , -1.5000000000e-05, 4.0000000000e-06),
        (2507.533        , 4.0100000000e-04 , -1.3100000000e-04, 3.9000000000e-05),
        (814.4571        , 2.3020000000e-03 , -7.5700000000e-04, 2.2100000000e-04),
        (311.5195        , 1.0037000000e-02 , -3.3180000000e-03, 9.8400000000e-04),
        (131.9617        , 3.4954000000e-02 , -1.1706000000e-02, 3.4230000000e-03),
        (59.98718        , 9.7909000000e-02 , -3.3604000000e-02, 9.9930000000e-03),
        (28.6625         , 0.21068          , -7.4879000000e-02, 2.1916000000e-02),
        (14.10851        , 0.330093         , -0.122548        , 3.7008000000e-02),
        (7.103706        , 0.331027         , -0.130276        , 3.7794000000e-02),
        (3.6092          , 0.15796          , 1.4596000000e-02 , -4.3790000000e-03),
        (1.77607         , 2.2099000000e-02 , 0.309184         , -0.110164),
        (0.85476         , -1.6050000000e-03, 0.462998         , -0.161017),
        (0.402239        , -1.3260000000e-03, 0.304957         , -0.182482),
        (0.154665        , -2.8000000000e-04, 5.0878000000e-02 , 0.388611),
        (6.4945000000e-02, 3.4000000000e-05 , -4.4930000000e-03, 0.6911),
        (2.6359000000e-02, -1.3000000000e-05, 1.8320000000e-03 , 7.9604000000e-02),],
       [2,
        (50.5138         , 4.2660000000e-03),
        (14.7405         , 2.7708000000e-02),
        (5.195           , 0.100001),
        (2.02846         , 0.231581),
        (0.804086        , 0.346033),
        (0.307689        , 0.373374),
        (0.111392        , 0.264288),
        (3.7352000000e-02, 6.3667000000e-02),]]

Ti = [[0,
        (3014643         , 8.0607820000e-06 , -4.6304860000e-06, 9.2305590000e-07 , -2.1803230000e-07, -3.9751260000e-07),
        (451432.9        , 6.2675180000e-05 , -3.6004510000e-05, 7.1789740000e-06 , -1.6948600000e-06, -3.1610800000e-06),
        (102733.8        , 3.2950060000e-04 , -1.8934200000e-04, 3.7751340000e-05 , -8.9192080000e-06, -1.6093750000e-05),
        (29098.17        , 1.3892030000e-03 , -7.9887810000e-04, 1.5945320000e-04 , -3.7636330000e-05, -7.0929470000e-05),
        (9492.33         , 5.0284690000e-03 , -2.8986980000e-03, 5.7951500000e-04 , -1.3695750000e-04, -2.4427100000e-04),
        (3426.346        , 1.6104190000e-02 , -9.3397010000e-03, 1.8784140000e-03 , -4.4328940000e-04, -8.4578920000e-04),
        (1335.896        , 4.5812320000e-02 , -2.6974640000e-02, 5.4927470000e-03 , -1.2988680000e-03, -2.2822080000e-03),
        (553.5026        , 0.1128613        , -6.8789130000e-02, 1.4432970000e-02 , -3.4067520000e-03, -6.6198730000e-03),
        (240.6925        , 0.2248193        , -0.1481037       , 3.2964080000e-02 , -7.8108290000e-03, -1.3350240000e-02),
        (108.7293        , 0.3114571        , -0.2445253       , 6.1254930000e-02 , -1.4492450000e-02, -2.9558300000e-02),
        (50.26457        , 0.2224995        , -0.2419916       , 7.1341130000e-02 , -1.7081360000e-02, -2.4770390000e-02),
        (22.58004        , 7.2931280000e-02 , 3.1837900000e-02 , -1.9731500000e-02, 4.8976660000e-03 , -8.4146240000e-03),
        (10.71432        , 0.1160683        , 0.4932686        , -0.2741869       , 6.7531080000e-02 , 0.1693855),
        (5.093546        , 0.1194774        , 0.4939655        , -0.4440977       , 0.1173318        , 0.1500787),
        (2.244183        , 2.0978680000e-02 , 9.1963130000e-02 , 7.7760840000e-02 , -2.9850250000e-02, 9.7877770000e-02),
        (1.05957         , -5.0917150000e-04, -5.3169920000e-03, 0.7068444        , -0.2277634       , -0.9653608),
        (0.468849        , 2.2178590000e-04 , 8.0856240000e-04 , 0.4413892        , -0.2928115       , 0.1489721),
        (0.106143        , -7.6368960000e-05, -6.9184590000e-04, 2.7997690000e-02 , 0.26653          , 2.191179),
        (5.5262000000e-02, 7.7195390000e-05 , 6.0865120000e-04 , -1.2107900000e-02, 0.5912406        , -1.243325),
        (2.5465000000e-02, -1.1490560000e-05, -1.3138420000e-04, 4.3247620000e-03 , 0.3037229        , -0.6711916),],
       [1,
        (11912.03        , 4.4000000000e-05 , -1.5000000000e-05, 4.0000000000e-06),
        (2819.947        , 3.9100000000e-04 , -1.3100000000e-04, 3.9000000000e-05),
        (915.9479        , 2.2480000000e-03 , -7.5500000000e-04, 2.2300000000e-04),
        (350.3842        , 9.8230000000e-03 , -3.3190000000e-03, 9.9200000000e-04),
        (148.4825        , 3.4338000000e-02 , -1.1750000000e-02, 3.4760000000e-03),
        (67.53944        , 9.6666000000e-02 , -3.3922000000e-02, 1.0172000000e-02),
        (32.30332        , 0.209417         , -7.6164000000e-02, 2.2576000000e-02),
        (15.92786        , 0.330189         , -0.125702        , 3.8238000000e-02),
        (8.038035        , 0.331936         , -0.133098        , 3.9337000000e-02),
        (4.093916        , 0.158488         , 1.7406000000e-02 , -6.1060000000e-03),
        (2.02239         , 2.2310000000e-02 , 0.315165         , -0.112962),
        (0.976102        , -1.5660000000e-03, 0.461814         , -0.168114),
        (0.459595        , -1.3240000000e-03, 0.299856         , -0.165932),
        (0.177152        , -2.7100000000e-04, 5.0000000000e-02 , 0.391403),
        (7.3517000000e-02, 3.2000000000e-05 , -4.2300000000e-03, 0.68184),
        (2.9401000000e-02, -1.2000000000e-05, 1.7250000000e-03 , 8.4031000000e-02),],
       [2,
        (64.013          , 3.8870000000e-03),
        (18.8179         , 2.6399000000e-02),
        (6.7287          , 9.7511000000e-02),
        (2.66413         , 0.232848),
        (1.07868         , 0.353152),
        (0.423209        , 0.372186),
        (0.155999        , 0.247672),
        (5.1884000000e-02, 5.8236000000e-02),]]

V = [[0,
       (3321857         , 8.0399990000e-06 , -4.5030030000e-06, 9.3206480000e-07 , -2.1589440000e-07, -4.0934160000e-07),
       (497435.6        , 6.2514020000e-05 , -3.5012950000e-05, 7.2493060000e-06 , -1.6785190000e-06, -3.2589560000e-06),
       (113202.7        , 3.2865530000e-04 , -1.8413390000e-04, 3.8119670000e-05 , -8.8312130000e-06, -1.6563900000e-05),
       (32063.33        , 1.3856970000e-03 , -7.7692160000e-04, 1.6102380000e-04 , -3.7277690000e-05, -7.3166890000e-05),
       (10459.62        , 5.0162170000e-03 , -2.8195050000e-03, 5.8522100000e-04 , -1.3560990000e-04, -2.5127840000e-04),
       (3775.506        , 1.6069310000e-02 , -9.0874860000e-03, 1.8975020000e-03 , -4.3923510000e-04, -8.7326570000e-04),
       (1472.04         , 4.5742420000e-02 , -2.6271340000e-02, 5.5509090000e-03 , -1.2869480000e-03, -2.3476540000e-03),
       (609.9331        , 0.1128544        , -6.7127260000e-02, 1.4605840000e-02 , -3.3821490000e-03, -6.8531500000e-03),
       (265.2634        , 0.2254344        , -0.145113        , 3.3429740000e-02 , -7.7656460000e-03, -1.3764200000e-02),
       (119.8607        , 0.3140461        , -0.2412483       , 6.2357220000e-02 , -1.4479850000e-02, -3.0846790000e-02),
       (55.44891        , 0.2267819        , -0.2416314       , 7.3124350000e-02 , -1.7155020000e-02, -2.5622080000e-02),
       (24.98372        , 7.3340690000e-02 , 3.0673620000e-02 , -1.9114720000e-02, 4.6101010000e-03 , -1.0051230000e-02),
       (11.88056        , 0.1102474        , 0.4970415        , -0.2817249       , 6.8278310000e-02 , 0.179533),
       (5.660311        , 0.1131358        , 0.4958875        , -0.4488151       , 0.1161368        , 0.15224),
       (2.495703        , 1.9712950000e-02 , 9.1818680000e-02 , 9.2026960000e-02 , -3.2770490000e-02, 9.4838870000e-02),
       (1.177866        , -4.7190880000e-04, -5.3925140000e-03, 0.7110117        , -0.228           , -1.014876),
       (0.520044        , 1.8616060000e-04 , 7.1023800000e-04 , 0.4309274        , -0.2793991       , 0.230881),
       (0.115965        , -6.2085980000e-05, -6.3631280000e-04, 2.6045890000e-02 , 0.2771165        , 2.113321),
       (5.8938000000e-02, 7.2953140000e-05 , 5.9799320000e-04 , -1.1010490000e-02, 0.5852999        , -1.253048),
       (2.6946000000e-02, -6.3620620000e-06, -1.1008790000e-04, 4.1063000000e-03 , 0.2963946        , -0.6139502),],
      [1,
       (13273.2         , 4.3000000000e-05 , -1.5000000000e-05, 4.0000000000e-06),
       (3142.126        , 3.8400000000e-04 , -1.3100000000e-04, 3.9000000000e-05),
       (1020.588        , 2.2100000000e-03 , -7.5500000000e-04, 2.2300000000e-04),
       (390.4407        , 9.6780000000e-03 , -3.3250000000e-03, 9.9600000000e-04),
       (165.5043        , 3.3936000000e-02 , -1.1811000000e-02, 3.4980000000e-03),
       (75.32006        , 9.5917000000e-02 , -3.4256000000e-02, 1.0296000000e-02),
       (36.05503        , 0.208853         , -7.7363000000e-02, 2.2962000000e-02),
       (17.80436        , 0.33066          , -0.128456        , 3.9208000000e-02),
       (9.002929        , 0.332312         , -0.135078        , 3.9943000000e-02),
       (4.594544        , 0.158188         , 2.0838000000e-02 , -7.1210000000e-03),
       (2.27676         , 2.2252000000e-02 , 0.320499         , -0.116225),
       (1.101178        , -1.5650000000e-03, 0.46026          , -0.169496),
       (0.518638        , -1.3530000000e-03, 0.295346         , -0.155374),
       (0.200565        , -2.6500000000e-04, 4.9046000000e-02 , 0.395022),
       (8.1291000000e-02, 2.9000000000e-05 , -3.8240000000e-03, 0.678908),
       (3.1795000000e-02, -1.1000000000e-05, 1.5850000000e-03 , 8.3122000000e-02),],
      [2,
       (77.6115         , 3.5950000000e-03),
       (22.9159         , 2.5210000000e-02),
       (8.27954         , 9.4786000000e-02),
       (3.30993         , 0.230363),
       (1.35863         , 0.352894),
       (0.54135         , 0.370414),
       (0.202356        , 0.245718),
       (6.7568000000e-02, 6.0993000000e-02),]]

Cr = [[0,
        (6177194         , 4.1286670000e-06 , -2.3017720000e-06, 4.8629570000e-07 , -1.1024510000e-07, 2.1798930000e-07),
        (924929.5        , 3.2107670000e-05 , -1.7895360000e-05, 3.7766450000e-06 , -8.5302330000e-07, 1.6129400000e-06),
        (210486.5        , 1.6884160000e-04 , -9.4161740000e-05, 1.9906640000e-05 , -4.5203580000e-06, 9.1118420000e-06),
        (59620.05        , 7.1285200000e-04 , -3.9750740000e-04, 8.3891640000e-05 , -1.8916120000e-05, 3.5006450000e-05),
        (19450.76        , 2.5893250000e-03 , -1.4470250000e-03, 3.0657060000e-04 , -6.9743440000e-05, 1.4353150000e-04),
        (7022.056        , 8.3773500000e-03 , -4.6946220000e-03, 9.9441070000e-04 , -2.2378670000e-04, 4.0358960000e-04),
        (2738.763        , 2.4417250000e-02 , -1.3823870000e-02, 2.9619590000e-03 , -6.7545030000e-04, 1.4251770000e-03),
        (1135.814        , 6.3651350000e-02 , -3.6746430000e-02, 7.9694730000e-03 , -1.7893460000e-03, 3.1140090000e-03),
        (495.0923        , 0.1427618        , -8.6471850000e-02, 1.9550170000e-02 , -4.4778580000e-03, 9.8144490000e-03),
        (224.7487        , 0.2541275        , -0.1696735       , 4.0850350000e-02 , -9.1401440000e-03, 1.4746980000e-02),
        (105.3836        , 0.3009512        , -0.2507089       , 6.9290030000e-02 , -1.6105620000e-02, 3.9115120000e-02),
        (50.19359        , 0.1766513        , -0.1961156       , 6.1469840000e-02 , -1.3348700000e-02, 9.1708880000e-03),
        (22.24957        , 6.9367090000e-02 , 0.1457244        , -6.9813020000e-02, 1.4260270000e-02 , 1.5598780000e-02),
        (10.98265        , 0.1179579        , 0.5466706        , -0.3517597       , 8.9316900000e-02 , -0.2816844),
        (5.383665        , 8.9161870000e-02 , 0.3979434        , -0.3828629       , 8.8852790000e-02 , -6.8952610000e-03),
        (2.343685        , 1.1036300000e-02 , 5.2770070000e-02 , 0.2676401        , -6.3687760000e-02, -0.1769781),
        (1.105202        , -3.5460480000e-04, -4.3745370000e-03, 0.717595         , -0.2783262       , 1.443061),
        (0.487848        , 1.0573110000e-04 , 3.2040350000e-04 , 0.3020814        , -0.1830071       , -1.029318),
        (8.9599000000e-02, 1.1146400000e-05 , -5.1420770000e-05, 7.7495140000e-03 , 0.6790937        , -1.307667),
        (3.3423000000e-02, 2.6613870000e-05 , 1.5841340000e-04 , 2.6960960000e-04 , 0.4672953        , 1.503842),],
       [1,
        (14454.2         , 4.4000000000e-05 , -1.5000000000e-05, 4.0000000000e-06),
        (3421.676        , 3.8900000000e-04 , -1.3500000000e-04, 4.0000000000e-05),
        (1111.387        , 2.2410000000e-03 , -7.7700000000e-04, 2.2900000000e-04),
        (425.1918        , 9.8210000000e-03 , -3.4270000000e-03, 1.0190000000e-03),
        (180.2623        , 3.4471000000e-02 , -1.2189000000e-02, 3.6020000000e-03),
        (82.06117        , 9.7460000000e-02 , -3.5388000000e-02, 1.0550000000e-02),
        (39.29726        , 0.211985         , -7.9915000000e-02, 2.3702000000e-02),
        (19.41959        , 0.33399          , -0.132335        , 3.9988000000e-02),
        (9.828899        , 0.330137         , -0.135401        , 4.0437000000e-02),
        (5.01681         , 0.152227         , 3.2008000000e-02 , -1.2074000000e-02),
        (2.487091        , 2.0425000000e-02 , 0.333849         , -0.118939),
        (1.19878         , -1.3600000000e-03, 0.461773         , -0.1781),
        (0.558695        , -1.1950000000e-03, 0.28129          , -0.123865),
        (0.208924        , -1.9700000000e-04, 4.1843000000e-02 , 0.429722),
        (8.4608000000e-02, 2.3000000000e-05 , -4.0020000000e-03, 0.650786),
        (3.3258000000e-02, -9.0000000000e-06, 1.5210000000e-03 , 6.4171000000e-02),],
       [2,
        (88.5768         , 3.6210000000e-03),
        (26.2045         , 2.5766000000e-02),
        (9.51747         , 9.7556000000e-02),
        (3.82248         , 0.236312),
        (1.57512         , 0.358286),
        (0.628928        , 0.368543),
        (0.234424        , 0.235494),
        (7.6815000000e-02, 5.3156000000e-02),]]

Mn = [[0,
        (3960805         , 8.2421270000e-06 , -3.9360950000e-06, 9.4627090000e-07 , -2.0953910000e-07, -4.1212310000e-07),
        (593115.5        , 6.4085870000e-05 , -3.0604810000e-05, 7.3605840000e-06 , -1.6294390000e-06, -3.2820990000e-06),
        (134976.8        , 3.3692530000e-04 , -1.6096260000e-04, 3.8699350000e-05 , -8.5705920000e-06, -1.6674330000e-05),
        (38230.67        , 1.4206480000e-03 , -6.7923480000e-04, 1.6351100000e-04 , -3.6192720000e-05, -7.3699990000e-05),
        (12471.54        , 5.1436830000e-03 , -2.4661820000e-03, 5.9417750000e-04 , -1.3161460000e-04, -2.5294950000e-04),
        (4501.743        , 1.6485690000e-02 , -7.9576290000e-03, 1.9277370000e-03 , -4.2668100000e-04, -8.8014250000e-04),
        (1755.212        , 4.6985600000e-02 , -2.3072480000e-02, 5.6417310000e-03 , -1.2502700000e-03, -2.3654820000e-03),
        (727.3039        , 0.1162437        , -5.9329560000e-02, 1.4878480000e-02 , -3.2946650000e-03, -6.9263540000e-03),
        (316.3678        , 0.2335277        , -0.1299451       , 3.4147830000e-02 , -7.5818600000e-03, -1.3938510000e-02),
        (143.0098        , 0.3292837        , -0.2212352       , 6.4057940000e-02 , -1.4228640000e-02, -3.1438400000e-02),
        (66.21805        , 0.2440304        , -0.229255        , 7.5576590000e-02 , -1.6937960000e-02, -2.6257490000e-02),
        (29.91896        , 7.2198060000e-02 , 3.5807330000e-02 , -1.9460700000e-02, 4.4542980000e-03 , -1.0483130000e-02),
        (14.30318        , 7.6878060000e-02 , 0.5107602        , -0.2957874       , 6.8670420000e-02 , 0.1856472),
        (6.839451        , 7.8522350000e-02 , 0.5008307        , -0.452117        , 0.1113335        , 0.1524839),
        (3.012374        , 1.2941090000e-02 , 9.0118300000e-02 , 0.1224531        , -3.9008200000e-02, 7.4113680000e-02),
        (1.418808        , -3.7848730000e-04, -6.9099090000e-03, 0.7169756        , -0.2215755       , -1.018097),
        (0.623624        , -2.5032030000e-05, -1.9129250000e-04, 0.4092712        , -0.2544359       , 0.2980372),
        (0.134098        , -2.4215170000e-05, -6.0323120000e-04, 2.2219690000e-02 , 0.2865866        , 1.971989),
        (6.5548000000e-02, 3.4620710000e-05 , 5.6216080000e-04 , -9.0112020000e-03, 0.5755741        , -1.179253),
        (2.9584000000e-02, 4.2614820000e-07 , -1.0211090000e-04, 3.6917270000e-03 , 0.2898778        , -0.5837703),],
       [1,
        (16205.86        , 4.2000000000e-05 , -1.5000000000e-05, 4.0000000000e-06),
        (3836.274        , 3.7300000000e-04 , -1.2900000000e-04, 4.0000000000e-05),
        (1246.048        , 2.1490000000e-03 , -7.4800000000e-04, 2.2600000000e-04),
        (476.7535        , 9.4450000000e-03 , -3.3080000000e-03, 1.0130000000e-03),
        (202.1895        , 3.3297000000e-02 , -1.1811000000e-02, 3.5750000000e-03),
        (92.09487        , 9.4759000000e-02 , -3.4533000000e-02, 1.0612000000e-02),
        (44.1472         , 0.208144         , -7.8785000000e-02, 2.3902000000e-02),
        (21.85468        , 0.331805         , -0.132183        , 4.1279000000e-02),
        (11.08596        , 0.333175         , -0.137195        , 4.1475000000e-02),
        (5.674108        , 0.157601         , 2.7075000000e-02 , -9.4580000000e-03),
        (2.82317         , 2.1445000000e-02 , 0.328891         , -0.123695),
        (1.368621        , -2.5580000000e-03, 0.45728          , -0.174392),
        (0.644431        , -2.0270000000e-03, 0.288908         , -0.12917),
        (0.248382        , -3.6000000000e-04, 4.7433000000e-02 , 0.400348),
        (9.7255000000e-02, 3.4000000000e-05 , -3.5220000000e-03, 0.669646),
        (3.6633000000e-02, -1.3000000000e-05, 1.4560000000e-03 , 8.2732000000e-02),],
       [2,
        (100.663         , 3.5790000000e-03),
        (29.8336         , 2.5827000000e-02),
        (10.8894         , 9.8559000000e-02),
        (4.39358         , 0.238327),
        (1.81782         , 0.358707),
        (0.727827        , 0.365092),
        (0.271295        , 0.233738),
        (8.8309000000e-02, 5.6618000000e-02),]]

Fe = [[0,
        (4316265         , 8.0488030000e-06 , -4.1559540000e-06, 9.5321780000e-07 , -2.0630080000e-07, -4.0093670000e-07),
        (646342.4        , 6.2583060000e-05 , -3.2314010000e-05, 7.4146050000e-06 , -1.6041690000e-06, -3.1892550000e-06),
        (147089.7        , 3.2902390000e-04 , -1.6995250000e-04, 3.8983930000e-05 , -8.4384370000e-06, -1.6230790000e-05),
        (41661.52        , 1.3873550000e-03 , -7.1713690000e-04, 1.6471520000e-04 , -3.5631510000e-05, -7.1579200000e-05),
        (13590.77        , 5.0232560000e-03 , -2.6036250000e-03, 5.9859800000e-04 , -1.2959980000e-04, -2.4639580000e-04),
        (4905.75         , 1.6101400000e-02 , -8.3991090000e-03, 1.9423900000e-03 , -4.2015340000e-04, -8.5449070000e-04),
        (1912.746        , 4.5900340000e-02 , -2.4341090000e-02, 5.6872370000e-03 , -1.2319540000e-03, -2.3075930000e-03),
        (792.6043        , 0.1136154        , -6.2519480000e-02, 1.5013290000e-02 , -3.2489220000e-03, -6.7282920000e-03),
        (344.8065        , 0.2283869        , -0.1365929       , 3.4524550000e-02 , -7.4937170000e-03, -1.3661650000e-02),
        (155.8999        , 0.3221159        , -0.2312707       , 6.4958200000e-02 , -1.4101020000e-02, -3.0622400000e-02),
        (72.23091        , 0.2383661        , -0.2383734       , 7.7161940000e-02 , -1.6916000000e-02, -2.6311370000e-02),
        (32.72506        , 7.4046670000e-02 , 3.1238370000e-02 , -1.8734110000e-02, 4.2189960000e-03 , -9.7601830000e-03),
        (15.66762        , 9.2141970000e-02 , 0.5086818        , -0.3009185       , 6.8338100000e-02 , 0.1801906),
        (7.503483        , 9.3397900000e-02 , 0.4987695        , -0.4554661       , 0.1098201        , 0.1529634),
        (3.312223        , 1.5739650000e-02 , 9.0335520000e-02 , 0.1286463        , -4.0090050000e-02, 5.5054130000e-02),
        (1.558471        , -4.1866820000e-04, -6.0053370000e-03, 0.7183316        , -0.2174739       , -0.9551364),
        (0.683914        , 5.3763180000e-05 , 2.3124540000e-04 , 0.4051743        , -0.2465135       , 0.2586813),
        (0.146757        , -3.8166540000e-05, -5.6436800000e-04, 2.1682270000e-02 , 0.2731435        , 1.834049),
        (7.0583000000e-02, 4.3196030000e-05 , 4.9922600000e-04 , -8.3435660000e-03, 0.5748321        , -0.933324),
        (3.1449000000e-02, -3.4010190000e-06, -1.0152930000e-04, 3.6589790000e-03 , 0.3012713        , -0.6981605),],
       [1,
        (17745.69        , 4.1000000000e-05 , -1.5000000000e-05, 5.0000000000e-06),
        (4200.721        , 3.6900000000e-04 , -1.3000000000e-04, 4.2000000000e-05),
        (1364.429        , 2.1290000000e-03 , -7.5100000000e-04, 2.4100000000e-04),
        (522.0806        , 9.3690000000e-03 , -3.3290000000e-03, 1.0850000000e-03),
        (221.4595        , 3.3097000000e-02 , -1.1912000000e-02, 3.8310000000e-03),
        (100.9096        , 9.4431000000e-02 , -3.4933000000e-02, 1.1423000000e-02),
        (48.40115        , 0.208077         , -7.9989000000e-02, 2.5792000000e-02),
        (23.98536        , 0.332333         , -0.134636        , 4.4818000000e-02),
        (12.1825         , 0.332987         , -0.138598        , 4.4598000000e-02),
        (6.242298        , 0.156843         , 3.0278000000e-02 , -1.1177000000e-02),
        (3.110944        , 2.1549000000e-02 , 0.333216         , -0.138134),
        (1.509958        , -2.0950000000e-03, 0.456153         , -0.188285),
        (0.710845        , -1.7390000000e-03, 0.285051         , -0.107399),
        (0.27319         , -3.0000000000e-04, 4.6144000000e-02 , 0.444863),
        (0.104233        , 2.9000000000e-05 , -3.2490000000e-03, 0.640239),
        (3.8291000000e-02, -1.1000000000e-05, 1.3570000000e-03 , 6.4457000000e-02),],
       [2,
        (113.344 , 3.5300000000e-03),
        (33.6414 , 2.5784000000e-02),
        (12.331  , 9.9119000000e-02),
        (4.99478 , 0.239073),
        (2.0728  , 0.357199),
        (0.830753, 0.362188),
        (0.309178, 0.236461),
        (0.10013 , 6.0118000000e-02),]]

Co = [[0,
        (4675675         , 7.9790260000e-06 , -4.2002400000e-06, 9.5926920000e-07 , -2.0288400000e-07, -3.8630530000e-07),
        (700161.5        , 6.2040710000e-05 , -3.2658310000e-05, 7.4618510000e-06 , -1.5775800000e-06, -3.0687880000e-06),
        (159337.3        , 3.2617350000e-04 , -1.7176440000e-04, 3.9231370000e-05 , -8.2988130000e-06, -1.5648260000e-05),
        (45130.46        , 1.3753600000e-03 , -7.2478530000e-04, 1.6577060000e-04 , -3.5041540000e-05, -6.8835880000e-05),
        (14722.38        , 4.9799970000e-03 , -2.6314620000e-03, 6.0243350000e-04 , -1.2746550000e-04, -2.3773670000e-04),
        (5314.222        , 1.5964340000e-02 , -8.4892720000e-03, 1.9552170000e-03 , -4.1326950000e-04, -8.2131730000e-04),
        (2072.018        , 4.5520860000e-02 , -2.4606190000e-02, 5.7263260000e-03 , -1.2122610000e-03, -2.2296300000e-03),
        (858.6188        , 0.1127385        , -6.3220590000e-02, 1.5129840000e-02 , -3.1993180000e-03, -6.4678410000e-03),
        (373.5497        , 0.2268262        , -0.1381957       , 3.4839730000e-02 , -7.3909720000e-03, -1.3254630000e-02),
        (168.9229        , 0.3203074        , -0.234068        , 6.5703510000e-02 , -1.3936490000e-02, -2.9466860000e-02),
        (78.29639        , 0.2374021        , -0.2415002       , 7.8315030000e-02 , -1.6785750000e-02, -2.5990660000e-02),
        (35.52123        , 7.4776860000e-02 , 3.0353120000e-02 , -1.8770370000e-02, 4.1498560000e-03 , -8.4998070000e-03),
        (17.04144        , 9.5818720000e-02 , 0.5101341        , -0.3062663       , 6.7976460000e-02 , 0.1727316),
        (8.173           , 9.6499110000e-02 , 0.4974939        , -0.4566429       , 0.1075807        , 0.1512189),
        (3.610318        , 1.6233620000e-02 , 8.9707460000e-02 , 0.1378169        , -4.1660220000e-02, 3.5545090000e-02),
        (1.697047        , -4.5354970000e-04, -5.9410340000e-03, 0.7193676        , -0.2128044       , -0.8829353),
        (0.743532        , 5.1135190000e-05 , 2.1753620000e-04 , 0.3992579        , -0.238136        , 0.214353),
        (0.158344        , -4.1745080000e-05, -5.4801550000e-04, 2.0799330000e-02 , 0.2650788        , 1.711865),
        (7.5036000000e-02, 4.0275770000e-05 , 4.5258040000e-04 , -7.8206630000e-03, 0.5722774        , -0.7140037),
        (3.3091000000e-02, -5.7890670000e-06, -1.0667480000e-04, 3.5339110000e-03 , 0.3091556        , -0.8027727),],
       [1,
        (19267.78        , 4.1000000000e-05 , -1.5000000000e-05, 5.0000000000e-06),
        (4560.986        , 3.6900000000e-04 , -1.3100000000e-04, 4.5000000000e-05),
        (1481.436        , 2.1280000000e-03 , -7.5800000000e-04, 2.5500000000e-04),
        (566.8671        , 9.3720000000e-03 , -3.3630000000e-03, 1.1440000000e-03),
        (240.491         , 3.3155000000e-02 , -1.2054000000e-02, 4.0610000000e-03),
        (109.6105        , 9.4752000000e-02 , -3.5424000000e-02, 1.2095000000e-02),
        (52.59491        , 0.209093         , -8.1287000000e-02, 2.7476000000e-02),
        (26.08361        , 0.333722         , -0.136908        , 4.7557000000e-02),
        (13.26143        , 0.332208         , -0.139019        , 4.7302000000e-02),
        (6.799778        , 0.154613         , 3.5468000000e-02 , -1.4418000000e-02),
        (3.393414        , 2.0902000000e-02 , 0.338498         , -0.150062),
        (1.648766        , -2.0240000000e-03, 0.454433         , -0.199092),
        (0.776282        , -1.6970000000e-03, 0.279793         , -7.9783000000e-02),
        (0.298003        , -2.8000000000e-04, 4.4776000000e-02 , 0.459035),
        (0.113618        , 2.6000000000e-05 , -3.1510000000e-03, 0.617495),
        (4.1624000000e-02, -1.0000000000e-05, 1.3170000000e-03 , 6.4690000000e-02),],
       [2,
        (126.264 , 3.5100000000e-03),
        (37.5226 , 2.5884000000e-02),
        (13.8021 , 0.100058),
        (5.60927 , 0.240547),
        (2.33369 , 0.356843),
        (0.936415, 0.359579),
        (0.348237, 0.236629),
        (0.112353, 6.2129000000e-02),]]

Ni = [[0,
        (5045991         , 8.2089960000e-06 , -3.6578490000e-06, 9.5941490000e-07 , -2.0137530000e-07, -3.9242450000e-07),
        (755614.2        , 6.3828840000e-05 , -2.8440940000e-05, 7.4626140000e-06 , -1.5658320000e-06, -3.1139090000e-06),
        (171956.8        , 3.3558000000e-04 , -1.4959280000e-04, 3.9238430000e-05 , -8.2371820000e-06, -1.5904470000e-05),
        (48704.79        , 1.4150750000e-03 , -6.3130090000e-04, 1.6578680000e-04 , -3.4781050000e-05, -6.9813940000e-05),
        (15888.41        , 5.1244440000e-03 , -2.2930520000e-03, 6.0259050000e-04 , -1.2652650000e-04, -2.4178480000e-04),
        (5735.123        , 1.6432560000e-02 , -7.4051230000e-03, 1.9556620000e-03 , -4.1025890000e-04, -8.3261950000e-04),
        (2236.137        , 4.6893980000e-02 , -2.1520320000e-02, 5.7303910000e-03 , -1.2038340000e-03, -2.2702940000e-03),
        (926.6468        , 0.1163534        , -5.5609740000e-02, 1.5147560000e-02 , -3.1790620000e-03, -6.5574270000e-03),
        (403.1743        , 0.2350511        , -0.1230176       , 3.4934990000e-02 , -7.3538280000e-03, -1.3542880000e-02),
        (182.3476        , 0.3350184        , -0.2130104       , 6.5980720000e-02 , -1.3890220000e-02, -2.9897680000e-02),
        (84.54885        , 0.2534779        , -0.2265837       , 7.8930830000e-02 , -1.6778750000e-02, -2.6931060000e-02),
        (38.39634        , 7.3009010000e-02 , 3.5467960000e-02 , -1.9062490000e-02, 4.1633780000e-03 , -7.8276930000e-03),
        (18.45859        , 6.1842440000e-02 , 0.5181697        , -0.3095921       , 6.8147030000e-02 , 0.1741667),
        (8.863548        , 6.3029560000e-02 , 0.502563         , -0.455861        , 0.1061029        , 0.1595468),
        (3.916227        , 1.0080630000e-02 , 8.9556740000e-02 , 0.1482931        , -4.3399800000e-02, 1.9955500000e-02),
        (1.83887         , -2.2445280000e-04, -7.0313110000e-03, 0.7134039        , -0.209495        , -0.8897),
        (0.804362        , -5.9327670000e-05, -4.3391670000e-04, 0.3976063        , -0.2310271       , 0.2486892),
        (0.169797        , -1.1585620000e-05, -5.8317110000e-04, 2.2955230000e-02 , 0.2590532        , 1.613012),
        (7.9306000000e-02, 8.1151090000e-06 , 4.2287880000e-04 , -9.1517580000e-03, 0.5691426        , -0.5990277),
        (3.4677000000e-02, -1.6816990000e-06, -1.2667140000e-04, 3.8754140000e-03 , 0.3158125        , -0.8369078),],
       [1,
        (21027.92        , 4.1000000000e-05 , -1.5000000000e-05, 6.0000000000e-06),
        (4977.56         , 3.6300000000e-04 , -1.2900000000e-04, 5.3000000000e-05),
        (1616.74         , 2.0970000000e-03 , -7.4900000000e-04, 3.0500000000e-04),
        (618.6718        , 9.2500000000e-03 , -3.3280000000e-03, 1.3640000000e-03),
        (262.5183        , 3.2796000000e-02 , -1.1947000000e-02, 4.8760000000e-03),
        (119.6907        , 9.4004000000e-02 , -3.5242000000e-02, 1.4503000000e-02),
        (57.46585        , 0.20828          , -8.1204000000e-02, 3.3296000000e-02),
        (28.52829        , 0.333654         , -0.137493        , 5.7482000000e-02),
        (14.52148        , 0.332904         , -0.139226        , 5.8702000000e-02),
        (7.45385         , 0.155372         , 3.6016000000e-02 , -1.9904000000e-02),
        (3.723553        , 2.0859000000e-02 , 0.339128         , -0.194695),
        (1.809813        , -2.4400000000e-03, 0.450472         , -0.239613),
        (0.851336        , -1.9980000000e-03, 0.281783         , -2.2320000000e-03),
        (0.324814        , -3.3800000000e-04, 4.7898000000e-02 , 0.521435),
        (0.119522        , 3.5000000000e-05 , -2.9870000000e-03, 0.54554),
        (4.2366000000e-02, -1.2000000000e-05, 1.3090000000e-03 , 4.3622000000e-02),],
       [2,
        (140.2527, 3.3760000000e-03),
        (41.7261 , 2.5141000000e-02),
        (15.3981 , 9.7746000000e-02),
        (6.2771  , 0.234709),
        (2.6185  , 0.346945),
        (1.0526  , 0.351068),
        (0.3916  , 0.250255),
        (0.1262  , 0.100082),]]

Cu = [[0,
        (5430321         , 7.8010260000e-06 , -4.4047060000e-06, 9.7046820000e-07 , -1.9593540000e-07, -3.5322290000e-07),
        (813166.5        , 6.0656660000e-05 , -3.4248010000e-05, 7.5492450000e-06 , -1.5234720000e-06, -2.7988120000e-06),
        (185054.4        , 3.1889640000e-04 , -1.8012380000e-04, 3.9688920000e-05 , -8.0148080000e-06, -1.4325170000e-05),
        (52414.66        , 1.3446870000e-03 , -7.6004550000e-04, 1.6772000000e-04 , -3.3839920000e-05, -6.2709460000e-05),
        (17098.68        , 4.8690500000e-03 , -2.7593480000e-03, 6.0951010000e-04 , -1.2311910000e-04, -2.1794900000e-04),
        (6171.994        , 1.5610130000e-02 , -8.9009700000e-03, 1.9788460000e-03 , -3.9920850000e-04, -7.4743160000e-04),
        (2406.481        , 4.4520770000e-02 , -2.5793780000e-02, 5.7980490000e-03 , -1.1719000000e-03, -2.0492710000e-03),
        (997.2584        , 0.1103111        , -6.6238610000e-02, 1.5341580000e-02 , -3.0961410000e-03, -5.8852030000e-03),
        (433.9289        , 0.2220342        , -0.1445927       , 3.5404840000e-02 , -7.1719930000e-03, -1.2268850000e-02),
        (196.2869        , 0.3133739        , -0.244011        , 6.7020980000e-02 , -1.3566210000e-02, -2.6831470000e-02),
        (91.0428         , 0.2315121        , -0.2504837       , 8.0269450000e-02 , -1.6439890000e-02, -2.4792610000e-02),
        (41.38425        , 7.6409200000e-02 , 2.8525770000e-02 , -1.9272310000e-02, 4.1076280000e-03 , -5.9847460000e-03),
        (19.93278        , 0.1103818        , 0.5115874        , -0.3160129       , 6.6939640000e-02 , 0.1557124),
        (9.581891        , 0.1094372        , 0.4928061        , -0.4573162       , 0.1028221        , 0.1436683),
        (4.234516        , 1.8363110000e-02 , 8.7884370000e-02 , 0.1550841        , -4.4229450000e-02, 8.3741030000e-03),
        (1.985814        , -6.0430840000e-04, -5.8202810000e-03, 0.7202872        , -0.2031191       , -0.7460711),
        (0.867083        , 5.0922450000e-05 , 2.0135080000e-04 , 0.3885122        , -0.2230022       , 0.1244367),
        (0.181339        , -5.5407300000e-05, -5.1825530000e-04, 1.9243260000e-02 , 0.2517975        , 1.51011),
        (8.3657000000e-02, 3.9694820000e-05 , 3.7315030000e-04 , -7.1038070000e-03, 0.5650091        , -0.3477122),
        (3.6267000000e-02, -1.2695380000e-05, -1.1931710000e-04, 3.2729060000e-03 , 0.3247243        , -0.9774169),],
       [1,
        (22760.57        , 4.0000000000e-05 , -1.5000000000e-05, 5.0000000000e-06),
        (5387.679        , 3.6100000000e-04 , -1.3100000000e-04, 4.9000000000e-05),
        (1749.945        , 2.0830000000e-03 , -7.5500000000e-04, 2.7800000000e-04),
        (669.6653        , 9.1970000000e-03 , -3.3590000000e-03, 1.2530000000e-03),
        (284.1948        , 3.2660000000e-02 , -1.2081000000e-02, 4.4470000000e-03),
        (129.6077        , 9.3795000000e-02 , -3.5703000000e-02, 1.3370000000e-02),
        (62.25415        , 0.208274         , -8.2502000000e-02, 3.0469000000e-02),
        (30.92964        , 0.333993         , -0.13989         , 5.3447000000e-02),
        (15.75827        , 0.332493         , -0.140729        , 5.2639000000e-02),
        (8.094211        , 0.154728         , 3.8766000000e-02 , -1.6881000000e-02),
        (4.046921        , 2.1271000000e-02 , 0.342695         , -0.179448),
        (1.967869        , -1.6900000000e-03, 0.45231          , -0.209588),
        (0.925295        , -1.5160000000e-03, 0.277054         , -3.9633000000e-02),
        (0.352992        , -2.4200000000e-04, 4.3885000000e-02 , 0.50213),
        (0.127307        , 2.3000000000e-05 , -2.8020000000e-03, 0.581111),
        (4.4356000000e-02, -9.0000000000e-06, 1.1520000000e-03 , 4.5666000000e-02),],
       [2,
        (173.897 , 2.7000000000e-03),
        (51.8869 , 2.0909000000e-02),
        (19.3419 , 8.4408000000e-02),
        (7.97572 , 0.213999),
        (3.39823 , 0.33598),
        (1.40932 , 0.357301),
        (0.548858, 0.264578),
        (0.190199, 0.103972),]]

Zn = [[0,
        (5820021         , 8.5492410000e-06 , -2.6400690000e-06, 9.9671030000e-07 , 1.9958180000e-07 , -5.4359100000e-07),
        (871523.4        , 6.6474100000e-05 , -2.0527200000e-05, 7.7541630000e-06 , 1.5529730000e-06 , -4.3368940000e-06),
        (198335          , 3.4949620000e-04 , -1.0798590000e-04, 4.0760190000e-05 , 8.1612590000e-06 , -2.1975720000e-05),
        (56176.31        , 1.4738320000e-03 , -4.5585770000e-04, 1.7228110000e-04 , 3.4507470000e-05 , -9.7473920000e-05),
        (18325.82        , 5.3383300000e-03 , -1.6577580000e-03, 6.2593700000e-04 , 1.2532750000e-04 , -3.3316150000e-04),
        (6614.955        , 1.7127080000e-02 , -5.3684920000e-03, 2.0328550000e-03 , 4.0729900000e-04 , -1.1661920000e-03),
        (2579.199        , 4.8940850000e-02 , -1.5712490000e-02, 5.9546460000e-03 , 1.1927340000e-03 , -3.1193080000e-03),
        (1068.849        , 0.1217934        , -4.1225580000e-02, 1.5766400000e-02 , 3.1631400000e-03 , -9.2395040000e-03),
        (465.1045        , 0.2476589        , -9.4064590000e-02, 3.6376380000e-02 , 7.3039420000e-03 , -1.8554710000e-02),
        (210.413         , 0.3582431        , -0.1719954       , 6.8923430000e-02 , 1.3912790000e-02 , -4.2811890000e-02),
        (97.61629        , 0.2798174        , -0.1958523       , 8.2380930000e-02 , 1.6706200000e-02 , -3.5710950000e-02),
        (44.3802         , 6.8574910000e-02 , 4.5329070000e-02 , -2.0113600000e-02, -4.0355860000e-03, -1.6383500000e-02),
        (21.42308        , -1.3110920000e-03, 0.5244442        , -0.3252526       , -6.9688610000e-02, 0.2644664),
        (10.30891        , 1.9140010000e-03 , 0.5006142        , -0.4602899       , -0.1030105       , 0.2086588),
        (4.553645        , -8.7592200000e-04, 8.9455270000e-02 , 0.1635546        , 4.4714420000e-02 , -1.7743820000e-02),
        (2.132821        , 3.7400960000e-04 , -2.1462620000e-03, 0.7297118        , 0.2150027        , -1.353873),
        (0.929697        , -1.4013990000e-04, 2.1121130000e-03 , 0.3769751        , 0.2220163        , 0.8182926),
        (0.192147        , 4.7571320000e-05 , -4.1339800000e-04, 1.4332240000e-02 , -0.3114776       , 1.695036),
        (8.7595000000e-02, -3.6427110000e-05, 3.2097520000e-04 , -6.6712100000e-03, -0.5693429       , -1.388656),
        (3.7702000000e-02, 1.1532480000e-05 , -1.0161400000e-04, 1.7662140000e-03 , -0.267844        , -0.21889),],
       [1,
        (24411.98        , -1.5000000000e-05, 5.0000000000e-06 , 1.2000000000e-05),
        (5778.518        , -1.3500000000e-04, 4.2000000000e-05 , 9.6000000000e-05),
        (1876.862        , -7.8200000000e-04, 2.3800000000e-04 , 5.9400000000e-04),
        (718.2361        , -3.4780000000e-03, 1.0880000000e-03 , 2.4840000000e-03),
        (304.8327        , -1.2520000000e-02, 3.8210000000e-03 , 9.5370000000e-03),
        (139.0453        , -3.7016000000e-02, 1.1644000000e-02 , 2.6479000000e-02),
        (66.80417        , -8.5559000000e-02, 2.6167000000e-02 , 6.6366000000e-02),
        (33.20699        , -0.144718        , 4.6750000000e-02 , 0.102458),
        (16.92816        , -0.143442        , 4.3309000000e-02 , 0.138683),
        (8.696229        , 4.3595000000e-02 , -1.3429000000e-02, -8.0140000000e-02),
        (4.35051         , 0.348888         , -0.153897        , -0.496069),
        (2.116523        , 0.453865         , -0.167413        , -0.46351),
        (0.995387        , 0.268594         , -8.4995000000e-02, 0.874531),
        (0.378112        , 3.8868000000e-02 , 0.450813         , 0.62979),
        (0.134579        , -2.4920000000e-03, 0.640869         , -0.811686),
        (4.6282000000e-02, 1.0140000000e-03 , 5.4172000000e-02 , -0.108948),],
       [2,
        (205.6177, 2.3420000000e-03),
        (61.44981, 1.8606000000e-02),
        (23.05689, 7.7102000000e-02),
        (9.577739, 0.202026),
        (4.133734, 0.329454),
        (1.747518, 0.360976),
        (0.69956 , 0.271657),
        (0.251608, 0.104981),]]

Ga = [[0,
        (6558157.3       , 8.0000000000e-06 , -2.5000000000e-06, 9.0000000000e-07 , 2.0000000000e-07),
        (982025.34       , 6.2200000000e-05 , -1.9300000000e-05, 7.4000000000e-06 , 1.7000000000e-06),
        (223467.69       , 3.2700000000e-04 , -1.0140000000e-04, 3.8700000000e-05 , 9.0000000000e-06),
        (63288.291       , 1.3794000000e-03 , -4.2810000000e-04, 1.6330000000e-04 , 3.8000000000e-05),
        (20642.94        , 4.9993000000e-03 , -1.5582000000e-03, 5.9440000000e-04 , 1.3820000000e-04),
        (7450.5224       , 1.6060500000e-02 , -5.0469000000e-03, 1.9292000000e-03 , 4.4890000000e-04),
        (2905.0744       , 4.6012400000e-02 , -1.4805600000e-02, 5.6689000000e-03 , 1.3188000000e-03),
        (1204.21         , 0.1152224        , -3.8948200000e-02, 1.5028200000e-02 , 3.5016000000e-03),
        (524.30454       , 0.2373921        , -8.9683200000e-02, 3.5022200000e-02 , 8.1673000000e-03),
        (237.46563       , 0.3531989        , -0.1664076       , 6.7113500000e-02 , 1.5733800000e-02),
        (110.57866       , 0.29155          , -0.200401        , 8.5015600000e-02 , 2.0028400000e-02),
        (51.374624       , 8.1212900000e-02 , 1.1494300000e-02 , -4.7212000000e-03, -1.0136000000e-03),
        (24.440846       , 7.6550000000e-04 , 0.4958134        , -0.3016737       , -7.5016200000e-02),
        (11.768591       , 1.6124000000e-03 , 0.529555         , -0.4825489       , -0.125798),
        (5.342119        , -7.5300000000e-04, 0.1110185        , 8.9169500000e-02 , 3.0085700000e-02),
        (2.495036        , 3.1340000000e-04 , -7.0000000000e-04, 0.728783         , 0.2488169),
        (1.098773        , -1.3060000000e-04, 2.2283000000e-03 , 0.4288542        , 0.2843706),
        (0.26018         , 5.1300000000e-05 , -5.0140000000e-04, 2.0724900000e-02 , -0.3110594),
        (0.127079        , -3.7900000000e-05, 3.7090000000e-04 , -8.7128000000e-03, -0.5862062),
        (5.4408000000e-02, 1.0900000000e-05 , -1.0700000000e-04, 2.0365000000e-03 , -0.2783824),],
       [1,
        (8050.1674       , 3.1690000000e-04 , -1.2030000000e-04, 2.0000000000e-05),
        (1907.5361       , 2.7648000000e-03 , -1.0492000000e-03, 1.6890000000e-04),
        (618.62746       , 1.5120400000e-02 , -5.8102000000e-03, 9.6680000000e-04),
        (235.32417       , 5.9958300000e-02 , -2.3434500000e-02, 3.7797000000e-03),
        (98.899646       , 0.173312         , -7.0827000000e-02, 1.1908200000e-02),
        (44.248215       , 0.341082         , -0.1465511       , 2.3569300000e-02),
        (20.617429       , 0.3896967        , -0.176966        , 3.1423300000e-02),
        (9.780516        , 0.1839817        , 3.6382100000e-02 , -1.3618800000e-02),
        (4.441238        , 2.1889600000e-02 , 0.4232848        , -7.3400300000e-02),
        (1.964045        , 1.1608000000e-03 , 0.4952586        , -0.1264785),
        (0.833578        , 2.7350000000e-04 , 0.1797428        , 1.5857900000e-02),
        (0.193445        , 1.2600000000e-05 , 6.2132000000e-03 , 0.5073757),
        (5.6117000000e-02, -4.6000000000e-06, -7.4060000000e-04, 0.6002606),],
       [2,
        (244.14741, 2.0270000000e-03),
        (73.067595, 1.6508800000e-02),
        (27.592081, 7.0382300000e-02),
        (11.546518, 0.191143),
        (5.048628 , 0.3254092),
        (2.178465 , 0.3678199),
        (0.900253 , 0.2744685),
        (0.337327 , 9.5623200000e-02),]]

Ge = [[0,
        (7447966.8       , 7.4000000000e-06 , -2.3000000000e-06, 9.0000000000e-07 , -2.0000000000e-07),
        (1115318.2       , 5.7400000000e-05 , -1.7900000000e-05, 6.9000000000e-06 , -1.8000000000e-06),
        (253842.65       , 3.0190000000e-04 , -9.4000000000e-05, 3.6200000000e-05 , -9.3000000000e-06),
        (71915.285       , 1.2733000000e-03 , -3.9640000000e-04, 1.5280000000e-04 , -3.9200000000e-05),
        (23470.181       , 4.6123000000e-03 , -1.4425000000e-03, 5.5630000000e-04 , -1.4260000000e-04),
        (8477.4918       , 1.4821400000e-02 , -4.6675000000e-03, 1.8018000000e-03 , -4.6210000000e-04),
        (3308.3908       , 4.2553600000e-02 , -1.3715300000e-02, 5.3085000000e-03 , -1.3614000000e-03),
        (1372.6054       , 0.1073055        , -3.6179700000e-02, 1.4087700000e-02 , -3.6175000000e-03),
        (598.22007       , 0.2245178        , -8.4167900000e-02, 3.3201300000e-02 , -8.5359000000e-03),
        (271.38602       , 0.3453131        , -0.1588767       , 6.4462100000e-02 , -1.6650600000e-02),
        (126.97795       , 0.3045261        , -0.2033807       , 8.6954000000e-02 , -2.2591100000e-02),
        (60.222065       , 9.9067000000e-02 , -2.5141000000e-02, 1.1874500000e-02 , -3.2147000000e-03),
        (28.018582       , 4.1317000000e-03 , 0.4575152        , -0.2724534       , 7.4499800000e-02),
        (13.517522       , 1.0347000000e-03 , 0.5571939        , -0.5001452       , 0.1440333),
        (6.309406        , -4.8560000000e-04, 0.1397055        , 1.0855400000e-02 , -8.0815000000e-03),
        (2.904534        , 1.8050000000e-04 , 2.2645000000e-03 , 0.7216469        , -0.2704163),
        (1.287556        , -9.1200000000e-05, 2.0927000000e-03 , 0.4805213        , -0.3401607),
        (0.336552        , 3.7800000000e-05 , -4.7390000000e-04, 2.7773800000e-02 , 0.2922084),
        (0.167732        , -2.6600000000e-05, 3.2810000000e-04 , -1.0229700000e-02, 0.6190657),
        (7.1069000000e-02, 7.2000000000e-06 , -9.1600000000e-05, 2.2444000000e-03 , 0.2863276),],
       [1,
        (6979.5982       , 4.5690000000e-04 , -1.7560000000e-04, 3.4800000000e-05),
        (1654.1648       , 3.9562000000e-03 , -1.5305000000e-03, 3.0140000000e-04),
        (536.02865       , 2.1314300000e-02 , -8.3145000000e-03, 1.6487000000e-03),
        (203.53713       , 8.1871500000e-02 , -3.2871800000e-02, 6.4982000000e-03),
        (85.23753        , 0.2223732        , -9.3166100000e-02, 1.8638300000e-02),
        (37.841962       , 0.3905659        , -0.1755542       , 3.5061300000e-02),
        (17.406512       , 0.3560415        , -0.1467912       , 2.9589200000e-02),
        (7.881492        , 0.1070312        , 0.1862934        , -4.7245800000e-02),
        (3.533213        , 3.6941000000e-03 , 0.5264862        , -0.1249847),
        (1.521473        , 1.9219000000e-03 , 0.3970859        , -0.1210801),
        (0.562704        , -4.1640000000e-04, 5.7147500000e-02 , 0.1368669),
        (0.199093        , 1.9170000000e-04 , -3.3478000000e-03, 0.575473),
        (6.7031000000e-02, -6.1200000000e-05, 1.2738000000e-03 , 0.4442689),],
       [2,
        (282.23911, 1.8275000000e-03),
        (84.549957, 1.5154500000e-02),
        (32.073656, 6.6046000000e-02),
        (13.497495, 0.183947),
        (5.95855  , 0.3227872),
        (2.610788 , 0.3729459),
        (1.103987 , 0.275173),
        (0.424049 , 8.8523400000e-02),]]

As = [[0,
        (8482339.6 , 6.8000000e-06, -2.1000000e-06, 8.00000000e-07, -2.000000e-07),
        (1270150.9 , 5.2800000e-05, -1.6500000e-05, 6.40000000e-06, -1.800000e-06),
        (289056.96 , 2.7740000e-04, -8.6600000e-05, 3.37000000e-05, -9.300000e-06),
        (81879.849 , 1.1702000e-03, -3.6530000e-04, 1.42300000e-04, -3.920000e-05),
        (26716.564 , 4.2421000e-03, -1.3309000e-03, 5.18800000e-04, -1.429000e-04),
        (9647.5842 , 1.3655700e-02, -4.3093000e-03, 1.68020000e-03, -4.629000e-04),
        (3764.1195 , 3.9339900e-02, -1.2697300e-02, 4.96770000e-03, -1.368700e-03),
        (1561.5656 , 9.9929200e-02, -3.3616000e-02, 1.32115000e-02, -3.644000e-03),
        (680.81467 , 0.2121555    , -7.8947000e-02, 3.14566000e-02, -8.688400e-03),
        (309.24119 , 0.3363866    , -0.1514458    , 6.18446000e-02, -1.715560e-02),
        (145.25736 , 0.3155125    , -0.2042014    , 8.79566000e-02, -2.455140e-02),
        (69.739048 , 0.1181312    , -5.5736700e-02, 2.57548000e-02, -7.352400e-03),
        (31.770325 , 8.0076000e-03, 0.4187607     , -0.2455459    , 7.2008700e-02),
        (15.391757 , 3.2930000e-04, 0.5758762     , -0.5090572    , 0.1576254),
        (7.341526  , -1.523000e-04, 0.1696842     , -5.5574900e-02, 1.4207400e-02),
        (3.323716  , 2.4700000e-05, 6.06620000e-03, 0.7083796     , -0.2851593),
        (1.485867  , -3.660000e-05, 1.76050000e-03, 0.5231027     , -0.3885347),
        (0.421086  , 1.4500000e-05, -3.6600000e-04, 3.48176000e-02, 0.2691061),
        (0.2115    , -9.400000e-06, 2.31600000e-04, -1.1117600e-02, 0.6495337),
        (8.8974e-02, 2.6000000e-06, -6.6100000e-05, 2.36360000e-03, 0.2974047),],
       [1,
        (7423.8614, 4.599000e-04, -1.79400e-04, 3.9900000000e-05),
        (1759.5166, 3.982300e-03, -1.56410e-03, 3.4880000000e-04),
        (570.22916, 2.146380e-02, -8.49990e-03, 1.8953000000e-03),
        (216.57997, 8.246170e-02, -3.36327e-02, 7.5325000000e-03),
        (90.734252, 0.2238902   , -9.53228e-02, 2.1431500000e-02),
        (40.308791, 0.3920704   , -0.1793626  , 4.0780700000e-02),
        (18.555502, 0.3542238   , -0.1466682  , 3.2524900000e-02),
        (8.396543 , 0.1048641   , 0.1966016   , -5.4883200000e-02),
        (3.767367 , 3.366400e-03, 0.5372088   , -0.1511922),
        (1.629701 , 1.849500e-03, 0.3857361   , -0.1249011),
        (0.568263 , -4.49600e-04, 4.709470e-02, 0.2089154),
        (0.222503 , 2.297000e-04, -5.40060e-03, 0.5855293),
        (8.0405e-02,-7.19000e-05, 1.530500e-03, 0.364466),],
       [2,
        (321.01961, 1.6840000000e-03),
        (96.249305, 1.4158600000e-02),
        (36.644963, 6.2825900000e-02),
        (15.493965, 0.1784993),
        (6.891138 , 0.3209452),
        (3.054831 , 0.3773515),
        (1.314241 , 0.2750231),
        (0.51343  , 8.2883400000e-02),]]

Se = [[0,
        (9563600, 6.3000000000e-06 , -2.0000000000e-06, 8.0000000000e-07 , -2.0000000000e-07),
        (1432100, 4.8900000000e-05 , -1.5300000000e-05, 6.0000000000e-06 , -1.8000000000e-06),
        (325910 , 2.5740000000e-04 , -8.0600000000e-05, 3.1700000000e-05 , -9.3000000000e-06),
        (92312  , 1.0861000000e-03 , -3.4000000000e-04, 1.3370000000e-04 , -3.9100000000e-05),
        (30116  , 3.9399000000e-03 , -1.2397000000e-03, 4.8830000000e-04 , -1.4280000000e-04),
        (10872  , 1.2704100000e-02 , -4.0177000000e-03, 1.5821000000e-03 , -4.6270000000e-04),
        (4240.1 , 3.6715600000e-02 , -1.1867200000e-02, 4.6919000000e-03 , -1.3722000000e-03),
        (1758.4 , 9.3867200000e-02 , -3.1534000000e-02, 1.2509800000e-02 , -3.6628000000e-03),
        (766.59 , 0.2017677        , -7.4643900000e-02, 3.0038100000e-02 , -8.8061000000e-03),
        (348.43 , 0.328054         , -0.1452179       , 5.9727100000e-02 , -1.7586700000e-02),
        (164.03 , 0.3238334        , -0.2038441       , 8.8469600000e-02 , -2.6207400000e-02),
        (79.142 , 0.1352337        , -7.8871100000e-02, 3.6392000000e-02 , -1.0996400000e-02),
        (35.524 , 1.1707500000e-02 , 0.3845825        , -0.2235329       , 6.9569700000e-02),
        (17.305 , -3.4360000000e-04, 0.586527         , -0.5122462       , 0.1683947),
        (8.3784 , 1.6650000000e-04 , 0.1973591        , -0.1084224       , 3.4616000000e-02),
        (3.7405 , -1.1880000000e-04, 1.0010200000e-02 , 0.6936372        , -0.2978702),
        (1.689  , 2.0400000000e-05 , 1.3160000000e-03 , 0.5558711        , -0.4322569),
        (0.50927, -1.1700000000e-05, -2.1010000000e-04, 4.0980600000e-02 , 0.2631611),
        (0.2552 , 8.3000000000e-06 , 1.1090000000e-04 , -1.1383200000e-02, 0.6757217),
        (0.10651, -1.9000000000e-06, -3.8000000000e-05, 2.4256000000e-03 , 0.2956495),],
       [1,
        (8004.3          , 4.5050000000e-04 , -1.7830000000e-04, 4.3000000000e-05),
        (1896.9          , 3.9049000000e-03 , -1.5554000000e-03, 3.7700000000e-04),
        (614.71          , 2.1090100000e-02 , -8.4727000000e-03, 2.0465000000e-03),
        (233.5           , 8.1292000000e-02 , -3.3624500000e-02, 8.1899000000e-03),
        (97.856          , 0.2217841        , -9.5826700000e-02, 2.3335600000e-02),
        (43.514          , 0.390727         , -0.1813907       , 4.4981300000e-02),
        (20.063          , 0.3559714        , -0.1503152       , 3.5747500000e-02),
        (9.1127          , 0.1073272        , 0.1948263        , -5.8686600000e-02),
        (4.1063          , 3.6985000000e-03 , 0.5415554        , -0.1709573),
        (1.7949          , 1.8032000000e-03 , 0.3837299        , -0.1293583),
        (0.62432         , -4.5010000000e-04, 4.4423200000e-02 , 0.2647063),
        (0.24615         , 2.2080000000e-04 , -5.0132000000e-03, 0.5778069),
        (8.8917000000e-02, -7.2200000000e-05, 1.6879000000e-03 , 0.3275508),],
       [2,
        (361.85 , 1.5655000000e-03),
        (108.55 , 1.3326200000e-02),
        (41.433 , 6.0152700000e-02),
        (17.579 , 0.1740293),
        (7.8627 , 0.319569),
        (3.518  , 0.3812029),
        (1.5348 , 0.2746086),
        (0.60813, 7.8255100000e-02),]]

Br = [[0,
        (10639000, 5.9000000000e-06 , -1.9000000000e-06, 7.0000000000e-07 , -2.0000000000e-07),
        (1593400 , 4.6100000000e-05 , -1.4500000000e-05, 5.7000000000e-06 , -1.8000000000e-06),
        (362610  , 2.4220000000e-04 , -7.6100000000e-05, 3.0300000000e-05 , -9.3000000000e-06),
        (102700  , 1.0226000000e-03 , -3.2100000000e-04, 1.2750000000e-04 , -3.9100000000e-05),
        (33501   , 3.7113000000e-03 , -1.1709000000e-03, 4.6590000000e-04 , -1.4280000000e-04),
        (12093   , 1.1978500000e-02 , -3.7968000000e-03, 1.5096000000e-03 , -4.6280000000e-04),
        (4715.9  , 3.4692700000e-02 , -1.1230700000e-02, 4.4852000000e-03 , -1.3750000000e-03),
        (1955.6  , 8.9123900000e-02 , -2.9927700000e-02, 1.1983500000e-02 , -3.6784000000e-03),
        (852.61  , 0.1934557        , -7.1270600000e-02, 2.8957100000e-02 , -8.8981000000e-03),
        (387.67  , 0.3209019        , -0.1403136       , 5.8156600000e-02 , -1.7952900000e-02),
        (182.68  , 0.3299233        , -0.2030763       , 8.8813300000e-02 , -2.7573200000e-02),
        (88.245  , 0.1494121        , -9.6098500000e-02, 4.4524400000e-02 , -1.4095300000e-02),
        (39.263  , 1.4993800000e-02 , 0.3558086        , -0.2060387       , 6.7256100000e-02),
        (19.234  , -9.1650000000e-04, 0.5921792        , -0.5127017       , 0.1766928),
        (9.4057  , 4.3800000000e-04 , 0.2215977        , -0.1509349       , 5.2886100000e-02),
        (4.1601  , -2.3980000000e-04, 1.3764800000e-02 , 0.6789203        , -0.3075955),
        (1.8995  , 7.3600000000e-05 , 8.3950000000e-04 , 0.5817697        , -0.4700658),
        (0.60472 , -3.6700000000e-05, -4.5100000000e-05, 4.6755500000e-02 , 0.2558761),
        (0.30114 , 2.3900000000e-05 , -8.5000000000e-06, -1.1182500000e-02, 0.6980341),
        (0.12515 , -5.6000000000e-06, -1.2400000000e-05, 2.4402000000e-03 , 0.2967256),],
       [1,
        (8676.5 , 4.3570000000e-04 , -1.7480000000e-04, 4.5100000000e-05),
        (2055.9 , 3.7815000000e-03 , -1.5263000000e-03, 3.9640000000e-04),
        (666.23 , 2.0478200000e-02 , -8.3399000000e-03, 2.1555000000e-03),
        (253.1  , 7.9283400000e-02 , -3.3220300000e-02, 8.6720000000e-03),
        (106.12 , 0.2178473        , -9.5418000000e-02, 2.4868000000e-02),
        (47.242 , 0.3878585        , -0.1824026       , 4.8547200000e-02),
        (21.825 , 0.359435         , -0.1558308       , 3.9615600000e-02),
        (9.9684 , 0.1121995        , 0.1867899        , -6.0574900000e-02),
        (4.5171 , 4.3874000000e-03 , 0.5427733        , -0.1871699),
        (1.9982 , 1.7809000000e-03 , 0.3873309        , -0.1377757),
        (0.70988, -4.5760000000e-04, 4.5306900000e-02 , 0.2928021),
        (0.28145, 2.1220000000e-04 , -4.3784000000e-03, 0.5760896),
        (0.10204, -7.3400000000e-05, 1.8111000000e-03 , 0.3078617),],
       [2,
        (403.83 , 1.4732000000e-03),
        (121.17 , 1.2672500000e-02),
        (46.345 , 5.8045100000e-02),
        (19.721 , 0.1705103),
        (8.8624 , 0.3185958),
        (3.9962 , 0.3845023),
        (1.7636 , 0.2737737),
        (0.70619, 7.4396700000e-02),]]

Kr = [[0,
        (11718113 , 5.6000000000e-06 , -1.8000000000e-06, 7.0000000000e-07 , -2.0000000000e-07),
        (1754604.4, 4.3800000000e-05 , -1.3800000000e-05, 5.5000000000e-06 , -1.8000000000e-06),
        (399281.32, 2.3050000000e-04 , -7.2600000000e-05, 2.9200000000e-05 , -9.3000000000e-06),
        (113084.57, 9.7330000000e-04 , -3.0630000000e-04, 1.2280000000e-04 , -3.9100000000e-05),
        (36885.925, 3.5337000000e-03 , -1.1177000000e-03, 4.4910000000e-04 , -1.4300000000e-04),
        (13312.209, 1.1416700000e-02 , -3.6270000000e-03, 1.4557000000e-03 , -4.6390000000e-04),
        (5189.9883, 3.3132500000e-02 , -1.0743200000e-02, 4.3319000000e-03 , -1.3801000000e-03),
        (2151.6597, 8.5446400000e-02 , -2.8699200000e-02, 1.1596500000e-02 , -3.7001000000e-03),
        (938.03251, 0.1869124        , -6.8667900000e-02, 2.8158500000e-02 , -8.9921000000e-03),
        (426.55732, 0.3149761        , -0.1365155       , 5.7033900000e-02 , -1.8302100000e-02),
        (201.0666 , 0.3343334        , -0.2022458       , 8.9135600000e-02 , -2.8755900000e-02),
        (97.097605, 0.160881         , -0.1090569       , 5.0842100000e-02 , -1.6732400000e-02),
        (42.998724, 1.7843500000e-02 , 0.3318768        , -0.192103        , 6.5241000000e-02),
        (21.177075, -1.3793000000e-03, 0.594825         , -0.512104        , 0.1834422),
        (10.426752, 6.5720000000e-04 , 0.2424825        , -0.1857007       , 6.9218300000e-02),
        (4.585008 , -3.3880000000e-04, 1.7224100000e-02 , 0.6654119        , -0.3156034),
        (2.117603 , 1.2110000000e-04 , 3.6850000000e-04 , 0.6023925        , -0.5031501),
        (0.707057 , -5.8900000000e-05, 1.1040000000e-04 , 5.2170700000e-02 , 0.2490072),
        (0.349225 , 3.6600000000e-05 , -1.1530000000e-04, -1.0645300000e-02, 0.7171571),
        (0.144821 , -8.6000000000e-06, 9.0000000000e-06 , 2.4226000000e-03 , 0.2987456),],
       [1,
        (9366.309 , 4.2310000000e-04 , -1.7200000000e-04, 4.6600000000e-05),
        (2219.5543, 3.6743000000e-03 , -1.5025000000e-03, 4.1000000000e-04),
        (719.45288, 1.9931200000e-02 , -8.2269000000e-03, 2.2328000000e-03),
        (273.46446, 7.7422200000e-02 , -3.2856600000e-02, 9.0144000000e-03),
        (114.75225, 0.2140386        , -9.5013500000e-02, 2.6011500000e-02),
        (51.155569, 0.3848556        , -0.1833106       , 5.1334000000e-02),
        (23.682676, 0.362634         , -0.1612161       , 4.3092900000e-02),
        (10.875484, 0.1170818        , 0.1787644        , -6.1504000000e-02),
        (4.955131 , 5.1210000000e-03 , 0.5437885        , -0.2003424),
        (2.217267 , 1.7539000000e-03 , 0.3913387        , -0.1457364),
        (0.80641  , -4.5730000000e-04, 4.6257000000e-02 , 0.3112161),
        (0.322154 , 2.1990000000e-04 , -4.7800000000e-03, 0.5764581),
        (0.117619 , -6.6800000000e-05, 1.3923000000e-03 , 0.2939391),],
       [2,
        (446.16133, 1.4044000000e-03),
        (133.96477, 1.2171500000e-02),
        (51.345907, 5.6391900000e-02),
        (21.916906, 0.167643),
        (9.893725 , 0.3177368),
        (4.492527 , 0.3872647),
        (2.002293 , 0.2728006),
        (0.808409 , 7.1208400000e-02),]]

#Y = [[0,
#       (121.555         , 3.9900000000e-04 , -1.3800000000e-04),
#       (13.3508         , -3.7374000000e-02, 1.2655000000e-02),
#       (8.34304         , 0.210408         , -7.2577000000e-02),
#       (5.21262         , -0.174259        , 6.8946000000e-02),
#       (2.84822         , -0.449059        , 0.141076),
#       (0.736092        , 0.751546         , -0.309769),
#       (0.339525        , 0.503913         , -0.364091),
#       (8.5000000000e-02, 3.8190000000e-02 , 0.308976),
#       (4.5719000000e-02, -1.6819000000e-02, 0.61839),],
#      [1,
#       (15.7057         , -1.0080000000e-03),
#       (9.81434         , 1.8451000000e-02),
#       (3.95152         , -0.153313),
#       (1.02873         , 0.388287),
#       (0.520341        , 0.471549),
#       (0.262806        , 0.244225),
#       (0.119127        , 3.7455000000e-02),
#       (5.3263000000e-02, 9.1700000000e-04),],
#      [2,
#       (15.8535         , 1.3370000000e-03),
#       (5.08183         , -6.9910000000e-03),
#       (1.45095         , 0.152184),
#       (0.689277        , 0.461729),
#       (0.313342        , 0.155567),
#       (0.138383        , -0.901673),
#       (5.9555000000e-02, -6.1751000000e-02),]]

#Zr = [[0,
#        (136.826         , 4.0900000000e-04 , -1.4200000000e-04),
#        (14.5128         , -3.8517000000e-02, 1.3145000000e-02),
#        (9.06981         , 0.215815         , -7.5341000000e-02),
#        (5.6664          , -0.17334         , 6.9978000000e-02),
#        (3.11319         , -0.470067        , 0.150436),
#        (0.823482        , 0.763461         , -0.325382),
#        (0.381193        , 0.50374          , -0.356712),
#        (9.7792000000e-02, 3.7859000000e-02 , 0.307014),
#        (5.0839000000e-02, -1.5390000000e-02, 0.623918),],
#       [1,
#        (17.4119         , -1.1830000000e-03),
#        (10.8799         , 1.9174000000e-02),
#        (4.32804         , -0.16007),
#        (1.13864         , 0.405762),
#        (0.575855        , 0.47362),
#        (0.28867         , 0.231961),
#        (0.128014        , 3.2662000000e-02),
#        (5.5290000000e-02, 6.3400000000e-04),],
#       [2,
#        (18.0732         , 1.6120000000e-03),
#        (5.21959         , -1.1812000000e-02),
#        (1.69985         , 0.199715),
#        (0.836323        , 0.503914),
#        (0.393354        , 9.3700000000e-03),
#        (0.178824        , -0.911661),
#        (7.8275000000e-02, 8.5915000000e-02),]]

#Nb = [[0,
#        (153.071         , 4.2700000000e-04 , -1.1600000000e-04),
#        (15.6363         , -3.9834000000e-02, 5.9360000000e-03),
#        (9.77218         , 0.223209         , -0.109862),
#        (6.10544         , -0.176           , 2.2529000000e-02),
#        (3.3909          , -0.486061        , 0.762558),
#        (0.911676        , 0.7744           , -3.366889),
#        (0.422139        , 0.502728         , 3.730538),
#        (0.109079        , 3.7403000000e-02 , -1.210909),
#        (5.5624000000e-02, -1.4645000000e-02, -1.212723),],
#       [1,
#        (18.8713         , -1.3830000000e-03),
#        (11.7929         , 2.0710000000e-02),
#        (4.71529         , -0.167706),
#        (1.2553          , 0.418125),
#        (0.635023        , 0.474164),
#        (0.317595        , 0.223734),
#        (0.141054        , 3.0689000000e-02),
#        (6.0494000000e-02, 6.2800000000e-04),],
#       [2,
#        (20.8985         , 1.8290000000e-03),
#        (5.60134         , -1.3451000000e-02),
#        (1.93805         , 0.232237),
#        (0.977512        , 0.541576),
#        (0.469796        , -0.109809),
#        (0.217905        , -0.882696),
#        (9.6917000000e-02, 0.14299),]]

#Mo = [[0,
#        (170.069         , 4.5300000000e-04 , -2.9800000000e-04),
#        (16.7338         , -4.1380000000e-02, 2.0969000000e-02),
#        (10.4587         , 0.232699         , -0.181422),
#        (6.53434         , -0.182519        , 0.128533),
#        (3.67935         , -0.498318        , 0.72887),
#        (1.00192         , 0.785379         , -3.464711),
#        (0.46314         , 0.50137          , 3.885592),
#        (0.118727        , 3.5829000000e-02 , -1.547566),
#        (5.9514000000e-02, -1.4037000000e-02, -0.761802),],
#       [1,
#        (20.308          , -1.5140000000e-03),
#        (12.6907         , 2.2168000000e-02),
#        (5.1195          , -0.174369),
#        (1.37783         , 0.427943),
#        (0.696824        , 0.475306),
#        (0.347367        , 0.217403),
#        (0.152819        , 2.8524000000e-02),
#        (6.5049000000e-02, 4.6100000000e-04),],
#       [2,
#        (22.6032 , 1.3060000000e-03),
#        (6.33914 , -1.2438000000e-02),
#        (2.17763 , 0.103512),
#        (1.107   , 0.277661),
#        (0.535372, 0.358857),
#        (0.24898 , 0.309226),
#        (0.110409, 0.174036),]]

#Tc = [[0,
#        (188.509         , 4.8500000000e-04 , -4.5400000000e-04),
#        (17.808          , -4.3066000000e-02, 3.3963000000e-02),
#        (11.131          , 0.244146         , -0.239696),
#        (6.95483         , -0.193577        , 0.213334),
#        (3.9764          , -0.505976        , 0.689739),
#        (1.09381         , 0.796275         , -3.451331),
#        (0.504008        , 0.498592         , 3.875321),
#        (0.127206        , 3.4146000000e-02 , -1.668387),
#        (6.3047000000e-02, -1.2991000000e-02, -0.524297),],
#       [1,
#        (21.6444         , -1.5590000000e-03),
#        (13.5268         , 2.3709000000e-02),
#        (5.54266         , -0.180371),
#        (1.50611         , 0.435517),
#        (0.76168         , 0.476454),
#        (0.378366        , 0.212883),
#        (0.163588        , 2.6643000000e-02),
#        (6.8941000000e-02, 1.8800000000e-04),],
#       [2,
#        (25.3828 , 1.3390000000e-03),
#        (6.98538 , -1.3281000000e-02),
#        (2.41217 , 0.108038),
#        (1.24177 , 0.286031),
#        (0.605242, 0.360834),
#        (0.282829, 0.301193),
#        (0.12556 , 0.165001),]]

#Ru = [[0,
#        (208.25          , 5.2300000000e-04 , -6.3500000000e-04),
#        (18.8471         , -4.4913000000e-02, 5.1747000000e-02),
#        (11.7818         , 0.257626         , -0.317189),
#        (7.36195         , -0.20913         , 0.329848),
#        (4.27771         , -0.510662        , 0.627053),
#        (1.19107         , 0.803247         , -3.422209),
#        (0.548568        , 0.498414         , 3.847948),
#        (0.138694        , 3.3766000000e-02 , -1.623926),
#        (6.7651000000e-02, -1.2094000000e-02, -0.603223),],
#       [1,
#        (22.7753         , -1.5440000000e-03),
#        (14.234          , 2.5771000000e-02),
#        (5.98755         , -0.186598),
#        (1.63924         , 0.442774),
#        (0.82788         , 0.478151),
#        (0.40901         , 0.208369),
#        (0.171877        , 2.4635000000e-02),
#        (7.1271000000e-02, -2.1900000000e-04),],
#       [2,
#        (25.8838 , 1.5230000000e-03),
#        (7.59255 , -1.8162000000e-02),
#        (2.71293 , 0.109691),
#        (1.39708 , 0.291597),
#        (0.682565, 0.362044),
#        (0.319378, 0.297514),
#        (0.141781, 0.161037),]]

#Rh = [[0,
#        (228.932         , 5.6800000000e-04 , -7.2500000000e-04),
#        (19.9087         , -4.6803000000e-02, 5.9930000000e-02),
#        (12.4468         , 0.272367         , -0.354951),
#        (7.77821         , -0.230168        , 0.390297),
#        (4.58006         , -0.509554        , 0.585743),
#        (1.29068         , 0.80985          , -3.302856),
#        (0.593414        , 0.497876         , 3.625717),
#        (0.149158        , 3.3154000000e-02 , -1.236749),
#        (7.1953000000e-02, -1.1513000000e-02, -1.007047),],
#       [1,
#        (24.2117         , -1.5790000000e-03),
#        (15.1331         , 2.7198000000e-02),
#        (6.4472          , -0.191463),
#        (1.77776         , 0.447658),
#        (0.89902         , 0.477724),
#        (0.444522        , 0.205819),
#        (0.188674        , 2.4352000000e-02),
#        (7.8514000000e-02, -5.8000000000e-05),],
#       [2,
#        (29.4998 , 1.6770000000e-03),
#        (7.40437 , -1.8439000000e-02),
#        (3.05959 , 0.105076),
#        (1.58205 , 0.29377),
#        (0.774834, 0.364178),
#        (0.363056, 0.297265),
#        (0.161047, 0.159958),]]

#Pd = [[0,
#        (247.202         , 6.2400000000e-04 , -8.0600000000e-04),
#        (20.7937         , -5.0198000000e-02, 6.7335000000e-02),
#        (13.0019         , 0.296242         , -0.397207),
#        (8.12562         , -0.264015        , 0.458351),
#        (4.88842         , -0.503715        , 0.557095),
#        (1.39206         , 0.817743         , -3.235207),
#        (0.638382        , 0.496409         , 3.43445),
#        (0.158828        , 3.2318000000e-02 , -0.847843),
#        (7.5793000000e-02, -1.1023000000e-02, -1.377241),],
#       [1,
#        (24.8824         , -1.7220000000e-03),
#        (15.5517         , 3.1534000000e-02),
#        (6.92343         , -0.201062),
#        (1.92286         , 0.452572),
#        (0.971191        , 0.479947),
#        (0.476919        , 0.204045),
#        (0.193866        , 2.2517000000e-02),
#        (7.8792000000e-02, -6.1400000000e-04),],
#       [2,
#        (29.0204 , 2.1720000000e-03),
#        (6.41149 , -4.7958000000e-02),
#        (3.99736 , 0.103343),
#        (1.88742 , 0.29321),
#        (0.913208, 0.371687),
#        (0.425675, 0.306456),
#        (0.187727, 0.166629),]]

#Ag = [[0,
#        (222.645         , 7.0000000000e-04 , -2.0800000000e-04),
#        (20.1725         , -7.9809000000e-02, 2.2805000000e-02),
#        (12.7197         , 0.458979         , -0.137325),
#        (8.00211         , -0.521826        , 0.173085),
#        (5.02053         , -0.407544        , 0.105755),
#        (1.52085         , 0.841458         , -0.314063),
#        (0.69492         , 0.495648         , -0.298534),
#        (0.172933        , 2.7660000000e-02 , 0.231324),
#        (8.1897000000e-02, -8.6430000000e-03, 0.596911),
#        (3.5190000000e-02, 3.5010000000e-03 , 0.344848),],
#       [1,
#        (22.049          , -5.8860000000e-03),
#        (13.8356         , 7.6357000000e-02),
#        (7.62994         , -0.266172),
#        (2.10372         , 0.462201),
#        (1.06262         , 0.489495),
#        (0.519383        , 0.200089),
#        (0.205199        , 1.9345000000e-02),
#        (8.2979000000e-02, -7.1700000000e-04),
#        (3.3144000000e-02, 3.9600000000e-04),],
#       [2,
#        (73.2665 , 4.5100000000e-04),
#        (18.7729 , 5.9840000000e-03),
#        (10.9237 , -1.8968000000e-02),
#        (3.00197 , 0.192386),
#        (1.47177 , 0.372172),
#        (0.684764, 0.372188),
#        (0.300397, 0.230066),
#        (0.120155, 6.4242000000e-02),]]

#Cd = [[0,
#        (257.497         , 7.6800000000e-04 , -2.3100000000e-04),
#        (21.3546         , -7.8194000000e-02, 2.2279000000e-02),
#        (13.4806         , 0.460928         , -0.138205),
#        (8.48651         , -0.53621         , 0.177784),
#        (5.32551         , -0.400823        , 0.105695),
#        (1.62686         , 0.855362         , -0.325954),
#        (0.740469        , 0.489868         , -0.299325),
#        (0.180933        , 2.2029000000e-02 , 0.2821),
#        (8.5096000000e-02, -8.3600000000e-03, 0.602044),
#        (3.6384000000e-02, 1.9660000000e-03 , 0.296635),],
#       [1,
#        (243.165         , 1.1300000000e-04),
#        (13.9588         , 6.9672000000e-02),
#        (8.31001         , -0.253675),
#        (2.202           , 0.482492),
#        (1.10072         , 0.48455),
#        (0.535975        , 0.17964),
#        (0.213654        , 1.5229000000e-02),
#        (8.5469000000e-02, -1.8800000000e-04),
#        (3.3823000000e-02, 2.3400000000e-04),],
#       [2,
#        (86.0666 , 4.4300000000e-04),
#        (22.6386 , 5.0060000000e-03),
#        (12.1384 , -1.6077000000e-02),
#        (3.44081 , 0.177152),
#        (1.71761 , 0.366656),
#        (0.814849, 0.377226),
#        (0.366007, 0.23392),
#        (0.150282, 6.4583000000e-02),]]

#In = [[0,
#        (2378.04         , 9.2000000000e-05 , 2.8000000000e-05),
#        (360.998         , 4.7900000000e-04 , 1.9900000000e-04),
#        (45.6335         , 1.2576000000e-02 , 1.8350000000e-03),
#        (28.5149         , -8.8422000000e-02, -2.0177000000e-02),
#        (17.822          , 0.252256         , 7.2046000000e-02),
#        (6.6299          , -0.719057        , -0.24499),
#        (1.70954         , 0.859606         , 0.39324),
#        (0.798445        , 0.474066         , 0.328413),
#        (0.204737        , 1.9853000000e-02 , -0.425536),
#        (9.6677000000e-02, -7.2440000000e-03, -0.587095),
#        (4.3541000000e-02, 1.7710000000e-03 , -0.201887),],
#       [1,
#        (266.902         , 1.0800000000e-04 , -3.2000000000e-05),
#        (14.7312         , 7.3684000000e-02 , -1.5210000000e-02),
#        (8.82779         , -0.264298        , 5.7922000000e-02),
#        (2.35953         , 0.494751         , -0.130047),
#        (1.17591         , 0.493684         , -0.137141),
#        (0.567568        , 0.163851         , -2.8731000000e-02),
#        (0.21294         , 1.0083000000e-02 , 0.301661),
#        (8.2807000000e-02, -2.2000000000e-04, 0.556639),
#        (3.2077000000e-02, 1.9800000000e-04 , 0.29124),],
#       [2,
#        (117.279         , 2.8100000000e-04),
#        (32.6865         , 2.4780000000e-03),
#        (13.1906         , -1.2439000000e-02),
#        (4.01821         , 0.14007),
#        (2.14948         , 0.330305),
#        (1.09126         , 0.375358),
#        (0.531941        , 0.258269),
#        (0.243687        , 9.0478000000e-02),
#        (9.0700000000e-02, 6.9130000000e-03),]]

#Sn = [[0,
#        (3672.4          , 1.1700000000e-04 , 4.3000000000e-05),
#        (558.143         , 6.8700000000e-04 , 3.0700000000e-04),
#        (114.089         , 2.1300000000e-03 , 4.9600000000e-04),
#        (31.4006         , -3.7669000000e-02, -9.1050000000e-03),
#        (19.6318         , 0.159149         , 4.9898000000e-02),
#        (6.77205         , -0.651754        , -0.249854),
#        (1.83351         , 0.837692         , 0.444097),
#        (0.877715        , 0.488426         , 0.352025),
#        (0.237396        , 2.1796000000e-02 , -0.4997),
#        (0.112068        , -7.4610000000e-03, -0.574357),
#        (5.1757000000e-02, 1.8720000000e-03 , -0.165579),],
#       [1,
#        (216.97          , 2.2600000000e-04, -8.1000000000e-05),
#        (20.9102         , 2.2917000000e-02, -5.4570000000e-03),
#        (8.79611         , -0.197146       , 5.3005000000e-02),
#        (2.56737         , 0.467917        , -0.154665),
#        (1.31451         , 0.496043        , -0.15894),
#        (0.653591        , 0.17661         , -4.9703000000e-02),
#        (0.27215         , 1.2850000000e-02, 0.327127),
#        (0.110736        , 1.1900000000e-04, 0.567089),
#        (4.4034000000e-02, 1.7300000000e-04, 0.264297),],
#       [2,
#        (130.243 , 3.1900000000e-04),
#        (36.7762 , 2.6780000000e-03),
#        (14.6321 , -1.0109000000e-02),
#        (4.69695 , 0.119768),
#        (2.53078 , 0.3226),
#        (1.30174 , 0.384238),
#        (0.646575, 0.265358),
#        (0.302316, 9.0377000000e-02),
#        (0.116   , 7.3340000000e-03),]]

#Sb = [[0,
#        (3928.33         , 1.5400000000e-04 , 6.2000000000e-05),
#        (593.889         , 9.3100000000e-04 , 4.2800000000e-04),
#        (120.185         , 2.8210000000e-03 , 8.7700000000e-04),
#        (29.514          , -5.5319000000e-02, -1.5713000000e-02),
#        (18.4422         , 0.243312         , 8.3003000000e-02),
#        (7.47571         , -0.738324        , -0.295433),
#        (1.95136         , 0.86631          , 0.481603),
#        (0.952258        , 0.471311         , 0.383768),
#        (0.287968        , 2.1126000000e-02 , -0.499692),
#        (0.136396        , -5.6770000000e-03, -0.605473),
#        (6.2628000000e-02, 1.3620000000e-03 , -0.167429),],
#       [1,
#        (210.471         , 2.6400000000e-04 , -1.0200000000e-04),
#        (16.1414         , 7.9905000000e-02 , -2.1761000000e-02),
#        (9.8253          , -0.276949        , 8.0661000000e-02),
#        (2.75267         , 0.48366          , -0.174628),
#        (1.42148         , 0.500697         , -0.184154),
#        (0.716246        , 0.166598         , -5.3472000000e-02),
#        (0.320205        , 1.1969000000e-02 , 0.358312),
#        (0.135088        , 2.7900000000e-04 , 0.568358),
#        (5.5130000000e-02, -5.0000000000e-06, 0.238343),],
#       [2,
#        (135.775 , 3.8300000000e-04),
#        (38.7746 , 3.0350000000e-03),
#        (13.4922 , -1.1466000000e-02),
#        (5.08327 , 0.115902),
#        (2.78958 , 0.321269),
#        (1.46159 , 0.387074),
#        (0.740845, 0.262424),
#        (0.35313 , 8.5723000000e-02),
#        (0.1393  , 7.1180000000e-03),]]

#Te = [[0,
#        (5324.98         , 2.0300000000e-04 , -9.3000000000e-05),
#        (803.674         , 1.3120000000e-03 , -6.4400000000e-04),
#        (175.146         , 3.8220000000e-03 , -1.6200000000e-03),
#        (29.6182         , -4.5247000000e-02, 1.2295000000e-02),
#        (18.5344         , 0.246886         , -8.8386000000e-02),
#        (7.9615          , -0.75016         , 0.31811),
#        (2.06539         , 0.879495         , -0.530777),
#        (1.02457         , 0.458114         , -0.396878),
#        (0.333843        , 2.0791000000e-02 , 0.530895),
#        (0.157811        , -4.4620000000e-03, 0.614293),
#        (7.2019000000e-02, 1.0900000000e-03 , 0.156103),],
#       [1,
#        (193.775         , 4.0000000000e-04, -1.6700000000e-04),
#        (17.5508         , 6.8608000000e-02, -2.0076000000e-02),
#        (10.1951         , -0.26657        , 8.4481000000e-02),
#        (2.97377         , 0.473533        , -0.188835),
#        (1.55647         , 0.510231        , -0.205364),
#        (0.787546        , 0.167513        , -5.0739000000e-02),
#        (0.368473        , 1.1741000000e-02, 0.385302),
#        (0.154273        , 1.1710000000e-03, 0.559188),
#        (6.1905000000e-02, 7.5000000000e-05, 0.231312),],
#       [2,
#        (142.617 , 4.6100000000e-04),
#        (41.0605 , 3.5350000000e-03),
#        (13.0622 , -1.1835000000e-02),
#        (5.72515 , 0.105967),
#        (3.13381 , 0.318952),
#        (1.65682 , 0.392307),
#        (0.851575, 0.264089),
#        (0.412128, 8.4343000000e-02),
#        (0.1651  , 7.2480000000e-03),]]

#I = [[0,
#       (5546.5          , 1.5600000000e-04 , -7.3000000000e-05),
#       (838.214         , 9.8600000000e-04 , -5.0800000000e-04),
#       (182.187         , 2.7920000000e-03 , -1.1580000000e-03),
#       (31.2123         , -4.3251000000e-02, 1.2193000000e-02),
#       (19.5314         , 0.234134         , -8.7854000000e-02),
#       (8.24099         , -0.750943        , 0.3382),
#       (2.19455         , 0.882968         , -0.57655),
#       (1.10911         , 0.462061         , -0.409298),
#       (0.374641        , 2.2286000000e-02 , 0.567459),
#       (0.17708         , -4.3530000000e-03, 0.612489),
#       (8.1061000000e-02, 1.1020000000e-03 , 0.143231),],
#      [1,
#       (188.988         , 5.8500000000e-04, -2.5600000000e-04),
#       (21.2868         , 3.6923000000e-02, -1.1682000000e-02),
#       (10.0396         , -0.235324       , 8.3192000000e-02),
#       (3.4518          , 0.341483        , -0.15697),
#       (1.97456         , 0.534788        , -0.224518),
#       (1.0242          , 0.265141        , -0.114451),
#       (0.449437        , 2.5787000000e-02, 0.375356),
#       (0.186648        , 5.2200000000e-04, 0.575136),
#       (7.3481000000e-02, 6.0600000000e-04, 0.245917),],
#      [2,
#       (132.662 , 5.7200000000e-04),
#       (37.6054 , 4.4020000000e-03),
#       (10.3891 , -4.0922000000e-02),
#       (6.49017 , 9.9661000000e-02),
#       (3.45451 , 0.322663),
#       (1.84413 , 0.400343),
#       (0.962478, 0.268306),
#       (0.472853, 8.4847000000e-02),
#       (0.1932  , 7.6320000000e-03),]]

#Xe = [[0,
#        (6456.4          , 2.5000000000e-04 , -1.3000000000e-04),
#        (974.061         , 1.6300000000e-03 , -8.8500000000e-04),
#        (214.429         , 4.7330000000e-03 , -2.3580000000e-03),
#        (31.3308         , -3.3699000000e-02, 7.2910000000e-03),
#        (19.613          , 0.243931         , -9.2639000000e-02),
#        (8.88609         , -0.764653        , 0.353795),
#        (2.32508         , 0.900794         , -0.61583),
#        (1.18422         , 0.441513         , -0.41306),
#        (0.426854        , 2.1416000000e-02 , 0.579334),
#        (0.201645        , -3.0880000000e-03, 0.625462),
#        (9.2178000000e-02, 8.5100000000e-04 , 0.142337),],
#       [1,
#        (191.17          , 7.6500000000e-04 , -3.2900000000e-04),
#        (22.5178         , 3.6952000000e-02 , -1.2781000000e-02),
#        (10.0604         , -0.280688        , 0.108274),
#        (5.55762         , 0.142717         , -7.2051000000e-02),
#        (2.69625         , 0.635654         , -0.28458),
#        (1.30764         , 0.393257         , -0.185205),
#        (0.530675        , 4.1056000000e-02 , 0.358336),
#        (0.222461        , -2.2510000000e-03, 0.588394),
#        (8.6881000000e-02, 7.7400000000e-04 , 0.257245),],
#       [2,
#        (142.971 , 7.3600000000e-04),
#        (41.3057 , 5.3720000000e-03),
#        (10.9222 , -2.8827000000e-02),
#        (6.82408 , 0.11991),
#        (3.66696 , 0.332464),
#        (1.98289 , 0.389209),
#        (1.05399 , 0.248359),
#        (0.529903, 7.7611000000e-02),
#        (0.2192  , 7.3660000000e-03),]]

#Hf = [[0,
#        (26.5042         , 3.2017000000e-02 , -9.2200000000e-03),
#        (16.584          , -0.258338        , 7.6675000000e-02),
#        (10.3831         , 0.741958         , -0.225641),
#        (6.4955          , -0.597246        , 0.185568),
#        (3.46431         , -0.467433        , 0.156549),
#        (0.9862          , 0.781438         , -0.311417),
#        (0.457828        , 0.533756         , -0.394523),
#        (0.132118        , 3.6380000000e-02 , 0.203483),
#        (6.6967000000e-02, -1.3648000000e-02, 0.686296),],
#       [1,
#        (15.2724         , -2.4916000000e-02),
#        (9.57035         , 0.134967),
#        (5.03618         , -0.314528),
#        (1.15215         , 0.476604),
#        (0.562401        , 0.484191),
#        (0.274204        , 0.184494),
#        (0.120505        , 1.8639000000e-02),
#        (5.2812000000e-02, 1.5040000000e-03),],
#       [2,
#        (11.9756         , -3.1330000000e-03),
#        (7.47998         , 3.3477000000e-02),
#        (4.67383         , -0.103809),
#        (1.17503         , 0.471682),
#        (0.52835         , 0.519189),
#        (0.227757        , -1.091746),
#        (9.4169000000e-02, 8.4120000000e-03),]]

#Ta = [[0,
#        (27.1236         , 3.1053000000e-02 , -9.0380000000e-03),
#        (16.9695         , -0.256246        , 7.7620000000e-02),
#        (10.6228         , 0.753704         , -0.235116),
#        (6.64493         , -0.622181        , 0.198568),
#        (3.5948          , -0.470936        , 0.164353),
#        (1.05044         , 0.795744         , -0.336773),
#        (0.492835        , 0.532076         , -0.394846),
#        (0.148736        , 3.5952000000e-02 , 0.223004),
#        (7.2228000000e-02, -1.3044000000e-02, 0.688639),],
#       [1,
#        (15.5273         , -2.4784000000e-02),
#        (9.72593         , 0.141271),
#        (5.23803         , -0.327328),
#        (1.22702         , 0.483439),
#        (0.605381        , 0.483952),
#        (0.296314        , 0.181262),
#        (0.130511        , 1.8356000000e-02),
#        (5.7116000000e-02, 1.4010000000e-03),],
#       [2,
#        (12.1917 , -3.4800000000e-03),
#        (7.61613 , 4.0819000000e-02),
#        (4.75954 , -0.131487),
#        (1.2759  , 0.587811),
#        (0.592946, 0.402498),
#        (0.264287, -1.168584),
#        (0.112495, 0.160741),]]

#W = [[0,
#       (28.3881         , 2.8698000000e-02 , -8.4840000000e-03),
#       (17.7568         , -0.241037        , 7.4544000000e-02),
#       (11.112          , 0.715218         , -0.228518),
#       (6.94934         , -0.57133         , 0.18744),
#       (3.81506         , -0.507256        , 0.180612),
#       (1.11249         , 0.812876         , -0.361562),
#       (0.525401        , 0.525241         , -0.387363),
#       (0.161529        , 3.4638000000e-02 , 0.248077),
#       (7.6409000000e-02, -1.2935000000e-02, 0.682862),],
#      [1,
#       (16.5554         , -2.5263000000e-02),
#       (10.3744         , 0.140961),
#       (5.5219          , -0.329916),
#       (1.28902         , 0.50172),
#       (0.635596        , 0.480566),
#       (0.309645        , 0.168905),
#       (0.137012        , 1.5727000000e-02),
#       (5.9938000000e-02, 1.4690000000e-03),],
#      [2,
#       (13.6383 , -2.6060000000e-03),
#       (8.51734 , 2.9088000000e-02),
#       (5.32328 , -8.3178000000e-02),
#       (1.39319 , 0.210505),
#       (0.654307, 0.379449),
#       (0.29439 , 0.382538),
#       (0.125722, 0.227906),]]

#Re = [[0,
#        (30.412          , 2.2987000000e-02 , -7.2090000000e-03),
#        (19.0142         , -0.197636        , 6.4574000000e-02),
#        (11.8921         , 0.581376         , -0.196352),
#        (7.43361         , -0.384004        , 0.135427),
#        (4.18113         , -0.60028         , 0.217554),
#        (1.16857         , 0.826427         , -0.390269),
#        (0.553977        , 0.510229         , -0.372336),
#        (0.170781        , 3.6551000000e-02 , 0.26722),
#        (7.9287000000e-02, -8.7660000000e-03, 0.671671),],
#       [1,
#        (18.3488         , -1.6877000000e-02),
#        (11.4877         , 9.2915000000e-02),
#        (5.43256         , -0.291401),
#        (1.37859         , 0.498227),
#        (0.688766        , 0.479607),
#        (0.338083        , 0.175292),
#        (0.14916         , 1.7341000000e-02),
#        (6.4321000000e-02, 1.3480000000e-03),],
#       [2,
#        (13.8248 , -1.0140000000e-03),
#        (8.63586 , 2.0069000000e-02),
#        (5.39695 , -7.0926000000e-02),
#        (1.49432 , 0.213634),
#        (0.713479, 0.374096),
#        (0.32491 , 0.369118),
#        (0.139836, 0.232499),]]

#Os = [[0,
#        (32.3055         , 1.9737000000e-02 , 6.9550000000e-03),
#        (20.1934         , -0.172281        , 4.1792000000e-02),
#        (12.6258         , 0.502059         , -0.218167),
#        (7.89021         , -0.272931        , -0.104958),
#        (4.46183         , -0.662856        , 1.21058),
#        (1.23613         , 0.840311         , -4.12591),
#        (0.58883         , 0.50412          , 4.59028),
#        (0.183261        , 3.6046000000e-02 , -1.606205),
#        (8.3972000000e-02, -7.7430000000e-03, -0.974731),],
#       [1,
#        (19.5631         , -1.4708000000e-02),
#        (12.2451         , 8.1365000000e-02),
#        (5.55342         , -0.286592),
#        (1.46284         , 0.504671),
#        (0.734537        , 0.480348),
#        (0.360575        , 0.172007),
#        (0.156691        , 1.6779000000e-02),
#        (6.6333000000e-02, 1.0290000000e-03),],
#       [2,
#        (14.6857 , -2.6900000000e-04),
#        (9.17124 , 1.6494000000e-02),
#        (5.72992 , -6.6674000000e-02),
#        (1.58756 , 0.224547),
#        (0.767269, 0.37966),
#        (0.352839, 0.361881),
#        (0.153036, 0.221683),]]

#Ir = [[0,
#        (34.2048         , 1.7330000000e-02 , -6.0010000000e-03),
#        (21.3768         , -0.153203        , 5.3885000000e-02),
#        (13.3624         , 0.441933         , -0.160602),
#        (8.34835         , -0.188692        , 8.0395000000e-02),
#        (4.73163         , -0.712225        , 0.257594),
#        (1.30785         , 0.852905         , -0.423751),
#        (0.624334        , 0.499746         , -0.348354),
#        (0.193871        , 3.5249000000e-02 , 0.280031),
#        (8.7949000000e-02, -7.0780000000e-03, 0.654557),],
#       [1,
#        (20.7204         , -1.3202000000e-02),
#        (12.9677         , 7.3952000000e-02),
#        (5.72224         , -0.284312),
#        (1.55038         , 0.510223),
#        (0.78266         , 0.479502),
#        (0.385515        , 0.169772),
#        (0.170609        , 1.6668000000e-02),
#        (7.2829000000e-02, 1.2420000000e-03),],
#       [2,
#        (91.4125 , 2.4000000000e-05),
#        (9.73013 , 1.5217000000e-02),
#        (6.07712 , -6.5724000000e-02),
#        (1.6882  , 0.234005),
#        (0.823786, 0.384535),
#        (0.382068, 0.355849),
#        (0.166965, 0.211976),]]

#Pt = [[0,
#        (36.0064         , 1.5603000000e-02 , -1.1445000000e-02),
#        (22.4991         , -0.1396          , 0.122044),
#        (14.0609         , 0.399469         , -0.375906),
#        (8.78161         , -0.127744        , 5.5388000000e-02),
#        (4.99238         , -0.751451        , 1.133587),
#        (1.38385         , 0.863327         , -4.214919),
#        (0.661617        , 0.497594         , 4.875941),
#        (0.204882        , 3.4758000000e-02 , -2.165936),
#        (9.2230000000e-02, -6.5890000000e-03, -0.426804),],
#       [1,
#        (21.5986         , -1.2515000000e-02),
#        (13.516          , 7.1570000000e-02),
#        (5.92037         , -0.287276),
#        (1.64126         , 0.515419),
#        (0.831131        , 0.480461),
#        (0.40843         , 0.167996),
#        (0.175427        , 1.5860000000e-02),
#        (7.2685000000e-02, 7.9500000000e-04),],
#       [2,
#        (72.7562 , 5.2000000000e-05),
#        (10.4742 , 1.2626000000e-02),
#        (6.2509  , -6.3241000000e-02),
#        (1.80185 , 0.239647),
#        (0.888454, 0.387672),
#        (0.415665, 0.351744),
#        (0.18308 , 0.20529),]]

#Au = [[0,
#        (36.0126         , 1.9029000000e-02 , -6.7770000000e-03),
#        (22.5645         , -0.1678          , 6.0008000000e-02),
#        (14.162          , 0.496677         , -0.183328),
#        (8.85487         , -0.266256        , 0.114719),
#        (5.06072         , -0.699898        , 0.248822),
#        (1.47405         , 0.873108         , -0.437671),
#        (0.704913        , 0.502582         , -0.331108),
#        (0.217787        , 3.2196000000e-02 , 0.274181),
#        (9.7408000000e-02, -5.5030000000e-03, 0.637738),
#        (4.1214000000e-02, 2.5190000000e-03 , 0.309236),],
#       [1,
#        (21.5954         , -1.3218000000e-02),
#        (13.5145         , 8.0196000000e-02),
#        (6.25514         , -0.296686),
#        (1.71814         , 0.528959),
#        (0.869439        , 0.478889),
#        (0.426759        , 0.15762),
#        (0.184297        , 1.3897000000e-02),
#        (7.6379000000e-02, 8.3500000000e-04),
#        (3.1220000000e-02, -2.9000000000e-05),],
#       [2,
#        (87.0208         , 4.4000000000e-05),
#        (11.0668         , 1.4288000000e-02),
#        (6.66047         , -6.8876000000e-02),
#        (1.94696         , 0.239559),
#        (0.984706        , 0.387323),
#        (0.474655        , 0.348756),
#        (0.216558        , 0.198492),
#        (9.1472000000e-02, 4.9879000000e-02),]]

#Hg = [[0,
#        (98.3058         , 1.0330000000e-03 , -3.5600000000e-04),
#        (19.6406         , -0.106382        , 3.7909000000e-02),
#        (12.3397         , 0.532073         , -0.200013),
#        (7.74782         , -0.522324        , 0.224093),
#        (4.86291         , -0.537321        , 0.179374),
#        (1.57719         , 0.884788         , -0.450833),
#        (0.752926        , 0.513834         , -0.339055),
#        (0.235112        , 2.9407000000e-02 , 0.293414),
#        (0.103968        , -6.1590000000e-03, 0.644628),
#        (4.3400000000e-02, 1.3840000000e-03 , 0.291626),],
#       [1,
#        (21.4065         , -1.2837000000e-02),
#        (13.3929         , 8.6531000000e-02),
#        (6.51021         , -0.308041),
#        (1.82222         , 0.532794),
#        (0.926507        , 0.482207),
#        (0.455082        , 0.154695),
#        (0.19276         , 1.3201000000e-02),
#        (7.8689000000e-02, 5.8500000000e-04),
#        (3.1729000000e-02, 2.0000000000e-05),],
#       [2,
#        (86.9881 , 5.8000000000e-05),
#        (11.9913 , 1.2779000000e-02),
#        (6.93648 , -6.8963000000e-02),
#        (2.08641 , 0.241563),
#        (1.07664 , 0.387858),
#        (0.531153, 0.345441),
#        (0.248808, 0.191509),
#        (0.10817 , 4.6502000000e-02),]]

#Tl = [[0,
#        (562.304         , 1.9800000000e-04 , -8.4000000000e-05),
#        (35.2498         , 2.2111000000e-02 , -7.1210000000e-03),
#        (22.0333         , -0.177173        , 6.2426000000e-02),
#        (13.7732         , 0.524763         , -0.198908),
#        (6.60703         , -0.845596        , 0.362328),
#        (4.1305          , -0.197292        , 5.9003000000e-02),
#        (1.69156         , 0.906998         , -0.495126),
#        (0.821021        , 0.521724         , -0.40182),
#        (0.277346        , 3.0621000000e-02 , 0.331809),
#        (0.126773        , -5.6180000000e-03, 0.679822),
#        (5.3300000000e-02, 1.1640000000e-03 , 0.258284),],
#       [1,
#        (18.7574         , -1.6678000000e-02, 2.6180000000e-03),
#        (11.7331         , 0.151246         , -3.2879000000e-02),
#        (6.97696         , -0.381416        , 9.2406000000e-02),
#        (1.92744         , 0.550395         , -0.166627),
#        (0.980847        , 0.489504         , -0.15637),
#        (0.478809        , 0.140689         , -2.3450000000e-03),
#        (0.190857        , 8.9600000000e-03 , 0.330988),
#        (7.5106000000e-02, 1.6700000000e-04 , 0.545236),
#        (2.9554000000e-02, 9.1000000000e-05 , 0.268724),],
#       [2,
#        (64.9978         , 1.9200000000e-04),
#        (10.5732         , 2.1383000000e-02),
#        (6.61217         , -8.8238000000e-02),
#        (2.17353         , 0.270285),
#        (1.10102         , 0.426546),
#        (0.529098        , 0.344412),
#        (0.23866         , 0.144068),
#        (9.0800000000e-02, 1.5012000000e-02),]]

#Pb = [[0,
#        (544.675         , 3.1900000000e-04 , -1.4600000000e-04),
#        (36.5128         , 2.4214000000e-02 , -8.3480000000e-03),
#        (22.7761         , -0.185466        , 6.9448000000e-02),
#        (14.2262         , 0.54609          , -0.220729),
#        (6.895           , -0.870515        , 0.400345),
#        (4.30969         , -0.203578        , 6.2964000000e-02),
#        (1.80085         , 0.908924         , -0.531559),
#        (0.890768        , 0.532            , -0.447946),
#        (0.318968        , 3.2284000000e-02 , 0.362706),
#        (0.148352        , -5.2680000000e-03, 0.696673),
#        (6.3288000000e-02, 1.0520000000e-03 , 0.244099),],
#       [1,
#        (18.6489         , -1.7800000000e-02, 3.0930000000e-03),
#        (11.6679         , 0.179357         , -4.5316000000e-02),
#        (7.29349         , -0.416725        , 0.117392),
#        (2.02849         , 0.559518         , -0.200762),
#        (1.04097         , 0.492518         , -0.184882),
#        (0.51419         , 0.13237          , -5.4120000000e-03),
#        (0.228651        , 8.0590000000e-03 , 0.369878),
#        (9.5828000000e-02, 7.9900000000e-04 , 0.546891),
#        (3.9229000000e-02, -2.7000000000e-05, 0.229493),],
#       [2,
#        (61.397  , 3.2500000000e-04),
#        (12.3735 , 1.3211000000e-02),
#        (6.92686 , -7.2781000000e-02),
#        (2.33087 , 0.269721),
#        (1.21019 , 0.426586),
#        (0.600516, 0.338139),
#        (0.280787, 0.135866),
#        (0.1093  , 1.4281000000e-02),]]

#Bi = [[0,
#        (798.633         , 3.8900000000e-04 , -1.9100000000e-04),
#        (95.0023         , 2.1040000000e-03 , -8.8500000000e-04),
#        (21.252          , -0.129681        , 5.5053000000e-02),
#        (13.2919         , 0.665119         , -0.302406),
#        (8.3121          , -0.774022        , 0.396483),
#        (5.19476         , -0.457747        , 0.178323),
#        (1.90972         , 0.901072         , -0.570493),
#        (0.962271        , 0.544534         , -0.479259),
#        (0.356026        , 3.3769000000e-02 , 0.398),
#        (0.168327        , -5.2330000000e-03, 0.700968),
#        (7.3265000000e-02, 1.0360000000e-03 , 0.231598),],
#       [1,
#        (19.2259         , -1.6152000000e-02, 2.7330000000e-03),
#        (12.0378         , 0.176031         , -4.8843000000e-02),
#        (7.53621         , -0.420103        , 0.13184),
#        (2.16084         , 0.552674         , -0.225271),
#        (1.13036         , 0.499562         , -0.207876),
#        (0.566778        , 0.134495         , -1.5585000000e-02),
#        (0.271608        , 8.0460000000e-03 , 0.393849),
#        (0.117769        , 1.0310000000e-03 , 0.55088),
#        (4.9304000000e-02, -1.6200000000e-04, 0.21115),],
#       [2,
#        (65.0224 , 3.9500000000e-04),
#        (13.6908 , 1.1201000000e-02),
#        (7.09591 , -7.2317000000e-02),
#        (2.5209  , 0.263286),
#        (1.34066 , 0.427325),
#        (0.682558, 0.337534),
#        (0.327714, 0.133787),
#        (0.1306  , 1.4699000000e-02),]]

#Po = [[0,
#        (2284.76         , 2.3600000000e-04 , 1.1400000000e-04),
#        (345.774         , 1.1910000000e-03 , 6.7900000000e-04),
#        (40.9204         , 2.6896000000e-02 , 7.4840000000e-03),
#        (25.5771         , -0.169909        , -5.7831000000e-02),
#        (15.9942         , 0.455449         , 0.184277),
#        (6.79383         , -0.974807        , -0.471617),
#        (1.92709         , 0.917259         , 0.665644),
#        (0.997032        , 0.502663         , 0.419202),
#        (0.34035         , 2.7567000000e-02 , -0.580224),
#        (0.161724        , -6.2060000000e-03, -0.612084),
#        (7.3536000000e-02, 1.3620000000e-03 , -0.14587),],
#       [1,
#        (19.7714         , -1.4491000000e-02, 2.1050000000e-03),
#        (12.3921         , 0.173269         , -5.0849000000e-02),
#        (7.77407         , -0.424167        , 0.143289),
#        (2.29131         , 0.552409         , -0.247041),
#        (1.20594         , 0.512089         , -0.232235),
#        (0.594611        , 0.127837         , 7.1000000000e-03),
#        (0.298645        , 5.2540000000e-03 , 0.424629),
#        (0.129742        , 2.0100000000e-03 , 0.531974),
#        (5.3935000000e-02, -1.3200000000e-04, 0.197294),],
#       [2,
#        (67.9636 , 4.9900000000e-04),
#        (14.9883 , 1.0150000000e-02),
#        (7.26074 , -7.1905000000e-02),
#        (2.7107  , 0.259436),
#        (1.46383 , 0.432343),
#        (0.755828, 0.337581),
#        (0.367176, 0.127293),
#        (0.1484  , 1.3505000000e-02),]]

#At = [[0,
#        (2405.31         , 1.7000000000e-04 , -8.2000000000e-05),
#        (365.565         , 8.1900000000e-04 , -4.9300000000e-04),
#        (41.9062         , 2.2487000000e-02 , -5.4020000000e-03),
#        (26.2026         , -0.157656        , 5.3170000000e-02),
#        (16.3915         , 0.452899         , -0.188744),
#        (7.08341         , -0.991743        , 0.499727),
#        (2.03313         , 0.922504         , -0.707197),
#        (1.07007         , 0.505242         , -0.433752),
#        (0.376071        , 2.8556000000e-02 , 0.612573),
#        (0.179447        , -6.1480000000e-03, 0.611353),
#        (8.1833000000e-02, 1.3480000000e-03 , 0.13651),],
#       [1,
#        (20.297          , -1.1810000000e-02, 1.0180000000e-03),
#        (12.7312         , 0.166948         , -5.1250000000e-02),
#        (8.00034         , -0.425172        , 0.153475),
#        (2.44796         , 0.537122         , -0.26161),
#        (1.31082         , 0.526732         , -0.255545),
#        (0.645865        , 0.132645         , 1.3314000000e-02),
#        (0.333758        , 4.5660000000e-03 , 0.443477),
#        (0.146166        , 2.8370000000e-03 , 0.525282),
#        (6.0871000000e-02, -4.7000000000e-05, 0.187962),],
#       [2,
#        (70.9454 , 6.2000000000e-04),
#        (16.256  , 9.6710000000e-03),
#        (7.36032 , -7.3459000000e-02),
#        (2.92336 , 0.252588),
#        (1.59912 , 0.437947),
#        (0.834087, 0.340053),
#        (0.408141, 0.123067),
#        (0.1683  , 1.2899000000e-02),]]

#Rn = [[0,
#        (3407.2          , 2.2900000000e-04 , -1.2500000000e-04),
#        (516.483         , 1.2550000000e-03 , -7.9100000000e-04),
#        (97.0281         , 3.6740000000e-03 , -1.3530000000e-03),
#        (26.4655         , -8.8574000000e-02, 3.2816000000e-02),
#        (16.5631         , 0.373319         , -0.166234),
#        (7.25106         , -0.962237        , 0.513472),
#        (2.17193         , 0.875167         , -0.729337),
#        (1.18012         , 0.552034         , -0.453315),
#        (0.401495        , 3.5608000000e-02 , 0.651236),
#        (0.194842        , -9.1960000000e-03, 0.586233),
#        (9.0925000000e-02, 2.0960000000e-03 , 0.128904),],
#       [1,
#        (20.7239         , -8.7120000000e-03, -2.3300000000e-04),
#        (12.9996         , 0.161529         , -5.1481000000e-02),
#        (8.17348         , -0.433919        , 0.165577),
#        (2.74742         , 0.444768         , -0.232341),
#        (1.5639          , 0.562185         , -0.287458),
#        (0.81102         , 0.191255         , -4.8609000000e-02),
#        (0.400963        , 1.3351000000e-02 , 0.445046),
#        (0.173764        , 1.5260000000e-03 , 0.548068),
#        (7.1576000000e-02, -1.5600000000e-04, 0.199923),],
#       [2,
#        (75.4318, 7.3400000000e-04),
#        (18.0171, 8.8650000000e-03),
#        (7.35165, -7.7145000000e-02),
#        (3.25212, 0.225037),
#        (1.80989, 0.438657),
#        (0.95655, 0.354579),
#        (0.47475, 0.133838),
#        (0.196  , 1.5079000000e-02),]]
