# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._calculate_refund_operations import build_post_request
from .._vendor import AzureReservationAPIMixinABC

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class CalculateRefundOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.reservations.aio.AzureReservationAPI`'s
        :attr:`calculate_refund` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def post(
        self,
        reservation_order_id: str,
        body: _models.CalculateRefundRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CalculateRefundResponse:
        """Calculate the refund amount of a reservation order.

        Calculate price for returning ``Reservations`` if there are no policy errors.

        :param reservation_order_id: Order Id of the reservation. Required.
        :type reservation_order_id: str
        :param body: Information needed for calculating refund of a reservation. Required.
        :type body: ~azure.mgmt.reservations.models.CalculateRefundRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CalculateRefundResponse or the result of cls(response)
        :rtype: ~azure.mgmt.reservations.models.CalculateRefundResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def post(
        self, reservation_order_id: str, body: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CalculateRefundResponse:
        """Calculate the refund amount of a reservation order.

        Calculate price for returning ``Reservations`` if there are no policy errors.

        :param reservation_order_id: Order Id of the reservation. Required.
        :type reservation_order_id: str
        :param body: Information needed for calculating refund of a reservation. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CalculateRefundResponse or the result of cls(response)
        :rtype: ~azure.mgmt.reservations.models.CalculateRefundResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def post(
        self, reservation_order_id: str, body: Union[_models.CalculateRefundRequest, IO], **kwargs: Any
    ) -> _models.CalculateRefundResponse:
        """Calculate the refund amount of a reservation order.

        Calculate price for returning ``Reservations`` if there are no policy errors.

        :param reservation_order_id: Order Id of the reservation. Required.
        :type reservation_order_id: str
        :param body: Information needed for calculating refund of a reservation. Is either a model type
         or a IO type. Required.
        :type body: ~azure.mgmt.reservations.models.CalculateRefundRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CalculateRefundResponse or the result of cls(response)
        :rtype: ~azure.mgmt.reservations.models.CalculateRefundResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-11-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-11-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CalculateRefundResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "CalculateRefundRequest")

        request = build_post_request(
            reservation_order_id=reservation_order_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.post.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CalculateRefundResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    post.metadata = {"url": "/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/calculateRefund"}
