# PySNMP SMI module. Autogenerated from smidump -f python IPV6-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:13 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

###############################################################
# CHANGED MANUALLY
# ipv6AddrEntry changed "ipv6IfIndex", added to index one more value: index, another index, ipv6
###############################################################

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( Ipv6Address, Ipv6AddressIfIdentifier, Ipv6AddressPrefix, Ipv6IfIndex, Ipv6IfIndexOrZero, ) = mibBuilder.importSymbols("IPV6-TC", "Ipv6Address", "Ipv6AddressIfIdentifier", "Ipv6AddressPrefix", "Ipv6IfIndex", "Ipv6IfIndexOrZero")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( DisplayString, PhysAddress, RowPointer, TimeStamp, TruthValue, VariablePointer, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "PhysAddress", "RowPointer", "TimeStamp", "TruthValue", "VariablePointer")

# Objects

ipv6MIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 55)).setRevisions(("1998-02-05 21:55",))
if mibBuilder.loadTexts: ipv6MIB.setOrganization("IETF IPv6 Working Group")
if mibBuilder.loadTexts: ipv6MIB.setContactInfo("           Dimitry Haskin\n\nPostal: Bay Networks, Inc.\n        660 Techology Park Drive.\n        Billerica, MA  01821\n        US\n\n   Tel: +1-978-916-8124\nE-mail: dhaskin@baynetworks.com\n\n        Steve Onishi\n\nPostal: Bay Networks, Inc.\n        3 Federal Street\n        Billerica, MA 01821\n        US\n\n   Tel: +1-978-916-3816\nE-mail: sonishi@baynetworks.com")
if mibBuilder.loadTexts: ipv6MIB.setDescription("The MIB module for entities implementing the IPv6\nprotocol.")
ipv6MIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 55, 1))
ipv6Forwarding = MibScalar((1, 3, 6, 1, 2, 1, 55, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("forwarding", 1), ("notForwarding", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6Forwarding.setDescription("The indication of whether this entity is acting\nas an IPv6 router in respect to the forwarding of\ndatagrams received by, but not addressed to, this\nentity.  IPv6 routers forward datagrams.  IPv6\nhosts do not (except those source-routed via the\nhost).\n\nNote that for some managed nodes, this object may\ntake on only a subset of the values possible.\nAccordingly, it is appropriate for an agent to\nreturn a `wrongValue' response if a management\nstation attempts to change this object to an\ninappropriate value.")
ipv6DefaultHopLimit = MibScalar((1, 3, 6, 1, 2, 1, 55, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255)).clone(64)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6DefaultHopLimit.setDescription("The default value inserted into the Hop Limit\nfield of the IPv6 header of datagrams originated\nat this entity, whenever a Hop Limit value is not\nsupplied by the transport layer protocol.")
ipv6Interfaces = MibScalar((1, 3, 6, 1, 2, 1, 55, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6Interfaces.setDescription("The number of IPv6 interfaces (regardless of\ntheir current state) present on this system.")
ipv6IfTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 55, 1, 4), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfTableLastChange.setDescription("The value of sysUpTime at the time of the last\ninsertion or removal of an entry in the\nipv6IfTable. If the number of entries has been\nunchanged since the last re-initialization of\nthe local network management subsystem, then this\nobject contains a zero value.")
ipv6IfTable = MibTable((1, 3, 6, 1, 2, 1, 55, 1, 5))
if mibBuilder.loadTexts: ipv6IfTable.setDescription("The IPv6 Interfaces table contains information\non the entity's internetwork-layer interfaces.\nAn IPv6 interface constitutes a logical network\nlayer attachment to the layer immediately below\nIPv6 including internet layer 'tunnels', such as\ntunnels over IPv4 or IPv6 itself.")
ipv6IfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 55, 1, 5, 1)).setIndexNames((0, "IPV6-MIB", "ipv6IfIndex"))
if mibBuilder.loadTexts: ipv6IfEntry.setDescription("An interface entry containing objects\nabout a particular IPv6 interface.")
ipv6IfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 5, 1, 1), Ipv6IfIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipv6IfIndex.setDescription("A unique non-zero value identifying\nthe particular IPv6 interface.")
ipv6IfDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 5, 1, 2), DisplayString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6IfDescr.setDescription("A textual string containing information about the\ninterface.  This string may be set by the network\nmanagement system.")
ipv6IfLowerLayer = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 5, 1, 3), VariablePointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfLowerLayer.setDescription("This object identifies the protocol layer over\nwhich this network interface operates.  If this\nnetwork interface operates over the data-link\nlayer, then the value of this object refers to an\ninstance of ifIndex [6]. If this network interface\noperates over an IPv4 interface, the value of this\nobject refers to an instance of ipAdEntAddr [3].\n\nIf this network interface operates over another\nIPv6 interface, the value of this object refers to\nan instance of ipv6IfIndex.  If this network\ninterface is not currently operating over an active\nprotocol layer, then the value of this object\nshould be set to the OBJECT ID { 0 0 }.")
ipv6IfEffectiveMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 5, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfEffectiveMtu.setDescription("The size of the largest IPv6 packet which can be\nsent/received on the interface, specified in\noctets.")
ipv6IfReasmMaxSize = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 5, 1, 5), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfReasmMaxSize.setDescription("The size of the largest IPv6 datagram which this\nentity can re-assemble from incoming IPv6 fragmented\ndatagrams received on this interface.")
ipv6IfIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 5, 1, 6), Ipv6AddressIfIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6IfIdentifier.setDescription("The Interface Identifier for this interface that\nis (at least) unique on the link this interface is\nattached to. The Interface Identifier is combined\nwith an address prefix to form an interface address.\n\nBy default, the Interface Identifier is autoconfigured\naccording to the rules of the link type this\ninterface is attached to.")
ipv6IfIdentifierLength = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 5, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 64))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6IfIdentifierLength.setDescription("The length of the Interface Identifier in bits.")
ipv6IfPhysicalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 5, 1, 8), PhysAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfPhysicalAddress.setDescription("The interface's physical address. For example, for\nan IPv6 interface attached to an 802.x link, this\nobject normally contains a MAC address. Note that\nin some cases this address may differ from the\naddress of the interface's protocol sub-layer.  The\ninterface's media-specific MIB must define the bit\nand byte ordering and the format of the value of\nthis object. For interfaces which do not have such\nan address (e.g., a serial line), this object should\ncontain an octet string of zero length.")
ipv6IfAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 5, 1, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("up", 1), ("down", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6IfAdminStatus.setDescription("The desired state of the interface.  When a managed\nsystem initializes,  all IPv6 interfaces start with\nipv6IfAdminStatus in the down(2) state.  As a result\nof either explicit management action or per\nconfiguration information retained by the managed\nsystem,  ipv6IfAdminStatus is then changed to\nthe up(1) state (or remains in the down(2) state).")
ipv6IfOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 5, 1, 10), Integer().subtype(subtypeSpec=SingleValueConstraint(4,3,1,2,5,)).subtype(namedValues=NamedValues(("up", 1), ("down", 2), ("noIfIdentifier", 3), ("unknown", 4), ("notPresent", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfOperStatus.setDescription("The current operational state of the interface.\nThe noIfIdentifier(3) state indicates that no valid\nInterface Identifier is assigned to the interface.\nThis state usually indicates that the link-local\ninterface address failed Duplicate Address Detection.\nIf ipv6IfAdminStatus is down(2) then ipv6IfOperStatus\nshould be down(2).  If ipv6IfAdminStatus is changed\nto up(1) then ipv6IfOperStatus should change to up(1)\nif the interface is ready to transmit and receive\nnetwork traffic; it should remain in the down(2) or\nnoIfIdentifier(3) state if and only if there is a\nfault that prevents it from going to the up(1) state;\nit should remain in the notPresent(5) state if\nthe interface has missing (typically, lower layer)\ncomponents.")
ipv6IfLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 5, 1, 11), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfLastChange.setDescription("The value of sysUpTime at the time the interface\nentered its current operational state.  If the\ncurrent state was entered prior to the last\nre-initialization of the local network management\nsubsystem, then this object contains a zero\nvalue.")
ipv6IfStatsTable = MibTable((1, 3, 6, 1, 2, 1, 55, 1, 6))
if mibBuilder.loadTexts: ipv6IfStatsTable.setDescription("IPv6 interface traffic statistics.")
ipv6IfStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 55, 1, 6, 1))
if mibBuilder.loadTexts: ipv6IfStatsEntry.setDescription("An interface statistics entry containing objects\nat a particular IPv6 interface.")
ipv6IfStatsInReceives = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsInReceives.setDescription("The total number of input datagrams received by\nthe interface, including those received in error.")
ipv6IfStatsInHdrErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsInHdrErrors.setDescription("The number of input datagrams discarded due to\nerrors in their IPv6 headers, including version\nnumber mismatch, other format errors, hop count\nexceeded, errors discovered in processing their\nIPv6 options, etc.")
ipv6IfStatsInTooBigErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsInTooBigErrors.setDescription("The number of input datagrams that could not be\nforwarded because their size exceeded the link MTU\nof outgoing interface.")
ipv6IfStatsInNoRoutes = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsInNoRoutes.setDescription("The number of input datagrams discarded because no\nroute could be found to transmit them to their\ndestination.")
ipv6IfStatsInAddrErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsInAddrErrors.setDescription("The number of input datagrams discarded because\nthe IPv6 address in their IPv6 header's destination\nfield was not a valid address to be received at\nthis entity.  This count includes invalid\naddresses (e.g., ::0) and unsupported addresses\n(e.g., addresses with unallocated prefixes).  For\nentities which are not IPv6 routers and therefore\ndo not forward datagrams, this counter includes\ndatagrams discarded because the destination address\nwas not a local address.")
ipv6IfStatsInUnknownProtos = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsInUnknownProtos.setDescription("The number of locally-addressed datagrams\nreceived successfully but discarded because of an\nunknown or unsupported protocol. This counter is\nincremented at the interface to which these\ndatagrams were addressed which might not be\nnecessarily the input interface for some of\nthe datagrams.")
ipv6IfStatsInTruncatedPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsInTruncatedPkts.setDescription("The number of input datagrams discarded because\ndatagram frame didn't carry enough data.")
ipv6IfStatsInDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsInDiscards.setDescription("The number of input IPv6 datagrams for which no\nproblems were encountered to prevent their\ncontinued processing, but which were discarded\n(e.g., for lack of buffer space).  Note that this\ncounter does not include any datagrams discarded\nwhile awaiting re-assembly.")
ipv6IfStatsInDelivers = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsInDelivers.setDescription("The total number of datagrams successfully\ndelivered to IPv6 user-protocols (including ICMP).\nThis counter is incremented at the interface to\nwhich these datagrams were addressed which might\nnot be necessarily the input interface for some of\nthe datagrams.")
ipv6IfStatsOutForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsOutForwDatagrams.setDescription("The number of output datagrams which this\nentity received and forwarded to their final\ndestinations.  In entities which do not act\nas IPv6 routers, this counter will include\nonly those packets which were Source-Routed\nvia this entity, and the Source-Route\nprocessing was successful.  Note that for\na successfully forwarded datagram the counter\nof the outgoing interface is incremented.")
ipv6IfStatsOutRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsOutRequests.setDescription("The total number of IPv6 datagrams which local IPv6\nuser-protocols (including ICMP) supplied to IPv6 in\nrequests for transmission.  Note that this counter\ndoes not include any datagrams counted in\nipv6IfStatsOutForwDatagrams.")
ipv6IfStatsOutDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsOutDiscards.setDescription("The number of output IPv6 datagrams for which no\nproblem was encountered to prevent their\ntransmission to their destination, but which were\ndiscarded (e.g., for lack of buffer space).  Note\nthat this counter would include datagrams counted\nin ipv6IfStatsOutForwDatagrams if any such packets\nmet this (discretionary) discard criterion.")
ipv6IfStatsOutFragOKs = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsOutFragOKs.setDescription("The number of IPv6 datagrams that have been\nsuccessfully fragmented at this output interface.")
ipv6IfStatsOutFragFails = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsOutFragFails.setDescription("The number of IPv6 datagrams that have been\ndiscarded because they needed to be fragmented\nat this output interface but could not be.")
ipv6IfStatsOutFragCreates = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsOutFragCreates.setDescription("The number of output datagram fragments that have\nbeen generated as a result of fragmentation at\nthis output interface.")
ipv6IfStatsReasmReqds = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsReasmReqds.setDescription("The number of IPv6 fragments received which needed\nto be reassembled at this interface.  Note that this\ncounter is incremented at the interface to which\nthese fragments were addressed which might not\nbe necessarily the input interface for some of\nthe fragments.")
ipv6IfStatsReasmOKs = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsReasmOKs.setDescription("The number of IPv6 datagrams successfully\nreassembled.  Note that this counter is incremented\nat the interface to which these datagrams were\naddressed which might not be necessarily the input\ninterface for some of the fragments.")
ipv6IfStatsReasmFails = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsReasmFails.setDescription("The number of failures detected by the IPv6 re-\nassembly algorithm (for whatever reason: timed\nout, errors, etc.).  Note that this is not\nnecessarily a count of discarded IPv6 fragments\nsince some algorithms (notably the algorithm in\nRFC 815) can lose track of the number of fragments\nby combining them as they are received.\nThis counter is incremented at the interface to which\nthese fragments were addressed which might not be\nnecessarily the input interface for some of the\nfragments.")
ipv6IfStatsInMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsInMcastPkts.setDescription("The number of multicast packets received\nby the interface")
ipv6IfStatsOutMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 6, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfStatsOutMcastPkts.setDescription("The number of multicast packets transmitted\nby the interface")
ipv6AddrPrefixTable = MibTable((1, 3, 6, 1, 2, 1, 55, 1, 7))
if mibBuilder.loadTexts: ipv6AddrPrefixTable.setDescription("The list of IPv6 address prefixes of\nIPv6 interfaces.")
ipv6AddrPrefixEntry = MibTableRow((1, 3, 6, 1, 2, 1, 55, 1, 7, 1)).setIndexNames((0, "IPV6-MIB", "ipv6IfIndex"), (0, "IPV6-MIB", "ipv6AddrPrefix"), (0, "IPV6-MIB", "ipv6AddrPrefixLength"))
if mibBuilder.loadTexts: ipv6AddrPrefixEntry.setDescription("An interface entry containing objects of\na particular IPv6 address prefix.")
ipv6AddrPrefix = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 7, 1, 1), Ipv6AddressPrefix()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipv6AddrPrefix.setDescription("The prefix associated with the this interface.")
ipv6AddrPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 7, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 128))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipv6AddrPrefixLength.setDescription("The length of the prefix (in bits).")
ipv6AddrPrefixOnLinkFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 7, 1, 3), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6AddrPrefixOnLinkFlag.setDescription("This object has the value 'true(1)', if this\nprefix can be used  for on-link determination\nand the value 'false(2)' otherwise.")
ipv6AddrPrefixAutonomousFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 7, 1, 4), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6AddrPrefixAutonomousFlag.setDescription("Autonomous address configuration flag. When\ntrue(1), indicates that this prefix can be used\nfor autonomous address configuration (i.e. can\nbe used to form a local interface address).\nIf false(2), it is not used to autoconfigure\na local interface address.")
ipv6AddrPrefixAdvPreferredLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 7, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6AddrPrefixAdvPreferredLifetime.setDescription("It is the length of time in seconds that this\nprefix will remain preferred, i.e. time until\ndeprecation.  A value of 4,294,967,295 represents\ninfinity.\n\nThe address generated from a deprecated prefix\nshould no longer be used as a source address in\nnew communications, but packets received on such\nan interface are processed as expected.")
ipv6AddrPrefixAdvValidLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 7, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6AddrPrefixAdvValidLifetime.setDescription("It is the length of time in seconds that this\nprefix will remain valid, i.e. time until\ninvalidation.  A value of 4,294,967,295 represents\ninfinity.\n\nThe address generated from an invalidated prefix\nshould not appear as the destination or source\naddress of a packet.")
ipv6AddrTable = MibTable((1, 3, 6, 1, 2, 1, 55, 1, 8))
if mibBuilder.loadTexts: ipv6AddrTable.setDescription("The table of addressing information relevant to\nthis node's interface addresses.")
ipv6AddrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 55, 1, 8, 1)).setIndexNames((0, "IPV6-MIB", "ipv6IfIndex"), (0, "IPV6-MIB", "ipv6IfIndex"), (0, "IPV6-MIB", "ipv6AddrAddress"))
if mibBuilder.loadTexts: ipv6AddrEntry.setDescription("The addressing information for one of this\nnode's interface addresses.")
ipv6AddrAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 8, 1, 1), Ipv6Address()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipv6AddrAddress.setDescription("The IPv6 address to which this entry's addressing\ninformation pertains.")
ipv6AddrPfxLength = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 8, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6AddrPfxLength.setDescription("The length of the prefix (in bits) associated with\nthe IPv6 address of this entry.")
ipv6AddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 8, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,3,)).subtype(namedValues=NamedValues(("stateless", 1), ("stateful", 2), ("unknown", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6AddrType.setDescription("The type of address. Note that 'stateless(1)'\nrefers to an address that was statelessly\nautoconfigured; 'stateful(2)' refers to a address\nwhich was acquired by via a stateful protocol\n(e.g. DHCPv6, manual configuration).")
ipv6AddrAnycastFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 8, 1, 4), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6AddrAnycastFlag.setDescription("This object has the value 'true(1)', if this\naddress is an anycast address and the value\n'false(2)' otherwise.")
ipv6AddrStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 8, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(5,4,3,1,2,)).subtype(namedValues=NamedValues(("preferred", 1), ("deprecated", 2), ("invalid", 3), ("inaccessible", 4), ("unknown", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6AddrStatus.setDescription("Address status.  The preferred(1) state indicates\nthat this is a valid address that can appear as\nthe destination or source address of a packet.\nThe deprecated(2) state indicates that this is\na valid but deprecated address that should no longer\nbe used as a source address in new communications,\nbut packets addressed to such an address are\nprocessed as expected. The invalid(3) state indicates\nthat this is not valid address which should not\nappear as the destination or source address of\na packet. The inaccessible(4) state indicates that\nthe address is not accessible because the interface\nto which this address is assigned is not operational.")
ipv6RouteNumber = MibScalar((1, 3, 6, 1, 2, 1, 55, 1, 9), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6RouteNumber.setDescription("The number of current ipv6RouteTable entries.\nThis is primarily to avoid having to read\nthe table in order to determine this number.")
ipv6DiscardedRoutes = MibScalar((1, 3, 6, 1, 2, 1, 55, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6DiscardedRoutes.setDescription("The number of routing entries which were chosen\nto be discarded even though they are valid.  One\npossible reason for discarding such an entry could\nbe to free-up buffer space for other routing\nentries.")
ipv6RouteTable = MibTable((1, 3, 6, 1, 2, 1, 55, 1, 11))
if mibBuilder.loadTexts: ipv6RouteTable.setDescription("IPv6 Routing table. This table contains\nan entry for each valid IPv6 unicast route\nthat can be used for packet forwarding\ndetermination.")
ipv6RouteEntry = MibTableRow((1, 3, 6, 1, 2, 1, 55, 1, 11, 1)).setIndexNames((0, "IPV6-MIB", "ipv6RouteDest"), (0, "IPV6-MIB", "ipv6RoutePfxLength"), (0, "IPV6-MIB", "ipv6RouteIndex"))
if mibBuilder.loadTexts: ipv6RouteEntry.setDescription("A routing entry.")
ipv6RouteDest = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 11, 1, 1), Ipv6Address()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipv6RouteDest.setDescription("The destination IPv6 address of this route.\nThis object may not take a Multicast address\nvalue.")
ipv6RoutePfxLength = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 11, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 128))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipv6RoutePfxLength.setDescription("Indicates the prefix length of the destination\naddress.")
ipv6RouteIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 11, 1, 3), Unsigned32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipv6RouteIndex.setDescription("The value which uniquely identifies the route\namong the routes to the same network layer\ndestination.  The way this value is chosen is\nimplementation specific but it must be unique for\nipv6RouteDest/ipv6RoutePfxLength pair and remain\nconstant for the life of the route.")
ipv6RouteIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 11, 1, 4), Ipv6IfIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6RouteIfIndex.setDescription("The index value which uniquely identifies the local\ninterface through which the next hop of this\nroute should be reached.  The interface identified\nby a particular value of this index is the same\ninterface as identified by the same value of\nipv6IfIndex.  For routes of the discard type this\nvalue can be zero.")
ipv6RouteNextHop = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 11, 1, 5), Ipv6Address()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6RouteNextHop.setDescription("On remote routes, the address of the next\nsystem en route;  otherwise, ::0\n('00000000000000000000000000000000'H in ASN.1\nstring representation).")
ipv6RouteType = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 11, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,3,4,)).subtype(namedValues=NamedValues(("other", 1), ("discard", 2), ("local", 3), ("remote", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6RouteType.setDescription("The type of route. Note that 'local(3)' refers\nto a route for which the next hop is the final\ndestination; 'remote(4)' refers to a route for\nwhich  the  next  hop is not the final\ndestination; 'discard(2)' refers to a route\nindicating that packets to destinations matching\nthis route are to be discarded (sometimes called\nblack-hole route).")
ipv6RouteProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 11, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(7,1,3,9,4,6,8,2,5,)).subtype(namedValues=NamedValues(("other", 1), ("local", 2), ("netmgmt", 3), ("ndisc", 4), ("rip", 5), ("ospf", 6), ("bgp", 7), ("idrp", 8), ("igrp", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6RouteProtocol.setDescription("The routing mechanism via which this route was\nlearned.")
ipv6RoutePolicy = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 11, 1, 8), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6RoutePolicy.setDescription("The general set of conditions that would cause the\nselection of one multipath route (set of next hops\nfor a given destination) is referred to as 'policy'.\nUnless the mechanism indicated by ipv6RouteProtocol\nspecified otherwise, the policy specifier is the\n8-bit Traffic Class field of the IPv6 packet header\nthat is zero extended at the left to a 32-bit value.\n\nProtocols defining 'policy' otherwise must either\ndefine a set of values which are valid for\nthis object or must implement an integer-\ninstanced  policy table for which this object's\nvalue acts as an index.")
ipv6RouteAge = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 11, 1, 9), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6RouteAge.setDescription("The number of seconds since this route was last\nupdated or otherwise determined to be correct.\nNote that no semantics of `too old' can be implied\nexcept through knowledge of the routing protocol\nby which the route was learned.")
ipv6RouteNextHopRDI = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 11, 1, 10), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6RouteNextHopRDI.setDescription("The Routing Domain ID of the Next Hop.\nThe  semantics of this object are determined by\nthe routing-protocol specified in  the  route's\nipv6RouteProtocol value.   When  this object is\nunknown or not relevant its value should be set\nto zero.")
ipv6RouteMetric = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 11, 1, 11), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6RouteMetric.setDescription("The routing metric for this route. The\nsemantics of this metric are determined by the\nrouting protocol specified in the route's\nipv6RouteProtocol value.  When this is unknown\nor not relevant to the protocol indicated by\nipv6RouteProtocol, the object value should be\nset to its maximum value (4,294,967,295).")
ipv6RouteWeight = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 11, 1, 12), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6RouteWeight.setDescription("The system internal weight value for this route.\nThe semantics of this value are determined by\nthe implementation specific rules. Generally,\nwithin routes with the same ipv6RoutePolicy value,\nthe lower the weight value the more preferred is\nthe route.")
ipv6RouteInfo = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 11, 1, 13), RowPointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6RouteInfo.setDescription("A reference to MIB definitions specific to the\nparticular routing protocol which is responsible\nfor this route, as determined by the  value\nspecified  in the route's ipv6RouteProto value.\nIf this information is not present,  its  value\nshould be set to the OBJECT ID { 0 0 },\nwhich is a syntactically valid object  identifier,\nand any implementation conforming to ASN.1\nand the Basic Encoding Rules must  be  able  to\ngenerate and recognize this value.")
ipv6RouteValid = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 11, 1, 14), TruthValue().clone('true')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6RouteValid.setDescription("Setting this object to the value 'false(2)' has\nthe effect of invalidating the corresponding entry\nin the ipv6RouteTable object.  That is, it\neffectively disassociates the destination\nidentified with said entry from the route\nidentified with said entry.  It is an\nimplementation-specific matter as to whether the\nagent removes an invalidated entry from the table.\nAccordingly, management stations must be prepared\nto receive tabular information from agents that\ncorresponds to entries not currently in use.\nProper interpretation of such entries requires\nexamination of the relevant ipv6RouteValid\nobject.")
ipv6NetToMediaTable = MibTable((1, 3, 6, 1, 2, 1, 55, 1, 12))
if mibBuilder.loadTexts: ipv6NetToMediaTable.setDescription("The IPv6 Address Translation table used for\nmapping from IPv6 addresses to physical addresses.\n\nThe IPv6 address translation table contain the\nIpv6Address to `physical' address equivalencies.\nSome interfaces do not use translation tables\nfor determining address equivalencies; if all\ninterfaces are of this type, then the Address\nTranslation table is empty, i.e., has zero\nentries.")
ipv6NetToMediaEntry = MibTableRow((1, 3, 6, 1, 2, 1, 55, 1, 12, 1)).setIndexNames((0, "IPV6-MIB", "ipv6IfIndex"), (0, "IPV6-MIB", "ipv6NetToMediaNetAddress"))
if mibBuilder.loadTexts: ipv6NetToMediaEntry.setDescription("Each entry contains one IPv6 address to `physical'\naddress equivalence.")
ipv6NetToMediaNetAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 12, 1, 1), Ipv6Address()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipv6NetToMediaNetAddress.setDescription("The IPv6 Address corresponding to\nthe media-dependent `physical' address.")
ipv6NetToMediaPhysAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 12, 1, 2), PhysAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6NetToMediaPhysAddress.setDescription("The media-dependent `physical' address.")
ipv6NetToMediaType = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 12, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(4,3,1,2,)).subtype(namedValues=NamedValues(("other", 1), ("dynamic", 2), ("static", 3), ("local", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6NetToMediaType.setDescription("The type of the mapping. The 'dynamic(2)' type\nindicates that the IPv6 address to physical\naddresses mapping has been dynamically\nresolved using the IPv6 Neighbor Discovery\nprotocol. The static(3)' types indicates that\nthe mapping has been statically configured.\nThe local(4) indicates that the mapping is\nprovided for an entity's own interface address.")
ipv6IfNetToMediaState = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 12, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(6,4,5,3,1,2,)).subtype(namedValues=NamedValues(("reachable", 1), ("stale", 2), ("delay", 3), ("probe", 4), ("invalid", 5), ("unknown", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfNetToMediaState.setDescription("The Neighbor Unreachability Detection [8] state\nfor the interface when the address mapping in\nthis entry is used.")
ipv6IfNetToMediaLastUpdated = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 12, 1, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6IfNetToMediaLastUpdated.setDescription("The value of sysUpTime at the time this entry\nwas last updated.  If this entry was updated prior\nto the last re-initialization of the local network\nmanagement subsystem, then this object contains\na zero value.")
ipv6NetToMediaValid = MibTableColumn((1, 3, 6, 1, 2, 1, 55, 1, 12, 1, 6), TruthValue().clone('true')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6NetToMediaValid.setDescription("Setting this object to the value 'false(2)' has\nthe effect of invalidating the corresponding entry\nin the ipv6NetToMediaTable.  That is, it effectively\ndisassociates the interface identified with said\nentry from the mapping identified with said entry.\nIt is an implementation-specific matter as to\nwhether the agent removes an invalidated entry\nfrom the table.  Accordingly, management stations\nmust be prepared to receive tabular information\nfrom agents that corresponds to entries not\ncurrently in use.  Proper interpretation of such\nentries requires examination of the relevant\nipv6NetToMediaValid object.")
ipv6Notifications = MibIdentifier((1, 3, 6, 1, 2, 1, 55, 2))
ipv6NotificationPrefix = MibIdentifier((1, 3, 6, 1, 2, 1, 55, 2, 0))
ipv6Conformance = MibIdentifier((1, 3, 6, 1, 2, 1, 55, 3))
ipv6Compliances = MibIdentifier((1, 3, 6, 1, 2, 1, 55, 3, 1))
ipv6Groups = MibIdentifier((1, 3, 6, 1, 2, 1, 55, 3, 2))

# Augmentions
ipv6IfEntry.registerAugmentions(("IPV6-MIB", "ipv6IfStatsEntry"))
ipv6IfStatsEntry.setIndexNames(*ipv6IfEntry.getIndexNames())

# Notifications

ipv6IfStateChange = NotificationType((1, 3, 6, 1, 2, 1, 55, 2, 0, 1)).setObjects(*(("IPV6-MIB", "ipv6IfOperStatus"), ("IPV6-MIB", "ipv6IfDescr"), ) )
if mibBuilder.loadTexts: ipv6IfStateChange.setDescription("An ipv6IfStateChange notification signifies\nthat there has been a change in the state of\nan ipv6 interface.  This notification should\nbe generated when the interface's operational\nstatus transitions to or from the up(1) state.")

# Groups

ipv6GeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 55, 3, 2, 1)).setObjects(*(("IPV6-MIB", "ipv6Forwarding"), ("IPV6-MIB", "ipv6IfStatsReasmFails"), ("IPV6-MIB", "ipv6IfStatsInNoRoutes"), ("IPV6-MIB", "ipv6IfIdentifierLength"), ("IPV6-MIB", "ipv6IfStatsInMcastPkts"), ("IPV6-MIB", "ipv6NetToMediaType"), ("IPV6-MIB", "ipv6AddrAnycastFlag"), ("IPV6-MIB", "ipv6IfStatsInTruncatedPkts"), ("IPV6-MIB", "ipv6IfStatsOutForwDatagrams"), ("IPV6-MIB", "ipv6NetToMediaPhysAddress"), ("IPV6-MIB", "ipv6RouteType"), ("IPV6-MIB", "ipv6AddrStatus"), ("IPV6-MIB", "ipv6IfStatsInHdrErrors"), ("IPV6-MIB", "ipv6IfStatsOutFragOKs"), ("IPV6-MIB", "ipv6IfStatsOutFragFails"), ("IPV6-MIB", "ipv6RouteAge"), ("IPV6-MIB", "ipv6RouteNumber"), ("IPV6-MIB", "ipv6IfEffectiveMtu"), ("IPV6-MIB", "ipv6RouteWeight"), ("IPV6-MIB", "ipv6IfNetToMediaState"), ("IPV6-MIB", "ipv6IfStatsInUnknownProtos"), ("IPV6-MIB", "ipv6IfStatsOutMcastPkts"), ("IPV6-MIB", "ipv6IfOperStatus"), ("IPV6-MIB", "ipv6IfStatsReasmReqds"), ("IPV6-MIB", "ipv6IfStatsOutRequests"), ("IPV6-MIB", "ipv6AddrPrefixAdvPreferredLifetime"), ("IPV6-MIB", "ipv6IfPhysicalAddress"), ("IPV6-MIB", "ipv6AddrPrefixOnLinkFlag"), ("IPV6-MIB", "ipv6IfTableLastChange"), ("IPV6-MIB", "ipv6IfAdminStatus"), ("IPV6-MIB", "ipv6NetToMediaValid"), ("IPV6-MIB", "ipv6IfStatsInDelivers"), ("IPV6-MIB", "ipv6IfStatsOutDiscards"), ("IPV6-MIB", "ipv6IfReasmMaxSize"), ("IPV6-MIB", "ipv6IfLowerLayer"), ("IPV6-MIB", "ipv6IfStatsInReceives"), ("IPV6-MIB", "ipv6IfStatsOutFragCreates"), ("IPV6-MIB", "ipv6RouteNextHop"), ("IPV6-MIB", "ipv6IfStatsInAddrErrors"), ("IPV6-MIB", "ipv6RouteValid"), ("IPV6-MIB", "ipv6RoutePolicy"), ("IPV6-MIB", "ipv6AddrPfxLength"), ("IPV6-MIB", "ipv6DefaultHopLimit"), ("IPV6-MIB", "ipv6AddrPrefixAutonomousFlag"), ("IPV6-MIB", "ipv6DiscardedRoutes"), ("IPV6-MIB", "ipv6RouteMetric"), ("IPV6-MIB", "ipv6IfStatsReasmOKs"), ("IPV6-MIB", "ipv6IfLastChange"), ("IPV6-MIB", "ipv6Interfaces"), ("IPV6-MIB", "ipv6AddrPrefixAdvValidLifetime"), ("IPV6-MIB", "ipv6RouteInfo"), ("IPV6-MIB", "ipv6RouteIfIndex"), ("IPV6-MIB", "ipv6IfDescr"), ("IPV6-MIB", "ipv6RouteProtocol"), ("IPV6-MIB", "ipv6IfStatsInDiscards"), ("IPV6-MIB", "ipv6IfIdentifier"), ("IPV6-MIB", "ipv6RouteNextHopRDI"), ("IPV6-MIB", "ipv6AddrType"), ("IPV6-MIB", "ipv6IfNetToMediaLastUpdated"), ("IPV6-MIB", "ipv6IfStatsInTooBigErrors"), ) )
if mibBuilder.loadTexts: ipv6GeneralGroup.setDescription("The IPv6 group of objects providing for basic\nmanagement of IPv6 entities.")
ipv6NotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 55, 3, 2, 2)).setObjects(*(("IPV6-MIB", "ipv6IfStateChange"), ) )
if mibBuilder.loadTexts: ipv6NotificationGroup.setDescription("The notification that an IPv6 entity is required\nto implement.")

# Compliances

ipv6Compliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 55, 3, 1, 1)).setObjects(*(("IPV6-MIB", "ipv6GeneralGroup"), ("IPV6-MIB", "ipv6NotificationGroup"), ) )
if mibBuilder.loadTexts: ipv6Compliance.setDescription("The compliance statement for SNMPv2 entities which\nimplement ipv6 MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("IPV6-MIB", PYSNMP_MODULE_ID=ipv6MIB)

# Objects
mibBuilder.exportSymbols("IPV6-MIB", ipv6MIB=ipv6MIB, ipv6MIBObjects=ipv6MIBObjects, ipv6Forwarding=ipv6Forwarding, ipv6DefaultHopLimit=ipv6DefaultHopLimit, ipv6Interfaces=ipv6Interfaces, ipv6IfTableLastChange=ipv6IfTableLastChange, ipv6IfTable=ipv6IfTable, ipv6IfEntry=ipv6IfEntry, ipv6IfIndex=ipv6IfIndex, ipv6IfDescr=ipv6IfDescr, ipv6IfLowerLayer=ipv6IfLowerLayer, ipv6IfEffectiveMtu=ipv6IfEffectiveMtu, ipv6IfReasmMaxSize=ipv6IfReasmMaxSize, ipv6IfIdentifier=ipv6IfIdentifier, ipv6IfIdentifierLength=ipv6IfIdentifierLength, ipv6IfPhysicalAddress=ipv6IfPhysicalAddress, ipv6IfAdminStatus=ipv6IfAdminStatus, ipv6IfOperStatus=ipv6IfOperStatus, ipv6IfLastChange=ipv6IfLastChange, ipv6IfStatsTable=ipv6IfStatsTable, ipv6IfStatsEntry=ipv6IfStatsEntry, ipv6IfStatsInReceives=ipv6IfStatsInReceives, ipv6IfStatsInHdrErrors=ipv6IfStatsInHdrErrors, ipv6IfStatsInTooBigErrors=ipv6IfStatsInTooBigErrors, ipv6IfStatsInNoRoutes=ipv6IfStatsInNoRoutes, ipv6IfStatsInAddrErrors=ipv6IfStatsInAddrErrors, ipv6IfStatsInUnknownProtos=ipv6IfStatsInUnknownProtos, ipv6IfStatsInTruncatedPkts=ipv6IfStatsInTruncatedPkts, ipv6IfStatsInDiscards=ipv6IfStatsInDiscards, ipv6IfStatsInDelivers=ipv6IfStatsInDelivers, ipv6IfStatsOutForwDatagrams=ipv6IfStatsOutForwDatagrams, ipv6IfStatsOutRequests=ipv6IfStatsOutRequests, ipv6IfStatsOutDiscards=ipv6IfStatsOutDiscards, ipv6IfStatsOutFragOKs=ipv6IfStatsOutFragOKs, ipv6IfStatsOutFragFails=ipv6IfStatsOutFragFails, ipv6IfStatsOutFragCreates=ipv6IfStatsOutFragCreates, ipv6IfStatsReasmReqds=ipv6IfStatsReasmReqds, ipv6IfStatsReasmOKs=ipv6IfStatsReasmOKs, ipv6IfStatsReasmFails=ipv6IfStatsReasmFails, ipv6IfStatsInMcastPkts=ipv6IfStatsInMcastPkts, ipv6IfStatsOutMcastPkts=ipv6IfStatsOutMcastPkts, ipv6AddrPrefixTable=ipv6AddrPrefixTable, ipv6AddrPrefixEntry=ipv6AddrPrefixEntry, ipv6AddrPrefix=ipv6AddrPrefix, ipv6AddrPrefixLength=ipv6AddrPrefixLength, ipv6AddrPrefixOnLinkFlag=ipv6AddrPrefixOnLinkFlag, ipv6AddrPrefixAutonomousFlag=ipv6AddrPrefixAutonomousFlag, ipv6AddrPrefixAdvPreferredLifetime=ipv6AddrPrefixAdvPreferredLifetime, ipv6AddrPrefixAdvValidLifetime=ipv6AddrPrefixAdvValidLifetime, ipv6AddrTable=ipv6AddrTable, ipv6AddrEntry=ipv6AddrEntry, ipv6AddrAddress=ipv6AddrAddress, ipv6AddrPfxLength=ipv6AddrPfxLength, ipv6AddrType=ipv6AddrType, ipv6AddrAnycastFlag=ipv6AddrAnycastFlag, ipv6AddrStatus=ipv6AddrStatus, ipv6RouteNumber=ipv6RouteNumber, ipv6DiscardedRoutes=ipv6DiscardedRoutes, ipv6RouteTable=ipv6RouteTable, ipv6RouteEntry=ipv6RouteEntry, ipv6RouteDest=ipv6RouteDest, ipv6RoutePfxLength=ipv6RoutePfxLength, ipv6RouteIndex=ipv6RouteIndex, ipv6RouteIfIndex=ipv6RouteIfIndex, ipv6RouteNextHop=ipv6RouteNextHop, ipv6RouteType=ipv6RouteType, ipv6RouteProtocol=ipv6RouteProtocol, ipv6RoutePolicy=ipv6RoutePolicy, ipv6RouteAge=ipv6RouteAge, ipv6RouteNextHopRDI=ipv6RouteNextHopRDI, ipv6RouteMetric=ipv6RouteMetric, ipv6RouteWeight=ipv6RouteWeight, ipv6RouteInfo=ipv6RouteInfo, ipv6RouteValid=ipv6RouteValid, ipv6NetToMediaTable=ipv6NetToMediaTable, ipv6NetToMediaEntry=ipv6NetToMediaEntry, ipv6NetToMediaNetAddress=ipv6NetToMediaNetAddress, ipv6NetToMediaPhysAddress=ipv6NetToMediaPhysAddress, ipv6NetToMediaType=ipv6NetToMediaType, ipv6IfNetToMediaState=ipv6IfNetToMediaState, ipv6IfNetToMediaLastUpdated=ipv6IfNetToMediaLastUpdated, ipv6NetToMediaValid=ipv6NetToMediaValid, ipv6Notifications=ipv6Notifications, ipv6NotificationPrefix=ipv6NotificationPrefix, ipv6Conformance=ipv6Conformance, ipv6Compliances=ipv6Compliances, ipv6Groups=ipv6Groups)

# Notifications
mibBuilder.exportSymbols("IPV6-MIB", ipv6IfStateChange=ipv6IfStateChange)

# Groups
mibBuilder.exportSymbols("IPV6-MIB", ipv6GeneralGroup=ipv6GeneralGroup, ipv6NotificationGroup=ipv6NotificationGroup)

# Compliances
mibBuilder.exportSymbols("IPV6-MIB", ipv6Compliance=ipv6Compliance)