# opan (Open Anharmonic)


Open Anharmonic is a Python wrapper for computational chemistry
  software packages intended to enable VPT2 computation of anharmonic
  vibrational constants. Note that no VPT2 capabilities are 
  implemented as of yet.

Other types of calculations are under consideration.

An adjunct goal of the project is to expose an API providing
  convenient access to various results of standalone calculations, as well
  as tools to manipulate those results.

Any branches with a prefixed `v.` are volatile (under active
  development). The history there may be rewritten dramatically, 
  without warning.

Starting with v0.4, this project strives to follow [Semantic Versioning v2.0.0](http://semver.org/spec/v2.0.0.html)
  and [PEP 440](https://www.python.org/dev/peps/pep-0440), with PEP 440 taking priority.  Thus, 
  per PEP 440, some elements of
  SemVer v2.0.0 may not be reflected in the official version numbers of the project.

Documentation can be found at [Read the Docs](https://www.readthedocs.org): [![Documentation Status](https://readthedocs.org/projects/opan/badge/?version=latest)](http://opan.readthedocs.org/en/latest/?badge=latest)

[QuantifiedCode](https://www.quantifiedcode.com) project analysis of `dev` branch: [![Code Issues](https://www.quantifiedcode.com/api/v1/project/db4810dd64384181b085fdd03d951f9b/badge.svg)](https://www.quantifiedcode.com/app/project/db4810dd64384181b085fdd03d951f9b)
