#!/usr/bin/env python
# -*- coding: utf-8 -*-
# pragma: no cover

################################################################################
"""
Globals to use in tests.


Lot of files generated by the collective.generic packages  will try to load user defined objects in user specific files.
The final goal is to regenerate easyly the test infrastructure on templates updates without impacting
user-specific test boilerplate.
We do not use paster local commands (insert/update) as it cannot determine witch is specific or not and we prefer to totally
separe generated stuff and what is user specific



If you need to edit something in this file, you must have better to do it in:


    - user_globals.py

All from there will be imported in this namespace

"""
################################################################################

import ConfigParser
import os
import re
import sys
from copy import deepcopy
from pprint import pprint
cwd = os.path.dirname(__file__)
import zope
from zope.interface.verify import verifyObject

from zope import interface, schema
from zope.component import adapts, getMultiAdapter, getAdapter, getAdapters
def get_interfaces(o): # pragma: no cover
    return [o for o in o.__provides__.interfaces()]

from zope.interface import implementedBy, providedBy

# used on testing
# copied from ZopeLite Class from zope.testingZope.TestCase
# but we can't import it
# if we do we polluate our os.environment and ZopeTestcase usecase detction
def errprint(msg): # pragma: no cover
    """Writes 'msg' to stderr and flushes the stream."""
    sys.stderr.write(msg)
    sys.stderr.flush()

def pstriplist(s): # pragma: no cover
    print '\n'.join([a.rstrip() for a in s.split('\n') if a.strip()])

from zope.traversing.adapters import DefaultTraversable
zope.component.provideAdapter(DefaultTraversable, [None])
class Request(zope.publisher.browser.TestRequest): # pragma: no cover
    def __setitem__(self, name, value):
        self._environ[name] = value
# alias
TestRequest = Request
def make_request(url='http://nohost/@@myview',form=None, *args,  **kwargs): # pragma: no cover
    r = Request(environ = {'SERVER_URL': url, 'ACTUAL_URL': url}, form=form, *args, **kwargs)
    zope.interface.alsoProvides(r, zope.annotation.interfaces.IAttributeAnnotatable)
    return r

from collective.cron.testing import (
    Browser,
    PLONE_MANAGER_ID,
    PLONE_MANAGER_NAME,
    PLONE_MANAGER_PASSWORD,
    SITE_OWNER_NAME,
    SITE_OWNER_PASSWORD,
    TEST_USER_ID,
    TEST_USER_NAME,
    TEST_USER_ROLES,
)                      
