# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .control_activity import ControlActivity


class UntilActivity(ControlActivity):
    """This activity executes inner activities until the specified boolean
    expression results to true or timeout is reached, whichever is earlier.

    :param name: Activity name.
    :type name: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list of :class:`ActivityDependency
     <azure.mgmt.datafactory.models.ActivityDependency>`
    :param type: Polymorphic Discriminator
    :type type: str
    :param expression: An expression that would evaluate to Boolean. The loop
     will continue until this expression evaluates to true
    :type expression: :class:`Expression
     <azure.mgmt.datafactory.models.Expression>`
    :param timeout: Specifies the timeout for the activity to run. If there is
     no value specified, it takes the value of TimeSpan.FromDays(7) which is 1
     week as default. Type: string (or Expression with resultType string),
     pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])). Type:
     string (or Expression with resultType string), pattern:
     ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type timeout: object
    :param activities: List of activities to execute.
    :type activities: list of :class:`Activity
     <azure.mgmt.datafactory.models.Activity>`
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'expression': {'required': True},
        'activities': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'type': {'key': 'type', 'type': 'str'},
        'expression': {'key': 'typeProperties.expression', 'type': 'Expression'},
        'timeout': {'key': 'typeProperties.timeout', 'type': 'object'},
        'activities': {'key': 'typeProperties.activities', 'type': '[Activity]'},
    }

    def __init__(self, name, expression, activities, description=None, depends_on=None, timeout=None):
        super(UntilActivity, self).__init__(name=name, description=description, depends_on=depends_on)
        self.expression = expression
        self.timeout = timeout
        self.activities = activities
        self.type = 'Until'
