# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SecureString(Model):
    """Azure Data Factory secure string definition. The string value will be
    masked with asterisks '*' during Get or List API calls.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: SecureString type. Default value: "SecureString" .
    :vartype type: str
    :param value: Value of secure string.
    :type value: str
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    type = "SecureString"

    def __init__(self, value):
        self.value = value
