# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CdnCertificateSourceParameters(Model):
    """Defines the parameters for using CDN managed certificate for securing
    custom domain.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.CdnCertificateSourceParameters" .
    :vartype odatatype: str
    :param certificate_type: Required. Type of certificate used. Possible
     values include: 'Shared', 'Dedicated'
    :type certificate_type: str or ~azure.mgmt.cdn.models.CertificateType
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'certificate_type': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'certificate_type': {'key': 'certificateType', 'type': 'str'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.CdnCertificateSourceParameters"

    def __init__(self, *, certificate_type, **kwargs) -> None:
        super(CdnCertificateSourceParameters, self).__init__(**kwargs)
        self.certificate_type = certificate_type
