
class ActType:
    obj_list =[]

    def __init__(self, params):
        # Unique ID generated by the system.
        self.actv_code_type_id = int(params.get('actv_code_type_id').strip()) if params.get('actv_code_type_id') else None
        # The maximum number of characters allowed for values of this Activity Code.
        self.actv_short_len = float(params.get('actv_short_len').strip()) if params.get('actv_short_len') else None
        # Sequence number for sorting.
        self.seq_num = int(params.get('seq_num').strip()) if params.get('seq_num') else None
        # Each Activity Code has a list of possible values, any of which can be assigned to an activity. Activity
        # Codes allow you to classify and categorize activities.
        self.actv_code_type = params.get('actv_code_type').strip() if params.get('actv_code_type') else None
        # Identifies the project which owns this Activity Code (if this is a project-level Activity Code).
        self.proj_id = int(params.get('proj_id')) if params.get('proj_id') else None
        # EPS Id element that
        self.wbs_id = params.get('wbs_id').strip() if params.get('wbs_id') else None
        self.actv_code_type_scope = params.get('actv_code_type_scope').strip() if params.get('actv_code_type_scope') else None
        ActType.obj_list.append(self)

    def get_id(self):
        return self.actv_code_type_id

    @classmethod
    def find_by_id(cls, id):
        """ Function to search list of activity code type by an ID

        Args:
            id: Unique ID generated by the system.

        Returns: ActType that matches the ID

        """
        obj = list(filter(lambda x: x.actv_code_type_id == id, cls.obj_list))
        if len(obj) > 0:
            return obj[0]
        else:
            obj = None
        return obj


    def __repr__(self):
        return self.actv_code_type

