/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.resourcemanager.nodesource.common;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.resourcemanager.exception.RMException;
import org.ow2.proactive.resourcemanager.nodesource.common.Configurable;
import org.ow2.proactive.resourcemanager.nodesource.common.ConfigurableField;
import org.ow2.proactive.utils.FileToBytesConverter;

@PublicAPI
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="pluginDescriptor")
public class PluginDescriptor
implements Serializable {
    @XmlTransient
    private static final Logger logger = Logger.getLogger(PluginDescriptor.class);
    private String pluginName;
    private String pluginDescription;
    private Collection<ConfigurableField> configurableFields = new LinkedList<ConfigurableField>();
    private Map<String, String> defaultValues;
    private Map<Integer, String> sectionDescriptions = new HashMap<Integer, String>();
    private Map<String, String> meta = new HashMap<String, String>();
    private static final long serialVersionUID = 131L;

    public PluginDescriptor() {
    }

    public PluginDescriptor(Class<?> cls, Object instance, Map<String, String> defaultValues) {
        try {
            this.pluginName = cls.getName();
            this.defaultValues = defaultValues;
            this.findSectionDescriptions(cls, instance);
            this.findConfigurableFileds(cls, instance);
            this.findMeta(cls, instance);
            Method getDescription = cls.getMethod("getDescription", new Class[0]);
            if (getDescription != null) {
                this.pluginDescription = (String)getDescription.invoke(instance, new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error when reading configurable fields", (Throwable)e);
        }
    }

    public PluginDescriptor(Class<?> cls, Object instance, Object[] parameters) {
        this(cls, instance, new HashMap<String, String>());
        this.validateParametersOrFail(cls, parameters);
        int fieldIndex = 0;
        for (ConfigurableField field : this.configurableFields) {
            Object parameterObject = parameters[fieldIndex++];
            this.setFieldToStringValueOf(field, parameterObject);
        }
    }

    private void validateParametersOrFail(Class<?> cls, Object[] parameters) {
        if (parameters == null || this.configurableFields.size() > parameters.length) {
            throw new IllegalArgumentException("There are not enough parameters to populate the plugin descriptor of " + cls.getSimpleName());
        }
    }

    private void setFieldToStringValueOf(ConfigurableField field, Object parameterObject) {
        if (parameterObject instanceof byte[]) {
            field.setValue(new String((byte[])parameterObject));
        } else {
            field.setValue(String.valueOf(parameterObject));
        }
    }

    private void findSectionDescriptions(Class<?> cls, Object instance) {
        try {
            Method getSectionDescriptions = cls.getMethod("getSectionDescriptions", new Class[0]);
            Map sectionDescriptions = (Map)getSectionDescriptions.invoke(instance, new Object[0]);
            this.sectionDescriptions.putAll(sectionDescriptions);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.debug((Object)"Could not load `getSectionDescriptions`.", (Throwable)e);
        }
    }

    private void findMeta(Class<?> cls, Object instance) {
        try {
            Method getMetaMethod = cls.getMethod("getMeta", new Class[0]);
            Map metaInfo = (Map)getMetaMethod.invoke(instance, new Object[0]);
            this.meta.putAll(metaInfo);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.debug((Object)"Could not load `getMeta`.", (Throwable)e);
        }
    }

    private void findConfigurableFileds(Class<?> cls, Object instance) {
        if (cls.getSuperclass() != null && cls.getSuperclass() != Object.class) {
            this.findConfigurableFileds(cls.getSuperclass(), instance);
        }
        for (Field f : cls.getDeclaredFields()) {
            Configurable configurable = f.getAnnotation(Configurable.class);
            if (configurable == null) continue;
            String name = f.getName();
            f.setAccessible(true);
            Object valueObj = null;
            try {
                valueObj = f.get(instance);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String value = valueObj == null ? (this.defaultValues.get(name) != null ? this.defaultValues.get(name) : "") : valueObj.toString();
            this.configurableFields.add(new ConfigurableField(name, value, configurable));
        }
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getPluginDescription() {
        return this.pluginDescription;
    }

    public Collection<ConfigurableField> getConfigurableFields() {
        return this.configurableFields;
    }

    public Map<String, String> getDefaultValues() {
        return this.defaultValues;
    }

    public Map<Integer, String> getSectionDescriptions() {
        return this.sectionDescriptions;
    }

    public Object[] packParameters(Object[] parameters) throws RMException {
        int configurableFieldsSize = this.configurableFields.size();
        ArrayList<Object> resultParams = new ArrayList<Object>(configurableFieldsSize);
        if (parameters.length != configurableFieldsSize) {
            throw new RMException("Incorrect number of parameters: expected " + configurableFieldsSize + ", provided " + parameters.length);
        }
        int counter = 0;
        for (ConfigurableField field : this.configurableFields) {
            boolean credentialsFilePath;
            Object value = parameters[counter++];
            Configurable configurable = field.getMeta();
            boolean bl = credentialsFilePath = configurable.credential() && value instanceof String;
            if (configurable.fileBrowser() || credentialsFilePath) {
                try {
                    value = value.toString().length() > 0 ? (Object)FileToBytesConverter.convertFileToByteArray((File)new File(value.toString())) : null;
                }
                catch (IOException e) {
                    throw new RMException("Cannot load file", e);
                }
            }
            resultParams.add(value);
        }
        return resultParams.toArray();
    }

    public static String beautifyName(String name) {
        StringBuffer buffer = new StringBuffer();
        if (name.contains(".")) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (i == 0) {
                buffer.append(Character.toUpperCase(ch));
                continue;
            }
            if (i > 0 && (Character.isUpperCase(ch) || Character.isDigit(ch))) {
                boolean nextCharInAupperCase;
                boolean bl = nextCharInAupperCase = i < name.length() - 1 && (Character.isUpperCase(name.charAt(i + 1)) || Character.isDigit(name.charAt(i + 1)));
                if (!nextCharInAupperCase) {
                    buffer.append(" " + ch);
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public String toString() {
        String result = "Name: " + PluginDescriptor.beautifyName(this.pluginName) + "\n";
        result = result + "Description: " + this.pluginDescription + "\n";
        result = result + "Class name: " + this.pluginName + "\n";
        if (this.configurableFields.size() > 0) {
            String params = "";
            for (ConfigurableField field : this.configurableFields) {
                params = params + field.getName();
                if (!field.getValue().equals("")) {
                    params = params + "[" + field.getValue() + "]";
                }
                params = params + " ";
            }
            result = result + "Parameters: <class name> " + params + "\n";
        }
        return result;
    }

    public Map<String, String> getMeta() {
        return this.meta;
    }
}

