/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive_grid_cloud_portal.common;

import java.io.IOException;
import java.security.KeyException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.security.auth.login.LoginException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jboss.resteasy.annotations.GZIP;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.ow2.proactive.authentication.UserData;
import org.ow2.proactive.resourcemanager.common.NSState;
import org.ow2.proactive.resourcemanager.common.RMState;
import org.ow2.proactive.resourcemanager.common.RMStatistics;
import org.ow2.proactive.resourcemanager.common.event.RMNodeHistory;
import org.ow2.proactive.resourcemanager.common.event.RMNodeSourceEvent;
import org.ow2.proactive.resourcemanager.common.event.dto.RMStateDelta;
import org.ow2.proactive.resourcemanager.common.event.dto.RMStateFull;
import org.ow2.proactive.resourcemanager.exception.RMActiveObjectCreationException;
import org.ow2.proactive.resourcemanager.exception.RMException;
import org.ow2.proactive.resourcemanager.exception.RMNodeException;
import org.ow2.proactive.resourcemanager.frontend.PluginDescriptorData;
import org.ow2.proactive.resourcemanager.frontend.topology.TopologyData;
import org.ow2.proactive.resourcemanager.nodesource.common.NodeSourceConfiguration;
import org.ow2.proactive.scheduler.common.exception.NotConnectedException;
import org.ow2.proactive.scripting.ScriptResult;
import org.ow2.proactive_grid_cloud_portal.common.dto.LoginForm;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.PermissionRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.RestException;

@Path(value="/rm")
public interface RMRestInterface {
    @GET
    @Path(value="url")
    @Produces(value={"text/plain"})
    public String getUrl();

    @GET
    @Path(value="domains")
    @Produces(value={"application/json"})
    public List<String> getDomains();

    @POST
    @Path(value="login")
    @Produces(value={"text/plain", "application/json"})
    public String rmConnect(@FormParam(value="username") String var1, @FormParam(value="password") String var2) throws KeyException, LoginException, RMException, RMActiveObjectCreationException, RMNodeException;

    @POST
    @Path(value="disconnect")
    @Produces(value={"application/json"})
    public void rmDisconnect(@HeaderParam(value="sessionid") String var1) throws NotConnectedException;

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="login")
    @Produces(value={"text/plain", "application/json"})
    public String loginWithCredential(@MultipartForm LoginForm var1) throws RMActiveObjectCreationException, RMNodeException, KeyException, IOException, LoginException, RMException;

    @GET
    @Path(value="logins/sessionid/{sessionId}")
    @Produces(value={"text/plain"})
    public String getLoginFromSessionId(@PathParam(value="sessionId") String var1);

    @GET
    @Path(value="logins/sessionid/{sessionId}/userdata")
    @Produces(value={"application/json"})
    public UserData getUserDataFromSessionId(@PathParam(value="sessionId") String var1);

    @GET
    @Path(value="statistics")
    @Produces(value={"application/json"})
    public RMStatistics getStatistics(@HeaderParam(value="sessionid") String var1) throws NotConnectedException;

    @GET
    @Path(value="state")
    @Produces(value={"application/json"})
    public RMState getState(@HeaderParam(value="sessionid") String var1) throws NotConnectedException;

    @GET
    @GZIP
    @Path(value="monitoring")
    @Produces(value={"application/json"})
    public RMStateDelta getRMStateDelta(@HeaderParam(value="sessionid") String var1, @HeaderParam(value="clientCounter") @DefaultValue(value="-1") String var2) throws NotConnectedException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="monitoring/full")
    @Produces(value={"application/json"})
    public RMStateFull getRMStateFull(@HeaderParam(value="sessionid") String var1) throws NotConnectedException, PermissionRestException;

    @GET
    @Path(value="model/hosts")
    @Produces(value={"text/plain", "application/json"})
    public String getModelHosts(@QueryParam(value="name") String var1) throws PermissionRestException;

    @GET
    @Path(value="model/nodesources")
    @Produces(value={"text/plain", "application/json"})
    public String getModelNodeSources(@QueryParam(value="name") String var1, @QueryParam(value="infrastructure") String var2, @QueryParam(value="policy") String var3, @QueryParam(value="noDefault") String var4) throws PermissionRestException;

    @GET
    @Path(value="model/tokens")
    @Produces(value={"text/plain", "application/json"})
    public String getModelTokens(@QueryParam(value="name") String var1, @QueryParam(value="nodeSource") String var2) throws PermissionRestException;

    @GET
    @Path(value="isactive")
    @Produces(value={"application/json"})
    public boolean isActive(@HeaderParam(value="sessionid") String var1) throws NotConnectedException;

    @POST
    @Path(value="node")
    @Produces(value={"application/json"})
    public boolean addNode(@HeaderParam(value="sessionid") String var1, @FormParam(value="nodeurl") String var2, @FormParam(value="nodesource") String var3) throws NotConnectedException;

    @GET
    @Path(value="node/isavailable")
    @Produces(value={"application/json"})
    public boolean nodeIsAvailable(@HeaderParam(value="sessionid") String var1, @QueryParam(value="nodeurl") String var2) throws NotConnectedException;

    @GET
    @GZIP
    @Path(value="nodesource")
    @Produces(value={"application/json"})
    public List<RMNodeSourceEvent> getExistingNodeSources(@HeaderParam(value="sessionid") String var1) throws NotConnectedException, PermissionRestException;

    @POST
    @Path(value="nodesource")
    @Produces(value={"application/json"})
    public NSState defineNodeSource(@HeaderParam(value="sessionid") String var1, @FormParam(value="nodeSourceName") String var2, @FormParam(value="infrastructureType") String var3, @FormParam(value="infrastructureParameters") String[] var4, @FormParam(value="infrastructureFileParameters") String[] var5, @FormParam(value="policyType") String var6, @FormParam(value="policyParameters") String[] var7, @FormParam(value="policyFileParameters") String[] var8, @FormParam(value="nodesRecoverable") String var9) throws NotConnectedException;

    @PUT
    @Path(value="nodesource/edit")
    @Produces(value={"application/json"})
    public NSState editNodeSource(@HeaderParam(value="sessionid") String var1, @FormParam(value="nodeSourceName") String var2, @FormParam(value="infrastructureType") String var3, @FormParam(value="infrastructureParameters") String[] var4, @FormParam(value="infrastructureFileParameters") String[] var5, @FormParam(value="policyType") String var6, @FormParam(value="policyParameters") String[] var7, @FormParam(value="policyFileParameters") String[] var8, @FormParam(value="nodesRecoverable") String var9) throws NotConnectedException;

    @PUT
    @Path(value="nodesource/parameter")
    @Produces(value={"application/json"})
    public NSState updateDynamicParameters(@HeaderParam(value="sessionid") String var1, @FormParam(value="nodeSourceName") String var2, @FormParam(value="infrastructureType") String var3, @FormParam(value="infrastructureParameters") String[] var4, @FormParam(value="infrastructureFileParameters") String[] var5, @FormParam(value="policyType") String var6, @FormParam(value="policyParameters") String[] var7, @FormParam(value="policyFileParameters") String[] var8) throws NotConnectedException, PermissionRestException;

    @Deprecated
    @POST
    @Path(value="nodesource/create")
    @Produces(value={"application/json"})
    public NSState createNodeSource(@HeaderParam(value="sessionid") String var1, @FormParam(value="nodeSourceName") String var2, @FormParam(value="infrastructureType") String var3, @FormParam(value="infrastructureParameters") String[] var4, @FormParam(value="infrastructureFileParameters") String[] var5, @FormParam(value="policyType") String var6, @FormParam(value="policyParameters") String[] var7, @FormParam(value="policyFileParameters") String[] var8) throws NotConnectedException, PermissionRestException;

    @Deprecated
    @POST
    @Path(value="nodesource/create/recovery")
    @Produces(value={"application/json"})
    public NSState createNodeSource(@HeaderParam(value="sessionid") String var1, @FormParam(value="nodeSourceName") String var2, @FormParam(value="infrastructureType") String var3, @FormParam(value="infrastructureParameters") String[] var4, @FormParam(value="infrastructureFileParameters") String[] var5, @FormParam(value="policyType") String var6, @FormParam(value="policyParameters") String[] var7, @FormParam(value="policyFileParameters") String[] var8, @FormParam(value="nodesRecoverable") String var9) throws NotConnectedException;

    @PUT
    @Path(value="nodesource/deploy")
    @Produces(value={"application/json"})
    public NSState deployNodeSource(@HeaderParam(value="sessionid") String var1, @FormParam(value="nodeSourceName") String var2) throws NotConnectedException, PermissionRestException;

    @PUT
    @Path(value="nodesource/undeploy")
    @Produces(value={"application/json"})
    public NSState undeployNodeSource(@HeaderParam(value="sessionid") String var1, @FormParam(value="nodeSourceName") String var2, @FormParam(value="preempt") boolean var3) throws NotConnectedException, PermissionRestException;

    @POST
    @Path(value="nodesource/pingfrequency")
    @Produces(value={"application/json"})
    public int getNodeSourcePingFrequency(@HeaderParam(value="sessionid") String var1, @FormParam(value="sourcename") String var2) throws NotConnectedException, PermissionRestException;

    @POST
    @Path(value="nodesource/{sourcename}/nodes")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Set<String> acquireNodes(@HeaderParam(value="sessionid") String var1, @PathParam(value="sourcename") String var2, @QueryParam(value="numbernodes") int var3, @QueryParam(value="sync") @DefaultValue(value="false") boolean var4, @QueryParam(value="timeout") @DefaultValue(value="600") long var5, String var7) throws NotConnectedException, RestException;

    @POST
    @Path(value="node/release")
    @Produces(value={"application/json"})
    public boolean releaseNode(@HeaderParam(value="sessionid") String var1, @FormParam(value="url") String var2) throws RMNodeException, NotConnectedException, PermissionRestException;

    @POST
    @Path(value="node/remove")
    @Produces(value={"application/json"})
    public boolean removeNode(@HeaderParam(value="sessionid") String var1, @FormParam(value="url") String var2, @FormParam(value="preempt") boolean var3) throws NotConnectedException, PermissionRestException;

    @POST
    @Path(value="nodesource/remove")
    @Produces(value={"application/json"})
    public boolean removeNodeSource(@HeaderParam(value="sessionid") String var1, @FormParam(value="name") String var2, @FormParam(value="preempt") boolean var3) throws NotConnectedException, PermissionRestException;

    @POST
    @Path(value="node/lock")
    @Produces(value={"application/json"})
    public boolean lockNodes(@HeaderParam(value="sessionid") String var1, @FormParam(value="nodeurls") Set<String> var2) throws NotConnectedException, PermissionRestException;

    @POST
    @Path(value="node/unlock")
    @Produces(value={"application/json"})
    public boolean unlockNodes(@HeaderParam(value="sessionid") String var1, @FormParam(value="nodeurls") Set<String> var2) throws NotConnectedException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="node/mbean")
    @Produces(value={"application/json"})
    public Object getNodeMBeanInfo(@HeaderParam(value="sessionid") String var1, @QueryParam(value="nodejmxurl") String var2, @QueryParam(value="objectname") String var3, @QueryParam(value="attrs") List<String> var4) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException, NotConnectedException, MalformedObjectNameException, NullPointerException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="node/mbean/history")
    @Produces(value={"application/json"})
    public String getNodeMBeanHistory(@HeaderParam(value="sessionid") String var1, @QueryParam(value="nodejmxurl") String var2, @QueryParam(value="objectname") String var3, @QueryParam(value="attrs") List<String> var4, @QueryParam(value="range") String var5) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException, NotConnectedException, MalformedObjectNameException, NullPointerException, MBeanException;

    @GET
    @GZIP
    @Path(value="nodes/mbean/history")
    @Produces(value={"application/json"})
    public Map<String, Map<String, Object>> getNodesMBeanHistory(@HeaderParam(value="sessionid") String var1, @QueryParam(value="nodesjmxurl") List<String> var2, @QueryParam(value="objectname") String var3, @QueryParam(value="attrs") List<String> var4, @QueryParam(value="range") String var5) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException, NotConnectedException, MalformedObjectNameException, NullPointerException, MBeanException;

    @GET
    @GZIP
    @Path(value="node/mbeans")
    @Produces(value={"application/json"})
    public Object getNodeMBeansInfo(@HeaderParam(value="sessionid") String var1, @QueryParam(value="nodejmxurl") String var2, @QueryParam(value="objectname") String var3, @QueryParam(value="attrs") List<String> var4) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException, NotConnectedException, MalformedObjectNameException, NullPointerException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="node/mbeans/history")
    @Produces(value={"application/json"})
    public Object getNodeMBeansHistory(@HeaderParam(value="sessionid") String var1, @QueryParam(value="nodejmxurl") String var2, @QueryParam(value="objectname") String var3, @QueryParam(value="attrs") List<String> var4, @QueryParam(value="range") String var5) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException, NotConnectedException, MalformedObjectNameException, NullPointerException, MBeanException, PermissionRestException;

    @GET
    @Path(value="shutdown")
    @Produces(value={"application/json"})
    public boolean shutdown(@HeaderParam(value="sessionid") String var1, @QueryParam(value="preempt") @DefaultValue(value="false") boolean var2) throws NotConnectedException, PermissionRestException;

    @GET
    @Path(value="topology")
    @Produces(value={"application/json"})
    public TopologyData getTopology(@HeaderParam(value="sessionid") String var1) throws NotConnectedException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="infrastructures")
    @Produces(value={"application/json"})
    public Collection<PluginDescriptorData> getSupportedNodeSourceInfrastructures(@HeaderParam(value="sessionid") String var1) throws NotConnectedException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="infrastructures/mapping")
    @Produces(value={"application/json"})
    public Map<String, List<String>> getInfrasToPoliciesMapping(@HeaderParam(value="sessionid") String var1) throws NotConnectedException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="policies")
    @Produces(value={"application/json"})
    public Collection<PluginDescriptorData> getSupportedNodeSourcePolicies(@HeaderParam(value="sessionid") String var1) throws NotConnectedException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="nodesource/configuration")
    @Produces(value={"application/json"})
    public NodeSourceConfiguration getNodeSourceConfiguration(@HeaderParam(value="sessionid") String var1, @QueryParam(value="nodeSourceName") String var2) throws NotConnectedException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="info/{name}")
    @Produces(value={"application/json"})
    public Object getMBeanInfo(@HeaderParam(value="sessionid") String var1, @PathParam(value="name") ObjectName var2, @QueryParam(value="attr") List<String> var3) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException, NotConnectedException, PermissionRestException;

    @POST
    @GZIP
    @Path(value="info/{name}")
    @Produces(value={"application/json"})
    public void setMBeanInfo(@HeaderParam(value="sessionid") String var1, @PathParam(value="name") ObjectName var2, @QueryParam(value="type") String var3, @QueryParam(value="attr") String var4, @QueryParam(value="value") String var5) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException, NotConnectedException, MBeanException, InvalidAttributeValueException, AttributeNotFoundException;

    @GET
    @GZIP
    @Path(value="stathistory")
    @Produces(value={"application/json"})
    public String getStatHistory(@HeaderParam(value="sessionid") String var1, @QueryParam(value="range") String var2, @QueryParam(value="function") String var3) throws ReflectionException, InterruptedException, IntrospectionException, NotConnectedException, InstanceNotFoundException, MalformedObjectNameException, IOException;

    @GET
    @Path(value="version")
    @Produces(value={"text/plain"})
    public String getVersion();

    @POST
    @GZIP
    @Path(value="node/script")
    @Produces(value={"application/json"})
    public ScriptResult<Object> executeNodeScript(@HeaderParam(value="sessionid") String var1, @FormParam(value="nodeurl") String var2, @FormParam(value="script") String var3, @FormParam(value="scriptEngine") String var4) throws Throwable;

    @POST
    @GZIP
    @Path(value="nodesource/script")
    @Produces(value={"application/json"})
    public List<ScriptResult<Object>> executeNodeSourceScript(@HeaderParam(value="sessionid") String var1, @FormParam(value="nodesource") String var2, @FormParam(value="script") String var3, @FormParam(value="scriptEngine") String var4) throws Throwable;

    @POST
    @GZIP
    @Path(value="host/script")
    @Produces(value={"application/json"})
    public ScriptResult<Object> executeHostScript(@HeaderParam(value="sessionid") String var1, @FormParam(value="host") String var2, @FormParam(value="script") String var3, @FormParam(value="scriptEngine") String var4) throws Throwable;

    @GET
    @GZIP
    @Path(value="threaddump")
    @Produces(value={"text/plain", "application/json"})
    public String getRMThreadDump(@HeaderParam(value="sessionid") String var1) throws NotConnectedException;

    @GET
    @GZIP
    @Path(value="node/threaddump")
    @Produces(value={"text/plain", "application/json"})
    public String getNodeThreadDump(@HeaderParam(value="sessionid") String var1, @QueryParam(value="nodeurl") String var2) throws NotConnectedException;

    @GET
    @GZIP
    @Path(value="nodes/history")
    @Produces(value={"application/json"})
    public Map<String, Map<String, Map<String, List<RMNodeHistory>>>> getNodesHistory(@HeaderParam(value="sessionid") String var1, @HeaderParam(value="windowStart") long var2, @HeaderParam(value="windowEnd") long var4) throws NotConnectedException;

    @POST
    @GZIP
    @Path(value="node/token")
    @Produces(value={"application/json"})
    public void addNodeToken(@HeaderParam(value="sessionid") String var1, @HeaderParam(value="nodeurl") String var2, @HeaderParam(value="token") String var3) throws NotConnectedException, RestException;

    @DELETE
    @GZIP
    @Path(value="node/token")
    @Produces(value={"application/json"})
    public void removeNodeToken(@HeaderParam(value="sessionid") String var1, @HeaderParam(value="nodeurl") String var2, @HeaderParam(value="token") String var3) throws NotConnectedException, RestException;

    @POST
    @GZIP
    @Path(value="node/tokens")
    @Produces(value={"application/json"})
    public void setNodeTokens(@HeaderParam(value="sessionid") String var1, @HeaderParam(value="nodeurl") String var2, @QueryParam(value="tokens") List<String> var3) throws NotConnectedException, RestException;

    @GET
    @Path(value="node/tags")
    @Produces(value={"application/json"})
    public Set<String> getNodeTags(@HeaderParam(value="sessionid") String var1) throws NotConnectedException, RestException;

    @GET
    @Path(value="node/tags/search")
    @Produces(value={"application/json"})
    public Set<String> getNodeTags(@HeaderParam(value="sessionid") String var1, @QueryParam(value="nodeurl") String var2) throws NotConnectedException, RestException;

    @GET
    @Path(value="nodes/search")
    @Produces(value={"application/json"})
    public Set<String> searchNodes(@HeaderParam(value="sessionid") String var1, @QueryParam(value="tags") List<String> var2, @QueryParam(value="all") @DefaultValue(value="true") boolean var3) throws NotConnectedException, RestException;

    @POST
    @Path(value="nodes/permission")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public boolean checkNodePermission(@HeaderParam(value="sessionid") String var1, String var2, @QueryParam(value="provider") @DefaultValue(value="false") boolean var3) throws NotConnectedException, PermissionRestException;

    @POST
    @Path(value="nodeSource/permission")
    @Produces(value={"application/json"})
    public boolean checkNodeSourcePermission(@HeaderParam(value="sessionid") String var1, @HeaderParam(value="nodeSourceName") String var2, @QueryParam(value="provider") @DefaultValue(value="false") boolean var3) throws NotConnectedException, PermissionRestException;
}

