<?xml version="1.0" encoding="utf-8"?>
<root xmlns:py="http://purl.org/kid/ns#" py:strip="">
<div py:replace="xml_stylesheet(stylesheet)" py:if="defined('stylesheet')" />
<feed xmlns="http://www.w3.org/2005/Atom">

  <generator py:if="defined('generator')" py:content="generator">
    feed generator
  </generator>
  <id py:content="id">
    feed id
  </id>
  <title py:if="defined('title')" py:content="title">
    feed title
  </title>
  <updated py:if="defined('updated')" py:content="updated">
    feed modification timestamp
  </updated>
  <author py:if="defined('author')">
    <name py:content="author['name']">
      feed author name
    </name>
    <email py:if="'email' in author" py:content="author['email']">
      feed author email
    </email>
    <uri py:if="'uri' in author" py:content="entry['author']['uri']">
      feed author uri
    </uri>
  </author>
  <link py:if="defined('link')" rel="self" href="${link}" />
  <icon py:if="defined('icon')" py:content="icon">
    feed icon
  </icon>
  <logo py:if="defined('logo')" py:content="logo">
    feed logo
  </logo>
  <rights py:if="defined('rights')" py:content="rights">
    feed rights
  </rights>
  <subtitle py:if="defined('subtitle')" py:content="subtitle">
    feed subtitle
  </subtitle>
  <category py:for="cat in value_of('categories', [])" term="${cat}"
    label="${cat}" />

  <entry py:for="entry in entries">
    <id py:if="'id' in entry" py:content="entry['id']">
      entry id
    </id>
    <!--! title element is required but can be empty -->
    <title py:content="entry.get('title', '')">
      entry title
    </title>
    <link py:if="'link' in entry" rel="alternate" href="${entry['link']}" />
    <updated py:if="'updated' in entry" py:content="entry['updated']">
      entry modification timestamp
    </updated>
    <published py:if="'published' in entry" py:content="entry['published']">
      entry publication timestamp
    </published>
    <author py:if="'author' in entry">
      <name py:content="entry['author']['name']">name</name>
      <email py:if="'email' in entry['author']" py:content="entry['author']['email']">
        entry email
      </email>
      <uri py:if="'uri' in entry['author']" py:content="entry['author']['uri']">
        entry uri
      </uri>
    </author>
    <content py:if="isinstance(entry.get('content'), dict)"
      py:content="entry['content']['value']"
      py:attrs="dict(type=entry['content'].get('type'))">
      entry content
    </content>
    <content py:if="'content' in entry and not isinstance(entry['content'], dict)"
      py:content="entry['content']">
      entry content
    </content>
    <summary py:if="'summary' in entry" py:content="entry['summary']">
      entry summary
    </summary>
    <rights py:if="'rights' in entry" py:content="entry['rights']">
      entry rights
    </rights>
    <category py:for="cat in entry.get('categories', [])" term="${cat}"
      label="${cat}" />
  </entry>

</feed>
</root>
