var geos_test_data = [
{'wkt1':'POLYGON ((100 100,100 200,200 200,200 100,100 100))', 'wkt2':'POLYGON ((100 100,1000000000000000.0 110.0,1000000000000000.0 100.0,100 100))', result:true},
{'wkt1':'POLYGON ((120 100,120 200,200 200,200 100,120 100))', 'wkt2':'POLYGON ((100 100,1000000000000000.0 110.0,1000000000000000.0 100.0,100 100))', result:true},
{'wkt1':'POLYGON ((20 20,20 100,120 100,140 20,20 20))', 'wkt2':'POLYGON ((20 20,20 100,120 100,140 20,20 20))', result:true},
{'wkt1':'POLYGON ((20 20,20 100,120 100,140 20,20 20))', 'wkt2':'POLYGON ((20 20,140 20,120 100,20 100,20 20))', result:true},
{'wkt1':'POLYGON ((20 20,20 100,120 100,140 20,20 20))', 'wkt2':'POLYGON ((120 100,140 20,20 20,20 100,120 100))', result:true},
{'wkt1':'POLYGON ((20 20,20 100,120 100,140 20,20 20))', 'wkt2':'POLYGON ((20 100,60 100,120 100,140 20,80 20,20 20,20 100))', result:true},
{'wkt1':'POLYGON ((0 0,80 0,80 80,0 80,0 0))', 'wkt2':'POLYGON ((100 200,100 140,180 140,180 200,100 200))', result:false},
{'wkt1':'POLYGON ((140 120,160 20,20 20,20 120,140 120))', 'wkt2':'POLYGON ((140 120,140 200,240 200,240 120,140 120))', result:true},
{'wkt1':'POLYGON ((140 120,160 20,20 20,20 120,140 120))', 'wkt2':'POLYGON ((80 180,140 260,260 200,200 60,80 180))', result:true},
{'wkt1':'POLYGON ((140 120,160 20,20 20,20 120,140 120))', 'wkt2':'POLYGON ((240 80,140 120,180 240,280 200,240 80))', result:true},
{'wkt1':'POLYGON ((140 160,20 20,270 20,150 160,230 40,60 40,140 160))', 'wkt2':'POLYGON ((140 40,180 80,120 100,140 40))', result:true},
{'wkt1':'POLYGON ((140 160,20 20,270 20,150 160,230 40,60 40,140 160))', 'wkt2':'POLYGON ((120 100,180 80,130 40,120 100))', result:true},
{'wkt1':'POLYGON ((20 20,180 20,140 140,20 140,20 20))', 'wkt2':'POLYGON ((180 100,80 200,180 280,260 200,180 100))', result:true},
{'wkt1':'POLYGON ((140 120,160 20,20 20,20 120,140 120))', 'wkt2':'POLYGON ((140 140,20 120,0 220,120 240,140 140))', result:true},
{'wkt1':'POLYGON ((160 200,210 70,120 70,160 200))', 'wkt2':'POLYGON ((160 200,260 40,70 40,160 200,20 20,310 20,160 200))', result:true},
{'wkt1':'POLYGON ((110 140,200 70,200 160,110 140))', 'wkt2':'POLYGON ((110 140,110 50,60 50,60 90,160 190,20 110,20 20,200 20,110 140))', result:true},
{'wkt1':'POLYGON ((20 120,20 20,260 20,260 120,200 40,140 120,80 40,20 120))', 'wkt2':'POLYGON ((20 120,20 240,260 240,260 120,200 200,140 120,80 200,20 120))', result:true},
{'wkt1':'POLYGON ((20 120,20 20,260 20,260 120,180 40,140 120,100 40,20 120))', 'wkt2':'POLYGON ((20 120,300 120,140 240,20 120))', result:true},
{'wkt1':'POLYGON ((20 20,20 300,280 300,280 260,220 260,60 100,60 60,280 60,280 20,20 20))', 'wkt2':'POLYGON ((100 140,160 80,280 180,200 240,220 160,160 200,180 120,100 140))', result:true},
{'wkt1':'POLYGON ((20 20,20 300,280 300,280 260,220 260,60 100,60 60,280 60,280 20,20 20))', 'wkt2':'POLYGON ((260 200,180 80,120 160,200 160,180 220,260 200))', result:true},
{'wkt1':'POLYGON ((20 20,280 20,280 140,220 60,140 140,80 60,20 140,20 20))', 'wkt2':'POLYGON ((0 140,300 140,140 240,0 140))', result:true},
{'wkt1':'POLYGON ((20 20,280 20,280 140,220 60,140 140,80 60,20 140,20 20))', 'wkt2':'POLYGON ((20 240,20 140,320 140,180 240,20 240))', result:true},
{'wkt1':'POLYGON ((20 20,280 20,280 140,220 60,140 140,80 60,20 140,20 20))', 'wkt2':'POLYGON ((20 240,20 140,80 180,140 140,220 180,280 140,280 240,20 240))', result:true},
{'wkt1':'POLYGON ((120 120,180 60,20 20,20 120,120 120))', 'wkt2':'POLYGON ((120 120,220 20,280 20,240 160,120 120))', result:true},
{'wkt1':'POLYGON ((140 120,160 20,20 20,20 120,140 120))', 'wkt2':'POLYGON ((140 120,160 20,260 120,220 200,140 120))', result:true},
{'wkt1':'POLYGON ((20 140,120 40,20 40,20 140))', 'wkt2':'POLYGON ((190 140,190 20,140 20,20 140,190 140))', result:true},
{'wkt1':'POLYGON ((120 120,180 60,20 20,20 120,120 120))', 'wkt2':'POLYGON ((300 20,220 20,120 120,260 160,300 20))', result:true},
{'wkt1':'POLYGON ((140 120,160 20,20 20,20 120,140 120))', 'wkt2':'POLYGON ((140 120,240 160,280 60,160 20,140 120))', result:true},
{'wkt1':'POLYGON ((120 120,180 60,20 20,20 120,120 120))', 'wkt2':'POLYGON ((280 60,180 60,120 120,260 180,280 60))', result:true},
{'wkt1':'POLYGON ((140 120,160 20,20 20,20 120,140 120))', 'wkt2':'POLYGON ((120 200,120 120,40 120,40 200,120 200))', result:true},
{'wkt1':'POLYGON ((140 120,160 20,20 20,20 120,140 120))', 'wkt2':'POLYGON ((160 220,140 120,60 120,40 220,160 220))', result:true},
{'wkt1':'POLYGON ((140 120,160 20,20 20,20 120,140 120))', 'wkt2':'POLYGON ((140 120,20 120,20 220,140 220,140 120))', result:true},
{'wkt1':'POLYGON ((120 120,180 60,20 20,20 120,120 120))', 'wkt2':'POLYGON ((320 20,220 20,80 160,240 140,320 20))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((60 40,60 140,180 140,180 40,60 40))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((20 20,80 140,160 60,20 20))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((160 60,20 20,100 140,160 60))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((20 100,140 160,160 40,20 100))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((160 40,20 100,160 160,160 40))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((20 180,180 120,80 40,20 180))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((180 120,100 40,20 180,180 120))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((20 20,140 40,140 120,20 160,80 80,20 20))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((20 20,140 40,140 140,20 180,80 100,20 20))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((40 180,60 100,180 100,200 180,120 120,40 180))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((20 180,60 80,180 80,220 180,120 120,20 180))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((40 60,20 180,100 100,140 180,160 120,220 100,140 40,40 60))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((60 100,180 100,220 180,120 140,20 180,60 100))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((20 20,20 140,120 120,120 40,20 20))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((20 20,20 180,140 140,140 60,20 20))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((20 20,120 40,120 120,20 140,20 20))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((120 40,20 20,20 140,120 120,120 40))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((20 20,140 60,140 140,20 180,20 20))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((140 60,20 20,20 180,140 140,140 60))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((20 20,60 120,140 120,180 20,20 20))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((20 40,120 40,120 120,20 140,20 40))', result:true},
{'wkt1':'POLYGON ((20 20,20 180,220 180,220 20,20 20))', 'wkt2':'POLYGON ((20 20,20 180,60 120,100 180,140 120,220 180,200 120,140 60,20 20))', result:true},
{'wkt1':'POLYGON ((150 150,330 150,250 70,70 70,150 150))', 'wkt2':'POLYGON ((150 150,270 150,140 20,20 20,150 150))', result:true},
{'wkt1':'POLYGON ((150 150,270 150,330 150,250 70,190 70,70 70,150 150))', 'wkt2':'POLYGON ((150 150,270 150,190 70,140 20,20 20,70 70,150 150))', result:true},
{'wkt1':'POLYGON ((20 20,60 50,20 40,60 70,20 60,60 90,20 90,70 110,20 130,80 130,20 150,80 160,20 170,80 180,20 200,80 200,30 240,80 220,50 260,100 220,100 260,120 220,130 260,140 220,150 280,150 190,160 280,170 190,180 280,190 190,200 280,210 190,220 280,230 190,240 260,250 230,260 260,260 220,290 270,290 220,330 260,300 210,340 240,290 180,340 210,290 170,350 170,240 150,350 150,240 140,350 130,240 120,350 120,240 110,350 110,240 100,350 100,240 90,350 90,240 80,350 80,300 70,340 60,290 60,340 40,300 50,340 20,270 60,310 20,250 60,270 20,230 60,240 20,210 60,210 20,190 70,190 20,180 90,170 20,160 90,150 20,140 90,130 20,120 90,110 20,100 90,100 20,90 60,80 20,70 40,20 20))', 'wkt2':'POLYGON ((190 140,140 130,200 160,130 150,210 170,130 170,210 180,120 190,220 200,120 200,250 210,120 210,250 220,120 220,250 230,120 240,230 240,120 250,240 260,120 260,240 270,120 270,270 290,120 290,230 300,150 310,250 310,180 320,250 320,200 360,260 330,240 360,280 320,290 370,290 320,320 360,310 320,360 360,310 310,380 340,310 290,390 330,310 280,410 310,310 270,420 280,310 260,430 250,300 250,440 240,300 240,450 230,280 220,440 220,280 210,440 210,300 200,430 190,300 190,440 180,330 180,430 150,320 180,420 130,300 180,410 120,280 180,400 110,280 170,390 90,280 160,400 70,270 160,450 30,260 160,420 30,250 160,390 30,240 160,370 30,230 160,360 30,230 150,330 50,240 130,330 30,230 130,310 30,220 130,280 30,230 100,270 40,220 110,250 30,210 130,240 30,210 100,220 40,200 90,200 20,190 100,180 30,20 20,180 40,20 30,180 50,20 50,180 60,30 60,180 70,20 70,170 80,80 80,170 90,20 80,180 100,40 100,200 110,60 110,200 120,120 120,190 140))', result:true},
{'wkt1':'POLYGON ((70 150,20 160,110 160,20 180,100 200,20 200,190 210,20 210,160 220,20 220,150 230,60 240,180 250,20 260,170 260,60 270,160 270,100 310,170 280,200 260,180 230,210 260,130 330,230 250,210 290,240 250,230 210,260 300,250 230,270 300,270 240,300 340,280 250,320 330,290 250,340 350,290 240,350 360,270 190,350 340,290 200,350 330,300 190,360 320,310 190,360 300,320 200,360 280,330 200,360 260,340 200,370 260,340 180,390 290,340 170,400 260,350 170,400 250,350 160,410 240,350 150,400 170,350 140,310 170,340 140,270 180,330 140,260 170,310 140,240 170,290 140,200 190,270 140,180 190,260 140,170 190,260 130,170 180,250 130,170 170,240 120,170 160,210 120,170 150,210 110,340 130,230 110,420 140,220 100,410 130,220 90,400 120,220 80,390 110,220 70,420 110,240 70,420 100,260 70,420 90,280 70,430 80,230 60,430 60,270 50,450 40,210 50,370 40,260 40,460 30,160 40,210 60,200 110,190 60,190 120,170 50,180 130,150 30,170 130,140 20,160 120,130 20,160 150,120 20,160 170,110 20,160 190,100 20,150 190,90 20,140 180,80 20,120 140,70 20,120 150,60 20,110 150,50 20,100 140,50 30,90 130,40 30,80 120,30 30,80 130,30 40,80 140,20 40,70 140,40 90,60 130,20 90,60 140,20 130,70 150))', 'wkt2':'POLYGON ((190 140,140 130,200 160,130 150,210 170,130 170,210 180,120 190,220 200,120 200,250 210,120 210,250 220,120 220,250 230,120 240,230 240,120 250,240 260,120 260,240 270,120 270,270 290,120 290,230 300,150 310,250 310,180 320,250 320,200 360,260 330,240 360,280 320,290 370,290 320,320 360,310 320,360 360,310 310,380 340,310 290,390 330,310 280,410 310,310 270,420 280,310 260,430 250,300 250,440 240,300 240,450 230,280 220,440 220,280 210,440 210,300 200,430 190,300 190,440 180,330 180,430 150,320 180,420 130,300 180,410 120,280 180,400 110,280 170,390 90,280 160,400 70,270 160,450 30,260 160,420 30,250 160,390 30,240 160,370 30,230 160,360 30,230 150,330 50,240 130,330 30,230 130,310 30,220 130,280 30,230 100,270 40,220 110,250 30,210 130,240 30,210 100,220 40,200 90,200 20,190 100,180 30,20 20,180 40,20 30,180 50,20 50,180 60,30 60,180 70,20 70,170 80,80 80,170 90,20 80,180 100,40 100,200 110,60 110,200 120,120 120,190 140))', result:true},
{'wkt1':'POLYGON ((60 160,220 160,220 20,60 20,60 160))', 'wkt2':'POLYGON ((60 160,20 200,260 200,220 160,140 80,60 160))', result:true},
{'wkt1':'POLYGON ((60 160,220 160,220 20,60 20,60 160))', 'wkt2':'POLYGON ((60 160,20 200,260 200,140 80,60 160))', result:true},
{'wkt1':'POLYGON ((60 160,220 160,220 20,60 20,60 160))', 'wkt2':'POLYGON ((20 200,140 80,260 200,20 200))', result:true},
{'wkt1':'POLYGON ((60 160,220 160,220 20,60 20,60 160))', 'wkt2':'POLYGON ((20 200,60 160,140 80,220 160,260 200,20 200))', result:true},
{'wkt1':'POLYGON ((60 160,220 160,220 20,60 20,60 160))', 'wkt2':'POLYGON ((20 200,60 160,140 80,260 200,20 200))', result:true},
{'wkt1':'POLYGON ((0 0,0 200,200 200,200 0,0 0))', 'wkt2':'POLYGON ((100 100,1000000 110,10000000 100,100 100))', result:true},
{'wkt1':'POLYGON ((100 0,100 200,200 200,200 0,100 0))', 'wkt2':'POLYGON ((100 100,1000000 110,10000000 100,100 100))', result:true},
{'wkt1':'POLYGON ((120 0,120 200,200 200,200 0,120 0))', 'wkt2':'POLYGON ((100 100,1000000 110,10000000 100,100 100))', result:true},
{'wkt1':'POLYGON ((0 0,0 200,110 200,110 0,0 0))', 'wkt2':'POLYGON ((100 100,1000000 110,10000000 100,100 100))', result:true},
{'wkt1':'POLYGON ((100 100,100 200,200 200,200 100,100 100))', 'wkt2':'POLYGON ((100 100,2100 110,2100 100,100 100))', result:true},
{'wkt1':'POLYGON ((100 100,100 200,200 200,200 100,100 100))', 'wkt2':'POLYGON ((100 100,2101 110,2101 100,100 100))', result:true},
{'wkt1':'POLYGON ((100 100,200 200,200 100,100 100))', 'wkt2':'POLYGON ((100 100,2101 110,2101 100,100 100))', result:true},
{'wkt1':'POLYGON ((100 100,100 200,200 200,200 100,100 100))', 'wkt2':'POLYGON ((100 100,1000000 110,1000000 100,100 100))', result:true},
{'wkt1':'POLYGON ((120 100,120 200,200 200,200 100,120 100))', 'wkt2':'POLYGON ((100 100,500 110,500 100,100 100))', result:true},
{'wkt1':'POLYGON ((120 100,120 200,200 200,200 100,120 100))', 'wkt2':'POLYGON ((100 100,501 110,501 100,100 100))', result:true},
{'wkt1':'POLYGON ((120 100,130 200,200 200,200 100,120 100))', 'wkt2':'POLYGON ((100 100,501 110,501 100,100 100))', result:true},
{'wkt1':'POLYGON ((120 100,17 200,200 200,200 100,120 100))', 'wkt2':'POLYGON ((100 100,501 110,501 100,100 100))', result:true},
{'wkt1':'POLYGON ((120 100,120 200,200 200,200 100,120 100))', 'wkt2':'POLYGON ((100 100,1000000 110,1000000 100,100 100))', result:true},
{'wkt1':'POLYGON ((101 99,101 1000000,102 1000000,101 99))', 'wkt2':'POLYGON ((100 100,1000000 110,1000000 100,100 100))', result:true},
{'wkt1':'POLYGON ((100 100,200 101,200 100,100 100))', 'wkt2':'POLYGON ((100 100,2101 110,2101 100,100 100))', result:true},
{'wkt1':'POLYGON ((16 319,150 39,25 302,160 20,265 20,127 317,16 319))', 'wkt2':'POLYGON ((10 307,22 307,153 34,22 34,10 307))', result:true},
{'wkt1':'POLYGON ((160 200,210 70,120 70,160 200))', 'wkt2':'POLYGON ((160 200,310 20,20 20,160 200),(160 200,260 40,70 40,160 200))', result:true},
{'wkt1':'POLYGON ((170 120,240 100,260 50,190 70,170 120))', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,330 120,260 50,100 50,170 120))', result:true},
{'wkt1':'POLYGON ((270 90,200 50,150 80,210 120,270 90))', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,330 120,260 50,100 50,170 120))', result:true},
{'wkt1':'POLYGON ((170 120,260 100,240 60,150 80,170 120))', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,330 120,260 50,100 50,170 120))', result:true},
{'wkt1':'POLYGON ((220 120,270 80,200 60,160 100,220 120))', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,330 120,260 50,100 50,170 120))', result:true},
{'wkt1':'POLYGON ((260 50,180 70,180 110,260 90,260 50))', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,330 120,260 50,100 50,170 120))', result:true},
{'wkt1':'POLYGON ((230 110,290 80,190 60,140 90,230 110))', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,330 120,260 50,100 50,170 120))', result:true},
{'wkt1':'POLYGON ((170 120,330 120,260 50,100 50,170 120))', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,330 120,260 50,100 50,170 120))', result:true},
{'wkt1':'POLYGON ((170 120,330 120,280 70,120 70,170 120))', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,330 120,260 50,100 50,170 120))', result:true},
{'wkt1':'POLYGON ((170 120,300 120,250 70,120 70,170 120))', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,330 120,260 50,100 50,170 120))', result:true},
{'wkt1':'POLYGON ((190 100,310 100,260 50,140 50,190 100))', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,330 120,260 50,100 50,170 120))', result:true},
{'wkt1':'POLYGON ((280 130,360 130,270 40,190 40,280 130))', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,250 120,180 50,100 50,170 120))', result:true},
{'wkt1':'POLYGON ((220 80,180 40,80 40,170 130,270 130,230 90,300 90,250 30,280 30,390 140,150 140,40 30,230 30,280 80,220 80))', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,250 120,180 50,100 50,170 120))', result:true},
{'wkt1':'POLYGON ((260 130,360 130,280 40,170 40,260 130))', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,250 120,180 50,100 50,170 120))', result:true},
{'wkt1':'POLYGON ((240 110,340 110,290 60,190 60,240 110))', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,250 120,180 50,100 50,170 120))', result:true},
{'wkt1':'POLYGON ((250 120,350 120,280 50,180 50,250 120))', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,250 120,180 50,100 50,170 120))', result:true},
{'wkt1':'POLYGON ((230 210,230 20,20 20,20 210,230 210),(120 180,50 50,200 50,120 180))', 'wkt2':'POLYGON ((230 210,230 20,20 20,20 210,230 210),(120 180,50 50,200 50,120 180))', result:true},
{'wkt1':'POLYGON ((230 210,230 20,20 20,20 210,230 210),(140 40,40 40,40 170,140 40),(110 190,210 190,210 50,110 190))', 'wkt2':'POLYGON ((230 210,230 20,20 20,20 210,230 210),(140 40,40 40,40 170,140 40),(110 190,210 190,210 50,110 190))', result:true},
{'wkt1':'POLYGON ((280 190,330 150,200 110,150 150,280 190))', 'wkt2':'MULTIPOLYGON (((140 110,260 110,170 20,50 20,140 110)),((300 270,420 270,340 190,220 190,300 270)))', result:true},
{'wkt1':'POLYGON ((80 190,220 190,140 110,0 110,80 190))', 'wkt2':'MULTIPOLYGON (((140 110,260 110,170 20,50 20,140 110)),((300 270,420 270,340 190,220 190,300 270)))', result:true},
{'wkt1':'POLYGON ((330 150,200 110,150 150,280 190,330 150))', 'wkt2':'MULTIPOLYGON (((140 110,260 110,170 20,50 20,140 110)),((300 270,420 270,340 190,220 190,300 270)))', result:true},
{'wkt1':'POLYGON ((290 190,340 150,220 120,170 170,290 190))', 'wkt2':'MULTIPOLYGON (((140 110,260 110,170 20,50 20,140 110)),((300 270,420 270,340 190,220 190,300 270)))', result:true},
{'wkt1':'POLYGON ((220 190,340 190,260 110,140 110,220 190))', 'wkt2':'MULTIPOLYGON (((140 110,260 110,170 20,50 20,140 110)),((300 270,420 270,340 190,220 190,300 270)))', result:true},
{'wkt1':'POLYGON ((140 190,220 190,100 70,20 70,140 190))', 'wkt2':'MULTIPOLYGON (((140 110,260 110,170 20,50 20,140 110)),((300 270,420 270,340 190,220 190,300 270)))', result:true},
{'wkt1':'POLYGON ((140 220,60 140,140 60,220 140,140 220))', 'wkt2':'MULTIPOLYGON (((100 20,180 20,180 100,100 100,100 20)),((20 100,100 100,100 180,20 180,20 100)),((100 180,180 180,180 260,100 260,100 180)),((180 100,260 100,260 180,180 180,180 100)))', result:true},
{'wkt1':'MULTIPOLYGON (((110 110,70 200,150 200,110 110)),((110 110,150 20,70 20,110 110)))', 'wkt2':'MULTIPOLYGON (((110 110,160 160,210 110,160 60,110 110)),((110 110,60 60,10 110,60 160,110 110)))', result:true},
{'wkt1':'MULTIPOLYGON (((110 110,70 200,150 200,110 110),(110 110,100 180,120 180,110 110)),((110 110,150 20,70 20,110 110),(110 110,120 40,100 40,110 110)))', 'wkt2':'MULTIPOLYGON (((110 110,160 160,210 110,160 60,110 110),(110 110,160 130,160 90,110 110)),((110 110,60 60,10 110,60 160,110 110),(110 110,60 90,60 130,110 110)))', result:true},
{'wkt1':'MULTIPOLYGON (((110 110,70 200,200 200,110 110),(110 110,100 180,120 180,110 110)),((110 110,200 20,70 20,110 110),(110 110,120 40,100 40,110 110)))', 'wkt2':'MULTIPOLYGON (((110 110,160 160,210 110,160 60,110 110),(110 110,160 130,160 90,110 110)),((110 110,60 60,10 110,60 160,110 110),(110 110,60 90,60 130,110 110)))', result:true},
{'wkt1':'MULTIPOLYGON (((110 110,20 200,200 200,110 110),(110 110,100 180,120 180,110 110)),((110 110,200 20,20 20,110 110),(110 110,120 40,100 40,110 110)))', 'wkt2':'MULTIPOLYGON (((110 110,160 160,210 110,160 60,110 110),(110 110,160 130,160 90,110 110)),((110 110,60 60,10 110,60 160,110 110),(110 110,60 90,60 130,110 110)))', result:true},
{'wkt1':'MULTIPOLYGON (((110 110,70 200,200 200,110 110),(110 110,100 180,120 180,110 110)),((110 110,200 20,70 20,110 110),(110 110,120 40,100 40,110 110)))', 'wkt2':'MULTIPOLYGON (((110 110,160 160,210 110,160 60,110 110),(110 110,160 130,160 90,110 110)),((110 110,60 60,10 110,60 160,110 110),(110 110,60 90,60 130,110 110)))', result:true},
{'wkt1':'MULTIPOLYGON (((110 110,70 200,200 200,110 110),(110 110,100 180,120 180,110 110)),((110 110,200 20,70 20,110 110),(110 110,120 40,100 40,110 110)))', 'wkt2':'MULTIPOLYGON (((110 110,70 200,210 110,70 20,110 110),(110 110,110 140,150 110,110 80,110 110)),((110 110,60 60,10 110,60 160,110 110),(110 110,60 90,60 130,110 110)))', result:true},
{'wkt1':'POLYGON ((100 60,140 100,100 140,60 100,100 60))', 'wkt2':'MULTIPOLYGON (((80 40,120 40,120 80,80 80,80 40)),((120 80,160 80,160 120,120 120,120 80)),((80 120,120 120,120 160,80 160,80 120)),((40 80,80 80,80 120,40 120,40 80)))', result:true},
{'wkt1':'LINESTRING (150 150,40 230)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (40 40,50 130,130 130)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (40 230,150 150)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (210 150,330 150)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (200 150,310 150,360 220)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (180 150,250 150,230 250,370 250,410 150)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (210 210,220 150,320 150,370 210)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (20 60,150 60)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (60 90,310 180)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (90 210,210 90)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (290 10,130 170)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (30 100,100 100,180 100)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (20 100,100 100,360 100,410 100)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (90 210,150 150,210 90)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (180 90,280 120)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (70 70,80 20)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (130 20,150 60)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (70 70,80 20,140 20,150 60)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (170 50,170 20,240 20,260 60)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150))', result:true},
{'wkt1':'LINESTRING (50 100,140 190,280 190)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,330 120,260 50,100 50,170 120))', result:false},
{'wkt1':'LINESTRING (140 60,180 100,290 100)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,330 120,260 50,100 50,170 120))', result:false},
{'wkt1':'LINESTRING (170 120,210 80,270 80)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,330 120,260 50,100 50,170 120))', result:true},
{'wkt1':'LINESTRING (170 120,260 50)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,330 120,260 50,100 50,170 120))', result:true},
{'wkt1':'LINESTRING (190 90,190 270)', 'wkt2':'POLYGON ((190 190,360 20,20 20,190 190),(190 190,280 50,100 50,190 190))', result:true},
{'wkt1':'LINESTRING (60 160,150 70)', 'wkt2':'POLYGON ((190 190,360 20,20 20,190 190),(110 110,250 100,140 30,110 110))', result:true},
{'wkt1':'LINESTRING (60 160,150 70)', 'wkt2':'POLYGON ((190 190,20 20,360 20,190 190),(250 100,110 110,140 30,250 100))', result:true},
{'wkt1':'LINESTRING (60 160,150 70)', 'wkt2':'POLYGON ((190 190,20 20,360 20,190 190),(250 100,110 110,140 30,250 100))', result:true},
{'wkt1':'LINESTRING (190 90,190 190,190 270)', 'wkt2':'POLYGON ((190 190,360 20,20 20,190 190),(190 190,280 50,100 50,190 190))', result:true},
{'wkt1':'LINESTRING (60 160,110 110,150 70)', 'wkt2':'POLYGON ((190 190,360 20,20 20,190 190),(110 110,250 100,140 30,110 110))', result:true},
{'wkt1':'LINESTRING (60 160,110 110,150 70)', 'wkt2':'POLYGON ((190 190,20 20,360 20,190 190),(250 100,110 110,140 30,250 100))', result:true},
{'wkt1':'LINESTRING (60 160,110 110,150 70)', 'wkt2':'POLYGON ((190 190,110 110,20 20,360 20,190 190),(250 100,110 110,140 30,250 100))', result:true},
{'wkt1':'LINESTRING (130 110,180 110,190 60)', 'wkt2':'POLYGON ((20 200,240 200,240 20,20 20,20 200),(130 110,60 180,60 40,130 110),(130 110,200 40,200 180,130 110))', result:true},
{'wkt1':'LINESTRING (80 110,180 110)', 'wkt2':'POLYGON ((20 200,240 200,240 20,20 20,20 200),(130 110,60 180,60 40,130 110),(130 110,200 40,200 180,130 110))', result:true},
{'wkt1':'LINESTRING (80 110,180 110)', 'wkt2':'POLYGON ((20 200,20 20,240 20,240 200,20 200),(60 180,130 110,60 40,60 180),(130 110,200 40,200 180,130 110))', result:true},
{'wkt1':'LINESTRING (80 110,170 110)', 'wkt2':'POLYGON ((20 200,20 20,240 20,240 200,20 200),(130 110,60 40,60 180,130 110),(130 180,130 40,200 110,130 180))', result:true},
{'wkt1':'LINESTRING (80 110,130 110,170 110)', 'wkt2':'POLYGON ((20 200,20 20,240 20,240 200,20 200),(130 110,60 40,60 180,130 110),(130 180,130 40,200 110,130 180))', result:true},
{'wkt1':'LINESTRING (80 110,130 110,180 110)', 'wkt2':'POLYGON ((20 200,240 200,240 20,20 20,20 200),(130 110,60 180,60 40,130 110),(130 110,200 40,200 180,130 110))', result:true},
{'wkt1':'LINESTRING (80 110,130 110,180 110)', 'wkt2':'POLYGON ((20 200,20 20,240 20,240 200,20 200),(60 180,130 110,60 40,60 180),(130 110,200 40,200 180,130 110))', result:true},
{'wkt1':'LINESTRING (80 110,130 110,170 110)', 'wkt2':'POLYGON ((20 200,20 20,240 20,240 200,20 200),(130 110,60 40,60 180,130 110),(130 180,130 40,200 110,130 180))', result:true},
{'wkt1':'LINESTRING (160 70,320 230)', 'wkt2':'MULTIPOLYGON (((140 110,260 110,170 20,50 20,140 110)),((300 270,420 270,340 190,220 190,300 270)))', result:true},
{'wkt1':'LINESTRING (160 70,200 110,280 190,320 230)', 'wkt2':'MULTIPOLYGON (((140 110,260 110,170 20,50 20,140 110)),((300 270,420 270,340 190,220 190,300 270)))', result:true},
{'wkt1':'LINESTRING (70 50,70 150)', 'wkt2':'MULTIPOLYGON (((0 0,0 100,140 100,140 0,0 0)),((20 170,70 100,130 170,20 170)))', result:true},
{'wkt1':'LINESTRING (110 110,20 200,200 200,110 110)', 'wkt2':'POLYGON ((20 20,200 20,110 110,20 20))', result:true},
{'wkt1':'LINESTRING (150 70,160 110,200 60,150 70)', 'wkt2':'POLYGON ((20 20,200 20,110 110,20 20))', result:true},
{'wkt1':'LINESTRING (80 60,120 40,120 70,80 60)', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110),(110 90,50 30,170 30,110 90))', result:true},
{'wkt1':'LINESTRING (20 20,200 20,110 110,20 20)', 'wkt2':'POLYGON ((20 20,200 20,110 110,20 20))', result:true},
{'wkt1':'LINESTRING (110 90,170 30,50 30,110 90)', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110),(110 90,50 30,170 30,110 90))', result:true},
{'wkt1':'LINESTRING (110 110,170 50,170 110,110 110)', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110),(110 90,50 30,170 30,110 90))', result:true},
{'wkt1':'LINESTRING (110 90,70 50,130 50,110 90)', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110),(110 90,50 30,170 30,110 90))', result:true},
{'wkt1':'LINESTRING (110 60,20 150,200 150,110 60)', 'wkt2':'POLYGON ((20 20,200 20,110 110,20 20))', result:true},
{'wkt1':'LINESTRING (110 130,110 70,200 100,110 130)', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110),(110 90,50 30,170 30,110 90))', result:true},
{'wkt1':'LINESTRING (110 90,160 40,60 40,110 90)', 'wkt2':'POLYGON ((20 20,200 20,110 110,20 20))', result:true},
{'wkt1':'LINESTRING (110 100,40 30,180 30,110 100)', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110),(110 90,60 40,160 40,110 90))', result:true},
{'wkt1':'LINESTRING (110 110,180 30,40 30,110 110)', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110),(110 90,60 40,160 40,110 90))', result:true},
{'wkt1':'LINESTRING (110 90,180 30,40 30,110 90)', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110),(110 90,60 40,160 40,110 90))', result:true},
{'wkt1':'LINESTRING (110 90,50 30,180 30,110 90)', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110),(110 90,60 40,160 40,110 90))', result:true},
{'wkt1':'LINESTRING (110 110,200 200,200 110,110 200)', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110))', result:true},
{'wkt1':'LINESTRING (110 110,200 200,110 110,20 200,20 110,200 110)', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110))', result:true},
{'wkt1':'LINESTRING (110 110,20 110,200 110,50 110,110 170)', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110))', result:true},
{'wkt1':'LINESTRING (110 110,20 200,110 200,110 110,200 200)', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110))', result:true},
{'wkt1':'LINESTRING (110 110,170 50,20 200,20 110,200 110)', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110))', result:true},
{'wkt1':'LINESTRING (110 110,180 40,110 40,110 180)', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110))', result:true},
{'wkt1':'LINESTRING (110 60,50 30,170 30,90 70)', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110))', result:true},
{'wkt1':'LINESTRING (110 110,180 40,110 40,110 110,70 40)', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110))', result:true},
{'wkt1':'LINESTRING (230 70,170 120,190 60,140 60,170 120,270 90)', 'wkt2':'POLYGON ((150 150,410 150,280 20,20 20,150 150),(170 120,330 120,260 50,100 50,170 120))', result:true},
{'wkt1':'MULTILINESTRING ((20 110,200 110),(200 200,110 110,20 210,110 110))', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110))', result:true},
{'wkt1':'MULTILINESTRING ((20 110,200 110),(60 180,60 110,160 110,110 110))', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110))', result:true},
{'wkt1':'MULTILINESTRING ((20 110,200 110),(200 200,110 110,20 200,110 200,110 110))', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110))', result:true},
{'wkt1':'MULTILINESTRING ((20 110,200 110),(110 50,110 170,110 70,110 150,200 150))', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110))', result:true},
{'wkt1':'MULTILINESTRING ((20 110,200 110),(50 110,170 110,110 170,110 50,110 170,110 50))', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110))', result:true},
{'wkt1':'MULTILINESTRING ((20 110,200 110),(110 60,110 160,200 160))', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110))', result:true},
{'wkt1':'MULTILINESTRING ((20 110,200 110),(110 60,110 160,200 160))', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110))', result:true},
{'wkt1':'MULTILINESTRING ((110 100,40 30,180 30),(170 30,110 90,50 30))', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110))', result:true},
{'wkt1':'MULTILINESTRING ((110 110,60 40,70 20,150 20,170 40),(180 30,40 30,110 80))', 'wkt2':'POLYGON ((110 110,200 20,20 20,110 110))', result:true},
{'wkt1':'MULTILINESTRING ((20 110,200 110,200 160),(110 110,200 110,200 70,20 150))', 'wkt2':'MULTIPOLYGON (((110 110,20 20,200 20,110 110)),((110 110,20 200,200 200,110 110)))', result:true},
{'wkt1':'MULTILINESTRING ((20 160,70 110,150 110,200 160),(110 110,20 110,50 80,70 110,200 110))', 'wkt2':'MULTIPOLYGON (((110 110,20 20,200 20,110 110)),((110 110,20 200,200 200,110 110)))', result:true},
{'wkt1':'MULTILINESTRING ((20 110,200 110),(110 110,20 170,20 130,200 90))', 'wkt2':'MULTIPOLYGON (((110 110,20 20,200 20,110 110)),((110 110,20 200,200 200,110 110)))', result:true},
{'wkt1':'LINESTRING (0 0,0 50,50 50,50 0,0 0)', 'wkt2':'MULTILINESTRING ((0 0,0 50),(0 50,50 50),(50 50,50 0),(50 0,0 0))', result:true},
{'wkt1':'LINESTRING (40 180,140 180)', 'wkt2':'MULTIPOLYGON (((20 320,180 320,180 180,20 180,20 320)),((20 180,20 80,180 80,180 180,20 180)))', result:true},
{'wkt1':'LINESTRING (40 180,140 180)', 'wkt2':'MULTIPOLYGON (((20 320,180 320,180 180,20 180,20 320)),((60 180,60 80,180 80,180 180,60 180)))', result:true},
{'wkt1':'LINESTRING (0 0,60 0,60 60,60 0,120 0)', 'wkt2':'MULTILINESTRING ((0 0,60 0),(60 0,120 0),(60 0,60 60))', result:true},
{'wkt1':'LINESTRING (40 40,120 120)', 'wkt2':'LINESTRING (40 40,60 120)', result:true},
{'wkt1':'LINESTRING (40 40,120 120)', 'wkt2':'LINESTRING (60 240,40 40)', result:true},
{'wkt1':'LINESTRING (40 40,180 180)', 'wkt2':'LINESTRING (120 120,20 200)', result:true},
{'wkt1':'LINESTRING (40 40,120 120)', 'wkt2':'LINESTRING (60 240,120 120)', result:true},
{'wkt1':'LINESTRING (40 40,180 180)', 'wkt2':'LINESTRING (20 180,140 140)', result:true},
{'wkt1':'LINESTRING (40 40,120 120)', 'wkt2':'LINESTRING (40 120,120 40)', result:true},
{'wkt1':'LINESTRING (40 40,100 100)', 'wkt2':'LINESTRING (40 40,100 100)', result:true},
{'wkt1':'LINESTRING (40 40,100 100)', 'wkt2':'LINESTRING (100 100,40 40)', result:true},
{'wkt1':'LINESTRING (40 40,120 120)', 'wkt2':'LINESTRING (40 120,120 160)', result:false},
{'wkt1':'LINESTRING (20 20,180 180)', 'wkt2':'LINESTRING (20 20,180 180)', result:true},
{'wkt1':'LINESTRING (20 20,180 180)', 'wkt2':'LINESTRING (20 20,110 110)', result:true},
{'wkt1':'LINESTRING (20 20,180 180)', 'wkt2':'LINESTRING (50 50,140 140)', result:true},
{'wkt1':'LINESTRING (180 180,40 40)', 'wkt2':'LINESTRING (120 120,260 260)', result:true},
{'wkt1':'LINESTRING (40 40,180 180)', 'wkt2':'LINESTRING (260 260,120 120)', result:true},
{'wkt1':'LINESTRING (40 40,180 180)', 'wkt2':'LINESTRING (120 120,260 260)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,80 240)', 'wkt2':'LINESTRING (40 40,20 100,40 160,20 200)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,80 240)', 'wkt2':'LINESTRING (20 200,40 160,20 100,40 40)', result:true},
{'wkt1':'LINESTRING (80 240,200 120,100 100,40 40)', 'wkt2':'LINESTRING (20 200,40 160,20 100,40 40)', result:true},
{'wkt1':'LINESTRING (60 60,60 230,140 230,250 160)', 'wkt2':'LINESTRING (20 20,60 60,250 160,310 230)', result:true},
{'wkt1':'LINESTRING (60 60,60 230,140 230,250 160)', 'wkt2':'LINESTRING (20 20,110 110,200 110,320 230)', result:true},
{'wkt1':'LINESTRING (60 110,60 250,360 210)', 'wkt2':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', result:true},
{'wkt1':'LINESTRING (60 110,60 250,360 210)', 'wkt2':'LINESTRING (360 210,310 160,110 160,60 110)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,80 240)', 'wkt2':'LINESTRING (160 160,240 240)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,80 240)', 'wkt2':'LINESTRING (240 240,160 160)', result:true},
{'wkt1':'LINESTRING (60 60,60 230,140 230,250 160)', 'wkt2':'LINESTRING (60 150,110 100,170 100,110 230)', result:true},
{'wkt1':'LINESTRING (60 60,60 230,140 230,250 160)', 'wkt2':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,80 240)', 'wkt2':'LINESTRING (200 120,200 190,150 240,200 240)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,80 240)', 'wkt2':'LINESTRING (200 240,150 240,200 200,200 120)', result:true},
{'wkt1':'LINESTRING (60 60,60 230,140 230,250 160)', 'wkt2':'LINESTRING (60 230,80 140,120 140,140 230)', result:true},
{'wkt1':'LINESTRING (60 110,200 110,250 160,300 210)', 'wkt2':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', result:true},
{'wkt1':'LINESTRING (60 110,200 110,250 160,300 210,360 210)', 'wkt2':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', result:true},
{'wkt1':'LINESTRING (60 110,220 110,250 160,280 110)', 'wkt2':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', result:true},
{'wkt1':'LINESTRING (60 110,150 110,200 160,250 110,360 110,360 210)', 'wkt2':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', result:true},
{'wkt1':'LINESTRING (130 160,160 110,220 110,250 160,250 210)', 'wkt2':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', result:true},
{'wkt1':'LINESTRING (130 160,160 110,190 110,230 210)', 'wkt2':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', result:true},
{'wkt1':'LINESTRING (130 160,160 110,200 110,230 160,260 210,360 210)', 'wkt2':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', result:true},
{'wkt1':'LINESTRING (130 160,160 110,200 110,230 160,260 210,360 210,380 210)', 'wkt2':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', result:true},
{'wkt1':'LINESTRING (130 160,160 110,200 110,230 160,260 210,380 210)', 'wkt2':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', result:true},
{'wkt1':'LINESTRING (110 160,160 110,200 110,250 160,250 210)', 'wkt2':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', result:true},
{'wkt1':'LINESTRING (110 160,180 110,250 160,320 110)', 'wkt2':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', result:true},
{'wkt1':'LINESTRING (140 160,180 80,220 160,250 80)', 'wkt2':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,130 190)', 'wkt2':'LINESTRING (20 130,70 130,160 40)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,130 190)', 'wkt2':'LINESTRING (40 160,40 100,110 40,170 40)', result:true},
{'wkt1':'LINESTRING (130 110,180 160,230 110,280 160,330 110)', 'wkt2':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,130 190)', 'wkt2':'LINESTRING (30 140,80 140,100 100,200 30)', result:true},
{'wkt1':'LINESTRING (110 110,110 160,180 110,250 160,250 110)', 'wkt2':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', result:true},
{'wkt1':'LINESTRING (20 20,80 80,160 80,240 80,300 140)', 'wkt2':'LINESTRING (20 60,60 60,60 140,80 80,100 20,140 140,180 20,200 80,220 20,240 80,300 80,270 110,200 110)', result:true},
{'wkt1':'LINESTRING (20 20,230 20,20 30,170 30,20 40,230 40,20 50,230 60,60 60,230 70,20 70,180 80,60 80,230 90,20 90,230 100,30 100,210 110,20 110,80 120,20 130,170 130,90 120,230 130,170 140,230 140,80 150,160 140,20 140,70 150,20 150,230 160,80 160,230 170,20 160,180 170,20 170,230 180,20 180,40 190,230 190,20 200,230 200)', 'wkt2':'LINESTRING (30 210,30 60,40 210,40 30,50 190,50 20,60 160,60 50,70 220,70 50,80 20,80 210,90 50,90 150,100 30,100 210,110 20,110 190,120 50,120 180,130 210,120 20,140 210,130 50,150 210,130 20,160 210,140 30,170 210,150 20,180 210,160 20,190 210,180 80,170 50,170 20,180 70,180 20,190 190,190 30,200 210,200 30,210 210,210 20,220 150,220 20)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,80 240)', 'wkt2':'LINESTRING (40 40,100 100,200 120,80 240)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,80 240)', 'wkt2':'LINESTRING (80 240,200 120,100 100,40 40)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,80 240)', 'wkt2':'LINESTRING (80 240,120 200,200 120,100 100,80 80,40 40)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,80 240)', 'wkt2':'LINESTRING (260 210,240 130,280 120,260 40)', result:false},
{'wkt1':'LINESTRING (100 20,20 20,20 160,210 160,210 20,110 20,50 120,120 150,200 150)', 'wkt2':'LINESTRING (140 130,100 110,120 60,170 60)', result:false},
{'wkt1':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', 'wkt2':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', result:true},
{'wkt1':'LINESTRING (60 110,110 160,310 160,360 210)', 'wkt2':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', result:true},
{'wkt1':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', 'wkt2':'LINESTRING (60 110,110 160,250 160)', result:true},
{'wkt1':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', 'wkt2':'LINESTRING (110 160,310 160,340 190)', result:true},
{'wkt1':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', 'wkt2':'LINESTRING (140 160,250 160,310 160,340 190)', result:true},
{'wkt1':'LINESTRING (60 110,110 160,250 160,310 160,360 210)', 'wkt2':'LINESTRING (110 160,250 160,310 160)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,80 240)', 'wkt2':'LINESTRING (200 120,100 100,40 40,140 80,200 40)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,80 240)', 'wkt2':'LINESTRING (280 240,240 140,200 120,100 100,40 40)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,80 240)', 'wkt2':'LINESTRING (80 190,140 140,40 40)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,80 240)', 'wkt2':'LINESTRING (240 200,200 260,80 240,140 180)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,80 240)', 'wkt2':'LINESTRING (140 180,80 240,200 260,240 200)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,80 240)', 'wkt2':'LINESTRING (280 240,240 140,200 120,80 240)', result:true},
{'wkt1':'LINESTRING (20 20,80 80,160 80,240 80,300 140)', 'wkt2':'LINESTRING (20 80,120 80,200 80,260 20)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,80 240)', 'wkt2':'LINESTRING (100 100,200 120,240 140,280 240)', result:true},
{'wkt1':'LINESTRING (40 40,100 100,200 120,80 240)', 'wkt2':'LINESTRING (280 240,240 140,200 120,100 100)', result:true},
{'wkt1':'LINESTRING (20 20,80 80,160 80,240 80,300 140)', 'wkt2':'LINESTRING (80 20,80 80,240 80,300 20)', result:true},
{'wkt1':'LINESTRING (20 20,80 80,160 80,240 80,300 140)', 'wkt2':'LINESTRING (20 80,80 80,120 80,140 140,160 80,200 80,220 20,240 80,270 110,300 80)', result:true},
{'wkt1':'LINESTRING (100 100,20 180,180 180)', 'wkt2':'LINESTRING (100 100,180 20,20 20,100 100)', result:true},
{'wkt1':'LINESTRING (20 100,180 100,100 180)', 'wkt2':'LINESTRING (100 100,180 20,20 20,100 100)', result:true},
{'wkt1':'LINESTRING (100 40,100 160,180 160)', 'wkt2':'LINESTRING (100 100,180 20,20 20,100 100)', result:true},
{'wkt1':'LINESTRING (20 100,100 100,180 100,100 180)', 'wkt2':'LINESTRING (100 100,180 20,20 20,100 100)', result:true},
{'wkt1':'LINESTRING (100 100,160 40)', 'wkt2':'LINESTRING (100 100,180 20,20 20,100 100)', result:true},
{'wkt1':'LINESTRING (100 100,180 20)', 'wkt2':'LINESTRING (100 100,180 20,20 20,100 100)', result:true},
{'wkt1':'LINESTRING (60 60,100 100,140 60)', 'wkt2':'LINESTRING (100 100,180 20,20 20,100 100)', result:true},
{'wkt1':'LINESTRING (100 100,190 10,190 100)', 'wkt2':'LINESTRING (100 100,180 20,20 20,100 100)', result:true},
{'wkt1':'LINESTRING (100 100,160 40,160 100)', 'wkt2':'LINESTRING (100 100,180 20,20 20,100 100)', result:true},
{'wkt1':'LINESTRING (60 140,160 40,160 140)', 'wkt2':'LINESTRING (100 100,180 20,20 20,100 100)', result:true},
{'wkt1':'LINESTRING (20 20,140 140)', 'wkt2':'LINESTRING (80 80,20 80,140 80,80 20,80 140)', result:true},
{'wkt1':'LINESTRING (20 20,140 140)', 'wkt2':'LINESTRING (80 80,20 80,140 80)', result:true},
{'wkt1':'LINESTRING (20 20,140 140)', 'wkt2':'LINESTRING (80 80,140 80,80 20,80 140)', result:true},
{'wkt1':'LINESTRING (20 20,140 140)', 'wkt2':'LINESTRING (80 80,20 80,140 80,80 20,80 80)', result:true},
{'wkt1':'LINESTRING (20 20,140 140)', 'wkt2':'LINESTRING (80 80,20 80,140 80,80 80)', result:true},
{'wkt1':'LINESTRING (20 20,140 140)', 'wkt2':'LINESTRING (80 80,20 80,20 140,140 20,80 20,80 80)', result:true},
{'wkt1':'LINESTRING (20 20,140 140)', 'wkt2':'LINESTRING (20 140,140 20,100 20,100 80)', result:true},
{'wkt1':'LINESTRING (20 20,140 140)', 'wkt2':'LINESTRING (140 80,20 80,120 80,80 20,80 140)', result:true},
{'wkt1':'LINESTRING (20 20,140 140)', 'wkt2':'LINESTRING (140 80,20 80,140 80)', result:true},
{'wkt1':'LINESTRING (20 20,140 140)', 'wkt2':'LINESTRING (140 80,20 80,80 140,80 20)', result:true},
{'wkt1':'LINESTRING (20 20,140 140)', 'wkt2':'LINESTRING (140 80,80 80,20 80,50 140,50 60)', result:true},
{'wkt1':'LINESTRING (20 20,140 140)', 'wkt2':'LINESTRING (140 80,20 80,120 80,80 20,80 80,80 140)', result:true},
{'wkt1':'LINESTRING (20 20,140 140)', 'wkt2':'LINESTRING (140 80,20 80,80 80,140 80)', result:true},
{'wkt1':'LINESTRING (20 20,140 140)', 'wkt2':'LINESTRING (140 80,20 80,80 140,80 80,80 20)', result:true},
{'wkt1':'LINESTRING (130 150,220 150,220 240)', 'wkt2':'LINESTRING (130 240,130 150,220 20,50 20,130 150)', result:true},
{'wkt1':'LINESTRING (30 150,130 150,250 150)', 'wkt2':'LINESTRING (130 240,130 150,220 20,50 20,130 150)', result:true},
{'wkt1':'LINESTRING (30 150,250 150)', 'wkt2':'LINESTRING (130 240,130 150,220 20,50 20,130 150)', result:true},
{'wkt1':'LINESTRING (30 150,130 150,250 150)', 'wkt2':'LINESTRING (130 240,130 20,30 20,130 150)', result:true},
{'wkt1':'LINESTRING (30 150,250 150)', 'wkt2':'LINESTRING (120 240,120 20,20 20,120 170)', result:true},
{'wkt1':'LINESTRING (200 200,20 20,200 20,110 110,20 200,110 200,110 110)', 'wkt2':'LINESTRING (110 110,200 110)', result:true},
{'wkt1':'LINESTRING (110 110,200 110)', 'wkt2':'LINESTRING (200 200,20 20,200 20,110 110,20 200,110 200,110 110)', result:true},
{'wkt1':'LINESTRING (20 110,200 110)', 'wkt2':'LINESTRING (200 200,20 20,200 20,110 110,20 200,110 200,110 110)', result:true},
{'wkt1':'LINESTRING (200 200,20 20,200 20,110 110,20 200,110 200,110 110)', 'wkt2':'LINESTRING (20 110,200 110)', result:true},
{'wkt1':'LINESTRING (90 200,90 130,110 110,150 200)', 'wkt2':'LINESTRING (200 200,20 20,200 20,20 200,20 130,90 130)', result:true},
{'wkt1':'LINESTRING (200 110,110 110,90 130,90 200)', 'wkt2':'LINESTRING (200 200,20 20,200 20,20 200,20 130,90 130)', result:true},
{'wkt1':'LINESTRING (80 80,150 80,210 80)', 'wkt2':'MULTILINESTRING ((20 20,140 140),(20 140,140 20))', result:true},
{'wkt1':'LINESTRING (40 80,160 200,260 20,40 80)', 'wkt2':'LINESTRING (40 80,160 200,260 20,40 80)', result:true},
{'wkt1':'LINESTRING (40 80,160 200,260 20,40 80)', 'wkt2':'LINESTRING (40 80,260 20,160 200,40 80)', result:true},
{'wkt1':'LINESTRING (40 80,160 200,260 20,40 80)', 'wkt2':'LINESTRING (260 20,40 80,160 200,260 20)', result:true},
{'wkt1':'LINESTRING (40 80,160 200,260 20,40 80)', 'wkt2':'LINESTRING (100 140,160 200,260 20,40 80,100 140)', result:true},
{'wkt1':'LINESTRING (100 100,180 20,20 20,100 100)', 'wkt2':'LINESTRING (100 100,180 180,20 180,100 100)', result:true},
{'wkt1':'LINESTRING (40 150,40 40,150 40,150 150,40 150)', 'wkt2':'LINESTRING (40 150,150 40,170 20,170 190,40 150)', result:true},
{'wkt1':'LINESTRING (100 100,180 20,20 20,100 100)', 'wkt2':'LINESTRING (180 100,20 100,100 180,180 100)', result:true},
{'wkt1':'LINESTRING (100 100,180 20,20 20,100 100)', 'wkt2':'LINESTRING (180 180,100 100,20 180,180 180)', result:true},
{'wkt1':'LINESTRING (20 180,100 100,20 20,20 180)', 'wkt2':'LINESTRING (100 20,100 180,180 100,100 20)', result:true},
{'wkt1':'LINESTRING (40 150,40 40,150 40,150 150,40 150)', 'wkt2':'LINESTRING (170 20,20 170,170 170,170 20)', result:true},
{'wkt1':'LINESTRING (40 150,40 40,150 40,150 150,40 150)', 'wkt2':'LINESTRING (40 150,150 150,90 210,40 150)', result:true},
{'wkt1':'LINESTRING (40 150,40 40,150 40,150 150,40 150)', 'wkt2':'LINESTRING (20 150,170 150,90 230,20 150)', result:true},
{'wkt1':'LINESTRING (40 150,40 40,150 40,150 150,40 150)', 'wkt2':'LINESTRING (40 150,150 150,150 40,20 40,20 150,40 150)', result:true},
{'wkt1':'LINESTRING (110 110,200 20,20 20,110 110)', 'wkt2':'LINESTRING (110 110,200 200,110 110,20 200,20 110,200 110)', result:true},
{'wkt1':'LINESTRING (110 110,200 20,20 20,110 110)', 'wkt2':'LINESTRING (110 110,20 110,200 110,50 110,110 170)', result:true},
{'wkt1':'LINESTRING (110 110,200 20,20 20,110 110)', 'wkt2':'LINESTRING (110 110,20 200,110 200,110 110,200 200)', result:true},
{'wkt1':'LINESTRING (110 110,200 20,20 20,110 110)', 'wkt2':'LINESTRING (200 20,20 200,200 200,110 110,110 40)', result:true},
{'wkt1':'LINESTRING (110 110,200 20,20 20,110 110)', 'wkt2':'LINESTRING (200 20,20 200,200 200,20 20)', result:true},
{'wkt1':'LINESTRING (110 110,20 110,110 20,20 20,110 110)', 'wkt2':'LINESTRING (110 110,200 200,110 200,200 110,110 110)', result:true},
{'wkt1':'LINESTRING (20 120,120 120,20 20,120 20,20 120)', 'wkt2':'LINESTRING (170 100,70 100,170 170,70 170,170 100)', result:true},
{'wkt1':'LINESTRING (20 110,110 110,20 20,110 20,20 110)', 'wkt2':'LINESTRING (110 160,70 110,60 160,20 130,110 160)', result:true},
{'wkt1':'LINESTRING (20 200,200 200,20 20,200 20,20 200)', 'wkt2':'LINESTRING (20 110,200 110,200 160,20 60,20 110)', result:true},
{'wkt1':'LINESTRING (20 110,110 110,20 20,110 20,20 110)', 'wkt2':'LINESTRING (200 200,110 110,200 110,110 200,200 200)', result:true},
{'wkt1':'LINESTRING (20 120,120 120,20 20,120 20,20 120)', 'wkt2':'LINESTRING (220 120,120 20,220 20,120 120,220 120)', result:true},
{'wkt1':'MULTILINESTRING ((70 20,20 90,70 170),(70 170,120 90,70 20))', 'wkt2':'MULTILINESTRING ((70 20,20 90,70 170),(70 170,120 90,70 20))', result:true},
{'wkt1':'MULTILINESTRING ((20 20,90 20,170 20),(90 20,90 80,90 140))', 'wkt2':'MULTILINESTRING ((20 20,90 20,170 20),(90 20,90 80,90 140))', result:true},
{'wkt1':'MULTILINESTRING ((20 20,90 20,170 20),(90 20,90 80,90 140))', 'wkt2':'MULTILINESTRING ((90 140,90 60,90 20),(170 20,130 20,20 20))', result:true},
{'wkt1':'MULTILINESTRING ((20 20,90 20,170 20),(90 20,90 80,90 140))', 'wkt2':'MULTILINESTRING ((90 20,170 100,170 140),(170 60,90 20,20 60),(130 100,130 60,90 20,50 90))', result:true},
{'wkt1':'MULTILINESTRING ((20 20,90 20,170 20),(90 20,90 80,90 140))', 'wkt2':'MULTILINESTRING ((90 20,170 100,170 140),(130 140,130 60,90 20,20 90,90 20,130 60,170 60))', result:true},
{'wkt1':'MULTILINESTRING ((20 20,90 20,170 20),(90 20,90 80,90 140))', 'wkt2':'MULTILINESTRING ((90 20,170 100,170 140),(170 60,90 20,20 60))', result:true},
{'wkt1':'MULTILINESTRING ((20 20,90 20,170 20),(90 20,90 80,90 140))', 'wkt2':'MULTILINESTRING ((90 20,170 100,170 140),(170 60,90 20,20 60),(130 100,90 20))', result:true},
{'wkt1':'MULTILINESTRING ((20 20,90 20,170 20),(90 20,90 80,90 140))', 'wkt2':'MULTILINESTRING ((90 20,170 100,170 140),(170 60,90 20,20 60),(120 100,170 100,90 20))', result:true},
{'wkt1':'MULTILINESTRING ((20 20,90 20,170 20),(90 20,90 80,90 140))', 'wkt2':'MULTILINESTRING ((90 20,170 100,170 140),(170 60,90 20,20 60),(120 100,170 100,90 20))', result:true},
{'wkt1':'MULTILINESTRING ((20 20,90 20,170 20),(90 20,90 80,90 140))', 'wkt2':'MULTILINESTRING ((90 20,170 100,170 140),(130 140,130 60,90 20,20 90,90 20))', result:true},
{'wkt1':'MULTILINESTRING ((20 20,90 20,170 20),(90 20,90 80,90 140))', 'wkt2':'MULTILINESTRING ((90 20,170 100,170 140),(170 60,90 20,20 60,20 140,90 20))', result:true},
{'wkt1':'MULTILINESTRING ((20 20,90 90,20 160),(90 160,90 20))', 'wkt2':'MULTILINESTRING ((160 160,90 90,160 20),(160 120,120 120,90 90,160 60))', result:true},
{'wkt1':'MULTILINESTRING ((20 20,90 90,20 160),(90 160,90 20))', 'wkt2':'MULTILINESTRING ((160 160,90 90,160 20),(160 120,120 120,90 90,120 60,160 60))', result:true},
{'wkt1':'MULTILINESTRING ((20 20,90 90,20 160),(90 160,90 20))', 'wkt2':'MULTILINESTRING ((160 160,90 90,160 20),(160 120,90 90,160 60))', result:true},
{'wkt1':'POINT (20 20)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:false},
{'wkt1':'POINT (70 170)', 'wkt2':'POLYGON ((110 230,80 160,20 160,20 20,200 20,200 160,140 160,110 230))', result:false},
{'wkt1':'POINT (110 130)', 'wkt2':'POLYGON ((20 160,80 160,110 100,140 160,200 160,200 20,20 20,20 160))', result:false},
{'wkt1':'POINT (100 70)', 'wkt2':'POLYGON ((20 150,100 150,40 50,170 50,110 150,190 150,190 20,20 20,20 150))', result:false},
{'wkt1':'POINT (100 70)', 'wkt2':'POLYGON ((20 150,100 150,40 50,160 50,100 150,180 150,180 20,20 20,20 150))', result:false},
{'wkt1':'POINT (60 120)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:true},
{'wkt1':'POINT (110 120)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:true},
{'wkt1':'POINT (160 120)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:true},
{'wkt1':'POINT (100 150)', 'wkt2':'POLYGON ((20 150,100 150,40 50,160 50,100 150,180 150,180 20,20 20,20 150))', result:true},
{'wkt1':'POINT (100 80)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:true},
{'wkt1':'POINT (60 160)', 'wkt2':'POLYGON ((190 190,360 20,20 20,190 190),(280 50,100 50,190 140,280 50))', result:false},
{'wkt1':'POINT (190 90)', 'wkt2':'POLYGON ((190 190,360 20,20 20,190 190),(280 50,100 50,190 140,280 50))', result:false},
{'wkt1':'POINT (190 190)', 'wkt2':'POLYGON ((190 190,360 20,20 20,190 190),(280 50,100 50,190 140,280 50))', result:true},
{'wkt1':'POINT (360 20)', 'wkt2':'POLYGON ((190 190,360 20,20 20,190 190),(280 50,100 50,190 140,280 50))', result:true},
{'wkt1':'POINT (130 130)', 'wkt2':'POLYGON ((190 190,360 20,20 20,190 190),(280 50,100 50,190 140,280 50))', result:true},
{'wkt1':'POINT (280 50)', 'wkt2':'POLYGON ((190 190,360 20,20 20,190 190),(280 50,100 50,190 140,280 50))', result:true},
{'wkt1':'POINT (150 100)', 'wkt2':'POLYGON ((190 190,360 20,20 20,190 190),(280 50,100 50,190 140,280 50))', result:true},
{'wkt1':'POINT (100 50)', 'wkt2':'POLYGON ((190 190,360 20,20 20,190 190),(280 50,100 50,190 140,280 50))', result:true},
{'wkt1':'POINT (140 120)', 'wkt2':'POLYGON ((190 190,360 20,20 20,190 190),(280 50,100 50,190 140,280 50))', result:true},
{'wkt1':'POINT (190 50)', 'wkt2':'POLYGON ((190 190,360 20,20 20,190 190),(90 50,150 110,190 50,90 50),(190 50,230 110,290 50,190 50))', result:true},
{'wkt1':'POINT (180 90)', 'wkt2':'POLYGON ((190 190,360 20,20 20,190 190),(180 140,180 40,80 40,180 140),(180 90,210 140,310 40,230 40,180 90))', result:true},
{'wkt1':'MULTIPOINT (20 80,110 160,20 160)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:false},
{'wkt1':'MULTIPOINT (20 80,60 120,20 160)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:true},
{'wkt1':'MULTIPOINT (10 80,110 170,110 120)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:true},
{'wkt1':'MULTIPOINT (10 80,110 170,160 120)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:true},
{'wkt1':'MULTIPOINT (20 120,60 120,110 120,160 120,200 120)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:true},
{'wkt1':'MULTIPOINT (60 120,110 120,160 120)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:true},
{'wkt1':'MULTIPOINT (60 120,160 120,160 40,60 40)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:true},
{'wkt1':'MULTIPOINT (20 150,60 120,110 80)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:true},
{'wkt1':'MULTIPOINT (110 80,160 120,200 160)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:true},
{'wkt1':'MULTIPOINT (110 80,110 120,110 160)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:true},
{'wkt1':'MULTIPOINT (110 170,110 80)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:true},
{'wkt1':'MULTIPOINT (60 120,160 120,110 80,110 170)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:true},
{'wkt1':'MULTIPOINT (90 80,130 80)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:true},
{'wkt1':'MULTIPOINT (60 120,160 120,110 80)', 'wkt2':'POLYGON ((60 120,60 40,160 40,160 120,60 120))', result:true},
{'wkt1':'MULTIPOINT (40 170,40 90,130 170)', 'wkt2':'POLYGON ((190 190,360 20,20 20,190 190),(280 50,100 50,190 140,280 50))', result:false},
{'wkt1':'MULTIPOINT (90 170,280 170,190 90)', 'wkt2':'POLYGON ((190 190,360 20,20 20,190 190),(280 50,100 50,190 140,280 50))', result:false},
{'wkt1':'MULTIPOINT (190 110,150 70,230 70)', 'wkt2':'POLYGON ((190 190,360 20,20 20,190 190),(280 50,100 50,190 140,280 50))', result:false},
{'wkt1':'POINT (100 100)', 'wkt2':'MULTIPOLYGON (((20 100,20 20,100 20,100 100,20 100)),((100 180,100 100,180 100,180 180,100 180)))', result:true},
{'wkt1':'POINT (20 100)', 'wkt2':'MULTIPOLYGON (((20 100,20 20,100 20,100 100,20 100)),((100 180,100 100,180 100,180 180,100 180)))', result:true},
{'wkt1':'POINT (60 100)', 'wkt2':'MULTIPOLYGON (((20 100,20 20,100 20,100 100,20 100)),((100 180,100 100,180 100,180 180,100 180)))', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'MULTIPOLYGON (((110 110,20 200,200 200,110 110),(110 110,80 180,140 180,110 110)),((110 110,20 20,200 20,110 110),(110 110,80 40,140 40,110 110)))', result:true},
{'wkt1':'POINT (110 200)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:false},
{'wkt1':'POINT (90 80)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:true},
{'wkt1':'POINT (340 240)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:true},
{'wkt1':'POINT (230 150)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:true},
{'wkt1':'POINT (160 150)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:true},
{'wkt1':'POINT (90 150)', 'wkt2':'LINESTRING (150 150,20 20,280 20,150 150)', result:false},
{'wkt1':'POINT (150 80)', 'wkt2':'LINESTRING (150 150,20 20,280 20,150 150)', result:false},
{'wkt1':'POINT (150 150)', 'wkt2':'LINESTRING (150 150,20 20,280 20,150 150)', result:true},
{'wkt1':'POINT (100 20)', 'wkt2':'LINESTRING (150 150,20 20,280 20,150 150)', result:true},
{'wkt1':'POINT (20 20)', 'wkt2':'LINESTRING (150 150,20 20,280 20,150 150)', result:true},
{'wkt1':'POINT (220 220)', 'wkt2':'LINESTRING (110 110,220 20,20 20,110 110,220 220)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 110,220 20,20 20,110 110,220 220)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 110,220 20,20 20,220 220)', result:true},
{'wkt1':'POINT (110 20)', 'wkt2':'LINESTRING (110 110,220 20,20 20,220 220)', result:true},
{'wkt1':'POINT (220 20)', 'wkt2':'LINESTRING (110 110,220 20,20 20,220 220)', result:true},
{'wkt1':'POINT (110 20)', 'wkt2':'LINESTRING (220 220,20 20,220 20,110 110)', result:true},
{'wkt1':'POINT (20 20)', 'wkt2':'LINESTRING (220 220,20 20,220 20,110 110)', result:true},
{'wkt1':'POINT (20 110)', 'wkt2':'LINESTRING (20 200,20 20,110 20,20 110,110 200)', result:true},
{'wkt1':'POINT (20 200)', 'wkt2':'LINESTRING (20 200,200 20,20 20,200 200)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (20 200,200 20,140 20,140 80,80 140,20 140)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (20 200,200 20,20 20,200 200)', result:true},
{'wkt1':'POINT (80 140)', 'wkt2':'LINESTRING (20 200,110 110,200 20,140 20,140 80,110 110,80 140,20 140)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (20 200,110 110,200 20,140 20,140 80,110 110,80 140,20 140)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (20 200,200 20,140 20,140 80,110 110,80 140,20 140)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (20 200,110 110,200 20,20 20,110 110,200 200)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (20 200,200 20,20 20,110 110,200 200)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (20 200,110 110,20 20,200 20,110 110,200 200)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 110,110 200,20 200,110 110,200 20,140 20,140 80,110 110,80 140,20 140)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 110,110 200,20 200,200 20,140 20,140 80,110 110,80 140,20 140)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 110,110 200,20 200,200 20,140 20,140 80,80 140,20 140)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 110,110 200,20 200,110 110,200 20,20 20,110 110,200 200)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 110,110 200,20 200,200 20,20 20,110 110,200 200)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 110,110 200,20 200,200 20,20 20,200 200)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 110,110 200,20 200,110 110,20 20,200 20,110 110,200 200)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 110,110 200,20 200,200 20,200 110,110 110,200 200)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (200 200,110 110,20 20,200 20,110 110,20 200,110 200,110 110)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (200 200,20 20,200 20,110 110,20 200,110 200,110 110)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (200 200,20 20,200 20,20 200,110 200,110 110)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (200 200,110 110,200 20,20 20,110 110,20 200,110 200,110 110)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (200 200,20 20,20 110,110 110,20 200,110 200,110 110)', result:true},
{'wkt1':'POINT (110 160)', 'wkt2':'LINESTRING (110 160,200 250,110 250,110 160,110 110,110 20,20 20,110 110)', result:true},
{'wkt1':'POINT (110 160)', 'wkt2':'LINESTRING (110 160,200 250,110 250,110 110,110 20,20 20,110 110)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 160,200 250,110 250,110 160,110 110,110 20,20 20,110 110)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 160,200 250,110 250,110 160,110 20,20 20,110 110)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 110,200 200,110 200,110 110,110 20,20 20,110 110)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 110,200 200,110 200,110 20,20 20,110 110)', result:true},
{'wkt1':'POINT (140 200)', 'wkt2':'LINESTRING (110 110,200 200,110 200,110 110,110 20,20 20,110 110)', result:true},
{'wkt1':'POINT (110 200)', 'wkt2':'LINESTRING (110 110,200 200,110 200,110 110,110 20,20 20,110 110)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 110,200 200,110 200,110 110,110 20,200 20,110 110)', result:true},
{'wkt1':'POINT (140 200)', 'wkt2':'LINESTRING (110 110,200 200,110 200,110 110,110 20,200 20,110 110)', result:true},
{'wkt1':'POINT (110 200)', 'wkt2':'LINESTRING (110 110,200 200,110 200,110 110,110 20,200 20,110 110)', result:true},
{'wkt1':'POINT (90 130)', 'wkt2':'LINESTRING (90 130,20 130,20 200,90 130,200 20,20 20,200 200)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (90 130,20 130,20 200,90 130,200 20,20 20,200 200)', result:true},
{'wkt1':'POINT (90 130)', 'wkt2':'LINESTRING (90 130,20 130,20 200,200 20,20 20,200 200)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (90 130,20 130,20 200,200 20,20 20,200 200)', result:true},
{'wkt1':'POINT (90 130)', 'wkt2':'LINESTRING (200 200,20 20,200 20,90 130,20 200,20 130,90 130)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (200 200,20 20,200 20,90 130,20 200,20 130,90 130)', result:true},
{'wkt1':'POINT (90 130)', 'wkt2':'LINESTRING (200 200,20 20,200 20,20 200,20 130,90 130)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (200 200,20 20,200 20,20 200,20 130,90 130)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 110,20 130,20 200,110 110,200 20,20 20,110 110,200 200,200 130,110 110)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 110,20 130,20 200,200 20,20 20,200 200,200 130,110 110)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 110,80 200,20 200,110 110,200 20,20 20,110 110,200 200,140 200,110 110)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 110,80 200,20 200,200 20,20 20,200 200,140 200,110 110)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (200 200,20 20,200 20,20 200,200 200)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (200 200,110 110,20 20,200 20,110 110,20 200,200 200)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (200 200,110 110,200 20,20 20,110 110,20 200,200 200)', result:true},
{'wkt1':'POINT (90 130)', 'wkt2':'LINESTRING (90 130,20 130,20 200,90 130,110 110,200 20,20 20,110 110,200 200,90 130)', result:true},
{'wkt1':'POINT (90 130)', 'wkt2':'LINESTRING (90 130,20 130,20 200,110 110,200 20,20 20,110 110,200 200,90 130)', result:true},
{'wkt1':'POINT (90 130)', 'wkt2':'LINESTRING (90 130,90 200,20 200,90 130,110 110,200 20,20 20,110 110,200 200,90 130)', result:true},
{'wkt1':'POINT (90 130)', 'wkt2':'LINESTRING (90 130,90 200,20 200,200 20,20 20,200 200,90 130)', result:true},
{'wkt1':'POINT (90 130)', 'wkt2':'LINESTRING (90 130,90 200,20 200,110 110,200 20,20 20,110 110,200 200,90 130)', result:true},
{'wkt1':'POINT (90 130)', 'wkt2':'LINESTRING (90 130,90 200,20 200,200 20,20 20,200 200,90 130)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (90 130,90 200,20 200,200 20,20 20,200 200,90 130)', result:true},
{'wkt1':'POINT (110 200)', 'wkt2':'LINESTRING (110 200,110 110,20 20,200 20,110 110,110 200,200 200)', result:true},
{'wkt1':'POINT (110 150)', 'wkt2':'LINESTRING (110 200,110 110,20 20,200 20,110 110,110 200,200 200)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 200,110 110,20 20,200 20,110 110,110 200,200 200)', result:true},
{'wkt1':'POINT (110 200)', 'wkt2':'LINESTRING (110 200,110 110,20 20,200 20,110 110,110 200)', result:true},
{'wkt1':'POINT (110 150)', 'wkt2':'LINESTRING (110 200,110 110,20 20,200 20,110 110,110 200)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (110 200,110 110,20 20,200 20,110 110,110 200)', result:true},
{'wkt1':'POINT (110 150)', 'wkt2':'LINESTRING (20 200,110 200,110 110,20 20,200 20,110 110,110 200,200 200)', result:true},
{'wkt1':'POINT (110 110)', 'wkt2':'LINESTRING (20 200,110 200,110 110,20 20,200 20,110 110,110 200,200 200)', result:true},
{'wkt1':'POINT (110 200)', 'wkt2':'LINESTRING (20 200,110 200,110 110,20 20,200 20,110 110,110 200,200 200)', result:true},
{'wkt1':'MULTIPOINT (50 250,90 220,130 190)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:false},
{'wkt1':'MULTIPOINT (180 180,230 130,280 80)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:false},
{'wkt1':'MULTIPOINT (50 120,90 80,130 40)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:true},
{'wkt1':'MULTIPOINT (300 280,340 240,380 200)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:true},
{'wkt1':'MULTIPOINT (230 150,260 120,290 90)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:true},
{'wkt1':'MULTIPOINT (200 190,240 150,270 110)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:true},
{'wkt1':'MULTIPOINT (160 150,190 120,220 90)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:true},
{'wkt1':'MULTIPOINT (120 190,160 150,200 110)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:true},
{'wkt1':'MULTIPOINT (90 80,160 150,340 240)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:true},
{'wkt1':'MULTIPOINT (90 80,160 150,300 150)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:true},
{'wkt1':'MULTIPOINT (90 80,160 150,240 150)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:true},
{'wkt1':'MULTIPOINT (90 80,130 120,210 150)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:true},
{'wkt1':'MULTIPOINT (130 120,210 150,340 200)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:true},
{'wkt1':'MULTIPOINT (160 150,240 150,340 210)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:true},
{'wkt1':'MULTIPOINT (160 150,300 150,340 150)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:true},
{'wkt1':'MULTIPOINT (160 150,240 150,340 240)', 'wkt2':'LINESTRING (90 80,160 150,300 150,340 150,340 240)', result:true},
{'wkt1':'POINT (20 20)', 'wkt2':'POINT (20 20)', result:true},
{'wkt1':'POINT (20 20)', 'wkt2':'POINT (40 60)', result:false},
{'wkt1':'POINT (40 40)', 'wkt2':'MULTIPOINT (20 20,80 80,20 120)', result:false},
{'wkt1':'POINT (20 20)', 'wkt2':'MULTIPOINT (20 20,80 80,20 120)', result:true},
{'wkt1':'MULTIPOINT (40 40,80 60,120 100)', 'wkt2':'MULTIPOINT (40 40,80 60,120 100)', result:true},
{'wkt1':'MULTIPOINT (40 40,80 60,120 100)', 'wkt2':'MULTIPOINT (40 40,120 100,80 60)', result:true},
{'wkt1':'MULTIPOINT (40 40,60 100,100 60,120 120)', 'wkt2':'MULTIPOINT (20 120,60 60,100 100,140 40)', result:false},
{'wkt1':'MULTIPOINT (20 20,80 70,140 120,200 170)', 'wkt2':'MULTIPOINT (20 20,80 70,140 120,200 170)', result:true},
{'wkt1':'MULTIPOINT (20 20,140 120,80 70,200 170)', 'wkt2':'MULTIPOINT (80 70,20 20,200 170,140 120)', result:true},
{'wkt1':'MULTIPOINT (20 20,80 70,140 120,200 170)', 'wkt2':'MULTIPOINT (80 70,140 120)', result:true},
{'wkt1':'MULTIPOINT (80 70,20 20,200 170,140 120)', 'wkt2':'MULTIPOINT (140 120,80 70)', result:true},
{'wkt1':'MULTIPOINT (80 70,20 20,200 170,140 120)', 'wkt2':'MULTIPOINT (80 170,140 120,200 80)', result:true},
{'wkt1':'MULTIPOINT (80 70,20 20,200 170,140 120)', 'wkt2':'MULTIPOINT (80 170,140 120,200 80,80 70)', result:true},
{'wkt1':'POLYGON((-8239529.462853361 4980952.065110421,-8224242.057199065 4980952.065110421,-8224242.057199064 4988844.188279452,-8239529.462853361 4988844.188279452,-8239529.462853361 4980952.065110421))', 'wkt2':'POINT(-8225445.94039435  4982695.78481786)', result:true},
{'wkt1':'POLYGON((-8239529.462853361 4980952.065110421,-8224242.057199065 4980952.065110421,-8224242.057199064 4988844.188279452,-8239529.462853361 4988844.188279452,-8239529.462853361 4980952.065110421))', 'wkt2':'POINT(-8224242.0571985  4982695.78481786)', result:false},
{'wkt1':'POLYGON((-8239529.462853361 4980952.065110421,-8224242.057199065 4980952.065110421,-8224242.057199064 4988844.188279452,-8239529.462853361 4988844.188279452,-8239529.462853361 4980952.065110421))', 'wkt2':'POINT(-8224242.0571995  4982695.78481786)', result:true}
];
