# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class WorkflowRunAction(SubResource):
    """WorkflowRunAction

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Gets or sets the resource id.
    :type id: str
    :ivar start_time: Gets the start time.
    :vartype start_time: datetime
    :ivar end_time: Gets the end time.
    :vartype end_time: datetime
    :ivar status: Gets the status. Possible values include: 'NotSpecified',
     'Paused', 'Running', 'Waiting', 'Succeeded', 'Skipped', 'Suspended',
     'Cancelled', 'Failed', 'Faulted', 'TimedOut', 'Aborted'
    :vartype status: str
    :ivar code: Gets the code.
    :vartype code: str
    :ivar error: Gets the error.
    :vartype error: object
    :ivar tracking_id: Gets the trackingId.
    :vartype tracking_id: str
    :ivar inputs_link: Gets the link to inputs.
    :vartype inputs_link: :class:`ContentLink
     <azure.mgmt.logic.models.ContentLink>`
    :ivar outputs_link: Gets the link to outputs.
    :vartype outputs_link: :class:`ContentLink
     <azure.mgmt.logic.models.ContentLink>`
    :ivar name: Gets the workflow run action name.
    :vartype name: str
    :ivar type: Gets the workflow run action type.
    :vartype type: str
    """ 

    _validation = {
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'status': {'readonly': True},
        'code': {'readonly': True},
        'error': {'readonly': True},
        'tracking_id': {'readonly': True},
        'inputs_link': {'readonly': True},
        'outputs_link': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'WorkflowStatus'},
        'code': {'key': 'properties.code', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'object'},
        'tracking_id': {'key': 'properties.trackingId', 'type': 'str'},
        'inputs_link': {'key': 'properties.inputsLink', 'type': 'ContentLink'},
        'outputs_link': {'key': 'properties.outputsLink', 'type': 'ContentLink'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, id=None):
        super(WorkflowRunAction, self).__init__(id=id)
        self.start_time = None
        self.end_time = None
        self.status = None
        self.code = None
        self.error = None
        self.tracking_id = None
        self.inputs_link = None
        self.outputs_link = None
        self.name = None
        self.type = None
