# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CorsRule(Model):
    """Specifies a CORS rule for the Blob service.

    All required parameters must be populated in order to send to Azure.

    :param allowed_origins: Required. Required if CorsRule element is present.
     A list of origin domains that will be allowed via CORS, or "*" to allow
     all domains
    :type allowed_origins: list[str]
    :param allowed_methods: Required. Required if CorsRule element is present.
     A list of HTTP methods that are allowed to be executed by the origin.
    :type allowed_methods: list[str]
    :param max_age_in_seconds: Required. Required if CorsRule element is
     present. The number of seconds that the client/browser should cache a
     preflight response.
    :type max_age_in_seconds: int
    :param exposed_headers: Required. Required if CorsRule element is present.
     A list of response headers to expose to CORS clients.
    :type exposed_headers: list[str]
    :param allowed_headers: Required. Required if CorsRule element is present.
     A list of headers allowed to be part of the cross-origin request.
    :type allowed_headers: list[str]
    """

    _validation = {
        'allowed_origins': {'required': True},
        'allowed_methods': {'required': True},
        'max_age_in_seconds': {'required': True},
        'exposed_headers': {'required': True},
        'allowed_headers': {'required': True},
    }

    _attribute_map = {
        'allowed_origins': {'key': 'allowedOrigins', 'type': '[str]'},
        'allowed_methods': {'key': 'allowedMethods', 'type': '[str]'},
        'max_age_in_seconds': {'key': 'maxAgeInSeconds', 'type': 'int'},
        'exposed_headers': {'key': 'exposedHeaders', 'type': '[str]'},
        'allowed_headers': {'key': 'allowedHeaders', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(CorsRule, self).__init__(**kwargs)
        self.allowed_origins = kwargs.get('allowed_origins', None)
        self.allowed_methods = kwargs.get('allowed_methods', None)
        self.max_age_in_seconds = kwargs.get('max_age_in_seconds', None)
        self.exposed_headers = kwargs.get('exposed_headers', None)
        self.allowed_headers = kwargs.get('allowed_headers', None)
