# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobAction(Model):
    """JobAction

    :param str type: Gets or sets the job action type. Possible values
     include: 'Http', 'Https', 'StorageQueue', 'ServiceBusQueue',
     'ServiceBusTopic'
    :param HttpRequest request: Gets or sets the http requests.
    :param StorageQueueMessage queue_message: Gets or sets the storage queue
     message.
    :param ServiceBusQueueMessage service_bus_queue_message: Gets or sets the
     service bus queue message.
    :param ServiceBusTopicMessage service_bus_topic_message: Gets or sets the
     service bus topic message.
    :param RetryPolicy retry_policy: Gets or sets the retry policy.
    :param JobErrorAction error_action: Gets or sets the error action.
    """ 

    _attribute_map = {
        'type': {'key': 'type', 'type': 'JobActionType'},
        'request': {'key': 'request', 'type': 'HttpRequest'},
        'queue_message': {'key': 'queueMessage', 'type': 'StorageQueueMessage'},
        'service_bus_queue_message': {'key': 'serviceBusQueueMessage', 'type': 'ServiceBusQueueMessage'},
        'service_bus_topic_message': {'key': 'serviceBusTopicMessage', 'type': 'ServiceBusTopicMessage'},
        'retry_policy': {'key': 'retryPolicy', 'type': 'RetryPolicy'},
        'error_action': {'key': 'errorAction', 'type': 'JobErrorAction'},
    }

    def __init__(self, type=None, request=None, queue_message=None, service_bus_queue_message=None, service_bus_topic_message=None, retry_policy=None, error_action=None, **kwargs):
        self.type = type
        self.request = request
        self.queue_message = queue_message
        self.service_bus_queue_message = service_bus_queue_message
        self.service_bus_topic_message = service_bus_topic_message
        self.retry_policy = retry_policy
        self.error_action = error_action
