# Copyright 2020 StrongDM Inc
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import role_attachments_pb2 as role__attachments__pb2


class RoleAttachmentsStub(object):
    """RoleAttachments represent relationships between composite roles and the roles
    that make up those composite roles. When a composite role is attached to another
    role, the permissions granted to members of the composite role are augmented to
    include the permissions granted to members of the attached role.

    Deprecated: use multi-role via AccountAttachments instead.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Create = channel.unary_unary(
                '/v1.RoleAttachments/Create',
                request_serializer=role__attachments__pb2.RoleAttachmentCreateRequest.SerializeToString,
                response_deserializer=role__attachments__pb2.RoleAttachmentCreateResponse.FromString,
                )
        self.Get = channel.unary_unary(
                '/v1.RoleAttachments/Get',
                request_serializer=role__attachments__pb2.RoleAttachmentGetRequest.SerializeToString,
                response_deserializer=role__attachments__pb2.RoleAttachmentGetResponse.FromString,
                )
        self.Delete = channel.unary_unary(
                '/v1.RoleAttachments/Delete',
                request_serializer=role__attachments__pb2.RoleAttachmentDeleteRequest.SerializeToString,
                response_deserializer=role__attachments__pb2.RoleAttachmentDeleteResponse.FromString,
                )
        self.List = channel.unary_unary(
                '/v1.RoleAttachments/List',
                request_serializer=role__attachments__pb2.RoleAttachmentListRequest.SerializeToString,
                response_deserializer=role__attachments__pb2.RoleAttachmentListResponse.FromString,
                )


class RoleAttachmentsServicer(object):
    """RoleAttachments represent relationships between composite roles and the roles
    that make up those composite roles. When a composite role is attached to another
    role, the permissions granted to members of the composite role are augmented to
    include the permissions granted to members of the attached role.

    Deprecated: use multi-role via AccountAttachments instead.
    """

    def Create(self, request, context):
        """Create registers a new RoleAttachment.

        Deprecated: use multi-role via AccountAttachments instead.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Get(self, request, context):
        """Get reads one RoleAttachment by ID.

        Deprecated: use multi-role via AccountAttachments instead.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Delete(self, request, context):
        """Delete removes a RoleAttachment by ID.

        Deprecated: use multi-role via AccountAttachments instead.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def List(self, request, context):
        """List gets a list of RoleAttachments matching a given set of criteria.

        Deprecated: use multi-role via AccountAttachments instead.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_RoleAttachmentsServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Create': grpc.unary_unary_rpc_method_handler(
                    servicer.Create,
                    request_deserializer=role__attachments__pb2.RoleAttachmentCreateRequest.FromString,
                    response_serializer=role__attachments__pb2.RoleAttachmentCreateResponse.SerializeToString,
            ),
            'Get': grpc.unary_unary_rpc_method_handler(
                    servicer.Get,
                    request_deserializer=role__attachments__pb2.RoleAttachmentGetRequest.FromString,
                    response_serializer=role__attachments__pb2.RoleAttachmentGetResponse.SerializeToString,
            ),
            'Delete': grpc.unary_unary_rpc_method_handler(
                    servicer.Delete,
                    request_deserializer=role__attachments__pb2.RoleAttachmentDeleteRequest.FromString,
                    response_serializer=role__attachments__pb2.RoleAttachmentDeleteResponse.SerializeToString,
            ),
            'List': grpc.unary_unary_rpc_method_handler(
                    servicer.List,
                    request_deserializer=role__attachments__pb2.RoleAttachmentListRequest.FromString,
                    response_serializer=role__attachments__pb2.RoleAttachmentListResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'v1.RoleAttachments', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class RoleAttachments(object):
    """RoleAttachments represent relationships between composite roles and the roles
    that make up those composite roles. When a composite role is attached to another
    role, the permissions granted to members of the composite role are augmented to
    include the permissions granted to members of the attached role.

    Deprecated: use multi-role via AccountAttachments instead.
    """

    @staticmethod
    def Create(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.RoleAttachments/Create',
            role__attachments__pb2.RoleAttachmentCreateRequest.SerializeToString,
            role__attachments__pb2.RoleAttachmentCreateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Get(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.RoleAttachments/Get',
            role__attachments__pb2.RoleAttachmentGetRequest.SerializeToString,
            role__attachments__pb2.RoleAttachmentGetResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Delete(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.RoleAttachments/Delete',
            role__attachments__pb2.RoleAttachmentDeleteRequest.SerializeToString,
            role__attachments__pb2.RoleAttachmentDeleteResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def List(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.RoleAttachments/List',
            role__attachments__pb2.RoleAttachmentListRequest.SerializeToString,
            role__attachments__pb2.RoleAttachmentListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
