/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.library;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgx.graphviz.driver.Driver;
import oracle.pgx.graphviz.formatter.EnhancedResultSet;
import oracle.pgx.graphviz.formatter.Formatter;
import oracle.pgx.graphviz.formatter.Pair;
import oracle.pgx.graphviz.library.QueryEnhancer;
import oracle.pgx.graphviz.library.QueryEnhancerUtils;
import oracle.pgx.graphviz.library.TableOnlyResultSet;
import oracle.pgx.graphviz.library.enhancer.Enhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedQueryEnhancer<T>
extends QueryEnhancer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(CachedQueryEnhancer.class);
    private static final String RESULT_SET_ID = "resultSetId";
    private final Cache<String, TableOnlyResultSet> cache;
    public static final String NUM_CACHED_RESULTSETS = "num_cached_resultsets";
    public static final String RESULTSET_EXPIRATION_TIME_SECS = "resultset_expiration_time_secs";
    public static final String RESULT_SET_SIZE_CACHE_THRESHHOLD = "resultset_expiration_time_mins";
    public static final int RESULT_SET_SIZE_CACHE_THRESHHOLD_DEFAULT = 100;
    public static final int RESULTSET_EXPIRATION_TIME_SECS_DEFAULT = 300;
    public static final int NUM_CACHED_RESULTSETS_DEFAULT = 1;

    private static int getIntPropertyOrDefault(Map<String, Object> properties, String key, int defaultValue) {
        try {
            return (int)Double.parseDouble(properties.getOrDefault(key, "").toString());
        }
        catch (NumberFormatException n) {
            return defaultValue;
        }
    }

    public CachedQueryEnhancer(@Nonnull Driver driver, @Nonnull Formatter<T> formatter, Map<String, Object> properties) throws PgqlException {
        super(driver, formatter);
        int numResultSets = CachedQueryEnhancer.getIntPropertyOrDefault(properties, NUM_CACHED_RESULTSETS, 1);
        int expirationTime = CachedQueryEnhancer.getIntPropertyOrDefault(properties, RESULTSET_EXPIRATION_TIME_SECS, 300);
        LOG.info("Using CachedQueryEnhancer with {} cached results set(s) and expiration time of {} seconds", (Object)numResultSets, (Object)expirationTime);
        RemovalListener<String, TableOnlyResultSet> listener = new RemovalListener<String, TableOnlyResultSet>(){

            public void onRemoval(RemovalNotification<String, TableOnlyResultSet> removal) {
                if (removal.wasEvicted()) {
                    String cause = removal.getCause().name();
                    LOG.info("Closing result set {}. (Reason: {})", removal.getKey(), (Object)cause);
                    try {
                        ((TableOnlyResultSet)removal.getValue()).resultSet.close();
                    }
                    catch (PgqlException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.cache = CacheBuilder.newBuilder().expireAfterAccess((long)expirationTime, TimeUnit.SECONDS).maximumSize((long)numResultSets).removalListener((RemovalListener)listener).recordStats().build();
    }

    @Override
    protected T query(@Nonnull GraphQuery graphQuery, Map<String, Object> properties) throws PgqlException, IOException, SQLException {
        TableOnlyResultSet trs = null;
        String queryString = graphQuery.toString();
        if (properties.containsKey("action") && properties.containsKey(RESULT_SET_ID) && properties.get("action").equals("paginate")) {
            trs = (TableOnlyResultSet)this.cache.getIfPresent(properties.get(RESULT_SET_ID));
        }
        if (trs == null) {
            trs = this.queryResultSet(queryString, properties);
            if (trs.getNumResults() > (long)CachedQueryEnhancer.getIntPropertyOrDefault(properties, RESULT_SET_SIZE_CACHE_THRESHHOLD, 100)) {
                this.cache.put((Object)trs.getResultSetId(), (Object)trs);
            }
            this.cache.cleanUp();
            LOG.info("Result set ID {} for query '{}' was not cached.", properties.get(RESULT_SET_ID), (Object)queryString);
        } else {
            LOG.info("Result set ID {} for query '{}' loaded from cache.", properties.get(RESULT_SET_ID), (Object)queryString);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cumulative statistics for cached result sets {}", (Object)this.cache.stats());
        }
        return (T)super.getFormatter().format((EnhancedResultSet)trs, properties);
    }

    private TableOnlyResultSet queryResultSet(@Nonnull String queryString, Map<String, Object> properties) throws PgqlException, SQLException {
        GraphQuery graphQuery = QueryEnhancerUtils.parseQuery(queryString, null, null);
        Enhancer enhancer = this.createEnhancer(graphQuery, properties);
        properties.put("enhancer", enhancer);
        String graphName = graphQuery.getGraphName() == null ? null : graphQuery.getGraphName().getName();
        String schema = graphQuery.getGraphName() == null ? null : graphQuery.getGraphName().getSchemaName();
        Pair<Boolean, String> canViz = enhancer.checkIfVisualizable();
        if (((Boolean)canViz.getFirst()).booleanValue()) {
            return (TableOnlyResultSet)this.driver.query(queryString, graphName, schema, properties);
        }
        String parsedQueryString = graphQuery.toString();
        return (TableOnlyResultSet)this.driver.query(parsedQueryString, graphName, schema, properties);
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.cache.invalidateAll();
    }
}

