/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import oracle.pgql.lang.PgqlVersion;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.PgqlStatement;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgql.lang.ir.StatementType;
import oracle.pgql.lang.metadata.AbstractMetadataProvider;
import oracle.pgql.lang.metadata.GraphSchema;
import oracle.pgql.lang.metadata.Label;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;

public class PgqlResult {
    private final String queryString;
    private final String errorMessages;
    private final boolean queryValid;
    private final PgqlStatement pgqlStatement;
    private final ISpoofaxParseUnit spoofaxParseUnit;
    private final PgqlVersion pgqlVersion;
    private final int bindVariableCount;
    private final boolean querySelectsAllProperties;
    private final AbstractMetadataProvider metadataProvider;

    public PgqlResult(String queryString, boolean queryValid, String messages, PgqlStatement pgqlStatement, ISpoofaxParseUnit spoofaxParseUnit, PgqlVersion pgqlVersion, int bindVariableCount, boolean querySelectsAllProperties, AbstractMetadataProvider metadataProvider) {
        this.queryString = queryString;
        this.errorMessages = messages;
        this.queryValid = queryValid;
        this.pgqlStatement = pgqlStatement;
        this.spoofaxParseUnit = spoofaxParseUnit;
        this.pgqlVersion = pgqlVersion;
        this.bindVariableCount = bindVariableCount;
        this.querySelectsAllProperties = querySelectsAllProperties;
        this.metadataProvider = metadataProvider;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public boolean isQueryValid() {
        return this.queryValid;
    }

    public String getErrorMessages() {
        return this.errorMessages;
    }

    public GraphQuery getGraphQuery() {
        if (this.pgqlStatement == null) {
            return null;
        }
        if (this.pgqlStatement.getStatementType() == StatementType.SELECT || this.pgqlStatement.getStatementType() == StatementType.GRAPH_MODIFY) {
            return (GraphQuery)this.pgqlStatement;
        }
        throw new IllegalStateException("Use getStatement() instead of getGraphQuery() if statment is not a SELECT or graph INSERT/UPDATE/DELETE query");
    }

    public PgqlStatement getPgqlStatement() {
        return this.pgqlStatement;
    }

    public PgqlVersion getPgqlVersion() {
        return this.pgqlVersion;
    }

    public int getBindVariableCount() {
        return this.bindVariableCount;
    }

    public boolean querySelectsAllProperties() {
        return this.querySelectsAllProperties;
    }

    public List<String> getAllProperties(QueryVariable vertexOrEdge) {
        if (this.pgqlStatement.getStatementType() != StatementType.SELECT) {
            throw new IllegalStateException("SELECT query expected but was " + this.pgqlStatement.getStatementType());
        }
        if (this.metadataProvider == null || this.metadataProvider.getGraphSchema() == null) {
            throw new IllegalStateException("Graph schema was not provided to the parser");
        }
        boolean isVertex = vertexOrEdge.getVariableType() == QueryVariable.VariableType.VERTEX;
        List<String> result = null;
        for (QueryExpression exp : this.getGraphQuery().getGraphPattern().getConstraints()) {
            if (!PgqlUtils.isHasLabelFunctionForVar((QueryExpression)exp, (QueryVariable)vertexOrEdge)) continue;
            List<String> properties = this.getAllProperties(exp, isVertex);
            if (result == null) {
                result = properties;
                continue;
            }
            result.retainAll(properties);
        }
        if (result == null) {
            List<? extends Label> labels = this.getLabels(isVertex);
            LinkedHashSet properties = new LinkedHashSet();
            for (Label label : labels) {
                properties.addAll(label.getProperties().stream().map(p -> p.getName()).collect(Collectors.toList()));
            }
            result = new ArrayList<String>(properties);
        }
        return result;
    }

    private List<String> getAllProperties(QueryExpression exp, boolean isVertex) {
        switch (exp.getExpType()) {
            case FUNCTION_CALL: {
                return this.getAllProperties((QueryExpression.FunctionCall)exp, isVertex);
            }
            case OR: {
                return this.getAllProperties((QueryExpression.LogicalExpression.Or)exp, isVertex);
            }
        }
        throw new IllegalStateException("Unsupported expression type " + this.pgqlStatement.getStatementType());
    }

    private List<String> getAllProperties(QueryExpression.FunctionCall functionCall, boolean isVertex) {
        String label = (String)((QueryExpression.Constant.ConstString)functionCall.getArgs().get(1)).getValue();
        List<? extends Label> labels = this.getLabels(isVertex);
        for (Label label2 : labels) {
            if (!label2.getLabel().equals(label)) continue;
            return label2.getProperties().stream().map(p -> p.getName()).collect(Collectors.toList());
        }
        for (Label label3 : labels) {
            if (!label3.getLabel().toUpperCase().equals(label)) continue;
            return label3.getProperties().stream().map(p -> p.getName()).collect(Collectors.toList());
        }
        throw new IllegalStateException("Label " + label + " does not exist");
    }

    private List<String> getAllProperties(QueryExpression.LogicalExpression.Or or, boolean isVertex) {
        List<String> result = this.getAllProperties(or.getExp1(), isVertex);
        result.addAll(this.getAllProperties(or.getExp2(), isVertex));
        return result;
    }

    private List<? extends Label> getLabels(boolean isVertex) {
        SchemaQualifiedName graphName = this.getGraphQuery().getGraphName();
        GraphSchema graphSchema = graphName == null ? (GraphSchema)this.metadataProvider.getGraphSchema().get() : (GraphSchema)this.metadataProvider.getGraphSchema(graphName).get();
        List labels = isVertex ? graphSchema.getVertexLabels() : graphSchema.getEdgeLabels();
        return labels;
    }

    protected ISpoofaxParseUnit getSpoofaxParseUnit() {
        return this.spoofaxParseUnit;
    }
}

