/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.pgx.common.Order;
import oracle.pgx.common.types.Type;
import oracle.pgx.common.types.Types;

public enum CollectionType implements Type
{
    ORDER(Order.class),
    SEQUENCE(List.class),
    SET(Set.class);

    private static final Map<String, CollectionType> ALIASES;
    private final Class<?> typeClass;

    @JsonCreator
    public static CollectionType parseCollectionType(String input) {
        return Types.parse(CollectionType.class, input, ALIASES);
    }

    public static CollectionType getTypeFor(Class<?> typeClass) {
        return (CollectionType)Types.getByTypeClass((Type[])CollectionType.values(), typeClass);
    }

    private CollectionType(Class<?> typeClass) {
        this.typeClass = typeClass;
    }

    @Override
    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    @Override
    @JsonValue
    public String toKey() {
        return this.name().toLowerCase();
    }

    public String toString() {
        return this.toKey();
    }

    static {
        ALIASES = new HashMap<String, CollectionType>();
        ALIASES.put("SEQ", SEQUENCE);
        ALIASES.put("ORD", ORDER);
    }
}

