/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class VersionInfo {
    @JsonProperty(value="release_version")
    private String releaseVersion;
    @JsonProperty(value="version")
    private String apiVersion;
    @JsonProperty(value="server_type")
    private String serverType;
    @JsonProperty(value="built")
    private String build;
    private String commit;
    private Map<String, String> displayFields;
    private static final String PGQL_VERSION = "2.0";

    private VersionInfo() {
    }

    public VersionInfo(String releaseVersion, String apiVersion, String built, String serverType, String commit) {
        this.releaseVersion = releaseVersion;
        this.apiVersion = apiVersion;
        this.serverType = serverType;
        this.commit = commit;
        this.build = built;
        this.displayFields = new HashMap<String, String>();
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    private void setReleaseVersion(String releaseVersion) {
        this.releaseVersion = releaseVersion;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    private void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getServerType() {
        return this.serverType;
    }

    private void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public String getBuild() {
        return this.build;
    }

    private void setBuild(String build) {
        this.build = build;
    }

    public String getCommit() {
        return this.commit;
    }

    private void setCommit(String commit) {
        this.commit = commit;
    }

    public String getPgqlVersion() {
        return PGQL_VERSION;
    }

    public Map<String, String> getDisplayFields() {
        return this.displayFields;
    }

    public String toString() {
        if (this.displayFields == null || this.displayFields.isEmpty()) {
            return this.getClass().getSimpleName() + "[releaseVersion=" + this.releaseVersion + ",apiVersion=" + this.apiVersion + ",pgqlVersion=" + PGQL_VERSION + ",serverType=" + this.serverType + ",build=" + this.build + ",commit=" + this.commit + "]";
        }
        return this.getClass().getSimpleName() + this.displayFields.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(",", "[", "]"));
    }

    public static VersionInfo getInstance(String serverFlavor) {
        return new VersionInfo("25.2.1", "3.27.0", "2025-04-16T02:06:16.559352-07:00", serverFlavor, "7bb18ad071094786510fde122ab35ad1f0a38141");
    }
}

