/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.pgx.common.MemoryUnit;

public class MemoryValue {
    private static final Pattern MEMORY_BYTES_REGEX = Pattern.compile("^([0-9]+)([kKmMgGtTpP]?)$");
    public static final long INVALID_MEMORY_BYTES = Long.MAX_VALUE;
    private static final String[] HUMAN_READABLE_SIZES = new String[]{"B", "KB", "MB", "GB", "TB", "PB"};
    private static final String[] HUMAN_READABLE_SIZES_BIT = new String[]{"bits", "kbits", "Mbits", "Gbits", "Tbits", "Pbits"};
    private static final int MEMORY_UNIT_INCREMENT = 1024;
    private static final int BASE_10_UNIT_INCREMENT = 1000;
    public static final MemoryValue INVALID_MEMORY_VALUE = new MemoryValue(Long.MAX_VALUE, MemoryUnit.INVALID_MEMORY_UNIT);
    final long size;
    final MemoryUnit unit;

    private MemoryValue(long size, MemoryUnit unit) {
        this.size = size;
        this.unit = unit;
    }

    private static MemoryUnit getMemoryUnitFromByteSuffix(String memoryUnit) {
        switch (memoryUnit) {
            case "": {
                return MemoryUnit.BYTE;
            }
            case "k": 
            case "K": {
                return MemoryUnit.KILOBYTE;
            }
            case "m": 
            case "M": {
                return MemoryUnit.MEGABYTE;
            }
            case "g": 
            case "G": {
                return MemoryUnit.GIGABYTE;
            }
            case "t": 
            case "T": {
                return MemoryUnit.TERABYTE;
            }
            case "p": 
            case "P": {
                return MemoryUnit.PETABYTE;
            }
        }
        return MemoryUnit.INVALID_MEMORY_UNIT;
    }

    public static MemoryValue fromString(String memoryBytes) {
        Matcher matcher;
        if (memoryBytes != null && (matcher = MEMORY_BYTES_REGEX.matcher(memoryBytes)).matches()) {
            try {
                MemoryValue result = new MemoryValue(Long.parseLong(matcher.group(1)), MemoryValue.getMemoryUnitFromByteSuffix(matcher.group(2)));
                if (result.unit != MemoryUnit.INVALID_MEMORY_UNIT) {
                    return result;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return INVALID_MEMORY_VALUE;
    }

    public static long byteCountFromString(String memoryBytes) {
        MemoryValue value = MemoryValue.fromString(memoryBytes);
        if (value != INVALID_MEMORY_VALUE) {
            return MemoryUnit.BYTE.convertFrom(value.size, value.unit);
        }
        return Long.MAX_VALUE;
    }

    public static String getHumanReadableSize(long bytes) {
        return MemoryValue.getHumanReadableSizeInternal(bytes, 1024, HUMAN_READABLE_SIZES);
    }

    public static String getHumanReadableSizeBits(long bits) {
        return MemoryValue.getHumanReadableSizeInternal(bits, 1000, HUMAN_READABLE_SIZES_BIT);
    }

    private static String getHumanReadableSizeInternal(long count, int memoryIncrement, String[] units) {
        int unitIdx;
        boolean negative = count < 0L;
        count = Math.abs(count);
        long remainder = 0L;
        for (unitIdx = 0; count >= 1000L && unitIdx < units.length - 1; count /= (long)memoryIncrement, ++unitIdx) {
            remainder = count % (long)memoryIncrement;
        }
        String res = "";
        if (negative) {
            res = res + "-";
        }
        res = res + count;
        if (remainder > 0L) {
            remainder = remainder * 1000L / (long)memoryIncrement;
            res = res + "." + String.format("%03d", remainder);
        }
        return res + " " + units[unitIdx];
    }
}

