/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.keys;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Objects;
import oracle.pgx.api.keys.KeyColumnDescriptor;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ErrorMessages;

@JsonSerialize(as=KeyColumnDescriptor.class)
class KeyColumnDescriptorImpl
implements KeyColumnDescriptor {
    private final String name;
    private final IdType type;

    @JsonCreator
    KeyColumnDescriptorImpl(@JsonProperty(value="name") String name, @JsonProperty(value="type") IdType type) {
        ErrorMessages.requireNonNull(name, "name");
        ErrorMessages.requireNonNull(type, "type");
        this.name = name;
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IdType getType() {
        return this.type;
    }

    @Override
    public KeyColumnDescriptor asKeyColumnDescriptor() {
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KeyColumnDescriptor)) {
            return false;
        }
        KeyColumnDescriptor other = (KeyColumnDescriptor)obj;
        return this.name.equals(other.getName()) && this.type == other.getType();
    }

    public String toString() {
        return "KeyColumnDescriptor{name='" + this.name + "', type=" + this.type + '}';
    }
}

