/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import java.net.URI;
import oracle.pgx.api.ClientContext;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.internal.PropertyProxy;
import oracle.pgx.client.RemotePropertyProxy;
import oracle.pgx.client.RemoteUtils;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.RemotePropertyProxyFactory;
import oracle.pgx.config.LinkTemplate;
import org.apache.hc.client5.http.fluent.Executor;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;

public class RemotePropertyProxyFactoryImpl
implements RemotePropertyProxyFactory {
    private final ClientContext context;
    private final URI baseUri;

    public RemotePropertyProxyFactoryImpl(ClientContext context, URI baseUri) {
        this.context = context;
        this.baseUri = baseUri;
    }

    public <T> PropertyProxy<T> createRemotePropertyProxy(SessionContext sessionContext, String propertyProxyUUID, long size, PropertyType keyType, IdType keyNodeEdgeValueType, PropertyType valueType, IdType nodeEdgeValueType, int dimension) {
        String url = LinkTemplate.PROPERTY_PROXY_SELF.generateUrl(this.baseUri, new Object[0]);
        CloseableHttpClient httpClient = this.context.getHttpClient();
        Executor executor = RemoteUtils.newHttpExecutor(httpClient, url, sessionContext, this.context.getCsrfToken(), this.context.getClientStickyCookie());
        return new RemotePropertyProxy(executor, this.baseUri, propertyProxyUUID, url, size, this.context.getConfig().getPrefetchSize(), keyType, keyNodeEdgeValueType, valueType, nodeEdgeValueType, dimension);
    }
}

