/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.io;

import java.util.ArrayList;
import java.util.List;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.AbstractTermFactory;
import org.spoofax.terms.io.TermVisitor;

public abstract class TermFactoryVisitor
implements TermVisitor {
    private final ITermFactory factory;
    private Integer i;
    private Double d;
    private String s;
    private String c;
    List<IStrategoTerm> subTerms = new ArrayList<IStrategoTerm>();
    List<IStrategoTerm> annos = new ArrayList<IStrategoTerm>();

    public TermFactoryVisitor(ITermFactory factory) {
        this.factory = factory;
    }

    public abstract void setTerm(IStrategoTerm var1);

    @Override
    public void visitInt(int value) {
        this.visit();
        this.i = value;
    }

    @Override
    public void endInt() {
        this.setTerm(this.withAnnos(this.factory.makeInt(this.i)));
    }

    @Override
    public void visitReal(double value) {
        this.visit();
        this.d = value;
    }

    @Override
    public void endReal() {
        this.setTerm(this.withAnnos(this.factory.makeReal(this.d)));
    }

    @Override
    public void visitString(String value) {
        this.visit();
        this.s = value;
    }

    @Override
    public void endString() {
        this.setTerm(this.withAnnos(this.factory.makeString(this.s)));
    }

    @Override
    public void visitAppl(String name) {
        this.visit();
        this.c = name;
    }

    @Override
    public void endAppl() {
        IStrategoConstructor c = this.factory.makeConstructor(this.c, this.subTerms.size());
        this.setTerm(this.withAnnos(this.factory.makeAppl(c, this.subTerms.toArray(AbstractTermFactory.EMPTY_TERM_ARRAY))));
    }

    @Override
    public void visitTuple() {
        this.visit();
    }

    @Override
    public void endTuple() {
        this.setTerm(this.withAnnos(this.factory.makeTuple(this.subTerms.toArray(AbstractTermFactory.EMPTY_TERM_ARRAY))));
    }

    @Override
    public void visitList() {
        this.visit();
    }

    @Override
    public void endList() {
        this.setTerm(this.withAnnos(this.factory.makeList(this.subTerms.toArray(AbstractTermFactory.EMPTY_TERM_ARRAY))));
    }

    @Override
    public TermVisitor visitPlaceholder() {
        this.visit();
        final TermFactoryVisitor outer = this;
        return new TermFactoryVisitor(this.factory){

            @Override
            public void setTerm(IStrategoTerm term) {
                outer.setTerm(TermFactoryVisitor.this.factory.makePlaceholder(term));
            }
        };
    }

    @Override
    public TermVisitor visitSubTerm() {
        final TermFactoryVisitor outer = this;
        return new TermFactoryVisitor(this.factory){

            @Override
            public void setTerm(IStrategoTerm subTerm) {
                outer.subTerms.add(subTerm);
            }
        };
    }

    @Override
    public TermVisitor visitAnnotation() {
        final TermFactoryVisitor outer = this;
        return new TermFactoryVisitor(this.factory){

            @Override
            public void setTerm(IStrategoTerm anno) {
                outer.annos.add(anno);
            }
        };
    }

    private IStrategoTerm withAnnos(IStrategoTerm term) {
        if (this.annos.isEmpty()) {
            return term;
        }
        return this.factory.annotateTerm(term, this.factory.makeList(this.annos));
    }

    private void visit() {
        this.i = null;
        this.d = null;
        this.s = null;
        this.c = null;
        this.subTerms.clear();
        this.annos.clear();
    }
}

