/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.recovery;

import java.util.HashMap;
import java.util.Map;

public class RecoveryJob<StackNode> {
    public int offset;
    public int iteration;
    final int iterationsQuota;
    final long timeoutAt;
    public Map<StackNode, Integer> quota;
    public Map<StackNode, Integer> lastRecoveredOffset;

    public RecoveryJob(int offset, int iterationsQuota, int timeout) {
        this.offset = offset;
        this.iteration = -1;
        this.iterationsQuota = iterationsQuota;
        this.timeoutAt = System.currentTimeMillis() + (long)timeout;
        this.quota = new HashMap<StackNode, Integer>();
        this.lastRecoveredOffset = new HashMap<StackNode, Integer>();
    }

    boolean hasNextIteration() {
        return this.iteration + 1 < this.iterationsQuota;
    }

    int nextIteration() {
        return ++this.iteration;
    }

    void initQuota(Iterable<StackNode> activeStacks) {
        int quotaPerStack = this.iteration + 1;
        this.quota.clear();
        activeStacks.forEach(stack -> {
            Integer n2 = this.quota.put(stack, quotaPerStack);
        });
    }

    int getQuota(StackNode stack) {
        return this.quota.getOrDefault(stack, 0);
    }

    int lastRecoveredOffset(StackNode stack) {
        return this.lastRecoveredOffset.getOrDefault(stack, -1);
    }

    void updateQuota(StackNode stack, int newQuota) {
        this.quota.merge(stack, newQuota, Math::max);
    }

    void updateLastRecoveredOffset(StackNode stack, int offset) {
        if (offset != -1) {
            this.lastRecoveredOffset.merge(stack, offset, Math::max);
        }
    }

    boolean timeout() {
        return System.currentTimeMillis() >= this.timeoutAt;
    }
}

