/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.util.ArrayList;
import org.spoofax.jsglr.client.IndentInfo;
import org.spoofax.jsglr.client.IndentationHandler;
import org.spoofax.jsglr.client.NewStructureSkipper;
import org.spoofax.jsglr.client.ParserHistory;
import org.spoofax.jsglr.client.SGLR;
import org.spoofax.jsglr.client.StructureSkipSuggestion;
import org.spoofax.jsglr.client.TokenOffset;

public class RegionRecovery {
    private SGLR myParser;
    private StructureSkipSuggestion erroneousRegion;
    private int errorDetectionLocation;
    public static int NR_OF_LINES_TILL_SUCCESS = 6;
    private int acceptPosition;

    public int getAcceptPosition() {
        return this.acceptPosition;
    }

    public RegionRecovery(SGLR sglr) {
        this.myParser = sglr;
    }

    private ParserHistory getHistory() {
        return this.myParser.getHistory();
    }

    public IndentInfo getStartLineErrorFragment() {
        return this.erroneousRegion.getStartSkip();
    }

    public int getEndPositionErrorFragment() {
        return this.erroneousRegion.getEndSkip().getTokensSeen();
    }

    public int getStartPositionErrorFragment() {
        return this.erroneousRegion.getStartSkip().getTokensSeen();
    }

    public String getErrorFragmentWithLeftMargin() {
        int tokIndexLine = this.getHistory().getTokensSeenStartLine(this.getStartLineErrorFragment().getTokensSeen(), this.myParser.currentInputStream);
        return this.getHistory().getFragment(tokIndexLine, this.getEndPositionErrorFragment() - 1, this.myParser.currentInputStream);
    }

    public String getErrorFragment() {
        int tokIndexLine = this.getStartPositionErrorFragment();
        return this.getHistory().getFragment(tokIndexLine, this.getEndPositionErrorFragment() - 1, this.myParser.currentInputStream);
    }

    public int getStartPositionErrorFragment_InclLeftMargin() {
        int tokIndexLine = this.getHistory().getTokensSeenStartLine(this.getStartLineErrorFragment().getTokensSeen(), this.myParser.currentInputStream);
        return tokIndexLine;
    }

    public ArrayList<IndentInfo> getSkippedLines() {
        return this.getHistory().getLinesFromTo(this.erroneousRegion.getIndexHistoryStart(), this.getEndPositionErrorFragment());
    }

    public boolean selectErroneousFragment(int failureOffset, int failureLineIndex) throws InterruptedException {
        return this.selectErroneousFragment(failureOffset, failureLineIndex, -1);
    }

    public boolean selectErroneousFragment(int failureOffset, int failureLineIndex, int cursorLineIndex) throws InterruptedException {
        ArrayList<StructureSkipSuggestion> priorRegions;
        boolean eofReached = this.myParser.getCurrentToken().getToken() == -1;
        this.acceptPosition = -1;
        NewStructureSkipper newRegionSelector = new NewStructureSkipper(this.myParser);
        this.errorDetectionLocation = failureOffset - 1;
        assert (failureLineIndex >= 0);
        ArrayList<StructureSkipSuggestion> prevRegions = newRegionSelector.getPreviousSkipSuggestions(failureLineIndex);
        if (this.trySetErroneousRegion(prevRegions)) {
            ArrayList<StructureSkipSuggestion> decomposedRegions = newRegionSelector.getZoomOnPreviousSuggestions(this.erroneousRegion);
            this.trySetErroneousRegion(decomposedRegions);
            return true;
        }
        ArrayList<StructureSkipSuggestion> currentRegions = newRegionSelector.getCurrentSkipSuggestions(failureLineIndex);
        if (this.trySetErroneousRegion(currentRegions)) {
            return true;
        }
        if (cursorLineIndex >= 0 && cursorLineIndex < failureLineIndex) {
            ArrayList<StructureSkipSuggestion> cursorRegions = newRegionSelector.getCurrentSkipSuggestions(cursorLineIndex);
            if (this.trySetErroneousRegion(cursorRegions)) {
                return true;
            }
            ArrayList<StructureSkipSuggestion> cursorParentRegion = newRegionSelector.getParentSkipSuggestions(cursorLineIndex);
            if (this.trySetErroneousRegion(cursorParentRegion)) {
                return true;
            }
        }
        if (this.trySetErroneousRegion(priorRegions = newRegionSelector.getPriorSkipSuggestions(failureLineIndex))) {
            ArrayList<StructureSkipSuggestion> decomposedRegions = newRegionSelector.getZoomOnPreviousSuggestions(this.erroneousRegion);
            this.trySetErroneousRegion(decomposedRegions);
            return true;
        }
        ArrayList<StructureSkipSuggestion> siblingForWardRegions = newRegionSelector.getSibblingForwardSuggestions(failureLineIndex);
        if (this.trySetErroneousRegion(siblingForWardRegions)) {
            return true;
        }
        ArrayList<StructureSkipSuggestion> siblingBackWardRegions = newRegionSelector.getSibblingBackwardSuggestions(failureLineIndex);
        if (this.trySetErroneousRegion(siblingBackWardRegions)) {
            return true;
        }
        ArrayList<StructureSkipSuggestion> siblingSurroundingRegions = newRegionSelector.getSibblingSurroundingSuggestions(failureLineIndex);
        if (this.trySetErroneousRegion(siblingSurroundingRegions)) {
            return true;
        }
        ArrayList<StructureSkipSuggestion> parentRegion = newRegionSelector.getParentSkipSuggestions(failureLineIndex);
        if (this.trySetErroneousRegion(parentRegion)) {
            return true;
        }
        this.erroneousRegion = newRegionSelector.getErroneousPrefix(failureLineIndex);
        ArrayList<StructureSkipSuggestion> decomposedRegions = newRegionSelector.getZoomOnPreviousSuggestions(this.erroneousRegion);
        boolean findSmallerPart = this.trySetErroneousRegion(decomposedRegions);
        if (!findSmallerPart) {
            if (eofReached) {
                int structStart = this.getHistory().getLastLine().structureStartPosition();
                int structStartIndex = this.getHistory().getLineOfTokenPosition(structStart);
                ArrayList<StructureSkipSuggestion> structRegions = newRegionSelector.getBlockSuggestions(structStartIndex);
                if (this.trySetErroneousRegion(structRegions)) {
                    return true;
                }
            }
            int indexAccept = this.getHistory().getIndexLastLine() >= failureLineIndex + NR_OF_LINES_TILL_SUCCESS ? failureLineIndex + NR_OF_LINES_TILL_SUCCESS : this.getHistory().getIndexLastLine();
            this.acceptPosition = this.getHistory().getLine(indexAccept).getTokensSeen();
            IndentInfo openEnd = new IndentInfo();
            openEnd.setTokensSeen(Integer.MAX_VALUE);
            this.erroneousRegion.setEndSkip(openEnd, Integer.MAX_VALUE);
            return false;
        }
        return true;
    }

    private boolean trySetErroneousRegion(ArrayList<StructureSkipSuggestion> regions) throws InterruptedException {
        StructureSkipSuggestion aSkip = new StructureSkipSuggestion();
        int indexSkips = 0;
        this.myParser.acceptingStack = null;
        this.myParser.activeStacks.clear();
        boolean hasFoundErroneousRegion = false;
        while (indexSkips < regions.size() && !hasFoundErroneousRegion) {
            aSkip = regions.get(indexSkips);
            hasFoundErroneousRegion = this.testRegion(aSkip);
            ++indexSkips;
        }
        if (hasFoundErroneousRegion) {
            this.erroneousRegion = aSkip;
        }
        return hasFoundErroneousRegion;
    }

    private boolean testRegion(StructureSkipSuggestion aSkip) throws InterruptedException {
        IndentInfo endPos = aSkip.getEndSkip();
        this.getHistory().setTokenIndex(endPos.getTokensSeen());
        this.myParser.activeStacks.clear();
        this.myParser.acceptingStack = null;
        this.myParser.activeStacks.addAll(endPos.getStackNodes());
        this.parseAdditionalTokens(aSkip);
        int nrOfParsedLines = 0;
        IndentationHandler indentHandler = new IndentationHandler();
        indentHandler.setInLeftMargin(false);
        while (this.myParser.activeStacks.size() > 0 && nrOfParsedLines < NR_OF_LINES_TILL_SUCCESS) {
            this.getHistory().readRecoverToken(this.myParser, false);
            indentHandler.updateIndentation(this.myParser.getCurrentToken().getToken());
            this.myParser.doParseStep();
            if (this.getHistory().getTokenIndex() <= this.errorDetectionLocation || !indentHandler.lineMarginEnded()) continue;
            ++nrOfParsedLines;
        }
        if (this.successCriterion()) {
            this.acceptPosition = this.getHistory().getTokenIndex();
            return true;
        }
        return false;
    }

    private void parseAdditionalTokens(StructureSkipSuggestion aSkip) throws InterruptedException {
        int i = 0;
        char[] cArray = aSkip.getAdditionalTokens();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char aChar = cArray[n2];
            this.myParser.setCurrentToken(new TokenOffset(aChar, this.myParser.getCurrentToken().getOffset() + i));
            ++i;
            this.myParser.doParseStep();
            ++n2;
        }
        if (aSkip.getAdditionalTokens().length > 0) {
            aSkip.getStartSkip().fillStackNodes(this.myParser.activeStacks);
            aSkip.getEndSkip().fillStackNodes(this.myParser.activeStacks);
            aSkip.getStartSkip().setTokensSeen(aSkip.getStartSkip().getTokensSeen() + aSkip.getAdditionalTokens().length);
            aSkip.setAdditionalTokens(new char[0]);
        }
    }

    private boolean successCriterion() {
        return this.myParser.activeStacks.size() > 0 || this.myParser.acceptingStack != null;
    }

    public int getStartIndexErrorFragment() {
        return this.erroneousRegion.getIndexHistoryStart();
    }

    public StructureSkipSuggestion getErroneousRegion() {
        return this.erroneousRegion;
    }
}

