/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr.treediff;

import java.util.ArrayList;
import org.spoofax.interpreter.library.jsglr.treediff.AbstractTreeMatcher;
import org.spoofax.interpreter.library.jsglr.treediff.HeuristicTreeMatcher;
import org.spoofax.interpreter.library.jsglr.treediff.LCSEqualTermsCommand;
import org.spoofax.interpreter.library.jsglr.treediff.OriginTreeMatcher;
import org.spoofax.interpreter.terms.IStrategoTerm;

public class OriginHeuristicTreeMatcher
extends AbstractTreeMatcher {
    private OriginTreeMatcher originTreeMatcher;
    private HeuristicTreeMatcher heuristicMatcher;

    public OriginHeuristicTreeMatcher(boolean useDesugaredOrigins, boolean requireSameSignature, boolean requireSameValue) {
        super(new LCSEqualTermsCommand(), true);
        this.originTreeMatcher = new OriginTreeMatcher(useDesugaredOrigins, requireSameSignature, requireSameValue);
        this.heuristicMatcher = new HeuristicTreeMatcher(requireSameSignature, requireSameValue, false);
    }

    @Override
    ArrayList<IStrategoTerm> getCandidateMatchTerms(IStrategoTerm root1, IStrategoTerm t2) {
        ArrayList<IStrategoTerm> originCandidates = this.originTreeMatcher.getCandidateMatchTerms(root1, t2);
        if (originCandidates.size() > 0) {
            return originCandidates;
        }
        return this.heuristicMatcher.getCandidateMatchTerms(root1, t2);
    }

    @Override
    double matchingScore(IStrategoTerm t1, IStrategoTerm t2) {
        return (3.0 * this.originTreeMatcher.matchingScore(t1, t2) + this.heuristicMatcher.matchingScore(t1, t2)) / 4.0;
    }
}

